go.modules.business.onlyoffice.SaveAsDialog = Ext.extend(go.Window, {

    initComponent: function () {

        Ext.apply(this, {
            layout: 'border',
            title: t("Save file", "files"),
            height: dp(700),
            width: dp(900),
            border: false,
            collapsible: true,
            maximizable: true,
            closeAction: 'close',
            buttons: [
                {
                    text: t("Ok"),
                    handler: function () {

                        if(this.nameField.isValid()){
                            var files = this.fb.gridStore.getRange();

                            for(var i=0;i<files.length;i++)
                            {
                                if(files[i].data.extension!='folder' && files[i].data.name==this.nameField.getValue())
                                {
                                    var tpl = new Ext.Template(t("{filename} already exists, do you want to overwrite the file?", "files"));

                                    if(!confirm(tpl.apply({filename: files[i].data.name})))
                                    {
                                        return false;
                                    }
                                    break;
                                }
                            }

                            this.handler.call(this.scope || this, this, this.fb.folder_id, this.nameField.getValue());
                        }else
                        {
                            this.nameField.focus();
                        }
                    },
                    scope: this
                },
                {
                    text: t("Close"),
                    handler: function () {
                        this.hide();
                    },
                    scope: this
                }
            ],
        });


        this.fb = new go.modules.business.onlyoffice.FileBrowser({
            region: 'center',
            border: false,
            loadDelayed: true,
            hideActionButtons: true,
            treeCollapsed: false,
            filePanelCollapsed: true,
            fileClickHandler: function (r) {
            },
            scope: this
        });

        this.nameField = new Ext.form.TextField({
            fieldLabel: t("Name"),
            name: 'filename',
            anchor: '100%',
            validator: function (v) {
                return !v.match(/[&\/:\*\?"<>|\\]/);
            }
        });

        var focusField = function(){
            this.nameField.focus(true);
        };

        this.focus= Ext.emptyFn;

        this.formPanel = new Ext.form.FormPanel({
            region: 'north',
            cls: 'go-form-panel',
            autoHeight: true,
            items: this.nameField
        });

        this.items = [this.fb, this.formPanel];

        go.modules.business.onlyoffice.SaveAsDialog.superclass.initComponent.call(this);
    },

    show: function (config) {

        //name, url
        var fileInfo = config.fileInfo,
            extension;

        this.nameField.setValue(fileInfo.name.replace(/[&\/:\*\?"<>|\\]/g, ""));
        extension = this.getFileExtension(fileInfo.name);

        this.fb.setRootID(0, 0);
        this.fb.setFilesFilter(extension);

        this.fileUrl = fileInfo.url;

        go.modules.business.onlyoffice.SaveAsDialog.superclass.show.call(this);
    },

    getFileExtension: function (filename) {
        var lastIndex = filename.lastIndexOf('.'),
            extension = '';

        if (lastIndex) {
            extension = filename.substr(lastIndex + 1);
        }
        return extension.toLowerCase();
    },

    handler: function (dialog, folder_id, filename) {

        this.getEl().mask(t("Sending..."));
        var me = this;

        go.Jmap.request({
            method: 'business/onlyoffice/CallbackController/saveFileAs',
            params: {
                folder_id: folder_id,
                filename: filename,
                url: me.fileUrl,
            }
        }).then(function () {

            Ext.MessageBox.alert(
                t("Success"),
                t("File sucessfully saved")
            );

            me.close();
        }).catch(function (result) {
            GO.errorDialog.show(result.message);
        }).finally(function () {
            me.getEl().unmask();
        })
    },
});
