go.modules.business.contracts.ContractGrid = Ext.extend(go.grid.GridPanel, {
	initComponent: function () {
		this.frontendConfig = go.modules.business.contracts.ModuleConfig.frontendOptions;

		this.store = new go.data.Store({
			fields: [
				'id',
				{name: 'createdAt', type: 'date'},
				{name: 'modifiedAt', type: 'date'},
				{name: 'creator', type: "relation"},
				{name: 'modifier', type: "relation"},
				'permissionLevel',

				{name: 'startsAt', type: 'date'},
				{name: 'endsAt', type: 'date'},
				{name: 'nextAt', type: 'date'},

				'number',
				'description',
				'reference',
				{name: 'customer', type: "string"},

				{name: 'intervalMonths', type: "int"},
				{name: 'annualValue', type: "float"},

			],
			entityStore: "Contract",
			sortInfo: {
				field: "nextAt",
				direction: "DESC"
			}

		});

		Ext.apply(this, {
			columns: [{
				header: t("Number"),
				width: dp(160),
				sortable: true,
				dataIndex: 'number'
			},

				{
					header: t("Customer"),
					width: dp(160),
					sortable: false,
					dataIndex: 'customer'
				},

				{
					header: t("Description"),
					width: dp(160),
					sortable: true,
					dataIndex: 'description'
				},

				{
					header: t("Reference"),
					width: dp(160),
					sortable: true,
					dataIndex: 'reference',
					hidden: true
				},

				{
					xtype: "valutacolumn",
					align: "right",
					header: t("Annual value"),
					width: dp(160),
					sortable: true,
					dataIndex: 'annualValue'
				},

				{
					xtype:"datecolumn",
					header: t('Starts at'),
					sortable: true,
					dataIndex: 'startsAt',
					hidden: true
				},

				{
					xtype:"datecolumn",
					header: t('Ends at'),
					sortable: true,
					dataIndex: 'endsAt',
					hidden: true
				},

				{
					xtype:"datecolumn",
					header: t('Next invoice at'),
					sortable: true,
					dataIndex: 'nextAt'
				},

				{
					header: t('Interval (months)'),
					sortable: true,
					dataIndex: 'intervalMonths',
					hidden: true
				},

				{
				hidden: !this.frontendConfig.showCreator,
				id: 'showCreator',
				header: t('Created by'),
				width: dp(160),
				sortable: true,
				dataIndex: 'creator',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				id: 'showCreationDate',
				header: t('Created at'),
				sortable: true,
				dataIndex: 'createdAt',
				hidden: !this.frontendConfig.showCreationDate
			},{
				hidden: !this.frontendConfig.showModifier,
				header: t('Modified by'),
				sortable: true,
				id: 'showModifier',
				dataIndex: 'modifier',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				hidden: !this.frontendConfig.showModificationDate,
				id: 'showModificationDate',
				header: t('Modified at'),
				width: dp(160),
				sortable: true,
				dataIndex: 'modifiedAt'
			}],
			viewConfig: {
				totalDisplay: this.frontendConfig.showTotals,
				emptyText: 	'<i>description</i><p>' +t("No items to display") + '</p>'
			},
			stateful: true,
			stateId: 'Contract-grid'
		});

		go.modules.business.contracts.ContractGrid.superclass.initComponent.call(this);
	}
});

