/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Menu } from "./Menu.js";
import { Config, Listener, ObservableListenerOpts } from "../Observable.js";
import { Component, ComponentEventMap } from "../Component.js";
/**
 * @inheritDoc
 */
export interface ColorMenuEventMap<Type> extends ComponentEventMap<Type> {
    /**
     * Fires when color is selected
     *
     * @param menu
     * @param color Hexadecimal color. eg. "000000"
     */
    select: (menu: Type, color: string) => void;
}
export interface ColorMenu {
    on<K extends keyof ColorMenuEventMap<ColorMenu>, L extends Listener>(eventName: K, listener: Partial<ColorMenuEventMap<ColorMenu>>[K], options?: ObservableListenerOpts): L;
    fire<K extends keyof ColorMenuEventMap<ColorMenu>>(eventName: K, ...args: Parameters<ColorMenuEventMap<Component>[K]>): boolean;
}
/**
 * Color menu component
 *
 * @example
 * ```
 * Button.create({
 * 	text: "Color",
 * 	menu: ColorMenu.create()
 * });
 * ```
 */
export declare class ColorMenu extends Menu {
    private _value;
    /**
     * Set color value as button text color if this menu belongs to a button
     */
    updateButton: boolean;
    protected baseCls: string;
    protected colors: string[];
    constructor();
    private static rgb2hex;
    /**
     * Color hex value eg. #000000
     */
    set value(color: string);
    get value(): string;
}
/**
 * Shorthand function to create {@see ColorMenu}
 *
 * @param config
 */
export declare const colormenu: (config?: Config<ColorMenu, ColorMenuEventMap<ColorMenu>>) => ColorMenu;
//# sourceMappingURL=ColorMenu.d.ts.map