<?php

namespace GO\Tickets;


use Faker\Generator;
use go\core\http\Exception;
use go\core\model\User;
use go\modules\community\addressbook\Module;

class TicketsModule extends \GO\Professional\Module{
	
	public function appCenter(){
		return true;
	}

	public function getStatus(): string
	{
		return \go\core\Module::STATUS_DEPRECATED;
	}

	public function install() {
		parent::install();
		$template = new Model\Template();
		$template->name = \GO::t("Default response", "tickets");
		$template->content = \GO::t("Dear sir/madam
Thank you for your response,
{MESSAGE}
Please do not reply to this email. You must go to the following page to reply:
{LINK}
Best regards,
{NAME}.", "tickets");
		$template->autoreply=0;
		$template->default_template=1;
		$template->ticket_created_for_client=0;
		$template->save();
		
		$template = new Model\Template();
		$template->name = \GO::t("Default ticket created by client", "tickets");
		$template->content = \GO::t("Dear sir/madam
We have received your question and a ticket has been created.
We will respond as soon as possible.
The message you sent to us was:
---------------------------------------------------------------------------
{MESSAGE}
---------------------------------------------------------------------------
Please do not reply to this email. You must go to the following page to reply:
{LINK}
Best regards,
{NAME}.", "tickets");
		$template->autoreply=1;
		$template->default_template=0;
		$template->ticket_created_for_client=0;
		$template->save();
		
		$template = new Model\Template();
		$template->name = \GO::t("Default ticket created for client", "tickets");
		$template->content = \GO::t("Dear sir/madam
We have created a ticket for you.
We will respond as soon as possible.
The ticket is about:
---------------------------------------------------------------------------
{MESSAGE}
---------------------------------------------------------------------------
Please do not reply to this email. You must go to the following page to reply:
{LINK}
Best regards,
{NAME}.", "tickets");
		$template->autoreply=0;
		$template->default_template=0;
		$template->ticket_created_for_client=1;
		$template->save();
		
		
		$type = new Model\Type();
		$type->publish_on_site=true;
		$type->name=\GO::t("IT", "tickets");
		$type->save();
		
		$type->acl->addGroup(\GO::config()->group_everyone, \GO\Base\Model\Acl::WRITE_PERMISSION);
		
		$type = new Model\Type();
		$type->name=\GO::t("Sales", "tickets");
		$type->save();
		
		$type->acl->addGroup(\GO::config()->group_everyone, \GO\Base\Model\Acl::WRITE_PERMISSION);
		
		$status = new Model\Status();
		$status->name = \GO::t("In progress", "tickets");
		$status->save();
		
		$status = new Model\Status();
		$status->name = \GO::t("Not resolved", "tickets");
		$status->save();
		
		$settings = new Model\Settings();
		$settings->id=1;
		$settings->save();
		
		
		$cron = new \GO\Base\Cron\CronJob();
		
		$cron->name = 'Close inactive tickets';
		$cron->active = true;
		$cron->runonce = false;
		$cron->minutes = '0';
		$cron->hours = '2';
		$cron->monthdays = '*';
		$cron->months = '*';
		$cron->weekdays = '*';
		$cron->job = 'GO\Tickets\Cron\CloseInactive';

		$cron->save();
		
		
		$cron = new \GO\Base\Cron\CronJob();
		
		$cron->name = 'Ticket reminders';
		$cron->active = true;
		$cron->runonce = false;
		$cron->minutes = '*/5';
		$cron->hours = '*';
		$cron->monthdays = '*';
		$cron->months = '*';
		$cron->weekdays = '*';
		$cron->job = 'GO\Tickets\Cron\Reminder';

		$cron->save();
		
		$cron = new \GO\Base\Cron\CronJob();
		
		$cron->name = 'Import tickets from IMAP';
		$cron->active = true;
		$cron->runonce = false;
		$cron->minutes = '0,5,10,15,20,25,30,35,40,45,50,55';
		$cron->hours = '*';
		$cron->monthdays = '*';
		$cron->months = '*';
		$cron->weekdays = '*';
		$cron->job = 'GO\Tickets\Cron\ImportImap';

		$cron->save();
		
		$cron = new \GO\Base\Cron\CronJob();
		
		$cron->name = 'Sent tickets due reminder';
		$cron->active = true;
		$cron->runonce = false;
		$cron->minutes = '0';
		$cron->hours = '1';
		$cron->monthdays = '*';
		$cron->months = '*';
		$cron->weekdays = '*';
		$cron->job = 'GO\Tickets\Cron\DueMailer';

		$cron->save();
	}
	
	public function autoInstall() {
		return false;
	}


	public function demo(Generator $faker)
	{

		$demo = User::find()->where('username', '=', 'demo')->single();

		$titles = [
			"Problem with Group-Office",
			"No sound",
			"Does it have super cow powers?",
			"How can I make quotes?",
			"How do I setup my iPhone?",

			"Problem with mail server",
			"I don't know how to send newsletters",
			"Start page open URL if scrollbar active",
			"Feature: Email counter",
			"Holiday Year Summary broken",

			"How do I setup my Android phone?",
			"Can I make invoices?",
			"How to stop the Spam!",
			"Group-Office Assistant",

		];

		$titleCount = count($titles);

		$users = User::find(['id', 'displayName', 'email'])->limit(10)->all();
		$userCount = count($users) - 1;



		for($i=0;$i<$titleCount;$i++) {

			$agentId = $users[$faker->numberBetween(0, $userCount)]->id;

			try {
				$ticket = new \GO\Tickets\Model\Ticket();
				$ticket->subject = $titles[$i];
				$ticket->ctime = $faker->dateTimeBetween("-1 years", "now")->format("U");
				$ticket->setFromContact(Module::get()->demoContact($faker));
				if (!$ticket->save()) {
					var_dump($ticket->getValidationErrors());
					continue;
				}

				$message = new \GO\Tickets\Model\Message();
				$message->sendEmail = false;
				$message->content = $faker->text(100);
				$message->is_note = false;
				$message->user_id = 0;
				$message->ctime = $faker->dateTimeBetween("@" . $ticket->ctime, "now")->format("U");
				$ticket->addMessage($message);

				//elmer picks up the ticket
				$ticket->sendEmail = false;
				$ticket->agent_id = $agentId;
				$ticket->type->acl->addGroup(\go\core\model\Group::find()->where(['isUserGroupFor' => $agentId])->single()->id, \GO\Base\Model\Acl::MANAGE_PERMISSION);

				if (!$ticket->save()) {
					var_dump($ticket->getValidationErrors());
					continue;
				}

				for ($n = 0; $n < $faker->numberBetween(0, 4); $n++) {
					$message = new \GO\Tickets\Model\Message();
					$message->sendEmail = false;
					$message->content = $faker->text(100);
					$message->is_note = false;
					$message->user_id = $n % 2 ? $agentId : 0;
					$message->ctime = $faker->dateTimeBetween("@" . $ticket->ctime, "now")->format("U");
					$ticket->addMessage($message);
				}
			}
			catch(Exception $e) {

			}


			echo ".";
		}



	}
}
