go.modules.business.finance.StatusGrid = Ext.extend(go.grid.GridPanel, {
	viewConfig: {
		scrollOffset: 0,
		forceFit: true,
		autoFill: true,
		totalDisplay: false
	},
	hideHeaders: true,
	title: t("Status"),
	entityStore: "FinanceDocument",
	multiSelectToolbarEnabled : false,
	hidden: true,
	setBook: function(book) {
		this.book = book;
		this.store.loadStatuses(book);
		this.show();
	},

	createStyle : function() {
		if(!this.style) {
			this.style = document.createElement('style');
			this.style.type = 'text/css';
			//this.style.innerHTML = '.cssClass { color: #f00; }';
			document.getElementsByTagName('head')[0].appendChild(this.style);
		}

		let style = "";
		this.book.statuses.forEach((s) => {
			style += `.business-finance-document-status-${s.id}  {
					background-color: #${s.color};
					fill: #${s.color};
			}`;
		});

		this.style.innerHTML = style;

		return this.style;

	},

	// updateTotals: function(params) {
	// 	var me = this;
	//
	// 	go.Jmap.request({
	// 		method: "FinanceDocument/totals",
	// 		params: params
	// 	}).then(function(totals) {
	//
	// 		// me.createStyle();
	//
	// 		me.totals = totals;
	//
	// 		// var data = {
	// 		// 	series: [],
	// 		// 	labels: []
	// 		// };
	// 		//
	// 		// if(!go.util.empty(totals)) {
	// 		// 	var sum = Object.values(totals).reduce(function (accumulator, currentValue) {
	// 		// 		return currentValue.subtotal + accumulator;
	// 		// 	}, 0);
	// 		// 	for (var status in totals) {
	// 		// 		var perc = parseInt((totals[status].subtotal / sum) * 100);
	// 		// 		var needle = status ? status : null;
	// 		//
	// 		// 		data.labels.push(perc);
	// 		// 		data.series.push(
	// 		// 			{
	// 		// 				value: totals[status].subtotal,
	// 		// 				meta: go.modules.business.finance.util.humanStatus(status, me.book) + " " + perc + "%",
	// 		// 				className: 'ct-series business-finance-document-status-' + (status || null)
	// 		// 			});
	// 		// 	}
	// 		//
	// 		// 	me.pieChart.update(data.series, data.labels);
	// 		// } else
	// 		// {
	// 		// 	me.pieChart.update({});
	// 		// }
	// 		me.getView().refresh();
	// 	});
	// },
	//
	// onChanges: function(s, a, c, d) {
	// 	this.updateTotals();
	// },

	initComponent: function () {
		var selModel = new Ext.grid.CheckboxSelectionModel();

		var me = this;

		go.Db.store("FinanceBook").on("changes", async (store, added, changed, destroyed) => {
			if(this.book && changed.indexOf(this.book.id) > -1) {
				const book = await go.Db.store("FinanceBook").single(this.book.id);
				this.setBook(book);
			}
		})

		Ext.apply(this, {
			store: go.modules.business.finance.stores.status,
			selModel: selModel,
			columns: [
				selModel,
				{
					id: 'id',
					sortable: false,
					dataIndex: 'id',
					hideable: false,
					draggable: false,
					menuDisabled: true,
					renderer: function(id, meta, r) {

						if(!me.book) {
							return "";
						}

						const status = me.book.statuses.find((s) => {
							return s.id == id;
						});

						let str;

						if(status) {
							str = '<div class="status" style="background-color: #'+status.color+'">' + status.name + '</div>';
						} else {
							str = '<div class="status business-finance-document-status-' + id + '">' + go.modules.business.finance.util.humanStatus(id, me.book) + '</div>';
						}

						if(!id) {
							id = "";
						}

						if(!me.totals || !me.totals[id] || !me.totals[id].subtotal) {
							return str;
						}

						str += '<div class="badge right">' + me.book.currency + ' ' + go.util.Format.number(me.totals[id].subtotal, 0) + '</div>';
						return str;
					}
				}
			],
			stateful: true
		});

		go.modules.business.finance.StatusGrid.superclass.initComponent.call(this);
	}
});
