/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Component, ComponentEventMap } from "../Component.js";
import { Toolbar } from "../Toolbar.js";
import { Table } from "./Table.js";
import { Config } from "../Observable";
export declare class MultiSelectToolbar extends Toolbar {
    readonly table: Table;
    private label;
    private backBtn;
    constructor(table: Table);
}
/**
 * Create a {@see MultiSelectToolbar} component
 *
 * {@see Toolbar} for an example
 *
 * @param config
 * @param items
 */
export declare const mstbar: (config: Config<MultiSelectToolbar, ComponentEventMap<MultiSelectToolbar>, "table">, ...items: (Component | "->" | "-")[]) => MultiSelectToolbar;
//# sourceMappingURL=MultiSelectToolbar.d.ts.map