GO.leavedays.SpecialLeaveDialog = Ext.extend(GO.dialog.TabbedFormDialog, {

	enableApplyButton: false,

	userId: null,

	initComponent: function () {

		Ext.apply(this, {
			titleField: 'user_name',
			height: dp(480),
			width: dp(700),
			updateAction: 'update',
			createAction: 'create',
			goDialogId: 'specialleavebudget',
			title: t("Special leave budget", "leavedays"),
			formControllerUrl: 'leavedays/specialleavebudget',
			endDateRequired: true
		});

		GO.leavedays.SpecialLeaveDialog.superclass.initComponent.call(this);

	},

	afterLoad: function (remoteModelId, config, action) {

		// this.yearField.setValue(GO.leavedays.activeYear);
		if (GO.leavedays.activeAgreementId > 0) {
			this.agreementIdField.setValue(GO.leavedays.activeAgreementId);
		}
		this.userId = GO.leavedays.activeUserId;

		if (!(remoteModelId > 0)) {
			var now = new Date();
			var theDate = new Date(GO.leavedays.activeYear, now.getMonth(), now.getDate());
			this.firstDateField.setValue(theDate);
			this.lastDateField.setValue(theDate);
		}

		this._checkDateInput(true);

	},


	buildForm: function () {
		this.propertiesPanel = new Ext.form.FieldSet({
			autoScroll: true,
			layout: 'column',
			items: [new Ext.Panel({
				columnWidth: .7,
				border: false,
				layout: 'form',
				waitMsgTarget: true,
				items: [
					this.agreementIdField = new Ext.form.NumberField({
						hidden: true,
						decimals: 0,
						name: 'agreement_id'
					}), {
						xtype: 'plainfield',
						name: 'user_name',
						fieldLabel: t("Employee", "leavedays")
					},
					// this.yearField = new GO.form.PlainField({
					// 	fieldLabel: t("Year", "leavedays"),
					// 	decimals: 0,
					// 	name: 'year'
					// }),
					this.firstDateField = new Ext.form.DateField({
						fieldLabel: t("First date", "leavedays"),
						name: 'start_date',
						format: GO.settings['date_format'],
						allowBlank: true,
						listeners: {
							change: {
								fn: this._checkDateInput,
								scope: this
							}
						}
					}), this.lastDateField = new Ext.form.DateField({
						fieldLabel: t("Last date", "leavedays"),
						name: 'finish_date',
						format: GO.settings['date_format'],
						allowBlank: true,
						listeners: {
							change: {
								fn: this._checkDateInput,
								scope: this
							}
						}
					}),

					this.hoursField = new GO.form.NumberField({
						fieldLabel: t("Special leave hours", "leavedays"),
						name: 'n_hours',
						width: dp(160),
						decimals: 2,
						maxValue: 8784,
						minValue: GO.leavedays.currentUserIsManager ? Number.NEGATIVE_INFINITY : 0,
						allowBlank: !GO.leavedays.currentUserIsManager
					}),

					this.commentsField = new Ext.form.TextField({
						fieldLabel: t("Description", "leavedays"),
						name: 'description',
						allowBlank: false,
						width: dp(300),
						maxLength: 50
					}),
					this.type = new go.modules.business.business.ActivityCombo({
						fieldLabel: t("Type", "leavedays"),
						hiddenName: 'activity_id',
						activityType: 'special',
						emptyText: t("Please select..."),
						listeners: {
							select: {
								fn: this._checkExpiry,
								scope: this
							}
						}
					})
				]
			})
			]
		});

		this.addPanel(this.propertiesPanel);
	},

	_checkDateInput: function (loading) {

		loading = loading || false;

		let eD = this.lastDateField.getValue(), sD = this.firstDateField.getValue();

		// Not relevant for special leave budgets
		// if (!GO.util.empty(sD) && sD.getFullYear() != this.yearField.getValue()) {
		// 	Ext.MessageBox.alert('', t("The holiday entry must be completely in the year %y.", "leavedays").replace('%y', this.yearField.getValue()));
		// 	this.firstDateField.reset();
		// } else if (!GO.util.empty(eD) && eD.getFullYear() != this.yearField.getValue()) {
		// 	Ext.MessageBox.alert('', t("The holiday entry must be completely in the year %y.", "leavedays").replace('%y', this.yearField.getValue()));
		// 	this.lastDateField.reset();
		// }

		if (!GO.util.empty(sD) && GO.util.empty(eD) && this.endDateRequired) {
			this.lastDateField.setValue(sD);
		}

		if (!GO.util.empty(sD) && !GO.util.empty(eD)) {

			if (sD > eD) {
				this.lastDateField.setValue(sD);
			}
			eD = this.lastDateField.getValue();
			sD = this.firstDateField.getValue();

		}

		if (loading === true) {
			return;
		}
	},

	_checkExpiry: function (cb, record, oldValue) {
		if (go.util.empty(record)) {
			this.endDateRequired = true;
		} else {
			this.endDateRequired = record.json.budgetExpires;
			if (go.util.empty(this.hoursField.getValue())) {
				this.hoursField.setValue(record.json.units);
			}
		}

		this._checkDateInput(false);

	}

});
