go.modules.business.newsletters.MainPanel = Ext.extend(go.modules.ModulePanel, {
	id: "business-newsletters",
	title: t("Newsletters"),

	layout: 'responsive',
	layoutConfig: {
		triggerWidth: 1000
	},

	addressListId : null,

	entityStore: "AddressList",

	onChanges : function(entityStore, added, changed, destroyed) {		

		if(changed.indexOf(this.addressListId) > -1) {
			this.cardPanel.getLayout().activeItem.store.reload();
		}
		
	},	

	initComponent: function () {		
		this.grids = {};

		this.items = [
			this.addressListContentPanel = Ext.create({
				xtype:"panel",
				layout: "responsive",
				region: "center",

				mobile: {
					xtype: "tabpanel",
					layout: null,
				},

				items: [
					this.cardPanel = new Ext.Panel({
						mobile: {
							title: t("Recipients"),
						},
						stateId: 'business-newsletters-west',
						disabled: true,
						region: "west",
						layout: "card",
						width: dp(500),
						items: [],
						split: true
					}),
					this.sentItemsGrid = new go.modules.business.newsletters.SentItemsGrid({
						region: "center",
						split: true
					})
				]
			}),
			this.createListsGrid()			
		];

		go.modules.business.newsletters.MainPanel.superclass.initComponent.call(this);

		this.on("afterrender", this.runModule, this);
	},

	runModule: function () {
		this.addressListGrid.store.load({
			callback: function() {
				// this.addressListGrid.getSelectionModel().selectFirstRow();

				const selected = this.addressListGrid.getSelectionModel().getSelected();

				if(selected) {
					this.loadAddressList(selected.id);
				}
			},
			scope: this
		});
	},
	
	addEntities : function() {
		this.entity.add().then((ids) => {
			const record = this.addressListGrid.getSelectionModel().getSelected(), store = go.Db.store("AddressList");
			
			store.get([record.id]).then((result) => {
				let update = {};
				let e = result.entities[0];
				update[e.id] = {
					entities: e.entities || {}
				};

				ids.forEach(function(id){
					update[e.id].entities[id] = {entityId: id};
				});
				
				store.set({
					update: update
				});
			});
		}).catch(function() {
			//closed
		});
	},

	createListsGrid: function () {
		const mayManage = go.Modules.get("business", 'newsletters').userRights.mayManage;
		return this.addressListGrid = new go.modules.business.newsletters.AddressListGrid({
			region: 'west',
			cls: 'go-sidenav',
			hideHeaders: false,
			stateful: false,
			selModel: new Ext.grid.RowSelectionModel({singleSelect: true}),
			width: dp(280),
			split: true,
			tbar: [{
					xtype: 'tbtitle',
					text: t('Lists')
				}, '->', {xtype:'tbsearch'}, {
					iconCls: 'ic-add',
					tooltip: t('Add'),
					hidden: !mayManage,
					handler: function (e, toolEl) {
						let dlg = new go.modules.business.newsletters.AddressListDialog();

						//TODO make selectable
						dlg.setValues({
							entity: "Contact"
						}).show();
					}
				},
				{
					cls: 'go-narrow',
					iconCls: "ic-arrow-forward",
					tooltip: t("Items"),
					handler: function () {
						this.addressListContentPanel.show();
					},
					scope: this
				}],
			listeners: {
				navigate: (grid, rowIndex, record) => {
					this.loadAddressList(record.id);
				},
				scope: this
			}
		});
	},
	
	loadAddressList : function(addressListId) {
		go.Db.store("AddressList").single(addressListId).then((addressList) => {
			this.cardPanel.show();
			this.entity = null;
			
			go.modules.business.newsletters.entities.forEach((e) => {
				if(e.name == addressList.entity) {
					this.entity = e;
					return false;
				}
			}, this);
			
			if(!this.entity) {
				throw "Could not find entity " + addressList.entity + " for newsletters. Is it registered?";
			}
			this.cardPanel.setDisabled(false);
			this.sentItemsGrid.setAddressListId(addressList.id);
			this.addressListId = addressList.id;
			
			if(!this.grids[this.entity.name]) {
				this.grids[this.entity.name] = new this.entity.grid({
					stateId: 'business-newsletters-' + this.entity.name,
					listeners: {
						rowdblclick: (grid, rowIndex, e) => {
							const win = new go.links.LinkDetailWindow({
								entity: this.entity.name
							});
							
							const record = grid.store.getAt(rowIndex);
							win.load(record.data.id);
						}
					},
					tbar: [
						{
							cls: 'go-narrow', //Shows on mobile only
							iconCls: "ic-menu",
							handler: () => {
								this.addressListGrid.show();
							},
							scope: this
						},
						{
							xtype: 'tbtitle',
							desktop: {
								text: t('Recipients')
							}
						},
						 '->',
						{
							xtype: 'tbsearch'
						},
						{
							xtype:"button",
							iconCls: "ic-add",
							tooltip: t("Add recipients"),
							handler: this.addEntities,
							scope: this
						},{
							xtype:"button",
							iconCls: "ic-delete",
							tooltip: t("Delete"),
							handler: function() {
								this.grids[this.entity.name].deleteSelected();
							},
							scope: this
						}
					]
				});
				//Override delete function
				this.grids[this.entity.name].doDelete = this.deleteEntities;
				this.cardPanel.add(this.grids[this.entity.name]);
			}

			this.cardPanel.getLayout().setActiveItem(this.grids[this.entity.name]);

			this.grids[this.entity.name].store.setFilter('addresslist', {addressListId: addressList.id}).load();
			this.sentItemsGrid.store.setFilter('addresslist', {addressListId: addressList.id}).load();
		});
		
	},

	deleteEntities : function(selectedRecords) {		
		const removeIds = selectedRecords.column("id"),
			addressListId = this.store.getFilter("addresslist").addressListId;

		go.Db.store("AddressList").single(addressListId).then((addressList) => {
			
			let update = {};
			update[addressListId] = 	{
				entities: addressList.entities
			};

			removeIds.forEach(function(id) {
				update[addressListId].entities[id] = null;
			});

			go.Db.store("AddressList").set({
				update: update
			});
		});
		
	},

});
