<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

namespace Glpi\Form\Export\Result;

final class ImportResultPreview
{
    /** @var string[] $valid_forms */
    private array $valid_forms = [];

    /** @var string[] $invalid_forms */
    private array $invalid_forms = [];

    /** @var string[] $skipped_forms */
    private array $skipped_forms = [];

    /**
     * Store error messages for a given form ID.
     * Unlike $invalid_forms, this represent errors that aren't recoverable.
     *
     *  @var array<int, array{name: string, errors: array<string>}> $fatal_errors
     **/
    private array $fatal_errors = [];

    public function addValidForm(int $form_id, string $form_name): void
    {
        $this->valid_forms[$form_id] = $form_name;
    }

    /** @return string[] */
    public function getValidForms(): array
    {
        return $this->valid_forms;
    }

    public function addInvalidForm(int $form_id, string $form_name): void
    {
        $this->invalid_forms[$form_id] = $form_name;
    }

    /** @return string[] */
    public function getInvalidForms(): array
    {
        return $this->invalid_forms;
    }

    public function addSkippedForm(int $form_id, string $form_name): void
    {
        $this->skipped_forms[$form_id] = $form_name;
    }

    /** @return string[] */
    public function getSkippedForms(): array
    {
        return $this->skipped_forms;
    }

    public function addFatalErrorForForm(
        int $form_id,
        string $form_name,
        string $error
    ): void {
        if (!isset($this->fatal_errors[$form_id])) {
            $this->fatal_errors[$form_id] = [
                'name' => $form_name,
                'errors' => [],
            ];
        }

        $this->fatal_errors[$form_id]['errors'][] = $error;
    }

    public function hasFatalErrorForForm(int $form_id): bool
    {
        $errors = $this->fatal_errors[$form_id]['errors'] ?? [];
        return count($errors) > 0;
    }

    public function getFormsWithFatalErrors(): array
    {
        return $this->fatal_errors;
    }
}
