<?php
/*
 * PSX is an open source PHP framework to develop RESTful APIs.
 * For the current version and information visit <https://phpsx.org>
 *
 * Copyright 2010-2024 Christoph Kappestein <christoph.kappestein@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace PSX\Api\Generator\Server\Dto;

use PSX\Api\OperationInterface;

/**
 * File
 *
 * @author  Christoph Kappestein <christoph.kappestein@gmail.com>
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @link    https://phpsx.org
 */
class File
{
    private string $name;
    private Folder $folder;
    private array $operations;

    public function __construct(string $name, Folder $folder)
    {
        $this->name = $name;
        $this->folder = $folder;
        $this->operations = [];
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getFolder(): Folder
    {
        return $this->folder;
    }

    /**
     * @return array<string, OperationInterface>
     */
    public function getOperations(): array
    {
        return $this->operations;
    }

    public function addOperation(string $name, OperationInterface $operation): void
    {
        $this->operations[$name] = $operation;
    }
}
