/**
 * Client automatically generated by SDKgen please do not edit this file manually
 * {@link https://sdkgen.app}
 */

import {ClientAbstract, CredentialsInterface, TokenStoreInterface, HttpRequest} from "sdkgen-client"
import {HttpBearer} from "sdkgen-client"
import {Anonymous} from "sdkgen-client"
import {ClientException, UnknownStatusCodeException} from "sdkgen-client";

import {ArrayEntryMessageException} from "./ArrayEntryMessageException";
import {Entry} from "./Entry";
import {EntryCollection} from "./EntryCollection";
import {EntryCreate} from "./EntryCreate";
import {EntryDelete} from "./EntryDelete";
import {EntryMessage} from "./EntryMessage";
import {EntryMessageException} from "./EntryMessageException";
import {EntryPatch} from "./EntryPatch";
import {EntryUpdate} from "./EntryUpdate";
import {MapEntryMessageException} from "./MapEntryMessageException";

export class Client extends ClientAbstract {
    /**
     * Returns a collection
     *
     * @returns {Promise<EntryCollection>}
     * @throws {ClientException}
     */
    public async get(name: string, type: string, startIndex?: number, float?: number, boolean?: boolean, date?: string, datetime?: string, args?: Entry): Promise<EntryCollection> {
        const url = this.parser.url('/foo/:name/:type', {
            'name': name,
            'type': type,
        });

        let request: HttpRequest = {
            url: url,
            method: 'GET',
            headers: {
            },
            params: this.parser.query({
                'startIndex': startIndex,
                'float': float,
                'boolean': boolean,
                'date': date,
                'datetime': datetime,
                'args': args,
            }, [
                'args',
            ]),
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as EntryCollection;
        }

        const statusCode = response.status;
        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<EntryMessage>}
     * @throws {EntryMessageException}
     * @throws {ClientException}
     */
    public async create(name: string, type: string, payload: EntryCreate): Promise<EntryMessage> {
        const url = this.parser.url('/foo/:name/:type', {
            'name': name,
            'type': type,
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as EntryMessage;
        }

        const statusCode = response.status;
        if (statusCode === 400) {
            throw new EntryMessageException(await response.json() as EntryMessage);
        }

        if (statusCode === 500) {
            throw new EntryMessageException(await response.json() as EntryMessage);
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<Record<string, EntryMessage>>}
     * @throws {EntryMessageException}
     * @throws {MapEntryMessageException}
     * @throws {ClientException}
     */
    public async update(name: string, type: string, payload: Record<string, EntryUpdate>): Promise<Record<string, EntryMessage>> {
        const url = this.parser.url('/foo/:name/:type', {
            'name': name,
            'type': type,
        });

        let request: HttpRequest = {
            url: url,
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as Record<string, EntryMessage>;
        }

        const statusCode = response.status;
        if (statusCode === 400) {
            throw new EntryMessageException(await response.json() as EntryMessage);
        }

        if (statusCode === 500) {
            throw new MapEntryMessageException(await response.json() as Record<string, EntryMessage>);
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<void>}
     * @throws {ClientException}
     */
    public async delete(name: string, type: string): Promise<void> {
        const url = this.parser.url('/foo/:name/:type', {
            'name': name,
            'type': type,
        });

        let request: HttpRequest = {
            url: url,
            method: 'DELETE',
            headers: {
            },
            params: this.parser.query({
            }, [
            ]),
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
        }

        const statusCode = response.status;
        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<Array<EntryMessage>>}
     * @throws {EntryMessageException}
     * @throws {ArrayEntryMessageException}
     * @throws {ClientException}
     */
    public async patch(name: string, type: string, payload: Array<EntryPatch>): Promise<Array<EntryMessage>> {
        const url = this.parser.url('/foo/:name/:type', {
            'name': name,
            'type': type,
        });

        let request: HttpRequest = {
            url: url,
            method: 'PATCH',
            headers: {
                'Content-Type': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as Array<EntryMessage>;
        }

        const statusCode = response.status;
        if (statusCode === 400) {
            throw new EntryMessageException(await response.json() as EntryMessage);
        }

        if (statusCode === 500) {
            throw new ArrayEntryMessageException(await response.json() as Array<EntryMessage>);
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }




    public static build(token: string): Client
    {
        return new Client('http://api.foo.com', new HttpBearer(token));
    }

    public static buildAnonymous(): Client
    {
        return new Client('http://api.foo.com', new Anonymous());
    }
}
