<?php
/**
 * QuoteTag automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Twitter;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TagAbstract;

class QuoteTag extends TagAbstract
{
    /**
     * Returns Quote Tweets for a Tweet specified by the requested Tweet ID.
     *
     * @param string $tweetId
     * @param string|null $exclude
     * @param string|null $expansions
     * @param int|null $maxResults
     * @param string|null $paginationToken
     * @param Fields|null $fields
     * @return TweetCollection
     * @throws ClientException
     */
    public function getAll(string $tweetId, ?string $exclude = null, ?string $expansions = null, ?int $maxResults = null, ?string $paginationToken = null, ?Fields $fields = null): TweetCollection
    {
        $url = $this->parser->url('/2/tweets/:tweet_id/quote_tweets', [
            'tweet_id' => $tweetId,
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
                'exclude' => $exclude,
                'expansions' => $expansions,
                'max_results' => $maxResults,
                'pagination_token' => $paginationToken,
                'fields' => $fields,
            ], [
                'fields',
            ]),
        ];

        try {
            $response = $this->httpClient->request('GET', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, TweetCollection::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }



}
