<?php
/**
 * BookmarkTag automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Twitter;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TagAbstract;

class BookmarkTag extends TagAbstract
{
    /**
     * Allows you to get an authenticated user's 800 most recent bookmarked Tweets.
     *
     * @param string $userId
     * @param string|null $expansions
     * @param string|null $paginationToken
     * @param Fields|null $fields
     * @return TweetCollection
     * @throws ClientException
     */
    public function getAll(string $userId, ?string $expansions = null, ?string $paginationToken = null, ?Fields $fields = null): TweetCollection
    {
        $url = $this->parser->url('/2/users/:user_id/bookmarks', [
            'user_id' => $userId,
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
                'expansions' => $expansions,
                'pagination_token' => $paginationToken,
                'fields' => $fields,
            ], [
                'fields',
            ]),
        ];

        try {
            $response = $this->httpClient->request('GET', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, TweetCollection::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * @param string $userId
     * @param SingleTweet $payload
     * @return BookmarkResponse
     * @throws ClientException
     */
    public function create(string $userId, SingleTweet $payload): BookmarkResponse
    {
        $url = $this->parser->url('/2/users/:user_id/bookmarks', [
            'user_id' => $userId,
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, BookmarkResponse::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * @param string $userId
     * @param string $tweetId
     * @return BookmarkResponse
     * @throws ClientException
     */
    public function delete(string $userId, string $tweetId): BookmarkResponse
    {
        $url = $this->parser->url('/2/users/:user_id/bookmarks/:tweet_id', [
            'user_id' => $userId,
            'tweet_id' => $tweetId,
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
            ], [
            ]),
        ];

        try {
            $response = $this->httpClient->request('DELETE', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, BookmarkResponse::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }



}
