<?php
/**
 * CompletionsTag automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Openai;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TagAbstract;

class CompletionsTag extends TagAbstract
{
    /**
     * Creates a model response for the given chat conversation.
     *
     * @param CompletionRequest $payload
     * @return CompletionResponse
     * @throws ErrorException
     * @throws ClientException
     */
    public function create(CompletionRequest $payload): CompletionResponse
    {
        $url = $this->parser->url('/v1/chat/completions', [
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, \PSX\Schema\SchemaSource::fromClass(CompletionResponse::class));

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode >= 0 && $statusCode <= 999) {
                $data = $this->parser->parse((string) $body, \PSX\Schema\SchemaSource::fromClass(Error::class));

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * List stored Chat Completions. Only Chat Completions that have been stored with the store parameter set to true will be returned.
     *
     * @param string|null $after
     * @param int|null $limit
     * @param string|null $model
     * @param string|null $order
     * @return CompletionCollection
     * @throws ErrorException
     * @throws ClientException
     */
    public function getAll(?string $after = null, ?int $limit = null, ?string $model = null, ?string $order = null): CompletionCollection
    {
        $url = $this->parser->url('/v1/chat/completions', [
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
                'after' => $after,
                'limit' => $limit,
                'model' => $model,
                'order' => $order,
            ], [
            ]),
        ];

        try {
            $response = $this->httpClient->request('GET', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, \PSX\Schema\SchemaSource::fromClass(CompletionCollection::class));

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode >= 0 && $statusCode <= 999) {
                $data = $this->parser->parse((string) $body, \PSX\Schema\SchemaSource::fromClass(Error::class));

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * Delete a stored chat completion. Only Chat Completions that have been created with the store parameter set to true can be deleted.
     *
     * @param string $completionId
     * @return CompletionDeleted
     * @throws ErrorException
     * @throws ClientException
     */
    public function delete(string $completionId): CompletionDeleted
    {
        $url = $this->parser->url('/v1/chat/completions/:completion_id', [
            'completion_id' => $completionId,
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
            ], [
            ]),
        ];

        try {
            $response = $this->httpClient->request('DELETE', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, \PSX\Schema\SchemaSource::fromClass(CompletionDeleted::class));

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode >= 0 && $statusCode <= 999) {
                $data = $this->parser->parse((string) $body, \PSX\Schema\SchemaSource::fromClass(Error::class));

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }



}
