<?php
/**
 * CompletionRequest automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Openai;

use PSX\Schema\Attribute\Description;
use PSX\Schema\Attribute\Key;

#[Description('')]
class CompletionRequest implements \JsonSerializable, \PSX\Record\RecordableInterface
{
    #[Description('Model ID used to generate the response, like gpt-4o or o1. OpenAI offers a wide range of models with different capabilities, performance characteristics, and price points. Refer to the model guide to browse and compare available models.')]
    protected ?string $model = null;
    /**
     * @var array<CompletionMessage>|null
     */
    #[Description('A list of messages comprising the conversation so far. Depending on the model you use, different message types (modalities) are supported, like text, images, and audio.')]
    protected ?array $messages = null;
    #[Key('frequency_penalty')]
    #[Description('Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model\'s likelihood to repeat the same line verbatim.')]
    protected ?float $frequencyPenalty = null;
    /**
     * @var \PSX\Record\Record<int>|null
     */
    #[Key('logit_bias')]
    #[Description('Modify the likelihood of specified tokens appearing in the completion.')]
    protected ?\PSX\Record\Record $logitBias = null;
    #[Description('Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the content of message.')]
    protected ?bool $logprobs = null;
    #[Key('max_completion_tokens')]
    #[Description('An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.')]
    protected ?int $maxCompletionTokens = null;
    /**
     * @var \PSX\Record\Record<string>|null
     */
    #[Description('Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format, and querying for objects via API or the dashboard.')]
    protected ?\PSX\Record\Record $metadata = null;
    #[Key('presence_penalty')]
    #[Description('Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model\'s likelihood to talk about new topics.')]
    protected ?float $presencePenalty = null;
    #[Key('reasoning_effort')]
    #[Description('Constrains effort on reasoning for reasoning models. Currently supported values are low, medium, and high. Reducing reasoning effort can result in faster responses and fewer tokens used on reasoning in a response.')]
    protected ?string $reasoningEffort = null;
    #[Description('This feature is in Beta. If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed, and you should refer to the system_fingerprint response parameter to monitor changes in the backend.')]
    protected ?int $seed = null;
    #[Key('service_tier')]
    #[Description('Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service')]
    protected ?string $serviceTier = null;
    /**
     * @var array<string>|null
     */
    #[Description('Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.')]
    protected ?array $stop = null;
    #[Description('Whether or not to store the output of this chat completion request for use in our model distillation or evals products.')]
    protected ?bool $store = null;
    #[Description('What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. We generally recommend altering this or top_p but not both.')]
    protected ?float $temperature = null;
    #[Key('top_logprobs')]
    #[Description('An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. logprobs must be set to true if this parameter is used.')]
    protected ?int $topLogprobs = null;
    #[Key('top_p')]
    #[Description('An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.')]
    protected ?float $topP = null;
    #[Description('A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.')]
    protected ?string $user = null;
    public function setModel(?string $model): void
    {
        $this->model = $model;
    }
    public function getModel(): ?string
    {
        return $this->model;
    }
    /**
     * @param array<CompletionMessage>|null $messages
     */
    public function setMessages(?array $messages): void
    {
        $this->messages = $messages;
    }
    /**
     * @return array<CompletionMessage>|null
     */
    public function getMessages(): ?array
    {
        return $this->messages;
    }
    public function setFrequencyPenalty(?float $frequencyPenalty): void
    {
        $this->frequencyPenalty = $frequencyPenalty;
    }
    public function getFrequencyPenalty(): ?float
    {
        return $this->frequencyPenalty;
    }
    /**
     * @param \PSX\Record\Record<int>|null $logitBias
     */
    public function setLogitBias(?\PSX\Record\Record $logitBias): void
    {
        $this->logitBias = $logitBias;
    }
    /**
     * @return \PSX\Record\Record<int>|null
     */
    public function getLogitBias(): ?\PSX\Record\Record
    {
        return $this->logitBias;
    }
    public function setLogprobs(?bool $logprobs): void
    {
        $this->logprobs = $logprobs;
    }
    public function getLogprobs(): ?bool
    {
        return $this->logprobs;
    }
    public function setMaxCompletionTokens(?int $maxCompletionTokens): void
    {
        $this->maxCompletionTokens = $maxCompletionTokens;
    }
    public function getMaxCompletionTokens(): ?int
    {
        return $this->maxCompletionTokens;
    }
    /**
     * @param \PSX\Record\Record<string>|null $metadata
     */
    public function setMetadata(?\PSX\Record\Record $metadata): void
    {
        $this->metadata = $metadata;
    }
    /**
     * @return \PSX\Record\Record<string>|null
     */
    public function getMetadata(): ?\PSX\Record\Record
    {
        return $this->metadata;
    }
    public function setPresencePenalty(?float $presencePenalty): void
    {
        $this->presencePenalty = $presencePenalty;
    }
    public function getPresencePenalty(): ?float
    {
        return $this->presencePenalty;
    }
    public function setReasoningEffort(?string $reasoningEffort): void
    {
        $this->reasoningEffort = $reasoningEffort;
    }
    public function getReasoningEffort(): ?string
    {
        return $this->reasoningEffort;
    }
    public function setSeed(?int $seed): void
    {
        $this->seed = $seed;
    }
    public function getSeed(): ?int
    {
        return $this->seed;
    }
    public function setServiceTier(?string $serviceTier): void
    {
        $this->serviceTier = $serviceTier;
    }
    public function getServiceTier(): ?string
    {
        return $this->serviceTier;
    }
    /**
     * @param array<string>|null $stop
     */
    public function setStop(?array $stop): void
    {
        $this->stop = $stop;
    }
    /**
     * @return array<string>|null
     */
    public function getStop(): ?array
    {
        return $this->stop;
    }
    public function setStore(?bool $store): void
    {
        $this->store = $store;
    }
    public function getStore(): ?bool
    {
        return $this->store;
    }
    public function setTemperature(?float $temperature): void
    {
        $this->temperature = $temperature;
    }
    public function getTemperature(): ?float
    {
        return $this->temperature;
    }
    public function setTopLogprobs(?int $topLogprobs): void
    {
        $this->topLogprobs = $topLogprobs;
    }
    public function getTopLogprobs(): ?int
    {
        return $this->topLogprobs;
    }
    public function setTopP(?float $topP): void
    {
        $this->topP = $topP;
    }
    public function getTopP(): ?float
    {
        return $this->topP;
    }
    public function setUser(?string $user): void
    {
        $this->user = $user;
    }
    public function getUser(): ?string
    {
        return $this->user;
    }
    public function toRecord(): \PSX\Record\RecordInterface
    {
        /** @var \PSX\Record\Record<mixed> $record */
        $record = new \PSX\Record\Record();
        $record->put('model', $this->model);
        $record->put('messages', $this->messages);
        $record->put('frequency_penalty', $this->frequencyPenalty);
        $record->put('logit_bias', $this->logitBias);
        $record->put('logprobs', $this->logprobs);
        $record->put('max_completion_tokens', $this->maxCompletionTokens);
        $record->put('metadata', $this->metadata);
        $record->put('presence_penalty', $this->presencePenalty);
        $record->put('reasoning_effort', $this->reasoningEffort);
        $record->put('seed', $this->seed);
        $record->put('service_tier', $this->serviceTier);
        $record->put('stop', $this->stop);
        $record->put('store', $this->store);
        $record->put('temperature', $this->temperature);
        $record->put('top_logprobs', $this->topLogprobs);
        $record->put('top_p', $this->topP);
        $record->put('user', $this->user);
        return $record;
    }
    public function jsonSerialize(): object
    {
        return (object) $this->toRecord()->getAll();
    }
}
