<?php

declare(strict_types = 1);

namespace PSX\OpenRPC;


class ContentDescriptor implements \JsonSerializable, \PSX\Record\RecordableInterface
{
    protected ?string $name = null;
    protected ?string $summary = null;
    protected ?string $description = null;
    protected ?bool $required = null;
    protected mixed $schema = null;
    protected ?bool $deprecated = null;
    public function setName(?string $name): void
    {
        $this->name = $name;
    }
    public function getName(): ?string
    {
        return $this->name;
    }
    public function setSummary(?string $summary): void
    {
        $this->summary = $summary;
    }
    public function getSummary(): ?string
    {
        return $this->summary;
    }
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }
    public function getDescription(): ?string
    {
        return $this->description;
    }
    public function setRequired(?bool $required): void
    {
        $this->required = $required;
    }
    public function getRequired(): ?bool
    {
        return $this->required;
    }
    public function setSchema(mixed $schema): void
    {
        $this->schema = $schema;
    }
    public function getSchema(): mixed
    {
        return $this->schema;
    }
    public function setDeprecated(?bool $deprecated): void
    {
        $this->deprecated = $deprecated;
    }
    public function getDeprecated(): ?bool
    {
        return $this->deprecated;
    }
    public function toRecord(): \PSX\Record\RecordInterface
    {
        /** @var \PSX\Record\Record<mixed> $record */
        $record = new \PSX\Record\Record();
        $record->put('name', $this->name);
        $record->put('summary', $this->summary);
        $record->put('description', $this->description);
        $record->put('required', $this->required);
        $record->put('schema', $this->schema);
        $record->put('deprecated', $this->deprecated);
        return $record;
    }
    public function jsonSerialize(): object
    {
        return (object) $this->toRecord()->getAll();
    }
}

