<?php

/*
 * FORMA - The E-Learning Suite
 *
 * Copyright (c) 2013-2023 (Forma)
 * https://www.formalms.org
 * License https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 *
 * from docebo 4.0.5 CE 2008-2012 (c) docebo
 * License https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */

defined('IN_FORMA') or exit('Direct access is forbidden.');

/**
 * @category
 *
 * @author Fabio Pirovano
 *
 * @version $Id:$
 *
 * @since 3.5
 *
 * ( editor = Eclipse 3.2.0[phpeclipse,subclipse,WTP], tabwidth = 4 )
 */
require_once dirname(__FILE__) . '/class.definition.php';

class Module_PreAssessment extends LmsAdminModule
{
    public function loadBody()
    {
        require_once dirname(__FILE__) . '/../modules/' . $this->module_name . '/' . $this->module_name . '.php';
        preAssessmentDispatch($GLOBALS['op']);
    }

    // Function for permission managment
    public function getAllToken($op)
    {
        return [
            'view' => ['code' => 'view',
                                'name' => '_VIEW',
                                'image' => 'standard/view.png', ],
            'mod' => ['code' => 'mod',
                                'name' => '_MOD',
                                'image' => 'standard/edit.png', ],
            'subscribe' => ['code' => 'subscribe',
                                'name' => '_SUBSCRIBE',
                                'image' => 'subscribe/add_subscribe.gif', ],
        ];
    }
}
