<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 */

/**
 * Point d'entrée pour la gestion de l'authentification des utilisateurs.
 * Gère la connexion, la déconnexion et la modification du mot de passe administrateur.
 */

$out['self'] = 'auth';

require_once __DIR__ . '/' . 'header.php';

if (DEBUG_MODE) {
    error_log('auth.php: header.php inclus avec succès, token=' . ($token ?? 'non défini'));
}

try {
    // Gérer la modification du mot de passe administrateur
    if (Util::isGET('password') && User::isAdmin()) {
        if (DEBUG_MODE) {
            error_log('auth.php: Accès à password, User::isAdmin=' . (User::isAdmin() ? 'true' : 'false'));
        }
        $cur = 'password';
        $out['subtitle'] = $lang['edit_password'];

        if (!empty($_POST) && HTMLForm::check('trip', 0, 50) && CSRF::check($token)) {
            if (DEBUG_MODE) {
                error_log('auth.php: Soumission du formulaire de mot de passe');
            }
            $config['admin'] = HTMLForm::trip(HTMLForm::clean(Parser::translitIt($_POST['trip'])), KEY);
            flatDB::saveEntry('config', 'config', $config);
            User::logout();
            $out['content'] .= Plugin::redirectMsg($lang['password_changed'], 'auth.php', $lang['login'], 'alert alert-success');
        } else {
            $out['content'] .= 
            HTMLForm::form('auth.php' . DS . 'password', 
                HTMLForm::password('trip', '', '', 'your_admin_psw') .
                HTMLForm::simple_submit('submit', 'btn btn-lg btn-primary btn-block', 'fa fa-check')
            );
        }
    }
    // Gérer la déconnexion
    elseif (Util::isGET('logout')) {
        if (DEBUG_MODE) {
            error_log('auth.php: Déconnexion demandée');
        }
        User::logout();
        $out['subtitle'] = $lang['logout'];
        $out['content'] .= Plugin::redirectMsg($lang['logout_confirm'], 'index.php' . DS . 'forum', $lang['forum'], 'alert alert-success', true);
    }
    // Gérer la page de connexion
    elseif (!User::isWorker()) {
        if (DEBUG_MODE) {
            error_log('auth.php: Accès à la page de connexion, User::isWorker=' . (User::isWorker() ? 'true' : 'false'));
        }
        $cur = 'login';
        $out['subtitle'] = (defined('FLATBOARD_PRO')) ? 'FLATBOARD PRO' : 'FLATBOARD';

        if (HTMLForm::checkBot() && HTMLForm::check('trip', 0, 50) && User::login($_POST['trip']) && CSRF::check($token)) {
            if (DEBUG_MODE) {
                error_log('auth.php: Authentification réussie via formulaire');
            }
            $referer = filter_var($_SERVER['HTTP_REFERER'], FILTER_VALIDATE_URL);
            $referer = ($referer === HTML_BASEPATH . DS . 'auth.php') ? 'index.php' : 'javascript:history.go(-1)';
            $redirect = !empty($referer) ? $referer : 'javascript:history.go(-1)';
            $out['content'] .= Plugin::redirectMsg($lang['login_confirm'], $redirect, $lang['previous_page'], 'alert alert-success', false);
        } else {
            if (DEBUG_MODE && !empty($_POST)) {
                error_log('auth.php: Échec de l\'authentification, checkBot=' . (HTMLForm::checkBot() ? 'true' : 'false') . 
                          ', checkTrip=' . (HTMLForm::check('trip', 0, 50) ? 'true' : 'false') . 
                          ', login=' . (User::login($_POST['trip']) ? 'true' : 'false') . 
                          ', CSRF=' . (CSRF::check($token) ? 'true' : 'false') . 
                          ', trip=' . ($_POST['trip'] ?? 'vide'));
            }
            $out['content'] .= 
            HTMLForm::form('auth.php',
                HTMLForm::password('trip', '', '', 'your_admin_psw') .
                HTMLForm::submit('login', 'btn btn-lg btn-primary btn-block', 'fa fa-check')
            );
        }
    }
    // Utilisateur déjà connecté
    else {
        if (DEBUG_MODE) {
            error_log('auth.php: Utilisateur déjà connecté, rôle=' . ($_SESSION['role'] ?? 'aucun'));
        }
        $out['subtitle'] = (defined('FLATBOARD_PRO')) ? 'FLATBOARD PRO' : 'FLATBOARD';
        $out['content'] .= '<div class="card">
            <div class="card-body">
                <h5 class="card-title">' . $lang['already_logged'] . '</h5>
                <p class="card-text">' . Util::lang('already_logged_msg', $lang[$_SESSION['role'] ?? '']) . '</p>
                <a href="' . HTML_BASEPATH . '" class="btn btn-primary">' . $lang['back_to_site'] . '</a>
                <a class="btn btn-secondary" href="auth.php/logout">' . $lang['logout'] . '</a>
            </div>
        </div>';
    }
} catch (SecurityException $e) {
    if (DEBUG_MODE) {
        error_log('auth.php: SecurityException - ' . $e->getMessage());
        $out['content'] .= '<div class="alert alert-danger">Erreur de sécurité : ' . htmlspecialchars($e->getMessage()) . '</div>';
    } else {
        error_log('auth.php: SecurityException - ' . $e->getMessage());
        $out['content'] .= '<div class="alert alert-danger">Erreur de session. Veuillez vous reconnecter.</div>';
    }
    $out['content'] .= HTMLForm::form('auth.php',
        HTMLForm::password('trip', '', '', 'your_admin_psw') .
        HTMLForm::submit('login', 'btn btn-lg btn-primary btn-block', 'fa fa-check')
    );
} catch (Exception $e) {
    if (DEBUG_MODE) {
        error_log('auth.php: Exception inattendue - ' . $e->getMessage());
        $out['content'] .= '<div class="alert alert-danger">Erreur inattendue : ' . htmlspecialchars($e->getMessage()) . '</div>';
    } else {
        error_log('auth.php: Exception inattendue - ' . $e->getMessage());
        $out['content'] .= '<div class="alert alert-danger">Une erreur est survenue. Veuillez réessayer plus tard.</div>';
    }
    $out['content'] .= HTMLForm::form('auth.php',
        HTMLForm::password('trip', '', '', 'your_admin_psw') .
        HTMLForm::submit('login', 'btn btn-lg btn-primary btn-block', 'fa fa-check')
    );
}

if (DEBUG_MODE) {
    error_log('auth.php: Avant inclusion de footer.php, content défini=' . (isset($out['content']) ? 'true' : 'false'));
}
require PATH_ROOT . DS . 'footer.php';
?>