<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
*/

$out['self'] = 'delete';
require_once __DIR__  . '/' .  'header.php';
/**
 * SUPPRIME UNE DISCUSSION
 **/
if(Util::isGETValidEntry('topic', 'topic') && (User::isWorker() || User::isAuthor($_GET['topic'],'topic')))
{
	$topicEntry = flatDB::readEntry('topic', $_GET['topic']);
	$out['subtitle'] = Util::lang('delete topic : %s', $topicEntry['title']);
	if(HTMLForm::checkBot() && CSRF::check($token) )
	{
		flatDB::deleteEntry('topic', $_GET['topic']);

		$forumEntry = flatDB::readEntry('forum', $topicEntry['forum']);
		unset($forumEntry['topic'][$_GET['topic']]);
		unset($forumEntry['pinnedTopic'][$_GET['topic']]);
		flatDB::saveEntry('forum', $topicEntry['forum'], $forumEntry);

		foreach($topicEntry['reply'] as $reply)
		{
			flatDB::deleteEntry('reply', $reply);
		}
		$out['content'] .= Plugin::redirectMsg($lang['topic_deleted'], 'view.php' . DS . 'forum' . DS . $topicEntry['forum'], $forumEntry['name']);
	}
	else
	{
		$out['content'] .= HTMLForm::form('delete.php' . DS . 'topic' . DS . $_GET['topic'],
		HTMLForm::submit());
	}
}
/**
 * SUPPRIME UNE RÉPONSE
 **/
else if(Util::isGETValidEntry('reply', 'reply') && (User::isWorker() || User::isAuthor($_GET['reply'],'reply')))
{
	$replyEntry = flatDB::readEntry('reply', $_GET['reply']);
	$out['subtitle'] = Util::lang('delete reply : %s', $_GET['reply']);
	if(HTMLForm::checkBot() && CSRF::check($token) )
	{
		flatDB::deleteEntry('reply', $_GET['reply']);

		$topicEntry = flatDB::readEntry('topic', $replyEntry['topic']);
		unset($topicEntry['reply'][$_GET['reply']]);
		flatDB::saveEntry('topic', $replyEntry['topic'], $topicEntry);
		
		$out['content'] .= Plugin::redirectMsg($lang['reply_deleted'], 'view.php' . DS . 'topic' . DS . $replyEntry['topic'], $topicEntry['title']);
	}
	else
	{
		$out['content'] .= HTMLForm::form('delete.php' . DS . 'reply' . DS . $_GET['reply'],
		HTMLForm::submit());
	}
}
/**
 * SUPPRIME UN FORUM
 **/
else if(Util::isGETValidEntry('forum', 'forum') && User::isAdmin())
{
	$forumEntry = flatDB::readEntry('forum', $_GET['forum']);
	$out['subtitle'] = Util::lang('delete forum : %s', $forumEntry['name']);
	if(HTMLForm::checkBot() && CSRF::check($token) )
	{
		flatDB::deleteEntry('forum', $_GET['forum']);
		$forums = flatDB::readEntry('config', 'forumOrder');
		unset($forums[$_GET['forum']]);
		flatDB::saveEntry('config', 'forumOrder', $forums);

		// Optimisation : précharger toutes les réponses avant la suppression
		$allReplies = [];
		foreach($forumEntry['topic'] as $topic)
		{
			$topicEntry = flatDB::readEntry('topic', $topic);
			if ($topicEntry && isset($topicEntry['reply']) && is_array($topicEntry['reply'])) {
				$allReplies = array_merge($allReplies, $topicEntry['reply']);
			}
			flatDB::deleteEntry('topic', $topic);
		}
		// Supprimer toutes les réponses en une seule passe
		foreach($allReplies as $reply)
		{
			flatDB::deleteEntry('reply', $reply);
		}
		$out['content'] .= Plugin::redirectMsg($lang['forum_deleted'], 'index.php' . DS . 'forum', $lang['forum']);
	}
	else
	{
		$out['content'] .= HTMLForm::form('delete.php' . DS . 'forum' . DS . $_GET['forum'],
		HTMLForm::submit());
	}
}
/**
 * SUPPRIME UN MODÉRATEUR
 **/
else if(Util::isGET('worker') && User::isAdmin() && isset($config['worker'][$_GET['worker']]))
{
	$out['subtitle'] = Util::lang('delete worker : %s', $config['worker'][$_GET['worker']]);
	if($_SERVER['REQUEST_METHOD'] == 'POST')
	{
		unset($config['worker'][$_GET['worker']]);
		flatDB::saveEntry('config', 'config', $config);
		
		$out['content'] .= Plugin::redirectMsg($lang['worker_deleted'], 'config.php' . DS . 'worker', $lang['worker']);
	}
	else
	{
		$out['content'] .= HTMLForm::form('delete.php' . DS . 'worker' . DS . $_GET['worker'],
		HTMLForm::simple_submit('delete'));
	}
}
/**
 * RETIRE UNE IP DANS LA LISTE DES BANNIS (amélioré avec meilleure gestion)
 **/
else if(Util::isGET('ban') && User::isAdmin())
{
	$banIp = $_GET['ban'] ?? '';
	$out['subtitle'] = Util::lang('delete : %s', htmlspecialchars($banIp));    	
	if(!empty($_POST) && CSRF::check($token))
	{
		if (!file_exists(BAN_FILE)) {
			$msg = $lang['ip_not_banned'];
		} else {
			$contenu_debut = @file_get_contents(BAN_FILE);
			if ($contenu_debut === false) {
				$msg = $lang['file_error'] ?? 'Erreur lors de la lecture du fichier';
			} else {
				// Supprimer toutes les occurrences de l'IP (avec et sans saut de ligne)
				$ipToRemove = trim($banIp);
				$lines = explode("\n", $contenu_debut);
				$newLines = [];
				$removed = false;
				
				foreach ($lines as $line) {
					$line = trim($line);
					if (!empty($line)) {
						if ($line === $ipToRemove) {
							$removed = true;
							continue; // Ne pas ajouter cette ligne
						}
						$newLines[] = $line;
					}
				}
				
				$contenu = implode("\n", $newLines) . (count($newLines) > 0 ? "\n" : '');
				
				// Écrire le fichier avec gestion d'erreur
				$result = @file_put_contents(BAN_FILE, $contenu, LOCK_EX);
				
				if ($result !== false) {
					// Invalider le cache
					User::invalidateBanCache();
					
					if ($removed) {
						$msg = $lang['ip_removed'];
					} else {
						$msg = $lang['ip_not_banned'];
					}
				} else {
					$msg = $lang['file_error'] ?? 'Erreur lors de l\'écriture du fichier';
				}
			}
		}
		
		$out['content'] .= Plugin::redirectMsg($msg, 'config.php' . DS . 'ban', $lang['ban_list']);
	}
	else
	{
		$out['content'] .= HTMLForm::form('delete.php' . DS . 'ban' . DS . htmlspecialchars($banIp),
			'<div class="alert alert-warning">
				<i class="fa fa-exclamation-triangle"></i> ' . ($lang['confirm_unban'] ?? 'Êtes-vous sûr de vouloir retirer cette IP de la liste des bannis ?') . '
			</div>' .
		HTMLForm::simple_submit('delete', 'btn btn-danger', 'fa fa-trash'));
	}
}
/**
 * SUPPRIME UN TAG
 **/
else if(Util::isGET('tag') && User::isAdmin())
{
	$out['subtitle'] = Util::lang('delete : %s', $_GET['tag']);    	
	if(!empty($_POST) && CSRF::check($token) )
	{
		$tag = flatDB::readEntry('config', 'tags');
		unset($tag[$_GET['tag']]);
		flatDB::saveEntry('config', 'tags', $tag);
          
		$out['content'] .= Plugin::redirectMsg($out['subtitle'], 'config.php' . DS . 'tags', $lang['tags']);
	}
	else
	{
		$out['content'] .= HTMLForm::form('delete.php' . DS . 'tag' . DS . $_GET['tag'],
		HTMLForm::simple_submit());
	}
}
/**
 * PAGE 404
 **/
else
{
	Util::redirect('index.php' . DS . '404');
}

require PATH_ROOT . DS . 'footer.php';
?>