#!/bin/sh

FIXED_FLAG=/usr/share/lve/ALTMODP-166.fixed
CAGEFS_MP=/etc/cagefs/cagefs.mp
CAGEFSCTL=/usr/sbin/cagefsctl

if [ -f "$CAGEFS_MP" ]
then
    # Remove alt-mod-passenger auto comment and the line after it
    /usr/bin/sed -i -e '/^# next line is added by alt-mod-passenger/,+1d' "$CAGEFS_MP"

    if [ -x "$CAGEFSCTL" ]
    then
        echo "CageFS will be remounted for alt-mod-passenger cleanup"
        "$CAGEFSCTL" --remount-all
        echo "CageFS remounted"
    fi
    /bin/touch "$FIXED_FLAG"
else
    # No MP -> no alt-mod-passenger setup, so no need to fix it
    /bin/touch "$FIXED_FLAG"
fi
exit 0

