<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'przechowywane w ":timezone"',
    'displayed_in_tz'                           => 'wyświetlane w ":timezone"',
    'close'                                     => 'Zamknij',
    'actions'                                   => 'Akcje',
    'edit'                                      => 'Modyfikuj',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'ID dziennika transakcji',
    'delete'                                    => 'Usuń',
    'split'                                     => 'Podziel',
    'single_split'                              => 'Podział',
    'clone'                                     => 'Sklonuj',
    'clone_and_edit'                            => 'Sklonuj i modyfikuj',
    'confirm_action'                            => 'Potwierdź akcję',
    'last_seven_days'                           => 'Ostatnie 7 dni',
    'last_thirty_days'                          => 'Ostanie 30 dni',
    'last_180_days'                             => 'Ostatnie 180 dni',
    'month_to_date'                             => 'Miesiąc do daty',
    'year_to_date'                              => 'Rok do daty',
    'YTD'                                       => 'Od początku roku',
    'welcome_back'                              => 'Co jest grane?',
    'main_dashboard_page_title'                 => 'Strona główna',
    'everything'                                => 'Wszystko',
    'today'                                     => 'dzisiaj',
    'customRange'                               => 'Niestandardowy zakres',
    'date_range'                                => 'Zakres dat',
    'apply'                                     => 'Zastosuj',
    'select_date'                               => 'Wybierz datę...',
    'cancel'                                    => 'Anuluj',
    'from'                                      => 'Z',
    'to'                                        => 'Do',
    'structure'                                 => 'Struktura',
    'help_translating'                          => 'Tekst pomocy nie jest jeszcze dostępny po polsku. <a href="https://crowdin.com/project/firefly-iii-help"> Może chcesz pomóc w tłumaczeniu?</a>',
    'showEverything'                            => 'Pokaż wszystko',
    'never'                                     => 'Nigdy',
    'no_results_for_empty_search'               => 'Twoje zapytanie były puste, wiec nic nie zostało znalezione.',
    'removed_amount'                            => 'Usunięto :amount',
    'added_amount'                              => 'Dodano :amount',
    'asset_account_role_help'                   => 'Dodatkowe opcje wynikające z Twojego wyboru można ustawić później.',
    'Opening balance'                           => 'Bilans otwarcia',
    'create_new_stuff'                          => 'Utwórz nowe rzeczy',
    'new_withdrawal'                            => 'Nowa wypłata',
    'create_new_transaction'                    => 'Stwórz nową transakcję',
    'sidebar_frontpage_create'                  => 'Utwórz',
    'new_transaction'                           => 'Nowa transakcja',
    'no_rules_for_bill'                         => 'Ta subskrypcja nie ma przypisanych do niej reguł.',
    'go_to_asset_accounts'                      => 'Zobacz swoje konta aktywów',
    'go_to_budgets'                             => 'Przejdź do swoich budżetów',
    'go_to_withdrawals'                         => 'Przejdź do swoich wydatków',
    'clones_journal_x'                          => 'Ta transakcja jest sklonowana z transakcji ":description" (#:id)',
    'go_to_categories'                          => 'Przejdź do swoich kategorii',
    'go_to_bills'                               => 'Przejdź do swoich subskrypcji',
    'go_to_expense_accounts'                    => 'Zobacz swoje konta wydatków',
    'go_to_revenue_accounts'                    => 'Zobacz swoje konta przychodów',
    'go_to_piggies'                             => 'Przejdź do swoich skarbonek',
    'new_deposit'                               => 'Nowa wpłata',
    'new_transfer'                              => 'Nowy transfer',
    'new_transfers'                             => 'Nowy transfer',
    'new_asset_account'                         => 'Nowe konto aktywów',
    'new_expense_account'                       => 'Nowe konto wydatków',
    'new_revenue_account'                       => 'Nowe konto przychodów',
    'new_liabilities_account'                   => 'Nowe zobowiązanie',
    'new_budget'                                => 'Nowy budżet',
    'new_bill'                                  => 'Nowa subskrypcja',
    'block_account_logout'                      => 'Zostałeś wylogowany. Zablokowane konta nie mogą korzystać z tej strony. Czy zarejestrowałeś się z prawidłowym adresem e-mail?',
    'flash_success'                             => 'Sukces!',
    'flash_info'                                => 'Komunikat',
    'flash_warning'                             => 'Ostrzeżenie!',
    'flash_error'                               => 'Błąd!',
    'flash_danger'                              => 'Uwaga!',
    'flash_info_multiple'                       => 'Jest jedna wiadomość|Jest :count wiadomości',
    'flash_error_multiple'                      => 'Jest jeden błąd|Jest :count błędów',
    'net_worth'                                 => 'Wartość netto',
    'help_for_this_page'                        => 'Pomoc dla tej strony',
    'help_for_this_page_body'                   => 'Więcej informacji o tej stronie możesz znaleźć <a href="https://docs.firefly-iii.org/">w dokumentacji</a>.',
    'two_factor_welcome'                        => 'Cześć!',
    'two_factor_enter_code'                     => 'Aby kontynuować, wprowadź kod uwierzytelniania dwuskładnikowego. Twoja aplikacja może wygenerować go dla Ciebie.',
    'two_factor_code_here'                      => 'Wprowadź tutaj kod',
    'two_factor_title'                          => 'Weryfikacja dwuskładnikowa',
    'authenticate'                              => 'Uwierzytelnij',
    'two_factor_forgot_title'                   => 'Utracone uwierzytelnianie dwuskładnikowe',
    'two_factor_forgot'                         => 'Zapomniałem mojego uwierzytelnienia dwuskładnikowego.',
    'two_factor_lost_header'                    => 'Straciłeś uwierzytelnianie dwuskładnikowe?',
    'two_factor_lost_intro'                     => 'Jeżeli także nie masz kodów, to niestety nie masz szczęścia. To nie jest coś, co możemy naprawić z poziomu przeglądarki. Masz dwie opcje.',
    'two_factor_lost_fix_self'                  => 'Jeśli jesteś właścicielem tej instancji Firefly III, przeczytaj <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">ten rozdział w FAQ</a> aby uzyskać pomoc.',
    'two_factor_lost_fix_owner'                 => 'W przeciwnym razie, powiadom właściciela strony, <a href="mailto::site_owner">:site_owner</a> i poproś go o zresetowanie Twojego uwierzytelnienia dwuskładnikowego.',
    'mfa_backup_code'                           => 'Użyłeś kodu zapasowego do zalogowania się do Firefly III. Nie możesz go użyć ponownie, więc wykreśl go z listy.',
    'pref_two_factor_new_backup_codes'          => 'Wygeneruj nowe kody zapasowe',
    'pref_two_factor_backup_code_count'         => 'Masz :count poprawny kod zapasowy.|Masz :count poprawnych kodów zapasowych.',
    '2fa_i_have_them'                           => 'Kody zapisane!',
    'warning_much_data'                         => 'Załadowanie danych z :days dni może trochę potrwać.',
    'registered'                                => 'Zarejestrowałeś się pomyślnie!',
    'Default asset account'                     => 'Domyślne konto aktywów',
    'no_budget_pointer'                         => 'Wygląda na to, że nie masz jeszcze budżetów. Powinieneś utworzyć kilka na stronie <a href="budgets">budżetów</a>. Budżety mogą Ci pomóc śledzić wydatki.',
    'no_bill_pointer'                           => 'Wygląda na to, że nie masz jeszcze subskrypcji. Powinieneś utworzyć ją na stronie <a href="subscriptions">subskrypcji</a>. Subskrypcje mogą pomóc Ci śledzić wydatki.',
    'Savings account'                           => 'Konto oszczędnościowe',
    'Credit card'                               => 'Karta kredytowa',
    'source_accounts'                           => 'Konto źródłowe | Konta źródłowe',
    'destination_accounts'                      => 'Konto docelowe|Konta docelowe',
    'user_id_is'                                => 'Twój identyfikator użytkownika to <strong>:user</strong>',
    'field_supports_markdown'                   => 'To pole obsługuje <a href="https://pl.wikipedia.org/wiki/Markdown">Markdown</a>.',
    'need_more_help'                            => 'Jeśli potrzebujesz dodatkowej pomocy w korzystaniu z Firefly III, proszę <a href="https://github.com/firefly-iii/firefly-iii/issues">opisz go w zgłoszeniu na Githubie</a>.',
    'reenable_intro_text'                       => 'Możesz także ponownie włączyć <a href="#" id="reenableGuidance">samouczek</a>.',
    'intro_boxes_after_refresh'                 => 'Samouczek pojawi się po odświeżeniu strony.',
    'show_all_no_filter'                        => 'Pokaż wszystkie transakcje bez grupowania ich według daty.',
    'expenses_by_category'                      => 'Wydatki wg kategorii',
    'expenses_by_budget'                        => 'Wydatki wg budżetu',
    'income_by_category'                        => 'Dochody wg kategorii',
    'expenses_by_asset_account'                 => 'Wydatki wg kont aktywów',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III nie może Cię przekierować na właściwą stronę. Przepraszamy.',
    'sum_of_expenses'                           => 'Suma wydatków',
    'sum_of_income'                             => 'Suma dochodów',
    'liabilities'                               => 'Zobowiązania',
    'spent_in_specific_budget'                  => 'Wydatki w budżecie ":budget"',
    'spent_in_specific_double'                  => 'Wydano z kont(a) ":account"',
    'earned_in_specific_double'                 => 'Zarobiono na konto(a) ":account"',
    'source_account'                            => 'Konto źródłowe',
    'source_account_reconciliation'             => 'Nie możesz edytować konta źródłowego transakcji uzgadniania.',
    'destination_account'                       => 'Konto docelowe',
    'destination_account_reconciliation'        => 'Nie możesz edytować konta docelowego transakcji uzgadniania.',
    'sum_of_expenses_in_budget'                 => 'Wydano łącznie w budżecie ":budget"',
    'left_in_budget_limit'                      => 'Możliwe do wydania wg budżetu',
    'current_period'                            => 'Bieżący okres',
    'show_the_current_period_and_overview'      => 'Pokaż bieżący okres oraz przegląd',
    'pref_languages_locale'                     => 'Aby język inny niż angielski działał poprawnie, twój system operacyjny musi być wyposażony w odpowiednie informacje o lokalizacji. Jeśli nie są one obecne, dane walutowe, daty i kwoty mogą być źle sformatowane.',
    'budget_in_period'                          => 'Wszystkie transakcje dla budżetu ":name" od :start do :end w :currency',
    'chart_budget_in_period'                    => 'Wykres wszystkich transakcji dla budżetu ":name" od :start do :end w :currency',
    'chart_budget_in_period_only_currency'      => 'Kwota zaplanowanego budżetu była w :currency, więc ten wykres pokaże transakcje tylko w :currency.',
    'chart_account_in_period'                   => 'Wykres wszystkich transakcji dla konta ":name" (:balance) od :start do :end',
    'chart_category_in_period'                  => 'Wykres wszystkich transakcji dla kategorii ":name" od :start do :end',
    'chart_category_all'                        => 'Wykres wszystkich transakcji dla kategorii ":name"',
    'clone_withdrawal'                          => 'Zduplikuj tę wypłatę',
    'clone_deposit'                             => 'Zduplikuj tą wpłatę',
    'clone_transfer'                            => 'Zduplikuj ten transfer',
    'multi_select_no_selection'                 => 'Nie wybrano',
    'multi_select_select_all'                   => 'Zaznacz wszystkie',
    'multi_select_n_selected'                   => 'wybrane',
    'multi_select_all_selected'                 => 'Wybrano wszystko',
    'multi_select_filter_placeholder'           => 'Znajdź...',
    'intro_next_label'                          => 'Dalej',
    'intro_prev_label'                          => 'Wstecz',
    'intro_skip_label'                          => 'Pomiń',
    'intro_done_label'                          => 'Gotowe',
    'between_dates_breadcrumb'                  => 'Pomiędzy :start a :end',
    'all_journals_without_budget'               => 'Wszystkie transakcje bez budżetu',
    'journals_without_budget'                   => 'Transakcje bez budżetu',
    'all_journals_without_category'             => 'Wszystkie transakcje bez kategorii',
    'journals_without_category'                 => 'Transakcje bez kategorii',
    'all_journals_for_account'                  => 'Wszystkie transakcje dla konta :name',
    'chart_all_journals_for_account'            => 'Wykres wszystkich transakcji dla konta :name',
    'journals_in_period_for_account'            => 'Wszystkie transakcje dla konta :name od :start do :end',
    'journals_in_period_for_account_js'         => 'Wszystkie transakcje dla konta {title} od {start} do {end}',
    'transferred'                               => 'Przesłano',
    'all_withdrawal'                            => 'Wszystkie wydatki',
    'all_transactions'                          => 'Wszystkie transakcje',
    'title_withdrawal_between'                  => 'Wszystkie wydatki do :start do :end',
    'all_deposit'                               => 'Wszystkie przychody',
    'title_deposit_between'                     => 'Wszystkie przychody do :start do :end',
    'all_transfers'                             => 'Wszystkie transfery',
    'title_transfers_between'                   => 'Wszystkie transfery od :start do :end',
    'all_transfer'                              => 'Wszystkie transfery',
    'all_journals_for_tag'                      => 'Wszystkie transakcje dla tagu ":tag"',
    'title_transfer_between'                    => 'Wszystkie transfery od :start do :end',
    'all_journals_for_category'                 => 'Wszystkie transakcje dla kategorii :name',
    'all_journals_for_budget'                   => 'Wszystkie transakcje dla budżetu :name',
    'chart_all_journals_for_budget'             => 'Wykres wszystkich transakcji dla budżetu :name',
    'journals_in_period_for_category'           => 'Wszystkie transakcje dla kategorii :name od :start do :end',
    'journals_in_period_for_tag'                => 'Wszystkie transakcje dla tagu :tag od :start do :end',
    'not_available_demo_user'                   => 'Funkcja, do której próbujesz uzyskać dostęp nie jest dostępna dla użytkowników demo.',
    'exchange_rate_instructions'                => 'Konto aktywów "@name" obsługuje tylko transakcje w walucie @primary_currency. Jeśli chcesz użyć waluty @foreign_currency, upewnij się, że kwota w @primary_currency jest również znana:',
    'transfer_exchange_rate_instructions'       => 'Konto źródłowe "@source_name" obsługuje tylko transakcje w walucie @source_currency. Konto docelowe "@dest_name" obsługuje tylko transakcje w walucie @dest_currency. Musisz podać przelewaną kwotę w obu walutach.',
    'transaction_data'                          => 'Dane transakcji',
    'invalid_server_configuration'              => 'Nieprawidłowa konfiguracja serwera',
    'invalid_locale_settings'                   => 'Firefly III nie może sformatować kwot pieniężnych, ponieważ na Twoim serwerze brakuje wymaganych pakietów. Sprawdź <a href="">instrukcje jak je zainstalować</a> (po angielsku).',
    'quickswitch'                               => 'Szybki przełącznik',
    'sign_in_to_start'                          => 'Zaloguj się, aby rozpocząć sesję',
    'sign_in'                                   => 'Zaloguj',
    'register_new_account'                      => 'Zarejestruj nowe konto',
    'forgot_my_password'                        => 'Nie pamiętam hasła',
    'problems_with_input'                       => 'Wystąpił problem z wprowadzonymi danymi.',
    'reset_password'                            => 'Zresetuj swoje hasło',
    'button_reset_password'                     => 'Zresetuj hasło',
    'reset_button'                              => 'Zresetuj',
    'want_to_login'                             => 'Chcę się zalogować',
    'login_page_title'                          => 'Zaloguj się do Firefly III',
    'register_page_title'                       => 'Zarejestruj się w Firefly III',
    'forgot_pw_page_title'                      => 'Nie pamiętam hasła do Firefly III',
    'reset_pw_page_title'                       => 'Resetowanie hasła do Firefly III',
    'cannot_reset_demo_user'                    => 'Nie można zresetować hasła dla użytkownika demonstracyjnego.',
    'no_att_demo_user'                          => 'Użytkownik demonstracyjny nie może przesyłać załączników.',
    'button_register'                           => 'Zarejestruj',
    'authorization'                             => 'Autoryzacja',
    'active_bills_only'                         => 'tylko aktywne subskrypcje',
    'active_bills_only_total'                   => 'wszystkie aktywne subskrypcje',
    'active_exp_bills_only'                     => 'tylko aktywne i oczekiwane subskrypcje',
    'active_exp_bills_only_total'               => 'tylko wszystkie aktywne i oczekiwane subskrypcje',
    'per_period_sum_1D'                         => 'Oczekiwane koszty dzienne',
    'per_period_sum_1W'                         => 'Oczekiwane koszty tygodniowe',
    'per_period_sum_1M'                         => 'Przewidywane koszty miesięczne',
    'per_period_sum_3M'                         => 'Oczekiwane koszty kwartalne',
    'per_period_sum_6M'                         => 'Oczekiwane koszty półroczne',
    'per_period_sum_1Y'                         => 'Oczekiwane koszty roczne',
    'average_per_bill'                          => 'średnia na subskrypcję',
    'expected_total'                            => 'oczekiwana suma',
    'reconciliation_account_name'               => 'Uzgadnianie :name (:currency)',
    'saved'                                     => 'Zapisano',
    'advanced_options'                          => 'Opcje zaawansowane',
    'advanced_options_explain'                  => 'Niektóre strony w Firefly III mają zaawansowane opcje ukryte pod tym przyciskiem. Ta strona niestety nie ma nic, ale sprawdź inne!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III wykrył, że masz transakcje sprzed roku 1970 r. Proszę, popraw te transakcje jak najszybciej jak to możliwe.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooki',
    'webhooks_breadcrumb'                       => 'Webhooki',
    'webhooks_menu_disabled'                    => 'wyłączone',
    'no_webhook_messages'                       => 'Brak wiadomości webhook',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Po utworzeniu transakcji',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Po zmodyfikowaniu transakcji',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Po usunięciu transakcji',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Szczegóły transakcji',
    'webhook_response_ACCOUNTS'                 => 'Szczegóły konta',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Zbadaj',
    'create_new_webhook'                        => 'Utwórz nowy webhook',
    'webhooks_create_breadcrumb'                => 'Utwórz nowy webhook',
    'webhook_trigger_form_help'                 => 'Wskaż zdarzenie do wyzwolenia webhook\'a',
    'webhook_response_form_help'                => 'Wskaż, co webhook musi przesłać do adresu URL.',
    'webhook_delivery_form_help'                => 'W jakim formacie webhook musi dostarczać dane.',
    'webhook_active_form_help'                  => 'Webhook musi być aktywny lub nie zostanie wywołany.',
    'stored_new_webhook'                        => 'Zapisano nowy webhook ":title"',
    'delete_webhook'                            => 'Usuń webhook',
    'deleted_webhook'                           => 'Usunięto webhook ":title"',
    'edit_webhook'                              => 'Edytuj webhook ":title"',
    'updated_webhook'                           => 'Zaktualizowano webhook ":title"',
    'edit_webhook_js'                           => 'Edytuj webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Webhook został uruchomiony na wskazanej transakcji. Poczekaj na wyniki.',
    'webhook_messages'                          => 'Wiadomość webhook\'a',
    'view_message'                              => 'Podgląd wiadomości',
    'view_attempts'                             => 'Podgląd nieudanych prób',
    'message_content_title'                     => 'Treść wiadomości webhook\'a',
    'message_content_help'                      => 'To jest zawartość wiadomości, która została wysłana (lub próbowano wysłać) za pomocą tego webhooka.',
    'attempt_content_title'                     => 'Próby dostępu do webhook',
    'attempt_content_help'                      => 'To są wszystkie nieudane próby przesłania tej wiadomości webhooka do skonfigurowanego adresu URL. Po pewnym czasie Firefly III przestanie próbować.',
    'no_attempts'                               => 'Nie ma nieudanych prób. To dobrze!',
    'webhook_attempt_at'                        => 'Próba o {moment}',
    'logs'                                      => 'Logi',
    'response'                                  => 'Odpowiedź',
    'visit_webhook_url'                         => 'Odwiedź adres URL webhooka',
    'reset_webhook_secret'                      => 'Resetuj sekret webhooka',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> został zapisany.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") został zaktualizowany.',

    // API access
    'authorization_request'                     => 'Żądanie autoryzacji Firefly III v:version',
    'authorization_request_intro'               => 'Aplikacja <strong>:client</strong> prosi o pozwolenie na dostęp do Twojej administracji finansowej. Czy chcesz pozwolić <strong>:client</strong> na dostęp do tych danych?',
    'authorization_request_site'                => 'Zostaniesz przekierowany do <code>:url</code>, który będzie mógł uzyskać dostęp do danych Firefly III.',
    'authorization_request_invalid'             => 'Ta prośba o dostęp jest nieprawidłowa. Proszę nigdy więcej nie klikaj tego linku.',
    'scopes_will_be_able'                       => 'Ta aplikacja będzie mogła:',
    'button_authorize'                          => 'Autoryzuj',
    'none_in_select_list'                       => '(żadne)',
    'no_piggy_bank'                             => '(brak skarbonki)',
    'name_in_currency'                          => ':name w :currency',
    'paid_in_currency'                          => 'Zapłacone w :currency',
    'unpaid_in_currency'                        => 'Niezapłacone w :currency',
    'is_alpha_warning'                          => 'Używasz wersji ALPHA. Uważaj na błędy i problemy.',
    'is_beta_warning'                           => 'Używasz wersji BETA. Uważaj na błędy i problemy.',
    'all_destination_accounts'                  => 'Konta docelowe',
    'all_source_accounts'                       => 'Konta źródłowe',
    'back_to_index'                             => 'Wróć do indeksu',
    'cant_logout_guard'                         => 'Firefly III nie może cię wylogować.',
    'internal_reference'                        => 'Wewnętrzne odwołanie',

    // check for updates:
    'update_check_title'                        => 'Sprawdź aktualizacje',
    'admin_update_check_title'                  => 'Automatycznie sprawdzaj dostępność aktualizacji',
    'admin_update_check_explain'                => 'Firefly III może automatycznie sprawdzać dostępność aktualizacji. Po włączeniu tej opcji będzie kontaktować się z serwerem aktualizacji w celu sprawdzenia czy dostępna jest nowa wersja Firefly III. Jeżeli będzie, otrzymasz powiadomienie. Możesz przetestować to powiadomienie używając przycisku po prawej stronie. Wskaż proszę czy chcesz, aby Firefly III sprawdzało dostępność aktualizacji.',
    'check_for_updates_permission'              => 'Firefly III może sprawdzić dostępność aktualizacji, ale potrzebuje Twojej zgody, aby to robić. Przejdź do <a href=":link">ustawień</a>, aby określić, czy ta funkcja ma być włączona.',
    'updates_ask_me_later'                      => 'Zapytaj mnie później',
    'updates_do_not_check'                      => 'Nie sprawdzaj dostępności aktualizacji',
    'updates_enable_check'                      => 'Włącz sprawdzanie aktualizacji',
    'admin_update_check_now_title'              => 'Sprawdź dostępność aktualizacji',
    'admin_update_check_now_explain'            => 'Jeśli naciśniesz przycisk, Firefly III sprawdzi, czy używasz najnowszej wersji.',
    'check_for_updates_button'                  => 'Sprawdź teraz!',
    'update_new_version_alert'                  => 'Dostępna jest nowa wersja Firefly III. Używasz wersji :your_version, najnowsza wersja to :new_version wydana :date.',
    'update_version_beta'                       => 'Ta wersja jest wersją BETA. Możesz napotkać błędy.',
    'update_version_alpha'                      => 'Ta wersja jest wersją ALPHA. Możesz napotkać błędy.',
    'update_current_dev_older'                  => 'Używasz wersji deweloperskiej ":version", która jest starsza niż najnowsza wersja :new_version. Zalecana aktualizacja!',
    'update_current_dev_newer'                  => 'Używasz wersji deweloperskiej ":version", która jest nowsza niż ostatnia wersja :new_version.',
    'update_current_version_alert'              => 'Używasz wersji :version, która jest najnowszą dostępną wersją.',
    'update_newer_version_alert'                => 'Używasz wersji :your_version, która jest nowsza niż najnowsza wersja, :new_version.',
    'update_check_error'                        => 'Wystąpił błąd podczas sprawdzania aktualizacji :error',
    'unknown_error'                             => 'Nieznany błąd. Przepraszamy za to.',
    'disabled_but_check'                        => 'Wyłączyłeś sprawdzanie aktualizacji. Więc nie zapomnij sprawdzać aktualizacji osobiście od czasu do czasu. Dziękujemy!',
    'admin_update_channel_title'                => 'Kanał aktualizacji',
    'admin_update_channel_explain'              => 'Firefly III posiada trzy "kanały", które decydują jak wczesnej pod względem funkcji, ulepszeń i błędów wersji używasz. Użyj kanału "beta", jeśli lubisz przygody i "alfa", gdy lubisz żyć niebezpiecznie.',
    'update_channel_stable'                     => 'Stabilne. Wszystko powinno działać zgodnie z oczekiwaniami.',
    'update_channel_beta'                       => 'Beta. Nowe funkcje, ale niektóre funkcje mogą nie działać poprawnie.',
    'update_channel_alpha'                      => 'Alfa. Rzucamy różne rzeczy i zostawiamy to, co się przyklei.',

    // search
    'search'                                    => 'Szukaj',
    'search_query'                              => 'Zapytanie',
    'search_found_transactions'                 => 'Firefly III znalazł :count transakcję w :time sekund.|Firefly III znalazł :count transakcji w :time sekund.',
    'search_found_more_transactions'            => 'Firefly III znalazł więcej niż :count transakcji w :time sekund.',
    'search_for_overview'                       => 'Firefly III szuka transakcji, które spełniają <b>wszystkie</b> z następujących warunków:',
    'search_for_query'                          => 'Wszystkie te słowa muszą być obecne: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Żadne z tych słów nie może być obecne: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Te parametry wyszukiwania nie są prawidłowe i zostały zignorowane.',

    // old


    'search_modifier_date_on'                             => 'Data transakcji to ":value"',
    'search_modifier_not_date_on'                         => 'Data transakcji to nie ":value"',
    'search_modifier_reconciled'                          => 'Transakcja została uzgodniona',
    'search_modifier_not_reconciled'                      => 'Transakcja nie została uzgodniona',
    'search_modifier_id'                                  => 'ID transakcji to ":value"',
    'search_modifier_not_id'                              => 'ID transakcji to nie ":value"',
    'search_modifier_date_before'                         => 'Data transakcji jest przed lub w ":value"',
    'search_modifier_date_after'                          => 'Data transakcji jest po lub w ":value"',
    'search_modifier_external_id_is'                      => 'Zewnętrzne ID to ":value"',
    'search_modifier_not_external_id_is'                  => 'Zewnętrzne ID to nie ":value"',
    'search_modifier_no_external_url'                     => 'Transakcja nie ma zewnętrznego adresu URL',
    'search_modifier_no_external_id'                      => 'Transakcja nie ma zewnętrznego ID',
    'search_modifier_not_any_external_url'                => 'Transakcja nie ma zewnętrznego adresu URL',
    'search_modifier_not_any_external_id'                 => 'Transakcja nie ma zewnętrznego ID',
    'search_modifier_any_external_url'                    => 'Transakcja musi mieć (dowolny) zewnętrzny adres URL',
    'search_modifier_any_external_id'                     => 'Transakcja musi mieć (dowolne) zewnętrzne ID',
    'search_modifier_not_no_external_url'                 => 'Transakcja musi mieć (dowolny) zewnętrzny adres URL',
    'search_modifier_not_no_external_id'                  => 'Transakcja musi mieć (dowolne) zewnętrzne ID',
    'search_modifier_internal_reference_is'               => 'Wewnętrzne odwołanie to ":value"',
    'search_modifier_not_internal_reference_is'           => 'Wewnętrzne odwołanie to nie ":value"',
    'search_modifier_description_starts'                  => 'Opis zaczyna się od ":value"',
    'search_modifier_not_description_starts'              => 'Opis nie zaczyna się od ":value"',
    'search_modifier_description_ends'                    => 'Opis kończy się na ":value"',
    'search_modifier_not_description_ends'                => 'Opis nie kończy się na ":value"',
    'search_modifier_description_contains'                => 'Opis zawiera ":value"',
    'search_modifier_not_description_contains'            => 'Opis nie zawiera ":value"',
    'search_modifier_description_is'                      => 'Opis to ":value"',
    'search_modifier_not_description_is'                  => 'Opis nie jest dokładnie ":value"',
    'search_modifier_currency_is'                         => 'Waluta (obca) transakcji to ":value"',
    'search_modifier_not_currency_is'                     => 'Waluta (obca) transakcji to nie ":value"',
    'search_modifier_foreign_currency_is'                 => 'Waluta obca transakcji to ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Waluta obca transakcji to nie ":value"',
    'search_modifier_has_attachments'                     => 'Transakcja musi mieć załącznik',
    'search_modifier_has_no_category'                     => 'Transakcja nie może mieć kategorii',
    'search_modifier_not_has_no_category'                 => 'Transakcja musi mieć (dowolną) kategorię',
    'search_modifier_not_has_any_category'                => 'Transakcja nie może mieć kategorii',
    'search_modifier_has_any_category'                    => 'Transakcja musi mieć (dowolną) kategorię',
    'search_modifier_has_no_budget'                       => 'Transakcja nie może mieć budżetu',
    'search_modifier_not_has_any_budget'                  => 'Transakcja nie może mieć budżetu',
    'search_modifier_has_any_budget'                      => 'Transakcja musi mieć (dowolny) budżet',
    'search_modifier_not_has_no_budget'                   => 'Transakcja musi mieć (dowolny) budżet',
    'search_modifier_has_no_bill'                         => 'Transakcja nie może mieć subskrypcji',
    'search_modifier_not_has_no_bill'                     => 'Transakcja musi mieć (dowolną) subskrypcję',
    'search_modifier_has_any_bill'                        => 'Transakcja musi mieć (dowolną) subskrypcję',
    'search_modifier_not_has_any_bill'                    => 'Transakcja nie może mieć subskrypcji',
    'search_modifier_has_no_tag'                          => 'Transakcja nie może mieć tagów',
    'search_modifier_not_has_any_tag'                     => 'Transakcja nie może mieć tagów',
    'search_modifier_not_has_no_tag'                      => 'Transakcja musi mieć (dowolny) tag',
    'search_modifier_has_any_tag'                         => 'Transakcja musi mieć (dowolny) tag',
    'search_modifier_notes_contains'                      => 'Notatki transakcji zawierają ":value"',
    'search_modifier_not_notes_contains'                  => 'Notatki transakcji nie zawierają ":value"',
    'search_modifier_notes_starts'                        => 'Notatki transakcji zaczynają się od ":value"',
    'search_modifier_not_notes_starts'                    => 'Notatki transakcji nie zaczynają się od ":value"',
    'search_modifier_notes_ends'                          => 'Notatki transakcji kończą się na ":value"',
    'search_modifier_not_notes_ends'                      => 'Notatki transakcji nie kończą się na ":value"',
    'search_modifier_notes_is'                            => 'Notatki transakcji to ":value"',
    'search_modifier_not_notes_is'                        => 'Notatki transakcji nie są dokładnie ":value"',
    'search_modifier_no_notes'                            => 'Transakcja nie ma notatek',
    'search_modifier_not_no_notes'                        => 'Transakcja musi zawierać notatki',
    'search_modifier_any_notes'                           => 'Transakcja musi zawierać notatki',
    'search_modifier_not_any_notes'                       => 'Transakcja nie ma notatek',
    'search_modifier_amount_is'                           => 'Kwota to dokładnie :value',
    'search_modifier_not_amount_is'                       => 'Kwota to nie :value',
    'search_modifier_amount_less'                         => 'Kwota jest mniejsza lub równa :value',
    'search_modifier_not_amount_more'                     => 'Kwota jest mniejsza lub równa :value',
    'search_modifier_amount_more'                         => 'Kwota jest większa lub równa :value',
    'search_modifier_not_amount_less'                     => 'Kwota jest większa lub równa :value',
    'search_modifier_source_account_is'                   => 'Konto źródłowe to ":value"',
    'search_modifier_not_source_account_is'               => 'Nazwa konta źródłowego to ":value"',
    'search_modifier_source_account_contains'             => 'Konto źródłowe zawiera ":value"',
    'search_modifier_not_source_account_contains'         => 'Nazwa konta źródłowego nie zawiera ":value"',
    'search_modifier_source_account_starts'               => 'Konto źródłowe zaczyna się od ":value"',
    'search_modifier_not_source_account_starts'           => 'Nazwa konta źródłowego nie zaczyna się od ":value"',
    'search_modifier_source_account_ends'                 => 'Konto źródłowe kończy się na ":value"',
    'search_modifier_not_source_account_ends'             => 'Nazwa konta źródłowego nie kończy się na ":value"',
    'search_modifier_source_account_id'                   => 'ID konta źródłowego to :value',
    'search_modifier_not_source_account_id'               => 'ID konta źródłowego to nie :value',
    'search_modifier_source_account_nr_is'                => 'Numer konta źródłowego (IBAN) to ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Numer konta źródłowego (IBAN) to nie ":value"',
    'search_modifier_source_account_nr_contains'          => 'Numer konta źródłowego (IBAN) zawiera ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Numer konta źródłowego (IBAN) nie zawiera ":value"',
    'search_modifier_source_account_nr_starts'            => 'Numer konta źródłowego (IBAN) zaczyna się od ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Numer konta źródłowego (IBAN) nie zaczyna się od ":value"',
    'search_modifier_source_account_nr_ends'              => 'Numer konta źródłowego (IBAN) kończy się na ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Numer konta źródłowego (IBAN) nie kończy się na ":value"',
    'search_modifier_destination_account_is'              => 'Nazwa konta docelowego to ":value"',
    'search_modifier_not_destination_account_is'          => 'Nazwa konta docelowego to nie ":value"',
    'search_modifier_destination_account_contains'        => 'Nazwa konta docelowego zawiera ":value"',
    'search_modifier_not_destination_account_contains'    => 'Nazwa konta docelowego nie zawiera ":value"',
    'search_modifier_destination_account_starts'          => 'Nazwa konta docelowego zaczyna się od ":value"',
    'search_modifier_not_destination_account_starts'      => 'Nazwa konta docelowego nie zaczyna się od ":value"',
    'search_modifier_destination_account_ends'            => 'Nazwa konta docelowego kończy się na ":value"',
    'search_modifier_not_destination_account_ends'        => 'Nazwa konta docelowego nie kończy się na ":value"',
    'search_modifier_destination_account_id'              => 'ID konta docelowego to :value',
    'search_modifier_not_destination_account_id'          => 'ID konta docelowego to nie :value',
    'search_modifier_destination_is_cash'                 => 'Konto docelowe to konto "(gotówka)"',
    'search_modifier_not_destination_is_cash'             => 'Konto docelowe nie jest kontem "(gotówka)"',
    'search_modifier_source_is_cash'                      => 'Konto źródłowe to konto "(gotówka)"',
    'search_modifier_not_source_is_cash'                  => 'Konto źródłowe to nie konto "(gotówka)"',
    'search_modifier_destination_account_nr_is'           => 'Numer konta docelowego (IBAN) to ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Numer konta docelowego (IBAN) to ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Numer konta docelowego (IBAN) zawiera ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Numer konta docelowego (IBAN) nie zawiera ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Numer konta docelowego (IBAN) zaczyna się od ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Numer konta docelowego (IBAN) nie zaczyna się od ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Numer konta docelowego (IBAN) kończy się na ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Numer konta docelowego (IBAN) nie kończy się na ":value"',
    'search_modifier_account_id'                          => 'ID konta źródłowego lub docelowego to: :value',
    'search_modifier_not_account_id'                      => 'ID konta źródłowego lub docelowego to nie: :value',
    'search_modifier_category_is'                         => 'Kategoria to ":value"',
    'search_modifier_not_category_is'                     => 'Kategoria to nie ":value"',
    'search_modifier_budget_is'                           => 'Budżet to ":value"',
    'search_modifier_not_budget_is'                       => 'Budżet to nie ":value"',
    'search_modifier_bill_is'                             => 'Subskrypcja to ":value"',
    'search_modifier_not_bill_is'                         => 'Subskrypcja to nie ":value"',
    'search_modifier_transaction_type'                    => 'Transakcja jest typu ":value"',
    'search_modifier_not_transaction_type'                => 'Typ transakcji to nie ":value"',
    'search_modifier_tag_is'                              => 'Tag to ":value"',
    'search_modifier_tag_contains'                        => 'Tag zawiera ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag nie zawiera ":value"',
    'search_modifier_tag_ends'                            => 'Tag kończy się na ":value"',
    'search_modifier_tag_starts'                          => 'Tag zaczyna się od ":value"',
    'search_modifier_not_tag_is'                          => 'Tag nie jest ustawiony na ":value"',
    'search_modifier_date_on_year'                        => 'Transakcja jest w roku ":value"',
    'search_modifier_not_date_on_year'                    => 'Transakcja nie jest w roku ":value"',
    'search_modifier_date_on_month'                       => 'Transakcja jest w miesiącu ":value"',
    'search_modifier_not_date_on_month'                   => 'Transakcja nie jest w miesiącu ":value"',
    'search_modifier_date_on_day'                         => 'Transakcja jest w dniu miesiąca ":value"',
    'search_modifier_not_date_on_day'                     => 'Transakcja nie jest w dniu miesiąca ":value"',
    'search_modifier_date_before_year'                    => 'Transakcja jest przed lub w roku ":value"',
    'search_modifier_date_before_month'                   => 'Transakcja jest przed lub w miesiącu ":value"',
    'search_modifier_date_before_day'                     => 'Transakcja jest przed lub w dniu miesiąca ":value"',
    'search_modifier_date_after_year'                     => 'Transakcja jest w roku lub po roku ":value"',
    'search_modifier_date_after_month'                    => 'Transakcja jest w miesiącu lub po miesiącu ":value"',
    'search_modifier_date_after_day'                      => 'Transakcja jest po lub w dniu miesiąca ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Tag nie jest ustawiony na ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag to ":value"',
    'search_modifier_account_is'                          => 'Konto to ":value"',
    'search_modifier_not_account_is'                      => 'Żadne z kont nie jest ":value"',
    'search_modifier_account_contains'                    => 'Konto zawiera ":value"',
    'search_modifier_not_account_contains'                => 'Żadne z kont nie zawiera ":value"',
    'search_modifier_account_ends'                        => 'Konto kończy się na ":value"',
    'search_modifier_not_account_ends'                    => 'Nazwa żadnego konta nie kończy się na ":value"',
    'search_modifier_account_starts'                      => 'Konto zaczyna się od ":value"',
    'search_modifier_not_account_starts'                  => 'Nazwa żadnego konta nie zaczyna się na ":value"',
    'search_modifier_account_nr_is'                       => 'Numer konta / IBAN to ":value"',
    'search_modifier_not_account_nr_is'                   => 'Żaden numer konta / IBAN nie jest ":value"',
    'search_modifier_account_nr_contains'                 => 'Numer konta / IBAN zawiera ":value"',
    'search_modifier_not_account_nr_contains'             => 'Żaden numer konta / IBAN nie zawiera ":value"',
    'search_modifier_account_nr_ends'                     => 'Numer konta / IBAN kończy się na ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Żaden numer konta / IBAN nie kończy się na ":value"',
    'search_modifier_account_nr_starts'                   => 'Numer konta / IBAN zaczyna się od ":value"',
    'search_modifier_not_account_nr_starts'               => 'Żaden numer konta / IBAN nie zaczyna się na ":value"',
    'search_modifier_category_contains'                   => 'Kategoria zawiera ":value"',
    'search_modifier_not_category_contains'               => 'Kategoria nie zawiera ":value"',
    'search_modifier_category_ends'                       => 'Kategoria kończy się na ":value"',
    'search_modifier_not_category_ends'                   => 'Kategoria nie kończy się na ":value"',
    'search_modifier_category_starts'                     => 'Kategoria zaczyna się od ":value"',
    'search_modifier_not_category_starts'                 => 'Kategoria zaczyna się na ":value"',
    'search_modifier_budget_contains'                     => 'Budżet zawiera ":value"',
    'search_modifier_not_budget_contains'                 => 'Budżet nie zawiera ":value"',
    'search_modifier_budget_ends'                         => 'Budżet kończy się na ":value"',
    'search_modifier_not_budget_ends'                     => 'Budżet nie kończy się na ":value"',
    'search_modifier_budget_starts'                       => 'Budżet zaczyna się od ":value"',
    'search_modifier_not_budget_starts'                   => 'Budżet nie zaczyna się od ":value"',
    'search_modifier_bill_contains'                       => 'Subskrypcja zawiera ":value"',
    'search_modifier_not_bill_contains'                   => 'Subskrypcja nie zawiera ":value"',
    'search_modifier_bill_ends'                           => 'Subskrypcja kończy się na ":value"',
    'search_modifier_not_bill_ends'                       => 'Subskrypcja nie kończy się na ":value"',
    'search_modifier_bill_starts'                         => 'Subskrypcja zaczyna się od ":value"',
    'search_modifier_not_bill_starts'                     => 'Subskrypcja nie zaczyna się od ":value"',
    'search_modifier_external_id_contains'                => 'Zewnętrzne ID zawiera ":value"',
    'search_modifier_not_external_id_contains'            => 'Zewnętrzne ID nie zawiera ":value"',
    'search_modifier_external_id_ends'                    => 'Zewnętrzne ID kończy się na ":value"',
    'search_modifier_not_external_id_ends'                => 'Zewnętrzne ID nie kończy się na ":value"',
    'search_modifier_external_id_starts'                  => 'Zewnętrzne ID zaczyna się od ":value"',
    'search_modifier_not_external_id_starts'              => 'Zewnętrzne ID nie zaczyna się od ":value"',
    'search_modifier_internal_reference_contains'         => 'Wewnętrzne odwołanie zawiera ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Wewnętrzne odwołanie nie zawiera ":value"',
    'search_modifier_internal_reference_ends'             => 'Wewnętrzne odwołanie kończy się na ":value"',
    'search_modifier_internal_reference_starts'           => 'Wewnętrzne odwołanie zaczyna się od ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Wewnętrzne odwołanie nie kończy się na ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Wewnętrzne odwołanie nie zaczyna się od ":value"',
    'search_modifier_external_url_is'                     => 'Zewnętrzny adres URL to ":value"',
    'search_modifier_not_external_url_is'                 => 'Zewnętrzny adres URL to nie ":value"',
    'search_modifier_external_url_contains'               => 'Zewnętrzny adres URL zawiera ":value"',
    'search_modifier_not_external_url_contains'           => 'Zewnętrzny adres URL nie zawiera ":value"',
    'search_modifier_external_url_ends'                   => 'Zewnętrzny adres URL kończy się na ":value"',
    'search_modifier_not_external_url_ends'               => 'Zewnętrzny adres URL nie kończy się na ":value"',
    'search_modifier_external_url_starts'                 => 'Zewnętrzny adres URL zaczyna się od ":value"',
    'search_modifier_not_external_url_starts'             => 'Zewnętrzny adres URL nie zaczyna się od ":value"',
    'search_modifier_has_no_attachments'                  => 'Transakcja nie ma załączników',
    'search_modifier_not_has_no_attachments'              => 'Transakcja ma załączniki',
    'search_modifier_not_has_attachments'                 => 'Transakcja nie ma załączników',
    'search_modifier_account_is_cash'                     => 'Dowolne konto jest kontem "(cash)".',
    'search_modifier_not_account_is_cash'                 => 'Żadne konto nie jest kontem "(cash)".',
    'search_modifier_journal_id'                          => 'ID dziennika to ":value"',
    'search_modifier_not_journal_id'                      => 'ID dziennika to nie ":value"',
    'search_modifier_recurrence_id'                       => 'ID transakcji cyklicznej to ":value"',
    'search_modifier_not_recurrence_id'                   => 'ID transakcji cyklicznej to nie ":value"',
    'search_modifier_foreign_amount_is'                   => 'Kwota obca to ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Kwota obca to nie ":value"',
    'search_modifier_foreign_amount_less'                 => 'Kwota obca jest mniejsza niż ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Kwota obca jest mniejsza niż ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Kwota obca jest większa niż ":value"',
    'search_modifier_foreign_amount_more'                 => 'Kwota obca jest większa niż ":value"',
    'search_modifier_exists'                              => 'Transakcja istnieje (dowolna transakcja)',
    'search_modifier_not_exists'                          => 'Transakcja nie istnieje (brak transakcji)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Data odsetek transakcji to ":value"',
    'search_modifier_not_interest_date_on'                => 'Data odsetek transakcji to nie ":value"',
    'search_modifier_interest_date_on_year'               => 'Data odsetek transakcji jest w roku ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Data odsetek transakcji nie jest w roku ":value"',
    'search_modifier_interest_date_on_month'              => 'Data odsetek transakcji jest w miesiącu ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Data odsetek transakcji nie jest w miesiącu ":value"',
    'search_modifier_interest_date_on_day'                => 'Data odsetek transakcji przypada w dniu miesiąca ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Data odsetek transakcji nie przypada w dniu miesiąca ":value"',
    'search_modifier_interest_date_before_year'           => 'Data odsetek transakcji jest przed lub w roku ":value"',
    'search_modifier_interest_date_before_month'          => 'Data odsetek transakcji jest przed lub w miesiącu ":value"',
    'search_modifier_interest_date_before_day'            => 'Data odsetek transakcji jest przed lub w dniu miesiąca ":value"',
    'search_modifier_interest_date_after_year'            => 'Data odsetek transakcji jest po lub w roku ":value"',
    'search_modifier_interest_date_after_month'           => 'Data odsetek transakcji jest po lub w miesiącu ":value"',
    'search_modifier_interest_date_after_day'             => 'Data odsetek transakcji jest po lub w dniu miesiąca ":value"',
    'search_modifier_book_date_on_year'                   => 'Data księgowania transakcji jest w roku ":value"',
    'search_modifier_book_date_on_month'                  => 'Data księgowania transakcji jest w miesiącu ":value"',
    'search_modifier_book_date_on_day'                    => 'Data księgowania transakcji przypada w dniu miesiąca ":value"',
    'search_modifier_not_book_date_on_year'               => 'Data księgowania transakcji nie jest w roku ":value"',
    'search_modifier_not_book_date_on_month'              => 'Data księgowania transakcji nie jest w miesiącu ":value"',
    'search_modifier_not_book_date_on_day'                => 'Data księgowania transakcji nie przypada w dniu miesiąca ":value"',
    'search_modifier_book_date_before_year'               => 'Data księgowania transakcji jest przed lub w roku ":value"',
    'search_modifier_book_date_before_month'              => 'Data księgowania transakcji jest przed lub w miesiącu ":value"',
    'search_modifier_book_date_before_day'                => 'Data księgowania transakcji jest przed lub w dniu miesiąca ":value"',
    'search_modifier_book_date_after_year'                => 'Data księgowania transakcji jest po lub w roku ":value"',
    'search_modifier_book_date_after_month'               => 'Data księgowania transakcji jest po lub w miesiącu ":value"',
    'search_modifier_book_date_after_day'                 => 'Data księgowania transakcji jest po lub w dniu miesiąca ":value"',
    'search_modifier_process_date_on_year'                => 'Data przetworzenia transakcji jest w roku ":value"',
    'search_modifier_process_date_on_month'               => 'Data przetworzenia transakcji jest w miesiącu ":value"',
    'search_modifier_process_date_on_day'                 => 'Data przetworzenia transakcji jest w dniu miesiąca ":value"',
    'search_modifier_not_process_date_on_year'            => 'Data przetworzenia transakcji nie jest w roku ":value"',
    'search_modifier_not_process_date_on_month'           => 'Data przetworzenia transakcji nie jest w miesiącu ":value"',
    'search_modifier_not_process_date_on_day'             => 'Data przetworzenia transakcji nie jest w dniu miesiąca ":value"',
    'search_modifier_process_date_before_year'            => 'Data przetworzenia transakcji jest przed lub w roku ":value"',
    'search_modifier_process_date_before_month'           => 'Data przetworzenia transakcji jest przed lub w miesiącu ":value"',
    'search_modifier_process_date_before_day'             => 'Data przetworzenia transakcji jest przed lub w dniu miesiąca ":value"',
    'search_modifier_process_date_after_year'             => 'Data przetworzenia transakcji jest po lub w roku ":value"',
    'search_modifier_process_date_after_month'            => 'Data przetworzenia transakcji jest po lub w miesiącu ":value"',
    'search_modifier_process_date_after_day'              => 'Data przetworzenia transakcji jest po lub w dniu miesiąca ":value"',
    'search_modifier_due_date_on_year'                    => 'Termin płatności transakcji jest w roku ":value"',
    'search_modifier_due_date_on_month'                   => 'Termin płatności transakcji jest w miesiącu ":value"',
    'search_modifier_due_date_on_day'                     => 'Termin płatności transakcji jest w dniu miesiąca ":value"',
    'search_modifier_not_due_date_on_year'                => 'Termin płatności transakcji nie jest w roku ":value"',
    'search_modifier_not_due_date_on_month'               => 'Termin płatności transakcji nie jest w miesiącu ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Termin płatności transakcji nie jest w dniu miesiąca ":value"',
    'search_modifier_due_date_before_year'                => 'Termin płatności transakcji jest przed lub w roku ":value"',
    'search_modifier_due_date_before_month'               => 'Termin płatności transakcji jest przed lub w miesiącu ":value"',
    'search_modifier_due_date_before_day'                 => 'Termin płatności transakcji jest przed lub w dniu miesiąca ":value"',
    'search_modifier_due_date_after_year'                 => 'Termin płatności transakcji jest po lub w roku ":value"',
    'search_modifier_due_date_after_month'                => 'Termin płatności transakcji jest po lub w miesiącu ":value"',
    'search_modifier_due_date_after_day'                  => 'Termin płatności transakcji jest po lub w dniu miesiąca ":value"',
    'search_modifier_payment_date_on_year'                => 'Data płatności transakcji jest w roku ":value"',
    'search_modifier_payment_date_on_month'               => 'Data płatności transakcji jest w miesiącu ":value"',
    'search_modifier_payment_date_on_day'                 => 'Data płatności transakcji jest w dniu miesiąca ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Data płatności transakcji nie jest w roku ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Data płatności transakcji nie jest w miesiącu ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Data płatności transakcji nie jest w dniu miesiąca ":value"',
    'search_modifier_payment_date_before_year'            => 'Data płatności transakcji jest przed lub w roku ":value"',
    'search_modifier_payment_date_before_month'           => 'Data płatności transakcji jest przed lub w miesiącu ":value"',
    'search_modifier_payment_date_before_day'             => 'Data płatności transakcji jest przed lub w dniu miesiąca ":value"',
    'search_modifier_payment_date_after_year'             => 'Data płatności transakcji jest po lub w roku ":value"',
    'search_modifier_payment_date_after_month'            => 'Data płatności transakcji jest po lub w miesiącu ":value"',
    'search_modifier_payment_date_after_day'              => 'Data płatności transakcji jest po lub w dniu miesiąca ":value"',
    'search_modifier_invoice_date_on_year'                => 'Data faktury transakcji jest w roku ":value"',
    'search_modifier_invoice_date_on_month'               => 'Data faktury transakcji jest w miesiącu ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Data faktury transakcji jest w dniu miesiąca ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Data faktury transakcji nie jest w roku ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Data faktury transakcji nie jest w miesiącu ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Data faktury transakcji nie jest w dniu miesiąca ":value"',
    'search_modifier_invoice_date_before_year'            => 'Data faktury transakcji jest przed lub w roku ":value"',
    'search_modifier_invoice_date_before_month'           => 'Data faktury transakcji jest przed lub w miesiącu ":value"',
    'search_modifier_invoice_date_before_day'             => 'Data faktury transakcji jest przed lub w dniu miesiąca ":value"',
    'search_modifier_invoice_date_after_year'             => 'Data faktury transakcji jest po lub w roku ":value"',
    'search_modifier_invoice_date_after_month'            => 'Data faktury transakcji jest po lub w miesiącu ":value"',
    'search_modifier_invoice_date_after_day'              => 'Data faktury transakcji jest po lub w dniu miesiąca ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transakcja została ostatnio zaktualizowana w roku ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transakcja została ostatnio zaktualizowana w miesiącu ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transakcja została ostatnio zaktualizowana w dniu miesiąca ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transakcja nie została ostatnio zaktualizowana w roku ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transakcja nie została ostatnio zaktualizowana w miesiącu ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transakcja nie została ostatnio zaktualizowana w dniu miesiąca ":value"',
    'search_modifier_updated_at_before_year'              => 'Transakcja została ostatnio zaktualizowana w roku lub przed rokiem ":value"',
    'search_modifier_updated_at_before_month'             => 'Transakcja została ostatnio zaktualizowana w miesiącu lub przed miesiącem ":value"',
    'search_modifier_updated_at_before_day'               => 'Transakcja została ostatnio zaktualizowana w dniu miesiąca lub przed dniem miesiąca ":value"',
    'search_modifier_updated_at_after_year'               => 'Transakcja została ostatnio zaktualizowana w roku lub po roku ":value"',
    'search_modifier_updated_at_after_month'              => 'Transakcja została ostatnio zaktualizowana w miesiącu lub po miesiącu ":value"',
    'search_modifier_updated_at_after_day'                => 'Transakcja została ostatnio zaktualizowana w dniu lub po dniu miesiąca ":value"',
    'search_modifier_created_at_on_year'                  => 'Transakcja została utworzona w roku ":value"',
    'search_modifier_created_at_on_month'                 => 'Transakcja została utworzona w miesiącu ":value"',
    'search_modifier_created_at_on_day'                   => 'Transakcja została utworzona w dniu miesiąca ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transakcja nie została utworzona w roku ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transakcja nie została utworzona w miesiącu ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transakcja nie została utworzona w dniu miesiąca ":value"',
    'search_modifier_created_at_before_year'              => 'Transakcja została utworzona w roku lub przed rokiem ":value"',
    'search_modifier_created_at_before_month'             => 'Transakcja została utworzona w miesiącu lub przed ":value"',
    'search_modifier_created_at_before_day'               => 'Transakcja została utworzona dnia miesiąca lub przed ":value"',
    'search_modifier_created_at_after_year'               => 'Transakcja została utworzona w roku lub po roku ":value"',
    'search_modifier_created_at_after_month'              => 'Transakcja została utworzona w miesiącu lub po miesiącu ":value"',
    'search_modifier_created_at_after_day'                => 'Transakcja została utworzona dnia miesiąca lub po dniu miesiąca ":value"',
    'search_modifier_interest_date_before'                => 'Data odsetek transakcji jest przed lub w dniu ":value"',
    'search_modifier_interest_date_after'                 => 'Data odsetek transakcji jest po lub w dniu ":value"',
    'search_modifier_book_date_on'                        => 'Data księgowania transakcji to ":value"',
    'search_modifier_not_book_date_on'                    => 'Data księgowania transakcji to nie ":value"',
    'search_modifier_book_date_before'                    => 'Data księgowania transakcji jest przed lub w dniu ":value"',
    'search_modifier_book_date_after'                     => 'Data księgowania transakcji jest po lub w dniu ":value"',
    'search_modifier_process_date_on'                     => 'Data przetworzenia transakcji to ":value"',
    'search_modifier_not_process_date_on'                 => 'Data przetworzenia transakcji to nie ":value"',
    'search_modifier_process_date_before'                 => 'Data przetworzenia transakcji jest przed lub w ":value"',
    'search_modifier_process_date_after'                  => 'Data przetworzenia transakcji jest po lub w ":value"',
    'search_modifier_due_date_on'                         => 'Termin płatności transakcji to ":value"',
    'search_modifier_not_due_date_on'                     => 'Termin płatności transakcji to nie ":value"',
    'search_modifier_due_date_before'                     => 'Termin płatności transakcji jest przed lub w ":value"',
    'search_modifier_due_date_after'                      => 'Termin płatności transakcji jest po lub w ":value"',
    'search_modifier_payment_date_on'                     => 'Data płatności transakcji to ":value"',
    'search_modifier_not_payment_date_on'                 => 'Data płatności transakcji to nie ":value"',
    'search_modifier_payment_date_before'                 => 'Data płatności transakcji jest przed lub w ":value"',
    'search_modifier_payment_date_after'                  => 'Data płatności transakcji jest po lub w ":value"',
    'search_modifier_invoice_date_on'                     => 'Data faktury transakcji to ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Data faktury transakcji to nie ":value"',
    'search_modifier_invoice_date_before'                 => 'Data faktury transakcji jest przed lub w dniu ":value"',
    'search_modifier_invoice_date_after'                  => 'Data faktury transakcji jest po lub w dniu ":value"',
    'search_modifier_created_at_on'                       => 'Transakcja została utworzona ":value"',
    'search_modifier_not_created_at_on'                   => 'Transakcja nie została utworzona ":value"',
    'search_modifier_created_at_before'                   => 'Transakcja została utworzona w dniu lub przed ":value"',
    'search_modifier_created_at_after'                    => 'Transakcja została utworzona w dniu lub po ":value"',
    'search_modifier_updated_at_on'                       => 'Transakcja została zaktualizowana w dniu ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transakcja nie została zaktualizowana w dniu ":value"',
    'search_modifier_updated_at_before'                   => 'Transakcja została zaktualizowana w dniu lub przed ":value"',
    'search_modifier_updated_at_after'                    => 'Transakcja została zaktualizowana w dniu lub po ":value"',

    'search_modifier_attachment_name_is'            => 'Nazwa dowolnego załącznika to ":value"',
    'search_modifier_attachment_name_contains'      => 'Nazwa dowolnego załącznika zawiera ":value"',
    'search_modifier_attachment_name_starts'        => 'Nazwa dowolnego załącznika zaczyna się od ":value"',
    'search_modifier_attachment_name_ends'          => 'Nazwa dowolnego załącznika kończy się na ":value"',
    'search_modifier_attachment_notes_are'          => 'Notatki dowolnego załącznika to ":value"',
    'search_modifier_attachment_notes_contains'     => 'Notatki dowolnego załącznika zawierają ":value"',
    'search_modifier_attachment_notes_starts'       => 'Notatki dowolnego załącznika zaczynają się od ":value"',
    'search_modifier_attachment_notes_ends'         => 'Notatki dowolnego załącznika kończą się na ":value"',
    'search_modifier_not_attachment_name_is'        => 'Nazwa dowolnego załącznika to nie ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Nazwa dowolnego załącznika nie zawiera ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Notatki dowolnego załącznika nie zaczynają się od ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Notatki dowolnego załącznika nie kończą się na ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Notatki dowolnego załącznika to nie ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Notatki dowolnego załącznika nie zawierają ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Notatki dowolnego załącznika zaczynają się od ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Notatki dowolnego załącznika nie kończą się na ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT to ":value"',
    'update_rule_from_query'                        => 'Aktualizuj regułę ":rule" z zapytania wyszukiwania',
    'create_rule_from_query'                        => 'Utwórz nową regułę z zapytania wyszukiwania',
    'rule_from_search_words'                        => 'Silnik reguł ma problemy z obsługą ":string". Sugerowana reguła, która pasuje do Twojego zapytania może dawać różne wyniki. Proszę dokładnie sprawdź wyzwalacze reguł.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Saldo konta docelowego to dokładnie ":value"',
    'search_modifier_not_destination_balance_is'    => 'Saldo konta docelowego to dokładnie NIE ":value"',
    'search_modifier_source_balance_is'             => 'Saldo konta źródłowego to dokładnie ":value"',
    'search_modifier_not_source_balance_is'         => 'Saldo konta źródłowego to dokładnie NIE ":value"',

    'search_modifier_destination_balance_lte'     => 'Saldo konta docelowego jest mniejsze lub równe ":value"',
    'search_modifier_not_destination_balance_lte' => 'Saldo konta docelowego jest większe niż ":value"',
    'search_modifier_source_balance_lte'          => 'Saldo konta źródłowego jest mniejsze lub równe ":value"',
    'search_modifier_not_source_balance_lte'      => 'Saldo konta źródłowego jest większe niż ":value"',

    'search_modifier_destination_balance_lt'     => 'Saldo konta docelowego jest mniejsze niż ":value"',
    'search_modifier_not_destination_balance_lt' => 'Saldo konta docelowego jest większe lub równe ":value"',
    'search_modifier_source_balance_lt'          => 'Saldo konta źródłowego jest mniejsze niż ":value"',
    'search_modifier_not_source_balance_lt'      => 'Saldo konta źródłowego jest większe lub równe ":value"',

    'search_modifier_destination_balance_gte'     => 'Saldo konta docelowego jest większe lub równe ":value"',
    'search_modifier_not_destination_balance_gte' => 'Saldo konta docelowego jest mniejsze niż ":value"',
    'search_modifier_source_balance_gte'          => 'Saldo konta źródłowego jest większe lub równe ":value"',
    'search_modifier_not_source_balance_gte'      => 'Saldo konta źródłowego jest mniejsze niż ":value"',

    'search_modifier_destination_balance_gt'              => 'Saldo konta docelowego jest większe niż ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Saldo konta docelowego jest mniejsze lub równe ":value"',
    'search_modifier_source_balance_gt'                   => 'Saldo konta źródłowego jest większe niż ":value"',
    'search_modifier_not_source_balance_gt'               => 'Saldo konta źródłowego jest mniejsze lub równe ":value"',


    // END
    'general_search_error'                                => 'Wystąpił błąd podczas wyszukiwania. Aby uzyskać więcej informacji proszę sprawdzić logi aplikacji.',
    'search_box'                                          => 'Szukaj',
    'search_box_intro'                                    => 'Witamy w funkcji wyszukiwania Firefly III. Wprowadź zapytanie w polu. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Upewnij się, że sprawdziłeś plik z dokumentacją</a>, ponieważ wyszukiwanie jest dość zaawansowane.',
    'search_error'                                        => 'Błąd podczas wyszukiwania',
    'search_searching'                                    => 'Wyszukiwanie...',
    'search_results'                                      => 'Wyniki wyszukiwania',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'rocznie',
    'repeat_freq_half-year'                               => 'co pół roku',
    'repeat_freq_quarterly'                               => 'kwartalnie',
    'repeat_freq_monthly'                                 => 'miesięcznie',
    'repeat_freq_weekly'                                  => 'tygodniowo',
    'repeat_freq_daily'                                   => 'codziennie',
    'daily'                                               => 'dziennie',
    'weekly'                                              => 'tygodniowo',
    'quarterly'                                           => 'kwartalnie',
    'half-year'                                           => 'co pół roku',
    'yearly'                                              => 'rocznie',

    // rules
    'is_not_rule_trigger'                                 => 'Nie',
    'cannot_fire_inactive_rules'                          => 'Nie możesz wykonać nieaktywnych reguł.',
    'show_triggers'                                       => 'Pokaż wyzwalacze',
    'show_actions'                                        => 'Pokaż działania',
    'rules'                                               => 'Reguły',
    'rule_name'                                           => 'Nazwa reguły',
    'rule_triggers'                                       => 'Reguły są wyzwalane gdy',
    'rule_actions'                                        => 'Reguła będzie',
    'new_rule'                                            => 'Nowa reguła',
    'new_rule_group'                                      => 'Nowa grupa reguł',
    'rule_priority_up'                                    => 'Zwiększ priorytet reguły',
    'rule_priority_down'                                  => 'Zmniejsz priorytet reguły',
    'make_new_rule_group'                                 => 'Utwórz nową grupę reguł',
    'store_new_rule_group'                                => 'Zapisz nową grupę reguł',
    'created_new_rule_group'                              => 'Nowa grupa reguł ":title" została zapisana!',
    'updated_rule_group'                                  => 'Pomyślnie zmodyfikowano grupę reguł ":title".',
    'edit_rule_group'                                     => 'Modyfikuj grupę reguł ":title"',
    'duplicate_rule'                                      => 'Duplikuj regułę ":title"',
    'rule_copy_of'                                        => 'Kopia ":title"',
    'duplicated_rule'                                     => 'Duplikat reguły ":title" w ":newTitle"',
    'delete_rule_group'                                   => 'Usuń grupę reguł ":title"',
    'deleted_rule_group'                                  => 'Usunięto grupę reguł ":title"',
    'update_rule_group'                                   => 'Aktualizuj grupę reguł',
    'no_rules_in_group'                                   => 'Nie ma żadnych reguł w tej grupie',
    'move_rule_group_up'                                  => 'Przenieś grupę reguł w górę',
    'move_rule_group_down'                                => 'Przenieś grupę reguł w dół',
    'save_rules_by_moving'                                => 'Zapisz tę regułę, przenosząc ją do innej grupy reguł:|Zapisz te reguły, przenosząc je do innej grupy reguł:',
    'make_new_rule'                                       => 'Utwórz nową regułę w grupie reguł ":title"',
    'make_new_rule_no_group'                              => 'Stwórz nową regułę',
    'instructions_rule_from_bill'                         => 'Aby dopasować transakcje do nowej subskrypcji ":name", Firefly III może utworzyć regułę, która będzie automatycznie sprawdzana względem wszelkich transakcji, które zapisujesz. Sprawdź poniższe szczegóły i zapisz regułę, aby Firefly III automatycznie dopasowywało transakcje do Twojej nowej subskrypcji.',
    'instructions_rule_from_journal'                      => 'Utwórz regułę na podstawie jednej z Twoich transakcji. Uzupełnij lub wyślij poniższy formularz.',
    'rule_is_strict'                                      => 'ścisła reguła',
    'rule_is_not_strict'                                  => 'swobodna reguła',
    'rule_help_stop_processing'                           => 'Po zaznaczeniu tego pola, późniejsze reguły w tej grupie nie zostaną wykonane, jeżeli ta konkretna reguła zostanie wykonana.',
    'rule_help_strict'                                    => 'W ścisłych regułach WSZYSTKIE wyzwalacze muszą się aktywować aby akcje zostały wykonane. W swobodnych regułach DOWOLNY wyzwalacz wystarcza do wykonania akcji.',
    'rule_help_active'                                    => 'Nieaktywne reguły nigdy nie zostaną uruchomione.',
    'stored_new_rule'                                     => 'Zapisano regułę o nazwie ":title"',
    'deleted_rule'                                        => 'Usunięto regułę o nazwie ":title"',
    'store_new_rule'                                      => 'Zapisz nową regułę',
    'updated_rule'                                        => 'Zmodyfikowano regułę o nazwie ":title"',
    'default_rule_group_name'                             => 'Reguły domyślne',
    'default_rule_group_description'                      => 'Wszystkie twoje reguły, które nie znajdują się w określonej grupie.',
    'trigger'                                             => 'Wyzwalacz',
    'trigger_value'                                       => 'Uruchom dla wartości',
    'stop_processing_other_triggers'                      => 'Zatrzymaj przetwarzanie innych wyzwalaczy',
    'add_rule_trigger'                                    => 'Dodaj nowy wyzwalacz',
    'action'                                              => 'Akcja',
    'action_value'                                        => 'Wartość akcji',
    'stop_executing_other_actions'                        => 'Zatrzymaj wykonywanie innych akcji',
    'add_rule_action'                                     => 'Dodaj nową akcję',
    'edit_rule'                                           => 'Modyfikuj regułę #:nr ":title"',
    'delete_rule'                                         => 'Usuń regułę ":title"',
    'update_rule'                                         => 'Modyfikuj regułę',
    'test_rule_triggers'                                  => 'Zobacz pasujące transakcje',
    'warning_no_matching_transactions'                    => 'Nie znaleziono pasujących transakcji.',
    'warning_no_valid_triggers'                           => 'Nie dostarczono prawidłowych wyzwalaczy.',
    'apply_rule_selection'                                => 'Zastosuj regułę ":title" do niektórych swoich transakcji',
    'apply_rule_selection_intro'                          => 'Reguły takie jak ":title" są zwykle stosowane tylko do nowych lub modyfikowanych transakcji, ale możesz powiedzieć Firefly III aby uruchomił ją dla istniejących transakcji. Może to być przydatne, gdy zmodyfikowałeś regułę i potrzebujesz zastosować zmiany dla wszystkich pozostałych transakcji.',
    'include_transactions_from_accounts'                  => 'Uwzględnij transakcje z tych kont',
    'include'                                             => 'Zawrzeć?',
    'applied_rule_selection'                              => '{0} Żadna transakcja w Twoim wyborze nie została zmieniona przez regułę ":title".|[1] Jedna transakcja w Twoim wyborze została zmieniona przez regułę ":title".|[2,*] :count transakcje w Twoim wyborze zostały zmienione przez regułę ":title".',
    'execute'                                             => 'Wykonaj',
    'apply_rule_group_selection'                          => 'Zastosuj grupę reguł ":title" do niektórych swoich transakcji',
    'apply_rule_group_selection_intro'                    => 'GRupy reguł takie jak ":title" są zwykle stosowane tylko do nowych lub modyfikowanych transakcji, ale możesz powiedzieć Firefly III aby uruchomił ją dla istniejących transakcji. Może to być przydatne, gdy zmodyfikowałeś grupę reguł i potrzebujesz zastosować zmiany dla wszystkich pozostałych transakcji.',
    'applied_rule_group_selection'                        => 'Grupa reguł ":title" została zastosowana do Twojego wyboru.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Po utworzeniu transakcji',
    'rule_trigger_update_journal'                         => 'Po zmodyfikowaniu transakcji',
    'rule_trigger_manual'                                 => 'Tylko gdy wyzwolona przez użytkownika',
    'rule_trigger_user_action'                            => 'Akcją użytkownika jest ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Konto źródłowe się zaczyna od..',
    'rule_trigger_source_account_starts'                  => 'Konto źródłowe się zaczyna od ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Konto źródłowe kończy się na..',
    'rule_trigger_source_account_ends'                    => 'Konto źródłowe kończy się na ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Kontem źródłowym jest..',
    'rule_trigger_source_account_is'                      => 'Nazwa konta źródłowego to ":trigger_value:"',
    'rule_trigger_source_account_contains_choice'         => 'Nazwa konta źródłowego zawiera..',
    'rule_trigger_source_account_contains'                => 'Nazwa konta źródłowego zawiera ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Konto (dowolne) ma ID dokładnie..',
    'rule_trigger_account_id'                             => 'Konto (dowolne) ma ID dokładnie :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'ID konta źródłowego to dokładnie..',
    'rule_trigger_source_account_id'                      => 'ID konta źródłowego to dokładnie :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'ID konta docelowego to dokładnie..',
    'rule_trigger_destination_account_id'                 => 'ID konta docelowego to dokładnie :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Dowolne konto jest kontem gotówkowym',
    'rule_trigger_account_is_cash'                        => 'Dowolne konto jest kontem gotówkowym',
    'rule_trigger_source_is_cash_choice'                  => 'Konto źródłowe to konto (gotówkowe)',
    'rule_trigger_source_is_cash'                         => 'Konto źródłowe to konto (gotówkowe)',
    'rule_trigger_destination_is_cash_choice'             => 'Konto docelowe to konto (gotówkowe)',
    'rule_trigger_destination_is_cash'                    => 'Konto docelowe to konto (gotówkowe)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Numer / IBAN konta źródłowego zaczyna się od..',
    'rule_trigger_source_account_nr_starts'               => 'Numer konta źródłowego / IBAN zaczyna się od ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Numer konta źródłowego / IBAN kończy się na..',
    'rule_trigger_source_account_nr_ends'                 => 'Numer konta źródłowego / IBAN kończy się ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Numer konta źródłowego / IBAN to..',
    'rule_trigger_source_account_nr_is'                   => 'Numer konta źródłowego / IBAN to ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Numer konta źródłowego / IBAN zawiera..',
    'rule_trigger_source_account_nr_contains'             => 'Numer konta źródłowego / IBAN zawiera ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Nazwa konta docelowego zaczyna się od..',
    'rule_trigger_destination_account_starts'             => 'Nazwa konta docelowego zaczyna się od ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Nazwa konta docelowego kończy się na..',
    'rule_trigger_destination_account_ends'               => 'Nazwa konta docelowego kończy się na ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Nazwa konta docelowego to..',
    'rule_trigger_destination_account_is'                 => 'Nazwa konta docelowego to ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Nazwa konta docelowego zawiera..',
    'rule_trigger_destination_account_contains'           => 'Nazwa konta docelowego zawiera ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Numer konta docelowego / IBAN zaczyna się od..',
    'rule_trigger_destination_account_nr_starts'          => 'Numer konta docelowego / IBAN zaczyna się od ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Numer konta docelowego / IBAN kończy się na..',
    'rule_trigger_destination_account_nr_ends'            => 'Numer konta docelowego / IBAN kończy się ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Numer konta docelowego / IBAN to..',
    'rule_trigger_destination_account_nr_is'              => 'Numer konta docelowego / IBAN to ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Numer konta docelowego / IBAN zawiera..',
    'rule_trigger_destination_account_nr_contains'        => 'Numer konta docelowego / IBAN zawiera ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transakcja jest typu..',
    'rule_trigger_transaction_type'                       => 'Transakcja jest typu ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategoria to..',
    'rule_trigger_category_is'                            => 'Kategoria to ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Kwota jest mniejsza lub równa ..',
    'rule_trigger_amount_less'                            => 'Kwota jest mniejsza lub równa :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Kwota to..',
    'rule_trigger_amount_is'                              => 'Kwota to :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Kwota jest większa lub równa..',
    'rule_trigger_amount_more'                            => 'Kwota jest większa lub równa :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Opis zaczyna się od..',
    'rule_trigger_description_starts'                     => 'Opis się zaczyna od ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Opis kończy się na..',
    'rule_trigger_description_ends'                       => 'Opis się kończy na ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Opis zawiera..',
    'rule_trigger_description_contains'                   => 'Opis zawiera ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Opis to..',
    'rule_trigger_description_is'                         => 'Opis to ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Data transakcji to..',
    'rule_trigger_date_on'                                => 'Data transakcji to ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Data transakcji jest przed..',
    'rule_trigger_date_before'                            => 'Data transakcji jest przed ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Data transakcji jest po..',
    'rule_trigger_date_after'                             => 'Data transakcji jest po ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transakcja została utworzona dnia..',
    'rule_trigger_created_at_on'                          => 'Transakcja została utworzona dnia ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transakcja została ostatnio edytowana dnia..',
    'rule_trigger_updated_at_on'                          => 'Transakcja została ostatnio edytowana dnia ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budżet to..',
    'rule_trigger_budget_is'                              => 'Budżet to ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Dowolny tag to..',
    'rule_trigger_tag_is'                                 => 'Dowolny tag jest ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Dowolny tag zawiera..',
    'rule_trigger_tag_contains'                           => 'Dowolny tag zawiera ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Dowolny tag kończy się na..',
    'rule_trigger_tag_ends'                               => 'Dowolny tag kończy się na ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Dowolny tag zaczyna się od..',
    'rule_trigger_tag_starts'                             => 'Dowolny tag zaczyna się od ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Waluta transakcji to..',
    'rule_trigger_currency_is'                            => 'Waluta transakcji to ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Waluta obca transakcji to..',
    'rule_trigger_foreign_currency_is'                    => 'Waluta obca transakcji to ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Ma dowolne załączniki',
    'rule_trigger_has_attachments'                        => 'Ma dowolne załącznik(i)',
    'rule_trigger_has_no_category_choice'                 => 'Brak kategorii',
    'rule_trigger_has_no_category'                        => 'Transakcje bez kategorii',
    'rule_trigger_has_any_category_choice'                => 'Ma (dowolną) kategorię',
    'rule_trigger_has_any_category'                       => 'Transakcja ma (dowolną) kategorię',
    'rule_trigger_has_no_budget_choice'                   => 'Brak budżetu',
    'rule_trigger_has_no_budget'                          => 'Transakcja bez budżetu',
    'rule_trigger_has_any_budget_choice'                  => 'Ma (dowolny) budżet',
    'rule_trigger_has_any_budget'                         => 'Transakcja ma (dowolny) budżet',
    'rule_trigger_has_no_bill_choice'                     => 'Nie ma subskrypcji',
    'rule_trigger_has_no_bill'                            => 'Transakcja nie ma subskrypcji',
    'rule_trigger_has_any_bill_choice'                    => 'Ma (dowolną) subskrypcję',
    'rule_trigger_has_any_bill'                           => 'Transakcja ma (dowolną) subskrypcję',
    'rule_trigger_has_no_tag_choice'                      => 'Brak tagów',
    'rule_trigger_has_no_tag'                             => 'Transakcja bez tagów',
    'rule_trigger_has_any_tag_choice'                     => 'Ma (dowolny) tag (lub kilka)',
    'rule_trigger_has_any_tag'                            => 'Transakcja ma (dowolny) tag (lub kilka)',
    'rule_trigger_any_notes_choice'                       => 'Ma (dowolne) notatki',
    'rule_trigger_any_notes'                              => 'Transakcja ma (dowolne) notatki',
    'rule_trigger_no_notes_choice'                        => 'Brak notatek',
    'rule_trigger_no_notes'                               => 'Transakcja bez notatek',
    'rule_trigger_notes_is_choice'                        => 'Notatki to..',
    'rule_trigger_notes_is'                               => 'Notatki to ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notatki zawierają..',
    'rule_trigger_notes_contains'                         => 'Notatki zawierają ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notatki zaczynają się od..',
    'rule_trigger_notes_starts'                           => 'Notatki zaczynają się od ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notatki kończą się na..',
    'rule_trigger_notes_ends'                             => 'Notatki kończą się na ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subskrypcja to..',
    'rule_trigger_bill_is'                                => 'Subskrypcja to ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Zewnętrzne ID to..',
    'rule_trigger_external_id_is'                         => 'Zewnętrzne ID to ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Wewnętrzne odwołanie to..',
    'rule_trigger_internal_reference_is'                  => 'Wewnętrzne odwołanie to ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'ID dziennika transakcji to..',
    'rule_trigger_journal_id'                             => 'ID dziennika transakcji to ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transakcja ma (dowolny) zewnętrzny adres URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transakcja ma (dowolne) zewnętrzne ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transakcja nie ma zewnętrznego adresu URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transakcja nie ma zewnętrznego ID',
    'rule_trigger_id_choice'                              => 'Identyfikator transakcji to..',
    'rule_trigger_id'                                     => 'Identyfikator transakcji to ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT to..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT to ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Akcja użytkownika to ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Żaden tag to..',
    'rule_trigger_tag_is_not'                             => 'Żaden tag to ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Konto (dowolne) to dokładnie..',
    'rule_trigger_account_is'                             => 'Konto (dowolne) to dokładnie ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Konto (dowolne) zawiera..',
    'rule_trigger_account_contains'                       => 'Konto (dowolne) zawiera ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Konto (dowolne) kończy się na..',
    'rule_trigger_account_ends'                           => 'Konto (dowolne) kończy się na ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Konto (dowolne) zaczyna się od..',
    'rule_trigger_account_starts'                         => 'Konto (dowolne) zaczyna się od ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Numer konta (dowolnego) / IBAN to..',
    'rule_trigger_account_nr_is'                          => 'Numer konta (dowolnego) / IBAN to ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Numer konta (dowolnego) / IBAN zawiera..',
    'rule_trigger_account_nr_contains'                    => 'Numer konta (dowolnego) / IBAN zawiera ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Numer konta (dowolnego) / IBAN kończy się na..',
    'rule_trigger_account_nr_ends'                        => 'Numer konta (dowolnego) / IBAN kończy się ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Numer konta (dowolnego) / IBAN zaczyna się od..',
    'rule_trigger_account_nr_starts'                      => 'Numer konta (dowolnego) / IBAN zaczyna się od ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Kategoria zawiera..',
    'rule_trigger_category_contains'                      => 'Kategoria zawiera ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Kategoria kończy się..',
    'rule_trigger_category_ends'                          => 'Kategoria kończy się na ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Kategoria zaczyna się od..',
    'rule_trigger_category_starts'                        => 'Kategoria zaczyna się od ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budżet zawiera..',
    'rule_trigger_budget_contains'                        => 'Budżet zawiera ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budżet kończy się na..',
    'rule_trigger_budget_ends'                            => 'Budżet kończy się na ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budżet zaczyna się od..',
    'rule_trigger_budget_starts'                          => 'Budżet zaczyna się od ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subskrypcja zawiera..',
    'rule_trigger_bill_contains'                          => 'Subskrypcja zawiera ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subskrypcja kończy się na..',
    'rule_trigger_bill_ends'                              => 'Subskrypcja kończy się na ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subskrypcja zaczyna się od..',
    'rule_trigger_bill_starts'                            => 'Subskrypcja zaczyna się od ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Zewnętrzne ID zawiera..',
    'rule_trigger_external_id_contains'                   => 'Zewnętrzne ID zawiera ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Zewnętrzne ID kończy się na..',
    'rule_trigger_external_id_ends'                       => 'Zewnętrzne ID kończy się na ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Zewnętrzne ID zaczyna się od..',
    'rule_trigger_external_id_starts'                     => 'Zewnętrzne ID zaczyna się od ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Wewnętrzne odwołanie zawiera..',
    'rule_trigger_internal_reference_contains'            => 'Wewnętrzne odwołanie zawiera ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Wewnętrzne odwołanie kończy się na..',
    'rule_trigger_internal_reference_ends'                => 'Wewnętrzne odwołanie kończy się na ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Wewnętrzne odwołanie zaczyna się od..',
    'rule_trigger_internal_reference_starts'              => 'Wewnętrzne odwołanie zaczyna się od ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Zewnętrzny adres URL to..',
    'rule_trigger_external_url_is'                        => 'Zewnętrzny adres URL to ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Zewnętrzny adres URL zawiera..',
    'rule_trigger_external_url_contains'                  => 'Zewnętrzny adres URL zawiera ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Zewnętrzny adres URL kończy się na..',
    'rule_trigger_external_url_ends'                      => 'Zewnętrzny adres URL kończy się na ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Zewnętrzny adres URL zaczyna się od..',
    'rule_trigger_external_url_starts'                    => 'Zewnętrzny adres URL zaczyna się od ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Nie ma załączników',
    'rule_trigger_has_no_attachments'                     => 'Transakcja nie ma załączników',
    'rule_trigger_recurrence_id_choice'                   => 'Cykliczna transakcja ma ID..',
    'rule_trigger_recurrence_id'                          => 'Cykliczna transakcja ma ID ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Data odsetek jest dnia..',
    'rule_trigger_interest_date_on'                       => 'Data odsetek jest dnia ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Data odsetek jest przed dniem..',
    'rule_trigger_interest_date_before'                   => 'Data odsetek jest przed dniem ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Data odsetek jest po..',
    'rule_trigger_interest_date_after'                    => 'Data odsetek jest po ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Data księgowania to..',
    'rule_trigger_book_date_on'                           => 'Data księgowania to ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Data księgowania jest przed..',
    'rule_trigger_book_date_before'                       => 'Data księgowania jest przed ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Data księgowania jest po..',
    'rule_trigger_book_date_after'                        => 'Data księgowania jest po ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Data przetworzenia to..',
    'rule_trigger_process_date_on'                        => 'Data przetworzenia to ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Data przetworzenia jest przed..',
    'rule_trigger_process_date_before'                    => 'Data przetworzenia jest przed ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Data przetworzenia jest po..',
    'rule_trigger_process_date_after'                     => 'Data przetworzenia jest po ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Termin płatności to..',
    'rule_trigger_due_date_on'                            => 'Termin płatności to ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Termin płatności jest przed..',
    'rule_trigger_due_date_before'                        => 'Termin płatności jest przed ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Termin płatności jest po..',
    'rule_trigger_due_date_after'                         => 'Termin płatności jest po ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Data płatności to..',
    'rule_trigger_payment_date_on'                        => 'Data płatności to ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Data płatności jest przed..',
    'rule_trigger_payment_date_before'                    => 'Data płatności jest przed ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Data płatności jest po..',
    'rule_trigger_payment_date_after'                     => 'Data płatności jest po ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Data faktury to..',
    'rule_trigger_invoice_date_on'                        => 'Data faktury to ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Data faktury jest przed..',
    'rule_trigger_invoice_date_before'                    => 'Data faktury jest przed ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Data faktury jest po..',
    'rule_trigger_invoice_date_after'                     => 'Data faktury jest po ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transakcja została utworzona przed..',
    'rule_trigger_created_at_before'                      => 'Transakcja została utworzona przed ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transakcja została utworzona po..',
    'rule_trigger_created_at_after'                       => 'Transakcja została utworzona po ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transakcja została ostatnio zaktualizowana przed..',
    'rule_trigger_updated_at_before'                      => 'Transakcja została ostatnio zaktualizowana przed ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transakcja została ostatnio edytowana po dniu..',
    'rule_trigger_updated_at_after'                       => 'Transakcja została ostatnio edytowana po dniu ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Kwota obca to dokładnie..',
    'rule_trigger_foreign_amount_is'                      => 'Kwota obca to dokładnie ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Kwota obca jest mniejsza niż..',
    'rule_trigger_foreign_amount_less'                    => 'Kwota obca jest mniejsza niż ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Kwota obca jest większa niż..',
    'rule_trigger_foreign_amount_more'                    => 'Kwota obca jest większa niż ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Nazwa dowolnego załącznika to..',
    'rule_trigger_attachment_name_is'                     => 'Nazwa dowolnego załącznika to ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Nazwa dowolnego załącznika zawiera..',
    'rule_trigger_attachment_name_contains'               => 'Nazwa dowolnego załącznika zawiera ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Nazwa dowolnego załącznika zaczyna się od..',
    'rule_trigger_attachment_name_starts'                 => 'Nazwa dowolnego załącznika zaczyna się od ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Nazwa dowolnego załącznika kończy się na..',
    'rule_trigger_attachment_name_ends'                   => 'Nazwa dowolnego załącznika kończy się na ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Notatki dowolnego załącznika to..',
    'rule_trigger_attachment_notes_are'                   => 'Notatki dowolnego załącznika to ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Notatki dowolnego załącznika zawierają..',
    'rule_trigger_attachment_notes_contains'              => 'Notatki dowolnego załącznika zawierają ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Notatki dowolnego załącznika zaczynają się od..',
    'rule_trigger_attachment_notes_starts'                => 'Notatki dowolnego załącznika zaczynają się od ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Notatki dowolnego załącznika kończą się na..',
    'rule_trigger_attachment_notes_ends'                  => 'Notatki dowolnego załącznika kończą się ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transakcja została uzgodniona',
    'rule_trigger_reconciled'                             => 'Transakcja została uzgodniona',
    'rule_trigger_exists_choice'                          => 'Dowolna transakcja pasuje(!)',
    'rule_trigger_exists'                                 => 'Dowolna transakcja pasuje',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'ID konta to nie ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'ID konta źródłowego to nie ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'ID konta docelowego to nie ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Typ transakcji to nie ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag to nie ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag to ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Opis to nie ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Opis nie kończy się na ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Opis nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notatki to nie ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notatki nie zawierają ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notatki nie kończą się na ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notatki nie zaczynają się od ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Konto źródłowe to nie ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Konto źródłowe nie zawiera ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Konto źródłowe nie kończy się na ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Konto źródłowe nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Numer konta źródłowego / IBAN to nie ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Numer konta źródłowego / IBAN nie zawiera ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Numer konta źródłowego / IBAN nie kończy się na ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Numer konta źródłowego / IBAN nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Konto docelowe to nie ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Konto docelowe nie zawiera ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Konto docelowe nie kończy się na ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Konto docelowe nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Numer konta docelowego / IBAN to nie ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Numer konta docelowego / IBAN nie zawiera ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Numer konta docelowego / IBAN nie kończy się na ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Numer konta docelowego / IBAN nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Żadne z kont nie jest ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Żadne z kont nie zawiera ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Żadne z kont nie kończy się na ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Żadne z kont nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Żaden numer konta / IBAN nie jest ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Żaden numer konta / IBAN nie zawiera ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Żaden numer konta / IBAN nie kończy się na ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Żaden numer konta / IBAN nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Kategoria to nie ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Kategoria nie zawiera ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Kategoria nie kończy się na ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Kategoria nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budżet to nie ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budżet nie zawiera ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budżet nie kończy się na ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budżet nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subskrypcja nie jest ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subskrypcja nie zawiera ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subskrypcja nie kończy się na ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subskrypcja nie kończy się ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'Zewnętrzne ID to nie ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'Zewnętrzne ID nie zawiera ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'Zewnętrzne ID nie kończy się na ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'Zewnętrzne ID nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Wewnętrzne odwołanie to nie ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Wewnętrzne odwołanie nie zawiera ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Wewnętrzne odwołanie nie kończy się na ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Wewnętrzne odwołanie nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'Zewnętrzny adres URL to nie ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'Zewnętrzny adres URL nie zawiera ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'Zewnętrzny adres URL nie kończy się na ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'Zewnętrzny adres URL nie zaczyna się od ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Waluta to nie ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Waluta obca to nie ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Identyfikator transakcji to nie ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'ID dziennika transakcji to nie ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Cykliczna transakcja nie ma ID ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Data to nie ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Data nie jest przed ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Data nie jest po ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Data odsetek to nie ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Data odsetek nie jest przed ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Data odsetek nie jest po ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Data księgowania to nie ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Data księgowania nie jest przed ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Data księgowania nie jest po ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Data przetworzenia to nie ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Data przetworzenia nie jest przed ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Data przetworzenia nie jest po ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Termin płatności to nie ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Termin płatności nie jest przed ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Termin płatności nie jest po ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Data płatności to nie ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Data płatności nie jest przed ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Data płatności nie jest po ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Data faktury nie jest ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Data faktury nie jest przed ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Data faktury nie jest po ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transakcja nie została utworzona ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transakcja nie została utworzona przed ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transakcja nie została utworzona po ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transakcja nie została zaktualizowana dnia ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transakcja nie została zaktualizowana przed ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transakcja nie została zaktualizowana po ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Kwota transakcji to nie ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Kwota transakcji jest większa niż ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Kwota transakcji jest mniejsza niż ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Kwota obcej transakcji to nie ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Kwota obcej transakcji jest większa niż ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Kwota obcej transakcji jest mniejsza niż ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Nazwa żadnego załącznika to ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Nazwa żadnego załącznika zawiera ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Nazwa żadnego załącznika zaczyna się od ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Nazwa żadnego załącznika kończy się na ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Notatki żadnego załącznika to ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Notatki żadnego załącznika zawierają ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Notatki żadnego załącznika zaczynają się od ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Notatki żadnego załącznika kończą się ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transakcja nie została uzgodniona',
    'rule_trigger_not_exists'                             => 'Transakcja nie istnieje',
    'rule_trigger_not_has_attachments'                    => 'Transakcja nie ma załączników',
    'rule_trigger_not_has_any_category'                   => 'Transakcja nie ma kategorii',
    'rule_trigger_not_has_any_budget'                     => 'Transakcja bez budżetu',
    'rule_trigger_not_has_any_bill'                       => 'Transakcja nie ma (żadnej) subskrypcji',
    'rule_trigger_not_has_any_tag'                        => 'Transakcja bez tagów',
    'rule_trigger_not_any_notes'                          => 'Transakcja bez notatek',
    'rule_trigger_not_any_external_url'                   => 'Transakcja nie ma zewnętrznego adresu URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transakcja ma (dowolne) załącznik(i)',
    'rule_trigger_not_has_no_category'                    => 'Transakcja ma (dowolną) kategorię',
    'rule_trigger_not_has_no_budget'                      => 'Transakcja ma (dowolny) budżet',
    'rule_trigger_not_has_no_bill'                        => 'Transakcja ma (dowolną) subskrypcję',
    'rule_trigger_not_has_no_tag'                         => 'Transakcja ma (dowolny) tag',
    'rule_trigger_not_no_notes'                           => 'Transakcja ma dowolne notatki',
    'rule_trigger_not_no_external_url'                    => 'Transakcja ma zewnętrzny adres URL',
    'rule_trigger_not_source_is_cash'                     => 'Konto źródłowe to nie konto gotówkowe',
    'rule_trigger_not_destination_is_cash'                => 'Konto docelowe to nie konto gotówkowe',
    'rule_trigger_not_account_is_cash'                    => 'Żadne konto nie jest kontem gotówkowym',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Saldo konta docelowego jest większe niż..',
    'rule_trigger_destination_balance_gte_choice'         => 'Saldo konta docelowego jest większe lub równe..',
    'rule_trigger_destination_balance_is_choice'          => 'Saldo konta docelowego to dokładnie..',
    'rule_trigger_destination_balance_lt_choice'          => 'Saldo konta docelowego jest mniejsze niż..',
    'rule_trigger_destination_balance_lte_choice'         => 'Saldo konta docelowego jest mniejsze lub równe..',

    'rule_trigger_source_balance_gt_choice'  => 'Saldo konta źródłowego jest większe niż..',
    'rule_trigger_source_balance_gte_choice' => 'Saldo konta źródłowego jest większe lub równe..',
    'rule_trigger_source_balance_is_choice'  => 'Saldo konta źródłowego to dokładnie..',
    'rule_trigger_source_balance_lt_choice'  => 'Saldo konta źródłowego jest mniejsze niż..',
    'rule_trigger_source_balance_lte_choice' => 'Saldo konta źródłowego jest mniejsze lub równe..',

    'rule_trigger_destination_balance_gt'  => 'Saldo konta docelowego jest większe niż :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Saldo konta docelowego jest większe lub równe :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Saldo konta docelowego to dokładnie :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Saldo konta docelowego jest mniejsze niż :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Saldo konta docelowego jest mniejsze lub równe :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Saldo konta źródłowego jest większe niż :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Saldo konta źródłowego jest większe lub równe :trigger_value',
    'rule_trigger_source_balance_is'           => 'Saldo konta źródłowego to dokładnie :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Saldo konta źródłowego jest mniejsze niż :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Saldo konta źródłowego jest mniejsze lub równe :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Saldo konta docelowego jest mniejsze lub równe :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Saldo konta docelowego jest mniejsze niż :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Saldo konta docelowego to nie :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Saldo konta docelowego jest większe lub równe :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Saldo konta docelowego jest większe niż :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Saldo konta źródłowego jest mniejsze lub równe :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Saldo konta źródłowego jest mniejsze niż :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Saldo konta źródłowego to nie :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Saldo konta źródłowego jest większe lub równe :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Saldo konta źródłowego jest większe niż :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'USUŃ transakcję(!)',
    'rule_action_delete_transaction'             => 'USUŃ transakcję(!)',
    'rule_action_set_category'                   => 'Ustaw kategorię na ":action_value"',
    'rule_action_clear_category'                 => 'Wyczyść kategorię',
    'rule_action_set_budget'                     => 'Ustaw budżet na ":action_value"',
    'rule_action_clear_budget'                   => 'Wyczyść budżet',
    'rule_action_add_tag'                        => 'Dodaj tag ":action_value"',
    'rule_action_remove_tag'                     => 'Usuń tag ":action_value"',
    'rule_action_remove_all_tags'                => 'Usuń wszystkie tagi',
    'rule_action_set_description'                => 'Ustaw opis na ":action_value"',
    'rule_action_append_description'             => 'Dołącz do opisu wartość ":action_value"',
    'rule_action_prepend_description'            => 'Poprzedź opis wartością ":action_value"',
    'rule_action_set_category_choice'            => 'Ustaw kategorię na ..',
    'rule_action_clear_category_choice'          => 'Wyczyść wszystkie kategorie',
    'rule_action_set_budget_choice'              => 'Ustaw budżet na ..',
    'rule_action_clear_budget_choice'            => 'Wyczyść wszystkie budżety',
    'rule_action_add_tag_choice'                 => 'Dodaj tag ..',
    'rule_action_remove_tag_choice'              => 'Usuń tag ..',
    'rule_action_remove_all_tags_choice'         => 'Usuń wszystkie tagi',
    'rule_action_set_description_choice'         => 'Ustaw opis na ..',
    'rule_action_update_piggy_choice'            => 'Dodaj / usuń kwotę transakcji w skarbonce ..',
    'rule_action_update_piggy'                   => 'Dodaj / usuń kwotę transakcji w skarbonce ":action_value"',
    'rule_action_append_description_choice'      => 'Dołącz do opisu ..',
    'rule_action_prepend_description_choice'     => 'Poprzedź opis ..',
    'rule_action_set_source_account_choice'      => 'Ustaw konto źródłowe na ..',
    'rule_action_set_source_account'             => 'Ustaw konto źródłowe na :action_value',
    'rule_action_set_destination_account_choice' => 'Ustaw konto docelowe na ..',
    'rule_action_set_destination_account'        => 'Ustaw konto docelowe na :action_value',
    'rule_action_append_notes_choice'            => 'Dołącz do notatek ..',
    'rule_action_append_notes'                   => 'Dołącz do notatek wartość ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Poprzedź notatki ..',
    'rule_action_prepend_notes'                  => 'Poprzedź notatki wartością ":action_value"',
    'rule_action_clear_notes_choice'             => 'Usuń wszystkie notatki',
    'rule_action_clear_notes'                    => 'Usuń wszystkie notatki',
    'rule_action_set_notes_choice'               => 'Ustaw notatki na ..',
    'rule_action_link_to_bill_choice'            => 'Powiąż z subskrypcją ..',
    'rule_action_link_to_bill'                   => 'Powiąż z subskrypcją ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Zamień konta źródłowe i docelowe (tylko przelewy!)',
    'rule_action_switch_accounts'                => 'Zamień konto źródłowe i docelowe',
    'rule_action_set_notes'                      => 'Ustaw notatki na ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Konwertuj transakcję na wpłatę',
    'rule_action_convert_deposit'                => 'Konwertuj transakcję na wpłatę od ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Konwertuj transakcję na wypłatę',
    'rule_action_convert_withdrawal'             => 'Konwertuj transakcję na wypłatę do ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Konwertuj transakcję na transfer',
    'rule_action_convert_transfer'               => 'Konwertuj transakcję na transfer z ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Dołącz opis do notatek transakcji',
    'rule_action_append_notes_to_descr_choice'   => 'Dołącz notatki transakcji do opisu',
    'rule_action_move_descr_to_notes_choice'     => 'Zastąp bieżące notatki transakcji opisem',
    'rule_action_move_notes_to_descr_choice'     => 'Zastąp bieżący opis notatkami transakcji',
    'rule_action_append_descr_to_notes'          => 'Dołącz opis do notatek',
    'rule_action_append_notes_to_descr'          => 'Dołącz notatki do opisu',
    'rule_action_move_descr_to_notes'            => 'Zastąp notatki opisem',
    'rule_action_move_notes_to_descr'            => 'Zastąp opis notatkami',
    'rule_action_set_amount_choice'              => 'Ustaw kwotę na ..',
    'rule_action_set_amount'                     => 'Ustaw kwotę na ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Ustaw konto docelowe na konto gotówkowe',
    'rule_action_set_source_to_cash_choice'      => 'Ustaw konto źródłowe na konto gotówkowe',
    'rulegroup_for_bills_title'                  => 'Grupa reguł dla subskrypcji',
    'rulegroup_for_bills_description'            => 'Specjalna grupa reguł dla wszystkich reguł, które dotyczą subskrypcji.',
    'rule_for_bill_title'                        => 'Automatycznie generowana reguła dla subskrypcji ":name"',
    'rule_for_bill_description'                  => 'Ta reguła jest automatycznie generowana, aby spróbować dopasować subskrypcję ":name".',
    'create_rule_for_bill'                       => 'Utwórz nową regułę dla subskrypcji ":name"',
    'create_rule_for_bill_txt'                   => 'Właśnie utworzyłeś nową subskrypcję o nazwie ":name". Gratulacje! Firefly III może automagicznie dopasować nowe wypłaty do tej subskrypcji. Na przykład za każdym razem, gdy płacisz czynsz, subskrypcja "czynsz" zostanie powiązana z wydatkiem. W ten sposób Firefly III może dokładnie pokazać, które subskrypcje są jeszcze do zapłacenia, a które nie. W tym celu należy utworzyć nową regułę. Firefly III wypełnił dla Ciebie pewne rozsądne domyślne ustawienia. Upewnij się, że są poprawne. Jeśli są, Firefly III automatycznie połączy pasującą wypłatę z prawidłową subskrypcją. Sprawdź czy wyzwalacze są poprawne i dodaj kolejne jeśli są błędne.',
    'new_rule_for_bill_title'                    => 'Reguła subskrypcji ":name"',
    'new_rule_for_bill_description'              => 'Ta reguła oznacza transakcje dla subskrypcji ":name".',

    'new_rule_for_journal_title'                => 'Reguła oparta na transakcji ":description"',
    'new_rule_for_journal_description'          => 'Ta reguła jest oparta na transakcji ":description". Będzie zgodna z transakcjami, które są dokładnie takie same.',

    // tags
    'store_new_tag'                             => 'Zachowaj nowy tag',
    'update_tag'                                => 'Zmodyfikuj tag',
    'no_location_set'                           => 'Nie ustawiono lokalizacji.',
    'meta_data'                                 => 'Metadane',
    'location'                                  => 'Lokalizacja',
    'location_first_split'                      => 'Lokalizacja dla tej transakcji może być ustawiona w pierwszym podziale tej transakcji.',
    'without_date'                              => 'Bez daty',
    'result'                                    => 'Wynik',
    'sums_apply_to_range'                       => 'Wszystkie sumy mają zastosowanie do wybranego zakresu',
    'mapbox_api_key'                            => 'Aby użyć mapy, pobierz klucz API z <a href="https://www.mapbox.com/">Mapbox</a>. Otwórz plik <code>.env</code> i wprowadź ten kod po <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Kliknij prawym przyciskiem myszy lub naciśnij i przytrzymaj aby ustawić lokalizację obiektu.',
    'click_tap_location'                        => 'Kliknij lub naciśnij mapę, aby dodać lokalizację',
    'clear_location'                            => 'Wyczyść lokalizację',
    'delete_all_selected_tags'                  => 'Usuń wszystkie zaznaczone tagi',
    'select_tags_to_delete'                     => 'Nie zapomnij wybrać tagów.',
    'deleted_x_tags'                            => 'Usunięto :count tag.|Usunięto :count tagów.',
    'create_rule_from_transaction'              => 'Utwórz regułę na podstawie transakcji',
    'create_recurring_from_transaction'         => 'Utwórz cykliczną transakcję na podstawie transakcji',

    // preferences
    'test_notifications_buttons'                => 'Aby przetestować konfigurację, użyj poniższych przycisków. Pamiętaj, że przyciski nie mają kontroli spamu.',
    'dark_mode_option_browser'                  => 'Pozwól Twojej przeglądarce decydować',
    'dark_mode_option_light'                    => 'Zawsze jasny',
    'dark_mode_option_dark'                     => 'Zawsze ciemny',
    'equal_to_language'                         => '(równe językowi)',
    'dark_mode_preference'                      => 'Tryb ciemny',
    'dark_mode_preference_help'                 => 'Powiedz Firefly III, kiedy użyć trybu ciemnego.',
    'pref_home_screen_accounts'                 => 'Konta na stronie domowej',
    'pref_home_screen_accounts_help'            => 'Które konta powinny być wyświetlane na stronie głównej?',
    'pref_view_range'                           => 'Zakres widoku',
    'pref_view_range_help'                      => 'Niektóre wykresy są automatycznie grupowane w okresy. Twoje budżety będą również pogrupowane w okresy. Jaki okres wolisz?',
    'pref_1D'                                   => 'Dzień',
    'pref_1W'                                   => 'Tydzień',
    'pref_1M'                                   => 'Miesiąc',
    'pref_3M'                                   => 'Trzy miesiące (kwartał)',
    'pref_6M'                                   => 'Sześć miesięcy',
    'pref_1Y'                                   => 'Rok',
    'pref_last365'                              => 'Ostatni rok',
    'pref_last90'                               => 'Ostatnie 90 dni',
    'pref_last30'                               => 'Ostatnie 30 dni',
    'pref_last7'                                => 'Ostatnie 7 dni',
    'pref_YTD'                                  => 'Rok do daty',
    'pref_QTD'                                  => 'Kwartał do daty',
    'pref_MTD'                                  => 'Miesiąc do daty',
    'pref_languages'                            => 'Języki',
    'pref_locale'                               => 'Ustawienia regionalne',
    'pref_languages_help'                       => 'Firefly III obsługuje kilka języków. Który wolisz?',
    'pref_locale_help'                          => 'Firefly III pozwala na ustawienie innych ustawień lokalnych, takich jak formatowanie walut, liczb i dat. Wpisy na tej liście mogą nie być obsługiwane przez Twój system. Firefly III nie ma poprawnych ustawień daty dla każdego miejsca; skontaktuj się ze mną, abym mógł to ulepszyć.',
    'pref_locale_no_demo'                       => 'Ta funkcja nie zadziała dla użytkownika demonstracyjnego.',
    'pref_convert_to_primary'                   => 'Wyświetl kwoty w swojej walucie głównej',
    'pref_convert_to_primary_help'              => 'Ta opcja sprawi, że Firefly III spróbuje wyświetlić i pokazać twoją walutę główną w możliwie największej liczbie miejsc, przeliczając kwoty tam, gdzie jest to konieczne. To pogarsza dokładność w celu ułatwienia użycia, ponieważ konwersja nie zawsze jest dokładna. Upewnij się, że Firefly III posiada niezbędne kursy wymiany na stronie "kursów wymiany".',
    'pref_convert_primary_help'                 => 'Wyświetl kwoty główne',
    'pref_custom_fiscal_year'                   => 'Ustawienia roku podatkowego',
    'pref_custom_fiscal_year_label'             => 'Włączone',
    'pref_custom_fiscal_year_help'              => 'W krajach, w których rok podatkowy nie zaczyna się 1 stycznia i nie kończy 31 grudnia, możesz włączyć tą opcję oraz podać początek / koniec roku podatkowego',
    'pref_fiscal_year_start_label'              => 'Początek roku podatkowego',
    'pref_two_factor_auth'                      => 'Uwierzytelnianie wieloskładnikowe (MFA)',
    'pref_two_factor_auth_help'                 => 'Po włączeniu uwierzytelniania wieloskładnikowego (znanego również jako uwierzytelnianie dwuskładnikowe), dodajesz dodatkową warstwę zabezpieczeń do swojego konta. Logujesz się czymś, co znasz (hasło) i czymś, co masz (kod weryfikacyjny). Kody weryfikacyjne są generowane przez aplikację na telefonie, taką jak Authy lub Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Włącz uwierzytelnianie wieloskładnikowe (MFA)',
    'pref_two_factor_auth_disabled'             => 'Kod weryfikacyjny uwierzytelniania wieloetapowego został usunięty i wyłączony',
    'pref_two_factor_auth_remove_it'            => 'Nie zapomnij usunąć konta z aplikacji uwierzytelniajcej!',
    'pref_two_factor_auth_code'                 => 'Zweryfikuj kod',
    'pref_two_factor_auth_code_help'            => 'Zeskanuj kod QR za pomocą aplikacji na telefonie, takiej jak Authy lub Google Authenticator i wprowadź wygenerowany kod. Kod QR zmienia się za każdym razem, gdy odwiedzasz tę stronę. Upewnij się, że używasz najnowszego.',
    'pref_two_factor_auth_reset_code'           => 'Zresetuj kod weryfikacyjny',
    'pref_two_factor_auth_disable_2fa'          => 'Wyłącz uwierzytelnianie wieloskładnikowe (MFA)',
    '2fa_use_secret_instead'                    => 'Jeżeli nie możesz zeskanować kodu QR użyj sekretu: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Zachowaj te kody na wypadek zgubienia urządzenia.',
    '2fa_already_enabled'                       => 'Uwierzytelnianie wieloetapowe (MFA) jest już włączone.',
    'wrong_mfa_code'                            => 'Ten kod uwierzytelniania nie jest prawidłowy.',
    'pref_save_settings'                        => 'Zapisz ustawienia',
    'saved_preferences'                         => 'Preferencje zostały zapisane!',
    'preferences_general'                       => 'Ogólne',
    'preferences_frontpage'                     => 'Ekran główny',
    'preferences_security'                      => 'Bezpieczeństwo',
    'preferences_layout'                        => 'Układ',
    'preferences_notifications'                 => 'Powiadomienia',
    'pref_home_show_deposits'                   => 'Pokaż przychody na stronie domowej',
    'pref_home_show_deposits_info'              => 'Ekran główny pokazuje już konta wydatków. Czy chcesz wyświetlać również konta przychodów?',
    'pref_home_do_show_deposits'                => 'Tak, pokaż je',
    'successful_count'                          => 'z których :count zakończone pomyślnie',
    'list_page_size_title'                      => 'Rozmiar strony',
    'list_page_size_help'                       => 'Każda lista rzeczy (konta, transakcje itp.) pokazuje co najwyżej tyle na stronę.',
    'list_page_size_label'                      => 'Rozmiar strony',
    'between_dates'                             => '(:start i :end)',
    'pref_optional_fields_transaction'          => 'Opcjonalne pola dla transakcji',
    'pref_optional_fields_transaction_help'     => 'Domyślnie nie wszystkie pola są aktywne podczas tworzenia nowej transakcji (aby uniknąć bałaganu). Poniżej możesz włączyć te pola, jeśli uważasz, że mogą one być przydatne dla Ciebie. Oczywiście każde pole, które jest wyłączone, ale już wypełnione, będzie widoczne niezależnie od ustawienia.',
    'optional_tj_date_fields'                   => 'Pola dat',
    'optional_tj_other_fields'                  => 'Inne pola',
    'optional_tj_attachment_fields'             => 'Pola załączników',
    'pref_optional_tj_interest_date'            => 'Data odsetek',
    'pref_optional_tj_book_date'                => 'Data księgowania',
    'pref_optional_tj_process_date'             => 'Data przetworzenia',
    'pref_optional_tj_due_date'                 => 'Termin realizacji',
    'pref_optional_tj_payment_date'             => 'Data płatności',
    'pref_optional_tj_invoice_date'             => 'Data faktury',
    'pref_optional_tj_internal_reference'       => 'Wewnętrzny numer',
    'pref_optional_tj_notes'                    => 'Notatki',
    'pref_optional_tj_attachments'              => 'Załączniki',
    'pref_optional_tj_external_url'             => 'Zewnętrzny adres URL',
    'pref_optional_tj_location'                 => 'Lokalizacja',
    'pref_optional_tj_links'                    => 'Powiązane transakcje',
    'optional_field_meta_dates'                 => 'Daty',
    'optional_field_meta_business'              => 'Biznesowe',
    'optional_field_attachments'                => 'Załączniki',
    'optional_field_meta_data'                  => 'Opcjonalne metadane',
    'external_url'                              => 'Zewnętrzny adres URL',
    'pref_notification_login_failure'           => 'Nieudane logowanie',
    'pref_notification_bill_reminder'           => 'Przypomnienie o wygasających subskrypcjach',
    'pref_notification_new_access_token'        => 'Powiadomienie o utworzeniu nowego tokenu dostępu API',
    'pref_notification_transaction_creation'    => 'Powiadomienie o automatycznym utworzeniu transakcji',
    'pref_notification_user_login'              => 'Powiadomienie o zalogowaniu się z nowej lokalizacji',
    'pref_notification_rule_action_failures'    => 'Powiadomienie o niewykonaniu akcji reguły (nie przez e-mail)',
    'pref_notification_new_password'            => 'Twoje hasło zostało zmienione',
    'pref_notification_enabled_mfa'             => 'Uwierzytelnianie wieloskładnikowe (MFA) jest włączone',
    'pref_notification_disabled_mfa'            => 'Uwierzytelnianie wieloskładnikowe (MFA) jest wyłączone',
    'pref_notification_few_left_mfa'            => 'Pozostało tylko kilka kodów zapasowych',
    'pref_notification_no_left_mfa'             => 'Nie masz już kodów zapasowych',
    'pref_notification_many_failed_mfa'         => 'Sprawdzanie uwierzytelniania wieloskładnikowego wielokrotnie się nie powiodło',
    'pref_notification_new_backup_codes'        => 'Nowe kody zapasowe zostały wygenerowane',
    'pref_notifications'                        => 'Powiadomienia',
    'pref_notifications_help'                   => 'Wskaż, czy są to powiadomienia, które chcesz otrzymywać. Niektóre powiadomienia mogą zawierać wrażliwe informacje finansowe.',
    'pref_notifications_settings'               => 'Ustawienia powiadomień',
    'pref_notifications_settings_help'          => 'Użyj tych ustawień, aby skonfigurować kanały powiadomień. Pamiętaj, że powiadomienia zostaną wysłane do WSZYSTKICH kanałów. KONIECZNIE zapisz swoje ustawienia.',
    'slack_url_label'                           => 'Adres URL "przychodzącego webhooka" dla Slacka',
    'discord_url_label'                         => 'Link do webhooka Discorda',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Kursy walutowe',
    'header_exchange_rates'                     => 'Kursy walutowe',
    'exchange_rates_intro'                      => 'Firefly III obsługuje pobieranie i korzystanie z kursów wymiany walut. Więcej informacji na ten temat w <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">dokumentacji</a>.',
    'exchange_rates_from_to'                    => 'Pomiędzy {from} i {to} (i odwrotnie)',
    'header_exchange_rates_rates'               => 'Kursy walutowe',
    'exchange_rates_intro_rates'                => 'Firefly III używa następujących kursów wymiany. Odwrotny jest obliczany automatycznie, w przypadku gdy nie jest dostarczony. Jeśli dla daty transakcji nie istnieje kurs wymiany, Firefly III skorzysta z kursu z przeszłości. Jeśli żaden nie istnieje, zostanie zastosowany kurs "1".',
    'header_exchange_rates_table'               => 'Tabela z kursami wymiany walut',
    'help_rate_form'                            => 'Tego dnia, ile {to} otrzymasz za jeden {from}?',
    'save_new_rate'                             => 'Zapisz nowy kurs',
    'add_new_rate'                              => 'Dodaj nowy kurs wymiany',
    'not_enough_currencies'                     => 'Za mało walut',
    'not_enough_currencies_enabled'             => 'Jeśli masz włączoną tylko jedną walutę, nie ma potrzeby dodawania kursów wymiany.',

    // Financial administrations
    'administration_index'                      => 'Zarządzanie finansami',
    'administrations_breadcrumb'                => 'Ustawienia finansowe',
    'administrations_page_title'                => 'Ustawienia finansowe',
    'administrations_index_menu'                => 'Ustawienia finansowe',
    'administrations_page_sub_title'            => 'Przegląd',
    'create_administration'                     => 'Utwórz nowe ustawianie',
    'administration_owner'                      => 'Administrator: {{email}}',
    'administration_you'                        => 'Twoja rola: {{role}}',
    'other_users_in_admin'                      => 'Inni użytkownicy w panelu administracji',
    'administrations_create_breadcrumb'         => 'Utwórz nowe ustawienia finansowe',
    'administrations_page_create_sub_title'     => 'Utwórz nowe ustawiania finansowe',
    'basic_administration_information'          => 'Podstawowe informacje administracyjne',
    'new_administration_created'                => 'Nowe ustawienie finansowe "{{title}}" zostało utworzone',
    'edit_administration_breadcrumb'            => 'Edytuj ustawienia finansowe ":title"',
    'administrations_page_edit_sub_title'       => 'Edytuj ustawienia finansowe ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edytuj ustawienia finansowe "{title}"',
    'temp_administrations_introduction'         => 'Firefly III wkrótce uzyska możliwość zarządzania wieloma ustawieniami finansowymi. W tej chwili jest tylko jedno domyślne ustawienie. Możesz ustawić jego tytuł i walutę główną. To zastępuje poprzednie ustawienia, w którym można było ustawić "domyślną walutę". Jest ona obecnie powiązana z wybranym ustawieniem finansowym i może być zmienione w tej zakładce.',
    'temp_administrations_introduction_edit'    => 'Obecnie możesz ustawić tylko "walutę główną" w domyślnie utworzonych ustawieniach finansowych. To zastępuje "domyślną walutę". To ustawienie jest obecnie powiązane z ustawieniami finansowymi i może być różne w zależności, które z nich zostało wybrane.',
    'administration_currency_form_help'         => 'Wczytywanie strony może zająć dużo czasu, jeśli zmienisz walutę główną, ponieważ transakcja może wymagać przewalutowania na (nową) walutę główną.',
    'flash_administration_updated'              => 'Administracja ":title" została zaktualizowana',
    'flash_administration_created'              => 'Administracja ":title" została utworzona',
    'flash_administration_deleted'              => 'Administracja ":title" została usunięta',

    // roles
    'administration_role_owner'                 => 'Właściciel',
    'administration_role_ro'                    => 'Tylko do odczytu',
    'administration_role_mng_trx'               => 'Zarządzanie transakcjami',
    'administration_role_mng_meta'              => 'Zarządzanie klasyfikacją i meta-danymi',
    'administration_role_mng_budgets'           => 'Zarządzanie budżetami',
    'administration_role_mng_piggies'           => 'Zarządzanie skarbonkami',
    'administration_role_mng_subscriptions'     => 'Zarządzanie subskrypcjami',
    'administration_role_mng_rules'             => 'Zarządzanie regułami',
    'administration_role_mng_recurring'         => 'Zarządzanie cyklicznymi transakcjami',
    'administration_role_mng_webhooks'          => 'Zarządzanie webhookami',
    'administration_role_mng_currencies'        => 'Zarządzanie walutami',
    'administration_role_view_reports'          => 'Odczyt raportów',
    'administration_role_full'                  => 'Pełny dostęp',

    // mfa
    'enable_mfa'                                => 'Włącz uwierzytelnianie wieloskładnikowe (MFA)',
    'mfa_index_title'                           => 'Uwierzytelnianie wieloskładnikowe (MFA)',
    'mfa_index_intro'                           => 'Firefly III obsługuje uwierzytelnianie wieloskładnikowe (MFA). Możesz włączyć MFA dla swojego konta, aby dodać dodatkową warstwę bezpieczeństwa. Aplikacje takie jak Authy, Google Authenticator i FreeOTP mogą być używane do generowania kodów potrzebnych do logowania. Klucze bezpieczeństwa nie są obsługiwane przez Firefly III, ale możesz użyć klucza bezpieczeństwa jako urządzenie do przechowywania swojego sekretu MFA.',
    'mfa_index_enabled'                         => 'Uwierzytelnianie wieloetapowe jest włączone dla Twojego konta.',
    'mfa_index_disabled'                        => 'Uwierzytelnianie wieloetapowe nie jest włączone dla Twojego konta.',
    'mfa_index_owner'                           => 'Właściciel tej instancji będzie zawsze w stanie wyłączyć uwierzytelnianie wieloetapowe dla Twojego konta.',
    'current_password_confirm_mfa'              => 'Podaj obecne hasło',
    'mfa_warning_code_changes'                  => 'Po wprowadzeniu hasła i kodu MFA może pokazać się nowe okno dialogowe MFA. W takim przypadku poczekaj na wygenerowanie nowego kodu MFA, zamiast używać tego, który właśnie zużyłeś.',
    'mfa_already_disabled'                      => 'Uwierzytelnianie wieloetapowe nie jest włączone, więc nie możesz go wyłączyć.',
    'disable_mfa_page'                          => 'Wyłącz uwierzytelnianie wieloetapowe',
    'disable_mfa_intro'                         => 'Możesz wyłączyć uwierzytelnianie wieloskładnikowe. Aby to zrobić, wprowadź hasło i kod uwierzytelniania wieloskładnikowego. Jeśli chcesz wyłączyć uwierzytelnianie wieloskładnikowe, ponieważ straciłeś dostęp do generatora kodów, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">zapoznaj się z dokumentacją</a>.',
    'pref_disable_mfa'                          => 'Wyłącz uwierzytelnianie wieloetapowe',
    'mfa_not_enabled'                           => 'Uwierzytelnianie wieloetapowe nie jest włączone.',
    'mfa_backup_codes_intro'                    => 'Firefly III może wygenerować dla Ciebie kody zapasowe. Te kody mogą być użyte do logowania, gdy nie możesz użyć generatora kodu. Możesz wygenerować nowy zestaw kodów w dowolnym momencie. Jeśli wygenerujesz nowy zestaw, stary zostanie unieważniony.',
    'mfa_backup_codes_quick'                    => 'Jeśli bardzo szybko przychodzisz ze strony konfiguracji uwierzytelniania wieloskładnikowego, Twoja aplikacja mogła jeszcze nie wygenerować nowego kodu. Kody MFA mogą być użyte tylko raz. Upewnij się, że używasz innego kodu niż poprzedni.',
    'mfa_backup_codes_title'                    => 'Kody zapasowe uwierzytelniania wieloetapowego',
    'mfa_backup_codes_post_title'               => 'Kody zapasowe uwierzytelniania wieloetapowego',

    // profile:
    'manage_mfa_settings'                       => 'Zarządzaj ustawieniami uwierzytelniania wieloetapowego',
    'purge_data_title'                          => 'Wyczyść dane z Firefly III',
    'purge_data_expl'                           => '"Wyczyszczenie" oznacza "usunięcie tego, co zostało już usunięte". W normalnych warunkach Firefly III nie usuwa nic na stałe. Po prostu je ukrywa. Przycisk poniżej usuwa wszystkie "usunięte" rekordy na ZAWSZE.',
    'delete_stuff_header'                       => 'Usuń i wyczyść dane',
    'purge_all_data'                            => 'Wyczyść wszystkie usunięte wpisy',
    'purge_data'                                => 'Wyczyść dane',
    'purged_all_records'                        => 'Wszystkie usunięte rekordy zostały wyczyszczone.',
    'delete_data_title'                         => 'Usuń dane z Firefly III',
    'permanent_delete_stuff'                    => 'Możesz usuwać rzeczy z Firefly III. Użycie poniższych przycisków oznacza, że Twoje wpisy zostaną usunięte z widoku i ukryte. Nie ma przycisku cofnięcia, ale wpisy mogą pozostać w bazie danych, skąd możesz je odzyskać, jeśli to konieczne.',
    'other_sessions_logged_out'                 => 'Wszystkie twoje inne sesje zostały wylogowane.',
    'delete_unused_accounts'                    => 'Usunięcie nieużywanych kont spowoduje wyczyszczenie list auto-uzupełniania.',
    'delete_all_unused_accounts'                => 'Usuń nieużywane konta',
    'deleted_all_unused_accounts'               => 'Wszystkie nieużywane konta zostały usunięte',
    'delete_all_budgets'                        => 'Usuń WSZYSTKIE budżety',
    'delete_all_categories'                     => 'Usuń WSZYSTKIE kategorie',
    'delete_all_tags'                           => 'Usuń WSZYSTKIE tagi',
    'delete_all_bills'                          => 'Usuń WSZYSTKIE subskrypcje',
    'delete_all_piggy_banks'                    => 'Usuń WSZYSTKIE skarbonki',
    'delete_all_rules'                          => 'Usuń WSZYSTKIE reguły',
    'delete_all_recurring'                      => 'Usuń WSZYSTKIE transakcje cykliczne',
    'delete_all_object_groups'                  => 'Usuń WSZYSTKIE grupy obiektów',
    'delete_all_accounts'                       => 'Usuń WSZYSTKIE konta',
    'delete_all_asset_accounts'                 => 'Usuń WSZYSTKIE konta aktywów',
    'delete_all_expense_accounts'               => 'Usuń WSZYSTKIE konta wydatków',
    'delete_all_revenue_accounts'               => 'Usuń WSZYSTKIE konta przychodów',
    'delete_all_liabilities'                    => 'Usuń WSZYSTKIE swoje zobowiązania',
    'delete_all_transactions'                   => 'Usuń WSZYSTKIE transakcje',
    'delete_all_withdrawals'                    => 'Usuń WSZYSTKIE wydatki',
    'delete_all_deposits'                       => 'Usuń WSZYSTKIE wpłaty',
    'delete_all_transfers'                      => 'Usuń WSZYSTKIE przelewy',
    'also_delete_transactions'                  => 'Usunięcie kont spowoduje również usunięcie WSZYSTKICH powiązanych wydatków, wpłat i transferów!',
    'deleted_all_budgets'                       => 'Usunięto wszystkie budżety',
    'deleted_all_categories'                    => 'Usunięto wszystkie kategorie',
    'deleted_all_tags'                          => 'Usunięto wszystkie tagi',
    'deleted_all_bills'                         => 'Wszystkie subskrypcje zostały usunięte',
    'deleted_all_piggy_banks'                   => 'Wszystkie skarbonki zostały usunięte',
    'deleted_all_rules'                         => 'Wszystkie reguły i grupy reguł zostały usunięte',
    'deleted_all_object_groups'                 => 'Wszystkie grupy zostały usunięte',
    'deleted_all_accounts'                      => 'Wszystkie konta zostały usunięte',
    'deleted_all_asset_accounts'                => 'Wszystkie konta aktywów zostały usunięte',
    'deleted_all_expense_accounts'              => 'Wszystkie konta wydatków zostały usunięte',
    'deleted_all_revenue_accounts'              => 'Wszystkie konta przychodów zostały usunięte',
    'deleted_all_liabilities'                   => 'Wszystkie zobowiązania zostały usunięte',
    'deleted_all_transactions'                  => 'Wszystkie transakcje zostały usunięte',
    'deleted_all_withdrawals'                   => 'Wszystkie wydatki zostały usunięte',
    'deleted_all_deposits'                      => 'Wszystkie wpłaty zostały usunięte',
    'deleted_all_transfers'                     => 'Wszystkie przelewy zostały usunięte',
    'deleted_all_recurring'                     => 'Wszystkie cykliczne transakcje zostały usunięte',
    'change_your_password'                      => 'Zmień swoje hasło',
    'delete_account'                            => 'Usuń konto',
    'current_password'                          => 'Bieżące hasło',
    'new_password'                              => 'Nowe Hasło',
    'new_password_again'                        => 'Nowe hasło (ponownie)',
    'delete_your_account'                       => 'Usuń swoje konto',
    'delete_your_account_help'                  => 'Usunięcie twojego konta usunie również wszystkie konta, transakcje, <em>wszystko</em> co mogłeś mieć zapisane w Firefly III. Po prostu ZNIKNIE.',
    'delete_your_account_password'              => 'Wprowadź hasło aby kontynuować.',
    'password'                                  => 'Hasło',
    'are_you_sure'                              => 'Jesteś pewny? Nie możesz tego cofnąć.',
    'are_you_sure_confirm'                      => 'Na pewno?',
    'delete_account_button'                     => 'USUŃ swoje konto',
    'invalid_current_password'                  => 'Nieprawidłowe bieżące hasło!',
    'password_changed'                          => 'Hasło zostało zmienione!',
    'should_change'                             => 'Chodzi o to, aby zmienić swoje hasło.',
    'invalid_password'                          => 'Nieprawidłowe hasło!',
    'what_is_pw_security'                       => 'Co to jest "Sprawdź bezpieczeństwo hasła"?',
    'secure_pw_title'                           => 'Jak wybrać bezpieczne hasło',
    'forgot_password_response'                  => 'Dziękujemy. Jeśli istnieje konto z tym adresem e-mail, instrukcje znajdziesz w swojej skrzynce odbiorczej.',
    'secure_pw_history'                         => 'Nie ma tygodnia w którym nie czytalibyśmy w wiadomościach o stronie, która straciła hasła swoich użytkowników. Hakerzy i złodzieje używają tych haseł, aby wykraść twoje prywatne informacje. Te informacje są cenne.',
    'secure_pw_ff'                              => 'Czy używasz tego samego hasła w całym Internecie? Jeśli jedna strona straci Twoje hasło, hakerzy będą mieli dostęp do wszystkich Twoich danych. Firefly III polega na Twoim wyborze silnego i unikatowego hasła w celu ochrony Twojej dokumentacji finansowej.',
    'secure_pw_check_box'                       => 'Aby Ci pomóc, Firefly III może sprawdzić, czy hasło, którego chcesz użyć, zostało w przeszłości skradzione. Jeśli okaże się to prawdą, Firefly III radzi NIE używać tego hasła.',
    'secure_pw_working_title'                   => 'Jak to działa?',
    'secure_pw_working'                         => 'Zaznaczając to pole, Firefly III wyśle pierwsze pięć znaków skrótu SHA1 Twojego hasła do <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">strony internetowej Troy Hunt</a>, aby sprawdzić, czy znajduje się ono na liście haseł, które wyciekły. To powstrzyma Cię przed używaniem niebezpiecznych haseł, co jest zalecane w najnowszej <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">specjalnej publikacji Narodowy Instytut Standaryzacji i Technologii (NIST)</a> na ten temat.',
    'secure_pw_should'                          => 'Czy powinienem zaznaczyć to pole?',
    'secure_pw_long_password'                   => 'Tak. Zawsze sprawdź, czy hasło jest bezpieczne.',
    'command_line_token'                        => 'Token wiersza poleceń',
    'explain_command_line_token'                => 'Potrzebujesz tego tokenu aby wykonywać operacje (takie jak eksportowanie danych) za pomocą wiersza poleceń. Bez niego takie wrażliwe polecenia nie będą działać. Nie udostępniaj nikomu swojego tokenu. Nikt Cię o niego nie zapyta, nawet ja. Jeżeli obawiasz się, że go straciłeś lub jesteś paranoikiem, wygeneruj nowy token używając przycisku.',
    'regenerate_command_line_token'             => 'Wygeneruj nowy token wiersza poleceń',
    'token_regenerated'                         => 'Wygenerowano nowy token wiersza poleceń',
    'change_your_email'                         => 'Zmień swój adres e-mail',
    'email_verification'                        => 'Wiadomość e-mail zostanie wysłana na Twój stary ORAZ nowy adres e-mail. Ze względów bezpieczeństwa nie będziesz mógł się zalogować, dopóki nie zweryfikujesz swojego nowego adresu e-mail. Jeśli nie jesteś pewien, czy twoja instalacja Firefly III jest zdolna do wysyłania wiadomości e-mail, nie używaj tej funkcji. Jeśli jesteś administratorem, możesz przetestować to w <a href="settings">ustawieniach</a>.',
    'email_changed_logout'                      => 'Dopóki nie zweryfikujesz swojego adresu e-mail, nie możesz się zalogować.',
    'login_with_new_email'                      => 'Teraz możesz logować się nowym adresem e-mail.',
    'login_with_old_email'                      => 'Teraz ponownie możesz logować się starym adresem e-mail.',
    'login_provider_local_only'                 => 'Ta akcja nie jest dostępna gdy uwierzytelniasz się poprzez ":login_provider".',
    'external_user_mgt_disabled'                => 'Ta akcja nie jest dostępna, gdy Firefly III nie jest odpowiedzialny za zarządzanie użytkownikiem lub obsługę uwierzytelniania.',
    'external_auth_disabled'                    => 'Ta akcja nie jest dostępna, gdy Firefly III nie jest odpowiedzialny za obsługę uwierzytelniania.',
    'delete_local_info_only'                    => "Ponieważ Firefly III nie jest odpowiedzialny za zarządzanie użytkownikami lub obsługę uwierzytelniania, ta funkcja usunie tylko lokalne informacje Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Klienci OAuth',
    'profile_oauth_no_clients'                  => 'Nie utworzyłeś żadnych klientów OAuth.',
    'profile_oauth_clients_external_auth'       => 'Jeśli używasz zewnętrznego dostawcy uwierzytelniania, takiego jak Authelia, klienci OAuth nie będą działać. Możesz używać tylko osobistych tokenów dostępu.',
    'profile_oauth_clients_header'              => 'Klienci',
    'profile_oauth_client_id'                   => 'ID klienta',
    'profile_oauth_client_name'                 => 'Nazwa',
    'profile_oauth_client_secret'               => 'Sekretny klucz',
    'profile_oauth_create_new_client'           => 'Utwórz nowego klienta',
    'profile_oauth_create_client'               => 'Utwórz klienta',
    'profile_oauth_edit_client'                 => 'Edytuj klienta',
    'profile_oauth_name_help'                   => 'Coś, co Twoi użytkownicy będą rozpoznawać i ufać.',
    'profile_oauth_redirect_url'                => 'Przekierowanie URL',
    'profile_oauth_redirect_url_help'           => 'Adres URL wywołania zwrotnego autoryzacji aplikacji.',
    'profile_authorized_apps'                   => 'Autoryzowane aplikacje',
    'profile_authorized_clients'                => 'Autoryzowani klienci',
    'profile_scopes'                            => 'Zakresy',
    'profile_revoke'                            => 'Unieważnij',
    'profile_oauth_client_secret_title'         => 'Sekret klienta',
    'profile_oauth_client_secret_expl'          => 'Oto twój nowy sekret klienta. Jest to jedyny raz, gdy zostanie wyświetlony, więc nie zgub go! Możesz teraz użyć tego sekretu, aby wykonać zapytania API.',
    'profile_personal_access_tokens'            => 'Osobiste tokeny dostępu',
    'profile_personal_access_token'             => 'Osobisty token dostępu',
    'profile_oauth_confidential'                => 'Poufne',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Oto twój nowy osobisty token dostępu. Jest to jedyny raz, gdy zostanie wyświetlony, więc nie zgub go! Możesz teraz użyć tego tokenu, aby wykonać zapytania API.',
    'profile_no_personal_access_token'          => 'Nie utworzyłeś żadnych osobistych tokenów.',
    'profile_create_new_token'                  => 'Utwórz nowy token',
    'profile_create_token'                      => 'Utwórz token',
    'profile_create'                            => 'Utwórz',
    'profile_save_changes'                      => 'Zapisz zmiany',
    'profile_whoops'                            => 'Uuuups!',
    'profile_something_wrong'                   => 'Coś poszło nie tak!',
    'profile_try_again'                         => 'Coś poszło nie tak. Spróbuj ponownie.',
    'amounts'                                   => 'Kwoty',
    'multi_account_warning_unknown'             => 'W zależności od rodzaju transakcji, którą tworzysz, konto źródłowe i/lub docelowe kolejnych podziałów może zostać ustawione na konto zdefiniowane w pierwszym podziale transakcji.',
    'multi_account_warning_withdrawal'          => 'Pamiętaj, że konto źródłowe kolejnych podziałów zostanie ustawione na konto zdefiniowane w pierwszym podziale wypłaty.',
    'multi_account_warning_deposit'             => 'Pamiętaj, że konto docelowe kolejnych podziałów zostanie ustawione na konto zdefiniowane w pierwszym podziale wpłaty.',
    'multi_account_warning_transfer'            => 'Pamiętaj, że konta źródłowe i docelowe kolejnych podziałów zostaną ustawione na konto zdefiniowane w pierwszym podziale transferu.',


    // export data:
    'export_data_title'                         => 'Eksportuj dane z Firefly III',
    'export_data_menu'                          => 'Eksportuj dane',
    'export_data_bc'                            => 'Eksportuj dane z Firefly III',
    'export_data_main_title'                    => 'Eksportuj dane z Firefly III',
    'export_data_expl'                          => 'Ten odnośnik pozwala wyeksportować wszystkie transakcje i metadane z Firefly III. Więcej informacji o procesie znajdziesz w pomocy (ikonka (?) w prawym górnym rogu).',
    'export_data_all_transactions'              => 'Eksportuj wszystkie transakcje',
    'export_data_advanced_expl'                 => 'Jeśli potrzebujesz bardziej zaawansowanego lub specyficznego rodzaju eksportu, przeczytaj pomoc, jak użyć polecenia konsoli <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Jeden załącznik |:count załączników',
    'attachments'                               => 'Załączniki',
    'edit_attachment'                           => 'Modyfikuj załącznik ":name"',
    'update_attachment'                         => 'Aktualizuj załącznik',
    'delete_attachment'                         => 'Usuń załącznik ":name"',
    'attachment_deleted'                        => 'Usunięto załącznik ":name"',
    'liabilities_deleted'                       => 'Usunięto zobowiązanie ":name"',
    'attachment_updated'                        => 'Zmodyfikowano załącznik ":name"',
    'upload_max_file_size'                      => 'Maksymalny rozmiar pliku to: :size',
    'list_all_attachments'                      => 'Lista wszystkich załączników',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Ponieważ ta transakcja jest uzgodniona, nie będziesz w stanie zaktualizować kont, ani kwot(y), chyba że usuniesz flagę uzgodnienia.',
    'is_reconciled'                             => 'Jest uzgodniona',
    'title_expenses'                            => 'Wydatki',
    'title_withdrawal'                          => 'Wydatki',
    'title_revenue'                             => 'Przychód / dochód',
    'title_deposit'                             => 'Przychód / dochód',
    'title_transfer'                            => 'Transfery',
    'title_transfers'                           => 'Transfery',
    'submission_options'                        => 'Opcje zapisu',
    'apply_rules_checkbox'                      => 'Zastosuj reguły',
    'fire_webhooks_checkbox'                    => 'Uruchom webhooki',
    'select_source_account'                     => 'Wybierz lub wpisz prawidłową nazwę konta źródłowego',
    'select_dest_account'                       => 'Wybierz lub wpisz prawidłową nazwę konta docelowego',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Ta transakcja jest już wypłatą',
    'convert_is_already_type_Deposit'           => 'Ta transakcja jest już wpłatą',
    'convert_is_already_type_Transfer'          => 'Ta transakcja jest już transferem',
    'convert_to_Withdrawal'                     => 'Konwertuj ":description" na wypłatę',
    'convert_to_Deposit'                        => 'Konwertuj ":description" na wpłatę',
    'convert_to_Transfer'                       => 'Konwertuj ":description" na transfer',
    'convert_options_WithdrawalDeposit'         => 'Konwertuj wypłatę na wpłatę',
    'convert_options_WithdrawalTransfer'        => 'Konwertuj wypłatę na transfer',
    'convert_options_DepositTransfer'           => 'Konwertuj wpłatę na transfer',
    'convert_options_DepositWithdrawal'         => 'Konwertuj wpłatę na wypłatę',
    'convert_options_TransferWithdrawal'        => 'Konwertuj transfer na wypłatę',
    'convert_options_TransferDeposit'           => 'Konwertuj transfer na wpłatę',
    'convert_Withdrawal_to_deposit'             => 'Konwertuj tę wypłatę na wpłatę',
    'convert_Withdrawal_to_transfer'            => 'Konwertuj tę wypłatę na transfer',
    'convert_Deposit_to_withdrawal'             => 'Konwertuj tę wpłatę na wypłatę',
    'convert_Deposit_to_transfer'               => 'Konwertuj tę wpłatę na transfer',
    'convert_Transfer_to_deposit'               => 'Konwertuj ten transfer na wpłatę',
    'convert_Transfer_to_withdrawal'            => 'Konwertuj ten transfer na wypłatę',
    'convert_please_set_revenue_source'         => 'Proszę wybierz konto przychodów, z którego będą przychodzić pieniądze.',
    'convert_please_set_asset_destination'      => 'Proszę wybierz konto aktywów, do którego będą wychodzić pieniądze.',
    'convert_please_set_expense_destination'    => 'Proszę wybierz konto wydatków, do którego będą wychodzić pieniądze.',
    'convert_please_set_asset_source'           => 'Proszę wybierz konto aktywów, z którego będą przychodzić pieniądze.',
    'convert_expl_w_d'                          => 'Podczas konwersji z wypłaty na wpłatę pieniądze zostaną wpłacone na wyświetlane konto docelowe, a nie wycofane z niego.|Podczas konwersji z wypłaty na wpłatę pieniądze zostaną wpłacone na wyświetlane konta docelowe, a nie wycofane z nich.',
    'convert_expl_w_t'                          => 'Podczas konwersji wypłaty na przelew, środki zostaną przeniesione z rachunku źródłowego na inny rachunek aktywów lub zobowiązań zamiast być wydane na oryginalnym koncie wydatków.|Podczas konwersji wypłaty na przelew, środki zostaną przeniesione z rachunków źródłowych na inne rachunki aktywów lub zobowiązań zamiast być wydane na oryginalnych kontach wydatków.',
    'convert_expl_d_w'                          => 'Podczas konwersji z wpłaty na wypłatę pieniądze zostaną wypłacone z wyświetlanego konta źródłowego, a nie wpłacone na nie.|Podczas konwersji z wpłaty na wypłatę pieniądze zostaną wypłacone z wyświetlanych kont źródłowych, a nie wpłacone na nie.',
    'convert_expl_d_t'                          => 'Kiedy zamienisz wpłatę na przelew, pieniądze zostaną wpłacone na wskazany rachunek docelowy z dowolnego konta aktywów lub zobowiązań.|Kiedy zamienisz wpłatę na przelew, pieniądze zostaną wpłacone na wskazane konta docelowe z dowolnego konta aktywów lub pasywów.',
    'convert_expl_t_w'                          => 'Kiedy zmieniasz transfer na wydatek, pieniądze będą wydawane na konto docelowe, które tutaj ustawiłeś, zamiast być transferem.',
    'convert_expl_t_d'                          => 'Kiedy zamienisz transfer na wydatek, pieniądze zostaną wpłacone na konto docelowe, które widzisz tutaj, zamiast zostać na nie przekazane.',
    'convert_select_sources'                    => 'Aby zakończyć konwersję, proszę ustawić nowe konto źródłowe.|Aby zakończyć konwersję, ustaw nowe konta źródłowe.',
    'convert_select_destinations'               => 'Aby zakończyć konwersję, wybierz nowe konto docelowe poniżej.|Aby zakończyć konwersję, wybierz nowe konta docelowe poniżej.',
    'converted_to_Withdrawal'                   => 'Transakcja została przekonwertowana do wypłaty',
    'converted_to_Deposit'                      => 'Transakcja została przekonwertowana do wpłaty',
    'converted_to_Transfer'                     => 'Transakcja została przekonwertowana do transferu',
    'invalid_convert_selection'                 => 'Wybrane konto jest już używane w tej transakcji lub nie istnieje.',
    'source_or_dest_invalid'                    => 'Nie można znaleźć poprawnych szczegółów transakcji. Konwersja nie jest możliwa.',
    'convert_to_withdrawal'                     => 'Konwertuj na wypłatę',
    'convert_to_deposit'                        => 'Konwertuj na wpłatę',
    'convert_to_transfer'                       => 'Konwertuj na transfer',

    // create new stuff:
    'create_new_withdrawal'                     => 'Utwórz nową wypłatę',
    'create_new_deposit'                        => 'Utwórz nową wpłatę',
    'create_new_transfer'                       => 'Utwórz nowy transfer',
    'create_new_asset'                          => 'Utwórz nowe konto aktywów',
    'create_new_liabilities'                    => 'Utwórz nowe zobowiązanie',
    'create_new_expense'                        => 'Utwórz nowe konto wydatków',
    'create_new_revenue'                        => 'Utwórz nowe konto przychodów',
    'create_new_piggy_bank'                     => 'Utwórz nową skarbonkę',
    'create_new_bill'                           => 'Utwórz nową subskrypcję',
    'create_new_subscription'                   => 'Utwórz nową subskrypcję',
    'create_new_rule'                           => 'Utwórz nową regułę',

    // currencies:
    'create_currency'                           => 'Utwórz nową walutę',
    'store_currency'                            => 'Zapisz nową walutę',
    'update_currency'                           => 'Modyfikuj walutę',
    'new_default_currency'                      => '":name" jest teraz domyślną walutą.',
    'default_currency_failed'                   => 'Nie można ustawić ":name" jako domyślnej waluty. Proszę sprawdź dziennik zdarzeń.',
    'cannot_delete_currency'                    => 'Nie można usunąć waluty :name, ponieważ jest ona nadal używana.',
    'cannot_delete_fallback_currency'           => ':name jest walutą rezerwową systemu i nie można jej usunąć.',
    'cannot_disable_currency_journals'          => 'Nie można wyłączyć :name ponieważ istnieją powiązane transakcje.',
    'cannot_disable_currency_last_left'         => 'Nie można wyłączyć :name, ponieważ jest to ostatnia włączona waluta.',
    'cannot_disable_currency_account_meta'      => 'Nie można wyłączyć :name ponieważ jest użyte na kontach aktywów.',
    'cannot_disable_currency_bills'             => 'Nie można wyłączyć :name ponieważ jest używany w subskrypcjach.',
    'cannot_disable_currency_recurring'         => 'Nie można wyłączyć :name ponieważ jest użyte w transakcjach cyklicznych.',
    'cannot_disable_currency_available_budgets' => 'Nie można wyłączyć :name ponieważ jest użyte w dostępnych budżetach.',
    'cannot_disable_currency_budget_limits'     => 'Nie można wyłączyć :name ponieważ jest użyte w budżetach.',
    'cannot_disable_currency_current_default'   => 'Nie można wyłączyć :name ponieważ jest to bieżąca waluta domyślna.',
    'cannot_disable_currency_system_fallback'   => 'Nie można wyłączyć :name ponieważ jest to waluta domyślna systemu.',
    'disable_EUR_side_effects'                  => 'Euro jest awaryjną walutą w systemie. Deaktywacja może mieć nieprzewidziane skutki i może spowodować wygaśnięcie gwarancji.',
    'deleted_currency'                          => 'Waluta :name została usunięta',
    'created_currency'                          => 'Waluta :name została utworzona',
    'could_not_store_currency'                  => 'Nie można zapisać nowej waluty.',
    'updated_currency'                          => 'Waluta :name została zmodyfikowana',
    'ask_site_owner'                            => 'Poproś :owner aby dodał, usunął lub zmodyfikował waluty.',
    'currencies_intro'                          => 'Firefly III obsługuje różne waluty, które można ustawić i włączyć tutaj.',
    'currencies_switch_default'                 => 'Możesz przełączyć walutę główną dla bieżących ustawień finansowych w zakładce "Ustawienia finansowe".',
    'make_default_currency'                     => 'Ustaw jako domyślną',
    'default_currency'                          => 'domyślna',
    'primary_currency_button'                   => 'główna',
    'currency_is_disabled'                      => 'Nieaktywna',
    'enable_currency'                           => 'Aktywuj',
    'disable_currency'                          => 'Deaktywuj',
    'currencies_default_disabled'               => 'Większość z tych walut jest domyślnie wyłączona. Aby móc z nich korzystać, należy je wcześniej aktywować.',
    'currency_is_now_enabled'                   => 'Waluta ":name" została aktywowana',
    'could_not_enable_currency'                 => 'Nie można włączyć waluty ":name". Sprawdź dziennik zdarzeń.',
    'currency_is_now_disabled'                  => 'Waluta ":name" została deaktywowana',
    'could_not_disable_currency'                => 'Nie można wyłączyć waluty ":name". Być może jest w użyciu?',

    // forms:
    'mandatoryFields'                           => 'Pola wymagane',
    'optionalFields'                            => 'Pola opcjonalne',
    'options'                                   => 'Opcje',

    // budgets:
    'daily_budgets'                             => 'Budżety dzienne',
    'weekly_budgets'                            => 'Budżety tygodniowe',
    'monthly_budgets'                           => 'Budżety miesięczne',
    'quarterly_budgets'                         => 'Budżety kwartalne',
    'half_year_budgets'                         => 'Budżety półroczne',
    'yearly_budgets'                            => 'Budżety roczne',
    'other_budgets'                             => 'Budżety niestandardowe',
    'budget_limit_not_in_range'                 => 'Ta kwota dotyczy okresu od :start do :end:',
    'total_available_budget'                    => 'Dostępny budżet (pomiędzy :start i :end)',
    'total_available_budget_in_currency'        => 'Dostępny budżet w :currency',
    'see_below'                                 => 'zobacz poniżej',
    'create_new_budget'                         => 'Utwórz nowy budżet',
    'store_new_budget'                          => 'Zapisz nowy budżet',
    'stored_new_budget'                         => 'Zapisano nowy budżet ":name"',
    'available_between'                         => 'Dostępne od :start i :end',
    'transactionsWithoutBudget'                 => 'Wydatki bez budżetu',
    'transactions_no_budget'                    => 'Wydatki bez budżetu między :start i :end',
    'spent_between'                             => 'Wydano między :start i :end',
    'spent_between_left'                        => 'Wydano :spent pomiędzy :start i :end, pozostało :left.',
    'set_available_amount'                      => 'Ustaw dostępną kwotę',
    'update_available_amount'                   => 'Aktualizuj dostępną kwotę',
    'ab_basic_modal_explain'                    => 'Użyj tego formularza aby wskazać, ile jesteś w stanie zabudżetować (w sumie, w :currency) we skazanym okresie.',
    'createBudget'                              => 'Nowy budżet',
    'invalid_currency'                          => 'To jest niewłaściwa waluta',
    'invalid_amount'                            => 'Proszę podać kwotę',
    'set_ab'                                    => 'Dostępna kwota budżetu została ustalona',
    'updated_ab'                                => 'Dostępna kwota budżetu została zaktualizowana',
    'deleted_ab'                                => 'Dostępna kwota budżetu została usunięta',
    'deleted_bl'                                => 'Zabudżetowana kwota została usunięta',
    'alt_currency_ab_create'                    => 'Ustaw dostępny budżet w innej walucie',
    'bl_create_btn'                             => 'Ustaw budżet w innej walucie',
    'inactiveBudgets'                           => 'Nieaktywne budżety',
    'without_budget_between'                    => 'Transakcje bez budżetu między :start i :end',
    'delete_budget'                             => 'Usuń budżet ":name"',
    'deleted_budget'                            => 'Usunięto budżet ":name"',
    'edit_budget'                               => 'Modyfikuj budżet ":name"',
    'updated_budget'                            => 'Zmodyfikowano budżet ":name"',
    'update_amount'                             => 'Aktualizuj kwotę',
    'update_budget'                             => 'Aktualizuj budżet',
    'update_budget_amount_range'                => 'Zaktualizuj (spodziewaną) dostępną kwotę między :start a :end',
    'set_budget_limit_title'                    => 'Ustaw zabudżetową kwotę dla budżetu :budget pomiędzy :start i :end',
    'set_budget_limit'                          => 'Ustaw zabudżetowaną kwotę',
    'budget_period_navigator'                   => 'Nawigator okresowy',
    'info_on_available_amount'                  => 'Co mam do dyspozycji?',
    'available_amount_indication'               => 'Skorzystaj z tych kwot, aby uzyskać wskazówkę ile może wynosić Twój całkowity budżet.',
    'suggested'                                 => 'Sugerowane',
    'average_between'                           => 'Średnia pomiędzy :start a :end',
    'transferred_in'                            => 'Przesłane (do)',
    'transferred_away'                          => 'Przesłane (od)',
    'auto_budget_none'                          => 'Brak automatycznego budżetu',
    'auto_budget_reset'                         => 'Ustaw stałą kwotę w każdym okresie',
    'auto_budget_rollover'                      => 'Dodaj kwotę w każdym okresie',
    'auto_budget_adjusted'                      => 'Dodaj kwotę do każdego okresu i popraw w razie przekroczenia wydatków',
    'auto_budget_period_daily'                  => 'Dziennie',
    'auto_budget_period_weekly'                 => 'Tygodniowo',
    'auto_budget_period_monthly'                => 'Miesięcznie',
    'auto_budget_period_quarterly'              => 'Kwartalnie',
    'auto_budget_period_half_year'              => 'Co pół roku',
    'auto_budget_period_yearly'                 => 'Rocznie',
    'auto_budget_help'                          => 'Możesz przeczytać więcej o tej funkcji w pomocy. Kliknij ikonę (?) u góry prawej strony.',
    'auto_budget_reset_icon'                    => 'Ten budżet będzie okresowo ustalany',
    'auto_budget_rollover_icon'                 => 'Kwota budżetu będzie okresowo rosła',
    'auto_budget_adjusted_icon'                 => 'Kwota budżetu będzie okresowo wzrastać i korygować się o nadmierne wydatki',
    'remove_budgeted_amount'                    => 'Usuń zabudżetowaną kwotę w :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Użyj pola pomijania do tworzenia dwumiesięcznych (pomiń = 1) lub innych niestandardowych przedziałów.',
    'subscription'                              => 'Subskrypcja',
    'not_expected_period'                       => 'Nie oczekiwany w tym okresie',
    'subscriptions_in_group'                    => 'Subskrypcje w grupie "{{title}}"',
    'subscr_expected_x_times'                   => 'Oczekuje zapłaty {{amount}} {{times}} razy w tym okresie',
    'not_or_not_yet'                            => 'Nie (jeszcze)',
    'visit_bill'                                => 'Zobacz subskrypcję ":name" w Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subskrypcja pasuje do transakcji pomiędzy :low i :high.',
    'running_again_loss'                        => 'Transakcje poprzednio powiązane z tą subskrypcją mogą stracić to powiązanie, jeżeli nie będą spełniały założeń reguł(y).',
    'bill_related_rules'                        => 'Reguły związane z tą subskrypcją',
    'repeats'                                   => 'Powtarza się',
    'bill_end_date_help'                        => 'Opcjonalne pole. Oczekuje się, że subskrypcja zakończy się z tą datą.',
    'bill_extension_date_help'                  => 'Pole opcjonalne. Subskrypcja musi być przedłużona (lub anulowana) w dniu lub przed tą datą.',
    'bill_end_index_line'                       => 'Ta subskrypcja kończy się :date',
    'bill_extension_index_line'                 => 'Ta subskrypcja musi zostać przedłużona lub anulowana :date',
    'connected_journals'                        => 'Powiązane transakcje',
    'auto_match_on'                             => 'Automatycznie dopasowane przez Firefly III',
    'auto_match_off'                            => 'Niedopasowane automatycznie przez Firefly III',
    'next_expected_match'                       => 'Następne oczekiwane dopasowanie',
    'delete_bill'                               => 'Usuń subskrypcję ":name"',
    'deleted_bill'                              => 'Usunięto subskrypcję ":name"',
    'edit_bill'                                 => 'Edytuj subskrypcję ":name"',
    'more'                                      => 'Więcej',
    'rescan_old'                                => 'Uruchom ponownie reguły na wszystkich transakcjach',
    'update_bill'                               => 'Aktualizuj subskrypcję',
    'updated_bill'                              => 'Zaktualizowano subskrypcję ":name"',
    'store_new_bill'                            => 'Zapisz nową subskrypcję',
    'stored_new_bill'                           => 'Zapisano nową subskrypcję ":name"',
    'cannot_scan_inactive_bill'                 => 'Nieaktywne subskrypcje nie mogą być skanowane.',
    'rescanned_bill'                            => 'Przeskanowano wszystko i połączono :count transakcję z subskrypcją.|Przeskanowano wszystko i połączono :count transakcji z subskrypcją.',
    'average_bill_amount_year'                  => 'Średnia kwota subskrypcji (:year)',
    'average_bill_amount_overall'               => 'Średnia kwota subskrypcji (ogólnie)',
    'bill_is_active'                            => 'Subskrypcja jest aktywna',
    'bill_expected_between'                     => 'Oczekiwano między :start a :end',
    'bill_will_automatch'                       => 'Subskrypcja będzie automatycznie powiązana z pasującymi transakcjami',
    'skips_over'                                => 'pomija',
    'bill_store_error'                          => 'Wystąpił nieoczekiwany błąd podczas zapisywania nowej subskrypcji. Sprawdź pliki z logami',
    'list_inactive_rule'                        => 'nieaktywna reguła',
    'bill_edit_rules'                           => 'Firefly III spróbuje edytować regułę związaną z tą subskrypcją. Jeśli jednak była ona już edytowana, nie zostanie zmieniona. Firefly III spróbuje również edytować :count reguł również związanych z tą subskrypcją. Jeśli były edytowane, nic się nie zmieni.',
    'bill_expected_date'                        => 'Oczekiwane :date',
    'bill_expected_date_js'                     => 'Oczekiwane {date}',
    'expected_amount'                           => '(Oczekiwana) kwota',
    'bill_paid_on'                              => 'Zapłacone {date}',
    'bill_repeats_weekly'                       => 'Powtarza się co tydzień',
    'bill_repeats_monthly'                      => 'Powtarza się co miesiąc',
    'bill_repeats_quarterly'                    => 'Powtarza się co kwartał',
    'bill_repeats_half-year'                    => 'Powtarza się co pół roku',
    'bill_repeats_yearly'                       => 'Powtarza się co rok',
    'bill_repeats_weekly_other'                 => 'Powtarza się co drugi tydzień',
    'bill_repeats_monthly_other'                => 'Powtarza się co drugi miesiąc',
    'bill_repeats_quarterly_other'              => 'Powtarza się co drugi kwartał',
    'bill_repeats_half-year_other'              => 'Powtarza się co rok',
    'bill_repeats_yearly_other'                 => 'Powtarza się co drugi rok',
    'bill_repeats_weekly_skip'                  => 'Powtarza się co {skip} tygodni',
    'bill_repeats_monthly_skip'                 => 'Powtarza się co {skip} miesięcy',
    'bill_repeats_quarterly_skip'               => 'Powtarza się co {skip} kwartałów',
    'bill_repeats_half-year_skip'               => 'Powtarza się co {skip} połów roku',
    'bill_repeats_yearly_skip'                  => 'Powtarza się co {skip} lat',
    'subscriptions'                             => 'Subskrypcje',
    'go_to_subscriptions'                       => 'Przejdź do swoich subskrypcji',
    'forever'                                   => 'Bez daty zakończenia',
    'extension_date_is'                         => 'Data przedłużenia to {date}',

    // accounts:
    'account_locked_currency'                   => 'Waluta tego konta musi pozostać :name tak długo jak skarbonki są z nim powiązane.',
    'i_am_owed_amount'                          => 'Należy mi się kwota',
    'i_owe_amount'                              => 'Jestem winien kwotę',
    'inactive_account_link'                     => 'Masz :count nieaktywne (zarchiwizowane) konto, które możesz zobaczyć na tej stronie.|Masz :count nieaktywnych (zarchiwizowanych) kont, które możesz zobaczyć na tej stronie.',
    'all_accounts_inactive'                     => 'To są twoje nieaktywne konta.',
    'active_account_link'                       => 'Ten link wraca do Twoich aktywnych kont.',
    'account_missing_transaction'               => 'Konto #:id (":name") nie możne być wyświetlone bezpośrednio, ale Firefly Iii nie ma informacji przekierowania.',
    'cc_monthly_payment_date_help'              => 'Wybierz dowolny rok i miesiąc, są i tak ignorowane. Ważny jest tylko dzień miesiąca.',
    'details_for_asset'                         => 'Szczegóły konta aktywów ":name"',
    'details_for_expense'                       => 'Szczegóły konta wydatków ":name"',
    'details_for_revenue'                       => 'Szczegóły konta przychodów ":name"',
    'details_for_cash'                          => 'Szczegóły konta gotówkowego ":name"',
    'store_new_asset_account'                   => 'Zapisz nowe konto aktywów',
    'store_new_expense_account'                 => 'Zapisz nowe konto wydatków',
    'store_new_revenue_account'                 => 'Zapisz nowe konto przychodów',
    'edit_asset_account'                        => 'Modyfikuj konto aktywów ":name"',
    'edit_expense_account'                      => 'Modyfikuj konto wydatków ":name"',
    'edit_revenue_account'                      => 'Modyfikuj konto przychodów ":name"',
    'delete_asset_account'                      => 'Usuń konto aktywów ":name"',
    'delete_expense_account'                    => 'Usuń konto wydatków ":name"',
    'delete_revenue_account'                    => 'Usuń konto przychodów ":name"',
    'delete_liabilities_account'                => 'Usuń zobowiązanie ":name"',
    'asset_deleted'                             => 'Pomyślnie usunięto konto aktywów ":name"',
    'account_deleted'                           => 'Pomyślnie usunięto konto ":name"',
    'expense_deleted'                           => 'Pomyślnie usunięto konto wydatków ":name"',
    'revenue_deleted'                           => 'Pomyślnie usunięto konto przychodów ":name"',
    'update_asset_account'                      => 'Aktualizuj konto aktywów',
    'update_undefined_account'                  => 'Zaktualizuj konto',
    'update_liabilities_account'                => 'Modyfikuj zobowiązanie',
    'update_expense_account'                    => 'Aktualizuj konto wydatków',
    'update_revenue_account'                    => 'Aktualizuj konto przychodów',
    'make_new_asset_account'                    => 'Utwórz nowe konto aktywów',
    'make_new_expense_account'                  => 'Utwórz nowe konto wydatków',
    'make_new_revenue_account'                  => 'Utwórz nowe konto przychodów',
    'make_new_liabilities_account'              => 'Utwórz nowe zobowiązanie',
    'asset_accounts'                            => 'Konta aktywów',
    'undefined_accounts'                        => 'Konta',
    'asset_accounts_inactive'                   => 'Konta aktywów (nieaktywne)',
    'expense_account'                           => 'Konto wydatków',
    'expense_accounts'                          => 'Konta wydatków',
    'expense_accounts_inactive'                 => 'Konto wydatków (nieaktywne)',
    'revenue_account'                           => 'Konto przychodów',
    'revenue_accounts'                          => 'Konta przychodów',
    'revenue_accounts_inactive'                 => 'Konta przychodów (nieaktywne)',
    'cash_accounts'                             => 'Konta gotówkowe',
    'Cash account'                              => 'Konto gotówkowe',
    'liabilities_accounts'                      => 'Zobowiązania',
    'liabilities_accounts_inactive'             => 'Zobowiązania (nieaktywne)',
    'reconcile_account'                         => 'Uzgodnij konto ":account"',
    'overview_of_reconcile_modal'               => 'Przegląd rozrachunku',
    'delete_reconciliation'                     => 'Usuń uzgodnienie',
    'update_reconciliation'                     => 'Zaktualizuj uzgodnienie',
    'amount_cannot_be_zero'                     => 'Kwota nie może wynosić zero',
    'end_of_reconcile_period'                   => 'Koniec okresu uzgodnienia: :period',
    'start_of_reconcile_period'                 => 'Początek okresu uzgodnienia: :period',
    'start_balance'                             => 'Saldo początkowe',
    'end_balance'                               => 'Saldo końcowe',
    'update_balance_dates_instruction'          => 'Dopasuj powyższe kwoty oraz daty do wyciągu bankowego i naciśnij "Rozpocznij uzgadnianie"',
    'select_transactions_instruction'           => 'Wybierz transakcje które pojawiają się na wyciągu bankowym.',
    'select_range_and_balance'                  => 'Najpierw sprawdź zakres dat i salda. Następnie naciśnij "Rozpocznij uzgadnianie"',
    'date_change_instruction'                   => 'Jeśli teraz zmienisz zakres dat, jakikolwiek postęp zostanie utracony.',
    'update_selection'                          => 'Zaktualizuj wybór',
    'store_reconcile'                           => 'Zapisz uzgodnienia',
    'reconciliation_transaction'                => 'Transakcja uzgadniania',
    'Reconciliation'                            => 'Rozrachunek',
    'reconciliation'                            => 'Rozrachunek',
    'reconcile_options'                         => 'Opcje uzgadniania',
    'reconcile_range'                           => 'Zakres rozrachunku',
    'start_reconcile'                           => 'Rozpocznij uzgadnianie',
    'cash_account_type'                         => 'Gotówka',
    'cash'                                      => 'gotówka',
    'cant_find_redirect_account'                => 'Firefly III próbował Cię przekierować, ale się nie udało. Przepraszamy za to. Wróć do strony głównej.',
    'account_type'                              => 'Typ konta',
    'save_transactions_by_moving'               => 'Zapisz tą transakcję przenosząc ją na inne konto:|Zapisz te transakcje przenosząc je na inne konto:',
    'save_transactions_by_moving_js'            => 'Brak transakcji|Zapisz tę transakcję, przenosząc ją na inne konto.|Zapisz te transakcje przenosząc je na inne konto.',
    'stored_new_account'                        => 'Nowe konto ":name" zostało zapisane!',
    'stored_new_account_js'                     => 'Nowe konto "<a href="accounts/show/{ID}">{name}</a>" zapisane!',
    'updated_account'                           => 'Zaktualizowano konto ":name"',
    'updated_account_js'                        => 'Zaktualizowano konto "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Opcje karty kredytowej',
    'no_transactions_account'                   => 'Brak transakcji (w tym okresie) na koncie aktywów ":name".',
    'no_transactions_period'                    => 'Nie ma żadnych transakcji (w tym okresie).',
    'no_data_for_chart'                         => 'Nie ma wystarczająco dużo informacji (póki co), aby wygenerować ten wykres.',
    'select_at_least_one_account'               => 'Wybierz proszę co najmniej jedno konto aktywów',
    'select_at_least_one_category'              => 'Wybierz proszę co najmniej jedną kategorię',
    'select_at_least_one_budget'                => 'Wybierz proszę co najmniej jeden budżet',
    'select_at_least_one_tag'                   => 'Wybierz proszę co najmniej jeden tag',
    'select_at_least_one_expense'               => 'Wybierz proszę co najmniej jedną kombinację kont wydatków/przychodów. Jeżeli nie masz żadnych (lista jest pusta) ten raport jest niedostępny.',
    'account_default_currency'                  => 'To będzie domyślna waluta powiązana z tym kontem.',
    'piggy_default_currency'                    => 'Skarbonki mogą oszczędzać pieniądze tylko w jednej walucie.',
    'piggy_account_currency_match'              => 'Tylko konta, które używają poprzednio wybranej waluty, zostaną zaakceptowane.',
    'reconcile_has_more'                        => 'Twoja księga główna Firefly III ma więcej pieniędzy niż bank twierdzi, że powinieneś mieć. Istnieje kilka opcji. Wybierz, co zrobić. Następnie naciśnij "Potwierdź uzgodnienie".',
    'reconcile_has_less'                        => 'Twoja księga główna Firefly III ma mniej pieniędzy niż bank twierdzi, że powinieneś mieć. Istnieje kilka opcji. Wybierz, co zrobić. Następnie naciśnij "Potwierdź uzgodnienie".',
    'reconcile_is_equal'                        => 'Twoja księga główna Firefly III i wyciągi bankowe są zgodne. Nie ma nic do zrobienia. Naciśnij "Potwierdź uzgodnienie" aby potwierdzić twój wybór.',
    'create_pos_reconcile_transaction'          => 'Oznacz wybrane transakcje jako uzgodnione i utwórz korektę dodając :amount do tego konta aktywów.',
    'create_neg_reconcile_transaction'          => 'Oznacz wybrane transakcje jako uzgodnione i utwórz korektę usuwając :amount z tego konta aktywów.',
    'reconcile_do_nothing'                      => 'Oznacz wybrane transakcje jako uzgodnione, ale nic nie poprawiaj.',
    'reconcile_go_back'                         => 'Możesz zawsze zmodyfikować lub usunąć korektę później.',
    'must_be_asset_account'                     => 'Możesz uzgodnić tylko konta aktywów',
    'reconciliation_stored'                     => 'Uzgodnienie zapisane',
    'reconciliation_error'                      => 'Z powodu błędu transakcje zostały oznaczone jako uzgodnione, ale korekta nie została zapisana: :error.',
    'reconciliation_transaction_title'          => 'Rozrachunek (od :from do :to)',
    'sum_of_reconciliation'                     => 'Suma rozrachunku',
    'reconcile_this_account'                    => 'Uzgodnij to konto',
    'reconcile'                                 => 'Uzgodnij',
    'show'                                      => 'Pokaż',
    'confirm_reconciliation'                    => 'Potwierdź rozrachunek',
    'submitted_start_balance'                   => 'Przesłane saldo początkowe',
    'selected_transactions'                     => 'Wybrane transakcje (:count)',
    'already_cleared_transactions'              => 'Transakcje uzgodnione wcześniej (:count)',
    'submitted_end_balance'                     => 'Przesłane saldo końcowe',
    'initial_balance_description'               => 'Saldo początkowe dla ":account"',
    'liability_credit_description'              => 'Zobowiązania udzielone dla ":account"',
    'interest_calc_'                            => 'nieznany',
    'interest_calc_daily'                       => 'Co dzień',
    'interest_calc_monthly'                     => 'Co miesiąc',
    'interest_calc_yearly'                      => 'Co rok',
    'interest_calc_weekly'                      => 'Tygodniowo',
    'interest_calc_half-year'                   => 'Co pół roku',
    'interest_calc_quarterly'                   => 'Kwartalnie',
    'initial_balance_account'                   => 'Początkowe saldo konta :account',
    'list_options'                              => 'Opcje listy',
    'account_column_opt_drag_and_drop'          => 'Przeciągnij i upuść',
    'account_column_opt_active'                 => 'Aktywne',
    'account_column_opt_name'                   => 'Nazwa',
    'account_column_opt_type'                   => 'Rodzaj',
    'account_column_opt_liability_type'         => 'Rodzaj zobowiązania',
    'account_column_opt_liability_direction'    => 'Kierunek zobowiązań',
    'account_column_opt_liability_interest'     => 'Odsetki od zobowiązań',
    'account_column_opt_number'                 => 'Numer konta',
    'account_column_opt_current_balance'        => 'Bieżące saldo',
    'account_column_opt_amount_due'             => 'Do zapłaty',
    'account_column_opt_last_activity'          => 'Ostatnia aktywność',
    'account_column_opt_balance_difference'     => 'Różnica salda',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nowa kategoria',
    'create_new_category'                       => 'Utwórz nową kategorię',
    'without_category'                          => 'Bez kategorii',
    'update_category'                           => 'Aktualizuj kategorię',
    'updated_category'                          => 'Zmodyfikowano kategorię ":name"',
    'categories'                                => 'Kategorie',
    'edit_category'                             => 'Edytuj kategorię ":name"',
    'no_category'                               => '(bez kategorii)',
    'unknown_category_plain'                    => 'Brak kategorii',
    'category'                                  => 'Kategoria',
    'delete_category'                           => 'Usuń kategorię ":name"',
    'deleted_category'                          => 'Usunięto kategorię ":name"',
    'store_category'                            => 'Zapisz nową kategorię',
    'stored_category'                           => 'Zapisano nową kategorię ":name"',
    'without_category_between'                  => 'Bez kategorii między :start i :end',


    // transactions:
    'wait_loading_transaction'                  => 'Poczekaj na załadowanie formularza',
    'wait_loading_data'                         => 'Proszę poczekać na załadowanie informacji...',
    'wait_attachments'                          => 'Proszę poczekać na przesłanie załączników.',
    'errors_upload'                             => 'Przesyłanie się nie powiodło. Proszę sprawdzić konsolę przeglądarki pod kątem błędu.',
    'amount_foreign_if'                         => 'Kwota w obcej walucie, jeśli w ogóle',
    'amount_destination_account'                => 'Kwota w walucie konta docelowego',
    'edit_transaction_title'                    => 'Edytuj transakcję ":description"',
    'unreconcile'                               => 'Cofnij uzgodnienie',
    'update_withdrawal'                         => 'Modyfikuj wypłatę',
    'update_deposit'                            => 'Modyfikuj wpłatę',
    'update_transaction'                        => 'Zaktualizuj transakcję',
    'update_transfer'                           => 'Modyfikuj transfer',
    'updated_withdrawal'                        => 'Zaktualizowano wypłatę ":description"',
    'updated_deposit'                           => 'Zaktualizowano wpłatę ":description"',
    'updated_transfer'                          => 'Zaktualizowano transfer ":description"',
    'no_changes_withdrawal'                     => 'Wydatek ":description" nie został zmieniony.',
    'no_changes_deposit'                        => 'Wpłata ":description" nie została zmieniona.',
    'no_changes_transfer'                       => 'Przelew ":description" nie został zmieniony.',
    'delete_withdrawal'                         => 'Usunięto wypłatę ":description"',
    'delete_deposit'                            => 'Usuń wpłatę ":description"',
    'delete_transfer'                           => 'Usuń transfer ":description"',
    'deleted_withdrawal'                        => 'Pomyślnie usunięto wypłatę ":description"',
    'deleted_deposit'                           => 'Pomyślnie usunięto depozyt ":description"',
    'deleted_transfer'                          => 'Pomyślnie usunięto transfer ":description"',
    'deleted_reconciliation'                    => 'Pomyślnie usunięto transakcję uzgadniania ":description"',
    'stored_journal'                            => 'Pomyślnie utworzono nową transakcję ":description"',
    'stored_journal_js'                         => 'Pomyślnie utworzono nową transakcję "{{description}}"',
    'stored_journal_no_descr'                   => 'Pomyślnie utworzono nową transakcję',
    'updated_journal_no_descr'                  => 'Pomyślnie zaktualizowano Twoją transakcję',
    'select_transactions'                       => 'Wybierz transakcje',
    'rule_group_select_transactions'            => 'Zastosuj ":title" do transakcji',
    'rule_select_transactions'                  => 'Zastosuj ":title" do transakcji',
    'stop_selection'                            => 'Przestań wybierać transakcje',
    'reconcile_selected'                        => 'Uzgodnij',
    'mass_delete_journals'                      => 'Usuń wiele transakcji',
    'mass_edit_journals'                        => 'Modyfikuj wiele transakcji',
    'mass_bulk_journals'                        => 'Hurtowa edycja wielu transakcji',
    'mass_bulk_journals_explain'                => 'Ten formularz pozwala na zmianę właściwości transakcji wymienionych poniżej w jednej ogólnej aktualizacji. Wszystkie transakcje w tabeli zostaną zaktualizowane, gdy zmienisz parametry widoczne tutaj.',
    'part_of_split'                             => 'Ta transakcja jest częścią podzielonej transakcji. Jeżeli nie zaznaczono wszystkich części, transakcja może zostać zmieniona tylko w połowie.',
    'bulk_set_new_values'                       => 'Użyj pól poniżej, aby ustawić nowe wartości. Jeżeli zostawisz je puste, zostaną wyczyszczone dla wszystkich transakcji. Pamiętaj także, że budżet zostanie ustawiony tylko dla wypłat.',
    'no_bulk_category'                          => 'Nie aktualizuj kategorii',
    'no_bulk_budget'                            => 'Nie aktualizuj budżetu',
    'no_bulk_tags'                              => 'Nie aktualizuj tagów',
    'replace_with_these_tags'                   => 'Zastąp tagami',
    'append_these_tags'                         => 'Dodaj te tagi',
    'mass_edit'                                 => 'Edytuj wybrane pojedynczo',
    'bulk_edit'                                 => 'Edytuj wybrane zbiorczo',
    'mass_delete'                               => 'Usuń zaznaczone',
    'cannot_edit_other_fields'                  => 'Nie możesz masowo modyfikować innych pól niż te tutaj, ponieważ nie ma miejsca, aby je pokazać. Proszę użyć ikony edycji i edytować je jedno po drugim, jeśli chcesz edytować te pola.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(brak budżetu)',
    'no_bill'                                   => '(brak subskrypcji)',
    'account_per_budget'                        => 'Konto wg. budżetu',
    'account_per_category'                      => 'Konto wg. kategorii',
    'create_new_object'                         => 'Utwórz',
    'empty'                                     => '(pusty)',
    'all_other_budgets'                         => '(wszystkie inne budżety)',
    'all_other_accounts'                        => '(wszystkie inne konta)',
    'expense_per_source_account'                => 'Wydatki według konta źródłowego',
    'expense_per_destination_account'           => 'Wydatki według konta docelowego',
    'income_per_destination_account'            => 'Przychody według konta docelowego',
    'spent_in_specific_category'                => 'Wydatki w kategorii ":category"',
    'earned_in_specific_category'               => 'Przychody w kategorii ":category"',
    'spent_in_specific_tag'                     => 'Wydatki w tagu ":tag"',
    'earned_in_specific_tag'                    => 'Przychody w tagu ":tag"',
    'income_per_source_account'                 => 'Przychody według konta źródłowego',
    'average_spending_per_destination'          => 'Średnie wydatki według konta docelowego',
    'average_spending_per_source'               => 'Średnie wydatki według konta źródłowego',
    'average_earning_per_source'                => 'Średnie przychody według konta źródłowego',
    'average_earning_per_destination'           => 'Średnie przychody według konta docelowego',
    'account_per_tag'                           => 'Konto wg. tagu',
    'tag_report_expenses_listed_once'           => 'Wydatki i dochody nigdy nie są wyświetlane dwukrotnie. Jeśli transakcja ma wiele tagów, może się pojawić pod jednym z jej tagów. Może się wydawać, że na tej liście brakuje danych, ale kwoty powinny poprawne.',
    'double_report_expenses_charted_once'       => 'Wydatki i dochody nigdy nie są wyświetlane dwukrotnie. Jeśli transakcja ma wiele tagów, może się pojawić pod jednym z jej tagów. Może się wydawać, że na tym wykresie brakuje danych, ale kwoty powinny poprawne.',
    'tag_report_chart_single_tag'               => 'Ten wykres dotyczy pojedynczego taga. Jeśli transakcja ma wiele tagów, to co tu widzisz może być pokazane na wykresach innych tagów.',
    'tag'                                       => 'Tag',
    'no_budget_squared'                         => '(brak budżetu)',
    'perm-delete-many'                          => 'Usunięcie wielu elementów w jednym podejściu może być bardzo poważne. Zachowaj ostrożność. Możesz usunąć część podzielonej transakcji z tej strony, więc zachowaj ostrożność.',
    'mass_deleted_transactions_success'         => 'Usunięto :count transakcję.|Usunięto :count transakcji.',
    'mass_edited_transactions_success'          => 'Zaktualizowano :count transakcję.|Zaktualizowano :count transakcji.',
    'opt_group_'                                => '(brak typu konta)',
    'opt_group_no_account_type'                 => '(brak typu konta)',
    'opt_group_defaultAsset'                    => 'Domyślne konta aktywów',
    'opt_group_savingAsset'                     => 'Konta oszczędnościowe',
    'opt_group_sharedAsset'                     => 'Współdzielone konta aktywów',
    'opt_group_ccAsset'                         => 'Karty kredytowe',
    'opt_group_cashWalletAsset'                 => 'Portfele gotówkowe',
    'opt_group_expense_account'                 => 'Konta wydatków',
    'opt_group_revenue_account'                 => 'Konta przychodów',
    'opt_group_l_Loan'                          => 'Zobowiązanie: Pożyczka',
    'opt_group_cash_account'                    => 'Konto gotówkowe',
    'opt_group_l_Debt'                          => 'Zobowiązanie: Dług',
    'opt_group_l_Mortgage'                      => 'Zobowiązanie: Hipoteka',
    'opt_group_l_Credit card'                   => 'Zobowiązanie: Karta kredytowa',
    'notes'                                     => 'Notatki',
    'view_notes'                                => 'Zobacz notatki',
    'set_budget_limit_notes'                    => 'Zobacz notatki dla tej kwoty w budżecie',
    'edit_bl_notes'                             => 'Edytuj notatki',
    'update_bl_notes'                           => 'Edytuj notatki',
    'unknown_journal_error'                     => 'Nie można zapisać transakcji. Sprawdź pliki dziennika.',
    'attachment_not_found'                      => 'Nie udało się znaleźć tego załącznika.',
    'journal_link_bill'                         => 'Ta transakcja jest powiązana z subskrypcją <a href=":route">:name</a>. Aby usunąć to powiązanie odznacz pole wyboru. Użyj reguł aby połączyć ją z inną subskrypcją.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transakcja #{ID} ("{title}")</a> została zapisana.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transakcja #{ID}</a> została zapisana.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transakcja #{ID}</a> ("{title}") została zaktualizowana.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transakcja #{ID}</a> ("{title}") nie została zmieniona.',
    'first_split_decides'                       => 'Pierwszy podział określa wartość tego pola',
    'first_split_overrules_source'              => 'Pierwszy podział może nadpisać konto źródłowe',
    'first_split_overrules_destination'         => 'Pierwszy podział może nadpisać konto docelowe',
    'spent_x_of_y'                              => 'Wydano {amount} z {total}',

    // new user:
    'welcome'                                   => 'Witaj w Firefly III!',
    'submit'                                    => 'Prześlij',
    'submission'                                => 'Zapisz',
    'submit_yes_really'                         => 'Zatwierdź (wiem co robię)',
    'getting_started'                           => 'Pierwsze kroki',
    'to_get_started'                            => 'Dobrze, że udało ci się zainstalować Firefly III. Aby rozpocząć korzystanie z tego narzędzia, wprowadź nazwę swojego banku i saldo głównego rachunku bieżącego. Nie martw się, jeśli masz wiele kont. Możesz dodać je później. Po prostu Firefly III potrzebuje czegoś na początek.',
    'savings_balance_text'                      => 'Firefly III automatycznie utworzy dla ciebie konto oszczędnościowe. Domyślnie na twoim koncie oszczędnościowym nie ma pieniędzy, ale jeśli chcesz, Firefly III może je tam przechowywać.',
    'finish_up_new_user'                        => 'To wszystko! Możesz kontynuować, naciskając <strong>Zatwierdź</strong>. Zostaniesz przeniesiony do strony głównej Firefly III.',
    'stored_new_accounts_new_user'              => 'Yay! Twoje nowe konta zostały zapisane.',
    'set_preferred_language'                    => 'Jeśli wolisz używać Firefly III w innym języku, wskaż to tutaj.',
    'language'                                  => 'Język',
    'new_savings_account'                       => 'Konto oszczędnościowe :bank_name',
    'cash_wallet'                               => 'Portfel gotówkowy',
    'currency_not_present'                      => 'Jeśli waluty, której zwykle używasz, nie ma na liście, nie martw się. Możesz tworzyć swoje własne waluty w Opcje > Waluty.',

    // home page:
    'transaction_table_description'             => 'Tabela zawierająca Twoje transakcje',
    'opposing_account'                          => 'Konto przeciwstawne',
    'yourAccounts'                              => 'Twoje konta',
    'your_accounts'                             => 'Przegląd Twoich kont',
    'category_overview'                         => 'Przegląd kategorii',
    'expense_overview'                          => 'Przegląd kont wydatków',
    'revenue_overview'                          => 'Przegląd kont przychodów',
    'budgetsAndSpending'                        => 'Budżety i wydatki',
    'budgets_and_spending'                      => 'Budżety i wydatki',
    'go_to_budget'                              => 'Idź do budżetu "{budget}"',
    'go_to_deposits'                            => 'Przejdź do wpłat',
    'go_to_expenses'                            => 'Przejdź do wydatków',
    'savings'                                   => 'Oszczędności',
    'newWithdrawal'                             => 'Nowy wydatek',
    'newDeposit'                                => 'Nowa wpłata',
    'newTransfer'                               => 'Nowy transfer',
    'bills_to_pay'                              => 'Subskrypcje do zapłaty',
    'per_day'                                   => 'Dziennie',
    'left_to_spend_per_day'                     => 'Kwota możliwa do wydania codziennie',
    'bills_paid'                                => 'Zapłacone subskrypcje',
    'custom_period'                             => 'Okres niestandardowy',
    'reset_to_current'                          => 'Przywróć do bieżącego okresu',
    'select_period'                             => 'Wybierz okres',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Waluta',
    'preferences'                               => 'Preferencje',
    'logout'                                    => 'Wyloguj',
    'logout_other_sessions'                     => 'Wyloguj z pozostałych sesji',
    'toggleNavigation'                          => 'Przełącz nawigację',
    'toggle_dropdown'                           => 'Rozwiń menu',
    'searchPlaceholder'                         => 'Szukaj...',
    'version'                                   => 'Wersja',
    'dashboard'                                 => 'Kokpit',
    'income_and_expense'                        => 'Przychody i wydatki',
    'all_money'                                 => 'Wszystkie Twoje pieniądze',
    'unknown_source_plain'                      => 'Nieznane konto źródłowe',
    'unknown_dest_plain'                        => 'Nieznane konto docelowe',
    'unknown_any_plain'                         => 'Nieznane konto',
    'unknown_budget_plain'                      => 'Brak budżetu',
    'available_budget'                          => 'Dostępne budżety ({currency})',
    'currencies'                                => 'Waluty',
    'activity'                                  => 'Aktywność',
    'usage'                                     => 'Użycie',
    'accounts'                                  => 'Konta',
    'Asset account'                             => 'Konto aktywów',
    'Default account'                           => 'Konto aktywów',
    'Expense account'                           => 'Konto wydatków',
    'Revenue account'                           => 'Konto przychodów',
    'Initial balance account'                   => 'Początkowe saldo konta',
    'account_type_Asset account'                => 'Konto aktywów',
    'account_type_Expense account'              => 'Konto wydatków',
    'account_type_Revenue account'              => 'Konto przychodów',
    'account_type_Debt'                         => 'Dług',
    'account_type_Loan'                         => 'Pożyczka',
    'account_type_Mortgage'                     => 'Hipoteka',
    'account_type_debt'                         => 'Dług',
    'account_type_loan'                         => 'Pożyczka',
    'account_type_mortgage'                     => 'Hipoteka',
    'account_type_Credit card'                  => 'Karta kredytowa',
    'credit_card_type_monthlyFull'              => 'Pełna płatność co miesiąc',
    'liability_direction_credit'                => 'Zadłużenie wobec mnie',
    'liability_direction_debit'                 => 'Zadłużenie wobec kogoś innego',
    'liability_direction_credit_short'          => 'Dług wobec Ciebie',
    'liability_direction_debit_short'           => 'Jesteś dłużny',
    'liability_direction__short'                => 'Nieznane',
    'liability_direction_null_short'            => 'Nieznane',
    'Liability credit'                          => 'Kredyt na zobowiązania',
    'budgets'                                   => 'Budżety',
    'tags'                                      => 'Tagi',
    'reports'                                   => 'Raporty',
    'transactions'                              => 'Transakcje',
    'expenses'                                  => 'Wydatki',
    'income'                                    => 'Przychody / dochody',
    'transfers'                                 => 'Transfery',
    'moneyManagement'                           => 'Zarządzanie pieniędzmi',
    'money_management'                          => 'Zarządzanie pieniędzmi',
    'tools'                                     => 'Narzędzia',
    'piggyBanks'                                => 'Skarbonki',
    'piggy_banks'                               => 'Skarbonki',
    'amount_x_of_y'                             => '{current} z {total}',
    'bills'                                     => 'Subskrypcje',
    'withdrawal'                                => 'Wypłata',
    'opening_balance'                           => 'Saldo początkowe',
    'deposit'                                   => 'Wpłata',
    'account'                                   => 'Konto',
    'transfer'                                  => 'Transfer',
    'Withdrawal'                                => 'Wypłata',
    'Deposit'                                   => 'Wpłata',
    'Transfer'                                  => 'Transfer',
    'bill'                                      => 'Subskrypcja',
    'yes'                                       => 'Tak',
    'no'                                        => 'Nie',
    'amount'                                    => 'Kwota',
    'overview'                                  => 'Przegląd',
    'saveOnAccount'                             => 'Oszczędzaj na koncie',
    'saveOnAccounts'                            => 'Oszczędzaj na koncie(kontach)',
    'unknown'                                   => 'Nieznane',
    'monthly'                                   => 'Miesięcznie',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Błędy',
    'debt_start_date'                           => 'Początkowa data długu',
    'debt_start_amount'                         => 'Początkowa kwota długu',
    'debt_start_amount_help'                    => 'Najlepiej ustawić tę wartość na wartość ujemną. Aby uzyskać więcej informacji, przeczytaj strony pomocy (ikona (?) w prawym górnym rogu).',
    'interest_period_help'                      => 'To pole jest czysto kosmetyczne i nie zostanie obliczone automatycznie. Jak się okazuje, banki są bardzo podstępne, więc Firefly III nigdy nie oblicza tego prawidłowo.',
    'store_new_liabilities_account'             => 'Zapisz nowe zobowiązanie',
    'edit_liabilities_account'                  => 'Modyfikuj zobowiązanie ":name"',
    'financial_control'                         => 'Kontrola finansowa',
    'accounting'                                => 'Księgowość',
    'automation'                                => 'Automatyzacja',
    'others'                                    => 'Pozostałe',
    'classification'                            => 'Klasyfikacja',
    'store_transaction'                         => 'Zapisz transakcję',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Domyślny raport finansowy między :start i :end',
    'report_audit'                              => 'Przegląd historii transakcji między :start i :end',
    'report_category'                           => 'Raport kategorii między :start a :end',
    'report_double'                             => 'Raport dotyczący wydatków/przychodów między :start a :end',
    'report_budget'                             => 'Raport budżetów między :start a :end',
    'report_tag'                                => 'Raport tagów między :start a :end',
    'quick_link_reports'                        => 'Szybkie linki',
    'quick_link_examples'                       => 'To tylko przykładowe linki, od których możesz zacząć. Sprawdź strony pomocy pod przyciskiem (?) aby uzyskać informacje o wszystkich raportach i magicznych słowach, których możesz użyć.',
    'quick_link_default_report'                 => 'Domyślny raport finansowy',
    'quick_link_audit_report'                   => 'Przegląd historii transakcji',
    'report_this_month_quick'                   => 'Bieżący miesiąc, wszystkie konta',
    'report_last_month_quick'                   => 'Ostatni miesiąc, wszystkie konta',
    'report_this_year_quick'                    => 'Bieżący rok, wszystkie konta',
    'report_this_fiscal_year_quick'             => 'Bieżący rok podatkowy, wszystkie konta',
    'report_all_time_quick'                     => 'Cały czas, wszystkie konta',
    'reports_can_bookmark'                      => 'Pamiętaj, że raporty można dodać do zakładek.',
    'incomeVsExpenses'                          => 'Dochody a wydatki',
    'accountBalances'                           => 'Salda kont',
    'balanceStart'                              => 'Saldo na początku okresu',
    'balanceEnd'                                => 'Saldo na końcu okresu',
    'splitByAccount'                            => 'Podziel według konta',
    'coveredWithTags'                           => 'Objęte tagami',
    'leftInBudget'                              => 'Pozostało w budżecie',
    'left_in_debt'                              => 'Do zapłaty',
    'sumOfSums'                                 => 'Suma sum',
    'noCategory'                                => '(bez kategorii)',
    'notCharged'                                => 'Brak opłaty (jeszcze)',
    'inactive'                                  => 'Nieaktywne',
    'active'                                    => 'Aktywne',
    'difference'                                => 'Różnica',
    'money_flowing_in'                          => 'Przychodzące',
    'money_flowing_out'                         => 'Wychodzące',
    'topX'                                      => 'czołówka :number',
    'show_full_list'                            => 'Pokaż całą listę',
    'show_only_top'                             => 'Pokazuj tylko czołową :number',
    'report_type'                               => 'Typ raportu',
    'report_type_default'                       => 'Domyślny raport finansowy',
    'report_type_audit'                         => 'Przegląd historii transakcji (audyt)',
    'report_type_category'                      => 'Raport kategorii',
    'report_type_budget'                        => 'Raport budżetów',
    'report_type_tag'                           => 'Raport tagów',
    'report_type_double'                        => 'Raport dotyczący konta wydatków/przychodów',
    'more_info_help'                            => 'Więcej informacji na temat typów raportów można znaleźć na stronach pomocy. Naciśnij ikonę (?) w prawym górnym rogu.',
    'report_included_accounts'                  => 'Uwzględnione konta',
    'report_date_range'                         => 'Zakres dat',
    'report_preset_ranges'                      => 'Predefiniowane zakresy',
    'shared'                                    => 'Udostępnione',
    'fiscal_year'                               => 'Rok podatkowy',
    'income_entry'                              => 'Dochód z konta ":name" między: :start a :end',
    'expense_entry'                             => 'Wydatki na konto ":name" między :start a :end',
    'category_entry'                            => 'Wydatki w kategorii ":name" między :start i :end',
    'budget_spent_amount'                       => 'Wydatki w budżecie ":budget" między :start i :end',
    'balance_amount'                            => 'Wydatki w budżecie ":budget" zapłacone z konta ":account" między :start a :end',
    'no_audit_activity'                         => 'Nie zarejestrowano żadnej aktywności na koncie <a href=":url" title=":account_name">:account_name</a> między :start a :end.',
    'audit_end_balance'                         => 'Saldo konta <a href=":url" title=":account_name">:account_name</a> na koniec :end wynosiło: :balance',
    'reports_extra_options'                     => 'Dodatkowe opcje',
    'report_has_no_extra_options'               => 'Ten raport nie ma dodatkowych opcji',
    'reports_submit'                            => 'Zobacz raport',
    'end_after_start_date'                      => 'Data zakończenia raportu musi być po dacie rozpoczęcia.',
    'select_category'                           => 'Wybierz kategorię(e)',
    'select_budget'                             => 'Wybierz budżet(y).',
    'select_tag'                                => 'Wybierz tag(i).',
    'income_per_category'                       => 'Dochody wg kategorii',
    'expense_per_category'                      => 'Wydatki wg kategorii',
    'expense_per_budget'                        => 'Wydatki wg budżetu',
    'income_per_account'                        => 'Dochody wg konta',
    'expense_per_account'                       => 'Wydatki wg konta',
    'expense_per_tag'                           => 'Wydatki wg tagu',
    'income_per_tag'                            => 'Dochody wg tagu',
    'include_expense_not_in_budget'             => 'Uwzględnij wydatki spoza wybranych budżetów',
    'include_expense_not_in_account'            => 'Uwzględnij wydatki spoza wybranych kont',
    'include_expense_not_in_category'           => 'Uwzględnij wydatki spoza wybranych kategorii',
    'include_income_not_in_category'            => 'Uwzględnij przychody spoza wybranych kategorii',
    'include_income_not_in_account'             => 'Uwzględnij przychody spoza wybranych kont',
    'include_income_not_in_tags'                => 'Uwzględnij przychody spoza wybranych tagów',
    'include_expense_not_in_tags'               => 'Uwzględnij wydatki spoza wybranych tagów',
    'everything_else'                           => 'Wszystko inne',
    'income_and_expenses'                       => 'Dochody i wydatki',
    'spent_average'                             => 'Wydano (średnia)',
    'income_average'                            => 'Dochód (średnia)',
    'transaction_count'                         => 'Liczba transakcji',
    'average_spending_per_account'              => 'Średnie wydatki per konto',
    'average_income_per_account'                => 'Średni dochód per konto',
    'total'                                     => 'Łącznie',
    'description'                               => 'Opis',
    'sum_of_period'                             => 'Suma dla tego okresu',
    'average_in_period'                         => 'Średnia dla tego okresu',
    'no_account_role'                           => '(brak roli)',
    'account_role_defaultAsset'                 => 'Domyślne konto aktywów',
    'account_role_sharedAsset'                  => 'Współdzielone konto aktywów',
    'account_role_savingAsset'                  => 'Konto oszczędnościowe',
    'account_role_ccAsset'                      => 'Karta kredytowa',
    'account_role_cashWalletAsset'              => 'Portfel gotówkowy',
    'budget_chart_click'                        => 'Kliknij na nazwę budżetu w tabeli powyżej, aby zobaczyć wykres.',
    'category_chart_click'                      => 'Kliknij na nazwę kategorii w tabeli powyżej, aby zobaczyć wykres.',
    'in_out_accounts'                           => 'Zarobione oraz wydane wg kombinacji',
    'in_out_accounts_per_asset'                 => 'Przychody i wydatki (na konto aktywów)',
    'in_out_per_category'                       => 'Zarobione oraz wydane wg kategorii',
    'out_per_budget'                            => 'Wydane wg budżetu',
    'select_expense_revenue'                    => 'Wybierz konto wydatków/przychodów',
    'multi_currency_report_sum'                 => 'Ponieważ ta lista zawiera konta z wieloma walutami, sumy, które widzisz, mogą nie mieć sensu. Raport zawsze używa domyślnej waluty.',
    'sum_in_default_currency'                   => 'Suma zawsze będzie w domyślnej walucie.',
    'net_filtered_prefs'                        => 'Ten wykres nigdy nie będzie zawierał kont, które nie mają zaznaczonej opcji "Uwzględnij w wartości netto".',


    // charts:
    'chart'                                     => 'Wykres',
    'month'                                     => 'Miesiąc',
    'budget'                                    => 'Budżet',
    'spent'                                     => 'Wydano',
    'spent_capped'                              => 'Wydano (ograniczone)',
    'spent_in_budget'                           => 'Wydano w budżecie',
    'left_to_spend'                             => 'Pozostało do wydania',
    'earned'                                    => 'Zarobiono',
    'overspent'                                 => 'Przepłacono',
    'left'                                      => 'Pozostało',
    'max-amount'                                => 'Maksymalna kwota',
    'min-amount'                                => 'Minimalna kwota',
    'journal-amount'                            => 'Aktualna kwota subskrypcji',
    'name'                                      => 'Nazwa',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Data',
    'date_and_time'                             => 'Data i czas',
    'time'                                      => 'Czas',
    'paid'                                      => 'Zapłacone',
    'unpaid'                                    => 'Niezapłacone',
    'day'                                       => 'Dzień',
    'budgeted'                                  => 'Zabudżetowano',
    'period'                                    => 'Okres',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'Przychodzące + wychodzące w tym okresie',
    'sum'                                       => 'Suma',
    'summary'                                   => 'Podsumowanie',
    'average'                                   => 'Średno',
    'balanceFor'                                => 'Saldo dla :name',
    'no_tags'                                   => '(brak tagów)',
    'nothing_found'                             => '(nic nie znaleziono)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Ustawienia strony',
    'visible_columns'               => 'Widoczne kolumny',
    'accounts_to_show'              => 'Konta do pokazania',
    'active_accounts_only'          => 'Tylko aktywne konta',
    'in_active_accounts_only'       => 'Tylko nieaktywne konta',
    'show_all_accounts'             => 'Pokaż wszystkie konta',
    'group_accounts'                => 'Grupuj konta',

    // piggy banks:
    'event_history'                 => 'Historia zdarzeń',
    'add_money_to_piggy'            => 'Dodaj pieniądze do skarbonki ":name"',
    'piggy_bank'                    => 'Skarbonka',
    'new_piggy_bank'                => 'Nowa skarbonka',
    'store_piggy_bank'              => 'Zapisz nową skarbonkę',
    'stored_piggy_bank'             => 'Zapisz nową skarbonkę ":name"',
    'account_status'                => 'Status konta',
    'left_for_piggy_banks'          => 'Dostępne dla skarbonek',
    'sum_of_piggy_banks'            => 'Suma skarbonek',
    'saved_so_far'                  => 'Zaoszczędzono do tej pory',
    'saved_so_far_total'            => 'Oszczędzono do tej pory',
    'reset_history'                 => 'wyzeruj historię',
    'reset_history_confirm'         => 'Czy na pewno chcesz wyzerować historię tej skarbonki? To sprawi, że wykres ponownie dopasuje się do wartości skarbonki.',
    'piggy_history_reset'           => 'Historia skarbonki została wyzerowana',
    'left_to_save'                  => 'Pozostało do zaoszczędzenia',
    'suggested_amount'              => 'Sugerowana miesięczna kwota do odłożenia',
    'add_money_to_piggy_title'      => 'Dodaj pieniądze do skarbonki ":name"',
    'remove_money_from_piggy_title' => 'Usuń pieniądze ze skarbonki ":name"',
    'add'                           => 'Dodaj',
    'no_money_for_piggy'            => 'Nie masz pieniędzy, które mógłbyś umieścić w tej skarbonce.',
    'suggested_savings_per_month'   => 'Sugerowane miesięcznie',

    'remove'                    => 'Usuń',
    'max_amount_add'            => 'Maksymalną kwotą, którą możesz dodać jest',
    'max_amount_remove'         => 'Maksymalną kwotą, którą możesz usunąć jest',
    'update_piggy_button'       => 'Aktualizuj skarbonkę',
    'update_piggy_title'        => 'Aktualizuj skarbonkę ":name"',
    'updated_piggy_bank'        => 'Zaktualizowano skarbonkę ":name"',
    'details'                   => 'Szczegóły',
    'events'                    => 'Zdarzenia',
    'target_amount'             => 'Kwota docelowa',
    'start_date'                => 'Data rozpoczęcia',
    'no_start_date'             => 'Brak daty rozpoczęcia',
    'target_date'               => 'Data docelowa',
    'no_target_date'            => 'Brak daty docelowej',
    'table'                     => 'Tabela',
    'delete_piggy_bank'         => 'Usuń skarbonkę ":name"',
    'cannot_add_amount_piggy'   => 'Nie można dodać :amount do ":name".',
    'cannot_remove_from_piggy'  => 'Nie można usunąć :amount z ":name".',
    'deleted_piggy_bank'        => 'Usunięto skarbonkę ":name"',
    'added_amount_to_piggy'     => 'Dodano :amount do ":name"',
    'removed_amount_from_piggy' => 'Usunięto :amount z ":name"',
    'piggy_events'              => 'Powiązane skarbonki',

    // tags
    'delete_tag'                => 'Usuń tag ":tag"',
    'deleted_tag'               => 'Usunięto tag ":tag"',
    'new_tag'                   => 'Utwórz nowy tag',
    'edit_tag'                  => 'Modyfikuj tag ":tag"',
    'updated_tag'               => 'Zaktualizowano tag ":tag"',
    'created_tag'               => 'Tag ":tag" został utworzony!',

    'transaction_journal_information'               => 'Informacje o transakcji',
    'transaction_journal_amount'                    => 'Informacje o kwocie',
    'transaction_journal_meta'                      => 'Meta informacje',
    'transaction_journal_more'                      => 'Więcej informacji',
    'basic_journal_information'                     => 'Podstawowe informacje o transakcji',
    'transaction_journal_extra'                     => 'Dodatkowe informacje',
    'att_part_of_journal'                           => 'Zapisano jako ":journal"',
    'total_amount'                                  => 'Łączna kwota',
    'number_of_decimals'                            => 'Ilość miejsc dziesiętnych',


    // administration
    'invite_is_already_redeemed'                    => 'Zaproszenie do ":address" zostało już wykorzystane.',
    'invite_is_deleted'                             => 'Zaproszenie do ":address" zostało usunięte.',
    'invite_new_user_title'                         => 'Zaproś nowego użytkownika',
    'invite_new_user_text'                          => 'Jako administrator możesz zaprosić innych użytkowników, aby zarejestrowali się w twojej instancji Firefly III. Będą mogli zarejestrować swoje konto, korzystając z bezpośredniego odnośnika, który możesz im udostępnić. Zaproszony użytkownik i jego odnośnik pojawią się w tabeli poniżej. Możesz udostępnić odnośnik użytkownikowi.',
    'invited_user_mail'                             => 'Adres email',
    'invite_user'                                   => 'Zaproś użytkownika',
    'user_is_invited'                               => 'Adres email ":address" został zaproszony do Firefly III',
    'administration'                                => 'Administracja',
    'system_settings'                               => 'Ustawienia systemowe',
    'code_already_used'                             => 'Kod zaproszenia został już użyty',
    'user_administration'                           => 'Administracja użytkownikami',
    'list_all_users'                                => 'Wszyscy użytkownicy',
    'all_users'                                     => 'Wszyscy użytkownicy',
    'instance_configuration'                        => 'Konfiguracja',
    'firefly_instance_configuration'                => 'Konfiguracja Firefly III',
    'setting_single_user_mode'                      => 'Tryb pojedynczego użytkownika',
    'setting_single_user_mode_explain'              => 'Domyślnie, Firefly III pozwala na jednego (1) użytkownika: Ciebie. Jest to środek bezpieczeństwa uniemożliwiający innym używanie Twojej instalacji, chyba że im pozwolisz. Kolejne rejestracje są zablokowane. Jeżeli odznaczysz to pole, inne osoby będą mogły używać Twojej instalacji Firefly III (zakładając, że jest ona dostępna w Internecie).',
    'store_configuration'                           => 'Zapisz konfigurację',
    'single_user_administration'                    => 'Administracja użytkownika dla :email',
    'edit_user'                                     => 'Modyfikuj użytkownika :email',
    'hidden_fields_preferences'                     => 'Możesz włączyć więcej opcji transakcji w swoich <a href="preferences">ustawieniach</a>.',
    'user_data_information'                         => 'Dane użytkownika',
    'user_information'                              => 'Informacja o użytkowniku',
    'total_size'                                    => 'łączny rozmiar',
    'budget_or_budgets'                             => ':count budżet|:count budżetów',
    'budgets_with_limits'                           => ':count budżet z ustaloną kwotą|:count budżetów z ustaloną kwotą',
    'nr_of_rules_in_total_groups'                   => ':count_rules reguła(y) w :count_groups grupa(ch) reguł',
    'tag_or_tags'                                   => ':count tag|:count tagów',
    'configuration_updated'                         => 'Konfiguracja została zaktualizowana',
    'setting_is_demo_site'                          => 'Strona demonstracyjna',
    'setting_is_demo_site_explain'                  => 'Jeśli zaznaczysz to pole, ta instalacja będzie zachowywać się jak witryna demonstracyjna, co może mieć dziwne efekty uboczne.',
    'block_code_bounced'                            => 'Odrzucony e-mail potwierdzający',
    'block_code_expired'                            => 'Demonstracyjne konto wygasło',
    'no_block_code'                                 => 'Brak powody blokady lub użytkownik niezablokowany',
    'demo_user_export'                              => 'Użytkownik demonstracyjny nie może eksportować danych',
    'block_code_email_changed'                      => 'Użytkownik nie potwierdził jeszcze nowego adresu e-mail',
    'admin_update_email'                            => 'W przeciwieństwie do strony "Profil", użytkownik NIE zostanie powiadomiony o zmianie adresu e-mail!',
    'update_user'                                   => 'Modyfikuj użytkownika',
    'updated_user'                                  => 'Dane użytkownika zostały zmienione.',
    'delete_user'                                   => 'Usuń użytkownika :email',
    'user_deleted'                                  => 'Użytkownik został usunięty',
    'send_test_email'                               => 'Wyślij testową wiadomość e-mail',
    'send_test_email_text'                          => 'Aby sprawdzić, czy Twoja instalacja umożliwia wysyłanie wiadomości e-mail, naciśnij ten przycisk. Nie zobaczysz tutaj błędu (jeśli jest), <strong>pliki dziennika będą odzwierciedlać wszelkie błędy</strong>. Możesz nacisnąć ten przycisk tyle razy, ile chcesz. Nie ma kontroli spamu. Wiadomość zostanie wysłana do <code>:email</code> i powinna wkrótce nadejść.',
    'send_message'                                  => 'Wyślij wiadomość',
    'send_test_triggered'                           => 'Test został uruchomiony. Sprawdź swoją skrzynkę odbiorczą i pliki dziennika.',
    'give_admin_careful'                            => 'Użytkownicy, którzy dostaną prawa administratora, mogą zabrać twoje. Zachowaj ostrożność.',
    'admin_maintanance_title'                       => 'Konserwacja',
    'admin_maintanance_expl'                        => 'Kilka pięknych przycisków do konserwacji Firefly III',
    'admin_maintenance_clear_cache'                 => 'Wyczyść pamięć podręczną',
    'owner_notifications'                           => 'Powiadomienia administacyjne',
    'owner_notifications_expl'                      => 'Następujące powiadomienia mogą być włączone lub wyłączone przez administratora. Zostanie wysłane przez WSZYSTKIE skonfigurowane kanały. Niektóre kanały są skonfigurowane w twoich zmiennych środowiskowych, inne mogą być ustawione tutaj.',
    'channel_settings'                              => 'Ustawienia kanałów powiadomień',
    'notification_test_failed'                      => 'Test powiadomień dla kanału ":channel" nie powiódł się. Dzienniki logów będą miały więcej szczegółów.',
    'notification_test_executed'                    => 'Test powiadomień dla kanału ":channel" wykonany. Sprawdź swoje logi po szczegóły.',
    'settings_notifications'                        => 'Ustawienia dla powiadomień',
    'title_owner_notifications'                     => 'Powiadomienia właściciela',
    'owner_notification_check_user_new_reg'         => 'Użytkownik otrzymuje wiadomość powitalną po rejestracji',
    'owner_notification_check_admin_new_reg'        => 'Administrator(zy) otrzyma(ją) nowe powiadomienie o rejestracji użytkownika',
    'owner_notification_check_new_version'          => 'Dostępna jest nowa wersja',
    'owner_notification_check_invite_created'       => 'Użytkownik został zaproszony do Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Zaproszenie użytkownika zostało użyte',
    'owner_notification_check_unknown_user_attempt' => 'Nieznany użytkownik próbuje zalogować się',
    'all_invited_users'                             => 'Wszyscy zaproszeni użytkownicy',
    'save_notification_settings'                    => 'Zapisz ustawienia',
    'notification_settings'                         => 'Ustawienia dla powiadomień',
    'notification_settings_saved'                   => 'Ustawienia powiadomień zostały zapisane',
    'available_channels_title'                      => 'Dostępne kanały',
    'available_channels_expl'                       => 'Te kanały są dostępne do wysyłania powiadomień. Aby przetestować konfigurację, użyj przycisków poniżej. Pamiętaj, że przyciski nie mają kontroli spamu.',
    'notification_channel_name_email'               => 'Adres e-mail',
    'slack_discord_double'                          => 'Kanał powiadomień Slack może również wysyłać powiadomienia do Discorda.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'niedostępny',
    'configure_channel_in_env'                      => 'wymaga zmiennych środowiskowych',
    'test_notification_channel_name_email'          => 'Testuj e-mail',
    'test_notification_channel_name_slack'          => 'Testuj Slack',
    'test_notification_channel_name_ntfy'           => 'Testuj Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Testuj Pushover',
    'test_notification_channel_name_gotify'         => 'Testuj Gotify',
    'test_notification_channel_name_pushbullet'     => 'Testuj Pushbullet',

    'split_transaction_title'               => 'Opis podzielonej transakcji',
    'split_transaction_title_help'          => 'Jeśli tworzysz podzieloną transakcję, musi ona posiadać globalny opis dla wszystkich podziałów w transakcji.',
    'split_title_help'                      => 'Podzielone transakcje muszą posiadać globalny opis.',
    'you_create_transfer'                   => 'Tworzysz przelew.',
    'you_create_withdrawal'                 => 'Tworzysz wydatek.',
    'you_create_deposit'                    => 'Tworzysz wpłatę.',

    // links
    'journal_link_configuration'            => 'Konfiguracja łączy między transakcjami',
    'create_new_link_type'                  => 'Utwórz nowy typ łącza',
    'store_new_link_type'                   => 'Zapisz nowy typ łącza',
    'update_link_type'                      => 'Modyfikuj typ łącza',
    'edit_link_type'                        => 'Modyfikuj typ łącza ":name"',
    'updated_link_type'                     => 'Zaktualizowano typ łącza ":name"',
    'delete_link_type'                      => 'Usuń typ łącza ":name"',
    'deleted_link_type'                     => 'Usunięto typ łącza ":name"',
    'stored_new_link_type'                  => 'Zapisz nowy typ łącza ":name"',
    'cannot_edit_link_type'                 => 'Nie można zaktualizować typu łącza ":name"',
    'link_type_help_name'                   => 'Np. "Duplikaty"',
    'link_type_help_inward'                 => 'Np. "duplikuje"',
    'link_type_help_outward'                => 'Np. "jest zduplikowana przez"',
    'save_connections_by_moving'            => 'Zapisz powiązania miedzy tymi transakcjami, przenosząc je do innego typu łącza:',
    'do_not_save_connection'                => '(nie zapisuj powiązań)',
    'link_transaction'                      => 'Powiąż transakcje',
    'link_to_other_transaction'             => 'Powiąż aktualną transakcję z inną transakcją',
    'select_transaction_to_link'            => 'Wybierz transakcję, aby powiązać tę transakcję. Powiązania są obecnie nieużywane w Firefly III (oprócz pokazywania), ale zamierzam to zmienić w przyszłości. Użyj pola wyszukiwania, aby wybrać transakcję według tytułu lub ID. Jeśli chcesz dodać niestandardowe typy powiązań, sprawdź sekcję administracyjną.',
    'this_transaction'                      => 'Ta transakcja',
    'transaction'                           => 'Transakcja',
    'comments'                              => 'Komentarze',
    'link_notes'                            => 'Notatki które chcesz zapisać wraz z powiązaniem.',
    'invalid_link_selection'                => 'Nie można powiązać tych transakcji',
    'selected_transaction'                  => 'Wybrana transakcja',
    'journals_linked'                       => 'Transakcje zostały powiązane.',
    'journals_error_linked'                 => 'Wybrane transakcje są już powiązane.',
    'journals_link_to_self'                 => 'Nie możesz powiązać transakcji z samej ze sobą',
    'journal_links'                         => 'Powiązane transakcje',
    'this_withdrawal'                       => 'Ta wypłata',
    'this_deposit'                          => 'Ta wpłata',
    'this_transfer'                         => 'Ten transfer',
    'overview_for_link'                     => 'Przegląd dla typu łącza ":name"',
    'source_transaction'                    => 'Transakcja źródłowa',
    'link_description'                      => 'Opis łącza',
    'destination_transaction'               => 'Transakcja docelowa',
    'delete_journal_link'                   => 'Usuń powiązanie między <a href=":source_link">:source</a> a <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Usunięto powiązanie',

    // link translations:
    'Paid_name'                             => 'Płatność',
    'Refund_name'                           => 'Zwrot',
    'Reimbursement_name'                    => 'Refundacja (zwrot kosztów)',
    'Related_name'                          => 'Powiązanie',
    'relates to_inward'                     => 'odnosi się do',
    'is (partially) refunded by_inward'     => 'jest (częściowo) zwracane przez',
    'is (partially) paid for by_inward'     => 'jest (częściowo) opłacane przez',
    'is (partially) reimbursed by_inward'   => 'jest (częściowo) refundowany przez',
    'inward_transaction'                    => 'Transakcja wewnętrzna',
    'outward_transaction'                   => 'Transakcja zewnętrzna',
    'relates to_outward'                    => 'odnosi się do',
    '(partially) refunds_outward'           => '(częściowo) refundowany',
    '(partially) pays for_outward'          => '(częściowo) płaci za',
    '(partially) reimburses_outward'        => '(częściowo) refundowany',
    'is (partially) refunded by'            => 'jest (częściowo) zwracane przez',
    'is (partially) paid for by'            => 'jest (częściowo) opłacane przez',
    'is (partially) reimbursed by'          => 'jest (częściowo) refundowany przez',
    'relates to'                            => 'odnosi się do',
    '(partially) refunds'                   => '(częściowo) zwraca',
    '(partially) pays for'                  => '(częściowo) płaci za',
    '(partially) reimburses'                => '(częściowo) refunduje',

    // split a transaction:
    'splits'                                => 'Podziały',
    'add_another_split'                     => 'Dodaj kolejny podział',
    'cannot_edit_opening_balance'           => 'Nie możesz edytować salda otwarcia konta.',
    'no_edit_multiple_left'                 => 'Nie wybrałeś żadnych poprawnych transakcji do edycji.',
    'breadcrumb_convert_group'              => 'Konwertuj tę transakcję',
    'convert_invalid_source'                => 'Informacje źródłowe są nieprawidłowe dla transakcji #%d.',
    'convert_invalid_destination'           => 'Informacje docelowe są nieprawidłowe dla transakcji #%d.',
    'create_another'                        => 'Po zapisaniu wróć tutaj, aby utworzyć kolejny.',
    'after_update_create_another'           => 'Po aktualizacji wróć tutaj, aby kontynuować edycję.',
    'store_as_new'                          => 'Zapisz jako nową zamiast aktualizować.',
    'reset_after'                           => 'Wyczyść formularz po zapisaniu',
    'errors_submission'                     => 'Coś poszło nie tak w czasie zapisu. Proszę, sprawdź błędy poniżej.',
    'errors_submission_v2'                  => 'Coś poszło nie tak w czasie zapisu. Proszę, sprawdź błędy poniżej: {{errorMessage}}',
    'transaction_expand_split'              => 'Rozwiń podział',
    'transaction_remove_split'              => 'Usuń podział',
    'transaction_collapse_split'            => 'Zwiń podział',

    // object groups
    'default_group_title_name'              => '(bez grupy)',
    'default_group_title_name_plain'        => 'bez grupy',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Stwórzmy konto aktywów!',
    'no_accounts_intro_asset'               => 'Nie masz jeszcze konta nie aktywów. Konta aktywów są twoimi głównymi kontami: konto czekowe, konto oszczędnościowe, wspólne konto lub nawet karta kredytowa.',
    'no_accounts_imperative_asset'          => 'Aby rozpocząć korzystanie z Firefly III należy utworzyć co najmniej jedno konto aktywów. Zróbmy je więc teraz:',
    'no_accounts_create_asset'              => 'Utwórz konto aktywów',
    'no_accounts_title_expense'             => 'Stwórzmy konto wydatków!',
    'no_accounts_intro_expense'             => 'Nie masz jeszcze żadnych kont wydatków. Konta wydatków to miejsca, w których wydajesz pieniądze, takie jak sklepy i supermarkety.',
    'no_accounts_imperative_expense'        => 'Konta wydatków są tworzone automatycznie podczas tworzenia transakcji, ale możesz również utworzyć je ręcznie, jeśli chcesz. Stwórzmy jedno teraz:',
    'no_accounts_create_expense'            => 'Utwórz konto wydatków',
    'no_accounts_title_revenue'             => 'Stwórzmy konto przychodów!',
    'no_accounts_intro_revenue'             => 'Nie masz jeszcze żadnych kont przychodów. Konta przychodów to miejsca, z których dostajesz pieniądze, takie jak pracodawca.',
    'no_accounts_imperative_revenue'        => 'Konta przychodów są tworzone automatycznie podczas tworzenia transakcji, ale możesz również utworzyć je ręcznie, jeśli chcesz. Stwórzmy jedno teraz:',
    'no_accounts_create_revenue'            => 'Utwórz konto przychodów',
    'no_accounts_title_liabilities'         => 'Stwórzmy zobowiązanie!',
    'no_accounts_intro_liabilities'         => 'Nie masz jeszcze żadnych zobowiązań. Zobowiązania to konta które rejestrują Twoje kredyty (np. studenckie) i inne długi.',
    'no_accounts_imperative_liabilities'    => 'Nie musisz korzystać z tej funkcji, ale może być przydatna, jeśli chcesz śledzić te rzeczy.',
    'no_accounts_create_liabilities'        => 'Utwórz zobowiązanie',
    'no_budgets_title_default'              => 'Stwórzmy budżet',
    'no_rules_title_default'                => 'Stwórzmy regułę',
    'no_budgets_intro_default'              => 'Nie masz jeszcze żadnych budżetów. Budżety są wykorzystywane do organizowania twoich wydatków w logiczne grupy, które możesz obserwować, aby ograniczyć swoje wydatki.',
    'no_rules_intro_default'                => 'Nie masz jeszcze żadnych reguł. Automatyzacja reguł jest dosyć potężna i może pomóc Ci w obsłudze transakcji.',
    'no_rules_imperative_default'           => 'Reguły mogą być bardzo przydatne podczas zarządzania transakcjami. Utwórzmy jedną teraz:',
    'no_budgets_imperative_default'         => 'Budżety są podstawowymi narzędziami zarządzania finansami. Stwórzmy jeden teraz:',
    'no_budgets_create_default'             => 'Stwórz budżet',
    'no_rules_create_default'               => 'Utwórz regułę',
    'no_categories_title_default'           => 'Stwórzmy kategorię!',
    'no_categories_intro_default'           => 'Nie masz jeszcze żadnych kategorii. Kategorie służą do precyzyjnego dostrajania transakcji i oznaczania ich zgodnie z wyznaczoną kategorią.',
    'no_categories_imperative_default'      => 'Kategorie są tworzone automatycznie podczas tworzenia transakcji, ale możesz również utworzyć je ręcznie, jeśli chcesz. Stwórzmy jedną teraz:',
    'no_categories_create_default'          => 'Stwórz kategorię',
    'no_tags_title_default'                 => 'Stwórzmy tag!',
    'no_tags_intro_default'                 => 'Nie masz jeszcze tagów. Tagi służą do precyzyjnego dostrajania transakcji i oznaczania ich zgodnie konkretnymi słowami kluczowymi.',
    'no_tags_imperative_default'            => 'Tagi są tworzone automatycznie podczas tworzenia transakcji, ale możesz również utworzyć je ręcznie. Stwórzmy jeden teraz:',
    'no_tags_create_default'                => 'Utwórz tag',
    'no_transactions_title_withdrawal'      => 'Stwórzmy wydatek!',
    'no_transactions_intro_withdrawal'      => 'Jeszcze nie masz wydatków. Powinieneś utworzyć wydatki aby rozpocząć zarządzanie swoimi finansami.',
    'no_transactions_imperative_withdrawal' => 'Wydałeś trochę pieniędzy? Zatem powinieneś je zapisać:',
    'no_transactions_create_withdrawal'     => 'Utwórz wydatek',
    'no_transactions_title_deposit'         => 'Stwórzmy przychód!',
    'no_transactions_intro_deposit'         => 'Jeszcze nie masz przychodów. Powinieneś utworzyć przychody aby rozpocząć zarządzanie swoimi finansami.',
    'no_transactions_imperative_deposit'    => 'Otrzymałeś trochę pieniędzy? Zatem powinieneś je zapisać:',
    'no_transactions_create_deposit'        => 'Stwórz depozyt',
    'no_transactions_title_transfers'       => 'Stwórzmy transfer!',
    'no_transactions_intro_transfers'       => 'Nie masz jeszcze żadnych transferów. Przenosząc pieniądze między kontami aktywów, rejestruje się je jako transfer.',
    'no_transactions_imperative_transfers'  => 'Czy przenosiłeś trochę pieniędzy? Zatem powinieneś to zapisać:',
    'no_transactions_create_transfers'      => 'Utwórz transfer',
    'no_piggies_title_default'              => 'Stwórzmy skarbonkę!',
    'no_piggies_intro_default'              => 'Nie posiadasz jeszcze żadnych skarbonek. Możesz stworzyć skarbonki aby dzielić swoje oszczędności i śledzić na co oszczędzasz.',
    'no_piggies_imperative_default'         => 'Oszczędzasz pieniądze na coś? Utwórz skarbonkę i śledź:',
    'no_piggies_create_default'             => 'Utwórz nową skarbonkę',
    'no_bills_title_default'                => 'Utwórzmy subskrypcję!',
    'no_bills_intro_default'                => 'Nie masz jeszcze żadnych subskrypcji. Możesz tworzyć subskrypcje, aby śledzić regularne wydatki, takie jak czynsz lub ubezpieczenie.',
    'no_bills_imperative_default'           => 'Czy masz takie regularne opłaty? Utwórz subskrypcję i monitoruj swoje płatności:',
    'no_bills_create_default'               => 'Utwórz subskrypcję',

    // recurring transactions
    'recurrence_max_count'                  => 'Ta cykliczna transakcja będzie utworzona najwyżej :max raz(y) i została już utworzona :count raz(y).',
    'create_right_now'                      => 'Utwórz teraz',
    'no_new_transaction_in_recurrence'      => 'Nie utworzono żadnej nowej transakcji. Być może została ona już uruchomiona na tę datę?',
    'recurrences'                           => 'Cykliczne transakcje',
    'repeat_until_in_past'                  => 'Ta cykliczna transakcja przestała powtarzać się w dniu :date.',
    'recurring_calendar_view'               => 'Kalendarz',
    'no_recurring_title_default'            => 'Utwórzmy cykliczną transakcję!',
    'no_recurring_intro_default'            => 'Nie masz jeszcze żadnych cyklicznych transakcji. Możesz ich użyć, aby Firefly III automatycznie tworzył transakcje za Ciebie.',
    'no_recurring_imperative_default'       => 'To dość zaawansowana funkcja, ale może być niezwykle przydatna. Zanim rozpoczniesz zapoznaj się z dokumentacją (ikona (?) w prawym górnym rogu).',
    'no_recurring_create_default'           => 'Utwórz cykliczną transakcję',
    'make_new_recurring'                    => 'Utwórz cykliczną transakcję',
    'recurring_daily'                       => 'Codziennie',
    'recurring_weekly'                      => 'Co tydzień w :weekday',
    'recurring_weekly_skip'                 => 'Co każdy :skip tydzień w :weekday',
    'recurring_monthly'                     => 'Co miesiąc w :dayOfMonth dzień',
    'recurring_monthly_skip'                => 'Co każdy :skip miesiąc :dayOfMonth dnia miesiąca',
    'recurring_ndom'                        => 'Co miesiąc w każdy :dayOfMonth. :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Co rok w dniu :date',
    'overview_for_recurrence'               => 'Przegląd cyklicznej transakcji ":title"',
    'warning_duplicates_repetitions'        => 'W rzadkich przypadkach daty pojawiają się dwa razy na tej liście. Może się to zdarzyć, gdy zdarzy się wiele powtórzeń. Firefly III zawsze generuje jedną transakcję dziennie.',
    'created_transactions'                  => 'Powiązane transakcje',
    'expected_withdrawals'                  => 'Oczekiwane wypłaty',
    'expected_deposits'                     => 'Oczekiwane wpłaty',
    'expected_transfers'                    => 'Oczekiwane transfery',
    'created_withdrawals'                   => 'Utworzone wypłaty',
    'created_deposits'                      => 'Utworzone wpłaty',
    'created_transfers'                     => 'Utworzone transfery',
    'recurring_info'                        => 'Cykliczna transakcja :count / :total',
    'created_from_recurrence'               => 'Utworzona przez cykliczną transakcję ":title" (#:id)',
    'recurring_never_cron'                  => 'Wygląda na to, że zadanie cron, które jest niezbędne do obsługi powtarzających się transakcji, nigdy nie zostało uruchomione. Jest to normalne po zainstalowaniu Firefly III, ale powinno to być jak najszybciej skonfigurowane. Sprawdź strony pomocy za pomocą ikony (?) w prawym górnym rogu strony.',
    'recurring_cron_long_ago'               => 'Wygląda na to, że minęło ponad 36 godzin, od kiedy zadanie cron do obsługi cyklicznych transakcji zostało uruchomione po raz ostatni. Czy jesteś pewien, że zostało poprawnie skonfigurowane? Sprawdź strony pomocy za pomocą ikony (?) w prawym górnym rogu strony.',

    'create_new_recurrence'              => 'Utwórz nową cykliczną transakcję',
    'help_first_date'                    => 'Wskaż pierwsze oczekiwane wystąpienie. Musi być w przyszłości.',
    'help_first_date_no_past'            => 'Wskaż pierwsze oczekiwane wystąpienie. Firefly III nie będzie tworzyć transakcji w przeszłości.',
    'no_currency'                        => '(brak waluty)',
    'mandatory_for_recurring'            => 'Obowiązkowe informacje o powtarzalności',
    'mandatory_for_transaction'          => 'Obowiązkowe informacje o transakcji',
    'optional_for_recurring'             => 'Opcjonalne informacje o powtarzalności',
    'optional_for_transaction'           => 'Opcjonalne informacje o transakcji',
    'change_date_other_options'          => 'Zmień "datę początkową" aby zobaczyć więcej opcji.',
    'mandatory_fields_for_tranaction'    => 'Te wartości znajdą się w tworzonych transakcjach',
    'click_for_calendar'                 => 'Kliknij tutaj, aby wyświetlić kalendarz pokazujący, kiedy transakcja będzie się powtarzać.',
    'repeat_forever'                     => 'Powtarzaj bez końca',
    'repeat_until_date'                  => 'Powtarzaj aż do dnia',
    'repeat_times'                       => 'Powtarzaj określoną liczbę razy',
    'recurring_skips_one'                => 'Co drugi',
    'recurring_skips_more'               => 'Pomiń :count wystąpień',
    'store_new_recurrence'               => 'Zapisz cykliczną transakcję',
    'stored_new_recurrence'              => 'Cykliczna transakcja ":title" zapisana pomyślnie.',
    'edit_recurrence'                    => 'Modyfikuj cykliczną transakcję ":title"',
    'recurring_repeats_until'            => 'Powtarza się aż do :date',
    'recurring_repeats_forever'          => 'Powtarza się bez końca',
    'recurring_repeats_x_times'          => 'Powtarza się :count raz|Powtarza się :count razy',
    'update_recurrence'                  => 'Aktualizuj cykliczną transakcję',
    'updated_recurrence'                 => 'Zaktualizowano cykliczną transakcję ":title"',
    'recurrence_is_inactive'             => 'Ta cykliczna transakcja jest nieaktywna i nie będzie generowała nowych transakcji.',
    'delete_recurring'                   => 'Usuń cykliczną transakcję ":title"',
    'new_recurring_transaction'          => 'Nowa cykliczna transakcja',
    'help_weekend'                       => 'Co powinno zrobić Firefly III, jeśli cykliczna transakcja wypadnie w sobotę lub niedzielę?',
    'do_nothing'                         => 'Po prostu utwórz transakcję',
    'skip_transaction'                   => 'Pomiń wystąpienie',
    'jump_to_friday'                     => 'Utwórz transakcję w poprzedni piątek',
    'jump_to_monday'                     => 'Utwórz transakcję w następny poniedziałek',
    'will_jump_friday'                   => 'Zostanie utworzona w piątki zamiast w weekendy.',
    'will_jump_monday'                   => 'Zostanie utworzona w poniedziałki zamiast w weekendy.',
    'except_weekends'                    => 'Pomiń weekendy',
    'recurrence_deleted'                 => 'Cykliczna transakcja ":title" została usunięta',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Wydano (:currency)',
    'box_earned_in_currency'             => 'Zarobiono (:currency)',
    'box_budgeted_in_currency'           => 'Zabudżetowano (:currency)',
    'box_bill_paid_in_currency'          => 'Zapłacone subskrypcje (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subskrypcje nieopłacone (:currency)',
    'box_left_to_spend_in_currency'      => 'Możliwe do wydania (:currency)',
    'box_net_worth_in_currency'          => 'Wartość netto (:currency)',
    'box_spend_per_day'                  => 'Możliwe do wydania codziennie: :amount',

    // debug page
    'debug_page'                         => 'Strona debugowania',
    'debug_submit_instructions'          => 'Jeśli masz problemy możesz użyć informacji w tym polu jako informacji debugowania. Skopiuj i wklej do nowego lub istniejącego <a href="https://github.com/firefly-iii/firefly-iii/issues">problemu z GitHub</a>. Wygeneruje to piękną tabelę, która może być wykorzystana do szybkiego rozpoznania twojego problemu.',
    'debug_pretty_table'                 => 'Jeśli skopiujesz/wkleisz poniższe pole do problemu na GitHub, zostanie wygenerowana tabela. Proszę nie używaj cudzysłowów.',
    'debug_additional_data'              => 'Możesz również udostępnić zawartość poniższego pola. Możesz również skopiować i wkleić to do nowego lub istniejącego <a href="https://github.com/firefly-iii/firefly-iii/issues">problemu GitHub</a>. Jednakże zawartość tego pola może zawierać informacje prywatne, takie jak nazwy konta, szczegóły transakcji lub adresy e-mail.',

    // object groups
    'object_groups_menu_bar'             => 'Grupy',
    'object_groups_page_title'           => 'Grupy',
    'object_groups_breadcrumb'           => 'Grupy',
    'object_groups_index'                => 'Przegląd',
    'object_groups'                      => 'Grupy',
    'object_groups_empty_explain'        => 'Niektóre rzeczy w Firefly III można podzielić na grupy. Na przykład skarbonki zawierają pole "Grupa" w ekranach edycji i tworzenia. Gdy ustawisz to pole, możesz edytować nazwy i kolejność grup na tej stronie. Aby uzyskać więcej informacji, sprawdź strony pomocy w prawym górnym rogu, pod ikoną (?).',
    'object_group_title'                 => 'Tytuł',
    'edit_object_group'                  => 'Modyfikuj grupę ":title"',
    'delete_object_group'                => 'Usuń grupę ":title"',
    'update_object_group'                => 'Aktualizuj grupę',
    'updated_object_group'               => 'Pomyślnie zaktualizowano grupę ":title"',
    'deleted_object_group'               => 'Pomyślnie usunięto grupę ":title"',
    'object_group'                       => 'Grupa',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Wpisy dziennika audytu',
    'ale_action_log_add'                 => 'Dodano :amount do skarbonki ":name"',
    'ale_action_log_remove'              => 'Usunięto :amount ze skarbonki ":name"',
    'ale_action_clear_budget'            => 'Usunięto z budżetu',
    'ale_action_update_group_title'      => 'Zaktualizowano tytuł grupy transakcji',
    'ale_action_update_date'             => 'Zaktualizowano datę transakcji',
    'ale_action_update_order'            => 'Zaktualizowano kolejność transakcji',
    'ale_action_clear_category'          => 'Usunięto z kategorii',
    'ale_action_clear_notes'             => 'Usunięto notatki',
    'ale_action_clear_tag'               => 'Wyczyszczono tag',
    'ale_action_clear_all_tags'          => 'Wyczyszczono wszystkie tagi',
    'ale_action_set_bill'                => 'Powiązano z subskrypcją',
    'ale_action_switch_accounts'         => 'Zmieniono konto źródłowe i docelowe',
    'ale_action_set_budget'              => 'Ustawiono budżet',
    'ale_action_set_category'            => 'Ustawiono kategorię',
    'ale_action_set_source'              => 'Ustawiono konto źródłowe',
    'ale_action_set_destination'         => 'Ustawiono konto docelowe',
    'ale_action_update_transaction_type' => 'Zmieniono typ transakcji',
    'ale_action_update_notes'            => 'Zmieniono notatki',
    'ale_action_update_description'      => 'Zmieniono opis',
    'ale_action_add_to_piggy'            => 'Skarbonka',
    'ale_action_remove_from_piggy'       => 'Skarbonka',
    'ale_action_add_tag'                 => 'Dodano tag',
    'ale_action_update_amount'           => 'Zaktualizowano kwotę',

    // dashboard
    'enable_auto_convert'                => 'Włącz przeliczenie walut',
    'disable_auto_convert'               => 'Wyłącz przeliczanie walut',
];
