
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `firefly649`
--

-- --------------------------------------------------------

--
-- Table structure for table `2fa_tokens`
--

CREATE TABLE `2fa_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `expires_at` datetime NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `2fa_tokens_token_unique` (`token`),
  KEY `2fa_tokens_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `accounts`
--

CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `account_type_id` int(10) unsigned NOT NULL,
  `name` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `virtual_balance` decimal(32,12) DEFAULT NULL,
  `iban` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `native_virtual_balance` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_user_id_index` (`user_id`),
  KEY `accounts_user_group_id_index` (`user_group_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `account_balances`
--

CREATE TABLE `account_balances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `transaction_currency_id` int(10) unsigned NOT NULL,
  `date` date DEFAULT NULL,
  `date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_journal_id` int(10) unsigned DEFAULT NULL,
  `balance` decimal(32,12) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_account_currency` (`account_id`,`transaction_currency_id`,`transaction_journal_id`,`date`,`title`),
  KEY `account_balances_transaction_journal_id_foreign` (`transaction_journal_id`),
  KEY `account_balances_transaction_currency_id_foreign` (`transaction_currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `account_meta`
--

CREATE TABLE `account_meta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_meta_account_id_index` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `account_piggy_bank`
--

CREATE TABLE `account_piggy_bank` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `piggy_bank_id` int(10) unsigned NOT NULL,
  `current_amount` decimal(32,12) NOT NULL DEFAULT '0.000000000000',
  `native_current_amount` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_piggy_save` (`account_id`,`piggy_bank_id`),
  KEY `account_piggy_bank_piggy_bank_id_foreign` (`piggy_bank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `account_types`
--

CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_types_type_unique` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `account_types`
--

INSERT INTO `account_types` VALUES
(1, '[[regtime]]', '[[regtime]]', 'Asset account'),
(2, '[[regtime]]', '[[regtime]]', 'Beneficiary account'),
(3, '[[regtime]]', '[[regtime]]', 'Cash account'),
(4, '[[regtime]]', '[[regtime]]', 'Credit card'),
(5, '[[regtime]]', '[[regtime]]', 'Debt'),
(6, '[[regtime]]', '[[regtime]]', 'Default account'),
(7, '[[regtime]]', '[[regtime]]', 'Expense account'),
(8, '[[regtime]]', '[[regtime]]', 'Import account'),
(9, '[[regtime]]', '[[regtime]]', 'Initial balance account'),
(10, '[[regtime]]', '[[regtime]]', 'Liability credit account'),
(11, '[[regtime]]', '[[regtime]]', 'Loan'),
(12, '[[regtime]]', '[[regtime]]', 'Mortgage'),
(13, '[[regtime]]', '[[regtime]]', 'Reconciliation account'),
(14, '[[regtime]]', '[[regtime]]', 'Revenue account');

-- --------------------------------------------------------

--
-- Table structure for table `attachments`
--

CREATE TABLE `attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `attachable_id` int(10) unsigned NOT NULL,
  `attachable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `md5` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `mime` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `uploaded` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `attachments_user_id_foreign` (`user_id`),
  KEY `attachments_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `audit_log_entries`
--

CREATE TABLE `audit_log_entries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `auditable_id` int(10) unsigned NOT NULL,
  `auditable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `changer_id` int(10) unsigned NOT NULL,
  `changer_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `before` text COLLATE utf8mb4_unicode_ci,
  `after` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `auto_budgets`
--

CREATE TABLE `auto_budgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `budget_id` int(10) unsigned NOT NULL,
  `transaction_currency_id` int(10) unsigned NOT NULL,
  `auto_budget_type` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `amount` decimal(32,12) NOT NULL,
  `period` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `native_amount` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `auto_budgets_transaction_currency_id_foreign` (`transaction_currency_id`),
  KEY `auto_budgets_budget_id_foreign` (`budget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `available_budgets`
--

CREATE TABLE `available_budgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `transaction_currency_id` int(10) unsigned NOT NULL,
  `amount` decimal(32,12) NOT NULL,
  `start_date` date NOT NULL,
  `start_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end_date` date NOT NULL,
  `end_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `native_amount` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `available_budgets_transaction_currency_id_foreign` (`transaction_currency_id`),
  KEY `available_budgets_user_id_foreign` (`user_id`),
  KEY `available_budgets_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bills`
--

CREATE TABLE `bills` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `transaction_currency_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `match` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount_min` decimal(32,12) NOT NULL,
  `amount_max` decimal(32,12) NOT NULL,
  `date` date NOT NULL,
  `date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `end_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extension_date` date DEFAULT NULL,
  `extension_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `repeat_freq` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `skip` smallint(5) unsigned NOT NULL DEFAULT '0',
  `automatch` tinyint(1) NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `name_encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `match_encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `native_amount_min` decimal(32,12) DEFAULT NULL,
  `native_amount_max` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bills_user_id_foreign` (`user_id`),
  KEY `bills_transaction_currency_id_foreign` (`transaction_currency_id`),
  KEY `bills_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `budgets`
--

CREATE TABLE `budgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `budgets_user_id_index` (`user_id`),
  KEY `budgets_user_group_id_index` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `budget_limits`
--

CREATE TABLE `budget_limits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `budget_id` int(10) unsigned NOT NULL,
  `transaction_currency_id` int(10) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `start_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `end_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(32,12) NOT NULL,
  `period` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `generated` tinyint(1) NOT NULL DEFAULT '0',
  `native_amount` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `budget_limits_budget_id_foreign` (`budget_id`),
  KEY `budget_limits_transaction_currency_id_foreign` (`transaction_currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `budget_transaction`
--

CREATE TABLE `budget_transaction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `budget_id` int(10) unsigned NOT NULL,
  `transaction_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `budget_transaction_budget_id_foreign` (`budget_id`),
  KEY `budget_transaction_transaction_id_foreign` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `budget_transaction_journal`
--

CREATE TABLE `budget_transaction_journal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `budget_id` int(10) unsigned NOT NULL,
  `budget_limit_id` int(10) unsigned DEFAULT NULL,
  `transaction_journal_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `budget_transaction_journal_budget_id_foreign` (`budget_id`),
  KEY `budget_transaction_journal_transaction_journal_id_foreign` (`transaction_journal_id`),
  KEY `budget_id_foreign` (`budget_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `encrypted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `categories_user_id_index` (`user_id`),
  KEY `categories_user_group_id_index` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category_transaction`
--

CREATE TABLE `category_transaction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `transaction_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_transaction_category_id_foreign` (`category_id`),
  KEY `category_transaction_transaction_id_foreign` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category_transaction_journal`
--

CREATE TABLE `category_transaction_journal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `transaction_journal_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_transaction_journal_category_id_foreign` (`category_id`),
  KEY `category_transaction_journal_transaction_journal_id_index` (`transaction_journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `configuration`
--

CREATE TABLE `configuration` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=48 ;

--
-- Dumping data for table `configuration`
--

INSERT INTO `configuration` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 'db_version', '1'),
(2, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_accounts', 'true'),
(3, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_attachments', 'true'),
(4, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_bills', 'true'),
(5, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_budgets', 'true'),
(6, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_categories', 'true'),
(7, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_piggy_banks', 'true'),
(8, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_preferences', 'true'),
(9, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_tags', 'true'),
(10, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_transaction_journals', 'true'),
(11, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_transactions', 'true'),
(12, '[[regtime]]', '[[regtime]]', NULL, 'is_decrypted_journal_links', 'true'),
(13, '[[regtime]]', '[[regtime]]', NULL, '480_transaction_identifier', 'true'),
(14, '[[regtime]]', '[[regtime]]', NULL, '480_migrated_to_groups', 'true'),
(15, '[[regtime]]', '[[regtime]]', NULL, '480_account_currencies', 'true'),
(16, '[[regtime]]', '[[regtime]]', NULL, '480_transfer_currencies', 'true'),
(17, '[[regtime]]', '[[regtime]]', NULL, '480_other_currencies', 'true'),
(18, '[[regtime]]', '[[regtime]]', NULL, '480_migrate_notes', 'true'),
(19, '[[regtime]]', '[[regtime]]', NULL, '480_migrate_attachments', 'true'),
(20, '[[regtime]]', '[[regtime]]', NULL, '480_bills_to_rules', 'true'),
(21, '[[regtime]]', '[[regtime]]', NULL, '480_bl_currency', 'true'),
(22, '[[regtime]]', '[[regtime]]', NULL, '480_cc_liabilities', 'true'),
(23, '[[regtime]]', '[[regtime]]', NULL, '480_back_to_journals', 'true'),
(24, '[[regtime]]', '[[regtime]]', NULL, '480_rename_account_meta', 'true'),
(25, '[[regtime]]', '[[regtime]]', NULL, '481_migrate_recurrence_meta', 'true'),
(26, '[[regtime]]', '[[regtime]]', NULL, '500_migrate_tag_locations', 'true'),
(27, '[[regtime]]', '[[regtime]]', NULL, '560_upgrade_liabilities', 'true'),
(28, '[[regtime]]', '[[regtime]]', NULL, '600_upgrade_liabilities', 'true'),
(29, '[[regtime]]', '[[regtime]]', NULL, '550_budget_limit_periods', 'true'),
(30, '[[regtime]]', '[[regtime]]', NULL, '610_migrate_rule_actions', 'true'),
(31, '[[regtime]]', '[[regtime]]', NULL, '610_correct_balances', 'false'),
(32, '[[regtime]]', '[[regtime]]', NULL, '610_upgrade_currency_prefs', 'true'),
(33, '[[regtime]]', '[[regtime]]', NULL, '620_make_multi_piggies', 'true'),
(34, '[[regtime]]', '[[regtime]]', NULL, '620_pc_amounts', 'true'),
(35, '[[regtime]]', '[[regtime]]', NULL, '640_upgrade_webhooks', 'true'),
(36, '[[regtime]]', '[[regtime]]', NULL, 'oauth_private_key', '[[private_key_enc]]'),
(37, '[[regtime]]', '[[regtime]]', NULL, 'oauth_public_key', '[[public_key_enc]]'),
(38, '[[regtime]]', '[[regtime]]', NULL, 'utc', 'false'),
(39, '[[regtime]]', '[[regtime]]', NULL, 'ff3_build_time', '1764362024'),
(40, '[[regtime]]', '[[regtime]]', NULL, 'installation_id', '[[installation_id]]'),
(41, '[[regtime]]', '[[regtime]]', NULL, 'is_demo_site', 'false'),
(42, '[[regtime]]', '[[regtime]]', NULL, 'single_user_mode', 'true'),
(43, '[[regtime]]', '[[regtime]]', NULL, 'notification_user_new_reg', 'true'),
(44, '[[regtime]]', '[[regtime]]', NULL, 'notification_admin_new_reg', 'true'),
(45, '[[regtime]]', '[[regtime]]', NULL, 'slack_webhook_url', '""'),
(46, '[[regtime]]', '[[regtime]]', NULL, 'pushover_app_token', '""'),
(47, '[[regtime]]', '[[regtime]]', NULL, 'pushover_user_token', '""');

-- --------------------------------------------------------

--
-- Table structure for table `currency_exchange_rates`
--

CREATE TABLE `currency_exchange_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `from_currency_id` int(10) unsigned NOT NULL,
  `to_currency_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate` decimal(32,12) NOT NULL,
  `user_rate` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_exchange_rates_user_id_foreign` (`user_id`),
  KEY `currency_exchange_rates_from_currency_id_foreign` (`from_currency_id`),
  KEY `currency_exchange_rates_to_currency_id_foreign` (`to_currency_id`),
  KEY `cer_to_ugi` (`user_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=31 ;

--
-- Dumping data for table `currency_exchange_rates`
--

INSERT INTO `currency_exchange_rates` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 1, '2025-04-15', NULL, '1.000000000000', NULL),
(2, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 2, '2025-04-15', NULL, '410.797980000000', NULL),
(3, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 3, '2025-04-15', NULL, '0.860032610000', NULL),
(4, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 4, '2025-04-15', NULL, '46.867455000000', NULL),
(5, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 5, '2025-04-15', NULL, '4.280209800000', NULL),
(6, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 6, '2025-04-15', NULL, '43.180054000000', NULL),
(7, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 7, '2025-04-15', NULL, '7.459100000000', NULL),
(8, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 11, '2025-04-15', NULL, '7.464833600000', NULL),
(9, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 12, '2025-04-15', NULL, '1.134904400000', NULL),
(10, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 13, '2025-04-15', NULL, '6.645851800000', NULL),
(11, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 14, '2025-04-15', NULL, '1.575105000000', NULL),
(12, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 15, '2025-04-15', NULL, '22.805278000000', NULL),
(13, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 20, '2025-04-15', NULL, '19070.382000000000', NULL),
(14, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 21, '2025-04-15', NULL, '1.787202000000', NULL),
(15, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 22, '2025-04-15', NULL, '1.919107800000', NULL),
(16, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 23, '2025-04-15', NULL, '57.874172000000', NULL),
(17, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 24, '2025-04-15', NULL, '10.549438000000', NULL),
(18, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 25, '2025-04-15', NULL, '21.444356000000', NULL),
(19, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 26, '2025-04-15', NULL, '162.471950000000', NULL),
(20, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 27, '2025-04-15', NULL, '8.284997700000', NULL),
(21, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 29, '2025-04-15', NULL, '93.344230000000', NULL),
(22, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 30, '2025-04-15', NULL, '97.572815000000', NULL),
(23, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 31, '2025-04-15', NULL, '4.180178600000', NULL),
(24, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 32, '2025-04-15', NULL, '0.926831260000', NULL),
(25, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 33, '2025-04-15', NULL, '7.534500000000', NULL),
(26, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 8, '2025-04-15', NULL, '145.105320000000', NULL),
(27, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 9, '2025-04-15', NULL, '11.980824000000', NULL),
(28, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 10, '2025-04-15', NULL, '11.088090000000', NULL),
(29, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 34, '2025-04-15', NULL, '8.804632200000', NULL),
(30, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 1, 35, '2025-04-15', NULL, '25.092213000000', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_journals`
--

CREATE TABLE `group_journals` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_group_id` int(10) unsigned NOT NULL,
  `transaction_journal_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_in_group` (`transaction_group_id`,`transaction_journal_id`),
  KEY `group_journals_transaction_journal_id_foreign` (`transaction_journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_memberships`
--

CREATE TABLE `group_memberships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned NOT NULL,
  `user_role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_memberships_user_id_user_group_id_user_role_id_unique` (`user_id`,`user_group_id`,`user_role_id`),
  KEY `group_memberships_user_group_id_foreign` (`user_group_id`),
  KEY `group_memberships_user_role_id_foreign` (`user_role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `group_memberships`
--

INSERT INTO `group_memberships` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 1, 1, 21);

-- --------------------------------------------------------

--
-- Table structure for table `invited_users`
--

CREATE TABLE `invited_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invite_code` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires` datetime NOT NULL,
  `expires_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redeemed` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `invited_users_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `journal_links`
--

CREATE TABLE `journal_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `link_type_id` int(10) unsigned NOT NULL,
  `source_id` int(10) unsigned NOT NULL,
  `destination_id` int(10) unsigned NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `journal_links_link_type_id_source_id_destination_id_unique` (`link_type_id`,`source_id`,`destination_id`),
  KEY `journal_links_source_id_foreign` (`source_id`),
  KEY `journal_links_destination_id_foreign` (`destination_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `journal_meta`
--

CREATE TABLE `journal_meta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_journal_id` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_meta_transaction_journal_id_index` (`transaction_journal_id`),
  KEY `journal_meta_name_index` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `link_types`
--

CREATE TABLE `link_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `outward` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `inward` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `editable` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `link_types_name_outward_inward_unique` (`name`,`outward`,`inward`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `link_types`
--

INSERT INTO `link_types` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 'Related', 'relates to', 'relates to', 0),
(2, '[[regtime]]', '[[regtime]]', NULL, 'Refund', '(partially) refunds', 'is (partially) refunded by', 0),
(3, '[[regtime]]', '[[regtime]]', NULL, 'Paid', '(partially) pays for', 'is (partially) paid for by', 0),
(4, '[[regtime]]', '[[regtime]]', NULL, 'Reimbursement', '(partially) reimburses', 'is (partially) reimbursed by', 0);

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE `locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `locatable_id` int(10) unsigned NOT NULL,
  `locatable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitude` decimal(12,8) DEFAULT NULL,
  `longitude` decimal(12,8) DEFAULT NULL,
  `zoom_level` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=60 ;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` VALUES
(1, '2016_06_16_000000_create_support_tables', 1),
(2, '2016_06_16_000001_create_users_table', 1),
(3, '2016_06_16_000002_create_main_tables', 1),
(4, '2016_08_25_091522_changes_for_3101', 1),
(5, '2016_09_12_121359_fix_nullables', 1),
(6, '2016_10_09_150037_expand_transactions_table', 1),
(7, '2016_10_22_075804_changes_for_v410', 1),
(8, '2016_11_24_210552_changes_for_v420', 1),
(9, '2016_12_22_150431_changes_for_v430', 1),
(10, '2016_12_28_203205_changes_for_v431', 1),
(11, '2017_04_13_163623_changes_for_v440', 1),
(12, '2017_06_02_105232_changes_for_v450', 1),
(13, '2017_08_20_062014_changes_for_v470', 1),
(14, '2017_11_04_170844_changes_for_v470a', 1),
(15, '2018_01_01_000001_create_oauth_auth_codes_table', 1),
(16, '2018_01_01_000002_create_oauth_access_tokens_table', 1),
(17, '2018_01_01_000003_create_oauth_refresh_tokens_table', 1),
(18, '2018_01_01_000004_create_oauth_clients_table', 1),
(19, '2018_01_01_000005_create_oauth_personal_access_clients_table', 1),
(20, '2018_03_19_141348_changes_for_v472', 1),
(21, '2018_04_07_210913_changes_for_v473', 1),
(22, '2018_04_29_174524_changes_for_v474', 1),
(23, '2018_06_08_200526_changes_for_v475', 1),
(24, '2018_09_05_195147_changes_for_v477', 1),
(25, '2018_11_06_172532_changes_for_v479', 1),
(26, '2019_01_28_193833_changes_for_v4710', 1),
(27, '2019_02_05_055516_changes_for_v4711', 1),
(28, '2019_02_11_170529_changes_for_v4712', 1),
(29, '2019_03_11_223700_fix_ldap_configuration', 1),
(30, '2019_03_22_183214_changes_for_v480', 1),
(31, '2019_11_30_000000_create_2fa_token_table', 1),
(32, '2019_12_28_191351_make_locations_table', 1),
(33, '2020_03_13_201950_changes_for_v520', 1),
(34, '2020_06_07_063612_changes_for_v530', 1),
(35, '2020_06_30_202620_changes_for_v530a', 1),
(36, '2020_07_24_162820_changes_for_v540', 1),
(37, '2020_11_12_070604_changes_for_v550', 1),
(38, '2021_03_12_061213_changes_for_v550b2', 1),
(39, '2021_05_09_064644_add_ldap_columns_to_users_table', 1),
(40, '2021_05_13_053836_extend_currency_info', 1),
(41, '2021_07_05_193044_drop_tele_table', 1),
(42, '2021_08_28_073733_user_groups', 1),
(43, '2021_12_27_000001_create_local_personal_access_tokens_table', 1),
(44, '2022_08_21_104626_add_user_groups', 1),
(45, '2022_09_18_123911_create_notifications_table', 1),
(46, '2022_10_01_074908_invited_users', 1),
(47, '2022_10_01_210238_audit_log_entries', 1),
(48, '2023_08_11_192521_upgrade_og_table', 1),
(49, '2023_10_21_113213_add_currency_pivot_tables', 1),
(50, '2024_03_03_174645_add_indices', 1),
(51, '2024_04_01_174351_expand_preferences_table', 1),
(52, '2024_05_12_060551_create_account_balance_table', 1),
(53, '2024_07_28_145631_add_running_balance', 1),
(54, '2024_11_05_062108_add_date_tz_columns', 1),
(55, '2024_11_30_075826_multi_piggy', 1),
(56, '2024_12_19_061003_add_native_amount_column', 1),
(57, '2025_07_10_065736_rename_tag_mode', 1),
(58, '2025_08_19_180459_create_webhook_details_tables', 1),
(59, '2025_09_25_175248_create_period_statistics', 1);

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `noteable_id` int(10) unsigned NOT NULL,
  `noteable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_access_tokens`
--

CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `client_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_auth_codes`
--

CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_clients`
--

CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_personal_access_clients`
--

CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oauth_refresh_tokens`
--

CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `object_groupables`
--

CREATE TABLE `object_groupables` (
  `object_group_id` int(11) NOT NULL,
  `object_groupable_id` int(10) unsigned NOT NULL,
  `object_groupable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `object_groups`
--

CREATE TABLE `object_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `object_groups_user_id_foreign` (`user_id`),
  KEY `object_groups_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `period_statistics`
--

CREATE TABLE `period_statistics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_group_id` bigint(20) unsigned NOT NULL,
  `primary_statable_id` int(10) unsigned DEFAULT NULL,
  `primary_statable_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `secondary_statable_id` int(10) unsigned DEFAULT NULL,
  `secondary_statable_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tertiary_statable_id` int(10) unsigned DEFAULT NULL,
  `tertiary_statable_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_currency_id` int(10) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `start_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `end_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `amount` decimal(32,12) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `period_statistics_transaction_currency_id_foreign` (`transaction_currency_id`),
  KEY `period_statistics_user_group_id_foreign` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `permission_role`
--

CREATE TABLE `permission_role` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `permission_role_role_id_foreign` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `piggy_banks`
--

CREATE TABLE `piggy_banks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `account_id` int(10) unsigned DEFAULT NULL,
  `transaction_currency_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_amount` decimal(32,12) NOT NULL,
  `start_date` date DEFAULT NULL,
  `start_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_date` date DEFAULT NULL,
  `target_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `encrypted` tinyint(1) NOT NULL DEFAULT '1',
  `native_target_amount` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `unique_currency` (`transaction_currency_id`),
  KEY `piggy_banks_account_id_foreign` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `piggy_bank_events`
--

CREATE TABLE `piggy_bank_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `piggy_bank_id` int(10) unsigned NOT NULL,
  `transaction_journal_id` int(10) unsigned DEFAULT NULL,
  `date` date NOT NULL,
  `date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(32,12) NOT NULL,
  `native_amount` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `piggy_bank_events_piggy_bank_id_foreign` (`piggy_bank_id`),
  KEY `piggy_bank_events_transaction_journal_id_foreign` (`transaction_journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `piggy_bank_repetitions`
--

CREATE TABLE `piggy_bank_repetitions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `piggy_bank_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `start_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target_date` date DEFAULT NULL,
  `target_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_amount` decimal(32,12) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `piggy_bank_repetitions_piggy_bank_id_foreign` (`piggy_bank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `preferences`
--

CREATE TABLE `preferences` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `preferences_user_id_foreign` (`user_id`),
  KEY `preferences_to_ugi` (`user_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `preferences`
--

INSERT INTO `preferences` VALUES
(1, '[[regtime]]', '[[regtime]]', 1, NULL, 'viewRange', '"1M"'),
(2, '[[regtime]]', '[[regtime]]', 1, NULL, 'language', '"[[language]]"');

-- --------------------------------------------------------

--
-- Table structure for table `recurrences`
--

CREATE TABLE `recurrences` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `transaction_type_id` int(10) unsigned NOT NULL,
  `title` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_date` date NOT NULL,
  `first_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `repeat_until` date DEFAULT NULL,
  `repeat_until_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latest_date` date DEFAULT NULL,
  `latest_date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `repetitions` smallint(5) unsigned NOT NULL,
  `apply_rules` tinyint(1) NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `recurrences_user_id_foreign` (`user_id`),
  KEY `recurrences_transaction_type_id_foreign` (`transaction_type_id`),
  KEY `recurrences_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `recurrences_meta`
--

CREATE TABLE `recurrences_meta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `recurrence_id` int(10) unsigned NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `recurrences_meta_recurrence_id_foreign` (`recurrence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `recurrences_repetitions`
--

CREATE TABLE `recurrences_repetitions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `recurrence_id` int(10) unsigned NOT NULL,
  `repetition_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `repetition_moment` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `repetition_skip` smallint(5) unsigned NOT NULL,
  `weekend` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `recurrences_repetitions_recurrence_id_foreign` (`recurrence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `recurrences_transactions`
--

CREATE TABLE `recurrences_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `recurrence_id` int(10) unsigned NOT NULL,
  `transaction_currency_id` int(10) unsigned NOT NULL,
  `transaction_type_id` int(10) unsigned DEFAULT NULL,
  `foreign_currency_id` int(10) unsigned DEFAULT NULL,
  `source_id` int(10) unsigned NOT NULL,
  `destination_id` int(10) unsigned NOT NULL,
  `amount` decimal(32,12) NOT NULL,
  `foreign_amount` decimal(32,12) DEFAULT NULL,
  `description` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `recurrences_transactions_recurrence_id_foreign` (`recurrence_id`),
  KEY `recurrences_transactions_transaction_currency_id_foreign` (`transaction_currency_id`),
  KEY `recurrences_transactions_foreign_currency_id_foreign` (`foreign_currency_id`),
  KEY `recurrences_transactions_source_id_foreign` (`source_id`),
  KEY `recurrences_transactions_destination_id_foreign` (`destination_id`),
  KEY `type_foreign` (`transaction_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_unique` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` VALUES
(1, '[[regtime]]', '[[regtime]]', 'owner', 'Site Owner', 'User runs this instance of FF3'),
(2, '[[regtime]]', '[[regtime]]', 'demo', 'Demo User', 'User is a demo user');

-- --------------------------------------------------------

--
-- Table structure for table `role_user`
--

CREATE TABLE `role_user` (
  `user_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_user_role_id_foreign` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_user`
--

INSERT INTO `role_user` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `rt_meta`
--

CREATE TABLE `rt_meta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `rt_id` int(10) unsigned NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rt_meta_rt_id_foreign` (`rt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rules`
--

CREATE TABLE `rules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `rule_group_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `stop_processing` tinyint(1) NOT NULL DEFAULT '0',
  `strict` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `rules_user_id_foreign` (`user_id`),
  KEY `rules_rule_group_id_foreign` (`rule_group_id`),
  KEY `rules_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rule_actions`
--

CREATE TABLE `rule_actions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `rule_id` int(10) unsigned NOT NULL,
  `action_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `stop_processing` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `rule_actions_rule_id_foreign` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rule_groups`
--

CREATE TABLE `rule_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `stop_processing` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `rule_groups_user_id_foreign` (`user_id`),
  KEY `rule_groups_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rule_triggers`
--

CREATE TABLE `rule_triggers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `rule_id` int(10) unsigned NOT NULL,
  `trigger_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `stop_processing` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `rule_triggers_rule_id_foreign` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `tag` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag_mode` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date DEFAULT NULL,
  `date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `latitude` decimal(12,8) DEFAULT NULL,
  `longitude` decimal(12,8) DEFAULT NULL,
  `zoomLevel` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tags_user_id_foreign` (`user_id`),
  KEY `tags_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tag_transaction_journal`
--

CREATE TABLE `tag_transaction_journal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` int(10) unsigned NOT NULL,
  `transaction_journal_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag_transaction_journal_tag_id_transaction_journal_id_unique` (`tag_id`,`transaction_journal_id`),
  KEY `tag_transaction_journal_transaction_journal_id_foreign` (`transaction_journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `reconciled` tinyint(1) NOT NULL DEFAULT '0',
  `account_id` int(10) unsigned NOT NULL,
  `transaction_journal_id` int(10) unsigned NOT NULL,
  `description` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_currency_id` int(10) unsigned DEFAULT NULL,
  `amount` decimal(32,12) NOT NULL,
  `balance_before` decimal(32,12) DEFAULT NULL,
  `balance_after` decimal(32,12) DEFAULT NULL,
  `balance_dirty` tinyint(1) NOT NULL DEFAULT '1',
  `foreign_amount` decimal(32,12) DEFAULT NULL,
  `foreign_currency_id` int(10) unsigned DEFAULT NULL,
  `identifier` smallint(5) unsigned NOT NULL DEFAULT '0',
  `native_amount` decimal(32,12) DEFAULT NULL,
  `native_foreign_amount` decimal(32,12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_account_id_index` (`account_id`),
  KEY `transactions_transaction_journal_id_index` (`transaction_journal_id`),
  KEY `transactions_transaction_currency_id_index` (`transaction_currency_id`),
  KEY `transactions_foreign_currency_id_index` (`foreign_currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `transaction_currencies`
--

CREATE TABLE `transaction_currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `code` varchar(51) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(51) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_places` smallint(5) unsigned NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`),
  UNIQUE KEY `transaction_currencies_code_unique` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=38 ;

--
-- Dumping data for table `transaction_currencies`
--

INSERT INTO `transaction_currencies` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 1, 'EUR', 'Euro', '€', 2),
(2, '[[regtime]]', '[[regtime]]', NULL, 0, 'HUF', 'Hungarian forint', 'Ft', 2),
(3, '[[regtime]]', '[[regtime]]', NULL, 0, 'GBP', 'British Pound', '£', 2),
(4, '[[regtime]]', '[[regtime]]', NULL, 0, 'UAH', 'Ukrainian hryvnia', '₴', 2),
(5, '[[regtime]]', '[[regtime]]', NULL, 0, 'PLN', 'Polish złoty', 'zł', 2),
(6, '[[regtime]]', '[[regtime]]', NULL, 0, 'TRY', 'Turkish lira', '₺', 2),
(7, '[[regtime]]', '[[regtime]]', NULL, 0, 'DKK', 'Dansk krone', 'kr.', 2),
(8, '[[regtime]]', '[[regtime]]', NULL, 0, 'ISK', 'Íslensk króna', 'kr.', 2),
(9, '[[regtime]]', '[[regtime]]', NULL, 0, 'NOK', 'Norsk krone', 'kr.', 2),
(10, '[[regtime]]', '[[regtime]]', NULL, 0, 'SEK', 'Svensk krona', 'kr.', 2),
(11, '[[regtime]]', '[[regtime]]', NULL, 0, 'RON', 'Romanian leu', 'lei', 2),
(12, '[[regtime]]', '[[regtime]]', NULL, 0, 'USD', 'US Dollar', '$', 2),
(13, '[[regtime]]', '[[regtime]]', NULL, 0, 'BRL', 'Brazilian real', 'R$', 2),
(14, '[[regtime]]', '[[regtime]]', NULL, 0, 'CAD', 'Canadian dollar', 'C$', 2),
(15, '[[regtime]]', '[[regtime]]', NULL, 0, 'MXN', 'Mexican peso', 'MX$', 2),
(16, '[[regtime]]', '[[regtime]]', NULL, 0, 'PEN', 'Peruvian Sol', 'S/', 2),
(17, '[[regtime]]', '[[regtime]]', NULL, 0, 'ARS', 'Argentinian Peso', '$', 2),
(18, '[[regtime]]', '[[regtime]]', NULL, 0, 'COP', 'Colombian Peso', '$', 2),
(19, '[[regtime]]', '[[regtime]]', NULL, 0, 'CLP', 'Chilean Peso', '$', 2),
(20, '[[regtime]]', '[[regtime]]', NULL, 0, 'IDR', 'Indonesian rupiah', 'Rp', 2),
(21, '[[regtime]]', '[[regtime]]', NULL, 0, 'AUD', 'Australian dollar', 'A$', 2),
(22, '[[regtime]]', '[[regtime]]', NULL, 0, 'NZD', 'New Zealand dollar', 'NZ$', 2),
(23, '[[regtime]]', '[[regtime]]', NULL, 0, 'EGP', 'Egyptian pound', 'E£', 2),
(24, '[[regtime]]', '[[regtime]]', NULL, 0, 'MAD', 'Moroccan dirham', 'DH', 2),
(25, '[[regtime]]', '[[regtime]]', NULL, 0, 'ZAR', 'South African rand', 'R', 2),
(26, '[[regtime]]', '[[regtime]]', NULL, 0, 'JPY', 'Japanese yen', '¥', 0),
(27, '[[regtime]]', '[[regtime]]', NULL, 0, 'CNY', 'Chinese yuan', '¥', 2),
(28, '[[regtime]]', '[[regtime]]', NULL, 0, 'KRW', 'South Korean won', '₩', 2),
(29, '[[regtime]]', '[[regtime]]', NULL, 0, 'RUB', 'Russian ruble', '₽', 2),
(30, '[[regtime]]', '[[regtime]]', NULL, 0, 'INR', 'Indian rupee', '₹', 2),
(31, '[[regtime]]', '[[regtime]]', NULL, 0, 'ILS', 'Israeli new shekel', '₪', 2),
(32, '[[regtime]]', '[[regtime]]', NULL, 0, 'CHF', 'Swiss franc', 'CHF', 2),
(33, '[[regtime]]', '[[regtime]]', NULL, 0, 'HRK', 'Croatian kuna', 'kn', 2),
(34, '[[regtime]]', '[[regtime]]', NULL, 0, 'HKD', 'Hong Kong dollar', 'HK$', 2),
(35, '[[regtime]]', '[[regtime]]', NULL, 0, 'CZK', 'Czech koruna', 'Kč', 2),
(36, '[[regtime]]', '[[regtime]]', NULL, 0, 'KZT', 'Kazakhstani tenge', '₸', 2),
(37, '[[regtime]]', '[[regtime]]', NULL, 0, 'SAR', 'Saudi Riyal', 'SAR', 2);

-- --------------------------------------------------------

--
-- Table structure for table `transaction_currency_user`
--

CREATE TABLE `transaction_currency_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `transaction_currency_id` int(10) unsigned NOT NULL,
  `user_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_combo` (`user_id`,`transaction_currency_id`),
  KEY `transaction_currency_user_transaction_currency_id_foreign` (`transaction_currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `transaction_currency_user_group`
--

CREATE TABLE `transaction_currency_user_group` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_group_id` bigint(20) unsigned NOT NULL,
  `transaction_currency_id` int(10) unsigned NOT NULL,
  `group_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_combo_ug` (`user_group_id`,`transaction_currency_id`),
  KEY `transaction_currency_user_group_transaction_currency_id_foreign` (`transaction_currency_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `transaction_currency_user_group`
--

INSERT INTO `transaction_currency_user_group` VALUES
(1, '[[regtime]]', '[[regtime]]', 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `transaction_groups`
--

CREATE TABLE `transaction_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_groups_user_id_index` (`user_id`),
  KEY `transaction_groups_user_group_id_index` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `transaction_journals`
--

CREATE TABLE `transaction_journals` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `transaction_type_id` int(10) unsigned NOT NULL,
  `transaction_group_id` int(10) unsigned DEFAULT NULL,
  `bill_id` int(10) unsigned DEFAULT NULL,
  `transaction_currency_id` int(10) unsigned DEFAULT NULL,
  `description` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` datetime NOT NULL,
  `date_tz` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `interest_date` date DEFAULT NULL,
  `book_date` date DEFAULT NULL,
  `process_date` date DEFAULT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `tag_count` int(10) unsigned NOT NULL,
  `encrypted` tinyint(1) NOT NULL DEFAULT '1',
  `completed` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `transaction_journals_user_id_index` (`user_id`),
  KEY `transaction_journals_user_group_id_index` (`user_group_id`),
  KEY `transaction_journals_date_index` (`date`),
  KEY `transaction_journals_transaction_group_id_index` (`transaction_group_id`),
  KEY `transaction_journals_transaction_type_id_index` (`transaction_type_id`),
  KEY `transaction_journals_transaction_currency_id_index` (`transaction_currency_id`),
  KEY `transaction_journals_bill_id_index` (`bill_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `transaction_types`
--

CREATE TABLE `transaction_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `transaction_types_type_unique` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `transaction_types`
--

INSERT INTO `transaction_types` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 'Deposit'),
(2, '[[regtime]]', '[[regtime]]', NULL, 'Invalid'),
(3, '[[regtime]]', '[[regtime]]', NULL, 'Liability credit'),
(4, '[[regtime]]', '[[regtime]]', NULL, 'Opening balance'),
(5, '[[regtime]]', '[[regtime]]', NULL, 'Reconciliation'),
(6, '[[regtime]]', '[[regtime]]', NULL, 'Transfer'),
(7, '[[regtime]]', '[[regtime]]', NULL, 'Withdrawal');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `objectguid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reset` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blocked` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `blocked_code` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mfa_secret` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_user_group_id` (`user_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, NULL, '[[regtime]]', '[[regtime]]', '[[admin_email]]', '[[admin_pass]]', NULL, NULL, 0, NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_groups`
--

CREATE TABLE `user_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_groups_title_unique` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_groups`
--

INSERT INTO `user_groups` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, '[[admin_email]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_roles`
--

CREATE TABLE `user_roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_roles_title_unique` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=22 ;

--
-- Dumping data for table `user_roles`
--

INSERT INTO `user_roles` VALUES
(1, '[[regtime]]', '[[regtime]]', NULL, 'ro'),
(2, '[[regtime]]', '[[regtime]]', NULL, 'mng_trx'),
(3, '[[regtime]]', '[[regtime]]', NULL, 'mng_meta'),
(4, '[[regtime]]', '[[regtime]]', NULL, 'read_budgets'),
(5, '[[regtime]]', '[[regtime]]', NULL, 'read_piggies'),
(6, '[[regtime]]', '[[regtime]]', NULL, 'read_subscriptions'),
(7, '[[regtime]]', '[[regtime]]', NULL, 'read_rules'),
(8, '[[regtime]]', '[[regtime]]', NULL, 'read_recurring'),
(9, '[[regtime]]', '[[regtime]]', NULL, 'read_webhooks'),
(10, '[[regtime]]', '[[regtime]]', NULL, 'read_currencies'),
(11, '[[regtime]]', '[[regtime]]', NULL, 'mng_budgets'),
(12, '[[regtime]]', '[[regtime]]', NULL, 'mng_piggies'),
(13, '[[regtime]]', '[[regtime]]', NULL, 'mng_subscriptions'),
(14, '[[regtime]]', '[[regtime]]', NULL, 'mng_rules'),
(15, '[[regtime]]', '[[regtime]]', NULL, 'mng_recurring'),
(16, '[[regtime]]', '[[regtime]]', NULL, 'mng_webhooks'),
(17, '[[regtime]]', '[[regtime]]', NULL, 'mng_currencies'),
(18, '[[regtime]]', '[[regtime]]', NULL, 'view_reports'),
(19, '[[regtime]]', '[[regtime]]', NULL, 'view_memberships'),
(20, '[[regtime]]', '[[regtime]]', NULL, 'full'),
(21, '[[regtime]]', '[[regtime]]', NULL, 'owner');

-- --------------------------------------------------------

--
-- Table structure for table `webhooks`
--

CREATE TABLE `webhooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_group_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `trigger` smallint(5) unsigned NOT NULL,
  `response` smallint(5) unsigned NOT NULL,
  `delivery` smallint(5) unsigned NOT NULL,
  `url` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `webhooks_user_id_foreign` (`user_id`),
  KEY `webhooks_title_index` (`title`),
  KEY `webhooks_secret_index` (`secret`),
  KEY `webhooks_to_ugi` (`user_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `webhook_attempts`
--

CREATE TABLE `webhook_attempts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `webhook_message_id` int(10) unsigned NOT NULL,
  `status_code` smallint(5) unsigned NOT NULL DEFAULT '0',
  `logs` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `webhook_attempts_webhook_message_id_foreign` (`webhook_message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `webhook_deliveries`
--

CREATE TABLE `webhook_deliveries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `key` smallint(5) unsigned NOT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `webhook_deliveries_key_title_unique` (`key`,`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `webhook_deliveries`
--

INSERT INTO `webhook_deliveries` VALUES
(1, '[[regtime]]', '[[regtime]]', 300, 'JSON');

-- --------------------------------------------------------

--
-- Table structure for table `webhook_messages`
--

CREATE TABLE `webhook_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `errored` tinyint(1) NOT NULL DEFAULT '0',
  `webhook_id` int(10) unsigned NOT NULL,
  `uuid` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `webhook_messages_webhook_id_foreign` (`webhook_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `webhook_responses`
--

CREATE TABLE `webhook_responses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `key` smallint(5) unsigned NOT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `webhook_responses_key_title_unique` (`key`,`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `webhook_responses`
--

INSERT INTO `webhook_responses` VALUES
(1, '[[regtime]]', '[[regtime]]', 200, 'TRANSACTIONS'),
(2, '[[regtime]]', '[[regtime]]', 210, 'ACCOUNTS'),
(3, '[[regtime]]', '[[regtime]]', 230, 'BUDGET'),
(4, '[[regtime]]', '[[regtime]]', 240, 'RELEVANT'),
(5, '[[regtime]]', '[[regtime]]', 220, 'NONE');

-- --------------------------------------------------------

--
-- Table structure for table `webhook_triggers`
--

CREATE TABLE `webhook_triggers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `key` smallint(5) unsigned NOT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `webhook_triggers_key_title_unique` (`key`,`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `webhook_triggers`
--

INSERT INTO `webhook_triggers` VALUES
(1, '[[regtime]]', '[[regtime]]', 50, 'ANY'),
(2, '[[regtime]]', '[[regtime]]', 100, 'STORE_TRANSACTION'),
(3, '[[regtime]]', '[[regtime]]', 110, 'UPDATE_TRANSACTION'),
(4, '[[regtime]]', '[[regtime]]', 120, 'DESTROY_TRANSACTION'),
(5, '[[regtime]]', '[[regtime]]', 200, 'STORE_BUDGET'),
(6, '[[regtime]]', '[[regtime]]', 210, 'UPDATE_BUDGET'),
(7, '[[regtime]]', '[[regtime]]', 220, 'DESTROY_BUDGET'),
(8, '[[regtime]]', '[[regtime]]', 230, 'STORE_UPDATE_BUDGET_LIMIT');

-- --------------------------------------------------------

--
-- Table structure for table `webhook_webhook_delivery`
--

CREATE TABLE `webhook_webhook_delivery` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `webhook_id` int(10) unsigned NOT NULL,
  `webhook_delivery_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `webhook_webhook_delivery_webhook_id_webhook_delivery_id_unique` (`webhook_id`,`webhook_delivery_id`),
  KEY `link_to_delivery` (`webhook_delivery_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `webhook_webhook_response`
--

CREATE TABLE `webhook_webhook_response` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `webhook_id` int(10) unsigned NOT NULL,
  `webhook_response_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `webhook_webhook_response_webhook_id_webhook_response_id_unique` (`webhook_id`,`webhook_response_id`),
  KEY `link_to_response` (`webhook_response_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `webhook_webhook_trigger`
--

CREATE TABLE `webhook_webhook_trigger` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `webhook_id` int(10) unsigned NOT NULL,
  `webhook_trigger_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `webhook_webhook_trigger_webhook_id_webhook_trigger_id_unique` (`webhook_id`,`webhook_trigger_id`),
  KEY `link_to_trigger` (`webhook_trigger_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `2fa_tokens`
--
ALTER TABLE `2fa_tokens`
  ADD CONSTRAINT `2fa_tokens_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `accounts`
--
ALTER TABLE `accounts`
  ADD CONSTRAINT `accounts_account_type_id_foreign` FOREIGN KEY (`account_type_id`) REFERENCES `account_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `accounts_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `accounts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `account_balances`
--
ALTER TABLE `account_balances`
  ADD CONSTRAINT `account_balances_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `account_balances_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `account_balances_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `account_meta`
--
ALTER TABLE `account_meta`
  ADD CONSTRAINT `account_meta_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `account_piggy_bank`
--
ALTER TABLE `account_piggy_bank`
  ADD CONSTRAINT `account_piggy_bank_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `account_piggy_bank_piggy_bank_id_foreign` FOREIGN KEY (`piggy_bank_id`) REFERENCES `piggy_banks` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `attachments`
--
ALTER TABLE `attachments`
  ADD CONSTRAINT `attachments_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `attachments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `auto_budgets`
--
ALTER TABLE `auto_budgets`
  ADD CONSTRAINT `auto_budgets_budget_id_foreign` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `auto_budgets_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `available_budgets`
--
ALTER TABLE `available_budgets`
  ADD CONSTRAINT `available_budgets_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `available_budgets_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `available_budgets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `bills`
--
ALTER TABLE `bills`
  ADD CONSTRAINT `bills_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `bills_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `bills_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `budgets`
--
ALTER TABLE `budgets`
  ADD CONSTRAINT `budgets_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `budgets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `budget_limits`
--
ALTER TABLE `budget_limits`
  ADD CONSTRAINT `budget_limits_budget_id_foreign` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `budget_limits_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `budget_transaction`
--
ALTER TABLE `budget_transaction`
  ADD CONSTRAINT `budget_transaction_budget_id_foreign` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `budget_transaction_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `budget_transaction_journal`
--
ALTER TABLE `budget_transaction_journal`
  ADD CONSTRAINT `budget_id_foreign` FOREIGN KEY (`budget_limit_id`) REFERENCES `budget_limits` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `budget_transaction_journal_budget_id_foreign` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `budget_transaction_journal_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `categories`
--
ALTER TABLE `categories`
  ADD CONSTRAINT `categories_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `categories_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `category_transaction`
--
ALTER TABLE `category_transaction`
  ADD CONSTRAINT `category_transaction_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `category_transaction_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `category_transaction_journal`
--
ALTER TABLE `category_transaction_journal`
  ADD CONSTRAINT `category_transaction_journal_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `category_transaction_journal_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `currency_exchange_rates`
--
ALTER TABLE `currency_exchange_rates`
  ADD CONSTRAINT `cer_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `currency_exchange_rates_from_currency_id_foreign` FOREIGN KEY (`from_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `currency_exchange_rates_to_currency_id_foreign` FOREIGN KEY (`to_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `currency_exchange_rates_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `group_journals`
--
ALTER TABLE `group_journals`
  ADD CONSTRAINT `group_journals_transaction_group_id_foreign` FOREIGN KEY (`transaction_group_id`) REFERENCES `transaction_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `group_journals_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `group_memberships`
--
ALTER TABLE `group_memberships`
  ADD CONSTRAINT `group_memberships_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `group_memberships_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `group_memberships_user_role_id_foreign` FOREIGN KEY (`user_role_id`) REFERENCES `user_roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `invited_users`
--
ALTER TABLE `invited_users`
  ADD CONSTRAINT `invited_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `journal_links`
--
ALTER TABLE `journal_links`
  ADD CONSTRAINT `journal_links_destination_id_foreign` FOREIGN KEY (`destination_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `journal_links_link_type_id_foreign` FOREIGN KEY (`link_type_id`) REFERENCES `link_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `journal_links_source_id_foreign` FOREIGN KEY (`source_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `journal_meta`
--
ALTER TABLE `journal_meta`
  ADD CONSTRAINT `journal_meta_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `object_groups`
--
ALTER TABLE `object_groups`
  ADD CONSTRAINT `object_groups_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `object_groups_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `period_statistics`
--
ALTER TABLE `period_statistics`
  ADD CONSTRAINT `period_statistics_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `period_statistics_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `permission_role`
--
ALTER TABLE `permission_role`
  ADD CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `piggy_banks`
--
ALTER TABLE `piggy_banks`
  ADD CONSTRAINT `piggy_banks_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `unique_currency` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `piggy_bank_events`
--
ALTER TABLE `piggy_bank_events`
  ADD CONSTRAINT `piggy_bank_events_piggy_bank_id_foreign` FOREIGN KEY (`piggy_bank_id`) REFERENCES `piggy_banks` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `piggy_bank_events_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `piggy_bank_repetitions`
--
ALTER TABLE `piggy_bank_repetitions`
  ADD CONSTRAINT `piggy_bank_repetitions_piggy_bank_id_foreign` FOREIGN KEY (`piggy_bank_id`) REFERENCES `piggy_banks` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `preferences`
--
ALTER TABLE `preferences`
  ADD CONSTRAINT `preferences_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `preferences_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `recurrences`
--
ALTER TABLE `recurrences`
  ADD CONSTRAINT `recurrences_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `recurrences_transaction_type_id_foreign` FOREIGN KEY (`transaction_type_id`) REFERENCES `transaction_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `recurrences_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `recurrences_meta`
--
ALTER TABLE `recurrences_meta`
  ADD CONSTRAINT `recurrences_meta_recurrence_id_foreign` FOREIGN KEY (`recurrence_id`) REFERENCES `recurrences` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `recurrences_repetitions`
--
ALTER TABLE `recurrences_repetitions`
  ADD CONSTRAINT `recurrences_repetitions_recurrence_id_foreign` FOREIGN KEY (`recurrence_id`) REFERENCES `recurrences` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `recurrences_transactions`
--
ALTER TABLE `recurrences_transactions`
  ADD CONSTRAINT `recurrences_transactions_destination_id_foreign` FOREIGN KEY (`destination_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `recurrences_transactions_foreign_currency_id_foreign` FOREIGN KEY (`foreign_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `recurrences_transactions_recurrence_id_foreign` FOREIGN KEY (`recurrence_id`) REFERENCES `recurrences` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `recurrences_transactions_source_id_foreign` FOREIGN KEY (`source_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `recurrences_transactions_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `type_foreign` FOREIGN KEY (`transaction_type_id`) REFERENCES `transaction_types` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `role_user`
--
ALTER TABLE `role_user`
  ADD CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `role_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `rt_meta`
--
ALTER TABLE `rt_meta`
  ADD CONSTRAINT `rt_meta_rt_id_foreign` FOREIGN KEY (`rt_id`) REFERENCES `recurrences_transactions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rules`
--
ALTER TABLE `rules`
  ADD CONSTRAINT `rules_rule_group_id_foreign` FOREIGN KEY (`rule_group_id`) REFERENCES `rule_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rules_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `rules_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rule_actions`
--
ALTER TABLE `rule_actions`
  ADD CONSTRAINT `rule_actions_rule_id_foreign` FOREIGN KEY (`rule_id`) REFERENCES `rules` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rule_groups`
--
ALTER TABLE `rule_groups`
  ADD CONSTRAINT `rule_groups_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `rule_groups_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rule_triggers`
--
ALTER TABLE `rule_triggers`
  ADD CONSTRAINT `rule_triggers_rule_id_foreign` FOREIGN KEY (`rule_id`) REFERENCES `rules` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tags`
--
ALTER TABLE `tags`
  ADD CONSTRAINT `tags_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `tags_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tag_transaction_journal`
--
ALTER TABLE `tag_transaction_journal`
  ADD CONSTRAINT `tag_transaction_journal_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `tag_transaction_journal_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `transactions`
--
ALTER TABLE `transactions`
  ADD CONSTRAINT `transactions_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `transactions_foreign_currency_id_foreign` FOREIGN KEY (`foreign_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `transactions_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `transactions_transaction_journal_id_foreign` FOREIGN KEY (`transaction_journal_id`) REFERENCES `transaction_journals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `transaction_currency_user`
--
ALTER TABLE `transaction_currency_user`
  ADD CONSTRAINT `transaction_currency_user_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `transaction_currency_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `transaction_currency_user_group`
--
ALTER TABLE `transaction_currency_user_group`
  ADD CONSTRAINT `transaction_currency_user_group_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `transaction_currency_user_group_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `transaction_groups`
--
ALTER TABLE `transaction_groups`
  ADD CONSTRAINT `transaction_groups_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `transaction_groups_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `transaction_journals`
--
ALTER TABLE `transaction_journals`
  ADD CONSTRAINT `transaction_journals_bill_id_foreign` FOREIGN KEY (`bill_id`) REFERENCES `bills` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `transaction_journals_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `transaction_journals_transaction_currency_id_foreign` FOREIGN KEY (`transaction_currency_id`) REFERENCES `transaction_currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `transaction_journals_transaction_group_id_foreign` FOREIGN KEY (`transaction_group_id`) REFERENCES `transaction_groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `transaction_journals_transaction_type_id_foreign` FOREIGN KEY (`transaction_type_id`) REFERENCES `transaction_types` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `transaction_journals_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `type_user_group_id` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `webhooks`
--
ALTER TABLE `webhooks`
  ADD CONSTRAINT `webhooks_to_ugi` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `webhooks_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `webhook_attempts`
--
ALTER TABLE `webhook_attempts`
  ADD CONSTRAINT `webhook_attempts_webhook_message_id_foreign` FOREIGN KEY (`webhook_message_id`) REFERENCES `webhook_messages` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `webhook_messages`
--
ALTER TABLE `webhook_messages`
  ADD CONSTRAINT `webhook_messages_webhook_id_foreign` FOREIGN KEY (`webhook_id`) REFERENCES `webhooks` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `webhook_webhook_delivery`
--
ALTER TABLE `webhook_webhook_delivery`
  ADD CONSTRAINT `link_to_delivery` FOREIGN KEY (`webhook_delivery_id`) REFERENCES `webhook_deliveries` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `webhook_webhook_delivery_webhook_id_foreign` FOREIGN KEY (`webhook_id`) REFERENCES `webhooks` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `webhook_webhook_response`
--
ALTER TABLE `webhook_webhook_response`
  ADD CONSTRAINT `link_to_response` FOREIGN KEY (`webhook_response_id`) REFERENCES `webhook_responses` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `webhook_webhook_response_webhook_id_foreign` FOREIGN KEY (`webhook_id`) REFERENCES `webhooks` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `webhook_webhook_trigger`
--
ALTER TABLE `webhook_webhook_trigger`
  ADD CONSTRAINT `link_to_trigger` FOREIGN KEY (`webhook_trigger_id`) REFERENCES `webhook_triggers` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `webhook_webhook_trigger_webhook_id_foreign` FOREIGN KEY (`webhook_id`) REFERENCES `webhooks` (`id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
