<?php

/**
 * config.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    'html_language'            => 'zh-tw',
    'locale'                   => 'zh_TW, Chinese Traditional (Taiwan), zh_TW.utf8, zh_TW.UTF-8',
    // 'month'                   => '%B %Y',
    'month_js'                 => 'MMMM YYYY',

    // 'month_and_day'           => '%B %e, %Y',
    'month_and_day_moment_js'  => 'YYYY 年 MMM D 日',
    'month_and_day_fns'        => 'yyyy年 M月 d日',
    'month_and_day_js'         => 'MMMM Do, YYYY',

    // 'month_and_date_day'      => '%A %B %e, %Y',
    'month_and_date_day_js'    => 'YYYY年 M月 D日 dddd',

    // 'month_and_day_no_year'   => '%B %e',
    'month_and_day_no_year_js' => 'M月 D日',



    // 'date_time'               => '%B %e, %Y, @ %T',
    'date_time_js'             => 'MMMM Do, YYYY, @ HH:mm:ss',
    'date_time_fns'            => 'yyyy年 M月 d日 於 HH:mm:ss',
    'date_time_fns_short'      => 'MMMM do, yyyy @ HH:mm',

    // 'specific_day'            => '%e %B %Y',
    'specific_day_js'          => 'D MMMM YYYY',

    // 'week_in_year'            => 'Week %V, %G',
    'week_in_year_js'          => 'GGGG年 第W週',
    'week_in_year_fns'         => "'週' w，yyyy",

    // 'year'                    => '%Y',
    'year_js'                  => 'YYYY',

    // 'half_year'               => '%B %Y',
    'half_year_js'             => '\QQ YYYY',

    'quarter_fns'              => "yyyy'年 第'Q'季度'",
    'half_year_fns'            => "'H{half}', yyyy",
    'dow_1'                    => '週一',
    'dow_2'                    => '週二',
    'dow_3'                    => '週三',
    'dow_4'                    => '週四',
    'dow_5'                    => '週五',
    'dow_6'                    => '週六',
    'dow_7'                    => '週日',
];
