<?php
/**
 * Redis info
 */
$servers = elgg_get_config('redis_servers');
if (!elgg_get_config('redis') || empty($servers) || !\Elgg\Cache\CompositeCache::isRedisAvailable()) {
	echo '<p>' . elgg_echo('admin:server:redis:inactive') . '</p>';

	return;
}

$redis = new Redis();

foreach ($servers as $server) {
	$redis->connect($server['host'], $server['port']);
}

$password = elgg_extract('password', elgg_get_config('redis_options'));
if (!empty($password)) {
	$redis->auth($password);
}

$stats = $redis->info();

$rows = [];

foreach ($stats as $key => $value) {
	$row = [];
	$row[] = elgg_format_element('td', [], elgg_format_element('b', [], $key . ':'));
	$row[] = elgg_format_element('td', [], $value);

	$rows[] = elgg_format_element('tr', [], implode(PHP_EOL, $row));
}

echo elgg_format_element('table', ['class' => 'elgg-table-alt'], implode(PHP_EOL, $rows));
