<?php
/**
 * Display information about who deleted a given entity
 *
 * @uses $vars['entity']     the entity to show information for
 * @uses $vars['actor']      actor information, if not set will be generated by the system
 * @uses $vars['actor_icon'] actor imprint icon (default: 'user')
 */

$actor_text = elgg_extract('actor', $vars);
if (!isset($actor_text)) {
	$entity = elgg_extract('entity', $vars);
	if ($entity instanceof \ElggEntity) {
		$actors = $entity->getEntitiesFromRelationship([
			'type' => 'user',
			'relationship' => 'deleted_by',
			'limit' => 1,
		]);
		if (!empty($actors)) {
			/* @var $actor \ElggUser */
			$actor = $actors[0];
			
			if (!$actor->isDeleted()) {
				$actor_text = elgg_view_entity_url($actor);
			} else {
				$actor_text = $actor->getDisplayName();
			}
			
			$actor_text = elgg_echo('trash:imprint:actor', [$actor_text]);
		}
	}
}

if (elgg_is_empty($actor_text)) {
	return;
}

echo elgg_view('trash/elements/imprint/element', [
	'icon_name' => elgg_extract('actor_icon', $vars, 'user'),
	'content' => $actor_text,
	'class' => 'elgg-listing-actor',
]);
