<?php
/**
 * This source file is part of the open source project
 * ExpressionEngine (https://expressionengine.com)
 *
 * @link      https://expressionengine.com/
 * @copyright Copyright (c) 2003-2023, Packet Tide, LLC (https://www.packettide.com)
 * @license   https://expressionengine.com/license Licensed under Apache License, Version 2.0
 */

/**
 * HTML Form Attributes
 *
 * Valid HTML attributes that might be specified in a FORM tag
 * (https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form) plus
 * HTML Global Attributes
 * (https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes) and
 * the ARIA Search role attribute
 * (https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/Search_role).
 * The list last updated on 5 june 2020
 *
 * This list does not include data-* or aria-* as these are wildcards and
 * need to be handled differently in the code.
 *
 */
return array(
    'accept',
    'accept-charset',
    'accesskey',
    'autocapitalize',
    'autocomplete',
    'contenteditable',
    'contextmenu',
    'dir',
    'draggable',
    'dropzone',
    'exportparts',
    'hidden',
    'inputmode',
    'is',
    'itemid',
    'itemprop',
    'itemref',
    'itemscope',
    'itemtype',
    'lang',
    'method',
    'novalidate',
    'onabort',
    'onautocomplete',
    'onautocompleteerror',
    'onblur',
    'oncancel',
    'oncanplay',
    'oncanplaythrough',
    'onchange',
    'onclick',
    'onclose',
    'oncontextmenu',
    'oncuechange',
    'ondblclick',
    'ondrag',
    'ondragend',
    'ondragenter',
    'ondragexit',
    'ondragleave',
    'ondragover',
    'ondragstart',
    'ondrop',
    'ondurationchange',
    'onemptied',
    'onended',
    'onerror',
    'onfocus',
    'oninput',
    'oninvalid',
    'onkeydown',
    'onkeypress',
    'onkeyup',
    'onload',
    'onloadeddata',
    'onloadedmetadata',
    'onloadstart',
    'onmousedown',
    'onmouseenter',
    'onmouseleave',
    'onmousemove',
    'onmouseout',
    'onmouseover',
    'onmouseup',
    'onmousewheel',
    'onpause',
    'onplay',
    'onplaying',
    'onprogress',
    'onratechange',
    'onreset',
    'onresize',
    'onscroll',
    'onseeked',
    'onseeking',
    'onselect',
    'onshow',
    'onsort',
    'onstalled',
    'onsubmit',
    'onsuspend',
    'ontimeupdate',
    'ontoggle',
    'onvolumechange',
    'onwaiting',
    'part',
    'rel',
    'slot',
    'spellcheck',
    'style',
    'tabindex',
    'target',
    'title',
    'translate',
    'role'
);

// EOF
