
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `drupalcms128`
--
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]autosave_form_entity_form`
--

CREATE TABLE `[[dbprefix]]autosave_form_entity_form` (
  `form_id` varchar(512) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `form_session_id` varchar(512) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `entity_type_id` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `entity_id` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `uid` int NOT NULL,
  `timestamp` int NOT NULL,
  `entity` longblob NOT NULL,
  `form_state` longblob NOT NULL,
  PRIMARY KEY (`form_id`,`form_session_id`,`entity_type_id`,`entity_id`,`langcode`,`uid`,`timestamp`),
  KEY `entity_type_id__entity_id` (`entity_type_id`,`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Saves the form state of partially filled content entity…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]batch`
--

CREATE TABLE `[[dbprefix]]batch` (
  `bid` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'A string token generated against the current user''s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Stores details about batches (processes that run in…' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cachetags`
--

CREATE TABLE `[[dbprefix]]cachetags` (
  `tag` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Namespace-prefixed tag string.',
  `invalidations` int NOT NULL DEFAULT '0' COMMENT 'Number incremented when the tag is invalidated.',
  PRIMARY KEY (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Cache table for tracking cache tag invalidations.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_bootstrap`
--

CREATE TABLE `[[dbprefix]]cache_bootstrap` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_bootstrap`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_config`
--

CREATE TABLE `[[dbprefix]]cache_config` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_config`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_container`
--

CREATE TABLE `[[dbprefix]]cache_container` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_container`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_data`
--

CREATE TABLE `[[dbprefix]]cache_data` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_data`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_default`
--

CREATE TABLE `[[dbprefix]]cache_default` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_default`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_discovery`
--

CREATE TABLE `[[dbprefix]]cache_discovery` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_discovery`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity`
--

CREATE TABLE `[[dbprefix]]cache_entity` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_entity`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_menu`
--

CREATE TABLE `[[dbprefix]]cache_menu` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_menu`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_render`
--

CREATE TABLE `[[dbprefix]]cache_render` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_render`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]captcha_sessions`
--

CREATE TABLE `[[dbprefix]]captcha_sessions` (
  `csid` int NOT NULL AUTO_INCREMENT COMMENT 'CAPTCHA session ID.',
  `token` varchar(64) DEFAULT NULL COMMENT 'One time CAPTCHA token.',
  `uid` int NOT NULL DEFAULT '0' COMMENT 'User''s "[[dbprefix]]users".uid.',
  `sid` varchar(64) NOT NULL DEFAULT '' COMMENT 'Session ID of the user.',
  `ip_address` varchar(128) DEFAULT NULL COMMENT 'IP address of the visitor.',
  `timestamp` int NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the challenge was generated.',
  `form_id` varchar(128) NOT NULL COMMENT 'The form_id of the form where the CAPTCHA is added to.',
  `solution` varchar(128) NOT NULL DEFAULT '' COMMENT 'Solution of the challenge.',
  `status` int NOT NULL DEFAULT '0' COMMENT 'Status of the CAPTCHA session (unsolved, solved, ...)',
  `attempts` int NOT NULL DEFAULT '0' COMMENT 'The number of attempts.',
  PRIMARY KEY (`csid`),
  KEY `csid_ip` (`csid`,`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Stores the data about CAPTCHA sessions (solution, IP…' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `collection` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object collection.',
  `name` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object name.',
  `data` longblob COMMENT 'A serialized configuration object data.',
  PRIMARY KEY (`collection`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for configuration data.';

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('', 'announcements_feed.settings', 'a:3:{s:7:"max_age";i:86400;s:13:"cron_interval";i:21600;s:5:"limit";i:2;}'),
('', 'automated_cron.settings', 'a:1:{s:8:"interval";i:10800;}'),
('', 'automatic_updates.settings', 'a:3:{s:10:"unattended";a:2:{s:6:"method";s:3:"web";s:5:"level";s:7:"disable";}s:24:"allow_core_minor_updates";b:1;s:17:"status_check_mail";s:11:"errors_only";}'),
('', 'autosave_form.messages', 'a:2:{s:40:"entity_saved_in_background_alert_message";s:198:"The content has been modified elsewhere. As a result, autosaving has been disabled and autosaved states for the current page have been deleted. Autosave will be reactivated after reloading the page.";s:8:"langcode";s:2:"en";}'),
('', 'autosave_form.settings', 'a:7:{s:8:"langcode";s:2:"en";s:8:"interval";i:60000;s:19:"only_on_form_change";b:0;s:9:"active_on";a:2:{s:20:"content_entity_forms";b:1;s:19:"config_entity_forms";b:0;}s:12:"notification";a:3:{s:6:"active";b:1;s:7:"message";s:15:"Saving draft...";s:5:"delay";i:1000;}s:28:"allowed_content_entity_types";a:1:{s:4:"node";a:1:{s:7:"bundles";a:0:{}}}s:11:"allowed_new";b:1;}'),
('', 'block.block.claro_breadcrumbs', 'a:13:{s:4:"uuid";s:36:"6df3916e-1743-4b48-ba77-157bba53cd9f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A";}s:2:"id";s:17:"claro_breadcrumbs";s:5:"theme";s:5:"claro";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_content', 'a:13:{s:4:"uuid";s:36:"f2dd4a9b-6139-44d0-8794-3d15fdab279a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0";}s:2:"id";s:13:"claro_content";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_local_actions', 'a:13:{s:4:"uuid";s:36:"0abe34e5-4686-43aa-8418-715988d1219e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0";}s:2:"id";s:19:"claro_local_actions";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_messages', 'a:13:{s:4:"uuid";s:36:"0948c16b-f770-4441-a83b-30701df53a71";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg";}s:2:"id";s:14:"claro_messages";s:5:"theme";s:5:"claro";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_page_title', 'a:13:{s:4:"uuid";s:36:"8d906e75-e67f-4605-a804-9196cf5c584f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs";}s:2:"id";s:16:"claro_page_title";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_primary_local_tasks', 'a:13:{s:4:"uuid";s:36:"5619940e-55b4-43d2-9339-a57d0cf2ad82";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw";}s:2:"id";s:25:"claro_primary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_secondary_local_tasks', 'a:13:{s:4:"uuid";s:36:"9815bff3-c1ad-4ae6-9ce5-7525495af502";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4";}s:2:"id";s:27:"claro_secondary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_account_menu', 'a:13:{s:4:"uuid";s:36:"b716aced-ef8c-422c-a87e-dc0efb48af65";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DxdLrNHPG9b5uQwKs4BJ9R5e8_jtJsQDY8rqliXtd9w";}s:2:"id";s:31:"drupal_cms_olivero_account_menu";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_breadcrumbs', 'a:13:{s:4:"uuid";s:36:"30e0895b-6cde-47b4-a017-d3ad832f1bd2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rUKMsaj4XvIHtU3kRiHIA6Rkn4IHzCkhTiUZudMkp14";}s:2:"id";s:30:"drupal_cms_olivero_breadcrumbs";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_content', 'a:13:{s:4:"uuid";s:36:"6fa7baee-647b-4692-b6ae-a71a539aa2e4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"G4iNGvy_k2yNIEH_FJmbkvgBBar1etJIhKJYuygT7hU";}s:2:"id";s:26:"drupal_cms_olivero_content";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_footer_menu', 'a:13:{s:4:"uuid";s:36:"77edf79c-3893-4a51-9dd3-10ddd9ae1500";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:18:"system.menu.footer";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WTl3U7fRuBpyEu0aKhp32saPddKEZ5zYKbbrfPJ2CMw";}s:2:"id";s:30:"drupal_cms_olivero_footer_menu";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:10:"footer_top";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:24:"system_menu_block:footer";s:8:"settings";a:7:{s:2:"id";s:24:"system_menu_block:footer";s:5:"label";s:6:"Footer";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_main_menu', 'a:13:{s:4:"uuid";s:36:"685ea8bf-2ab0-4dac-94a3-de42fc9abf1f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IYx37JlV-JCEqldSOUCsYu6gh4RpwuLDPpoeQcEF7mk";}s:2:"id";s:28:"drupal_cms_olivero_main_menu";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:2;s:16:"expand_all_items";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_messages', 'a:13:{s:4:"uuid";s:36:"e02bd630-20ba-403d-8d5c-a4f783fd37a2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5ra2HNIksWbp6AhPpTufTGSlgx2FR7RR_ssxdjgFg4I";}s:2:"id";s:27:"drupal_cms_olivero_messages";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_page_title', 'a:13:{s:4:"uuid";s:36:"9999d3bc-b49f-47dd-a5d3-bccf411a4867";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dY7_Wihz9ohfBPKP554_brUfc9nPaecShShmC_VTGRM";}s:2:"id";s:29:"drupal_cms_olivero_page_title";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_powered', 'a:13:{s:4:"uuid";s:36:"95903753-51f7-4312-a0a8-fa908d0a29ac";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VBXsyvJSTQNtrh86WK8GN_FCaRtK03D1fjfZQnUvtU";}s:2:"id";s:26:"drupal_cms_olivero_powered";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:13:"footer_bottom";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_primary_admin_actions', 'a:13:{s:4:"uuid";s:36:"e7251eac-6e1d-4ee4-8e48-7db3f76bc992";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bXIY_bcTLD1-0gwNQhWPHANNy6hQa_RxJgvHxKhNS2E";}s:2:"id";s:40:"drupal_cms_olivero_primary_admin_actions";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_primary_local_tasks', 'a:13:{s:4:"uuid";s:36:"d978c2a1-467b-487d-bf01-4b73f335415f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"A_KsAw1fyIvdBubmxkvtCtoSuV62cVV-p0RSPnvqc9U";}s:2:"id";s:38:"drupal_cms_olivero_primary_local_tasks";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_secondary_local_tasks', 'a:13:{s:4:"uuid";s:36:"c94cc6a0-f46b-43c4-aa44-86ef63e661c2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3KAyDgB3FHENrBwroAUcCPvkfPHBMFcRDnsZFyFMuwc";}s:2:"id";s:40:"drupal_cms_olivero_secondary_local_tasks";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-2;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.drupal_cms_olivero_site_branding', 'a:13:{s:4:"uuid";s:36:"e10a6894-6b83-4c53-bd88-a6dbccb6b7d9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:18:"drupal_cms_olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MX2iS2rMC2lQ-sUFnOKksJ01S2lh0j5-80hKkdDmHkI";}s:2:"id";s:32:"drupal_cms_olivero_site_branding";s:5:"theme";s:18:"drupal_cms_olivero";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.gin_breadcrumbs', 'a:13:{s:4:"uuid";s:36:"af93c590-9d18-47b1-995d-d57b1be6568a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:3:"gin";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"y9X3xgCsO59pQyzNLzY1D3SDJJxCHILLWkpPnmuTJ2E";}s:2:"id";s:15:"gin_breadcrumbs";s:5:"theme";s:3:"gin";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.gin_content', 'a:13:{s:4:"uuid";s:36:"16216338-b4f2-4a3b-83ca-d91160afe106";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:3:"gin";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hBHXB7hC05XU7pDYzETt-GUcpFlogK1gkjyAsg0Ym58";}s:2:"id";s:11:"gin_content";s:5:"theme";s:3:"gin";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.gin_local_actions', 'a:13:{s:4:"uuid";s:36:"2be996fd-aed9-4d07-9813-c222a3f770dc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:3:"gin";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OQ9aJ-4qVwK1x00o9EOYK4eFDjQr_HLpbPiJaPSVZiQ";}s:2:"id";s:17:"gin_local_actions";s:5:"theme";s:3:"gin";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.gin_messages', 'a:13:{s:4:"uuid";s:36:"b0040475-87e4-4ef6-b95e-31bdee867455";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:3:"gin";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WvPhI8OwllG0gE69-F8qL3ai3nd5SbYD6JpmEuZcyok";}s:2:"id";s:12:"gin_messages";s:5:"theme";s:3:"gin";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.gin_page_title', 'a:13:{s:4:"uuid";s:36:"784cb964-2348-426e-8f0a-e08db56c8b7d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:3:"gin";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HLQY2xgby8K3vN_98hiOSasOhm9pdCsH234-s0duJ8Q";}s:2:"id";s:14:"gin_page_title";s:5:"theme";s:3:"gin";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.gin_primary_local_tasks', 'a:13:{s:4:"uuid";s:36:"3a1b386e-a7bc-4f77-9a74-92f920d2e0cd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:3:"gin";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Hh01DLj9k7UnNdPpOQXHZHW7GHf2OPNDQyCJF7_R9ac";}s:2:"id";s:23:"gin_primary_local_tasks";s:5:"theme";s:3:"gin";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.gin_secondary_local_tasks', 'a:13:{s:4:"uuid";s:36:"e0cd2708-7262-4266-9710-a79c47a8912c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:3:"gin";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCWhood0xXFQYqxFgL1spXdb9KeIuXH1YvTdjIEedDg";}s:2:"id";s:25:"gin_secondary_local_tasks";s:5:"theme";s:3:"gin";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_footer', 'a:13:{s:4:"uuid";s:36:"8ebd595c-60ac-4c81-ab68-2a4ac773461b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:18:"system.menu.footer";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpqwoXCSO_zinj94pb7fNZl6CLdO8Z8mQzNDIkLe--c";}s:2:"id";s:14:"olivero_footer";s:5:"theme";s:7:"olivero";s:6:"region";s:10:"footer_top";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:24:"system_menu_block:footer";s:8:"settings";a:7:{s:2:"id";s:24:"system_menu_block:footer";s:5:"label";s:6:"Footer";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";N;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),
('', 'captcha.settings', 'a:14:{s:8:"langcode";s:2:"en";s:15:"enable_globally";i:0;s:31:"enable_globally_on_admin_routes";b:0;s:17:"default_challenge";s:31:"friendlycaptcha/friendlycaptcha";s:11:"description";s:110:"This question is for testing whether or not you are a human visitor and to prevent automated spam submissions.";s:5:"title";s:7:"CAPTCHA";s:19:"administration_mode";b:0;s:35:"administration_mode_on_admin_routes";b:0;s:13:"whitelist_ips";s:0:"";s:30:"wrong_captcha_response_message";s:55:"The answer you entered for the CAPTCHA was not correct.";s:18:"default_validation";i:1;s:11:"persistence";i:1;s:12:"enable_stats";b:0;s:19:"log_wrong_responses";b:0;}'),
('', 'coffee.configuration', 'a:2:{s:12:"coffee_menus";a:1:{s:5:"admin";s:5:"admin";}s:11:"max_results";i:7;}'),
('', 'core.date_format.fallback', 'a:9:{s:4:"uuid";s:36:"aa92fa03-6df5-49a6-8e07-c28cf75016b1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iIBLu1j9n6Oo5PW-wpu5gdyNs9Kvv4LMRqtQUdJjRz8";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, j M Y - H:i";}'),
('', 'core.date_format.html_date', 'a:9:{s:4:"uuid";s:36:"46b6a58e-fa40-4f21-9053-531b9cd1de2b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}'),
('', 'core.date_format.html_datetime', 'a:9:{s:4:"uuid";s:36:"8cb753fc-42e4-47fb-8c7b-1dac9e1995d9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\\TH:i:sO";}'),
('', 'core.date_format.html_month', 'a:9:{s:4:"uuid";s:36:"8bb65156-8355-489c-be01-67eeb04e6fb9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}'),
('', 'core.date_format.html_time', 'a:9:{s:4:"uuid";s:36:"3926d3dc-9ba5-402b-aa7a-c3ac8647ccfc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}'),
('', 'core.date_format.html_week', 'a:9:{s:4:"uuid";s:36:"b548137d-6c48-4726-97ed-2a45ea184a84";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\\WW";}'),
('', 'core.date_format.html_year', 'a:9:{s:4:"uuid";s:36:"83e05f2b-31a2-45a2-9fc7-377e061a9258";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}'),
('', 'core.date_format.html_yearless_date', 'a:9:{s:4:"uuid";s:36:"9e732fea-6de7-46a9-962a-879f9755bd8c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}'),
('', 'core.date_format.long', 'a:9:{s:4:"uuid";s:36:"c8d08f8c-1d75-48ce-9ed7-9aa2f56ad64a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5B4_r5Vd0_9UaJwtAC5yFCm9-k8NNvp1xiQNhFFkknU";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:14:"l, j F Y - H:i";}'),
('', 'core.date_format.medium', 'a:9:{s:4:"uuid";s:36:"2d16c3b4-2274-468c-b38a-1082d7f0cd33";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"q7pDV2d9qFh1IVqvymOxUUYGSziZDeg961wURC0cSLs";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, j M Y - H:i";}'),
('', 'core.date_format.olivero_medium', 'a:9:{s:4:"uuid";s:36:"7fde1793-69df-4340-a15a-8a827b0001dc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z7ynTCss9wwEi8ojENJ08qx44RN6leI-tqoN2o5QzdE";}s:2:"id";s:14:"olivero_medium";s:5:"label";s:14:"Olivero Medium";s:6:"locked";b:0;s:7:"pattern";s:5:"j F Y";}'),
('', 'core.date_format.short', 'a:9:{s:4:"uuid";s:36:"46e0a274-4797-415e-b0bb-de5e0da037be";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SAeixlV7Djy_Ggv_1P95TiqD4KUihA5icvU521tA84Y";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"j M Y - H:i";}'),
('', 'core.entity_form_display.easy_email.user_created_approval_admin.default', 'a:11:{s:4:"uuid";s:36:"aaffe547-a18a-4698-8171-ece7f25cda09";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:54:"easy_email.easy_email_type.user_created_approval_admin";i:1;s:69:"field.field.easy_email.user_created_approval_admin.field_related_user";}s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OHtFXYg43YlhqKZii0A27uM9V19Xsa3EmlyK3WmtXAo";}s:2:"id";s:46:"easy_email.user_created_approval_admin.default";s:16:"targetEntityType";s:10:"easy_email";s:6:"bundle";s:27:"user_created_approval_admin";s:4:"mode";s:7:"default";s:7:"content";a:17:{s:10:"attachment";a:5:{s:4:"type";s:12:"file_generic";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}s:20:"third_party_settings";a:0:{}}s:15:"attachment_path";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:11:"bcc_address";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"bcc_uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:9:"body_html";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:10:"body_plain";a:5:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:10:"cc_address";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:6:"cc_uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:11:"creator_uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:18:"field_related_user";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:26;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:12:"from_address";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:9:"from_name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:13:"inbox_preview";a:5:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:17:"recipient_address";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:13:"recipient_uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:8:"reply_to";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:2:{s:3:"key";b:1;s:5:"label";b:1;}}'),
('', 'core.entity_form_display.media.document.default', 'a:11:{s:4:"uuid";s:36:"4c66b6cf-79ef-48d6-b822-a97ec5c42b83";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:47:"field.field.media.document.field_media_document";i:1;s:19:"media.type.document";}s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"path";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j3PwHXJrIDYYTMBtwbGTChh6m3fzbh9KJyHZ4wJdb1U";}s:2:"id";s:22:"media.document.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:7:"default";s:7:"content";a:6:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:20:"field_media_document";a:5:{s:4:"type";s:12:"file_generic";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}s:20:"third_party_settings";a:0:{}}s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:4:{s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.media.document.media_library', 'a:11:{s:4:"uuid";s:36:"2c5d8b1d-7e28-4c4b-bf51-8d82cbcfbc5a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:47:"field.field.media.document.field_media_document";i:2;s:19:"media.type.document";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dcpfpqyLXOSGpulacMAJW3H-G34_LeNsjdfxd1_oCfY";}s:2:"id";s:28:"media.document.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:9:{s:7:"created";b:1;s:20:"field_media_document";b:1;s:4:"path";b:1;s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:6:"status";b:1;s:3:"uid";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.media.image.default', 'a:11:{s:4:"uuid";s:36:"4844845f-595e-4d69-bc4b-521430befa84";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:41:"field.field.media.image.field_media_image";i:1;s:25:"image.style.media_library";i:2;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N2Imq6kLhAPzzFt_VZQCkWItt-UfqPOkcQlyC-3yTgM";}s:2:"id";s:19:"media.image.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:17:"field_media_image";a:5:{s:4:"type";s:17:"image_focal_point";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:13:"media_library";s:12:"preview_link";b:1;s:7:"offsets";s:5:"50,50";}s:20:"third_party_settings";a:0:{}}s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:7:{s:7:"created";b:1;s:4:"path";b:1;s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:3:"uid";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.media.image.media_library', 'a:11:{s:4:"uuid";s:36:"13e34c1f-e2bb-4a6a-90f6-cc8aa2daa67b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:25:"image.style.media_library";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BMLrK4zKp8-FFnMseBdT_6h6YipUsKRfbDf_3WUB5HA";}s:2:"id";s:25:"media.image.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:13:"media_library";s:7:"content";a:2:{s:17:"field_media_image";a:5:{s:4:"type";s:17:"image_focal_point";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:13:"media_library";s:12:"preview_link";b:1;s:7:"offsets";s:5:"50,50";}s:20:"third_party_settings";a:0:{}}s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:8:{s:7:"created";b:1;s:4:"path";b:1;s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:6:"status";b:1;s:3:"uid";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.media.remote_video.default', 'a:11:{s:4:"uuid";s:36:"2d8d238c-1394-4abe-8ab4-e985a9774fdf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:55:"field.field.media.remote_video.field_media_oembed_video";i:1;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pM8mGlwfpvfG_y5tZn0lGAXFLXz2_yKkL7MvWZsRqdA";}s:2:"id";s:26:"media.remote_video.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:24:"field_media_oembed_video";a:5:{s:4:"type";s:16:"oembed_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:7:{s:7:"created";b:1;s:4:"path";b:1;s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:3:"uid";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.media.remote_video.media_library', 'a:11:{s:4:"uuid";s:36:"5fecaf3e-ba52-4138-ad3d-b138ab3bbf42";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:23:"media.type.remote_video";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TBgPW-uaXRaICBwLaVc16rXpRiLSknDIdF9q0XL7qso";}s:2:"id";s:32:"media.remote_video.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:9:{s:7:"created";b:1;s:24:"field_media_oembed_video";b:1;s:4:"path";b:1;s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:6:"status";b:1;s:3:"uid";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.media.svg_image.default', 'a:11:{s:4:"uuid";s:36:"dcf1a9d4-210e-444c-9dff-ad7b655b9a4f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:49:"field.field.media.svg_image.field_media_svg_image";i:1;s:21:"image.style.thumbnail";i:2;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JLgK8EtXsFEkXMebLDxNafl20wBLb0-O-zsvJXlKthg";}s:2:"id";s:23:"media.svg_image.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:9:"svg_image";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:21:"field_media_svg_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:4;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:7:{s:7:"created";b:1;s:4:"path";b:1;s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:3:"uid";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.media.svg_image.media_library', 'a:11:{s:4:"uuid";s:36:"1dc3162d-5b65-4b5b-9525-86a35d94bc7a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_form_mode.media.media_library";i:1;s:49:"field.field.media.svg_image.field_media_svg_image";i:2;s:21:"image.style.thumbnail";i:3;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jZjgtY49s-hqyIAMN42-MR1Gi43lmpHbHFqrZ4CKFOg";}s:2:"id";s:29:"media.svg_image.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:9:"svg_image";s:4:"mode";s:13:"media_library";s:7:"content";a:2:{s:21:"field_media_svg_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:4:"name";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:8:{s:7:"created";b:1;s:4:"path";b:1;s:10:"publish_on";b:1;s:13:"publish_state";b:1;s:6:"status";b:1;s:3:"uid";b:1;s:12:"unpublish_on";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.node.page.default', 'a:11:{s:4:"uuid";s:36:"348701c3-2377-4e1d-bbcc-e3b3bd18bf08";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:35:"field.field.node.page.field_content";i:1;s:39:"field.field.node.page.field_description";i:2;s:42:"field.field.node.page.field_featured_image";i:3;s:32:"field.field.node.page.field_tags";i:4;s:44:"field.field.node.page.layout_builder__layout";i:5;s:14:"node.type.page";}s:6:"module";a:5:{i:0;s:13:"media_library";i:1;s:4:"path";i:2;s:9:"scheduler";i:3;s:6:"tagify";i:4;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cv3vrBO5FThyOybHSBKigkVK5IOoRQ0kMGg8hkQ7Cb4";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:16:{s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:13:"field_content";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:7;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:9;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:17:"field_description";a:5:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:6;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:20:"field_featured_image";a:5:{s:4:"type";s:20:"media_library_widget";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:11:"media_types";a:0:{}}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:43:"tagify_entity_reference_autocomplete_widget";s:6:"weight";i:9;s:6:"region";s:7:"content";s:8:"settings";a:3:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:16:"moderation_state";a:5:{s:4:"type";s:24:"moderation_state_default";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:14;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:12;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:10:"publish_on";a:5:{s:4:"type";s:29:"datetime_timestamp_no_default";s:6:"weight";i:4;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:14:"publish_status";a:5:{s:4:"type";s:20:"scheduler_moderation";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:18:"scheduler_settings";a:4:{s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:13;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:12:"unpublish_on";a:5:{s:4:"type";s:29:"datetime_timestamp_no_default";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:3:{s:22:"layout_builder__layout";b:1;s:13:"publish_state";b:1;s:15:"unpublish_state";b:1;}}'),
('', 'core.entity_form_display.user.user.default', 'a:11:{s:4:"uuid";s:36:"d23d53df-b157-492f-9a09-9b3ef80005f2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pojsLtV41YIYgWaeuqfl6yG8fsVXhC1iVB7XwKG0nMc";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:4:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:7:"contact";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:4:"path";b:1;}}'),
('', 'core.entity_form_mode.media.media_library', 'a:10:{s:4:"uuid";s:36:"399b18bb-521d-4f84-a169-cfe2ee579901";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"h9eGjVAfAa4nod-BMI9TzN2uZwl7_WhRYREJZlOC6fs";}s:2:"id";s:19:"media.media_library";s:5:"label";s:13:"Media library";s:11:"description";N;s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_form_mode.user.register', 'a:10:{s:4:"uuid";s:36:"c4c8fdcc-6317-4855-95a4-25c55a082356";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1TFiplNN7Wmj_DtVLLLP-NLPYpZJdAswKY-vTrYgFyo";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:11:"description";N;s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'core.entity_view_display.easy_email.user_created_approval_admin.default', 'a:11:{s:4:"uuid";s:36:"6b904e64-c095-4c43-bb39-6f09991d655a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:54:"easy_email.easy_email_type.user_created_approval_admin";i:1;s:69:"field.field.easy_email.user_created_approval_admin.field_related_user";}s:6:"module";a:3:{i:0;s:4:"file";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I99b974QYXHklYe6OTTJuWgZLsKHhba6B7WX6jJUGIE";}s:2:"id";s:46:"easy_email.user_created_approval_admin.default";s:16:"targetEntityType";s:10:"easy_email";s:6:"bundle";s:27:"user_created_approval_admin";s:4:"mode";s:7:"default";s:7:"content";a:19:{s:10:"attachment";a:6:{s:4:"type";s:12:"file_default";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:28:"use_description_as_link_text";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:15:"attachment_path";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:11:"bcc_address";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:7:"bcc_uid";a:6:{s:4:"type";s:6:"author";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:9:"body_html";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:10:"body_plain";a:6:{s:4:"type";s:12:"basic_string";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:10:"cc_address";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:6:"cc_uid";a:6:{s:4:"type";s:6:"author";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:11:"creator_uid";a:6:{s:4:"type";s:6:"author";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:18:"field_related_user";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}s:12:"from_address";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:9:"from_name";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:13:"inbox_preview";a:6:{s:4:"type";s:12:"basic_string";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:3:"key";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:5:"label";a:6:{s:4:"type";s:6:"string";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-5;s:6:"region";s:7:"content";}s:17:"recipient_address";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:13:"recipient_uid";a:6:{s:4:"type";s:6:"author";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"reply_to";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}s:7:"subject";a:6:{s:4:"type";s:6:"string";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-4;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.media.document.default', 'a:11:{s:4:"uuid";s:36:"7ba0dbea-9cb9-4821-b01d-306717f5fb49";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:47:"field.field.media.document.field_media_document";i:1;s:19:"media.type.document";}s:6:"module";a:1:{i:0;s:4:"file";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Ue2D9UBZwS3Brs8Z06aU9o2B8a6OLpSbd83kmX9bkfU";}s:2:"id";s:22:"media.document.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:20:"field_media_document";a:6:{s:4:"type";s:12:"file_default";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.document.media_library', 'a:11:{s:4:"uuid";s:36:"6c920c76-fb43-4e97-8f7f-6d6cfe33a07b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:47:"field.field.media.document.field_media_document";i:2;s:21:"image.style.thumbnail";i:3;s:19:"media.type.document";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YcWqjhIlo-2RZUM5ogvRsrKB7M3voF2XB3lVLwgOlLU";}s:2:"id";s:28:"media.document.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:8:"document";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:20:"field_media_document";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.16_9_large', 'a:11:{s:4:"uuid";s:36:"84d91d17-5b46-4c9f-a1e1-47e35740bb91";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.16_9_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.16_9_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FuV1WGhCbzoXiz7smvBVXC-0xYzl4ziBxfVUMw7QCKc";}s:2:"id";s:22:"media.image.16_9_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"16_9_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"16_9_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.16_9_medium', 'a:11:{s:4:"uuid";s:36:"0a66bbc2-a551-4428-a457-84de25a4409c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:39:"core.entity_view_mode.media.16_9_medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:35:"responsive_image.styles.16_9_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9a_J-MEjpjfs8KcMjFPMy7LXjsDMv6uir6CMIg8nzRc";}s:2:"id";s:23:"media.image.16_9_medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:11:"16_9_medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:11:"16_9_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.16_9_small', 'a:11:{s:4:"uuid";s:36:"9321b085-24ec-442a-9ec1-e05d4236db28";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.16_9_small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.16_9_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pH5ELzMw6acMy5rc5Dv_VOjHo-sPdQpL5a1QTB0n-cc";}s:2:"id";s:22:"media.image.16_9_small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"16_9_small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"16_9_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.16_9_wide', 'a:11:{s:4:"uuid";s:36:"39267521-6abf-44a5-83de-34e8c6cffade";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.16_9_wide";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.16_9_wide";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"p5IWbA8vLVUpYcFxMzUA304E6ZVsA2mgJewTJwpynvw";}s:2:"id";s:21:"media.image.16_9_wide";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"16_9_wide";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"16_9_wide";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.1_1_square_large', 'a:11:{s:4:"uuid";s:36:"11ad98cf-f594-4a00-9775-978e703a0764";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:44:"core.entity_view_mode.media.1_1_square_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.1_1_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iyBb8Noyu3HExDuD__MJQc1k3oWwV3cBWtCi0gK2_aY";}s:2:"id";s:28:"media.image.1_1_square_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:16:"1_1_square_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"1_1_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.1_1_square_medium', 'a:11:{s:4:"uuid";s:36:"4e977e7a-6227-4064-becd-f90b42210bec";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:45:"core.entity_view_mode.media.1_1_square_medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.1_1_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vg9PxyGyPZ1tf58J5UUv6Jxalf_hYC526PwthH76O6M";}s:2:"id";s:29:"media.image.1_1_square_medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:17:"1_1_square_medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"1_1_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.1_1_square_small', 'a:11:{s:4:"uuid";s:36:"3da80f19-d151-4452-a4b5-60035bf192c9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:44:"core.entity_view_mode.media.1_1_square_small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:40:"responsive_image.styles.1_1_square_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-QuOI23XKy868t0JVwQT4XHpp0urRI5-vg_zxNKfbXk";}s:2:"id";s:28:"media.image.1_1_square_small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:16:"1_1_square_small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:16:"1_1_square_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.2_3_large', 'a:11:{s:4:"uuid";s:36:"fed86388-c871-4dc7-b8a9-35023beea282";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.2_3_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.2_3_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BXteIzKWABS6LE3XntsCMj8VikaD_H_T9r4ehuyt_m4";}s:2:"id";s:21:"media.image.2_3_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"2_3_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"2_3_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.2_3_medium', 'a:11:{s:4:"uuid";s:36:"b7ca00a6-eef5-4863-9e59-de9a26769ccb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.2_3_medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.2_3_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a3qi6fV5DH-KitiDEd4ScBNAbZnA749NRjttSXuVl14";}s:2:"id";s:22:"media.image.2_3_medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"2_3_medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"2_3_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.2_3_small', 'a:11:{s:4:"uuid";s:36:"4832405a-80be-4e93-abf3-0aed409fd9e6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.2_3_small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.2_3_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DXgwTLbd2n9i1TtQTNRWQ8nhwyRyk_4_ixQDlea1uj4";}s:2:"id";s:21:"media.image.2_3_small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"2_3_small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"2_3_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.3_2_large', 'a:11:{s:4:"uuid";s:36:"f36f7dad-ac81-46eb-8b99-dae73f181c96";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.3_2_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.3_2_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gtIXxn48WmWIakRfh1MEaJk6eJuafQipR_msleUm25Q";}s:2:"id";s:21:"media.image.3_2_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"3_2_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"3_2_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.3_2_medium', 'a:11:{s:4:"uuid";s:36:"4b91501b-aa36-45e2-a1b4-859338e9ad2f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.3_2_medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.3_2_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1j5FW20IGfbOgCuJ2q11uiWijLYeFOhW8ihRB27RpMg";}s:2:"id";s:22:"media.image.3_2_medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"3_2_medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"3_2_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.3_2_small', 'a:11:{s:4:"uuid";s:36:"47bce69c-e907-42d0-9cd8-a4bbd4bd3798";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.3_2_small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.3_2_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wjwcgIk6LuuVMkXnR-VROMuLjIzq4hc_kzKDwQKyLCQ";}s:2:"id";s:21:"media.image.3_2_small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"3_2_small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"3_2_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.3_2_wide', 'a:11:{s:4:"uuid";s:36:"cd01e822-86ba-42d3-a1f9-1767a85e8ee1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:36:"core.entity_view_mode.media.3_2_wide";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:32:"responsive_image.styles.3_2_wide";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BpgEHwvQroTuUKAhS9NY_yUtuNPV_9A_cB2hdMUeipE";}s:2:"id";s:20:"media.image.3_2_wide";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:8:"3_2_wide";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:8:"3_2_wide";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.3_4_large', 'a:11:{s:4:"uuid";s:36:"4f0e697b-cfee-433d-89b3-58ddaf6c0bbf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.3_4_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.3_4_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5aN1t5vANUQI1fuwCW6fnJvceNOmv5s8hPXbIszLjyo";}s:2:"id";s:21:"media.image.3_4_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"3_4_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"3_4_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.3_4_medium', 'a:11:{s:4:"uuid";s:36:"9d156afe-c553-4748-9ee0-5969dbaa254f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.3_4_medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.3_4_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3c2e0J47ni6SPiHpY1kGRuhm1j_2BYSDTYKYC6Ucous";}s:2:"id";s:22:"media.image.3_4_medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"3_4_medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"3_4_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.3_4_small', 'a:11:{s:4:"uuid";s:36:"6b15d698-1628-4689-9f07-e3f0f7beab11";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.3_4_small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.3_4_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fL4NsgzhPyYYTkzLxHNNE1NoMG_qXDxpkfcPdEsXKEI";}s:2:"id";s:21:"media.image.3_4_small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"3_4_small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"3_4_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.4_3_large', 'a:11:{s:4:"uuid";s:36:"11e4f3fc-15fc-4191-b5b7-942fe2d8660e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.4_3_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.4_3_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"T_bDn3-hgDsAl0ZSEvyYDFRaZOH4TEROjfthZ8OcP6U";}s:2:"id";s:21:"media.image.4_3_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"4_3_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"4_3_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.4_3_medium', 'a:11:{s:4:"uuid";s:36:"3b304ceb-be61-45c8-824e-36e6e9989fcf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.4_3_medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.4_3_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hj6Lbkty5KiNCTl1KqnxmeNPFMdcwtlN09jAC3rKXtE";}s:2:"id";s:22:"media.image.4_3_medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"4_3_medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"4_3_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.4_3_small', 'a:11:{s:4:"uuid";s:36:"dc168cd0-62a1-4dd3-91fd-2e89baa01962";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.4_3_small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.4_3_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"w6iydU5_ty857lSKHMyETYs3qOJTjKaDpoUUsK3zS0Q";}s:2:"id";s:21:"media.image.4_3_small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"4_3_small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"4_3_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.4_3_wide', 'a:11:{s:4:"uuid";s:36:"770028ca-fdfa-489c-9dfe-b2a9fd7f3766";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:36:"core.entity_view_mode.media.4_3_wide";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:32:"responsive_image.styles.4_3_wide";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BrR_soni1UNu-aTfnirE9Yj55lcKbMWkM3FbrYMBcM8";}s:2:"id";s:20:"media.image.4_3_wide";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:8:"4_3_wide";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:8:"4_3_wide";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.9_16_large', 'a:11:{s:4:"uuid";s:36:"dd74f7bb-33a4-45ed-aa3f-b7f60e915407";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.9_16_large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.9_16_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yul_zb8OA6uDsuAs5SK94GpFMEebEBCCqKcJHAWS8XM";}s:2:"id";s:22:"media.image.9_16_large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"9_16_large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"9_16_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.9_16_medium', 'a:11:{s:4:"uuid";s:36:"fb250809-5358-4ad4-977c-fe28a379a7c1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:39:"core.entity_view_mode.media.9_16_medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:35:"responsive_image.styles.9_16_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pNUtcVKeHPPo2UrdgH3a-pr1gsHhIWSgah3vjeawfN0";}s:2:"id";s:23:"media.image.9_16_medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:11:"9_16_medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:11:"9_16_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.9_16_small', 'a:11:{s:4:"uuid";s:36:"46046d8a-4831-46cf-9725-6a863e84b76d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:38:"core.entity_view_mode.media.9_16_small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.9_16_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Qg47l0nztaKlmUP88POsslRft9_59Yv-5F2xEfztWgA";}s:2:"id";s:22:"media.image.9_16_small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:10:"9_16_small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"9_16_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.default', 'a:11:{s:4:"uuid";s:36:"b0d76ae8-fb54-48fd-ad89-6ebcae8b745c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:41:"field.field.media.image.field_media_image";i:1;s:17:"image.style.large";i:2;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t2YAVeSqMs3Gpnfp_plCnQ2TsoC0u57VCUWl8e2jMMM";}s:2:"id";s:19:"media.image.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:11:"image_style";s:5:"large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.hero', 'a:11:{s:4:"uuid";s:36:"90cf0237-fc1b-4b0d-a154-1214065d3a93";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:32:"core.entity_view_mode.media.hero";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:34:"responsive_image.styles.hero_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bRkbUUam-k4ca3cG_O0yJzoKiQu3dTprhyhjfjVsuvI";}s:2:"id";s:16:"media.image.hero";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:4:"hero";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:10:"hero_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:5:"eager";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.hero_wide', 'a:11:{s:4:"uuid";s:36:"dad42315-6a62-418c-9d9b-d95080df5382";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:37:"core.entity_view_mode.media.hero_wide";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:33:"responsive_image.styles.hero_wide";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZejmoalQDLSkcymedLEev-L-rqYRZ_0TtEjMVjU0fIk";}s:2:"id";s:21:"media.image.hero_wide";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:9:"hero_wide";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:9:"hero_wide";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:5:"eager";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.large', 'a:11:{s:4:"uuid";s:36:"27c5031f-83d6-4535-80aa-a3b875f3601a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:33:"core.entity_view_mode.media.large";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:39:"responsive_image.styles.uncropped_large";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XvmVZ_yi02p9yC65erQMoAF3IWDKwKjXeOuwDTrsws8";}s:2:"id";s:17:"media.image.large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:5:"large";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:15:"uncropped_large";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.media_library', 'a:11:{s:4:"uuid";s:36:"99b72254-56f2-4ce5-a1ee-bdb37aa39725";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:42:"image.style.media_library_square_thumbnail";i:3;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ILLWu5KFvbsX6J7sh2Itd4w8-lBBRhR_H8ZrmQiN2yo";}s:2:"id";s:25:"media.image.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:5:"above";s:8:"settings";a:5:{s:10:"image_link";s:0:"";s:11:"image_style";s:30:"media_library_square_thumbnail";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}s:14:"svg_attributes";a:2:{s:5:"width";N;s:6:"height";N;}s:19:"svg_render_as_image";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:17:"field_media_image";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.medium', 'a:11:{s:4:"uuid";s:36:"03a9e175-46f4-496d-b92f-5751c1cd9237";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:34:"core.entity_view_mode.media.medium";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:40:"responsive_image.styles.uncropped_medium";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wqQM7_KUv5vqnmpIMaNT_HabCwCG00Sj05AjxeFRWuk";}s:2:"id";s:18:"media.image.medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:6:"medium";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:16:"uncropped_medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.image.small', 'a:11:{s:4:"uuid";s:36:"8d60150f-7f91-4175-a86d-d240789ef10a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:33:"core.entity_view_mode.media.small";i:1;s:41:"field.field.media.image.field_media_image";i:2;s:16:"media.type.image";i:3;s:39:"responsive_image.styles.uncropped_small";}s:6:"module";a:1:{i:0;s:16:"responsive_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oNuUpNpfOugaAqlzHs15IqaiRyvOkSFLkrel0JSPaCs";}s:2:"id";s:17:"media.image.small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:5:"image";s:4:"mode";s:5:"small";s:7:"content";a:1:{s:17:"field_media_image";a:6:{s:4:"type";s:16:"responsive_image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:3:{s:22:"responsive_image_style";s:15:"uncropped_small";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.remote_video.default', 'a:11:{s:4:"uuid";s:36:"0c4e6507-3867-4a73-b5d8-f993b772c939";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:55:"field.field.media.remote_video.field_media_oembed_video";i:1;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZdPcl2hPxl5pgv3pI-07R7h51OjeUeKJTy-ab1NfM34";}s:2:"id";s:26:"media.remote_video.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:24:"field_media_oembed_video";a:6:{s:4:"type";s:6:"oembed";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:9:"max_width";i:0;s:10:"max_height";i:0;s:7:"loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.remote_video.large', 'a:11:{s:4:"uuid";s:36:"087f5831-b6dc-4932-abc2-0709cdf69c07";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.media.large";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8sbb_QSvh_hI-3kfgrHN9SfG2REfd3J3DHiRTKLKb5Q";}s:2:"id";s:24:"media.remote_video.large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:5:"large";s:7:"content";a:1:{s:24:"field_media_oembed_video";a:6:{s:4:"type";s:6:"oembed";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:9:"max_width";i:960;s:10:"max_height";i:540;s:7:"loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.remote_video.media_library', 'a:11:{s:4:"uuid";s:36:"b93138c6-d507-421e-a1a9-5e50b9dfd991";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:18:"image.style.medium";i:3;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PGGoP-hVkXe_S-GiJRAub4PHDu0KhMExylclrqjdJb4";}s:2:"id";s:32:"media.remote_video.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:24:"field_media_oembed_video";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.remote_video.medium', 'a:11:{s:4:"uuid";s:36:"35c02442-2e19-4e2d-9653-70ab112fd127";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.media.medium";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JffINI1KDnu52CmUqLDKa66ptuZTRyHnAKcf2lczQD0";}s:2:"id";s:25:"media.remote_video.medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:6:"medium";s:7:"content";a:1:{s:24:"field_media_oembed_video";a:6:{s:4:"type";s:6:"oembed";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:9:"max_width";i:720;s:10:"max_height";i:405;s:7:"loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.remote_video.small', 'a:11:{s:4:"uuid";s:36:"18d76087-b399-4324-8223-835976df5a50";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.media.small";i:1;s:55:"field.field.media.remote_video.field_media_oembed_video";i:2;s:23:"media.type.remote_video";}s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oHxF-3xJaWb5uxcDdHpfYJGZD3HuA1L8yky15IKGwAc";}s:2:"id";s:24:"media.remote_video.small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:12:"remote_video";s:4:"mode";s:5:"small";s:7:"content";a:1:{s:24:"field_media_oembed_video";a:6:{s:4:"type";s:6:"oembed";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:9:"max_width";i:304;s:10:"max_height";i:171;s:7:"loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.svg_image.default', 'a:11:{s:4:"uuid";s:36:"4de2dab5-e199-49db-a6e4-589eeee882f5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:49:"field.field.media.svg_image.field_media_svg_image";i:1;s:17:"image.style.large";i:2;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pKrsHdKCRwI4_mpcVzuqg_60fXWqQAL_mDo2_i87ovU";}s:2:"id";s:23:"media.svg_image.default";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:9:"svg_image";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:21:"field_media_svg_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:5:{s:10:"image_link";s:0:"";s:11:"image_style";s:5:"large";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}s:14:"svg_attributes";a:2:{s:5:"width";i:960;s:6:"height";N;}s:19:"svg_render_as_image";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.svg_image.large', 'a:11:{s:4:"uuid";s:36:"13fc9390-4d04-4531-b014-ada2170452d6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.media.large";i:1;s:49:"field.field.media.svg_image.field_media_svg_image";i:2;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8s9vf7jyyrNPyHX1w1z4HOl97rDn9IQLxjUWpfr6yYs";}s:2:"id";s:21:"media.svg_image.large";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:9:"svg_image";s:4:"mode";s:5:"large";s:7:"content";a:1:{s:21:"field_media_svg_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:5:{s:10:"image_link";s:0:"";s:11:"image_style";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}s:14:"svg_attributes";a:2:{s:5:"width";i:960;s:6:"height";N;}s:19:"svg_render_as_image";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.svg_image.media_library', 'a:11:{s:4:"uuid";s:36:"aa8dbbb7-108c-4c49-9b38-25a15347c786";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:49:"field.field.media.svg_image.field_media_svg_image";i:2;s:18:"image.style.medium";i:3;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gRFRXMFGmd0zKG3UKwqRFKtaA-P2rI-jyN6asBMgqT8";}s:2:"id";s:29:"media.svg_image.media_library";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:9:"svg_image";s:4:"mode";s:13:"media_library";s:7:"content";a:1:{s:9:"thumbnail";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:5:{s:10:"image_link";s:0:"";s:11:"image_style";s:6:"medium";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}s:14:"svg_attributes";a:2:{s:5:"width";N;s:6:"height";N;}s:19:"svg_render_as_image";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:21:"field_media_svg_image";b:1;s:4:"name";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.media.svg_image.medium', 'a:11:{s:4:"uuid";s:36:"639e7837-e428-462c-b164-946daa3ee2cb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.media.medium";i:1;s:49:"field.field.media.svg_image.field_media_svg_image";i:2;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TAe9U8S5-70QgYJVIj4Wuj_b9RzRS_no_MWLMxmcL0Q";}s:2:"id";s:22:"media.svg_image.medium";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:9:"svg_image";s:4:"mode";s:6:"medium";s:7:"content";a:1:{s:21:"field_media_svg_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:5:{s:10:"image_link";s:0:"";s:11:"image_style";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}s:14:"svg_attributes";a:2:{s:5:"width";i:720;s:6:"height";N;}s:19:"svg_render_as_image";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'core.entity_view_display.media.svg_image.small', 'a:11:{s:4:"uuid";s:36:"2cd5a465-8654-4f05-abc8-217aa7fa2512";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.media.small";i:1;s:49:"field.field.media.svg_image.field_media_svg_image";i:2;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:9:"svg_image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9GQg53pdI35jR8t5BxkZhXUXiXpkg7wmcvpytyB42_M";}s:2:"id";s:21:"media.svg_image.small";s:16:"targetEntityType";s:5:"media";s:6:"bundle";s:9:"svg_image";s:4:"mode";s:5:"small";s:7:"content";a:1:{s:21:"field_media_svg_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:15:"visually_hidden";s:8:"settings";a:5:{s:10:"image_link";s:0:"";s:11:"image_style";s:0:"";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}s:14:"svg_attributes";a:2:{s:5:"width";i:300;s:6:"height";N;}s:19:"svg_render_as_image";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:7:"created";b:1;s:4:"name";b:1;s:9:"thumbnail";b:1;s:3:"uid";b:1;}}'),
('', 'core.entity_view_display.node.page.card', 'a:12:{s:4:"uuid";s:36:"1e53054a-f2df-4624-b694-0636d91f8029";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:31:"core.entity_view_mode.node.card";i:1;s:35:"field.field.node.page.field_content";i:2;s:39:"field.field.node.page.field_description";i:3;s:42:"field.field.node.page.field_featured_image";i:4;s:32:"field.field.node.page.field_tags";i:5;s:44:"field.field.node.page.layout_builder__layout";i:6;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:14:"layout_builder";i:1;s:4:"user";}}s:20:"third_party_settings";a:1:{s:14:"layout_builder";a:2:{s:7:"enabled";b:0;s:12:"allow_custom";b:0;}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6WriJ20_O2OwaTgXGmR-JxzZrJPCG4MJqugHf_U4454";}s:2:"id";s:14:"node.page.card";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:4:"card";s:7:"content";a:2:{s:17:"field_description";a:6:{s:4:"type";s:12:"basic_string";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}s:20:"field_featured_image";a:6:{s:4:"type";s:28:"entity_reference_entity_view";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:11:"16_9_medium";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:26:"content_moderation_control";b:1;s:13:"field_content";b:1;s:10:"field_tags";b:1;s:22:"layout_builder__layout";b:1;s:5:"links";b:1;}}'),
('', 'core.entity_view_display.node.page.default', 'a:12:{s:4:"uuid";s:36:"41e0b646-a77e-421c-a5b1-1394198e6b0a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:35:"field.field.node.page.field_content";i:1;s:39:"field.field.node.page.field_description";i:2;s:42:"field.field.node.page.field_featured_image";i:3;s:32:"field.field.node.page.field_tags";i:4;s:44:"field.field.node.page.layout_builder__layout";i:5;s:14:"node.type.page";}s:6:"module";a:4:{i:0;s:14:"layout_builder";i:1;s:16:"layout_discovery";i:2;s:4:"text";i:3;s:4:"user";}}s:20:"third_party_settings";a:1:{s:14:"layout_builder";a:3:{s:7:"enabled";b:1;s:12:"allow_custom";b:1;s:8:"sections";a:1:{i:0;a:4:{s:9:"layout_id";s:13:"layout_onecol";s:15:"layout_settings";a:1:{s:5:"label";s:0:"";}s:10:"components";a:4:{s:36:"541922dc-a8c8-4b74-9cdd-88a1f5d053dd";a:5:{s:4:"uuid";s:36:"541922dc-a8c8-4b74-9cdd-88a1f5d053dd";s:6:"region";s:7:"content";s:13:"configuration";a:4:{s:2:"id";s:35:"field_block:node:page:field_content";s:13:"label_display";s:1:"0";s:15:"context_mapping";a:1:{s:6:"entity";s:21:"layout_builder.entity";}s:9:"formatter";a:4:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}}s:6:"weight";i:2;s:10:"additional";a:0:{}}s:36:"b09072a1-7bd8-49c5-ac58-2da953562e12";a:5:{s:4:"uuid";s:36:"b09072a1-7bd8-49c5-ac58-2da953562e12";s:6:"region";s:7:"content";s:13:"configuration";a:3:{s:2:"id";s:54:"extra_field_block:node:page:content_moderation_control";s:13:"label_display";s:1:"0";s:15:"context_mapping";a:1:{s:6:"entity";s:21:"layout_builder.entity";}}s:6:"weight";i:1;s:10:"additional";a:0:{}}s:36:"bfcb27c2-a42f-4e71-bf84-1841a548d5a6";a:5:{s:4:"uuid";s:36:"bfcb27c2-a42f-4e71-bf84-1841a548d5a6";s:6:"region";s:7:"content";s:13:"configuration";a:6:{s:2:"id";s:42:"field_block:node:page:field_featured_image";s:5:"label";s:14:"Featured image";s:13:"label_display";s:1:"0";s:8:"provider";s:14:"layout_builder";s:15:"context_mapping";a:2:{s:6:"entity";s:21:"layout_builder.entity";s:9:"view_mode";s:9:"view_mode";}s:9:"formatter";a:4:{s:4:"type";s:28:"entity_reference_entity_view";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:9:"view_mode";s:4:"hero";}s:20:"third_party_settings";a:0:{}}}s:6:"weight";i:0;s:10:"additional";a:0:{}}s:36:"6976105a-c13d-457c-a8ae-0dfd6f9a7903";a:5:{s:4:"uuid";s:36:"6976105a-c13d-457c-a8ae-0dfd6f9a7903";s:6:"region";s:7:"content";s:13:"configuration";a:6:{s:2:"id";s:32:"field_block:node:page:field_tags";s:5:"label";s:4:"Tags";s:13:"label_display";s:1:"0";s:8:"provider";s:14:"layout_builder";s:15:"context_mapping";a:2:{s:6:"entity";s:21:"layout_builder.entity";s:9:"view_mode";s:9:"view_mode";}s:9:"formatter";a:4:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:6:"inline";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}}}s:6:"weight";i:4;s:10:"additional";a:0:{}}}s:20:"third_party_settings";a:0:{}}}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rVDjFcG7a9eUsRsMS1vdA6OQgJ77pZjEPmk1fIuADao";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:26:"content_moderation_control";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-20;s:6:"region";s:7:"content";}s:13:"field_content";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:20:"field_featured_image";a:6:{s:4:"type";s:28:"entity_reference_entity_view";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:4:"hero";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:17:"field_description";b:1;s:10:"field_tags";b:1;s:22:"layout_builder__layout";b:1;s:5:"links";b:1;}}'),
('', 'core.entity_view_display.node.page.teaser', 'a:11:{s:4:"uuid";s:36:"568b94af-24bd-4b29-b8c5-2fb4e3ad7285";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:35:"field.field.node.page.field_content";i:2;s:39:"field.field.node.page.field_description";i:3;s:42:"field.field.node.page.field_featured_image";i:4;s:32:"field.field.node.page.field_tags";i:5;s:44:"field.field.node.page.layout_builder__layout";i:6;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"T4x4GidpcZanW89XGB9jlCvGB7-7ks7ZXUGkaP5s-Fo";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:17:"field_description";a:6:{s:4:"type";s:12:"basic_string";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:1;s:6:"region";s:7:"content";}s:20:"field_featured_image";a:6:{s:4:"type";s:28:"entity_reference_entity_view";s:5:"label";s:6:"hidden";s:8:"settings";a:2:{s:9:"view_mode";s:10:"4_3_medium";s:4:"link";b:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:5:{s:26:"content_moderation_control";b:1;s:13:"field_content";b:1;s:10:"field_tags";b:1;s:22:"layout_builder__layout";b:1;s:5:"links";b:1;}}'),
('', 'core.entity_view_mode.block.token', 'a:9:{s:4:"uuid";s:36:"ac4b0ea0-10af-4fec-bbe1-eadb1109541a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"block";}}s:2:"id";s:11:"block.token";s:5:"label";s:5:"Token";s:11:"description";N;s:16:"targetEntityType";s:5:"block";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.file.token', 'a:9:{s:4:"uuid";s:36:"fe36488f-c918-43b8-bcf9-4bcf58bd43a1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"file";}}s:2:"id";s:10:"file.token";s:5:"label";s:5:"Token";s:11:"description";N;s:16:"targetEntityType";s:4:"file";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.16_9_large', 'a:10:{s:4:"uuid";s:36:"cfa6f56a-049b-4b2e-8c90-8008cd87c554";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LEGx0C_gkKGRFms3WeNv1lCV_UDeXTH1UQGbV4Vo30k";}s:2:"id";s:16:"media.16_9_large";s:5:"label";s:10:"16:9 Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.16_9_medium', 'a:10:{s:4:"uuid";s:36:"5d0bfac3-5750-498b-9bbe-7aee584b9acd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3OJyyde9aurVBB4SUfXKsP4pLSdjPOXPD1HqhA71k6E";}s:2:"id";s:17:"media.16_9_medium";s:5:"label";s:11:"16:9 Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.16_9_small', 'a:10:{s:4:"uuid";s:36:"3473ed3b-7656-4299-8681-03f29c73e5e2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"n89IaKyrrPz_WBFJghe1r64AV1-0xNM20L8k_y1H8vs";}s:2:"id";s:16:"media.16_9_small";s:5:"label";s:10:"16:9 Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.16_9_wide', 'a:10:{s:4:"uuid";s:36:"101e752e-4d90-433a-abb1-4d3113b9092b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pnJS9cW8aVLAkMjy-sTmfnFm5vwoFZNioBOg_YhgkQU";}s:2:"id";s:15:"media.16_9_wide";s:5:"label";s:9:"16:9 Wide";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.1_1_square_large', 'a:10:{s:4:"uuid";s:36:"925d3db6-980f-4c9a-b0b7-95f76233d140";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"E1JsA47GgI2neLVrNnLbnpi6_SnIw60ypLpePK7W3RE";}s:2:"id";s:22:"media.1_1_square_large";s:5:"label";s:18:"1:1 (Square) Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.1_1_square_medium', 'a:10:{s:4:"uuid";s:36:"d1032f1d-4402-4cfb-85f4-0589f690c8b6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k7w8PG2jgrRx0d71Gdy11dc1FBKid6E2SxT43es_4Fg";}s:2:"id";s:23:"media.1_1_square_medium";s:5:"label";s:19:"1:1 (Square) Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.1_1_square_small', 'a:10:{s:4:"uuid";s:36:"815f8649-6fdf-4857-9147-4a4f8a9a8b9c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uIta0ebP_LA4NPUuR-vmIiZL3Pno_PKmVzXbkpKMZW4";}s:2:"id";s:22:"media.1_1_square_small";s:5:"label";s:18:"1:1 (Square) Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.2_3_large', 'a:10:{s:4:"uuid";s:36:"beeef20c-570b-4022-9605-68086cdb021e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1yc0BhgU54kHKup2ctHuFQWQTy6suPOnLn6x-lQxNKI";}s:2:"id";s:15:"media.2_3_large";s:5:"label";s:9:"2:3 Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.2_3_medium', 'a:10:{s:4:"uuid";s:36:"90a3fa67-59c1-41fd-9582-f5cdb799aaf2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dVme8ZCrS-WvrjKnwAUzPb3E1oQcKYZr6dR9emOYgO4";}s:2:"id";s:16:"media.2_3_medium";s:5:"label";s:10:"2:3 Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.2_3_small', 'a:10:{s:4:"uuid";s:36:"40354006-4a82-47d8-8eb2-521578171226";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"v6BAXpYIb-JM73xaZHSQZBEa2G3ixlNBidDwNATmfcI";}s:2:"id";s:15:"media.2_3_small";s:5:"label";s:9:"2:3 Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.3_2_large', 'a:10:{s:4:"uuid";s:36:"601f8a3f-91ae-4172-b701-b8603c0bbf5c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BiWHRgpWdQtmf_j44juwwUtGyQP79DsmBfXqoEDNb4Y";}s:2:"id";s:15:"media.3_2_large";s:5:"label";s:9:"3:2 Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.3_2_medium', 'a:10:{s:4:"uuid";s:36:"3ab68144-a644-4385-8d01-d476de711df5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SNMMe-RxkbvbHYDoq4zJcNDhpXasXdQwaDd0S-hDJUY";}s:2:"id";s:16:"media.3_2_medium";s:5:"label";s:10:"3:2 Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.3_2_small', 'a:10:{s:4:"uuid";s:36:"d2e98726-a23c-459f-b6a0-38744e42c7f6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2_cdYgIuwANLo2fR9R3OKRi_GAQ7LlFBsQsstP7AaME";}s:2:"id";s:15:"media.3_2_small";s:5:"label";s:9:"3:2 Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.3_2_wide', 'a:10:{s:4:"uuid";s:36:"9106a84c-89ea-43a0-9a70-2da9108f3be2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qQ-9DfjR9NJ441_s2BqS7p-B3pLqePh-FM4eCm43-xw";}s:2:"id";s:14:"media.3_2_wide";s:5:"label";s:8:"3:2 Wide";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.3_4_large', 'a:10:{s:4:"uuid";s:36:"40cdcc13-19b1-4a8e-b915-d9afb0145f47";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zbCsOb-PnJ7UJGjpME30HuieR2wlTzU2MmoY6iEeghc";}s:2:"id";s:15:"media.3_4_large";s:5:"label";s:9:"3:4 Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.3_4_medium', 'a:10:{s:4:"uuid";s:36:"926d439b-b351-4faf-819d-7781e870b2b0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jv0Hg46gFRDMJ4rgTC0rB6zqOWh8J8HSNHGHss3wr0E";}s:2:"id";s:16:"media.3_4_medium";s:5:"label";s:10:"3:4 Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.3_4_small', 'a:10:{s:4:"uuid";s:36:"0475302e-78ca-48ea-8621-35c903ba9337";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0umh5oeCxe3nbP_aCgmC9ef5KQfNuTTrkadocDhYTH0";}s:2:"id";s:15:"media.3_4_small";s:5:"label";s:9:"3:4 Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.4_3_large', 'a:10:{s:4:"uuid";s:36:"f7b67310-3882-4ef2-8e00-877162a504e9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KDpoeP9Xsqk1-2eUZPzO9ZoRCs3nHY9L-YUTT9g_RFA";}s:2:"id";s:15:"media.4_3_large";s:5:"label";s:9:"4:3 Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.4_3_medium', 'a:10:{s:4:"uuid";s:36:"908db13b-8e26-472d-a5e9-b796351b3b6c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lr75s7t1haZKLGSILkJZeyIj1HujzWrNl4nDxZalxwQ";}s:2:"id";s:16:"media.4_3_medium";s:5:"label";s:10:"4:3 Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.4_3_small', 'a:10:{s:4:"uuid";s:36:"a2029321-6911-4413-b2e9-a4d02a94fa74";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_FSZlwENEgx36sqz9Grr_BGf2GiNqOhNhPbD-YELDv4";}s:2:"id";s:15:"media.4_3_small";s:5:"label";s:9:"4:3 Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.4_3_wide', 'a:10:{s:4:"uuid";s:36:"2f4ebb88-e10e-48a1-a6d6-63bc270f87e2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"p7g2PyETibEB0CxdXFdXJpEZbMuwrr5HkNBdBV8oK7o";}s:2:"id";s:14:"media.4_3_wide";s:5:"label";s:8:"4:3 Wide";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.9_16_large', 'a:10:{s:4:"uuid";s:36:"3c99ef91-183f-45b4-ad01-e785da466715";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wrnos1LqjHxK3oqTB0g-AjMHUb3JgReqBsAnoMJSMYM";}s:2:"id";s:16:"media.9_16_large";s:5:"label";s:10:"9:16 Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.9_16_medium', 'a:10:{s:4:"uuid";s:36:"4674ed9d-eef6-40bc-8752-da4cbaed0c59";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C4dV28K3UsbLFSot0mwx3InBZ4XdBBC7Rzk2lLRrlJQ";}s:2:"id";s:17:"media.9_16_medium";s:5:"label";s:11:"9:16 Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.9_16_small', 'a:10:{s:4:"uuid";s:36:"50900575-79b8-4586-92dc-69819dd793d2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ajQY0iRDTK8002X87LXQaTxBLhxAWkdRM7yM_b-uTHM";}s:2:"id";s:16:"media.9_16_small";s:5:"label";s:10:"9:16 Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.full', 'a:10:{s:4:"uuid";s:36:"6f1209a0-c68e-4f04-8452-ed3bf215cd86";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dTfAUHooYV0uOVPO3saGpgv-c5PppJXDwxvwRTJOycM";}s:2:"id";s:10:"media.full";s:5:"label";s:12:"Full content";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.hero', 'a:10:{s:4:"uuid";s:36:"8ded7639-090a-4159-bdab-e982865efe77";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zAj-eiOJoImMZ2MAmC2k7HFfOKvT0JA_aHDz6RaN2uQ";}s:2:"id";s:10:"media.hero";s:5:"label";s:4:"Hero";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.hero_wide', 'a:10:{s:4:"uuid";s:36:"48636168-a588-4468-8682-02da11fe8d33";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZfeAFB0XHD3WjB_xibJhxKG1vqXzxRxylIzd3QVRric";}s:2:"id";s:15:"media.hero_wide";s:5:"label";s:9:"Hero Wide";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.large', 'a:10:{s:4:"uuid";s:36:"88306735-e589-4fb3-bf75-a588db72a559";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"S8zjrAUo-0BGMD_cASIqUpPrzMVaC0rTscO6pNpTIwM";}s:2:"id";s:11:"media.large";s:5:"label";s:5:"Large";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.media_library', 'a:10:{s:4:"uuid";s:36:"3ecdbcf6-af04-4654-ba0b-667e0633d359";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"04_dAqpWYP1WmsXZ7IXJ7-yarCvNddD10EUkBDtIFy4";}s:2:"id";s:19:"media.media_library";s:5:"label";s:13:"Media library";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.medium', 'a:10:{s:4:"uuid";s:36:"9ea764eb-7bbd-416a-b5c4-e15b9568989f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"GBOXT2oPid8CPDG3oFxF_5QYPEOBtADnZvlqY_e7FS8";}s:2:"id";s:12:"media.medium";s:5:"label";s:6:"Medium";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.small', 'a:10:{s:4:"uuid";s:36:"545bede6-0966-43c5-be2d-719eb614e432";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5A3-9WmnLzFhzzDR2c-ilHPnHaTltfH_DEnL332-7ks";}s:2:"id";s:11:"media.small";s:5:"label";s:5:"Small";s:11:"description";s:0:"";s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.media.token', 'a:9:{s:4:"uuid";s:36:"5524aaf9-1d39-486e-b1c4-8152cd74cd91";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:2:"id";s:11:"media.token";s:5:"label";s:5:"Token";s:11:"description";N;s:16:"targetEntityType";s:5:"media";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.card', 'a:10:{s:4:"uuid";s:36:"4ffe3237-a87c-4265-86a1-bc2ea3ed6444";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AtN311PK7pVwNFVe7be6DabmiwfNEbWODEYcHCaewdk";}s:2:"id";s:9:"node.card";s:5:"label";s:4:"Card";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.full', 'a:10:{s:4:"uuid";s:36:"1b852ba6-706c-4a64-b070-16cd2f6eccb2";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QJ2aZ1xfVf59aq6Pz5X7fyUOa2HxuCoTwQ_RQjoulAU";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.rss', 'a:10:{s:4:"uuid";s:36:"03d4957b-7b27-48ff-af1a-98f6f93a17a8";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"l8fiAFE3Kng_6bhLlUDnVTkTDzXWxzYFrCWTrngVXEA";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.teaser', 'a:10:{s:4:"uuid";s:36:"2645fe53-59ed-4884-89d5-2c9a9ac1ce4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgGJDZFpMaz_8bTv6fN1bXS3Qi5LWmRJI9R53kEGsNQ";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.token', 'a:9:{s:4:"uuid";s:36:"d1576f26-54d6-4a8d-b186-84f42e4f71ca";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:2:"id";s:10:"node.token";s:5:"label";s:5:"Token";s:11:"description";N;s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.path_alias.token', 'a:9:{s:4:"uuid";s:36:"651d69c5-9dd9-49ba-9de8-c43bb190f6fe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:10:"path_alias";}}s:2:"id";s:16:"path_alias.token";s:5:"label";s:5:"Token";s:11:"description";N;s:16:"targetEntityType";s:10:"path_alias";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.taxonomy_term.full', 'a:10:{s:4:"uuid";s:36:"d7cc40f1-5df1-4ad3-80e9-c6cb5149df0c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iukUENpf8CFvjZbGGacKX_Ges0-lU9z6zvsd32P6kbo";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:11:"description";s:0:"";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.taxonomy_term.token', 'a:9:{s:4:"uuid";s:36:"8fb1fa84-7658-4482-8c48-d4e7ba480b22";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:2:"id";s:19:"taxonomy_term.token";s:5:"label";s:5:"Token";s:11:"description";N;s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.user.compact', 'a:10:{s:4:"uuid";s:36:"92d45eb8-a5ac-475a-a3ec-d0ae27256162";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TtD7OuGskOsQfoGyxXkrdtllBpR37J19d5BMQDZWJgA";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.user.full', 'a:10:{s:4:"uuid";s:36:"4c1346e5-1dbe-4487-9811-b313247265f6";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZbXunWS_xAvMZXFfinyvClDAb_RCVLt7gAzE3v16E-Q";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.user.token', 'a:9:{s:4:"uuid";s:36:"a7f3b0e5-427d-4e06-a03c-dd8da0b884a2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:10:"user.token";s:5:"label";s:5:"Token";s:11:"description";N;s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.extension', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4GIX5Esnc_umpXUBj4IIocRX7Mt5fPhm4AgXfE3E56E";}s:6:"module";a:89:{s:18:"announcements_feed";i:0;s:14:"automated_cron";i:0;s:17:"automatic_updates";i:0;s:28:"automatic_updates_extensions";i:0;s:13:"autosave_form";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:7:"bpmn_io";i:0;s:10:"breakpoint";i:0;s:7:"captcha";i:0;s:9:"ckeditor5";i:0;s:6:"coffee";i:0;s:6:"config";i:0;s:18:"content_moderation";i:0;s:10:"contextual";i:0;s:4:"crop";i:0;s:9:"dashboard";i:0;s:8:"datetime";i:0;s:5:"dblog";i:0;s:17:"drupal_cms_helper";i:0;s:18:"dynamic_page_cache";i:0;s:15:"easy_breadcrumb";i:0;s:10:"easy_email";i:0;s:19:"easy_email_override";i:0;s:3:"eca";i:0;s:8:"eca_base";i:0;s:10:"eca_config";i:0;s:11:"eca_content";i:0;s:8:"eca_misc";i:0;s:17:"eca_modeller_bpmn";i:0;s:10:"eca_render";i:0;s:6:"eca_ui";i:0;s:8:"eca_user";i:0;s:6:"editor";i:0;s:5:"field";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:11:"focal_point";i:0;s:15:"friendlycaptcha";i:0;s:11:"gin_toolbar";i:0;s:8:"honeypot";i:0;s:5:"image";i:0;s:18:"inline_form_errors";i:0;s:9:"jquery_ui";i:0;s:19:"jquery_ui_resizable";i:0;s:5:"klaro";i:0;s:14:"layout_builder";i:0;s:16:"layout_discovery";i:0;s:4:"link";i:0;s:6:"linkit";i:0;s:19:"login_emailusername";i:0;s:10:"mailsystem";i:0;s:5:"media";i:0;s:13:"media_library";i:0;s:20:"menu_link_attributes";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:5:"mysql";i:0;s:10:"navigation";i:0;s:4:"node";i:0;s:7:"options";i:0;s:15:"package_manager";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:15:"project_browser";i:0;s:8:"redirect";i:0;s:12:"redirect_404";i:0;s:16:"responsive_image";i:0;s:3:"sam";i:0;s:9:"scheduler";i:0;s:40:"scheduler_content_moderation_integration";i:0;s:9:"svg_image";i:0;s:19:"symfony_mailer_lite";i:0;s:6:"system";i:0;s:6:"tagify";i:0;s:16:"tagify_user_list";i:0;s:8:"taxonomy";i:0;s:4:"text";i:0;s:5:"token";i:0;s:5:"trash";i:0;s:6:"update";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:9:"workflows";i:0;s:8:"eca_form";i:1;s:8:"pathauto";i:1;s:5:"views";i:10;}s:5:"theme";a:5:{s:5:"claro";i:0;s:3:"gin";i:0;s:7:"olivero";i:0;s:16:"easy_email_theme";i:0;s:18:"drupal_cms_olivero";i:0;}}'),
('', 'core.menu.static_menu_link_overrides', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jdY7AU0tU-QsjmiOw3W8vwpYMb-By--_MSFgbqKUTYM";}s:11:"definitions";a:1:{s:32:"announcements_feed__announcement";a:5:{s:9:"menu_name";s:5:"admin";s:6:"parent";s:12:"system.admin";s:6:"weight";i:0;s:8:"expanded";b:0;s:7:"enabled";b:0;}}}'),
('', 'crop.settings', 'a:1:{s:23:"flush_derivative_images";b:1;}'),
('', 'crop.type.focal_point', 'a:13:{s:4:"uuid";s:36:"8bdaef08-251e-4520-868e-b502f81202df";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"flCi9IdafdLXlJqvoHguutUOiC05-aynK4niYN4YZ3o";}s:2:"id";s:11:"focal_point";s:5:"label";s:11:"Focal point";s:11:"description";s:37:"Crop type used by Focal point module.";s:12:"aspect_ratio";s:0:"";s:16:"soft_limit_width";N;s:17:"soft_limit_height";N;s:16:"hard_limit_width";N;s:17:"hard_limit_height";N;}'),
('', 'dashboard.dashboard.welcome', 'a:10:{s:4:"uuid";s:36:"230ccb4d-dac2-4d88-a7a3-80e0e1e38929";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:19:"system.menu.welcome";i:1;s:25:"views.view.recent_content";}s:6:"module";a:5:{i:0;s:18:"announcements_feed";i:1;s:14:"layout_builder";i:2;s:16:"layout_discovery";i:3;s:6:"system";i:4;s:5:"views";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mr9v0CKhIfU3r6ZZKahq3suJv7K2vUe-Im-_kpmyETY";}s:2:"id";s:7:"welcome";s:5:"label";s:20:"Welcome to your site";s:11:"description";s:69:"Presented to users when they complete the Drupal CMS install process.";s:6:"layout";a:2:{i:0;a:4:{s:9:"layout_id";s:21:"layout_twocol_section";s:15:"layout_settings";a:3:{s:5:"label";s:17:"Content and tasks";s:13:"column_widths";s:5:"67-33";s:15:"context_mapping";a:0:{}}s:10:"components";a:2:{s:36:"cb457c1c-83c2-4a79-a09e-2c64a8bf8fb8";a:5:{s:4:"uuid";s:36:"cb457c1c-83c2-4a79-a09e-2c64a8bf8fb8";s:6:"region";s:6:"second";s:13:"configuration";a:8:{s:2:"id";s:25:"system_menu_block:welcome";s:5:"label";s:9:"Top tasks";s:13:"label_display";s:7:"visible";s:8:"provider";s:6:"system";s:15:"context_mapping";a:0:{}s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:6:"weight";i:0;s:10:"additional";a:0:{}}s:36:"95005442-e22e-4068-bcac-814fb6c1ccc4";a:5:{s:4:"uuid";s:36:"95005442-e22e-4068-bcac-814fb6c1ccc4";s:6:"region";s:5:"first";s:13:"configuration";a:7:{s:2:"id";s:47:"views_block:recent_content-block_recent_content";s:5:"label";s:0:"";s:13:"label_display";s:7:"visible";s:8:"provider";s:5:"views";s:15:"context_mapping";a:0:{}s:11:"views_label";s:0:"";s:14:"items_per_page";N;}s:6:"weight";i:0;s:10:"additional";a:0:{}}}s:20:"third_party_settings";a:0:{}}i:1;a:4:{s:9:"layout_id";s:13:"layout_onecol";s:15:"layout_settings";a:2:{s:5:"label";s:13:"Announcements";s:15:"context_mapping";a:0:{}}s:10:"components";a:1:{s:36:"237ad3cf-cb2b-4991-a107-efafbef5f846";a:5:{s:4:"uuid";s:36:"237ad3cf-cb2b-4991-a107-efafbef5f846";s:6:"region";s:7:"content";s:13:"configuration";a:5:{s:2:"id";s:14:"announce_block";s:5:"label";s:13:"Announcements";s:13:"label_display";s:7:"visible";s:8:"provider";s:18:"announcements_feed";s:15:"context_mapping";a:0:{}}s:6:"weight";i:0;s:10:"additional";a:0:{}}}s:20:"third_party_settings";a:0:{}}}s:6:"weight";i:0;}'),
('', 'dblog.settings', 'a:1:{s:9:"row_limit";i:1000;}'),
('', 'drupal_cms_olivero.settings', 'a:7:{s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";s:18:"base_primary_color";s:7:"#1b9ae4";}'),
('', 'easy_breadcrumb.settings', 'a:37:{s:8:"langcode";s:2:"en";s:20:"applies_admin_routes";b:0;s:21:"include_invalid_paths";b:0;s:14:"excluded_paths";s:0:"";s:15:"replaced_titles";s:0:"";s:12:"custom_paths";s:0:"";s:20:"include_home_segment";b:1;s:23:"alternative_title_field";s:22:"field_breadcrumb_title";s:18:"home_segment_title";s:4:"Home";s:17:"home_segment_keep";b:0;s:21:"include_title_segment";b:1;s:30:"title_from_page_when_available";b:1;s:21:"title_segment_as_link";b:0;s:26:"use_menu_title_as_fallback";b:0;s:37:"use_page_title_as_menu_title_fallback";b:0;s:25:"menu_title_preferred_menu";s:0:"";s:24:"remove_repeated_segments";b:1;s:31:"language_path_prefix_as_segment";b:0;s:14:"absolute_paths";b:0;s:21:"hide_single_home_item";b:1;s:14:"term_hierarchy";b:0;s:14:"use_site_title";b:0;s:27:"add_structured_data_json_ld";b:1;s:18:"capitalizator_mode";s:4:"none";s:27:"capitalizator_ignored_words";a:8:{i:0;s:2:"of";i:1;s:3:"and";i:2;s:2:"or";i:3;s:2:"de";i:4;s:3:"del";i:5;s:1:"y";i:6;s:1:"o";i:7;s:1:"a";}s:26:"capitalizator_forced_words";a:0:{}s:43:"capitalizator_forced_words_case_sensitivity";b:1;s:39:"capitalizator_forced_words_first_letter";b:0;s:16:"follow_redirects";b:1;s:21:"limit_segment_display";b:0;s:21:"segment_display_limit";i:0;s:23:"segment_display_minimum";i:1;s:14:"truncator_mode";b:0;s:16:"truncator_length";i:100;s:14:"truncator_dots";b:1;s:34:"remove_repeated_segments_text_only";b:0;s:28:"home_segment_validation_skip";b:0;}'),
('', 'easy_email.easy_email_type.default', 'a:28:{s:4:"uuid";s:36:"f973cdb2-ae1c-4a2e-8fe4-e6b94e68ebb9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wtiD2a3ZqXWw4_OG6-jmSAyjVNeeIsqZf8rVnAe6J7I";}s:5:"label";s:7:"Default";s:2:"id";s:7:"default";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:0:"";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:0:"";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:0:"";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:7:"private";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_activation', 'a:28:{s:4:"uuid";s:36:"28727c2e-02c4-4b40-a8ae-b1673efdb3b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IgeiNHsAfxUgOHSdgQ94BJwptt-eVx51_t9N0mqr7Jw";}s:5:"label";s:24:"User: Account Activation";s:2:"id";s:15:"user_activation";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:94:"Account details for [easy_email:recipient_uid:0:entity:display-name] at [site:name] (approved)";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:657:"<p>[easy_email:recipient_uid:0:entity:display-name],</p><p>Your account at [site:name] has been activated.</p><p>You may now log in by clicking this link or copying and pasting it into your browser:</p><p><a class="button" href="[easy_email:recipient_uid:0:entity:one-time-login-url]">Log in and set your password</a></p><p>This link can only be used once to log in and will lead you to a page where you can set your password.</p><p>After setting your password, you will be able to log in at [site:login-url] in the future using:</p><p>username: [easy_email:recipient_uid:0:entity:account-name]<br>password: Your password</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:535:"[easy_email:recipient_uid:0:entity:display-name],\r\n\r\nYour account at [site:name] has been activated.\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[easy_email:recipient_uid:0:entity:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [user:account-name]\r\npassword: Your password\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_blocked', 'a:28:{s:4:"uuid";s:36:"f8dc02d0-bf52-4548-9786-48ff76da30b8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"R9i03-dkbYVX5YpNxrXZ4YuXSFE8SQPqsK2KPK3iYIg";}s:5:"label";s:21:"User: Account Blocked";s:2:"id";s:12:"user_blocked";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:93:"Account details for [easy_email:recipient_uid:0:entity:display-name] at [site:name] (blocked)";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:140:"<p>[easy_email:recipient_uid:0:entity:display-name],</p><p>Your account on [site:name] has been blocked.</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:122:"[easy_email:recipient_uid:0:entity:display-name],\r\n\r\nYour account on [site:name] has been blocked.\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_canceled', 'a:28:{s:4:"uuid";s:36:"aa7097af-5398-4980-af93-afd706ce2ff6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YhNk9pF6Z6XX7hxg2zo9S8MpzAvcJqC51WxEqdo2nGo";}s:5:"label";s:22:"User: Account Canceled";s:2:"id";s:13:"user_canceled";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:94:"Account details for [easy_email:recipient_uid:0:entity:display-name] at [site:name] (canceled)";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:141:"<p>[easy_email:recipient_uid:0:entity:display-name],</p><p>Your account on [site:name] has been canceled.</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:123:"[easy_email:recipient_uid:0:entity:display-name],\r\n\r\nYour account on [site:name] has been canceled.\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_cancellation_confirmation', 'a:28:{s:4:"uuid";s:36:"c94b0af6-124b-4e80-a0af-50b975f9e9b3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"---tmZd3cead7Mt_Wgnbs1QNC5SJPiB-FdcLZigl8zU";}s:5:"label";s:39:"User: Account Cancellation Confirmation";s:2:"id";s:30:"user_cancellation_confirmation";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:96:"Account cancellation request for [easy_email:recipient_uid:0:entity:display-name] at [site:name]";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:530:"<p>[easy_email:recipient_uid:0:entity:display-name]</p><p>A request to cancel your account has been made at [site:name].</p><p>You may now cancel your account on <a href="[site:url]">[site:url-brief]</a> by clicking this link:</p><p><a class="button danger" href="[easy_email:recipient_uid:0:entity:cancel-url]">Cancel your account</a></p><p><strong>NOTE: The cancellation of your account is not reversible.</strong></p><p>This link expires in one day and nothing will happen if it is not used.</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:446:"[easy_email:recipient_uid:0:entity:display-name]\r\n\r\nA request to cancel your account has been made at [site:name].\r\n\r\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\r\n\r\n[easy_email:recipient_uid:0:entity:cancel-url]\r\n\r\nNOTE: The cancellation of your account is not reversible.\r\n\r\nThis link expires in one day and nothing will happen if it is not used.\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_created_approval_admin', 'a:28:{s:4:"uuid";s:36:"66c2e270-2c9a-4080-90ae-f9413e982e28";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5cKYb7lWoNO7gUjyhPKg1MQPkD8QB_VutMv1JncWDzY";}s:5:"label";s:54:"User: Created - Awaiting Approval - Admin Notification";s:2:"id";s:27:"user_created_approval_admin";s:3:"key";s:0:"";s:9:"recipient";a:1:{i:0;s:11:"[site:mail]";}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:113:"Account details for [easy_email:field_related_user:0:entity:display-name] at [site:name] (pending admin approval)";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:191:"<p>[easy_email:field_related_user:0:entity:display-name] has applied for an account.</p><p><a class="button" href="[easy_email:field_related_user:0:entity:edit-url]">Edit user account</a></p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:134:"[easy_email:field_related_user:0:entity:display-name] has applied for an account.\r\n\r\n[easy_email:field_related_user:0:entity:edit-url]";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_created_awaiting_approval', 'a:28:{s:4:"uuid";s:36:"ed344628-a46a-4533-988e-9a8a789b4b38";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1ZAXZxNQwYxLotq6hm5Um5kzE_yUuYJYZBtbZ4Ij4s8";}s:5:"label";s:33:"User: Created - Awaiting Approval";s:2:"id";s:30:"user_created_awaiting_approval";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:108:"Account details for [easy_email:recipient_uid:0:entity:display-name] at [site:name] (pending admin approval)";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:339:"<p>[easy_email:recipient_uid:0:entity:display-name],</p><p>Thank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:321:"[easy_email:recipient_uid:0:entity:display-name],\r\n\r\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_created_by_admin', 'a:28:{s:4:"uuid";s:36:"99f5063b-a7b4-44e3-9606-28d8358b95d6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Zmd7M6O4e8e4MLmBDlmtGxLjwxZc1fua1Uj5lUQO13M";}s:5:"label";s:32:"User: Created - By Administrator";s:2:"id";s:21:"user_created_by_admin";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:58:"An administrator created an account for you at [site:name]";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:658:"<p>[easy_email:recipient_uid:0:entity:display-name],</p><p>A site administrator at [site:name] has created an account for you. You may now log in by clicking this link:</p><p><a class="button" href="[easy_email:recipient_uid:0:entity:one-time-login-url]">Log in and set your password</a></p><p>This link can only be used once to log in and will lead you to a page where you can set your password.</p><p>After setting your password, you will be able to log in at <a href="[site:login-url]">[site:login-url]</a> in the future using:</p><p>username: [easy_email:recipient_uid:0:entity:account-name]<br>password: Your password</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:581:"[easy_email:recipient_uid:0:entity:display-name],\r\n\r\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[easy_email:recipient_uid:0:entity:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [easy_email:recipient_uid:0:entity:account-name]\r\npassword: Your password\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'easy_email.easy_email_type.user_created_no_approval', 'a:28:{s:4:"uuid";s:36:"e0c62699-ff24-4de0-ae58-528886d33943";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EIjP3woir0yj0CNRD6S0bX1EQZFsthRMMq70YIA9yNo";}s:5:"label";s:36:"User: Created - No Approval Required";s:2:"id";s:24:"user_created_no_approval";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:83:"Account details for [easy_email:recipient_uid:0:entity:display-name] at [site:name]";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:624:"<p>[easy_email:recipient_uid:0:entity:display-name],</p><p>Thank you for registering at [site:name]. You may now log in by clicking this link:</p><p><a class="button" href="[easy_email:recipient_uid:0:entity:one-time-login-url]">Log in and set your password</a></p><p>This link can only be used once to log in and will lead you to a page where you can set your password.</p><p>After setting your password, you will be able to log in at <a href="[site:login-url]">[site:login-url]</a> in the future using:</p><p>username: [easy_email:recipient_uid:0:entity:name]<br>password: Your password</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:547:"[easy_email:recipient_uid:0:entity:display-name],\r\n\r\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[easy_email:recipient_uid:0:entity:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password.\r\n\r\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\r\n\r\nusername: [easy_email:recipient_uid:0:entity:name]\r\npassword: Your password\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.easy_email_type.user_password_recovery', 'a:28:{s:4:"uuid";s:36:"607e2dff-8127-4593-990e-012136a556e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QZnjU2YLRofjL7y_vzHwQId4eJAbgK2TWvFYLsLoqBo";}s:5:"label";s:23:"User: Password Recovery";s:2:"id";s:22:"user_password_recovery";s:3:"key";s:0:"";s:9:"recipient";a:0:{}s:2:"cc";a:0:{}s:3:"bcc";a:0:{}s:8:"fromName";s:0:"";s:11:"fromAddress";s:0:"";s:14:"replyToAddress";s:0:"";s:7:"subject";s:97:"Replacement login information for [easy_email:recipient_uid:0:entity:display-name] at [site:name]";s:12:"inboxPreview";s:0:"";s:8:"bodyHtml";a:2:{s:5:"value";s:518:"<p>[easy_email:recipient_uid:0:entity:display-name],</p><p>A request to reset the password for your account has been made at [site:name].</p><p>You may now log in by clicking this link:</p><p><a class="button" href="[easy_email:recipient_uid:0:entity:one-time-login-url]">Log in and reset your password</a></p><p>This link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it''s not used.</p><p>-- &nbsp;[site:name] team</p>";s:6:"format";s:10:"easy_email";}s:9:"bodyPlain";s:475:"[easy_email:recipient_uid:0:entity:display-name],\r\n\r\nA request to reset the password for your account has been made at [site:name].\r\n\r\nYou may now log in by clicking this link or copying and pasting it into your browser:\r\n\r\n[easy_email:recipient_uid:0:entity:one-time-login-url]\r\n\r\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it''s not used.\r\n\r\n--  [site:name] team";s:17:"generateBodyPlain";b:0;s:10:"attachment";a:0:{}s:14:"saveAttachment";b:0;s:16:"attachmentScheme";s:6:"public";s:19:"attachmentDirectory";s:0:"";s:9:"saveEmail";b:1;s:16:"allowSavingEmail";b:1;s:11:"purgeEmails";b:1;s:13:"purgeInterval";i:30;s:11:"purgePeriod";s:4:"days";}'),
('', 'easy_email.settings', 'a:9:{s:13:"purge_on_cron";b:1;s:16:"purge_cron_limit";i:50;s:24:"allowed_attachment_paths";a:1:{i:0;s:10:"public://*";}s:23:"email_collection_access";b:1;s:29:"allowed_attachment_extensions";a:0:{}s:29:"blocked_attachment_extensions";a:28:{i:0;s:3:"exe";i:1;s:3:"bat";i:2;s:3:"cmd";i:3;s:3:"com";i:4;s:3:"pif";i:5;s:3:"scr";i:6;s:3:"vbs";i:7;s:2:"js";i:8;s:3:"jar";i:9;s:3:"php";i:10;s:4:"php3";i:11;s:4:"php4";i:12;s:4:"php5";i:13;s:5:"phtml";i:14;s:2:"pl";i:15;s:2:"py";i:16;s:3:"cgi";i:17;s:3:"asp";i:18;s:4:"aspx";i:19;s:3:"jsp";i:20;s:2:"sh";i:21;s:4:"bash";i:22;s:3:"zsh";i:23;s:4:"fish";i:24;s:3:"ksh";i:25;s:3:"csh";i:26;s:3:"ps1";i:27;s:2:"vb";}s:29:"allowed_attachment_mime_types";a:0:{}s:29:"blocked_attachment_mime_types";a:10:{i:0;s:24:"application/x-executable";i:1;s:24:"application/x-msdownload";i:2;s:27:"application/x-msdos-program";i:3;s:17:"application/x-msi";i:4;s:17:"application/x-php";i:5;s:10:"text/x-php";i:6;s:23:"application/x-httpd-php";i:7;s:22:"application/javascript";i:8;s:15:"text/javascript";i:9;s:24:"application/x-javascript";}s:19:"max_attachment_size";i:10;}'),
('', 'easy_email_override.easy_email_override.default', 'a:12:{s:4:"uuid";s:36:"49d976d1-c8a4-42d4-92ba-cd6212cf1d1d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"H6fthR3yJNL-OjSAkSQSmH_cnsMKmw1-Jdak1w3-Irw";}s:5:"label";s:7:"Default";s:2:"id";s:7:"default";s:9:"param_map";a:0:{}s:13:"copied_fields";a:9:{s:4:"from";b:1;s:8:"reply_to";b:1;s:2:"to";b:1;s:2:"cc";b:1;s:3:"bcc";b:1;s:7:"subject";b:1;s:9:"body_html";b:1;s:10:"body_plain";b:1;s:11:"attachments";b:1;}s:6:"module";s:1:"*";s:3:"key";s:1:"*";s:15:"easy_email_type";s:7:"default";}'),
('', 'easy_email_override.easy_email_override.user_activation', 'a:12:{s:4:"uuid";s:36:"57280ca3-9fa0-479a-b232-2a83c8d70b1a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iHV3jqNkXYMOf_TEDLGkIUKLyV0stVw2kgHIDVu81lk";}s:5:"label";s:24:"User: Account Activation";s:2:"id";s:15:"user_activation";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:16:"status_activated";s:15:"easy_email_type";s:15:"user_activation";}'),
('', 'easy_email_override.easy_email_override.user_blocked', 'a:12:{s:4:"uuid";s:36:"a1db8438-eba6-44f9-95e0-7113125a15ef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Pi8VIUZ6ALFD4tAtFDfSDWD47xBK5TSP7gJxHREEwNg";}s:5:"label";s:21:"User: Account Blocked";s:2:"id";s:12:"user_blocked";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:14:"status_blocked";s:15:"easy_email_type";s:12:"user_blocked";}'),
('', 'easy_email_override.easy_email_override.user_canceled', 'a:12:{s:4:"uuid";s:36:"60b72ddc-6157-4202-8bea-f25d85052836";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XNp7gpuE22WlY7lXjMrgVyzgw0wXjS3OHTg6HXb0rD8";}s:5:"label";s:22:"User: Account Canceled";s:2:"id";s:13:"user_canceled";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:15:"status_canceled";s:15:"easy_email_type";s:13:"user_canceled";}'),
('', 'easy_email_override.easy_email_override.user_cancellation_confirmation', 'a:12:{s:4:"uuid";s:36:"808b5455-b4a8-45c1-99d3-9384dc5466ce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0tyyL-b-loCmd1m4AvwyJJX1zH3fguElL1364guMj7Q";}s:5:"label";s:39:"User: Account Cancellation Confirmation";s:2:"id";s:30:"user_cancellation_confirmation";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:14:"cancel_confirm";s:15:"easy_email_type";s:30:"user_cancellation_confirmation";}'),
('', 'easy_email_override.easy_email_override.user_created_approval_admin', 'a:12:{s:4:"uuid";s:36:"39830053-7abf-490f-9853-a9128bba7306";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"idEFDx1Ceqeihsw6WQZcrv11Wmrg9Qv9umeNOs3Qvp0";}s:5:"label";s:54:"User: Created - Awaiting Approval - Admin Notification";s:2:"id";s:27:"user_created_approval_admin";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:18:"field_related_user";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:31:"register_pending_approval_admin";s:15:"easy_email_type";s:27:"user_created_approval_admin";}'),
('', 'easy_email_override.easy_email_override.user_created_awaiting_approval', 'a:12:{s:4:"uuid";s:36:"23e53dcb-88e4-46c5-9d4a-38b0e431532c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QN9QzhoJiXRShTGADAWVj7tLGjQeaw0XmiapZ-ByqOI";}s:5:"label";s:33:"User: Created - Awaiting Approval";s:2:"id";s:30:"user_created_awaiting_approval";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:25:"register_pending_approval";s:15:"easy_email_type";s:30:"user_created_awaiting_approval";}'),
('', 'easy_email_override.easy_email_override.user_created_by_admin', 'a:12:{s:4:"uuid";s:36:"45883b2d-6239-4cb7-a96b-5e94027c0287";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nnyPLVusxAhlFozBQli4AvhjUsZMpc7rX4PjyaKQTww";}s:5:"label";s:32:"User: Created - By Administrator";s:2:"id";s:21:"user_created_by_admin";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:22:"register_admin_created";s:15:"easy_email_type";s:21:"user_created_by_admin";}'),
('', 'easy_email_override.easy_email_override.user_created_no_approval', 'a:12:{s:4:"uuid";s:36:"7491b9f9-6ddb-499b-a3aa-732eddb70a66";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1vUqjh87cx6OlhuqMNgqc1liDQgFJs8eMcnRh8ggh7c";}s:5:"label";s:36:"User: Created - No Approval Required";s:2:"id";s:24:"user_created_no_approval";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:29:"register_no_approval_required";s:15:"easy_email_type";s:24:"user_created_no_approval";}'),
('', 'easy_email_override.easy_email_override.user_password_recovery', 'a:12:{s:4:"uuid";s:36:"636b0eea-eecd-4372-a7af-fc75a05c1d9b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gWPZrzr15FUAO595UUFUWE1iQ2yYck326mhSILtUJlg";}s:5:"label";s:23:"User: Password Recovery";s:2:"id";s:22:"user_password_recovery";s:9:"param_map";a:1:{i:0;a:2:{s:6:"source";s:7:"account";s:11:"destination";s:13:"recipient_uid";}}s:13:"copied_fields";a:9:{s:4:"from";b:0;s:8:"reply_to";b:0;s:2:"to";b:0;s:2:"cc";b:0;s:3:"bcc";b:0;s:7:"subject";b:0;s:9:"body_html";b:0;s:10:"body_plain";b:0;s:11:"attachments";b:0;}s:6:"module";s:4:"user";s:3:"key";s:14:"password_reset";s:15:"easy_email_type";s:22:"user_password_recovery";}'),
('', 'eca.eca.auth_redirects', 'a:14:{s:4:"uuid";s:36:"0e49f3e4-0d7e-45fa-a109-c56e6f1344ae";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"eca_user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EMIvsmlHhrhC56f7q_KLtCkAYMX8UBJNY90CqZUUPTg";}s:2:"id";s:14:"auth_redirects";s:8:"modeller";s:7:"bpmn_io";s:5:"label";s:24:"Authentication redirects";s:7:"version";s:5:"1.0.0";s:6:"weight";i:0;s:6:"events";a:1:{s:17:"Event_user_logout";a:4:{s:6:"plugin";s:11:"user:logout";s:5:"label";s:11:"User logout";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:24:"Action_redirect_to_login";s:9:"condition";s:0:"";}}}}s:10:"conditions";a:0:{}s:8:"gateways";a:0:{}s:7:"actions";a:1:{s:24:"Action_redirect_to_login";a:4:{s:6:"plugin";s:18:"action_goto_action";s:5:"label";s:26:"Back to login after logout";s:13:"configuration";a:2:{s:14:"replace_tokens";b:0;s:3:"url";s:11:"/user/login";}s:10:"successors";a:0:{}}}}'),
('', 'eca.eca.content_duplicate', 'a:14:{s:4:"uuid";s:36:"6198222e-7343-4412-bd56-3ac8f9537e65";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:11:"eca_content";i:1;s:8:"eca_misc";i:2;s:10:"eca_render";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BK2tpuGDKOBZZReM5BCWytJU6rhmZZHlQdwR_t2N5aM";}s:2:"id";s:17:"content_duplicate";s:8:"modeller";s:7:"bpmn_io";s:5:"label";s:17:"Duplicate content";s:7:"version";s:5:"1.0.0";s:6:"weight";i:0;s:6:"events";a:3:{s:21:"Event_operations_link";a:4:{s:6:"plugin";s:28:"eca_render:entity_operations";s:5:"label";s:15:"Operation links";s:13:"configuration";a:2:{s:14:"entity_type_id";s:4:"node";s:6:"bundle";s:0:"";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:30:"Activity_duplicate_access_link";s:9:"condition";s:0:"";}}}s:20:"Event_prepare_entity";a:4:{s:6:"plugin";s:26:"content_entity:prepareform";s:5:"label";s:19:"Prepare entity form";s:13:"configuration";a:1:{s:4:"type";s:9:"node _all";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:27:"Activity_load_id_from_query";s:9:"condition";s:0:"";}}}s:23:"Event_alter_local_tasks";a:4:{s:6:"plugin";s:22:"eca_render:local_tasks";s:5:"label";s:16:"Alter local task";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:28:"Activity_load_route_parmeter";s:9:"condition";s:0:"";}}}}s:10:"conditions";a:1:{s:23:"Flow_create_access_link";a:2:{s:6:"plugin";s:24:"eca_entity_is_accessible";s:13:"configuration";a:3:{s:6:"negate";b:0;s:9:"operation";s:6:"create";s:6:"entity";s:4:"temp";}}}s:8:"gateways";a:0:{}s:7:"actions";a:7:{s:17:"Activity_add_link";a:4:{s:6:"plugin";s:16:"eca_render_build";s:5:"label";s:4:"Link";s:13:"configuration";a:6:{s:5:"value";s:108:""#type": link\n"#url": /[entity:entity_type]/add/[entity:bundle_id]?duplicate=[entity:id]\n"#title": Duplicate";s:8:"use_yaml";b:1;s:4:"name";s:0:"";s:10:"token_name";s:0:"";s:6:"weight";s:0:"";s:4:"mode";s:6:"append";}s:10:"successors";a:0:{}}s:20:"Activity_load_entity";a:4:{s:6:"plugin";s:21:"eca_token_load_entity";s:5:"label";s:20:"Load original entity";s:13:"configuration";a:10:{s:10:"token_name";s:8:"original";s:4:"from";s:2:"id";s:11:"entity_type";s:4:"node";s:9:"entity_id";s:4:"[id]";s:11:"revision_id";s:0:"";s:10:"properties";s:0:"";s:8:"langcode";s:10:"_interface";s:15:"latest_revision";b:0;s:9:"unchanged";b:0;s:6:"object";s:6:"entity";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:16:"Activity_message";s:9:"condition";s:0:"";}}}s:16:"Activity_message";a:4:{s:6:"plugin";s:21:"action_message_action";s:5:"label";s:22:"Show duplicate message";s:13:"configuration";a:2:{s:7:"message";s:38:"You are duplicating "[original:label]"";s:14:"replace_tokens";b:1;}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:18:"Activity_duplicate";s:9:"condition";s:0:"";}}}s:18:"Activity_duplicate";a:4:{s:6:"plugin";s:16:"eca_clone_entity";s:5:"label";s:17:"Duplicate content";s:13:"configuration";a:5:{s:10:"token_name";s:6:"entity";s:5:"label";s:0:"";s:9:"published";b:0;s:5:"owner";s:0:"";s:6:"object";s:8:"original";}s:10:"successors";a:0:{}}s:30:"Activity_duplicate_access_link";a:4:{s:6:"plugin";s:16:"eca_clone_entity";s:5:"label";s:9:"Duplicate";s:13:"configuration";a:5:{s:10:"token_name";s:4:"temp";s:5:"label";s:0:"";s:9:"published";b:0;s:5:"owner";s:0:"";s:6:"object";s:6:"entity";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:17:"Activity_add_link";s:9:"condition";s:23:"Flow_create_access_link";}}}s:28:"Activity_load_route_parmeter";a:4:{s:6:"plugin";s:26:"eca_token_load_route_param";s:5:"label";s:20:"Load route parameter";s:13:"configuration";a:3:{s:10:"token_name";s:6:"entity";s:7:"request";s:1:"2";s:14:"parameter_name";s:4:"node";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:30:"Activity_duplicate_access_link";s:9:"condition";s:0:"";}}}s:27:"Activity_load_id_from_query";a:4:{s:6:"plugin";s:24:"eca_token_load_query_arg";s:5:"label";s:14:"Load entity ID";s:13:"configuration";a:2:{s:10:"token_name";s:2:"id";s:13:"argument_name";s:9:"duplicate";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:20:"Activity_load_entity";s:9:"condition";s:0:"";}}}}}'),
('', 'eca.eca.privacy_setting_link', 'a:14:{s:4:"uuid";s:36:"af946129-1c4e-4456-9ebb-aab3f6d54bb7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:4:{i:0;s:8:"eca_base";i:1;s:10:"eca_config";i:2;s:11:"eca_content";i:3;s:8:"eca_user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"kFAslzRrMVj1lXfuTWHtJh9sqhNK6kzcMjroNwNmrjs";}s:2:"id";s:20:"privacy_setting_link";s:8:"modeller";s:7:"bpmn_io";s:5:"label";s:29:"Show link to privacy settings";s:7:"version";s:5:"1.0.0";s:6:"weight";i:0;s:6:"events";a:1:{s:17:"Event_save_config";a:4:{s:6:"plugin";s:11:"config:save";s:5:"label";s:11:"Save config";s:13:"configuration";a:3:{s:11:"config_name";s:0:"";s:9:"sync_mode";s:0:"";s:10:"write_mode";s:0:"";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:14:"Activity_and_1";s:9:"condition";s:14:"Flow_klaro_app";}}}}s:10:"conditions";a:5:{s:14:"Flow_klaro_app";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:6:"negate";b:0;s:4:"case";b:0;s:4:"left";s:13:"[config_name]";s:5:"right";s:16:"klaro.klaro_app.";s:8:"operator";s:10:"beginswith";s:4:"type";s:5:"value";}}s:12:"Flow_enabled";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:6:"negate";b:0;s:4:"case";b:0;s:4:"left";s:15:"[config:status]";s:5:"right";s:1:"1";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";}}s:17:"Flow_was_disabled";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:4:"case";b:0;s:4:"left";s:24:"[config_original:status]";s:5:"right";s:1:"1";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";s:6:"negate";b:1;}}s:13:"Flow_disabled";a:2:{s:6:"plugin";s:22:"eca_entity_field_value";s:13:"configuration";a:7:{s:4:"case";b:0;s:14:"expected_value";s:1:"1";s:10:"field_name";s:7:"enabled";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";s:6:"negate";b:1;s:6:"entity";s:8:"menulink";}}s:17:"Flow_not_required";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:4:"case";b:0;s:4:"left";s:17:"[config:required]";s:5:"right";s:1:"1";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";s:6:"negate";b:1;}}}s:8:"gateways";a:0:{}s:7:"actions";a:5:{s:14:"Activity_and_1";a:4:{s:6:"plugin";s:22:"eca_void_and_condition";s:5:"label";s:3:"AND";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:14:"Activity_and_2";s:9:"condition";s:12:"Flow_enabled";}}}s:14:"Activity_and_2";a:4:{s:6:"plugin";s:22:"eca_void_and_condition";s:5:"label";s:3:"AND";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:14:"Activity_and_3";s:9:"condition";s:17:"Flow_was_disabled";}}}s:14:"Activity_and_3";a:4:{s:6:"plugin";s:18:"eca_switch_account";s:5:"label";s:16:"Switch to user 1";s:13:"configuration";a:1:{s:7:"user_id";s:1:"1";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:23:"Activity_load_menu_link";s:9:"condition";s:17:"Flow_not_required";}}}s:23:"Activity_load_menu_link";a:4:{s:6:"plugin";s:21:"eca_token_load_entity";s:5:"label";s:14:"Load menu link";s:13:"configuration";a:10:{s:10:"token_name";s:8:"menulink";s:4:"from";s:10:"properties";s:11:"entity_type";s:17:"menu_link_content";s:9:"entity_id";s:0:"";s:11:"revision_id";s:0:"";s:10:"properties";s:42:"uuid: d7f4f1b2-af94-46b8-ac63-a8a5b14fb0f5";s:8:"langcode";s:10:"_interface";s:15:"latest_revision";b:0;s:9:"unchanged";b:0;s:6:"object";s:0:"";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:25:"Activity_enable_menu_link";s:9:"condition";s:13:"Flow_disabled";}}}s:25:"Activity_enable_menu_link";a:4:{s:6:"plugin";s:19:"eca_set_field_value";s:5:"label";s:16:"Enable menu link";s:13:"configuration";a:7:{s:10:"field_name";s:7:"enabled";s:11:"field_value";s:1:"1";s:6:"method";s:9:"set:clear";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:11:"save_entity";b:1;s:6:"object";s:8:"menulink";}s:10:"successors";a:0:{}}}}'),
('', 'eca.eca.remote_video_consent', 'a:14:{s:4:"uuid";s:36:"1255d2f3-d267-4ff4-af16-5ff34d1f81e3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"media.type.remote_video";}s:6:"module";a:4:{i:0;s:8:"eca_base";i:1;s:10:"eca_config";i:2;s:11:"eca_content";i:3;s:8:"eca_user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Ar_MbwS1e-DzQ3cQsroO3yEBLMLBtepj4Z_jI0H0QVY";}s:2:"id";s:20:"remote_video_consent";s:8:"modeller";s:7:"bpmn_io";s:5:"label";s:42:"Enable consent management for remote video";s:7:"version";s:5:"1.0.0";s:6:"weight";i:0;s:6:"events";a:2:{s:25:"Event_insert_remote_video";a:4:{s:6:"plugin";s:21:"content_entity:insert";s:5:"label";s:19:"Insert remote video";s:13:"configuration";a:1:{s:4:"type";s:18:"media remote_video";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:29:"Activity_set_default_provider";s:9:"condition";s:0:"";}}}s:17:"Event_save_config";a:4:{s:6:"plugin";s:11:"config:save";s:5:"label";s:11:"Save config";s:13:"configuration";a:3:{s:11:"config_name";s:0:"";s:9:"sync_mode";s:0:"";s:10:"write_mode";s:0:"";}s:10:"successors";a:2:{i:0;a:2:{s:2:"id";s:14:"Activity_and_1";s:9:"condition";s:15:"Flow_is_youtube";}i:1;a:2:{s:2:"id";s:14:"Activity_and_1";s:9:"condition";s:7:"Flow_is";}}}}s:10:"conditions";a:6:{s:13:"Flow_is_vimeo";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:6:"negate";b:0;s:4:"case";b:0;s:4:"left";s:32:"[media:field_media_oembed_video]";s:5:"right";s:9:"vimeo.com";s:8:"operator";s:8:"contains";s:4:"type";s:5:"value";}}s:25:"Flow_is_provider_disabled";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:4:"case";b:0;s:4:"left";s:8:"[status]";s:5:"right";s:1:"1";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";s:6:"negate";b:1;}}s:15:"Flow_is_youtube";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:6:"negate";b:0;s:4:"case";b:0;s:4:"left";s:13:"[config_name]";s:5:"right";s:23:"klaro.klaro_app.youtube";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";}}s:7:"Flow_is";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:6:"negate";b:0;s:4:"case";b:0;s:4:"left";s:13:"[config_name]";s:5:"right";s:21:"klaro.klaro_app.vimeo";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";}}s:13:"Flow_disabled";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:4:"case";b:0;s:4:"left";s:15:"[config:status]";s:5:"right";s:1:"1";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";s:6:"negate";b:1;}}s:16:"Flow_was_enabled";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:6:"negate";b:0;s:4:"case";b:0;s:4:"left";s:24:"[config_original:status]";s:5:"right";s:1:"1";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";}}}s:8:"gateways";a:0:{}s:7:"actions";a:10:{s:29:"Activity_set_default_provider";a:4:{s:6:"plugin";s:19:"eca_token_set_value";s:5:"label";s:31:"Set default provider to YouTube";s:13:"configuration";a:3:{s:10:"token_name";s:8:"provider";s:11:"token_value";s:7:"youtube";s:8:"use_yaml";b:0;}s:10:"successors";a:2:{i:0;a:2:{s:2:"id";s:27:"Activity_set_vimeo_provider";s:9:"condition";s:13:"Flow_is_vimeo";}i:1;a:2:{s:2:"id";s:20:"Activity_switch_user";s:9:"condition";s:0:"";}}}s:27:"Activity_set_vimeo_provider";a:4:{s:6:"plugin";s:19:"eca_token_set_value";s:5:"label";s:21:"Set provider to Vimeo";s:13:"configuration";a:3:{s:10:"token_name";s:8:"provider";s:11:"token_value";s:5:"vimeo";s:8:"use_yaml";b:0;}s:10:"successors";a:0:{}}s:29:"Activity_read_current_setting";a:4:{s:6:"plugin";s:15:"eca_config_read";s:5:"label";s:20:"Read current setting";s:13:"configuration";a:4:{s:10:"token_name";s:6:"status";s:18:"include_overridden";b:1;s:11:"config_name";s:26:"klaro.klaro_app.[provider]";s:10:"config_key";s:6:"status";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:24:"Activity_enable_provider";s:9:"condition";s:25:"Flow_is_provider_disabled";}}}s:24:"Activity_enable_provider";a:4:{s:6:"plugin";s:16:"eca_config_write";s:5:"label";s:15:"Enable provider";s:13:"configuration";a:5:{s:12:"config_value";s:1:"1";s:8:"use_yaml";b:0;s:11:"save_config";b:1;s:11:"config_name";s:26:"klaro.klaro_app.[provider]";s:10:"config_key";s:6:"status";}s:10:"successors";a:0:{}}s:20:"Activity_switch_user";a:4:{s:6:"plugin";s:18:"eca_switch_account";s:5:"label";s:19:"Switch user account";s:13:"configuration";a:1:{s:7:"user_id";s:1:"1";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:29:"Activity_read_current_setting";s:9:"condition";s:0:"";}}}s:14:"Activity_and_1";a:4:{s:6:"plugin";s:22:"eca_void_and_condition";s:5:"label";s:3:"AND";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:14:"Activity_and_2";s:9:"condition";s:13:"Flow_disabled";}}}s:14:"Activity_and_2";a:4:{s:6:"plugin";s:22:"eca_void_and_condition";s:5:"label";s:3:"AND";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:16:"Activity_switch_";s:9:"condition";s:16:"Flow_was_enabled";}}}s:27:"Activity_re_enable_provider";a:4:{s:6:"plugin";s:16:"eca_config_write";s:5:"label";s:18:"Re-enable provider";s:13:"configuration";a:5:{s:12:"config_value";s:1:"1";s:8:"use_yaml";b:0;s:11:"save_config";b:1;s:11:"config_name";s:13:"[config_name]";s:10:"config_key";s:6:"status";}s:10:"successors";a:0:{}}s:16:"Activity_switch_";a:4:{s:6:"plugin";s:18:"eca_switch_account";s:5:"label";s:11:"Switch user";s:13:"configuration";a:1:{s:7:"user_id";s:1:"1";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:16:"Activity_0rno7mm";s:9:"condition";s:0:"";}}}s:16:"Activity_0rno7mm";a:4:{s:6:"plugin";s:21:"eca_token_load_entity";s:5:"label";s:19:"Load a remote video";s:13:"configuration";a:10:{s:10:"token_name";s:5:"video";s:4:"from";s:10:"properties";s:11:"entity_type";s:5:"media";s:9:"entity_id";s:0:"";s:11:"revision_id";s:0:"";s:10:"properties";s:20:"bundle: remote_video";s:8:"langcode";s:10:"_interface";s:15:"latest_revision";b:0;s:9:"unchanged";b:0;s:6:"object";s:0:"";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:27:"Activity_re_enable_provider";s:9:"condition";s:0:"";}}}}}'),
('', 'eca.eca.unpublished_404', 'a:14:{s:4:"uuid";s:36:"f6fd46a0-0bef-4bb1-8133-fb7afadbf82c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:4:{i:0;s:8:"eca_base";i:1;s:11:"eca_content";i:2;s:8:"eca_misc";i:3;s:8:"eca_user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yTrWRUJ0MTfHyHgtVLlFBbFtUzss0dvA6O08vWM8fX4";}s:2:"id";s:15:"unpublished_404";s:8:"modeller";s:7:"bpmn_io";s:5:"label";s:15:"Unpublished 404";s:7:"version";s:5:"1.0.0";s:6:"weight";i:0;s:6:"events";a:1:{s:24:"Event_uncaught_exception";a:4:{s:6:"plugin";s:28:"kernel:exception_status_code";s:5:"label";s:18:"Uncaught Exception";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:12:"Activity_and";s:9:"condition";s:11:"Flow_is_403";}}}}s:10:"conditions";a:2:{s:11:"Flow_is_403";a:2:{s:6:"plugin";s:10:"eca_scalar";s:13:"configuration";a:6:{s:6:"negate";b:0;s:4:"case";b:0;s:4:"left";s:12:"[event:code]";s:5:"right";s:3:"403";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";}}s:16:"Flow_unpublished";a:2:{s:6:"plugin";s:22:"eca_entity_field_value";s:13:"configuration";a:7:{s:4:"case";b:0;s:14:"expected_value";s:1:"1";s:10:"field_name";s:6:"status";s:8:"operator";s:5:"equal";s:4:"type";s:5:"value";s:6:"negate";b:1;s:6:"entity";s:4:"node";}}}s:8:"gateways";a:0:{}s:7:"actions";a:4:{s:12:"Activity_and";a:4:{s:6:"plugin";s:22:"eca_void_and_condition";s:5:"label";s:3:"AND";s:13:"configuration";a:0:{}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:22:"Activity_switch_user_1";s:9:"condition";s:0:"";}}}s:22:"Activity_switch_user_1";a:4:{s:6:"plugin";s:18:"eca_switch_account";s:5:"label";s:16:"Switch to user 1";s:13:"configuration";a:1:{s:7:"user_id";s:1:"1";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:29:"Activity_load_node_from_route";s:9:"condition";s:0:"";}}}s:29:"Activity_load_node_from_route";a:4:{s:6:"plugin";s:26:"eca_token_load_route_param";s:5:"label";s:20:"Load node from route";s:13:"configuration";a:3:{s:10:"token_name";s:4:"node";s:7:"request";s:1:"2";s:14:"parameter_name";s:4:"node";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:28:"Activity_not_found_exception";s:9:"condition";s:16:"Flow_unpublished";}}}s:28:"Activity_not_found_exception";a:4:{s:6:"plugin";s:19:"eca_throw_exception";s:5:"label";s:19:"Not found exception";s:13:"configuration";a:3:{s:14:"exception_type";s:60:"Symfony\\Component\\HttpKernel\\Exception\\NotFoundHttpException";s:16:"response_message";s:0:"";s:13:"log_exception";b:0;}s:10:"successors";a:0:{}}}}'),
('', 'eca.eca.user_register', 'a:14:{s:4:"uuid";s:36:"adea79d6-47ab-45bd-9edd-d44852a707c5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:8:"eca_base";i:1;s:8:"eca_form";i:2;s:8:"eca_user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uwBLat3LuK8xV6FR2dAUmZCaGcc3ra67YKA3gNc3Bfc";}s:2:"id";s:13:"user_register";s:8:"modeller";s:7:"bpmn_io";s:5:"label";s:17:"User registration";s:7:"version";s:5:"1.0.1";s:6:"weight";i:0;s:6:"events";a:2:{s:25:"Event_build_user_reg_form";a:4:{s:6:"plugin";s:15:"form:form_build";s:5:"label";s:24:"Build user register form";s:13:"configuration";a:4:{s:7:"form_id";s:18:"user-register-form";s:14:"entity_type_id";s:0:"";s:6:"bundle";s:0:"";s:9:"operation";s:0:"";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:24:"Activity_set_weight_mail";s:9:"condition";s:12:"Flow_0x4d8cz";}}}s:28:"Event_validate_user_reg_form";a:4:{s:6:"plugin";s:18:"form:form_validate";s:5:"label";s:27:"Validate user register form";s:13:"configuration";a:4:{s:7:"form_id";s:18:"user-register-form";s:14:"entity_type_id";s:0:"";s:6:"bundle";s:0:"";s:9:"operation";s:0:"";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:15:"Gateway_0esk9dm";s:9:"condition";s:14:"Flow_notify_on";}}}}s:10:"conditions";a:3:{s:12:"Flow_0x4d8cz";a:2:{s:6:"plugin";s:19:"eca_current_user_id";s:13:"configuration";a:2:{s:7:"user_id";s:1:"0";s:6:"negate";b:1;}}s:14:"Flow_notify_on";a:2:{s:6:"plugin";s:20:"eca_form_field_value";s:13:"configuration";a:9:{s:6:"negate";b:0;s:4:"case";b:0;s:11:"field_value";s:1:"1";s:10:"field_name";s:6:"notify";s:10:"strip_tags";b:1;s:4:"trim";b:1;s:10:"xss_filter";b:1;s:8:"operator";s:5:"equal";s:4:"type";s:7:"numeric";}}s:12:"Flow_0xwcjpm";a:2:{s:6:"plugin";s:19:"eca_current_user_id";s:13:"configuration";a:2:{s:7:"user_id";s:1:"0";s:6:"negate";b:1;}}}s:8:"gateways";a:1:{s:15:"Gateway_0esk9dm";a:2:{s:4:"type";i:0;s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:26:"Activity_get_random_string";s:9:"condition";s:12:"Flow_0xwcjpm";}}}}s:7:"actions";a:11:{s:36:"Activity_password_field_not_required";a:4:{s:6:"plugin";s:22:"eca_form_field_require";s:5:"label";s:28:"Set password as not required";s:13:"configuration";a:2:{s:4:"flag";b:0;s:10:"field_name";s:4:"pass";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:33:"Activity_invisible_state_password";s:9:"condition";s:0:"";}}}s:26:"Activity_get_random_string";a:4:{s:6:"plugin";s:26:"eca_token_set_random_value";s:5:"label";s:17:"Get random string";s:13:"configuration";a:3:{s:10:"token_name";s:8:"password";s:4:"mode";s:8:"password";s:6:"length";s:2:"15";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:21:"Activity_set_password";s:9:"condition";s:0:"";}}}s:21:"Activity_set_password";a:4:{s:6:"plugin";s:24:"eca_form_field_set_value";s:5:"label";s:12:"Set password";s:13:"configuration";a:7:{s:11:"field_value";s:10:"[password]";s:8:"use_yaml";b:0;s:13:"validate_yaml";b:0;s:10:"field_name";s:4:"pass";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:10:"xss_filter";b:0;}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:19:"Activity_set_status";s:9:"condition";s:0:"";}}}s:24:"Activity_set_weight_mail";a:4:{s:6:"plugin";s:25:"eca_form_field_set_weight";s:5:"label";s:19:"Set weight for mail";s:13:"configuration";a:2:{s:6:"weight";s:3:"-10";s:10:"field_name";s:4:"mail";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:24:"Activity_set_weight_name";s:9:"condition";s:0:"";}}}s:24:"Activity_set_weight_name";a:4:{s:6:"plugin";s:25:"eca_form_field_set_weight";s:5:"label";s:19:"Set weight for name";s:13:"configuration";a:2:{s:6:"weight";s:2:"-9";s:10:"field_name";s:4:"name";}s:10:"successors";a:1:{i:0;a:2:{s:2:"id";s:26:"Activity_set_weight_notify";s:9:"condition";s:0:"";}}}s:26:"Activity_set_weight_notify";a:4:{s:6:"plugin";s:25:"eca_form_field_set_weight";s:5:"label";s:21:"Set weight for notify";s:13:"configuration";a:2:{s:6:"weight";s:2:"-8";s:10:"field_name";s:6:"notify";}s:10:"successors";a:2:{i:0;a:2:{s:2:"id";s:28:"Activity_set_weight_password";s:9:"condition";s:0:"";}i:1;a:2:{s:2:"id";s:22:"Activity_enable_notify";s:9:"condition";s:0:"";}}}s:28:"Activity_set_weight_password";a:4:{s:6:"plugin";s:25:"eca_form_field_set_weight";s:5:"label";s:23:"Set weight for password";s:13:"configuration";a:2:{s:6:"weight";s:2:"-7";s:10:"field_name";s:4:"pass";}s:10:"successors";a:2:{i:0;a:2:{s:2:"id";s:36:"Activity_password_field_not_required";s:9:"condition";s:0:"";}i:1;a:2:{s:2:"id";s:31:"Activity_invisible_state_status";s:9:"condition";s:0:"";}}}s:22:"Activity_enable_notify";a:4:{s:6:"plugin";s:28:"eca_form_field_default_value";s:5:"label";s:24:"Enable notify by default";s:13:"configuration";a:5:{s:5:"value";s:1:"1";s:10:"field_name";s:6:"notify";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:10:"xss_filter";b:0;}s:10:"successors";a:0:{}}s:31:"Activity_invisible_state_status";a:4:{s:6:"plugin";s:24:"eca_form_field_add_state";s:5:"label";s:30:"Add invisible state for status";s:13:"configuration";a:5:{s:8:"selector";s:21:":input[name="notify"]";s:5:"state";s:9:"invisible";s:9:"condition";s:7:"checked";s:5:"value";s:0:"";s:10:"field_name";s:6:"status";}s:10:"successors";a:0:{}}s:33:"Activity_invisible_state_password";a:4:{s:6:"plugin";s:24:"eca_form_field_add_state";s:5:"label";s:32:"Add invisible state for password";s:13:"configuration";a:5:{s:8:"selector";s:21:":input[name="notify"]";s:5:"state";s:9:"invisible";s:9:"condition";s:7:"checked";s:5:"value";s:0:"";s:10:"field_name";s:4:"pass";}s:10:"successors";a:0:{}}s:19:"Activity_set_status";a:4:{s:6:"plugin";s:24:"eca_form_field_set_value";s:5:"label";s:10:"Set status";s:13:"configuration";a:7:{s:11:"field_value";s:1:"1";s:8:"use_yaml";b:0;s:13:"validate_yaml";b:0;s:10:"field_name";s:6:"status";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:10:"xss_filter";b:0;}s:10:"successors";a:0:{}}}}'),
('', 'eca.settings', 'a:5:{s:9:"log_level";i:3;s:20:"documentation_domain";s:20:"https://ecaguide.org";s:4:"user";s:0:"";s:12:"service_user";s:0:"";s:22:"dependency_calculation";a:4:{i:0;s:6:"bundle";i:1;s:13:"field_storage";i:2;s:12:"field_config";i:3;s:16:"new_field_config";}}'),
('', 'editor.editor.content_format', 'a:9:{s:4:"uuid";s:36:"accba397-e27f-4a38-90b6-e66fcafbb2db";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:28:"filter.format.content_format";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"qwkf8fM0BRjtexKpH3GhUROBbX7wsKZLW4i31gbA1Ss";}s:6:"format";s:14:"content_format";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:16:{i:0;s:7:"heading";i:1;s:4:"bold";i:2;s:6:"italic";i:3;s:10:"blockQuote";i:4;s:4:"link";i:5;s:12:"bulletedList";i:6;s:12:"numberedList";i:7;s:6:"indent";i:8;s:7:"outdent";i:9;s:9:"alignment";i:10;s:11:"insertTable";i:11;s:11:"drupalMedia";i:12;s:4:"undo";i:13;s:4:"redo";i:14;s:12:"removeFormat";i:15;s:13:"sourceEditing";}}s:7:"plugins";a:6:{s:19:"ckeditor5_alignment";a:1:{s:18:"enabled_alignments";a:4:{i:0;s:6:"center";i:1;s:7:"justify";i:2;s:4:"left";i:3;s:5:"right";}}s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:14:"ckeditor5_list";a:2:{s:10:"properties";a:2:{s:8:"reversed";b:1;s:10:"startIndex";b:1;}s:10:"multiBlock";b:1;}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}s:16:"linkit_extension";a:2:{s:14:"linkit_enabled";b:1;s:14:"linkit_profile";s:7:"default";}s:11:"media_media";a:1:{s:24:"allow_view_mode_override";b:1;}}}s:12:"image_upload";a:1:{s:6:"status";b:0;}}'),
('', 'editor.editor.easy_email', 'a:9:{s:4:"uuid";s:36:"90da01ea-0382-45ca-a8a4-2ab0cd64c456";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.easy_email";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"G5aONEl8U2TXgEmMrqQa5uwYWtdC4Y5JsOvQz-GybHc";}s:6:"format";s:10:"easy_email";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:27:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:9:"underline";i:3;s:13:"strikethrough";i:4;s:11:"superscript";i:5;s:9:"subscript";i:6;s:1:"|";i:7;s:9:"alignment";i:8;s:1:"|";i:9;s:4:"link";i:10;s:1:"|";i:11;s:12:"bulletedList";i:12;s:12:"numberedList";i:13;s:6:"indent";i:14;s:7:"outdent";i:15;s:1:"|";i:16;s:10:"blockQuote";i:17;s:17:"drupalInsertImage";i:18;s:11:"insertTable";i:19;s:14:"horizontalLine";i:20;s:1:"|";i:21;s:7:"heading";i:22;s:1:"|";i:23;s:13:"sourceEditing";i:24;s:1:"|";i:25;s:12:"removeFormat";i:26;s:17:"specialCharacters";}}s:7:"plugins";a:5:{s:19:"ckeditor5_alignment";a:1:{s:18:"enabled_alignments";a:4:{i:0;s:6:"center";i:1;s:7:"justify";i:2;s:4:"left";i:3;s:5:"right";}}s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}s:14:"ckeditor5_list";a:2:{s:10:"properties";a:2:{s:8:"reversed";b:1;s:10:"startIndex";b:1;}s:10:"multiBlock";b:1;}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";N;s:14:"max_dimensions";a:2:{s:5:"width";N;s:6:"height";N;}}}'),
('', 'field.field.easy_email.user_created_approval_admin.field_related_user', 'a:17:{s:4:"uuid";s:36:"905ac2ec-5083-4064-b8df-ff6b3b0b7d8f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:54:"easy_email.easy_email_type.user_created_approval_admin";i:1;s:43:"field.storage.easy_email.field_related_user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"65DZt38D5YhSUrwHCukU0blnWZpB6UWTzq9V_riuL0U";}s:2:"id";s:57:"easy_email.user_created_approval_admin.field_related_user";s:10:"field_name";s:18:"field_related_user";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";s:27:"user_created_approval_admin";s:5:"label";s:12:"Related User";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:12:"default:user";s:16:"handler_settings";a:5:{s:14:"target_bundles";N;s:4:"sort";a:2:{s:5:"field";s:5:"_none";s:9:"direction";s:3:"ASC";}s:11:"auto_create";b:0;s:6:"filter";a:1:{s:4:"type";s:5:"_none";}s:17:"include_anonymous";b:0;}}s:10:"field_type";s:16:"entity_reference";}'),
('', 'field.field.media.document.field_media_document', 'a:17:{s:4:"uuid";s:36:"11d66af4-148d-44af-9cc9-e84955142bb3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:40:"field.storage.media.field_media_document";i:1;s:19:"media.type.document";}s:6:"module";a:1:{i:0;s:4:"file";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DY5HtJTxUjFRGU_PaY6ifo2nhR-nAZ0y0s6kLmUbv5g";}s:2:"id";s:35:"media.document.field_media_document";s:10:"field_name";s:20:"field_media_document";s:11:"entity_type";s:5:"media";s:6:"bundle";s:8:"document";s:5:"label";s:8:"Document";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:6:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:96:"txt rtf doc docx ppt pptx xls xlsx pdf odf odg odp ods odt fodt fods fodp fodg key numbers pages";s:12:"max_filesize";s:0:"";s:17:"description_field";b:0;}s:10:"field_type";s:4:"file";}'),
('', 'field.field.media.image.field_media_image', 'a:17:{s:4:"uuid";s:36:"62842215-4e1f-43ce-851d-38a28450a106";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:37:"field.storage.media.field_media_image";i:1;s:16:"media.type.image";}s:6:"module";a:1:{i:0;s:5:"image";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"P7CkVOgjDXiN26Fm2hniNei-XPK3iuZTlcBGqreTbJ0";}s:2:"id";s:29:"media.image.field_media_image";s:10:"field_name";s:17:"field_media_image";s:11:"entity_type";s:5:"media";s:6:"bundle";s:5:"image";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:21:"png gif jpg jpeg webp";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}'),
('', 'field.field.media.remote_video.field_media_oembed_video', 'a:17:{s:4:"uuid";s:36:"a55fbe01-046e-4377-b325-d69764dcb2a7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:44:"field.storage.media.field_media_oembed_video";i:1;s:23:"media.type.remote_video";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Eo4HHenV5iZat_kEWgr_wydD3TgwURMCzwt-7qIEyoM";}s:2:"id";s:43:"media.remote_video.field_media_oembed_video";s:10:"field_name";s:24:"field_media_oembed_video";s:11:"entity_type";s:5:"media";s:6:"bundle";s:12:"remote_video";s:5:"label";s:9:"Video URL";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:6:"string";}'),
('', 'field.field.media.svg_image.field_media_svg_image', 'a:17:{s:4:"uuid";s:36:"ef8bfa0b-7b62-4c83-a6ac-9b3cd07adaa1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:41:"field.storage.media.field_media_svg_image";i:1;s:20:"media.type.svg_image";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zeCRqFlYGhwWjUDHIiANbncreBJ1ADyW-VdyccSUBTs";}s:2:"id";s:37:"media.svg_image.field_media_svg_image";s:10:"field_name";s:21:"field_media_svg_image";s:11:"entity_type";s:5:"media";s:6:"bundle";s:9:"svg_image";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:3:"svg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}'),
('', 'field.field.node.page.field_content', 'a:17:{s:4:"uuid";s:36:"c481a546-fa9b-4605-ba29-eb4e635b82b8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:32:"field.storage.node.field_content";i:1;s:28:"filter.format.content_format";i:2;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_5V-RqipdviPFL737_mD5u0cYh_cuh_FcpFOEZvFj50";}s:2:"id";s:23:"node.page.field_content";s:10:"field_name";s:13:"field_content";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:7:"Content";s:11:"description";s:25:"The content of this page.";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:1:{s:15:"allowed_formats";a:1:{i:0;s:14:"content_format";}}s:10:"field_type";s:9:"text_long";}'),
('', 'field.field.node.page.field_description', 'a:17:{s:4:"uuid";s:36:"c3cfa3c9-d7c5-4ba9-80a1-94422fc61edb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:2:{i:0;s:36:"field.storage.node.field_description";i:1;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cNlFl-oRIOsqwCDvw0RGnOEdWtwcp0WgKTsZXtuZ63E";}s:2:"id";s:27:"node.page.field_description";s:10:"field_name";s:17:"field_description";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:11:"Description";s:11:"description";s:84:"Describe the page content. This appears as the description in search engine results.";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:11:"string_long";}'),
('', 'field.field.node.page.field_featured_image', 'a:17:{s:4:"uuid";s:36:"85fa0b14-4e51-4c49-8a63-3145eeb8fc37";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:39:"field.storage.node.field_featured_image";i:1;s:16:"media.type.image";i:2;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iApO7kSzb-V6JYndmSzDzAWJ0-6Q9QlA67AmN7Yp8io";}s:2:"id";s:30:"node.page.field_featured_image";s:10:"field_name";s:20:"field_featured_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:14:"Featured image";s:11:"description";s:69:"Include an image. This appears as the image in search engine results.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:13:"default:media";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:5:"image";s:5:"image";}s:4:"sort";a:2:{s:5:"field";s:5:"_none";s:9:"direction";s:3:"ASC";}s:11:"auto_create";b:0;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}'),
('', 'field.field.node.page.field_tags', 'a:17:{s:4:"uuid";s:36:"974ee4d6-cdea-413e-b2b4-ad65aeb0f0e2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:14:"node.type.page";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CZielLnZ_HpghhaDcyCvCe2H_dwoqo3rN3-cBxfrpA0";}s:2:"id";s:20:"node.page.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Tags";s:11:"description";s:33:"Include tags for relevant topics.";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:4:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:2:{s:5:"field";s:4:"name";s:9:"direction";s:3:"asc";}s:11:"auto_create";b:1;s:18:"auto_create_bundle";s:0:"";}}s:10:"field_type";s:16:"entity_reference";}'),
('', 'field.field.node.page.layout_builder__layout', 'a:17:{s:4:"uuid";s:36:"91a16d6c-560b-46b5-af6c-6d5347451c15";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:41:"field.storage.node.layout_builder__layout";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:14:"layout_builder";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eO3IlWQ07nkmufMLXVNK0-yc6ZbdfzfFtsw_cr4r2f8";}s:2:"id";s:32:"node.page.layout_builder__layout";s:10:"field_name";s:22:"layout_builder__layout";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:6:"Layout";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:14:"layout_section";}'),
('', 'field.settings', 'a:1:{s:16:"purge_batch_size";i:50;}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'field.storage.easy_email.field_related_user', 'a:17:{s:4:"uuid";s:36:"213df2a9-561c-423e-8908-0f0525bc290a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:10:"easy_email";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"o5KZRiEHScznNR5RsW8h1ahlZgOpLK0EZqNOCLAdlrA";}s:2:"id";s:29:"easy_email.field_related_user";s:10:"field_name";s:18:"field_related_user";s:11:"entity_type";s:10:"easy_email";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:4:"user";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.media.field_media_document', 'a:17:{s:4:"uuid";s:36:"c59a39d2-cc93-4b65-9ec2-c1873794c383";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BdkTx7IL59MCw5a_fOZprPTOGM_wcjz-Fm8g7HV3vFk";}s:2:"id";s:26:"media.field_media_document";s:10:"field_name";s:20:"field_media_document";s:11:"entity_type";s:5:"media";s:4:"type";s:4:"file";s:8:"settings";a:4:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";}s:6:"module";s:4:"file";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.media.field_media_image', 'a:17:{s:4:"uuid";s:36:"b22a4ff6-7a92-473c-b10b-cf0786213e7a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:5:"media";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0N0KSFk57p6qsq3qM4lYVGSuROvzXK-tSsdwByqUh3g";}s:2:"id";s:23:"media.field_media_image";s:10:"field_name";s:17:"field_media_image";s:11:"entity_type";s:5:"media";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.media.field_media_oembed_video', 'a:17:{s:4:"uuid";s:36:"5a1b7610-0302-4908-baf4-d76f9c0ac750";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cNf_852Dq-fNnSaMI4LxL-J6N7bLkHuDbD9EUqOn4_U";}s:2:"id";s:30:"media.field_media_oembed_video";s:10:"field_name";s:24:"field_media_oembed_video";s:11:"entity_type";s:5:"media";s:4:"type";s:6:"string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:14:"case_sensitive";b:0;s:8:"is_ascii";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.media.field_media_svg_image', 'a:17:{s:4:"uuid";s:36:"edb9c6d0-874a-4e22-ac3c-90c25302498f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jCafpTnKdKBGPBW2pIJD5w0ecIHvavTp-dO9YA61eDI";}s:2:"id";s:27:"media.field_media_svg_image";s:10:"field_name";s:21:"field_media_svg_image";s:11:"entity_type";s:5:"media";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";s:0:"";s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_content', 'a:17:{s:4:"uuid";s:36:"269fe3c0-62fa-45a2-912e-94c224e168b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TCp4LZaLZP1BvDKV-smwg65LNdYOjGR4VT0lqcx__h8";}s:2:"id";s:18:"node.field_content";s:10:"field_name";s:13:"field_content";s:11:"entity_type";s:4:"node";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_description', 'a:17:{s:4:"uuid";s:36:"62c02011-b5b4-49ab-b2aa-0835bda5ecb2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3AS87dwrSU77oczdhjjhtLjbTP7KRQLnp3_GEpGImFc";}s:2:"id";s:22:"node.field_description";s:10:"field_name";s:17:"field_description";s:11:"entity_type";s:4:"node";s:4:"type";s:11:"string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_featured_image', 'a:17:{s:4:"uuid";s:36:"9891d3a9-69da-461c-8656-222ba08751c5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"media";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ij5NA5OrfuoaOPfx4KE3NT0oi0EnokhZweXx3iDOI4w";}s:2:"id";s:25:"node.field_featured_image";s:10:"field_name";s:20:"field_featured_image";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:5:"media";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_tags', 'a:17:{s:4:"uuid";s:36:"c95a2c96-1f88-489f-b14d-5937662fbb4c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.layout_builder__layout', 'a:17:{s:4:"uuid";s:36:"9a3af57a-8347-435b-810e-2fb5c3ecd1ae";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:14:"layout_builder";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"g7kepf2eck__olXZwnmcQdOVAdSZR0cr77Jm-uf6wfA";}s:2:"id";s:27:"node.layout_builder__layout";s:10:"field_name";s:22:"layout_builder__layout";s:11:"entity_type";s:4:"node";s:4:"type";s:14:"layout_section";s:8:"settings";a:0:{}s:6:"module";s:14:"layout_builder";s:6:"locked";b:1;s:11:"cardinality";i:1;s:12:"translatable";b:0;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field_ui.settings', 'a:1:{s:12:"field_prefix";s:6:"field_";}'),
('', 'file.settings', 'a:4:{s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;s:21:"filename_sanitization";a:6:{s:13:"transliterate";b:0;s:18:"replace_whitespace";b:0;s:24:"replace_non_alphanumeric";b:0;s:22:"deduplicate_separators";b:0;s:9:"lowercase";b:0;s:21:"replacement_character";s:1:"-";}}'),
('', 'filter.format.content_format', 'a:9:{s:4:"uuid";s:36:"76d40409-ee18-446a-a7d6-58a8be6c210b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:12:{i:0;s:39:"core.entity_view_mode.media.16_9_medium";i:1;s:38:"core.entity_view_mode.media.16_9_small";i:2;s:45:"core.entity_view_mode.media.1_1_square_medium";i:3;s:44:"core.entity_view_mode.media.1_1_square_small";i:4;s:38:"core.entity_view_mode.media.3_4_medium";i:5;s:37:"core.entity_view_mode.media.3_4_small";i:6;s:38:"core.entity_view_mode.media.4_3_medium";i:7;s:37:"core.entity_view_mode.media.4_3_small";i:8;s:39:"core.entity_view_mode.media.9_16_medium";i:9;s:38:"core.entity_view_mode.media.9_16_small";i:10;s:34:"core.entity_view_mode.media.medium";i:11;s:33:"core.entity_view_mode.media.small";}s:6:"module";a:2:{i:0;s:6:"linkit";i:1;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tjFZLkdWssWjPYjuOrXf4pJu5kPdlmqRFEkaPUEsWTM";}s:4:"name";s:7:"Content";s:6:"format";s:14:"content_format";s:6:"weight";i:0;s:7:"filters";a:9:{s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:807:"<br> <p class="text-align-left text-align-center text-align-right text-align-justify"> <h2 class="text-align-left text-align-center text-align-right text-align-justify"> <h3 class="text-align-left text-align-center text-align-right text-align-justify"> <h4 class="text-align-left text-align-center text-align-right text-align-justify"> <h5 class="text-align-left text-align-center text-align-right text-align-justify"> <h6 class="text-align-left text-align-center text-align-right text-align-justify"> <strong> <em> <blockquote> <a href data-entity-type data-entity-uuid data-entity-substitution> <ul> <ol reversed start> <li> <table> <tr> <td rowspan colspan> <th rowspan colspan> <thead> <tbody> <tfoot> <caption> <drupal-media data-entity-type data-entity-uuid alt data-view-mode data-caption data-align>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:22:"filter_image_lazy_load";a:5:{s:2:"id";s:22:"filter_image_lazy_load";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:15;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}s:6:"linkit";a:5:{s:2:"id";s:6:"linkit";s:8:"provider";s:6:"linkit";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:2:{s:5:"title";b:0;s:18:"media_substitution";s:8:"metadata";}}s:11:"media_embed";a:5:{s:2:"id";s:11:"media_embed";s:8:"provider";s:5:"media";s:6:"status";b:1;s:6:"weight";i:100;s:8:"settings";a:3:{s:17:"default_view_mode";s:6:"medium";s:18:"allowed_view_modes";a:12:{s:11:"16_9_medium";s:11:"16_9_medium";s:10:"16_9_small";s:10:"16_9_small";s:17:"1_1_square_medium";s:17:"1_1_square_medium";s:16:"1_1_square_small";s:16:"1_1_square_small";s:10:"3_4_medium";s:10:"3_4_medium";s:9:"3_4_small";s:9:"3_4_small";s:10:"4_3_medium";s:10:"4_3_medium";s:9:"4_3_small";s:9:"4_3_small";s:11:"9_16_medium";s:11:"9_16_medium";s:10:"9_16_small";s:10:"9_16_small";s:6:"medium";s:6:"medium";s:5:"small";s:5:"small";}s:19:"allowed_media_types";a:0:{}}}}}'),
('', 'filter.format.easy_email', 'a:9:{s:4:"uuid";s:36:"90e73e27-d2f8-4de8-8e4d-bebac77bc8c7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hZ85Vt8E8gvraglJAThpcJkvGV_Zd50394USyVi12uA";}s:4:"name";s:5:"Email";s:6:"format";s:10:"easy_email";s:6:"weight";i:50;s:7:"filters";a:10:{s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:-45;s:8:"settings";a:0:{}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-48;s:8:"settings";a:0:{}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-44;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-47;s:8:"settings";a:0:{}}s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-50;s:8:"settings";a:3:{s:12:"allowed_html";s:0:"";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-49;s:8:"settings";a:0:{}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:0;s:6:"weight";i:-42;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-46;s:8:"settings";a:0:{}}s:22:"filter_image_lazy_load";a:5:{s:2:"id";s:22:"filter_image_lazy_load";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-41;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-43;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}'),
('', 'filter.format.plain_text', 'a:9:{s:4:"uuid";s:36:"5bf99b5f-1868-40b7-895b-10238b7a42bd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JLMwODO0epnA_H-jFlH9ezVfa5YBJniRv3MmLqYNl_Q";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}'),
('', 'filter.settings', 'a:2:{s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}'),
('', 'focal_point.settings', 'a:2:{s:9:"crop_type";s:11:"focal_point";s:13:"default_value";s:5:"50,50";}'),
('', 'friendlycaptcha.settings', 'a:4:{s:8:"site_key";s:12:"${site_uuid}";s:7:"api_key";s:12:"${site_uuid}";s:12:"api_endpoint";s:5:"local";s:25:"enable_validation_logging";b:0;}'),
('', 'gin.settings', 'a:12:{s:19:"preset_accent_color";s:4:"blue";s:18:"preset_focus_color";s:3:"gin";s:15:"enable_darkmode";s:1:"0";s:15:"classic_toolbar";s:3:"new";s:26:"secondary_toolbar_frontend";b:1;s:4:"logo";a:1:{s:11:"use_default";b:1;}s:18:"high_contrast_mode";b:0;s:14:"layout_density";s:7:"default";s:23:"show_description_toggle";b:0;s:24:"show_user_theme_settings";b:0;s:21:"sticky_action_buttons";b:0;s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}'),
('', 'honeypot.settings', 'a:7:{s:17:"protect_all_forms";b:0;s:17:"unprotected_forms";a:5:{i:0;s:15:"user_login_form";i:1;s:11:"search_form";i:2;s:17:"search_block_form";i:3;s:18:"views_exposed_form";i:4;s:22:"honeypot_settings_form";}s:3:"log";b:0;s:12:"element_name";s:3:"url";s:10:"time_limit";i:5;s:6:"expire";i:300;s:13:"form_settings";a:5:{s:18:"user_register_form";b:1;s:9:"user_pass";b:1;s:29:"feedback_contact_message_form";b:0;s:21:"_contact_message_form";b:0;s:20:"comment_comment_form";b:1;}}'),
('', 'image.settings', 'a:3:{s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;}'),
('', 'image.style.16_9_1008x567_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"bc570d06-f384-4963-af89-6cef9e5ae91e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rUmhU4_c8AT7D4J30BEnpECYnCyLnrDdPkojGUeXeyI";}s:4:"name";s:30:"16_9_1008x567_focal_point_webp";s:5:"label";s:36:"16:9 | 1008x567 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"a4692861-9772-46ac-9026-30f6831c3b2f";a:4:{s:4:"uuid";s:36:"a4692861-9772-46ac-9026-30f6831c3b2f";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1008;s:6:"height";i:567;s:9:"crop_type";s:11:"focal_point";}}s:36:"e1a547a7-f2ff-4046-8cff-7a439e95037c";a:4:{s:4:"uuid";s:36:"e1a547a7-f2ff-4046-8cff-7a439e95037c";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_1312x738_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"6566ae24-d8ca-46c9-987b-cad9cab3f6d0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"J90G97BIxyugYQdKqpcqEGSLdBtXb7-iU2WiDcvoZfI";}s:4:"name";s:30:"16_9_1312x738_focal_point_webp";s:5:"label";s:36:"16:9 | 1312x738 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"19a93f4d-15cd-42a9-b556-0fd4c7c6611b";a:4:{s:4:"uuid";s:36:"19a93f4d-15cd-42a9-b556-0fd4c7c6611b";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1312;s:6:"height";i:738;s:9:"crop_type";s:11:"focal_point";}}s:36:"fdb99600-8453-48a6-88b8-c53bd40b18fe";a:4:{s:4:"uuid";s:36:"fdb99600-8453-48a6-88b8-c53bd40b18fe";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_1800x1080_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"6b0f3350-564c-4ec0-af6d-24cc4ec5d653";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"o4IuvASIS08-gEBjs7Yk4b4DE4fF8aYqK-BM3EqEMSA";}s:4:"name";s:31:"16_9_1800x1080_focal_point_webp";s:5:"label";s:37:"16:9 | 1800x1080 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"fea1c3a1-1f85-4682-8e80-a50f68d2f7eb";a:4:{s:4:"uuid";s:36:"fea1c3a1-1f85-4682-8e80-a50f68d2f7eb";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1800;s:6:"height";i:1080;s:9:"crop_type";s:11:"focal_point";}}s:36:"1c5d7a9c-c642-4595-adad-f128e730c5ca";a:4:{s:4:"uuid";s:36:"1c5d7a9c-c642-4595-adad-f128e730c5ca";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_304x171_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"8e8d8e40-23b6-428f-b012-f38c3f59ff02";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZFBBgjK4pwCSD1ikUGo4Y4OHNM5s_9DA92fn2z4RCC4";}s:4:"name";s:29:"16_9_304x171_focal_point_webp";s:5:"label";s:35:"16:9 | 304x171 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"9b9738dc-6a6a-4b51-aa25-897694875aa5";a:4:{s:4:"uuid";s:36:"9b9738dc-6a6a-4b51-aa25-897694875aa5";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:304;s:6:"height";i:171;s:9:"crop_type";s:11:"focal_point";}}s:36:"68641107-bc5b-4881-8b06-28755e2d05e8";a:4:{s:4:"uuid";s:36:"68641107-bc5b-4881-8b06-28755e2d05e8";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_512x288_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"172aee40-6b76-4aa0-916f-271f33803fb5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XTTF2Ywao0XyVrsNo6kNQWmbO_92DabxPnO6f9QKkLc";}s:4:"name";s:29:"16_9_512x288_focal_point_webp";s:5:"label";s:35:"16:9 | 512x288 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"1cc316bd-d2dd-43d7-8991-ffdb80cbae61";a:4:{s:4:"uuid";s:36:"1cc316bd-d2dd-43d7-8991-ffdb80cbae61";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:512;s:6:"height";i:288;s:9:"crop_type";s:11:"focal_point";}}s:36:"f2ff37ae-8653-413e-b59b-acf81331c414";a:4:{s:4:"uuid";s:36:"f2ff37ae-8653-413e-b59b-acf81331c414";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_608x342_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"d7e407a0-c39a-4fb7-9288-8395b03efab9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"56XTHCUdB6wET9DrAElUE74Ix7EX0tkKnerfTi-2jog";}s:4:"name";s:29:"16_9_608x342_focal_point_webp";s:5:"label";s:35:"16:9 | 608x342 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"6f55742d-ba93-4285-9334-5095dadb35b3";a:4:{s:4:"uuid";s:36:"6f55742d-ba93-4285-9334-5095dadb35b3";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:608;s:6:"height";i:342;s:9:"crop_type";s:11:"focal_point";}}s:36:"0a27b7b7-48e0-4929-bd2c-c3e7449b32e4";a:4:{s:4:"uuid";s:36:"0a27b7b7-48e0-4929-bd2c-c3e7449b32e4";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_704x396_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"2c977db7-473a-46c1-bf65-1aa9fadb247e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3Rwj2BfPhj0Iwh2yDqa9v0I6774P0jL_kNbm-NMebR8";}s:4:"name";s:29:"16_9_704x396_focal_point_webp";s:5:"label";s:35:"16:9 | 704x396 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"0b39c115-5b73-46cf-8b05-c393f5f11070";a:4:{s:4:"uuid";s:36:"0b39c115-5b73-46cf-8b05-c393f5f11070";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:704;s:6:"height";i:396;s:9:"crop_type";s:11:"focal_point";}}s:36:"02cca37b-7fa1-4031-9b24-801539264d89";a:4:{s:4:"uuid";s:36:"02cca37b-7fa1-4031-9b24-801539264d89";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_720x405_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"2af7c52b-b090-4659-ace9-378c3d2756c3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqz7xE0_XoRHk4QP0jCvmAqkcNOt79VIgnSUAqZbVmU";}s:4:"name";s:29:"16_9_720x405_focal_point_webp";s:5:"label";s:35:"16:9 | 720x405 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"0b39c115-5b73-46cf-8b05-c393f6f11070";a:4:{s:4:"uuid";s:36:"0b39c115-5b73-46cf-8b05-c393f6f11070";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:720;s:6:"height";i:405;s:9:"crop_type";s:11:"focal_point";}}s:36:"02cca37b-7fa1-4031-9b24-801539265d89";a:4:{s:4:"uuid";s:36:"02cca37b-7fa1-4031-9b24-801539265d89";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.16_9_960x540_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"915bf209-9854-4f7d-b835-c0b98b9d2850";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4upmuC8xKRxeb0tQRZU2uZrfyHr-q1Zes5ovw71pu5Y";}s:4:"name";s:29:"16_9_960x540_focal_point_webp";s:5:"label";s:35:"16:9 | 960x540 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"f1135985-9346-4752-a1e3-3935baeb85bc";a:4:{s:4:"uuid";s:36:"f1135985-9346-4752-a1e3-3935baeb85bc";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:960;s:6:"height";i:540;s:9:"crop_type";s:11:"focal_point";}}s:36:"3f445242-b603-402a-a79d-1b09d0c4de05";a:4:{s:4:"uuid";s:36:"3f445242-b603-402a-a79d-1b09d0c4de05";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.1_1_300x300_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"0d426851-5632-43f9-9512-e88978646dab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RBpcwBg8XPF0jivC2EOPFflM0ANoBhdGnRqnDaZVAfk";}s:4:"name";s:28:"1_1_300x300_focal_point_webp";s:5:"label";s:34:"1:1 | 300x300 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"1812e881-f11b-4b5b-b86b-9a2cac8afedb";a:4:{s:4:"uuid";s:36:"1812e881-f11b-4b5b-b86b-9a2cac8afedb";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:300;s:6:"height";i:300;s:9:"crop_type";s:11:"focal_point";}}s:36:"4d3ee515-bc3f-4b65-83f0-7db0a5ebf14e";a:4:{s:4:"uuid";s:36:"4d3ee515-bc3f-4b65-83f0-7db0a5ebf14e";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.1_1_500x500_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"bc0b9757-c6aa-4747-8f3a-774af10b6fc5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vAuvmeUZmayHuqGDq5EXNjQK-bpiQjoqIu9nLyuePD4";}s:4:"name";s:28:"1_1_500x500_focal_point_webp";s:5:"label";s:34:"1:1 | 500x500 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"af85869c-9682-4f49-8c30-d1be92e67d60";a:4:{s:4:"uuid";s:36:"af85869c-9682-4f49-8c30-d1be92e67d60";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:500;s:6:"height";i:500;s:9:"crop_type";s:11:"focal_point";}}s:36:"f3b7ca3f-d873-4c56-884d-141c73511959";a:4:{s:4:"uuid";s:36:"f3b7ca3f-d873-4c56-884d-141c73511959";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.1_1_600x600_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"b86ac682-6fb0-41cb-94e1-2e7e32996e6f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hWBBzf2FF0-zS9yzBP6AprGfe11trj6f2nmWF0mglLM";}s:4:"name";s:28:"1_1_600x600_focal_point_webp";s:5:"label";s:34:"1:1 | 600x600 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"6920a024-f16d-48a8-8a9b-0b61285c3555";a:4:{s:4:"uuid";s:36:"6920a024-f16d-48a8-8a9b-0b61285c3555";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:600;s:6:"height";i:600;s:9:"crop_type";s:11:"focal_point";}}s:36:"22aaebcd-5967-4b6d-9d92-a699a391f803";a:4:{s:4:"uuid";s:36:"22aaebcd-5967-4b6d-9d92-a699a391f803";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.1_1_720x720_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"e31fc775-1d8c-40ee-b8ad-edd15defd81a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"80cfH4HxCpJal8fjyPj_2U2IQn9qiLHV-mh17SwH8jA";}s:4:"name";s:28:"1_1_720x720_focal_point_webp";s:5:"label";s:34:"1:1 | 720x720 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"6920a024-f16d-48a8-8a9b-0b61295c3555";a:4:{s:4:"uuid";s:36:"6920a024-f16d-48a8-8a9b-0b61295c3555";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:720;s:6:"height";i:720;s:9:"crop_type";s:11:"focal_point";}}s:36:"22aaebcd-5967-4b6d-9d92-a699a491f803";a:4:{s:4:"uuid";s:36:"22aaebcd-5967-4b6d-9d92-a699a491f803";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.1_1_960x960_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"aea130eb-aa8a-414a-9985-6c2817da853b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"E35Yuo-dUfqIcmF1IVVuVt-4d5-A6G90TU9B3_Kgyf0";}s:4:"name";s:28:"1_1_960x960_focal_point_webp";s:5:"label";s:34:"1:1 | 960x960 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"6efd13f5-a85b-41f4-a8e6-b3a4468dc128";a:4:{s:4:"uuid";s:36:"6efd13f5-a85b-41f4-a8e6-b3a4468dc128";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:960;s:6:"height";i:960;s:9:"crop_type";s:11:"focal_point";}}s:36:"b72647ac-59a9-4d13-9f4d-8dba35b897bd";a:4:{s:4:"uuid";s:36:"b72647ac-59a9-4d13-9f4d-8dba35b897bd";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.2_3_200x300_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"c27b314e-5bdc-4599-bbce-2f8cfeec1ac9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"du3-Uxc-9zTMsuVZw3_3JVjmd6VSpAFKn1CQeS5LAAg";}s:4:"name";s:28:"2_3_200x300_focal_point_webp";s:5:"label";s:34:"2:3 | 200x300 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"95886ad8-198b-43ae-a5d7-dc17a4c5d1ee";a:4:{s:4:"uuid";s:36:"95886ad8-198b-43ae-a5d7-dc17a4c5d1ee";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:200;s:6:"height";i:300;s:9:"crop_type";s:11:"focal_point";}}s:36:"82c5e0e1-cb63-4986-9a8a-ca847618033d";a:4:{s:4:"uuid";s:36:"82c5e0e1-cb63-4986-9a8a-ca847618033d";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.2_3_400x600_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"b9c342dd-ba0f-405a-9b63-e9b7275c1ac5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_QLaMq5zankn9KLRIsLYsj-0ZejvzIAPm_0N9kdf2VM";}s:4:"name";s:28:"2_3_400x600_focal_point_webp";s:5:"label";s:34:"2:3 | 400x600 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"ac290958-e77d-4c03-bcba-1b8d783fe383";a:4:{s:4:"uuid";s:36:"ac290958-e77d-4c03-bcba-1b8d783fe383";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:400;s:6:"height";i:600;s:9:"crop_type";s:11:"focal_point";}}s:36:"24b921e9-3cd0-49ee-9c6a-4831c07f9c49";a:4:{s:4:"uuid";s:36:"24b921e9-3cd0-49ee-9c6a-4831c07f9c49";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.2_3_500x750_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"7b5d795b-c9d6-40f1-b8a1-f15fa0801257";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"910vVU5ylybcTsvbX3F_5TDfP0jFwC599RuM-OuUAD0";}s:4:"name";s:28:"2_3_500x750_focal_point_webp";s:5:"label";s:34:"2:3 | 500x750 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"4077b605-04d5-4ac2-b7ba-a91c58478506";a:4:{s:4:"uuid";s:36:"4077b605-04d5-4ac2-b7ba-a91c58478506";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:500;s:6:"height";i:750;s:9:"crop_type";s:11:"focal_point";}}s:36:"b38c5baf-e1bb-4e70-9575-b6f3157e1403";a:4:{s:4:"uuid";s:36:"b38c5baf-e1bb-4e70-9575-b6f3157e1403";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.2_3_640x960_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"be942729-8171-486f-85e0-8b1ffb88e338";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mKehpFY683BxSQk6t_i0A_GtluMPG5lMT6MgIrH9ugE";}s:4:"name";s:28:"2_3_640x960_focal_point_webp";s:5:"label";s:34:"2:3 | 640x960 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"261a29b3-88a2-4b27-b8d8-24b3838cda6c";a:4:{s:4:"uuid";s:36:"261a29b3-88a2-4b27-b8d8-24b3838cda6c";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:640;s:6:"height";i:960;s:9:"crop_type";s:11:"focal_point";}}s:36:"b311343e-7401-45bb-9d96-bf347b557763";a:4:{s:4:"uuid";s:36:"b311343e-7401-45bb-9d96-bf347b557763";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_1002x668_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"7bb0c769-c448-4d48-8e36-3778453d9ee2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yThwTXjgGre5WrkLDkk1gqjns80YFZChgBj28g3NGLk";}s:4:"name";s:29:"3_2_1002x668_focal_point_webp";s:5:"label";s:35:"3:2 | 1002x668 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"9094bc59-a790-436b-9cc3-c9e0ef46f9c1";a:4:{s:4:"uuid";s:36:"9094bc59-a790-436b-9cc3-c9e0ef46f9c1";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1002;s:6:"height";i:668;s:9:"crop_type";s:11:"focal_point";}}s:36:"cba48438-2435-4a32-94f1-35a261a4f021";a:4:{s:4:"uuid";s:36:"cba48438-2435-4a32-94f1-35a261a4f021";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_1302x868_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"3f113fbe-fe73-4c47-88fb-6ec74903ea03";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9mthF58PKpAegMSBzvpoPqRFn_IJxPZCSeS_-21j1Zo";}s:4:"name";s:29:"3_2_1302x868_focal_point_webp";s:5:"label";s:35:"3:2 | 1302x868 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"7b33ff35-1af3-45d1-99f4-61c66f364c1e";a:4:{s:4:"uuid";s:36:"7b33ff35-1af3-45d1-99f4-61c66f364c1e";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1302;s:6:"height";i:868;s:9:"crop_type";s:11:"focal_point";}}s:36:"a2c39aab-e4c0-4e1d-bc81-071f28e4030c";a:4:{s:4:"uuid";s:36:"a2c39aab-e4c0-4e1d-bc81-071f28e4030c";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_1800x1200_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"9e21da61-879c-49ac-a3d4-2d7ffe6a6aeb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"64O4blMdGlnhpcPjP7R_zCGKH0Vt0SdZSW2kgSyJhGc";}s:4:"name";s:30:"3_2_1800x1200_focal_point_webp";s:5:"label";s:36:"3:2 | 1800x1200 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"d21598a8-976c-4a84-9f8a-a1e883c286c9";a:4:{s:4:"uuid";s:36:"d21598a8-976c-4a84-9f8a-a1e883c286c9";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1800;s:6:"height";i:1200;s:9:"crop_type";s:11:"focal_point";}}s:36:"3ef1b112-12b8-403c-b68b-6ff77a9083a5";a:4:{s:4:"uuid";s:36:"3ef1b112-12b8-403c-b68b-6ff77a9083a5";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_300x200_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"c66c0a28-af3b-452f-84f7-b0b6aa051bef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dZh376G6qWFSii5XEpKyQnE_jOQQdFkSZPPM6DzEV-g";}s:4:"name";s:28:"3_2_300x200_focal_point_webp";s:5:"label";s:34:"3:2 | 300x200 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"133d649e-7185-4767-ad5c-41c2654ac120";a:4:{s:4:"uuid";s:36:"133d649e-7185-4767-ad5c-41c2654ac120";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:300;s:6:"height";i:200;s:9:"crop_type";s:11:"focal_point";}}s:36:"30a15830-aa08-4c9b-96db-6849d38f3285";a:4:{s:4:"uuid";s:36:"30a15830-aa08-4c9b-96db-6849d38f3285";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_504x336_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"a940fdd2-b4e9-49aa-96aa-6e64724d386b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"xqWS9UPDCn0CuIK6xb8wYc6N4lZ8mp4zQgkdwjPr9cQ";}s:4:"name";s:28:"3_2_504x336_focal_point_webp";s:5:"label";s:34:"3:2 | 504x336 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"64530e0e-a690-47c7-b4e6-d7e01eb6e5a5";a:4:{s:4:"uuid";s:36:"64530e0e-a690-47c7-b4e6-d7e01eb6e5a5";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:504;s:6:"height";i:336;s:9:"crop_type";s:11:"focal_point";}}s:36:"992c64d4-cf18-4a3e-97ec-c70e6a937af1";a:4:{s:4:"uuid";s:36:"992c64d4-cf18-4a3e-97ec-c70e6a937af1";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_600x400_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"2b085f41-15f3-4136-b828-b4e477aed322";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"E56mB71UH-awQVZ5GJhr9QBrlOHiwHfSAFHSZOmbkOA";}s:4:"name";s:28:"3_2_600x400_focal_point_webp";s:5:"label";s:34:"3:2 | 600x400 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"bbc60a52-53f2-4601-94e6-fb8185695d1d";a:4:{s:4:"uuid";s:36:"bbc60a52-53f2-4601-94e6-fb8185695d1d";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:600;s:6:"height";i:400;s:9:"crop_type";s:11:"focal_point";}}s:36:"c2411b05-918a-4a68-8d26-9c1d47f00749";a:4:{s:4:"uuid";s:36:"c2411b05-918a-4a68-8d26-9c1d47f00749";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_702x468_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"0522a0fd-616a-4455-a30e-42bb507747e2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wYCdpKqcpgzlA1mcUWjNa-zCX4c0YQOAHbG4-9oGyWs";}s:4:"name";s:28:"3_2_702x468_focal_point_webp";s:5:"label";s:34:"3:2 | 702x468 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"fc06144f-358b-4202-b952-37164be5b776";a:4:{s:4:"uuid";s:36:"fc06144f-358b-4202-b952-37164be5b776";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:702;s:6:"height";i:468;s:9:"crop_type";s:11:"focal_point";}}s:36:"df642333-0a12-49d8-ae80-68b72e60f160";a:4:{s:4:"uuid";s:36:"df642333-0a12-49d8-ae80-68b72e60f160";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_720x480_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"b62ed692-b640-4161-a03a-016130ae947c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3j9Nz2WNuvWzbXO2tj5r6ICfYKppzE9AeL2vzFBOdsU";}s:4:"name";s:28:"3_2_720x480_focal_point_webp";s:5:"label";s:34:"3:2 | 720x480 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"fc06144f-358b-4202-b952-37264be5b776";a:4:{s:4:"uuid";s:36:"fc06144f-358b-4202-b952-37264be5b776";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:720;s:6:"height";i:480;s:9:"crop_type";s:11:"focal_point";}}s:36:"df642333-0a12-49d8-ae80-68b74e60f160";a:4:{s:4:"uuid";s:36:"df642333-0a12-49d8-ae80-68b74e60f160";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_2_960x640_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"727c3346-4cdd-490d-acdd-2c176635478b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C804kxfnhhZr_nepPHreTXCqP3fvt0o8SSN2XtaC4i8";}s:4:"name";s:28:"3_2_960x640_focal_point_webp";s:5:"label";s:34:"3:2 | 960x640 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"bcf36920-5524-4ab9-809a-36ac7cca2fa8";a:4:{s:4:"uuid";s:36:"bcf36920-5524-4ab9-809a-36ac7cca2fa8";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:960;s:6:"height";i:640;s:9:"crop_type";s:11:"focal_point";}}s:36:"39a18c97-77ba-4924-91b6-cc3c850a0dd1";a:4:{s:4:"uuid";s:36:"39a18c97-77ba-4924-91b6-cc3c850a0dd1";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_4_225x300_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"4ae257bb-4243-43d1-a926-12e8675fc91b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sQzanDwhi14jfi5JIGP_KI77R0-r_E6YU5xuD_wkcvY";}s:4:"name";s:28:"3_4_225x300_focal_point_webp";s:5:"label";s:34:"3:4 | 225x300 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"ee8503d0-3291-49fd-91f0-03330865ae3b";a:4:{s:4:"uuid";s:36:"ee8503d0-3291-49fd-91f0-03330865ae3b";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:225;s:6:"height";i:300;s:9:"crop_type";s:11:"focal_point";}}s:36:"9345aea6-53fb-43ca-8f3e-a0bd87a4e796";a:4:{s:4:"uuid";s:36:"9345aea6-53fb-43ca-8f3e-a0bd87a4e796";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_4_450x600_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"04d698ba-8243-4732-b350-f7989c6de928";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"l8oGdxxp5_lUEMYzcHdhoU0DGd86KYDOBT_jNwXF-xk";}s:4:"name";s:28:"3_4_450x600_focal_point_webp";s:5:"label";s:34:"3:4 | 450x600 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"b442b7c1-227b-422c-8dad-beae9cf4b700";a:4:{s:4:"uuid";s:36:"b442b7c1-227b-422c-8dad-beae9cf4b700";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:450;s:6:"height";i:600;s:9:"crop_type";s:11:"focal_point";}}s:36:"bdd5bd8e-4cd7-4a1f-9c9f-b95cbe9c7138";a:4:{s:4:"uuid";s:36:"bdd5bd8e-4cd7-4a1f-9c9f-b95cbe9c7138";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_4_504x672_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"ffffa912-7f63-44de-9130-ceb5d7d15aff";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OVTgGK9NkERBk8qqsN1HXV2kwAMqb42RX1Ld7b6Smks";}s:4:"name";s:28:"3_4_504x672_focal_point_webp";s:5:"label";s:34:"3:4 | 504x672 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"daee41bb-943a-4728-9add-9a4e56024f28";a:4:{s:4:"uuid";s:36:"daee41bb-943a-4728-9add-9a4e56024f28";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:504;s:6:"height";i:672;s:9:"crop_type";s:11:"focal_point";}}s:36:"83131eb6-d8b9-44bf-84aa-c7deca5020d1";a:4:{s:4:"uuid";s:36:"83131eb6-d8b9-44bf-84aa-c7deca5020d1";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_4_708x944_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"d3376c46-7afe-43a3-969f-0de30942e7fc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Ae5KdrXLDYIOS5hhvM52Qu4nVHOY_dHBTbZLLpOgAlQ";}s:4:"name";s:28:"3_4_708x944_focal_point_webp";s:5:"label";s:34:"3:4 | 708x944 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"33453e0d-803d-4856-8458-96766fd16079";a:4:{s:4:"uuid";s:36:"33453e0d-803d-4856-8458-96766fd16079";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:708;s:6:"height";i:944;s:9:"crop_type";s:11:"focal_point";}}s:36:"e08637f9-a053-4b4d-a2ab-dc4c8db0c54b";a:4:{s:4:"uuid";s:36:"e08637f9-a053-4b4d-a2ab-dc4c8db0c54b";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.3_4_720x960_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"ee1ebff7-3ff5-49a6-a93c-6be051455631";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QUxjEBPVw3l9VFb0TQtY9LqPmQYgTWsb7Ft6fDU3gzY";}s:4:"name";s:28:"3_4_720x960_focal_point_webp";s:5:"label";s:34:"3:4 | 720x960 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"833bdd49-4edb-4675-b53f-02e386a7c907";a:4:{s:4:"uuid";s:36:"833bdd49-4edb-4675-b53f-02e386a7c907";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:720;s:6:"height";i:960;s:9:"crop_type";s:11:"focal_point";}}s:36:"321b736d-3e1d-481c-979c-6181727ff5c3";a:4:{s:4:"uuid";s:36:"321b736d-3e1d-481c-979c-6181727ff5c3";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_1000x750_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"9bf9f2f1-6f75-46ab-9574-97144954fa56";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W9mIxC4R2nzY-W2P-9fdm5_nW0QzreV4m7fs6ni5Su8";}s:4:"name";s:29:"4_3_1000x750_focal_point_webp";s:5:"label";s:35:"4:3 | 1000x750 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"01ef5c36-668a-4874-b526-fa37d23f2538";a:4:{s:4:"uuid";s:36:"01ef5c36-668a-4874-b526-fa37d23f2538";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1000;s:6:"height";i:750;s:9:"crop_type";s:11:"focal_point";}}s:36:"e0454d1e-6318-4b13-a740-2f90ee1f442b";a:4:{s:4:"uuid";s:36:"e0454d1e-6318-4b13-a740-2f90ee1f442b";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_1300x975_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"9a1b2467-683d-4dc3-9631-291a069adaa1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tuQUlzuJp3UQu5KG0eieGRyHl8q8tFNwuPKQt2fTb5Y";}s:4:"name";s:29:"4_3_1300x975_focal_point_webp";s:5:"label";s:35:"4:3 | 1300x975 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"b14b2f7f-c42c-4d6f-9859-ff817758290b";a:4:{s:4:"uuid";s:36:"b14b2f7f-c42c-4d6f-9859-ff817758290b";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1300;s:6:"height";i:975;s:9:"crop_type";s:11:"focal_point";}}s:36:"698577e0-3cab-4604-a933-3de25bf10b09";a:4:{s:4:"uuid";s:36:"698577e0-3cab-4604-a933-3de25bf10b09";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_1800x1350_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"1ebda699-7983-4959-bcb4-9e59c39459d6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-I4-yZZ8sair8esEVtKLU1JUnx3b1jgIOr4U7sua-A4";}s:4:"name";s:30:"4_3_1800x1350_focal_point_webp";s:5:"label";s:36:"4:3 | 1800x1350 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"ee7717f4-236e-443d-aae7-2e8474911a6a";a:4:{s:4:"uuid";s:36:"ee7717f4-236e-443d-aae7-2e8474911a6a";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1800;s:6:"height";i:1350;s:9:"crop_type";s:11:"focal_point";}}s:36:"a95f2f2d-b9e3-42f4-927b-0e5405f6c87b";a:4:{s:4:"uuid";s:36:"a95f2f2d-b9e3-42f4-927b-0e5405f6c87b";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_300x225_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"e334a963-62e4-4617-8fbb-c0691cb94feb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zqqUtC7Gqn47tmO5_TLzdDpLAV-BxCEEPC5eGGS0eyc";}s:4:"name";s:28:"4_3_300x225_focal_point_webp";s:5:"label";s:34:"4:3 | 300x225 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"d89720e6-3767-4ce6-a282-f43cf41a063c";a:4:{s:4:"uuid";s:36:"d89720e6-3767-4ce6-a282-f43cf41a063c";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:300;s:6:"height";i:225;s:9:"crop_type";s:11:"focal_point";}}s:36:"6f7b215b-1907-472f-8f78-33e30a5c1956";a:4:{s:4:"uuid";s:36:"6f7b215b-1907-472f-8f78-33e30a5c1956";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_500x375_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"fd3a4333-3451-4cf7-82f8-0ef1b2e61f34";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"X3d6XCe6W4ovUovqev5rl7DH15zj7BpGVsB1EYcWEhA";}s:4:"name";s:28:"4_3_500x375_focal_point_webp";s:5:"label";s:34:"4:3 | 500x375 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"dfadf4bb-5214-485a-ab1e-bb326c01aecd";a:4:{s:4:"uuid";s:36:"dfadf4bb-5214-485a-ab1e-bb326c01aecd";s:2:"id";s:13:"image_convert";s:6:"weight";i:-9;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}s:36:"94758e96-0da3-4c96-bccc-3939ae2e60f1";a:4:{s:4:"uuid";s:36:"94758e96-0da3-4c96-bccc-3939ae2e60f1";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:-10;s:4:"data";a:3:{s:5:"width";i:500;s:6:"height";i:375;s:9:"crop_type";s:11:"focal_point";}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'image.style.4_3_600x450_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"84580ba2-b13d-4c1e-8a38-2902f757ed1d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"O0lMbbbyuFvPN4Jb1G2cXNAylvh-dcB_HiSMkgHOc2c";}s:4:"name";s:28:"4_3_600x450_focal_point_webp";s:5:"label";s:34:"4:3 | 600x450 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"3fe5cbde-6ac5-44ae-9350-592863668be1";a:4:{s:4:"uuid";s:36:"3fe5cbde-6ac5-44ae-9350-592863668be1";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:600;s:6:"height";i:450;s:9:"crop_type";s:11:"focal_point";}}s:36:"7e5258bb-b400-429a-81b6-02c3fee58638";a:4:{s:4:"uuid";s:36:"7e5258bb-b400-429a-81b6-02c3fee58638";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_700x525_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"d82f5346-25ca-4521-9109-478859e79703";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8VtJ1BobaVIkK8FtFL8fJTjh86pBfn5TWbUCf5jhJc4";}s:4:"name";s:28:"4_3_700x525_focal_point_webp";s:5:"label";s:34:"4:3 | 700x525 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"149ad60e-788b-4013-9edf-ffc2a0f8153d";a:4:{s:4:"uuid";s:36:"149ad60e-788b-4013-9edf-ffc2a0f8153d";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:700;s:6:"height";i:525;s:9:"crop_type";s:11:"focal_point";}}s:36:"6581bab2-d9e8-48c1-bfca-ee25fb2c58f0";a:4:{s:4:"uuid";s:36:"6581bab2-d9e8-48c1-bfca-ee25fb2c58f0";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_720x540_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"f56f1b6d-49e4-477b-8dac-9bc3dda3dcff";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"604uA_yosAOhvA_K5YG1BabnRrwlvJI34qKLcBpoFvg";}s:4:"name";s:28:"4_3_720x540_focal_point_webp";s:5:"label";s:34:"4:3 | 720x540 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"149ad60e-788b-4013-9edf-ffc2a1f8153d";a:4:{s:4:"uuid";s:36:"149ad60e-788b-4013-9edf-ffc2a1f8153d";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:720;s:6:"height";i:540;s:9:"crop_type";s:11:"focal_point";}}s:36:"6581bab2-d9e8-48c1-bfca-ee25fb3c58f0";a:4:{s:4:"uuid";s:36:"6581bab2-d9e8-48c1-bfca-ee25fb3c58f0";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.4_3_960x720_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"ab0c9f1d-e7ee-49e5-8292-6678c86cb9f9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YxglfBQE4Ys9thqAqyYmgsS-ODdhnFqhgT9CoWlL9qg";}s:4:"name";s:28:"4_3_960x720_focal_point_webp";s:5:"label";s:34:"4:3 | 960x720 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"bc0680ff-3bbf-4df2-ba2b-2da08ff937d2";a:4:{s:4:"uuid";s:36:"bc0680ff-3bbf-4df2-ba2b-2da08ff937d2";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:960;s:6:"height";i:720;s:9:"crop_type";s:11:"focal_point";}}s:36:"79042a88-0e34-4461-84c8-5053854ed324";a:4:{s:4:"uuid";s:36:"79042a88-0e34-4461-84c8-5053854ed324";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.5_2_1000x400_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"fe141af9-6256-4ec4-8fc7-91c112ca0e73";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dsu5W-V8UIomtuVkd_y5u0-3fTBdYOkWH6g2gN5GZZI";}s:4:"name";s:29:"5_2_1000x400_focal_point_webp";s:5:"label";s:35:"5:2 | 1000x400 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"495c8364-5de0-4791-a779-1132eac38656";a:4:{s:4:"uuid";s:36:"495c8364-5de0-4791-a779-1132eac38656";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1000;s:6:"height";i:400;s:9:"crop_type";s:11:"focal_point";}}s:36:"813f987a-dda6-417e-a257-fc33cc18bdd0";a:4:{s:4:"uuid";s:36:"813f987a-dda6-417e-a257-fc33cc18bdd0";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.5_2_1300x520_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"a3ba8b34-7292-44d2-9ba7-1809314bff8d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bXxL2gf_ZDVeQlqJis68PL-SjDznlZkIKR_gZ_fpZYw";}s:4:"name";s:29:"5_2_1300x520_focal_point_webp";s:5:"label";s:35:"5:2 | 1300x520 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"e3359c49-f775-4f01-9316-ed07f061dafa";a:4:{s:4:"uuid";s:36:"e3359c49-f775-4f01-9316-ed07f061dafa";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1300;s:6:"height";i:520;s:9:"crop_type";s:11:"focal_point";}}s:36:"d564bc71-f6ad-4a31-b9c5-4c0acdedd9bf";a:4:{s:4:"uuid";s:36:"d564bc71-f6ad-4a31-b9c5-4c0acdedd9bf";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.5_2_1800x720_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"8f955cb8-cf8a-4220-8c6f-498c97aeb9f4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RjJp7UlQWe99FAAm277IGhjXhpPH9WhCY67sL1nT5lg";}s:4:"name";s:29:"5_2_1800x720_focal_point_webp";s:5:"label";s:35:"5:2 | 1800x720 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"9701146b-1531-467b-b7e8-65ce1088635b";a:4:{s:4:"uuid";s:36:"9701146b-1531-467b-b7e8-65ce1088635b";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1800;s:6:"height";i:720;s:9:"crop_type";s:11:"focal_point";}}s:36:"3722b6c8-9616-4507-bd7e-0c5e6b0e7887";a:4:{s:4:"uuid";s:36:"3722b6c8-9616-4507-bd7e-0c5e6b0e7887";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.9_16_171x304_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"f04de5d9-d860-4eeb-870c-892e233f108a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N9Jr7Uz2cEoEqiLhI3ZrdW_kAZHE8fObPDzDHUAkjkw";}s:4:"name";s:29:"9_16_171x304_focal_point_webp";s:5:"label";s:35:"9:16 | 171x304 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"74888829-c3f8-4f9f-b950-78e9e6a1405b";a:4:{s:4:"uuid";s:36:"74888829-c3f8-4f9f-b950-78e9e6a1405b";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:171;s:6:"height";i:304;s:9:"crop_type";s:11:"focal_point";}}s:36:"2571894f-9e3f-4754-bb49-518e11a3ba8b";a:4:{s:4:"uuid";s:36:"2571894f-9e3f-4754-bb49-518e11a3ba8b";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.9_16_342x608_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"4d6141e2-0c61-4678-b673-9b952b10102d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"O-wtmwSyYJ2114dC8tyoaRvMi2rUM_7qFQjWKmjlXC8";}s:4:"name";s:29:"9_16_342x608_focal_point_webp";s:5:"label";s:35:"9:16 | 342x608 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"e45d01d6-5a23-4eba-bb39-f06c36c05c70";a:4:{s:4:"uuid";s:36:"e45d01d6-5a23-4eba-bb39-f06c36c05c70";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:342;s:6:"height";i:608;s:9:"crop_type";s:11:"focal_point";}}s:36:"dd9e7fc0-75d9-413d-a136-a038742dc729";a:4:{s:4:"uuid";s:36:"dd9e7fc0-75d9-413d-a136-a038742dc729";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.9_16_504x896_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"91aba3ce-3334-41e5-bd60-21fea3ae486b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"B4NGfxDNRMyei-tkT14O5fKT-ThTkmx_NfMx-AenvKQ";}s:4:"name";s:29:"9_16_504x896_focal_point_webp";s:5:"label";s:35:"9:16 | 504x896 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"d263d4ad-2722-45a5-a232-ee2825dd64cf";a:4:{s:4:"uuid";s:36:"d263d4ad-2722-45a5-a232-ee2825dd64cf";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:504;s:6:"height";i:896;s:9:"crop_type";s:11:"focal_point";}}s:36:"30a15113-f9c7-4202-9843-75062870fc5a";a:4:{s:4:"uuid";s:36:"30a15113-f9c7-4202-9843-75062870fc5a";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.9_16_540x960_focal_point_webp', 'a:8:{s:4:"uuid";s:36:"bd9a8299-d082-4324-8e14-77cbd6ba2351";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RoJw_KbIIco0B3lYxF5MCwsxraDvmbr5Ye41WsQ8x_s";}s:4:"name";s:29:"9_16_540x960_focal_point_webp";s:5:"label";s:35:"9:16 | 540x960 | Focal Point | WebP";s:7:"effects";a:2:{s:36:"58bd4825-e186-4b38-8975-b9d51a2e57ca";a:4:{s:4:"uuid";s:36:"58bd4825-e186-4b38-8975-b9d51a2e57ca";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:540;s:6:"height";i:960;s:9:"crop_type";s:11:"focal_point";}}s:36:"03c1233f-c59e-4792-9fbe-7c7d9aa9200c";a:4:{s:4:"uuid";s:36:"03c1233f-c59e-4792-9fbe-7c7d9aa9200c";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.large', 'a:8:{s:4:"uuid";s:36:"a2eabdea-f67e-4814-96d1-562aedf96896";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yrvYt4IlFH9AKX1vx-_N6OfeG_6HgylGP7hhB9AMH3k";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:2:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}s:36:"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8";a:4:{s:4:"uuid";s:36:"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.linkit_result_thumbnail', 'a:8:{s:4:"uuid";s:36:"c0ea65fc-5d37-4878-8b6c-b7a44b3ab1b9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PY0kMp7KIxvU4kBi5mcnD_DHTKUc1OkYCfaPliXjpa8";}s:4:"name";s:23:"linkit_result_thumbnail";s:5:"label";s:23:"Linkit result thumbnail";s:7:"effects";a:1:{s:36:"2943df29-38ea-459c-ba1d-290489bb1807";a:4:{s:4:"uuid";s:36:"2943df29-38ea-459c-ba1d-290489bb1807";s:2:"id";s:20:"image_scale_and_crop";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:50;s:6:"height";i:50;s:6:"anchor";s:13:"center-center";}}}}'),
('', 'image.style.media_library', 'a:8:{s:4:"uuid";s:36:"c9d36e47-8a9a-4e14-a7e6-a7f383a96e43";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RLU5O05P9vuBxEQjSSs9xRH-Mu8KXEyzUHRIS2R4Lm0";}s:4:"name";s:13:"media_library";s:5:"label";s:34:"Media Library thumbnail (220×220)";s:7:"effects";a:2:{s:36:"75b076a8-1234-4b42-85db-bf377c4d8d5f";a:4:{s:4:"uuid";s:36:"75b076a8-1234-4b42-85db-bf377c4d8d5f";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}s:36:"1021da71-fc2a-43d0-be5d-efaf1c79e2ea";a:4:{s:4:"uuid";s:36:"1021da71-fc2a-43d0-be5d-efaf1c79e2ea";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.media_library_square_thumbnail', 'a:8:{s:4:"uuid";s:36:"a5100768-78b7-401f-9388-eba674f28735";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:11:"focal_point";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QSJDZnSyRhy4KYDGLGFDV80vWMsrnlKN08TxWwxg4wY";}s:4:"name";s:30:"media_library_square_thumbnail";s:5:"label";s:30:"Media Library Square Thumbnail";s:7:"effects";a:2:{s:36:"e1133a5d-4918-4fd3-8b1e-c4b21222cc59";a:4:{s:4:"uuid";s:36:"e1133a5d-4918-4fd3-8b1e-c4b21222cc59";s:2:"id";s:13:"image_convert";s:6:"weight";i:-9;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}s:36:"10aaa04e-b821-481e-8555-5c29088daa27";a:4:{s:4:"uuid";s:36:"10aaa04e-b821-481e-8555-5c29088daa27";s:2:"id";s:26:"focal_point_scale_and_crop";s:6:"weight";i:-10;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:9:"crop_type";s:11:"focal_point";}}}}'),
('', 'image.style.medium', 'a:8:{s:4:"uuid";s:36:"e32d8f00-cc14-4b1e-8110-d9e9670f8eb9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aUG-EM9kKTKhcsdttoYmG5tug7pU2mNOQzcpp91jfFQ";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:2:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}s:36:"c410ed2f-aa30-4d9c-a224-d2865d9188cd";a:4:{s:4:"uuid";s:36:"c410ed2f-aa30-4d9c-a224-d2865d9188cd";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.thumbnail', 'a:8:{s:4:"uuid";s:36:"8d881979-35ba-4d3b-9b9c-561cddfaac4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JXYDC3SLZUXSwnTjR9rBo6uZF3vDSZd8S7EA5ZOH7kM";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:2:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}s:36:"c4eb9942-2c9e-4a81-949f-6161a44b6559";a:4:{s:4:"uuid";s:36:"c4eb9942-2c9e-4a81-949f-6161a44b6559";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.uncropped_300w_webp', 'a:8:{s:4:"uuid";s:36:"6da2d9d7-ba20-4323-a11e-34c3b5dc92a2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NCBRwf613YXQfSoyCbeMJgvLQaOKdmlWc-ji1hPnyUE";}s:4:"name";s:19:"uncropped_300w_webp";s:5:"label";s:23:"Uncropped | 300w | WebP";s:7:"effects";a:2:{s:36:"ac265dad-e2f4-4db8-bf22-0c4f930df865";a:4:{s:4:"uuid";s:36:"ac265dad-e2f4-4db8-bf22-0c4f930df865";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:300;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"edf92b44-e86e-4b5c-b11c-fd6e44ebda67";a:4:{s:4:"uuid";s:36:"edf92b44-e86e-4b5c-b11c-fd6e44ebda67";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.uncropped_500w_webp', 'a:8:{s:4:"uuid";s:36:"cd5c966c-34c0-4b42-b4d8-ee3e216dab59";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OOUcrXVRdJF__ijCGehyxq5Dyb7RjsgfDLpPFqd9b9M";}s:4:"name";s:19:"uncropped_500w_webp";s:5:"label";s:23:"Uncropped | 500w | WebP";s:7:"effects";a:2:{s:36:"e340ff9b-0c69-4b8e-a1c3-96585413dce3";a:4:{s:4:"uuid";s:36:"e340ff9b-0c69-4b8e-a1c3-96585413dce3";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:500;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"1b8708aa-72a4-43dc-9cd2-65f0c4198197";a:4:{s:4:"uuid";s:36:"1b8708aa-72a4-43dc-9cd2-65f0c4198197";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.uncropped_600w_webp', 'a:8:{s:4:"uuid";s:36:"ae312742-69bd-4fd2-85a2-912928213bc0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"A2gGIDp7Jjh5fOtgqNWOUh7WIEGIPBwCDT0hL5TKGjs";}s:4:"name";s:19:"uncropped_600w_webp";s:5:"label";s:23:"Uncropped | 600w | WebP";s:7:"effects";a:2:{s:36:"e5267027-b558-48af-abe1-3edd8aa95234";a:4:{s:4:"uuid";s:36:"e5267027-b558-48af-abe1-3edd8aa95234";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:600;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"cd39cbc2-25c5-4d42-baf1-bc5d375a440f";a:4:{s:4:"uuid";s:36:"cd39cbc2-25c5-4d42-baf1-bc5d375a440f";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.uncropped_700w_webp', 'a:8:{s:4:"uuid";s:36:"54a37411-4a3f-447a-891b-4ef0f7e91396";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZBv3sGbt2diHXRx444gTlBfRUJaeYKijdFfd3fxvN4k";}s:4:"name";s:19:"uncropped_700w_webp";s:5:"label";s:23:"Uncropped | 700w | WebP";s:7:"effects";a:2:{s:36:"93295bf7-164c-4763-9ce5-014b4007154c";a:4:{s:4:"uuid";s:36:"93295bf7-164c-4763-9ce5-014b4007154c";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:700;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"70230248-85a9-4941-8cde-0fd3cb86c22b";a:4:{s:4:"uuid";s:36:"70230248-85a9-4941-8cde-0fd3cb86c22b";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.uncropped_720w_webp', 'a:8:{s:4:"uuid";s:36:"6c77ba80-bedb-4ca9-a68a-bb45c3f3553b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TOkI3HZ_uw8yfmmn_hPpKuBav97oD79-HhAIAHnG35Y";}s:4:"name";s:19:"uncropped_720w_webp";s:5:"label";s:23:"Uncropped | 720w | WebP";s:7:"effects";a:2:{s:36:"93295bf7-164c-4763-9ce5-014b4007155c";a:4:{s:4:"uuid";s:36:"93295bf7-164c-4763-9ce5-014b4007155c";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:720;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"70230248-85a9-4941-8cde-0fd3cb86c23b";a:4:{s:4:"uuid";s:36:"70230248-85a9-4941-8cde-0fd3cb86c23b";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.uncropped_960w_webp', 'a:8:{s:4:"uuid";s:36:"33b85dbb-daa5-43aa-b234-e41a61e7b233";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tGrpkUIY3iWGrJwW-KdLRjR_mxZT7IJFSHY1aK_TCHA";}s:4:"name";s:19:"uncropped_960w_webp";s:5:"label";s:23:"Uncropped | 960w | WebP";s:7:"effects";a:2:{s:36:"8bd270bf-d5f1-4eca-b53b-a4e8a62b283d";a:4:{s:4:"uuid";s:36:"8bd270bf-d5f1-4eca-b53b-a4e8a62b283d";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:960;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"0ce9a656-f212-4e70-911a-faadf1d1ee9f";a:4:{s:4:"uuid";s:36:"0ce9a656-f212-4e70-911a-faadf1d1ee9f";s:2:"id";s:13:"image_convert";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'klaro.klaro_app.ai_alt_text_generation', 'a:23:{s:4:"uuid";s:36:"f9fffe2c-dfb1-4ba9-ae81-323311925f13";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BZCELYsWAV2EfJIDJNfLNSb_qe0Nzv5E9PZJgRrYDfw";}s:2:"id";s:22:"ai_alt_text_generation";s:5:"label";s:29:"Drupal AI Alt Text Generation";s:11:"description";s:127:"This service generates alt texts for images using AI vision models. The image and metadata are sent to the selected AI service.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";b:0;s:23:"contextual_consent_text";s:50:"Transfer image and meta data to chosen AI service?";s:8:"info_url";s:0:"";s:18:"privacy_policy_url";s:0:"";s:8:"purposes";a:1:{i:0;s:3:"cms";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:0:{}s:18:"wrapper_identifier";a:1:{i:0;s:23:".ai-alt-text-generation";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.bluesky', 'a:23:{s:4:"uuid";s:36:"0a312a74-6c32-4214-b5fc-83ea0f6ec703";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mokEu9Dzzr8_EGNrVGPYu_t5xT4zX6RZaEDYsv-bAps";}s:2:"id";s:7:"bluesky";s:5:"label";s:7:"Bluesky";s:11:"description";s:58:"Bluesky is a social media platform by Bluesky, PBLLC (USA)";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:29:"https://bsky.social/about/faq";s:18:"privacy_policy_url";s:48:"https://bsky.social/about/support/privacy-policy";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:14:"embed.bsky.app";}s:18:"wrapper_identifier";a:1:{i:0;s:14:".bluesky-embed";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.cms', 'a:23:{s:4:"uuid";s:36:"ea0ba5b3-a610-4609-8b53-7552bb823b8d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HBeBrdoMQ8HHvIcge46zv21fgnD6c8V6FjQ_h1eiQkY";}s:2:"id";s:3:"cms";s:5:"label";s:10:"Drupal CMS";s:11:"description";s:89:"Store data (e.g. cookie for user session) in your browser (required to use this website).";s:7:"default";b:1;s:8:"purposes";a:1:{i:0;s:3:"cms";}s:7:"cookies";a:1:{i:0;a:3:{s:5:"regex";s:13:"^[SESS|SSESS]";s:4:"path";s:0:"";s:6:"domain";s:0:"";}}s:8:"required";b:1;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:22:"https://www.drupal.org";s:18:"privacy_policy_url";s:0:"";s:11:"javascripts";a:0:{}s:13:"callback_code";s:0:"";s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:-1;}'),
('', 'klaro.klaro_app.deepchat', 'a:23:{s:4:"uuid";s:36:"ddd26eea-2e32-457a-9cd2-22fb6847240c";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OMK9vMBaKPKJ8-CWEuVow08R1qVHG67bkSVrN0_wRpM";}s:2:"id";s:8:"deepchat";s:5:"label";s:8:"Deepchat";s:11:"description";s:197:"Deepchat is a chatbot. Your data is passed on to external AI providers. Depending on the settings, a session cookie can be written for the chat history. See the privacy policy for more information.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";b:1;s:23:"contextual_consent_text";s:87:"Load service chatbot Deepchat (uses session cookie and sends data to external service)?";s:8:"info_url";s:0:"";s:18:"privacy_policy_url";s:0:"";s:8:"purposes";a:1:{i:0;s:8:"livechat";}s:7:"cookies";a:1:{i:0;a:3:{s:5:"regex";s:18:"^deepChatState_.*$";s:4:"path";s:0:"";s:6:"domain";s:0:"";}}s:13:"callback_code";s:0:"";s:11:"javascripts";a:0:{}s:18:"wrapper_identifier";a:1:{i:0;s:9:"deep-chat";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.facebook', 'a:23:{s:4:"uuid";s:36:"3b1d4995-ae1a-41ca-98fa-ed81a4d03595";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fBAyZTIZVpIJVNbRqVfsPO67ZB4JOqq1ocvlR_rf0qA";}s:2:"id";s:8:"facebook";s:5:"label";s:8:"Facebook";s:11:"description";s:65:"Facebook is a social media platform by Meta Platforms, Inc (USA).";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:35:"https://about.meta.com/company-info";s:18:"privacy_policy_url";s:40:"https://www.facebook.com/privacy/policy/";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:16:"www.facebook.com";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.ga', 'a:23:{s:4:"uuid";s:36:"214f8ff1-72f4-4e42-9fe0-3ce208d530d0";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mtHeuWVbubnMes-4rhJlAepwGRtO7rE3jXdl6QwnojI";}s:2:"id";s:2:"ga";s:5:"label";s:16:"Google Analytics";s:11:"description";s:49:"Tracks online visits of the website as a service.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:61:"https://marketingplatform.google.com/intl/de/about/analytics/";s:18:"privacy_policy_url";s:35:"https://policies.google.com/privacy";s:8:"purposes";a:1:{i:0;s:9:"analytics";}s:7:"cookies";a:3:{i:0;a:3:{s:5:"regex";s:10:"^_ga(_.*)?";s:4:"path";s:0:"";s:6:"domain";s:0:"";}i:1;a:3:{s:5:"regex";s:5:"^_gid";s:4:"path";s:0:"";s:6:"domain";s:0:"";}i:2;a:3:{s:5:"regex";s:4:"^IDE";s:4:"path";s:0:"";s:6:"domain";s:0:"";}}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:12:"analytics.js";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:1:{i:0;s:20:"ga4_google_analytics";}s:6:"weight";i:1;}'),
('', 'klaro.klaro_app.google_maps', 'a:23:{s:4:"uuid";s:36:"1a03466b-e194-431a-b7c3-2804ccd277aa";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NbcMmqZiMsveI0yQk8U-rm4QJl9Pr__gONSqOsJKjas";}s:2:"id";s:11:"google_maps";s:5:"label";s:11:"Google Maps";s:11:"description";s:55:"Google Maps is an online map service offered by Google.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:33:"https://www.google.com/maps/about";s:18:"privacy_policy_url";s:35:"https://policies.google.com/privacy";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:2:{i:0;s:33:"https://www.google.com/maps/embed";i:1;s:46:"https://maps.googleapis.com/maps/api/staticmap";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.google_recaptcha', 'a:23:{s:4:"uuid";s:36:"214ae4e6-d98d-49ac-86cb-f319feaae828";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cJ6_jdvxb_glh6-HwEiUSPk5fAK43aWMRIjzMJtKQoA";}s:2:"id";s:16:"google_recaptcha";s:5:"label";s:16:"Google reCAPTCHA";s:11:"description";s:50:"reCAPTCHA is a CAPTCHA system owned by Google LLC.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:39:"https://www.google.com/recaptcha/about/";s:18:"privacy_policy_url";s:35:"https://policies.google.com/privacy";s:8:"purposes";a:1:{i:0;s:8:"security";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:3:{i:0;s:39:"https://www.google.com/recaptcha/api.js";i:1;s:42:"https://www.recaptcha.net/recaptcha/api.js";i:2;s:12:"recaptcha.js";}s:18:"wrapper_identifier";a:1:{i:0;s:12:".g-recaptcha";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.gtm', 'a:23:{s:4:"uuid";s:36:"45685c9b-3e44-4400-8e61-f103c6de582d";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"p1dtty8n0_QsIkVflvUTbHLiT0RpYW7huKeQOCTAgQE";}s:2:"id";s:3:"gtm";s:5:"label";s:18:"Google Tag Manager";s:11:"description";s:35:"Manages and deploys marketing tags.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:63:"https://marketingplatform.google.com/intl/de/about/tag-manager/";s:18:"privacy_policy_url";s:35:"https://policies.google.com/privacy";s:8:"purposes";a:1:{i:0;s:11:"advertising";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:3:{i:0;s:6:"gtm.js";i:1;s:7:"gtag.js";i:2;s:40:"https://www.googletagmanager.com/ns.html";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:1:{i:0;s:3:"gtm";}s:6:"weight";i:2;}'),
('', 'klaro.klaro_app.instagram', 'a:23:{s:4:"uuid";s:36:"88bd2d3b-2b4f-4d5f-b691-d296038c251a";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iNRJWR9llujUKVo3_0Pb8lFXSXUeSj2y2bg6xK3X-DQ";}s:2:"id";s:9:"instagram";s:5:"label";s:9:"Instagram";s:11:"description";s:66:"Instagram is a social media platform by Meta Platforms, Inc (USA).";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:28:"https://about.instagram.com/";s:18:"privacy_policy_url";s:42:"https://privacycenter.instagram.com/policy";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:26:"www.instagram.com/embed.js";}s:18:"wrapper_identifier";a:1:{i:0;s:16:".instagram-media";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.klaro', 'a:23:{s:4:"uuid";s:36:"7181f93b-7697-4a90-a3e2-2a8d221097a3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5FaC8_PP76ON-gppVAhTdnHRYooCqaMf-cDj-tSBhos";}s:2:"id";s:5:"klaro";s:5:"label";s:15:"Consent manager";s:11:"description";s:73:"Klaro! Cookie & Consent manager saves your consent status in the browser.";s:7:"default";b:1;s:8:"required";b:1;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:59:"https://github.com/klaro-org/klaro-js/blob/master/README.md";s:18:"privacy_policy_url";s:0:"";s:8:"purposes";a:1:{i:0;s:3:"cms";}s:7:"cookies";a:1:{i:0;a:3:{s:5:"regex";s:5:"klaro";s:4:"path";s:0:"";s:6:"domain";s:0:"";}}s:13:"callback_code";s:0:"";s:11:"javascripts";a:0:{}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.leaflet', 'a:23:{s:4:"uuid";s:36:"5706e912-b91e-4a38-a8ac-1c3cbc4296ff";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"xGsGOe4iv5uPr7X38FsUPaLmRoziapSCPgEsNTIyTZ0";}s:2:"id";s:7:"leaflet";s:5:"label";s:22:"External Map (Leaflet)";s:11:"description";s:116:"This service loads external maps via Leaflet. See privacy policy for more information about the chosen map provider.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:0:"";s:18:"privacy_policy_url";s:0:"";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:0:{}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.linkedin', 'a:23:{s:4:"uuid";s:36:"2f07791e-297e-463a-a3a6-ad90ba14ce3e";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2UYbcuxoVLN4VDT8JiLiVZ31ESUsac6CeAl4zcLy2Zw";}s:2:"id";s:8:"linkedin";s:5:"label";s:8:"Linkedin";s:11:"description";s:96:"Linkedin is a social media platform by Linkedin, Inc (USA), subsidiary of Microsoft Corp. (USA).";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:27:"https://about.linkedin.com/";s:18:"privacy_policy_url";s:45:"https://www.linkedin.com/legal/privacy-policy";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:16:"www.linkedin.com";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.mastodon', 'a:23:{s:4:"uuid";s:36:"67c8cd3c-b86d-4d65-9d18-ead6ce461416";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6qjt1wfIOxzlhFeLbPaV9cdeo9ec-Y-QLM1alxsTGAA";}s:2:"id";s:8:"mastodon";s:5:"label";s:33:"Mastodon social.bund.de (Example)";s:11:"description";s:88:"Mastodon for social.bund.de - you must adapt the URL for your preferred Mastodon server.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:25:"https://joinmastodon.org/";s:18:"privacy_policy_url";s:0:"";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:14:"social.bund.de";}s:18:"wrapper_identifier";a:1:{i:0;s:15:".mastodon-embed";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.mastodon_module', 'a:23:{s:4:"uuid";s:36:"8608ebfa-4e51-42d1-9749-e0df1b3b23ea";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BzFX1-YlTuEiAQhkp5w8qob5Xt--YNF7VLqRJzPQU60";}s:2:"id";s:15:"mastodon_module";s:5:"label";s:8:"Mastodon";s:11:"description";s:146:"Mastodon module for Drupal connects to given Mastodon server and stores posts in user''s browser. Personal data such as IP addresses are processed.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";b:0;s:23:"contextual_consent_text";s:0:"";s:8:"info_url";s:24:"https://mastodon.social/";s:18:"privacy_policy_url";s:38:"https://mastodon.social/privacy-policy";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:21:"mastodon.fed_embed.js";}s:18:"wrapper_identifier";a:1:{i:0;s:9:"fed-embed";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.matomo', 'a:23:{s:4:"uuid";s:36:"a6204944-8f6a-443d-b4e9-f7e8843eb402";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"n6Mv2ssZaK6w9tKtiTQVgW7HiBz-iALHiB2QlGlE-FE";}s:2:"id";s:6:"matomo";s:5:"label";s:6:"Matomo";s:11:"description";s:36:"Tracks online visits of the website.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:18:"https://matomo.org";s:18:"privacy_policy_url";s:33:"https://matomo.org/privacy-policy";s:8:"purposes";a:1:{i:0;s:9:"analytics";}s:7:"cookies";a:4:{i:0;a:3:{s:5:"regex";s:8:"^_pk_.*$";s:4:"path";s:0:"";s:6:"domain";s:0:"";}i:1;a:3:{s:5:"regex";s:10:"^matomo.*$";s:4:"path";s:0:"";s:6:"domain";s:0:"";}i:2;a:3:{s:5:"regex";s:8:"^mtm_.*$";s:4:"path";s:0:"";s:6:"domain";s:0:"";}i:3;a:3:{s:5:"regex";s:12:"piwik_ignore";s:4:"path";s:0:"";s:6:"domain";s:0:"";}}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:9:"matomo.js";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:1:{i:0;s:22:"matomo_tracking_script";}s:6:"weight";i:3;}'),
('', 'klaro.klaro_app.matomo_cookies', 'a:23:{s:4:"uuid";s:36:"10c4e3c0-390f-4a86-8a95-5fe660adad95";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DdJBlbMEM6Jt7omKCRqnVanOawB9Whrf0wWpj-CJBv8";}s:2:"id";s:14:"matomo_cookies";s:5:"label";s:22:"Matomo (block cookies)";s:11:"description";s:36:"Tracks online visits of the website.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:18:"https://matomo.org";s:18:"privacy_policy_url";s:33:"https://matomo.org/privacy-policy";s:8:"purposes";a:1:{i:0;s:9:"analytics";}s:7:"cookies";a:3:{i:0;a:3:{s:5:"regex";s:8:"^_pk_.*$";s:4:"path";s:0:"";s:6:"domain";s:0:"";}i:1;a:3:{s:5:"regex";s:12:"piwik_ignore";s:4:"path";s:0:"";s:6:"domain";s:0:"";}i:2;a:3:{s:5:"regex";s:18:"mtm_cookie_consent";s:4:"path";s:0:"";s:6:"domain";s:0:"";}}s:13:"callback_code";s:174:"if (typeof _paq !== ''undefined'') {\r\n  if (consent == true) {\r\n    _paq.push([''rememberCookieConsentGiven'']);\r\n  } else {\r\n    _paq.push([''forgetCookieConsentGiven'']);\r\n  }\r\n}";s:11:"javascripts";a:0:{}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:3;}'),
('', 'klaro.klaro_app.simple_popup_blocks', 'a:23:{s:4:"uuid";s:36:"b4c2b2ad-461a-4a7f-a12d-7853470d1a5d";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2DIYeBjP4A4xycO3g3v8wmVqJ9uhelaGln4Nz9ytWcc";}s:2:"id";s:19:"simple_popup_blocks";s:5:"label";s:19:"Simple Popup Blocks";s:11:"description";s:63:"Popups that will save into a cookie if they were already opened";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";b:0;s:23:"contextual_consent_text";s:0:"";s:8:"info_url";s:0:"";s:18:"privacy_policy_url";s:0:"";s:8:"purposes";a:1:{i:0;s:3:"cms";}s:7:"cookies";a:1:{i:0;a:3:{s:5:"regex";s:10:"spb_(_.*)?";s:4:"path";s:0:"";s:6:"domain";s:0:"";}}s:13:"callback_code";s:119:"var block = document.querySelector(''.simple-popup-blocks-global'');\r\nif (false == consent && block) {\r\nblock.remove()\r\n}";s:11:"javascripts";a:1:{i:0;s:46:"/simple_popup_blocks/js/simple_popup_blocks.js";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.threads', 'a:23:{s:4:"uuid";s:36:"7aabec2d-aa1e-4bac-a11d-8bb95f7c8f08";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"kReaAib6xEZo0ziOsmpR2WXSxhXMhOuLpEKVyMHMtns";}s:2:"id";s:7:"threads";s:5:"label";s:20:"Threads by Instagram";s:11:"description";s:64:"Threads is a social media platform by Meta Platforms, Inc (USA).";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:35:"https://about.instagram.com/threads";s:18:"privacy_policy_url";s:42:"https://about.instagram.com/safety/privacy";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:15:"www.threads.net";}s:18:"wrapper_identifier";a:1:{i:0;s:16:".text-post-media";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.tiktok', 'a:23:{s:4:"uuid";s:36:"211e59df-c797-4057-aee0-c51483de7e75";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VANMO9bKFMpdZ3Tz-c21Ejv8U78LRuGUs0nplDDJ4e0";}s:2:"id";s:6:"tiktok";s:5:"label";s:6:"TikTok";s:11:"description";s:75:"TikTok is a social media platform by Bytedance Ltd. (China/Cayman Islands).";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:28:"https://www.tiktok.com/about";s:18:"privacy_policy_url";s:47:"https://www.tiktok.com/legal/privacy-policy-row";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:14:"www.tiktok.com";}s:18:"wrapper_identifier";a:1:{i:0;s:13:".tiktok-embed";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.umami', 'a:23:{s:4:"uuid";s:36:"2411f68b-6add-4272-95ad-dadee4456752";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vN8TfPdEQ-WQeGejDogrVhptSSDdSy2U4jHZ80cmM7s";}s:2:"id";s:5:"umami";s:5:"label";s:5:"Umami";s:11:"description";s:36:"Tracks online visits of the website.";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";b:0;s:23:"contextual_consent_text";s:0:"";s:8:"info_url";s:16:"https://umami.is";s:18:"privacy_policy_url";s:24:"https://umami.is/privacy";s:8:"purposes";a:1:{i:0;s:9:"analytics";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:8:"umami.js";}s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:1:{i:0;s:31:"umami_analytics_tracking_script";}s:6:"weight";i:4;}'),
('', 'klaro.klaro_app.vimeo', 'a:23:{s:4:"uuid";s:36:"0ed83ff9-694f-4b1d-9d92-d354613e5452";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U6qalwZKD1yRnEEimqvgovefpsmYuoXB7zSWZ_n-57U";}s:2:"id";s:5:"vimeo";s:5:"label";s:5:"Vimeo";s:11:"description";s:54:"Vimeo is a video sharing platform by Vimeo, LLC (USA).";s:7:"default";b:0;s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:18:"https://vimeo.com/";s:18:"privacy_policy_url";s:25:"https://vimeo.com/privacy";s:11:"javascripts";a:1:{i:0;s:9:"vimeo.com";}s:13:"callback_code";s:0:"";s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.x', 'a:23:{s:4:"uuid";s:36:"59ed23e2-2f03-49ac-97c3-2297284c875b";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"30nD-PfLJzOQ9q4Zls4kVESZf25cg-IhPNE_CSi9Bgo";}s:2:"id";s:1:"x";s:5:"label";s:1:"X";s:11:"description";s:74:"X (formerly known as Twitter) is a social media platform by X Corp. (USA).";s:7:"default";b:0;s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:14:"https://x.com/";s:18:"privacy_policy_url";s:24:"https://x.com/en/privacy";s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:13:"callback_code";s:0:"";s:11:"javascripts";a:1:{i:0;s:31:"platform.twitter.com/widgets.js";}s:18:"wrapper_identifier";a:1:{i:0;s:14:".twitter-tweet";}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_app.youtube', 'a:23:{s:4:"uuid";s:36:"630a9546-67da-478b-9b5d-59990a1dbe77";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ETjeewYXUBo_zLRzIlijtavOYTyqTUkqyMsUM2x3FYo";}s:2:"id";s:7:"youtube";s:5:"label";s:7:"YouTube";s:11:"description";s:60:"YouTube is an online video sharing platform owned by Google.";s:7:"default";b:0;s:8:"purposes";a:1:{i:0;s:16:"external_content";}s:7:"cookies";a:0:{}s:8:"required";b:0;s:7:"opt_out";b:0;s:9:"only_once";b:0;s:23:"contextual_consent_only";N;s:23:"contextual_consent_text";N;s:8:"info_url";s:24:"https://www.youtube.com/";s:18:"privacy_policy_url";s:77:"https://www.youtube.com/howyoutubeworks/our-commitments/protecting-user-data/";s:11:"javascripts";a:4:{i:0;s:11:"youtube.com";i:1;s:8:"youtu.be";i:2;s:20:"youtube-nocookie.com";i:3;s:9:"ytimg.com";}s:13:"callback_code";s:0:"";s:18:"wrapper_identifier";a:0:{}s:11:"attachments";a:0:{}s:6:"weight";i:0;}'),
('', 'klaro.klaro_purpose.advertising', 'a:9:{s:4:"uuid";s:36:"7b1184a4-75ae-4b32-9362-e4e85f80543c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"p0Xmtt8DXCK7YDyQCjx9e34PXU7oZopObzexorM4geo";}s:2:"id";s:11:"advertising";s:5:"label";s:25:"Advertising and Marketing";s:11:"description";s:0:"";s:6:"weight";i:0;}'),
('', 'klaro.klaro_purpose.analytics', 'a:9:{s:4:"uuid";s:36:"e2328988-a21d-4363-82a9-467bdb1e54f6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DaAAmHlWMVahC2MmhRKQN8Lun9hBPT6LR6PCjkCEikI";}s:2:"id";s:9:"analytics";s:5:"label";s:9:"Analytics";s:11:"description";s:0:"";s:6:"weight";i:1;}'),
('', 'klaro.klaro_purpose.cms', 'a:9:{s:4:"uuid";s:36:"e5352888-4282-4767-956d-34d17251a6d3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3j5wXqDkwDxjQzmBncu4QboNV0z9hzVwJug3j5IpigQ";}s:2:"id";s:3:"cms";s:5:"label";s:10:"Functional";s:11:"description";s:0:"";s:6:"weight";i:-1;}'),
('', 'klaro.klaro_purpose.external_content', 'a:9:{s:4:"uuid";s:36:"018b82f3-0026-4c8f-ada9-1e826ea42052";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DdVZR131nyy6OVL9mBguPmzKgAzSs-6NjqEdbkF55NI";}s:2:"id";s:16:"external_content";s:5:"label";s:25:"Embedded external content";s:11:"description";s:0:"";s:6:"weight";i:6;}'),
('', 'klaro.klaro_purpose.livechat', 'a:9:{s:4:"uuid";s:36:"8ad470fd-06a8-47c2-9d82-ba0ea32eb820";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1PTw_ErrIEO0qT4X6G3QCbRnAnoKOpaqwQiAWHbisGg";}s:2:"id";s:8:"livechat";s:5:"label";s:9:"Live chat";s:11:"description";s:0:"";s:6:"weight";i:3;}'),
('', 'klaro.klaro_purpose.security', 'a:9:{s:4:"uuid";s:36:"bc1630d8-cedb-4555-ad90-64ae983d651e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"viRP54gfVbiAJggsHB02B_iBsSqhc8KLC7lngFFBP5Q";}s:2:"id";s:8:"security";s:5:"label";s:8:"Security";s:11:"description";s:0:"";s:6:"weight";i:4;}'),
('', 'klaro.klaro_purpose.styling', 'a:9:{s:4:"uuid";s:36:"e6769083-4f28-4b89-b904-a1f49ce04c5c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zb5fw3XvVMA3iaOX1CO7qm1YLv0IzThvz3HQvDcsLA8";}s:2:"id";s:7:"styling";s:5:"label";s:7:"Styling";s:11:"description";s:0:"";s:6:"weight";i:5;}'),
('', 'klaro.settings', 'a:21:{s:8:"langcode";s:2:"en";s:11:"dialog_mode";s:6:"silent";s:24:"auto_decorate_final_html";b:1;s:22:"auto_decorate_js_alter";b:1;s:30:"auto_decorate_page_attachments";b:1;s:30:"auto_decorate_preprocess_field";b:1;s:20:"get_entity_thumbnail";b:1;s:13:"block_unknown";b:0;s:21:"log_unknown_resources";b:0;s:19:"block_unknown_label";s:16:"Unknown services";s:25:"block_unknown_description";s:43:"Allow loading of unknown external resources";s:18:"show_toggle_button";b:0;s:17:"show_close_button";b:0;s:24:"deletable_cookie_domains";a:0:{}s:12:"exclude_urls";a:0:{}s:12:"disable_urls";a:0:{}s:6:"styles";a:1:{i:0;s:5:"light";}s:20:"process_descriptions";b:0;s:12:"override_css";b:1;s:17:"show_notice_title";b:0;s:7:"library";a:14:{s:10:"element_id";s:5:"klaro";s:14:"storage_method";s:6:"cookie";s:11:"cookie_name";s:5:"klaro";s:25:"cookie_expires_after_days";i:180;s:13:"cookie_domain";s:0:"";s:16:"group_by_purpose";b:1;s:10:"accept_all";b:0;s:16:"hide_decline_all";b:0;s:15:"hide_learn_more";b:0;s:20:"learn_more_as_button";b:0;s:16:"additional_class";s:0:"";s:18:"disable_powered_by";b:0;s:10:"html_texts";b:0;s:10:"auto_focus";b:1;}}'),
('', 'klaro.texts', 'a:12:{s:8:"langcode";s:2:"en";s:12:"consentModal";a:3:{s:5:"title";s:32:"Use of personal data and cookies";s:11:"description";s:76:"Please choose the services and 3rd party applications we would like to use.\n";s:13:"privacyPolicy";a:3:{s:4:"name";s:14:"privacy policy";s:4:"text";s:48:"To learn more, please read our {privacyPolicy}.\n";s:3:"url";s:24:"internal:/privacy-policy";}}s:13:"consentNotice";a:4:{s:5:"title";s:32:"Use of personal data and cookies";s:17:"changeDescription";s:69:"There were changes since your last visit, please update your consent.";s:11:"description";s:81:"We use cookies and process personal data for the following purposes: {purposes}.\n";s:9:"learnMore";s:9:"Customize";}s:2:"ok";s:6:"Accept";s:4:"save";s:4:"Save";s:7:"decline";s:7:"Decline";s:5:"close";s:5:"Close";s:9:"acceptAll";s:10:"Accept all";s:14:"acceptSelected";s:15:"Accept selected";s:7:"service";a:5:{s:10:"disableAll";a:2:{s:5:"title";s:19:"Toggle all services";s:11:"description";s:47:"Use this switch to enable/disable all services.";}s:6:"optOut";a:2:{s:5:"title";s:9:"(opt-out)";s:11:"description";s:53:"This service is loaded by default (opt-out possible).";}s:8:"required";a:2:{s:5:"title";s:17:"(always required)";s:11:"description";s:32:"This service is always required.";}s:8:"purposes";s:8:"Purposes";s:7:"purpose";s:7:"Purpose";}s:17:"contextualConsent";a:3:{s:12:"acceptAlways";s:6:"Always";s:10:"acceptOnce";s:15:"Yes (this time)";s:11:"description";s:42:"Load external content supplied by {title}?";}s:9:"poweredBy";s:17:"Powered by Klaro!";}'),
('', 'linkit.linkit_profile.default', 'a:9:{s:4:"uuid";s:36:"d44d7aad-b7b5-4996-8caf-8f3d51977c8a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-OA36tRZkthwtA4QzlWDUFHfvtKu1rJCY9S9FMX4fhI";}s:5:"label";s:7:"Default";s:2:"id";s:7:"default";s:11:"description";s:24:"A default Linkit profile";s:8:"matchers";a:2:{s:36:"556010a3-e317-48b3-b4ed-854c10f4b950";a:4:{s:2:"id";s:11:"entity:node";s:4:"uuid";s:36:"556010a3-e317-48b3-b4ed-854c10f4b950";s:8:"settings";a:6:{s:8:"metadata";s:72:"[node:content-type:name] by [node:author] on [node:created:custom:j M Y]";s:7:"bundles";a:0:{}s:15:"group_by_bundle";b:0;s:17:"substitution_type";s:9:"canonical";s:5:"limit";i:100;s:19:"include_unpublished";b:1;}s:6:"weight";i:0;}s:36:"f82bb77f-274f-4ef3-8aaa-30754dc9914c";a:4:{s:2:"id";s:12:"entity:media";s:4:"uuid";s:36:"f82bb77f-274f-4ef3-8aaa-30754dc9914c";s:8:"settings";a:5:{s:8:"metadata";s:0:"";s:7:"bundles";a:1:{s:8:"document";s:8:"document";}s:15:"group_by_bundle";b:0;s:17:"substitution_type";s:5:"media";s:5:"limit";i:100;}s:6:"weight";i:0;}}}'),
('', 'mailsystem.settings', 'a:3:{s:5:"theme";s:16:"easy_email_theme";s:8:"defaults";a:2:{s:6:"sender";s:19:"symfony_mailer_lite";s:9:"formatter";s:19:"symfony_mailer_lite";}s:7:"modules";a:2:{s:19:"symfony_mailer_lite";a:1:{s:4:"none";a:2:{s:6:"sender";s:19:"symfony_mailer_lite";s:9:"formatter";s:19:"symfony_mailer_lite";}}s:10:"easy_email";a:1:{s:4:"none";a:2:{s:6:"sender";s:19:"symfony_mailer_lite";s:9:"formatter";s:19:"symfony_mailer_lite";}}}}'),
('', 'media.settings', 'a:4:{s:13:"icon_base_uri";s:28:"public://media-icons/generic";s:13:"iframe_domain";N;s:20:"oembed_providers_url";s:33:"https://oembed.com/providers.json";s:14:"standalone_url";b:0;}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'media.type.document', 'a:13:{s:4:"uuid";s:36:"7525b5bf-8e0c-4629-b2af-54543f52009e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_D9q3XSnP6ik9we9UuoTvZsQKPuYNp_G9PfwVtWzgnQ";}s:2:"id";s:8:"document";s:5:"label";s:8:"Document";s:11:"description";s:44:"An uploaded file or document, such as a PDF.";s:6:"source";s:4:"file";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:1:{s:12:"source_field";s:20:"field_media_document";}s:9:"field_map";a:1:{s:4:"name";s:4:"name";}}'),
('', 'media.type.image', 'a:13:{s:4:"uuid";s:36:"123997d5-44b3-41ef-a94f-0f92ffe3933a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6Qope5wG7HUpV0tPOBMtDI_GZkHFcF1Xj4hgD9Cu_hM";}s:2:"id";s:5:"image";s:5:"label";s:5:"Image";s:11:"description";s:36:"Use local images for reusable media.";s:6:"source";s:5:"image";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:1:{s:12:"source_field";s:17:"field_media_image";}s:9:"field_map";a:1:{s:4:"name";s:4:"name";}}'),
('', 'media.type.remote_video', 'a:13:{s:4:"uuid";s:36:"b6c6b341-c27d-4248-aabb-0a80b0e23696";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hIBTnDGgDKnCiP6HUZm1m7600DHUEpC6FN3LQ4sUgZ4";}s:2:"id";s:12:"remote_video";s:5:"label";s:12:"Remote video";s:11:"description";s:46:"A remotely hosted video from YouTube or Vimeo.";s:6:"source";s:12:"oembed:video";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:1;s:20:"source_configuration";a:3:{s:12:"source_field";s:24:"field_media_oembed_video";s:20:"thumbnails_directory";s:44:"public://oembed_thumbnails/[date:custom:Y-m]";s:9:"providers";a:2:{i:0;s:7:"YouTube";i:1;s:5:"Vimeo";}}s:9:"field_map";a:1:{s:5:"title";s:4:"name";}}'),
('', 'media.type.svg_image', 'a:13:{s:4:"uuid";s:36:"d9e54f30-b1f8-4d1d-9cbd-20d0312c40c1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"kY__LOOCcyCZcd_DkDa-w7gXfB83wAXe49p2ISIAUQ8";}s:2:"id";s:9:"svg_image";s:5:"label";s:9:"SVG Image";s:11:"description";s:60:"A locally hosted SVG file that can be displayed as an image.";s:6:"source";s:5:"image";s:25:"queue_thumbnail_downloads";b:0;s:12:"new_revision";b:0;s:20:"source_configuration";a:1:{s:12:"source_field";s:21:"field_media_svg_image";}s:9:"field_map";a:0:{}}'),
('', 'media_library.settings', 'a:1:{s:11:"advanced_ui";b:0;}'),
('', 'menu_link_attributes.config', 'a:1:{s:10:"attributes";a:4:{s:15:"container_class";a:2:{s:5:"label";s:19:"Container class(es)";s:11:"description";s:82:"CSS class for the menu list item (&lt;li&gt;). Separate multiple classes by space.";}s:5:"class";a:2:{s:5:"label";s:14:"Link class(es)";s:11:"description";s:76:"CSS class for the link (&lt;a href&gt;). Separate multiple classes by space.";}s:6:"target";a:4:{s:5:"label";s:11:"Link target";s:11:"description";s:0:"";s:7:"options";a:2:{s:6:"_blank";s:19:"New window (_blank)";s:5:"_self";s:19:"Same window (_self)";}s:13:"default_value";s:0:"";}s:3:"rel";a:2:{s:5:"label";s:12:"Relationship";s:11:"description";s:100:"The "rel" attribute specifies the relationship between the current document and the linked document.";}}}'),
('', 'menu_ui.settings', 'a:1:{s:24:"override_parent_selector";b:0;}'),
('', 'navigation.block_layout', 'a:2:{s:8:"langcode";s:2:"en";s:8:"sections";a:1:{i:0;a:4:{s:9:"layout_id";s:17:"navigation_layout";s:15:"layout_settings";a:1:{s:5:"label";s:0:"";}s:10:"components";a:6:{s:36:"2622e40b-8786-4b8c-8883-19e49da53023";a:5:{s:4:"uuid";s:36:"2622e40b-8786-4b8c-8883-19e49da53023";s:6:"region";s:7:"content";s:13:"configuration";a:4:{s:2:"id";s:20:"navigation_dashboard";s:5:"label";s:9:"Dashboard";s:13:"label_display";s:1:"0";s:8:"provider";s:9:"dashboard";}s:6:"weight";i:0;s:10:"additional";a:0:{}}s:36:"3ff7be01-c8b0-4444-88f3-2364d7a8054e";a:5:{s:4:"uuid";s:36:"3ff7be01-c8b0-4444-88f3-2364d7a8054e";s:6:"region";s:7:"content";s:13:"configuration";a:6:{s:2:"id";s:23:"navigation_menu:content";s:5:"label";s:7:"Content";s:13:"label_display";s:1:"0";s:8:"provider";s:10:"navigation";s:5:"level";i:1;s:5:"depth";i:2;}s:6:"weight";i:1;s:10:"additional";a:0:{}}s:36:"3f2f743f-856f-404a-9c28-57ee83af4691";a:5:{s:4:"uuid";s:36:"3f2f743f-856f-404a-9c28-57ee83af4691";s:6:"region";s:7:"content";s:13:"configuration";a:6:{s:2:"id";s:21:"navigation_menu:admin";s:5:"label";s:14:"Administration";s:13:"label_display";s:1:"0";s:8:"provider";s:10:"navigation";s:5:"level";i:2;s:5:"depth";i:2;}s:6:"weight";i:2;s:10:"additional";a:0:{}}s:36:"283da777-e051-4571-8089-47633a9ce706";a:5:{s:4:"uuid";s:36:"283da777-e051-4571-8089-47633a9ce706";s:6:"region";s:6:"footer";s:13:"configuration";a:4:{s:2:"id";s:15:"navigation_user";s:5:"label";s:4:"User";s:13:"label_display";s:1:"0";s:8:"provider";s:10:"navigation";}s:6:"weight";i:0;s:10:"additional";a:0:{}}s:36:"6d7080a7-abab-4bad-b960-2459ca892a54";a:5:{s:4:"uuid";s:36:"6d7080a7-abab-4bad-b960-2459ca892a54";s:6:"region";s:6:"footer";s:13:"configuration";a:8:{s:2:"id";s:15:"navigation_link";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:10:"navigation";s:15:"context_mapping";a:0:{}s:5:"title";s:4:"Help";s:3:"uri";s:20:"internal:/admin/help";s:10:"icon_class";s:4:"help";}s:6:"weight";i:-2;s:10:"additional";a:0:{}}s:36:"52e884dd-0301-4265-b2b3-9cea53a403f3";a:5:{s:4:"uuid";s:36:"52e884dd-0301-4265-b2b3-9cea53a403f3";s:6:"region";s:6:"footer";s:13:"configuration";a:7:{s:2:"id";s:15:"navigation_link";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:10:"navigation";s:5:"title";s:4:"Help";s:3:"uri";s:38:"https://new.drupal.org/docs/drupal-cms";s:10:"icon_class";s:4:"help";}s:6:"weight";i:-2;s:10:"additional";a:0:{}}}s:20:"third_party_settings";a:0:{}}}}'),
('', 'navigation.settings', 'a:1:{s:4:"logo";a:3:{s:8:"provider";s:7:"default";s:4:"path";s:0:"";s:3:"max";a:3:{s:8:"filesize";i:1048576;s:6:"height";i:40;s:5:"width";i:40;}}}'),
('', 'node.settings', 'a:1:{s:15:"use_admin_theme";b:1;}'),
('', 'node.type.page', 'a:13:{s:4:"uuid";s:36:"4ccbbfa0-6ff8-4772-a111-fba705e50e86";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:9:"scheduler";}}s:20:"third_party_settings";a:1:{s:9:"scheduler";a:12:{s:15:"expand_fieldset";s:13:"when_required";s:19:"fields_display_mode";s:12:"vertical_tab";s:14:"publish_enable";b:1;s:17:"publish_past_date";s:5:"error";s:25:"publish_past_date_created";b:0;s:16:"publish_required";b:0;s:16:"publish_revision";b:1;s:13:"publish_touch";b:1;s:25:"show_message_after_update";b:1;s:16:"unpublish_enable";b:1;s:18:"unpublish_required";b:0;s:18:"unpublish_revision";b:1;}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ofBTVP5AmqIoiRQxuySnBpPvyzCT2nG0UVvuAZaGt3g";}s:4:"name";s:10:"Basic page";s:4:"type";s:4:"page";s:11:"description";s:77:"Use <em>basic pages</em> for your static content, such as an ''About us'' page.";s:4:"help";N;s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:0;}'),
('', 'olivero.settings', 'a:7:{s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";s:18:"base_primary_color";s:7:"#1b9ae4";}'),
('', 'package_manager.settings', 'a:2:{s:35:"additional_trusted_composer_plugins";a:1:{i:0;s:12:"tbachert/spi";}s:37:"include_unknown_files_in_project_root";b:0;}'),
('', 'pathauto.pattern.menu_path', 'a:13:{s:4:"uuid";s:36:"1d502da6-4c3e-4f26-b007-ea2c28b852b0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"m-a2LUHptfRoh6Bpm6Tqewk6RI4bBLHSf1jhBpfPqHY";}s:2:"id";s:9:"menu_path";s:5:"label";s:9:"Menu Path";s:4:"type";s:23:"canonical_entities:node";s:7:"pattern";s:47:"[node:menu-link:parents:join-path]/[node:title]";s:18:"selection_criteria";a:0:{}s:15:"selection_logic";s:3:"and";s:6:"weight";i:10;s:13:"relationships";a:0:{}}'),
('', 'pathauto.pattern.page_content', 'a:13:{s:4:"uuid";s:36:"d9471a27-10c9-4109-81aa-1dd65924b64a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"node";}s:8:"enforced";a:1:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ufS9yFb1v8YrfiIRN4steBSrb1NQGxkfZLSUls3rWU4";}s:2:"id";s:12:"page_content";s:5:"label";s:12:"Page content";s:4:"type";s:23:"canonical_entities:node";s:7:"pattern";s:13:"/[node:title]";s:18:"selection_criteria";a:1:{s:36:"425d6456-71e3-4b65-9302-6c695efaab28";a:5:{s:2:"id";s:18:"entity_bundle:node";s:6:"negate";b:0;s:4:"uuid";s:36:"425d6456-71e3-4b65-9302-6c695efaab28";s:15:"context_mapping";a:1:{s:4:"node";s:4:"node";}s:7:"bundles";a:1:{s:4:"page";s:4:"page";}}}s:15:"selection_logic";s:3:"and";s:6:"weight";i:-5;s:13:"relationships";a:0:{}}'),
('', 'pathauto.settings', 'a:12:{s:20:"enabled_entity_types";a:1:{i:0;s:4:"user";}s:11:"punctuation";a:1:{s:6:"hyphen";i:1;}s:7:"verbose";b:0;s:9:"separator";s:1:"-";s:10:"max_length";i:100;s:20:"max_component_length";i:100;s:13:"transliterate";b:1;s:12:"reduce_ascii";b:0;s:4:"case";b:1;s:12:"ignore_words";s:134:"a, an, as, at, before, but, by, for, from, is, in, into, like, of, off, on, onto, per, since, than, the, this, that, to, up, via, with";s:13:"update_action";i:2;s:11:"safe_tokens";a:6:{i:0;s:5:"alias";i:1;s:4:"path";i:2;s:9:"join-path";i:3;s:9:"login-url";i:4;s:3:"url";i:5;s:9:"url-brief";}}'),
('', 'project_browser.admin_settings', 'a:4:{s:14:"default_source";s:17:"drupalorg_jsonapi";s:15:"enabled_sources";a:2:{s:11:"recommended";a:1:{s:3:"uri";s:95:"https://git.drupalcode.org/api/v4/projects/167158/repository/files/recommended.yml/raw?ref=HEAD";}s:17:"drupalorg_jsonapi";a:0:{}}s:16:"allow_ui_install";b:1;s:14:"max_selections";i:1;}'),
('', 'redirect.settings', 'a:7:{s:13:"auto_redirect";b:1;s:19:"default_status_code";i:301;s:23:"passthrough_querystring";b:1;s:7:"warning";b:0;s:17:"ignore_admin_path";b:0;s:12:"access_check";b:0;s:24:"route_normalizer_enabled";b:1;}'),
('', 'redirect_404.settings', 'a:3:{s:9:"row_limit";i:10000;s:5:"pages";s:0:"";s:12:"suppress_404";b:1;}'),
('', 'responsive_image.styles.16_9_large', 'a:10:{s:4:"uuid";s:36:"ecf971e2-9d2f-4910-b212-86fb221c4008";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:41:"image.style.16_9_512x288_focal_point_webp";i:1;s:41:"image.style.16_9_704x396_focal_point_webp";i:2;s:41:"image.style.16_9_960x540_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"S4-Tq7YR9BkjoihSNREBjphKN_h6rsrBFiSszggZzrM";}s:2:"id";s:10:"16_9_large";s:5:"label";s:10:"16:9 Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:29:"16_9_512x288_focal_point_webp";i:1;s:29:"16_9_704x396_focal_point_webp";i:2;s:29:"16_9_960x540_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"16_9_512x288_focal_point_webp";}'),
('', 'responsive_image.styles.16_9_medium', 'a:10:{s:4:"uuid";s:36:"4b7fb23d-4501-46b7-8e40-fbf42636fe86";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:41:"image.style.16_9_512x288_focal_point_webp";i:1;s:41:"image.style.16_9_608x342_focal_point_webp";i:2;s:41:"image.style.16_9_720x405_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mq4zS3NclUIsDOU5ZLBG6N7UJ3_jELLRHlnDr8mwmtk";}s:2:"id";s:11:"16_9_medium";s:5:"label";s:11:"16:9 Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:29:"16_9_512x288_focal_point_webp";i:1;s:29:"16_9_608x342_focal_point_webp";i:2;s:29:"16_9_720x405_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"16_9_512x288_focal_point_webp";}'),
('', 'responsive_image.styles.16_9_small', 'a:10:{s:4:"uuid";s:36:"ead271d6-e248-4827-a7b6-137b9a0adb93";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:41:"image.style.16_9_304x171_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7NUEYvcLoUeexjZ8i4-W1asbRxdfoSYwdcwxEAmhYnM";}s:2:"id";s:10:"16_9_small";s:5:"label";s:10:"16:9 Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:29:"16_9_304x171_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"16_9_304x171_focal_point_webp";}'),
('', 'responsive_image.styles.16_9_wide', 'a:10:{s:4:"uuid";s:36:"4dc11ab8-886f-4433-90a9-1a9128f210a0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:42:"image.style.16_9_1008x567_focal_point_webp";i:1;s:42:"image.style.16_9_1312x738_focal_point_webp";i:2;s:43:"image.style.16_9_1800x1080_focal_point_webp";i:3;s:41:"image.style.16_9_512x288_focal_point_webp";i:4;s:41:"image.style.16_9_704x396_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N9LTVunYZ9ep9ovn548LrCwAcOxHKSRPuZ9VoHzYoSA";}s:2:"id";s:9:"16_9_wide";s:5:"label";s:9:"16:9 Wide";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:5:{i:0;s:30:"16_9_1008x567_focal_point_webp";i:1;s:30:"16_9_1312x738_focal_point_webp";i:2;s:31:"16_9_1800x1080_focal_point_webp";i:3;s:29:"16_9_512x288_focal_point_webp";i:4;s:29:"16_9_704x396_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"16_9_512x288_focal_point_webp";}'),
('', 'responsive_image.styles.1_1_large', 'a:10:{s:4:"uuid";s:36:"e4408dc3-887f-49c0-bb4b-e12a6bd01dfe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:40:"image.style.1_1_500x500_focal_point_webp";i:1;s:40:"image.style.1_1_600x600_focal_point_webp";i:2;s:40:"image.style.1_1_960x960_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8ajHzD3HYeNz0fUtaC3B4fTALuPxvjZKkVg6wr4g8kA";}s:2:"id";s:9:"1_1_large";s:5:"label";s:18:"1:1 (Square) Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:28:"1_1_500x500_focal_point_webp";i:1;s:28:"1_1_600x600_focal_point_webp";i:2;s:28:"1_1_960x960_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"1_1_500x500_focal_point_webp";}'),
('', 'responsive_image.styles.1_1_medium', 'a:10:{s:4:"uuid";s:36:"cd7eeb37-fcd9-4282-8ebb-97ea20d23331";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:40:"image.style.1_1_500x500_focal_point_webp";i:1;s:40:"image.style.1_1_600x600_focal_point_webp";i:2;s:40:"image.style.1_1_720x720_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktpky4Z530bMqKLP86Qs2x-bDC7dvzsWL1TlEjehoPg";}s:2:"id";s:10:"1_1_medium";s:5:"label";s:19:"1:1 (Square) Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:28:"1_1_500x500_focal_point_webp";i:1;s:28:"1_1_600x600_focal_point_webp";i:2;s:28:"1_1_720x720_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"1_1_500x500_focal_point_webp";}'),
('', 'responsive_image.styles.1_1_square_small', 'a:10:{s:4:"uuid";s:36:"643e7a2a-8181-470a-9e45-2e7a6c821151";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:40:"image.style.1_1_300x300_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EXaEg4fstTvEHl6g1aakZeiu5c3GwJd4oJGqPjENuwc";}s:2:"id";s:16:"1_1_square_small";s:5:"label";s:18:"1:1 (Square) Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:28:"1_1_300x300_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"1_1_300x300_focal_point_webp";}'),
('', 'responsive_image.styles.2_3_large', 'a:10:{s:4:"uuid";s:36:"96f2ec63-8902-44d8-9bfb-7e26288fb323";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:40:"image.style.2_3_500x750_focal_point_webp";i:1;s:40:"image.style.2_3_640x960_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vRGV07SFQiS31VP-_zidgTkuiyuVKFpstWqpVDwbLzE";}s:2:"id";s:9:"2_3_large";s:5:"label";s:9:"2:3 Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:2:{i:0;s:28:"2_3_500x750_focal_point_webp";i:1;s:28:"2_3_640x960_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"2_3_500x750_focal_point_webp";}'),
('', 'responsive_image.styles.2_3_medium', 'a:10:{s:4:"uuid";s:36:"5dea8bf0-8205-451b-a705-5ce841e181e8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:40:"image.style.2_3_400x600_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hjBsSKLOVpw9Ewq4koDvW8PvIkC1zVv8kMRlaA11SHU";}s:2:"id";s:10:"2_3_medium";s:5:"label";s:10:"2:3 Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:28:"2_3_400x600_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"2_3_400x600_focal_point_webp";}'),
('', 'responsive_image.styles.2_3_small', 'a:10:{s:4:"uuid";s:36:"395ffcb7-76b5-47fd-90f2-073f736ff6e5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:40:"image.style.2_3_200x300_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"P4x7phUB2FCg8BlxB1lkQbqRyOGk9xpnpGE15a2pzk8";}s:2:"id";s:9:"2_3_small";s:5:"label";s:9:"2:3 Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:28:"2_3_200x300_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"2_3_200x300_focal_point_webp";}'),
('', 'responsive_image.styles.3_2_large', 'a:10:{s:4:"uuid";s:36:"3444ac23-e49e-4a75-84c3-dcc304c73117";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:40:"image.style.3_2_504x336_focal_point_webp";i:1;s:40:"image.style.3_2_702x468_focal_point_webp";i:2;s:40:"image.style.3_2_960x640_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MHQTjncrgntre1ahNWfgpaffd40bLa1uf5fpeWLtKA0";}s:2:"id";s:9:"3_2_large";s:5:"label";s:9:"3:2 Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:28:"3_2_504x336_focal_point_webp";i:1;s:28:"3_2_702x468_focal_point_webp";i:2;s:28:"3_2_960x640_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"3_2_504x336_focal_point_webp";}'),
('', 'responsive_image.styles.3_2_medium', 'a:10:{s:4:"uuid";s:36:"7e884429-bf7a-429d-b43d-3bb8269bc3dd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:40:"image.style.3_2_504x336_focal_point_webp";i:1;s:40:"image.style.3_2_600x400_focal_point_webp";i:2;s:40:"image.style.3_2_720x480_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6roo0qawEBX5lGH5eyn937sjWEflqMgn9B7NUnsoOO4";}s:2:"id";s:10:"3_2_medium";s:5:"label";s:10:"3:2 Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:28:"3_2_504x336_focal_point_webp";i:1;s:28:"3_2_600x400_focal_point_webp";i:2;s:28:"3_2_720x480_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"3_2_504x336_focal_point_webp";}'),
('', 'responsive_image.styles.3_2_small', 'a:10:{s:4:"uuid";s:36:"ccbb5528-a1c9-45ad-a6a8-454725dabf5a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:40:"image.style.3_2_300x200_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"xnztAPpGg0kU1AWGeqTM5Lw0jtj78wizlcMTGYBfUbM";}s:2:"id";s:9:"3_2_small";s:5:"label";s:9:"3:2 Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:28:"3_2_300x200_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"3_2_300x200_focal_point_webp";}'),
('', 'responsive_image.styles.3_2_wide', 'a:10:{s:4:"uuid";s:36:"e1e36895-4659-4a02-bc11-7f559a691759";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:41:"image.style.3_2_1002x668_focal_point_webp";i:1;s:41:"image.style.3_2_1302x868_focal_point_webp";i:2;s:42:"image.style.3_2_1800x1200_focal_point_webp";i:3;s:40:"image.style.3_2_504x336_focal_point_webp";i:4;s:40:"image.style.3_2_702x468_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TAKtqHc8qd9rV3ayKqVjOw3Cwl4ZgzAt5shSGJfiP08";}s:2:"id";s:8:"3_2_wide";s:5:"label";s:8:"3:2 Wide";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:5:{i:0;s:29:"3_2_1002x668_focal_point_webp";i:1;s:29:"3_2_1302x868_focal_point_webp";i:2;s:30:"3_2_1800x1200_focal_point_webp";i:3;s:28:"3_2_504x336_focal_point_webp";i:4;s:28:"3_2_702x468_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"3_2_504x336_focal_point_webp";}'),
('', 'responsive_image.styles.3_4_large', 'a:10:{s:4:"uuid";s:36:"d30e4cd9-75a0-403c-9dc0-d8d70e420ddc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:40:"image.style.3_4_504x672_focal_point_webp";i:1;s:40:"image.style.3_4_708x944_focal_point_webp";i:2;s:40:"image.style.3_4_720x960_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dF-GUw56Cnp-jYucCeVt0slNMlsJhc3hKT24Fe5Kx-o";}s:2:"id";s:9:"3_4_large";s:5:"label";s:9:"3:4 Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:28:"3_4_504x672_focal_point_webp";i:1;s:28:"3_4_708x944_focal_point_webp";i:2;s:28:"3_4_720x960_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"3_4_504x672_focal_point_webp";}'),
('', 'responsive_image.styles.3_4_medium', 'a:10:{s:4:"uuid";s:36:"6276f73b-df9d-4c52-a5da-3b7ef1b7d781";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:40:"image.style.3_4_450x600_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Fr0e6yt1MhidlYWl0XfXIghuIfpyPedcwgEus8CoQ-g";}s:2:"id";s:10:"3_4_medium";s:5:"label";s:10:"3:4 Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:28:"3_4_450x600_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"3_4_450x600_focal_point_webp";}'),
('', 'responsive_image.styles.3_4_small', 'a:10:{s:4:"uuid";s:36:"d567802e-bc19-4bf8-81b5-67d17b88037e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:40:"image.style.3_4_225x300_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"f3TukTGdoAxixCwYlYWmQoEff0EsZbvcSWgM0ICu-7Y";}s:2:"id";s:9:"3_4_small";s:5:"label";s:9:"3:4 Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:28:"3_4_225x300_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"3_4_225x300_focal_point_webp";}'),
('', 'responsive_image.styles.4_3_large', 'a:10:{s:4:"uuid";s:36:"20e11470-8d4b-4acf-a311-a69bb76f3b0f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:40:"image.style.4_3_500x375_focal_point_webp";i:1;s:40:"image.style.4_3_700x525_focal_point_webp";i:2;s:40:"image.style.4_3_960x720_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0rk_gkOqh410UcQIbDVO-RVn01w6UdtRhCJzUE7TtrY";}s:2:"id";s:9:"4_3_large";s:5:"label";s:9:"4:3 Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:28:"4_3_500x375_focal_point_webp";i:1;s:28:"4_3_700x525_focal_point_webp";i:2;s:28:"4_3_960x720_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"4_3_500x375_focal_point_webp";}'),
('', 'responsive_image.styles.4_3_medium', 'a:10:{s:4:"uuid";s:36:"98979c73-7993-4287-8412-ebe5183ca7f3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:40:"image.style.4_3_500x375_focal_point_webp";i:1;s:40:"image.style.4_3_600x450_focal_point_webp";i:2;s:40:"image.style.4_3_720x540_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-XiXFD1eySSVzt_7SRm2vwZK73RGeZ4b85w5h55nkn4";}s:2:"id";s:10:"4_3_medium";s:5:"label";s:10:"4:3 Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:28:"4_3_500x375_focal_point_webp";i:1;s:28:"4_3_600x450_focal_point_webp";i:2;s:28:"4_3_720x540_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"4_3_500x375_focal_point_webp";}'),
('', 'responsive_image.styles.4_3_small', 'a:10:{s:4:"uuid";s:36:"8912de3d-7b8a-417e-8748-32af9a4e2dfe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:40:"image.style.4_3_300x225_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zOVIXPM1rDW0uhEcSgNupOq0Vp0UavNIasMywnZW7Co";}s:2:"id";s:9:"4_3_small";s:5:"label";s:9:"4:3 Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:28:"4_3_300x225_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"4_3_300x225_focal_point_webp";}'),
('', 'responsive_image.styles.4_3_wide', 'a:10:{s:4:"uuid";s:36:"9fffbedc-a2d1-43b7-926b-9927d9ce937e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:41:"image.style.4_3_1000x750_focal_point_webp";i:1;s:41:"image.style.4_3_1300x975_focal_point_webp";i:2;s:42:"image.style.4_3_1800x1350_focal_point_webp";i:3;s:40:"image.style.4_3_500x375_focal_point_webp";i:4;s:40:"image.style.4_3_700x525_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ahkjvo3e4zLmD7-eTBiYRi5Gh9Jk8r4EcrbGTkrQi6g";}s:2:"id";s:8:"4_3_wide";s:5:"label";s:8:"4:3 Wide";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:5:{i:0;s:29:"4_3_1000x750_focal_point_webp";i:1;s:29:"4_3_1300x975_focal_point_webp";i:2;s:30:"4_3_1800x1350_focal_point_webp";i:3;s:28:"4_3_500x375_focal_point_webp";i:4;s:28:"4_3_700x525_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:28:"4_3_500x375_focal_point_webp";}'),
('', 'responsive_image.styles.9_16_large', 'a:10:{s:4:"uuid";s:36:"31263423-8d1e-4379-a082-e6d1dd7d9f40";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:41:"image.style.9_16_504x896_focal_point_webp";i:1;s:41:"image.style.9_16_540x960_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8WoAxMBkx3T9rD8M4YoQf9L-dImlodOa4_DSe6XnNDU";}s:2:"id";s:10:"9_16_large";s:5:"label";s:10:"9:16 Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:2:{i:0;s:29:"9_16_504x896_focal_point_webp";i:1;s:29:"9_16_540x960_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"9_16_504x896_focal_point_webp";}'),
('', 'responsive_image.styles.9_16_medium', 'a:10:{s:4:"uuid";s:36:"14fdc63d-c1ee-4c6c-93b4-655155aa5aef";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:41:"image.style.9_16_342x608_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-2ZXbZGeu7Aa2dnOHN-_KM9OKHuat6ILui4bPkzie2w";}s:2:"id";s:11:"9_16_medium";s:5:"label";s:11:"9:16 Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:29:"9_16_342x608_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"9_16_342x608_focal_point_webp";}'),
('', 'responsive_image.styles.9_16_small', 'a:10:{s:4:"uuid";s:36:"72de36b6-7368-48df-aea7-0e5bb1fc9582";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:41:"image.style.9_16_171x304_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"teivQD0TuACkQsVKuGkYzG2IiASlQVH8okgU27Dogiw";}s:2:"id";s:10:"9_16_small";s:5:"label";s:10:"9:16 Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:1:{i:0;s:29:"9_16_171x304_focal_point_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"9_16_171x304_focal_point_webp";}'),
('', 'responsive_image.styles.hero_large', 'a:10:{s:4:"uuid";s:36:"7332deda-74f7-4e70-a831-f5d2021c97a4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:4:{i:0;s:41:"image.style.16_9_512x288_focal_point_webp";i:1;s:41:"image.style.16_9_704x396_focal_point_webp";i:2;s:41:"image.style.5_2_1000x400_focal_point_webp";i:3;s:41:"image.style.5_2_1300x520_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rW90Hnj8aOmYP1KohxaJdYFbm517IjurExtf3Uxi5T8";}s:2:"id";s:10:"hero_large";s:5:"label";s:10:"Hero Large";s:20:"image_style_mappings";a:3:{i:0;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:29:"5_2_1300x520_focal_point_webp";s:13:"breakpoint_id";s:10:"olivero.lg";s:10:"multiplier";s:2:"1x";}i:1;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:29:"5_2_1000x400_focal_point_webp";s:13:"breakpoint_id";s:10:"olivero.md";s:10:"multiplier";s:2:"1x";}i:2;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:29:"16_9_704x396_focal_point_webp";s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"16_9_512x288_focal_point_webp";}'),
('', 'responsive_image.styles.hero_wide', 'a:10:{s:4:"uuid";s:36:"b46cc7a2-fe99-4e0e-8ab6-f0bb7784ea04";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:5:{i:0;s:41:"image.style.16_9_512x288_focal_point_webp";i:1;s:41:"image.style.16_9_704x396_focal_point_webp";i:2;s:41:"image.style.5_2_1000x400_focal_point_webp";i:3;s:41:"image.style.5_2_1300x520_focal_point_webp";i:4;s:41:"image.style.5_2_1800x720_focal_point_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"r53rfarUKfKsYhtkVlH-z6Pj7GDn2OxaNkcH9ETAnIw";}s:2:"id";s:9:"hero_wide";s:5:"label";s:9:"Hero Wide";s:20:"image_style_mappings";a:4:{i:0;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:29:"5_2_1800x720_focal_point_webp";s:13:"breakpoint_id";s:10:"olivero.xl";s:10:"multiplier";s:2:"1x";}i:1;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:29:"5_2_1300x520_focal_point_webp";s:13:"breakpoint_id";s:10:"olivero.lg";s:10:"multiplier";s:2:"1x";}i:2;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:29:"5_2_1000x400_focal_point_webp";s:13:"breakpoint_id";s:10:"olivero.md";s:10:"multiplier";s:2:"1x";}i:3;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:29:"16_9_704x396_focal_point_webp";s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:29:"16_9_512x288_focal_point_webp";}'),
('', 'responsive_image.styles.uncropped_large', 'a:10:{s:4:"uuid";s:36:"b4e9460d-bab8-488d-992d-ec46171f215b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:31:"image.style.uncropped_500w_webp";i:1;s:31:"image.style.uncropped_700w_webp";i:2;s:31:"image.style.uncropped_960w_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PLvQsmjLw9rloVdsiDRY9SHjtCNLLzMK3sjgjNQzi-I";}s:2:"id";s:15:"uncropped_large";s:5:"label";s:15:"Uncropped Large";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:19:"uncropped_500w_webp";i:1;s:19:"uncropped_700w_webp";i:2;s:19:"uncropped_960w_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:19:"uncropped_500w_webp";}'),
('', 'responsive_image.styles.uncropped_medium', 'a:10:{s:4:"uuid";s:36:"c2bed165-26a6-4b92-8f0d-2117b098012b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:31:"image.style.uncropped_500w_webp";i:1;s:31:"image.style.uncropped_600w_webp";i:2;s:31:"image.style.uncropped_720w_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Iw3zoqONo4dtgurC42v0smJG9beZpFsBarFpbiBDIGw";}s:2:"id";s:16:"uncropped_medium";s:5:"label";s:16:"Uncropped Medium";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:5:"sizes";s:13:"image_mapping";a:2:{s:5:"sizes";s:5:"100vw";s:18:"sizes_image_styles";a:3:{i:0;s:19:"uncropped_500w_webp";i:1;s:19:"uncropped_600w_webp";i:2;s:19:"uncropped_720w_webp";}}s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:19:"uncropped_500w_webp";}'),
('', 'responsive_image.styles.uncropped_small', 'a:10:{s:4:"uuid";s:36:"ff3e3a18-68bd-4bbc-ae28-fd73fd49d19d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"image.style.uncropped_300w_webp";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U13C9GPgeAZyWtnEn7aWWR48yP3-4mAndLliGh_VoSw";}s:2:"id";s:15:"uncropped_small";s:5:"label";s:15:"Uncropped Small";s:20:"image_style_mappings";a:1:{i:0;a:4:{s:18:"image_mapping_type";s:11:"image_style";s:13:"image_mapping";s:19:"uncropped_300w_webp";s:13:"breakpoint_id";s:10:"olivero.sm";s:10:"multiplier";s:2:"1x";}}s:16:"breakpoint_group";s:7:"olivero";s:20:"fallback_image_style";s:19:"uncropped_300w_webp";}'),
('', 'sam.settings', 'a:4:{s:14:"add_more_label";s:16:"Add another item";s:12:"remove_label";s:6:"Remove";s:18:"help_text_singular";s:35:"@count additional item can be added";s:16:"help_text_plural";s:36:"@count additional items can be added";}'),
('', 'scheduler.settings', 'a:21:{s:15:"allow_date_only";b:0;s:11:"date_format";s:11:"Y-m-d H:i:s";s:12:"date_letters";s:8:"djmnFMyY";s:16:"date_only_format";s:5:"Y-m-d";s:23:"default_expand_fieldset";s:13:"when_required";s:27:"default_fields_display_mode";s:12:"vertical_tab";s:22:"default_publish_enable";b:0;s:25:"default_publish_past_date";s:5:"error";s:33:"default_publish_past_date_created";b:0;s:24:"default_publish_required";b:0;s:24:"default_publish_revision";b:0;s:21:"default_publish_touch";b:0;s:33:"default_show_message_after_update";b:1;s:12:"default_time";s:8:"00:00:00";s:24:"default_unpublish_enable";b:0;s:26:"default_unpublish_required";b:0;s:26:"default_unpublish_revision";b:0;s:12:"hide_seconds";b:1;s:3:"log";b:1;s:12:"time_letters";s:8:"hHgGisaA";s:16:"time_only_format";s:5:"H:i:s";}'),
('', 'symfony_mailer_lite.message', 'a:5:{s:12:"content_type";s:10:"text/plain";s:8:"override";b:0;s:11:"text_format";s:0:"";s:14:"generate_plain";b:1;s:13:"character_set";s:5:"UTF-8";}'),
('', 'symfony_mailer_lite.settings', 'a:1:{s:17:"default_transport";s:6:"native";}'),
('', 'symfony_mailer_lite.symfony_mailer_lite_transport.native', 'a:9:{s:4:"uuid";s:36:"206707a1-f44e-4ed6-bc7a-b1f424e28f18";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fmIZX47PjCIVObQh6Ao8FQfKjkWy-FzUE-OvsbDmMjQ";}s:2:"id";s:6:"native";s:5:"label";s:19:"PHP native sendmail";s:6:"plugin";s:6:"native";s:13:"configuration";a:0:{}}'),
('', 'system.action.media_delete_action', 'a:10:{s:4:"uuid";s:36:"7b618372-4a4e-4d49-937b-8a3124de24ff";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FrZy1tmuXJcOxhXlBoI1Hsnen5TT-9OCC1iolWH84go";}s:2:"id";s:19:"media_delete_action";s:5:"label";s:12:"Delete media";s:4:"type";s:5:"media";s:6:"plugin";s:26:"entity:delete_action:media";s:13:"configuration";a:0:{}}'),
('', 'system.action.media_publish_action', 'a:10:{s:4:"uuid";s:36:"f39d5d1f-cfba-4841-b96c-d346d97a77b4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nh83qNNrmWE-CDdHz2MdFOAk60T9mzv3R-MaKfZR2jw";}s:2:"id";s:20:"media_publish_action";s:5:"label";s:13:"Publish media";s:4:"type";s:5:"media";s:6:"plugin";s:27:"entity:publish_action:media";s:13:"configuration";a:0:{}}'),
('', 'system.action.media_save_action', 'a:10:{s:4:"uuid";s:36:"5f79ae5d-8006-438c-a9c0-daf277ff8edb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VVyUA6PIaVeGtcIbgEWqJ6SYDiJdReBeojFswURFpKs";}s:2:"id";s:17:"media_save_action";s:5:"label";s:10:"Save media";s:4:"type";s:5:"media";s:6:"plugin";s:24:"entity:save_action:media";s:13:"configuration";a:0:{}}'),
('', 'system.action.media_unpublish_action', 'a:10:{s:4:"uuid";s:36:"db3af404-0741-4b05-8d08-7647b1e7ed74";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:5:"media";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CsK6TseQ2DatEbZgbd30swOlZ28_HHwAESU2LvEnWq0";}s:2:"id";s:22:"media_unpublish_action";s:5:"label";s:15:"Unpublish media";s:4:"type";s:5:"media";s:6:"plugin";s:29:"entity:unpublish_action:media";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_delete_action', 'a:10:{s:4:"uuid";s:36:"2ee41053-337a-4e09-8c08-95c667ef031f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_make_sticky_action', 'a:10:{s:4:"uuid";s:36:"9fac858a-e88a-4b0b-8615-4267b82d808f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_make_unsticky_action', 'a:10:{s:4:"uuid";s:36:"26952575-7e52-493d-a916-125a77c385c5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_promote_action', 'a:10:{s:4:"uuid";s:36:"d440cf43-9ab5-4633-aed8-e9aa2bd5c67c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_publish_action', 'a:10:{s:4:"uuid";s:36:"c98d84e1-8e72-4acc-9c87-c5dda0204773";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_save_action', 'a:10:{s:4:"uuid";s:36:"b8adc3f7-9f03-4660-9888-a4683160bdc4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_unpromote_action', 'a:10:{s:4:"uuid";s:36:"3577b100-c4c8-41cd-8869-f40ab63d2764";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_unpublish_action', 'a:10:{s:4:"uuid";s:36:"e7289c40-b788-4613-9a18-a1d59600dad8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.redirect_delete_action', 'a:10:{s:4:"uuid";s:36:"5cb6ee93-ffc4-4fb0-813d-fe2fa843581d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:8:"redirect";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:8:"redirect";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vcnRZRvBqTbK3nZ2M4_lKPlEGc8GjPzgaqapYUfyX8M";}s:2:"id";s:22:"redirect_delete_action";s:5:"label";s:15:"Delete redirect";s:4:"type";s:8:"redirect";s:6:"plugin";s:22:"redirect_delete_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.taxonomy_term_publish_action', 'a:10:{s:4:"uuid";s:36:"5eee0209-d98b-4cef-8577-2bf4d4b698bb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}'),
('', 'system.action.taxonomy_term_unpublish_action', 'a:10:{s:4:"uuid";s:36:"395192a9-eff1-4959-8306-9afc590605e6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_add_role_action.administrator', 'a:9:{s:4:"uuid";s:36:"8d158a08-2b4a-4baf-bd78-8a7cc4d960e8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}'),
('', 'system.action.user_add_role_action.content_editor', 'a:9:{s:4:"uuid";s:36:"a70f5410-e023-4491-a6e4-5cd6ff6f8fda";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:35:"user_add_role_action.content_editor";s:5:"label";s:51:"Add the Content editor role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}'),
('', 'system.action.user_block_user_action', 'a:10:{s:4:"uuid";s:36:"d9c13b6b-0183-46f7-94c0-1b87a376ffbe";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_cancel_user_action', 'a:10:{s:4:"uuid";s:36:"1ff5ca7b-0e64-4690-9ee9-848504316e59";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_remove_role_action.administrator', 'a:9:{s:4:"uuid";s:36:"914f8c70-ba63-4d02-966a-7b4a7b237582";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'system.action.user_remove_role_action.content_editor', 'a:9:{s:4:"uuid";s:36:"e0e97b5e-c1b1-4fc8-be1c-85c9bc57e6ce";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:38:"user_remove_role_action.content_editor";s:5:"label";s:56:"Remove the Content editor role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}'),
('', 'system.action.user_unblock_user_action', 'a:10:{s:4:"uuid";s:36:"d98a7938-6a18-4999-885d-c84f2380339c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.advisories', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}'),
('', 'system.cron', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"f3yToH8v8EaBZU0NFFw2qR8ogSCuWVmQaN0hpYR1BD8";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";b:1;}'),
('', 'system.date', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IVsFTD1mvR2NGBP_1myt9kFIFmGepH4PyaN5aQBYpno";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";N;}s:8:"timezone";a:2:{s:7:"default";s:12:"Asia/Kolkata";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}'),
('', 'system.diff', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}'),
('', 'system.feature_flags', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZYyVj1FtPGV40Cf65YDVTUIc7YgLH6trXlotuevfs2I";}s:16:"linkset_endpoint";b:0;}'),
('', 'system.file', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}'),
('', 'system.image', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}'),
('', 'system.image.gd', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}'),
('', 'system.logging', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}'),
('', 'system.mail', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5PvD9swkqWUeHkabdvbJ2SQqdhrzjkCT21wtD4BLfk4";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}s:10:"mailer_dsn";a:6:{s:6:"scheme";s:8:"sendmail";s:4:"host";s:7:"default";s:4:"user";N;s:8:"password";N;s:4:"port";N;s:7:"options";a:0:{}}}'),
('', 'system.maintenance', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}'),
('', 'system.menu.account', 'a:9:{s:4:"uuid";s:36:"07c3a279-eb38-4819-a40e-bf59853f78e8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}'),
('', 'system.menu.admin', 'a:9:{s:4:"uuid";s:36:"3becd82a-c553-4a37-95a1-081612975630";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}'),
('', 'system.menu.content', 'a:9:{s:4:"uuid";s:36:"29e265c2-6766-4ca9-8a68-6d60ca521b2a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:10:"navigation";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nqVwm91Uyib_rvFaNPF1MdYqHlmZ38w5rsOVVy4uWDw";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:11:"description";s:18:"Content task links";s:6:"locked";b:1;}'),
('', 'system.menu.footer', 'a:9:{s:4:"uuid";s:36:"ab3a6046-5a4a-4489-90f7-3dc5385a2712";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}'),
('', 'system.menu.main', 'a:9:{s:4:"uuid";s:36:"24c60a78-527e-4c69-b6ab-261d011701f0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}'),
('', 'system.menu.navigation-user-links', 'a:9:{s:4:"uuid";s:36:"38399c29-3d39-4613-8b78-6d96e0ef8fa0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:10:"navigation";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RP5hKQYc151zqBiiWtGfY-3JN7i35Gtxo1f2hhS09hM";}s:2:"id";s:21:"navigation-user-links";s:5:"label";s:21:"Navigation user links";s:11:"description";s:35:"User links to be used in Navigation";s:6:"locked";b:1;}'),
('', 'system.menu.tools', 'a:9:{s:4:"uuid";s:36:"f8bf3b4f-7b00-4f06-b9df-32887f493b01";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}'),
('', 'system.menu.welcome', 'a:9:{s:4:"uuid";s:36:"d57be252-aa85-4793-acc1-8e46f80feb09";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LB6uOBDSz0K5jGR2bcJy0YQGwlhoGIf4wmHZ1yr-AMc";}s:2:"id";s:7:"welcome";s:5:"label";s:7:"Welcome";s:11:"description";s:53:"Things users can do when they start using Drupal CMS.";s:6:"locked";b:0;}'),
('', 'system.performance', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jtno5biznHZbrIgKwzq-ze-7XaQxLCGe6PeUOR7bRiQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:900;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\\/(?:styles|imagecache)\\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}}'),
('', 'system.rss', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0";}s:5:"items";a:1:{s:9:"view_mode";s:3:"rss";}}'),
('', 'system.site', 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HlN7eAN2N4JIHsYv56V4E7sqC9bS609KwvGFjyD_mgk";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"b7b6617a-97c4-49fb-ac25-36a729d27e8f";s:4:"name";[[ser_site_name]]s:4:"mail";[[site_mail]]s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:11:"/user/login";i:404;s:0:"";s:5:"front";s:7:"/node/2";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";s:17:"mail_notification";N;}'),
('', 'system.theme', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6lQ55NXM9ysybMQ6NzJj4dtiQ1dAkOYxdDompa-r_kk";}s:5:"admin";s:3:"gin";s:7:"default";s:18:"drupal_cms_olivero";}'),
('', 'system.theme.global', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KZiV2LB312xgJBphfq5BTjmp16xiR5KM8InBJ-pff7Y";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";N;s:11:"use_default";b:1;}}'),
('', 'tagify.settings', 'a:1:{s:18:"set_default_widget";b:1;}'),
('', 'taxonomy.settings', 'a:3:{s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;}'),
('', 'taxonomy.vocabulary.tags', 'a:10:{s:4:"uuid";s:36:"ebf6ab79-33f3-4d60-b941-1b072555af9c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iTEzwrEQ_4JIb-OYGiqzyF2TmMgWyWayresXcWgwGWM";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;s:12:"new_revision";b:0;}'),
('', 'text.settings', 'a:1:{s:22:"default_summary_length";i:600;}'),
('', 'trash.settings', 'a:3:{s:20:"enabled_entity_types";a:1:{s:4:"node";a:0:{}}s:10:"auto_purge";a:2:{s:7:"enabled";b:0;s:5:"after";s:7:"30 days";}s:16:"compact_overview";b:0;}'),
('', 'update.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cceqUa945af6yMPEeM1pWJQoA-tumoAqhThW2xGoZ04";}s:5:"check";a:2:{s:19:"disabled_extensions";b:1;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";N;s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;[[site_mail]]}s:9:"threshold";s:3:"all";}}'),
('', 'user.flood', 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}'),
('', 'user.mail', 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM";}s:8:"langcode";s:2:"en";s:14:"cancel_confirm";a:2:{s:7:"subject";s:67:"Account cancellation request for [user:display-name] at [site:name]";s:4:"body";s:376:"[user:display-name]\n\nA request to cancel your account has been made at [site:name].\n\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\n\n[user:cancel-url]\n\nNOTE: The cancellation of your account is not reversible.\n\nThis link expires in one day and nothing will happen if it is not used.\n\n--  [site:name] team";}s:14:"password_reset";a:2:{s:7:"subject";s:68:"Replacement login information for [user:display-name] at [site:name]";s:4:"body";s:407:"[user:display-name],\n\nA request to reset the password for your account has been made at [site:name].\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it''s not used.\n\n--  [site:name] team";}s:22:"register_admin_created";a:2:{s:7:"subject";s:58:"An administrator created an account for you at [site:name]";s:4:"body";s:473:"[user:display-name],\n\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";}s:29:"register_no_approval_required";a:2:{s:7:"subject";s:54:"Account details for [user:display-name] at [site:name]";s:4:"body";s:447:"[user:display-name],\n\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";}s:25:"register_pending_approval";a:2:{s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";s:4:"body";s:288:"[user:display-name],\n\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n--  [site:name] team";}s:31:"register_pending_approval_admin";a:2:{s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";s:4:"body";s:64:"[user:display-name] has applied for an account.\n\n[user:edit-url]";}s:16:"status_activated";a:2:{s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (approved)";s:4:"body";s:462:"[user:display-name],\n\nYour account at [site:name] has been activated.\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:account-name]\npassword: Your password\n\n--  [site:name] team";}s:14:"status_blocked";a:2:{s:7:"subject";s:64:"Account details for [user:display-name] at [site:name] (blocked)";s:4:"body";s:89:"[user:display-name],\n\nYour account on [site:name] has been blocked.\n\n--  [site:name] team";}s:15:"status_canceled";a:2:{s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (canceled)";s:4:"body";s:90:"[user:display-name],\n\nYour account on [site:name] has been canceled.\n\n--  [site:name] team";}}'),
('', 'user.role.administrator', 'a:10:{s:4:"uuid";s:36:"89e482ae-9c28-4896-ae6f-b9ab940a41f0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:3;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}'),
('', 'user.role.anonymous', 'a:10:{s:4:"uuid";s:36:"5c6816cd-f7d0-4568-b907-65f5c909e4f2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:5:"klaro";i:1;s:5:"media";i:2;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j5zLMOdJBqC0bMvSdth5UebkprJB8g_2FXHqhfpJzow";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:3:{i:0;s:14:"access content";i:1;s:9:"use klaro";i:2;s:10:"view media";}}'),
('', 'user.role.authenticated', 'a:10:{s:4:"uuid";s:36:"4e092540-8031-418f-9fbb-531571ea91c2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:27:"dashboard.dashboard.welcome";}s:6:"module";a:9:{i:0;s:7:"captcha";i:1;s:6:"coffee";i:2;s:9:"dashboard";i:3;s:4:"file";i:4;s:8:"honeypot";i:5;s:5:"klaro";i:6;s:5:"media";i:7;s:4:"node";i:8;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"dJ0L2DNSj5q6XVZAGsuVDpJTh5UeYkIPwKrUOOpr8YI";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:9:{i:0;s:13:"access coffee";i:1;s:14:"access content";i:2;s:26:"bypass honeypot protection";i:3;s:16:"delete own files";i:4;s:12:"skip CAPTCHA";i:5;s:9:"use klaro";i:6;s:10:"view media";i:7;s:28:"view own unpublished content";i:8;s:22:"view welcome dashboard";}}'),
('', 'user.role.content_editor', 'a:10:{s:4:"uuid";s:36:"d3aec9ef-caad-4851-9ec9-68a225ac999e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:28:"filter.format.content_format";i:1;s:19:"media.type.document";i:2;s:16:"media.type.image";i:3;s:23:"media.type.remote_video";i:4;s:20:"media.type.svg_image";i:5;s:14:"node.type.page";i:6;s:34:"workflows.workflow.basic_editorial";}s:6:"module";a:12:{i:0;s:18:"content_moderation";i:1;s:10:"contextual";i:2;s:4:"file";i:3;s:6:"filter";i:4;s:5:"media";i:5;s:10:"navigation";i:6;s:4:"node";i:7;s:4:"path";i:8;s:8:"redirect";i:9;s:9:"scheduler";i:10;s:6:"system";i:11;s:5:"trash";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"g-zSnaBXJnH7VoimReFb6KcLjIgHCU-hisiShtZ9hjQ";}s:2:"id";s:14:"content_editor";s:5:"label";s:14:"Content editor";s:6:"weight";i:2;s:8:"is_admin";b:0;s:11:"permissions";a:39:{i:0;s:27:"access administration pages";i:1;s:23:"access content overview";i:2;s:23:"access contextual links";i:3;s:21:"access media overview";i:4;s:17:"access navigation";i:5;s:12:"access trash";i:6;s:15:"administer menu";i:7;s:20:"administer redirects";i:8;s:22:"administer url aliases";i:9;s:21:"create document media";i:10;s:18:"create image media";i:11;s:19:"create page content";i:12;s:25:"create remote_video media";i:13;s:22:"create svg_image media";i:14;s:18:"create url aliases";i:15;s:25:"delete any document media";i:16;s:22:"delete any image media";i:17;s:23:"delete any page content";i:18;s:29:"delete any remote_video media";i:19;s:26:"delete any svg_image media";i:20;s:16:"delete own files";i:21;s:21:"delete page revisions";i:22;s:23:"edit any document media";i:23;s:20:"edit any image media";i:24;s:21:"edit any page content";i:25;s:27:"edit any remote_video media";i:26;s:24:"edit any svg_image media";i:27;s:20:"revert all revisions";i:28;s:28:"schedule publishing of nodes";i:29;s:47:"use basic_editorial transition create_new_draft";i:30;s:38:"use basic_editorial transition publish";i:31;s:40:"use basic_editorial transition unpublish";i:32;s:30:"use text format content_format";i:33;s:18:"view all revisions";i:34;s:28:"view any unpublished content";i:35;s:28:"view own unpublished content";i:36;s:26:"view own unpublished media";i:37;s:22:"view scheduled content";i:38;s:29:"view the administration theme";}}'),
('', 'user.settings', 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M4F5x5CHrctvvJZY1qyP3D4ht3xaPjp2_CEo2TE-uJw";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:10:"admin_only";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}'),
('', 'views.settings', 'a:4:{s:17:"display_extenders";a:0:{}s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}'),
('', 'views.view.content', 'a:13:{s:4:"uuid";s:36:"6e590cae-1e94-486a-88b0-bcfb7002b632";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhgEYFEzezna1qjycmr6NgssQgyiLfUvOv-iB_a_I6o";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:7:"Content";s:6:"fields";a:8:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:8:"langcode";a:37:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:14:"field_language";s:5:"label";s:8:"Language";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:8:"language";s:8:"settings";a:2:{s:14:"link_to_entity";b:0;s:15:"native_language";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:3:{s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.files', 'a:13:{s:4:"uuid";s:36:"c4e683af-7cf0-4f08-a956-c52a29520e30";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LTTOi-7sByeB_teJJcm_LiTiEciHUIU-ZdjYcnQS--I";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:5:"Files";s:6:"fields";a:9:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:5:"field";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:26:"@count place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:12:"file_managed";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:11:"file_status";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:7:"default";s:7:"changed";s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:15:{s:5:"title";s:10:"File usage";s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"entity_label";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"empty";a:0:{}s:9:"arguments";a:1:{s:3:"fid";a:22:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:8:"file_fid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:7:"default";s:12:"entity_label";s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"group_by";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:0;s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:27:"admin/content/files/usage/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.latest', 'a:13:{s:4:"uuid";s:36:"0807de34-d91b-4305-b540-a1c8394be10c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:31:"core.entity_view_mode.node.card";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UHNsgKJ1nUm3BGDaQNlcsbeNwt1xmKATTJvK7BCmGmo";}s:2:"id";s:6:"latest";s:5:"label";s:6:"Latest";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:6:"Latest";s:6:"fields";a:1:{s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:6;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:1:{s:8:"operator";s:0:"";}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:6:"not in";s:5:"value";a:1:{s:4:"page";s:4:"page";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:1:{s:4:"type";s:7:"default";}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:4:"card";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"latest";a:6:{s:2:"id";s:6:"latest";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:16:"block_hide_empty";b:1;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.media', 'a:13:{s:4:"uuid";s:36:"e794d1ba-f6e7-4efc-9b4b-94d53ce1e001";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:21:"image.style.thumbnail";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:5:"media";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zwbF6kYhafeyYkQp4JM4qtykNGzfTn3ZXBTXzlVcUa8";}s:2:"id";s:5:"media";s:5:"label";s:5:"Media";s:6:"module";s:5:"views";s:11:"description";s:22:"Find and manage media.";s:3:"tag";s:0:"";s:10:"base_table";s:16:"media_field_data";s:10:"base_field";s:3:"mid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:5:"Media";s:6:"fields";a:8:{s:15:"media_bulk_form";a:26:{s:2:"id";s:15:"media_bulk_form";s:5:"table";s:5:"media";s:5:"field";s:15:"media_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:20:"thumbnail__target_id";a:37:{s:2:"id";s:20:"thumbnail__target_id";s:5:"table";s:16:"media_field_data";s:5:"field";s:20:"thumbnail__target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:9:"thumbnail";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"Thumbnail";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:5:"image";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:9:"thumbnail";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:12:"group_column";s:0:"";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:5:"media";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Media name";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"bundle";a:37:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:16:"media_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"status";a:37:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"media";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access media overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No media available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:10:"Media name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"bundle";a:16:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"bundle_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"bundle_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:4:"True";s:11:"description";N;s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:1;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:16:"media_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:12:"media_status";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:4:"name";s:4:"name";s:6:"bundle";s:6:"bundle";s:7:"changed";s:7:"changed";s:3:"uid";s:3:"uid";s:6:"status";s:6:"status";s:20:"thumbnail__target_id";s:20:"thumbnail__target_id";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"bundle";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:20:"thumbnail__target_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:15:"media_page_list";a:6:{s:2:"id";s:15:"media_page_list";s:13:"display_title";s:5:"Media";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/media";s:4:"menu";a:8:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Media";s:11:"description";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.media_library', 'a:13:{s:4:"uuid";s:36:"0bf8830b-ef9e-4ac8-90ce-35f38203b414";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:2:{i:0;s:41:"core.entity_view_mode.media.media_library";i:1;s:25:"image.style.media_library";}s:6:"module";a:4:{i:0;s:5:"image";i:1;s:5:"media";i:2;s:13:"media_library";i:3;s:4:"user";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:13:"media_library";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VdcKXEqxk1VQJiuPCL61Cc7Y-tnNRekMFRO0uXqzBNo";}s:2:"id";s:13:"media_library";s:5:"label";s:13:"Media library";s:6:"module";s:5:"views";s:11:"description";s:22:"Find and manage media.";s:3:"tag";s:0:"";s:10:"base_table";s:16:"media_field_data";s:10:"base_field";s:3:"mid";s:7:"display";a:4:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:5:"title";s:5:"Media";s:6:"fields";a:2:{s:15:"media_bulk_form";a:26:{s:2:"id";s:15:"media_bulk_form";s:5:"table";s:5:"media";s:5:"field";s:15:"media_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:15:"rendered_entity";a:24:{s:2:"id";s:15:"rendered_entity";s:5:"table";s:5:"media";s:5:"field";s:15:"rendered_entity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:15:"rendered_entity";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"view_mode";s:13:"media_library";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:24;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"6, 12, 24, 48";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:13:"Apply filters";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:0;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access media overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No media available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:3:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:12:"Newest first";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:1;s:11:"granularity";s:6:"second";}s:4:"name";a:12:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:8:"standard";s:5:"order";s:3:"ASC";s:6:"expose";a:2:{s:5:"label";s:10:"Name (A-Z)";s:16:"field_identifier";s:4:"name";}s:7:"exposed";b:1;}s:6:"name_1";a:12:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:10:"Name (Z-A)";s:16:"field_identifier";s:6:"name_1";}s:7:"exposed";b:1;}}s:7:"filters";a:5:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:17:"Publishing status";s:11:"description";N;s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:1;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:9:"Published";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:4:"Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"bundle";a:16:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"bundle_op";s:5:"label";s:10:"Media type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"bundle_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:10:"Media type";s:11:"description";N;s:10:"identifier";s:6:"bundle";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:3:{i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}}}}s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:16:"media_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:12:"media_status";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:9:"css_class";s:0:"";s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:6:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:22:"url.query_args:sort_by";i:4;s:4:"user";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:4:"page";a:6:{s:2:"id";s:4:"page";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:6:"fields";a:5:{s:15:"media_bulk_form";a:26:{s:2:"id";s:15:"media_bulk_form";s:5:"table";s:5:"media";s:5:"field";s:15:"media_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"edit_media";a:26:{s:2:"id";s:10:"edit_media";s:5:"table";s:5:"media";s:5:"field";s:10:"edit_media";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:16:"entity_link_edit";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:15:"Edit {{ name }}";s:9:"make_link";b:1;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:15:"Edit {{ name }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:1:"0";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"text";s:4:"Edit";s:18:"output_url_as_text";b:0;s:8:"absolute";b:0;}s:12:"delete_media";a:26:{s:2:"id";s:12:"delete_media";s:5:"table";s:5:"media";s:5:"field";s:12:"delete_media";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:18:"entity_link_delete";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:17:"Delete {{ name }}";s:9:"make_link";b:1;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:17:"Delete {{ name }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:1:"0";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"text";s:6:"Delete";s:18:"output_url_as_text";b:0;s:8:"absolute";b:0;}s:15:"rendered_entity";a:24:{s:2:"id";s:15:"rendered_entity";s:5:"table";s:5:"media";s:5:"field";s:15:"rendered_entity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:15:"rendered_entity";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"view_mode";s:13:"media_library";}}s:8:"defaults";a:1:{s:6:"fields";b:0;}s:17:"display_extenders";a:0:{}s:4:"path";s:24:"admin/content/media-grid";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:22:"url.query_args:sort_by";i:5;s:4:"user";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"widget";a:6:{s:2:"id";s:6:"widget";s:13:"display_title";s:6:"Widget";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:12:{s:6:"fields";a:2:{s:25:"media_library_select_form";a:23:{s:2:"id";s:25:"media_library_select_form";s:5:"table";s:5:"media";s:5:"field";s:25:"media_library_select_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:25:"media_library_select_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:15:"rendered_entity";a:24:{s:2:"id";s:15:"rendered_entity";s:5:"table";s:5:"media";s:5:"field";s:15:"rendered_entity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:15:"rendered_entity";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"view_mode";s:13:"media_library";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:10:"view media";}}s:9:"arguments";a:1:{s:6:"bundle";a:26:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:6:"ignore";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:24;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:0;s:5:"limit";i:0;s:4:"case";s:4:"none";s:9:"path_case";s:4:"none";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:3:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:4:"Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:7:{s:6:"access";b:0;s:9:"css_class";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;s:6:"header";b:0;}s:9:"css_class";s:0:"";s:19:"display_description";s:0:"";s:6:"header";a:2:{s:17:"display_link_grid";a:7:{s:2:"id";s:17:"display_link_grid";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:4:"Grid";s:5:"empty";b:1;s:10:"display_id";s:6:"widget";}s:18:"display_link_table";a:7:{s:2:"id";s:18:"display_link_table";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:5:"Table";s:5:"empty";b:1;s:10:"display_id";s:12:"widget_table";}}s:18:"rendering_language";s:33:"***LANGUAGE_language_interface***";s:17:"display_extenders";a:0:{}s:4:"path";s:26:"admin/content/media-widget";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:22:"url.query_args:sort_by";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"widget_table";a:6:{s:2:"id";s:12:"widget_table";s:13:"display_title";s:14:"Widget (table)";s:14:"display_plugin";s:4:"page";s:8:"position";i:3;s:15:"display_options";a:13:{s:6:"fields";a:5:{s:25:"media_library_select_form";a:9:{s:2:"id";s:25:"media_library_select_form";s:5:"table";s:5:"media";s:5:"field";s:25:"media_library_select_form";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:25:"media_library_select_form";s:5:"label";s:0:"";s:13:"element_class";s:0:"";s:21:"element_wrapper_class";s:0:"";}s:20:"thumbnail__target_id";a:10:{s:2:"id";s:20:"thumbnail__target_id";s:5:"table";s:16:"media_field_data";s:5:"field";s:20:"thumbnail__target_id";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:9:"thumbnail";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"Thumbnail";s:4:"type";s:5:"image";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:13:"media_library";s:13:"image_loading";a:1:{s:9:"attribute";s:5:"eager";}}}s:4:"name";a:10:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}}s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:20:"media_field_revision";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}}s:7:"changed";a:10:{s:2:"id";s:7:"changed";s:5:"table";s:16:"media_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:10:"view media";}}s:9:"arguments";a:1:{s:6:"bundle";a:26:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:6:"ignore";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:24;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:0;s:5:"limit";i:0;s:4:"case";s:4:"none";s:9:"path_case";s:4:"none";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:3:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:16:"media_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:4:"Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"media_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:3:{s:9:"row_class";s:85:"media-library-item media-library-item--table js-media-library-item js-click-to-select";s:17:"default_row_class";b:1;s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:8:"defaults";a:9:{s:6:"access";b:0;s:9:"css_class";b:0;s:5:"style";b:0;s:3:"row";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;s:6:"header";b:0;}s:9:"css_class";s:0:"";s:6:"header";a:2:{s:17:"display_link_grid";a:7:{s:2:"id";s:17:"display_link_grid";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:4:"Grid";s:5:"empty";b:1;s:10:"display_id";s:6:"widget";}s:18:"display_link_table";a:7:{s:2:"id";s:18:"display_link_table";s:5:"table";s:5:"views";s:5:"field";s:12:"display_link";s:9:"plugin_id";s:12:"display_link";s:5:"label";s:5:"Table";s:5:"empty";b:1;s:10:"display_id";s:12:"widget_table";}}s:18:"rendering_language";s:33:"***LANGUAGE_language_interface***";s:17:"display_extenders";a:0:{}s:4:"path";s:32:"admin/content/media-widget-table";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:22:"url.query_args:sort_by";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.moderated_content', 'a:13:{s:4:"uuid";s:36:"2c77f4cb-4e87-4dfe-b501-1783817b18a4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:18:"content_moderation";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rhhD8pwk7nzhYCx9O0cy3YpUw3f7J20dMtt4F2tNQ_k";}s:2:"id";s:17:"moderated_content";s:5:"label";s:17:"Moderated content";s:6:"module";s:5:"views";s:11:"description";s:26:"Find and moderate content.";s:3:"tag";s:0:"";s:10:"base_table";s:19:"node_field_revision";s:10:"base_field";s:3:"vid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:5:"title";s:17:"Moderated content";s:6:"fields";a:6:{s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:19:"node_field_revision";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:3:"nid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:16:"moderation_state";a:36:{s:2:"id";s:16:"moderation_state";s:5:"table";s:19:"node_field_revision";s:5:"field";s:16:"moderation_state";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:5:"field";s:5:"label";s:16:"Moderation state";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:24:"content_moderation_state";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:19:"node_field_revision";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"node_revision";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:28:"view any unpublished content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:98:"No moderated content available. Only pending versions of content, such as drafts, are listed here.";s:8:"tokenize";b:0;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:6:{s:36:"latest_translation_affected_revision";a:15:{s:2:"id";s:36:"latest_translation_affected_revision";s:5:"table";s:13:"node_revision";s:5:"field";s:36:"latest_translation_affected_revision";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:36:"latest_translation_affected_revision";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:19:"node_field_revision";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:3:"nid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:16:"moderation_state";a:15:{s:2:"id";s:16:"moderation_state";s:5:"table";s:19:"node_field_revision";s:5:"field";s:16:"moderation_state";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:23:"moderation_state_filter";s:8:"operator";s:2:"in";s:5:"value";a:2:{s:15:"editorial-draft";s:15:"editorial-draft";s:18:"editorial-archived";s:18:"editorial-archived";}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:19:"moderation_state_op";s:5:"label";s:16:"Moderation state";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:19:"moderation_state_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:16:"moderation_state";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:1;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:19:"node_field_revision";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:18:"moderation_state_1";a:15:{s:2:"id";s:18:"moderation_state_1";s:5:"table";s:19:"node_field_revision";s:5:"field";s:16:"moderation_state";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:23:"moderation_state_filter";s:8:"operator";s:6:"not in";s:5:"value";a:1:{s:25:"basic_editorial-published";s:25:"basic_editorial-published";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:5:{s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:16:"moderation_state";s:16:"moderation_state";s:7:"changed";s:7:"changed";}s:7:"default";s:7:"changed";s:4:"info";a:5:{s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:16:"moderation_state";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:2:{s:3:"nid";a:10:{s:2:"id";s:3:"nid";s:5:"table";s:19:"node_field_revision";s:5:"field";s:3:"nid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:47:"Get the actual content from a content revision.";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"nid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:19:"node_field_revision";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"User";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:1:{i:0;s:20:"config:workflow_list";}}}s:17:"moderated_content";a:6:{s:2:"id";s:17:"moderated_content";s:13:"display_title";s:17:"Moderated content";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:23:"admin/content/moderated";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:1:{i:0;s:20:"config:workflow_list";}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.publishing_content', 'a:13:{s:4:"uuid";s:36:"2558416a-f6e3-480d-8d54-c7a1d11efc4d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:34:"workflows.workflow.basic_editorial";}s:6:"module";a:3:{i:0;s:18:"content_moderation";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"65aJ1NYfywgFx8kOvKrRkhAWEBRTS77dG0Sx6mCtf6Q";}s:2:"id";s:18:"publishing_content";s:5:"label";s:18:"Publishing content";s:6:"module";s:5:"views";s:11:"description";s:55:"Shows a list of publishing-managed content on the site.";s:3:"tag";s:10:"Publishing";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:18:"Publishing content";s:6:"fields";a:7:{s:14:"node_bulk_form";a:26:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:3:{i:0;s:18:"node_delete_action";i:1;s:19:"node_publish_action";i:2;s:21:"node_unpublish_action";}}s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"created";a:37:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Create date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"custom";s:18:"custom_date_format";s:8:"m/d g:ia";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Updated date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"custom";s:18:"custom_date_format";s:8:"m/d g:ia";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"status";a:37:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"Published";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"yes-no";s:19:"format_custom_false";s:0:"";s:18:"format_custom_true";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:1;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:25:"view publishing dashboard";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"changed";a:6:{s:2:"id";s:7:"changed";s:5:"table";s:19:"node_field_revision";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";}}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:36:"latest_translation_affected_revision";a:15:{s:2:"id";s:36:"latest_translation_affected_revision";s:5:"table";s:13:"node_revision";s:5:"field";s:36:"latest_translation_affected_revision";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:36:"latest_translation_affected_revision";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:16:"moderation_state";a:15:{s:2:"id";s:16:"moderation_state";s:5:"table";s:19:"node_field_revision";s:5:"field";s:16:"moderation_state";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:23:"moderation_state_filter";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:19:"moderation_state_op";s:5:"label";s:16:"Moderation state";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:19:"moderation_state_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:16:"moderation_state";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:3:"uid";a:16:{s:2:"id";s:3:"uid";s:5:"table";s:19:"node_field_revision";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:6:"uid_op";s:5:"label";s:11:"Authored by";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:6:"uid_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:3:"uid";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:8:"Contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"combine";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:1:{s:5:"title";s:5:"title";}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:7:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:3:"uid";s:3:"uid";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:6:"status";s:6:"status";s:9:"edit_node";s:9:"edit_node";}s:7:"default";s:2:"-1";s:4:"info";a:7:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:0;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:8:"use_ajax";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:1:{i:0;s:20:"config:workflow_list";}}}s:12:"block_drafts";a:6:{s:2:"id";s:12:"block_drafts";s:13:"display_title";s:15:"My drafts Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:3;s:15:"display_options";a:22:{s:5:"title";s:9:"My Drafts";s:6:"fields";a:3:{s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Updated date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:61:"No drafted content by you. Only your drafts, are listed here.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:19:"node_field_revision";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"uid";a:22:{s:2:"id";s:3:"uid";s:5:"table";s:19:"node_field_revision";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:16:"entity_target_id";s:14:"default_action";s:7:"default";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:12:"current_user";s:24:"default_argument_options";a:0:{}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:2:{s:36:"latest_translation_affected_revision";a:15:{s:2:"id";s:36:"latest_translation_affected_revision";s:5:"table";s:13:"node_revision";s:5:"field";s:36:"latest_translation_affected_revision";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:36:"latest_translation_affected_revision";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:16:"moderation_state";a:15:{s:2:"id";s:16:"moderation_state";s:5:"table";s:19:"node_field_revision";s:5:"field";s:16:"moderation_state";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:23:"moderation_state_filter";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:21:"basic_editorial-draft";s:21:"basic_editorial-draft";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:14:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";b:0;s:12:"exposed_form";b:0;s:12:"link_display";b:0;s:8:"link_url";b:0;s:6:"fields";b:0;s:5:"sorts";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:67:"Shows a list of all draft content for the currently logged-in user.";s:8:"use_more";b:1;s:15:"use_more_always";b:1;s:13:"use_more_text";s:14:"See all drafts";s:12:"link_display";s:10:"custom_url";s:8:"link_url";s:24:"/admin/content/moderated";s:15:"display_comment";s:61:"Shows a list of all drafted for the currently logged-in user.";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:17:"block_description";s:9:"My drafts";s:14:"block_category";s:9:"Dashboard";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:1:{i:0;s:20:"config:workflow_list";}}}s:15:"block_scheduled";a:6:{s:2:"id";s:15:"block_scheduled";s:13:"display_title";s:15:"Scheduled Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:2;s:15:"display_options";a:20:{s:5:"title";s:9:"Scheduled";s:6:"fields";a:4:{s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:12:"unpublish_on";a:37:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Unpublish on";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"publish_on";a:37:{s:2:"id";s:10:"publish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:5:"field";s:5:"label";s:29:"Scheduled On | Unpublished On";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:109:"{% if publish_on %}\r\n{{ publish_on }} |\r\n{% endif %}\r\n{% if unpublish_on %}\r\n {{ unpublish_on }}\r\n{% endif %}";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:1;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:56:"{% if unpublish_on %}\r\n| {{ unpublish_on }}\r\n{% endif %}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:71:"No scheduled content available. Only scheduled content are listed here.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:19:"node_field_revision";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:2:{s:10:"publish_on";a:16:{s:2:"id";s:10:"publish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:4:"date";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:10:"+1 minutes";s:4:"type";s:4:"date";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:13:"publish_on_op";s:5:"label";s:10:"Publish on";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"publish_on_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:20:"publish_on_scheduled";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"unpublish_on";a:16:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:4:"date";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:10:"+1 minutes";s:4:"type";s:4:"date";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:15:"unpublish_on_op";s:5:"label";s:12:"Unpublish on";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:15:"unpublish_on_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:12:"unpublish_on";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:2:"OR";}}s:8:"defaults";a:13:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";b:0;s:12:"exposed_form";b:0;s:12:"link_display";b:0;s:8:"link_url";b:0;s:6:"fields";b:0;s:5:"sorts";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:73:"Shows a list of all content scheduled for future publication on the site.";s:8:"use_more";b:1;s:15:"use_more_always";b:1;s:13:"use_more_text";s:17:"See all scheduled";s:12:"link_display";s:10:"custom_url";s:8:"link_url";s:24:"/admin/content/scheduled";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:17:"block_description";s:9:"Scheduled";s:14:"block_category";s:9:"Dashboard";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.recent_content', 'a:13:{s:4:"uuid";s:36:"19517495-9003-4f36-a52d-6dd0e4fd4f66";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UHwoGnNBPReaNrQZ6xsQ6lYHZP0Ry-0sQqMueJWr-_w";}s:2:"id";s:14:"recent_content";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:14:"Recent content";s:6:"fields";a:2:{s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:2:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:31:"You don''t have any content yet.";s:8:"tokenize";b:0;}s:18:"node_listing_empty";a:9:{s:2:"id";s:18:"node_listing_empty";s:5:"table";s:4:"node";s:5:"field";s:18:"node_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:5:"empty";b:1;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:0:"";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:1:{s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:0:{}s:16:"show_admin_links";b:0;s:8:"use_more";b:1;s:15:"use_more_always";b:1;s:13:"use_more_text";s:15:"See all content";s:12:"link_display";s:10:"custom_url";s:8:"link_url";s:14:"/admin/content";s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:14:"url.query_args";i:3;s:4:"user";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:20:"block_recent_content";a:6:{s:2:"id";s:20:"block_recent_content";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:3:{s:15:"display_comment";s:46:"Recent content block for the Welcome dashboard";s:17:"display_extenders";a:0:{}s:14:"block_category";s:9:"Dashboard";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:14:"url.query_args";i:3;s:4:"user";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.redirect', 'a:13:{s:4:"uuid";s:36:"5a5d9c36-0d0f-481c-826e-5d21b8aa2de9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"link";i:1;s:8:"redirect";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bo9oscq1zl57-jdLbBC_NrcL0AGGUS03Wxcaajpxvrg";}s:2:"id";s:8:"redirect";s:5:"label";s:8:"Redirect";s:6:"module";s:5:"views";s:11:"description";s:17:"List of redirects";s:3:"tag";s:0:"";s:10:"base_table";s:8:"redirect";s:10:"base_field";s:3:"rid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:5:"title";s:8:"Redirect";s:6:"fields";a:7:{s:18:"redirect_bulk_form";a:26:{s:2:"id";s:18:"redirect_bulk_form";s:5:"table";s:8:"redirect";s:5:"field";s:18:"redirect_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:8:"redirect";s:9:"plugin_id";s:18:"redirect_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:14:"With selection";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:21:"redirect_source__path";a:37:{s:2:"id";s:21:"redirect_source__path";s:5:"table";s:8:"redirect";s:5:"field";s:21:"redirect_source__path";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:15:"redirect_source";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"From";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:4:"path";s:4:"type";s:15:"redirect_source";s:8:"settings";a:0:{}s:12:"group_column";s:0:"";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:22:"redirect_redirect__uri";a:6:{s:2:"id";s:22:"redirect_redirect__uri";s:5:"table";s:8:"redirect";s:5:"field";s:22:"redirect_redirect__uri";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:17:"redirect_redirect";s:9:"plugin_id";s:5:"field";}s:11:"status_code";a:6:{s:2:"id";s:11:"status_code";s:5:"table";s:8:"redirect";s:5:"field";s:11:"status_code";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:11:"status_code";s:9:"plugin_id";s:5:"field";}s:8:"language";a:6:{s:2:"id";s:8:"language";s:5:"table";s:8:"redirect";s:5:"field";s:8:"language";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:8:"language";s:9:"plugin_id";s:5:"field";}s:7:"created";a:27:{s:2:"id";s:7:"created";s:5:"table";s:8:"redirect";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"label";s:7:"Created";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:8:"fallback";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:10:"operations";a:5:{s:2:"id";s:10:"operations";s:5:"table";s:8:"redirect";s:5:"field";s:10:"operations";s:11:"entity_type";s:8:"redirect";s:9:"plugin_id";s:17:"entity_operations";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"administer redirects";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:27:"There are no redirects yet.";s:8:"tokenize";b:0;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:4:{s:21:"redirect_source__path";a:16:{s:2:"id";s:21:"redirect_source__path";s:5:"table";s:8:"redirect";s:5:"field";s:21:"redirect_source__path";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:15:"redirect_source";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:24:"redirect_source__path_op";s:5:"label";s:4:"From";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:24:"redirect_source__path_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:21:"redirect_source__path";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:22:"redirect_redirect__uri";a:16:{s:2:"id";s:22:"redirect_redirect__uri";s:5:"table";s:8:"redirect";s:5:"field";s:22:"redirect_redirect__uri";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:17:"redirect_redirect";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:25:"redirect_redirect__uri_op";s:5:"label";s:2:"To";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:25:"redirect_redirect__uri_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:22:"redirect_redirect__uri";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:11:"status_code";a:16:{s:2:"id";s:11:"status_code";s:5:"table";s:8:"redirect";s:5:"field";s:11:"status_code";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:11:"status_code";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:14:"status_code_op";s:5:"label";s:11:"Status code";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:14:"status_code_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"status_code";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:11:"Status code";s:11:"description";s:0:"";s:10:"identifier";s:11:"status_code";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:7:{i:1;a:3:{s:5:"title";s:20:"300 Multiple Choices";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:3:"300";}}i:2;a:3:{s:5:"title";s:21:"301 Moved Permanently";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:3:"301";}}i:3;a:3:{s:5:"title";s:9:"302 Found";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:3:"302";}}i:4;a:3:{s:5:"title";s:13:"303 See Other";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:3:"303";}}i:5;a:3:{s:5:"title";s:16:"304 Not Modified";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:3:"304";}}i:6;a:3:{s:5:"title";s:13:"305 Use Proxy";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:3:"305";}}i:7;a:3:{s:5:"title";s:22:"307 Temporary Redirect";s:8:"operator";s:1:"=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:3:"307";}}}}}s:8:"language";a:16:{s:2:"id";s:8:"language";s:5:"table";s:8:"redirect";s:5:"field";s:8:"language";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:8:"redirect";s:12:"entity_field";s:8:"language";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"language_op";s:5:"label";s:17:"Original language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"language_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"language";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:7:{s:18:"redirect_bulk_form";s:18:"redirect_bulk_form";s:21:"redirect_source__path";s:21:"redirect_source__path";s:22:"redirect_redirect__uri";s:22:"redirect_redirect__uri";s:11:"status_code";s:11:"status_code";s:8:"language";s:8:"language";s:7:"created";s:7:"created";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"created";s:4:"info";a:7:{s:18:"redirect_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:21:"redirect_source__path";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:22:"redirect_redirect__uri";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"status_code";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"language";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:0;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:28:"admin/config/search/redirect";}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}}}'),
('', 'views.view.redirect_404', 'a:13:{s:4:"uuid";s:36:"70516bc4-29af-4644-88d3-bd72bdf18898";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:12:"redirect_404";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"xEiwRlPcHIHzIa2IWKrMChHbyV62cH2lobBY0rHDsQA";}s:2:"id";s:12:"redirect_404";s:5:"label";s:12:"Redirect 404";s:6:"module";s:5:"views";s:11:"description";s:0:"";s:3:"tag";s:0:"";s:10:"base_table";s:12:"redirect_404";s:10:"base_field";s:0:"";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"administer redirects";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:10;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:4:"tags";a:2:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:0;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:4:{s:4:"path";s:4:"path";s:5:"count";s:5:"count";s:11:"daily_count";s:11:"daily_count";s:9:"timestamp";s:9:"timestamp";}s:4:"info";a:4:{s:4:"path";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"daily_count";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:7:"default";s:5:"count";s:11:"empty_table";b:0;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:6:{s:4:"path";a:24:{s:5:"table";s:12:"redirect_404";s:5:"field";s:4:"path";s:2:"id";s:4:"path";s:11:"entity_type";N;s:12:"entity_field";N;s:9:"plugin_id";s:8:"standard";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:4:"Path";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:24:{s:2:"id";s:5:"count";s:5:"table";s:12:"redirect_404";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:5:"Count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:6:"format";s:12:"unserialized";s:3:"key";s:0:"";s:9:"plugin_id";s:10:"serialized";}s:11:"daily_count";a:24:{s:2:"id";s:11:"daily_count";s:5:"table";s:12:"redirect_404";s:5:"field";s:11:"daily_count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:11:"Daily count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:6:"format";s:12:"unserialized";s:3:"key";s:0:"";s:9:"plugin_id";s:10:"serialized";}s:9:"timestamp";a:25:{s:2:"id";s:9:"timestamp";s:5:"table";s:12:"redirect_404";s:5:"field";s:9:"timestamp";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:13:"Last accessed";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:9:"plugin_id";s:4:"date";}s:8:"langcode";a:22:{s:2:"id";s:8:"langcode";s:5:"table";s:12:"redirect_404";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:8:"Language";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:8:"standard";}s:23:"redirect_404_operations";a:22:{s:2:"id";s:23:"redirect_404_operations";s:5:"table";s:12:"redirect_404";s:5:"field";s:23:"redirect_404_operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:23:"redirect_404_operations";}}s:7:"filters";a:3:{s:4:"path";a:14:{s:2:"id";s:4:"path";s:5:"table";s:12:"redirect_404";s:5:"field";s:4:"path";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:10:{s:11:"operator_id";s:7:"path_op";s:5:"label";s:4:"Path";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"path_op";s:10:"identifier";s:4:"path";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:6:"string";}s:8:"langcode";a:14:{s:2:"id";s:8:"langcode";s:5:"table";s:12:"redirect_404";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:11:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:11:"in_operator";}s:8:"resolved";a:14:{s:2:"id";s:8:"resolved";s:5:"table";s:12:"redirect_404";s:5:"field";s:8:"resolved";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:10:{s:11:"operator_id";s:0:"";s:5:"label";s:8:"Resolved";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"resolved_op";s:10:"identifier";s:8:"resolved";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:7:"boolean";}}s:5:"sorts";a:0:{}s:5:"title";s:13:"Fix 404 pages";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:31:"There are no 404 errors to fix.";s:9:"plugin_id";s:11:"text_custom";}}s:13:"relationships";a:0:{}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:32:"admin/config/search/redirect/404";s:19:"display_description";s:52:"Lists 404 error paths with no redirect assigned yet.";s:7:"enabled";b:1;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.scheduler_scheduled_content', 'a:13:{s:4:"uuid";s:36:"5708022f-b1c9-42bc-8ada-c54fce4856a1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:17:"system.menu.admin";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:9:"scheduler";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uVPQEpmZxMNaMQGTGQghVz_jsbwMAdfEtD2ZDUnhrPg";}s:2:"id";s:27:"scheduler_scheduled_content";s:5:"label";s:17:"Scheduled Content";s:6:"module";s:5:"views";s:11:"description";s:34:"Find and manage scheduled content.";s:3:"tag";s:0:"";s:10:"base_table";s:19:"node_field_revision";s:10:"base_field";s:3:"vid";s:7:"display";a:3:{s:7:"default";a:6:{s:15:"display_options";a:18:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:22:"view scheduled content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:5:{s:14:"items_per_page";i:50;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:4:"tags";a:4:{s:8:"previous";s:12:"‹ previous";s:4:"next";s:8:"next ›";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:1;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:8:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:10:"publish_on";s:10:"publish_on";s:12:"unpublish_on";s:12:"unpublish_on";s:10:"operations";s:10:"operations";}s:4:"info";a:8:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"publish_on";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:12:"unpublish_on";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:7:"default";s:2:"-1";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:8:{s:14:"node_bulk_form";a:26:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:12:"relationship";s:3:"nid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}s:9:"plugin_id";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";}s:5:"title";a:37:{s:2:"id";s:5:"title";s:5:"table";s:19:"node_field_revision";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:4:"trim";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:17:"click_sort_column";s:5:"value";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:9:"plugin_id";s:5:"field";}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:3:"nid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:12:"Content Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:12:"revision_uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:5:"field";s:4:"type";s:9:"user_name";s:17:"click_sort_column";s:5:"value";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";}s:6:"status";a:37:{s:2:"id";s:6:"status";s:5:"table";s:19:"node_field_revision";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:18:"format_custom_true";s:9:"Published";s:19:"format_custom_false";s:11:"Unpublished";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";}s:10:"publish_on";a:37:{s:2:"id";s:10:"publish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Publish on";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:5:"field";}s:12:"unpublish_on";a:37:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:12:"Unpublish on";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:5:"field";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"node_revision";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:17:"entity_operations";}}s:7:"filters";a:7:{s:15:"latest_revision";a:15:{s:2:"id";s:15:"latest_revision";s:5:"table";s:13:"node_revision";s:5:"field";s:15:"latest_revision";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:0:{}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"latest_revision";}s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:19:"node_field_revision";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:0:{}s:11:"placeholder";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:6:"string";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:3:"nid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:0:{}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:6:"bundle";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:19:"node_field_revision";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:0:{}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:19:"node_field_revision";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:0:{}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"language";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";}s:10:"publish_on";a:16:{s:2:"id";s:10:"publish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:11:"placeholder";s:0:"";s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";s:14:"remember_roles";a:0:{}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"node";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:4:"date";}s:12:"unpublish_on";a:16:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:19:"node_field_revision";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:11:"placeholder";s:0:"";s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";s:14:"remember_roles";a:0:{}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"node";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:4:"date";}}s:5:"sorts";a:0:{}s:5:"title";s:17:"Scheduled Content";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:21:"No scheduled content.";s:9:"plugin_id";s:11:"text_custom";}}s:9:"arguments";a:0:{}s:13:"relationships";a:2:{s:3:"nid";a:10:{s:2:"id";s:3:"nid";s:5:"table";s:19:"node_field_revision";s:5:"field";s:3:"nid";s:11:"admin_label";s:7:"node id";s:8:"required";b:0;s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"nid";s:9:"plugin_id";s:8:"standard";}s:12:"revision_uid";a:10:{s:2:"id";s:12:"revision_uid";s:5:"table";s:13:"node_revision";s:5:"field";s:12:"revision_uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:16:"revision user id";s:8:"required";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:12:"revision_uid";s:9:"plugin_id";s:8:"standard";}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:2:{i:1;s:3:"AND";i:2;s:2:"OR";}}s:17:"display_extenders";a:0:{}}s:14:"display_plugin";s:7:"default";s:13:"display_title";s:6:"Master";s:2:"id";s:7:"default";s:8:"position";i:0;s:14:"cache_metadata";a:3:{s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:7:"max-age";i:0;s:4:"tags";a:0:{}}}s:8:"overview";a:6:{s:15:"display_options";a:6:{s:4:"path";s:23:"admin/content/scheduled";s:4:"menu";a:8:{s:4:"type";s:6:"normal";s:5:"title";s:17:"Scheduled Content";s:11:"description";s:56:"Content that is scheduled for publishing or unpublishing";s:8:"expanded";b:0;s:6:"parent";s:20:"system.admin_content";s:6:"weight";i:-10;s:7:"context";s:1:"0";s:9:"menu_name";s:5:"admin";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:33:"Find and manage scheduled content";s:9:"menu_name";s:5:"admin";s:6:"weight";i:-10;}s:17:"display_extenders";a:0:{}s:19:"display_description";s:72:"Overview of all scheduled content, as a tab on main ''content admin'' page";s:15:"display_comment";s:127:"Revision nid relationship is required because the content type is only stored at ''content'' level, not ''content revision'' level.";}s:14:"display_plugin";s:4:"page";s:13:"display_title";s:16:"Content Overview";s:2:"id";s:8:"overview";s:8:"position";i:1;s:14:"cache_metadata";a:3:{s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:7:"max-age";i:0;s:4:"tags";a:0:{}}}s:9:"user_page";a:6:{s:15:"display_options";a:10:{s:4:"path";s:20:"user/%user/scheduled";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:9:"Scheduled";s:11:"description";s:0:"";s:6:"parent";s:9:"user.page";s:6:"weight";i:-10;s:7:"context";s:1:"0";s:9:"menu_name";s:5:"admin";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:33:"Find and manage scheduled content";s:9:"menu_name";s:5:"admin";s:6:"weight";i:-10;}s:17:"display_extenders";a:0:{}s:19:"display_description";s:81:"Scheduled content tab on user profile, showing just that user''s scheduled content";s:8:"defaults";a:5:{s:7:"filters";b:1;s:13:"filter_groups";b:1;s:9:"arguments";b:0;s:6:"access";b:0;s:5:"empty";b:0;}s:9:"arguments";a:1:{s:3:"uid";a:23:{s:2:"id";s:3:"uid";s:5:"table";s:19:"node_field_revision";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:14:"default_action";s:5:"empty";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:14:"items_per_page";i:25;s:8:"override";b:0;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:11:"entity:user";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:5:{s:9:"operation";s:4:"view";s:8:"multiple";i:0;s:6:"access";b:0;s:14:"restrict_roles";b:0;s:5:"roles";a:0:{}}s:12:"break_phrase";b:0;s:3:"not";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:16:"entity_target_id";s:21:"target_entity_type_id";s:4:"user";}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:1;s:7:"content";s:49:"No scheduled content for user {{ arguments.uid }}";s:9:"plugin_id";s:11:"text_custom";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:15:"display_comment";s:172:"Access to the user view is controlled via SchedulerRouteSubscriber::alterRoutes(). The high-level permission "access content" is added to satisfy the security_review module";}s:14:"display_plugin";s:4:"page";s:13:"display_title";s:4:"User";s:2:"id";s:9:"user_page";s:8:"position";i:2;s:14:"cache_metadata";a:3:{s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:7:"max-age";i:0;s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.scheduler_scheduled_media', 'a:13:{s:4:"uuid";s:36:"84b66254-f821-4c96-aae4-a40717e30fda";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:17:"system.menu.admin";}s:6:"module";a:2:{i:0;s:5:"media";i:1;s:4:"user";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:9:"scheduler";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YRy2WeHDLh-luDD3tNW3oTAOBJXXDxo4x5lCCox6aSo";}s:2:"id";s:25:"scheduler_scheduled_media";s:5:"label";s:15:"Scheduled Media";s:6:"module";s:5:"views";s:11:"description";s:32:"Find and manage scheduled media.";s:3:"tag";s:0:"";s:10:"base_table";s:20:"media_field_revision";s:10:"base_field";s:3:"vid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:5:"title";s:15:"Scheduled Media";s:6:"fields";a:8:{s:15:"media_bulk_form";a:26:{s:2:"id";s:15:"media_bulk_form";s:5:"table";s:5:"media";s:5:"field";s:15:"media_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:20:"media_field_revision";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Media Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"bundle";a:37:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:3:"mid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Media type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:20:"media_field_revision";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"status";a:37:{s:2:"id";s:6:"status";s:5:"table";s:20:"media_field_revision";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"publish_on";a:37:{s:2:"id";s:10:"publish_on";s:5:"table";s:20:"media_field_revision";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Publish on";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:12:"unpublish_on";a:37:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:20:"media_field_revision";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Unpublish on";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:14:"media_revision";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"view scheduled media";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No scheduled media.";s:8:"tokenize";b:0;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:7:{s:15:"latest_revision";a:15:{s:2:"id";s:15:"latest_revision";s:5:"table";s:14:"media_revision";s:5:"field";s:15:"latest_revision";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:9:"plugin_id";s:15:"latest_revision";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:20:"media_field_revision";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:10:"Media name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"bundle";a:16:{s:2:"id";s:6:"bundle";s:5:"table";s:16:"media_field_data";s:5:"field";s:6:"bundle";s:12:"relationship";s:3:"mid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"bundle";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"bundle_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"bundle_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"bundle";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:20:"media_field_revision";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:20:"media_field_revision";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:10:"publish_on";a:16:{s:2:"id";s:10:"publish_on";s:5:"table";s:20:"media_field_revision";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:4:"date";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"unpublish_on";a:16:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:20:"media_field_revision";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:4:"date";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:15:"min_placeholder";N;s:15:"max_placeholder";N;s:11:"placeholder";N;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:2:{i:1;s:3:"AND";i:2;s:2:"OR";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:15:"media_bulk_form";s:15:"media_bulk_form";s:4:"name";s:4:"name";s:6:"bundle";s:6:"bundle";s:3:"uid";s:3:"uid";s:6:"status";s:6:"status";s:10:"publish_on";s:10:"publish_on";s:12:"unpublish_on";s:12:"unpublish_on";s:10:"operations";s:10:"operations";}s:7:"default";s:10:"publish_on";s:4:"info";a:8:{s:15:"media_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"bundle";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"publish_on";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:12:"unpublish_on";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"mid";a:10:{s:2:"id";s:3:"mid";s:5:"table";s:20:"media_field_revision";s:5:"field";s:3:"mid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:11:"Media Field";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:3:"mid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:8:"overview";a:6:{s:2:"id";s:8:"overview";s:13:"display_title";s:14:"Media Overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:19:"display_description";s:60:"Overview of all scheduled media, via main admin content page";s:17:"display_extenders";a:0:{}s:4:"path";s:29:"admin/content/media/scheduled";s:4:"menu";a:8:{s:4:"type";s:6:"normal";s:5:"title";s:15:"Scheduled Media";s:11:"description";s:61:"Media items that are scheduled for publishing or unpublishing";s:6:"weight";i:0;s:8:"expanded";b:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:20:"system.admin_content";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:9:"user_page";a:6:{s:2:"id";s:9:"user_page";s:13:"display_title";s:4:"User";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:9:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:10:"view media";}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:47:"No scheduled media for user {{ arguments.uid }}";s:8:"tokenize";b:1;}}s:9:"arguments";a:1:{s:3:"uid";a:7:{s:2:"id";s:3:"uid";s:5:"table";s:20:"media_field_revision";s:5:"field";s:3:"uid";s:11:"entity_type";s:5:"media";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:16:"entity_target_id";s:21:"target_entity_type_id";s:4:"user";}}s:8:"defaults";a:3:{s:5:"empty";b:0;s:6:"access";b:0;s:9:"arguments";b:0;}s:19:"display_description";s:73:"Scheduled media on user profile, showing just that user''s scheduled media";s:15:"display_comment";s:168:"Access to the user view is controlled via SchedulerRouteSubscriber::alterRoutes(). The high-level permission "view media" is added to satisfy the security_review module";s:17:"display_extenders";a:0:{}s:4:"path";s:26:"user/%user/scheduled_media";s:4:"menu";a:8:{s:4:"type";s:3:"tab";s:5:"title";s:15:"Scheduled Media";s:11:"description";s:28:"Scheduled Media by this user";s:6:"weight";i:-1;s:8:"expanded";b:0;s:9:"menu_name";s:7:"account";s:6:"parent";s:9:"user.page";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.scheduler_scheduled_taxonomy_term', 'a:13:{s:4:"uuid";s:36:"fb015335-e445-4795-97aa-2c34cdda88c6";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:17:"system.menu.admin";}s:6:"module";a:2:{i:0;s:8:"taxonomy";i:1;s:4:"user";}s:8:"enforced";a:1:{s:6:"module";a:1:{i:0;s:9:"scheduler";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7ZcJnFko4-mLBQqyaReXIMqUrIsp-0UxhrOrcuqXYS4";}s:2:"id";s:33:"scheduler_scheduled_taxonomy_term";s:5:"label";s:24:"Scheduled Taxonomy Terms";s:6:"module";s:5:"views";s:11:"description";s:41:"Find and manage scheduled taxonomy terms.";s:3:"tag";s:0:"";s:10:"base_table";s:24:"taxonomy_term_field_data";s:10:"base_field";s:3:"tid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:5:"title";s:24:"Scheduled Taxonomy Terms";s:6:"fields";a:7:{s:23:"taxonomy_term_bulk_form";a:26:{s:2:"id";s:23:"taxonomy_term_bulk_form";s:5:"table";s:18:"taxonomy_term_data";s:5:"field";s:23:"taxonomy_term_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:9:"plugin_id";s:9:"bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"exclude";s:16:"selected_actions";a:0:{}}s:4:"name";a:38:{s:2:"id";s:4:"name";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:9:"term_name";s:5:"label";s:4:"Term";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:14:"convert_spaces";b:0;}s:3:"vid";a:37:{s:2:"id";s:3:"vid";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:3:"vid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:3:"vid";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Vocabulary";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:6:"status";a:37:{s:2:"id";s:6:"status";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"publish_on";a:37:{s:2:"id";s:10:"publish_on";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Publish on";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:12:"unpublish_on";a:37:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Unpublish on";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:18:"taxonomy_term_data";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:6:{s:6:"offset";i:0;s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:28:"view scheduled taxonomy_term";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:27:"No scheduled taxonomy terms";s:8:"tokenize";b:0;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:4:"name";a:16:{s:2:"id";s:4:"name";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"name_op";s:5:"label";s:9:"Term name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"name_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:3:"vid";a:16:{s:2:"id";s:3:"vid";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:3:"vid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:3:"vid";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:6:"vid_op";s:5:"label";s:10:"Vocabulary";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:6:"vid_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:3:"vid";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:24:"taxonomy_term_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:10:"publish_on";a:16:{s:2:"id";s:10:"publish_on";s:5:"table";s:28:"taxonomy_term_field_revision";s:5:"field";s:10:"publish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:10:"publish_on";s:9:"plugin_id";s:4:"date";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:15:"min_placeholder";N;s:15:"max_placeholder";N;s:11:"placeholder";N;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"unpublish_on";a:16:{s:2:"id";s:12:"unpublish_on";s:5:"table";s:28:"taxonomy_term_field_revision";s:5:"field";s:12:"unpublish_on";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"taxonomy_term";s:12:"entity_field";s:12:"unpublish_on";s:9:"plugin_id";s:4:"date";s:8:"operator";s:9:"not empty";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:0:"";s:4:"type";s:4:"date";}s:5:"group";i:2;s:7:"exposed";b:0;s:6:"expose";a:15:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:15:"min_placeholder";s:0:"";s:15:"max_placeholder";s:0:"";s:11:"placeholder";s:0:"";}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:2:{i:1;s:3:"AND";i:2;s:2:"OR";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:23:"taxonomy_term_bulk_form";s:23:"taxonomy_term_bulk_form";s:4:"name";s:4:"name";s:3:"vid";s:3:"vid";s:6:"status";s:6:"status";s:10:"publish_on";s:10:"publish_on";s:12:"unpublish_on";s:12:"unpublish_on";}s:7:"default";s:10:"publish_on";s:4:"info";a:6:{s:23:"taxonomy_term_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"vid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"publish_on";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:12:"unpublish_on";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:8:"overview";a:6:{s:2:"id";s:8:"overview";s:13:"display_title";s:14:"Taxonomy Terms";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:19:"display_description";s:61:"Overview of all scheduled terms, via main admin taxonomy page";s:17:"display_extenders";a:0:{}s:4:"path";s:34:"admin/structure/taxonomy/scheduled";s:4:"menu";a:8:{s:4:"type";s:6:"normal";s:5:"title";s:24:"Scheduled Taxonomy Terms";s:11:"description";s:64:"Taxonomy Terms that are scheduled for publishing or unpublishing";s:6:"weight";i:0;s:8:"expanded";b:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:37:"entity.taxonomy_vocabulary.collection";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.taxonomy_term', 'a:13:{s:4:"uuid";s:36:"83351b64-f783-4406-81e5-cf40ffa949c1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"core.entity_view_mode.node.card";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KZYBlfIVZuXjvmTL28MLoopyltGJz2SvNa_uu8-9NxE";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:22:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:18:"taxonomy_index_tid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:7:"bundles";a:0:{}s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:4:"card";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"entity";s:5:"empty";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:8:"tokenize";b:1;s:13:"bypass_access";b:0;}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:7:"default";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:15:"taxonomy/term/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.user_admin_people', 'a:13:{s:4:"uuid";s:36:"aafad72b-0a2e-477e-a060-fda1b01b4706";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hZxrM4LiKjRy1g-zZSX1RExTVK8SKQAtMrsRER1420I";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:25:{s:5:"title";s:6:"People";s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:14:"user_bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:7:"Blocked";s:18:"format_custom_true";s:6:"Active";}}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:20:"No people available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"user_permissions";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:11:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:7:"default";s:7:"created";s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:15:"display_comment";s:0:"";s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:17:"admin/people/list";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.watchdog', 'a:13:{s:4:"uuid";s:36:"de668207-0911-47d7-a873-921e5f38bbc8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"dblog";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QxV85zTbzQHWnwqOjUQ9k-Hza0YP94TJebVvD1rVucg";}s:2:"id";s:8:"watchdog";s:5:"label";s:8:"Watchdog";s:6:"module";s:5:"views";s:11:"description";s:19:"Recent log messages";s:3:"tag";s:0:"";s:10:"base_table";s:8:"watchdog";s:10:"base_field";s:3:"wid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:19:"Recent log messages";s:6:"fields";a:8:{s:7:"nothing";a:22:{s:2:"id";s:7:"nothing";s:5:"table";s:5:"views";s:5:"field";s:7:"nothing";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"Icon";s:9:"plugin_id";s:6:"custom";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:4:"icon";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:0;}s:3:"wid";a:22:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:3:"WID";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"severity";a:23:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"machine_name";s:5:"label";s:8:"Severity";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"machine_name";b:0;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:4:"Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:9:"timestamp";a:25:{s:2:"id";s:9:"timestamp";s:5:"table";s:8:"watchdog";s:5:"field";s:9:"timestamp";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"label";s:4:"Date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:7:"message";a:23:{s:2:"id";s:7:"message";s:5:"table";s:8:"watchdog";s:5:"field";s:7:"message";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:13:"dblog_message";s:5:"label";s:7:"Message";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/reports/dblog/event/{{ wid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:13:"{{ message }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:56;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:1;s:4:"trim";b:1;s:13:"preserve_tags";s:0:"";s:4:"html";b:1;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"replace_variables";b:1;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"User";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"link";a:22:{s:2:"id";s:4:"link";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"link";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"dblog_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:0;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"access site reports";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:4:"area";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:26:"No log messages available.";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:26:"No log messages available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:3:"wid";a:10:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"wid";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:4:"type";a:14:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"dblog_types";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"severity";a:14:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"in_operator";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"severity_op";s:5:"label";s:8:"Severity";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"severity_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"severity";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:25:"{{ type }} {{ severity }}";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:7:"nothing";s:7:"nothing";s:3:"wid";s:3:"wid";s:8:"severity";s:8:"severity";s:4:"type";s:4:"type";s:9:"timestamp";s:9:"timestamp";s:7:"message";s:7:"message";s:4:"name";s:4:"name";s:4:"link";s:4:"link";}s:7:"default";s:3:"wid";s:4:"info";a:8:{s:7:"nothing";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:3:"wid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:8:"severity";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:9:"timestamp";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"message";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:4:"link";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:0;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"User";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:11:"admin-dblog";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:4:"page";a:6:{s:2:"id";s:4:"page";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/reports/dblog";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'workflows.workflow.basic_editorial', 'a:9:{s:4:"uuid";s:36:"dbe98800-283c-4e24-8514-501d5bcde77e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:18:"content_moderation";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cTcLoeCkGY_boimnlZKzLdtKZmR7FXc6AirGUwq_Lts";}s:2:"id";s:15:"basic_editorial";s:5:"label";s:5:"Basic";s:4:"type";s:18:"content_moderation";s:13:"type_settings";a:4:{s:6:"states";a:3:{s:5:"draft";a:4:{s:5:"label";s:5:"Draft";s:6:"weight";i:-1;s:9:"published";b:0;s:16:"default_revision";b:0;}s:9:"published";a:4:{s:5:"label";s:9:"Published";s:6:"weight";i:0;s:9:"published";b:1;s:16:"default_revision";b:1;}s:11:"unpublished";a:4:{s:5:"label";s:11:"Unpublished";s:6:"weight";i:1;s:9:"published";b:0;s:16:"default_revision";b:1;}}s:11:"transitions";a:3:{s:16:"create_new_draft";a:4:{s:5:"label";s:16:"Create new draft";s:4:"from";a:3:{i:0;s:11:"unpublished";i:1;s:5:"draft";i:2;s:9:"published";}s:2:"to";s:5:"draft";s:6:"weight";i:-1;}s:7:"publish";a:4:{s:5:"label";s:7:"Publish";s:4:"from";a:3:{i:0;s:5:"draft";i:1;s:9:"published";i:2;s:11:"unpublished";}s:2:"to";s:9:"published";s:6:"weight";i:0;}s:9:"unpublish";a:4:{s:5:"label";s:9:"Unpublish";s:4:"from";a:1:{i:0;s:9:"published";}s:2:"to";s:11:"unpublished";s:6:"weight";i:1;}}s:12:"entity_types";a:1:{s:4:"node";a:1:{i:0;s:4:"page";}}s:24:"default_moderation_state";s:5:"draft";}}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_moderation_state`
--

CREATE TABLE `[[dbprefix]]content_moderation_state` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int unsigned DEFAULT NULL,
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `content_moderation_state_field__uuid__value` (`uuid`),
  UNIQUE KEY `content_moderation_state__revision_id` (`revision_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='The base table for content_moderation_state entities.' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]content_moderation_state`
--

INSERT INTO `[[dbprefix]]content_moderation_state` VALUES
(1, 1, 'e9b4a6a0-75dc-42fb-8900-e3458311adfe', 'en'),
(2, 2, '267c0ed4-251c-4e22-813b-5ec8d7b37a9d', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_moderation_state_field_data`
--

CREATE TABLE `[[dbprefix]]content_moderation_state_field_data` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `uid` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `workflow` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'The ID of the target entity.',
  `moderation_state` varchar(255) DEFAULT NULL,
  `content_entity_type_id` varchar(32) DEFAULT NULL,
  `content_entity_id` int DEFAULT NULL,
  `content_entity_revision_id` int DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`,`langcode`),
  UNIQUE KEY `content_moderation_state__lookup` (`content_entity_type_id`,`content_entity_id`,`content_entity_revision_id`,`workflow`,`langcode`),
  KEY `content_moderation_state__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `content_moderation_state__revision_id` (`revision_id`),
  KEY `content_moderation_state_field__uid__target_id` (`uid`),
  KEY `content_moderation_state__09628d8dbc` (`workflow`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for content_moderation_state entities.';

--
-- Dumping data for table `[[dbprefix]]content_moderation_state_field_data`
--

INSERT INTO `[[dbprefix]]content_moderation_state_field_data` VALUES
(1, 1, 'en', 1, 'basic_editorial', 'draft', 'node', 1, 1, 1, 1),
(2, 2, 'en', 1, 'basic_editorial', 'published', 'node', 2, 2, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_moderation_state_field_revision`
--

CREATE TABLE `[[dbprefix]]content_moderation_state_field_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `uid` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `workflow` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'The ID of the target entity.',
  `moderation_state` varchar(255) DEFAULT NULL,
  `content_entity_type_id` varchar(32) DEFAULT NULL,
  `content_entity_id` int DEFAULT NULL,
  `content_entity_revision_id` int DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`,`langcode`),
  UNIQUE KEY `content_moderation_state__lookup` (`content_entity_type_id`,`content_entity_id`,`content_entity_revision_id`,`workflow`,`langcode`),
  KEY `content_moderation_state__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `content_moderation_state_field__uid__target_id` (`uid`),
  KEY `content_moderation_state__09628d8dbc` (`workflow`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for content_moderation_state…';

--
-- Dumping data for table `[[dbprefix]]content_moderation_state_field_revision`
--

INSERT INTO `[[dbprefix]]content_moderation_state_field_revision` VALUES
(1, 1, 'en', 1, 'basic_editorial', 'draft', 'node', 1, 1, 1, 1),
(2, 2, 'en', 1, 'basic_editorial', 'published', 'node', 2, 2, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_moderation_state_revision`
--

CREATE TABLE `[[dbprefix]]content_moderation_state_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `content_moderation_state__id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for content_moderation_state entities.' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]content_moderation_state_revision`
--

INSERT INTO `[[dbprefix]]content_moderation_state_revision` VALUES
(1, 1, 'en', 1),
(2, 2, 'en', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]crop`
--

CREATE TABLE `[[dbprefix]]crop` (
  `cid` int unsigned NOT NULL AUTO_INCREMENT,
  `vid` int unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`cid`),
  UNIQUE KEY `crop_field__uuid__value` (`uuid`),
  UNIQUE KEY `crop__vid` (`vid`),
  KEY `crop_field__type__target_id` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='The base table for crop entities.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]crop`
--

INSERT INTO `[[dbprefix]]crop` VALUES
(1, 1, 'focal_point', '893f1eb0-a0b2-4553-a3fd-d3f05db1695b', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]crop_field_data`
--

CREATE TABLE `[[dbprefix]]crop_field_data` (
  `cid` int unsigned NOT NULL,
  `vid` int unsigned NOT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `entity_id` int unsigned DEFAULT NULL,
  `entity_type` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `x` int unsigned DEFAULT NULL,
  `y` int unsigned DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`cid`,`langcode`),
  KEY `crop__id__default_langcode__langcode` (`cid`,`default_langcode`,`langcode`),
  KEY `crop__vid` (`vid`),
  KEY `crop_field__type__target_id` (`type`),
  KEY `crop__uri_type` (`uri`(191),`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for crop entities.';

--
-- Dumping data for table `[[dbprefix]]crop_field_data`
--

INSERT INTO `[[dbprefix]]crop_field_data` VALUES
(1, 1, 'focal_point', 'en', 1, 'file', 'public://2024-12/drupal-cms-hero.webp', NULL, NULL, 600, 240, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]crop_field_revision`
--

CREATE TABLE `[[dbprefix]]crop_field_revision` (
  `cid` int unsigned NOT NULL,
  `vid` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `entity_id` int unsigned DEFAULT NULL,
  `entity_type` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `x` int unsigned DEFAULT NULL,
  `y` int unsigned DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`vid`,`langcode`),
  KEY `crop__id__default_langcode__langcode` (`cid`,`default_langcode`,`langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for crop entities.';

--
-- Dumping data for table `[[dbprefix]]crop_field_revision`
--

INSERT INTO `[[dbprefix]]crop_field_revision` VALUES
(1, 1, 'en', 1, 'file', 'public://2024-12/drupal-cms-hero.webp', NULL, NULL, 600, 240, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]crop_revision`
--

CREATE TABLE `[[dbprefix]]crop_revision` (
  `cid` int unsigned NOT NULL,
  `vid` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `revision_timestamp` int DEFAULT NULL,
  `revision_uid` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_log` longtext,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`vid`),
  KEY `crop__cid` (`cid`),
  KEY `crop_field__revision_uid__target_id` (`revision_uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for crop entities.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]crop_revision`
--

INSERT INTO `[[dbprefix]]crop_revision` VALUES
(1, 1, 'en', [[timestamp]], 1, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email`
--

CREATE TABLE `[[dbprefix]]easy_email` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `vid` int unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `creator_uid` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `from_name` varchar(255) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `reply_to` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `body_html__value` longtext,
  `body_html__format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  `body_plain` longtext,
  `inbox_preview` longtext,
  `created` int DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `sent` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `easy_email_field__uuid__value` (`uuid`),
  UNIQUE KEY `easy_email__vid` (`vid`),
  KEY `easy_email_field__type__target_id` (`type`),
  KEY `easy_email_field__creator_uid__target_id` (`creator_uid`),
  KEY `easy_email_field__body_html__format` (`body_html__format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for easy_email entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision`
--

CREATE TABLE `[[dbprefix]]easy_email_revision` (
  `id` int unsigned NOT NULL,
  `vid` int unsigned NOT NULL AUTO_INCREMENT,
  `revision_created` int DEFAULT NULL,
  `revision_user` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_log_message` longtext,
  `label` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `creator_uid` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `from_name` varchar(255) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `reply_to` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `body_html__value` longtext,
  `body_html__format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  `body_plain` longtext,
  `inbox_preview` longtext,
  `sent` int DEFAULT NULL,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`vid`),
  KEY `easy_email__id` (`id`),
  KEY `easy_email_field__revision_user__target_id` (`revision_user`),
  KEY `easy_email_field__creator_uid__target_id` (`creator_uid`),
  KEY `easy_email_field__body_html__format` (`body_html__format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for easy_email entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__attachment`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__attachment` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `attachment_target_id` int unsigned NOT NULL COMMENT 'The ID of the file entity.',
  `attachment_display` tinyint unsigned DEFAULT '1' COMMENT 'Flag to control whether this file should be displayed when viewing content.',
  `attachment_description` text COMMENT 'A description of the file.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `attachment_target_id` (`attachment_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field attachment.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__attachment_path`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__attachment_path` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `attachment_path_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field attachment…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__bcc_address`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__bcc_address` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `bcc_address_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field bcc_address.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__bcc_uid`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__bcc_uid` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `bcc_uid_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `bcc_uid_target_id` (`bcc_uid_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field bcc_uid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__cc_address`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__cc_address` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `cc_address_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field cc_address.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__cc_uid`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__cc_uid` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `cc_uid_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `cc_uid_target_id` (`cc_uid_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field cc_uid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__field_related_user`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__field_related_user` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_related_user_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_related_user_target_id` (`field_related_user_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field field_related…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__recipient_address`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__recipient_address` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `recipient_address_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field recipient…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email_revision__recipient_uid`
--

CREATE TABLE `[[dbprefix]]easy_email_revision__recipient_uid` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `recipient_uid_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `recipient_uid_target_id` (`recipient_uid_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for easy_email field recipient_uid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__attachment`
--

CREATE TABLE `[[dbprefix]]easy_email__attachment` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `attachment_target_id` int unsigned NOT NULL COMMENT 'The ID of the file entity.',
  `attachment_display` tinyint unsigned DEFAULT '1' COMMENT 'Flag to control whether this file should be displayed when viewing content.',
  `attachment_description` text COMMENT 'A description of the file.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `attachment_target_id` (`attachment_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field attachment.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__attachment_path`
--

CREATE TABLE `[[dbprefix]]easy_email__attachment_path` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `attachment_path_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field attachment_path.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__bcc_address`
--

CREATE TABLE `[[dbprefix]]easy_email__bcc_address` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `bcc_address_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field bcc_address.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__bcc_uid`
--

CREATE TABLE `[[dbprefix]]easy_email__bcc_uid` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `bcc_uid_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `bcc_uid_target_id` (`bcc_uid_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field bcc_uid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__cc_address`
--

CREATE TABLE `[[dbprefix]]easy_email__cc_address` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `cc_address_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field cc_address.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__cc_uid`
--

CREATE TABLE `[[dbprefix]]easy_email__cc_uid` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `cc_uid_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `cc_uid_target_id` (`cc_uid_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field cc_uid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__field_related_user`
--

CREATE TABLE `[[dbprefix]]easy_email__field_related_user` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_related_user_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_related_user_target_id` (`field_related_user_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field field_related_user.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__recipient_address`
--

CREATE TABLE `[[dbprefix]]easy_email__recipient_address` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `recipient_address_value` varchar(255) NOT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field recipient_address.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]easy_email__recipient_uid`
--

CREATE TABLE `[[dbprefix]]easy_email__recipient_uid` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `recipient_uid_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `recipient_uid_target_id` (`recipient_uid_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for easy_email field recipient_uid.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_managed`
--

CREATE TABLE `[[dbprefix]]file_managed` (
  `fid` int unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `uid` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `filename` varchar(255) DEFAULT NULL,
  `uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `filemime` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  `filesize` bigint unsigned DEFAULT NULL,
  `status` tinyint NOT NULL,
  `created` int DEFAULT NULL,
  `changed` int NOT NULL,
  PRIMARY KEY (`fid`),
  UNIQUE KEY `file_field__uuid__value` (`uuid`),
  KEY `file_field__uid__target_id` (`uid`),
  KEY `file_field__uri` (`uri`(191)),
  KEY `file_field__status` (`status`),
  KEY `file_field__changed` (`changed`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='The base table for file entities.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]file_managed`
--

INSERT INTO `[[dbprefix]]file_managed` VALUES
(1, '05439bd3-1c60-4e1a-8719-e9da071e88e4', 'en', 1, 'drupal-cms-hero.webp', 'public://2024-12/drupal-cms-hero.webp', 'image/webp', 68934, 1, 1733288974, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_usage`
--

CREATE TABLE `[[dbprefix]]file_usage` (
  `fid` int unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(50) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Track where a file is used.';

--
-- Dumping data for table `[[dbprefix]]file_usage`
--

INSERT INTO `[[dbprefix]]file_usage` VALUES
(1, 'file', 'media', '1', 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]honeypot_user`
--

CREATE TABLE `[[dbprefix]]honeypot_user` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Unique record ID.',
  `uid` int unsigned NOT NULL COMMENT 'Foreign key to "[[dbprefix]]users".uid. uniquely identifies a Drupal user to whom this ACL data applies.',
  `hostname` varchar(128) NOT NULL COMMENT 'Hostname of user that that triggered honeypot.',
  `timestamp` int unsigned NOT NULL COMMENT 'Date/time when the form submission failed, as Unix timestamp.',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `timestamp` (`timestamp`),
  KEY `hostname` (`hostname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Table that stores failed attempts to submit a form.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inline_block_usage`
--

CREATE TABLE `[[dbprefix]]inline_block_usage` (
  `block_content_id` int unsigned NOT NULL COMMENT 'The block_content entity ID.',
  `layout_entity_type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT '' COMMENT 'The entity type of the parent entity.',
  `layout_entity_id` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT '0' COMMENT 'The ID of the parent entity.',
  PRIMARY KEY (`block_content_id`),
  KEY `type_id` (`layout_entity_type`,`layout_entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Track where a block_content entity is used.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]key_value`
--

CREATE TABLE `[[dbprefix]]key_value` (
  `collection` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',
  `name` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The key of the key-value pair. As KEY is a SQL reserved keyword, name was chosen instead.',
  `value` longblob NOT NULL COMMENT 'The value.',
  PRIMARY KEY (`collection`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Generic key-value storage table. See the state system for…';

--
-- Dumping data for table `[[dbprefix]]key_value`
--

INSERT INTO `[[dbprefix]]key_value` VALUES
('config.entity.key_store.action', 'uuid:1ff5ca7b-0e64-4690-9ee9-848504316e59', 'a:1:{i:0;s:37:"system.action.user_cancel_user_action";}'),
('config.entity.key_store.action', 'uuid:26952575-7e52-493d-a916-125a77c385c5', 'a:1:{i:0;s:39:"system.action.node_make_unsticky_action";}'),
('config.entity.key_store.action', 'uuid:2ee41053-337a-4e09-8c08-95c667ef031f', 'a:1:{i:0;s:32:"system.action.node_delete_action";}'),
('config.entity.key_store.action', 'uuid:3577b100-c4c8-41cd-8869-f40ab63d2764', 'a:1:{i:0;s:35:"system.action.node_unpromote_action";}'),
('config.entity.key_store.action', 'uuid:395192a9-eff1-4959-8306-9afc590605e6', 'a:1:{i:0;s:44:"system.action.taxonomy_term_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:5cb6ee93-ffc4-4fb0-813d-fe2fa843581d', 'a:1:{i:0;s:36:"system.action.redirect_delete_action";}'),
('config.entity.key_store.action', 'uuid:5eee0209-d98b-4cef-8577-2bf4d4b698bb', 'a:1:{i:0;s:42:"system.action.taxonomy_term_publish_action";}'),
('config.entity.key_store.action', 'uuid:5f79ae5d-8006-438c-a9c0-daf277ff8edb', 'a:1:{i:0;s:31:"system.action.media_save_action";}'),
('config.entity.key_store.action', 'uuid:7b618372-4a4e-4d49-937b-8a3124de24ff', 'a:1:{i:0;s:33:"system.action.media_delete_action";}'),
('config.entity.key_store.action', 'uuid:8d158a08-2b4a-4baf-bd78-8a7cc4d960e8', 'a:1:{i:0;s:48:"system.action.user_add_role_action.administrator";}'),
('config.entity.key_store.action', 'uuid:914f8c70-ba63-4d02-966a-7b4a7b237582', 'a:1:{i:0;s:51:"system.action.user_remove_role_action.administrator";}'),
('config.entity.key_store.action', 'uuid:9fac858a-e88a-4b0b-8615-4267b82d808f', 'a:1:{i:0;s:37:"system.action.node_make_sticky_action";}'),
('config.entity.key_store.action', 'uuid:a70f5410-e023-4491-a6e4-5cd6ff6f8fda', 'a:1:{i:0;s:49:"system.action.user_add_role_action.content_editor";}'),
('config.entity.key_store.action', 'uuid:b8adc3f7-9f03-4660-9888-a4683160bdc4', 'a:1:{i:0;s:30:"system.action.node_save_action";}'),
('config.entity.key_store.action', 'uuid:c98d84e1-8e72-4acc-9c87-c5dda0204773', 'a:1:{i:0;s:33:"system.action.node_publish_action";}'),
('config.entity.key_store.action', 'uuid:d440cf43-9ab5-4633-aed8-e9aa2bd5c67c', 'a:1:{i:0;s:33:"system.action.node_promote_action";}'),
('config.entity.key_store.action', 'uuid:d98a7938-6a18-4999-885d-c84f2380339c', 'a:1:{i:0;s:38:"system.action.user_unblock_user_action";}'),
('config.entity.key_store.action', 'uuid:d9c13b6b-0183-46f7-94c0-1b87a376ffbe', 'a:1:{i:0;s:36:"system.action.user_block_user_action";}'),
('config.entity.key_store.action', 'uuid:db3af404-0741-4b05-8d08-7647b1e7ed74', 'a:1:{i:0;s:36:"system.action.media_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:e0e97b5e-c1b1-4fc8-be1c-85c9bc57e6ce', 'a:1:{i:0;s:52:"system.action.user_remove_role_action.content_editor";}'),
('config.entity.key_store.action', 'uuid:e7289c40-b788-4613-9a18-a1d59600dad8', 'a:1:{i:0;s:35:"system.action.node_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:f39d5d1f-cfba-4841-b96c-d346d97a77b4', 'a:1:{i:0;s:34:"system.action.media_publish_action";}'),
('config.entity.key_store.block', 'theme:claro', 'a:7:{i:0;s:31:"block.block.claro_local_actions";i:1;s:28:"block.block.claro_page_title";i:2;s:37:"block.block.claro_primary_local_tasks";i:3;s:39:"block.block.claro_secondary_local_tasks";i:4;s:29:"block.block.claro_breadcrumbs";i:5;s:25:"block.block.claro_content";i:6;s:26:"block.block.claro_messages";}'),
('config.entity.key_store.block', 'theme:drupal_cms_olivero', 'a:12:{i:0;s:41:"block.block.drupal_cms_olivero_page_title";i:1;s:52:"block.block.drupal_cms_olivero_primary_admin_actions";i:2;s:50:"block.block.drupal_cms_olivero_primary_local_tasks";i:3;s:52:"block.block.drupal_cms_olivero_secondary_local_tasks";i:4;s:42:"block.block.drupal_cms_olivero_breadcrumbs";i:5;s:38:"block.block.drupal_cms_olivero_content";i:6;s:39:"block.block.drupal_cms_olivero_messages";i:7;s:38:"block.block.drupal_cms_olivero_powered";i:8;s:44:"block.block.drupal_cms_olivero_site_branding";i:9;s:43:"block.block.drupal_cms_olivero_account_menu";i:10;s:42:"block.block.drupal_cms_olivero_footer_menu";i:11;s:40:"block.block.drupal_cms_olivero_main_menu";}'),
('config.entity.key_store.block', 'theme:gin', 'a:7:{i:0;s:29:"block.block.gin_local_actions";i:1;s:26:"block.block.gin_page_title";i:2;s:35:"block.block.gin_primary_local_tasks";i:3;s:37:"block.block.gin_secondary_local_tasks";i:4;s:27:"block.block.gin_breadcrumbs";i:5;s:23:"block.block.gin_content";i:6;s:24:"block.block.gin_messages";}'),
('config.entity.key_store.block', 'theme:olivero', 'a:1:{i:0;s:26:"block.block.olivero_footer";}'),
('config.entity.key_store.block', 'uuid:0948c16b-f770-4441-a83b-30701df53a71', 'a:1:{i:0;s:26:"block.block.claro_messages";}'),
('config.entity.key_store.block', 'uuid:0abe34e5-4686-43aa-8418-715988d1219e', 'a:1:{i:0;s:31:"block.block.claro_local_actions";}'),
('config.entity.key_store.block', 'uuid:16216338-b4f2-4a3b-83ca-d91160afe106', 'a:1:{i:0;s:23:"block.block.gin_content";}'),
('config.entity.key_store.block', 'uuid:2be996fd-aed9-4d07-9813-c222a3f770dc', 'a:1:{i:0;s:29:"block.block.gin_local_actions";}'),
('config.entity.key_store.block', 'uuid:30e0895b-6cde-47b4-a017-d3ad832f1bd2', 'a:1:{i:0;s:42:"block.block.drupal_cms_olivero_breadcrumbs";}'),
('config.entity.key_store.block', 'uuid:3a1b386e-a7bc-4f77-9a74-92f920d2e0cd', 'a:1:{i:0;s:35:"block.block.gin_primary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:5619940e-55b4-43d2-9339-a57d0cf2ad82', 'a:1:{i:0;s:37:"block.block.claro_primary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:685ea8bf-2ab0-4dac-94a3-de42fc9abf1f', 'a:1:{i:0;s:40:"block.block.drupal_cms_olivero_main_menu";}'),
('config.entity.key_store.block', 'uuid:6df3916e-1743-4b48-ba77-157bba53cd9f', 'a:1:{i:0;s:29:"block.block.claro_breadcrumbs";}'),
('config.entity.key_store.block', 'uuid:6fa7baee-647b-4692-b6ae-a71a539aa2e4', 'a:1:{i:0;s:38:"block.block.drupal_cms_olivero_content";}'),
('config.entity.key_store.block', 'uuid:77edf79c-3893-4a51-9dd3-10ddd9ae1500', 'a:1:{i:0;s:42:"block.block.drupal_cms_olivero_footer_menu";}'),
('config.entity.key_store.block', 'uuid:784cb964-2348-426e-8f0a-e08db56c8b7d', 'a:1:{i:0;s:26:"block.block.gin_page_title";}'),
('config.entity.key_store.block', 'uuid:8d906e75-e67f-4605-a804-9196cf5c584f', 'a:1:{i:0;s:28:"block.block.claro_page_title";}'),
('config.entity.key_store.block', 'uuid:8ebd595c-60ac-4c81-ab68-2a4ac773461b', 'a:1:{i:0;s:26:"block.block.olivero_footer";}'),
('config.entity.key_store.block', 'uuid:95903753-51f7-4312-a0a8-fa908d0a29ac', 'a:1:{i:0;s:38:"block.block.drupal_cms_olivero_powered";}'),
('config.entity.key_store.block', 'uuid:9815bff3-c1ad-4ae6-9ce5-7525495af502', 'a:1:{i:0;s:39:"block.block.claro_secondary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:9999d3bc-b49f-47dd-a5d3-bccf411a4867', 'a:1:{i:0;s:41:"block.block.drupal_cms_olivero_page_title";}'),
('config.entity.key_store.block', 'uuid:af93c590-9d18-47b1-995d-d57b1be6568a', 'a:1:{i:0;s:27:"block.block.gin_breadcrumbs";}'),
('config.entity.key_store.block', 'uuid:b0040475-87e4-4ef6-b95e-31bdee867455', 'a:1:{i:0;s:24:"block.block.gin_messages";}'),
('config.entity.key_store.block', 'uuid:b716aced-ef8c-422c-a87e-dc0efb48af65', 'a:1:{i:0;s:43:"block.block.drupal_cms_olivero_account_menu";}'),
('config.entity.key_store.block', 'uuid:c94cc6a0-f46b-43c4-aa44-86ef63e661c2', 'a:1:{i:0;s:52:"block.block.drupal_cms_olivero_secondary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:d978c2a1-467b-487d-bf01-4b73f335415f', 'a:1:{i:0;s:50:"block.block.drupal_cms_olivero_primary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:e02bd630-20ba-403d-8d5c-a4f783fd37a2', 'a:1:{i:0;s:39:"block.block.drupal_cms_olivero_messages";}'),
('config.entity.key_store.block', 'uuid:e0cd2708-7262-4266-9710-a79c47a8912c', 'a:1:{i:0;s:37:"block.block.gin_secondary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:e10a6894-6b83-4c53-bd88-a6dbccb6b7d9', 'a:1:{i:0;s:44:"block.block.drupal_cms_olivero_site_branding";}'),
('config.entity.key_store.block', 'uuid:e7251eac-6e1d-4ee4-8e48-7db3f76bc992', 'a:1:{i:0;s:52:"block.block.drupal_cms_olivero_primary_admin_actions";}'),
('config.entity.key_store.block', 'uuid:f2dd4a9b-6139-44d0-8794-3d15fdab279a', 'a:1:{i:0;s:25:"block.block.claro_content";}'),
('config.entity.key_store.crop_type', 'uuid:8bdaef08-251e-4520-868e-b502f81202df', 'a:1:{i:0;s:21:"crop.type.focal_point";}'),
('config.entity.key_store.dashboard', 'uuid:230ccb4d-dac2-4d88-a7a3-80e0e1e38929', 'a:1:{i:0;s:27:"dashboard.dashboard.welcome";}'),
('config.entity.key_store.date_format', 'uuid:2d16c3b4-2274-468c-b38a-1082d7f0cd33', 'a:1:{i:0;s:23:"core.date_format.medium";}'),
('config.entity.key_store.date_format', 'uuid:3926d3dc-9ba5-402b-aa7a-c3ac8647ccfc', 'a:1:{i:0;s:26:"core.date_format.html_time";}'),
('config.entity.key_store.date_format', 'uuid:46b6a58e-fa40-4f21-9053-531b9cd1de2b', 'a:1:{i:0;s:26:"core.date_format.html_date";}'),
('config.entity.key_store.date_format', 'uuid:46e0a274-4797-415e-b0bb-de5e0da037be', 'a:1:{i:0;s:22:"core.date_format.short";}'),
('config.entity.key_store.date_format', 'uuid:7fde1793-69df-4340-a15a-8a827b0001dc', 'a:1:{i:0;s:31:"core.date_format.olivero_medium";}'),
('config.entity.key_store.date_format', 'uuid:83e05f2b-31a2-45a2-9fc7-377e061a9258', 'a:1:{i:0;s:26:"core.date_format.html_year";}'),
('config.entity.key_store.date_format', 'uuid:8bb65156-8355-489c-be01-67eeb04e6fb9', 'a:1:{i:0;s:27:"core.date_format.html_month";}'),
('config.entity.key_store.date_format', 'uuid:8cb753fc-42e4-47fb-8c7b-1dac9e1995d9', 'a:1:{i:0;s:30:"core.date_format.html_datetime";}'),
('config.entity.key_store.date_format', 'uuid:9e732fea-6de7-46a9-962a-879f9755bd8c', 'a:1:{i:0;s:35:"core.date_format.html_yearless_date";}'),
('config.entity.key_store.date_format', 'uuid:aa92fa03-6df5-49a6-8e07-c28cf75016b1', 'a:1:{i:0;s:25:"core.date_format.fallback";}'),
('config.entity.key_store.date_format', 'uuid:b548137d-6c48-4726-97ed-2a45ea184a84', 'a:1:{i:0;s:26:"core.date_format.html_week";}'),
('config.entity.key_store.date_format', 'uuid:c8d08f8c-1d75-48ce-9ed7-9aa2f56ad64a', 'a:1:{i:0;s:21:"core.date_format.long";}'),
('config.entity.key_store.easy_email_override', 'uuid:23e53dcb-88e4-46c5-9d4a-38b0e431532c', 'a:1:{i:0;s:70:"easy_email_override.easy_email_override.user_created_awaiting_approval";}'),
('config.entity.key_store.easy_email_override', 'uuid:39830053-7abf-490f-9853-a9128bba7306', 'a:1:{i:0;s:67:"easy_email_override.easy_email_override.user_created_approval_admin";}'),
('config.entity.key_store.easy_email_override', 'uuid:45883b2d-6239-4cb7-a96b-5e94027c0287', 'a:1:{i:0;s:61:"easy_email_override.easy_email_override.user_created_by_admin";}'),
('config.entity.key_store.easy_email_override', 'uuid:49d976d1-c8a4-42d4-92ba-cd6212cf1d1d', 'a:1:{i:0;s:47:"easy_email_override.easy_email_override.default";}'),
('config.entity.key_store.easy_email_override', 'uuid:57280ca3-9fa0-479a-b232-2a83c8d70b1a', 'a:1:{i:0;s:55:"easy_email_override.easy_email_override.user_activation";}'),
('config.entity.key_store.easy_email_override', 'uuid:60b72ddc-6157-4202-8bea-f25d85052836', 'a:1:{i:0;s:53:"easy_email_override.easy_email_override.user_canceled";}'),
('config.entity.key_store.easy_email_override', 'uuid:636b0eea-eecd-4372-a7af-fc75a05c1d9b', 'a:1:{i:0;s:62:"easy_email_override.easy_email_override.user_password_recovery";}'),
('config.entity.key_store.easy_email_override', 'uuid:7491b9f9-6ddb-499b-a3aa-732eddb70a66', 'a:1:{i:0;s:64:"easy_email_override.easy_email_override.user_created_no_approval";}'),
('config.entity.key_store.easy_email_override', 'uuid:808b5455-b4a8-45c1-99d3-9384dc5466ce', 'a:1:{i:0;s:70:"easy_email_override.easy_email_override.user_cancellation_confirmation";}'),
('config.entity.key_store.easy_email_override', 'uuid:a1db8438-eba6-44f9-95e0-7113125a15ef', 'a:1:{i:0;s:52:"easy_email_override.easy_email_override.user_blocked";}'),
('config.entity.key_store.easy_email_type', 'uuid:28727c2e-02c4-4b40-a8ae-b1673efdb3b9', 'a:1:{i:0;s:42:"easy_email.easy_email_type.user_activation";}'),
('config.entity.key_store.easy_email_type', 'uuid:607e2dff-8127-4593-990e-012136a556e3', 'a:1:{i:0;s:49:"easy_email.easy_email_type.user_password_recovery";}'),
('config.entity.key_store.easy_email_type', 'uuid:66c2e270-2c9a-4080-90ae-f9413e982e28', 'a:1:{i:0;s:54:"easy_email.easy_email_type.user_created_approval_admin";}'),
('config.entity.key_store.easy_email_type', 'uuid:99f5063b-a7b4-44e3-9606-28d8358b95d6', 'a:1:{i:0;s:48:"easy_email.easy_email_type.user_created_by_admin";}'),
('config.entity.key_store.easy_email_type', 'uuid:aa7097af-5398-4980-af93-afd706ce2ff6', 'a:1:{i:0;s:40:"easy_email.easy_email_type.user_canceled";}'),
('config.entity.key_store.easy_email_type', 'uuid:c94b0af6-124b-4e80-a0af-50b975f9e9b3', 'a:1:{i:0;s:57:"easy_email.easy_email_type.user_cancellation_confirmation";}'),
('config.entity.key_store.easy_email_type', 'uuid:e0c62699-ff24-4de0-ae58-528886d33943', 'a:1:{i:0;s:51:"easy_email.easy_email_type.user_created_no_approval";}'),
('config.entity.key_store.easy_email_type', 'uuid:ed344628-a46a-4533-988e-9a8a789b4b38', 'a:1:{i:0;s:57:"easy_email.easy_email_type.user_created_awaiting_approval";}'),
('config.entity.key_store.easy_email_type', 'uuid:f8dc02d0-bf52-4548-9786-48ff76da30b8', 'a:1:{i:0;s:39:"easy_email.easy_email_type.user_blocked";}'),
('config.entity.key_store.easy_email_type', 'uuid:f973cdb2-ae1c-4a2e-8fe4-e6b94e68ebb9', 'a:1:{i:0;s:34:"easy_email.easy_email_type.default";}'),
('config.entity.key_store.eca', 'uuid:0e49f3e4-0d7e-45fa-a109-c56e6f1344ae', 'a:1:{i:0;s:22:"eca.eca.auth_redirects";}'),
('config.entity.key_store.eca', 'uuid:1255d2f3-d267-4ff4-af16-5ff34d1f81e3', 'a:1:{i:0;s:28:"eca.eca.remote_video_consent";}'),
('config.entity.key_store.eca', 'uuid:6198222e-7343-4412-bd56-3ac8f9537e65', 'a:1:{i:0;s:25:"eca.eca.content_duplicate";}'),
('config.entity.key_store.eca', 'uuid:adea79d6-47ab-45bd-9edd-d44852a707c5', 'a:1:{i:0;s:21:"eca.eca.user_register";}'),
('config.entity.key_store.eca', 'uuid:af946129-1c4e-4456-9ebb-aab3f6d54bb7', 'a:1:{i:0;s:28:"eca.eca.privacy_setting_link";}'),
('config.entity.key_store.eca', 'uuid:f6fd46a0-0bef-4bb1-8133-fb7afadbf82c', 'a:1:{i:0;s:23:"eca.eca.unpublished_404";}'),
('config.entity.key_store.editor', 'uuid:90da01ea-0382-45ca-a8a4-2ab0cd64c456', 'a:1:{i:0;s:24:"editor.editor.easy_email";}'),
('config.entity.key_store.editor', 'uuid:accba397-e27f-4a38-90b6-e66fcafbb2db', 'a:1:{i:0;s:28:"editor.editor.content_format";}'),
('config.entity.key_store.entity_form_display', 'uuid:13e34c1f-e2bb-4a6a-90f6-cc8aa2daa67b', 'a:1:{i:0;s:50:"core.entity_form_display.media.image.media_library";}'),
('config.entity.key_store.entity_form_display', 'uuid:1dc3162d-5b65-4b5b-9525-86a35d94bc7a', 'a:1:{i:0;s:54:"core.entity_form_display.media.svg_image.media_library";}'),
('config.entity.key_store.entity_form_display', 'uuid:2c5d8b1d-7e28-4c4b-bf51-8d82cbcfbc5a', 'a:1:{i:0;s:53:"core.entity_form_display.media.document.media_library";}'),
('config.entity.key_store.entity_form_display', 'uuid:2d8d238c-1394-4abe-8ab4-e985a9774fdf', 'a:1:{i:0;s:51:"core.entity_form_display.media.remote_video.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:348701c3-2377-4e1d-bbcc-e3b3bd18bf08', 'a:1:{i:0;s:42:"core.entity_form_display.node.page.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:4844845f-595e-4d69-bc4b-521430befa84', 'a:1:{i:0;s:44:"core.entity_form_display.media.image.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:4c66b6cf-79ef-48d6-b822-a97ec5c42b83', 'a:1:{i:0;s:47:"core.entity_form_display.media.document.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:5fecaf3e-ba52-4138-ad3d-b138ab3bbf42', 'a:1:{i:0;s:57:"core.entity_form_display.media.remote_video.media_library";}'),
('config.entity.key_store.entity_form_display', 'uuid:aaffe547-a18a-4698-8171-ece7f25cda09', 'a:1:{i:0;s:71:"core.entity_form_display.easy_email.user_created_approval_admin.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:d23d53df-b157-492f-9a09-9b3ef80005f2', 'a:1:{i:0;s:42:"core.entity_form_display.user.user.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:dcf1a9d4-210e-444c-9dff-ad7b655b9a4f', 'a:1:{i:0;s:48:"core.entity_form_display.media.svg_image.default";}'),
('config.entity.key_store.entity_form_mode', 'uuid:399b18bb-521d-4f84-a169-cfe2ee579901', 'a:1:{i:0;s:41:"core.entity_form_mode.media.media_library";}'),
('config.entity.key_store.entity_form_mode', 'uuid:c4c8fdcc-6317-4855-95a4-25c55a082356', 'a:1:{i:0;s:35:"core.entity_form_mode.user.register";}'),
('config.entity.key_store.entity_view_display', 'uuid:03a9e175-46f4-496d-b92f-5751c1cd9237', 'a:1:{i:0;s:43:"core.entity_view_display.media.image.medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:087f5831-b6dc-4932-abc2-0709cdf69c07', 'a:1:{i:0;s:49:"core.entity_view_display.media.remote_video.large";}'),
('config.entity.key_store.entity_view_display', 'uuid:0a66bbc2-a551-4428-a457-84de25a4409c', 'a:1:{i:0;s:48:"core.entity_view_display.media.image.16_9_medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:0c4e6507-3867-4a73-b5d8-f993b772c939', 'a:1:{i:0;s:51:"core.entity_view_display.media.remote_video.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:11ad98cf-f594-4a00-9775-978e703a0764', 'a:1:{i:0;s:53:"core.entity_view_display.media.image.1_1_square_large";}'),
('config.entity.key_store.entity_view_display', 'uuid:11e4f3fc-15fc-4191-b5b7-942fe2d8660e', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.4_3_large";}'),
('config.entity.key_store.entity_view_display', 'uuid:13fc9390-4d04-4531-b014-ada2170452d6', 'a:1:{i:0;s:46:"core.entity_view_display.media.svg_image.large";}'),
('config.entity.key_store.entity_view_display', 'uuid:18d76087-b399-4324-8223-835976df5a50', 'a:1:{i:0;s:49:"core.entity_view_display.media.remote_video.small";}'),
('config.entity.key_store.entity_view_display', 'uuid:1e53054a-f2df-4624-b694-0636d91f8029', 'a:1:{i:0;s:39:"core.entity_view_display.node.page.card";}'),
('config.entity.key_store.entity_view_display', 'uuid:27c5031f-83d6-4535-80aa-a3b875f3601a', 'a:1:{i:0;s:42:"core.entity_view_display.media.image.large";}'),
('config.entity.key_store.entity_view_display', 'uuid:2cd5a465-8654-4f05-abc8-217aa7fa2512', 'a:1:{i:0;s:46:"core.entity_view_display.media.svg_image.small";}'),
('config.entity.key_store.entity_view_display', 'uuid:35c02442-2e19-4e2d-9653-70ab112fd127', 'a:1:{i:0;s:50:"core.entity_view_display.media.remote_video.medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:39267521-6abf-44a5-83de-34e8c6cffade', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.16_9_wide";}'),
('config.entity.key_store.entity_view_display', 'uuid:3b304ceb-be61-45c8-824e-36e6e9989fcf', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.4_3_medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:3da80f19-d151-4452-a4b5-60035bf192c9', 'a:1:{i:0;s:53:"core.entity_view_display.media.image.1_1_square_small";}'),
('config.entity.key_store.entity_view_display', 'uuid:41e0b646-a77e-421c-a5b1-1394198e6b0a', 'a:1:{i:0;s:42:"core.entity_view_display.node.page.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:46046d8a-4831-46cf-9725-6a863e84b76d', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.9_16_small";}'),
('config.entity.key_store.entity_view_display', 'uuid:47bce69c-e907-42d0-9cd8-a4bbd4bd3798', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.3_2_small";}'),
('config.entity.key_store.entity_view_display', 'uuid:4832405a-80be-4e93-abf3-0aed409fd9e6', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.2_3_small";}'),
('config.entity.key_store.entity_view_display', 'uuid:4b91501b-aa36-45e2-a1b4-859338e9ad2f', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.3_2_medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:4de2dab5-e199-49db-a6e4-589eeee882f5', 'a:1:{i:0;s:48:"core.entity_view_display.media.svg_image.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:4e977e7a-6227-4064-becd-f90b42210bec', 'a:1:{i:0;s:54:"core.entity_view_display.media.image.1_1_square_medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:4f0e697b-cfee-433d-89b3-58ddaf6c0bbf', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.3_4_large";}'),
('config.entity.key_store.entity_view_display', 'uuid:568b94af-24bd-4b29-b8c5-2fb4e3ad7285', 'a:1:{i:0;s:41:"core.entity_view_display.node.page.teaser";}'),
('config.entity.key_store.entity_view_display', 'uuid:639e7837-e428-462c-b164-946daa3ee2cb', 'a:1:{i:0;s:47:"core.entity_view_display.media.svg_image.medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:6b15d698-1628-4689-9f07-e3f0f7beab11', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.3_4_small";}'),
('config.entity.key_store.entity_view_display', 'uuid:6b904e64-c095-4c43-bb39-6f09991d655a', 'a:1:{i:0;s:71:"core.entity_view_display.easy_email.user_created_approval_admin.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:6c920c76-fb43-4e97-8f7f-6d6cfe33a07b', 'a:1:{i:0;s:53:"core.entity_view_display.media.document.media_library";}'),
('config.entity.key_store.entity_view_display', 'uuid:770028ca-fdfa-489c-9dfe-b2a9fd7f3766', 'a:1:{i:0;s:45:"core.entity_view_display.media.image.4_3_wide";}'),
('config.entity.key_store.entity_view_display', 'uuid:7ba0dbea-9cb9-4821-b01d-306717f5fb49', 'a:1:{i:0;s:47:"core.entity_view_display.media.document.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:84d91d17-5b46-4c9f-a1e1-47e35740bb91', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.16_9_large";}'),
('config.entity.key_store.entity_view_display', 'uuid:8d60150f-7f91-4175-a86d-d240789ef10a', 'a:1:{i:0;s:42:"core.entity_view_display.media.image.small";}'),
('config.entity.key_store.entity_view_display', 'uuid:90cf0237-fc1b-4b0d-a154-1214065d3a93', 'a:1:{i:0;s:41:"core.entity_view_display.media.image.hero";}'),
('config.entity.key_store.entity_view_display', 'uuid:9321b085-24ec-442a-9ec1-e05d4236db28', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.16_9_small";}'),
('config.entity.key_store.entity_view_display', 'uuid:99b72254-56f2-4ce5-a1ee-bdb37aa39725', 'a:1:{i:0;s:50:"core.entity_view_display.media.image.media_library";}'),
('config.entity.key_store.entity_view_display', 'uuid:9d156afe-c553-4748-9ee0-5969dbaa254f', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.3_4_medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:aa8dbbb7-108c-4c49-9b38-25a15347c786', 'a:1:{i:0;s:54:"core.entity_view_display.media.svg_image.media_library";}'),
('config.entity.key_store.entity_view_display', 'uuid:b0d76ae8-fb54-48fd-ad89-6ebcae8b745c', 'a:1:{i:0;s:44:"core.entity_view_display.media.image.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:b7ca00a6-eef5-4863-9e59-de9a26769ccb', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.2_3_medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:b93138c6-d507-421e-a1a9-5e50b9dfd991', 'a:1:{i:0;s:57:"core.entity_view_display.media.remote_video.media_library";}'),
('config.entity.key_store.entity_view_display', 'uuid:cd01e822-86ba-42d3-a1f9-1767a85e8ee1', 'a:1:{i:0;s:45:"core.entity_view_display.media.image.3_2_wide";}'),
('config.entity.key_store.entity_view_display', 'uuid:dad42315-6a62-418c-9d9b-d95080df5382', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.hero_wide";}'),
('config.entity.key_store.entity_view_display', 'uuid:dc168cd0-62a1-4dd3-91fd-2e89baa01962', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.4_3_small";}'),
('config.entity.key_store.entity_view_display', 'uuid:dd74f7bb-33a4-45ed-aa3f-b7f60e915407', 'a:1:{i:0;s:47:"core.entity_view_display.media.image.9_16_large";}'),
('config.entity.key_store.entity_view_display', 'uuid:f36f7dad-ac81-46eb-8b99-dae73f181c96', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.3_2_large";}'),
('config.entity.key_store.entity_view_display', 'uuid:fb250809-5358-4ad4-977c-fe28a379a7c1', 'a:1:{i:0;s:48:"core.entity_view_display.media.image.9_16_medium";}'),
('config.entity.key_store.entity_view_display', 'uuid:fed86388-c871-4dc7-b8a9-35023beea282', 'a:1:{i:0;s:46:"core.entity_view_display.media.image.2_3_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:03d4957b-7b27-48ff-af1a-98f6f93a17a8', 'a:1:{i:0;s:30:"core.entity_view_mode.node.rss";}'),
('config.entity.key_store.entity_view_mode', 'uuid:0475302e-78ca-48ea-8621-35c903ba9337', 'a:1:{i:0;s:37:"core.entity_view_mode.media.3_4_small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:101e752e-4d90-433a-abb1-4d3113b9092b', 'a:1:{i:0;s:37:"core.entity_view_mode.media.16_9_wide";}'),
('config.entity.key_store.entity_view_mode', 'uuid:1b852ba6-706c-4a64-b070-16cd2f6eccb2', 'a:1:{i:0;s:31:"core.entity_view_mode.node.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:2645fe53-59ed-4884-89d5-2c9a9ac1ce4b', 'a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}'),
('config.entity.key_store.entity_view_mode', 'uuid:2f4ebb88-e10e-48a1-a6d6-63bc270f87e2', 'a:1:{i:0;s:36:"core.entity_view_mode.media.4_3_wide";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3473ed3b-7656-4299-8681-03f29c73e5e2', 'a:1:{i:0;s:38:"core.entity_view_mode.media.16_9_small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3ab68144-a644-4385-8d01-d476de711df5', 'a:1:{i:0;s:38:"core.entity_view_mode.media.3_2_medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3c99ef91-183f-45b4-ad01-e785da466715', 'a:1:{i:0;s:38:"core.entity_view_mode.media.9_16_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3ecdbcf6-af04-4654-ba0b-667e0633d359', 'a:1:{i:0;s:41:"core.entity_view_mode.media.media_library";}'),
('config.entity.key_store.entity_view_mode', 'uuid:40354006-4a82-47d8-8eb2-521578171226', 'a:1:{i:0;s:37:"core.entity_view_mode.media.2_3_small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:40cdcc13-19b1-4a8e-b915-d9afb0145f47', 'a:1:{i:0;s:37:"core.entity_view_mode.media.3_4_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:4674ed9d-eef6-40bc-8752-da4cbaed0c59', 'a:1:{i:0;s:39:"core.entity_view_mode.media.9_16_medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:48636168-a588-4468-8682-02da11fe8d33', 'a:1:{i:0;s:37:"core.entity_view_mode.media.hero_wide";}'),
('config.entity.key_store.entity_view_mode', 'uuid:4c1346e5-1dbe-4487-9811-b313247265f6', 'a:1:{i:0;s:31:"core.entity_view_mode.user.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:4ffe3237-a87c-4265-86a1-bc2ea3ed6444', 'a:1:{i:0;s:31:"core.entity_view_mode.node.card";}'),
('config.entity.key_store.entity_view_mode', 'uuid:50900575-79b8-4586-92dc-69819dd793d2', 'a:1:{i:0;s:38:"core.entity_view_mode.media.9_16_small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:545bede6-0966-43c5-be2d-719eb614e432', 'a:1:{i:0;s:33:"core.entity_view_mode.media.small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:5524aaf9-1d39-486e-b1c4-8152cd74cd91', 'a:1:{i:0;s:33:"core.entity_view_mode.media.token";}'),
('config.entity.key_store.entity_view_mode', 'uuid:5d0bfac3-5750-498b-9bbe-7aee584b9acd', 'a:1:{i:0;s:39:"core.entity_view_mode.media.16_9_medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:601f8a3f-91ae-4172-b701-b8603c0bbf5c', 'a:1:{i:0;s:37:"core.entity_view_mode.media.3_2_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:651d69c5-9dd9-49ba-9de8-c43bb190f6fe', 'a:1:{i:0;s:38:"core.entity_view_mode.path_alias.token";}'),
('config.entity.key_store.entity_view_mode', 'uuid:6f1209a0-c68e-4f04-8452-ed3bf215cd86', 'a:1:{i:0;s:32:"core.entity_view_mode.media.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:815f8649-6fdf-4857-9147-4a4f8a9a8b9c', 'a:1:{i:0;s:44:"core.entity_view_mode.media.1_1_square_small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:88306735-e589-4fb3-bf75-a588db72a559', 'a:1:{i:0;s:33:"core.entity_view_mode.media.large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:8ded7639-090a-4159-bdab-e982865efe77', 'a:1:{i:0;s:32:"core.entity_view_mode.media.hero";}'),
('config.entity.key_store.entity_view_mode', 'uuid:8fb1fa84-7658-4482-8c48-d4e7ba480b22', 'a:1:{i:0;s:41:"core.entity_view_mode.taxonomy_term.token";}'),
('config.entity.key_store.entity_view_mode', 'uuid:908db13b-8e26-472d-a5e9-b796351b3b6c', 'a:1:{i:0;s:38:"core.entity_view_mode.media.4_3_medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:90a3fa67-59c1-41fd-9582-f5cdb799aaf2', 'a:1:{i:0;s:38:"core.entity_view_mode.media.2_3_medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:9106a84c-89ea-43a0-9a70-2da9108f3be2', 'a:1:{i:0;s:36:"core.entity_view_mode.media.3_2_wide";}'),
('config.entity.key_store.entity_view_mode', 'uuid:925d3db6-980f-4c9a-b0b7-95f76233d140', 'a:1:{i:0;s:44:"core.entity_view_mode.media.1_1_square_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:926d439b-b351-4faf-819d-7781e870b2b0', 'a:1:{i:0;s:38:"core.entity_view_mode.media.3_4_medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:92d45eb8-a5ac-475a-a3ec-d0ae27256162', 'a:1:{i:0;s:34:"core.entity_view_mode.user.compact";}'),
('config.entity.key_store.entity_view_mode', 'uuid:9ea764eb-7bbd-416a-b5c4-e15b9568989f', 'a:1:{i:0;s:34:"core.entity_view_mode.media.medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:a2029321-6911-4413-b2e9-a4d02a94fa74', 'a:1:{i:0;s:37:"core.entity_view_mode.media.4_3_small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:a7f3b0e5-427d-4e06-a03c-dd8da0b884a2', 'a:1:{i:0;s:32:"core.entity_view_mode.user.token";}'),
('config.entity.key_store.entity_view_mode', 'uuid:ac4b0ea0-10af-4fec-bbe1-eadb1109541a', 'a:1:{i:0;s:33:"core.entity_view_mode.block.token";}'),
('config.entity.key_store.entity_view_mode', 'uuid:beeef20c-570b-4022-9605-68086cdb021e', 'a:1:{i:0;s:37:"core.entity_view_mode.media.2_3_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:cfa6f56a-049b-4b2e-8c90-8008cd87c554', 'a:1:{i:0;s:38:"core.entity_view_mode.media.16_9_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:d1032f1d-4402-4cfb-85f4-0589f690c8b6', 'a:1:{i:0;s:45:"core.entity_view_mode.media.1_1_square_medium";}'),
('config.entity.key_store.entity_view_mode', 'uuid:d1576f26-54d6-4a8d-b186-84f42e4f71ca', 'a:1:{i:0;s:32:"core.entity_view_mode.node.token";}'),
('config.entity.key_store.entity_view_mode', 'uuid:d2e98726-a23c-459f-b6a0-38744e42c7f6', 'a:1:{i:0;s:37:"core.entity_view_mode.media.3_2_small";}'),
('config.entity.key_store.entity_view_mode', 'uuid:d7cc40f1-5df1-4ad3-80e9-c6cb5149df0c', 'a:1:{i:0;s:40:"core.entity_view_mode.taxonomy_term.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:f7b67310-3882-4ef2-8e00-877162a504e9', 'a:1:{i:0;s:37:"core.entity_view_mode.media.4_3_large";}'),
('config.entity.key_store.entity_view_mode', 'uuid:fe36488f-c918-43b8-bcf9-4bcf58bd43a1', 'a:1:{i:0;s:32:"core.entity_view_mode.file.token";}'),
('config.entity.key_store.field_config', 'uuid:11d66af4-148d-44af-9cc9-e84955142bb3', 'a:1:{i:0;s:47:"field.field.media.document.field_media_document";}'),
('config.entity.key_store.field_config', 'uuid:62842215-4e1f-43ce-851d-38a28450a106', 'a:1:{i:0;s:41:"field.field.media.image.field_media_image";}'),
('config.entity.key_store.field_config', 'uuid:85fa0b14-4e51-4c49-8a63-3145eeb8fc37', 'a:1:{i:0;s:42:"field.field.node.page.field_featured_image";}'),
('config.entity.key_store.field_config', 'uuid:905ac2ec-5083-4064-b8df-ff6b3b0b7d8f', 'a:1:{i:0;s:69:"field.field.easy_email.user_created_approval_admin.field_related_user";}'),
('config.entity.key_store.field_config', 'uuid:91a16d6c-560b-46b5-af6c-6d5347451c15', 'a:1:{i:0;s:44:"field.field.node.page.layout_builder__layout";}'),
('config.entity.key_store.field_config', 'uuid:974ee4d6-cdea-413e-b2b4-ad65aeb0f0e2', 'a:1:{i:0;s:32:"field.field.node.page.field_tags";}'),
('config.entity.key_store.field_config', 'uuid:a55fbe01-046e-4377-b325-d69764dcb2a7', 'a:1:{i:0;s:55:"field.field.media.remote_video.field_media_oembed_video";}'),
('config.entity.key_store.field_config', 'uuid:c3cfa3c9-d7c5-4ba9-80a1-94422fc61edb', 'a:1:{i:0;s:39:"field.field.node.page.field_description";}'),
('config.entity.key_store.field_config', 'uuid:c481a546-fa9b-4605-ba29-eb4e635b82b8', 'a:1:{i:0;s:35:"field.field.node.page.field_content";}'),
('config.entity.key_store.field_config', 'uuid:ef8bfa0b-7b62-4c83-a6ac-9b3cd07adaa1', 'a:1:{i:0;s:49:"field.field.media.svg_image.field_media_svg_image";}'),
('config.entity.key_store.field_storage_config', 'uuid:213df2a9-561c-423e-8908-0f0525bc290a', 'a:1:{i:0;s:43:"field.storage.easy_email.field_related_user";}'),
('config.entity.key_store.field_storage_config', 'uuid:269fe3c0-62fa-45a2-912e-94c224e168b9', 'a:1:{i:0;s:32:"field.storage.node.field_content";}'),
('config.entity.key_store.field_storage_config', 'uuid:5a1b7610-0302-4908-baf4-d76f9c0ac750', 'a:1:{i:0;s:44:"field.storage.media.field_media_oembed_video";}'),
('config.entity.key_store.field_storage_config', 'uuid:62c02011-b5b4-49ab-b2aa-0835bda5ecb2', 'a:1:{i:0;s:36:"field.storage.node.field_description";}'),
('config.entity.key_store.field_storage_config', 'uuid:9891d3a9-69da-461c-8656-222ba08751c5', 'a:1:{i:0;s:39:"field.storage.node.field_featured_image";}'),
('config.entity.key_store.field_storage_config', 'uuid:9a3af57a-8347-435b-810e-2fb5c3ecd1ae', 'a:1:{i:0;s:41:"field.storage.node.layout_builder__layout";}'),
('config.entity.key_store.field_storage_config', 'uuid:b22a4ff6-7a92-473c-b10b-cf0786213e7a', 'a:1:{i:0;s:37:"field.storage.media.field_media_image";}'),
('config.entity.key_store.field_storage_config', 'uuid:c59a39d2-cc93-4b65-9ec2-c1873794c383', 'a:1:{i:0;s:40:"field.storage.media.field_media_document";}'),
('config.entity.key_store.field_storage_config', 'uuid:c95a2c96-1f88-489f-b14d-5937662fbb4c', 'a:1:{i:0;s:29:"field.storage.node.field_tags";}'),
('config.entity.key_store.field_storage_config', 'uuid:edb9c6d0-874a-4e22-ac3c-90c25302498f', 'a:1:{i:0;s:41:"field.storage.media.field_media_svg_image";}'),
('config.entity.key_store.filter_format', 'uuid:5bf99b5f-1868-40b7-895b-10238b7a42bd', 'a:1:{i:0;s:24:"filter.format.plain_text";}'),
('config.entity.key_store.filter_format', 'uuid:76d40409-ee18-446a-a7d6-58a8be6c210b', 'a:1:{i:0;s:28:"filter.format.content_format";}'),
('config.entity.key_store.filter_format', 'uuid:90e73e27-d2f8-4de8-8e4d-bebac77bc8c7', 'a:1:{i:0;s:24:"filter.format.easy_email";}'),
('config.entity.key_store.image_style', 'uuid:04d698ba-8243-4732-b350-f7989c6de928', 'a:1:{i:0;s:40:"image.style.3_4_450x600_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:0522a0fd-616a-4455-a30e-42bb507747e2', 'a:1:{i:0;s:40:"image.style.3_2_702x468_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:0d426851-5632-43f9-9512-e88978646dab', 'a:1:{i:0;s:40:"image.style.1_1_300x300_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:172aee40-6b76-4aa0-916f-271f33803fb5', 'a:1:{i:0;s:41:"image.style.16_9_512x288_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:1ebda699-7983-4959-bcb4-9e59c39459d6', 'a:1:{i:0;s:42:"image.style.4_3_1800x1350_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:2af7c52b-b090-4659-ace9-378c3d2756c3', 'a:1:{i:0;s:41:"image.style.16_9_720x405_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:2b085f41-15f3-4136-b828-b4e477aed322', 'a:1:{i:0;s:40:"image.style.3_2_600x400_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:2c977db7-473a-46c1-bf65-1aa9fadb247e', 'a:1:{i:0;s:41:"image.style.16_9_704x396_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:33b85dbb-daa5-43aa-b234-e41a61e7b233', 'a:1:{i:0;s:31:"image.style.uncropped_960w_webp";}'),
('config.entity.key_store.image_style', 'uuid:3f113fbe-fe73-4c47-88fb-6ec74903ea03', 'a:1:{i:0;s:41:"image.style.3_2_1302x868_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:4ae257bb-4243-43d1-a926-12e8675fc91b', 'a:1:{i:0;s:40:"image.style.3_4_225x300_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:4d6141e2-0c61-4678-b673-9b952b10102d', 'a:1:{i:0;s:41:"image.style.9_16_342x608_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:54a37411-4a3f-447a-891b-4ef0f7e91396', 'a:1:{i:0;s:31:"image.style.uncropped_700w_webp";}'),
('config.entity.key_store.image_style', 'uuid:6566ae24-d8ca-46c9-987b-cad9cab3f6d0', 'a:1:{i:0;s:42:"image.style.16_9_1312x738_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:6b0f3350-564c-4ec0-af6d-24cc4ec5d653', 'a:1:{i:0;s:43:"image.style.16_9_1800x1080_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:6c77ba80-bedb-4ca9-a68a-bb45c3f3553b', 'a:1:{i:0;s:31:"image.style.uncropped_720w_webp";}'),
('config.entity.key_store.image_style', 'uuid:6da2d9d7-ba20-4323-a11e-34c3b5dc92a2', 'a:1:{i:0;s:31:"image.style.uncropped_300w_webp";}'),
('config.entity.key_store.image_style', 'uuid:727c3346-4cdd-490d-acdd-2c176635478b', 'a:1:{i:0;s:40:"image.style.3_2_960x640_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:7b5d795b-c9d6-40f1-b8a1-f15fa0801257', 'a:1:{i:0;s:40:"image.style.2_3_500x750_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:7bb0c769-c448-4d48-8e36-3778453d9ee2', 'a:1:{i:0;s:41:"image.style.3_2_1002x668_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:84580ba2-b13d-4c1e-8a38-2902f757ed1d', 'a:1:{i:0;s:40:"image.style.4_3_600x450_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:8d881979-35ba-4d3b-9b9c-561cddfaac4b', 'a:1:{i:0;s:21:"image.style.thumbnail";}'),
('config.entity.key_store.image_style', 'uuid:8e8d8e40-23b6-428f-b012-f38c3f59ff02', 'a:1:{i:0;s:41:"image.style.16_9_304x171_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:8f955cb8-cf8a-4220-8c6f-498c97aeb9f4', 'a:1:{i:0;s:41:"image.style.5_2_1800x720_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:915bf209-9854-4f7d-b835-c0b98b9d2850', 'a:1:{i:0;s:41:"image.style.16_9_960x540_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:91aba3ce-3334-41e5-bd60-21fea3ae486b', 'a:1:{i:0;s:41:"image.style.9_16_504x896_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:9a1b2467-683d-4dc3-9631-291a069adaa1', 'a:1:{i:0;s:41:"image.style.4_3_1300x975_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:9bf9f2f1-6f75-46ab-9574-97144954fa56', 'a:1:{i:0;s:41:"image.style.4_3_1000x750_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:9e21da61-879c-49ac-a3d4-2d7ffe6a6aeb', 'a:1:{i:0;s:42:"image.style.3_2_1800x1200_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:a2eabdea-f67e-4814-96d1-562aedf96896', 'a:1:{i:0;s:17:"image.style.large";}'),
('config.entity.key_store.image_style', 'uuid:a3ba8b34-7292-44d2-9ba7-1809314bff8d', 'a:1:{i:0;s:41:"image.style.5_2_1300x520_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:a5100768-78b7-401f-9388-eba674f28735', 'a:1:{i:0;s:42:"image.style.media_library_square_thumbnail";}'),
('config.entity.key_store.image_style', 'uuid:a940fdd2-b4e9-49aa-96aa-6e64724d386b', 'a:1:{i:0;s:40:"image.style.3_2_504x336_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:ab0c9f1d-e7ee-49e5-8292-6678c86cb9f9', 'a:1:{i:0;s:40:"image.style.4_3_960x720_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:ae312742-69bd-4fd2-85a2-912928213bc0', 'a:1:{i:0;s:31:"image.style.uncropped_600w_webp";}'),
('config.entity.key_store.image_style', 'uuid:aea130eb-aa8a-414a-9985-6c2817da853b', 'a:1:{i:0;s:40:"image.style.1_1_960x960_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:b62ed692-b640-4161-a03a-016130ae947c', 'a:1:{i:0;s:40:"image.style.3_2_720x480_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:b86ac682-6fb0-41cb-94e1-2e7e32996e6f', 'a:1:{i:0;s:40:"image.style.1_1_600x600_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:b9c342dd-ba0f-405a-9b63-e9b7275c1ac5', 'a:1:{i:0;s:40:"image.style.2_3_400x600_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:bc0b9757-c6aa-4747-8f3a-774af10b6fc5', 'a:1:{i:0;s:40:"image.style.1_1_500x500_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:bc570d06-f384-4963-af89-6cef9e5ae91e', 'a:1:{i:0;s:42:"image.style.16_9_1008x567_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:bd9a8299-d082-4324-8e14-77cbd6ba2351', 'a:1:{i:0;s:41:"image.style.9_16_540x960_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:be942729-8171-486f-85e0-8b1ffb88e338', 'a:1:{i:0;s:40:"image.style.2_3_640x960_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:c0ea65fc-5d37-4878-8b6c-b7a44b3ab1b9', 'a:1:{i:0;s:35:"image.style.linkit_result_thumbnail";}'),
('config.entity.key_store.image_style', 'uuid:c27b314e-5bdc-4599-bbce-2f8cfeec1ac9', 'a:1:{i:0;s:40:"image.style.2_3_200x300_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:c66c0a28-af3b-452f-84f7-b0b6aa051bef', 'a:1:{i:0;s:40:"image.style.3_2_300x200_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:c9d36e47-8a9a-4e14-a7e6-a7f383a96e43', 'a:1:{i:0;s:25:"image.style.media_library";}'),
('config.entity.key_store.image_style', 'uuid:cd5c966c-34c0-4b42-b4d8-ee3e216dab59', 'a:1:{i:0;s:31:"image.style.uncropped_500w_webp";}'),
('config.entity.key_store.image_style', 'uuid:d3376c46-7afe-43a3-969f-0de30942e7fc', 'a:1:{i:0;s:40:"image.style.3_4_708x944_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:d7e407a0-c39a-4fb7-9288-8395b03efab9', 'a:1:{i:0;s:41:"image.style.16_9_608x342_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:d82f5346-25ca-4521-9109-478859e79703', 'a:1:{i:0;s:40:"image.style.4_3_700x525_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:e31fc775-1d8c-40ee-b8ad-edd15defd81a', 'a:1:{i:0;s:40:"image.style.1_1_720x720_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:e32d8f00-cc14-4b1e-8110-d9e9670f8eb9', 'a:1:{i:0;s:18:"image.style.medium";}'),
('config.entity.key_store.image_style', 'uuid:e334a963-62e4-4617-8fbb-c0691cb94feb', 'a:1:{i:0;s:40:"image.style.4_3_300x225_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:ee1ebff7-3ff5-49a6-a93c-6be051455631', 'a:1:{i:0;s:40:"image.style.3_4_720x960_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:f04de5d9-d860-4eeb-870c-892e233f108a', 'a:1:{i:0;s:41:"image.style.9_16_171x304_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:f56f1b6d-49e4-477b-8dac-9bc3dda3dcff', 'a:1:{i:0;s:40:"image.style.4_3_720x540_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:fd3a4333-3451-4cf7-82f8-0ef1b2e61f34', 'a:1:{i:0;s:40:"image.style.4_3_500x375_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:fe141af9-6256-4ec4-8fc7-91c112ca0e73', 'a:1:{i:0;s:41:"image.style.5_2_1000x400_focal_point_webp";}'),
('config.entity.key_store.image_style', 'uuid:ffffa912-7f63-44de-9130-ceb5d7d15aff', 'a:1:{i:0;s:40:"image.style.3_4_504x672_focal_point_webp";}'),
('config.entity.key_store.klaro_app', 'uuid:0a312a74-6c32-4214-b5fc-83ea0f6ec703', 'a:1:{i:0;s:23:"klaro.klaro_app.bluesky";}'),
('config.entity.key_store.klaro_app', 'uuid:0ed83ff9-694f-4b1d-9d92-d354613e5452', 'a:1:{i:0;s:21:"klaro.klaro_app.vimeo";}'),
('config.entity.key_store.klaro_app', 'uuid:10c4e3c0-390f-4a86-8a95-5fe660adad95', 'a:1:{i:0;s:30:"klaro.klaro_app.matomo_cookies";}'),
('config.entity.key_store.klaro_app', 'uuid:1a03466b-e194-431a-b7c3-2804ccd277aa', 'a:1:{i:0;s:27:"klaro.klaro_app.google_maps";}'),
('config.entity.key_store.klaro_app', 'uuid:211e59df-c797-4057-aee0-c51483de7e75', 'a:1:{i:0;s:22:"klaro.klaro_app.tiktok";}'),
('config.entity.key_store.klaro_app', 'uuid:214ae4e6-d98d-49ac-86cb-f319feaae828', 'a:1:{i:0;s:32:"klaro.klaro_app.google_recaptcha";}'),
('config.entity.key_store.klaro_app', 'uuid:214f8ff1-72f4-4e42-9fe0-3ce208d530d0', 'a:1:{i:0;s:18:"klaro.klaro_app.ga";}'),
('config.entity.key_store.klaro_app', 'uuid:2411f68b-6add-4272-95ad-dadee4456752', 'a:1:{i:0;s:21:"klaro.klaro_app.umami";}'),
('config.entity.key_store.klaro_app', 'uuid:2f07791e-297e-463a-a3a6-ad90ba14ce3e', 'a:1:{i:0;s:24:"klaro.klaro_app.linkedin";}'),
('config.entity.key_store.klaro_app', 'uuid:3b1d4995-ae1a-41ca-98fa-ed81a4d03595', 'a:1:{i:0;s:24:"klaro.klaro_app.facebook";}'),
('config.entity.key_store.klaro_app', 'uuid:45685c9b-3e44-4400-8e61-f103c6de582d', 'a:1:{i:0;s:19:"klaro.klaro_app.gtm";}'),
('config.entity.key_store.klaro_app', 'uuid:5706e912-b91e-4a38-a8ac-1c3cbc4296ff', 'a:1:{i:0;s:23:"klaro.klaro_app.leaflet";}'),
('config.entity.key_store.klaro_app', 'uuid:59ed23e2-2f03-49ac-97c3-2297284c875b', 'a:1:{i:0;s:17:"klaro.klaro_app.x";}'),
('config.entity.key_store.klaro_app', 'uuid:630a9546-67da-478b-9b5d-59990a1dbe77', 'a:1:{i:0;s:23:"klaro.klaro_app.youtube";}'),
('config.entity.key_store.klaro_app', 'uuid:67c8cd3c-b86d-4d65-9d18-ead6ce461416', 'a:1:{i:0;s:24:"klaro.klaro_app.mastodon";}'),
('config.entity.key_store.klaro_app', 'uuid:7181f93b-7697-4a90-a3e2-2a8d221097a3', 'a:1:{i:0;s:21:"klaro.klaro_app.klaro";}'),
('config.entity.key_store.klaro_app', 'uuid:7aabec2d-aa1e-4bac-a11d-8bb95f7c8f08', 'a:1:{i:0;s:23:"klaro.klaro_app.threads";}'),
('config.entity.key_store.klaro_app', 'uuid:8608ebfa-4e51-42d1-9749-e0df1b3b23ea', 'a:1:{i:0;s:31:"klaro.klaro_app.mastodon_module";}'),
('config.entity.key_store.klaro_app', 'uuid:88bd2d3b-2b4f-4d5f-b691-d296038c251a', 'a:1:{i:0;s:25:"klaro.klaro_app.instagram";}'),
('config.entity.key_store.klaro_app', 'uuid:a6204944-8f6a-443d-b4e9-f7e8843eb402', 'a:1:{i:0;s:22:"klaro.klaro_app.matomo";}'),
('config.entity.key_store.klaro_app', 'uuid:b4c2b2ad-461a-4a7f-a12d-7853470d1a5d', 'a:1:{i:0;s:35:"klaro.klaro_app.simple_popup_blocks";}'),
('config.entity.key_store.klaro_app', 'uuid:ddd26eea-2e32-457a-9cd2-22fb6847240c', 'a:1:{i:0;s:24:"klaro.klaro_app.deepchat";}'),
('config.entity.key_store.klaro_app', 'uuid:ea0ba5b3-a610-4609-8b53-7552bb823b8d', 'a:1:{i:0;s:19:"klaro.klaro_app.cms";}'),
('config.entity.key_store.klaro_app', 'uuid:f9fffe2c-dfb1-4ba9-ae81-323311925f13', 'a:1:{i:0;s:38:"klaro.klaro_app.ai_alt_text_generation";}'),
('config.entity.key_store.klaro_purpose', 'uuid:018b82f3-0026-4c8f-ada9-1e826ea42052', 'a:1:{i:0;s:36:"klaro.klaro_purpose.external_content";}'),
('config.entity.key_store.klaro_purpose', 'uuid:7b1184a4-75ae-4b32-9362-e4e85f80543c', 'a:1:{i:0;s:31:"klaro.klaro_purpose.advertising";}'),
('config.entity.key_store.klaro_purpose', 'uuid:8ad470fd-06a8-47c2-9d82-ba0ea32eb820', 'a:1:{i:0;s:28:"klaro.klaro_purpose.livechat";}'),
('config.entity.key_store.klaro_purpose', 'uuid:bc1630d8-cedb-4555-ad90-64ae983d651e', 'a:1:{i:0;s:28:"klaro.klaro_purpose.security";}'),
('config.entity.key_store.klaro_purpose', 'uuid:e2328988-a21d-4363-82a9-467bdb1e54f6', 'a:1:{i:0;s:29:"klaro.klaro_purpose.analytics";}'),
('config.entity.key_store.klaro_purpose', 'uuid:e5352888-4282-4767-956d-34d17251a6d3', 'a:1:{i:0;s:23:"klaro.klaro_purpose.cms";}'),
('config.entity.key_store.klaro_purpose', 'uuid:e6769083-4f28-4b89-b904-a1f49ce04c5c', 'a:1:{i:0;s:27:"klaro.klaro_purpose.styling";}'),
('config.entity.key_store.linkit_profile', 'uuid:d44d7aad-b7b5-4996-8caf-8f3d51977c8a', 'a:1:{i:0;s:29:"linkit.linkit_profile.default";}'),
('config.entity.key_store.media_type', 'uuid:123997d5-44b3-41ef-a94f-0f92ffe3933a', 'a:1:{i:0;s:16:"media.type.image";}'),
('config.entity.key_store.media_type', 'uuid:7525b5bf-8e0c-4629-b2af-54543f52009e', 'a:1:{i:0;s:19:"media.type.document";}'),
('config.entity.key_store.media_type', 'uuid:b6c6b341-c27d-4248-aabb-0a80b0e23696', 'a:1:{i:0;s:23:"media.type.remote_video";}'),
('config.entity.key_store.media_type', 'uuid:d9e54f30-b1f8-4d1d-9cbd-20d0312c40c1', 'a:1:{i:0;s:20:"media.type.svg_image";}'),
('config.entity.key_store.menu', 'uuid:07c3a279-eb38-4819-a40e-bf59853f78e8', 'a:1:{i:0;s:19:"system.menu.account";}'),
('config.entity.key_store.menu', 'uuid:24c60a78-527e-4c69-b6ab-261d011701f0', 'a:1:{i:0;s:16:"system.menu.main";}'),
('config.entity.key_store.menu', 'uuid:29e265c2-6766-4ca9-8a68-6d60ca521b2a', 'a:1:{i:0;s:19:"system.menu.content";}'),
('config.entity.key_store.menu', 'uuid:38399c29-3d39-4613-8b78-6d96e0ef8fa0', 'a:1:{i:0;s:33:"system.menu.navigation-user-links";}'),
('config.entity.key_store.menu', 'uuid:3becd82a-c553-4a37-95a1-081612975630', 'a:1:{i:0;s:17:"system.menu.admin";}'),
('config.entity.key_store.menu', 'uuid:ab3a6046-5a4a-4489-90f7-3dc5385a2712', 'a:1:{i:0;s:18:"system.menu.footer";}'),
('config.entity.key_store.menu', 'uuid:d57be252-aa85-4793-acc1-8e46f80feb09', 'a:1:{i:0;s:19:"system.menu.welcome";}'),
('config.entity.key_store.menu', 'uuid:f8bf3b4f-7b00-4f06-b9df-32887f493b01', 'a:1:{i:0;s:17:"system.menu.tools";}'),
('config.entity.key_store.node_type', 'uuid:4ccbbfa0-6ff8-4772-a111-fba705e50e86', 'a:1:{i:0;s:14:"node.type.page";}'),
('config.entity.key_store.pathauto_pattern', 'status:1', 'a:2:{i:0;s:29:"pathauto.pattern.page_content";i:1;s:26:"pathauto.pattern.menu_path";}'),
('config.entity.key_store.pathauto_pattern', 'type:canonical_entities:node', 'a:2:{i:0;s:29:"pathauto.pattern.page_content";i:1;s:26:"pathauto.pattern.menu_path";}'),
('config.entity.key_store.pathauto_pattern', 'uuid:1d502da6-4c3e-4f26-b007-ea2c28b852b0', 'a:1:{i:0;s:26:"pathauto.pattern.menu_path";}'),
('config.entity.key_store.pathauto_pattern', 'uuid:d9471a27-10c9-4109-81aa-1dd65924b64a', 'a:1:{i:0;s:29:"pathauto.pattern.page_content";}'),
('config.entity.key_store.responsive_image_style', 'uuid:14fdc63d-c1ee-4c6c-93b4-655155aa5aef', 'a:1:{i:0;s:35:"responsive_image.styles.9_16_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:20e11470-8d4b-4acf-a311-a69bb76f3b0f', 'a:1:{i:0;s:33:"responsive_image.styles.4_3_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:31263423-8d1e-4379-a082-e6d1dd7d9f40', 'a:1:{i:0;s:34:"responsive_image.styles.9_16_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:3444ac23-e49e-4a75-84c3-dcc304c73117', 'a:1:{i:0;s:33:"responsive_image.styles.3_2_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:395ffcb7-76b5-47fd-90f2-073f736ff6e5', 'a:1:{i:0;s:33:"responsive_image.styles.2_3_small";}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('config.entity.key_store.responsive_image_style', 'uuid:4b7fb23d-4501-46b7-8e40-fbf42636fe86', 'a:1:{i:0;s:35:"responsive_image.styles.16_9_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:4dc11ab8-886f-4433-90a9-1a9128f210a0', 'a:1:{i:0;s:33:"responsive_image.styles.16_9_wide";}'),
('config.entity.key_store.responsive_image_style', 'uuid:5dea8bf0-8205-451b-a705-5ce841e181e8', 'a:1:{i:0;s:34:"responsive_image.styles.2_3_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:6276f73b-df9d-4c52-a5da-3b7ef1b7d781', 'a:1:{i:0;s:34:"responsive_image.styles.3_4_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:643e7a2a-8181-470a-9e45-2e7a6c821151', 'a:1:{i:0;s:40:"responsive_image.styles.1_1_square_small";}'),
('config.entity.key_store.responsive_image_style', 'uuid:72de36b6-7368-48df-aea7-0e5bb1fc9582', 'a:1:{i:0;s:34:"responsive_image.styles.9_16_small";}'),
('config.entity.key_store.responsive_image_style', 'uuid:7332deda-74f7-4e70-a831-f5d2021c97a4', 'a:1:{i:0;s:34:"responsive_image.styles.hero_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:7e884429-bf7a-429d-b43d-3bb8269bc3dd', 'a:1:{i:0;s:34:"responsive_image.styles.3_2_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:8912de3d-7b8a-417e-8748-32af9a4e2dfe', 'a:1:{i:0;s:33:"responsive_image.styles.4_3_small";}'),
('config.entity.key_store.responsive_image_style', 'uuid:96f2ec63-8902-44d8-9bfb-7e26288fb323', 'a:1:{i:0;s:33:"responsive_image.styles.2_3_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:98979c73-7993-4287-8412-ebe5183ca7f3', 'a:1:{i:0;s:34:"responsive_image.styles.4_3_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:9fffbedc-a2d1-43b7-926b-9927d9ce937e', 'a:1:{i:0;s:32:"responsive_image.styles.4_3_wide";}'),
('config.entity.key_store.responsive_image_style', 'uuid:b46cc7a2-fe99-4e0e-8ab6-f0bb7784ea04', 'a:1:{i:0;s:33:"responsive_image.styles.hero_wide";}'),
('config.entity.key_store.responsive_image_style', 'uuid:b4e9460d-bab8-488d-992d-ec46171f215b', 'a:1:{i:0;s:39:"responsive_image.styles.uncropped_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:c2bed165-26a6-4b92-8f0d-2117b098012b', 'a:1:{i:0;s:40:"responsive_image.styles.uncropped_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:ccbb5528-a1c9-45ad-a6a8-454725dabf5a', 'a:1:{i:0;s:33:"responsive_image.styles.3_2_small";}'),
('config.entity.key_store.responsive_image_style', 'uuid:cd7eeb37-fcd9-4282-8ebb-97ea20d23331', 'a:1:{i:0;s:34:"responsive_image.styles.1_1_medium";}'),
('config.entity.key_store.responsive_image_style', 'uuid:d30e4cd9-75a0-403c-9dc0-d8d70e420ddc', 'a:1:{i:0;s:33:"responsive_image.styles.3_4_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:d567802e-bc19-4bf8-81b5-67d17b88037e', 'a:1:{i:0;s:33:"responsive_image.styles.3_4_small";}'),
('config.entity.key_store.responsive_image_style', 'uuid:e1e36895-4659-4a02-bc11-7f559a691759', 'a:1:{i:0;s:32:"responsive_image.styles.3_2_wide";}'),
('config.entity.key_store.responsive_image_style', 'uuid:e4408dc3-887f-49c0-bb4b-e12a6bd01dfe', 'a:1:{i:0;s:33:"responsive_image.styles.1_1_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:ead271d6-e248-4827-a7b6-137b9a0adb93', 'a:1:{i:0;s:34:"responsive_image.styles.16_9_small";}'),
('config.entity.key_store.responsive_image_style', 'uuid:ecf971e2-9d2f-4910-b212-86fb221c4008', 'a:1:{i:0;s:34:"responsive_image.styles.16_9_large";}'),
('config.entity.key_store.responsive_image_style', 'uuid:ff3e3a18-68bd-4bbc-ae28-fd73fd49d19d', 'a:1:{i:0;s:39:"responsive_image.styles.uncropped_small";}'),
('config.entity.key_store.symfony_mailer_lite_transport', 'uuid:206707a1-f44e-4ed6-bc7a-b1f424e28f18', 'a:1:{i:0;s:56:"symfony_mailer_lite.symfony_mailer_lite_transport.native";}'),
('config.entity.key_store.taxonomy_vocabulary', 'uuid:ebf6ab79-33f3-4d60-b941-1b072555af9c', 'a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}'),
('config.entity.key_store.user_role', 'uuid:4e092540-8031-418f-9fbb-531571ea91c2', 'a:1:{i:0;s:23:"user.role.authenticated";}'),
('config.entity.key_store.user_role', 'uuid:5c6816cd-f7d0-4568-b907-65f5c909e4f2', 'a:1:{i:0;s:19:"user.role.anonymous";}'),
('config.entity.key_store.user_role', 'uuid:89e482ae-9c28-4896-ae6f-b9ab940a41f0', 'a:1:{i:0;s:23:"user.role.administrator";}'),
('config.entity.key_store.user_role', 'uuid:d3aec9ef-caad-4851-9ec9-68a225ac999e', 'a:1:{i:0;s:24:"user.role.content_editor";}'),
('config.entity.key_store.view', 'uuid:0807de34-d91b-4305-b540-a1c8394be10c', 'a:1:{i:0;s:17:"views.view.latest";}'),
('config.entity.key_store.view', 'uuid:0bf8830b-ef9e-4ac8-90ce-35f38203b414', 'a:1:{i:0;s:24:"views.view.media_library";}'),
('config.entity.key_store.view', 'uuid:19517495-9003-4f36-a52d-6dd0e4fd4f66', 'a:1:{i:0;s:25:"views.view.recent_content";}'),
('config.entity.key_store.view', 'uuid:2558416a-f6e3-480d-8d54-c7a1d11efc4d', 'a:1:{i:0;s:29:"views.view.publishing_content";}'),
('config.entity.key_store.view', 'uuid:2c77f4cb-4e87-4dfe-b501-1783817b18a4', 'a:1:{i:0;s:28:"views.view.moderated_content";}'),
('config.entity.key_store.view', 'uuid:5708022f-b1c9-42bc-8ada-c54fce4856a1', 'a:1:{i:0;s:38:"views.view.scheduler_scheduled_content";}'),
('config.entity.key_store.view', 'uuid:5a5d9c36-0d0f-481c-826e-5d21b8aa2de9', 'a:1:{i:0;s:19:"views.view.redirect";}'),
('config.entity.key_store.view', 'uuid:6e590cae-1e94-486a-88b0-bcfb7002b632', 'a:1:{i:0;s:18:"views.view.content";}'),
('config.entity.key_store.view', 'uuid:70516bc4-29af-4644-88d3-bd72bdf18898', 'a:1:{i:0;s:23:"views.view.redirect_404";}'),
('config.entity.key_store.view', 'uuid:83351b64-f783-4406-81e5-cf40ffa949c1', 'a:1:{i:0;s:24:"views.view.taxonomy_term";}'),
('config.entity.key_store.view', 'uuid:84b66254-f821-4c96-aae4-a40717e30fda', 'a:1:{i:0;s:36:"views.view.scheduler_scheduled_media";}'),
('config.entity.key_store.view', 'uuid:aafad72b-0a2e-477e-a060-fda1b01b4706', 'a:1:{i:0;s:28:"views.view.user_admin_people";}'),
('config.entity.key_store.view', 'uuid:c4e683af-7cf0-4f08-a956-c52a29520e30', 'a:1:{i:0;s:16:"views.view.files";}'),
('config.entity.key_store.view', 'uuid:de668207-0911-47d7-a873-921e5f38bbc8', 'a:1:{i:0;s:19:"views.view.watchdog";}'),
('config.entity.key_store.view', 'uuid:e794d1ba-f6e7-4efc-9b4b-94d53ce1e001', 'a:1:{i:0;s:16:"views.view.media";}'),
('config.entity.key_store.view', 'uuid:fb015335-e445-4795-97aa-2c34cdda88c6', 'a:1:{i:0;s:44:"views.view.scheduler_scheduled_taxonomy_term";}'),
('config.entity.key_store.workflow', 'uuid:dbe98800-283c-4e24-8514-501d5bcde77e', 'a:1:{i:0;s:34:"workflows.workflow.basic_editorial";}'),
('entity.definitions.bundle_field_map', 'easy_email', 'a:1:{s:18:"field_related_user";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:27:"user_created_approval_admin";s:27:"user_created_approval_admin";}}}'),
('entity.definitions.bundle_field_map', 'media', 'a:4:{s:20:"field_media_document";a:2:{s:4:"type";s:4:"file";s:7:"bundles";a:1:{s:8:"document";s:8:"document";}}s:17:"field_media_image";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:5:"image";s:5:"image";}}s:21:"field_media_svg_image";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:9:"svg_image";s:9:"svg_image";}}s:24:"field_media_oembed_video";a:2:{s:4:"type";s:6:"string";s:7:"bundles";a:1:{s:12:"remote_video";s:12:"remote_video";}}}'),
('entity.definitions.bundle_field_map', 'node', 'a:5:{s:17:"field_description";a:2:{s:4:"type";s:11:"string_long";s:7:"bundles";a:1:{s:4:"page";s:4:"page";}}s:20:"field_featured_image";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:4:"page";s:4:"page";}}s:22:"layout_builder__layout";a:2:{s:4:"type";s:14:"layout_section";s:7:"bundles";a:1:{s:4:"page";s:4:"page";}}s:10:"field_tags";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:4:"page";s:4:"page";}}s:13:"field_content";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:4:"page";s:4:"page";}}}'),
('entity.definitions.installed', 'action.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:6:"action";s:8:"\0*\0class";s:27:"Drupal\\system\\Entity\\Action";s:11:"\0*\0provider";s:6:"system";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\system\\Entity\\Action";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer actions";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:13:"@count action";s:6:"plural";s:14:"@count actions";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:action_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"type";i:3;s:6:"plugin";i:4;s:13:"configuration";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'base_field_override.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"base_field_override";s:8:"\0*\0class";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:11:"\0*\0handlers";a:2:{s:7:"storage";s:42:"Drupal\\Core\\Field\\BaseFieldOverrideStorage";s:6:"access";s:55:"Drupal\\Core\\Field\\BaseFieldOverrideAccessControlHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Base field override";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:base_field_override_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:6:"bundle";i:3;s:10:"field_name";i:4;s:10:"field_type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:19:"base_field_override";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'block.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:5:"block";s:8:"\0*\0class";s:25:"Drupal\\block\\Entity\\Block";s:11:"\0*\0provider";s:5:"block";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:25:"Drupal\\block\\Entity\\Block";s:11:"\0*\0handlers";a:5:{s:6:"access";s:38:"Drupal\\block\\BlockAccessControlHandler";s:12:"view_builder";s:29:"Drupal\\block\\BlockViewBuilder";s:12:"list_builder";s:29:"Drupal\\block\\BlockListBuilder";s:4:"form";a:2:{s:7:"default";s:22:"Drupal\\block\\BlockForm";s:6:"delete";s:33:"Drupal\\block\\Form\\BlockDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer blocks";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:44:"/admin/structure/block/manage/{block}/delete";s:9:"edit-form";s:37:"/admin/structure/block/manage/{block}";s:6:"enable";s:44:"/admin/structure/block/manage/{block}/enable";s:7:"disable";s:45:"/admin/structure/block/manage/{block}/disable";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:12:"@count block";s:6:"plural";s:13:"@count blocks";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:17:"config:block_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:2:{i:0;s:5:"theme";i:1;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"theme";i:2;s:6:"region";i:3;s:6:"weight";i:4;s:8:"provider";i:5;s:6:"plugin";i:6;s:8:"settings";i:7;s:10:"visibility";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'captcha_point.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:13:"captcha_point";s:8:"\0*\0class";s:34:"Drupal\\captcha\\Entity\\CaptchaPoint";s:11:"\0*\0provider";s:7:"captcha";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:6:"formId";s:5:"label";s:5:"label";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:34:"Drupal\\captcha\\Entity\\CaptchaPoint";s:11:"\0*\0handlers";a:4:{s:12:"list_builder";s:56:"Drupal\\captcha\\Entity\\Controller\\CaptchaPointListBuilder";s:4:"form";a:5:{s:3:"add";s:36:"Drupal\\captcha\\Form\\CaptchaPointForm";s:4:"edit";s:36:"Drupal\\captcha\\Form\\CaptchaPointForm";s:7:"disable";s:43:"Drupal\\captcha\\Form\\CaptchaPointDisableForm";s:6:"enable";s:42:"Drupal\\captcha\\Form\\CaptchaPointEnableForm";s:6:"delete";s:42:"Drupal\\captcha\\Form\\CaptchaPointDeleteForm";}s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:27:"administer CAPTCHA settings";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:9:"edit-form";s:59:"/admin/config/people/captcha/captcha-points/{captcha_point}";s:7:"disable";s:67:"/admin/config/people/captcha/captcha-points/{captcha_point}/disable";s:6:"enable";s:66:"/admin/config/people/captcha/captcha-points/{captcha_point}/enable";s:11:"delete-form";s:66:"/admin/config/people/captcha/captcha-points/{captcha_point}/delete";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Captcha Point";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:8:"rendered";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:13:"captcha_point";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:6:"formId";i:1;s:11:"captchaType";i:2;s:5:"label";i:3;s:4:"uuid";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'content_moderation_state.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:24:"content_moderation_state";s:8:"\0*\0class";s:55:"Drupal\\content_moderation\\Entity\\ContentModerationState";s:11:"\0*\0provider";s:18:"content_moderation";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:4:"uuid";s:4:"uuid";s:3:"uid";s:3:"uid";s:5:"owner";s:3:"uid";s:8:"langcode";s:8:"langcode";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:55:"Drupal\\content_moderation\\Entity\\ContentModerationState";s:11:"\0*\0handlers";a:6:{s:14:"storage_schema";s:61:"Drupal\\content_moderation\\ContentModerationStateStorageSchema";s:10:"views_data";s:28:"Drupal\\views\\EntityViewsData";s:6:"access";s:68:"Drupal\\content_moderation\\ContentModerationStateAccessControlHandler";s:7:"storage";s:46:"Drupal\\Core\\Entity\\Sql\\SqlContentEntityStorage";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:4:"form";a:1:{s:14:"layout_builder";s:46:"Drupal\\layout_builder\\Form\\OverridesEntityForm";}}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:24:"content_moderation_state";s:22:"\0*\0revision_data_table";s:39:"content_moderation_state_field_revision";s:17:"\0*\0revision_table";s:33:"content_moderation_state_revision";s:13:"\0*\0data_table";s:35:"content_moderation_state_field_data";s:11:"\0*\0internal";b:1;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"Content moderation state";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"content moderation state";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"content moderation states";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:31:"@count content moderation state";s:6:"plural";s:32:"@count content moderation states";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:29:"content_moderation_state_list";}s:14:"\0*\0constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:24:"content_moderation_state";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'content_moderation_state.field_storage_definitions', 'a:13:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:2:"id";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:36;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:69;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:103;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"User";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:78:"Drupal\\content_moderation\\Entity\\ContentModerationState::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The username of the entity creator.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:139;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"workflow";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Workflow";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:40:"The workflow the moderation state is in.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:8:"workflow";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:8:"workflow";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:178;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"moderation_state";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Moderation state";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The moderation state of the referenced content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:16:"moderation_state";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:216;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:22:"content_entity_type_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"Content entity type ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:63:"The ID of the content entity type this moderation state is for.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:22:"content_entity_type_id";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:253;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:17:"content_entity_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Content entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"The ID of the content entity this moderation state is for.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:17:"content_entity_id";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:289;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:26:"content_entity_revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"Content entity revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:67:"The revision ID of the content entity this moderation state is for.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:26:"content_entity_revision_id";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:328;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:367;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:410;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:18:"content_moderation";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:24:"content_moderation_state";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:452;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'crop.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:4:"crop";s:8:"\0*\0class";s:23:"Drupal\\crop\\Entity\\Crop";s:11:"\0*\0provider";s:4:"crop";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:0;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:3:"cid";s:6:"bundle";s:4:"type";s:8:"revision";s:3:"vid";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\crop\\Entity\\Crop";s:11:"\0*\0handlers";a:5:{s:7:"storage";s:23:"Drupal\\crop\\CropStorage";s:14:"storage_schema";s:29:"Drupal\\crop\\CropStorageSchema";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:36:"Drupal\\Core\\Entity\\ContentEntityForm";s:6:"delete";s:47:"Drupal\\Core\\Entity\\ContentEntityConfirmFormBase";s:4:"edit";s:36:"Drupal\\Core\\Entity\\ContentEntityForm";s:14:"layout_builder";s:46:"Drupal\\layout_builder\\Form\\OverridesEntityForm";}}s:19:"\0*\0admin_permission";s:15:"administer crop";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";s:9:"crop_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Crop type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:4:"crop";s:22:"\0*\0revision_data_table";s:19:"crop_field_revision";s:17:"\0*\0revision_table";s:13:"crop_revision";s:13:"\0*\0data_table";s:15:"crop_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Crop";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"crop_list";}s:14:"\0*\0constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:2:{s:9:"fieldable";b:1;s:10:"token_type";s:4:"crop";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:18:"revision_timestamp";s:18:"revision_timestamp";s:12:"revision_uid";s:12:"revision_uid";s:12:"revision_log";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'crop.field_storage_definitions', 'a:18:{s:3:"cid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Crop ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The crop ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:3:"cid";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The crop UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"The crop revision ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The crop type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:4:"type";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"crop_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The node language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:152;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:9:"entity_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"ID of entity crop belongs to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:9:"entity_id";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:184;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"entity_type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Entity type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The type of entity crop belongs to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:11:"entity_type";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:223;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uri";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"URI";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"The URI of the image crop belongs to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:3:"uri";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:14:"field_item:uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:259;}s:7:"\0*\0type";s:3:"uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"height";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Height";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"The crop height.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:6:"height";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:294;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"width";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Width";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"The crop width.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:5:"width";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:334;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:1:"x";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"X coordinate";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"The crop''s X coordinate.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:1:"x";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:374;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:1:"y";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Y coordinate";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"The crop''s Y coordinate.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:1:"y";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:414;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:18:"revision_timestamp";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Revision timestamp";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:18:"revision_timestamp";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:454;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Revision author ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:12:"revision_uid";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:484;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_log";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Revision Log";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The log entry explaining the changes in this revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:521;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"crop";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:554;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:597;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"crop";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:4:"crop";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:639;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'crop_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:9:"crop_type";s:8:"\0*\0class";s:27:"Drupal\\crop\\Entity\\CropType";s:11:"\0*\0provider";s:4:"crop";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\crop\\Entity\\CropType";s:11:"\0*\0handlers";a:4:{s:4:"form";a:3:{s:3:"add";s:29:"Drupal\\crop\\Form\\CropTypeForm";s:4:"edit";s:29:"Drupal\\crop\\Form\\CropTypeForm";s:6:"delete";s:35:"Drupal\\crop\\Form\\CropTypeDeleteForm";}s:12:"list_builder";s:31:"Drupal\\crop\\CropTypeListBuilder";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:21:"administer crop types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:2:{s:9:"edit-form";s:43:"/admin/config/media/crop/manage/{crop_type}";s:11:"delete-form";s:50:"/admin/config/media/crop/manage/{crop_type}/delete";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:4:"crop";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Crop type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:crop_type_list";}s:14:"\0*\0constraints";a:2:{s:29:"CropTypeMachineNameValidation";a:0:{}s:29:"CropTypeAspectRatioValidation";a:0:{}}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:9:"crop_type";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:12:"aspect_ratio";i:4;s:16:"soft_limit_width";i:5;s:17:"soft_limit_height";i:6;s:16:"hard_limit_width";i:7;s:17:"hard_limit_height";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'dashboard.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:9:"dashboard";s:8:"\0*\0class";s:33:"Drupal\\dashboard\\Entity\\Dashboard";s:11:"\0*\0provider";s:9:"dashboard";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:6:"weight";s:6:"weight";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:33:"Drupal\\dashboard\\Entity\\Dashboard";s:11:"\0*\0handlers";a:4:{s:6:"access";s:46:"Drupal\\dashboard\\DashboardAccessControlHandler";s:7:"storage";s:40:"Drupal\\dashboard\\DashboardStorageHandler";s:12:"list_builder";s:37:"Drupal\\dashboard\\DashboardListBuilder";s:4:"form";a:4:{s:3:"add";s:35:"Drupal\\dashboard\\Form\\DashboardForm";s:4:"edit";s:35:"Drupal\\dashboard\\Form\\DashboardForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";s:14:"layout_builder";s:48:"Drupal\\dashboard\\Form\\DashboardLayoutBuilderForm";}}s:19:"\0*\0admin_permission";s:20:"administer dashboard";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:6:{s:10:"collection";s:26:"/admin/structure/dashboard";s:8:"add-form";s:30:"/admin/structure/dashboard/add";s:9:"edit-form";s:38:"/admin/structure/dashboard/{dashboard}";s:11:"delete-form";s:45:"/admin/structure/dashboard/{dashboard}/delete";s:9:"canonical";s:28:"/admin/dashboard/{dashboard}";s:7:"preview";s:46:"/admin/structure/dashboard/{dashboard}/preview";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Dashboard";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Dashboards";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"dashboard";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"dashboards";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:16:"@count dashboard";s:6:"plural";s:17:"@count dashboards";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:dashboard_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:9:"dashboard";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:6:"layout";i:4;s:6:"weight";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'date_format.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:11:"date_format";s:8:"\0*\0class";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\system\\DateFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\\system\\Form\\DateFormatAddForm";s:4:"edit";s:37:"Drupal\\system\\Form\\DateFormatEditForm";s:6:"delete";s:39:"Drupal\\system\\Form\\DateFormatDeleteForm";}s:12:"list_builder";s:35:"Drupal\\system\\DateFormatListBuilder";}s:19:"\0*\0admin_permission";s:29:"administer site configuration";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:61:"/admin/config/regional/date-time/formats/manage/{date_format}";s:11:"delete-form";s:68:"/admin/config/regional/date-time/formats/manage/{date_format}/delete";s:10:"collection";s:40:"/admin/config/regional/date-time/formats";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Date format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:8:"rendered";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"locked";i:3;s:7:"pattern";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'easy_email.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:10:"easy_email";s:8:"\0*\0class";s:34:"Drupal\\easy_email\\Entity\\EasyEmail";s:11:"\0*\0provider";s:10:"easy_email";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:2:"id";s:8:"revision";s:3:"vid";s:6:"bundle";s:4:"type";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:3:"uid";s:11:"creator_uid";s:6:"status";s:6:"status";s:8:"langcode";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:34:"Drupal\\easy_email\\Entity\\EasyEmail";s:11:"\0*\0handlers";a:10:{s:5:"event";s:38:"Drupal\\easy_email\\Event\\EasyEmailEvent";s:7:"storage";s:34:"Drupal\\easy_email\\EasyEmailStorage";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:12:"list_builder";s:38:"Drupal\\easy_email\\EasyEmailListBuilder";s:10:"views_data";s:28:"Drupal\\views\\EntityViewsData";s:4:"form";a:6:{s:7:"default";s:36:"Drupal\\easy_email\\Form\\EasyEmailForm";s:3:"add";s:36:"Drupal\\easy_email\\Form\\EasyEmailForm";s:4:"edit";s:36:"Drupal\\easy_email\\Form\\EasyEmailForm";s:6:"delete";s:42:"Drupal\\easy_email\\Form\\EasyEmailDeleteForm";s:23:"delete-multiple-confirm";s:42:"Drupal\\Core\\Entity\\Form\\DeleteMultipleForm";s:14:"layout_builder";s:46:"Drupal\\layout_builder\\Form\\OverridesEntityForm";}s:6:"access";s:47:"Drupal\\easy_email\\EasyEmailAccessControlHandler";s:14:"route_provider";a:2:{s:4:"html";s:44:"Drupal\\easy_email\\EasyEmailHtmlRouteProvider";s:10:"moderation";s:70:"Drupal\\content_moderation\\Entity\\Routing\\EntityModerationRouteProvider";}s:13:"autosave_form";s:51:"Drupal\\autosave_form\\Form\\AutosaveEntityFormHandler";s:10:"moderation";s:58:"Drupal\\content_moderation\\Entity\\Handler\\ModerationHandler";}s:19:"\0*\0admin_permission";s:25:"administer email entities";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:13:{s:9:"canonical";s:33:"/admin/reports/email/{easy_email}";s:7:"preview";s:41:"/admin/reports/email/{easy_email}/preview";s:13:"preview_plain";s:47:"/admin/reports/email/{easy_email}/preview-plain";s:8:"add-page";s:24:"/admin/reports/email/add";s:8:"add-form";s:42:"/admin/reports/email/add/{easy_email_type}";s:9:"edit-form";s:38:"/admin/reports/email/{easy_email}/edit";s:11:"delete-form";s:40:"/admin/reports/email/{easy_email}/delete";s:15:"version-history";s:43:"/admin/reports/email/{easy_email}/revisions";s:8:"revision";s:70:"/admin/reports/email/{easy_email}/revisions/{easy_email_revision}/view";s:15:"revision_revert";s:72:"/admin/reports/email/{easy_email}/revisions/{easy_email_revision}/revert";s:15:"revision_delete";s:72:"/admin/reports/email/{easy_email}/revisions/{easy_email_revision}/delete";s:10:"collection";s:20:"/admin/reports/email";s:14:"latest-version";s:40:"/admin/reports/email/{easy_email}/latest";}s:21:"\0*\0bundle_entity_type";s:15:"easy_email_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Email template";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:10:"easy_email";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";s:19:"easy_email_revision";s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Emails";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"emails";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:12:"@count email";s:6:"plural";s:13:"@count emails";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:32:"entity.easy_email_type.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:15:"easy_email_list";}s:14:"\0*\0constraints";a:3:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;s:10:"EcaContent";N;}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:10:"easy_email";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:20:"revision_log_message";s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'easy_email.field_storage_definitions', 'a:30:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"easy_email";s:10:"field_name";s:2:"id";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"easy_email";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:36;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"easy_email";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:69;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";s:14:"Email template";s:8:"required";b:1;s:9:"read-only";b:1;s:8:"provider";s:10:"easy_email";s:10:"field_name";s:4:"type";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:15:"easy_email_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:103;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:10:"easy_email";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:134;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:10:"easy_email";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:164;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:20:"revision_log_message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:20:"revision_log_message";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:201;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"label";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:12:"revisionable";b:1;s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Label";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:2:{s:4:"form";a:2:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}s:12:"configurable";b:1;}s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:5:"label";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:243;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"key";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Unique key";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:63:"A unique key for this message used to prevent duplicate emails.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:3:"key";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:286;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"creator_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Creator";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"The user ID of creator of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:17:"autocomplete_type";s:4:"tags";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:11:"creator_uid";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:336;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"recipient_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Recipients";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:11:"cardinality";i:-1;s:8:"required";b:0;s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:17:"autocomplete_type";s:4:"tags";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:13:"recipient_uid";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:390;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:17:"recipient_address";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Recipient addresses";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The recipient email addresses of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:17:"recipient_address";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:441;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"cc_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"CC";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:11:"cardinality";i:-1;s:8:"required";b:0;s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:17:"autocomplete_type";s:4:"tags";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:6:"cc_uid";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:492;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:10:"cc_address";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"CC addresses";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"The CC email addresses of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:10:"cc_address";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:543;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"bcc_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"BCC";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:11:"cardinality";i:-1;s:8:"required";b:0;s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:17:"autocomplete_type";s:4:"tags";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:7:"bcc_uid";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:594;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"bcc_address";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"BCC addresses";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"The BCC email addresses of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:11:"bcc_address";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:645;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:9:"from_name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"From name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The From name of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:9:"from_name";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:696;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"from_address";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"From address";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"The From address of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:12:"from_address";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:747;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"reply_to";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Reply to address";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"The reply to address of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:8:"reply_to";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:798;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"subject";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Subject";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:32:"The Subject of the Email entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:7:"subject";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:849;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:9:"body_html";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"HTML body";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"view";a:2:{s:7:"options";a:3:{s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:5:"label";s:6:"hidden";}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:9:"body_html";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:text_long";s:8:"settings";a:1:{s:15:"allowed_formats";a:0:{}}}s:18:"\0*\0fieldDefinition";r:900;}s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:2:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}s:6:"format";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:10:"body_plain";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Plain text body";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"view";a:2:{s:7:"options";a:3:{s:4:"type";s:12:"basic_string";s:6:"weight";i:0;s:5:"label";s:6:"hidden";}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:10:"body_plain";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:945;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"inbox_preview";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Inbox preview";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"view";a:2:{s:7:"options";a:3:{s:4:"type";s:12:"basic_string";s:6:"weight";i:0;s:5:"label";s:6:"hidden";}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:13:"inbox_preview";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:985;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:10:"attachment";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Attachments";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:11:"cardinality";i:-1;s:8:"required";b:0;s:7:"display";a:2:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:12:"file_generic";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"view";a:2:{s:7:"options";a:3:{s:4:"type";s:12:"file_default";s:6:"weight";i:0;s:5:"label";s:6:"hidden";}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:10:"attachment";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:file";s:8:"settings";a:10:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:7:"private";s:15:"file_extensions";s:55:"txt pdf doc docx xls xlsx ppt pptx rtf png jpg jpeg gif";s:14:"file_directory";s:11:"attachments";s:12:"max_filesize";s:0:"";s:17:"description_field";b:0;s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:1025;}s:7:"\0*\0type";s:4:"file";s:9:"\0*\0schema";a:4:{s:7:"columns";a:3:{s:9:"target_id";a:3:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}s:7:"display";a:5:{s:11:"description";s:75:"Flag to control whether this file should be displayed when viewing content.";s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"unsigned";b:1;s:7:"default";i:1;}s:11:"description";a:2:{s:11:"description";s:26:"A description of the file.";s:4:"type";s:4:"text";}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:12:"foreign keys";a:1:{s:9:"target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:9:"target_id";s:3:"fid";}}}s:11:"unique keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:15:"attachment_path";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:11:"entity_type";s:10:"easy_email";s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Attachment paths";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:11:"cardinality";i:-1;s:8:"required";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:5:"above";s:4:"type";s:6:"string";s:6:"weight";i:-4;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-4;}s:12:"configurable";b:1;}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:15:"attachment_path";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:4:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;s:15:"text_processing";i:0;}}s:18:"\0*\0fieldDefinition";r:1091;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"The time that the entity was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:7:"created";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:1139;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"The time that the entity was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:1168;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"sent";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Sent";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The time that the entity was sent.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:10:"easy_email";s:10:"field_name";s:4:"sent";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:timestamp";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:1197;}s:7:"\0*\0type";s:9:"timestamp";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:10:"easy_email";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:10:"easy_email";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:1227;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:18:"field_related_user";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:29:"easy_email.field_related_user";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"213df2a9-561c-423e-8908-0f0525bc290a";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"o5KZRiEHScznNR5RsW8h1ahlZgOpLK0EZqNOCLAdlrA";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:10:"easy_email";i:1;s:4:"user";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:29:"easy_email.field_related_user";s:13:"\0*\0field_name";s:18:"field_related_user";s:14:"\0*\0entity_type";s:10:"easy_email";s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0module";s:4:"core";s:11:"\0*\0settings";a:1:{s:11:"target_type";s:4:"user";}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:29:"easy_email.field_related_user";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"213df2a9-561c-423e-8908-0f0525bc290a";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"o5KZRiEHScznNR5RsW8h1ahlZgOpLK0EZqNOCLAdlrA";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:10:"easy_email";i:1;s:4:"user";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:29:"easy_email.field_related_user";s:13:"\0*\0field_name";s:18:"field_related_user";s:14:"\0*\0entity_type";s:10:"easy_email";s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0module";s:4:"core";s:11:"\0*\0settings";a:1:{s:11:"target_type";s:4:"user";}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'easy_email_override.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"easy_email_override";s:8:"\0*\0class";s:47:"Drupal\\easy_email_override\\Entity\\EmailOverride";s:11:"\0*\0provider";s:19:"easy_email_override";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:47:"Drupal\\easy_email_override\\Entity\\EmailOverride";s:11:"\0*\0handlers";a:7:{s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:12:"list_builder";s:51:"Drupal\\easy_email_override\\EmailOverrideListBuilder";s:4:"form";a:3:{s:3:"add";s:49:"Drupal\\easy_email_override\\Form\\EmailOverrideForm";s:4:"edit";s:49:"Drupal\\easy_email_override\\Form\\EmailOverrideForm";s:6:"delete";s:55:"Drupal\\easy_email_override\\Form\\EmailOverrideDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:57:"Drupal\\easy_email_override\\EmailOverrideHtmlRouteProvider";}s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";s:13:"autosave_form";s:51:"Drupal\\autosave_form\\Form\\AutosaveEntityFormHandler";}s:19:"\0*\0admin_permission";s:29:"administer site configuration";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:64:"/admin/structure/email-templates/overrides/{easy_email_override}";s:8:"add-form";s:46:"/admin/structure/email-templates/overrides/add";s:9:"edit-form";s:69:"/admin/structure/email-templates/overrides/{easy_email_override}/edit";s:11:"delete-form";s:71:"/admin/structure/email-templates/overrides/{easy_email_override}/delete";s:10:"collection";s:42:"/admin/structure/email-templates/overrides";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Email override";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Email overrides";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"email override";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"email overrides";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:21:"@count email override";s:6:"plural";s:22:"@count email overrides";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:easy_email_override_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:19:"easy_email_override";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:19:"easy_email_override";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:7:{i:0;s:5:"label";i:1;s:2:"id";i:2;s:9:"param_map";i:3;s:13:"copied_fields";i:4;s:6:"module";i:5;s:3:"key";i:6;s:15:"easy_email_type";}s:21:"\0*\0mergedConfigExport";a:0:{}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'easy_email_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:15:"easy_email_type";s:8:"\0*\0class";s:38:"Drupal\\easy_email\\Entity\\EasyEmailType";s:11:"\0*\0provider";s:10:"easy_email";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:38:"Drupal\\easy_email\\Entity\\EasyEmailType";s:11:"\0*\0handlers";a:7:{s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:12:"list_builder";s:42:"Drupal\\easy_email\\EasyEmailTypeListBuilder";s:4:"form";a:3:{s:3:"add";s:40:"Drupal\\easy_email\\Form\\EasyEmailTypeForm";s:4:"edit";s:40:"Drupal\\easy_email\\Form\\EasyEmailTypeForm";s:6:"delete";s:46:"Drupal\\easy_email\\Form\\EasyEmailTypeDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:48:"Drupal\\easy_email\\EasyEmailTypeHtmlRouteProvider";}s:6:"access";s:51:"Drupal\\easy_email\\EasyEmailTypeAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";s:13:"autosave_form";s:51:"Drupal\\autosave_form\\Form\\AutosaveEntityFormHandler";}s:19:"\0*\0admin_permission";s:22:"administer email types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:60:"/admin/structure/email-templates/templates/{easy_email_type}";s:8:"add-form";s:46:"/admin/structure/email-templates/templates/add";s:9:"edit-form";s:65:"/admin/structure/email-templates/templates/{easy_email_type}/edit";s:11:"delete-form";s:67:"/admin/structure/email-templates/templates/{easy_email_type}/delete";s:10:"collection";s:42:"/admin/structure/email-templates/templates";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:10:"easy_email";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Email template";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Email templates";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"email template";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"email templates";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:21:"@count email template";s:6:"plural";s:22:"@count email templates";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:27:"config:easy_email_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:15:"easy_email_type";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:15:"easy_email_type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:23:{i:0;s:5:"label";i:1;s:2:"id";i:2;s:3:"key";i:3;s:9:"recipient";i:4;s:2:"cc";i:5;s:3:"bcc";i:6;s:8:"fromName";i:7;s:11:"fromAddress";i:8;s:14:"replyToAddress";i:9;s:7:"subject";i:10;s:12:"inboxPreview";i:11;s:8:"bodyHtml";i:12;s:9:"bodyPlain";i:13;s:17:"generateBodyPlain";i:14;s:10:"attachment";i:15;s:14:"saveAttachment";i:16;s:16:"attachmentScheme";i:17;s:19:"attachmentDirectory";i:18;s:9:"saveEmail";i:19;s:16:"allowSavingEmail";i:20;s:11:"purgeEmails";i:21;s:13:"purgeInterval";i:22;s:11:"purgePeriod";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'eca.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:3:"eca";s:8:"\0*\0class";s:21:"Drupal\\eca\\Entity\\Eca";s:11:"\0*\0provider";s:3:"eca";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:6:"weight";s:6:"weight";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:21:"Drupal\\eca\\Entity\\Eca";s:11:"\0*\0handlers";a:2:{s:7:"storage";s:28:"Drupal\\eca\\Entity\\EcaStorage";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";}s:19:"\0*\0admin_permission";s:14:"administer eca";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"ECA";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"ECAs";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"ECA";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"ECAs";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:10:"@count ECA";s:6:"plural";s:11:"@count ECAs";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:15:"config:eca_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:3:"eca";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:3:"eca";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:11:{i:0;s:2:"id";i:1;s:8:"modeller";i:2;s:5:"label";i:3;s:4:"uuid";i:4;s:6:"status";i:5;s:7:"version";i:6;s:6:"weight";i:7;s:6:"events";i:8;s:10:"conditions";i:9;s:8:"gateways";i:10;s:7:"actions";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'eca_model.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:9:"eca_model";s:8:"\0*\0class";s:23:"Drupal\\eca\\Entity\\Model";s:11:"\0*\0provider";s:3:"eca";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:4:"uuid";s:4:"uuid";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\eca\\Entity\\Model";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"ECA Model";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"ECA Models";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"ECA Model";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"ECA Models";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:16:"@count ECA Model";s:6:"plural";s:17:"@count ECA Models";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:eca_model_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:9:"eca_model";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:5:"model";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"tags";i:3;s:13:"documentation";i:4;s:8:"filename";i:5;s:9:"modeldata";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'editor.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:6:"editor";s:8:"\0*\0class";s:27:"Drupal\\editor\\Entity\\Editor";s:11:"\0*\0provider";s:6:"editor";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:6:"format";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\editor\\Entity\\Editor";s:11:"\0*\0handlers";a:2:{s:6:"access";s:40:"Drupal\\editor\\EditorAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:18:"@count text editor";s:6:"plural";s:19:"@count text editors";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:editor_list";}s:14:"\0*\0constraints";a:1:{s:26:"RequiredConfigDependencies";a:1:{i:0;s:13:"filter_format";}}s:13:"\0*\0additional";a:1:{s:10:"token_type";s:6:"editor";}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:6:"format";i:1;s:6:"editor";i:2;s:8:"settings";i:3;s:12:"image_upload";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_form_display.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"entity_form_display";s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:11:"\0*\0handlers";a:2:{s:6:"access";s:70:"Drupal\\Core\\Entity\\Entity\\Access\\EntityFormDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity form display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_form_display_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_form_mode.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:16:"entity_form_mode";s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Form mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_form_mode_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_view_display.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:19:"entity_view_display";s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:11:"\0*\0handlers";a:2:{s:6:"access";s:70:"Drupal\\Core\\Entity\\Entity\\Access\\EntityViewDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity view display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_view_display_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_view_mode.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:16:"entity_view_mode";s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"View mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_view_mode_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'field_config.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:12:"field_config";s:8:"\0*\0class";s:31:"Drupal\\field\\Entity\\FieldConfig";s:11:"\0*\0provider";s:5:"field";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:31:"Drupal\\field\\Entity\\FieldConfig";s:11:"\0*\0handlers";a:2:{s:6:"access";s:44:"Drupal\\field\\FieldConfigAccessControlHandler";s:7:"storage";s:31:"Drupal\\field\\FieldConfigStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:12:"@count field";s:6:"plural";s:13:"@count fields";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:field_config_list";}s:14:"\0*\0constraints";a:2:{s:26:"RequiredConfigDependencies";a:1:{i:0;s:20:"field_storage_config";}s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:6:"bundle";i:4;s:10:"field_type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:5:"field";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'field_storage_config.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:20:"field_storage_config";s:8:"\0*\0class";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:11:"\0*\0provider";s:5:"field";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:11:"\0*\0handlers";a:2:{s:6:"access";s:51:"Drupal\\field\\FieldStorageConfigAccessControlHandler";s:7:"storage";s:38:"Drupal\\field\\FieldStorageConfigStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:20:"@count field storage";s:6:"plural";s:21:"@count field storages";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:32:"config:field_storage_config_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:4:"type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:7:"storage";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:4:"type";i:4;s:8:"settings";i:5;s:6:"module";i:6;s:6:"locked";i:7;s:11:"cardinality";i:8;s:12:"translatable";i:9;s:7:"indexes";i:10;s:22:"persist_with_no_fields";i:11;s:14:"custom_storage";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'file.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:4:"file";s:8:"\0*\0class";s:23:"Drupal\\file\\Entity\\File";s:11:"\0*\0provider";s:4:"file";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"fid";s:5:"label";s:8:"filename";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\file\\Entity\\File";s:11:"\0*\0handlers";a:8:{s:7:"storage";s:23:"Drupal\\file\\FileStorage";s:14:"storage_schema";s:29:"Drupal\\file\\FileStorageSchema";s:6:"access";s:36:"Drupal\\file\\FileAccessControlHandler";s:10:"views_data";s:25:"Drupal\\file\\FileViewsData";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:4:"form";a:1:{s:6:"delete";s:42:"Drupal\\Core\\Entity\\ContentEntityDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\file\\Entity\\FileRouteProvider";}s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:1:{s:11:"delete-form";s:19:"/file/{file}/delete";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:12:"file_managed";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"File";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"file";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:11:"@count file";s:6:"plural";s:12:"@count files";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"file_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'file.field_storage_definitions', 'a:11:{s:3:"fid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"File ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The file ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"fid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The file UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The file language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:0;s:22:"default_value_callback";s:46:"Drupal\\file\\Entity\\File::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"The user ID of the file.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filename";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Filename";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"Name of the file with no path components.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filename";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:153;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uri";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"URI";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The URI to access the file (either local or remote).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"constraints";a:1:{s:13:"FileUriUnique";N;}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uri";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:file_uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:1;}}s:18:"\0*\0fieldDefinition";r:187;}s:7:"\0*\0type";s:8:"file_uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:1;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filemime";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"File MIME type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"The file''s MIME type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filemime";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:222;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filesize";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"File size";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The size of the file in bytes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filesize";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:3:"big";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:256;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Status";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:63:"The status of the file, temporary (FALSE) and permanent (TRUE).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:4:"file";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:293;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:40:"The timestamp that the file was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:334;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"The timestamp that the file was last changed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:363;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'filter_format.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:13:"filter_format";s:8:"\0*\0class";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:11:"\0*\0provider";s:6:"filter";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:6:"format";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:3:"add";s:33:"Drupal\\filter\\FilterFormatAddForm";s:4:"edit";s:34:"Drupal\\filter\\FilterFormatEditForm";s:7:"disable";s:36:"Drupal\\filter\\Form\\FilterDisableForm";s:6:"enable";s:35:"Drupal\\filter\\Form\\FilterEnableForm";}s:12:"list_builder";s:37:"Drupal\\filter\\FilterFormatListBuilder";s:6:"access";s:46:"Drupal\\filter\\FilterFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer filters";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:52:"/admin/config/content/formats/manage/{filter_format}";s:7:"disable";s:60:"/admin/config/content/formats/manage/{filter_format}/disable";s:6:"enable";s:59:"/admin/config/content/formats/manage/{filter_format}/enable";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:18:"@count text format";s:6:"plural";s:19:"@count text formats";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:25:"config:filter_format_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:6:"format";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:4:"name";i:1;s:6:"format";i:2;s:6:"weight";i:3;s:5:"roles";i:4;s:7:"filters";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'image_style.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:5:"\0*\0id";s:11:"image_style";s:8:"\0*\0class";s:30:"Drupal\\image\\Entity\\ImageStyle";s:11:"\0*\0provider";s:5:"image";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:4:"name";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:30:"Drupal\\image\\Entity\\ImageStyle";s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:3:"add";s:35:"Drupal\\image\\Form\\ImageStyleAddForm";s:4:"edit";s:36:"Drupal\\image\\Form\\ImageStyleEditForm";s:6:"delete";s:38:"Drupal\\image\\Form\\ImageStyleDeleteForm";s:5:"flush";s:37:"Drupal\\image\\Form\\ImageStyleFlushForm";}s:12:"list_builder";s:34:"Drupal\\image\\ImageStyleListBuilder";s:7:"storage";s:30:"Drupal\\image\\ImageStyleStorage";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";}s:19:"\0*\0admin_permission";s:23:"administer image styles";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:10:"flush-form";s:59:"/admin/config/media/image-styles/manage/{image_style}/flush";s:9:"edit-form";s:53:"/admin/config/media/image-styles/manage/{image_style}";s:11:"delete-form";s:60:"/admin/config/media/image-styles/manage/{image_style}/delete";s:10:"collection";s:32:"/admin/config/media/image-styles";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:18:"@count image style";s:6:"plural";s:19:"@count image styles";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration"