
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `domainmod4230`
--

-- --------------------------------------------------------

--
-- Table structure for table `api_registrars`
--

CREATE TABLE `api_registrars` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `req_account_username` tinyint(1) NOT NULL DEFAULT '0',
  `req_account_password` tinyint(1) NOT NULL DEFAULT '0',
  `req_account_id` tinyint(1) NOT NULL DEFAULT '0',
  `req_reseller_id` tinyint(1) NOT NULL DEFAULT '0',
  `req_api_app_name` tinyint(1) NOT NULL DEFAULT '0',
  `req_api_key` tinyint(1) NOT NULL DEFAULT '0',
  `req_api_secret` tinyint(1) NOT NULL DEFAULT '0',
  `req_ip_address` tinyint(1) NOT NULL DEFAULT '0',
  `lists_domains` tinyint(1) NOT NULL DEFAULT '0',
  `ret_expiry_date` tinyint(1) NOT NULL DEFAULT '0',
  `ret_dns_servers` tinyint(1) NOT NULL DEFAULT '0',
  `ret_privacy_status` tinyint(1) NOT NULL DEFAULT '0',
  `ret_autorenewal_status` tinyint(1) NOT NULL DEFAULT '0',
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `api_registrars`
--

INSERT INTO `api_registrars` VALUES
(1, 'Above.com', 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(2, 'DNSimple', 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(3, 'DreamHost', 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 'DreamHost does not currently allow the WHOIS privacy status of a domain to be retrieved via their API, so all domains added to the Domain Queue from a DreamHost account will have their WHOIS privacy status set to No by default.', '[[regtime]]', '1970-01-01 00:00:00'),
(4, 'Dynadot', 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(5, 'eNom', 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(6, 'Fabulous', 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(7, 'Freenom', 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 'Freenom currently only gives API access to reseller accounts.', '[[regtime]]', '1970-01-01 00:00:00'),
(8, 'Gandi', 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 'Gandi does not currently allow the WHOIS privacy status of a domain to be retrieved via their API, so all domains added to the Domain Queue from a Gandi account will have their WHOIS privacy status set to No by default.', '[[regtime]]', '1970-01-01 00:00:00'),
(9, 'GoDaddy', 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 'When retrieving your list of domains from GoDaddy, the current limit is 1,000 domains. If you have more than this you should export the full list of domains from GoDaddy and paste it into the <strong>Domains to add</strong> field when adding domains via the Domain Queue.', '[[regtime]]', '1970-01-01 00:00:00'),
(10, 'Internet.bs', 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(11, 'Name.com', 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(12, 'NameBright', 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(13, 'Namecheap', 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(14, 'NameSilo', 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 'NameSilo''s domains have 6 possible statuses: Active, Expired (grace period), Expired (restore period), Expired (pending delete), Inactive, and Pending Outbound Transfer<BR><BR>When retrieving your list of domains via the API, <STRONG>Inactive</STRONG> domains are not returned.<BR><BR>When retrieving the details of a specific domain via the API, <STRONG>Inactive</STRONG> and <STRONG>Expired (pending delete)</STRONG> domains will not return any data.', '[[regtime]]', '1970-01-01 00:00:00'),
(15, 'OpenSRS', 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00'),
(16, 'Porkbun', 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 'When retrieving your list of domains from Porkbun, the current limit is 1,000 domains. If you have more than this you should export the full list of domains from Porkbun and paste it into the <strong>Domains to add</strong> field when adding domains via the Domain Queue.', '[[regtime]]', '1970-01-01 00:00:00'),
(17, 'ResellerClub', 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 'ResellerClub does not allow users to retrieve a list of their domains via the API, nor do they return the Auto Renewal status when retrieving the details of a domain. All domains imported via the API will have their Auto Renewal status set to No by default.', '[[regtime]]', '1970-01-01 00:00:00'),
(18, 'Cloudflare', 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, '', '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `stakeholder` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` VALUES
(1, '[no category]', '[no stakeholder]', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `creation_types`
--

CREATE TABLE `creation_types` (
  `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `creation_types`
--

INSERT INTO `creation_types` VALUES
(1, 'Installation', '[[regtime]]'),
(2, 'Manual', '[[regtime]]'),
(3, 'Bulk Updater', '[[regtime]]'),
(4, 'Manual or Bulk Updater', '[[regtime]]'),
(5, 'Queue', '[[regtime]]'),
(6, 'CSV Importer', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(75) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `symbol_order` tinyint(1) NOT NULL DEFAULT '0',
  `symbol_space` tinyint(1) NOT NULL DEFAULT '0',
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=167 ;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` VALUES
(1, 'ALL', 'Albania Lek', 'Lek', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(2, 'AFN', 'Afghanistan Afghani', '؋', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(3, 'ARS', 'Argentina Peso', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(4, 'AWG', 'Aruba Guilder', 'ƒ', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(5, 'AUD', 'Australia Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(6, 'AZN', 'Azerbaijan New Manat', 'ман', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(7, 'BSD', 'Bahamas Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(8, 'BBD', 'Barbados Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(9, 'BYR', 'Belarus Ruble', 'p.', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(10, 'BZD', 'Belize Dollar', 'BZ$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(11, 'BMD', 'Bermuda Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(12, 'BOB', 'Bolivia Boliviano', '$b', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(13, 'BAM', 'Bosnia and Herzegovina Convertible Marka', 'KM', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(14, 'BWP', 'Botswana Pula', 'P', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(15, 'BGN', 'Bulgaria Lev', 'лв', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(16, 'BRL', 'Brazil Real', 'R$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(17, 'BND', 'Brunei Darussalam Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(18, 'KHR', 'Cambodia Riel', '៛', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(19, 'CAD', 'Canada Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(20, 'KYD', 'Cayman Islands Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(21, 'CLP', 'Chile Peso', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(22, 'CNY', 'China Yuan Renminbi', '¥', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(23, 'COP', 'Colombia Peso', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(24, 'CRC', 'Costa Rica Colon', '₡', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(25, 'HRK', 'Croatia Kuna', 'kn', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(26, 'CUP', 'Cuba Peso', '₱', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(27, 'CZK', 'Czech Republic Koruna', 'Kč', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(28, 'DKK', 'Denmark Krone', 'kr', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(29, 'DOP', 'Dominican Republic Peso', 'RD$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(30, 'XCD', 'East Caribbean Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(31, 'EGP', 'Egypt Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(32, 'SVC', 'El Salvador Colon', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(33, 'EEK', 'Estonia Kroon', 'kr', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(34, 'EUR', 'Euro Member Countries', '€', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(35, 'FKP', 'Falkland Islands (Malvinas) Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(36, 'FJD', 'Fiji Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(37, 'GHC', 'Ghana Cedis', '¢', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(38, 'GIP', 'Gibraltar Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(39, 'GTQ', 'Guatemala Quetzal', 'Q', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(40, 'GGP', 'Guernsey Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(41, 'GYD', 'Guyana Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(42, 'HNL', 'Honduras Lempira', 'L', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(43, 'HKD', 'Hong Kong Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(44, 'HUF', 'Hungary Forint', 'Ft', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(45, 'ISK', 'Iceland Krona', 'kr', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(46, 'INR', 'India Rupee', 'Rs', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(47, 'IDR', 'Indonesia Rupiah', 'Rp', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(48, 'IRR', 'Iran Rial', '﷼', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(49, 'IMP', 'Isle of Man Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(50, 'ILS', 'Israel Shekel', '₪', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(51, 'JMD', 'Jamaica Dollar', 'J$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(52, 'JPY', 'Japan Yen', '¥', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(53, 'JEP', 'Jersey Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(54, 'KZT', 'Kazakhstan Tenge', 'лв', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(55, 'KPW', 'Korea (North) Won', '₩', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(56, 'KRW', 'Korea (South) Won', '₩', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(57, 'KGS', 'Kyrgyzstan Som', 'лв', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(58, 'LAK', 'Laos Kip', '₭', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(59, 'LVL', 'Latvia Lat', 'Ls', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(60, 'LBP', 'Lebanon Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(61, 'LRD', 'Liberia Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(62, 'LTL', 'Lithuania Litas', 'Lt', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(63, 'MKD', 'Macedonia Denar', 'ден', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(64, 'RM', 'Malaysia Ringgit', 'RM', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(65, 'MUR', 'Mauritius Rupee', '₨', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(66, 'MXN', 'Mexico Peso', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(67, 'MNT', 'Mongolia Tughrik', '₮', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(68, 'MZN', 'Mozambique Metical', 'MT', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(69, 'NAD', 'Namibia Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(70, 'NPR', 'Nepal Rupee', '₨', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(71, 'ANG', 'Netherlands Antilles Guilder', 'ƒ', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(72, 'NZD', 'New Zealand Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(73, 'NIO', 'Nicaragua Cordoba', 'C$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(74, 'NGN', 'Nigeria Naira', '₦', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(75, 'NOK', 'Norway Krone', 'kr', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(76, 'OMR', 'Oman Rial', '﷼', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(77, 'PKR', 'Pakistan Rupee', '₨', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(78, 'PAB', 'Panama Balboa', 'B/.', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(79, 'PYG', 'Paraguay Guarani', 'Gs', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(80, 'PEN', 'Peru Nuevo Sol', 'S/.', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(81, 'PHP', 'Philippines Peso', '₱', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(82, 'PLN', 'Poland Zloty', 'zł', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(83, 'QAR', 'Qatar Riyal', '﷼', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(84, 'RON', 'Romania New Leu', 'lei', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(85, 'RUB', 'Russia Ruble', 'руб', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(86, 'SHP', 'Saint Helena Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(87, 'SAR', 'Saudi Arabia Riyal', '﷼', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(88, 'RSD', 'Serbia Dinar', 'Дин.', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(89, 'SCR', 'Seychelles Rupee', '₨', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(90, 'SGD', 'Singapore Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(91, 'SBD', 'Solomon Islands Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(92, 'SOS', 'Somalia Shilling', 'S', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(93, 'ZAR', 'South Africa Rand', 'R', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(94, 'LKR', 'Sri Lanka Rupee', '₨', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(95, 'SEK', 'Sweden Krona', 'kr', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(96, 'CHF', 'Switzerland Franc', 'CHF', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(97, 'SRD', 'Suriname Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(98, 'SYP', 'Syria Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(99, 'TWD', 'Taiwan New Dollar', 'NT$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(100, 'THB', 'Thailand Baht', '฿', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(101, 'TTD', 'Trinidad and Tobago Dollar', 'TT$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(102, 'TRY', 'Turkey Lira', '₺', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(103, 'TVD', 'Tuvalu Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(104, 'UAH', 'Ukraine Hryvna', '₴', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(105, 'GBP', 'United Kingdom Pound', '£', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(106, 'USD', 'United States Dollar', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(107, 'UYU', 'Uruguay Peso', '$U', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(108, 'UZS', 'Uzbekistan Som', 'лв', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(109, 'VEF', 'Venezuela Bolivar', 'Bs', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(110, 'VND', 'Viet Nam Dong', '₫', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(111, 'YER', 'Yemen Rial', '﷼', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(112, 'ZWD', 'Zimbabwe Dollar', 'Z$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(113, 'AED', 'Emirati Dirham', 'د.إ', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(114, 'MYR', 'Malaysian Ringgit', 'RM', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(115, 'KWD', 'Kuwaiti Dinar', 'ك', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(116, 'MAD', 'Moroccan Dirham', 'م.', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(117, 'IQD', 'Iraqi Dinar', 'د.ع', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(118, 'BDT', 'Bangladeshi Taka', 'Tk', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(119, 'BHD', 'Bahraini Dinar', 'BD', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(120, 'KES', 'Kenyan Shilling', 'KSh', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(121, 'XOF', 'CFA Franc', 'CFA', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(122, 'JOD', 'Jordanian Dinar', 'JD', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(123, 'TND', 'Tunisian Dinar', 'د.ت', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(124, 'GHS', 'Ghanaian Cedi', 'GH¢', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(125, 'XAF', 'Central African CFA Franc BEAC', 'FCFA', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(126, 'DZD', 'Algerian Dinar', 'دج', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(127, 'XPF', 'CFP Franc', 'F', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(128, 'UGX', 'Ugandan Shilling', 'USh', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(129, 'TZS', 'Tanzanian Shilling', 'TZS', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(130, 'ETB', 'Ethiopian Birr', 'Br', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(131, 'GEL', 'Georgian Lari', 'GEL', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(132, 'CUC', 'Cuban Convertible Peso', 'CUC$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(133, 'MMK', 'Burmese Kyat', 'K', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(134, 'LYD', 'Libyan Dinar', 'LD', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(135, 'ZMK', 'Zambian Kwacha', 'ZK', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(136, 'ZMW', 'Zambian Kwacha', 'ZK', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(137, 'MOP', 'Macau Pataca', 'MOP$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(138, 'AMD', 'Armenian Dram', 'AMD', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(139, 'AOA', 'Angolan Kwanza', 'Kz', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(140, 'PGK', 'Papua New Guinean Kina', 'K', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(141, 'MGA', 'Malagasy Ariary', 'Ar', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(142, 'VUV', 'Ni-Vanuatu Vatu', 'VT', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(143, 'SDG', 'Sudanese Pound', 'SDG', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(144, 'MWK', 'Malawian Kwacha', 'MK', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(145, 'RWF', 'Rwandan Franc', 'FRw', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(146, 'GMD', 'Gambian Dalasi', 'D', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(147, 'MVR', 'Maldivian Rufiyaa', 'Rf', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(148, 'CDF', 'Congolese Franc', 'FC', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(149, 'DJF', 'Djiboutian Franc', 'Fdj', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(150, 'HTG', 'Haitian Gourde', 'G', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(151, 'WST', 'Samoan Tala', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(152, 'GNF', 'Guinean Franc', 'FG', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(153, 'CVE', 'Cape Verdean Escudo', '$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(154, 'TOP', 'Tongan Pa''anga', 'T$', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(155, 'MDL', 'Moldovan Leu', 'MDL', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(156, 'SLL', 'Sierra Leonean Leone', 'Le', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(157, 'BIF', 'Burundian Franc', 'FBu', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(158, 'MRO', 'Mauritanian Ouguiya', 'UM', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(159, 'BTN', 'Bhutanese Ngultrum', 'Nu.', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(160, 'SZL', 'Swazi Lilangeni', 'SZL', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(161, 'TJS', 'Tajikistani Somoni', 'TJS', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(162, 'TMT', 'Turkmenistani Manat', 'm', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(163, 'LSL', 'Basotho Loti', 'LSL', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(164, 'KMF', 'Comoran Franc', 'CF', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(165, 'STD', 'Sao Tomean Dobra', 'STD', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00'),
(166, 'SPL', 'Seborgan Luigino', 'SPL', 0, 0, '', '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `currency_conversions`
--

CREATE TABLE `currency_conversions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `currency_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `conversion` decimal(12,4) NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_types`
--

CREATE TABLE `custom_field_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `custom_field_types`
--

INSERT INTO `custom_field_types` VALUES
(1, 'Check Box', '[[regtime]]', '1970-01-01 00:00:00'),
(2, 'Text', '[[regtime]]', '1970-01-01 00:00:00'),
(3, 'Text Area', '[[regtime]]', '1970-01-01 00:00:00'),
(4, 'Date', '[[regtime]]', '1970-01-01 00:00:00'),
(5, 'Time Stamp', '[[regtime]]', '1970-01-01 00:00:00'),
(6, 'URL', '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `dns`
--

CREATE TABLE `dns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns1` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns2` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns3` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns4` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns5` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns6` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns7` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns8` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns9` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dns10` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ip1` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip2` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip3` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip4` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip5` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip6` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip7` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip8` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip9` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `ip10` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `number_of_servers` tinyint(2) NOT NULL DEFAULT '0',
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `dns`
--

INSERT INTO `dns` VALUES
(1, '[no dns]', 'ns1.no-dns.com', 'ns2.no-dns.com', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 2, 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `domains`
--

CREATE TABLE `domains` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned NOT NULL DEFAULT '1',
  `registrar_id` int(10) unsigned NOT NULL DEFAULT '1',
  `account_id` int(10) unsigned NOT NULL DEFAULT '1',
  `domain` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tld` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `expiry_date` date NOT NULL DEFAULT '1970-01-01',
  `cat_id` int(10) unsigned NOT NULL DEFAULT '1',
  `fee_id` int(10) unsigned NOT NULL DEFAULT '0',
  `total_cost` decimal(10,2) NOT NULL,
  `dns_id` int(10) unsigned NOT NULL DEFAULT '1',
  `ip_id` int(10) unsigned NOT NULL DEFAULT '1',
  `hosting_id` int(10) unsigned NOT NULL DEFAULT '1',
  `function` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `autorenew` tinyint(1) NOT NULL DEFAULT '0',
  `privacy` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(2) NOT NULL DEFAULT '1',
  `fee_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_fields`
--

CREATE TABLE `domain_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(75) COLLATE utf8_unicode_ci NOT NULL,
  `field_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_field_data`
--

CREATE TABLE `domain_field_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `domain_id` int(10) unsigned NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_queue`
--

CREATE TABLE `domain_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `api_registrar_id` smallint(5) NOT NULL DEFAULT '0',
  `domain_id` int(10) unsigned NOT NULL DEFAULT '0',
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `registrar_id` int(10) unsigned NOT NULL DEFAULT '0',
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `domain` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tld` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `expiry_date` date NOT NULL DEFAULT '1970-01-01',
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dns_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ip_id` int(10) unsigned NOT NULL DEFAULT '0',
  `hosting_id` int(10) unsigned NOT NULL DEFAULT '0',
  `autorenew` tinyint(1) NOT NULL DEFAULT '0',
  `privacy` tinyint(1) NOT NULL DEFAULT '0',
  `processing` tinyint(1) NOT NULL DEFAULT '0',
  `ready_to_import` tinyint(1) NOT NULL DEFAULT '0',
  `finished` tinyint(1) NOT NULL DEFAULT '0',
  `already_in_domains` tinyint(1) NOT NULL DEFAULT '0',
  `already_in_queue` tinyint(1) NOT NULL DEFAULT '0',
  `invalid_domain` tinyint(1) NOT NULL DEFAULT '0',
  `copied_to_history` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_queue_history`
--

CREATE TABLE `domain_queue_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `api_registrar_id` smallint(5) NOT NULL DEFAULT '0',
  `domain_id` int(10) unsigned NOT NULL DEFAULT '0',
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `registrar_id` int(10) unsigned NOT NULL DEFAULT '0',
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `domain` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tld` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `expiry_date` date NOT NULL DEFAULT '1970-01-01',
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dns_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ip_id` int(10) unsigned NOT NULL DEFAULT '0',
  `hosting_id` int(10) unsigned NOT NULL DEFAULT '0',
  `autorenew` tinyint(1) NOT NULL DEFAULT '0',
  `privacy` tinyint(1) NOT NULL DEFAULT '0',
  `already_in_domains` tinyint(1) NOT NULL DEFAULT '0',
  `already_in_queue` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_queue_list`
--

CREATE TABLE `domain_queue_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `api_registrar_id` smallint(5) NOT NULL DEFAULT '0',
  `domain_count` int(6) NOT NULL DEFAULT '0',
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `registrar_id` int(10) unsigned NOT NULL DEFAULT '0',
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `processing` tinyint(1) NOT NULL DEFAULT '0',
  `ready_to_import` tinyint(1) NOT NULL DEFAULT '0',
  `finished` tinyint(1) NOT NULL DEFAULT '0',
  `copied_to_history` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_queue_list_history`
--

CREATE TABLE `domain_queue_list_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `api_registrar_id` smallint(5) NOT NULL DEFAULT '0',
  `domain_count` int(6) NOT NULL DEFAULT '0',
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `registrar_id` int(10) unsigned NOT NULL DEFAULT '0',
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_queue_temp`
--

CREATE TABLE `domain_queue_temp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `domain` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `expiry_date` date NOT NULL DEFAULT '1970-01-01',
  `ns1` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns2` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns3` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns4` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns5` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns6` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns7` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns8` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns9` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ns10` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `autorenew` tinyint(1) NOT NULL DEFAULT '0',
  `privacy` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dw_servers`
--

CREATE TABLE `dw_servers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `protocol` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `port` int(5) NOT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `api_token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `hash` longtext COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `dw_accounts` int(10) unsigned NOT NULL,
  `dw_dns_zones` int(10) unsigned NOT NULL,
  `dw_dns_records` int(10) unsigned NOT NULL,
  `build_status` tinyint(1) NOT NULL DEFAULT '0',
  `build_start_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `build_end_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `build_time` int(10) unsigned NOT NULL DEFAULT '0',
  `has_ever_been_built` tinyint(1) NOT NULL DEFAULT '0',
  `build_status_overall` tinyint(1) NOT NULL DEFAULT '0',
  `build_start_time_overall` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `build_end_time_overall` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `build_time_overall` int(10) unsigned NOT NULL DEFAULT '0',
  `has_ever_been_built_overall` tinyint(1) NOT NULL DEFAULT '0',
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fees`
--

CREATE TABLE `fees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `registrar_id` int(10) unsigned NOT NULL,
  `tld` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `initial_fee` decimal(10,2) NOT NULL,
  `renewal_fee` decimal(10,2) NOT NULL,
  `transfer_fee` decimal(10,2) NOT NULL,
  `privacy_fee` decimal(10,2) NOT NULL,
  `misc_fee` decimal(10,2) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `fee_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `goal_activity`
--

CREATE TABLE `goal_activity` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown',
  `old_version` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown',
  `new_version` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown',
  `ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown',
  `agent` longtext COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown',
  `new_activity` tinyint(1) NOT NULL DEFAULT '1',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `goal_activity`
--

INSERT INTO `goal_activity` VALUES
(1, 'i', 'n/a', '4.23.0', '[[serverip]]', '[[act_agent]]', '[[act_language]]', 1, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `hosting`
--

CREATE TABLE `hosting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `hosting`
--

INSERT INTO `hosting` VALUES
(1, '[no hosting]', '', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `ip_addresses`
--

CREATE TABLE `ip_addresses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `rdns` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ip_addresses`
--

INSERT INTO `ip_addresses` VALUES
(1, '[no ip address]', '-', '-', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=27 ;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` VALUES
(1, 'English (CA)', 'en_CA.UTF-8', '[[regtime]]'),
(2, 'English (US)', 'en_US.UTF-8', '[[regtime]]'),
(3, 'Arabic', 'ar_SA.UTF-8', '[[regtime]]'),
(4, 'Bengali', 'bn_BD.UTF-8', '[[regtime]]'),
(5, 'Chinese (Simplified)', 'zh_CN.UTF-8', '[[regtime]]'),
(6, 'Chinese (Traditional)', 'zh_TW.UTF-8', '[[regtime]]'),
(7, 'Dutch', 'nl_NL.UTF-8', '[[regtime]]'),
(8, 'French', 'fr_FR.UTF-8', '[[regtime]]'),
(9, 'German', 'de_DE.UTF-8', '[[regtime]]'),
(10, 'Hindi', 'hi_IN.UTF-8', '[[regtime]]'),
(11, 'Indonesian', 'id_ID.UTF-8', '[[regtime]]'),
(12, 'Italian', 'it_IT.UTF-8', '[[regtime]]'),
(13, 'Japanese', 'ja_JP.UTF-8', '[[regtime]]'),
(14, 'Korean', 'ko_KR.UTF-8', '[[regtime]]'),
(15, 'Marathi', 'mr_IN.UTF-8', '[[regtime]]'),
(16, 'Persian', 'fa_IR.UTF-8', '[[regtime]]'),
(17, 'Polish', 'pl_PL.UTF-8', '[[regtime]]'),
(18, 'Portuguese', 'pt_PT.UTF-8', '[[regtime]]'),
(19, 'Portuguese (BR)', 'pt_BR.UTF-8', '[[regtime]]'),
(20, 'Russian', 'ru_RU.UTF-8', '[[regtime]]'),
(21, 'Spanish', 'es_ES.UTF-8', '[[regtime]]'),
(22, 'Tamil', 'ta_IN.UTF-8', '[[regtime]]'),
(23, 'Telugu', 'te_IN.UTF-8', '[[regtime]]'),
(24, 'Turkish', 'tr_TR.UTF-8', '[[regtime]]'),
(25, 'Urdu', 'ur_PK.UTF-8', '[[regtime]]'),
(26, 'Vietnamese', 'vi_VN.UTF-8', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `log`
--

CREATE TABLE `log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `area` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `level` varchar(9) COLLATE utf8_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8_unicode_ci NOT NULL,
  `extra` longtext COLLATE utf8_unicode_ci NOT NULL,
  `url` longtext COLLATE utf8_unicode_ci NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `owners`
--

CREATE TABLE `owners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `owners`
--

INSERT INTO `owners` VALUES
(1, '[no owner]', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `registrars`
--

CREATE TABLE `registrars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `api_registrar_id` tinyint(3) NOT NULL DEFAULT '0',
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `registrar_accounts`
--

CREATE TABLE `registrar_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned NOT NULL,
  `registrar_id` int(10) unsigned NOT NULL,
  `email_address` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `account_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `reseller` tinyint(1) NOT NULL DEFAULT '0',
  `reseller_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `api_app_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `api_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `api_secret` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `api_ip_id` int(10) unsigned NOT NULL DEFAULT '0',
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `registrar_id` (`registrar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `scheduler`
--

CREATE TABLE `scheduler` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `interval` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Daily',
  `expression` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0 7 * * *',
  `last_run` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `last_duration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `next_run` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `sort_order` int(4) NOT NULL DEFAULT '1',
  `is_running` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `scheduler`
--

INSERT INTO `scheduler` VALUES
(1, 'Domain Queue Processing', 'domain-queue', 'Retrieves information for domains in the queue and adds them to DomainMOD.', 'Every 5 Minutes', '*/5 * * * *', '1970-01-01 00:00:00', '', '[[regtime]]', 10, 0, 1, '[[regtime]]', '1970-01-01 00:00:00'),
(2, 'Send Expiration Email', 'expiration-email', 'Sends an email out to everyone who''s subscribed, letting them know of upcoming Domain & SSL Certificate expirations.<BR><BR>Users can subscribe via their User Profile.<BR><BR>Administrators can set the FROM email address and the number of days in the future to display in the email via System Settings.', 'Daily', '0 0 * * *', '1970-01-01 00:00:00', '', '[[next_run]] 07:00:00', 20, 0, 1, '[[regtime]]', '1970-01-01 00:00:00'),
(3, 'Update Conversion Rates', 'update-conversion-rates', 'Retrieves the current currency conversion rates and updates the entire system, which keeps all of the financial information in DomainMOD accurate and up-to-date.<BR><BR>Users can set their default currency via their User Profile.', 'Daily', '0 0 * * *', '1970-01-01 00:00:00', '', '[[next_run]] 07:00:00', 40, 0, 1, '[[regtime]]', '1970-01-01 00:00:00'),
(4, 'System Cleanup', 'cleanup', '<em>Domains:</em> Converts all domain entries to lowercase.<BR><BR> <em>TLDs:</em> Updates all TLD entries in the database to ensure their accuracy.<BR><BR> <em>Segments:</em> Compares the Segment data to the domain database and records the status of each domain. This keeps the Segment filtering data up-to-date and running smoothly.<BR><BR><em>Fees:</em> Cross-references the Domain, SSL Certificate, and fee tables, making sure that everything is accurate. It also deletes all unused fees.', 'Daily', '0 0 * * *', '1970-01-01 00:00:00', '', '[[next_run]] 07:00:00', 60, 0, 1, '[[regtime]]', '1970-01-01 00:00:00'),
(5, 'Check For New Version', 'check-new-version', 'Checks to see if there is a newer version of DomainMOD available to download.', 'Daily', '0 0 * * *', '1970-01-01 00:00:00', '', '[[next_run]] 07:00:00', 80, 0, 1, '[[regtime]]', '1970-01-01 00:00:00'),
(6, 'Data Warehouse Build', 'data-warehouse-build', 'Rebuilds the Data Warehouse so that you have the most up-to-date information available.', 'Daily', '0 0 * * *', '1970-01-01 00:00:00', '', '[[next_run]] 07:00:00', 100, 0, 1, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `segments`
--

CREATE TABLE `segments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `segment` longtext COLLATE utf8_unicode_ci NOT NULL,
  `number_of_domains` int(6) NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `segment_data`
--

CREATE TABLE `segment_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int(10) unsigned NOT NULL,
  `domain` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `missing` tinyint(1) NOT NULL DEFAULT '0',
  `filtered` tinyint(1) NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `full_url` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'http://',
  `db_version` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `upgrade_available` tinyint(1) NOT NULL DEFAULT '0',
  `email_address` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `large_mode` tinyint(1) NOT NULL DEFAULT '0',
  `default_category_domains` int(10) unsigned NOT NULL DEFAULT '0',
  `default_category_ssl` int(10) unsigned NOT NULL DEFAULT '0',
  `default_dns` int(10) unsigned NOT NULL DEFAULT '0',
  `default_host` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ip_address_domains` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ip_address_ssl` int(10) unsigned NOT NULL DEFAULT '0',
  `default_owner_domains` int(10) unsigned NOT NULL DEFAULT '0',
  `default_owner_ssl` int(10) unsigned NOT NULL DEFAULT '0',
  `default_registrar` int(10) unsigned NOT NULL DEFAULT '0',
  `default_registrar_account` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ssl_provider_account` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ssl_type` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ssl_provider` int(10) unsigned NOT NULL DEFAULT '0',
  `expiration_days` int(3) NOT NULL DEFAULT '60',
  `email_signature` int(10) unsigned NOT NULL DEFAULT '1',
  `currency_converter` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'fcra',
  `use_smtp` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_server` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `smtp_protocol` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'tls',
  `smtp_port` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '587',
  `smtp_email_address` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `smtp_username` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `smtp_password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `debug_mode` tinyint(1) NOT NULL DEFAULT '0',
  `local_php_log` tinyint(1) NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` VALUES
(1, '[[softurl]]', '4.23.0', 0, '[[admin_email]]', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 1, 'fcra', 0, '', 'tls', '587', '', '', '', 0, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `ssl_accounts`
--

CREATE TABLE `ssl_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned NOT NULL,
  `ssl_provider_id` int(10) unsigned NOT NULL,
  `email_address` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `reseller` tinyint(1) NOT NULL DEFAULT '0',
  `reseller_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`),
  KEY `ssl_provider_id` (`ssl_provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ssl_certs`
--

CREATE TABLE `ssl_certs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) unsigned NOT NULL,
  `ssl_provider_id` int(10) unsigned NOT NULL,
  `account_id` int(10) unsigned NOT NULL,
  `domain_id` int(10) unsigned NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `ip_id` int(10) unsigned NOT NULL,
  `cat_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `expiry_date` date NOT NULL DEFAULT '1970-01-01',
  `fee_id` int(10) unsigned NOT NULL,
  `total_cost` decimal(10,2) NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(2) NOT NULL DEFAULT '1',
  `fee_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ssl_cert_fields`
--

CREATE TABLE `ssl_cert_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(75) COLLATE utf8_unicode_ci NOT NULL,
  `field_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ssl_cert_field_data`
--

CREATE TABLE `ssl_cert_field_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ssl_id` int(10) unsigned NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ssl_cert_types`
--

CREATE TABLE `ssl_cert_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `ssl_cert_types`
--

INSERT INTO `ssl_cert_types` VALUES
(1, 'Web Server SSL/TLS Certificate', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00'),
(2, 'S/MIME and Authentication Certificate', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00'),
(3, 'Object Code Signing Certificate', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00'),
(4, 'Digital ID', '', 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `ssl_fees`
--

CREATE TABLE `ssl_fees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ssl_provider_id` int(10) unsigned NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `initial_fee` decimal(10,2) NOT NULL,
  `renewal_fee` decimal(10,2) NOT NULL,
  `misc_fee` decimal(10,2) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `fee_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ssl_providers`
--

CREATE TABLE `ssl_providers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `timezones`
--

CREATE TABLE `timezones` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `timezone` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=517 ;

--
-- Dumping data for table `timezones`
--

INSERT INTO `timezones` VALUES
(1, 'Africa/Abidjan', '[[regtime]]'),
(2, 'Africa/Accra', '[[regtime]]'),
(3, 'Africa/Addis_Ababa', '[[regtime]]'),
(4, 'Africa/Algiers', '[[regtime]]'),
(5, 'Africa/Asmara', '[[regtime]]'),
(6, 'Africa/Asmera', '[[regtime]]'),
(7, 'Africa/Bamako', '[[regtime]]'),
(8, 'Africa/Bangui', '[[regtime]]'),
(9, 'Africa/Banjul', '[[regtime]]'),
(10, 'Africa/Bissau', '[[regtime]]'),
(11, 'Africa/Blantyre', '[[regtime]]'),
(12, 'Africa/Brazzaville', '[[regtime]]'),
(13, 'Africa/Bujumbura', '[[regtime]]'),
(14, 'Africa/Cairo', '[[regtime]]'),
(15, 'Africa/Casablanca', '[[regtime]]'),
(16, 'Africa/Ceuta', '[[regtime]]'),
(17, 'Africa/Conakry', '[[regtime]]'),
(18, 'Africa/Dakar', '[[regtime]]'),
(19, 'Africa/Dar_es_Salaam', '[[regtime]]'),
(20, 'Africa/Djibouti', '[[regtime]]'),
(21, 'Africa/Douala', '[[regtime]]'),
(22, 'Africa/El_Aaiun', '[[regtime]]'),
(23, 'Africa/Freetown', '[[regtime]]'),
(24, 'Africa/Gaborone', '[[regtime]]'),
(25, 'Africa/Harare', '[[regtime]]'),
(26, 'Africa/Johannesburg', '[[regtime]]'),
(27, 'Africa/Juba', '[[regtime]]'),
(28, 'Africa/Kampala', '[[regtime]]'),
(29, 'Africa/Khartoum', '[[regtime]]'),
(30, 'Africa/Kigali', '[[regtime]]'),
(31, 'Africa/Kinshasa', '[[regtime]]'),
(32, 'Africa/Lagos', '[[regtime]]'),
(33, 'Africa/Libreville', '[[regtime]]'),
(34, 'Africa/Lome', '[[regtime]]'),
(35, 'Africa/Luanda', '[[regtime]]'),
(36, 'Africa/Lubumbashi', '[[regtime]]'),
(37, 'Africa/Lusaka', '[[regtime]]'),
(38, 'Africa/Malabo', '[[regtime]]'),
(39, 'Africa/Maputo', '[[regtime]]'),
(40, 'Africa/Maseru', '[[regtime]]'),
(41, 'Africa/Mbabane', '[[regtime]]'),
(42, 'Africa/Mogadishu', '[[regtime]]'),
(43, 'Africa/Monrovia', '[[regtime]]'),
(44, 'Africa/Nairobi', '[[regtime]]'),
(45, 'Africa/Ndjamena', '[[regtime]]'),
(46, 'Africa/Niamey', '[[regtime]]'),
(47, 'Africa/Nouakchott', '[[regtime]]'),
(48, 'Africa/Ouagadougou', '[[regtime]]'),
(49, 'Africa/Porto-Novo', '[[regtime]]'),
(50, 'Africa/Sao_Tome', '[[regtime]]'),
(51, 'Africa/Timbuktu', '[[regtime]]'),
(52, 'Africa/Tripoli', '[[regtime]]'),
(53, 'Africa/Tunis', '[[regtime]]'),
(54, 'Africa/Windhoek', '[[regtime]]'),
(55, 'America/Adak', '[[regtime]]'),
(56, 'America/Anchorage', '[[regtime]]'),
(57, 'America/Anguilla', '[[regtime]]'),
(58, 'America/Antigua', '[[regtime]]'),
(59, 'America/Araguaina', '[[regtime]]'),
(60, 'America/Argentina/Buenos_Aires', '[[regtime]]'),
(61, 'America/Argentina/Catamarca', '[[regtime]]'),
(62, 'America/Argentina/ComodRivadavia', '[[regtime]]'),
(63, 'America/Argentina/Cordoba', '[[regtime]]'),
(64, 'America/Argentina/Jujuy', '[[regtime]]'),
(65, 'America/Argentina/La_Rioja', '[[regtime]]'),
(66, 'America/Argentina/Mendoza', '[[regtime]]'),
(67, 'America/Argentina/Rio_Gallegos', '[[regtime]]'),
(68, 'America/Argentina/Salta', '[[regtime]]'),
(69, 'America/Argentina/San_Juan', '[[regtime]]'),
(70, 'America/Argentina/San_Luis', '[[regtime]]'),
(71, 'America/Argentina/Tucuman', '[[regtime]]'),
(72, 'America/Argentina/Ushuaia', '[[regtime]]'),
(73, 'America/Aruba', '[[regtime]]'),
(74, 'America/Asuncion', '[[regtime]]'),
(75, 'America/Atikokan', '[[regtime]]'),
(76, 'America/Atka', '[[regtime]]'),
(77, 'America/Bahia', '[[regtime]]'),
(78, 'America/Bahia_Banderas', '[[regtime]]'),
(79, 'America/Barbados', '[[regtime]]'),
(80, 'America/Belem', '[[regtime]]'),
(81, 'America/Belize', '[[regtime]]'),
(82, 'America/Blanc-Sablon', '[[regtime]]'),
(83, 'America/Boa_Vista', '[[regtime]]'),
(84, 'America/Bogota', '[[regtime]]'),
(85, 'America/Boise', '[[regtime]]'),
(86, 'America/Buenos_Aires', '[[regtime]]'),
(87, 'America/Cambridge_Bay', '[[regtime]]'),
(88, 'America/Campo_Grande', '[[regtime]]'),
(89, 'America/Cancun', '[[regtime]]'),
(90, 'America/Caracas', '[[regtime]]'),
(91, 'America/Catamarca', '[[regtime]]'),
(92, 'America/Cayenne', '[[regtime]]'),
(93, 'America/Cayman', '[[regtime]]'),
(94, 'America/Chicago', '[[regtime]]'),
(95, 'America/Chihuahua', '[[regtime]]'),
(96, 'America/Coral_Harbour', '[[regtime]]'),
(97, 'America/Cordoba', '[[regtime]]'),
(98, 'America/Costa_Rica', '[[regtime]]'),
(99, 'America/Creston', '[[regtime]]'),
(100, 'America/Cuiaba', '[[regtime]]'),
(101, 'America/Curacao', '[[regtime]]'),
(102, 'America/Danmarkshavn', '[[regtime]]'),
(103, 'America/Dawson', '[[regtime]]'),
(104, 'America/Dawson_Creek', '[[regtime]]'),
(105, 'America/Denver', '[[regtime]]'),
(106, 'America/Detroit', '[[regtime]]'),
(107, 'America/Dominica', '[[regtime]]'),
(108, 'America/Edmonton', '[[regtime]]'),
(109, 'America/Eirunepe', '[[regtime]]'),
(110, 'America/El_Salvador', '[[regtime]]'),
(111, 'America/Ensenada', '[[regtime]]'),
(112, 'America/Fort_Wayne', '[[regtime]]'),
(113, 'America/Fortaleza', '[[regtime]]'),
(114, 'America/Glace_Bay', '[[regtime]]'),
(115, 'America/Godthab', '[[regtime]]'),
(116, 'America/Goose_Bay', '[[regtime]]'),
(117, 'America/Grand_Turk', '[[regtime]]'),
(118, 'America/Grenada', '[[regtime]]'),
(119, 'America/Guadeloupe', '[[regtime]]'),
(120, 'America/Guatemala', '[[regtime]]'),
(121, 'America/Guayaquil', '[[regtime]]'),
(122, 'America/Guyana', '[[regtime]]'),
(123, 'America/Halifax', '[[regtime]]'),
(124, 'America/Havana', '[[regtime]]'),
(125, 'America/Hermosillo', '[[regtime]]'),
(126, 'America/Indiana/Indianapolis', '[[regtime]]'),
(127, 'America/Indiana/Knox', '[[regtime]]'),
(128, 'America/Indiana/Marengo', '[[regtime]]'),
(129, 'America/Indiana/Petersburg', '[[regtime]]'),
(130, 'America/Indiana/Tell_City', '[[regtime]]'),
(131, 'America/Indiana/Vevay', '[[regtime]]'),
(132, 'America/Indiana/Vincennes', '[[regtime]]'),
(133, 'America/Indiana/Winamac', '[[regtime]]'),
(134, 'America/Indianapolis', '[[regtime]]'),
(135, 'America/Inuvik', '[[regtime]]'),
(136, 'America/Iqaluit', '[[regtime]]'),
(137, 'America/Jamaica', '[[regtime]]'),
(138, 'America/Jujuy', '[[regtime]]'),
(139, 'America/Juneau', '[[regtime]]'),
(140, 'America/Kentucky/Louisville', '[[regtime]]'),
(141, 'America/Kentucky/Monticello', '[[regtime]]'),
(142, 'America/Knox_IN', '[[regtime]]'),
(143, 'America/Kralendijk', '[[regtime]]'),
(144, 'America/La_Paz', '[[regtime]]'),
(145, 'America/Lima', '[[regtime]]'),
(146, 'America/Los_Angeles', '[[regtime]]'),
(147, 'America/Louisville', '[[regtime]]'),
(148, 'America/Lower_Princes', '[[regtime]]'),
(149, 'America/Maceio', '[[regtime]]'),
(150, 'America/Managua', '[[regtime]]'),
(151, 'America/Manaus', '[[regtime]]'),
(152, 'America/Marigot', '[[regtime]]'),
(153, 'America/Martinique', '[[regtime]]'),
(154, 'America/Matamoros', '[[regtime]]'),
(155, 'America/Mazatlan', '[[regtime]]'),
(156, 'America/Mendoza', '[[regtime]]'),
(157, 'America/Menominee', '[[regtime]]'),
(158, 'America/Merida', '[[regtime]]'),
(159, 'America/Metlakatla', '[[regtime]]'),
(160, 'America/Mexico_City', '[[regtime]]'),
(161, 'America/Miquelon', '[[regtime]]'),
(162, 'America/Moncton', '[[regtime]]'),
(163, 'America/Monterrey', '[[regtime]]'),
(164, 'America/Montevideo', '[[regtime]]'),
(165, 'America/Montreal', '[[regtime]]'),
(166, 'America/Montserrat', '[[regtime]]'),
(167, 'America/Nassau', '[[regtime]]'),
(168, 'America/New_York', '[[regtime]]'),
(169, 'America/Nipigon', '[[regtime]]'),
(170, 'America/Nome', '[[regtime]]'),
(171, 'America/Noronha', '[[regtime]]'),
(172, 'America/North_Dakota/Beulah', '[[regtime]]'),
(173, 'America/North_Dakota/Center', '[[regtime]]'),
(174, 'America/North_Dakota/New_Salem', '[[regtime]]'),
(175, 'America/Ojinaga', '[[regtime]]'),
(176, 'America/Panama', '[[regtime]]'),
(177, 'America/Pangnirtung', '[[regtime]]'),
(178, 'America/Paramaribo', '[[regtime]]'),
(179, 'America/Phoenix', '[[regtime]]'),
(180, 'America/Port-au-Prince', '[[regtime]]'),
(181, 'America/Port_of_Spain', '[[regtime]]'),
(182, 'America/Porto_Acre', '[[regtime]]'),
(183, 'America/Porto_Velho', '[[regtime]]'),
(184, 'America/Puerto_Rico', '[[regtime]]'),
(185, 'America/Rainy_River', '[[regtime]]'),
(186, 'America/Rankin_Inlet', '[[regtime]]'),
(187, 'America/Recife', '[[regtime]]'),
(188, 'America/Regina', '[[regtime]]'),
(189, 'America/Resolute', '[[regtime]]'),
(190, 'America/Rio_Branco', '[[regtime]]'),
(191, 'America/Rosario', '[[regtime]]'),
(192, 'America/Santa_Isabel', '[[regtime]]'),
(193, 'America/Santarem', '[[regtime]]'),
(194, 'America/Santiago', '[[regtime]]'),
(195, 'America/Santo_Domingo', '[[regtime]]'),
(196, 'America/Sao_Paulo', '[[regtime]]'),
(197, 'America/Scoresbysund', '[[regtime]]'),
(198, 'America/Shiprock', '[[regtime]]'),
(199, 'America/Sitka', '[[regtime]]'),
(200, 'America/St_Barthelemy', '[[regtime]]'),
(201, 'America/St_Johns', '[[regtime]]'),
(202, 'America/St_Kitts', '[[regtime]]'),
(203, 'America/St_Lucia', '[[regtime]]'),
(204, 'America/St_Thomas', '[[regtime]]'),
(205, 'America/St_Vincent', '[[regtime]]'),
(206, 'America/Swift_Current', '[[regtime]]'),
(207, 'America/Tegucigalpa', '[[regtime]]'),
(208, 'America/Thule', '[[regtime]]'),
(209, 'America/Thunder_Bay', '[[regtime]]'),
(210, 'America/Tijuana', '[[regtime]]'),
(211, 'America/Toronto', '[[regtime]]'),
(212, 'America/Tortola', '[[regtime]]'),
(213, 'America/Vancouver', '[[regtime]]'),
(214, 'America/Virgin', '[[regtime]]'),
(215, 'America/Whitehorse', '[[regtime]]'),
(216, 'America/Winnipeg', '[[regtime]]'),
(217, 'America/Yakutat', '[[regtime]]'),
(218, 'America/Yellowknife', '[[regtime]]'),
(219, 'Antarctica/Casey', '[[regtime]]'),
(220, 'Antarctica/Davis', '[[regtime]]'),
(221, 'Antarctica/DumontDUrville', '[[regtime]]'),
(222, 'Antarctica/Macquarie', '[[regtime]]'),
(223, 'Antarctica/Mawson', '[[regtime]]'),
(224, 'Antarctica/McMurdo', '[[regtime]]'),
(225, 'Antarctica/Palmer', '[[regtime]]'),
(226, 'Antarctica/Rothera', '[[regtime]]'),
(227, 'Antarctica/South_Pole', '[[regtime]]'),
(228, 'Antarctica/Syowa', '[[regtime]]'),
(229, 'Antarctica/Vostok', '[[regtime]]'),
(230, 'Arctic/Longyearbyen', '[[regtime]]'),
(231, 'Asia/Aden', '[[regtime]]'),
(232, 'Asia/Almaty', '[[regtime]]'),
(233, 'Asia/Amman', '[[regtime]]'),
(234, 'Asia/Anadyr', '[[regtime]]'),
(235, 'Asia/Aqtau', '[[regtime]]'),
(236, 'Asia/Aqtobe', '[[regtime]]'),
(237, 'Asia/Ashgabat', '[[regtime]]'),
(238, 'Asia/Ashkhabad', '[[regtime]]'),
(239, 'Asia/Baghdad', '[[regtime]]'),
(240, 'Asia/Bahrain', '[[regtime]]'),
(241, 'Asia/Baku', '[[regtime]]'),
(242, 'Asia/Bangkok', '[[regtime]]'),
(243, 'Asia/Beirut', '[[regtime]]'),
(244, 'Asia/Bishkek', '[[regtime]]'),
(245, 'Asia/Brunei', '[[regtime]]'),
(246, 'Asia/Calcutta', '[[regtime]]'),
(247, 'Asia/Choibalsan', '[[regtime]]'),
(248, 'Asia/Chongqing', '[[regtime]]'),
(249, 'Asia/Chungking', '[[regtime]]'),
(250, 'Asia/Colombo', '[[regtime]]'),
(251, 'Asia/Dacca', '[[regtime]]'),
(252, 'Asia/Damascus', '[[regtime]]'),
(253, 'Asia/Dhaka', '[[regtime]]'),
(254, 'Asia/Dili', '[[regtime]]'),
(255, 'Asia/Dubai', '[[regtime]]'),
(256, 'Asia/Dushanbe', '[[regtime]]'),
(257, 'Asia/Gaza', '[[regtime]]'),
(258, 'Asia/Harbin', '[[regtime]]'),
(259, 'Asia/Hebron', '[[regtime]]'),
(260, 'Asia/Ho_Chi_Minh', '[[regtime]]'),
(261, 'Asia/Hong_Kong', '[[regtime]]'),
(262, 'Asia/Hovd', '[[regtime]]'),
(263, 'Asia/Irkutsk', '[[regtime]]'),
(264, 'Asia/Istanbul', '[[regtime]]'),
(265, 'Asia/Jakarta', '[[regtime]]'),
(266, 'Asia/Jayapura', '[[regtime]]'),
(267, 'Asia/Jerusalem', '[[regtime]]'),
(268, 'Asia/Kabul', '[[regtime]]'),
(269, 'Asia/Kamchatka', '[[regtime]]'),
(270, 'Asia/Karachi', '[[regtime]]'),
(271, 'Asia/Kashgar', '[[regtime]]'),
(272, 'Asia/Kathmandu', '[[regtime]]'),
(273, 'Asia/Katmandu', '[[regtime]]'),
(274, 'Asia/Khandyga', '[[regtime]]'),
(275, 'Asia/Kolkata', '[[regtime]]'),
(276, 'Asia/Krasnoyarsk', '[[regtime]]'),
(277, 'Asia/Kuala_Lumpur', '[[regtime]]'),
(278, 'Asia/Kuching', '[[regtime]]'),
(279, 'Asia/Kuwait', '[[regtime]]'),
(280, 'Asia/Macao', '[[regtime]]'),
(281, 'Asia/Macau', '[[regtime]]'),
(282, 'Asia/Magadan', '[[regtime]]'),
(283, 'Asia/Makassar', '[[regtime]]'),
(284, 'Asia/Manila', '[[regtime]]'),
(285, 'Asia/Muscat', '[[regtime]]'),
(286, 'Asia/Nicosia', '[[regtime]]'),
(287, 'Asia/Novokuznetsk', '[[regtime]]'),
(288, 'Asia/Novosibirsk', '[[regtime]]'),
(289, 'Asia/Omsk', '[[regtime]]'),
(290, 'Asia/Oral', '[[regtime]]'),
(291, 'Asia/Phnom_Penh', '[[regtime]]'),
(292, 'Asia/Pontianak', '[[regtime]]'),
(293, 'Asia/Pyongyang', '[[regtime]]'),
(294, 'Asia/Qatar', '[[regtime]]'),
(295, 'Asia/Qyzylorda', '[[regtime]]'),
(296, 'Asia/Rangoon', '[[regtime]]'),
(297, 'Asia/Riyadh', '[[regtime]]'),
(298, 'Asia/Saigon', '[[regtime]]'),
(299, 'Asia/Sakhalin', '[[regtime]]'),
(300, 'Asia/Samarkand', '[[regtime]]'),
(301, 'Asia/Seoul', '[[regtime]]'),
(302, 'Asia/Shanghai', '[[regtime]]'),
(303, 'Asia/Singapore', '[[regtime]]'),
(304, 'Asia/Taipei', '[[regtime]]'),
(305, 'Asia/Tashkent', '[[regtime]]'),
(306, 'Asia/Tbilisi', '[[regtime]]'),
(307, 'Asia/Tehran', '[[regtime]]'),
(308, 'Asia/Tel_Aviv', '[[regtime]]'),
(309, 'Asia/Thimbu', '[[regtime]]'),
(310, 'Asia/Thimphu', '[[regtime]]'),
(311, 'Asia/Tokyo', '[[regtime]]'),
(312, 'Asia/Ujung_Pandang', '[[regtime]]'),
(313, 'Asia/Ulaanbaatar', '[[regtime]]'),
(314, 'Asia/Ulan_Bator', '[[regtime]]'),
(315, 'Asia/Urumqi', '[[regtime]]'),
(316, 'Asia/Ust-Nera', '[[regtime]]'),
(317, 'Asia/Vientiane', '[[regtime]]'),
(318, 'Asia/Vladivostok', '[[regtime]]'),
(319, 'Asia/Yakutsk', '[[regtime]]'),
(320, 'Asia/Yekaterinburg', '[[regtime]]'),
(321, 'Asia/Yerevan', '[[regtime]]'),
(322, 'Atlantic/Azores', '[[regtime]]'),
(323, 'Atlantic/Bermuda', '[[regtime]]'),
(324, 'Atlantic/Canary', '[[regtime]]'),
(325, 'Atlantic/Cape_Verde', '[[regtime]]'),
(326, 'Atlantic/Faeroe', '[[regtime]]'),
(327, 'Atlantic/Faroe', '[[regtime]]'),
(328, 'Atlantic/Jan_Mayen', '[[regtime]]'),
(329, 'Atlantic/Madeira', '[[regtime]]'),
(330, 'Atlantic/Reykjavik', '[[regtime]]'),
(331, 'Atlantic/South_Georgia', '[[regtime]]'),
(332, 'Atlantic/St_Helena', '[[regtime]]'),
(333, 'Atlantic/Stanley', '[[regtime]]'),
(334, 'Australia/ACT', '[[regtime]]'),
(335, 'Australia/Adelaide', '[[regtime]]'),
(336, 'Australia/Brisbane', '[[regtime]]'),
(337, 'Australia/Broken_Hill', '[[regtime]]'),
(338, 'Australia/Canberra', '[[regtime]]'),
(339, 'Australia/Currie', '[[regtime]]'),
(340, 'Australia/Darwin', '[[regtime]]'),
(341, 'Australia/Eucla', '[[regtime]]'),
(342, 'Australia/Hobart', '[[regtime]]'),
(343, 'Australia/LHI', '[[regtime]]'),
(344, 'Australia/Lindeman', '[[regtime]]'),
(345, 'Australia/Lord_Howe', '[[regtime]]'),
(346, 'Australia/Melbourne', '[[regtime]]'),
(347, 'Australia/North', '[[regtime]]'),
(348, 'Australia/NSW', '[[regtime]]'),
(349, 'Australia/Perth', '[[regtime]]'),
(350, 'Australia/Queensland', '[[regtime]]'),
(351, 'Australia/South', '[[regtime]]'),
(352, 'Australia/Sydney', '[[regtime]]'),
(353, 'Australia/Tasmania', '[[regtime]]'),
(354, 'Australia/Victoria', '[[regtime]]'),
(355, 'Australia/West', '[[regtime]]'),
(356, 'Australia/Yancowinna', '[[regtime]]'),
(357, 'Brazil/Acre', '[[regtime]]'),
(358, 'Brazil/DeNoronha', '[[regtime]]'),
(359, 'Brazil/East', '[[regtime]]'),
(360, 'Brazil/West', '[[regtime]]'),
(361, 'Canada/Atlantic', '[[regtime]]'),
(362, 'Canada/Central', '[[regtime]]'),
(363, 'Canada/East-Saskatchewan', '[[regtime]]'),
(364, 'Canada/Eastern', '[[regtime]]'),
(365, 'Canada/Mountain', '[[regtime]]'),
(366, 'Canada/Newfoundland', '[[regtime]]'),
(367, 'Canada/Pacific', '[[regtime]]'),
(368, 'Canada/Saskatchewan', '[[regtime]]'),
(369, 'Canada/Yukon', '[[regtime]]'),
(370, 'Chile/Continental', '[[regtime]]'),
(371, 'Chile/EasterIsland', '[[regtime]]'),
(372, 'Cuba', '[[regtime]]'),
(373, 'Egypt', '[[regtime]]'),
(374, 'Eire', '[[regtime]]'),
(375, 'Europe/Amsterdam', '[[regtime]]'),
(376, 'Europe/Andorra', '[[regtime]]'),
(377, 'Europe/Athens', '[[regtime]]'),
(378, 'Europe/Belfast', '[[regtime]]'),
(379, 'Europe/Belgrade', '[[regtime]]'),
(380, 'Europe/Berlin', '[[regtime]]'),
(381, 'Europe/Bratislava', '[[regtime]]'),
(382, 'Europe/Brussels', '[[regtime]]'),
(383, 'Europe/Bucharest', '[[regtime]]'),
(384, 'Europe/Budapest', '[[regtime]]'),
(385, 'Europe/Busingen', '[[regtime]]'),
(386, 'Europe/Chisinau', '[[regtime]]'),
(387, 'Europe/Copenhagen', '[[regtime]]'),
(388, 'Europe/Dublin', '[[regtime]]'),
(389, 'Europe/Gibraltar', '[[regtime]]'),
(390, 'Europe/Guernsey', '[[regtime]]'),
(391, 'Europe/Helsinki', '[[regtime]]'),
(392, 'Europe/Isle_of_Man', '[[regtime]]'),
(393, 'Europe/Istanbul', '[[regtime]]'),
(394, 'Europe/Jersey', '[[regtime]]'),
(395, 'Europe/Kaliningrad', '[[regtime]]'),
(396, 'Europe/Kiev', '[[regtime]]'),
(397, 'Europe/Lisbon', '[[regtime]]'),
(398, 'Europe/Ljubljana', '[[regtime]]'),
(399, 'Europe/London', '[[regtime]]'),
(400, 'Europe/Luxembourg', '[[regtime]]'),
(401, 'Europe/Madrid', '[[regtime]]'),
(402, 'Europe/Malta', '[[regtime]]'),
(403, 'Europe/Mariehamn', '[[regtime]]'),
(404, 'Europe/Minsk', '[[regtime]]'),
(405, 'Europe/Monaco', '[[regtime]]'),
(406, 'Europe/Moscow', '[[regtime]]'),
(407, 'Europe/Nicosia', '[[regtime]]'),
(408, 'Europe/Oslo', '[[regtime]]'),
(409, 'Europe/Paris', '[[regtime]]'),
(410, 'Europe/Podgorica', '[[regtime]]'),
(411, 'Europe/Prague', '[[regtime]]'),
(412, 'Europe/Riga', '[[regtime]]'),
(413, 'Europe/Rome', '[[regtime]]'),
(414, 'Europe/Samara', '[[regtime]]'),
(415, 'Europe/San_Marino', '[[regtime]]'),
(416, 'Europe/Sarajevo', '[[regtime]]'),
(417, 'Europe/Simferopol', '[[regtime]]'),
(418, 'Europe/Skopje', '[[regtime]]'),
(419, 'Europe/Sofia', '[[regtime]]'),
(420, 'Europe/Stockholm', '[[regtime]]'),
(421, 'Europe/Tallinn', '[[regtime]]'),
(422, 'Europe/Tirane', '[[regtime]]'),
(423, 'Europe/Tiraspol', '[[regtime]]'),
(424, 'Europe/Uzhgorod', '[[regtime]]'),
(425, 'Europe/Vaduz', '[[regtime]]'),
(426, 'Europe/Vatican', '[[regtime]]'),
(427, 'Europe/Vienna', '[[regtime]]'),
(428, 'Europe/Vilnius', '[[regtime]]'),
(429, 'Europe/Volgograd', '[[regtime]]'),
(430, 'Europe/Warsaw', '[[regtime]]'),
(431, 'Europe/Zagreb', '[[regtime]]'),
(432, 'Europe/Zaporozhye', '[[regtime]]'),
(433, 'Europe/Zurich', '[[regtime]]'),
(434, 'Greenwich', '[[regtime]]'),
(435, 'Hongkong', '[[regtime]]'),
(436, 'Iceland', '[[regtime]]'),
(437, 'Indian/Antananarivo', '[[regtime]]'),
(438, 'Indian/Chagos', '[[regtime]]'),
(439, 'Indian/Christmas', '[[regtime]]'),
(440, 'Indian/Cocos', '[[regtime]]'),
(441, 'Indian/Comoro', '[[regtime]]'),
(442, 'Indian/Kerguelen', '[[regtime]]'),
(443, 'Indian/Mahe', '[[regtime]]'),
(444, 'Indian/Maldives', '[[regtime]]'),
(445, 'Indian/Mauritius', '[[regtime]]'),
(446, 'Indian/Mayotte', '[[regtime]]'),
(447, 'Indian/Reunion', '[[regtime]]'),
(448, 'Iran', '[[regtime]]'),
(449, 'Israel', '[[regtime]]'),
(450, 'Jamaica', '[[regtime]]'),
(451, 'Japan', '[[regtime]]'),
(452, 'Kwajalein', '[[regtime]]'),
(453, 'Libya', '[[regtime]]'),
(454, 'Mexico/BajaNorte', '[[regtime]]'),
(455, 'Mexico/BajaSur', '[[regtime]]'),
(456, 'Mexico/General', '[[regtime]]'),
(457, 'Pacific/Apia', '[[regtime]]'),
(458, 'Pacific/Auckland', '[[regtime]]'),
(459, 'Pacific/Chatham', '[[regtime]]'),
(460, 'Pacific/Chuuk', '[[regtime]]'),
(461, 'Pacific/Easter', '[[regtime]]'),
(462, 'Pacific/Efate', '[[regtime]]'),
(463, 'Pacific/Enderbury', '[[regtime]]'),
(464, 'Pacific/Fakaofo', '[[regtime]]'),
(465, 'Pacific/Fiji', '[[regtime]]'),
(466, 'Pacific/Funafuti', '[[regtime]]'),
(467, 'Pacific/Galapagos', '[[regtime]]'),
(468, 'Pacific/Gambier', '[[regtime]]'),
(469, 'Pacific/Guadalcanal', '[[regtime]]'),
(470, 'Pacific/Guam', '[[regtime]]'),
(471, 'Pacific/Honolulu', '[[regtime]]'),
(472, 'Pacific/Johnston', '[[regtime]]'),
(473, 'Pacific/Kiritimati', '[[regtime]]'),
(474, 'Pacific/Kosrae', '[[regtime]]'),
(475, 'Pacific/Kwajalein', '[[regtime]]'),
(476, 'Pacific/Majuro', '[[regtime]]'),
(477, 'Pacific/Marquesas', '[[regtime]]'),
(478, 'Pacific/Midway', '[[regtime]]'),
(479, 'Pacific/Nauru', '[[regtime]]'),
(480, 'Pacific/Niue', '[[regtime]]'),
(481, 'Pacific/Norfolk', '[[regtime]]'),
(482, 'Pacific/Noumea', '[[regtime]]'),
(483, 'Pacific/Pago_Pago', '[[regtime]]'),
(484, 'Pacific/Palau', '[[regtime]]'),
(485, 'Pacific/Pitcairn', '[[regtime]]'),
(486, 'Pacific/Pohnpei', '[[regtime]]'),
(487, 'Pacific/Ponape', '[[regtime]]'),
(488, 'Pacific/Port_Moresby', '[[regtime]]'),
(489, 'Pacific/Rarotonga', '[[regtime]]'),
(490, 'Pacific/Saipan', '[[regtime]]'),
(491, 'Pacific/Samoa', '[[regtime]]'),
(492, 'Pacific/Tahiti', '[[regtime]]'),
(493, 'Pacific/Tarawa', '[[regtime]]'),
(494, 'Pacific/Tongatapu', '[[regtime]]'),
(495, 'Pacific/Truk', '[[regtime]]'),
(496, 'Pacific/Wake', '[[regtime]]'),
(497, 'Pacific/Wallis', '[[regtime]]'),
(498, 'Pacific/Yap', '[[regtime]]'),
(499, 'Poland', '[[regtime]]'),
(500, 'Portugal', '[[regtime]]'),
(501, 'Singapore', '[[regtime]]'),
(502, 'Turkey', '[[regtime]]'),
(503, 'US/Alaska', '[[regtime]]'),
(504, 'US/Aleutian', '[[regtime]]'),
(505, 'US/Arizona', '[[regtime]]'),
(506, 'US/Central', '[[regtime]]'),
(507, 'US/East-Indiana', '[[regtime]]'),
(508, 'US/Eastern', '[[regtime]]'),
(509, 'US/Hawaii', '[[regtime]]'),
(510, 'US/Indiana-Starke', '[[regtime]]'),
(511, 'US/Michigan', '[[regtime]]'),
(512, 'US/Mountain', '[[regtime]]'),
(513, 'US/Pacific', '[[regtime]]'),
(514, 'US/Pacific-New', '[[regtime]]'),
(515, 'US/Samoa', '[[regtime]]'),
(516, 'Zulu', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `last_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `username` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `email_address` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `new_password` tinyint(1) NOT NULL DEFAULT '1',
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `read_only` tinyint(1) NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `number_of_logins` int(10) unsigned NOT NULL DEFAULT '0',
  `last_login` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `creation_type_id` tinyint(2) NOT NULL DEFAULT '2',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, 'Domain', 'Administrator', 'admin', '[[admin_email]]', CONCAT('*', UPPER(SHA1(UNHEX(SHA1('[[admin_pass]]'))))), 0, 1, 0, 1, 0, '1970-01-01 00:00:00', 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `user_settings`
--

CREATE TABLE `user_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `default_language` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en_US.UTF-8',
  `default_currency` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `default_timezone` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'America/New_York',
  `default_category_domains` int(10) unsigned NOT NULL DEFAULT '0',
  `default_category_ssl` int(10) unsigned NOT NULL DEFAULT '0',
  `default_dns` int(10) unsigned NOT NULL DEFAULT '0',
  `default_host` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ip_address_domains` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ip_address_ssl` int(10) unsigned NOT NULL DEFAULT '0',
  `default_owner_domains` int(10) unsigned NOT NULL DEFAULT '0',
  `default_owner_ssl` int(10) unsigned NOT NULL DEFAULT '0',
  `default_registrar` int(10) unsigned NOT NULL DEFAULT '0',
  `default_registrar_account` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ssl_provider_account` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ssl_type` int(10) unsigned NOT NULL DEFAULT '0',
  `default_ssl_provider` int(10) unsigned NOT NULL DEFAULT '0',
  `expiration_emails` tinyint(1) NOT NULL DEFAULT '0',
  `number_of_domains` int(5) NOT NULL DEFAULT '50',
  `number_of_ssl_certs` int(5) NOT NULL DEFAULT '50',
  `display_domain_owner` tinyint(1) NOT NULL DEFAULT '0',
  `display_domain_registrar` tinyint(1) NOT NULL DEFAULT '0',
  `display_domain_account` tinyint(1) NOT NULL DEFAULT '1',
  `display_domain_expiry_date` tinyint(1) NOT NULL DEFAULT '1',
  `display_domain_category` tinyint(1) NOT NULL DEFAULT '1',
  `display_domain_dns` tinyint(1) NOT NULL DEFAULT '1',
  `display_domain_host` tinyint(1) NOT NULL DEFAULT '0',
  `display_domain_ip` tinyint(1) NOT NULL DEFAULT '0',
  `display_domain_tld` tinyint(1) NOT NULL DEFAULT '1',
  `display_domain_fee` tinyint(1) NOT NULL DEFAULT '1',
  `display_ssl_owner` tinyint(1) NOT NULL DEFAULT '1',
  `display_ssl_provider` tinyint(1) NOT NULL DEFAULT '0',
  `display_ssl_account` tinyint(1) NOT NULL DEFAULT '1',
  `display_ssl_domain` tinyint(1) NOT NULL DEFAULT '1',
  `display_ssl_type` tinyint(1) NOT NULL DEFAULT '1',
  `display_ssl_expiry_date` tinyint(1) NOT NULL DEFAULT '1',
  `display_ssl_ip` tinyint(1) NOT NULL DEFAULT '0',
  `display_ssl_category` tinyint(1) NOT NULL DEFAULT '0',
  `display_ssl_fee` tinyint(1) NOT NULL DEFAULT '0',
  `display_inactive_assets` tinyint(1) NOT NULL DEFAULT '1',
  `display_dw_intro_page` tinyint(1) NOT NULL DEFAULT '1',
  `dark_mode` tinyint(1) NOT NULL DEFAULT '0',
  `insert_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_settings`
--

INSERT INTO `user_settings` VALUES
(1, 1, 'en_US.UTF-8', 'USD', 'America/New_York', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 50, 50, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, '[[regtime]]', '1970-01-01 00:00:00');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
