
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cube6512`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_404_log`
--

CREATE TABLE `[[dbprefix]]CubeCart_404_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(510) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `done` tinyint(1) NOT NULL DEFAULT '0',
  `warn` tinyint(1) NOT NULL DEFAULT '0',
  `ignore` tinyint(1) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uri` (`uri`),
  KEY `ignore` (`ignore`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_access_log`
--

CREATE TABLE `[[dbprefix]]CubeCart_access_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Supports IPv6 addresses',
  `useragent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `success` enum('Y','N') COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `type` (`type`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_addressbook`
--

CREATE TABLE `[[dbprefix]]CubeCart_addressbook` (
  `address_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `billing` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `default` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `description` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `line1` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `line2` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `town` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `postcode` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` smallint(3) unsigned NOT NULL,
  `w3w` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`address_id`),
  KEY `customer_id` (`customer_id`),
  KEY `billing` (`billing`),
  KEY `default` (`default`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_admin_error_log`
--

CREATE TABLE `[[dbprefix]]CubeCart_admin_error_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_admin_log`
--

CREATE TABLE `[[dbprefix]]CubeCart_admin_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_type` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_admin_users`
--

CREATE TABLE `[[dbprefix]]CubeCart_admin_users` (
  `admin_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `salt` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `new_password` tinyint(1) NOT NULL DEFAULT '1',
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `verify` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logins` int(10) unsigned NOT NULL DEFAULT '0',
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `failLevel` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `blockTime` int(10) unsigned NOT NULL DEFAULT '0',
  `lastTime` int(10) unsigned NOT NULL DEFAULT '0',
  `session_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Supports IPv6 addresses',
  `language` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en-GB',
  `dashboard_notes` text COLLATE utf8mb4_unicode_ci,
  `order_notify` tinyint(1) unsigned DEFAULT '0',
  `tour_shown` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`admin_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_admin_users`
--

INSERT INTO `[[dbprefix]]CubeCart_admin_users` VALUES
(1, NULL, 1, '[[admin_realname]]', '[[admin_username]]', '[[admin_pass]]', '[[salt]]', 1, '[[admin_email]]', NULL, 0, 1, NULL, 0, 0, 0, NULL, NULL, NULL, 'en-GB', NULL, 1, '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_alt_shipping`
--

CREATE TABLE `[[dbprefix]]CubeCart_alt_shipping` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` smallint(1) NOT NULL DEFAULT '0',
  `byprice` smallint(1) NOT NULL,
  `global` smallint(1) NOT NULL,
  `notes` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_alt_shipping_prices`
--

CREATE TABLE `[[dbprefix]]CubeCart_alt_shipping_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `alt_ship_id` int(10) unsigned NOT NULL,
  `low` decimal(16,3) NOT NULL DEFAULT '0.000',
  `high` decimal(16,3) NOT NULL DEFAULT '0.000',
  `price` decimal(16,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_blocker`
--

CREATE TABLE `[[dbprefix]]CubeCart_blocker` (
  `block_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `level` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `last_attempt` int(10) unsigned NOT NULL DEFAULT '0',
  `ban_expires` int(10) unsigned NOT NULL DEFAULT '0',
  `username` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Supports IPv6 addresses',
  PRIMARY KEY (`block_id`),
  KEY `location` (`location`),
  KEY `last_attempt` (`last_attempt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_category`
--

CREATE TABLE `[[dbprefix]]CubeCart_category` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cat_desc` text COLLATE utf8mb4_unicode_ci,
  `cat_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cat_image` int(10) NOT NULL,
  `per_ship` decimal(20,2) NOT NULL DEFAULT '0.00',
  `item_ship` decimal(20,2) NOT NULL DEFAULT '0.00',
  `item_int_ship` decimal(20,2) NOT NULL DEFAULT '0.00',
  `per_int_ship` decimal(20,2) NOT NULL DEFAULT '0.00',
  `hide` smallint(1) NOT NULL DEFAULT '0',
  `seo_meta_title` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_description` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_keywords` text COLLATE utf8mb4_unicode_ci,
  `priority` smallint(6) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `cat_hier_position` int(11) NOT NULL DEFAULT '0',
  `cat_parse` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  KEY `cat_parent_id` (`cat_parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_category`
--

INSERT INTO `[[dbprefix]]CubeCart_category` VALUES
(1, 'Test Category', 'This is a test category setup during install. It can be edited or deleted from the store admin control panel.', 0, 0, '0.00', '0.00', '0.00', '0.00', 0, '', '', '', 1, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_category_discount`
--

CREATE TABLE `[[dbprefix]]CubeCart_category_discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `percent` decimal(5,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_id` (`cat_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_category_index`
--

CREATE TABLE `[[dbprefix]]CubeCart_category_index` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `primary` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat_id` (`cat_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_category_index`
--

INSERT INTO `[[dbprefix]]CubeCart_category_index` VALUES
(1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_category_language`
--

CREATE TABLE `[[dbprefix]]CubeCart_category_language` (
  `translation_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `language` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_desc` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_title` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_description` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_keywords` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`translation_id`),
  KEY `cat_id` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_code_snippet`
--

CREATE TABLE `[[dbprefix]]CubeCart_code_snippet` (
  `snippet_id` int(11) NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `unique_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hook_trigger` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `php_code` blob NOT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`snippet_id`),
  UNIQUE KEY `unique_id` (`unique_id`),
  KEY `hook_trigger` (`hook_trigger`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_config`
--

CREATE TABLE `[[dbprefix]]CubeCart_config` (
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `array` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]CubeCart_config`
--

INSERT INTO `[[dbprefix]]CubeCart_config` VALUES
('config', '[[ser_config]]'),
('Contact_Form', '[[Contact_Form]]'),
('logos', 'eyJmb3VuZGF0aW9uZGVmYXVsdCI6InNraW5zXC9mb3VuZGF0aW9uXC9pbWFnZXNcL2RlZmF1bHRcL2xvZ29cL2RlZmF1bHQucG5nIiwiZW1haWxzIjoic2tpbnNcL2ZvdW5kYXRpb25cL2ltYWdlc1wvZGVmYXVsdFwvbG9nb1wvZGVmYXVsdC5wbmciLCJpbnZvaWNlcyI6InNraW5zXC9mb3VuZGF0aW9uXC9pbWFnZXNcL2RlZmF1bHRcL2xvZ29cL2RlZmF1bHQucG5nIn0=');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_cookie_consent`
--

CREATE TABLE `[[dbprefix]]CubeCart_cookie_consent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `dialogue_id` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `url_shown` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ip_address` (`ip_address`),
  KEY `session_id` (`session_id`),
  KEY `customer_id` (`customer_id`),
  KEY `dialogue_id` (`dialogue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_cookie_consent_text`
--

CREATE TABLE `[[dbprefix]]CubeCart_cookie_consent_text` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_coupons`
--

CREATE TABLE `[[dbprefix]]CubeCart_coupons` (
  `coupon_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `archived` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `manufacturer_id` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00',
  `discount_price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `starts` date NOT NULL DEFAULT '0000-00-00',
  `expires` date NOT NULL DEFAULT '0000-00-00',
  `allowed_uses` int(10) unsigned NOT NULL DEFAULT '0',
  `min_subtotal` decimal(16,2) unsigned NOT NULL DEFAULT '0.00',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `shipping` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `free_shipping` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `subtotal` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cart_order_id` varchar(18) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_sent` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `coupon_per_customer` int(10) unsigned DEFAULT NULL,
  `exclude_sale_items` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupon_id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_currency`
--

CREATE TABLE `[[dbprefix]]CubeCart_currency` (
  `currency_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varbinary(255) NOT NULL DEFAULT '',
  `code` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso` int(3) unsigned zerofill DEFAULT NULL,
  `symbol_left` tinyblob,
  `symbol_right` tinyblob,
  `value` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `decimal_places` tinyint(2) unsigned DEFAULT '2',
  `updated` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `symbol_decimal` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `symbol_thousand` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `adjustment` decimal(5,3) NOT NULL DEFAULT '0.000',
  PRIMARY KEY (`currency_id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=32 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_currency`
--

INSERT INTO `[[dbprefix]]CubeCart_currency` VALUES
(1, 'United States dollar', 'USD', 840, '$', '', '1.31441', 2, 1764028800, 1, '.', ',', '0.000'),
(2, 'Japanese yen', 'JPY', 392, '¥', '', '205.30269', 0, 1764028800, 1, '.', ',', '0.000'),
(3, 'Bulgarian lev', 'BGN', 100, '', 'BGN', '2.22553', 2, 1764028800, 0, '.', ',', '0.000'),
(4, 'Czech koruna', 'CZK', 203, '', 'CZK', '27.46131', 2, 1764028800, 0, '.', ',', '0.000'),
(5, 'Danish krone', 'DKK', 208, 'kr', '', '8.49920', 2, 1764028800, 0, '.', ',', '0.000'),
(6, 'Estonian kroon', 'EEK', 233, 'kr', '', '0.00000', 2, 0, 0, '.', ',', '0.000'),
(7, 'Pound Sterling', 'GBP', 826, '£', '', '1.00000', 2, 1764028800, 1, '.', ',', '0.000'),
(8, 'Hungarian forint', 'HUF', 348, 'Ft', '', '434.18298', 2, 1764028800, 0, '.', ',', '0.000'),
(9, 'Lithuanian litas', 'LTL', 440, 'Lt', '', '0.00000', 2, 0, 0, '.', ',', '0.000'),
(10, 'Latvian lat', 'LVL', 428, 'Ls', '', '0.00000', 2, 0, 0, '.', ',', '0.000'),
(11, 'Polish zloty', 'PLN', 985, 'zl', '', '4.80519', 2, 1764028800, 0, '.', ',', '0.000'),
(12, 'Romanian leu', 'RON', 642, 'lei', '', '5.78983', 2, 1764028800, 0, '.', ',', '0.000'),
(13, 'Swedish krona', 'SEK', 752, 'kr', '', '12.57169', 2, 1764028800, 0, '.', ',', '0.000'),
(14, 'Swiss franc', 'CHF', 756, 'CHF', '', '1.06338', 2, 1764028800, 0, '.', ',', '0.000'),
(15, 'Norwegian krone', 'NOK', 578, 'kr', '', '13.48202', 2, 1764028800, 0, '.', ',', '0.000'),
(16, 'Croatian kuna', 'HRK', 191, 'kn', '', '7.69850', 2, 1421884800, 0, '.', ',', '0.000'),
(17, 'Russian ruble', 'RUB', 643, '', 'RUB', '74.78000', 2, 1421884800, 0, '.', ',', '0.000'),
(18, 'Turkish lira', 'TRY', 792, 'YTL', '', '55.76604', 2, 1764028800, 0, '.', ',', '0.000'),
(19, 'Brazilian real', 'BRL', 986, 'R$', '', '7.05246', 2, 1764028800, 0, '.', ',', '0.000'),
(20, 'Canadian Dollar', 'CAD', 124, '$', '', '1.85492', 2, 1764028800, 1, '.', ',', '0.000'),
(21, 'Chinese yuan', 'CNY', 156, '元', '', '9.31327', 2, 1764028800, 0, '.', ',', '0.000'),
(22, 'Hong Kong dollar', 'HKD', 344, '圓', '', '10.22110', 2, 1764028800, 0, '.', ',', '0.000'),
(23, 'Mexican peso', 'MXN', 484, '$', '', '24.24704', 2, 1764028800, 0, '.', ',', '0.000'),
(24, 'Malaysian ringgit', 'MYR', 458, 'RM', '', '5.43446', 2, 1764028800, 0, '.', ',', '0.000'),
(25, 'New Zealand dollar', 'NZD', 554, '$', '', '2.34445', 2, 1764028800, 0, '.', ',', '0.000'),
(26, 'Philippine peso', 'PHP', 608, 'Php', '', '77.34866', 2, 1764028800, 0, '.', ',', '0.000'),
(27, 'Singapore dollar', 'SGD', 702, '$', '', '1.71120', 2, 1764028800, 0, '.', ',', '0.000'),
(28, 'Thai baht', 'THB', 764, '฿', '', '42.43514', 2, 1764028800, 0, '.', ',', '0.000'),
(29, 'South African rand', 'ZAR', 710, 'R', '', '22.63097', 2, 1764028800, 0, '.', ',', '0.000'),
(30, 'Euro', 'EUR', 978, '€', '', '1.13792', 2, 1764028800, 1, '.', ',', '0.000'),
(31, 'Australian Dollar', 'AUD', 036, '$', '', '2.03425', 2, 1764028800, 1, '.', ',', '0.000');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_customer`
--

CREATE TABLE `[[dbprefix]]CubeCart_customer` (
  `customer_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salt` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `new_password` tinyint(1) NOT NULL DEFAULT '1',
  `verify` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` smallint(3) unsigned NOT NULL DEFAULT '0',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `registered` int(10) unsigned NOT NULL DEFAULT '0',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Supports IPv6 addresses',
  `order_count` int(10) unsigned DEFAULT '0',
  `type` tinyint(1) unsigned DEFAULT '1',
  `language` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en-GB',
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `credit` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `email` (`email`),
  FULLTEXT KEY `fulltext` (`first_name`,`last_name`,`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_customer_coupon`
--

CREATE TABLE `[[dbprefix]]CubeCart_customer_coupon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `coupon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `used` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `email` (`email`),
  KEY `coupon` (`coupon`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_customer_group`
--

CREATE TABLE `[[dbprefix]]CubeCart_customer_group` (
  `group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `group_name` (`group_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_customer_membership`
--

CREATE TABLE `[[dbprefix]]CubeCart_customer_membership` (
  `membership_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `customer_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`membership_id`),
  KEY `group_id` (`group_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_documents`
--

CREATE TABLE `[[dbprefix]]CubeCart_documents` (
  `doc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `doc_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `doc_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `doc_order` int(10) unsigned NOT NULL DEFAULT '0',
  `doc_terms` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `doc_home` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `doc_privacy` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `doc_lang` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doc_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doc_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `doc_url` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `doc_url_openin` tinyint(1) unsigned DEFAULT NULL,
  `seo_meta_title` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_description` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_keywords` text COLLATE utf8mb4_unicode_ci,
  `navigation_link` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `doc_parse` tinyint(1) NOT NULL DEFAULT '0',
  `hide_title` enum('0','1') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  PRIMARY KEY (`doc_id`),
  KEY `doc_parent_id` (`doc_parent_id`),
  KEY `doc_status` (`doc_status`),
  KEY `doc_home` (`doc_home`),
  KEY `doc_privacy` (`doc_privacy`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_documents`
--

INSERT INTO `[[dbprefix]]CubeCart_documents` VALUES
(1, 0, 1, 1, 0, 1, 0, 'en-GB', 'Welcome to [[store_name]]', '<ul class="bxslider">\n   <li><img src="skins/foundation/images/examples/slide1.jpg" title="Promotional Message One" /></li>\n   <li><img src="skins/foundation/images/examples/slide2.jpg" /></li>\n   <li><img src="skins/foundation/images/examples/slide3.jpg" title="Promotional Message Two" /></li>\n</ul>\n<p>This message and the slider above (including the images) can be edited using the <strong><span style="color: red;">Rich</span> <span style="color: blue;">Text</span> <span style="color: green;">Editor</span></strong> which can be found in the admin control panel of your store under <i>File Manager &gt; Documents</i>.</p>', NULL, NULL, NULL, NULL, NULL, 1, 0, '0'),
(2, 0, 1, 2, 0, 0, 0, 'en-GB', 'About Us', 'This can be managed under <span class="navTitle">Documents in the admin control panel.</span>', NULL, NULL, NULL, NULL, NULL, 1, 0, '0'),
(3, 0, 1, 3, 1, 0, 0, 'en-GB', 'Terms and Conditions', 'This can be managed under <span class="navTitle">Documents in the admin control panel.</span>', NULL, NULL, NULL, NULL, NULL, 1, 0, '0'),
(4, 0, 1, 4, 0, 0, 1, 'en-GB', 'Privacy Policy', 'This can be managed under <span class="navTitle">Documents in the admin control panel.</span>', NULL, NULL, NULL, NULL, NULL, 1, 0, '0'),
(5, 0, 1, 5, 0, 0, 0, 'en-GB', 'Returns Policy', 'This can be managed under <span class="navTitle">Documents in the admin control panel.</span>', NULL, NULL, NULL, NULL, NULL, 1, 0, '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_domains`
--

CREATE TABLE `[[dbprefix]]CubeCart_domains` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_downloads`
--

CREATE TABLE `[[dbprefix]]CubeCart_downloads` (
  `digital_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_inv_id` int(10) unsigned NOT NULL,
  `customer_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cart_order_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL,
  `downloads` int(10) unsigned NOT NULL DEFAULT '0',
  `expire` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `accesskey` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`digital_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_email_content`
--

CREATE TABLE `[[dbprefix]]CubeCart_email_content` (
  `content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_type` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`content_id`),
  KEY `content_type` (`content_type`),
  KEY `language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_email_content`
--

INSERT INTO `[[dbprefix]]CubeCart_email_content` VALUES
(1, '', 'admin.password_recovery', 'en-GB', 'Admin Password Recovery', '<p>Dear {$DATA.name},</p>\n<p>To regain access to the stores administration control panel. Please follow the link below:</p>\n<p><a href="{$DATA.link}">{$DATA.link}</a></p>\n<p>If the link above doesn''t work, please copy and paste it into your browser address bar.</p>', 'Dear {$DATA.name},\n\nTo regain access to the stores administration control panel. Please follow the link below:\n\n{$DATA.link}\n\nIf the link above doesn''t work, please copy and paste it into your browser address bar.'),
(2, '', 'cart.order_complete', 'en-GB', 'Order Complete', '<p>Hi {$DATA.first_name|capitalize},</p>\n<p>We are pleased to say that order number {$DATA.cart_order_id} is complete. If you have ordered physical goods they should arrive shortly.</p>{if !empty($DATA.ship_tracking)}<p>Track your order:<br>{$DATA.ship_tracking}</p>{/if}', 'Hi {$DATA.first_name|capitalize},\n\nWe are pleased to say that order number {$DATA.cart_order_id} is complete. If you have ordered physical goods they should arrive shortly.\n{if !empty($DATA.ship_tracking)}\nTrack your order:\n{$DATA.ship_tracking}\n{/if}'),
(3, '', 'cart.order_cancelled', 'en-GB', 'Order Cancelled', '<p>Hi {$DATA.first_name|capitalize},</p>\n<p>Order number {$DATA.cart_order_id} has been cancelled.</p>', 'Hi {$DATA.first_name|capitalize},\n\nOrder number {$DATA.cart_order_id} has been cancelled.'),
(4, '', 'cart.order_confirmation', 'en-GB', 'Order Confirmation #{$DATA.cart_order_id}', '<p>Thank you {$DATA.first_name|capitalize}!</p>\n<p>Your order {$DATA.cart_order_id} has been received which was placed on {$DATA.order_date}. Please keep this email for your records. It is possible to view the status of your order online.</p> \n<p><a href="{$DATA.link}">{$DATA.link}</a></p>\n<table width="100%">\n<tr>\n<td valign="top" width="50%"><strong>Billing address:</strong><br>\n{$BILLING.first_name|capitalize} {$BILLING.last_name|capitalize}<br>\n{if !empty($BILLING.company_name)}{$BILLING.company_name}<br>\n{/if}\n{$BILLING.line1|capitalize}<br>\n{if !empty($BILLING.line2)}{$BILLING.line2|capitalize}<br>\n{/if}\n{$BILLING.town|upper}<br>\n{if !empty($BILLING.state)}{$BILLING.state|upper}<br>{/if}\n{$BILLING.postcode}<br>\n{$BILLING.country}{if !empty($BILLING.w3w)}<div class="w3w">///<a href="https://what3words.com/{$BILLING.w3w}">{$BILLING.w3w}</a></div>{/if}<br>\n{$BILLING.phone}<br>\n<br>\n<strong>Email:</strong><br>\n{$BILLING.email}</td>\n<td valign="top" width="50%"><strong>Shipping address:</strong><br>\n{$SHIPPING.first_name|capitalize} {$SHIPPING.last_name|capitalize}<br>\n{if !empty($SHIPPING.company_name)}{$SHIPPING.company_name} <br>\n{/if}{$SHIPPING.line1|capitalize}<br>\n{if !empty($SHIPPING.line2)}{$SHIPPING.line2|capitalize} <br>\n{/if}{$SHIPPING.town|upper}<br>\n{if !empty($SHIPPING.state)}{$SHIPPING.state|upper}<br>{/if}\n{$SHIPPING.postcode}<br>\n{$SHIPPING.country}{if !empty($SHIPPING.w3w)}<div class="w3w">///<a href="https://what3words.com/{$SHIPPING.w3w}">{$SHIPPING.w3w}</a></div>{/if}</td>\n</tr>\n</table>\n<table border="0" cellpadding="3" cellspacing="0" width="100%">\n<tbody>\n<tr>\n<td><strong>Item</strong></td>\n<td><strong>Quantity</strong></td>\n<td><strong>Cost</strong></td>\n</tr>\n{foreach from=$PRODUCTS item=product}\n<tr>\n<td>{$product.name} <br>{$product.product_options}</td>\n<td>{$product.quantity}</td>\n<td>{$product.price}</td>\n</tr>\n{/foreach}\n<tr>\n<td>&nbsp;</td>\n<td> {if !empty($DATA.ship_method)}{$DATA.ship_method}:{if !empty($DATA.ship_product)} ({$DATA.ship_product}){/if}{else}Shipping:{/if}</td>\n<td> {$DATA.shipping}</td>\n</tr>\n<tr>\n<td>&nbsp;</td>\n<td> Discount:</td>\n<td> {$DATA.discount}</td>\n</tr>\n<tr>\n<td>&nbsp;</td>\n<td> Subtotal:</td>\n<td> {$DATA.subtotal}</td>\n</tr>\n{foreach from=$TAXES item=tax}\n<tr>\n<td>&nbsp;</td>\n<td> {$tax.tax_name}: ({$tax.tax_percent}%)</td>\n<td> {$tax.tax_amount}</td>\n</tr>\n{/foreach}\n{if $DATA.show_credit}\n<tr>\n<td>&nbsp;</td>\n<td>Credit:</td>\n<td>({$DATA.credit_used})</td>\n</tr>\n{/if}\n<tr>\n<td>&nbsp;</td>\n<td><strong>Order Total: </strong></td>\n<td><strong>{$DATA.total}</strong></td>\n</tr>\n</tbody>\n</table>\n{if !empty($DATA.note_to_customer)}\n<p>&quot;{$DATA.note_to_customer}&quot;</p>\n{/if}', 'Thank you {$DATA.first_name|capitalize}!\n\nYour order {$DATA.cart_order_id} has been received which was placed on {$DATA.order_date}. Please keep this email for your records. It is possible to view the status of your order online. \n\n{$DATA.link}\n\n----------------------------------------------------------------------\nBilling address:\n{$BILLING.first_name|capitalize} {$BILLING.last_name|capitalize}\n{if !empty($BILLING.company_name)}{$BILLING.company_name}\n{/if}{$BILLING.line1|capitalize}\n{if !empty($BILLING.line2)}{$BILLING.line2|capitalize}\n{/if}{$BILLING.town|upper}\n{if !empty($BILLING.state)}{$BILLING.state|upper}\n{/if}{$BILLING.postcode}\n{$BILLING.country}{if !empty($BILLING.w3w)}\n///{$BILLING.w3w}{/if}\n{$BILLING.phone}\n\nEmail:\n{$BILLING.email}\n\nShipping address:\n{$SHIPPING.first_name|capitalize} {$SHIPPING.last_name|capitalize}\n{if !empty($SHIPPING.company_name)}{$SHIPPING.company_name}\n{/if}{$SHIPPING.line1|capitalize}\n{if !empty($SHIPPING.line2)}{$SHIPPING.line2|capitalize}\n{/if}{$SHIPPING.town|upper}\n{if !empty($SHIPPING.state)}{$SHIPPING.state|upper}\n{/if}{$SHIPPING.postcode}\n{$SHIPPING.country}{if !empty($SHIPPING.w3w)}\n///{$SHIPPING.w3w}{/if}\n\n----------------------------------------------------------------------\nItems in Your Order\n\n{foreach from=$PRODUCTS item=product}\n-----------------------------------\n{$product.name}\n{$product.product_options}\n\nPart Number: {$product.product_code}\nUnit Price: {$product.price}\nQty: {$product.quantity}\n\n{/foreach}\n-----------------------------------\nSubtotal: {$DATA.subtotal}\nDiscount: {$DATA.discount}\n{if !empty($DATA.ship_method)}{$DATA.ship_method}:{if !empty($DATA.ship_product)} ({$DATA.ship_product}){/if}{else}Shipping:{/if} {$DATA.shipping}\n{foreach from=$TAXES item=tax}{$tax.tax_name} ({$tax.tax_percent}%): {$tax.tax_amount}\n{/foreach}{if $DATA.show_credit}\nCredit: ({$DATA.credit_used})\n{/if}--------------------------\nOrder Total: {$DATA.total}\n==========================\n{if !empty($DATA.note_to_customer)}\n"{$DATA.note_to_customer}"{/if}'),
(5, '', 'cart.payment_fraud', 'en-GB', 'Order Problem', '<p>Hi {$DATA.first_name|capitalize},</p>\n<p>We are very sorry but we have not been able to accept the payment for order {$DATA.cart_order_id}. Please feel free to contact a member of staff if you have any questions.</p>', 'Hi {$DATA.first_name|capitalize},\n\nWe are very sorry but we have not been able to accept the payment for order {$DATA.cart_order_id}. Please feel free to contact a member of staff if you have any questions.'),
(6, '', 'account.password_recovery', 'en-GB', 'Password Recovery', '<p>Dear {$DATA.first_name|capitalize} {$DATA.last_name|capitalize},<br>\n<br>\nTo reset your password, please click on the link below or copy and paste the address onto your web browser''s address window. Once you''re on the web page, you will be instructed to enter and confirm your new password.<br> \n<br>\n<a href="{$DATA.reset_link}">{$DATA.reset_link}</a><br>\n<br>\nIf you require further assistance in resetting your password, please contact us.</p>', 'Hi {$DATA.first_name|capitalize},\n\nTo reset your password, please click on the link below or copy and paste the address onto your web browser''s address window. Once you''re on the web page, you will be instructed to enter and confirm your new password.\n\n{$DATA.reset_link}\n\nIf you require further assistance in resetting your password, please contact us.'),
(7, '', 'admin.order_received', 'en-GB', 'New Order #{$DATA.cart_order_id}', '<p>{$DATA.first_name|capitalize} {$DATA.last_name|capitalize} {if !empty($BILLING.company_name)}({$BILLING.company_name}){/if} just placed order number {$DATA.cart_order_id} on {$DATA.order_date}.</p>\n<p>This order can be managed online by following the link below.</p>\n<p><a href="{$DATA.link}">{$DATA.link}</a></p>\n<table width="100%">\n<tr>\n<td valign="top" width="50%"><strong>Billing address:</strong><br>\n{$BILLING.first_name|capitalize} {$BILLING.last_name|capitalize}<br>\n{if !empty($BILLING.company_name)}{$BILLING.company_name}<br>\n{/if}\n{$BILLING.line1|capitalize}<br>\n{if !empty($BILLING.line2)}{$BILLING.line2|capitalize}<br>\n{/if}\n{$BILLING.town|upper}<br>\n{if !empty($BILLING.state)}{$BILLING.state|upper}<br>{/if}\n{$BILLING.postcode}<br>\n{$BILLING.country}{if !empty($BILLING.w3w)}<div class="w3w">///<a href="https://what3words.com/{$BILLING.w3w}">{$BILLING.w3w}</a></div>{/if}<br>\n{$BILLING.phone}<br>\n<br>\n<strong>Email:</strong><br>\n{$BILLING.email}</td>\n<td valign="top" width="50%"><strong>Shipping address:</strong><br>\n{$SHIPPING.first_name|capitalize} {$SHIPPING.last_name|capitalize}<br>\n{if !empty($SHIPPING.company_name)}{$SHIPPING.company_name} <br>\n{/if}{$SHIPPING.line1|capitalize}<br>\n{if !empty($SHIPPING.line2)}{$SHIPPING.line2|capitalize} <br>\n{/if}{$SHIPPING.town|upper}<br>\n{if !empty($SHIPPING.state)}{$SHIPPING.state|upper}<br>{/if}\n{$SHIPPING.postcode}<br>\n{$SHIPPING.country}{if !empty($SHIPPING.w3w)}<div class="w3w">///<a href="https://what3words.com/{$SHIPPING.w3w}">{$SHIPPING.w3w}</a></div>{/if}</td>\n</tr>\n</table>\n<table border="0" cellpadding="3" cellspacing="0" width="100%">\n<tbody>\n<tr>\n<td><strong>Item</strong></td>\n<td><strong>Quantity</strong></td>\n<td><strong>Cost</strong></td>\n</tr>\n{foreach from=$PRODUCTS item=product}\n<tr>\n<td>{$product.name} <br>{$product.product_options}</td>\n<td>{$product.quantity}</td>\n<td>{$product.price}</td>\n</tr>\n{/foreach}\n<tr>\n<td>&nbsp;</td>\n<td> {if !empty($DATA.ship_method)}{$DATA.ship_method}:{if !empty($DATA.ship_product)} ({$DATA.ship_product}){/if}{else}Shipping:{/if}</td>\n<td> {$DATA.shipping}</td>\n</tr>\n<tr>\n<td>&nbsp;</td>\n<td> Discount:</td>\n<td> {$DATA.discount}</td>\n</tr>\n<tr>\n<td>&nbsp;</td>\n<td> Subtotal:</td>\n<td> {$DATA.subtotal}</td>\n</tr>\n{foreach from=$TAXES item=tax}\n<tr>\n<td>&nbsp;</td>\n<td> {$tax.tax_name}: ({$tax.tax_percent}%)</td>\n<td> {$tax.tax_amount}</td>\n</tr>\n{/foreach}\n{if $DATA.show_credit}\n<tr>\n<td>&nbsp;</td>\n<td>Credit:</td>\n<td>({$DATA.credit_used})</td>\n</tr>\n{/if}\n<tr>\n<td>&nbsp;</td>\n<td><strong>Order Total: </strong></td>\n<td><strong>{$DATA.total}</strong></td>\n</tr>\n</tbody>\n</table>', '{$DATA.first_name|capitalize} {$DATA.last_name|capitalize} {if !empty($BILLING.company_name)}({$BILLING.company_name}){/if} just placed order number {$DATA.cart_order_id} on {$DATA.order_date}.\n\nThis order can be managed online by following the link below.\n\n{$DATA.link}\n\n----------------------------------------------------------------------\nBilling address:\n{$BILLING.first_name|capitalize} {$BILLING.last_name|capitalize}\n{if !empty($BILLING.company_name)}{$BILLING.company_name}\n{/if}{$BILLING.line1|capitalize}\n{if !empty($BILLING.line2)}{$BILLING.line2|capitalize}\n{/if}{$BILLING.town|upper}\n{if !empty($BILLING.state)}{$BILLING.state|upper}\n{/if}{$BILLING.postcode}\n{$BILLING.country}{if !empty($BILLING.w3w)}\n///{$BILLING.w3w}{/if}\n{$BILLING.phone}\n\nEmail:\n{$BILLING.email}\n\nShipping address:\n{$SHIPPING.first_name|capitalize} {$SHIPPING.last_name|capitalize}\n{if !empty($SHIPPING.company_name)}{$SHIPPING.company_name}\n{/if}{$SHIPPING.line1|capitalize}\n{if !empty($SHIPPING.line2)}{$SHIPPING.line2|capitalize}\n{/if}{$SHIPPING.town|upper}\n{if !empty($SHIPPING.state)}{$SHIPPING.state|upper}\n{/if}{$SHIPPING.postcode}\n{$SHIPPING.country}{if !empty($SHIPPING.w3w)}\n///{$SHIPPING.w3w}{/if}\n\n----------------------------------------------------------------------\nItems in Your Order\n\n{foreach from=$PRODUCTS item=product}\n-----------------------------------\n{$product.name}\n{$product.product_options}\n\nPart Number: {$product.product_code}\nUnit Price: {$product.price}\nQty: {$product.quantity}\n\n{/foreach}\n-----------------------------------\nSubtotal: {$DATA.subtotal}\nDiscount: {$DATA.discount}\n{if !empty($DATA.ship_method)}{$DATA.ship_method}:{if !empty($DATA.ship_product)} ({$DATA.ship_product}){/if}{else}Shipping:{/if} {$DATA.shipping}\n{foreach from=$TAXES item=tax}{$tax.tax_name} ({$tax.tax_percent}%): {$tax.tax_amount}\n{/foreach}{if $DATA.show_credit}\nCredit: ({$DATA.credit_used})\n{/if}--------------------------\nOrder Total: {$DATA.total}\n=========================='),
(8, '', 'admin.review_added', 'en-GB', 'New Product Review', '{$DATA.name} has submit a new review/comment about ''{$DATA.product_name}''. This can be moderated following the link below.\n        <p><strong>Moderation Link:</strong><br><a href=''{$DATA.link}''>{$DATA.link}</a></p>\n        <p><strong>Review Text:</strong><br>{$DATA.review}</p>', '{$DATA.name} has submit a new review/comment about ''{$DATA.product_name}''. This can be moderated following the link below.\n\nModeration Link:\n{$DATA.link}\nReview Text:\n{$DATA.review}'),
(9, '', 'cart.digital_download', 'en-GB', 'Your Purchased Downloads', '<p>Hi {$DATA.first_name|capitalize},</p>\n<p>Your digital files are now ready for download. Please use the links provided below to access them below:</p>\n{foreach from=$DOWNLOADS item=download}\n<p><strong>{$download.name}:</strong> (Link expires on {$download.expire}<strong>)</strong><br>\n<a href="{$download.url}">{$download.url}</a></p>\n{/foreach}\n<p>If the links above don''t work, please try copy and pasting them it into your browser address bar. You can also find access to these files from your the customer area of our website.</p> \n<p>&nbsp;</p>', 'Hi {$DATA.first_name|capitalize},\n\nYour digital files are now ready for download. Please use the links provided below to access them below:\n\n{foreach from=$DOWNLOADS item=download}\n{$download.name}: (Link expires on {$download.expire})\n{$download.url}\n{/foreach}\n\nIf the links above don''t work, please try copy and pasting them it into your browser address bar. You can also find access to these files from your the customer area of our website.'),
(10, '', 'cart.gift_certificate', 'en-GB', 'Your Gift Card', '<p>Dear {$DATA.name},</p>\n<p>We are pleased to be sending you this gift card which you can use towards the purchase of any items on our website.</p>\n<p><strong>From: </strong>{$DATA.first_name|capitalize} {$DATA.last_name|capitalize}<br>\n<strong>Amount: </strong>{$DATA.value}<br>\n<strong>Claim Code:</strong> {$DATA.code}<br>\n<strong>Gift Message:</strong> {$DATA.message}</p>\n<p>-------------------</p>\n<p>To redeem this gift card please enter the &quot;Claim Code&quot; above into the text field labeled &quot;Promotional code or gift card&quot; during checkout.</p>\n<p>Why not spend it now?</p>', 'Dear {$DATA.name},\n\nWe are pleased to be sending you this gift card which you can use towards the purchase of any item(s) on our website.\n\nHappy shopping!\n\nFrom: {$DATA.first_name|capitalize} {$DATA.last_name|capitalize}\nAmount: {$DATA.value}\nClaim Code: {$DATA.code}\nGift Message: {$DATA.message}\n\n-------------------\n\nTo redeem this gift card please enter the "Claim Code" above into the text field labeled "Promotional code or gift card" during checkout.\n\nWhy not spend it now?'),
(11, '', 'catalogue.tell_friend', 'en-GB', '{$DATA.from} has recommended something', 'Dear {$DATA.to},\n<p>Your friend <strong>{$DATA.from}</strong> thought that you might be interested in <strong>{$DATA.name}</strong>.</p>\n<p><strong>Product Link:</strong> <a href="{$DATA.link}">{$DATA.name}</a></p>\n<p>{$DATA.message}</p>', 'Dear {$DATA.to},\n\nYour friend {$DATA.from} thought that you might be interested in ''{$DATA.name}''.\n\n{$DATA.name}\nProduct Link: {$DATA.link}\n\n{$DATA.message}'),
(12, '', 'cart.payment_received', 'en-GB', 'Thank you for your payment!', '<p>Hi {$DATA.first_name|capitalize},</p>\n<p>Thank you. We have received a payment of {$DATA.total} for order number {$DATA.cart_order_id}.</p>', 'Hi {$DATA.first_name|capitalize},\n\nThank you. We have received a payment of {$DATA.total} for order number {$DATA.cart_order_id}.'),
(13, '', 'newsletter.verify_email', 'en-GB', 'Confirm your subscription', '<p>{$DATA.email} has been submitted to subscribe to our newsletter. If this is you and you want to subscribe, please confirm your subscription using the link below:</p><p><a href="{$DATA.link}">{$DATA.link}</a></p>', '{$DATA.email} has been submitted to subscribe to our newsletter. If this is you and you want to subscribe, please confirm your subscription using the link below:\n\n{$DATA.link}'),
(14, '', 'newsletter.remove_request', 'en-GB', 'Confirm Newsletter Removal', '<p>Someone has requested that <strong>{$DATA.email}</strong> is to be unsubscribed from our mailing list. If you did requst this action please confirm using the link below.</p><p><a href="{$DATA.link}">{$DATA.link}</a></p>', 'Someone has requested that {$DATA.email} is to be unsubscribed from our mailing list. If you did requst this action please confirm using the link below.\n    \n{$DATA.link}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_email_template`
--

CREATE TABLE `[[dbprefix]]CubeCart_email_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template_default` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_email_template`
--

INSERT INTO `[[dbprefix]]CubeCart_email_template` VALUES
(1, '1', 'Default Emails', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\r\n<html>\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />\r\n<style type="text/css">\r\nhtml, body, table {\r\n	font-family: Arial;\r\n	font-size: 14px;\r\n}\r\n.w3w{\r\ncolor: #E11F26;\r\ndisplay: block\r\n}.w3w a{\r\ncolor: #333333;\r\ntext-decoration: none\r\n}\r\n</style>\r\n<title>Default HTML Template</title>\r\n<base href="{$DATA.storeURL}" />\r\n</head>\r\n<body bgcolor="#f7f7f7">\r\n<table border="0" cellpadding="0" cellspacing="0" width="100%">\r\n  <tbody>\r\n    <tr>\r\n      <td style="text-align:center"><table bgcolor="#ffffff" border="0" cellpadding="15" cellspacing="0" width="580">\r\n          <tbody>\r\n            <tr>\r\n              <td><a href="{$DATA.storeURL}"><img alt="{$DATA.storeName}" border="0" src="{$DATA.logoURL}" style="max-width: 580px" /></a></td>\r\n            </tr>\r\n            <tr>\r\n              <td> {$EMAIL_CONTENT}</td>\r\n            </tr>\r\n            <tr>\r\n              <td><p> Kind regards,</p>\r\n                <p> The {$DATA.storeName} Staff<br />\r\n                  <a href="{$DATA.storeURL}">{$DATA.storeURL}</a></p></td>\r\n            </tr>\r\n          </tbody>\r\n        </table></td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n</body>\r\n</html>', '{$EMAIL_CONTENT}\r\n\r\nKind regards,\r\n\r\nThe {$DATA.storeName} Staff\r\n{$DATA.storeURL}'),
(2, '0', 'Default Newsletter', '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\r\n<html>\r\n<head>\r\n<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />\r\n<style type="text/css">\r\nhtml, body, table {\r\n	font-family: Arial;\r\n	font-size: 14px;\r\n}\r\n.w3w{\r\ncolor: #E11F26;\r\ndisplay: block\r\n}.w3w a{\r\ncolor: #333333;\r\ntext-decoration: none\r\n}\r\n</style>\r\n<title>Default HTML Newsletter Template</title>\r\n<base href="{$DATA.storeURL}" />\r\n</head>\r\n<body bgcolor="#f7f7f7">\r\n<table border="0" cellpadding="0" cellspacing="0" width="100%">\r\n  <tbody>\r\n    <tr>\r\n      <td style="text-align:center"><table bgcolor="#ffffff" border="0" cellpadding="15" cellspacing="0" width="580">\r\n          <tbody>\r\n            <tr>\r\n              <td><a href="{$DATA.storeURL}"><img src="{$DATA.logoURL}" style="max-width: 580px" alt="{$DATA.storeName}" border="0" /></a></td>\r\n            </tr>\r\n            <tr>\r\n              <td>{$EMAIL_CONTENT}</td>\r\n            </tr>\r\n            <tr>\r\n              <td><p>Kind regards,</p>\r\n                <p>The {$DATA.storeName} Staff<br />\r\n                  <a href="{$DATA.storeURL}">{$DATA.storeURL}</a></p>\r\n                <hr size="1" />\r\n                <p><font size="2">To unsubscribe please follow the link below:<br />\r\n                  <a href="{$DATA.unsubscribeURL}">{$DATA.unsubscribeURL}</a></font></p></td>\r\n            </tr>\r\n          </tbody>\r\n        </table></td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n</body>\r\n</html>', '{$EMAIL_CONTENT}\r\n\r\nKind regards,\r\n\r\nThe {$DATA.storeName} Staff\r\n{$DATA.storeURL}\r\n\r\n-------------------\r\n\r\nTo unsubscribe please follow the link below:\r\n{$DATA.unsubscribeURL}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_extension_info`
--

CREATE TABLE `[[dbprefix]]CubeCart_extension_info` (
  `file_id` int(10) unsigned NOT NULL,
  `seller_id` int(10) unsigned NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dir` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `modified` int(11) NOT NULL,
  `keep_current` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`file_id`),
  KEY `seller_id` (`seller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_filemanager`
--

CREATE TABLE `[[dbprefix]]CubeCart_filemanager` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `filepath` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `filename` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `filesize` bigint(20) unsigned NOT NULL,
  `mimetype` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `md5hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `stream` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `alt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `md5hash` (`md5hash`),
  KEY `type` (`type`),
  KEY `filepath` (`filepath`),
  KEY `filename` (`filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_geo_country`
--

CREATE TABLE `[[dbprefix]]CubeCart_geo_country` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iso` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varbinary(80) NOT NULL DEFAULT '',
  `iso3` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numcode` smallint(3) unsigned zerofill DEFAULT NULL,
  `eu` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`iso`),
  KEY `id` (`id`),
  KEY `eu` (`eu`),
  KEY `numcode` (`numcode`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=245 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_geo_country`
--

INSERT INTO `[[dbprefix]]CubeCart_geo_country` VALUES
(5, 'AD', 'Andorra', 'AND', 020, '0', 2),
(224, 'AE', 'United Arab Emirates', 'ARE', 784, '0', 2),
(1, 'AF', 'Afghanistan', 'AFG', 004, '0', 2),
(9, 'AG', 'Antigua and Barbuda', 'ATG', 028, '0', 2),
(7, 'AI', 'Anguilla', 'AIA', 660, '0', 2),
(2, 'AL', 'Albania', 'ALB', 008, '0', 2),
(151, 'AN', 'Netherlands Antilles', 'ANT', 530, '0', 2),
(6, 'AO', 'Angola', 'AGO', 244, '0', 2),
(8, 'AQ', 'Antarctica', 'ATA', 010, '0', 2),
(10, 'AR', 'Argentina', 'ARG', 032, '0', 1),
(4, 'AS', 'American Samoa', 'ASM', 016, '0', 2),
(14, 'AT', 'Austria', 'AUT', 040, '1', 2),
(13, 'AU', 'Australia', 'AUS', 036, '0', 2),
(12, 'AW', 'Aruba', 'ABW', 533, '0', 2),
(15, 'AZ', 'Azerbaijan', 'AZE', 031, '0', 2),
(27, 'BA', 'Bosnia and Herzegovina', 'BIH', 070, '0', 2),
(19, 'BB', 'Barbados', 'BRB', 052, '0', 2),
(18, 'BD', 'Bangladesh', 'BGD', 050, '0', 2),
(21, 'BE', 'Belgium', 'BEL', 056, '1', 2),
(34, 'BF', 'Burkina Faso', 'BFA', 854, '0', 2),
(33, 'BG', 'Bulgaria', 'BGR', 100, '1', 2),
(17, 'BH', 'Bahrain', 'BHR', 048, '0', 2),
(35, 'BI', 'Burundi', 'BDI', 108, '0', 2),
(23, 'BJ', 'Benin', 'BEN', 204, '0', 2),
(24, 'BM', 'Bermuda', 'BMU', 060, '0', 2),
(32, 'BN', 'Brunei Darussalam', 'BRN', 096, '0', 2),
(26, 'BO', 'Bolivia', 'BOL', 068, '0', 2),
(30, 'BR', 'Brazil', 'BRA', 076, '0', 1),
(16, 'BS', 'Bahamas', 'BHS', 044, '0', 2),
(25, 'BT', 'Bhutan', 'BTN', 064, '0', 2),
(29, 'BV', 'Bouvet Island', 'BVT', 074, '0', 2),
(28, 'BW', 'Botswana', 'BWA', 072, '0', 2),
(20, 'BY', 'Belarus', 'BLR', 112, '0', 2),
(22, 'BZ', 'Belize', 'BLZ', 084, '0', 2),
(38, 'CA', 'Canada', 'CAN', 124, '0', 1),
(46, 'CC', 'Cocos (Keeling) Islands', 'CCK', 166, '0', 2),
(50, 'CD', 'Congo, the Democratic Republic of the', 'COD', 180, '0', 2),
(41, 'CF', 'Central African Republic', 'CAF', 140, '0', 2),
(49, 'CG', 'Congo', 'COG', 178, '0', 2),
(206, 'CH', 'Switzerland', 'CHE', 756, '0', 2),
(53, 'CI', 'Cote D''Ivoire', 'CIV', 384, '0', 2),
(51, 'CK', 'Cook Islands', 'COK', 184, '0', 2),
(43, 'CL', 'Chile', 'CHL', 152, '0', 2),
(37, 'CM', 'Cameroon', 'CMR', 120, '0', 2),
(44, 'CN', 'China', 'CHN', 156, '0', 1),
(47, 'CO', 'Colombia', 'COL', 170, '0', 2),
(52, 'CR', 'Costa Rica', 'CRI', 188, '0', 2),
(55, 'CU', 'Cuba', 'CUB', 192, '0', 2),
(39, 'CV', 'Cape Verde', 'CPV', 132, '0', 2),
(45, 'CX', 'Christmas Island', 'CXR', 162, '0', 2),
(56, 'CY', 'Cyprus', 'CYP', 196, '1', 2),
(57, 'CZ', 'Czech Republic', 'CZE', 203, '1', 2),
(80, 'DE', 'Germany', 'DEU', 276, '1', 2),
(59, 'DJ', 'Djibouti', 'DJI', 262, '0', 2),
(58, 'DK', 'Denmark', 'DNK', 208, '1', 2),
(60, 'DM', 'Dominica', 'DMA', 212, '0', 2),
(61, 'DO', 'Dominican Republic', 'DOM', 214, '0', 2),
(3, 'DZ', 'Algeria', 'DZA', 012, '0', 2),
(62, 'EC', 'Ecuador', 'ECU', 218, '0', 2),
(67, 'EE', 'Estonia', 'EST', 233, '1', 2),
(63, 'EG', 'Egypt', 'EGY', 818, '0', 2),
(236, 'EH', 'Western Sahara', 'ESH', 732, '0', 2),
(66, 'ER', 'Eritrea', 'ERI', 232, '0', 2),
(199, 'ES', 'Spain', 'ESP', 724, '1', 2),
(68, 'ET', 'Ethiopia', 'ETH', 231, '0', 2),
(72, 'FI', 'Finland', 'FIN', 246, '1', 2),
(71, 'FJ', 'Fiji', 'FJI', 242, '0', 2),
(69, 'FK', 'Falkland Islands (Malvinas)', 'FLK', 238, '0', 2),
(139, 'FM', 'Micronesia, Federated States of', 'FSM', 583, '0', 2),
(70, 'FO', 'Faroe Islands', 'FRO', 234, '0', 2),
(73, 'FR', 'France', 'FRA', 250, '1', 2),
(77, 'GA', 'Gabon', 'GAB', 266, '0', 2),
(225, 'GB', 'United Kingdom', 'GBR', 826, '0', 2),
(85, 'GD', 'Grenada', 'GRD', 308, '0', 2),
(79, 'GE', 'Georgia', 'GEO', 268, '0', 2),
(74, 'GF', 'French Guiana', 'GUF', 254, '0', 2),
(241, 'GG', 'Guernsey', 'GGY', 831, '0', 2),
(81, 'GH', 'Ghana', 'GHA', 288, '0', 2),
(82, 'GI', 'Gibraltar', 'GIB', 292, '0', 2),
(84, 'GL', 'Greenland', 'GRL', 304, '0', 2),
(78, 'GM', 'Gambia', 'GMB', 270, '0', 2),
(89, 'GN', 'Guinea', 'GIN', 324, '0', 2),
(86, 'GP', 'Guadeloupe', 'GLP', 312, '0', 2),
(65, 'GQ', 'Equatorial Guinea', 'GNQ', 226, '0', 2),
(83, 'GR', 'Greece', 'GRC', 300, '1', 2),
(198, 'GS', 'South Georgia and the South Sandwich Islands', 'SGS', 239, '0', 2),
(88, 'GT', 'Guatemala', 'GTM', 320, '0', 2),
(87, 'GU', 'Guam', 'GUM', 316, '0', 2),
(90, 'GW', 'Guinea-Bissau', 'GNB', 624, '0', 2),
(91, 'GY', 'Guyana', 'GUY', 328, '0', 2),
(96, 'HK', 'Hong Kong', 'HKG', 344, '0', 2),
(93, 'HM', 'Heard Island and Mcdonald Islands', 'HMD', 334, '0', 2),
(95, 'HN', 'Honduras', 'HND', 340, '0', 2),
(54, 'HR', 'Croatia', 'HRV', 191, '1', 2),
(92, 'HT', 'Haiti', 'HTI', 332, '0', 2),
(97, 'HU', 'Hungary', 'HUN', 348, '1', 2),
(100, 'ID', 'Indonesia', 'IDN', 360, '0', 1),
(103, 'IE', 'Ireland', 'IRL', 372, '1', 2),
(104, 'IL', 'Israel', 'ISR', 376, '0', 2),
(243, 'IM', 'Isle of Man', 'IMN', 833, '0', 2),
(99, 'IN', 'India', 'IND', 356, '0', 1),
(31, 'IO', 'British Indian Ocean Territory', 'IOT', 086, '0', 2),
(102, 'IQ', 'Iraq', 'IRQ', 368, '0', 2),
(101, 'IR', 'Iran, Islamic Republic of', 'IRN', 364, '0', 2),
(98, 'IS', 'Iceland', 'ISL', 352, '0', 2),
(105, 'IT', 'Italy', 'ITA', 380, '1', 2),
(242, 'JE', 'Jersey', 'JEY', 832, '0', 2),
(106, 'JM', 'Jamaica', 'JAM', 388, '0', 2),
(108, 'JO', 'Jordan', 'JOR', 400, '0', 2),
(107, 'JP', 'Japan', 'JPN', 392, '0', 1),
(110, 'KE', 'Kenya', 'KEN', 404, '0', 2),
(115, 'KG', 'Kyrgyzstan', 'KGZ', 417, '0', 2),
(36, 'KH', 'Cambodia', 'KHM', 116, '0', 2),
(111, 'KI', 'Kiribati', 'KIR', 296, '0', 2),
(48, 'KM', 'Comoros', 'COM', 174, '0', 2),
(180, 'KN', 'Saint Kitts and Nevis', 'KNA', 659, '0', 2),
(112, 'KP', 'Korea, Democratic People''s Republic of', 'PRK', 408, '0', 2),
(113, 'KR', 'Korea, Republic of', 'KOR', 410, '0', 2),
(114, 'KW', 'Kuwait', 'KWT', 414, '0', 2),
(40, 'KY', 'Cayman Islands', 'CYM', 136, '0', 2),
(109, 'KZ', 'Kazakhstan', 'KAZ', 398, '0', 2),
(116, 'LA', 'Lao People''s Democratic Republic', 'LAO', 418, '0', 2),
(118, 'LB', 'Lebanon', 'LBN', 422, '0', 2),
(181, 'LC', 'Saint Lucia', 'LCA', 662, '0', 2),
(122, 'LI', 'Liechtenstein', 'LIE', 438, '0', 2),
(200, 'LK', 'Sri Lanka', 'LKA', 144, '0', 2),
(119, 'LS', 'Lesotho', 'LSO', 426, '0', 2),
(123, 'LT', 'Lithuania', 'LTU', 440, '1', 2),
(124, 'LU', 'Luxembourg', 'LUX', 442, '1', 2),
(117, 'LV', 'Latvia', 'LVA', 428, '1', 2),
(121, 'LY', 'Libyan Arab Jamahiriya', 'LBY', 434, '0', 2),
(144, 'MA', 'Morocco', 'MAR', 504, '0', 2),
(141, 'MC', 'Monaco', 'MCO', 492, '0', 2),
(140, 'MD', 'Moldova, Republic of', 'MDA', 498, '0', 2),
(240, 'ME', 'Montenegro', 'MNE', 499, '0', 2),
(127, 'MG', 'Madagascar', 'MDG', 450, '0', 2),
(133, 'MH', 'Marshall Islands', 'MHL', 584, '0', 2),
(126, 'MK', 'Macedonia, the Former Yugoslav Republic of', 'MKD', 807, '0', 2),
(131, 'ML', 'Mali', 'MLI', 466, '0', 2),
(146, 'MM', 'Myanmar', 'MMR', 104, '0', 2),
(142, 'MN', 'Mongolia', 'MNG', 496, '0', 2),
(125, 'MO', 'Macao', 'MAC', 446, '0', 2),
(159, 'MP', 'Northern Mariana Islands', 'MNP', 580, '0', 2),
(134, 'MQ', 'Martinique', 'MTQ', 474, '0', 2),
(135, 'MR', 'Mauritania', 'MRT', 478, '0', 2),
(143, 'MS', 'Montserrat', 'MSR', 500, '0', 2),
(132, 'MT', 'Malta', 'MLT', 470, '1', 2),
(136, 'MU', 'Mauritius', 'MUS', 480, '0', 2),
(130, 'MV', 'Maldives', 'MDV', 462, '0', 2),
(128, 'MW', 'Malawi', 'MWI', 454, '0', 2),
(138, 'MX', 'Mexico', 'MEX', 484, '0', 1),
(129, 'MY', 'Malaysia', 'MYS', 458, '0', 2),
(145, 'MZ', 'Mozambique', 'MOZ', 508, '0', 2),
(147, 'NA', 'Namibia', 'NAM', 516, '0', 2),
(152, 'NC', 'New Caledonia', 'NCL', 540, '0', 2),
(155, 'NE', 'Niger', 'NER', 562, '0', 2),
(158, 'NF', 'Norfolk Island', 'NFK', 574, '0', 2),
(156, 'NG', 'Nigeria', 'NGA', 566, '0', 2),
(154, 'NI', 'Nicaragua', 'NIC', 558, '0', 2),
(150, 'NL', 'Netherlands', 'NLD', 528, '1', 2),
(160, 'NO', 'Norway', 'NOR', 578, '0', 2),
(149, 'NP', 'Nepal', 'NPL', 524, '0', 2),
(148, 'NR', 'Nauru', 'NRU', 520, '0', 2),
(157, 'NU', 'Niue', 'NIU', 570, '0', 2),
(153, 'NZ', 'New Zealand', 'NZL', 554, '0', 2),
(161, 'OM', 'Oman', 'OMN', 512, '0', 2),
(165, 'PA', 'Panama', 'PAN', 591, '0', 2),
(168, 'PE', 'Peru', 'PER', 604, '0', 2),
(75, 'PF', 'French Polynesia', 'PYF', 258, '0', 2),
(166, 'PG', 'Papua New Guinea', 'PNG', 598, '0', 2),
(169, 'PH', 'Philippines', 'PHL', 608, '0', 2),
(162, 'PK', 'Pakistan', 'PAK', 586, '0', 2),
(171, 'PL', 'Poland', 'POL', 616, '1', 2),
(182, 'PM', 'Saint Pierre and Miquelon', 'SPM', 666, '0', 2),
(170, 'PN', 'Pitcairn', 'PCN', 612, '0', 2),
(173, 'PR', 'Puerto Rico', 'PRI', 630, '0', 2),
(164, 'PS', 'Palestinian Territory, Occupied', 'PSE', 275, '0', 2),
(172, 'PT', 'Portugal', 'PRT', 620, '1', 2),
(163, 'PW', 'Palau', 'PLW', 585, '0', 2),
(167, 'PY', 'Paraguay', 'PRY', 600, '0', 2),
(174, 'QA', 'Qatar', 'QAT', 634, '0', 2),
(175, 'RE', 'Reunion', 'REU', 638, '0', 2),
(176, 'RO', 'Romania', 'ROM', 642, '1', 2),
(244, 'RS', 'Serbia', 'SRB', 688, '0', 2),
(177, 'RU', 'Russian Federation', 'RUS', 643, '0', 2),
(178, 'RW', 'Rwanda', 'RWA', 646, '0', 2),
(187, 'SA', 'Saudi Arabia', 'SAU', 682, '0', 2),
(195, 'SB', 'Solomon Islands', 'SLB', 090, '0', 2),
(190, 'SC', 'Seychelles', 'SYC', 690, '0', 2),
(201, 'SD', 'Sudan', 'SDN', 736, '0', 2),
(205, 'SE', 'Sweden', 'SWE', 752, '1', 2),
(192, 'SG', 'Singapore', 'SGP', 702, '0', 2),
(179, 'SH', 'Saint Helena', 'SHN', 654, '0', 2),
(194, 'SI', 'Slovenia', 'SVN', 705, '1', 2),
(203, 'SJ', 'Svalbard and Jan Mayen', 'SJM', 744, '0', 2),
(193, 'SK', 'Slovakia', 'SVK', 703, '1', 2),
(191, 'SL', 'Sierra Leone', 'SLE', 694, '0', 2),
(185, 'SM', 'San Marino', 'SMR', 674, '0', 2),
(188, 'SN', 'Senegal', 'SEN', 686, '0', 2),
(196, 'SO', 'Somalia', 'SOM', 706, '0', 2),
(202, 'SR', 'Suriname', 'SUR', 740, '0', 2),
(186, 'ST', 'Sao Tome and Principe', 'STP', 678, '0', 2),
(64, 'SV', 'El Salvador', 'SLV', 222, '0', 2),
(207, 'SY', 'Syrian Arab Republic', 'SYR', 760, '0', 2),
(204, 'SZ', 'Swaziland', 'SWZ', 748, '0', 2),
(220, 'TC', 'Turks and Caicos Islands', 'TCA', 796, '0', 2),
(42, 'TD', 'Chad', 'TCD', 148, '0', 2),
(76, 'TF', 'French Southern Territories', 'ATF', 260, '0', 2),
(213, 'TG', 'Togo', 'TGO', 768, '0', 2),
(211, 'TH', 'Thailand', 'THA', 764, '0', 1),
(209, 'TJ', 'Tajikistan', 'TJK', 762, '0', 2),
(214, 'TK', 'Tokelau', 'TKL', 772, '0', 2),
(212, 'TL', 'Timor-Leste', 'TLS', 626, '0', 2),
(219, 'TM', 'Turkmenistan', 'TKM', 795, '0', 2),
(217, 'TN', 'Tunisia', 'TUN', 788, '0', 2),
(215, 'TO', 'Tonga', 'TON', 776, '0', 2),
(218, 'TR', 'Turkey', 'TUR', 792, '0', 2),
(216, 'TT', 'Trinidad and Tobago', 'TTO', 780, '0', 2),
(221, 'TV', 'Tuvalu', 'TUV', 798, '0', 2),
(208, 'TW', 'Taiwan', 'TWN', 158, '0', 2),
(210, 'TZ', 'Tanzania, United Republic of', 'TZA', 834, '0', 2),
(223, 'UA', 'Ukraine', 'UKR', 804, '0', 2),
(222, 'UG', 'Uganda', 'UGA', 800, '0', 2),
(227, 'UM', 'United States Minor Outlying Islands', 'UMI', 581, '0', 2),
(226, 'US', 'United States', 'USA', 840, '0', 1),
(228, 'UY', 'Uruguay', 'URY', 858, '0', 2),
(229, 'UZ', 'Uzbekistan', 'UZB', 860, '0', 2),
(94, 'VA', 'Holy See (Vatican City State)', 'VAT', 336, '0', 2),
(183, 'VC', 'Saint Vincent and the Grenadines', 'VCT', 670, '0', 2),
(231, 'VE', 'Venezuela', 'VEN', 862, '0', 2),
(233, 'VG', 'Virgin Islands, British', 'VGB', 092, '0', 2),
(234, 'VI', 'Virgin Islands, U.s.', 'VIR', 850, '0', 2),
(232, 'VN', 'Viet Nam', 'VNM', 704, '0', 2),
(230, 'VU', 'Vanuatu', 'VUT', 548, '0', 2),
(235, 'WF', 'Wallis and Futuna', 'WLF', 876, '0', 2),
(184, 'WS', 'Samoa', 'WSM', 882, '0', 2),
(237, 'YE', 'Yemen', 'YEM', 887, '0', 2),
(137, 'YT', 'Mayotte', 'MYT', 175, '0', 2),
(197, 'ZA', 'South Africa', 'ZAF', 710, '0', 2),
(238, 'ZM', 'Zambia', 'ZMB', 894, '0', 2),
(239, 'ZW', 'Zimbabwe', 'ZWE', 716, '0', 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_geo_zone`
--

CREATE TABLE `[[dbprefix]]CubeCart_geo_zone` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` smallint(4) unsigned NOT NULL DEFAULT '0',
  `abbrev` varbinary(4) NOT NULL DEFAULT '',
  `name` varbinary(40) NOT NULL DEFAULT '',
  `status` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_id` (`country_id`,`abbrev`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=705 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_geo_zone`
--

INSERT INTO `[[dbprefix]]CubeCart_geo_zone` VALUES
(1, 226, 'AL', 'Alabama', '1'),
(2, 226, 'AK', 'Alaska', '1'),
(3, 226, 'AS', 'American Samoa', '1'),
(4, 226, 'AZ', 'Arizona', '1'),
(5, 226, 'AR', 'Arkansas', '1'),
(6, 226, 'AF', 'Armed Forces Africa', '1'),
(7, 226, 'AA', 'Armed Forces Americas', '1'),
(8, 226, 'AC', 'Armed Forces Canada', '1'),
(9, 226, 'AE', 'Armed Forces Europe', '1'),
(10, 226, 'AM', 'Armed Forces Middle East', '1'),
(11, 226, 'AP', 'Armed Forces Pacific', '1'),
(12, 226, 'CA', 'California', '1'),
(13, 226, 'CO', 'Colorado', '1'),
(14, 226, 'CT', 'Connecticut', '1'),
(15, 226, 'DE', 'Delaware', '1'),
(16, 226, 'DC', 'District of Columbia', '1'),
(17, 226, 'FM', 'Federated States Of Micronesia', '1'),
(18, 226, 'FL', 'Florida', '1'),
(19, 226, 'GA', 'Georgia', '1'),
(20, 226, 'GU', 'Guam', '1'),
(21, 226, 'HI', 'Hawaii', '1'),
(22, 226, 'ID', 'Idaho', '1'),
(23, 226, 'IL', 'Illinois', '1'),
(24, 226, 'IN', 'Indiana', '1'),
(25, 226, 'IA', 'Iowa', '1'),
(26, 226, 'KS', 'Kansas', '1'),
(27, 226, 'KY', 'Kentucky', '1'),
(28, 226, 'LA', 'Louisiana', '1'),
(29, 226, 'ME', 'Maine', '1'),
(30, 226, 'MH', 'Marshall Islands', '1'),
(31, 226, 'MD', 'Maryland', '1'),
(32, 226, 'MA', 'Massachusetts', '1'),
(33, 226, 'MI', 'Michigan', '1'),
(34, 226, 'MN', 'Minnesota', '1'),
(35, 226, 'MS', 'Mississippi', '1'),
(36, 226, 'MO', 'Missouri', '1'),
(37, 226, 'MT', 'Montana', '1'),
(38, 226, 'NE', 'Nebraska', '1'),
(39, 226, 'NV', 'Nevada', '1'),
(40, 226, 'NH', 'New Hampshire', '1'),
(41, 226, 'NJ', 'New Jersey', '1'),
(42, 226, 'NM', 'New Mexico', '1'),
(43, 226, 'NY', 'New York', '1'),
(44, 226, 'NC', 'North Carolina', '1'),
(45, 226, 'ND', 'North Dakota', '1'),
(46, 226, 'MP', 'Northern Mariana Islands', '1'),
(47, 226, 'OH', 'Ohio', '1'),
(48, 226, 'OK', 'Oklahoma', '1'),
(49, 226, 'OR', 'Oregon', '1'),
(50, 226, 'PW', 'Palau', '1'),
(51, 226, 'PA', 'Pennsylvania', '1'),
(52, 226, 'PR', 'Puerto Rico', '1'),
(53, 226, 'RI', 'Rhode Island', '1'),
(54, 226, 'SC', 'South Carolina', '1'),
(55, 226, 'SD', 'South Dakota', '1'),
(56, 226, 'TN', 'Tennessee', '1'),
(57, 226, 'TX', 'Texas', '1'),
(58, 226, 'UT', 'Utah', '1'),
(59, 226, 'VT', 'Vermont', '1'),
(60, 226, 'VI', 'Virgin Islands', '1'),
(61, 226, 'VA', 'Virginia', '1'),
(62, 226, 'WA', 'Washington', '1'),
(63, 226, 'WV', 'West Virginia', '1'),
(64, 226, 'WI', 'Wisconsin', '1'),
(65, 226, 'WY', 'Wyoming', '1'),
(66, 38, 'AB', 'Alberta', '1'),
(67, 38, 'BC', 'British Columbia', '1'),
(68, 38, 'MB', 'Manitoba', '1'),
(69, 38, 'NF', 'Newfoundland', '1'),
(70, 38, 'NB', 'New Brunswick', '1'),
(71, 38, 'NS', 'Nova Scotia', '1'),
(72, 38, 'NT', 'Northwest Territories', '1'),
(73, 38, 'NU', 'Nunavut', '1'),
(74, 38, 'ON', 'Ontario', '1'),
(75, 38, 'PE', 'Prince Edward Island', '1'),
(76, 38, 'QC', 'Quebec', '1'),
(77, 38, 'SK', 'Saskatchewan', '1'),
(78, 38, 'YT', 'Yukon Territory', '1'),
(79, 80, 'NDS', 'Niedersachsen', '1'),
(80, 80, 'BAW', 'Baden-Württemberg', '1'),
(81, 80, 'BAY', 'Bayern', '1'),
(82, 80, 'BER', 'Berlin', '1'),
(83, 80, 'BRG', 'Brandenburg', '1'),
(84, 80, 'BRE', 'Bremen', '1'),
(85, 80, 'HAM', 'Hamburg', '1'),
(86, 80, 'HES', 'Hessen', '1'),
(87, 80, 'MEC', 'Mecklenburg-Vorpommern', '1'),
(88, 80, 'NRW', 'Nordrhein-Westfalen', '1'),
(89, 80, 'RHE', 'Rheinland-Pfalz', '1'),
(90, 80, 'SAR', 'Saarland', '1'),
(91, 80, 'SAS', 'Sachsen', '1'),
(92, 80, 'SAC', 'Sachsen-Anhalt', '1'),
(93, 80, 'SCN', 'Schleswig-Holstein', '1'),
(94, 80, 'THE', 'Thüringen', '1'),
(95, 14, 'WIE', 'Wien', '1'),
(96, 14, 'NO', 'NiederÖsterreich', '1'),
(97, 14, 'OO', 'OberÖsterreich', '1'),
(98, 14, 'SB', 'Salzburg', '1'),
(99, 14, 'KN', 'Kärnten', '1'),
(100, 14, 'ST', 'Steiermark', '1'),
(101, 14, 'TI', 'Tirol', '1'),
(102, 14, 'BL', 'Burgenland', '1'),
(103, 14, 'VB', 'Voralberg', '1'),
(104, 206, 'AG', 'Aargau', '1'),
(105, 206, 'AI', 'Appenzell Innerrhoden', '1'),
(106, 206, 'APP', 'Appenzell Ausserrhoden', '1'),
(107, 206, 'BE', 'Bern', '1'),
(108, 206, 'BLA', 'Basel-Landschaft', '1'),
(109, 206, 'BS', 'Basel-Stadt', '1'),
(110, 206, 'FR', 'Freiburg', '1'),
(111, 206, 'GE', 'Genf', '1'),
(112, 206, 'GL', 'Glarus', '1'),
(113, 206, 'JUB', 'Graubünden', '1'),
(114, 206, 'JU', 'Jura', '1'),
(115, 206, 'LU', 'Luzern', '1'),
(116, 206, 'NEU', 'Neuenburg', '1'),
(117, 206, 'NW', 'Nidwalden', '1'),
(118, 206, 'OW', 'Obwalden', '1'),
(119, 206, 'SG', 'St. Gallen', '1'),
(120, 206, 'SH', 'Schaffhausen', '1'),
(121, 206, 'SO', 'Solothurn', '1'),
(122, 206, 'SZ', 'Schwyz', '1'),
(123, 206, 'TG', 'Thurgau', '1'),
(124, 206, 'TE', 'Tessin', '1'),
(125, 206, 'UR', 'Uri', '1'),
(126, 206, 'VD', 'Waadt', '1'),
(127, 206, 'VS', 'Wallis', '1'),
(128, 206, 'ZG', 'Zug', '1'),
(129, 206, 'ZH', 'Zürich', '1'),
(130, 199, 'ACOR', 'A Coruña', '1'),
(131, 199, 'ALAV', 'Alava', '1'),
(132, 199, 'ALBA', 'Albacete', '1'),
(133, 199, 'ALIC', 'Alicante', '1'),
(134, 199, 'ALME', 'Almeria', '1'),
(135, 199, 'ASTU', 'Asturias', '1'),
(136, 199, 'AVIL', 'Avila', '1'),
(137, 199, 'BADA', 'Badajoz', '1'),
(138, 199, 'BALE', 'Baleares', '1'),
(139, 199, 'BARC', 'Barcelona', '1'),
(140, 199, 'BURG', 'Burgos', '1'),
(141, 199, 'CACE', 'Caceres', '1'),
(142, 199, 'CADI', 'Cadiz', '1'),
(143, 199, 'CANT', 'Cantabria', '1'),
(144, 199, 'CAST', 'Castellon', '1'),
(145, 199, 'CEUT', 'Ceuta', '1'),
(146, 199, 'CIUD', 'Ciudad Real', '1'),
(147, 199, 'CORD', 'Cordoba', '1'),
(148, 199, 'CUEN', 'Cuenca', '1'),
(149, 199, 'GIRO', 'Girona', '1'),
(150, 199, 'GRAN', 'Granada', '1'),
(151, 199, 'GUAD', 'Guadalajara', '1'),
(152, 199, 'GUIP', 'Guipuzcoa', '1'),
(153, 199, 'HUEL', 'Huelva', '1'),
(154, 199, 'HUES', 'Huesca', '1'),
(155, 199, 'JAEN', 'Jaen', '1'),
(156, 199, 'LAR', 'La Rioja', '1'),
(157, 199, 'LAS', 'Las Palmas', '1'),
(158, 199, 'LEON', 'Leon', '1'),
(159, 199, 'LLEI', 'Lleida', '1'),
(160, 199, 'LUGO', 'Lugo', '1'),
(161, 199, 'MADR', 'Madrid', '1'),
(162, 199, 'MALA', 'Malaga', '1'),
(163, 199, 'MELI', 'Melilla', '1'),
(164, 199, 'MURC', 'Murcia', '1'),
(165, 199, 'NAVA', 'Navarra', '1'),
(166, 199, 'OURE', 'Ourense', '1'),
(167, 199, 'PALE', 'Palencia', '1'),
(168, 199, 'PONT', 'Pontevedra', '1'),
(169, 199, 'SALA', 'Salamanca', '1'),
(170, 199, 'SANT', 'Santa Cruz de Tenerife', '1'),
(171, 199, 'SEGO', 'Segovia', '1'),
(172, 199, 'SEVI', 'Sevilla', '1'),
(173, 199, 'SORI', 'Soria', '1'),
(174, 199, 'TARR', 'Tarragona', '1'),
(175, 199, 'TERU', 'Teruel', '1'),
(176, 199, 'TOLE', 'Toledo', '1'),
(177, 199, 'VALE', 'Valencia', '1'),
(178, 199, 'VALL', 'Valladolid', '1'),
(179, 199, 'VIZC', 'Vizcaya', '1'),
(180, 199, 'ZAMO', 'Zamora', '1'),
(181, 199, 'ZARA', 'Zaragoza', '1'),
(415, 103, 'CW', 'Carlow', '1'),
(416, 103, 'CN', 'Cavan', '1'),
(417, 103, 'CE', 'Clare', '1'),
(418, 103, 'C', 'Cork', '1'),
(419, 103, 'DL', 'Donegal', '1'),
(420, 103, 'D', 'Dublin', '1'),
(421, 103, 'G', 'Galway', '1'),
(422, 103, 'KY', 'Kerry', '1'),
(423, 103, 'KE', 'Kildare', '1'),
(424, 103, 'KK', 'Kilkenny', '1'),
(425, 103, 'LS', 'Laois', '1'),
(426, 103, 'LM', 'Leitrim', '1'),
(427, 103, 'LK', 'Limerick', '1'),
(428, 103, 'LD', 'Longford', '1'),
(429, 103, 'LH', 'Louth', '1'),
(430, 103, 'MO', 'Mayo', '1'),
(431, 103, 'MH', 'Meath', '1'),
(432, 103, 'MN', 'Monaghan', '1'),
(433, 103, 'OY', 'Offaly', '1'),
(434, 103, 'RN', 'Roscommon', '1'),
(435, 103, 'SO', 'Sligo', '1'),
(436, 103, 'TA', 'Tipperary', '1'),
(437, 103, 'WD', 'Waterford', '1'),
(438, 103, 'WH', 'Westmeath', '1'),
(439, 103, 'WX', 'Wexford', '1'),
(440, 103, 'WW', 'Wicklow', '1'),
(441, 225, 'AVN', 'Avon', '1'),
(442, 225, 'BDF', 'Bedfordshire', '1'),
(443, 225, 'BRK', 'Berkshire', '1'),
(444, 225, 'BKM', 'Buckinghamshire', '1'),
(445, 225, 'CAM', 'Cambridgeshire', '1'),
(446, 225, 'CHS', 'Cheshire', '1'),
(447, 225, 'CLV', 'Cleveland', '1'),
(448, 225, 'CON', 'Cornwall', '1'),
(449, 225, 'CUL', 'Cumberland', '1'),
(450, 225, 'CMA', 'Cumbria', '1'),
(451, 225, 'DBY', 'Derbyshire', '1'),
(452, 225, 'DEV', 'Devon', '1'),
(453, 225, 'DOR', 'Dorset', '1'),
(454, 225, 'DUR', 'County Durham', '1'),
(455, 225, 'ESS', 'Essex', '1'),
(456, 225, 'GLS', 'Gloucestershire', '1'),
(457, 225, 'HAM', 'Hampshire', '1'),
(458, 225, 'HWR', 'Hereford and Worcester', '1'),
(459, 225, 'HEF', 'Herefordshire', '1'),
(460, 225, 'HRT', 'Hertfordshire', '1'),
(461, 225, 'HUM', 'Humberside', '1'),
(462, 225, 'HUN', 'Huntingdonshire', '1'),
(463, 225, 'IOW', 'Isle of Wight', '1'),
(464, 225, 'KEN', 'Kent', '1'),
(465, 225, 'LAN', 'Lancashire', '1'),
(466, 225, 'LEI', 'Leicestershire', '1'),
(467, 225, 'LIN', 'Lincolnshire', '1'),
(468, 225, 'GTM', 'Greater Manchester', '1'),
(469, 225, 'GTL', 'Greater London', '1'),
(470, 225, 'MSY', 'Merseyside', '1'),
(471, 225, 'MDX', 'Middlesex', '1'),
(472, 225, 'NFK', 'Norfolk', '1'),
(473, 225, 'NTH', 'Northamptonshire', '1'),
(474, 225, 'NBL', 'Northumberland', '1'),
(475, 225, 'NTT', 'Nottinghamshire', '1'),
(476, 225, 'OXF', 'Oxfordshire', '1'),
(477, 225, 'RUT', 'Rutland', '1'),
(478, 225, 'SAL', 'Shropshire', '1'),
(479, 225, 'SOM', 'Somerset', '1'),
(480, 225, 'STS', 'Staffordshire', '1'),
(481, 225, 'SFK', 'Suffolk', '1'),
(482, 225, 'SRY', 'Surrey', '1'),
(484, 225, 'TWR', 'Tyne and Wear', '1'),
(485, 225, 'WAR', 'Warwickshire', '1'),
(486, 225, 'WMD', 'West Midlands', '1'),
(487, 225, 'WES', 'Westmorland', '1'),
(488, 225, 'WIL', 'Wiltshire', '1'),
(489, 225, 'WOR', 'Worcestershire', '1'),
(491, 225, 'ABD', 'Aberdeenshire', '1'),
(492, 225, 'ANS', 'Angus', '1'),
(493, 225, 'ARL', 'Argyll', '1'),
(494, 225, 'AYR', 'Ayrshire', '1'),
(495, 225, 'BAN', 'Banffshire', '1'),
(496, 225, 'BEW', 'Berwickshire', '1'),
(497, 225, 'BUT', 'Bute', '1'),
(498, 225, 'CAI', 'Caithness', '1'),
(499, 225, 'CLK', 'Clackmannanshire', '1'),
(500, 225, 'CRO', 'Cromartyshire', '1'),
(501, 225, 'DFS', 'Dumfriesshire', '1'),
(502, 225, 'DNB', 'Dunbartonshire', '1'),
(503, 225, 'ELN', 'East Lothian', '1'),
(504, 225, 'FIF', 'Fife', '1'),
(505, 225, 'INV', 'Inverness-shire', '1'),
(506, 225, 'KRS', 'Kinross-shire', '1'),
(507, 225, 'KKD', 'Kirkcudbrightshire', '1'),
(508, 225, 'LKS', 'Lanarkshire', '1'),
(509, 225, 'MLN', 'Midlothian', '1'),
(510, 225, 'MOR', 'Moray', '1'),
(511, 225, 'NAI', 'Nairnshire', '1'),
(512, 225, 'OKI', 'Orkney', '1'),
(513, 225, 'PEE', 'Peeblesshire', '1'),
(514, 225, 'PER', 'Perthshire', '1'),
(515, 225, 'RFW', 'Renfrewshire', '1'),
(516, 225, 'ROC', 'Ross', '1'),
(517, 225, 'ROX', 'Roxburghshire', '1'),
(518, 225, 'SEL', 'Selkirkshire', '1'),
(519, 225, 'SHI', 'Shetland', '1'),
(520, 225, 'STI', 'Stirlingshire', '1'),
(521, 225, 'SUT', 'Sutherland', '1'),
(522, 225, 'WLN', 'West Lothian', '1'),
(523, 225, 'WIG', 'Wigtownshire', '1'),
(524, 225, 'AGY', 'Anglesey', '1'),
(525, 225, 'BRN', 'Brecknockshire', '1'),
(526, 225, 'CAE', 'Caernarfonshire', '1'),
(527, 225, 'CAD', 'Ceredigion', '1'),
(528, 225, 'CRR', 'Carmarthenshire', '1'),
(529, 225, 'CLW', 'Clwyd', '1'),
(530, 225, 'DEN', 'Denbighshire', '1'),
(531, 225, 'DFD', 'Dyfed', '1'),
(532, 225, 'FLN', 'Flintshire', '1'),
(533, 225, 'GLA', 'Glamorgan', '1'),
(534, 225, 'GNT', 'Gwent', '1'),
(535, 225, 'GWN', 'Gwynedd', '1'),
(536, 225, 'MER', 'Merionethshire', '1'),
(537, 225, 'MON', 'Monmouthshire', '1'),
(538, 225, 'MGY', 'Montgomeryshire', '1'),
(539, 225, 'PEM', 'Pembrokeshire', '1'),
(540, 225, 'POW', 'Powys', '1'),
(541, 225, 'RAD', 'Radnorshire', '1'),
(542, 225, 'ANT', 'Antrim', '1'),
(543, 225, 'ARM', 'Armagh', '1'),
(544, 225, 'LDY', 'Londonderry', '1'),
(545, 225, 'DOW', 'Down', '1'),
(546, 225, 'FER', 'Fermanagh', '1'),
(547, 225, 'TYR', 'Tyrone', '1'),
(548, 150, 'DR', 'Drenthe', '1'),
(549, 150, 'FL', 'Flevoland', '1'),
(550, 150, 'FR', 'Friesland', '1'),
(551, 150, 'GLD', 'Gelderland', '1'),
(552, 150, 'GR', 'Groningen', '1'),
(553, 150, 'LI', 'Limburg', '1'),
(554, 150, 'NB', 'Noord-Brabant', '1'),
(555, 150, 'NH', 'Noord-Holland', '1'),
(556, 150, 'OV', 'Overijssel', '1'),
(557, 150, 'UT', 'Utrecht', '1'),
(558, 150, 'ZL', 'Zeeland', '1'),
(559, 150, 'ZH', 'Zuid-Holland', '1'),
(560, 13, 'ACT', 'Australian Capital Territory', '1'),
(561, 13, 'NSW', 'New South Wales', '1'),
(562, 13, 'NT', 'Northern Territory', '1'),
(563, 13, 'QLD', 'Queensland', '1'),
(564, 13, 'SA', 'South Australia', '1'),
(565, 13, 'TAS', 'Tasmania', '1'),
(566, 13, 'VIC', 'Victoria', '1'),
(567, 13, 'WA', 'Western Australia', '1'),
(568, 225, 'SXE', 'East Sussex', '1'),
(569, 225, 'SXW', 'West Sussex', '1'),
(570, 225, 'YSN', 'North Yorkshire', '1'),
(571, 225, 'YSS', 'South Yorkshire', '1'),
(572, 225, 'YSW', 'West Yorkshire', '1'),
(573, 225, 'ERY', 'East Yorkshire', '1'),
(574, 225, 'LND', 'London', '1'),
(575, 10, 'CT', 'Catamarca', '1'),
(576, 10, 'CC', 'Chaco', '1'),
(577, 10, 'CH', 'Chubut', '1'),
(578, 10, 'DF', 'Ciudad de Buenos Aires', '1'),
(579, 10, 'CN', 'Corrientes', '1'),
(580, 10, 'CB', 'Córdoba', '1'),
(581, 10, 'ER', 'Entre Ríos', '1'),
(582, 10, 'FM', 'Formosa', '1'),
(583, 10, 'JY', 'Jujuy', '1'),
(584, 10, 'LP', 'La Pampa', '1'),
(585, 10, 'LR', 'La Rioja', '1'),
(586, 10, 'MZ', 'Mendoza', '1'),
(587, 10, 'MN', 'Misiones', '1'),
(588, 10, 'NQ', 'Neuquén', '1'),
(589, 10, 'RN', 'Río Negro', '1'),
(590, 10, 'SA', 'Salta', '1'),
(591, 10, 'SJ', 'San Juan', '1'),
(592, 10, 'SL', 'San Luis', '1'),
(593, 10, 'SC', 'Santa Cruz', '1'),
(594, 10, 'SF', 'Santa Fe', '1'),
(595, 10, 'SE', 'Santiago del Estero', '1'),
(596, 10, 'TF', 'Tierra del Fuego', '1'),
(597, 10, 'TM', 'Tucumán', '1'),
(598, 30, 'AC', 'Acre', '1'),
(599, 30, 'AL', 'Alagoas', '1'),
(600, 30, 'AP', 'Amapá', '1'),
(601, 30, 'AM', 'Amazonas', '1'),
(602, 30, 'BA', 'Bahia', '1'),
(603, 30, 'CE', 'Ceará', '1'),
(604, 30, 'DF', 'Distrito Federal', '1'),
(605, 30, 'ES', 'Espírito Santo', '1'),
(606, 30, 'GO', 'Goiás', '1'),
(607, 30, 'MA', 'Maranhão', '1'),
(608, 30, 'MT', 'Mato Grosso', '1'),
(609, 30, 'MS', 'Mato Grosso do Sul', '1'),
(610, 30, 'MG', 'Minas Gerais', '1'),
(611, 30, 'PR', 'Paraná', '1'),
(612, 30, 'PB', 'Paraíba', '1'),
(613, 30, 'PA', 'Pará', '1'),
(614, 30, 'PE', 'Pemambuco', '1'),
(615, 30, 'PI', 'Piauí', '1'),
(616, 30, 'RN', 'Rio Grande do Norte', '1'),
(617, 30, 'RS', 'Rio Grande do Sul', '1'),
(618, 30, 'RJ', 'Rio de Janeiro', '1'),
(619, 30, 'RO', 'Rondônia', '1'),
(620, 30, 'RR', 'Roraima', '1'),
(621, 30, 'SC', 'Santa Catarina', '1'),
(622, 30, 'SE', 'Sergipe', '1'),
(623, 30, 'SP', 'São Paulo', '1'),
(624, 30, 'TO', 'Tocatins', '1'),
(625, 99, 'INAN', 'Andaman and Nicobar Islands', '1'),
(626, 99, 'INAP', 'Andhra Pradesh', '1'),
(627, 99, 'INAR', 'Arunachal Pradesh', '1'),
(628, 99, 'INAS', 'Assam', '1'),
(629, 99, 'INBR', 'Bihar', '1'),
(630, 99, 'INCH', 'Chandigarh', '1'),
(631, 99, 'INCT', 'Chhattisgarh', '1'),
(632, 99, 'INDN', 'Dadra and Nagar Haveli', '1'),
(633, 99, 'INDD', 'Daman and Diu', '1'),
(634, 99, 'INDL', 'Delhi', '1'),
(635, 99, 'INGA', 'Goa', '1'),
(636, 99, 'INGJ', 'Gujarat', '1'),
(637, 99, 'INHR', 'Haryana', '1'),
(638, 99, 'INHP', 'Himachal Pradesh', '1'),
(639, 99, 'INJK', 'Jammu and Kashmir', '1'),
(640, 99, 'INJH', 'Jharkhand', '1'),
(641, 99, 'INKA', 'Karnataka', '1'),
(642, 99, 'INKL', 'Kerala', '1'),
(643, 99, 'INLD', 'Lakshadweep', '1'),
(644, 99, 'INMP', 'Madhya Pradesh', '1'),
(645, 99, 'INMH', 'Maharashtra', '1'),
(646, 99, 'INMN', 'Manipur', '1'),
(647, 99, 'INML', 'Meghalaya', '1'),
(648, 99, 'INMZ', 'Mizoram', '1'),
(649, 99, 'INNL', 'Nagaland', '1'),
(650, 99, 'INOR', 'Odisha', '1'),
(651, 99, 'INPY', 'Puducherry', '1'),
(652, 99, 'INPB', 'Punjab', '1'),
(653, 99, 'INRJ', 'Rajasthan', '1'),
(654, 99, 'INSK', 'Sikkim', '1'),
(655, 99, 'INTN', 'Tamil Nadu', '1'),
(656, 99, 'INTG', 'Telangana', '1'),
(657, 99, 'INTR', 'Tripura', '1'),
(658, 99, 'INUP', 'Uttar Pradesh', '1'),
(659, 99, 'INWB', 'West Bengal', '1'),
(660, 107, 'AI', 'Aichi', '1'),
(661, 107, 'AK', 'Akita', '1'),
(662, 107, 'AO', 'Aomori', '1'),
(663, 107, 'CH', 'Chiba', '1'),
(664, 107, 'EH', 'Ehime', '1'),
(665, 107, 'FI', 'Fukui', '1'),
(666, 107, 'FA', 'Fukuoka', '1'),
(667, 107, 'GI', 'Gifu', '1'),
(668, 107, 'GU', 'Gunma', '1'),
(669, 107, 'HI', 'Hiroshima', '1'),
(670, 107, 'HO', 'Hokkaido', '1'),
(671, 107, 'HY', 'Hyogo', '1'),
(672, 107, 'IB', 'Ibaraki', '1'),
(673, 107, 'IS', 'Ishikawa', '1'),
(674, 107, 'IW', 'Iwate', '1'),
(675, 107, 'KAG', 'Kagawa', '1'),
(676, 107, 'KAN', 'Kanagawa', '1'),
(677, 107, 'KO', 'Kochi', '1'),
(678, 107, 'KU', 'Kumamoto', '1'),
(679, 107, 'KY', 'Kyoto', '1'),
(680, 107, 'MIE', 'Mie', '1'),
(681, 107, 'MIGI', 'Miyagi', '1'),
(682, 107, 'MIKI', 'Miyazaki', '1'),
(683, 107, 'NAO', 'Nagano', '1'),
(684, 107, 'NAKI', 'Nagasaki', '1'),
(685, 107, 'NARA', 'Nara', '1'),
(686, 107, 'NI', 'Niigata', '1'),
(687, 107, 'OI', 'Oita', '1'),
(688, 107, 'OKA', 'Okayama', '1'),
(689, 107, 'OKI', 'Okinawa', '1'),
(690, 107, 'OS', 'Osaka', '1'),
(691, 107, 'SAGA', 'Saga', '1'),
(692, 107, 'SAIT', 'Saitama', '1'),
(693, 107, 'SHGA', 'Shiga', '1'),
(694, 107, 'SHNE', 'Shimane', '1'),
(695, 107, 'SHKA', 'Shizuoka', '1'),
(696, 107, 'TOCH', 'Tochigi', '1'),
(697, 107, 'TOKU', 'Tokushima', '1'),
(698, 107, 'TOKY', 'Tokyo', '1'),
(699, 107, 'TOTT', 'Tottori', '1'),
(700, 107, 'TOY', 'Toyama', '1'),
(701, 107, 'WAK', 'Wakayama', '1'),
(702, 107, 'YATA', 'Yamagata', '1'),
(703, 107, 'YAGU', 'Yamaguchi', '1'),
(704, 107, 'YANA', 'Yamanashi', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_history`
--

CREATE TABLE `[[dbprefix]]CubeCart_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_history`
--

INSERT INTO `[[dbprefix]]CubeCart_history` VALUES
(1, '6.5.12', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_hooks`
--

CREATE TABLE `[[dbprefix]]CubeCart_hooks` (
  `hook_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hook_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'A descriptive name for the hook',
  `enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'All hooks should be disabled by DEFAULT',
  `trigger` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The trigger used to call the hook',
  `filepath` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`hook_id`),
  KEY `trigger` (`trigger`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_image_index`
--

CREATE TABLE `[[dbprefix]]CubeCart_image_index` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `file_id` int(10) unsigned NOT NULL,
  `main_img` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_inventory`
--

CREATE TABLE `[[dbprefix]]CubeCart_inventory` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product ID',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Status',
  `live_from` int(11) NOT NULL DEFAULT '0',
  `product_code` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Product Code',
  `quantity` int(11) NOT NULL DEFAULT '1' COMMENT 'Quantity',
  `description` text COLLATE utf8mb4_unicode_ci COMMENT 'Description',
  `description_short` text COLLATE utf8mb4_unicode_ci COMMENT 'Short Description',
  `price` decimal(16,2) NOT NULL DEFAULT '0.00' COMMENT 'Retail Price',
  `sale_price` decimal(16,2) NOT NULL DEFAULT '0.00' COMMENT 'Sale Price',
  `cost_price` decimal(16,2) NOT NULL DEFAULT '0.00' COMMENT 'Cost Price',
  `name` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Product Name',
  `cat_id` int(10) unsigned DEFAULT '0' COMMENT 'Main Category ID',
  `popularity` int(10) unsigned DEFAULT '0' COMMENT 'Popularity',
  `stock_level` int(11) DEFAULT '0' COMMENT 'Main Stock Level',
  `stock_warning` int(10) NOT NULL DEFAULT '0' COMMENT 'Main Stock Warning level',
  `use_stock_level` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Use Stock Control',
  `digital` int(4) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Digital?',
  `digital_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Digital Path',
  `product_weight` decimal(10,4) DEFAULT NULL COMMENT 'Product Weight',
  `product_width` decimal(10,4) DEFAULT NULL COMMENT 'Product Width',
  `product_height` decimal(10,4) DEFAULT NULL COMMENT 'Product Height',
  `product_depth` decimal(10,4) DEFAULT NULL COMMENT 'Product Depth',
  `dimension_unit` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT 'cm' COMMENT 'Product Dimension Unit',
  `tax_type` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Tax Type',
  `tax_inclusive` tinyint(1) unsigned DEFAULT '0' COMMENT 'Price inclusive of tax',
  `featured` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Featured product',
  `latest` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Included on Homepage',
  `seo_meta_title` text COLLATE utf8mb4_unicode_ci COMMENT 'SEO Meta Title',
  `seo_meta_description` text COLLATE utf8mb4_unicode_ci COMMENT 'SEO Meta Description',
  `seo_meta_keywords` text COLLATE utf8mb4_unicode_ci COMMENT 'SEO Meta Keywords',
  `upc` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'UPC Code',
  `ean` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'EAN Code',
  `jan` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JAN Code',
  `isbn` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ISBN Code',
  `brand` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Brand',
  `google_category` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Google Cat',
  `gtin` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'GTIN Code',
  `mpn` varchar(70) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'MPN Code',
  `date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date Added',
  `updated` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Last Updated',
  `manufacturer` int(10) unsigned DEFAULT NULL COMMENT 'Manufacturer ID',
  `condition` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Condition',
  `available` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `minimum_quantity` int(10) NOT NULL DEFAULT '1',
  `maximum_quantity` int(10) NOT NULL DEFAULT '0',
  `product_parse` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `manufacture_country` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `spec_array` text COLLATE utf8mb4_unicode_ci,
  `spec_copy` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`product_id`),
  KEY `status` (`status`),
  KEY `live_from` (`live_from`),
  KEY `popularity` (`popularity`),
  KEY `featured` (`featured`),
  KEY `use_stock_level` (`use_stock_level`),
  FULLTEXT KEY `fulltext` (`product_code`,`description`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_inventory`
--

INSERT INTO `[[dbprefix]]CubeCart_inventory` VALUES
(1, 1, 0, 'TESA31', 1, 'This is the main copy for the product.', NULL, '10.00', '6.99', '0.00', 'Test Product', 1, 0, 0, 0, 0, 0, NULL, '4.0000', NULL, NULL, NULL, 'cm', 1, 0, 1, 1, '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', '0000-00-00 00:00:00', NULL, NULL, '1', 1, 0, 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_inventory_language`
--

CREATE TABLE `[[dbprefix]]CubeCart_inventory_language` (
  `translation_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `language` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description_short` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `seo_meta_title` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_description` text COLLATE utf8mb4_unicode_ci,
  `seo_meta_keywords` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`translation_id`),
  KEY `language` (`language`),
  FULLTEXT KEY `fulltext` (`name`,`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_invoice_template`
--

CREATE TABLE `[[dbprefix]]CubeCart_invoice_template` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_ci,
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `hash` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_lang_strings`
--

CREATE TABLE `[[dbprefix]]CubeCart_lang_strings` (
  `string_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`string_id`),
  KEY `language` (`language`),
  KEY `type` (`type`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_logo`
--

CREATE TABLE `[[dbprefix]]CubeCart_logo` (
  `logo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) unsigned NOT NULL,
  `filename` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mimetype` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(10) unsigned NOT NULL,
  `height` int(10) unsigned NOT NULL,
  `skin` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `style` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`logo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_manufacturers`
--

CREATE TABLE `[[dbprefix]]CubeCart_manufacturers` (
  `id` int(10) unsigned NOT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `URL` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` int(10) unsigned DEFAULT NULL,
  `line1` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `line2` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `town` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `postcode` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` mediumint(3) NOT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_line1` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_line2` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_town` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_postcode` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_country` mediumint(3) NOT NULL,
  `eu_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eu_contact_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_modules`
--

CREATE TABLE `[[dbprefix]]CubeCart_modules` (
  `module_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `countries` tinytext COLLATE utf8mb4_unicode_ci,
  `position` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`module_id`),
  KEY `folder` (`folder`),
  KEY `status` (`status`),
  KEY `module` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_newsletter`
--

CREATE TABLE `[[dbprefix]]CubeCart_newsletter` (
  `newsletter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `template_id` int(10) unsigned NOT NULL,
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_sent` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_email` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_newsletter_subscriber`
--

CREATE TABLE `[[dbprefix]]CubeCart_newsletter_subscriber` (
  `subscriber_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `validation` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` datetime DEFAULT NULL,
  `imported` tinyint(1) DEFAULT '0',
  `dbl_opt` tinyint(1) DEFAULT '0',
  `remove_token` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`subscriber_id`),
  KEY `customer_id` (`customer_id`),
  KEY `email` (`email`),
  KEY `dbl_opt` (`dbl_opt`),
  KEY `status` (`status`),
  KEY `remove_token` (`remove_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_newsletter_subscriber_log`
--

CREATE TABLE `[[dbprefix]]CubeCart_newsletter_subscriber_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log` text COLLATE utf8mb4_unicode_ci,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_options_set`
--

CREATE TABLE `[[dbprefix]]CubeCart_options_set` (
  `set_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `set_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `set_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_options_set_member`
--

CREATE TABLE `[[dbprefix]]CubeCart_options_set_member` (
  `set_member_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `set_id` int(10) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL,
  `value_id` int(10) unsigned NOT NULL,
  `priority` int(11) NOT NULL,
  PRIMARY KEY (`set_member_id`),
  KEY `set_id` (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_options_set_product`
--

CREATE TABLE `[[dbprefix]]CubeCart_options_set_product` (
  `set_product_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`set_product_id`),
  KEY `set_id` (`set_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_option_assign`
--

CREATE TABLE `[[dbprefix]]CubeCart_option_assign` (
  `assign_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product` int(10) unsigned NOT NULL DEFAULT '0',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value_id` int(10) unsigned NOT NULL DEFAULT '0',
  `set_member_id` int(10) unsigned NOT NULL DEFAULT '0',
  `set_enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `option_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `option_negative` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `option_price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `option_weight` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `matrix_include` tinyint(1) NOT NULL DEFAULT '0',
  `absolute_price` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `image_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`assign_id`),
  KEY `set_member_id` (`set_member_id`),
  KEY `product` (`product`),
  KEY `set_enabled` (`set_enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_option_group`
--

CREATE TABLE `[[dbprefix]]CubeCart_option_group` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `option_type` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `option_required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `priority` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_option_matrix`
--

CREATE TABLE `[[dbprefix]]CubeCart_option_matrix` (
  `matrix_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) unsigned NOT NULL,
  `options_identifier` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cached_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cached_array` text COLLATE utf8mb4_unicode_ci,
  `stock_level` int(11) NOT NULL,
  `use_stock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `product_code` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upc` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ean` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `jan` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isbn` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gtin` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `restock_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`matrix_id`),
  KEY `product_id` (`product_id`),
  KEY `options_identifier` (`options_identifier`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_option_value`
--

CREATE TABLE `[[dbprefix]]CubeCart_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `value_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `priority` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`value_id`),
  KEY `option_id` (`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_order_history`
--

CREATE TABLE `[[dbprefix]]CubeCart_order_history` (
  `history_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cart_order_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `updated` int(10) unsigned NOT NULL DEFAULT '0',
  `initiator` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'G',
  PRIMARY KEY (`history_id`),
  KEY `cart_order_id` (`cart_order_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_order_inventory`
--

CREATE TABLE `[[dbprefix]]CubeCart_order_inventory` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(225) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` smallint(5) unsigned NOT NULL DEFAULT '0',
  `price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `cost_price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `tax` decimal(16,2) NOT NULL DEFAULT '0.00',
  `tax_percent` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `cart_order_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_options` blob,
  `options_array` blob,
  `digital` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `stock_updated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `custom` blob,
  `coupon_id` int(10) unsigned NOT NULL DEFAULT '0',
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `options_identifier` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `cart_order_id` (`cart_order_id`),
  KEY `options_identifier` (`options_identifier`),
  KEY `quantity` (`quantity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_order_notes`
--

CREATE TABLE `[[dbprefix]]CubeCart_order_notes` (
  `note_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) unsigned NOT NULL,
  `cart_order_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `print` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`note_id`),
  KEY `admin_id` (`admin_id`),
  KEY `cart_order_id` (`cart_order_id`),
  KEY `time` (`time`),
  KEY `print` (`print`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_order_summary`
--

CREATE TABLE `[[dbprefix]]CubeCart_order_summary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cart_order_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_date` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `subtotal` decimal(16,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(16,2) NOT NULL DEFAULT '0.00',
  `shipping` decimal(16,2) NOT NULL DEFAULT '0.00',
  `shipping_tax` decimal(16,2) NOT NULL DEFAULT '0.00',
  `shipping_tax_rate` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `total_tax` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `offline_capture` blob,
  `ship_method` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `ship_product` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ship_date` date DEFAULT NULL,
  `ship_tracking` text COLLATE utf8mb4_unicode_ci,
  `gateway` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line1` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `line2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `town` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `postcode` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` smallint(3) unsigned NOT NULL,
  `w3w` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_d` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_name_d` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name_d` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name_d` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line1_d` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `line2_d` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `town_d` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state_d` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `postcode_d` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_d` smallint(3) unsigned NOT NULL,
  `w3w_d` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_comments` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Supports IPv6 addresses',
  `dashboard` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `discount_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'f',
  `basket` mediumblob,
  `lang` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note_to_customer` text COLLATE utf8mb4_unicode_ci,
  `custom_oid` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `credit_used` decimal(8,2) NOT NULL DEFAULT '0.00',
  `credit_shift` tinyint(4) NOT NULL DEFAULT '0',
  `coupon_data` text COLLATE utf8mb4_unicode_ci,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cart_order_id` (`cart_order_id`),
  UNIQUE KEY `custom_oid` (`custom_oid`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `email` (`email`),
  KEY `order_date` (`order_date`),
  KEY `dashboard` (`dashboard`),
  KEY `credit_used` (`credit_used`),
  KEY `credit_shift` (`credit_shift`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_order_tax`
--

CREATE TABLE `[[dbprefix]]CubeCart_order_tax` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cart_order_id` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_id` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(16,2) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_order_id` (`cart_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_permissions`
--

CREATE TABLE `[[dbprefix]]CubeCart_permissions` (
  `permission_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0',
  `section_id` int(10) unsigned NOT NULL DEFAULT '0',
  `level` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `admin_id` (`admin_id`),
  KEY `section_id` (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_pricing_group`
--

CREATE TABLE `[[dbprefix]]CubeCart_pricing_group` (
  `price_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `sale_price` decimal(16,2) NOT NULL DEFAULT '0.00',
  `tax_type` int(10) unsigned NOT NULL,
  `tax_inclusive` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`price_id`),
  KEY `group_id` (`group_id`),
  KEY `product_id` (`product_id`),
  KEY `tax_type` (`tax_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_pricing_quantity`
--

CREATE TABLE `[[dbprefix]]CubeCart_pricing_quantity` (
  `discount_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `quantity` int(10) unsigned NOT NULL,
  `price` decimal(16,2) NOT NULL,
  PRIMARY KEY (`discount_id`),
  KEY `product_id` (`product_id`),
  KEY `group_id` (`group_id`),
  KEY `quantity` (`quantity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_request_log`
--

CREATE TABLE `[[dbprefix]]CubeCart_request_log` (
  `request_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `request_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request` blob NOT NULL,
  `result` blob NOT NULL,
  `response_code` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_curl` enum('1','0') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` blob NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `request_headers` blob,
  `response_headers` blob,
  PRIMARY KEY (`request_id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_reviews`
--

CREATE TABLE `[[dbprefix]]CubeCart_reviews` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `approved` smallint(1) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(10) unsigned NOT NULL DEFAULT '0',
  `rating` decimal(2,1) unsigned NOT NULL DEFAULT '0.0',
  `vote_up` int(11) NOT NULL DEFAULT '0',
  `vote_down` int(11) NOT NULL DEFAULT '0',
  `anon` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `review` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Supports IPv6 addresses',
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `vote_up` (`vote_up`),
  KEY `vote_down` (`vote_down`),
  KEY `approved` (`approved`),
  FULLTEXT KEY `fulltext` (`name`,`email`,`title`,`review`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_saved_cart`
--

CREATE TABLE `[[dbprefix]]CubeCart_saved_cart` (
  `customer_id` int(10) unsigned NOT NULL,
  `basket` mediumblob NOT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_search`
--

CREATE TABLE `[[dbprefix]]CubeCart_search` (
  `id` int(64) unsigned NOT NULL AUTO_INCREMENT,
  `hits` int(64) NOT NULL DEFAULT '1',
  `searchstr` varbinary(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_seo_urls`
--

CREATE TABLE `[[dbprefix]]CubeCart_seo_urls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` int(25) unsigned DEFAULT NULL,
  `custom` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `redirect` enum('0','301','302') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `path` (`path`),
  KEY `type` (`type`),
  KEY `item_id` (`item_id`),
  KEY `custom` (`custom`),
  KEY `redirect` (`redirect`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_sessions`
--

CREATE TABLE `[[dbprefix]]CubeCart_sessions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_start` int(10) unsigned NOT NULL DEFAULT '0',
  `session_last` int(10) unsigned NOT NULL DEFAULT '0',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0',
  `customer_id` int(10) unsigned NOT NULL DEFAULT '0',
  `location` varbinary(255) DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Supports IPv6 addresses',
  `useragent` text COLLATE utf8mb4_unicode_ci,
  `acp` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `session_last` (`session_last`),
  KEY `acp` (`acp`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_shipping_rates`
--

CREATE TABLE `[[dbprefix]]CubeCart_shipping_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` int(11) NOT NULL DEFAULT '0',
  `method_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `min_weight` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `max_weight` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `min_value` decimal(16,2) NOT NULL DEFAULT '0.00',
  `max_value` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_items` int(11) NOT NULL DEFAULT '0',
  `max_items` int(11) NOT NULL DEFAULT '0',
  `flat_rate` decimal(12,2) NOT NULL DEFAULT '0.00',
  `weight_rate` decimal(12,2) NOT NULL DEFAULT '0.00',
  `percent_rate` decimal(12,2) NOT NULL DEFAULT '0.00',
  `item_rate` decimal(12,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `zone_id` (`zone_id`),
  KEY `method_name` (`method_name`),
  KEY `min_weight` (`min_weight`),
  KEY `max_weight` (`max_weight`),
  KEY `min_value` (`min_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_shipping_zones`
--

CREATE TABLE `[[dbprefix]]CubeCart_shipping_zones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `countries` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `states` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `postcodes` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `zone_name` (`zone_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_system_error_log`
--

CREATE TABLE `[[dbprefix]]CubeCart_system_error_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `backtrace` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `time` (`time`),
  KEY `read` (`read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_tariff`
--

CREATE TABLE `[[dbprefix]]CubeCart_tariff` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `source` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `destination` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tariff` enum('D','M') COLLATE utf8mb4_unicode_ci NOT NULL,
  `percent` decimal(5,2) NOT NULL,
  `display` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `combos` (`source`,`destination`,`tariff`),
  KEY `source` (`source`),
  KEY `destination` (`destination`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_tax_class`
--

CREATE TABLE `[[dbprefix]]CubeCart_tax_class` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tax_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_tax_class`
--

INSERT INTO `[[dbprefix]]CubeCart_tax_class` VALUES
(1, 'Standard Rate'),
(2, 'Reduced Rate'),
(3, 'Zero Rate');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_tax_details`
--

CREATE TABLE `[[dbprefix]]CubeCart_tax_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varbinary(150) NOT NULL DEFAULT '',
  `display` varbinary(150) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_tax_details`
--

INSERT INTO `[[dbprefix]]CubeCart_tax_details` VALUES
(1, 'VAT', 'VAT', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_tax_rates`
--

CREATE TABLE `[[dbprefix]]CubeCart_tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned NOT NULL DEFAULT '1',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0',
  `country_id` int(10) unsigned NOT NULL DEFAULT '0',
  `county_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tax_percent` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `goods` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `shipping` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_id` (`type_id`,`details_id`,`country_id`,`county_id`),
  KEY `active` (`active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]CubeCart_tax_rates`
--

INSERT INTO `[[dbprefix]]CubeCart_tax_rates` VALUES
(1, 1, 1, 826, 0, '20.0000', 1, 1, 0),
(2, 2, 1, 826, 0, '5.0000', 1, 1, 0),
(3, 3, 1, 826, 0, '0.0000', 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CubeCart_transactions`
--

CREATE TABLE `[[dbprefix]]CubeCart_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gateway` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extra` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `order_id` varchar(18) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trans_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(10) unsigned DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `captured` decimal(16,2) DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `customer_id` (`customer_id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
