
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cpg1627`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]albums`
--

CREATE TABLE `[[dbprefix]]albums` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `visibility` int(11) NOT NULL DEFAULT '0',
  `uploads` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `comments` enum('YES','NO') NOT NULL DEFAULT 'YES',
  `votes` enum('YES','NO') NOT NULL DEFAULT 'YES',
  `pos` int(11) NOT NULL DEFAULT '0',
  `category` int(11) NOT NULL DEFAULT '0',
  `owner` int(11) NOT NULL DEFAULT '1',
  `thumb` int(11) NOT NULL DEFAULT '0',
  `keyword` varchar(50) DEFAULT NULL,
  `alb_password` varchar(32) DEFAULT NULL,
  `alb_password_hint` text,
  `moderator_group` int(11) NOT NULL DEFAULT '0',
  `alb_hits` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `alb_category` (`category`),
  KEY `moderator_group` (`moderator_group`),
  KEY `visibility` (`visibility`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store albums' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banned`
--

CREATE TABLE `[[dbprefix]]banned` (
  `ban_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `user_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `ip_addr` tinytext,
  `expiry` datetime DEFAULT NULL,
  `brute_force` tinyint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ban_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about banned users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bridge`
--

CREATE TABLE `[[dbprefix]]bridge` (
  `name` varchar(40) NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the bridging data, not used when unbridged';

--
-- Dumping data for table `[[dbprefix]]bridge`
--

INSERT INTO `[[dbprefix]]bridge` VALUES
('cookie_prefix', ''),
('full_forum_url', ''),
('recovery_logon_failures', '0'),
('recovery_logon_timestamp', ''),
('relative_path_to_config_file', ''),
('short_name', ''),
('use_post_based_groups', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `pos` int(11) NOT NULL DEFAULT '0',
  `parent` int(11) NOT NULL DEFAULT '0',
  `thumb` int(11) NOT NULL DEFAULT '0',
  `lft` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rgt` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `depth` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  KEY `cat_parent` (`parent`),
  KEY `cat_pos` (`pos`),
  KEY `cat_owner_id` (`owner_id`),
  KEY `depth_cid` (`depth`,`cid`),
  KEY `lft_depth` (`lft`,`depth`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Used to store categories' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 0, 'User galleries', 'This category contains albums that belong to Coppermine users.', 0, 0, 0, 1, 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categorymap`
--

CREATE TABLE `[[dbprefix]]categorymap` (
  `cid` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`cid`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds the categories where groups can create albums';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `pid` mediumint(10) NOT NULL DEFAULT '0',
  `msg_id` mediumint(10) NOT NULL AUTO_INCREMENT,
  `msg_author` varchar(25) NOT NULL DEFAULT '',
  `msg_body` text NOT NULL,
  `msg_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `msg_raw_ip` tinytext,
  `msg_hdr_ip` tinytext,
  `author_md5_id` varchar(32) NOT NULL DEFAULT '',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `approval` enum('YES','NO') NOT NULL DEFAULT 'YES',
  `spam` enum('YES','NO') NOT NULL DEFAULT 'NO',
  PRIMARY KEY (`msg_id`),
  KEY `com_pic_id` (`pid`),
  KEY `author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store comments made on pics' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `name` varchar(40) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store the configuration options';

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('admin_activation', '0'),
('albums_per_page', '12'),
('album_list_cols', '2'),
('album_sort_order', 'pa'),
('album_uploads_default', 'NO'),
('alb_desc_thumb', '1'),
('alb_list_thumb_size', '50'),
('allowed_doc_types', 'doc/txt/rtf/pdf/xls/pps/ppt/zip/gz/mdb'),
('allowed_img_types', 'jpeg/jpg/png/gif'),
('allowed_mov_types', 'asf/asx/mpg/mpeg/wmv/swf/avi/mov/m4v'),
('allowed_snd_types', 'mp3/midi/mid/wma/wav/ogg'),
('allow_duplicate_emails_addr', '0'),
('allow_email_change', '0'),
('allow_guests_enter_file_details', '0'),
('allow_memberlist', '0'),
('allow_private_albums', '1'),
('allow_unlogged_access', '3'),
('allow_user_account_delete', '0'),
('allow_user_album_keyword', '0'),
('allow_user_edit_after_cat_close', '0'),
('allow_user_move_album', '0'),
('allow_user_registration', '0'),
('allow_user_upload_choice', '1'),
('auto_orient_checked', '1'),
('auto_resize', '1'),
('batch_add_hide_existing_files', '0'),
('batch_proc_limit', '2'),
('bridge_enable', '0'),
('browse_batch_add', '1'),
('browse_by_date', '0'),
('caption_in_thumbview', '1'),
('categories_alpha_sort', '0'),
('charset', 'utf-8'),
('clickable_keyword_search', '1'),
('comments_anon_pfx', 'Guest_'),
('comments_per_page', '20'),
('comments_sort_descending', '0'),
('comment_akismet_api_key', ''),
('comment_akismet_counter', '0'),
('comment_akismet_enable', '0'),
('comment_akismet_group', '0'),
('comment_approval', '0'),
('comment_captcha', '1'),
('comment_placeholder', '1'),
('comment_promote_registration', '0'),
('comment_user_edit', '1'),
('contact_form_guest_email_field', '2'),
('contact_form_guest_enable', '0'),
('contact_form_guest_name_field', '2'),
('contact_form_registered_enable', '1'),
('contact_form_sender_email', '1'),
('contact_form_subject_content', 'Coppermine gallery contact form'),
('contact_form_subject_field', '0'),
('cookies_need_consent', '0'),
('cookie_name', 'cpg16x'),
('cookie_path', '/'),
('count_admin_hits', '0'),
('count_album_hits', '1'),
('count_file_hits', '1'),
('custom_footer_path', ''),
('custom_header_path', ''),
('custom_lnk_name', ''),
('custom_lnk_url', ''),
('custom_sortorder_thumbs', '1'),
('debug_mode', '0'),
('debug_notice', '0'),
('default_dir_mode', '[[dir_mode]]'),
('default_file_mode', '[[file_mode]]'),
('default_sort_order', 'na'),
('disable_comment_flood_protect', '0'),
('display_comment_approval_only', '0'),
('display_comment_count', '0'),
('display_coppermine_news', '1'),
('display_filename', '0'),
('display_film_strip', '1'),
('display_pic_info', '0'),
('display_redirection_page', '0'),
('display_reset_boxes_in_config', '0'),
('display_sidebar_guest', '1'),
('display_sidebar_user', '1'),
('display_stats_on_index', '1'),
('display_thumbnail_rating', '0'),
('display_thumbs_batch_add', '1'),
('display_uploader', '0'),
('ecards_more_pic_target', '[[softurl]]/'),
('ecard_captcha', '1'),
('ecard_flash', '0'),
('editpics_ignore_newer_than', '0'),
('email_comment_notification', '0'),
('enable_encrypted_passwords', '1'),
('enable_help', '1'),
('enable_menu_icons', '2'),
('enable_plugins', '1'),
('enable_smilies', '1'),
('enable_thumb_watermark', '1'),
('enable_unsharp', '0'),
('enable_watermark', '0'),
('enable_zipdownload', '0'),
('filter_bad_words', '0'),
('first_level', '1'),
('forbiden_fname_char', '$/\\\\:*?&quot;&#039;&lt;&gt;|` &amp;#@'),
('form_token_lifetime', '3600'),
('fullpath', 'albums/'),
('fullsize_padding_x', '5'),
('fullsize_padding_y', '3'),
('gallery_admin_email', '[[admin_email]]'),
('gallery_description', '[[site_desc]]'),
('gallery_name', '[[site_name]]'),
('global_registration_pw', ''),
('guest_token_cleanup', '0'),
('hit_details', '0'),
('home_target', 'index.php'),
('impath', '/usr/bin/'),
('im_options', '-antialias'),
('jpeg_qual', '80'),
('keep_votes_time', '30'),
('keyword_separator', ';'),
('lang', 'english'),
('language_autodetect', '1'),
('last_updates_check', '1'),
('link_last_upload', '0'),
('link_pic_count', '1'),
('login_expiry', '10'),
('login_method', 'username'),
('login_threshold', '5'),
('log_ecards', '0'),
('log_mode', '0'),
('main_page_layout', 'breadcrumb/catlist/alblist/random,2/lastup,2'),
('main_table_width', '100%'),
('make_intermediate', '1'),
('max_com_lines', '10'),
('max_com_size', '512'),
('max_com_wlength', '38'),
('max_film_strip_items', '5'),
('max_img_desc_length', '512'),
('max_tabs', '12'),
('max_upl_size', '1024'),
('max_upl_width_height', '2048'),
('media_autostart', '1'),
('min_votes_for_rating', '1'),
('normal_pfx', 'normal_'),
('offline', '0'),
('old_style_rating', '0'),
('only_empty_albums', '0'),
('orig_pfx', 'orig_'),
('performance_page_generation_time', '0'),
('performance_page_query_count', '0'),
('performance_page_query_time', '0'),
('performance_timestamp', '0'),
('personal_album_on_registration', '0'),
('picinfo_movie_download_link', '1'),
('picture_table_width', '100%'),
('picture_use', 'thumb'),
('picture_width', '400'),
('purge_expired_bans', '1'),
('rate_own_files', '0'),
('rating_stars_amount', '5'),
('read_exif_data', '0'),
('read_iptc_data', '0'),
('reduce_watermark', '0'),
('registration_captcha', '0'),
('reg_notify_admin_email', '0'),
('reg_requires_valid_email', '1'),
('report_post', '0'),
('session_cleanup', '[[timestamp]]'),
('show_bbcode_help', '1'),
('show_private', '0'),
('show_which_exif', '|0|0|0|0|0|0|0|0|1|0|1|1|0|0|0|0|0|0|0|0|0|0|0|1|0|0|0|1|0|0|0|1|1|0|0|0|0|1|0|0|0|1|0|0|1|1|0|0|0|0|0|1|0|1|1'),
('silly_safe_mode', '0'),
('site_token', '[[site_token]]'),
('slideshow_hits', '1'),
('slideshow_interval', '5000'),
('smtp_host', ''),
('smtp_password', ''),
('smtp_username', ''),
('subcat_level', '2'),
('tabs_dropdown', '1'),
('theme', 'curve'),
('theme_list', '0'),
('thumbcols', '4'),
('thumbnail_to_fullsize', '0'),
('thumbrows', '3'),
('thumb_height', '128'),
('thumb_method', '[[thumb_method]]'),
('thumb_pfx', 'thumb_'),
('thumb_use', 'any'),
('thumb_width', '128'),
('time_offset', '0'),
('transparent_overlay', '0'),
('unsharp_amount', '120'),
('unsharp_radius', '0.5'),
('unsharp_threshold', '3'),
('upload_create_album_directory', '1'),
('upload_h5a', 'a:11:{s:10:"concurrent";i:3;s:8:"upldsize";i:0;s:8:"autoedit";i:1;s:8:"acptmime";s:7:"image/*";s:8:"enabtitl";i:0;s:8:"enabdesc";i:0;s:8:"enabkeys";i:1;s:8:"enabusr1";i:0;s:8:"enabusr2";i:0;s:8:"enabusr3";i:0;s:8:"enabusr4";i:0;}'),
('upload_mechanism', 'upload_h5a'),
('upl_notify_admin_email', '0'),
('userpics', 'userpics/'),
('users_can_edit_pics', '0'),
('user_field1_name', ''),
('user_field2_name', ''),
('user_field3_name', ''),
('user_field4_name', ''),
('user_manager_hide_file_stats', '0'),
('user_profile1_name', 'Location'),
('user_profile2_name', 'Interests'),
('user_profile3_name', 'Website'),
('user_profile4_name', 'Occupation'),
('user_profile5_name', ''),
('user_profile6_name', 'Biography'),
('user_registration_disclaimer', '1'),
('views_in_thumbview', '1'),
('vote_details', '0'),
('watermark_file', 'images/watermark.png'),
('watermark_transparency', '40'),
('watermark_transparency_featherx', '0'),
('watermark_transparency_feathery', '0'),
('where_put_watermark', 'southeast'),
('which_files_to_watermark', 'both');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dict`
--

CREATE TABLE `[[dbprefix]]dict` (
  `keyId` bigint(20) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(60) NOT NULL,
  PRIMARY KEY (`keyId`),
  UNIQUE KEY `keyword` (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds the keyword dictionary' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ecards`
--

CREATE TABLE `[[dbprefix]]ecards` (
  `eid` int(11) NOT NULL AUTO_INCREMENT,
  `sender_name` varchar(50) NOT NULL DEFAULT '',
  `sender_email` text NOT NULL,
  `recipient_name` varchar(50) NOT NULL DEFAULT '',
  `recipient_email` text NOT NULL,
  `link` text NOT NULL,
  `date` tinytext NOT NULL,
  `sender_ip` tinytext NOT NULL,
  PRIMARY KEY (`eid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to log ecards' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]exif`
--

CREATE TABLE `[[dbprefix]]exif` (
  `pid` int(11) NOT NULL,
  `exifData` text NOT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores EXIF data from individual pics';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favpics`
--

CREATE TABLE `[[dbprefix]]favpics` (
  `user_id` int(11) NOT NULL,
  `user_favpics` text NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the server side favourites';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filetypes`
--

CREATE TABLE `[[dbprefix]]filetypes` (
  `extension` char(7) NOT NULL DEFAULT '',
  `mime` char(254) DEFAULT NULL,
  `content` char(15) DEFAULT NULL,
  `player` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store the file extensions';

--
-- Dumping data for table `[[dbprefix]]filetypes`
--

INSERT INTO `[[dbprefix]]filetypes` VALUES
('001', 'application/001', 'document', ''),
('7z', 'application/7z', 'document', ''),
('arj', 'application/arj', 'document', ''),
('asf', 'video/x-ms-asf', 'movie', 'WMP'),
('asx', 'video/x-ms-asx', 'movie', 'WMP'),
('avi', 'video/avi', 'movie', 'WMP'),
('bmp', 'image/bmp', 'image', ''),
('bz2', 'application/bz2', 'document', ''),
('cab', 'application/cab', 'document', ''),
('doc', 'application/msword', 'document', ''),
('docm', 'application/vnd.ms-word.document.macroEnabled.12', 'document', ''),
('docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'document', ''),
('dotm', 'application/vnd.ms-word.template.macroEnabled.12', 'document', ''),
('dotx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template', 'document', ''),
('gif', 'image/gif', 'image', ''),
('gz', 'application/gz', 'document', ''),
('iff', 'image/iff', 'image', ''),
('jb2', 'image/jb2', 'image', ''),
('jp2', 'image/jp2', 'image', ''),
('jpc', 'image/jpc', 'image', ''),
('jpe', 'image/jpe', 'image', ''),
('jpeg', 'image/jpeg', 'image', ''),
('jpg', 'image/jpg', 'image', ''),
('jpx', 'image/jpx', 'image', ''),
('lzh', 'application/lzh', 'document', ''),
('m4v', 'video/x-m4v', 'movie', 'HTMLV'),
('mdb', 'application/msaccess', 'document', ''),
('mid', 'audio/midi', 'audio', 'WMP'),
('midi', 'audio/midi', 'audio', 'WMP'),
('mov', 'video/quicktime', 'movie', 'QT'),
('mp3', 'audio/mpeg3', 'audio', 'WMP'),
('mp4', 'video/mp4', 'movie', 'HTMLV'),
('mpeg', 'video/mpeg', 'movie', 'WMP'),
('mpg', 'video/mpeg', 'movie', 'WMP'),
('odb', 'application/vnd.oasis.opendocument.database', 'document', ''),
('odc', 'application/vnd.oasis.opendocument.chart', 'document', ''),
('odf', 'application/vnd.oasis.opendocument.formula', 'document', ''),
('odg', 'application/vnd.oasis.opendocument.graphics', 'document', ''),
('odi', 'application/vnd.oasis.opendocument.image', 'document', ''),
('odm', 'application/vnd.oasis.opendocument.text-master', 'document', ''),
('odp', 'application/vnd.oasis.opendocument.presentation', 'document', ''),
('ods', 'application/vnd.oasis.opendocument.spreadsheet', 'document', ''),
('odt', 'application/vnd.oasis.opendocument.text', 'document', ''),
('oga', 'audio/ogg', 'audio', 'HTMLA'),
('ogg', 'audio/ogg', 'audio', 'HTMLA'),
('ogv', 'video/ogg', 'movie', 'HTMLV'),
('onepkg', 'application/onenote', 'document', ''),
('onetmp', 'application/onenote', 'document', ''),
('onetoc', 'application/onenote', 'document', ''),
('onetoc2', 'application/onenote', 'document', ''),
('otc', 'application/vnd.oasis.opendocument.chart-template', 'document', ''),
('otf', 'application/vnd.oasis.opendocument.formula-template', 'document', ''),
('otg', 'application/vnd.oasis.opendocument.graphics-template', 'document', ''),
('oth', 'application/vnd.oasis.opendocument.text-web', 'document', ''),
('oti', 'application/vnd.oasis.opendocument.image-template', 'document', ''),
('otp', 'application/vnd.oasis.opendocument.presentation-template', 'document', ''),
('ots', 'application/vnd.oasis.opendocument.spreadsheet-template', 'document', ''),
('ott', 'application/vnd.oasis.opendocument.text-template', 'document', ''),
('pdf', 'application/pdf', 'document', ''),
('png', 'image/png', 'image', ''),
('potm', 'application/vnd.ms-powerpoint.template.macroEnabled.12', 'document', ''),
('potx', 'application/vnd.openxmlformats-officedocument.presentationml.template', 'document', ''),
('ppam', 'application/vnd.ms-powerpoint.addin.macroEnabled.12', 'document', ''),
('pps', 'application/powerpoint', 'document', ''),
('ppsm', 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12', 'document', ''),
('ppsx', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow', 'document', ''),
('ppt', 'application/powerpoint', 'document', ''),
('pptm', 'application/vnd.ms-powerpoint.presentation.macroEnabled.12', 'document', ''),
('pptx', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'document', ''),
('psd', 'image/psd', 'image', ''),
('ra', 'audio/x-realaudio', 'document', 'RMP'),
('ram', 'audio/x-pn-realaudio', 'document', 'RMP'),
('rar', 'application/rar', 'document', ''),
('rm', 'audio/x-realmedia', 'document', 'RMP'),
('rpm', 'application/rpm', 'document', ''),
('rtf', 'text/richtext', 'document', ''),
('sldm', 'application/vnd.ms-powerpoint.slide.macroEnabled.12', 'document', ''),
('sldx', 'application/vnd.openxmlformats-officedocument.presentationml.slide', 'document', ''),
('stc', 'application/vnd.sun.xml.calc.template', 'document', ''),
('std', 'application/vnd.sun.xml.draw.template', 'document', ''),
('sti', 'application/vnd.sun.xml.impress.template', 'document', ''),
('stw', 'application/vnd.sun.xml.writer.template', 'document', ''),
('swc', 'image/swc', 'image', ''),
('swf', 'application/x-shockwave-flash', 'movie', 'SWF'),
('sxc', 'application/vnd.sun.xml.calc', 'document', ''),
('sxd', 'application/vnd.sun.xml.draw', 'document', ''),
('sxg', 'application/vnd.sun.xml.writer.global', 'document', ''),
('sxi', 'application/vnd.sun.xml.impress', 'document', ''),
('sxm', 'application/vnd.sun.xml.math', 'document', ''),
('sxw', 'application/vnd.sun.xml.writer', 'document', ''),
('tar', 'application/tar', 'document', ''),
('thmx', 'application/vnd.ms-officetheme', 'document', ''),
('tif', 'image/tif', 'document', ''),
('tiff', 'image/tiff', 'document', ''),
('txt', 'text/plain', 'document', ''),
('wav', 'audio/wav', 'audio', 'WMP'),
('wma', 'audio/x-ms-wma', 'audio', 'WMP'),
('wmv', 'video/x-ms-wmv', 'movie', 'WMP'),
('xlam', 'application/vnd.ms-excel.addin.macroEnabled.12', 'document', ''),
('xls', 'application/excel', 'document', ''),
('xlsb', 'application/vnd.ms-excel.sheet.binary.macroEnabled.12', 'document', ''),
('xlsm', 'application/vnd.ms-excel.sheet.macroEnabled.12', 'document', ''),
('xlsx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'document', ''),
('xltm', 'application/vnd.ms-excel.template.macroEnabled.12', 'document', ''),
('xltx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template', 'document', ''),
('z', 'application/z', 'document', ''),
('zip', 'application/zip', 'document', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hit_stats`
--

CREATE TABLE `[[dbprefix]]hit_stats` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(100) NOT NULL DEFAULT '',
  `ip` varchar(40) NOT NULL DEFAULT '',
  `search_phrase` varchar(255) NOT NULL DEFAULT '',
  `sdate` bigint(20) NOT NULL DEFAULT '0',
  `referer` text NOT NULL,
  `browser` varchar(255) NOT NULL DEFAULT '',
  `os` varchar(50) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Detailed stats about hits, only used when enabled' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `lang_id` varchar(40) NOT NULL DEFAULT '',
  `english_name` varchar(70) DEFAULT NULL,
  `native_name` varchar(70) DEFAULT NULL,
  `custom_name` varchar(70) DEFAULT NULL,
  `flag` varchar(15) DEFAULT NULL,
  `abbr` varchar(15) NOT NULL DEFAULT '',
  `available` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `enabled` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `complete` enum('YES','NO') NOT NULL DEFAULT 'NO',
  PRIMARY KEY (`lang_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains the language file definitions';

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
('english', 'English (US)', 'English (US)', NULL, 'us', 'en', 'YES', 'YES', 'YES'),
('french', 'French', 'Fran&ccedil;ais', NULL, 'fr', 'fr', 'YES', 'YES', 'YES'),
('german', 'German (informal)', 'Deutsch (Du)', NULL, 'de', 'de', 'YES', 'YES', 'YES');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pictures`
--

CREATE TABLE `[[dbprefix]]pictures` (
  `pid` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL DEFAULT '0',
  `filepath` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `total_filesize` int(11) NOT NULL DEFAULT '0',
  `pwidth` smallint(6) NOT NULL DEFAULT '0',
  `pheight` smallint(6) NOT NULL DEFAULT '0',
  `hits` int(10) NOT NULL DEFAULT '0',
  `mtime` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `ctime` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `pic_rating` int(11) NOT NULL DEFAULT '0',
  `votes` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `caption` text NOT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `approved` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `galleryicon` int(11) NOT NULL DEFAULT '0',
  `user1` varchar(255) NOT NULL DEFAULT '',
  `user2` varchar(255) NOT NULL DEFAULT '',
  `user3` varchar(255) NOT NULL DEFAULT '',
  `user4` varchar(255) NOT NULL DEFAULT '',
  `url_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `pic_raw_ip` tinytext,
  `pic_hdr_ip` tinytext,
  `lasthit_ip` tinytext,
  `position` int(11) NOT NULL DEFAULT '0',
  `guest_token` varchar(32) DEFAULT '',
  PRIMARY KEY (`pid`),
  KEY `owner_id` (`owner_id`),
  KEY `pic_hits` (`hits`),
  KEY `pic_rate` (`pic_rating`),
  KEY `aid_approved` (`aid`,`approved`),
  KEY `pic_aid` (`aid`,`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store data about individual pics' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `plugin_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `path` varchar(128) NOT NULL DEFAULT '',
  `priority` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`plugin_id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `path` (`path`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores the plugins' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]plugins`
--

INSERT INTO `[[dbprefix]]plugins` VALUES
(1, 'HTML5 Upload', 1, 'upload_h5a', 0),
(2, 'Flash Upload', 1, 'upload_swf', 1),
(3, 'Single File Upload', 1, 'upload_sgl', 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `remember` int(1) DEFAULT '0',
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store sessions';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]temp_messages`
--

CREATE TABLE `[[dbprefix]]temp_messages` (
  `message_id` varchar(80) NOT NULL DEFAULT '',
  `user_id` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store messages from one page to the other';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]usergroups`
--

CREATE TABLE `[[dbprefix]]usergroups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '',
  `group_quota` int(11) NOT NULL DEFAULT '0',
  `has_admin_access` tinyint(4) NOT NULL DEFAULT '0',
  `can_rate_pictures` tinyint(4) NOT NULL DEFAULT '0',
  `can_send_ecards` tinyint(4) NOT NULL DEFAULT '0',
  `can_post_comments` tinyint(4) NOT NULL DEFAULT '0',
  `can_upload_pictures` tinyint(4) NOT NULL DEFAULT '0',
  `can_create_albums` tinyint(4) NOT NULL DEFAULT '0',
  `pub_upl_need_approval` tinyint(4) NOT NULL DEFAULT '1',
  `priv_upl_need_approval` tinyint(4) NOT NULL DEFAULT '1',
  `access_level` tinyint(4) NOT NULL DEFAULT '3',
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]usergroups`
--

INSERT INTO `[[dbprefix]]usergroups` VALUES
(1, 'Administrators', 0, 1, 1, 1, 1, 1, 1, 0, 0, 3),
(2, 'Registered', 1024, 0, 1, 1, 1, 1, 1, 1, 0, 3),
(3, 'Anonymous', 0, 0, 1, 0, 0, 0, 0, 1, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group` int(11) NOT NULL DEFAULT '2',
  `user_active` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `user_name` varchar(25) NOT NULL DEFAULT '',
  `user_password` varchar(255) NOT NULL DEFAULT '',
  `user_password_salt` varchar(255) NOT NULL DEFAULT '',
  `user_password_hash_algorithm` varchar(25) NOT NULL DEFAULT '',
  `user_password_iterations` varchar(25) NOT NULL DEFAULT '',
  `user_lastvisit` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `user_regdate` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `user_group_list` varchar(255) NOT NULL DEFAULT '',
  `user_email` varchar(255) NOT NULL DEFAULT '',
  `user_email_valid` enum('YES','') NOT NULL DEFAULT '',
  `user_profile1` varchar(255) NOT NULL DEFAULT '',
  `user_profile2` varchar(255) NOT NULL DEFAULT '',
  `user_profile3` varchar(255) NOT NULL DEFAULT '',
  `user_profile4` varchar(255) NOT NULL DEFAULT '',
  `user_profile5` varchar(255) NOT NULL DEFAULT '',
  `user_profile6` text NOT NULL,
  `user_actkey` varchar(32) NOT NULL DEFAULT '',
  `user_language` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_name` (`user_name`),
  KEY `user_group` (`user_group`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Used to store users, not used when bridged' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, 1, 'YES', '[[admin_username]]', '[[admin_pass]]', '[[salt]]', 'sha256', '1000', '[[regtime]]', '[[regtime]]', '', '[[admin_email]]', '', '', '', '', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]votes`
--

CREATE TABLE `[[dbprefix]]votes` (
  `pic_id` mediumint(9) NOT NULL DEFAULT '0',
  `user_md5_id` varchar(32) NOT NULL DEFAULT '',
  `vote_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pic_id`,`user_md5_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores votes for individual pics';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]vote_stats`
--

CREATE TABLE `[[dbprefix]]vote_stats` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(100) NOT NULL DEFAULT '',
  `rating` smallint(6) NOT NULL DEFAULT '0',
  `ip` varchar(40) NOT NULL DEFAULT '',
  `sdate` bigint(20) NOT NULL DEFAULT '0',
  `referer` text NOT NULL,
  `browser` varchar(255) NOT NULL DEFAULT '',
  `os` varchar(50) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Detailed stats about votes, only used when enabled' AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
