SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cotonti0925`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth`
--

CREATE TABLE `[[dbprefix]]auth` (
  `auth_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `auth_groupid` mediumint(8) unsigned NOT NULL,
  `auth_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `auth_option` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `auth_rights` tinyint(3) unsigned DEFAULT '0',
  `auth_rights_lock` tinyint(3) unsigned DEFAULT '0',
  `auth_setbyuserid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`auth_id`),
  KEY `auth_groupid` (`auth_groupid`),
  KEY `auth_code` (`auth_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=115 ;

--
-- Dumping data for table `[[dbprefix]]auth`
--

INSERT INTO `[[dbprefix]]auth` VALUES
(1, 1, 'admin', 'a', 0, 255, 1),
(2, 2, 'admin', 'a', 0, 255, 1),
(3, 3, 'admin', 'a', 0, 255, 1),
(4, 4, 'admin', 'a', 0, 255, 1),
(5, 5, 'admin', 'a', 255, 255, 1),
(6, 6, 'admin', 'a', 1, 0, 1),
(7, 1, 'message', 'a', 1, 255, 1),
(8, 2, 'message', 'a', 1, 255, 1),
(9, 3, 'message', 'a', 1, 255, 1),
(10, 4, 'message', 'a', 1, 255, 1),
(11, 5, 'message', 'a', 255, 255, 1),
(12, 6, 'message', 'a', 131, 0, 1),
(13, 1, 'structure', 'a', 0, 255, 1),
(14, 2, 'structure', 'a', 0, 255, 1),
(15, 3, 'structure', 'a', 0, 255, 1),
(16, 4, 'structure', 'a', 0, 255, 1),
(17, 5, 'structure', 'a', 255, 255, 1),
(18, 6, 'structure', 'a', 1, 0, 1),
(19, 5, 'index', 'a', 255, 255, 1),
(20, 6, 'index', 'a', 1, 0, 1),
(21, 2, 'index', 'a', 1, 128, 1),
(22, 3, 'index', 'a', 0, 255, 1),
(23, 4, 'index', 'a', 1, 0, 1),
(24, 1, 'index', 'a', 1, 128, 1),
(25, 5, 'page', 'a', 255, 255, 1),
(26, 6, 'page', 'a', 7, 0, 1),
(27, 2, 'page', 'a', 1, 128, 1),
(28, 3, 'page', 'a', 0, 255, 1),
(29, 4, 'page', 'a', 7, 0, 1),
(30, 1, 'page', 'a', 1, 128, 1),
(31, 1, 'page', 'articles', 5, 250, 1),
(32, 2, 'page', 'articles', 1, 254, 1),
(33, 3, 'page', 'articles', 0, 255, 1),
(34, 4, 'page', 'articles', 7, 0, 1),
(35, 5, 'page', 'articles', 255, 255, 1),
(36, 6, 'page', 'articles', 135, 0, 1),
(37, 1, 'page', 'events', 5, 250, 1),
(38, 2, 'page', 'events', 1, 254, 1),
(39, 3, 'page', 'events', 0, 255, 1),
(40, 4, 'page', 'events', 7, 0, 1),
(41, 5, 'page', 'events', 255, 255, 1),
(42, 6, 'page', 'events', 135, 0, 1),
(43, 1, 'page', 'system', 5, 250, 1),
(44, 2, 'page', 'system', 1, 254, 1),
(45, 3, 'page', 'system', 0, 255, 1),
(46, 4, 'page', 'system', 7, 0, 1),
(47, 5, 'page', 'system', 255, 255, 1),
(48, 6, 'page', 'system', 135, 0, 1),
(49, 1, 'page', 'news', 5, 250, 1),
(50, 2, 'page', 'news', 1, 254, 1),
(51, 3, 'page', 'news', 0, 255, 1),
(52, 4, 'page', 'news', 7, 0, 1),
(53, 5, 'page', 'news', 255, 255, 1),
(54, 6, 'page', 'news', 135, 0, 1),
(55, 5, 'rss', 'a', 255, 255, 1),
(56, 6, 'rss', 'a', 1, 0, 1),
(57, 2, 'rss', 'a', 1, 128, 1),
(58, 3, 'rss', 'a', 0, 255, 1),
(59, 4, 'rss', 'a', 1, 0, 1),
(60, 1, 'rss', 'a', 1, 128, 1),
(61, 5, 'users', 'a', 255, 255, 1),
(62, 6, 'users', 'a', 3, 0, 1),
(63, 2, 'users', 'a', 1, 128, 1),
(64, 3, 'users', 'a', 0, 255, 1),
(65, 4, 'users', 'a', 3, 0, 1),
(66, 1, 'users', 'a', 1, 128, 1),
(67, 5, 'plug', 'cleaner', 255, 255, 1),
(68, 6, 'plug', 'cleaner', 1, 254, 1),
(69, 2, 'plug', 'cleaner', 0, 255, 1),
(70, 3, 'plug', 'cleaner', 0, 255, 1),
(71, 4, 'plug', 'cleaner', 1, 254, 1),
(72, 1, 'plug', 'cleaner', 0, 255, 1),
(73, 5, 'plug', 'ckeditor', 255, 255, 1),
(74, 6, 'plug', 'ckeditor', 3, 252, 1),
(75, 2, 'plug', 'ckeditor', 1, 252, 1),
(76, 3, 'plug', 'ckeditor', 0, 255, 1),
(77, 4, 'plug', 'ckeditor', 3, 252, 1),
(78, 1, 'plug', 'ckeditor', 1, 252, 1),
(79, 5, 'plug', 'html', 255, 255, 1),
(80, 6, 'plug', 'html', 3, 0, 1),
(81, 2, 'plug', 'html', 1, 252, 1),
(82, 3, 'plug', 'html', 0, 255, 1),
(83, 4, 'plug', 'html', 3, 0, 1),
(84, 1, 'plug', 'html', 1, 252, 1),
(85, 5, 'plug', 'htmlpurifier', 255, 255, 1),
(86, 6, 'plug', 'htmlpurifier', 3, 0, 1),
(87, 2, 'plug', 'htmlpurifier', 3, 252, 1),
(88, 3, 'plug', 'htmlpurifier', 0, 255, 1),
(89, 4, 'plug', 'htmlpurifier', 3, 0, 1),
(90, 1, 'plug', 'htmlpurifier', 3, 252, 1),
(91, 5, 'plug', 'search', 255, 255, 1),
(92, 6, 'plug', 'search', 1, 254, 1),
(93, 2, 'plug', 'search', 1, 254, 1),
(94, 3, 'plug', 'search', 0, 255, 1),
(95, 4, 'plug', 'search', 1, 254, 1),
(96, 1, 'plug', 'search', 1, 254, 1),
(97, 5, 'plug', 'indexnews', 255, 255, 1),
(98, 6, 'plug', 'indexnews', 3, 0, 1),
(99, 2, 'plug', 'indexnews', 1, 252, 1),
(100, 3, 'plug', 'indexnews', 0, 255, 1),
(101, 4, 'plug', 'indexnews', 3, 0, 1),
(102, 1, 'plug', 'indexnews', 1, 252, 1),
(103, 5, 'plug', 'mcaptcha', 255, 255, 1),
(104, 6, 'plug', 'mcaptcha', 1, 254, 1),
(105, 2, 'plug', 'mcaptcha', 1, 254, 1),
(106, 3, 'plug', 'mcaptcha', 0, 255, 1),
(107, 4, 'plug', 'mcaptcha', 1, 254, 1),
(108, 1, 'plug', 'mcaptcha', 1, 254, 1),
(109, 5, 'plug', 'ipsearch', 255, 255, 1),
(110, 6, 'plug', 'ipsearch', 0, 255, 1),
(111, 2, 'plug', 'ipsearch', 0, 255, 1),
(112, 3, 'plug', 'ipsearch', 0, 255, 1),
(113, 4, 'plug', 'ipsearch', 0, 255, 1),
(114, 1, 'plug', 'ipsearch', 0, 255, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache`
--

CREATE TABLE `[[dbprefix]]cache` (
  `c_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `c_realm` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cot',
  `c_expire` int(10) unsigned NOT NULL DEFAULT '0',
  `c_auto` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `c_value` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`c_name`,`c_realm`),
  KEY `c_realm` (`c_realm`),
  KEY `c_name` (`c_name`),
  KEY `c_expire` (`c_expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_bindings`
--

CREATE TABLE `[[dbprefix]]cache_bindings` (
  `c_event` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `c_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `c_realm` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cot',
  `c_type` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`c_event`,`c_id`,`c_realm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `config_owner` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'core',
  `config_cat` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config_subcat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `config_order` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00',
  `config_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config_type` tinyint(4) NOT NULL DEFAULT '0',
  `config_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `config_default` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `config_variants` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `config_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `config_donor` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `config_owner_cat_name_subcat_key` (`config_owner`,`config_cat`,`config_name`,`config_subcat`),
  KEY `config_owner` (`config_owner`,`config_cat`),
  KEY `config_owner_2` (`config_owner`,`config_cat`,`config_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('core', 'locale', '', '11', 'defaulttimezone', 4, 'UTC', 'UTC', 'cot_config_timezones()', '', ''),
('core', 'locale', '', '01', 'forcedefaultlang', 3, '0', '0', '', '', ''),
('core', 'main', '', '01', 'adminemail', 1, '[[admin_email]]', 'admin@mysite.com', '', '', ''),
('core', 'main', '', '02', 'clustermode', 3, '0', '0', '', '', ''),
('core', 'main', '', '07', 'confirmlinks', 3, '1', '1', '', '', ''),
('core', 'main', '', '91', 'default_show_installed', 3, '0', '0', '', '', ''),
('core', 'main', '', '06', 'easypagenav', 3, '1', '1', '', '', ''),
('core', 'main', '', '03', 'hostip', 1, '999.999.999.999', '999.999.999.999', '', '', ''),
('core', 'main', '', '08', 'loggerlevel', 2, 'sec+adm+ext', 'sec+adm+ext', 'none,sec,adm,ext,sec+adm,sec+ext,adm+ext,sec+adm+ext,all', '', ''),
('core', 'main', '', '05', 'maxrowsperpage', 8, '15', '', 'cot_config_type_int(1)', '', ''),
('core', 'main', '', '04', 'parser', 4, 'html', 'none', 'cot_get_parsers()', '', ''),
('core', 'menus', '', '02', 'banner', 0, '', '', '', '', ''),
('core', 'menus', '', '03', 'bottomline', 0, '', '', '', '', ''),
('core', 'menus', '', '21', 'freetext1', 0, '', '', '', '', ''),
('core', 'menus', '', '22', 'freetext2', 0, '', '', '', '', ''),
('core', 'menus', '', '23', 'freetext3', 0, '', '', '', '', ''),
('core', 'menus', '', '24', 'freetext4', 0, '', '', '', '', ''),
('core', 'menus', '', '25', 'freetext5', 0, '', '', '', '', ''),
('core', 'menus', '', '26', 'freetext6', 0, '', '', '', '', ''),
('core', 'menus', '', '27', 'freetext7', 0, '', '', '', '', ''),
('core', 'menus', '', '28', 'freetext8', 0, '', '', '', '', ''),
('core', 'menus', '', '29', 'freetext9', 0, '', '', '', '', ''),
('core', 'menus', '', '11', 'menu1', 0, '<li><a href="index.php">Home</a></li>\n<li><a href="index.php?e=forums">Forums</a></li>\n<li><a href="index.php?e=page&c=articles">Articles</a></li>\n<li><a href="index.php?e=search">Search</a></li>', '<li><a href="index.php">Home</a></li>\n<li><a href="index.php?e=forums">Forums</a></li>\n<li><a href="index.php?e=page&c=articles">Articles</a></li>\n<li><a href="index.php?e=search">Search</a></li>', '', '', ''),
('core', 'menus', '', '12', 'menu2', 0, '', '', '', '', ''),
('core', 'menus', '', '13', 'menu3', 0, '', '', '', '', ''),
('core', 'menus', '', '14', 'menu4', 0, '', '', '', '', ''),
('core', 'menus', '', '15', 'menu5', 0, '', '', '', '', ''),
('core', 'menus', '', '16', 'menu6', 0, '', '', '', '', ''),
('core', 'menus', '', '17', 'menu7', 0, '', '', '', '', ''),
('core', 'menus', '', '18', 'menu8', 0, '', '', '', '', ''),
('core', 'menus', '', '19', 'menu9', 0, '', '', '', '', ''),
('core', 'menus', '', '01', 'topline', 0, '', '', '', '', ''),
('core', 'performance', '', '01', 'gzip', 3, '0', '0', '', '', ''),
('core', 'performance', '', '02', 'headrc_consolidate', 3, '0', '0', '', '', ''),
('core', 'performance', '', '03', 'headrc_minify', 3, '1', '1', '', '', ''),
('core', 'performance', '', '05', 'jquery', 3, '1', '1', '', '', ''),
('core', 'performance', '', '04', 'jquery_cdn', 1, '', '', '', '', ''),
('core', 'performance', '', '06', 'turnajax', 3, '1', '1', '', '', ''),
('core', 'security', '', '31', 'captchamain', 4, 'mcaptcha', 'mcaptcha', 'cot_captcha_list()', '', ''),
('core', 'security', '', '32', 'captcharandom', 3, '0', '0', '', '', ''),
('core', 'security', '', '97', 'devmode', 3, '0', '0', '', '', ''),
('core', 'security', '', '42', 'hashfunc', 4, 'sha256', 'sha256', 'cot_hash_funcs()', '', ''),
('core', 'security', '', '40', 'logWrongInput', 3, '0', '0', '', '', ''),
('core', 'security', '', '98', 'maintenance', 3, '0', '0', '', '', ''),
('core', 'security', '', '99', 'maintenancereason', 1, '', '', '', '', ''),
('core', 'security', '', '41', 'referercheck', 3, '1', '1', '', '', ''),
('core', 'security', '', '21', 'shieldenabled', 3, '0', '0', '', '', ''),
('core', 'security', '', '22', 'shieldtadjust', 2, '100', '100', '10,25,50,75,100,125,150,200,300,400,600,800', '', ''),
('core', 'security', '', '23', 'shieldzhammer', 2, '25', '25', '5,10,15,20,25,30,40,50,100', '', ''),
('core', 'sessions', '', '01', 'cookiedomain', 1, '', '', '', '', ''),
('core', 'sessions', '', '03', 'cookielifetime', 2, '5184000', '5184000', '1800,3600,7200,14400,28800,43200,86400,172800,259200,604800,1296000,2592000,5184000', '', ''),
('core', 'sessions', '', '02', 'cookiepath', 1, '', '', '', '', ''),
('core', 'sessions', '', '04', 'forcerememberme', 3, '0', '0', '', '', ''),
('core', 'sessions', '', '06', 'redirbkonlogin', 3, '1', '1', '', '', ''),
('core', 'sessions', '', '07', 'redirbkonlogout', 3, '0', '0', '', '', ''),
('core', 'sessions', '', '05', 'timedout', 2, '1200', '1200', '30,60,120,300,600,900,1200,1800,2400,3600', '', ''),
('core', 'theme', '', '05', 'disablesysinfos', 3, '0', '0', '', '', ''),
('core', 'theme', '', '01', 'forcedefaulttheme', 3, '0', '0', '', '', ''),
('core', 'theme', '', '02', 'homebreadcrumb', 3, '0', '0', '', '', ''),
('core', 'theme', '', '06', 'keepcrbottom', 3, '1', '1', '', '', ''),
('core', 'theme', '', '08', 'msg_separate', 3, '0', '0', '', 'Show messages separately for each source', ''),
('core', 'theme', '', '04', 'separator', 1, '/', '/', '', '', ''),
('core', 'theme', '', '07', 'showsqlstats', 3, '0', '0', '', '', ''),
('core', 'title', '', '99', 'body_mail', 0, '{MAIL_BODY}\n\n{SITE_TITLE} - {SITE_URL}\n{SITE_DESCRIPTION}', '{MAIL_BODY}\n\n{SITE_TITLE} - {SITE_URL}\n{SITE_DESCRIPTION}', '', '', ''),
('core', 'title', '', '01', 'maintitle', 1, 'Title of your site', 'Title of your site', '', '', ''),
('core', 'title', '', '03', 'metakeywords', 1, '', '', '', '', ''),
('core', 'title', '', '98', 'subject_mail', 1, '{SITE_TITLE} - {MAIL_SUBJECT}', '{SITE_TITLE} - {MAIL_SUBJECT}', '', '', ''),
('core', 'title', '', '02', 'subtitle', 1, 'Subtitle', 'Subtitle', '', '', ''),
('core', 'title', '', '18', 'title_header', 1, '{SUBTITLE} - {MAINTITLE}', '{SUBTITLE} - {MAINTITLE}', '', '', ''),
('core', 'title', '', '19', 'title_header_index', 1, '{MAINTITLE} - {DESCRIPTION} {SUBTITLE}', '{MAINTITLE} - {DESCRIPTION} {SUBTITLE}', '', '', ''),
('core', 'title', '', '14', 'title_users_details', 1, '{USER}: {NAME}', '{USER} - {NAME}', '', '', ''),
('module', 'page', '__default', '05', 'allowemptytext', 3, '0', '0', '', '', ''),
('module', 'page', '', '04', 'autovalidate', 3, '1', '1', '', '', ''),
('module', 'page', '', '03', 'count_admin', 3, '0', '0', '', '', ''),
('module', 'page', '__default', '06', 'keywords', 1, '', '', '', '', ''),
('module', 'page', '', '01', 'markup', 3, '1', '1', '', '', ''),
('module', 'page', '', '06', 'maxlistsperpage', 2, '30', '30', '5,10,15,20,25,30,40,50,60,70,100,200,500', '', ''),
('module', 'page', '__default', '03', 'maxrowsperpage', 1, '30', '30', '', '', ''),
('module', 'page', '__default', '08', 'metadesc', 1, '', '', '', '', ''),
('module', 'page', '__default', '07', 'metatitle', 1, '', '', '', '', ''),
('module', 'page', '__default', '01', 'order', 4, 'title', 'title', 'cot_page_config_order()', '', ''),
('module', 'page', '', '02', 'parser', 4, 'html', 'none', 'cot_get_parsers()', '', ''),
('module', 'page', '', '07', 'title_page', 1, '{TITLE} - {CATEGORY}', '{TITLE} - {CATEGORY}', '', '', ''),
('module', 'page', '__default', '04', 'truncatetext', 1, '0', '0', '', '', ''),
('module', 'page', '__default', '02', 'way', 2, 'asc', 'asc', 'asc,desc', '', ''),
('module', 'rss', '', '04', 'rss_charset', 1, 'UTF-8', 'UTF-8', '', '', ''),
('module', 'rss', '', '03', 'rss_maxitems', 1, '40', '40', '', '', ''),
('module', 'rss', '', '05', 'rss_pagemaxsymbols', 1, '', '', '', '', ''),
('module', 'rss', '', '06', 'rss_postmaxsymbols', 1, '', '', '', '', ''),
('module', 'rss', '', '02', 'rss_timetolive', 2, '30', '30', '0,10,20,30,40,50,60,120,180,140,200', '', ''),
('module', 'users', '', '01', 'disablereg', 3, '0', '0', '', '', ''),
('module', 'users', '', '06', 'inactive_login', 3, '0', '0', '', '', ''),
('module', 'users', '', '02', 'maxusersperpage', 1, '50', '50', '', '', ''),
('module', 'users', '', '05', 'register_auto_login', 3, '0', '0', '', '', ''),
('module', 'users', '', '04', 'regnoactivation', 3, '0', '0', '', '', ''),
('module', 'users', '', '03', 'regrequireadmin', 3, '0', '0', '', '', ''),
('module', 'users', '', '08', 'user_email_noprotection', 3, '0', '0', '', '', ''),
('module', 'users', '', '07', 'useremailchange', 3, '0', '0', '', '', ''),
('module', 'users', '', '10', 'usertextimg', 3, '0', '0', '', '', ''),
('module', 'users', '', '09', 'usertextmax', 1, '300', '300', '', '', ''),
('plug', 'cleaner', '', '06', 'logprune', 2, '15', '15', '0,1,2,3,7,15,30,60', 'Delete the log entries older than * days (0 to disable).', ''),
('plug', 'cleaner', '', '06', 'pmnotarchived', 2, '180', '180', '0,15,30,60,120,180,365', 'Delete the private messages older than * days and not archived (0 to disable).', ''),
('plug', 'cleaner', '', '05', 'pmnotread', 2, '120', '120', '0,15,30,60,120,180,365', 'Delete the private messages older than * days and not read by the recipient (0 to disable).', ''),
('plug', 'cleaner', '', '07', 'pmold', 2, '365', '365', '0,15,30,60,120,180,365', 'Delete ALL the private messages older than * days (0 to disable).', ''),
('plug', 'cleaner', '', '04', 'refprune', 2, '30', '30', '0,15,30,60,120,180,365', 'Delete the referer entries older than * days (0 to disable).', ''),
('plug', 'cleaner', '', '05', 'userprune', 2, '2', '2', '0,1,2,3,4,5,6,7', 'Delete the user accounts not activated within * days (0 to disable).', ''),
('plug', 'html', '', '01', 'editor', 4, 'ckeditor', 'ckeditor', 'cot_get_editors()', '', ''),
('plug', 'htmlpurifier', '', '01', 'doctype', 2, 'HTML5', 'HTML5', 'XHTML 1.0 Transitional,XHTML 1.0 Strict,HTML 4.01 Transitional,HTML 4.01 Strict,XHTML 1.1,HTML5', 'Doctype', ''),
('plug', 'htmlpurifier', '', '03', 'rel2abs', 3, '0', '0', '', 'Turn relative links into absolute', ''),
('plug', 'htmlpurifier', '', '02', 'tidylevel', 2, 'medium', 'medium', 'none,light,medium,heavy', 'Tidy level', ''),
('plug', 'htmlpurifier', '', '05', 'videoiframe', 3, '0', '0', '', 'Allow video iframes from Youtube/Vimeo', ''),
('plug', 'indexnews', '', '03', 'cache_ttl', 2, '0', '0', '0,60,180,300,600,1800,3600', 'Cache lifetime in seconds, 0 disables cache', ''),
('plug', 'indexnews', '', '01', 'category', 4, 'news', 'news', 'cot_pagecat_list()', 'News category codes, comma separated', ''),
('plug', 'indexnews', '', '02', 'maxpages', 1, '10', '10', '', 'Recent pages displayed', ''),
('plug', 'mcaptcha', '', '02', 'attempts', 1, '0', '0', '', 'Max captcha attempts per session (0 for unlimited)', ''),
('plug', 'mcaptcha', '', '01', 'delay', 1, '3', '3', '', 'Anti-hammer delay in seconds', ''),
('plug', 'search', '', '08', 'addfields', 1, '', '', '', 'Additional pages fields for search, separated by commas. Example "page_extra1,page_extra2,page_key"', ''),
('plug', 'search', '', '09', 'extrafilters', 3, '1', '1', '', 'Show extrafilters on main search page', ''),
('plug', 'search', '', '06', 'forumsearch', 3, '1', '1', '', 'Enable forums search', ''),
('plug', 'search', '', '04', 'maxitems', 1, '50', '50', '', 'Maximum results lines for general search', ''),
('plug', 'search', '', '02', 'maxsigns', 2, '40', '40', '20,30,40,50,60,70,80', 'Maximum signs in query', ''),
('plug', 'search', '', '01', 'maxwords', 2, '5', '5', '3,5,8,10', 'Maximum search words', ''),
('plug', 'search', '', '03', 'minsigns', 2, '3', '3', '2,3,4,5', 'Min. signs in query', ''),
('plug', 'search', '', '05', 'pagesearch', 3, '1', '1', '', 'Enable pages search', ''),
('plug', 'search', '', '07', 'searchurl', 2, 'Normal', 'Normal', 'Normal,Single', 'Type of forum post link to use, Single uses a Single post view, while Normal uses the traditional thread/jump-to link', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]core`
--

CREATE TABLE `[[dbprefix]]core` (
  `ct_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ct_code` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ct_title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ct_version` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ct_state` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `ct_lock` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ct_plug` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ct_id`),
  KEY `ct_code` (`ct_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]core`
--

INSERT INTO `[[dbprefix]]core` VALUES
(1, 'admin', 'Administration panel', '0.7.0', 1, 1, 0),
(2, 'message', 'Messages', '0.7.0', 1, 1, 0),
(3, 'index', 'Index', '1.0.2', 1, 0, 0),
(4, 'page', 'Pages', '1.0.13', 1, 0, 0),
(5, 'rss', 'RSS', '1.0.3', 1, 0, 0),
(6, 'users', 'Users', '1.4.13', 1, 0, 0),
(7, 'cleaner', 'Cleaner', '1.7.2', 1, 0, 1),
(8, 'ckeditor', 'CKEditor', '1.0.3-4.19.1', 1, 0, 1),
(9, 'html', 'HTML Parser', '1.1.0', 1, 0, 1),
(10, 'htmlpurifier', 'HTML Purifier', '1.2.2-4.15.0', 1, 0, 1),
(11, 'search', 'Search', '4.0.12', 1, 0, 1),
(12, 'indexnews', 'Index News', '1.0.1', 1, 0, 1),
(13, 'mcaptcha', 'MathCaptcha', '1.2.1', 1, 0, 1),
(14, 'ipsearch', 'IP search', '1.7.1', 1, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extra_fields`
--

CREATE TABLE `[[dbprefix]]extra_fields` (
  `field_location` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_html` text COLLATE utf8mb4_unicode_ci,
  `field_variants` text COLLATE utf8mb4_unicode_ci,
  `field_params` text COLLATE utf8mb4_unicode_ci,
  `field_default` text COLLATE utf8mb4_unicode_ci,
  `field_required` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `field_enabled` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `field_parse` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'HTML',
  `field_description` text COLLATE utf8mb4_unicode_ci,
  KEY `field_location` (`field_location`),
  KEY `field_name` (`field_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `grp_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `grp_alias` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grp_level` tinyint(4) NOT NULL DEFAULT '1',
  `grp_disabled` tinyint(4) NOT NULL DEFAULT '0',
  `grp_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grp_title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `grp_desc` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `grp_icon` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `grp_ownerid` int(10) unsigned NOT NULL DEFAULT '0',
  `grp_maintenance` tinyint(4) NOT NULL DEFAULT '0',
  `grp_skiprights` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`grp_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, 'guests', 0, 0, 'Guests', 'Guest', '', '', 1, 0, 0),
(2, 'inactive', 1, 0, 'Inactive', 'Inactive', '', '', 1, 0, 0),
(3, 'banned', 1, 0, 'Banned', 'Banned', '', '', 1, 0, 0),
(4, 'members', 1, 0, 'Members', 'Member', '', '', 1, 0, 0),
(5, 'administrators', 99, 0, 'Administrators', 'Administrator', '', '', 1, 1, 0),
(6, 'moderators', 50, 0, 'Moderators', 'Moderator', '', '', 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_users`
--

CREATE TABLE `[[dbprefix]]groups_users` (
  `gru_userid` int(10) unsigned NOT NULL,
  `gru_groupid` mediumint(8) unsigned NOT NULL,
  `gru_state` tinyint(4) NOT NULL DEFAULT '0',
  UNIQUE KEY `gru_groupid` (`gru_groupid`,`gru_userid`),
  KEY `gru_userid` (`gru_userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]groups_users`
--

INSERT INTO `[[dbprefix]]groups_users` VALUES
(1, 5, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logger`
--

CREATE TABLE `[[dbprefix]]logger` (
  `log_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `log_date` int(10) unsigned NOT NULL,
  `log_ip` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `log_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `log_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `log_uri` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `log_group` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT 'adm',
  `log_type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `log_status` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `log_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `page_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page_state` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `page_cat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_desc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `page_keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `page_metatitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `page_metadesc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `page_text` mediumtext COLLATE utf8mb4_unicode_ci,
  `page_parser` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `page_author` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `page_ownerid` int(10) unsigned NOT NULL DEFAULT '0',
  `page_date` int(10) unsigned NOT NULL DEFAULT '0',
  `page_begin` int(10) unsigned NOT NULL DEFAULT '0',
  `page_expire` int(10) unsigned NOT NULL DEFAULT '0',
  `page_updated` int(10) unsigned NOT NULL DEFAULT '0',
  `page_file` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `page_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `page_size` int(10) unsigned NOT NULL DEFAULT '0',
  `page_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `page_filecount` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`),
  KEY `page_cat` (`page_cat`),
  KEY `page_alias` (`page_alias`),
  KEY `page_date` (`page_date`),
  KEY `page_ownerid` (`page_ownerid`),
  KEY `page_begin` (`page_begin`),
  KEY `page_expire` (`page_expire`),
  KEY `page_title` (`page_title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]pages`
--

INSERT INTO `[[dbprefix]]pages` VALUES
(1, '', 0, 'news', 'Welcome!', '', '', '', '', 'Congratulations, Cotonti was successfully installed! You can now login with the user account you created during installation. Next step is to go to the Administration panel and change the settings for your website, such as the title, server settings, language, user groups and extensions. You can safely remove this message by clicking its title, then clicking Edit and Delete this page.', '', '', 1, [[timestamp]], [[timestamp]], 0, 0, 0, '', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `pl_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pl_hook` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pl_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pl_part` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pl_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pl_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pl_order` tinyint(3) unsigned NOT NULL DEFAULT '10',
  `pl_active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `pl_module` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pl_id`),
  KEY `plugins_active_idx` (`pl_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=34 ;

--
-- Dumping data for table `[[dbprefix]]plugins`
--

INSERT INTO `[[dbprefix]]plugins` VALUES
(1, 'module', 'index', 'main', 'Index', 'index/index.php', 10, 1, 1),
(2, 'admin.home.sidepanel', 'page', 'admin.home', 'Pages', 'page/page.admin.home.php', 10, 1, 1),
(3, 'admin', 'page', 'admin', 'Pages', 'page/page.admin.php', 10, 1, 1),
(4, 'admin.extrafields.first', 'page', 'extrafields', 'Pages', 'page/page.extrafields.php', 10, 1, 1),
(5, 'header.main', 'page', 'header', 'Pages', 'page/page.header.php', 10, 1, 1),
(6, 'module', 'page', 'main', 'Pages', 'page/page.php', 10, 1, 1),
(7, 'structure.extensions', 'page', 'structure', 'Pages', 'page/page.structure.php', 10, 1, 1),
(8, 'trashcan.api', 'page', 'trashcan', 'Pages', 'page/page.trashcan.php', 10, 1, 1),
(9, 'module', 'rss', 'main', 'RSS', 'rss/rss.php', 10, 1, 1),
(10, 'admin.home.sidepanel', 'users', 'admin.home', 'Users', 'users/users.admin.home.php', 10, 1, 1),
(11, 'admin.extrafields.first', 'users', 'extrafields', 'Users', 'users/users.extrafields.php', 10, 1, 1),
(12, 'module', 'users', 'main', 'Users', 'users/users.php', 10, 1, 1),
(13, 'admin.home', 'cleaner', 'main', 'Cleaner', 'cleaner/cleaner.php', 10, 1, 0),
(14, 'parser.last', 'ckeditor', 'anchor', 'CKEditor', 'ckeditor/ckeditor.anchor.php', 10, 1, 0),
(15, 'editor', 'ckeditor', 'editor', 'CKEditor', 'ckeditor/ckeditor.editor.php', 10, 1, 0),
(16, 'pfs.first', 'ckeditor', 'pfs', 'CKEditor', 'ckeditor/ckeditor.pfs.php', 10, 1, 0),
(17, 'forums.posts.first', 'html', 'forums', 'HTML Parser', 'html/html.forums.php', 10, 1, 0),
(18, 'parser', 'html', 'parser', 'HTML Parser', 'html/html.parser.php', 10, 1, 0),
(19, 'pfs.first', 'html', 'pfs', 'HTML Parser', 'html/html.pfs.php', 10, 1, 0),
(20, 'global', 'htmlpurifier', 'main', 'HTML Purifier', 'htmlpurifier/htmlpurifier.php', 10, 1, 0),
(21, 'forums.posts.first', 'search', 'forums.posts.first', 'Search', 'search/search.forums.posts.first.php', 10, 1, 0),
(22, 'header.main', 'search', 'header', 'Search', 'search/search.header.php', 10, 1, 0),
(23, 'page.first', 'search', 'page.first', 'Search', 'search/search.page.first.php', 10, 1, 0),
(24, 'standalone', 'search', 'main', 'Search', 'search/search.php', 10, 1, 0),
(25, 'rc', 'search', 'rc', 'Search', 'search/search.rc.php', 10, 1, 0),
(26, 'index.main', 'indexnews', 'index.main', 'Index News', 'indexnews/indexnews.index.main.php', 10, 1, 0),
(27, 'index.tags', 'indexnews', 'index.tags', 'Index News', 'indexnews/indexnews.index.tags.php', 10, 1, 0),
(28, 'comments.newcomment.tags', 'mcaptcha', 'com.tags', 'MathCaptcha', 'mcaptcha/mcaptcha.com.tags.php', 10, 1, 0),
(29, 'comments.send.first', 'mcaptcha', 'com.validate', 'MathCaptcha', 'mcaptcha/mcaptcha.com.validate.php', 10, 1, 0),
(30, 'global', 'mcaptcha', 'global', 'MathCaptcha', 'mcaptcha/mcaptcha.global.php', 10, 1, 0),
(31, 'users.register.tags', 'mcaptcha', 'register.tags', 'MathCaptcha', 'mcaptcha/mcaptcha.register.tags.php', 10, 1, 0),
(32, 'users.register.add.first', 'mcaptcha', 'register.validate', 'MathCaptcha', 'mcaptcha/mcaptcha.register.validate.php', 10, 1, 0),
(33, 'tools', 'ipsearch', 'admin', 'IP search', 'ipsearch/ipsearch.admin.php', 10, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]structure`
--

CREATE TABLE `[[dbprefix]]structure` (
  `structure_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `structure_area` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `structure_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `structure_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `structure_tpl` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `structure_title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `structure_desc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `structure_icon` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `structure_locked` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `structure_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`structure_id`),
  KEY `structure_code` (`structure_code`),
  KEY `structure_path` (`structure_path`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]structure`
--

INSERT INTO `[[dbprefix]]structure` VALUES
(1, 'page', 'articles', '001', '', 'Articles', '', '', 0, 0),
(2, 'page', 'system', '999', '', 'System', '', '', 0, 0),
(3, 'page', 'events', '002', '', 'Events', '', '', 0, 0),
(4, 'page', 'news', '003', '', 'News', '', '', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]updates`
--

CREATE TABLE `[[dbprefix]]updates` (
  `upd_param` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `upd_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`upd_param`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]updates`
--

INSERT INTO `[[dbprefix]]updates` VALUES
('branch', 'siena'),
('revision', '0.9.23');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_banexpire` int(10) unsigned NOT NULL DEFAULT '0',
  `user_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_password` varchar(224) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_passfunc` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sha256',
  `user_passsalt` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_maingrp` mediumint(8) unsigned NOT NULL DEFAULT '4',
  `user_country` char(2) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `user_timezone` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'UTC',
  `user_text` text COLLATE utf8mb4_unicode_ci,
  `user_birthdate` date DEFAULT NULL,
  `user_gender` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'U',
  `user_email` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_hideemail` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `user_theme` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `user_scheme` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `user_lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `user_regdate` int(10) unsigned NOT NULL DEFAULT '0',
  `user_lastlog` int(10) unsigned NOT NULL DEFAULT '0',
  `user_lastvisit` int(10) unsigned NOT NULL DEFAULT '0',
  `user_lastip` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `user_logcount` int(10) unsigned NOT NULL DEFAULT '0',
  `user_sid` char(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `user_sidtime` int(10) unsigned NOT NULL DEFAULT '0',
  `user_lostpass` char(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `user_auth` mediumtext COLLATE utf8mb4_unicode_ci,
  `user_token` char(16) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`user_id`),
  KEY `user_password` (`user_password`),
  KEY `user_regdate` (`user_regdate`),
  KEY `user_name` (`user_name`),
  KEY `user_maingrp` (`user_maingrp`),
  KEY `user_email` (`user_email`),
  KEY `user_sid` (`user_sid`),
  KEY `user_lostpass` (`user_lostpass`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, 0, '[[admin_username]]', '[[admin_pass]]', 'sha256', '[[salt]]', 5, '', 'UTC', NULL, NULL, 'U', '[[admin_email]]', 1, 'nemesis', 'default', 'en', [[timestamp]], 0, 0, '[[clientip]]', 0, '', 0, '', NULL, '');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
