# Cotonti Siena

**Cotonti** is a powerful open-source web development framework and content manager with a focus on security, speed and flexibility.
Why choose Cotonti?

Cotonti combines the flexibility of a web framework with the rapid deployability and featureset of a content management system. Despite having features such as user accounts, content creation, file management and community tools out of the box, it can be easily extended using modules or plugins. Cotonti is powered by its own template engine which is both fast and easy to learn, even if you are not an experienced programmer.

Read more about [Cotonti's Benefits](https://www.cotonti.com/articles/benefits)...

## Major features

* Open source, community driven
* Secure and reliable
* Fast and lightweight
* Modular and extensible
* Layout separated from logic
* Fast and easy template engine
* Internationalized


## Releases and latest Changes

You can find latest releases and its change lists on [dedicated GitHub page](https://github.com/Cotonti/Cotonti/releases).


## Requirements

To install Cotonti you need the following server software pre-installed:

* WWW Server (Apache, nginx, etc)
* PHP 7.3.0 or higher
* MySQL 5.0.8 or higher


## Server configuration

You MUST ensure that PHP has been compiled with support for:
* GD
* Hash
* Mbstring
* MySQL
* PCRE
* PDO and PDO_MySQL
* Sessions
* Zlib
in order to successfully run Cotonti.


## Optional components

If you want support for SEF (Search Engine Friendly) URLs,
you'll need `mod_rewrite` and the ability to use local `.htaccess` files.


## Installation

For step-by-step instructions see [Install.txt](https://github.com/Cotonti/Cotonti/blob/master/Install.txt) file.


## Contribution 

Cotonti is only as good as it is because of many individual community members and users that take the time to [report issues and request new features](https://github.com/Cotonti/Cotonti/issues), write the [documentation](https://www.cotonti.com/docs/), post feedback in the Cotonti [community forums](https://www.cotonti.com/forums). To be one of our developer community, become a Contributor.

Be sure you are familiar with Cotonti [technical concepts](https://www.cotonti.com/docs/devel/technical_concepts), coding [guidelines](https://www.cotonti.com/docs/devel/coding_guide) and [style](https://www.cotonti.com/docs/devel/code-style) we use.

When you're ready to contribute the bugfix or a new feature you can issue a [Pull Request](https://help.github.com/articles/using-pull-requests/) with related commit(s) from your GitHub account.


## Copyright

Copyright (c) 2008-2024, Cotonti Team

Copyright (c) 2001-2008, Neocrome

All rights reserved.

## License

Cotonti Siena is free software; you can redistribute it and/or modify it under the terms of the [3-clause BSD License](https://en.wikipedia.org/wiki/BSD_licenses#3-clause_license_.28.22Revised_BSD_License.22.2C_.22New_BSD_License.22.2C_or_.22Modified_BSD_License.22.29) (or New-BSD) as published by Regents of the University of California.

[BSD 3-clause License](https://github.com/Cotonti/Cotonti/blob/master/License.txt) 
