<?php
$lang['help_function_page_selector'] = '<h3>Zweck dieses Plugins</h3>
<p>Dieses Admin-Plugin bietet eine Steuerung, um die Auswahl einer Inhaltsseite oder eines anderen Elements zu ermöglichen. Dies eignet sich, um einem Webseitenadministrator die Auswahl einer Seite zu ermöglichen, die in einer Einstellung gespeichert wird.</p>
<h3>Verwendung:</h3>
<pre><code>{page_selector name=standardseite value=$aktuelle_seite}</code></pre>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>name</th>
		<td>string</td>
		<td>Der Name des Eingabefelds.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>value</th>
		<td>int</td>
		<td>Die ID der aktuell ausgewählten Seite.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>allowcurrent</th>
		<td>bool</td>
		<td>Ob das aktuell ausgewählte Element erneut ausgewählt werden darf oder nicht. Der Standardwert ist false.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>allow_all</th>
		<td>bool</td>
		<td>Ob inaktive Inhaltsobjekte oder Inhaltsobjekte, die keine verwendbaren Links haben, ausgewählt werden dürfen oder nicht. Der Standardwert ist false.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>for_child</th>
		<td>bool</td>
		<td>Gibt an, dass wir eine übergeordnete Seite für ein neues Inhaltsobjekt auswählen. Der Standardwert ist false.</td>
	</tr>
</table>';
$lang['help_function_cms_html_options'] = '<h3>Zweck dieses Plugins</h3>
<p>Dies ist ein leistungsstarkes Plugin, um Optionen für Auswahlelemente in HTML <option>- und <optgroup>-Tags zu rendern. Jede Option kann Unterelemente, einen eigenen Titel-Tag und ein eigenes Klassenattribut haben.</p>
<h3>Verwendung:</h3>
<pre><code>{cms_html_options options=$options [selected=value]}</code></pre>
<h3>Welche Parameter werden akzeptiert?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>options</th>
		<td>array</td>
		<td>Ein Array von Optionsdefinitionen.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>selected</th>
		<td>string</td>
		<td>Der Wert, der automatisch in der Dropdown-Liste ausgewählt werden soll. Muss dem Wert einer der Optionen entsprechen.</td>
	</tr>
</table>
<h4>Optionen</h4>
<p>Jede Option ist ein assoziatives Array mit zwei oder mehr der folgenden Elemente:</p>
<table>
	<tr>
		<th scope=\\\'col\\\'>Element</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>label</th>
		<td>string (erforderlich)</td>
		<td>Ein Label für die Option (das dem Benutzer präsentiert wird).</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>value</th>
		<td>mixed (erforderlich)</td>
		<td>Entweder ein Zeichenfolgenwert für die Option oder ein Array von Optionsdefinitionen.
			<p>Wenn der Wert einer Optionsdefinition selbst ein Array von Optionen ist, wird das Label als optgroup mit Unterelementen gerendert.</p>
		</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>title</th>
		<td>string</td>
		<td>Ein Titelattribut für die Option.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>class</th>
		<td>string</td>
		<td>Ein Klassenname für die Option.</td>
	</tr>
</table>

<h3>Beispiel:</h3>
<pre><code>
{$opts[]=[\'label\'=>\'Vogel\',\'value\'=>\'b\',\'title\'=>\'Ich habe einen Haustiervogel\']}
{$opts[]=[\'label\'=>\'Fisch\',\'value\'=>\'f\']}
{$sub[]=[\'label\'=>\'Kleiner Hund\',\'value\'=>\'sd\']}
{$sub[]=[\'label\'=>\'Mittlerer Hund\',\'value\'=>\'md\']}
{$sub[]=[\'label\'=>\'Großer Hund\',\'value\'=>\'ld\']}
{$opts[]=[\'label\'=>\'Hund\',\'value\'=>$sub]}
{$opts[]=[\'label\'=>\'Katze\',\'value\'=>\'c\',\'class\'=>\'katze\']}
<select name=\\\'haustier\\\'>
	{cms_html_options options=$opts selected=\'md\'}
</select></code></pre>';
$lang['help_modifier_cms_date_format'] = '<h3>Beschreibung</h3>
<p>Dieser Modifikator formatiert Datumsangaben in ein geeignetes Format. Es nutzt die regulären „strftime“-Parameter. Wenn keine Format-Zeichenfolge angegeben ist, verwendet das System die Benutzereinstellungen des Datumsformats (für angemeldete Benutzer) oder das Standard-Datumsformat des Systems.</p>
<p>Dieser Modifikator ist in der Lage, Daten in vielen Formaten zu verstehen, z. B. Datumsausgaben aus der Datenbank oder Integer-Zeitstempel, die von der Funktion time() erzeugt werden.</p>
<h3>Verwendung</h3>
<pre><code>{$some_date_var|cms_date_format[:<format string>]}</code></pre>
<h3>Beispiel</ h3>
<pre><code>{\'2012-03-24 22:44:22 \'|cms_date_format}</code></pre>';
$lang['help_modifier_cms_escape'] = '<h3>Was macht das?</h3>
<p>Dieser Modifikator wird verwendet, um den String auf verschiedene Arten zu escapen. Dies kann verwendet werden, um den String in mehrere verschiedene Anzeigeformate zu konvertieren oder um Benutzereingaben mit Sonderzeichen auf einer Standard-Webseite darstellbar zu machen.</p>
<h3>Verwendung:</h3>
<pre><code>{$some_var_with_text|cms_escape[:<escape type>|[<character set>]]}</code></pre>
<h4>Gültige Escape-Typen:</h4>
<table>
	<tr>
		<th scope=\\\'col\\\'>Escape-Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>html (Standard)</th>
		<td>Verwendet htmlspecialchars.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>htmlall</th>
		<td>Verwendet htmlentities.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>url</th>
		<td>Kodiert alle Entitäten als Roh-URL.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>urlpathinfo</th>
		<td>Ähnlich wie der URL-Escape-Typ, kodiert aber auch /.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>quotes</th>
		<td>Escapen von unmaskierten einfachen Anführungszeichen.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>hex</th>
		<td>Escapen jedes Zeichens in Hexadezimal.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>hexentity</th>
		<td>Hexadezimale Kodierung jedes Zeichens.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>decentity</th>
		<td>Dezimale Kodierung jedes Zeichens.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>javascript</th>
		<td>Escapen von Anführungszeichen, Backslashes, Zeilenumbrüchen usw.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>mail</th>
		<td>Kodiert eine E-Mail-Adresse in etwas, das sicher angezeigt werden kann.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>nonstd</th>
		<td>Escapen von nicht standardmäßigen Zeichen, wie Dokumentanführungszeichen.</td>
	</tr>
</table>
<h4>Zeichensatz:</h4>
<p>Wenn der Zeichensatz nicht angegeben ist, wird utf-8 angenommen. Der Zeichensatz ist nur für die Escape-Typen „html“ und „htmlall“ anwendbar.</p>';
$lang['help_modifier_relative_time'] = '<h3>Was macht das?</h3>
<p>Dieser Modifikator wandelt einen ganzzahligen Zeitstempel oder eine Zeit-/Datumszeichenfolge in eine menschenlesbare Zeitspanne von oder bis jetzt um, z. B.: „vor 3 Stunden“</p>
<h3>Welche Parameter akzeptiert er?</h3>
<p>Dieser Modifikator akzeptiert keine optionalen Parameter.</p>
<h3>Beispiel:</h3>
<pre><code>{$some_timestamp|relative_time}</code></pre>';
$lang['help_modifier_summarize'] = '<h3>Was macht das?</h3>
<p>Dieser Modifikator wird verwendet, um eine lange Textsequenz auf eine begrenzte Anzahl von Wörtern zu kürzen.</p>
<h3>Verwendung:</h3>
<pre><code>{$some_var_with_long_text|summarize:<Anzahl>}</code></pre>
<h3>Beispiel:</h3>
<p>Im folgenden Beispiel würden alle HTML-Tags aus dem Inhalt entfernt und der Text nach 50 Wörtern gekürzt.</p>
<pre><code>{content|strip_tags|summarize:50}</code></pre>';
$lang['help_function_admin_icon'] = '<h3>Was macht das?</h3>
	<p>Dies ist ein Plugin nur für den Administrationsbereich, das Modulen ermöglicht, Piktogramme aus dem aktuellen Admin-Theme einfach anzuzeigen. Diese Piktogramme sind nützlich beim Erstellen von Links oder beim Anzeigen von Statusinformationen.</p>
	<h3>Welche Parameter werden akzeptiert?</h3>
	<table>
		<tr>
			<th scope=\\\'col\\\'>Parameter</th>
			<th scope=\\\'col\\\'>Typ</th>
			<th scope=\\\'col\\\'>Beschreibung</th>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>icon</th>
			<td>erforderlich</td>
			<td>Der Dateiname des Bilds, z. B.: run.gif</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>height</th>
			<td>optional</td>
			<td>Die Höhe des Bilds in Pixeln.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>width</th>
			<td>optional</td>
			<td>Die Breite des Bilds in Pixeln.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>alt</th>
			<td>optional</td>
			<td>Alternativtext für das img-Tag, falls der angegebene Dateiname nicht verfügbar ist.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>rel</th>
			<td>optional</td>
			<td>Ein rel-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>class</th>
			<td>optional</td>
			<td>Ein class-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>id</th>
			<td>optional</td>
			<td>Ein id-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>title</th>
			<td>optional</td>
			<td>Ein title-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>accesskey</th>
			<td>optional</td>
			<td>Ein Zugriffstasten-Zeichen für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>assign</th>
			<td>optional</td>
			<td>Weist die Ausgabe der benannten Smarty-Variable zu.</td>
		</tr>
	</table>
	<h3>Beispiel:</h3>
	<pre><code>{admin_icon icon=\'edit.gif\' class=\'editicon\'}</code></pre>';
$lang['help_function_cms_action_url'] = '<h3>Was macht das?</h3>
<p>Dies ist ein intelligentes Plugin, das nützlich ist, um eine URL zu einer Modulaktion zu generieren. Dieses Plugin ist nützlich für Modulentwickler, die Links generieren (entweder für Ajax oder im Administrationsbereich), um verschiedene Funktionen auszuführen oder verschiedene Daten anzuzeigen.</p>
<h3>Welche Parameter werden akzeptiert?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>module</th>
		<td>optional</td>
		<td>Der Modulname, für den eine URL generiert werden soll. Dieser Parameter ist nicht erforderlich, wenn eine URL von innerhalb einer Modulaktion zu einer Aktion innerhalb desselben Moduls generiert wird.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>action</th>
		<td>erforderlich</td>
		<td>Der Aktionsname, für den eine URL generiert werden soll.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>returnid</th>
		<td>optional</td>
		<td>Die Ganzzahl-Seiten-ID, um die Ergebnisse der Aktion anzuzeigen. Dieser Parameter ist nicht erforderlich, wenn die Aktion auf der aktuellen Seite angezeigt werden soll oder wenn die URL zu einer Administrationsaktion von innerhalb einer Administrationsaktion ist.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>mid</th>
		<td>optional</td>
		<td>Die Modulaktions-ID. Dies wird standardmäßig auf „m1_“ für Administrationsaktionen und „cntnt01“ für Frontendaktionen festgelegt.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>forjs</th>
		<td>optional</td>
		<td>Eine optionale Ganzzahl, die angibt, dass die generierte URL für die Verwendung in JavaScript geeignet sein sollte.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Weist die Ausgabe-URL der benannten Smarty-Variablen zu.</td>
	</tr>
</table>
<p><strong>Hinweis:</strong> Alle anderen Parameter, die von diesem Plugin nicht akzeptiert werden, werden automatisch an die aufgerufene Modulaktion in der generierten URL übergeben.</p>
<h3>Beispiel:</h3>
<pre><code>{cms_action_url module=News action=defaultadmin}</code></pre>';
$lang['help_function_cms_admin_user'] = '<h3>Was macht das?</h3>
<p>Dieses Admin-Plugin gibt Informationen über die angegebene Admin-Benutzer-ID aus.</p>

<h3>Welche Parameter werden akzeptiert?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>uid</th>
		<td>erforderlich</td>
		<td>Eine Ganzzahl-Benutzer-ID, die ein gültiges Admin-Konto darstellt.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>mode</th>
		<td>optional</td>
		<td>Der Betriebsmodus. Mögliche Werte sind:
			<table>
				<tr>
					<th scope=\\\'col\\\'>Wert</th>
					<th scope=\\\'col\\\'>Beschreibung</th>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>username</th>
					<td>(Standard) - gibt den Benutzernamen für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>email</th>
					<td>gibt die E-Mail-Adresse für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>firstname</th>
					<td>gibt den Vornamen für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>lastname</th>
					<td>gibt den Nachnamen für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>fullname</th>
					<td>gibt den vollständigen Namen für die angegebene uid aus.</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Weist die Ausgabe der benannten Smarty-Variablen zu.</td>
	</tr>
</table>

<h3>Beispiel:</h3>
<pre><code>{cms_admin_user uid=1 mode=email}</code></pre>';
$lang['help_function_cms_get_language'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin gibt den aktuellen CMSMS-Sprachnamen zurück. Die Sprache wird für Übersetzungszeichenfolgen und Datumsformatierung verwendet.</p>

<h3>Welche Parameter werden akzeptiert?</h3>
<table>
  <tr>
    <th scope=\\\'row\\\'>assign</th>
    <td>(optional) – weist die Ausgabe des Plugins der benannten Smarty-Variablen zu.</td>
  </tr>
</table>';
$lang['help_function_cms_help'] = '<h3>Was macht das?</h3>
<p>Dies ist ein Admin-Plugin, das verwendet wird, um einen Link zu generieren, der beim Klicken Popup-Hilfe für ein bestimmtes Element generiert.</p>
<p>Dieses Plugin wird in der Regel aus Modul-Admin-Vorlagen verwendet, um Endbenutzerhilfe in einem Popup-Fenster für ein Eingabefeld, eine Spalte oder andere wichtige Informationen anzuzeigen.</p>

<h3>Welche Parameter werden akzeptiert?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>key</th>
		<td>erforderlich</td>
		<td>Der zweite Teil in einem eindeutigen Schlüssel zur Identifizierung der anzuzeigenden Hilfesequenz. Dies ist normalerweise der Schlüssel aus der entsprechenden Sprachdatei des Bereichs.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>realm</th>
		<td>optional</td>
		<td>Der erste Teil in einem eindeutigen Schlüssel zur Identifizierung der Hilfesequenz. Wenn dieser Parameter nicht angegeben wird und dieses Plugin aus einer Modulaktion aufgerufen wird, wird normalerweise der aktuelle Modulname verwendet. Wenn kein Modulname gefunden werden kann, wird \\\'help\\\' als Sprachbereich verwendet.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>title</th>
		<td>optional</td>
		<td>Titel des Hilfefensters</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Weist die Ausgabe der benannten Smarty-Variablen zu.</td>
	</tr>
</table>

<h3>Beispiel:</h3>
<pre><code>{cms_help key2=\'help_field_username\' title=$foo}</code></pre>';
$lang['help_function_cms_init_editor'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin wird verwendet, um den ausgewählten visuellen Editor zu initialisieren, damit die WYSIWYG-Funktionalitäten für die Übermittlung von Frontend-Daten erforderlich sind. Dieses Modul wird den ausgewählten visuellen Editor für die öffentliche Website finden <em>(siehe globale Einstellungen)</em>, feststellen, ob er angefordert wurde, und falls ja, den entsprechenden HTML-Code generieren <em>(normalerweise JavaScript-Links)</em>, damit der Editor ordnungsgemäß initialisiert wird, wenn die Seite geladen wird. Wenn keine visuellen Editoren für die Frontend-Anforderung angefordert wurden, wird dieses Plugin keine Ausgabe erzeugen.</p>

<h3>Wie wird es verwendet?</h3>
<p>Zuerst müssen Sie den visuellen Editor in den globalen Einstellungen im Administrationsbereich auswählen. Wenn Sie visuelle Editoren auf zahlreichen Seiten verwenden, ist es möglicherweise am besten, das Plugin <code>{cms_init_editor}</code> direkt in Ihre Seitenvorlage einzubinden. Wenn Sie den visuellen Editor nur auf einer begrenzten Anzahl von Seiten aktivieren müssen, können Sie ihn einfach in das Feld „Seitenspezifische Metadaten“ auf jeder Seite platzieren.</p>

<h3>Welche Parameter werden akzeptiert?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<td>assign</td>
		<td>optional</td>
		<td>Weist die Ausgabe des Plugins der benannten Smarty-Variablen zu.</td>
	</tr>
</table>';
$lang['help_function_cms_lang_info'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin gibt ein Objekt zurück, das die Informationen enthält, die CMSMS über die ausgewählte Sprache hat. Diese können Lokalisierungsinformationen, Codierungen, Sprachaliase usw. enthalten.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>lang</th>
		<td>optional</td>
		<td>Die Sprache, für die Informationen zurückgegeben werden sollen. Wenn der lang-Parameter nicht angegeben ist, werden die Informationen für die aktuelle CMSMS-Sprache verwendet.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Weist die Ausgabe des Plugins der benannten Smarty-Variablen zu.</td>
	</tr>
</table>
<h3>Beispiel:</h3>
<pre><code>{cms_lang_info assign=\'nls\'}{$nls->locale()}</code></pre>
<h3>Siehe auch:</h3>
<p>die Dokumentation zur CmsNls-Klasse.</p>';
$lang['help_function_cms_pageoptions'] = '<h3>Was macht das?</h3>
<p>Dies ist ein einfaches Plugin zum Generieren einer Sequenz von <option>-Tags für eine Aufklappliste, die Seitenzahlen in einer Paginierung darstellt.</p>
<p>Anhand der Anzahl der Seiten und der aktuellen Seite generiert dieses Plugin eine Liste von Seitenzahlen, die eine schnelle Navigation zu einem Teil der Seiten ermöglichen.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>numpages</th>
		<td>Ganzzahl</td>
		<td>erforderlich</td>
		<td>Die Gesamtanzahl der verfügbaren Seiten, die angezeigt werden sollen.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>curpage</th>
		<td>Ganzzahl</td>
		<td>erforderlich</td>
		<td>Die aktuelle Seitennummer (muss größer als 0 und kleiner oder gleich „numpages“ sein).</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>surround</th>
		<td>Ganzzahl</td>
		<td>optional</td>
		<td>Die Anzahl der Elemente, die die aktuelle Seite umgeben sollen. Der Standardwert für diesen Parameter beträgt 3.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>bare</th>
		<td>boolescher Wert</td>
		<td>optional</td>
		<td>Gibt keine <option>-Tags aus, sondern gibt stattdessen nur ein einfaches Array aus, das für weitere Manipulationen in Smarty geeignet ist.</td>
	</tr>
</table>
<h3>Beispiel:</h3>
<pre><code><select name=\\\'{$actionid}pagenum\\\'>{cms_pageoptions numpages=50 curpage=14}</select></code></pre>';
$lang['help_function_share_data'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin wird verwendet, um eine oder mehrere aktive Smarty-Variablen in den übergeordneten oder globalen Bereich zu kopieren.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>scope</th>
		<td>String</td>
		<td>optional</td>
		<td>Der Zielbereich, in den die Variablen kopiert werden sollen. Mögliche Werte sind \\\'parent\\\' <em>(Standard)</em> oder \\\'global\\\', um die Daten zum globalen Smarty-Objekt zu kopieren, um sie auf der gesamten Seite später zu verwenden.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>vars</th>
		<td>gemischt</td>
		<td>erforderlich</td>
		<td>Entweder ein Array von Zeichenfolgenvariablennamen oder eine durch Kommas getrennte Liste von Zeichenfolgenvariablennamen.</td>
	</tr>
</table>
<h3>Beispiel:</h3>
<pre><code>{share_data scope=global data=\'title,canonical\'}</code></pre>
<h3>Hinweis:</h3>
<p>Dieses Plugin akzeptiert keine Array-Zugriffe oder Objektmitglieder als Variablennamen. Zum Beispiel, <code>$foo[1]</code> oder <code>{$foo->bar}</code> funktionieren nicht.</p>';
$lang['help_function_cms_yesno'] = '<h3>Was macht das?</h3>
<p>Dies ist ein einfaches Plugin, das bei der Formularerstellung verwendet wird, um eine Reihe von Optionen für eine Aufklappliste zu erstellen, das eine Ja/Nein-Auswahl darstellt.</p>
<p>Dieses Plugin generiert übersetzte Ja/Nein-Optionen mit dem richtigen ausgewählten Wert.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>selected</th>
		<td>Ganzzahl</td>
		<td>optional</td>
		<td>entweder 0 <em>(nein)</em> oder 1 <em>(ja)</em></td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>String</td>
		<td>optional</td>
		<td>Weist die Ausgabe der benannten Smarty-Variablen zu.</td>
	</tr>
</table>
<h3>Beispiel:</h3>
<pre><code><select name="{$actionid}opt">{cms_yesno selected=$opt}</select></code></pre>';
$lang['help_function_module_available'] = '<h3>Was macht das?</h3>
<p>Ein Plugin, um zu testen, ob ein bestimmtes Modul (nach Namen) installiert ist und für die Verwendung verfügbar ist.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>module</th>
		<td>String</td>
		<td>erforderlich</td>
		<td>Der Name des Moduls.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>String</td>
		<td>optional</td>
		<td>Weist die Ausgabe des Plugins der benannten Smarty-Variablen zu.</td>
	</tr>
</table>
<h3>Beispiel:</h3>
<pre><code>{module_available module=\'News\' assign=\'havenews\'}
{if $havenews}
	{cms_module module=News}
{/if}</code></pre>
<h3>Hinweis:</h3>
<p>Sie können die Kurzform des Modulaufrufs (z. B. <code>{News}</code>) in dieser Art von Ausdruck nicht verwenden, es muss das Tag <code>{cms_module module=…}</code> verwendet werden.</p>';
$lang['help_function_cms_set_language'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin versucht, die aktuelle Sprache für die Verwendung von Übersetzungszeichenfolgen und Datumsformatierungen auf die gewünschte Sprache festzulegen. Die angegebene Sprache muss CMSMS bekannt sein (Die nls-Datei muss vorhanden sein). Wenn diese Funktion aufgerufen wird (und sofern nicht in der config.php überschrieben), wird versucht, die Lokalisierung auf die mit der Sprache verbundene Lokalisierung zu setzen. Die Lokalisierung für die Sprache muss auf dem Server installiert sein.</p>
<h3>Welche Parameter nimmt es?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>lang</th>
		<td>erforderlich</td>
		<td>Die gewünschte Sprache. Die Sprache muss der CMSMS-Installation bekannt sein (nls-Datei muss vorhanden sein).</td>
	</tr>
</table>';
$lang['help_function_browser_lang'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin erkennt und gibt die Sprache aus, die der Browser des Benutzers akzeptiert, und gleicht sie mit einer Liste von erlaubten Sprachen ab, um einen Sprachwert für die Sitzung zu bestimmen.</p>
<h3>Wie verwende ich es?</h3>
<p>Fügen Sie das Tag frühzeitig in Ihre Seitenvorlage ein <em>(es kann über dem <head>-Abschnitt platziert werden, wenn Sie möchten)</em> und geben Sie ihm den Namen der Standardsprache und die akzeptierten Sprachen an (nur Zwei-Zeichen-Sprachcodes werden akzeptiert), und tun Sie dann etwas mit dem Ergebnis. z.B.:</p>
<pre><code>{browser_lang accepted="de,fr,en,es" default=en assign=tmp}
{session_put var=lang val=$tmp}</code></pre>
<p><em>(<code>{session_put}</code> ist ein Plugin, das vom SimpleSmarty-Modul bereitgestellt wird)</em>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>accepted</th>
		<td>erforderlich</td>
		<td>Eine durch Kommas getrenntes Liste von Zwei-Zeichen-Sprachcodes, die akzeptiert werden.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>default</th>
		<td>optional</td>
		<td>Eine Standardsprache, die ausgegeben wird, wenn keine akzeptierte Sprache vom Browser unterstützt wurde. en wird verwendet, wenn kein anderer Wert angegeben ist.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Der Name der Smarty-Variablen, der die Ergebnisse zugewiesen werden. Wenn nicht angegeben, werden die Ergebnisse dieser Funktion zurückgegeben.</td>
	</tr>
</table>';
$lang['help_function_content_module'] = '<h3>Was macht das?</h3>
<p>Dieser Inhaltstyp ermöglicht die Interaktion mit verschiedenen Modulen, um verschiedene Arten von Inhaltblöcken zu erstellen.</p>
<p>Einige Module können Inhaltblocktypen definieren, die in Modulvorlagen verwendet werden sollen. z.B.: Das MAMS-Modul kann einen Gruppenlisten-Inhaltstyp definieren. Es wird dann angeben, wie Sie den content_module-Tag verwenden können, um diesen Blocktyp in Ihren Vorlagen zu nutzen.</p>
<p><strong>Hinweis:</strong> Dieser Blocktyp darf nur mit kompatiblen Modulen verwendet werden. Sie sollten dies nur so verwenden, wie es von Add-On-Modulen empfohlen wird.</p>
<p>Dieser Tag akzeptiert einige Parameter und leitet alle anderen Parameter zur Verarbeitung an das Modul weiter.</p>
<table>
	<caption>Parameter</caption>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>module</code></th>
		<td>erforderlich</td>
		<td>Der Name des Moduls, das diesen Inhaltblock bereitstellt. Dieses Modul muss installiert und verfügbar sein.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>block</code></th>
		<td>erforderlich</td>
		<td>Der Name des Inhaltblocks.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>label</code></th>
		<td>optional</td>
		<td>Eine Beschriftung für den Inhaltblock zur Verwendung beim Bearbeiten der Seite.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>required</code></th>
		<td>optional</td>
		<td>Ermöglicht die Angabe, dass der Inhaltblock einen Text enthalten muss.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>tab</code></th>
		<td>optional</td>
		<td>Das gewünschte Register, auf dem dieses Feld im Bearbeitungsformular angezeigt werden soll.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>priority</code></th>
		<td>optional</td>
		<td>Ermöglicht die Angabe einer ganzen Zahl als Priorität für den Block innerhalb des Tabs.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>assign</code></th>
		<td>optional</td>
		<td>Weist die Ergebnisse einer Smarty-Variablen mit diesem Namen zu.</td>
	</tr>
</table>';
$lang['help_function_cms_stylesheet'] = '<h3>Was macht das?</h3>
<p>Dieses Tag ist der Ersatz für das {stylesheet}-Tag. Es ermöglicht die Verarbeitung von Smarty in CSS-Dateien und das Zwischenspeichern derselben, indem statische Dateien im Verzeichnis /tmp/cache generiert werden.</p>
<p>Dieses Plugin ruft Stylesheet-Informationen aus dem System ab. Standardmäßig werden alle Stylesheets, die der aktuellen Vorlage in der vom Designer festgelegten Reihenfolge angehängt sind, abgerufen und zu einem einzelnen Stylesheet kombiniert.</p>
<p>Generierte Stylesheets werden gemäß dem letzten Änderungsdatum in der Datenbank eindeutig benannt und werden nur generiert, wenn sich ein Stylesheet geändert hat.</p>
<h3>Wie benutze ich es?</h3>
<p>Fügen Sie das Tag <code>{cms_stylesheet}</code> einfach in den Kopfbereich Ihrer Vorlage/Seite ein.</p>
<h3>Akzeptierte Parameter.</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>name</code></th>
		<td>optional</td>
		<td>String</td>
		<td>Anstelle aller Stylesheets für die angegebene Seite abzurufen, wird nur ein speziell benanntes Stylesheet abgerufen, unabhängig davon, ob es der aktuellen Vorlage angehängt ist oder nicht.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>nocombine</code></th>
		<td>optional</td>
		<td>boolscher Wert, Standardwert „false“</td>
		<td>Wenn aktiviert und mehrere Stylesheets mit dem Template verknüpft sind, werden die Stylesheets als separate Tags ausgegeben, anstatt zu einem einzelnen Tag kombiniert zu werden.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>nolinks</code></th>
		<td>optional</td>
		<td>boolscher Wert, Standardwert „false“</td>
		<td>Wenn aktiviert, werden die Stylesheets als URL ohne <link>-Tag ausgegeben.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>https</code></th>
		<td>optional</td>
		<td>boolscher Wert, Standardwert „false“</td>
		<td>Gibt an, ob der ssl_url-Konfigurationseintrag verwendet werden soll, um Stylesheet-URLs zu präfixieren. Wenn nicht angegeben, wird das System versuchen, die richtige Root-URL basierend auf dem sicheren Flag der angezeigten Seite zu bestimmen.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>designid</code></th>
		<td>optional</td>
		<td>String</td>
		<td>Wenn designid definiert ist, werden Stylesheets zurückgegeben, die mit diesem Design anstelle des aktuellen verknüpft sind.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>media</code></th>
		<td>optional</td>
		<td>String <strong>[veraltet]</strong></td>
		<td>Wenn in Verbindung mit dem Namen-Parameter verwendet, ermöglicht dieser Parameter das Überschreiben des Medientyps für dieses Stylesheet. Wenn in Verbindung mit dem templateid-Parameter verwendet, gibt der media-Parameter nur Stylesheet-Tags für diejenigen Stylesheets aus, die als kompatibel mit dem angegebenen Medientyp markiert sind.</td>
	</tr>
</table>
<h3>Smarty-Verarbeitung</h3>
<p>Bei der Generierung von CSS-Dateien werden die Stylesheets, die aus der Datenbank abgerufen wurden, durch Smarty geleitet. Die Smarty-Delimiter wurden von den CMSMS-Standard { und } auf [[ und ]] geändert, um den Übergang in Stylesheets zu erleichtern. Dies ermöglicht das Erstellen von Smarty-Variablen am Anfang des Stylesheets und die Verwendung dieser Variablen später im Stylesheet, z.B.:</p>
<pre>
<code>
[[assign var=\'red\' value=\'#900\']]

h3 .error { color: [[$red]]; }<br/>
</code>
</pre>
<p>Weil die zwischengespeicherten Dateien im Verzeichnis /tmp/cache der CMSMS-Installation generiert werden, ist das CSS-relative Arbeitsverzeichnis nicht das Wurzelverzeichnis. Daher sollten alle Bilder oder anderen Tags, die eine URL benötigen, das Tag <code>[[root_url]]</code> verwenden, um sicherzustellen, dass es sich um eine absolute URL handelt. z.B.:</p>
<pre>
<code>
h3 .error { background: url([[root_url]]/uploads/images/error_background.png); }<br/>
</code>
</pre>
<p><strong>Hinweis:</strong> Aufgrund der Zwischenspeicherung des Plugins sollten Smarty-Variablen oben in JEDES Stylesheet platziert werden, das einer Vorlage zugewiesen ist.</p>';
$lang['help_function_page_attr'] = '<h3>Was macht das?</h3>
<p>Mit diesem Tag können Sie den Wert der Attribute einer bestimmten Seite abrufen.</p>
<h3>Wie benutze ich es?</h3>
<p>Fügen Sie das Tag <code>{page_attr key=\'extra1\'}</code> in die Vorlage ein.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<thead>
		<tr>
			<th scope=\\\'col\\\'>Parameter</th>
			<th scope=\\\'col\\\'>Status</th>
			<th scope=\\\'col\\\'>Beschreibung</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<th scope=\\\'row\\\'><code>page</code></th>
			<td>optional</td>
			<td>Eine optionale Seiten-ID oder Alias, von der der Inhalt abgerufen werden soll. Wenn nicht angegeben, wird die aktuelle Seite angenommen.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'><code>key</code></th>
			<td>erforderlich</td>
			<td>
				<p>Der Schlüssel, um das Attribut abzurufen. Der Schlüssel kann entweder ein Blockname sein oder aus einer Reihe von Standardattributen stammen, die mit einer Inhaltsseite verknüpft sind. Einige akzeptierte Standardattribute sind:</p>
				<table>
					<tr>
						<th scope=\\\'col\\\'>Wert</th>
						<th scope=\\\'col\\\'>Typ</th>
						<th scope=\\\'col\\\'>Beschreibung</th>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>_dflt_</code></th>
						<td>String</td>
						<td>Der Wert für den Standardinhaltsblock (ein Alias für „content_en“)</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>title</code></th>
						<td>String</td>
						<td></td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>description</code></th>
						<td>String</td>
						<td></td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>alias</code></th>
						<td>String</td>
						<td>Der eindeutige Seitenalias.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>id</code></th>
						<td>Ganzzahl</td>
						<td>Die eindeutige Seiten-ID.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>created_date</code></th>
						<td>String (Datum)</td>
						<td>Datum der Erstellung des Inhaltsobjekts.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>modified_date</code></th>
						<td>String (Datum)</td>
						<td>Datum der letzten Änderung des Inhaltsobjekts.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>last_modified_by</code></th>
						<td>Ganzzahl</td>
						<td>UID des Benutzers, der die Seite zuletzt geändert hat.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>owner</code></th>
						<td>Ganzzahl</td>
						<td>UID des Seitenbesitzers.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>image</code></th>
						<td>String</td>
						<td>Der Pfad zum Bild, das mit der Inhaltsseite verknüpft ist.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>thumbnail</code></th>
						<td>String</td>
						<td>Der Pfad zum Vorschaubild, das mit der Inhaltsseite verknüpft ist.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>extra1</code></th>
						<td>String</td>
						<td>Der Wert des Attributs „extra1“.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>extra2</code></th>
						<td>String</td>
						<td>Der Wert des Attributs „extra2“.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>extra3</code></th>
						<td>String</td>
						<td>Der Wert des Attributs „extra3“.</td>
					</tr>
					<tr>
						<th scope=\\\'row\\\'><code>pageattr</code></th>
						<td>String</td>
						<td>Der Wert des seitenspezifischen Smarty-Datenattributs.</td>
					</tr>
				</table>
				<strong>Hinweis:</strong> Die obige Liste ist nicht abschließend. Sie können auch die nicht analysierten Inhalte zusätzlicher Inhaltsblöcke oder Eigenschaften abrufen, die von Drittanbietermodulen hinzugefügt wurden. Die Ausgabe ist immer ein String.
			</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'><code>inactive</code></th>
			<td>optional</td>
			<td>Ermöglicht das Lesen von Seitenattributen von inaktiven Seiten.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'><code>assign</code></th>
			<td>optional</td>
			<td>Weist die Ergebnisse einer Smarty-Variable mit diesem Namen zu.</td>
		</tr>
	</tbody>
</table>
<h3>Gibt zurück:</h3>
<p><strong>string</strong> - Der tatsächliche Wert des Inhaltsblocks aus der Datenbank für den angegebenen Block und die Seite.</p>
<p><strong>Hinweis:</strong> Die Ausgabe dieses Plugins wird nicht durch Smarty geleitet oder für die Anzeige bereinigt. Wenn Sie die Daten anzeigen, müssen Sie Zeichendaten in Entitäten umwandeln und/oder sie durch Smarty leiten.</p>';
$lang['help_function_page_image'] = '<h3>Was tut dies?</h3>
<p>Dieses Tag kann verwendet werden, um den Wert der Bilddatei- oder Vorschaubild-Felder einer bestimmten Seite zurückzugeben.</p>
<h3>Wie verwende ich es?</h3>
<p>Fügen Sie das Tag <code>{page_image}</code> in die Vorlage ein.</p>
<h3>Welche Parameter nimmt es?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>thumbnail</code></th>
		<td>bool</td>
		<td>optional</td>
		<td>Den Wert der Vorschaubild-Eigenschaft anstatt der Bild-Eigenschaft an.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>full</code></th>
		<td>bool</td>
		<td>optional</td>
		<td>Ausgabe der vollständigen URL zur Bilddatei relativ zum Upload-Pfad anzeigen.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>tag</code></th>
		<td>bool</td>
		<td>optional</td>
		<td>Ausgabe eines vollständigen HTML-img-Tags, wenn die Eigenschaftswert nicht leer ist. Wenn der tag-Parameter aktiviert ist, wird „vollständig“ impliziert.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>assign</code></th>
		<td>String</td>
		<td>optional</td>
		<td>Die Ergebnisse einer Smarty-Variablen mit diesem Namen zuweisen.</td>
	</tr>
</table>
<p>Wenn der Parameter „tag“ angegeben ist und der Eigenschaftswert nicht leer ist, wird ein vollständiges HTML-img-Tag ausgegeben. Alle oben nicht aufgeführten Argumente des Plugins werden automatisch in das resultierende img-Tag aufgenommen. z. B.: <code>{page_image tag=true class=\\\'pageimage\\\' id=\\\'someid\\\' title=\\\'testing\\\'}</code>.</p>
<p>Wenn das Plugin ein vollständiges img-Tag ausgibt und das alt-Attribut nicht angegeben wurde, wird der Wert der Eigenschaft für das alt-Attribut des img-Tags verwendet.</p>';
$lang['help_function_dump'] = '<h3>Was tut dies?</h3>
<p>Dieser Tag kann verwendet werden, um den Inhalt von beliebigen Smarty-Variablen in einem lesbareren Format auszugeben. Dies ist nützlich für die Fehlerbehebung und das Bearbeiten von Vorlagen, um das Format und die Typen von Daten zu wissen, die verfügbar sind.</p>
<h3>Wie verwende ich es?</h3>
<p>Fügen Sie das Tag <code>{dump item=\'the_smarty_variable_to_dump\'}</code> in die Vorlage ein.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>item</th>
		<td>String</td>
		<td>erforderlich</td>
		<td>Die Smarty-Variable, deren Inhalt ausgegeben werden soll.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>maxlevel</th>
		<td>Ganzzahl</td>
		<td>optional</td>
		<td>Die maximale Anzahl an Ebenen, die rekursiv ausgegeben werden (gilt nur, wenn „recurse“ auch angegeben ist). Der Standardwert für diesen Parameter ist 3.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>nomethods</th>
		<td>Bool</td>
		<td>optional</td>
		<td>Ausgabe von Methoden von Objekten vermeiden.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>novars</th>
		<td>Bool</td>
		<td>optional</td>
		<td>Ausgabe von Objektkennwerten vermeiden.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>recurse</th>
		<td>Bool</td>
		<td>optional</td>
		<td>Rekursion über eine maximale Anzahl von Ebenen durch die Objekte und Bereitstellung einer ausführlichen Ausgabe für jedes Element, bis die maximale Anzahl von Ebenen erreicht ist.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>String</td>
		<td>optional</td>
		<td>Zuweisen der Ergebnisse zu einer Smarty-Variablen mit diesem Namen.</td>
	</tr>
</table>';
$lang['help_function_content_image'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin ermöglicht es Vorlagendesignern, Benutzer aufzufordern, eine Bilddatei auszuwählen, wenn sie den Inhalt einer Seite bearbeiten. Es verhält sich ähnlich wie das Content-Plugin für zusätzliche Inhaltsbereiche.</p>
<h3>Wie wird es verwendet?</h3>
<p>Fügen Sie einfach das Tag <code>{content_image block=\'image1\'}</code> in Ihre Seitenvorlage ein.</p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>block</code></th>
		<td>String</td>
		<td><strong>erforderlich</strong></td>
		<td>Der Name für diesen zusätzlichen Inhaltsblock. <br> Beispiel: <code>{content_image block=\'image1\'}</code></td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>label</code></th>
		<td>String</td>
		<td>optional</td>
		<td>Eine Bezeichnung für diesen Inhaltsblock auf der Bearbeitungsseite. Wenn nicht angegeben, wird der Blockname verwendet.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>dir</code></th>
		<td>String</td>
		<td>optional</td>
		<td>Der Name eines Verzeichnisses – relativ zum Uploads-Verzeichnis – aus dem Bilddateien ausgewählt werden sollen. Wenn nicht angegeben, wird die Einstellung aus den globalen Einstellungen verwendet. Wenn diese Einstellung leer ist, wird das Uploads-Verzeichnis verwendet. <br> Beispiel: Verwenden Sie Bilder aus dem Verzeichnis uploads/images. <pre><code>{content_image block=\'image1\' dir=\'images\'}</code></pre></td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>default</code></th>
		<td>String</td>
		<td>optional</td>
		<td>Ein Standardbild festlegen, das verwendet wird, wenn kein Bild ausgewählt ist.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>urlonly</code></th>
		<td>Bool</td>
		<td>optional</td>
		<td>Geben Sie nur die URL des Bildes aus und ignorieren Sie alle Parameter wie id, name, width, height usw.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>tab</code></th>
		<td>String</td>
		<td>optional</td>
		<td>Der gewünschte Tab, auf dem dieses Feld im Bearbeitungsformular angezeigt werden soll.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>exclude</code></th>
		<td>String</td>
		<td>optional</td>
		<td>Geben Sie ein Präfix von Dateien an, die ausgeschlossen werden sollen. Zum Beispiel: thumb_</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>sort</code></th>
		<td>Bool</td>
		<td>optional</td>
		<td>Die Optionen sortieren; Standard ist, dass nicht sortiert wird.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>priority</code></th>
		<td>Ganzzahl</td>
		<td>optional</td>
		<td>Ermöglicht das Festlegen einer ganzzahligen Priorität für den Block innerhalb des Tabs.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>assign</code></th>
		<td>String</td>
		<td>optional</td>
		<td>Die Ergebnisse einer Smarty-Variablen mit diesem Namen zuweisen.</td>
	</tr>
</table>
<p><strong>Hinweis:</strong> Ab Version 2.2 wird keine Ausgabe generiert, wenn dieser Inhaltsblock keinen Wert enthält.</p>
<p>Zusätzlich zu den oben aufgeführten Argumenten akzeptiert dieses Plugin eine beliebige Anzahl zusätzlicher Argumente und leitet sie direkt an das generierte img-Tag weiter, falls vorhanden. Zum Beispiel: <code>{content_image block=\'img1\' id=\\\'id_img1\\\' class=\\\'page-image\\\' title=\'ein Bildblock\' data-foo=bar}</code></p>';
$lang['help_function_process_pagedata'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin verarbeitet die Daten im Block „pagedata“ von Inhaltsseiten über Smarty. Es ermöglicht Ihnen, seitenspezifische Daten für Smarty anzugeben, ohne die Vorlage für jede Seite ändern zu müssen.</p>
<h3>Wie verwende ich es?</h3>
<ol>
	<li>Fügen Sie Smarty-Zuweisungsvariablen und andere Smarty-Logik in das Feld „pagedata“ einiger Ihrer Inhaltsseiten ein.</li>
	<li>Fügen Sie das Tag <code>{process_pagedata}</code> ganz oben in Ihre Seitenvorlage ein.</li>
</ol>
<h3>Akzeptierte Parameter</h3>
<table>
	<thead>
		<tr>
			<th scope=\\\'col\\\'>Parameter</th>
			<th scope=\\\'col\\\'>Typ</th>
			<th scope=\\\'col\\\'>Status</th>
			<th scope=\\\'col\\\'>Beschreibung</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<th scope=\\\'row\\\'><code>assign</code></th>
			<td>String</td>
			<td>optional</td>
			<td>Die Ergebnisse einer Smarty-Variable mit diesem Namen zuweisen.</td>
		</tr>
	</tbody>
</table>';
$lang['help_function_current_date'] = '<h3 style=\\\'color: red;\\\'>Veraltet</h3>
<p>Verwenden Sie <code>{$smarty.now|cms_date_format}</code></p>
<h3>Was bewirkt das?</h3>
<p>Druckt das aktuelle Datum und die aktuelle Uhrzeit. Wenn kein Format angegeben ist, wird standardmäßig ein Format ähnlich „01.01.2004“ verwendet.</p>
<h3>Wie verwende ich es?</h3>
<p>Fügen Sie das Tag einfach in Ihre Vorlage/Seite ein, wie: <code>{current_date format=\\\'%A %d-%b-%y %T %Z\\\'}</code></p>
<h3>Akzeptierte Parameter</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Status</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>Format</code></th>
		<td>optional</td>
		<td>Datums-/Uhrzeitformat unter Verwendung von Parametern aus der strftime-Funktion von PHP.<br>Eine Parameterliste und weitere Informationen finden Sie auf <a href=\\\'https://www.php.net/strftime\\\' target=\\\'_blank\\\'>https://www.php.net/strftime</a>.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>ucword</code></th>
		<td>optional</td>
		<td>Wenn wahr, wird der erste Buchstabe jedes Worts in Großbuchstaben zurückgegeben.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'><code>assign</code></th>
		<td>optional</td>
		<td>Die Ergebnisse der benannten Smarty-Variable zuweisen.</td>
	</tr>
</table>';
$lang['function'] = 'Funktionen können eine Aufgabe ausführen oder die Datenbank abfragen und normalerweise eine Ausgabe anzeigen. Sie können wie folgt aufgerufen werden: <code>{tagname [attribute=value…]}</code>';
$lang['modifier'] = 'Modifikatoren nehmen die Ausgabe einer Smarty-Variable und modifizieren sie. Sie werden folgendermaßen aufgerufen: <code>{$variable|modifier[:arg:...]}</code>';
$lang['postfilter'] = 'Postfilter werden von Smarty automatisch nach der Kompilierung jeder Vorlage aufgerufen. Ein manueller Aufruf ist nicht möglich.';
$lang['prefilter'] = 'Vorfilter werden von Smarty automatisch vor der Kompilierung jeder Vorlage aufgerufen. Ein manueller Aufruf ist nicht möglich.';
$lang['tag_about'] = 'Zeigt den Entwicklungsverlauf und die Autoreninformationen für dieses Plugin an, sofern verfügbar';
$lang['tag_adminplugin'] = 'Gibt an, dass das Tag nur im Administrationsbereich verfügbar ist und normalerweise in Modulvorlagen verwendet wird.';
$lang['tag_cachable'] = 'Zeigt an, ob die Ausgabe des Plugins zwischengespeichert werden kann (wenn Smarty-Caching aktiviert ist). Admin-Plugins und Modifikatoren können nicht zwischengespeichert werden.';
$lang['tag_help'] = 'Hilfe für dieses Tag anzeigen (sofern verfügbar)';
$lang['tag_name'] = 'Dies ist der Name für das Tag';
$lang['tag_type'] = 'Tag-Typ (Funktion, Modifikator bzw. Pre- oder Post-Filter';
$lang['title_admin'] = 'Diese Erweiterung ist nur im CMSMS-Administrationsbereich verfügbar.';
$lang['title_notadmin'] = 'Diese Erweiterung ist im Administrationsbereich und auf der öffentlichen Website verwendbar.';
$lang['title_cachable'] = 'Diese Erweiterung kann zwischengespeichert werden';
$lang['title_notcachable'] = 'Diese Erweiterung kann nicht zwischengespeichert werden';
$lang['viewabout'] = 'Vorgeschichte und Autoreninformation für dieses Modul anzeigen';
$lang['viewhelp'] = 'Modulhilfe anzeigen';
?>