ALTER TABLE `invoice` CHANGE `pluginused` `pluginused` VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'none';
ALTER TABLE `customField` ADD `regex` TEXT NULL DEFAULT NULL;
ALTER TABLE `customuserfields` ADD `regex` TEXT NULL DEFAULT NULL;

UPDATE `help` SET `detail` = '[\n    {\n        "name": "COMPANYNAME",\n        "description": "Company name",\n        "hostingonly": false\n    },\n    {\n        "name": "COMPANYADDRESS",\n        "description": "Company address",\n        "hostingonly": false\n    },\n    {\n        "name": "ACCOUNTINFORMATION",\n        "description": "Account Information<br/><i style=\'font-size:smaller;\'>Includes Domain Name, Username, Password, IP</i>",\n        "hostingonly": true\n    },\n    {\n        "name": "DOMAINNAME",\n        "description": "Domain name without http://www.",\n        "hostingonly": false\n    },\n    {\n        "name": "DOMAINUSERNAME",\n        "description": "Domain User Name",\n        "hostingonly": true\n    },\n    {\n        "name": "DOMAINPASSWORD",\n        "description": "Domain Password",\n        "hostingonly": true\n    },\n    {\n        "name": "DOMAINIP",\n        "description": "IP Address to Domain",\n        "hostingonly": true\n    },\n    {\n        "name": "COMPANYURL",\n        "description": "URL to your web site",\n        "hostingonly": false\n    },\n    {\n        "name": "SUPPORTEMAIL",\n        "description": "E-mail to support staff",\n        "hostingonly": false\n    },\n    {\n        "name": "CLIENTAPPLICATIONURL",\n        "description": "URL to Clientexec.",\n        "hostingonly": false\n    },\n    {\n        "name": "FORGOTPASSWORDURL",\n        "description": "URL to retrieve forgotten password.",\n        "hostingonly": false\n    },\n    {\n        "name": "CLIENTNAME",\n        "description": "Client\'s first and last name",\n        "hostingonly": false\n    },\n    {\n        "name": "FIRSTNAME",\n        "description": "Client\'s First name",\n        "hostingonly": false\n    },\n    {\n        "name": "CLIENTEMAIL",\n        "description": "Client\'s Email",\n        "hostingonly": false\n    },\n    {\n        "name": "ORGANIZATION",\n        "description": "Client\'s Organization",\n        "hostingonly": false\n    },\n    {\n        "name": "PLANNAME",\n        "description": "Client\'s Plan",\n        "hostingonly": false\n    },\n    {\n        "name": "PACKAGEID",\n        "description": "Client\'s Package ID",\n        "hostingonly": false\n    },\n    {\n        "name": "NAMESERVERS",\n        "description": "Name Servers<br/><i style=\'font-size:smaller;\'>lists only hostnames</i>",\n        "hostingonly": false\n    },\n    {\n        "name": "NAMESERVERSANDIPS",\n        "description": "Name Servers and Ips<br/><i style=\'font-size:smaller;\'>lists both IPs and hostnames</i>",\n        "hostingonly": false\n    },\n    {\n        "name": "NAMESERVERIPS",\n        "description": "Name Server Ips<br/><i style=\'font-size:smaller;\'>lists only IPs</i>",\n        "hostingonly": false\n    },\n    {\n        "name": "SERVERHOSTNAME",\n        "description": "Server Host Name<br/><i style=\'font-size:smaller;\'>i.e. server1.yourdomain.com</i>",\n        "hostingonly": true\n    },\n    {\n        "name": "SERVERSHAREDIP",\n        "description": "Server\'s Shared IP",\n        "hostingonly": true\n    },\n    {\n        "name": "CUSTOMPROFILE_xxxx",\n        "description": "Custom Profile<br/><i style=\'font-size:smaller;\'>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>",\n        "hostingonly": false\n    },\n    {\n        "name": "CUSTOMPACKAGE_xxxx",\n        "description": "Custom Package Field<br/><i style=\'font-size:smaller;\'>Where xxx is custom package field name (i.e. [CUSTOMPACKAGE_somename])</i>",\n        "hostingonly": true\n    }\n]' WHERE `help`.`detail` = '[{"name":"COMPANYNAME","description":"Company name","hostingonly":false},{"name":"COMPANYADDRESS","description":"Company address","hostingonly":false},{"name":"ACCOUNTINFORMATION","description":"Account Information<br/><i style=\'font-size:smaller;\'>Includes Domain Name, Username, Password, IP</i>","hostingonly":true},{"name":"DOMAINNAME","description":"Domain name without http://www.","hostingonly":false},{"name":"DOMAINUSERNAME","description":"Domain User Name","hostingonly":true},{"name":"DOMAINPASSWORD","description":"Domain Password","hostingonly":true},{"name":"DOMAINIP","description":"IP Address to Domain","hostingonly":true},{"name":"COMPANYURL","description":"URL to your web site","hostingonly":false},{"name":"SUPPORTEMAIL","description":"E-mail to support staff","hostingonly":false},{"name":"CLIENTAPPLICATIONURL","description":"URL to Clientexec.","hostingonly":false},{"name":"FORGOTPASSWORDURL","description":"URL to retrieve forgotten password.","hostingonly":false},{"name":"CLIENTNAME","description":"Client\'s first and last name","hostingonly":false},{"name":"FIRSTNAME","description":"Client\'s First name","hostingonly":false},{"name":"CLIENTEMAIL","description":"Client\'s Email","hostingonly":false},{"name":"ORGANIZATION","description":"Client\'s Organization","hostingonly":false},{"name":"PLANNAME","description":"Client\'s Plan","hostingonly":false},{"name":"NAMESERVERS","description":"Name Servers<br/><i style=\'font-size:smaller;\'>lists only hostnames</i>","hostingonly":false},{"name":"NAMESERVERSANDIPS","description":"Name Servers and Ips<br/><i style=\'font-size:smaller;\'>lists both IPs and hostnames</i>","hostingonly":false},{"name":"NAMESERVERIPS","description":"Name Server Ips<br/><i style=\'font-size:smaller;\'>lists only IPs</i>","hostingonly":false},{"name":"SERVERHOSTNAME","description":"Server Host Name<br/><i style=\'font-size:smaller;\'>i.e. server1.yourdomain.com</i>","hostingonly":true},{"name":"SERVERSHAREDIP","description":"Server\'s Shared IP","hostingonly":true},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=\'font-size:smaller;\'>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>","hostingonly":false},{"name":"CUSTOMPACKAGE_xxxx","description":"Custom Package Field<br/><i style=\'font-size:smaller;\'>Where xxx is custom package field name (i.e. [CUSTOMPACKAGE_somename])</i>","hostingonly":true}]' AND `help`.`title` = 'Welcome Email Tags' LIMIT 1;

REPLACE INTO `tld_extra_attributes` (`tld`, `extra_attributes`) VALUES
('us', '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'),
('uk', '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'),
('nu', 'YToxOntzOjk6Imlpc19vcmdubyI7YTo0OntzOjI6IklEIjtzOjM6IjIyNyI7czoxMToiZGVzY3JpcHRpb24iO3M6Mjc5OiJPcmdhbml6YXRpb24gTnVtYmVyOgoKU3RhcnRzIHdpdGggSVNPIDMxNjYgQWxwaGEtMiBjb3VudHJ5IGNvZGUgaW4gc3F1YXJlIGJyYWNrZXRzIChlLmcuIFtVU10gZm9yIFVuaXRlZCBTdGF0ZXMpLCBmb2xsb3dlZCBieSAxIHRvIDEyMyBjaGFyYWN0ZXJzLiBJZiB0aGUgY291bnRyeSBjb2RlIGZvciBTd2VkZW4gaXMgZ2l2ZW4sIGEgdmFsaWQgU3dlZGlzaCBwZXJzb25hbCBvciBvcmdhbmlzYXRpb25hbCBudW1iZXIgbXVzdCBiZSBnaXZlbiAoNiBkaWdpdHMsIGRhc2gsIDQgZGlnaXRzKS4iO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('nyc', 'YToxOntzOjE3OiJueWNfbmV4dXNjYXRlZ29yeSI7YTo0OntzOjI6IklEIjtzOjM6IjIzNiI7czoxMToiZGVzY3JpcHRpb24iO3M6NTg5OiJPbmx5IGluZGl2aWR1YWxzIGFuZCBvcmdhbml6YXRpb25zIHRoYXQgaGF2ZSBhIHBoeXNpY2FsIHByZXNlbmNlIGluIG9uZSBvZiBOZXcgWW9yayBDaXR54oCZcyA1IGJvcm91Z2hzIHdpbGwgYmUgYWxsb3dlZCB0byByZWdpc3RlciBhIC5ueWMgZG9tYWluLgotIFAuTyBCb3hlcyBub3QgcGVybWl0dGVkCi0gUmVnaXN0cmFudHMgbXVzdCBhZ3JlZSB0aGF0IHRoZXkgYXJlIGluIGNvbXBsaWFuY2Ugd2l0aCBhbGwgcmVsZXZhbnQgRmVkZXJhbCwgTmV3IFlvcmsgU3RhdGUgYW5kIE5ldyBZb3JrIENpdHkgbGF3cyBhbmQgdGF4IHJlcXVpcmVtZW50cwotIFJlZ2lzdHJhbnRzIG11c3QgcmVtYWluIGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgYXBwbGljYWJsZSBOZXh1cyBQb2xpY3kgZm9yIHRoZSBkdXJhdGlvbiBvZiBkb21haW7igJlzIHJlZ2lzdHJhdGlvbgotIE5vIHByb3h5IHJlZ2lzdHJhdGlvbnMgcGVybWl0dGVk4oCTIFJlZ2lzdHJhbnRzIG11c3QgYWdyZWUgbm90IHRvIGxpY2Vuc2UsIHN1Yi1kZWxlZ2F0ZSBvciB0cmFuc2ZlciAubnljIGRvbWFpbihzKSB0byB0aGlyZCBwYXJ0aWVzLgoKSSBkZWNsYXJlIHRoYXQgSSBhbSBhbjoKIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToyOntzOjEyOiJPcmdhbml6YXRpb24iO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6Nzg6IkFuIGVudGl0eSBvciBvcmdhbml6YXRpb24gdGhhdCBoYXMgYSBwaHlzaWNhbCBzdHJlZXQgYWRkcmVzcyBpbiBOZXcgWW9yayBDaXR5LiI7czo1OiJ2YWx1ZSI7czozOiJPUkciO31zOjEwOiJJbmRpdmlkdWFsIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjY1OiJJbmRpdmlkdWFscyB3aG9zZSBwcmltYXJ5IHBsYWNlIG9mIHJlc2lkZW5jZSBpcyBpbiBOZXcgWW9yayBDaXR5LiI7czo1OiJ2YWx1ZSI7czo1OiJJTkRJViI7fX19fQ=='),
('physio', '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'),
('scot', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjU0IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('quebec', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjU1IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('bio', 'YToxOntzOjk6ImJpb19hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjI0MyI7czoxMToiZGVzY3JpcHRpb24iO3M6NDgzOiJCeSByZWdpc3RlcmluZyB0aGlzIGRvbWFpbiBuYW1lLCB0aGUgcmVnaXN0cmFudCBjb21taXRzIHRvIG5vdCB1bmRlcm1pbmUgdGhlIFByaW5jaXBsZXMgb2YgT3JnYW5pYyBBZ3JpY3VsdHVyZSBhcyBmb3JtdWxhdGVkIGJ5IHRoZSBJRk9BTSAoUE9BKS4gCgkJSWYgdGhlIHJlZ2lzdHJhbnQgaXMgYSBwcm9kdWNlciwgYSB0cmFuc2Zvcm1lciBvciByZXRhaWxlciBpbiB0aGUgZmllbGQgb2YgYWdyaWN1bHR1cmUsIGZvb2QgYW5kIGZhcm1pbmcsIHRoZSByZWdpc3RyYW50IGNvbW1pdHMgdG8gYWJpZGUgYnkgUE9BIGFuZCBieSBhbnkgCgkJcmVndWxhdGlvbnMgaW4gZm9yY2UgaW4gdGhlIHJlbGV2YW50IG1hcmtldHMgd2hlcmUgdGhlIHJlZ2lzdHJhbnQgaW50ZW5kcyB0byBwcmVzZW50IG9yIHByb21vdGUgaXRzIHByb2R1Y3RzIHdpdGhpbiB0aGUgb24tbGluZSBjb250ZW50IGFzc29jaWF0ZWQgd2l0aCB0aGlzIC5CSU8gZG9tYWluIG5hbWUocykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjE6e3M6NzoiSSBhZ3JlZSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czo0ODU6IkkgY2VydGlmeSB0aGF0IHRoZSByZWdpc3RyYW50IG9mIHRoaXMgZG9tYWluIHRoZSBjb21taXRzIHRvIG5vdCB1bmRlcm1pbmUgdGhlIFByaW5jaXBsZXMgb2YgT3JnYW5pYyBBZ3JpY3VsdHVyZSBhcyBmb3JtdWxhdGVkIGJ5IHRoZSBJRk9BTSAoUE9BKS4gCgkJSWYgdGhlIHJlZ2lzdHJhbnQgaXMgYSBwcm9kdWNlciwgYSB0cmFuc2Zvcm1lciBvciByZXRhaWxlciBpbiB0aGUgZmllbGQgb2YgYWdyaWN1bHR1cmUsIGZvb2QgYW5kIGZhcm1pbmcsIHRoZSByZWdpc3RyYW50IGNvbW1pdHMgdG8gYWJpZGUgYnkgUE9BIGFuZCBieSBhbnkgCgkJcmVndWxhdGlvbnMgaW4gZm9yY2UgaW4gdGhlIHJlbGV2YW50IG1hcmtldHMgd2hlcmUgdGhlIHJlZ2lzdHJhbnQgaW50ZW5kcyB0byBwcmVzZW50IG9yIHByb21vdGUgaXRzIHByb2R1Y3RzIHdpdGhpbiB0aGUgb24tbGluZSBjb250ZW50IGFzc29jaWF0ZWQgd2l0aCB0aGlzIC5CSU8gZG9tYWluIG5hbWUocykuIjtzOjU6InZhbHVlIjtzOjc6IkkgQWdyZWUiO319fX0='),
('archi', 'YToxOntzOjExOiJhcmNoaV9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjI0MCI7czoxMToiZGVzY3JpcHRpb24iO3M6MzI2OiJCeSByZWdpc3RlcmluZyB0aGlzIGRvbWFpbiBuYW1lLCB5b3UgY2VydGlmeSB0aGF0IHRoZSByZWdpc3RyYW50IG9mIHRoaXMgZG9tYWluIGlzIGFuIGluZGl2aWR1YWwgcHJvZmVzc2lvbmFsIGFyY2hpdGVjdCAob3IgYW4gYXJjaGl0ZWN0dXJlIGZpcm0pIHJlZ2lzdGVyZWQgYXMgYSBtZW1iZXIgb2YgYSBuYXRpb25hbCBhcmNoaXRlY3RzIGFzc29jaWF0aW9uIGF1dGhvcml6ZWQgYnkgdGhlIHJlZ2lzdHJ5IG9wZXJhdG9yLCBvciBhbiBhcmNoaXRlY3R1cmUtcmVsYXRlZCBvcmdhbml6YXRpb24gYXV0aG9yaXplZCBieSB0aGUgcmVnaXN0cnkgb3BlcmF0b3IuJnF1b3Q7CiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MTp7czo3OiJJIGFncmVlIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjExMToiSSBjZXJ0aWZ5IHRoYXQgdGhlIHJlZ2lzdHJhbnQgb2YgdGhpcyBkb21haW4gaXMgYW4gaW5kaXZpZHVhbCBwcm9mZXNzaW9uYWwgYXJjaGl0ZWN0IChvciBhbiBhcmNoaXRlY3R1cmUgZmlybSkuIjtzOjU6InZhbHVlIjtzOjc6IkkgQWdyZWUiO319fX0='),
('ca', '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'),
('co.uk', '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'),
('org.uk', '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'),
('law.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4MiI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('med.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4MyI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('cpa.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NCI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ==');
REPLACE INTO `tld_extra_attributes` (`tld`, `extra_attributes`) VALUES
('me.uk', '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'),
('eu', 'YToxOntzOjE0OiJldV93aG9pc3BvbGljeSI7YTo0OntzOjI6IklEIjtzOjI6IjQ1IjtzOjExOiJkZXNjcmlwdGlvbiI7czoyOToiUmVnaXN0cnkgRGF0YSBUcmFuc2ZlciBQb2xpY3kiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjE6e3M6NzoiSSBBR1JFRSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czo0NTg6IkkgaGVyZWJ5IGFncmVlIHRoYXQgdGhlIFJlZ2lzdHJ5IGlzIGVudGl0bGVkIHRvIHRyYW5zZmVyIHRoZSBkYXRhIGNvbnRhaW5lZCBpbiB0aGlzIGFwcGxpY2F0aW9uIHRvIHRoaXJkIHBhcnRpZXMgKGkpIGlmIG9yZGVyZWQgdG8gZG8gc28gYnkgYSBwdWJsaWMgYXV0aG9yaXR5LCBjYXJyeWluZyBvdXQgaXRzIGxlZ2l0aW1hdGUgdGFza3M7IGFuZCAoaWkpIHVwb24gZGVtYW5kIG9mIGFuIEFEUiBQcm92aWRlciBhcyBtZW50aW9uZWQgaW4gc2VjdGlvbiAxNiBvZiB0aGUgVGVybXMgYW5kIENvbmRpdGlvbnMgd2hpY2ggYXJlIHB1Ymxpc2hlZCBhdCB3d3cuZXVyaWQuZXU7IGFuZCAoaWlpKSBhcyBwcm92aWRlZCBpbiBTZWN0aW9uIDIgKFdIT0lTIGxvb2stdXAgZmFjaWxpdHkpIG9mIHRoZSAuZXUgRG9tYWluIE5hbWUgV0hPSVMgUG9saWN5IHdoaWNoIGlzIHB1Ymxpc2hlZCBhdCB3d3cuZXVyaWQuZXUuIjtzOjU6InZhbHVlIjtzOjc6IkkgQUdSRUUiO319fX0='),
('it', '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'),
('pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTozOntzOjI6IklEIjtzOjM6IjE5MCI7czoxMToiZGVzY3JpcHRpb24iO3M6NjQ6IkluZGljYXRlZCBwcm9mZXNzaW9uYWwgYXNzb2NpYXRpb24gcmVjb2duaXplZCBieSBnb3Zlcm5tZW50IGJvZHkiO3M6Nzoib3B0aW9ucyI7YTowOnt9fX0='),
('aaa.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NSI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('aca.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NiI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('acct.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NyI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('eng.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4OCI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('avocat.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4OSI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('tel', 'YTo0OntzOjEzOiJ0ZWxfd2hvaXN0eXBlIjthOjM6e3M6MjoiSUQiO3M6MzoiMTQ0IjtzOjExOiJkZXNjcmlwdGlvbiI7czoyMzoiTmF0dXJhbCBvciBMZWdhbCBQZXJzb24iO3M6Nzoib3B0aW9ucyI7YToyOntzOjE0OiJOYXR1cmFsIFBlcnNvbiI7YTozOntzOjExOiJkZXNjcmlwdGlvbiI7czoxNDoiTmF0dXJhbCBQZXJzb24iO3M6NToidmFsdWUiO3M6MTQ6Im5hdHVyYWxfcGVyc29uIjtzOjg6InJlcXVpcmVzIjthOjE6e2k6MDtzOjM6IjE0NSI7fX1zOjEyOiJMZWdhbCBQZXJzb24iO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTI6IkxlZ2FsIFBlcnNvbiI7czo1OiJ2YWx1ZSI7czoxMjoibGVnYWxfcGVyc29uIjt9fX1zOjEyOiJ0ZWxfdXNlcm5hbWUiO2E6Mzp7czoyOiJJRCI7czozOiIxNDciO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjg6IlVzZXJuYW1lIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjEyOiJ0ZWxfcGFzc3dvcmQiO2E6Mzp7czoyOiJJRCI7czozOiIxNDgiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjg6IlBhc3N3b3JkIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE2OiJ0ZWxfZW1haWxhZGRyZXNzIjthOjM6e3M6MjoiSUQiO3M6MzoiMTUwIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxMzoiRW1haWwgQWRkcmVzcyI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('bar.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE5MCI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('jur.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE5MSI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('recht.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE5MiI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('es', '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'),
('com.es', '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'),
('nom.es', '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');
REPLACE INTO `tld_extra_attributes` (`tld`, `extra_attributes`) VALUES
('org.es', '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'),
('au', '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'),
('com.au', 'YToyOntzOjE1OiJhdV9yZWdpc3RyYW50aWQiO2E6NDp7czoyOiJJRCI7czozOiIyMDEiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjk6IklEIG51bWJlciI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE5OiJhdV9yZWdpc3RyYW50aWR0eXBlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjA0IjtzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJJRCB0eXBlIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTozOntzOjI2OiJBdXN0cmFsaWFuIEJ1c2luZXNzIE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNjoiQXVzdHJhbGlhbiBCdXNpbmVzcyBOdW1iZXIiO3M6NToidmFsdWUiO3M6MzoiQUJOIjt9czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7czo1OiJ2YWx1ZSI7czozOiJBQ04iO31zOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjtzOjU6InZhbHVlIjtzOjI6IlRNIjt9fX19'),
('org.au', 'YToyOntzOjE1OiJhdV9yZWdpc3RyYW50aWQiO2E6NDp7czoyOiJJRCI7czozOiIyMDMiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjk6IklEIG51bWJlciI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE5OiJhdV9yZWdpc3RyYW50aWR0eXBlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjA2IjtzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJJRCB0eXBlIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTozOntzOjI2OiJBdXN0cmFsaWFuIEJ1c2luZXNzIE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNjoiQXVzdHJhbGlhbiBCdXNpbmVzcyBOdW1iZXIiO3M6NToidmFsdWUiO3M6MzoiQUJOIjt9czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7czo1OiJ2YWx1ZSI7czozOiJBQ04iO31zOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjtzOjU6InZhbHVlIjtzOjI6IlRNIjt9fX19'),
('net.au', 'YToyOntzOjE1OiJhdV9yZWdpc3RyYW50aWQiO2E6NDp7czoyOiJJRCI7czozOiIyMDIiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjk6IklEIG51bWJlciI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE5OiJhdV9yZWdpc3RyYW50aWR0eXBlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjA1IjtzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJJRCB0eXBlIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTozOntzOjI2OiJBdXN0cmFsaWFuIEJ1c2luZXNzIE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNjoiQXVzdHJhbGlhbiBCdXNpbmVzcyBOdW1iZXIiO3M6NToidmFsdWUiO3M6MzoiQUJOIjt9czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7czo1OiJ2YWx1ZSI7czozOiJBQ04iO31zOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjtzOjU6InZhbHVlIjtzOjI6IlRNIjt9fX19'),
('sg', 'YTo0OntzOjEyOiJzZ19sZWdhbHR5cGUiO2E6NDp7czoyOiJJRCI7czozOiIzMTMiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjEwMDoiVHlwZSBvZiBSZWdpc3RyYW50IEVudGl0eSwgaWYgT3JnYW5pemF0aW9uIGlzIHNlbGVjdGVkLCBhIHJlZ2lzdHJhbnQgb3JnYW5pemF0aW9uIG11c3QgYmUgc3VwcGxpZWQgLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6Mjp7czozNToiRW50aXR5IGlzIGEgcmVnaXN0ZXJlZCBvcmdhbml6YXRpb24iO2E6Mzp7czoxMToiZGVzY3JpcHRpb24iO3M6MzU6IkVudGl0eSBpcyBhIHJlZ2lzdGVyZWQgb3JnYW5pemF0aW9uIjtzOjU6InZhbHVlIjtzOjEyOiJvcmdhbml6YXRpb24iO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjExIjt9fXM6MjM6IkVudGl0eSBpcyBhbiBpbmRpdmlkdWFsIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIzOiJFbnRpdHkgaXMgYW4gaW5kaXZpZHVhbCI7czo1OiJ2YWx1ZSI7czoxMDoiSW5kaXZpZHVhbCI7fX19czo4OiJzZ19yY2JpZCI7YTo0OntzOjI6IklEIjtzOjM6IjIxMSI7czoxMToiZGVzY3JpcHRpb24iO3M6MTIyOiJGb3IgaW5kaXZpZHVhbDogVGhlIGNvcnJlc3BvbmRpbmcgSUQtQ2FyZC9QYXNzcG9ydApGb3Igb3JnYW5pemF0aW9uOiBUaGUgY29ycmVzcG9uZGluZyBjb21wYW55IHJlZ2lzdHJhdGlvbiBvciBWQVQtbnVtYmVyICI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjk6InNnX2xvY2FsZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxNCI7czoxMToiZGVzY3JpcHRpb24iO3M6Mjk6IkxvY2F0aW9uIG9mIFJlZ2lzdHJhbnQgRW50aXR5IjtzOjg6InJlcXVpcmVkIjtzOjE6IjIiO3M6Nzoib3B0aW9ucyI7YToyOntzOjM4OiJSZWdpc3RyYW50IGlzIGxvY2F0ZWQgd2l0aGluIFNpbmdhcG9yZSI7YTozOntzOjExOiJkZXNjcmlwdGlvbiI7czozODoiUmVnaXN0cmFudCBpcyBsb2NhdGVkIHdpdGhpbiBTaW5nYXBvcmUiO3M6NToidmFsdWUiO3M6MjoiU0ciO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjMxIjt9fXM6Mzk6IlJlZ2lzdHJhbnQgaXMgbG9jYXRlZCBPVVRTSURFIFNpbmdhcG9yZSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czozOToiUmVnaXN0cmFudCBpcyBsb2NhdGVkIE9VVFNJREUgU2luZ2Fwb3JlIjtzOjU6InZhbHVlIjtzOjU6Ik5PTlNHIjt9fX1zOjEwOiJzZ19hZG1pbmlkIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjMxIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxMzI6IlRoZSBjb3JyZXNwb25kaW5nIElEIENhcmQgb3IgUGFzc3BvcnQgb2YgdGhlIEFkbWluaXN0cmF0aXZlIGNvbnRhY3QuIFJlcXVpcmVkIGlmIHRoZSBSZWdpc3RyYW50IG9yIFRlY2huaWNhbCBDb250YWN0IGlzIGluIFNpbmdhcG9yZSI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('com.sg', 'YTo0OntzOjEyOiJzZ19sZWdhbHR5cGUiO2E6NDp7czoyOiJJRCI7czozOiIzMTEiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjEwMDoiVHlwZSBvZiBSZWdpc3RyYW50IEVudGl0eSwgaWYgT3JnYW5pemF0aW9uIGlzIHNlbGVjdGVkLCBhIHJlZ2lzdHJhbnQgb3JnYW5pemF0aW9uIG11c3QgYmUgc3VwcGxpZWQgLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6Mjp7czozNToiRW50aXR5IGlzIGEgcmVnaXN0ZXJlZCBvcmdhbml6YXRpb24iO2E6Mzp7czoxMToiZGVzY3JpcHRpb24iO3M6MzU6IkVudGl0eSBpcyBhIHJlZ2lzdGVyZWQgb3JnYW5pemF0aW9uIjtzOjU6InZhbHVlIjtzOjEyOiJvcmdhbml6YXRpb24iO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjExIjt9fXM6MjM6IkVudGl0eSBpcyBhbiBpbmRpdmlkdWFsIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIzOiJFbnRpdHkgaXMgYW4gaW5kaXZpZHVhbCI7czo1OiJ2YWx1ZSI7czoxMDoiSW5kaXZpZHVhbCI7fX19czo4OiJzZ19yY2JpZCI7YTo0OntzOjI6IklEIjtzOjM6IjIxMiI7czoxMToiZGVzY3JpcHRpb24iO3M6MTIyOiJGb3IgaW5kaXZpZHVhbDogVGhlIGNvcnJlc3BvbmRpbmcgSUQtQ2FyZC9QYXNzcG9ydApGb3Igb3JnYW5pemF0aW9uOiBUaGUgY29ycmVzcG9uZGluZyBjb21wYW55IHJlZ2lzdHJhdGlvbiBvciBWQVQtbnVtYmVyICI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjk6InNnX2xvY2FsZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxMiI7czoxMToiZGVzY3JpcHRpb24iO3M6Mjk6IkxvY2F0aW9uIG9mIFJlZ2lzdHJhbnQgRW50aXR5IjtzOjg6InJlcXVpcmVkIjtzOjE6IjIiO3M6Nzoib3B0aW9ucyI7YToyOntzOjM4OiJSZWdpc3RyYW50IGlzIGxvY2F0ZWQgd2l0aGluIFNpbmdhcG9yZSI7YTozOntzOjExOiJkZXNjcmlwdGlvbiI7czozODoiUmVnaXN0cmFudCBpcyBsb2NhdGVkIHdpdGhpbiBTaW5nYXBvcmUiO3M6NToidmFsdWUiO3M6MjoiU0ciO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjMxIjt9fXM6Mzk6IlJlZ2lzdHJhbnQgaXMgbG9jYXRlZCBPVVRTSURFIFNpbmdhcG9yZSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czozOToiUmVnaXN0cmFudCBpcyBsb2NhdGVkIE9VVFNJREUgU2luZ2Fwb3JlIjtzOjU6InZhbHVlIjtzOjU6Ik5PTlNHIjt9fX1zOjEwOiJzZ19hZG1pbmlkIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjMwIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxMzI6IlRoZSBjb3JyZXNwb25kaW5nIElEIENhcmQgb3IgUGFzc3BvcnQgb2YgdGhlIEFkbWluaXN0cmF0aXZlIGNvbnRhY3QuIFJlcXVpcmVkIGlmIHRoZSBSZWdpc3RyYW50IG9yIFRlY2huaWNhbCBDb250YWN0IGlzIGluIFNpbmdhcG9yZSI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('fr', 'YToxOntzOjEyOiJmcl9sZWdhbHR5cGUiO2E6NDp7czoyOiJJRCI7czozOiIyMTMiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjc2OiJEZXBlbmRpbmcgb24gdGhlIHR5cGUgb2YgcmVnaXN0cmFudCwgZGlmZmVyZW50IGV4dGVuc2lvbnMgbXVzdCBiZSBwcm92aWRlZC4gIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToyOntzOjc6IkNvbXBhbnkiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6NzM6IkNvbXBhbmllcyBoYXZpbmcgdGhlaXIgaGVhZCBvZmZpY2UgaW4gdGhlIHRlcnJpdG9yeSBvZiB0aGUgRXVyb3BlYW4gVW5pb24iO3M6NToidmFsdWUiO3M6NzoiQ29tcGFueSI7fXM6MTA6IkluZGl2aWR1YWwiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6NDU6IkluZGl2aWR1YWwgcGVyc29uIHJlc3BvbnNpYmxlIGZvciB0aGUgZG9tYWluLiI7czo1OiJ2YWx1ZSI7czoxMDoiSW5kaXZpZHVhbCI7fX19fQ=='),
('lannie', 'YToxOntzOjE3OiJsYW5uaWVfbGVnYWxfdHlwZSI7YTozOntzOjI6IklEIjtzOjM6IjMwMiI7czoxMToiZGVzY3JpcHRpb24iO3M6Mzc6IkJvZ3VzIGxlZ2FsIHR5cGUgdG8gc2VlIGlmIHRoaXMgd29ya3MiO3M6Nzoib3B0aW9ucyI7YToxOntzOjEyOiJDb3Jwb3JhdGlvbiAiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6NTcyOiJBIGNvcnBvcmF0aW9uIHVuZGVyIHRoZSBsYXdzIG9mIENhbmFkYSBvciBhbnkgcHJvdmluY2Ugb3IgdGVycml0b3J5IG9mIENhbmFkYSwgQ2hhcml0aWVzLCBDb29wZXJhdGl2ZSwgQ291bmNpbC4KUmVxdWlyZW1lbnRzOiBSZWdpc3RyYW50IG5hbWUgbXVzdCBiZSB0aGUgZnVsbCBsZWdhbCBuYW1lIG9mIHRoZSBjb3Jwb3JhdGlvbiBhbmQgbXVzdCBiZSBmb2xsb3dlZCBieSB0aGUganVyaXNkaWN0aW9uIG9mIGluY29ycG9yYXRpb24gKGVnLiBDYW5hZGEsIE9udGFyaW8sIE5XVC4uLiksIHVubGVzcyBpdCBpcyBvYnZpb3VzIGZyb20gdGhlIGNvcnBvcmF0aW9uJiMzOTtzIG5hbWUuIENhbmFkaWFuIEludGVybmV0IFJlZ2lzdHJhdGlvbiBBdXRob3JpdHkgKENhbmFkYSkuIEZvciBDaGFyaXRpZXMsIHRoZSBORlAgc2hvdWxkIGJlIGluY2x1ZGVkIGluIHRoZSBvcmdhbml6YXRpb24gbmFtZS4gSWYgdGhpcyBpcyBhIG5vdC1mb3ItcHJvZml0IG9yZ2FuaXphdGlvbiwgeW91IGFyZSBhbHNvIHJlcXVpcmVkIHRvIHN1Ym1pdCB0aGUgcmVnaXN0cmF0aW9uIG51bWJlciBpLmUuOiAxMjM0NTY3ODkgUlIwMDAxICI7czo1OiJ2YWx1ZSI7czozOiJDQ08iO319fX0='),
('ong', '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'),
('law', 'YTo0OntzOjIwOiJsYXctYWNjcmVkaXRhdGlvbi1pZCI7YTo0OntzOjI6IklEIjtzOjM6IjI4MSI7czoxMToiZGVzY3JpcHRpb24iO3M6MjI2OiJUaGUgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIElEIGlzIGEgY2hhcmFjdGVyIHN0cmluZyBpc3N1ZWQgYnkgdGhlIGFjY3JlZGl0YXRpb24gYm9keSB0byB0aGUgcXVhbGlmaWVkIGxhd3llci4gQWNjcmVkaXRhdGlvbiBJRHMgdW5pcXVlbHkgaWRlbnRpZnkgdGhlIHF1YWxpZmllZCBsYXd5ZXIgd2l0aGluIHRoZSBjb250ZXh0IG9mIHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTowOnt9fXM6MjI6Imxhdy1hY2NyZWRpdGF0aW9uLWJvZHkiO2E6NDp7czoyOiJJRCI7czozOiIyODIiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE5NjoiVGhlIGFjY3JlZGl0YXRpb24gYm9keSBpcyB0aGUgZW50aXR5IHRoYXQgaXNzdWVkIHRoZSBhY2NyZWRpdGF0aW9uIElEIHRvIHRoZSBxdWFsaWZpZWQgbGF3eWVyLiBXaXRoaW4gdGhlIFF1YWxpZmllZCBMYXd5ZXIgZXh0ZW5zaW9uLCBhIGNoYXJhY3RlciBzdHJpbmcgaXMgdXNlZCB0byByZXByZXNlbnQgYW4gYWNjcmVkaXRhdGlvbiBib2R5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjIyOiJsYXctYWNjcmVkaXRhdGlvbi15ZWFyIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjgzIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxNTM6IkEgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIHllYXIgaXMgdGhlIHllYXIgaGUvc2hlIHdhcyBpbml0aWFsbHkgY2VydGlmaWVkIGJ5IHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIEl0IGlzIHJlcHJlc2VudGVkIGJ5IGEgZm91ci1kaWdpdCB5ZWFyLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjI0OiJsYXctanVyaXNkaWN0aW9uLWNvdW50cnkiO2E6NDp7czoyOiJJRCI7czozOiIyODQiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIwODoiVGhlIGFjY3JlZGl0YXRpb24ganVyaXNkaWN0aW9uIGNvdW50cnkgaXMgdGhlIGNvdW50cnkgaW4gd2hpY2ggdGhlIGFjY3JlZGl0YXRpb24gYm9keSBjZXJ0aWZpZXMgdGhlIHF1YWxpZmllZCBsYXd5ZXIuIElTTyB0d28tbGV0dGVyIGNvdW50cnkgY29kZXMgYXJlIHVzZWQgdG8gcmVwcmVzZW50IHRoZSBhY2NyZWRpdGF0aW9uIGp1cmlzZGljdGlvbiBjb3VudHJ5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('ngo', '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'),
('eus', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjk0IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('gal', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjkzIjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('dev', 'YToxOntzOjk6ImRldl9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxNSI7czoxMToiZGVzY3JpcHRpb24iO3M6NTI5OiIuREVWIEVsaWdpYmlsaXR5IFJlcXVpcmVtZW50czogCgouRGV2IGlzIGEgbW9yZSBzZWN1cmUgZG9tYWluLCBtZWFuaW5nIHRoYXQgSFRUUFMgaXMgcmVxdWlyZWQgZm9yIGFsbCAuZGV2IHdlYnNpdGVzLiBZb3UgY2FuIGJ1eSB5b3VyIC5EZXYgZG9tYWluIG5hbWUgbm93LCBidXQgaW4gb3JkZXIgZm9yIGl0IHRvIHdvcmsgcHJvcGVybHkgaW4gYnJvd3NlcnMgeW91IG11c3QgZmlyc3QgY29uZmlndXJlIEhUVFBTIHNlcnZpbmcuIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IGNvbmZpZ3VyaW5nIEhUVFBTLCBwbGVhc2UgY2xpY2sgaGVyZS4gVG8gb2J0YWluIG1vcmUgaW5mb3JtYXRpb24gb24gU1NMIGNlcnRpZmljYXRlcywgcGxlYXNlIHZpc2l0IHlvdXIgaG9zdGluZyBzZXJ2aWNlIHByb3ZpZGVyIG9yIGdldCBhIGZyZWUgU1NMIGNlcnRpZmljYXRlIGZyb20gTGV0JiMzOTtzIEVuY3J5cHQuCgogSSwgdGhlIFJlZ2lzdHJhbnQsIHVuZGVyc3RhbmQgYW5kIGFncmVlIHRvIHRoZSAuZGV2IFJlZ2lzdHJhdGlvbiBQb2xpY3kuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToxOntzOjc6IkkgQWdyZWUiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTA1OiJCeSBzZWxlY3RpbmcgJnF1b3Q7SSBBZ3JlZSZxdW90OyB5b3UgY29uZmlybSB0aGF0IHlvdSBoYXZlIHJlYWQsIGFuZCBhZ3JlZSB0byB0aGUgLmRldiBSZWdpc3RyYW50IFBvbGljeS4iO3M6NToidmFsdWUiO3M6NzoiSSBBZ3JlZSI7fX19fQ=='),
('barcelona', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjk1IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('abogado', 'YTo0OntzOjIwOiJsYXctYWNjcmVkaXRhdGlvbi1pZCI7YTo0OntzOjI6IklEIjtzOjM6IjI4NiI7czoxMToiZGVzY3JpcHRpb24iO3M6MjI2OiJUaGUgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIElEIGlzIGEgY2hhcmFjdGVyIHN0cmluZyBpc3N1ZWQgYnkgdGhlIGFjY3JlZGl0YXRpb24gYm9keSB0byB0aGUgcXVhbGlmaWVkIGxhd3llci4gQWNjcmVkaXRhdGlvbiBJRHMgdW5pcXVlbHkgaWRlbnRpZnkgdGhlIHF1YWxpZmllZCBsYXd5ZXIgd2l0aGluIHRoZSBjb250ZXh0IG9mIHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTowOnt9fXM6MjI6Imxhdy1hY2NyZWRpdGF0aW9uLWJvZHkiO2E6NDp7czoyOiJJRCI7czozOiIyODciO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE5NjoiVGhlIGFjY3JlZGl0YXRpb24gYm9keSBpcyB0aGUgZW50aXR5IHRoYXQgaXNzdWVkIHRoZSBhY2NyZWRpdGF0aW9uIElEIHRvIHRoZSBxdWFsaWZpZWQgbGF3eWVyLiBXaXRoaW4gdGhlIFF1YWxpZmllZCBMYXd5ZXIgZXh0ZW5zaW9uLCBhIGNoYXJhY3RlciBzdHJpbmcgaXMgdXNlZCB0byByZXByZXNlbnQgYW4gYWNjcmVkaXRhdGlvbiBib2R5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjIyOiJsYXctYWNjcmVkaXRhdGlvbi15ZWFyIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjg4IjtzOjExOiJkZXNjcmlwdGlvbiI7czoxNTM6IkEgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIHllYXIgaXMgdGhlIHllYXIgaGUvc2hlIHdhcyBpbml0aWFsbHkgY2VydGlmaWVkIGJ5IHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIEl0IGlzIHJlcHJlc2VudGVkIGJ5IGEgZm91ci1kaWdpdCB5ZWFyLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjI0OiJsYXctanVyaXNkaWN0aW9uLWNvdW50cnkiO2E6NDp7czoyOiJJRCI7czozOiIyODkiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIwODoiVGhlIGFjY3JlZGl0YXRpb24ganVyaXNkaWN0aW9uIGNvdW50cnkgaXMgdGhlIGNvdW50cnkgaW4gd2hpY2ggdGhlIGFjY3JlZGl0YXRpb24gYm9keSBjZXJ0aWZpZXMgdGhlIHF1YWxpZmllZCBsYXd5ZXIuIElTTyB0d28tbGV0dGVyIGNvdW50cnkgY29kZXMgYXJlIHVzZWQgdG8gcmVwcmVzZW50IHRoZSBhY2NyZWRpdGF0aW9uIGp1cmlzZGljdGlvbiBjb3VudHJ5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('app', 'YToxOntzOjk6ImFwcF9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxNyI7czoxMToiZGVzY3JpcHRpb24iO3M6NTI5OiIuQVBQIEVsaWdpYmlsaXR5IFJlcXVpcmVtZW50czogLkFQUCBpcyBhIG1vcmUgc2VjdXJlIGRvbWFpbiwgbWVhbmluZyB0aGF0IEhUVFBTIGlzIHJlcXVpcmVkIGZvciBhbGwgLkFQUCB3ZWJzaXRlcy4gWW91IGNhbiBidXkgeW91ciAuQVBQIGRvbWFpbiBuYW1lIG5vdywgYnV0IGluIG9yZGVyIGZvciBpdCB0byB3b3JrIHByb3Blcmx5IGluIGJyb3dzZXJzIHlvdSBtdXN0IGZpcnN0IGNvbmZpZ3VyZSBIVFRQUyBzZXJ2aW5nLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBjb25maWd1cmluZyBIVFRQUywgcGxlYXNlIGNsaWNrIGhlcmUuIFRvIG9idGFpbiBtb3JlIGluZm9ybWF0aW9uIG9uIFNTTCBjZXJ0aWZpY2F0ZXMsIHBsZWFzZSB2aXNpdCB5b3VyIGhvc3Rpbmcgc2VydmljZSBwcm92aWRlciBvciBnZXQgYSBmcmVlIFNTTCBjZXJ0aWZpY2F0ZSBmcm9tIExldCZhbXA7IzM5O3MgRW5jcnlwdC4gSSwgdGhlIFJlZ2lzdHJhbnQsIHVuZGVyc3RhbmQgYW5kIGFncmVlIHRvIHRoZSAuQVBQIFJlZ2lzdHJhdGlvbiBQb2xpY3kuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToxOntpOjA7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoxMDU6IkJ5IHNlbGVjdGluZyAmcXVvdDtJIEFncmVlJnF1b3Q7IHlvdSBjb25maXJtIHRoYXQgeW91IGhhdmUgcmVhZCwgYW5kIGFncmVlIHRvIHRoZSAuYXBwIFJlZ2lzdHJhbnQgUG9saWN5LiI7czo1OiJ2YWx1ZSI7czo3OiJJIEFncmVlIjt9fX19'),
('day', 'YToxOntzOjk6ImRheV9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxOCI7czoxMToiZGVzY3JpcHRpb24iO3M6NTI5OiIuREFZIEVsaWdpYmlsaXR5IFJlcXVpcmVtZW50czogLkRBWSBpcyBhIG1vcmUgc2VjdXJlIGRvbWFpbiwgbWVhbmluZyB0aGF0IEhUVFBTIGlzIHJlcXVpcmVkIGZvciBhbGwgLkRBWSB3ZWJzaXRlcy4gWW91IGNhbiBidXkgeW91ciAuREFZIGRvbWFpbiBuYW1lIG5vdywgYnV0IGluIG9yZGVyIGZvciBpdCB0byB3b3JrIHByb3Blcmx5IGluIGJyb3dzZXJzIHlvdSBtdXN0IGZpcnN0IGNvbmZpZ3VyZSBIVFRQUyBzZXJ2aW5nLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBjb25maWd1cmluZyBIVFRQUywgcGxlYXNlIGNsaWNrIGhlcmUuIFRvIG9idGFpbiBtb3JlIGluZm9ybWF0aW9uIG9uIFNTTCBjZXJ0aWZpY2F0ZXMsIHBsZWFzZSB2aXNpdCB5b3VyIGhvc3Rpbmcgc2VydmljZSBwcm92aWRlciBvciBnZXQgYSBmcmVlIFNTTCBjZXJ0aWZpY2F0ZSBmcm9tIExldCZhbXA7IzM5O3MgRW5jcnlwdC4gSSwgdGhlIFJlZ2lzdHJhbnQsIHVuZGVyc3RhbmQgYW5kIGFncmVlIHRvIHRoZSAuREFZIFJlZ2lzdHJhdGlvbiBQb2xpY3kuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToxOntzOjc6IkkgQUdSRUUiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTA1OiJCeSBzZWxlY3RpbmcgJnF1b3Q7SSBBZ3JlZSZxdW90OyB5b3UgY29uZmlybSB0aGF0IHlvdSBoYXZlIHJlYWQsIGFuZCBhZ3JlZSB0byB0aGUgLmRheSBSZWdpc3RyYW50IFBvbGljeS4iO3M6NToidmFsdWUiO3M6NzoiSSBBZ3JlZSI7fX19fQ==');