<?php
/**
 * EmailAuthValidation
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * EmailAuthValidation Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class EmailAuthValidation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'EmailAuthValidation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dkim_is_valid' => 'bool',
        'spf_is_valid' => 'bool',
        'found_txt_records_dkim' => 'string[]',
        'found_txt_records_spf' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dkim_is_valid' => null,
        'spf_is_valid' => null,
        'found_txt_records_dkim' => null,
        'found_txt_records_spf' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'dkim_is_valid' => false,
        'spf_is_valid' => false,
        'found_txt_records_dkim' => false,
        'found_txt_records_spf' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dkim_is_valid' => 'dkimIsValid',
        'spf_is_valid' => 'spfIsValid',
        'found_txt_records_dkim' => 'foundTxtRecordsDkim',
        'found_txt_records_spf' => 'foundTxtRecordsSpf'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'dkim_is_valid' => 'setDkimIsValid',
        'spf_is_valid' => 'setSpfIsValid',
        'found_txt_records_dkim' => 'setFoundTxtRecordsDkim',
        'found_txt_records_spf' => 'setFoundTxtRecordsSpf'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dkim_is_valid' => 'getDkimIsValid',
        'spf_is_valid' => 'getSpfIsValid',
        'found_txt_records_dkim' => 'getFoundTxtRecordsDkim',
        'found_txt_records_spf' => 'getFoundTxtRecordsSpf'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('dkim_is_valid', $data ?? [], null);
        $this->setIfExists('spf_is_valid', $data ?? [], null);
        $this->setIfExists('found_txt_records_dkim', $data ?? [], null);
        $this->setIfExists('found_txt_records_spf', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['dkim_is_valid'] === null) {
            $invalidProperties[] = "'dkim_is_valid' can't be null";
        }
        if ($this->container['spf_is_valid'] === null) {
            $invalidProperties[] = "'spf_is_valid' can't be null";
        }
        if ($this->container['found_txt_records_dkim'] === null) {
            $invalidProperties[] = "'found_txt_records_dkim' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dkim_is_valid
     *
     * @return bool
     */
    public function getDkimIsValid()
    {
        return $this->container['dkim_is_valid'];
    }

    /**
     * Sets dkim_is_valid
     *
     * @param bool $dkim_is_valid dkim_is_valid
     *
     * @return self
     */
    public function setDkimIsValid($dkim_is_valid)
    {
        if (is_null($dkim_is_valid)) {
            throw new \InvalidArgumentException('non-nullable dkim_is_valid cannot be null');
        }
        $this->container['dkim_is_valid'] = $dkim_is_valid;

        return $this;
    }

    /**
     * Gets spf_is_valid
     *
     * @return bool
     */
    public function getSpfIsValid()
    {
        return $this->container['spf_is_valid'];
    }

    /**
     * Sets spf_is_valid
     *
     * @param bool $spf_is_valid spf_is_valid
     *
     * @return self
     */
    public function setSpfIsValid($spf_is_valid)
    {
        if (is_null($spf_is_valid)) {
            throw new \InvalidArgumentException('non-nullable spf_is_valid cannot be null');
        }
        $this->container['spf_is_valid'] = $spf_is_valid;

        return $this;
    }

    /**
     * Gets found_txt_records_dkim
     *
     * @return string[]
     */
    public function getFoundTxtRecordsDkim()
    {
        return $this->container['found_txt_records_dkim'];
    }

    /**
     * Sets found_txt_records_dkim
     *
     * @param string[] $found_txt_records_dkim found_txt_records_dkim
     *
     * @return self
     */
    public function setFoundTxtRecordsDkim($found_txt_records_dkim)
    {
        if (is_null($found_txt_records_dkim)) {
            throw new \InvalidArgumentException('non-nullable found_txt_records_dkim cannot be null');
        }
        $this->container['found_txt_records_dkim'] = $found_txt_records_dkim;

        return $this;
    }

    /**
     * Gets found_txt_records_spf
     *
     * @return string[]|null
     */
    public function getFoundTxtRecordsSpf()
    {
        return $this->container['found_txt_records_spf'];
    }

    /**
     * Sets found_txt_records_spf
     *
     * @param string[]|null $found_txt_records_spf found_txt_records_spf
     *
     * @return self
     */
    public function setFoundTxtRecordsSpf($found_txt_records_spf)
    {
        if (is_null($found_txt_records_spf)) {
            throw new \InvalidArgumentException('non-nullable found_txt_records_spf cannot be null');
        }
        $this->container['found_txt_records_spf'] = $found_txt_records_spf;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


