# Updating countries
UPDATE `country` SET `iso` = 'TL' WHERE `iso` = 'TS';
UPDATE `country` SET `exists` = 0 WHERE `iso` = 'AN';
UPDATE `user_customuserfields` SET `value` = 'TL' WHERE `value` = 'TS' AND `customid` IN (SELECT `id` FROM `customuserfields` WHERE `type` = 6);
UPDATE `object_customField` SET `value` = 'TL' WHERE `value` = 'TS' AND `customFieldId` IN (SELECT `id` FROM `customField` WHERE `fieldType` = 6);

INSERT INTO `country` (`name`, `iso`, `phone_code`) VALUES
('Aland Islands', 'AX', '+358-18'),
('Anguilla', 'AI', '+1-264'),
('Antarctica', 'AQ', '672'),
('Bouvet Island', 'BV', '0055'),
('British Indian Ocean Territory', 'IO', '246'),
('Christmas Island', 'CX', '61'),
('Falkland Islands', 'FK', '500'),
('French Guiana', 'GF', '594'),
('French Southern Territories', 'TF', '262'),
('Gibraltar', 'GI', '350'),
('Guadeloupe', 'GP', '590'),
('Guernsey and Alderney', 'GG', '+44-1481'),
('Heard Island and McDonald Islands', 'HM', '672'),
('Jersey', 'JE', '+44-1534'),
('Man (Isle of)', 'IM', '+44-1624'),
('Martinique', 'MQ', '596'),
('Montserrat', 'MS', '+1-664'),
('Bonaire, Sint Eustatius and Saba', 'BQ', '599'),
('Norfolk Island', 'NF', '672'),
('Palestinian Territory Occupied', 'PS', '970'),
('Pitcairn Island', 'PN', '870'),
('Reunion', 'RE', '262'),
('Saint Helena', 'SH', '290'),
('Saint Pierre and Miquelon', 'PM', '508'),
('Saint-Barthelemy', 'BL', '590'),
('Saint-Martin (French part)', 'MF', '590'),
('South Georgia', 'GS', '500'),
('Svalbard And Jan Mayen Islands', 'SJ', '47'),
('United States Minor Outlying Islands', 'UM', '1'),
('Vatican City State (Holy See)', 'VA', '379'),
('Virgin Islands (British)', 'VG', '+1-284'),
('Virgin Islands (US)', 'VI', '+1-340'),
('Wallis And Futuna Islands', 'WF', '681'),
('Kosovo', 'XK', '383'),
('Curaçao', 'CW', '599'),
('Sint Maarten (Dutch part)', 'SX', '1721');



#
# Table structure for table `state`
#

DROP TABLE IF EXISTS `state`;
CREATE TABLE IF NOT EXISTS `state` (
  `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `exists` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_region_final` (`country_code`,`iso2`)
) ENGINE=InnoDB AUTO_INCREMENT=5117 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

INSERT INTO `state` (`id`, `name`, `country_code`, `iso2`, `exists`) VALUES
(1, 'Southern Nations, Nationalities, and Peoples\' Region', 'ET', 'SN', 1),
(2, 'Somali Region', 'ET', 'SO', 1),
(3, 'Amhara Region', 'ET', 'AM', 1),
(4, 'Tigray Region', 'ET', 'TI', 1),
(5, 'Oromia Region', 'ET', 'OR', 1),
(6, 'Afar Region', 'ET', 'AF', 1),
(7, 'Harari Region', 'ET', 'HA', 1),
(8, 'Dire Dawa', 'ET', 'DD', 1),
(9, 'Benishangul-Gumuz Region', 'ET', 'BE', 1),
(10, 'Gambela Region', 'ET', 'GA', 1),
(11, 'Addis Ababa', 'ET', 'AA', 1),
(12, 'Petnjica Municipality', 'ME', '23', 1),
(13, 'Bar Municipality', 'ME', '02', 1),
(14, 'Danilovgrad Municipality', 'ME', '07', 1),
(15, 'Rožaje Municipality', 'ME', '17', 1),
(16, 'Plužine Municipality', 'ME', '15', 1),
(17, 'Nikšić Municipality', 'ME', '12', 1),
(18, 'Šavnik Municipality', 'ME', '18', 1),
(19, 'Plav Municipality', 'ME', '13', 1),
(20, 'Pljevlja Municipality', 'ME', '14', 1),
(21, 'Berane Municipality', 'ME', '03', 1),
(22, 'Mojkovac Municipality', 'ME', '11', 1),
(23, 'Andrijevica Municipality', 'ME', '01', 1),
(24, 'Gusinje Municipality', 'ME', '22', 1),
(25, 'Bijelo Polje Municipality', 'ME', '04', 1),
(26, 'Kotor Municipality', 'ME', '10', 1),
(27, 'Podgorica Municipality', 'ME', '16', 1),
(28, 'Old Royal Capital Cetinje', 'ME', '06', 1),
(29, 'Tivat Municipality', 'ME', '19', 1),
(30, 'Budva Municipality', 'ME', '05', 1),
(31, 'Kolašin Municipality', 'ME', '09', 1),
(32, 'Žabljak Municipality', 'ME', '21', 1),
(33, 'Ulcinj Municipality', 'ME', '20', 1),
(34, 'Kunene Region', 'NA', 'KU', 1),
(35, 'Kavango West Region', 'NA', 'KW', 1),
(36, 'Kavango East Region', 'NA', 'KE', 1),
(37, 'Oshana Region', 'NA', 'ON', 1),
(38, 'Hardap Region', 'NA', 'HA', 1),
(39, 'Omusati Region', 'NA', 'OS', 1),
(40, 'Ohangwena Region', 'NA', 'OW', 1),
(41, 'Omaheke Region', 'NA', 'OH', 1),
(42, 'Oshikoto Region', 'NA', 'OT', 1),
(43, 'Erongo Region', 'NA', 'ER', 1),
(44, 'Khomas Region', 'NA', 'KH', 1),
(45, 'Karas Region', 'NA', 'KA', 1),
(46, 'Otjozondjupa Region', 'NA', 'OD', 1),
(47, 'Zambezi Region', 'NA', 'CA', 1),
(48, 'Ashanti', 'GH', 'AH', 1),
(49, 'Western', 'GH', 'WP', 1),
(50, 'Eastern', 'GH', 'EP', 1),
(51, 'Northern', 'GH', 'NP', 1),
(52, 'Central', 'GH', 'CP', 1),
(53, 'Ahafo', 'GH', 'AF', 1),
(54, 'Greater Accra', 'GH', 'AA', 1),
(55, 'Upper East', 'GH', 'UE', 1),
(56, 'Volta', 'GH', 'TV', 1),
(57, 'Upper West', 'GH', 'UW', 1),
(58, 'San Marino', 'SM', '07', 1),
(59, 'Acquaviva', 'SM', '01', 1),
(60, 'Chiesanuova', 'SM', '02', 1),
(61, 'Borgo Maggiore', 'SM', '06', 1),
(62, 'Faetano', 'SM', '04', 1),
(63, 'Montegiardino', 'SM', '08', 1),
(64, 'Domagnano', 'SM', '03', 1),
(65, 'Serravalle', 'SM', '09', 1),
(66, 'Fiorentino', 'SM', '05', 1),
(67, 'Tillabéri Region', 'NE', '6', 1),
(68, 'Dosso Region', 'NE', '3', 1),
(69, 'Zinder Region', 'NE', '7', 1),
(70, 'Maradi Region', 'NE', '4', 1),
(71, 'Agadez Region', 'NE', '1', 1),
(72, 'Diffa Region', 'NE', '2', 1),
(73, 'Tahoua Region', 'NE', '5', 1),
(74, 'Mqabba', 'MT', '33', 1),
(75, 'San Ġwann', 'MT', '49', 1),
(76, 'Żurrieq', 'MT', '68', 1),
(77, 'Luqa', 'MT', '25', 1),
(78, 'Marsaxlokk', 'MT', '28', 1),
(79, 'Qala', 'MT', '42', 1),
(80, 'Żebbuġ Malta', 'MT', '66', 1),
(81, 'Xgħajra', 'MT', '63', 1),
(82, 'Kirkop', 'MT', '23', 1),
(83, 'Rabat', 'MT', '46', 1),
(84, 'Floriana', 'MT', '09', 1),
(85, 'Żebbuġ Gozo', 'MT', '65', 1),
(86, 'Swieqi', 'MT', '57', 1),
(87, 'Saint Lawrence', 'MT', '50', 1),
(88, 'Birżebbuġa', 'MT', '05', 1),
(89, 'Mdina', 'MT', '29', 1),
(90, 'Santa Venera', 'MT', '54', 1),
(91, 'Kerċem', 'MT', '22', 1),
(92, 'Għarb', 'MT', '14', 1),
(93, 'Iklin', 'MT', '19', 1),
(94, 'Santa Luċija', 'MT', '53', 1),
(95, 'Valletta', 'MT', '60', 1),
(96, 'Msida', 'MT', '34', 1),
(97, 'Birkirkara', 'MT', '04', 1),
(98, 'Siġġiewi', 'MT', '55', 1),
(99, 'Kalkara', 'MT', '21', 1),
(100, 'St. Julian\'s', 'MT', '48', 1),
(101, 'Victoria', 'MT', '45', 1),
(102, 'Mellieħa', 'MT', '30', 1),
(103, 'Tarxien', 'MT', '59', 1),
(104, 'Sliema', 'MT', '56', 1),
(105, 'Ħamrun', 'MT', '18', 1),
(106, 'Għasri', 'MT', '16', 1),
(107, 'Birgu', 'MT', '03', 1),
(108, 'Balzan', 'MT', '02', 1),
(109, 'Mġarr', 'MT', '31', 1),
(110, 'Attard', 'MT', '01', 1),
(111, 'Qrendi', 'MT', '44', 1),
(112, 'Naxxar', 'MT', '38', 1),
(113, 'Gżira', 'MT', '12', 1),
(114, 'Xagħra', 'MT', '61', 1),
(115, 'Paola', 'MT', '39', 1),
(116, 'Sannat', 'MT', '52', 1),
(117, 'Dingli', 'MT', '07', 1),
(118, 'Gudja', 'MT', '11', 1),
(119, 'Qormi', 'MT', '43', 1),
(120, 'Għargħur', 'MT', '15', 1),
(121, 'Xewkija', 'MT', '62', 1),
(122, 'Ta\' Xbiex', 'MT', '58', 1),
(123, 'Żabbar', 'MT', '64', 1),
(124, 'Għaxaq', 'MT', '17', 1),
(125, 'Pembroke', 'MT', '40', 1),
(126, 'Lija', 'MT', '24', 1),
(127, 'Pietà', 'MT', '41', 1),
(128, 'Marsa', 'MT', '26', 1),
(129, 'Fgura', 'MT', '08', 1),
(130, 'Għajnsielem', 'MT', '13', 1),
(131, 'Mtarfa', 'MT', '35', 1),
(132, 'Munxar', 'MT', '36', 1),
(133, 'Nadur', 'MT', '37', 1),
(134, 'Fontana', 'MT', '10', 1),
(135, 'Żejtun', 'MT', '67', 1),
(136, 'Senglea', 'MT', '20', 1),
(137, 'Marsaskala', 'MT', '27', 1),
(138, 'Cospicua', 'MT', '06', 1),
(139, 'St. Paul\'s Bay', 'MT', '51', 1),
(140, 'Mosta', 'MT', '32', 1),
(141, 'Mangystau Region', 'KZ', 'MAN', 1),
(142, 'Kyzylorda Region', 'KZ', 'KZY', 1),
(143, 'Almaty Region', 'KZ', 'ALM', 1),
(144, 'North Kazakhstan Region', 'KZ', 'SEV', 1),
(145, 'Akmola Region', 'KZ', 'AKM', 1),
(146, 'Pavlodar Region', 'KZ', 'PAV', 1),
(147, 'Jambyl Region', 'KZ', 'ZHA', 1),
(148, 'West Kazakhstan Province', 'KZ', 'ZAP', 1),
(149, 'Turkestan Region', 'KZ', 'YUZ', 1),
(150, 'Karaganda Region', 'KZ', 'KAR', 1),
(151, 'Aktobe Region', 'KZ', 'AKT', 1),
(152, 'Almaty', 'KZ', 'ALA', 1),
(153, 'Atyrau Region', 'KZ', 'ATY', 1),
(154, 'East Kazakhstan Region', 'KZ', 'VOS', 1),
(155, 'Baikonur', 'KZ', 'BAY', 1),
(156, 'Nur-Sultan', 'KZ', 'AST', 1),
(157, 'Kostanay Region', 'KZ', 'KUS', 1),
(158, 'Kakamega', 'KE', '11', 1),
(159, 'Kisii', 'KE', '16', 1),
(161, 'Busia', 'KE', '04', 1),
(163, 'Embu', 'KE', '06', 1),
(164, 'Laikipia', 'KE', '20', 1),
(165, 'Nandi', 'KE', '32', 1),
(166, 'Lamu', 'KE', '21', 1),
(167, 'Kirinyaga', 'KE', '15', 1),
(168, 'Bungoma', 'KE', '03', 1),
(169, 'Uasin Gishu', 'KE', '44', 1),
(170, 'Isiolo', 'KE', '09', 1),
(171, 'Kisumu', 'KE', '17', 1),
(173, 'Kwale', 'KE', '19', 1),
(174, 'Kilifi', 'KE', '14', 1),
(175, 'Narok', 'KE', '33', 1),
(176, 'Taita–Taveta', 'KE', '39', 1),
(178, 'Murang\'a', 'KE', '29', 1),
(180, 'Nyeri', 'KE', '36', 1),
(181, 'Baringo', 'KE', '01', 1),
(182, 'Wajir', 'KE', '46', 1),
(183, 'Trans Nzoia', 'KE', '42', 1),
(184, 'Machakos', 'KE', '22', 1),
(185, 'Tharaka-Nithi', 'KE', '41', 1),
(186, 'Siaya', 'KE', '38', 1),
(187, 'Mandera', 'KE', '24', 1),
(188, 'Makueni', 'KE', '23', 1),
(190, 'Migori', 'KE', '27', 1),
(191, 'Nairobi City', 'KE', '30', 1),
(192, 'Nyandarua', 'KE', '35', 1),
(193, 'Kericho', 'KE', '12', 1),
(194, 'Marsabit', 'KE', '25', 1),
(195, 'Homa Bay', 'KE', '08', 1),
(196, 'Garissa', 'KE', '07', 1),
(197, 'Kajiado', 'KE', '10', 1),
(198, 'Meru', 'KE', '26', 1),
(199, 'Kiambu', 'KE', '13', 1),
(200, 'Mombasa', 'KE', '28', 1),
(201, 'Elgeyo-Marakwet', 'KE', '05', 1),
(202, 'Vihiga', 'KE', '45', 1),
(203, 'Nakuru', 'KE', '31', 1),
(205, 'Tana River', 'KE', '40', 1),
(206, 'Turkana', 'KE', '43', 1),
(207, 'Samburu', 'KE', '37', 1),
(208, 'West Pokot', 'KE', '47', 1),
(209, 'Nyamira', 'KE', '34', 1),
(210, 'Bomet', 'KE', '02', 1),
(211, 'Kitui', 'KE', '18', 1),
(212, 'Bié Province', 'AO', 'BIE', 1),
(213, 'Huambo Province', 'AO', 'HUA', 1),
(214, 'Zaire Province', 'AO', 'ZAI', 1),
(215, 'Cunene Province', 'AO', 'CNN', 1),
(216, 'Cuanza Sul', 'AO', 'CUS', 1),
(217, 'Cuanza Norte Province', 'AO', 'CNO', 1),
(218, 'Benguela Province', 'AO', 'BGU', 1),
(219, 'Moxico Province', 'AO', 'MOX', 1),
(220, 'Lunda Sul Province', 'AO', 'LSU', 1),
(221, 'Bengo Province', 'AO', 'BGO', 1),
(222, 'Luanda Province', 'AO', 'LUA', 1),
(223, 'Lunda Norte Province', 'AO', 'LNO', 1),
(224, 'Uíge Province', 'AO', 'UIG', 1),
(225, 'Huíla Province', 'AO', 'HUI', 1),
(226, 'Cuando Cubango Province', 'AO', 'CCU', 1),
(227, 'Malanje Province', 'AO', 'MAL', 1),
(228, 'Cabinda Province', 'AO', 'CAB', 1),
(229, 'Gasa District', 'BT', 'GA', 1),
(230, 'Tsirang District', 'BT', '21', 1),
(231, 'Wangdue Phodrang District', 'BT', '24', 1),
(232, 'Haa District', 'BT', '13', 1),
(233, 'Zhemgang District', 'BT', '34', 1),
(234, 'Lhuntse District', 'BT', '44', 1),
(235, 'Punakha District', 'BT', '23', 1),
(236, 'Trashigang District', 'BT', '41', 1),
(237, 'Paro District', 'BT', '11', 1),
(238, 'Dagana District', 'BT', '22', 1),
(239, 'Chukha District', 'BT', '12', 1),
(240, 'Bumthang District', 'BT', '33', 1),
(241, 'Thimphu District', 'BT', '15', 1),
(242, 'Mongar District', 'BT', '42', 1),
(243, 'Samdrup Jongkhar District', 'BT', '45', 1),
(244, 'Pemagatshel District', 'BT', '43', 1),
(245, 'Trongsa District', 'BT', '32', 1),
(246, 'Samtse District', 'BT', '14', 1),
(247, 'Sarpang District', 'BT', '31', 1),
(248, 'Tombouctou Region', 'ML', '6', 1),
(249, 'Ségou Region', 'ML', '4', 1),
(250, 'Koulikoro Region', 'ML', '2', 1),
(251, 'Ménaka Region', 'ML', '9', 1),
(252, 'Kayes Region', 'ML', '1', 1),
(253, 'Bamako', 'ML', 'BKO', 1),
(254, 'Sikasso Region', 'ML', '3', 1),
(255, 'Mopti Region', 'ML', '5', 1),
(256, 'Taoudénit Region', 'ML', '10', 1),
(257, 'Kidal Region', 'ML', '8', 1),
(258, 'Gao Region', 'ML', '7', 1),
(259, 'Southern Province', 'RW', '05', 1),
(260, 'Western Province', 'RW', '04', 1),
(261, 'Eastern Province', 'RW', '02', 1),
(262, 'Kigali district', 'RW', '01', 1),
(263, 'Northern Province', 'RW', '03', 1),
(264, 'Belize District', 'BZ', 'BZ', 1),
(265, 'Stann Creek District', 'BZ', 'SC', 1),
(266, 'Corozal District', 'BZ', 'CZL', 1),
(267, 'Toledo District', 'BZ', 'TOL', 1),
(268, 'Orange Walk District', 'BZ', 'OW', 1),
(269, 'Cayo District', 'BZ', 'CY', 1),
(270, 'Príncipe Province', 'ST', 'P', 1),
(271, 'São Tomé Province', 'ST', 'S', 1),
(272, 'Havana Province', 'CU', '03', 1),
(273, 'Santiago de Cuba Province', 'CU', '13', 1),
(274, 'Sancti Spíritus Province', 'CU', '07', 1),
(275, 'Granma Province', 'CU', '12', 1),
(276, 'Mayabeque Province', 'CU', '16', 1),
(277, 'Pinar del Río Province', 'CU', '01', 1),
(278, 'Isla de la Juventud', 'CU', '99', 1),
(279, 'Holguín Province', 'CU', '11', 1),
(280, 'Villa Clara Province', 'CU', '05', 1),
(281, 'Las Tunas Province', 'CU', '10', 1),
(282, 'Ciego de Ávila Province', 'CU', '08', 1),
(283, 'Artemisa Province', 'CU', '15', 1),
(284, 'Matanzas Province', 'CU', '04', 1),
(285, 'Guantánamo Province', 'CU', '14', 1),
(286, 'Camagüey Province', 'CU', '09', 1),
(287, 'Cienfuegos Province', 'CU', '06', 1),
(288, 'Jigawa', 'NG', 'JI', 1),
(289, 'Enugu', 'NG', 'EN', 1),
(290, 'Kebbi', 'NG', 'KE', 1),
(291, 'Benue', 'NG', 'BE', 1),
(292, 'Sokoto', 'NG', 'SO', 1),
(293, 'Abuja Federal Capital Territory', 'NG', 'FC', 1),
(294, 'Kaduna', 'NG', 'KD', 1),
(295, 'Kwara', 'NG', 'KW', 1),
(296, 'Oyo', 'NG', 'OY', 1),
(297, 'Yobe', 'NG', 'YO', 1),
(298, 'Kogi', 'NG', 'KO', 1),
(299, 'Zamfara', 'NG', 'ZA', 1),
(300, 'Kano', 'NG', 'KN', 1),
(301, 'Nasarawa', 'NG', 'NA', 1),
(302, 'Plateau', 'NG', 'PL', 1),
(303, 'Abia', 'NG', 'AB', 1),
(304, 'Akwa Ibom', 'NG', 'AK', 1),
(305, 'Bayelsa', 'NG', 'BY', 1),
(306, 'Lagos', 'NG', 'LA', 1),
(307, 'Borno', 'NG', 'BO', 1),
(308, 'Imo', 'NG', 'IM', 1),
(309, 'Ekiti', 'NG', 'EK', 1),
(310, 'Gombe', 'NG', 'GO', 1),
(311, 'Ebonyi', 'NG', 'EB', 1),
(312, 'Bauchi', 'NG', 'BA', 1),
(313, 'Katsina', 'NG', 'KT', 1),
(314, 'Cross River', 'NG', 'CR', 1),
(315, 'Anambra', 'NG', 'AN', 1),
(316, 'Delta', 'NG', 'DE', 1),
(317, 'Niger', 'NG', 'NI', 1),
(318, 'Edo', 'NG', 'ED', 1),
(319, 'Taraba', 'NG', 'TA', 1),
(320, 'Adamawa', 'NG', 'AD', 1),
(321, 'Ondo', 'NG', 'ON', 1),
(322, 'Osun', 'NG', 'OS', 1),
(323, 'Ogun', 'NG', 'OG', 1),
(324, 'Rukungiri District', 'UG', '412', 1),
(325, 'Kyankwanzi District', 'UG', '123', 1),
(326, 'Kabarole District', 'UG', '405', 1),
(327, 'Mpigi District', 'UG', '106', 1),
(328, 'Apac District', 'UG', '302', 1),
(329, 'Abim District', 'UG', '314', 1),
(330, 'Yumbe District', 'UG', '313', 1),
(331, 'Rukiga District', 'UG', '431', 1),
(332, 'Northern Region', 'UG', 'N', 1),
(333, 'Serere District', 'UG', '232', 1),
(334, 'Kamuli District', 'UG', '205', 1),
(335, 'Amuru District', 'UG', '316', 1),
(336, 'Kaberamaido District', 'UG', '213', 1),
(337, 'Namutumba District', 'UG', '224', 1),
(338, 'Kibuku District', 'UG', '227', 1),
(339, 'Ibanda District', 'UG', '417', 1),
(340, 'Iganga District', 'UG', '203', 1),
(341, 'Dokolo District', 'UG', '317', 1),
(342, 'Lira District', 'UG', '307', 1),
(343, 'Bukedea District', 'UG', '219', 1),
(344, 'Alebtong District', 'UG', '323', 1),
(345, 'Koboko District', 'UG', '319', 1),
(346, 'Kiryandongo District', 'UG', '421', 1),
(347, 'Kiboga District', 'UG', '103', 1),
(348, 'Kitgum District', 'UG', '305', 1),
(349, 'Bududa District', 'UG', '218', 1),
(350, 'Mbale District', 'UG', '209', 1),
(351, 'Namayingo District', 'UG', '230', 1),
(352, 'Amuria District', 'UG', '216', 1),
(353, 'Amudat District', 'UG', '324', 1),
(354, 'Masindi District', 'UG', '409', 1),
(355, 'Kiruhura District', 'UG', '419', 1),
(356, 'Masaka District', 'UG', '105', 1),
(357, 'Pakwach District', 'UG', '332', 1),
(358, 'Rubanda District', 'UG', '429', 1),
(359, 'Tororo District', 'UG', '212', 1),
(360, 'Kamwenge District', 'UG', '413', 1),
(361, 'Adjumani District', 'UG', '301', 1),
(362, 'Wakiso District', 'UG', '113', 1),
(363, 'Moyo District', 'UG', '309', 1),
(364, 'Mityana District', 'UG', '115', 1),
(365, 'Butaleja District', 'UG', '221', 1),
(366, 'Gomba District', 'UG', '121', 1),
(367, 'Jinja District', 'UG', '204', 1),
(368, 'Kayunga District', 'UG', '112', 1),
(369, 'Kween District', 'UG', '228', 1),
(370, 'Western Region', 'UG', 'W', 1),
(371, 'Mubende District', 'UG', '107', 1),
(372, 'Eastern Region', 'UG', 'E', 1),
(373, 'Kanungu District', 'UG', '414', 1),
(374, 'Omoro District', 'UG', '331', 1),
(375, 'Bukomansimbi District', 'UG', '118', 1),
(376, 'Lyantonde District', 'UG', '114', 1),
(377, 'Buikwe District', 'UG', '117', 1),
(378, 'Nwoya District', 'UG', '328', 1),
(379, 'Zombo District', 'UG', '330', 1),
(380, 'Buyende District', 'UG', '226', 1),
(381, 'Bunyangabu District', 'UG', '430', 1),
(382, 'Kampala District', 'UG', '102', 1),
(383, 'Isingiro District', 'UG', '418', 1),
(384, 'Butambala District', 'UG', '119', 1),
(385, 'Bukwo District', 'UG', '220', 1),
(386, 'Bushenyi District', 'UG', '402', 1),
(387, 'Bugiri District', 'UG', '201', 1),
(388, 'Butebo District', 'UG', '233', 1),
(389, 'Buliisa District', 'UG', '416', 1),
(390, 'Otuke District', 'UG', '329', 1),
(391, 'Buhweju District', 'UG', '420', 1),
(392, 'Agago District', 'UG', '322', 1),
(393, 'Nakapiripirit District', 'UG', '311', 1),
(394, 'Kalungu District', 'UG', '122', 1),
(395, 'Moroto District', 'UG', '308', 1),
(396, 'Central Region', 'UG', 'C', 1),
(397, 'Oyam District', 'UG', '321', 1),
(398, 'Kaliro District', 'UG', '222', 1),
(399, 'Kakumiro District', 'UG', '428', 1),
(400, 'Namisindwa District', 'UG', '234', 1),
(401, 'Kole District', 'UG', '325', 1),
(402, 'Kyenjojo District', 'UG', '415', 1),
(403, 'Kagadi District', 'UG', '427', 1),
(404, 'Ntungamo District', 'UG', '411', 1),
(405, 'Kalangala District', 'UG', '101', 1),
(406, 'Nakasongola District', 'UG', '109', 1),
(407, 'Sheema District', 'UG', '426', 1),
(408, 'Pader District', 'UG', '312', 1),
(409, 'Kisoro District', 'UG', '408', 1),
(410, 'Mukono District', 'UG', '108', 1),
(411, 'Lamwo District', 'UG', '326', 1),
(412, 'Pallisa District', 'UG', '210', 1),
(413, 'Gulu District', 'UG', '304', 1),
(414, 'Buvuma District', 'UG', '120', 1),
(415, 'Mbarara District', 'UG', '410', 1),
(416, 'Amolatar District', 'UG', '315', 1),
(417, 'Lwengo District', 'UG', '124', 1),
(418, 'Mayuge District', 'UG', '214', 1),
(419, 'Bundibugyo District', 'UG', '401', 1),
(420, 'Katakwi District', 'UG', '207', 1),
(421, 'Maracha District', 'UG', '320', 1),
(422, 'Ntoroko District', 'UG', '424', 1),
(423, 'Nakaseke District', 'UG', '116', 1),
(424, 'Ngora District', 'UG', '231', 1),
(425, 'Kumi District', 'UG', '208', 1),
(426, 'Kabale District', 'UG', '404', 1),
(427, 'Sembabule District', 'UG', '111', 1),
(428, 'Bulambuli District', 'UG', '225', 1),
(429, 'Sironko District', 'UG', '215', 1),
(430, 'Napak District', 'UG', '327', 1),
(431, 'Busia District', 'UG', '202', 1),
(432, 'Kapchorwa District', 'UG', '206', 1),
(433, 'Luwero District', 'UG', '104', 1),
(434, 'Kaabong District', 'UG', '318', 1),
(435, 'Mitooma District', 'UG', '423', 1),
(436, 'Kibaale District', 'UG', '407', 1),
(437, 'Kyegegwa District', 'UG', '422', 1),
(438, 'Manafwa District', 'UG', '223', 1),
(439, 'Rakai District', 'UG', '110', 1),
(440, 'Kasese District', 'UG', '406', 1),
(441, 'Budaka District', 'UG', '217', 1),
(442, 'Rubirizi District', 'UG', '425', 1),
(443, 'Kotido District', 'UG', '306', 1),
(444, 'Soroti District', 'UG', '211', 1),
(445, 'Luuka District', 'UG', '229', 1),
(446, 'Nebbi District', 'UG', '310', 1),
(447, 'Arua District', 'UG', '303', 1),
(448, 'Kyotera District', 'UG', '125', 1),
(449, 'Schellenberg', 'LI', '08', 1),
(450, 'Schaan', 'LI', '07', 1),
(451, 'Eschen', 'LI', '02', 1),
(452, 'Vaduz', 'LI', '11', 1),
(453, 'Ruggell', 'LI', '06', 1),
(454, 'Planken', 'LI', '05', 1),
(455, 'Mauren', 'LI', '04', 1),
(456, 'Triesenberg', 'LI', '10', 1),
(457, 'Gamprin', 'LI', '03', 1),
(458, 'Balzers', 'LI', '01', 1),
(459, 'Triesen', 'LI', '09', 1),
(460, 'Brčko District', 'BA', 'BRC', 1),
(461, 'Tuzla Canton', 'BA', '03', 1),
(462, 'Central Bosnia Canton', 'BA', '06', 1),
(463, 'Herzegovina-Neretva Canton', 'BA', '07', 1),
(464, 'Posavina Canton', 'BA', '02', 1),
(465, 'Una-Sana Canton', 'BA', '01', 1),
(466, 'Sarajevo Canton', 'BA', '09', 1),
(467, 'Federation of Bosnia and Herzegovina', 'BA', 'BIH', 1),
(468, 'Zenica-Doboj Canton', 'BA', '04', 1),
(469, 'West Herzegovina Canton', 'BA', '08', 1),
(470, 'Republika Srpska', 'BA', 'SRP', 1),
(471, 'Canton 10', 'BA', '10', 1),
(472, 'Bosnian Podrinje Canton', 'BA', '05', 1),
(473, 'Dakar', 'SN', 'DK', 1),
(474, 'Kolda', 'SN', 'KD', 1),
(475, 'Kaffrine', 'SN', 'KA', 1),
(476, 'Matam', 'SN', 'MT', 1),
(477, 'Saint-Louis', 'SN', 'SL', 1),
(478, 'Ziguinchor', 'SN', 'ZG', 1),
(479, 'Fatick', 'SN', 'FK', 1),
(480, 'Diourbel Region', 'SN', 'DB', 1),
(481, 'Kédougou', 'SN', 'KE', 1),
(482, 'Sédhiou', 'SN', 'SE', 1),
(483, 'Kaolack', 'SN', 'KL', 1),
(484, 'Thiès Region', 'SN', 'TH', 1),
(485, 'Louga', 'SN', 'LG', 1),
(486, 'Tambacounda Region', 'SN', 'TC', 1),
(487, 'Encamp', 'AD', '03', 1),
(488, 'Andorra la Vella', 'AD', '07', 1),
(489, 'Canillo', 'AD', '02', 1),
(490, 'Sant Julià de Lòria', 'AD', '06', 1),
(491, 'Ordino', 'AD', '05', 1),
(492, 'Escaldes-Engordany', 'AD', '08', 1),
(493, 'La Massana', 'AD', '04', 1),
(494, 'Mont Buxton', 'SC', '17', 1),
(495, 'La Digue', 'SC', '15', 1),
(496, 'Saint Louis', 'SC', '22', 1),
(497, 'Baie Lazare', 'SC', '06', 1),
(498, 'Mont Fleuri', 'SC', '18', 1),
(499, 'Les Mamelles', 'SC', '24', 1),
(500, 'Grand\'Anse Mahé', 'SC', '13', 1),
(501, 'Roche Caiman', 'SC', '25', 1),
(502, 'Anse Royale', 'SC', '05', 1),
(503, 'Glacis', 'SC', '12', 1),
(504, 'Grand\'Anse Praslin', 'SC', '14', 1),
(505, 'Bel Ombre', 'SC', '10', 1),
(506, 'Anse-aux-Pins', 'SC', '01', 1),
(507, 'Port Glaud', 'SC', '21', 1),
(508, 'Au Cap', 'SC', '04', 1),
(509, 'Takamaka', 'SC', '23', 1),
(510, 'Pointe La Rue', 'SC', '20', 1),
(511, 'Plaisance', 'SC', '19', 1),
(512, 'Beau Vallon', 'SC', '08', 1),
(513, 'Anse Boileau', 'SC', '02', 1),
(514, 'Baie Sainte Anne', 'SC', '07', 1),
(515, 'Bel Air', 'SC', '09', 1),
(516, 'La Rivière Anglaise', 'SC', '16', 1),
(517, 'Cascade', 'SC', '11', 1),
(518, 'Shaki', 'AZ', 'SA', 1),
(519, 'Tartar District', 'AZ', 'TAR', 1),
(520, 'Shirvan', 'AZ', 'SR', 1),
(521, 'Qazakh District', 'AZ', 'QAZ', 1),
(522, 'Sadarak District', 'AZ', 'SAD', 1),
(523, 'Yevlakh District', 'AZ', 'YEV', 1),
(524, 'Khojali District', 'AZ', 'XCI', 1),
(525, 'Kalbajar District', 'AZ', 'KAL', 1),
(526, 'Qakh District', 'AZ', 'QAX', 1),
(527, 'Fizuli District', 'AZ', 'FUZ', 1),
(528, 'Astara District', 'AZ', 'AST', 1),
(529, 'Shamakhi District', 'AZ', 'SMI', 1),
(530, 'Neftchala District', 'AZ', 'NEF', 1),
(531, 'Goychay', 'AZ', 'GOY', 1),
(532, 'Bilasuvar District', 'AZ', 'BIL', 1),
(533, 'Tovuz District', 'AZ', 'TOV', 1),
(534, 'Ordubad District', 'AZ', 'ORD', 1),
(535, 'Sharur District', 'AZ', 'SAR', 1),
(536, 'Samukh District', 'AZ', 'SMX', 1),
(537, 'Khizi District', 'AZ', 'XIZ', 1),
(538, 'Yevlakh', 'AZ', 'YE', 1),
(539, 'Ujar District', 'AZ', 'UCA', 1),
(540, 'Absheron District', 'AZ', 'ABS', 1),
(541, 'Lachin District', 'AZ', 'LAC', 1),
(542, 'Qabala District', 'AZ', 'QAB', 1),
(543, 'Agstafa District', 'AZ', 'AGA', 1),
(544, 'Imishli District', 'AZ', 'IMI', 1),
(545, 'Salyan District', 'AZ', 'SAL', 1),
(546, 'Lerik District', 'AZ', 'LER', 1),
(547, 'Agsu District', 'AZ', 'AGU', 1),
(548, 'Qubadli District', 'AZ', 'QBI', 1),
(549, 'Kurdamir District', 'AZ', 'KUR', 1),
(550, 'Yardymli District', 'AZ', 'YAR', 1),
(551, 'Goranboy District', 'AZ', 'GOR', 1),
(552, 'Baku', 'AZ', 'BA', 1),
(553, 'Agdash District', 'AZ', 'AGS', 1),
(554, 'Beylagan District', 'AZ', 'BEY', 1),
(555, 'Masally District', 'AZ', 'MAS', 1),
(556, 'Oghuz District', 'AZ', 'OGU', 1),
(557, 'Saatly District', 'AZ', 'SAT', 1),
(558, 'Lankaran District', 'AZ', 'LA', 1),
(559, 'Agdam District', 'AZ', 'AGM', 1),
(560, 'Balakan District', 'AZ', 'BAL', 1),
(561, 'Dashkasan District', 'AZ', 'DAS', 1),
(562, 'Nakhchivan Autonomous Republic', 'AZ', 'NX', 1),
(563, 'Quba District', 'AZ', 'QBA', 1),
(564, 'Ismailli District', 'AZ', 'ISM', 1),
(565, 'Sabirabad District', 'AZ', 'SAB', 1),
(566, 'Zaqatala District', 'AZ', 'ZAQ', 1),
(567, 'Kangarli District', 'AZ', 'KAN', 1),
(568, 'Martuni', 'AZ', 'XVD', 1),
(569, 'Barda District', 'AZ', 'BAR', 1),
(570, 'Jabrayil District', 'AZ', 'CAB', 1),
(571, 'Hajigabul District', 'AZ', 'HAC', 1),
(572, 'Julfa District', 'AZ', 'CUL', 1),
(573, 'Gobustan District', 'AZ', 'QOB', 1),
(574, 'Goygol District', 'AZ', 'GYG', 1),
(575, 'Babek District', 'AZ', 'BAB', 1),
(576, 'Zardab District', 'AZ', 'ZAR', 1),
(577, 'Aghjabadi District', 'AZ', 'AGC', 1),
(578, 'Jalilabad District', 'AZ', 'CAL', 1),
(579, 'Shahbuz District', 'AZ', 'SAH', 1),
(580, 'Mingachevir', 'AZ', 'MI', 1),
(581, 'Zangilan District', 'AZ', 'ZAN', 1),
(582, 'Sumqayit', 'AZ', 'SM', 1),
(583, 'Shamkir District', 'AZ', 'SKR', 1),
(584, 'Siazan District', 'AZ', 'SIY', 1),
(585, 'Ganja', 'AZ', 'GA', 1),
(586, 'Shaki District', 'AZ', 'SAK', 1),
(587, 'Lankaran', 'AZ', 'LAN', 1),
(588, 'Qusar District', 'AZ', 'QUS', 1),
(589, 'Gədəbəy', 'AZ', 'GAD', 1),
(590, 'Khachmaz District', 'AZ', 'XAC', 1),
(591, 'Shabran District', 'AZ', 'SBN', 1),
(592, 'Shusha District', 'AZ', 'SUS', 1),
(593, 'Skrapar District', 'AL', 'SK', 1),
(594, 'Kavajë District', 'AL', 'KA', 1),
(595, 'Lezhë District', 'AL', 'LE', 1),
(596, 'Librazhd District', 'AL', 'LB', 1),
(597, 'Korçë District', 'AL', 'KO', 1),
(598, 'Elbasan County', 'AL', '03', 1),
(599, 'Lushnjë District', 'AL', 'LU', 1),
(600, 'Has District', 'AL', 'HA', 1),
(601, 'Kukës County', 'AL', '07', 1),
(602, 'Malësi e Madhe District', 'AL', 'MM', 1),
(603, 'Berat County', 'AL', '01', 1),
(604, 'Gjirokastër County', 'AL', '05', 1),
(605, 'Dibër District', 'AL', 'DI', 1),
(606, 'Pogradec District', 'AL', 'PG', 1),
(607, 'Bulqizë District', 'AL', 'BU', 1),
(608, 'Devoll District', 'AL', 'DV', 1),
(609, 'Lezhë County', 'AL', '08', 1),
(610, 'Dibër County', 'AL', '09', 1),
(611, 'Shkodër County', 'AL', '10', 1),
(612, 'Kuçovë District', 'AL', 'KC', 1),
(613, 'Vlorë District', 'AL', 'VL', 1),
(614, 'Krujë District', 'AL', 'KR', 1),
(615, 'Tirana County', 'AL', '11', 1),
(616, 'Tepelenë District', 'AL', 'TE', 1),
(617, 'Gramsh District', 'AL', 'GR', 1),
(618, 'Delvinë District', 'AL', 'DL', 1),
(619, 'Peqin District', 'AL', 'PQ', 1),
(620, 'Pukë District', 'AL', 'PU', 1),
(621, 'Gjirokastër District', 'AL', 'GJ', 1),
(622, 'Kurbin District', 'AL', 'KB', 1),
(623, 'Kukës District', 'AL', 'KU', 1),
(624, 'Sarandë District', 'AL', 'SR', 1),
(625, 'Përmet District', 'AL', 'PR', 1),
(626, 'Shkodër District', 'AL', 'SH', 1),
(627, 'Fier District', 'AL', 'FR', 1),
(628, 'Kolonjë District', 'AL', 'ER', 1),
(629, 'Berat District', 'AL', 'BR', 1),
(630, 'Korçë County', 'AL', '06', 1),
(631, 'Fier County', 'AL', '04', 1),
(632, 'Durrës County', 'AL', '02', 1),
(633, 'Tirana District', 'AL', 'TR', 1),
(634, 'Vlorë County', 'AL', '12', 1),
(635, 'Mat District', 'AL', 'MT', 1),
(636, 'Tropojë District', 'AL', 'TP', 1),
(637, 'Mallakastër District', 'AL', 'MK', 1),
(638, 'Mirditë District', 'AL', 'MR', 1),
(639, 'Durrës District', 'AL', 'DR', 1),
(640, 'Sveti Nikole Municipality', 'MK', '69', 1),
(641, 'Kratovo Municipality', 'MK', '43', 1),
(642, 'Zajas Municipality', 'MK', '31', 1),
(643, 'Staro Nagoričane Municipality', 'MK', '71', 1),
(644, 'Češinovo-Obleševo Municipality', 'MK', '81', 1),
(645, 'Debarca Municipality', 'MK', '22', 1),
(646, 'Probištip Municipality', 'MK', '63', 1),
(647, 'Krivogaštani Municipality', 'MK', '45', 1),
(648, 'Gevgelija Municipality', 'MK', '18', 1),
(649, 'Bogdanci Municipality', 'MK', '05', 1),
(650, 'Vraneštica Municipality', 'MK', '15', 1),
(651, 'Veles Municipality', 'MK', '13', 1),
(652, 'Bosilovo Municipality', 'MK', '07', 1),
(653, 'Mogila Municipality', 'MK', '53', 1),
(654, 'Tearce Municipality', 'MK', '75', 1),
(655, 'Demir Kapija Municipality', 'MK', '24', 1),
(656, 'Aračinovo Municipality', 'MK', '02', 1),
(657, 'Drugovo Municipality', 'MK', '28', 1),
(658, 'Vasilevo Municipality', 'MK', '11', 1),
(659, 'Lipkovo Municipality', 'MK', '48', 1),
(660, 'Brvenica Municipality', 'MK', '08', 1),
(661, 'Štip Municipality', 'MK', '83', 1),
(662, 'Vevčani Municipality', 'MK', '12', 1),
(663, 'Tetovo Municipality', 'MK', '76', 1),
(664, 'Negotino Municipality', 'MK', '54', 1),
(665, 'Konče Municipality', 'MK', '41', 1),
(666, 'Prilep Municipality', 'MK', '62', 1),
(667, 'Saraj Municipality', 'MK', '68', 1),
(668, 'Želino Municipality', 'MK', '30', 1),
(669, 'Mavrovo and Rostuša Municipality', 'MK', '50', 1),
(670, 'Plasnica Municipality', 'MK', '61', 1),
(671, 'Valandovo Municipality', 'MK', '10', 1),
(672, 'Vinica Municipality', 'MK', '14', 1),
(673, 'Zrnovci Municipality', 'MK', '33', 1),
(674, 'Karbinci', 'MK', '37', 1),
(675, 'Dolneni Municipality', 'MK', '27', 1),
(676, 'Čaška Municipality', 'MK', '80', 1),
(677, 'Kriva Palanka Municipality', 'MK', '44', 1),
(678, 'Jegunovce Municipality', 'MK', '35', 1),
(679, 'Bitola Municipality', 'MK', '04', 1),
(680, 'Šuto Orizari Municipality', 'MK', '84', 1),
(681, 'Karpoš Municipality', 'MK', '38', 1),
(682, 'Oslomej Municipality', 'MK', '57', 1),
(683, 'Kumanovo Municipality', 'MK', '47', 1),
(684, 'Greater Skopje', 'MK', '85', 1),
(685, 'Pehčevo Municipality', 'MK', '60', 1),
(686, 'Kisela Voda Municipality', 'MK', '39', 1),
(687, 'Demir Hisar Municipality', 'MK', '25', 1),
(688, 'Kičevo Municipality', 'MK', '40', 1),
(689, 'Vrapčište Municipality', 'MK', '16', 1),
(690, 'Ilinden Municipality', 'MK', '34', 1),
(691, 'Rosoman Municipality', 'MK', '67', 1),
(692, 'Makedonski Brod Municipality', 'MK', '52', 1),
(693, 'Gostivar Municipality', 'MK', '19', 1),
(694, 'Butel Municipality', 'MK', '09', 1),
(695, 'Delčevo Municipality', 'MK', '23', 1),
(696, 'Novaci Municipality', 'MK', '55', 1),
(697, 'Dojran Municipality', 'MK', '26', 1),
(698, 'Petrovec Municipality', 'MK', '59', 1),
(699, 'Ohrid Municipality', 'MK', '58', 1),
(700, 'Struga Municipality', 'MK', '72', 1),
(701, 'Makedonska Kamenica Municipality', 'MK', '51', 1),
(702, 'Centar Municipality', 'MK', '77', 1),
(703, 'Aerodrom Municipality', 'MK', '01', 1),
(704, 'Čair Municipality', 'MK', '79', 1),
(705, 'Lozovo Municipality', 'MK', '49', 1),
(706, 'Zelenikovo Municipality', 'MK', '32', 1),
(707, 'Gazi Baba Municipality', 'MK', '17', 1),
(708, 'Gradsko Municipality', 'MK', '20', 1),
(709, 'Radoviš Municipality', 'MK', '64', 1),
(710, 'Strumica Municipality', 'MK', '73', 1),
(711, 'Studeničani Municipality', 'MK', '74', 1),
(712, 'Resen Municipality', 'MK', '66', 1),
(713, 'Kavadarci Municipality', 'MK', '36', 1),
(714, 'Kruševo Municipality', 'MK', '46', 1),
(715, 'Čučer-Sandevo Municipality', 'MK', '82', 1),
(716, 'Berovo Municipality', 'MK', '03', 1),
(717, 'Rankovce Municipality', 'MK', '65', 1),
(718, 'Novo Selo Municipality', 'MK', '56', 1),
(719, 'Sopište Municipality', 'MK', '70', 1),
(720, 'Centar Župa Municipality', 'MK', '78', 1),
(721, 'Bogovinje Municipality', 'MK', '06', 1),
(722, 'Gjorče Petrov Municipality', 'MK', '29', 1),
(723, 'Kočani Municipality', 'MK', '42', 1),
(724, 'Požega-Slavonia', 'HR', '11', 1),
(725, 'Split-Dalmatia', 'HR', '17', 1),
(726, 'Međimurje', 'HR', '20', 1),
(727, 'Zadar', 'HR', '13', 1),
(728, 'Dubrovnik-Neretva', 'HR', '19', 1),
(729, 'Krapina-Zagorje', 'HR', '02', 1),
(730, 'Šibenik-Knin', 'HR', '15', 1),
(731, 'Lika-Senj', 'HR', '09', 1),
(732, 'Virovitica-Podravina', 'HR', '10', 1),
(733, 'Sisak-Moslavina', 'HR', '03', 1),
(734, 'Bjelovar-Bilogora', 'HR', '07', 1),
(735, 'Primorje-Gorski Kotar', 'HR', '08', 1),
(736, 'Zagreb', 'HR', '01', 1),
(737, 'Brod-Posavina', 'HR', '12', 1),
(738, 'Zagreb', 'HR', '21', 1),
(739, 'Varaždin', 'HR', '05', 1),
(740, 'Osijek-Baranja', 'HR', '14', 1),
(741, 'Vukovar-Syrmia', 'HR', '16', 1),
(742, 'Koprivnica-Križevci', 'HR', '06', 1),
(743, 'Istria', 'HR', '18', 1),
(744, 'Kyrenia District (Keryneia)', 'CY', '06', 1),
(745, 'Nicosia District (Lefkoşa)', 'CY', '01', 1),
(746, 'Paphos District (Pafos)', 'CY', '05', 1),
(747, 'Larnaca District (Larnaka)', 'CY', '03', 1),
(748, 'Limassol District (Leymasun)', 'CY', '02', 1),
(749, 'Famagusta District (Mağusa)', 'CY', '04', 1),
(750, 'Rangpur Division', 'BD', 'F', 1),
(751, 'Cox\'s Bazar District', 'BD', '11', 1),
(752, 'Bandarban District', 'BD', '01', 1),
(753, 'Rajshahi Division', 'BD', 'E', 1),
(754, 'Pabna District', 'BD', '49', 1),
(755, 'Sherpur District', 'BD', '57', 1),
(756, 'Bhola District', 'BD', '07', 1),
(757, 'Jessore District', 'BD', '22', 1),
(758, 'Mymensingh Division', 'BD', 'H', 1),
(759, 'Rangpur District', 'BD', '55', 1),
(760, 'Dhaka Division', 'BD', 'C', 1),
(761, 'Chapai Nawabganj District', 'BD', '45', 1),
(762, 'Faridpur District', 'BD', '15', 1),
(763, 'Comilla District', 'BD', '08', 1),
(764, 'Netrokona District', 'BD', '41', 1),
(765, 'Sylhet Division', 'BD', 'G', 1),
(766, 'Mymensingh District', 'BD', '34', 1),
(767, 'Sylhet District', 'BD', '60', 1),
(768, 'Chandpur District', 'BD', '09', 1),
(769, 'Narail District', 'BD', '43', 1),
(770, 'Narayanganj District', 'BD', '40', 1),
(771, 'Dhaka District', 'BD', '13', 1),
(772, 'Nilphamari District', 'BD', '46', 1),
(773, 'Rajbari District', 'BD', '53', 1),
(774, 'Kushtia District', 'BD', '30', 1),
(775, 'Khulna Division', 'BD', 'D', 1),
(776, 'Meherpur District', 'BD', '39', 1),
(777, 'Patuakhali District', 'BD', '51', 1),
(778, 'Jhalokati District', 'BD', '25', 1),
(779, 'Kishoreganj District', 'BD', '26', 1),
(780, 'Lalmonirhat District', 'BD', '32', 1),
(781, 'Sirajganj District', 'BD', '59', 1),
(782, 'Tangail District', 'BD', '63', 1),
(783, 'Dinajpur District', 'BD', '14', 1),
(784, 'Barguna District', 'BD', '02', 1),
(785, 'Chittagong District', 'BD', '10', 1),
(786, 'Khagrachari District', 'BD', '29', 1),
(787, 'Natore District', 'BD', '44', 1),
(788, 'Chuadanga District', 'BD', '12', 1),
(789, 'Jhenaidah District', 'BD', '23', 1),
(790, 'Munshiganj District', 'BD', '35', 1),
(791, 'Pirojpur District', 'BD', '50', 1),
(792, 'Gopalganj District', 'BD', '17', 1),
(793, 'Kurigram District', 'BD', '28', 1),
(794, 'Moulvibazar District', 'BD', '38', 1),
(795, 'Gaibandha District', 'BD', '19', 1),
(796, 'Bagerhat District', 'BD', '05', 1),
(797, 'Bogra District', 'BD', '03', 1),
(798, 'Gazipur District', 'BD', '18', 1),
(799, 'Satkhira District', 'BD', '58', 1),
(800, 'Panchagarh District', 'BD', '52', 1),
(801, 'Shariatpur District', 'BD', '62', 1),
(802, 'Bahadia', 'BD', '33', 1),
(803, 'Chittagong Division', 'BD', 'B', 1),
(804, 'Thakurgaon District', 'BD', '64', 1),
(805, 'Habiganj District', 'BD', '20', 1),
(806, 'Joypurhat District', 'BD', '24', 1),
(807, 'Barisal Division', 'BD', 'A', 1),
(808, 'Jamalpur District', 'BD', '21', 1),
(809, 'Rangamati Hill District', 'BD', '56', 1),
(810, 'Brahmanbaria District', 'BD', '04', 1),
(811, 'Khulna District', 'BD', '27', 1),
(812, 'Sunamganj District', 'BD', '61', 1),
(813, 'Rajshahi District', 'BD', '54', 1),
(814, 'Naogaon District', 'BD', '48', 1),
(815, 'Noakhali District', 'BD', '47', 1),
(816, 'Feni District', 'BD', '16', 1),
(817, 'Madaripur District', 'BD', '36', 1),
(818, 'Barisal District', 'BD', '06', 1),
(819, 'Lakshmipur District', 'BD', '31', 1),
(820, 'Okayama Prefecture', 'JP', '33', 1),
(821, 'Chiba Prefecture', 'JP', '12', 1),
(822, 'Ōita Prefecture', 'JP', '44', 1),
(823, 'Tokyo', 'JP', '13', 1),
(824, 'Nara Prefecture', 'JP', '29', 1),
(825, 'Shizuoka Prefecture', 'JP', '22', 1),
(826, 'Shimane Prefecture', 'JP', '32', 1),
(827, 'Aichi Prefecture', 'JP', '23', 1),
(828, 'Hiroshima Prefecture', 'JP', '34', 1),
(829, 'Akita Prefecture', 'JP', '05', 1),
(830, 'Ishikawa Prefecture', 'JP', '17', 1),
(831, 'Hyōgo Prefecture', 'JP', '28', 1),
(832, 'Hokkaidō Prefecture', 'JP', '01', 1),
(833, 'Mie Prefecture', 'JP', '24', 1),
(834, 'Kyōto Prefecture', 'JP', '26', 1),
(835, 'Yamaguchi Prefecture', 'JP', '35', 1),
(836, 'Tokushima Prefecture', 'JP', '36', 1),
(837, 'Yamagata Prefecture', 'JP', '06', 1),
(838, 'Toyama Prefecture', 'JP', '16', 1),
(839, 'Aomori Prefecture', 'JP', '02', 1),
(840, 'Kagoshima Prefecture', 'JP', '46', 1),
(841, 'Niigata Prefecture', 'JP', '15', 1),
(842, 'Kanagawa Prefecture', 'JP', '14', 1),
(843, 'Nagano Prefecture', 'JP', '20', 1),
(844, 'Wakayama Prefecture', 'JP', '30', 1),
(845, 'Shiga Prefecture', 'JP', '25', 1),
(846, 'Kumamoto Prefecture', 'JP', '43', 1),
(847, 'Fukushima Prefecture', 'JP', '07', 1),
(848, 'Fukui Prefecture', 'JP', '18', 1),
(849, 'Nagasaki Prefecture', 'JP', '42', 1),
(850, 'Tottori Prefecture', 'JP', '31', 1),
(851, 'Ibaraki Prefecture', 'JP', '08', 1),
(852, 'Yamanashi Prefecture', 'JP', '19', 1),
(853, 'Okinawa Prefecture', 'JP', '47', 1),
(854, 'Tochigi Prefecture', 'JP', '09', 1),
(855, 'Miyazaki Prefecture', 'JP', '45', 1),
(856, 'Iwate Prefecture', 'JP', '03', 1),
(857, 'Miyagi Prefecture', 'JP', '04', 1),
(858, 'Gifu Prefecture', 'JP', '21', 1),
(859, 'Ōsaka Prefecture', 'JP', '27', 1),
(860, 'Saitama Prefecture', 'JP', '11', 1),
(861, 'Fukuoka Prefecture', 'JP', '40', 1),
(862, 'Gunma Prefecture', 'JP', '10', 1),
(863, 'Saga Prefecture', 'JP', '41', 1),
(864, 'Kagawa Prefecture', 'JP', '37', 1),
(865, 'Ehime Prefecture', 'JP', '38', 1),
(866, 'Ontario', 'CA', 'ON', 1),
(867, 'Manitoba', 'CA', 'MB', 1),
(868, 'New Brunswick', 'CA', 'NB', 1),
(869, 'Yukon', 'CA', 'YT', 1),
(870, 'Saskatchewan', 'CA', 'SK', 1),
(871, 'Prince Edward Island', 'CA', 'PE', 1),
(872, 'Alberta', 'CA', 'AB', 1),
(873, 'Quebec', 'CA', 'QC', 1),
(874, 'Nova Scotia', 'CA', 'NS', 1),
(875, 'British Columbia', 'CA', 'BC', 1),
(876, 'Nunavut', 'CA', 'NU', 1),
(877, 'Newfoundland and Labrador', 'CA', 'NL', 1),
(878, 'Northwest Territories', 'CA', 'NT', 1),
(879, 'White Nile', 'SD', 'NW', 1),
(880, 'Red Sea', 'SD', 'RS', 1),
(881, 'Khartoum', 'SD', 'KH', 1),
(882, 'Sennar', 'SD', 'SI', 1),
(883, 'South Kordofan', 'SD', 'KS', 1),
(884, 'Kassala', 'SD', 'KA', 1),
(885, 'Al Jazirah', 'SD', 'GZ', 1),
(886, 'Al Qadarif', 'SD', 'GD', 1),
(887, 'Blue Nile', 'SD', 'NB', 1),
(888, 'West Darfur', 'SD', 'DW', 1),
(889, 'West Kordofan', 'SD', 'GK', 1),
(890, 'North Darfur', 'SD', 'DN', 1),
(891, 'River Nile', 'SD', 'NR', 1),
(892, 'East Darfur', 'SD', 'DE', 1),
(893, 'North Kordofan', 'SD', 'KN', 1),
(894, 'South Darfur', 'SD', 'DS', 1),
(895, 'Northern', 'SD', 'NO', 1),
(896, 'Central Darfur', 'SD', 'DC', 1),
(897, 'Khelvachauri Municipality', 'GE', '29', 1),
(898, 'Senaki Municipality', 'GE', '50', 1),
(899, 'Tbilisi', 'GE', 'TB', 1),
(900, 'Adjara', 'GE', 'AJ', 1),
(901, 'Autonomous Republic of Abkhazia', 'GE', 'AB', 1),
(902, 'Mtskheta-Mtianeti', 'GE', 'MM', 1),
(903, 'Shida Kartli', 'GE', 'SK', 1),
(904, 'Kvemo Kartli', 'GE', 'KK', 1),
(905, 'Imereti', 'GE', 'IM', 1),
(906, 'Samtskhe-Javakheti', 'GE', 'SJ', 1),
(907, 'Guria', 'GE', 'GU', 1),
(908, 'Samegrelo-Zemo Svaneti', 'GE', 'SZ', 1),
(909, 'Racha-Lechkhumi and Kvemo Svaneti', 'GE', 'RL', 1),
(910, 'Kakheti', 'GE', 'KA', 1),
(911, 'Northern Province', 'SL', 'N', 1),
(912, 'Southern Province', 'SL', 'S', 1),
(913, 'Western Area', 'SL', 'W', 1),
(914, 'Eastern Province', 'SL', 'E', 1),
(915, 'Hiran', 'SO', 'HI', 1),
(916, 'Mudug', 'SO', 'MU', 1),
(917, 'Bakool', 'SO', 'BK', 1),
(918, 'Galguduud', 'SO', 'GA', 1),
(919, 'Sanaag Region', 'SO', 'SA', 1),
(920, 'Nugal', 'SO', 'NU', 1),
(921, 'Lower Shebelle', 'SO', 'SH', 1),
(922, 'Middle Juba', 'SO', 'JD', 1),
(923, 'Middle Shebelle', 'SO', 'SD', 1),
(924, 'Lower Juba', 'SO', 'JH', 1),
(925, 'Awdal Region', 'SO', 'AW', 1),
(926, 'Bay', 'SO', 'BY', 1),
(927, 'Banaadir', 'SO', 'BN', 1),
(928, 'Gedo', 'SO', 'GE', 1),
(929, 'Togdheer Region', 'SO', 'TO', 1),
(930, 'Bari', 'SO', 'BR', 1),
(931, 'Northern Cape', 'ZA', 'NC', 1),
(932, 'Free State', 'ZA', 'FS', 1),
(933, 'Limpopo', 'ZA', 'LP', 1),
(934, 'North West', 'ZA', 'NW', 1),
(935, 'KwaZulu-Natal', 'ZA', 'KZN', 1),
(936, 'Gauteng', 'ZA', 'GP', 1),
(937, 'Mpumalanga', 'ZA', 'MP', 1),
(938, 'Eastern Cape', 'ZA', 'EC', 1),
(939, 'Western Cape', 'ZA', 'WC', 1),
(940, 'Chontales', 'NI', 'CO', 1),
(941, 'Managua', 'NI', 'MN', 1),
(942, 'Rivas', 'NI', 'RI', 1),
(943, 'Granada', 'NI', 'GR', 1),
(944, 'León', 'NI', 'LE', 1),
(945, 'Estelí', 'NI', 'ES', 1),
(946, 'Boaco', 'NI', 'BO', 1),
(947, 'Matagalpa', 'NI', 'MT', 1),
(948, 'Madriz', 'NI', 'MD', 1),
(949, 'Río San Juan', 'NI', 'SJ', 1),
(950, 'Carazo', 'NI', 'CA', 1),
(951, 'North Caribbean Coast', 'NI', 'AN', 1),
(952, 'South Caribbean Coast', 'NI', 'AS', 1),
(953, 'Masaya', 'NI', 'MS', 1),
(954, 'Chinandega', 'NI', 'CI', 1),
(955, 'Jinotega', 'NI', 'JI', 1),
(956, 'Karak', 'JO', 'KA', 1),
(957, 'Tafilah', 'JO', 'AT', 1),
(958, 'Madaba', 'JO', 'MD', 1),
(959, 'Aqaba', 'JO', 'AQ', 1),
(960, 'Irbid', 'JO', 'IR', 1),
(961, 'Balqa', 'JO', 'BA', 1),
(962, 'Mafraq', 'JO', 'MA', 1),
(963, 'Ajloun', 'JO', 'AJ', 1),
(964, 'Ma\'an', 'JO', 'MN', 1),
(965, 'Amman', 'JO', 'AM', 1),
(966, 'Jerash', 'JO', 'JA', 1),
(967, 'Zarqa', 'JO', 'AZ', 1),
(968, 'Manzini District', 'SZ', 'MA', 1),
(969, 'Hhohho District', 'SZ', 'HH', 1),
(970, 'Lubombo District', 'SZ', 'LU', 1),
(971, 'Shiselweni District', 'SZ', 'SH', 1),
(972, 'Al Jahra', 'KW', 'JA', 1),
(973, 'Hawalli', 'KW', 'HA', 1),
(974, 'Mubarak Al-Kabeer', 'KW', 'MU', 1),
(975, 'Al Farwaniyah', 'KW', 'FA', 1),
(976, 'Capital', 'KW', 'KU', 1),
(977, 'Al Ahmadi', 'KW', 'AH', 1),
(978, 'Luang Prabang Province', 'LA', 'LP', 1),
(979, 'Vientiane Prefecture', 'LA', 'VT', 1),
(980, 'Vientiane Province', 'LA', 'VI', 1),
(981, 'Salavan Province', 'LA', 'SL', 1),
(982, 'Attapeu Province', 'LA', 'AT', 1),
(983, 'Xaisomboun Province', 'LA', 'XS', 1),
(984, 'Sekong Province', 'LA', 'XE', 1),
(985, 'Bolikhamsai Province', 'LA', 'BL', 1),
(986, 'Khammouane Province', 'LA', 'KH', 1),
(987, 'Phongsaly Province', 'LA', 'PH', 1),
(988, 'Oudomxay Province', 'LA', 'OU', 1),
(989, 'Houaphanh Province', 'LA', 'HO', 1),
(990, 'Savannakhet Province', 'LA', 'SV', 1),
(991, 'Bokeo Province', 'LA', 'BK', 1),
(992, 'Luang Namtha Province', 'LA', 'LM', 1),
(993, 'Sainyabuli Province', 'LA', 'XA', 1),
(994, 'Xaisomboun', 'LA', 'XN', 1),
(995, 'Xiangkhouang Province', 'LA', 'XI', 1),
(996, 'Champasak Province', 'LA', 'CH', 1),
(997, 'Talas Region', 'KG', 'T', 1),
(998, 'Batken Region', 'KG', 'B', 1),
(999, 'Naryn Region', 'KG', 'N', 1),
(1000, 'Jalal-Abad Region', 'KG', 'J', 1),
(1001, 'Bishkek', 'KG', 'GB', 1),
(1002, 'Issyk-Kul Region', 'KG', 'Y', 1),
(1003, 'Osh', 'KG', 'GO', 1),
(1004, 'Chuy Region', 'KG', 'C', 1),
(1005, 'Osh Region', 'KG', 'O', 1),
(1006, 'Trøndelag', 'NO', '50', 1),
(1007, 'Oslo', 'NO', '03', 1),
(1008, 'Vestfold', 'NO', '07', 1),
(1009, 'Oppland', 'NO', '05', 1),
(1010, 'Sør-Trøndelag', 'NO', '16', 1),
(1011, 'Buskerud', 'NO', '06', 1),
(1012, 'Nord-Trøndelag', 'NO', '17', 1),
(1013, 'Svalbard', 'NO', '21', 1),
(1014, 'Vest-Agder', 'NO', '10', 1),
(1015, 'Troms', 'NO', '19', 1),
(1016, 'Finnmark', 'NO', '20', 1),
(1017, 'Akershus', 'NO', '02', 1),
(1018, 'Sogn og Fjordane', 'NO', '14', 1),
(1019, 'Hedmark', 'NO', '04', 1),
(1020, 'Møre og Romsdal', 'NO', '15', 1),
(1021, 'Rogaland', 'NO', '11', 1),
(1022, 'Østfold', 'NO', '01', 1),
(1023, 'Hordaland', 'NO', '12', 1),
(1024, 'Telemark', 'NO', '08', 1),
(1025, 'Nordland', 'NO', '18', 1),
(1026, 'Jan Mayen', 'NO', '22', 1),
(1027, 'Hódmezővásárhely', 'HU', 'HV', 1),
(1028, 'Érd', 'HU', 'ER', 1),
(1029, 'Szeged', 'HU', 'SD', 1),
(1030, 'Nagykanizsa', 'HU', 'NK', 1),
(1031, 'Csongrád County', 'HU', 'CS', 1),
(1032, 'Debrecen', 'HU', 'DE', 1),
(1033, 'Székesfehérvár', 'HU', 'SF', 1),
(1034, 'Nyíregyháza', 'HU', 'NY', 1),
(1035, 'Somogy County', 'HU', 'SO', 1),
(1036, 'Békéscsaba', 'HU', 'BC', 1),
(1037, 'Eger', 'HU', 'EG', 1),
(1038, 'Tolna County', 'HU', 'TO', 1),
(1039, 'Vas County', 'HU', 'VA', 1),
(1040, 'Heves County', 'HU', 'HE', 1),
(1041, 'Győr', 'HU', 'GY', 1),
(1042, 'Győr-Moson-Sopron County', 'HU', 'GS', 1),
(1043, 'Jász-Nagykun-Szolnok County', 'HU', 'JN', 1),
(1044, 'Fejér County', 'HU', 'FE', 1),
(1045, 'Szabolcs-Szatmár-Bereg County', 'HU', 'SZ', 1),
(1046, 'Zala County', 'HU', 'ZA', 1),
(1047, 'Szolnok', 'HU', 'SK', 1),
(1048, 'Bács-Kiskun', 'HU', 'BK', 1),
(1049, 'Dunaújváros', 'HU', 'DU', 1),
(1050, 'Zalaegerszeg', 'HU', 'ZE', 1),
(1051, 'Nógrád County', 'HU', 'NO', 1),
(1052, 'Szombathely', 'HU', 'SH', 1),
(1053, 'Pécs', 'HU', 'PS', 1),
(1054, 'Veszprém County', 'HU', 'VE', 1),
(1055, 'Baranya', 'HU', 'BA', 1),
(1056, 'Kecskemét', 'HU', 'KM', 1),
(1057, 'Sopron', 'HU', 'SN', 1),
(1058, 'Borsod-Abaúj-Zemplén', 'HU', 'BZ', 1),
(1059, 'Pest County', 'HU', 'PE', 1),
(1060, 'Békés', 'HU', 'BE', 1),
(1061, 'Szekszárd', 'HU', 'SS', 1),
(1062, 'Veszprém', 'HU', 'VM', 1),
(1063, 'Hajdú-Bihar County', 'HU', 'HB', 1),
(1064, 'Budapest', 'HU', 'BU', 1),
(1065, 'Miskolc', 'HU', 'MI', 1),
(1066, 'Tatabánya', 'HU', 'TB', 1),
(1067, 'Kaposvár', 'HU', 'KV', 1),
(1068, 'Salgótarján', 'HU', 'ST', 1),
(1069, 'Tipperary', 'IE', 'TA', 1),
(1070, 'Sligo', 'IE', 'SO', 1),
(1071, 'Donegal', 'IE', 'DL', 1),
(1072, 'Dublin', 'IE', 'D', 1),
(1073, 'Leinster', 'IE', 'L', 1),
(1074, 'Cork', 'IE', 'CO', 1),
(1075, 'Monaghan', 'IE', 'MN', 1),
(1076, 'Longford', 'IE', 'LD', 1),
(1077, 'Kerry', 'IE', 'KY', 1),
(1078, 'Offaly', 'IE', 'OY', 1),
(1079, 'Galway', 'IE', 'G', 1),
(1080, 'Munster', 'IE', 'M', 1),
(1081, 'Roscommon', 'IE', 'RN', 1),
(1082, 'Kildare', 'IE', 'KE', 1),
(1083, 'Louth', 'IE', 'LH', 1),
(1084, 'Mayo', 'IE', 'MO', 1),
(1085, 'Wicklow', 'IE', 'WW', 1),
(1086, 'Ulster', 'IE', 'U', 1),
(1087, 'Connacht', 'IE', 'C', 1),
(1088, 'Cavan', 'IE', 'CN', 1),
(1089, 'Waterford', 'IE', 'WD', 1),
(1090, 'Kilkenny', 'IE', 'KK', 1),
(1091, 'Clare', 'IE', 'CE', 1),
(1092, 'Meath', 'IE', 'MH', 1),
(1093, 'Wexford', 'IE', 'WX', 1),
(1094, 'Limerick', 'IE', 'LK', 1),
(1095, 'Carlow', 'IE', 'CW', 1),
(1096, 'Laois', 'IE', 'LS', 1),
(1097, 'Westmeath', 'IE', 'WH', 1),
(1098, 'Djelfa', 'DZ', '17', 1),
(1099, 'El Oued', 'DZ', '39', 1),
(1100, 'El Tarf', 'DZ', '36', 1),
(1101, 'Oran', 'DZ', '31', 1),
(1102, 'Naama', 'DZ', '45', 1),
(1103, 'Annaba', 'DZ', '23', 1),
(1104, 'Bouïra', 'DZ', '10', 1),
(1105, 'Chlef', 'DZ', '02', 1),
(1106, 'Tiaret', 'DZ', '14', 1),
(1107, 'Tlemcen', 'DZ', '13', 1),
(1108, 'Béchar', 'DZ', '08', 1),
(1109, 'Médéa', 'DZ', '26', 1),
(1110, 'Skikda', 'DZ', '21', 1),
(1111, 'Blida', 'DZ', '09', 1),
(1112, 'Illizi', 'DZ', '33', 1),
(1113, 'Jijel', 'DZ', '18', 1),
(1114, 'Biskra', 'DZ', '07', 1),
(1115, 'Tipasa', 'DZ', '42', 1),
(1116, 'Bordj Bou Arréridj', 'DZ', '34', 1),
(1117, 'Tébessa', 'DZ', '12', 1),
(1118, 'Adrar', 'DZ', '01', 1),
(1119, 'Aïn Defla', 'DZ', '44', 1),
(1120, 'Tindouf', 'DZ', '37', 1),
(1121, 'Constantine', 'DZ', '25', 1),
(1122, 'Aïn Témouchent', 'DZ', '46', 1),
(1123, 'Saïda', 'DZ', '20', 1),
(1124, 'Mascara', 'DZ', '29', 1),
(1125, 'Boumerdès', 'DZ', '35', 1),
(1126, 'Khenchela', 'DZ', '40', 1),
(1127, 'Ghardaïa', 'DZ', '47', 1),
(1128, 'Béjaïa', 'DZ', '06', 1),
(1129, 'El Bayadh', 'DZ', '32', 1),
(1130, 'Relizane', 'DZ', '48', 1),
(1131, 'Tizi Ouzou', 'DZ', '15', 1),
(1132, 'Mila', 'DZ', '43', 1),
(1133, 'Tissemsilt', 'DZ', '38', 1),
(1134, 'M\'Sila', 'DZ', '28', 1),
(1135, 'Tamanghasset', 'DZ', '11', 1),
(1136, 'Oum El Bouaghi', 'DZ', '04', 1),
(1137, 'Guelma', 'DZ', '24', 1),
(1138, 'Laghouat', 'DZ', '03', 1),
(1139, 'Ouargla', 'DZ', '30', 1),
(1140, 'Mostaganem', 'DZ', '27', 1),
(1141, 'Sétif', 'DZ', '19', 1),
(1142, 'Batna', 'DZ', '05', 1),
(1143, 'Souk Ahras', 'DZ', '41', 1),
(1144, 'Algiers', 'DZ', '16', 1),
(1146, 'Burgos', 'ES', 'BU', 1),
(1147, 'Salamanca', 'ES', 'SA', 1),
(1157, 'Palencia', 'ES', 'P', 1),
(1158, 'Madrid', 'ES', 'M', 1),
(1160, 'Asturias', 'ES', 'O', 1),
(1161, 'Zamora', 'ES', 'ZA', 1),
(1167, 'Pontevedra', 'ES', 'PO', 1),
(1170, 'Cantabria', 'ES', 'S', 1),
(1171, 'La Rioja', 'ES', 'LO', 1),
(1174, 'Balearic Islands', 'ES', 'PM', 1),
(1175, 'Valencia', 'ES', 'V', 1),
(1176, 'Murcia', 'ES', 'MU', 1),
(1177, 'Huesca', 'ES', 'HU', 1),
(1183, 'Valladolid', 'ES', 'VA', 1),
(1185, 'Las Palmas', 'ES', 'GC', 1),
(1189, 'Ávila', 'ES', 'AV', 1),
(1190, 'Caceres', 'ES', 'CC', 1),
(1191, 'Gipuzkoa', 'ES', 'SS', 1),
(1192, 'Segovia', 'ES', 'SG', 1),
(1193, 'Sevilla', 'ES', 'SE', 1),
(1200, 'Léon', 'ES', 'LE', 1),
(1203, 'Tarragona', 'ES', 'T', 1),
(1204, 'Navarra', 'ES', 'NA', 1),
(1205, 'Toledo', 'ES', 'TO', 1),
(1208, 'Soria', 'ES', 'SO', 1),
(1209, 'Guanacaste Province', 'CR', 'G', 1),
(1210, 'Puntarenas Province', 'CR', 'P', 1),
(1211, 'Provincia de Cartago', 'CR', 'C', 1),
(1212, 'Heredia Province', 'CR', 'H', 1),
(1213, 'Limón Province', 'CR', 'L', 1),
(1214, 'San José Province', 'CR', 'SJ', 1),
(1215, 'Alajuela Province', 'CR', 'A', 1),
(1216, 'Brunei-Muara District', 'BN', 'BM', 1),
(1217, 'Belait District', 'BN', 'BE', 1),
(1218, 'Temburong District', 'BN', 'TE', 1),
(1219, 'Tutong District', 'BN', 'TU', 1),
(1220, 'Saint Philip', 'BB', '10', 1),
(1221, 'Saint Lucy', 'BB', '07', 1),
(1222, 'Saint Peter', 'BB', '09', 1),
(1223, 'Saint Joseph', 'BB', '06', 1),
(1224, 'Saint James', 'BB', '04', 1),
(1225, 'Saint Thomas', 'BB', '11', 1),
(1226, 'Saint George', 'BB', '03', 1),
(1227, 'Saint John', 'BB', '05', 1),
(1228, 'Christ Church', 'BB', '01', 1),
(1229, 'Saint Andrew', 'BB', '02', 1),
(1230, 'Saint Michael', 'BB', '08', 1),
(1231, 'Ta\'izz', 'YE', 'TA', 1),
(1232, 'Sana\'a', 'YE', 'SA', 1),
(1233, 'Ibb', 'YE', 'IB', 1),
(1234, 'Ma\'rib', 'YE', 'MA', 1),
(1235, 'Al Mahwit', 'YE', 'MW', 1),
(1236, 'Sana\'a', 'YE', 'SN', 1),
(1237, 'Abyan', 'YE', 'AB', 1),
(1238, 'Hadhramaut', 'YE', 'HD', 1),
(1239, 'Socotra', 'YE', 'SU', 1),
(1240, 'Al Bayda\'', 'YE', 'BA', 1),
(1241, 'Al Hudaydah', 'YE', 'HU', 1),
(1242, '\'Adan', 'YE', 'AD', 1),
(1243, 'Al Jawf', 'YE', 'JA', 1),
(1244, 'Hajjah', 'YE', 'HJ', 1),
(1245, 'Lahij', 'YE', 'LA', 1),
(1246, 'Dhamar', 'YE', 'DH', 1),
(1247, 'Shabwah', 'YE', 'SH', 1),
(1248, 'Raymah', 'YE', 'RA', 1),
(1249, 'Saada', 'YE', 'SD', 1),
(1250, '\'Amran', 'YE', 'AM', 1),
(1251, 'Al Mahrah', 'YE', 'MR', 1),
(1252, 'Sangha-Mbaéré', 'CF', 'SE', 1),
(1253, 'Nana-Grébizi Economic Prefecture', 'CF', 'KB', 1),
(1254, 'Ouham Prefecture', 'CF', 'AC', 1),
(1255, 'Ombella-M\'Poko Prefecture', 'CF', 'MP', 1),
(1256, 'Lobaye Prefecture', 'CF', 'LB', 1),
(1257, 'Mambéré-Kadéï', 'CF', 'HS', 1),
(1258, 'Haut-Mbomou Prefecture', 'CF', 'HM', 1),
(1259, 'Bamingui-Bangoran Prefecture', 'CF', 'BB', 1),
(1260, 'Nana-Mambéré Prefecture', 'CF', 'NM', 1),
(1261, 'Vakaga Prefecture', 'CF', 'VK', 1),
(1262, 'Bangui', 'CF', 'BGF', 1),
(1263, 'Kémo Prefecture', 'CF', 'KG', 1),
(1264, 'Basse-Kotto Prefecture', 'CF', 'BK', 1),
(1265, 'Ouaka Prefecture', 'CF', 'UK', 1),
(1266, 'Mbomou Prefecture', 'CF', 'MB', 1),
(1267, 'Ouham-Pendé Prefecture', 'CF', 'OP', 1),
(1268, 'Haute-Kotto Prefecture', 'CF', 'HK', 1),
(1269, 'Romblon', 'PH', 'ROM', 1),
(1270, 'Bukidnon', 'PH', 'BUK', 1),
(1271, 'Rizal', 'PH', 'RIZ', 1),
(1272, 'Bohol', 'PH', 'BOH', 1),
(1273, 'Quirino', 'PH', 'QUI', 1),
(1274, 'Biliran', 'PH', 'BIL', 1),
(1275, 'Quezon', 'PH', 'QUE', 1),
(1276, 'Siquijor', 'PH', 'SIG', 1),
(1277, 'Sarangani', 'PH', 'SAR', 1),
(1278, 'Bulacan', 'PH', 'BUL', 1),
(1279, 'Cagayan', 'PH', 'CAG', 1),
(1280, 'South Cotabato', 'PH', 'SCO', 1),
(1281, 'Sorsogon', 'PH', 'SOR', 1),
(1282, 'Sultan Kudarat', 'PH', 'SUK', 1),
(1283, 'Camarines Norte', 'PH', 'CAN', 1),
(1284, 'Southern Leyte', 'PH', 'SLE', 1),
(1285, 'Camiguin', 'PH', 'CAM', 1),
(1286, 'Surigao del Norte', 'PH', 'SUN', 1),
(1287, 'Camarines Sur', 'PH', 'CAS', 1),
(1288, 'Sulu', 'PH', 'SLU', 1),
(1289, 'Davao Oriental', 'PH', 'DAO', 1),
(1290, 'Eastern Samar', 'PH', 'EAS', 1),
(1291, 'Dinagat Islands', 'PH', 'DIN', 1),
(1292, 'Capiz', 'PH', 'CAP', 1),
(1293, 'Tawi-Tawi', 'PH', 'TAW', 1),
(1294, 'Calabarzon', 'PH', '40', 1),
(1295, 'Tarlac', 'PH', 'TAR', 1),
(1296, 'Surigao del Sur', 'PH', 'SUR', 1),
(1297, 'Zambales', 'PH', 'ZMB', 1),
(1298, 'Ilocos Norte', 'PH', 'ILN', 1),
(1299, 'Mimaropa', 'PH', '41', 1),
(1300, 'Ifugao', 'PH', 'IFU', 1),
(1301, 'Catanduanes', 'PH', 'CAT', 1),
(1302, 'Zamboanga del Norte', 'PH', 'ZAN', 1),
(1303, 'Guimaras', 'PH', 'GUI', 1),
(1304, 'Bicol', 'PH', '05', 1),
(1305, 'Western Visayas', 'PH', '06', 1),
(1306, 'Cebu', 'PH', 'CEB', 1),
(1307, 'Cavite', 'PH', 'CAV', 1),
(1308, 'Central Visayas', 'PH', '07', 1),
(1309, 'Davao Occidental', 'PH', 'DVO', 1),
(1310, 'Soccsksargen', 'PH', '12', 1),
(1311, 'Compostela Valley', 'PH', 'COM', 1),
(1312, 'Kalinga', 'PH', 'KAL', 1),
(1313, 'Isabela', 'PH', 'ISA', 1),
(1314, 'Caraga', 'PH', '13', 1),
(1315, 'Iloilo', 'PH', 'ILI', 1),
(1316, 'Autonomous Region in Muslim Mindanao', 'PH', '14', 1),
(1317, 'La Union', 'PH', 'LUN', 1),
(1318, 'Davao del Sur', 'PH', 'DAS', 1),
(1319, 'Davao del Norte', 'PH', 'DAV', 1),
(1320, 'Cotabato', 'PH', 'NCO', 1),
(1321, 'Ilocos Sur', 'PH', 'ILS', 1),
(1322, 'Eastern Visayas', 'PH', '08', 1),
(1323, 'Agusan del Norte', 'PH', 'AGN', 1),
(1324, 'Abra', 'PH', 'ABR', 1),
(1325, 'Zamboanga Peninsula', 'PH', '09', 1),
(1326, 'Agusan del Sur', 'PH', 'AGS', 1),
(1327, 'Lanao del Norte', 'PH', 'LAN', 1),
(1328, 'Laguna', 'PH', 'LAG', 1),
(1329, 'Marinduque', 'PH', 'MAD', 1),
(1330, 'Maguindanao', 'PH', 'MAG', 1),
(1331, 'Aklan', 'PH', 'AKL', 1),
(1332, 'Leyte', 'PH', 'LEY', 1),
(1333, 'Lanao del Sur', 'PH', 'LAS', 1),
(1334, 'Apayao', 'PH', 'APA', 1),
(1335, 'Cordillera Administrative', 'PH', '15', 1),
(1336, 'Antique', 'PH', 'ANT', 1),
(1337, 'Albay', 'PH', 'ALB', 1),
(1338, 'Masbate', 'PH', 'MAS', 1),
(1339, 'Northern Mindanao', 'PH', '10', 1),
(1340, 'Davao', 'PH', '11', 1),
(1341, 'Aurora', 'PH', 'AUR', 1),
(1342, 'Cagayan Valley', 'PH', '02', 1),
(1343, 'Misamis Occidental', 'PH', 'MSC', 1),
(1344, 'Bataan', 'PH', 'BAN', 1),
(1345, 'Central Luzon', 'PH', '03', 1),
(1346, 'Basilan', 'PH', 'BAS', 1),
(1347, 'Metro Manila', 'PH', 'NCR', 1),
(1348, 'Misamis Oriental', 'PH', 'MSR', 1),
(1349, 'Northern Samar', 'PH', 'NSA', 1),
(1350, 'Negros Oriental', 'PH', 'NER', 1),
(1351, 'Negros Occidental', 'PH', 'NEC', 1),
(1352, 'Batanes', 'PH', 'BTN', 1),
(1353, 'Mountain Province', 'PH', 'MOU', 1),
(1354, 'Oriental Mindoro', 'PH', 'MDR', 1),
(1355, 'Ilocos', 'PH', '01', 1),
(1356, 'Occidental Mindoro', 'PH', 'MDC', 1),
(1357, 'Zamboanga del Sur', 'PH', 'ZAS', 1),
(1358, 'Nueva Vizcaya', 'PH', 'NUV', 1),
(1359, 'Batangas', 'PH', 'BTG', 1),
(1360, 'Nueva Ecija', 'PH', 'NUE', 1),
(1361, 'Palawan', 'PH', 'PLW', 1),
(1362, 'Zamboanga Sibugay', 'PH', 'ZSI', 1),
(1363, 'Benguet', 'PH', 'BEN', 1),
(1364, 'Pangasinan', 'PH', 'PAN', 1),
(1365, 'Pampanga', 'PH', 'PAM', 1),
(1366, 'Northern District', 'IL', 'Z', 1),
(1367, 'Central District', 'IL', 'M', 1),
(1368, 'Southern District', 'IL', 'D', 1),
(1369, 'Haifa District', 'IL', 'HA', 1),
(1370, 'Jerusalem District', 'IL', 'JM', 1),
(1371, 'Tel Aviv District', 'IL', 'TA', 1),
(1372, 'Limburg', 'BE', 'VLI', 1),
(1373, 'Flanders', 'BE', 'VLG', 1),
(1374, 'Flemish Brabant', 'BE', 'VBR', 1),
(1375, 'Hainaut', 'BE', 'WHT', 1),
(1376, 'Brussels-Capital Region', 'BE', 'BRU', 1),
(1377, 'East Flanders', 'BE', 'VOV', 1),
(1378, 'Namur', 'BE', 'WNA', 1),
(1379, 'Luxembourg', 'BE', 'WLX', 1);
INSERT INTO `state` (`id`, `name`, `country_code`, `iso2`, `exists`) VALUES
(1380, 'Wallonia', 'BE', 'WAL', 1),
(1381, 'Antwerp', 'BE', 'VAN', 1),
(1382, 'Walloon Brabant', 'BE', 'WBR', 1),
(1383, 'West Flanders', 'BE', 'VWV', 1),
(1384, 'Liège', 'BE', 'WLG', 1),
(1385, 'Darién Province', 'PA', '5', 1),
(1386, 'Colón Province', 'PA', '3', 1),
(1387, 'Coclé Province', 'PA', '2', 1),
(1388, 'Guna Yala', 'PA', 'KY', 1),
(1389, 'Herrera Province', 'PA', '6', 1),
(1390, 'Los Santos Province', 'PA', '7', 1),
(1391, 'Ngöbe-Buglé Comarca', 'PA', 'NB', 1),
(1392, 'Veraguas Province', 'PA', '9', 1),
(1393, 'Bocas del Toro Province', 'PA', '1', 1),
(1394, 'Panamá Oeste Province', 'PA', '10', 1),
(1395, 'Panamá Province', 'PA', '8', 1),
(1396, 'Emberá-Wounaan Comarca', 'PA', 'EM', 1),
(1397, 'Chiriquí Province', 'PA', '4', 1),
(1398, 'Howland Island', 'US', 'UM-84', 1),
(1399, 'Delaware', 'US', 'DE', 1),
(1400, 'Alaska', 'US', 'AK', 1),
(1401, 'Maryland', 'US', 'MD', 1),
(1402, 'Baker Island', 'US', 'UM-81', 1),
(1403, 'Kingman Reef', 'US', 'UM-89', 1),
(1404, 'New Hampshire', 'US', 'NH', 1),
(1405, 'Wake Island', 'US', 'UM-79', 1),
(1406, 'Kansas', 'US', 'KS', 1),
(1407, 'Texas', 'US', 'TX', 1),
(1408, 'Nebraska', 'US', 'NE', 1),
(1409, 'Vermont', 'US', 'VT', 1),
(1410, 'Jarvis Island', 'US', 'UM-86', 1),
(1411, 'Hawaii', 'US', 'HI', 1),
(1412, 'Guam', 'US', 'GU', 1),
(1413, 'United States Virgin Islands', 'US', 'VI', 1),
(1414, 'Utah', 'US', 'UT', 1),
(1415, 'Oregon', 'US', 'OR', 1),
(1416, 'California', 'US', 'CA', 1),
(1417, 'New Jersey', 'US', 'NJ', 1),
(1418, 'North Dakota', 'US', 'ND', 1),
(1419, 'Kentucky', 'US', 'KY', 1),
(1420, 'Minnesota', 'US', 'MN', 1),
(1421, 'Oklahoma', 'US', 'OK', 1),
(1422, 'Pennsylvania', 'US', 'PA', 1),
(1423, 'New Mexico', 'US', 'NM', 1),
(1424, 'American Samoa', 'US', 'AS', 1),
(1425, 'Illinois', 'US', 'IL', 1),
(1426, 'Michigan', 'US', 'MI', 1),
(1427, 'Virginia', 'US', 'VA', 1),
(1428, 'Johnston Atoll', 'US', 'UM-67', 1),
(1429, 'West Virginia', 'US', 'WV', 1),
(1430, 'Mississippi', 'US', 'MS', 1),
(1431, 'Northern Mariana Islands', 'US', 'MP', 1),
(1432, 'United States Minor Outlying Islands', 'US', 'UM', 1),
(1433, 'Massachusetts', 'US', 'MA', 1),
(1434, 'Arizona', 'US', 'AZ', 1),
(1435, 'Connecticut', 'US', 'CT', 1),
(1436, 'Florida', 'US', 'FL', 1),
(1437, 'District of Columbia', 'US', 'DC', 1),
(1438, 'Midway Atoll', 'US', 'UM-71', 1),
(1439, 'Navassa Island', 'US', 'UM-76', 1),
(1440, 'Indiana', 'US', 'IN', 1),
(1441, 'Wisconsin', 'US', 'WI', 1),
(1442, 'Wyoming', 'US', 'WY', 1),
(1443, 'South Carolina', 'US', 'SC', 1),
(1444, 'Arkansas', 'US', 'AR', 1),
(1445, 'South Dakota', 'US', 'SD', 1),
(1446, 'Montana', 'US', 'MT', 1),
(1447, 'North Carolina', 'US', 'NC', 1),
(1448, 'Palmyra Atoll', 'US', 'UM-95', 1),
(1449, 'Puerto Rico', 'US', 'PR', 1),
(1450, 'Colorado', 'US', 'CO', 1),
(1451, 'Missouri', 'US', 'MO', 1),
(1452, 'New York', 'US', 'NY', 1),
(1453, 'Maine', 'US', 'ME', 1),
(1454, 'Tennessee', 'US', 'TN', 1),
(1455, 'Georgia', 'US', 'GA', 1),
(1456, 'Alabama', 'US', 'AL', 1),
(1457, 'Louisiana', 'US', 'LA', 1),
(1458, 'Nevada', 'US', 'NV', 1),
(1459, 'Iowa', 'US', 'IA', 1),
(1460, 'Idaho', 'US', 'ID', 1),
(1461, 'Rhode Island', 'US', 'RI', 1),
(1462, 'Washington', 'US', 'WA', 1),
(1463, 'Shinyanga', 'TZ', '22', 1),
(1464, 'Simiyu', 'TZ', '30', 1),
(1465, 'Kagera', 'TZ', '05', 1),
(1466, 'Dodoma', 'TZ', '03', 1),
(1467, 'Kilimanjaro', 'TZ', '09', 1),
(1468, 'Mara', 'TZ', '13', 1),
(1469, 'Tabora', 'TZ', '24', 1),
(1470, 'Morogoro', 'TZ', '16', 1),
(1471, 'Zanzibar South', 'TZ', '11', 1),
(1472, 'Pemba South', 'TZ', '10', 1),
(1473, 'Zanzibar North', 'TZ', '07', 1),
(1474, 'Singida', 'TZ', '23', 1),
(1475, 'Zanzibar West', 'TZ', '15', 1),
(1476, 'Mtwara', 'TZ', '17', 1),
(1477, 'Rukwa', 'TZ', '20', 1),
(1478, 'Kigoma', 'TZ', '08', 1),
(1479, 'Mwanza', 'TZ', '18', 1),
(1480, 'Njombe', 'TZ', '29', 1),
(1481, 'Geita', 'TZ', '27', 1),
(1482, 'Katavi', 'TZ', '28', 1),
(1483, 'Lindi', 'TZ', '12', 1),
(1484, 'Manyara', 'TZ', '26', 1),
(1485, 'Pwani', 'TZ', '19', 1),
(1486, 'Ruvuma', 'TZ', '21', 1),
(1487, 'Tanga', 'TZ', '25', 1),
(1488, 'Pemba North', 'TZ', '06', 1),
(1489, 'Iringa', 'TZ', '04', 1),
(1490, 'Dar es Salaam', 'TZ', '02', 1),
(1491, 'Arusha', 'TZ', '01', 1),
(1493, 'Tavastia Proper', 'FI', '06', 1),
(1494, 'Central Ostrobothnia', 'FI', '07', 1),
(1495, 'Southern Savonia', 'FI', '04', 1),
(1496, 'Kainuu', 'FI', '05', 1),
(1497, 'South Karelia', 'FI', '02', 1),
(1498, 'Southern Ostrobothnia', 'FI', '03', 1),
(1500, 'Lapland', 'FI', '10', 1),
(1501, 'Satakunta', 'FI', '17', 1),
(1502, 'Päijänne Tavastia', 'FI', '16', 1),
(1503, 'Northern Savonia', 'FI', '15', 1),
(1504, 'North Karelia', 'FI', '13', 1),
(1505, 'Northern Ostrobothnia', 'FI', '14', 1),
(1506, 'Pirkanmaa', 'FI', '11', 1),
(1507, 'Finland Proper', 'FI', '19', 1),
(1508, 'Ostrobothnia', 'FI', '12', 1),
(1509, 'Åland Islands', 'FI', '01', 1),
(1510, 'Uusimaa', 'FI', '18', 1),
(1511, 'Central Finland', 'FI', '08', 1),
(1512, 'Kymenlaakso', 'FI', '09', 1),
(1513, 'Canton of Diekirch', 'LU', 'DI', 1),
(1514, 'Luxembourg District', 'LU', 'L', 1),
(1515, 'Canton of Echternach', 'LU', 'EC', 1),
(1516, 'Canton of Redange', 'LU', 'RD', 1),
(1517, 'Canton of Esch-sur-Alzette', 'LU', 'ES', 1),
(1518, 'Canton of Capellen', 'LU', 'CA', 1),
(1519, 'Canton of Remich', 'LU', 'RM', 1),
(1520, 'Grevenmacher District', 'LU', 'G', 1),
(1521, 'Canton of Clervaux', 'LU', 'CL', 1),
(1522, 'Canton of Mersch', 'LU', 'ME', 1),
(1523, 'Canton of Vianden', 'LU', 'VD', 1),
(1524, 'Diekirch District', 'LU', 'D', 1),
(1525, 'Canton of Grevenmacher', 'LU', 'GR', 1),
(1526, 'Canton of Wiltz', 'LU', 'WI', 1),
(1527, 'Canton of Luxembourg', 'LU', 'LU', 1),
(1528, 'Region Zealand', 'DK', '85', 1),
(1529, 'Region of Southern Denmark', 'DK', '83', 1),
(1530, 'Capital Region of Denmark', 'DK', '84', 1),
(1531, 'Central Denmark Region', 'DK', '82', 1),
(1532, 'North Denmark Region', 'DK', '81', 1),
(1533, 'Gävleborg County', 'SE', 'X', 1),
(1534, 'Dalarna County', 'SE', 'W', 1),
(1535, 'Värmland County', 'SE', 'S', 1),
(1536, 'Östergötland County', 'SE', 'E', 1),
(1537, 'Blekinge', 'SE', 'K', 1),
(1538, 'Norrbotten County', 'SE', 'BD', 1),
(1539, 'Örebro County', 'SE', 'T', 1),
(1540, 'Södermanland County', 'SE', 'D', 1),
(1541, 'Skåne County', 'SE', 'M', 1),
(1542, 'Kronoberg County', 'SE', 'G', 1),
(1543, 'Västerbotten County', 'SE', 'AC', 1),
(1544, 'Kalmar County', 'SE', 'H', 1),
(1545, 'Uppsala County', 'SE', 'C', 1),
(1546, 'Gotland County', 'SE', 'I', 1),
(1547, 'Västra Götaland County', 'SE', 'O', 1),
(1548, 'Halland County', 'SE', 'N', 1),
(1549, 'Västmanland County', 'SE', 'U', 1),
(1550, 'Jönköping County', 'SE', 'F', 1),
(1551, 'Stockholm County', 'SE', 'AB', 1),
(1552, 'Västernorrland County', 'SE', 'Y', 1),
(1553, 'Plungė District Municipality', 'LT', '35', 1),
(1554, 'Šiauliai District Municipality', 'LT', '44', 1),
(1555, 'Jurbarkas District Municipality', 'LT', '12', 1),
(1556, 'Kaunas County', 'LT', 'KU', 1),
(1557, 'Mažeikiai District Municipality', 'LT', '26', 1),
(1558, 'Panevėžys County', 'LT', 'PN', 1),
(1559, 'Elektrėnai municipality', 'LT', '08', 1),
(1560, 'Švenčionys District Municipality', 'LT', '49', 1),
(1561, 'Akmenė District Municipality', 'LT', '01', 1),
(1562, 'Ignalina District Municipality', 'LT', '09', 1),
(1563, 'Neringa Municipality', 'LT', '28', 1),
(1564, 'Visaginas Municipality', 'LT', '59', 1),
(1565, 'Kaunas District Municipality', 'LT', '16', 1),
(1566, 'Biržai District Municipality', 'LT', '06', 1),
(1567, 'Jonava District Municipality', 'LT', '10', 1),
(1568, 'Radviliškis District Municipality', 'LT', '37', 1),
(1569, 'Telšiai County', 'LT', 'TE', 1),
(1570, 'Marijampolė County', 'LT', 'MR', 1),
(1571, 'Kretinga District Municipality', 'LT', '22', 1),
(1572, 'Tauragė District Municipality', 'LT', '50', 1),
(1573, 'Tauragė County', 'LT', 'TA', 1),
(1574, 'Alytus County', 'LT', 'AL', 1),
(1575, 'Kazlų Rūda municipality', 'LT', '17', 1),
(1576, 'Šakiai District Municipality', 'LT', '41', 1),
(1577, 'Šalčininkai District Municipality', 'LT', '42', 1),
(1578, 'Prienai District Municipality', 'LT', '36', 1),
(1579, 'Druskininkai municipality', 'LT', '07', 1),
(1580, 'Kaunas City Municipality', 'LT', '15', 1),
(1581, 'Joniškis District Municipality', 'LT', '11', 1),
(1582, 'Molėtai District Municipality', 'LT', '27', 1),
(1583, 'Kaišiadorys District Municipality', 'LT', '13', 1),
(1584, 'Kėdainiai District Municipality', 'LT', '18', 1),
(1585, 'Kupiškis District Municipality', 'LT', '23', 1),
(1586, 'Šiauliai County', 'LT', 'SA', 1),
(1587, 'Raseiniai District Municipality', 'LT', '38', 1),
(1588, 'Palanga City Municipality', 'LT', '31', 1),
(1589, 'Panevėžys City Municipality', 'LT', '32', 1),
(1590, 'Rietavas municipality', 'LT', '39', 1),
(1591, 'Kalvarija municipality', 'LT', '14', 1),
(1592, 'Vilnius District Municipality', 'LT', '58', 1),
(1593, 'Trakai District Municipality', 'LT', '52', 1),
(1594, 'Širvintos District Municipality', 'LT', '47', 1),
(1595, 'Pakruojis District Municipality', 'LT', '30', 1),
(1596, 'Ukmergė District Municipality', 'LT', '53', 1),
(1597, 'Klaipeda City Municipality', 'LT', '20', 1),
(1598, 'Utena District Municipality', 'LT', '54', 1),
(1599, 'Alytus District Municipality', 'LT', '03', 1),
(1600, 'Klaipėda County', 'LT', 'KL', 1),
(1601, 'Vilnius County', 'LT', 'VL', 1),
(1602, 'Varėna District Municipality', 'LT', '55', 1),
(1603, 'Birštonas Municipality', 'LT', '05', 1),
(1604, 'Klaipėda District Municipality', 'LT', '21', 1),
(1605, 'Alytus City Municipality', 'LT', '02', 1),
(1606, 'Vilnius City Municipality', 'LT', '57', 1),
(1607, 'Šilutė District Municipality', 'LT', '46', 1),
(1608, 'Telšiai District Municipality', 'LT', '51', 1),
(1609, 'Šiauliai City Municipality', 'LT', '43', 1),
(1610, 'Marijampolė Municipality', 'LT', '25', 1),
(1611, 'Lazdijai District Municipality', 'LT', '24', 1),
(1612, 'Pagėgiai municipality', 'LT', '29', 1),
(1613, 'Šilalė District Municipality', 'LT', '45', 1),
(1614, 'Panevėžys District Municipality', 'LT', '33', 1),
(1615, 'Rokiškis District Municipality', 'LT', '40', 1),
(1616, 'Pasvalys District Municipality', 'LT', '34', 1),
(1617, 'Skuodas District Municipality', 'LT', '48', 1),
(1618, 'Kelmė District Municipality', 'LT', '19', 1),
(1619, 'Zarasai District Municipality', 'LT', '60', 1),
(1620, 'Vilkaviškis District Municipality', 'LT', '56', 1),
(1621, 'Utena County', 'LT', 'UT', 1),
(1622, 'Opole Voivodeship', 'PL', 'OP', 1),
(1623, 'Silesian Voivodeship', 'PL', 'SL', 1),
(1624, 'Pomeranian Voivodeship', 'PL', 'PM', 1),
(1625, 'Kuyavian-Pomeranian Voivodeship', 'PL', 'KP', 1),
(1626, 'Podkarpackie Voivodeship', 'PL', 'PK', 1),
(1628, 'Warmian-Masurian Voivodeship', 'PL', 'WN', 1),
(1629, 'Lower Silesian Voivodeship', 'PL', 'DS', 1),
(1630, 'Świętokrzyskie Voivodeship', 'PL', 'SK', 1),
(1631, 'Lubusz Voivodeship', 'PL', 'LB', 1),
(1632, 'Podlaskie Voivodeship', 'PL', 'PD', 1),
(1633, 'West Pomeranian Voivodeship', 'PL', 'ZP', 1),
(1634, 'Greater Poland Voivodeship', 'PL', 'WP', 1),
(1635, 'Lesser Poland Voivodeship', 'PL', 'MA', 1),
(1636, 'Łódź Voivodeship', 'PL', 'LD', 1),
(1637, 'Masovian Voivodeship', 'PL', 'MZ', 1),
(1638, 'Lublin Voivodeship', 'PL', 'LU', 1),
(1639, 'Aargau', 'CH', 'AG', 1),
(1640, 'Fribourg', 'CH', 'FR', 1),
(1641, 'Basel-Land', 'CH', 'BL', 1),
(1642, 'Uri', 'CH', 'UR', 1),
(1643, 'Ticino', 'CH', 'TI', 1),
(1644, 'St. Gallen', 'CH', 'SG', 1),
(1645, 'Bern', 'CH', 'BE', 1),
(1646, 'Zug', 'CH', 'ZG', 1),
(1647, 'Geneva', 'CH', 'GE', 1),
(1648, 'Valais', 'CH', 'VS', 1),
(1649, 'Appenzell Innerrhoden', 'CH', 'AI', 1),
(1650, 'Obwalden', 'CH', 'OW', 1),
(1651, 'Vaud', 'CH', 'VD', 1),
(1652, 'Nidwalden', 'CH', 'NW', 1),
(1653, 'Schwyz', 'CH', 'SZ', 1),
(1654, 'Schaffhausen', 'CH', 'SH', 1),
(1655, 'Appenzell Ausserrhoden', 'CH', 'AR', 1),
(1656, 'Zürich', 'CH', 'ZH', 1),
(1657, 'Thurgau', 'CH', 'TG', 1),
(1658, 'Jura', 'CH', 'JU', 1),
(1659, 'Neuchâtel', 'CH', 'NE', 1),
(1660, 'Graubünden', 'CH', 'GR', 1),
(1661, 'Glarus', 'CH', 'GL', 1),
(1662, 'Solothurn', 'CH', 'SO', 1),
(1663, 'Lucerne', 'CH', 'LU', 1),
(1664, 'Tuscany', 'IT', '52', 1),
(1665, 'Padua', 'IT', 'PD', 1),
(1666, 'Parma', 'IT', 'PR', 1),
(1667, 'Siracusa', 'IT', 'SR', 1),
(1668, 'Palermo', 'IT', 'PA', 1),
(1669, 'Campania', 'IT', '72', 1),
(1670, 'Marche', 'IT', '57', 1),
(1671, 'Reggio Calabria', 'IT', 'RC', 1),
(1672, 'Ancona', 'IT', 'AN', 1),
(1673, 'Venice', 'IT', 'VE', 1),
(1674, 'Latina', 'IT', 'LT', 1),
(1675, 'Lecce', 'IT', 'LE', 1),
(1676, 'Pavia', 'IT', 'PV', 1),
(1677, 'Lecco', 'IT', 'LC', 1),
(1678, 'Lazio', 'IT', '62', 1),
(1679, 'Abruzzo', 'IT', '65', 1),
(1680, 'Florence', 'IT', 'FI', 1),
(1681, 'Ascoli Piceno', 'IT', 'AP', 1),
(1682, 'Cagliari', 'IT', 'CA', 1),
(1683, 'Umbria', 'IT', '55', 1),
(1684, 'Bologna', 'IT', 'BO', 1),
(1685, 'Pisa', 'IT', 'PI', 1),
(1686, 'Barletta-Andria-Trani', 'IT', 'BT', 1),
(1687, 'Pistoia', 'IT', 'PT', 1),
(1688, 'Apulia', 'IT', '75', 1),
(1689, 'Belluno', 'IT', 'BL', 1),
(1690, 'Pordenone', 'IT', 'PN', 1),
(1691, 'Perugia', 'IT', 'PG', 1),
(1692, 'Avellino', 'IT', 'AV', 1),
(1693, 'Pesaro and Urbino', 'IT', 'PU', 1),
(1694, 'Pescara', 'IT', 'PE', 1),
(1695, 'Molise', 'IT', '67', 1),
(1696, 'Piacenza', 'IT', 'PC', 1),
(1697, 'Potenza', 'IT', 'PZ', 1),
(1698, 'Milan', 'IT', 'MI', 1),
(1699, 'Genoa', 'IT', 'GE', 1),
(1700, 'Prato', 'IT', 'PO', 1),
(1701, 'Benevento', 'IT', 'BN', 1),
(1702, 'Piedmont', 'IT', '21', 1),
(1703, 'Calabria', 'IT', '78', 1),
(1704, 'Bergamo', 'IT', 'BG', 1),
(1705, 'Lombardy', 'IT', '25', 1),
(1706, 'Basilicata', 'IT', '77', 1),
(1707, 'Ravenna', 'IT', 'RA', 1),
(1708, 'Reggio Emilia', 'IT', 'RE', 1),
(1709, 'Sicily', 'IT', '82', 1),
(1710, 'Turin', 'IT', 'TO', 1),
(1711, 'Rome', 'IT', 'RM', 1),
(1712, 'Rieti', 'IT', 'RI', 1),
(1713, 'Rimini', 'IT', 'RN', 1),
(1714, 'Brindisi', 'IT', 'BR', 1),
(1715, 'Sardinia', 'IT', '88', 1),
(1716, 'Aosta Valley', 'IT', '23', 1),
(1717, 'Brescia', 'IT', 'BS', 1),
(1718, 'Caltanissetta', 'IT', 'CL', 1),
(1719, 'Rovigo', 'IT', 'RO', 1),
(1720, 'Salerno', 'IT', 'SA', 1),
(1721, 'Campobasso', 'IT', 'CB', 1),
(1722, 'Sassari', 'IT', 'SS', 1),
(1723, 'Enna', 'IT', 'EN', 1),
(1724, 'Naples', 'IT', 'NA', 1),
(1725, 'Trentino-South Tyrol', 'IT', '32', 1),
(1726, 'Verbano-Cusio-Ossola', 'IT', 'VB', 1),
(1727, 'Agrigento', 'IT', 'AG', 1),
(1728, 'Catanzaro', 'IT', 'CZ', 1),
(1729, 'Ragusa', 'IT', 'RG', 1),
(1730, 'South Sardinia', 'IT', 'SU', 1),
(1731, 'Caserta', 'IT', 'CE', 1),
(1732, 'Savona', 'IT', 'SV', 1),
(1733, 'Trapani', 'IT', 'TP', 1),
(1734, 'Siena', 'IT', 'SI', 1),
(1735, 'Viterbo', 'IT', 'VT', 1),
(1736, 'Verona', 'IT', 'VR', 1),
(1737, 'Vibo Valentia', 'IT', 'VV', 1),
(1738, 'Vicenza', 'IT', 'VI', 1),
(1739, 'Chieti', 'IT', 'CH', 1),
(1740, 'Como', 'IT', 'CO', 1),
(1741, 'Sondrio', 'IT', 'SO', 1),
(1742, 'Cosenza', 'IT', 'CS', 1),
(1743, 'Taranto', 'IT', 'TA', 1),
(1744, 'Fermo', 'IT', 'FM', 1),
(1745, 'Livorno', 'IT', 'LI', 1),
(1746, 'Ferrara', 'IT', 'FE', 1),
(1747, 'Lodi', 'IT', 'LO', 1),
(1748, 'Trentino', 'IT', 'TN', 1),
(1749, 'Lucca', 'IT', 'LU', 1),
(1750, 'Macerata', 'IT', 'MC', 1),
(1751, 'Cremona', 'IT', 'CR', 1),
(1752, 'Teramo', 'IT', 'TE', 1),
(1753, 'Veneto', 'IT', '34', 1),
(1754, 'Crotone', 'IT', 'KR', 1),
(1755, 'Terni', 'IT', 'TR', 1),
(1756, 'Friuli–Venezia Giulia', 'IT', '36', 1),
(1757, 'Modena', 'IT', 'MO', 1),
(1758, 'Mantua', 'IT', 'MN', 1),
(1759, 'Massa and Carrara', 'IT', 'MS', 1),
(1760, 'Matera', 'IT', 'MT', 1),
(1761, 'Medio Campidano', 'IT', 'VS', 1),
(1762, 'Treviso', 'IT', 'TV', 1),
(1763, 'Trieste', 'IT', 'TS', 1),
(1764, 'Udine', 'IT', 'UD', 1),
(1765, 'Varese', 'IT', 'VA', 1),
(1766, 'Catania', 'IT', 'CT', 1),
(1767, 'South Tyrol', 'IT', 'BZ', 1),
(1768, 'Liguria', 'IT', '42', 1),
(1769, 'Monza and Brianza', 'IT', 'MB', 1),
(1770, 'Messina', 'IT', 'ME', 1),
(1771, 'Foggia', 'IT', 'FG', 1),
(1772, 'Bari', 'IT', 'BA', 1),
(1773, 'Emilia-Romagna', 'IT', '45', 1),
(1774, 'Novara', 'IT', 'NO', 1),
(1775, 'Cuneo', 'IT', 'CN', 1),
(1776, 'Frosinone', 'IT', 'FR', 1),
(1777, 'Gorizia', 'IT', 'GO', 1),
(1778, 'Biella', 'IT', 'BI', 1),
(1779, 'Forlì-Cesena', 'IT', 'FC', 1),
(1780, 'Asti', 'IT', 'AT', 1),
(1781, 'L\'Aquila', 'IT', 'AQ', 1),
(1783, 'Alessandria', 'IT', 'AL', 1),
(1785, 'Vercelli', 'IT', 'VC', 1),
(1786, 'Oristano', 'IT', 'OR', 1),
(1787, 'Grosseto', 'IT', 'GR', 1),
(1788, 'Imperia', 'IT', 'IM', 1),
(1789, 'Isernia', 'IT', 'IS', 1),
(1790, 'Nuoro', 'IT', 'NU', 1),
(1791, 'La Spezia', 'IT', 'SP', 1),
(1792, 'Sumatera Utara', 'ID', 'SU', 1),
(1793, 'Bengkulu', 'ID', 'BE', 1),
(1794, 'Kalimantan Tengah', 'ID', 'KT', 1),
(1795, 'Sulawesi Selatan', 'ID', 'SN', 1),
(1796, 'Sulawesi Tenggara', 'ID', 'SG', 1),
(1798, 'Papua', 'ID', 'PA', 1),
(1799, 'Papua Barat', 'ID', 'PB', 1),
(1800, 'Maluku', 'ID', 'MA', 1),
(1801, 'Maluku Utara', 'ID', 'MU', 1),
(1802, 'Jawa Tengah', 'ID', 'JT', 1),
(1804, 'Kalimantan Timur', 'ID', 'KI', 1),
(1805, 'DKI Jakarta', 'ID', 'JK', 1),
(1806, 'Kalimantan Barat', 'ID', 'KB', 1),
(1807, 'Kepulauan Riau', 'ID', 'KR', 1),
(1808, 'Sulawesi Utara', 'ID', 'SA', 1),
(1809, 'Riau', 'ID', 'RI', 1),
(1810, 'Banten', 'ID', 'BT', 1),
(1811, 'Lampung', 'ID', 'LA', 1),
(1812, 'Gorontalo', 'ID', 'GO', 1),
(1813, 'Sulawesi Tengah', 'ID', 'ST', 1),
(1814, 'Nusa Tenggara Barat', 'ID', 'NB', 1),
(1815, 'Jambi', 'ID', 'JA', 1),
(1816, 'Sumatera Selatan', 'ID', 'SS', 1),
(1817, 'Sulawesi Barat', 'ID', 'SR', 1),
(1818, 'Nusa Tenggara Timur', 'ID', 'NT', 1),
(1819, 'Kalimantan Selatan', 'ID', 'KS', 1),
(1820, 'Kepulauan Bangka Belitung', 'ID', 'BB', 1),
(1822, 'Aceh', 'ID', 'AC', 1),
(1824, 'Kalimantan Utara', 'ID', 'KU', 1),
(1825, 'Jawa Barat', 'ID', 'JB', 1),
(1826, 'Bali', 'ID', 'BA', 1),
(1827, 'Jawa Timur', 'ID', 'JI', 1),
(1828, 'Sumatera Barat', 'ID', 'SB', 1),
(1829, 'DI Yogyakarta', 'ID', 'YO', 1),
(1830, 'Phoenix Islands', 'KI', 'P', 1),
(1831, 'Gilbert Islands', 'KI', 'G', 1),
(1832, 'Line Islands', 'KI', 'L', 1),
(1833, 'Primorsky Krai', 'RU', 'PRI', 1),
(1834, 'Novgorod Oblast', 'RU', 'NGR', 1),
(1835, 'Jewish Autonomous Oblast', 'RU', 'YEV', 1),
(1836, 'Nenets Autonomous Okrug', 'RU', 'NEN', 1),
(1837, 'Rostov Oblast', 'RU', 'ROS', 1),
(1838, 'Khanty-Mansi Autonomous Okrug', 'RU', 'KHM', 1),
(1839, 'Magadan Oblast', 'RU', 'MAG', 1),
(1840, 'Krasnoyarsk Krai', 'RU', 'KYA', 1),
(1841, 'Republic of Karelia', 'RU', 'KR', 1),
(1842, 'Republic of Buryatia', 'RU', 'BU', 1),
(1843, 'Murmansk Oblast', 'RU', 'MUR', 1),
(1844, 'Kaluga Oblast', 'RU', 'KLU', 1),
(1845, 'Chelyabinsk Oblast', 'RU', 'CHE', 1),
(1846, 'Omsk Oblast', 'RU', 'OMS', 1),
(1847, 'Yamalo-Nenets Autonomous Okrug', 'RU', 'YAN', 1),
(1848, 'Sakha Republic', 'RU', 'SA', 1),
(1849, 'Arkhangelsk', 'RU', 'ARK', 1),
(1850, 'Republic of Dagestan', 'RU', 'DA', 1),
(1851, 'Yaroslavl Oblast', 'RU', 'YAR', 1),
(1852, 'Republic of Adygea', 'RU', 'AD', 1),
(1853, 'Republic of North Ossetia-Alania', 'RU', 'SE', 1),
(1854, 'Republic of Bashkortostan', 'RU', 'BA', 1),
(1855, 'Kursk Oblast', 'RU', 'KRS', 1),
(1856, 'Ulyanovsk Oblast', 'RU', 'ULY', 1),
(1857, 'Nizhny Novgorod Oblast', 'RU', 'NIZ', 1),
(1858, 'Amur Oblast', 'RU', 'AMU', 1),
(1859, 'Chukotka Autonomous Okrug', 'RU', 'CHU', 1),
(1860, 'Tver Oblast', 'RU', 'TVE', 1),
(1861, 'Republic of Tatarstan', 'RU', 'TA', 1),
(1862, 'Samara Oblast', 'RU', 'SAM', 1),
(1863, 'Pskov Oblast', 'RU', 'PSK', 1),
(1864, 'Ivanovo Oblast', 'RU', 'IVA', 1),
(1865, 'Kamchatka Krai', 'RU', 'KAM', 1),
(1866, 'Astrakhan Oblast', 'RU', 'AST', 1),
(1867, 'Bryansk Oblast', 'RU', 'BRY', 1),
(1868, 'Stavropol Krai', 'RU', 'STA', 1),
(1869, 'Karachay-Cherkess Republic', 'RU', 'KC', 1),
(1870, 'Mari El Republic', 'RU', 'ME', 1),
(1871, 'Perm Krai', 'RU', 'PER', 1),
(1872, 'Tomsk Oblast', 'RU', 'TOM', 1),
(1873, 'Khabarovsk Krai', 'RU', 'KHA', 1),
(1874, 'Vologda Oblast', 'RU', 'VLG', 1),
(1875, 'Sakhalin', 'RU', 'SAK', 1),
(1876, 'Altai Republic', 'RU', 'AL', 1),
(1877, 'Republic of Khakassia', 'RU', 'KK', 1),
(1878, 'Tambov Oblast', 'RU', 'TAM', 1),
(1879, 'Saint Petersburg', 'RU', 'SPE', 1),
(1880, 'Irkutsk', 'RU', 'IRK', 1),
(1881, 'Vladimir Oblast', 'RU', 'VLA', 1),
(1882, 'Moscow Oblast', 'RU', 'MOS', 1),
(1883, 'Republic of Kalmykia', 'RU', 'KL', 1),
(1884, 'Republic of Ingushetia', 'RU', 'IN', 1),
(1885, 'Smolensk Oblast', 'RU', 'SMO', 1),
(1886, 'Orenburg Oblast', 'RU', 'ORE', 1),
(1887, 'Saratov Oblast', 'RU', 'SAR', 1),
(1888, 'Novosibirsk', 'RU', 'NVS', 1),
(1889, 'Lipetsk Oblast', 'RU', 'LIP', 1),
(1890, 'Kirov Oblast', 'RU', 'KIR', 1),
(1891, 'Krasnodar Krai', 'RU', 'KDA', 1),
(1892, 'Kabardino-Balkar Republic', 'RU', 'KB', 1),
(1893, 'Chechen Republic', 'RU', 'CE', 1),
(1894, 'Sverdlovsk', 'RU', 'SVE', 1),
(1895, 'Tula Oblast', 'RU', 'TUL', 1),
(1896, 'Leningrad Oblast', 'RU', 'LEN', 1),
(1897, 'Kemerovo Oblast', 'RU', 'KEM', 1),
(1898, 'Republic of Mordovia', 'RU', 'MO', 1),
(1899, 'Komi Republic', 'RU', 'KO', 1),
(1900, 'Tuva Republic', 'RU', 'TY', 1),
(1901, 'Moscow', 'RU', 'MOW', 1),
(1902, 'Kaliningrad', 'RU', 'KGD', 1),
(1903, 'Belgorod Oblast', 'RU', 'BEL', 1),
(1904, 'Zabaykalsky Krai', 'RU', 'ZAB', 1),
(1905, 'Ryazan Oblast', 'RU', 'RYA', 1),
(1906, 'Voronezh Oblast', 'RU', 'VOR', 1),
(1907, 'Tyumen Oblast', 'RU', 'TYU', 1),
(1908, 'Oryol Oblast', 'RU', 'ORL', 1),
(1909, 'Penza Oblast', 'RU', 'PNZ', 1),
(1910, 'Kostroma Oblast', 'RU', 'KOS', 1),
(1911, 'Altai Krai', 'RU', 'ALT', 1),
(1912, 'Sevastopol', 'RU', 'UA-40', 1),
(1913, 'Udmurt Republic', 'RU', 'UD', 1),
(1914, 'Chuvash Republic', 'RU', 'CU', 1),
(1915, 'Kurgan Oblast', 'RU', 'KGN', 1),
(1916, 'Lomaiviti', 'FJ', '06', 1),
(1917, 'Ba', 'FJ', '01', 1),
(1918, 'Tailevu', 'FJ', '14', 1),
(1919, 'Nadroga-Navosa', 'FJ', '08', 1),
(1920, 'Rewa', 'FJ', '12', 1),
(1921, 'Northern Division', 'FJ', 'N', 1),
(1922, 'Macuata', 'FJ', '07', 1),
(1923, 'Western Division', 'FJ', 'W', 1),
(1924, 'Cakaudrove', 'FJ', '03', 1),
(1925, 'Serua', 'FJ', '13', 1),
(1926, 'Ra', 'FJ', '11', 1),
(1927, 'Naitasiri', 'FJ', '09', 1),
(1928, 'Namosi', 'FJ', '10', 1),
(1929, 'Central Division', 'FJ', 'C', 1),
(1930, 'Bua', 'FJ', '02', 1),
(1931, 'Rotuma', 'FJ', 'R', 1),
(1932, 'Eastern Division', 'FJ', 'E', 1),
(1933, 'Lau', 'FJ', '05', 1),
(1934, 'Kadavu', 'FJ', '04', 1),
(1935, 'Labuan', 'MY', '15', 1),
(1936, 'Sabah', 'MY', '12', 1),
(1937, 'Sarawak', 'MY', '13', 1),
(1938, 'Perlis', 'MY', '09', 1),
(1939, 'Penang', 'MY', '07', 1),
(1940, 'Pahang', 'MY', '06', 1),
(1941, 'Malacca', 'MY', '04', 1),
(1942, 'Terengganu', 'MY', '11', 1),
(1943, 'Perak', 'MY', '08', 1),
(1944, 'Selangor', 'MY', '10', 1),
(1945, 'Putrajaya', 'MY', '16', 1),
(1946, 'Kelantan', 'MY', '03', 1),
(1947, 'Kedah', 'MY', '02', 1),
(1948, 'Negeri Sembilan', 'MY', '05', 1),
(1949, 'Kuala Lumpur', 'MY', '14', 1),
(1950, 'Johor', 'MY', '01', 1),
(1951, 'Mashonaland East Province', 'ZW', 'ME', 1),
(1952, 'Matabeleland South Province', 'ZW', 'MS', 1),
(1953, 'Mashonaland West Province', 'ZW', 'MW', 1),
(1954, 'Matabeleland North Province', 'ZW', 'MN', 1),
(1955, 'Mashonaland Central Province', 'ZW', 'MC', 1),
(1956, 'Bulawayo Province', 'ZW', 'BU', 1),
(1957, 'Midlands Province', 'ZW', 'MI', 1),
(1958, 'Harare Province', 'ZW', 'HA', 1),
(1959, 'Manicaland', 'ZW', 'MA', 1),
(1960, 'Masvingo Province', 'ZW', 'MV', 1),
(1961, 'Bulgan Province', 'MN', '067', 1),
(1962, 'Darkhan-Uul Province', 'MN', '037', 1),
(1963, 'Dornod Province', 'MN', '061', 1),
(1964, 'Khovd Province', 'MN', '043', 1),
(1965, 'Övörkhangai Province', 'MN', '055', 1),
(1966, 'Orkhon Province', 'MN', '035', 1),
(1967, 'Ömnögovi Province', 'MN', '053', 1),
(1968, 'Töv Province', 'MN', '047', 1),
(1969, 'Bayan-Ölgii Province', 'MN', '071', 1),
(1970, 'Dundgovi Province', 'MN', '059', 1),
(1971, 'Uvs Province', 'MN', '046', 1),
(1972, 'Govi-Altai Province', 'MN', '065', 1),
(1973, 'Arkhangai Province', 'MN', '073', 1),
(1974, 'Khentii Province', 'MN', '039', 1),
(1975, 'Khövsgöl Province', 'MN', '041', 1),
(1976, 'Bayankhongor Province', 'MN', '069', 1),
(1977, 'Sükhbaatar Province', 'MN', '051', 1),
(1978, 'Govisümber Province', 'MN', '064', 1),
(1979, 'Zavkhan Province', 'MN', '057', 1),
(1980, 'Selenge Province', 'MN', '049', 1),
(1981, 'Dornogovi Province', 'MN', '063', 1),
(1982, 'Northern Province', 'ZM', '05', 1),
(1983, 'Western Province', 'ZM', '01', 1),
(1984, 'Copperbelt Province', 'ZM', '08', 1),
(1985, 'Northwestern Province', 'ZM', '06', 1),
(1986, 'Central Province', 'ZM', '02', 1),
(1987, 'Luapula Province', 'ZM', '04', 1),
(1988, 'Lusaka Province', 'ZM', '09', 1),
(1989, 'Muchinga Province', 'ZM', '10', 1),
(1990, 'Southern Province', 'ZM', '07', 1),
(1991, 'Eastern Province', 'ZM', '03', 1),
(1992, 'Capital', 'BH', '13', 1),
(1993, 'Southern', 'BH', '14', 1),
(1994, 'Northern', 'BH', '17', 1),
(1995, 'Muharraq', 'BH', '15', 1),
(1996, 'Central', 'BH', '16', 1),
(1997, 'Rio de Janeiro', 'BR', 'RJ', 1),
(1998, 'Minas Gerais', 'BR', 'MG', 1),
(1999, 'Amapá', 'BR', 'AP', 1),
(2000, 'Goiás', 'BR', 'GO', 1),
(2001, 'Rio Grande do Sul', 'BR', 'RS', 1),
(2002, 'Bahia', 'BR', 'BA', 1),
(2003, 'Sergipe', 'BR', 'SE', 1),
(2004, 'Amazonas', 'BR', 'AM', 1),
(2005, 'Paraíba', 'BR', 'PB', 1),
(2006, 'Pernambuco', 'BR', 'PE', 1),
(2007, 'Alagoas', 'BR', 'AL', 1),
(2008, 'Piauí', 'BR', 'PI', 1),
(2009, 'Pará', 'BR', 'PA', 1),
(2010, 'Mato Grosso do Sul', 'BR', 'MS', 1),
(2011, 'Mato Grosso', 'BR', 'MT', 1),
(2012, 'Acre', 'BR', 'AC', 1),
(2013, 'Rondônia', 'BR', 'RO', 1),
(2014, 'Santa Catarina', 'BR', 'SC', 1),
(2015, 'Maranhão', 'BR', 'MA', 1),
(2016, 'Ceará', 'BR', 'CE', 1),
(2017, 'Distrito Federal', 'BR', 'DF', 1),
(2018, 'Espírito Santo', 'BR', 'ES', 1),
(2019, 'Rio Grande do Norte', 'BR', 'RN', 1),
(2020, 'Tocantins', 'BR', 'TO', 1),
(2021, 'São Paulo', 'BR', 'SP', 1),
(2022, 'Paraná', 'BR', 'PR', 1),
(2023, 'Aragatsotn Region', 'AM', 'AG', 1),
(2024, 'Ararat Province', 'AM', 'AR', 1),
(2025, 'Vayots Dzor Region', 'AM', 'VD', 1),
(2026, 'Armavir Region', 'AM', 'AV', 1),
(2027, 'Syunik Province', 'AM', 'SU', 1),
(2028, 'Gegharkunik Province', 'AM', 'GR', 1),
(2029, 'Lori Region', 'AM', 'LO', 1),
(2030, 'Yerevan', 'AM', 'ER', 1),
(2031, 'Shirak Region', 'AM', 'SH', 1),
(2032, 'Tavush Region', 'AM', 'TV', 1),
(2033, 'Kotayk Region', 'AM', 'KT', 1),
(2034, 'Cojedes', 'VE', 'H', 1),
(2035, 'Falcón', 'VE', 'I', 1),
(2036, 'Portuguesa', 'VE', 'P', 1),
(2037, 'Miranda', 'VE', 'M', 1),
(2038, 'Lara', 'VE', 'K', 1),
(2039, 'Bolívar', 'VE', 'F', 1),
(2040, 'Carabobo', 'VE', 'G', 1),
(2041, 'Yaracuy', 'VE', 'U', 1),
(2042, 'Zulia', 'VE', 'V', 1),
(2043, 'Trujillo', 'VE', 'T', 1),
(2044, 'Amazonas', 'VE', 'Z', 1),
(2045, 'Guárico', 'VE', 'J', 1),
(2046, 'Federal Dependencies of Venezuela', 'VE', 'W', 1),
(2047, 'Aragua', 'VE', 'D', 1),
(2048, 'Táchira', 'VE', 'S', 1),
(2049, 'Barinas', 'VE', 'E', 1),
(2050, 'Anzoátegui', 'VE', 'B', 1),
(2051, 'Delta Amacuro', 'VE', 'Y', 1),
(2052, 'Nueva Esparta', 'VE', 'O', 1),
(2053, 'Mérida', 'VE', 'L', 1),
(2054, 'Monagas', 'VE', 'N', 1),
(2055, 'La Guaira', 'VE', 'X', 1),
(2056, 'Sucre', 'VE', 'R', 1),
(2057, 'Carinthia', 'AT', '2', 1),
(2058, 'Upper Austria', 'AT', '4', 1),
(2059, 'Styria', 'AT', '6', 1),
(2060, 'Vienna', 'AT', '9', 1),
(2061, 'Salzburg', 'AT', '5', 1),
(2062, 'Burgenland', 'AT', '1', 1),
(2063, 'Vorarlberg', 'AT', '8', 1),
(2064, 'Tyrol', 'AT', '7', 1),
(2065, 'Lower Austria', 'AT', '3', 1),
(2066, 'Mid-Western Region', 'NP', '2', 1),
(2067, 'Western Region', 'NP', '3', 1),
(2068, 'Far-Western Development Region', 'NP', '5', 1),
(2069, 'Eastern Development Region', 'NP', '4', 1),
(2070, 'Mechi Zone', 'NP', 'ME', 1),
(2071, 'Bheri Zone', 'NP', 'BH', 1),
(2072, 'Kosi Zone', 'NP', 'KO', 1),
(2073, 'Central Region', 'NP', '1', 1),
(2074, 'Lumbini Zone', 'NP', 'LU', 1),
(2075, 'Narayani Zone', 'NP', 'NA', 1),
(2076, 'Janakpur Zone', 'NP', 'JA', 1),
(2077, 'Rapti Zone', 'NP', 'RA', 1),
(2078, 'Seti Zone', 'NP', 'SE', 1),
(2079, 'Karnali Zone', 'NP', 'KA', 1),
(2080, 'Dhaulagiri Zone', 'NP', 'DH', 1),
(2081, 'Gandaki Zone', 'NP', 'GA', 1),
(2082, 'Bagmati Zone', 'NP', 'BA', 1),
(2083, 'Mahakali Zone', 'NP', 'MA', 1),
(2084, 'Sagarmatha Zone', 'NP', 'SA', 1),
(2085, 'Unity', 'SS', 'UY', 1),
(2086, 'Upper Nile', 'SS', 'NU', 1),
(2087, 'Warrap', 'SS', 'WR', 1),
(2088, 'Northern Bahr el Ghazal', 'SS', 'BN', 1),
(2089, 'Western Equatoria', 'SS', 'EW', 1),
(2090, 'Lakes', 'SS', 'LK', 1),
(2091, 'Western Bahr el Ghazal', 'SS', 'BW', 1),
(2092, 'Central Equatoria', 'SS', 'EC', 1),
(2093, 'Eastern Equatoria', 'SS', 'EE', 1),
(2094, 'Jonglei State', 'SS', 'JG', 1),
(2095, 'Karditsa Regional Unit', 'GR', '41', 1),
(2096, 'West Greece Region', 'GR', 'G', 1),
(2097, 'Thessaloniki Regional Unit', 'GR', '54', 1),
(2098, 'Arcadia Prefecture', 'GR', '12', 1),
(2099, 'Imathia Regional Unit', 'GR', '53', 1),
(2100, 'Kastoria Regional Unit', 'GR', '56', 1),
(2101, 'Euboea', 'GR', '04', 1),
(2102, 'Grevena Prefecture', 'GR', '51', 1),
(2103, 'Preveza Prefecture', 'GR', '34', 1),
(2104, 'Lefkada Regional Unit', 'GR', '24', 1),
(2105, 'Argolis Regional Unit', 'GR', '11', 1),
(2106, 'Laconia', 'GR', '16', 1),
(2107, 'Pella Regional Unit', 'GR', '59', 1),
(2108, 'West Macedonia Region', 'GR', 'C', 1),
(2109, 'Crete Region', 'GR', 'M', 1),
(2110, 'Epirus Region', 'GR', 'D', 1),
(2111, 'Kilkis Regional Unit', 'GR', '57', 1),
(2112, 'Kozani Prefecture', 'GR', '58', 1),
(2113, 'Ioannina Regional Unit', 'GR', '33', 1),
(2114, 'Phthiotis Prefecture', 'GR', '06', 1),
(2115, 'Chania Regional Unit', 'GR', '94', 1),
(2116, 'Achaea Regional Unit', 'GR', '13', 1),
(2117, 'East Macedonia and Thrace', 'GR', 'A', 1),
(2118, 'South Aegean', 'GR', 'L', 1),
(2119, 'Peloponnese Region', 'GR', 'J', 1),
(2120, 'East Attica Regional Unit', 'GR', 'A2', 1),
(2121, 'Serres Prefecture', 'GR', '62', 1),
(2122, 'Attica Region', 'GR', 'I', 1),
(2123, 'Aetolia-Acarnania Regional Unit', 'GR', '01', 1),
(2124, 'Corfu Prefecture', 'GR', '22', 1),
(2125, 'Central Macedonia', 'GR', 'B', 1),
(2126, 'Boeotia Regional Unit', 'GR', '03', 1),
(2127, 'Kefalonia Prefecture', 'GR', '23', 1),
(2128, 'Central Greece Region', 'GR', 'H', 1),
(2129, 'Corinthia Regional Unit', 'GR', '15', 1),
(2130, 'Drama Regional Unit', 'GR', '52', 1),
(2131, 'Ionian Islands Region', 'GR', 'F', 1),
(2132, 'Larissa Prefecture', 'GR', '42', 1),
(2133, 'Kayin State', 'MM', '13', 1),
(2134, 'Mandalay Region', 'MM', '04', 1),
(2135, 'Yangon Region', 'MM', '06', 1),
(2136, 'Magway Region', 'MM', '03', 1),
(2137, 'Chin State', 'MM', '14', 1),
(2138, 'Rakhine State', 'MM', '16', 1),
(2139, 'Shan State', 'MM', '17', 1),
(2140, 'Tanintharyi Region', 'MM', '05', 1),
(2141, 'Bago', 'MM', '02', 1),
(2142, 'Ayeyarwady Region', 'MM', '07', 1),
(2143, 'Kachin State', 'MM', '11', 1),
(2144, 'Kayah State', 'MM', '12', 1),
(2145, 'Sagaing Region', 'MM', '01', 1),
(2146, 'Naypyidaw Union Territory', 'MM', '18', 1),
(2147, 'Mon State', 'MM', '15', 1),
(2148, 'Bartın', 'TR', '74', 1),
(2149, 'Kütahya', 'TR', '43', 1),
(2150, 'Sakarya', 'TR', '54', 1),
(2151, 'Edirne', 'TR', '22', 1),
(2152, 'Van', 'TR', '65', 1),
(2153, 'Bingöl', 'TR', '12', 1),
(2154, 'Kilis', 'TR', '79', 1),
(2155, 'Adıyaman', 'TR', '02', 1),
(2156, 'Mersin', 'TR', '33', 1),
(2157, 'Denizli', 'TR', '20', 1),
(2158, 'Malatya', 'TR', '44', 1),
(2159, 'Elazığ', 'TR', '23', 1),
(2160, 'Erzincan', 'TR', '24', 1),
(2161, 'Amasya', 'TR', '05', 1),
(2162, 'Muş', 'TR', '49', 1),
(2163, 'Bursa', 'TR', '16', 1),
(2164, 'Eskişehir', 'TR', '26', 1),
(2165, 'Erzurum', 'TR', '25', 1),
(2166, 'Iğdır', 'TR', '76', 1),
(2167, 'Tekirdağ', 'TR', '59', 1),
(2168, 'Çankırı', 'TR', '18', 1),
(2169, 'Antalya', 'TR', '07', 1),
(2170, 'Istanbul', 'TR', '34', 1),
(2171, 'Konya', 'TR', '42', 1),
(2172, 'Bolu', 'TR', '14', 1),
(2173, 'Çorum', 'TR', '19', 1),
(2174, 'Ordu', 'TR', '52', 1),
(2175, 'Balıkesir', 'TR', '10', 1),
(2176, 'Kırklareli', 'TR', '39', 1),
(2177, 'Bayburt', 'TR', '69', 1),
(2178, 'Kırıkkale', 'TR', '71', 1),
(2179, 'Afyonkarahisar', 'TR', '03', 1),
(2180, 'Kırşehir', 'TR', '40', 1),
(2181, 'Sivas', 'TR', '58', 1),
(2182, 'Muğla', 'TR', '48', 1),
(2183, 'Şanlıurfa', 'TR', '63', 1),
(2184, 'Karaman', 'TR', '70', 1),
(2185, 'Ardahan', 'TR', '75', 1),
(2186, 'Giresun', 'TR', '28', 1),
(2187, 'Aydın', 'TR', '09', 1),
(2188, 'Yozgat', 'TR', '66', 1),
(2189, 'Niğde', 'TR', '51', 1),
(2190, 'Hakkâri', 'TR', '30', 1),
(2191, 'Artvin', 'TR', '08', 1),
(2192, 'Tunceli', 'TR', '62', 1),
(2193, 'Ağrı', 'TR', '04', 1),
(2194, 'Batman', 'TR', '72', 1),
(2195, 'Kocaeli', 'TR', '41', 1),
(2196, 'Nevşehir', 'TR', '50', 1),
(2197, 'Kastamonu', 'TR', '37', 1),
(2198, 'Manisa', 'TR', '45', 1),
(2199, 'Tokat', 'TR', '60', 1),
(2200, 'Kayseri', 'TR', '38', 1),
(2201, 'Uşak', 'TR', '64', 1),
(2202, 'Düzce', 'TR', '81', 1),
(2203, 'Gaziantep', 'TR', '27', 1),
(2204, 'Gümüşhane', 'TR', '29', 1),
(2205, 'İzmir', 'TR', '35', 1),
(2206, 'Trabzon', 'TR', '61', 1),
(2207, 'Siirt', 'TR', '56', 1),
(2208, 'Kars', 'TR', '36', 1),
(2209, 'Burdur', 'TR', '15', 1),
(2210, 'Aksaray', 'TR', '68', 1),
(2211, 'Hatay', 'TR', '31', 1),
(2212, 'Adana', 'TR', '01', 1),
(2213, 'Zonguldak', 'TR', '67', 1),
(2214, 'Osmaniye', 'TR', '80', 1),
(2215, 'Bitlis', 'TR', '13', 1),
(2216, 'Çanakkale', 'TR', '17', 1),
(2217, 'Ankara', 'TR', '06', 1),
(2218, 'Yalova', 'TR', '77', 1),
(2219, 'Rize', 'TR', '53', 1),
(2220, 'Samsun', 'TR', '55', 1),
(2221, 'Bilecik', 'TR', '11', 1),
(2222, 'Isparta', 'TR', '32', 1),
(2223, 'Karabük', 'TR', '78', 1),
(2224, 'Mardin', 'TR', '47', 1),
(2225, 'Şırnak', 'TR', '73', 1),
(2226, 'Diyarbakır', 'TR', '21', 1),
(2227, 'Kahramanmaraş', 'TR', '46', 1),
(2228, 'Lisbon', 'PT', '11', 1),
(2229, 'Bragança', 'PT', '04', 1),
(2230, 'Beja', 'PT', '02', 1),
(2231, 'Madeira', 'PT', '30', 1),
(2232, 'Portalegre', 'PT', '12', 1),
(2233, 'Açores', 'PT', '20', 1),
(2234, 'Vila Real', 'PT', '17', 1),
(2235, 'Aveiro', 'PT', '01', 1),
(2236, 'Évora', 'PT', '07', 1),
(2237, 'Viseu', 'PT', '18', 1),
(2238, 'Santarém', 'PT', '14', 1),
(2239, 'Faro', 'PT', '08', 1),
(2240, 'Leiria', 'PT', '10', 1),
(2241, 'Castelo Branco', 'PT', '05', 1),
(2242, 'Setúbal', 'PT', '15', 1),
(2243, 'Porto', 'PT', '13', 1),
(2244, 'Braga', 'PT', '03', 1),
(2245, 'Viana do Castelo', 'PT', '16', 1),
(2246, 'Coimbra', 'PT', '06', 1),
(2247, 'Zhejiang', 'CN', 'ZJ', 1),
(2248, 'Fujian', 'CN', 'FJ', 1),
(2249, 'Shanghai', 'CN', 'SH', 1),
(2250, 'Jiangsu', 'CN', 'JS', 1),
(2251, 'Anhui', 'CN', 'AH', 1),
(2252, 'Shandong', 'CN', 'SD', 1),
(2253, 'Jilin', 'CN', 'JL', 1),
(2254, 'Shanxi', 'CN', 'SX', 1),
(2255, 'Taiwan', 'CN', 'TW', 1),
(2256, 'Jiangxi', 'CN', 'JX', 1),
(2257, 'Beijing', 'CN', 'BJ', 1),
(2258, 'Hunan', 'CN', 'HN', 1),
(2259, 'Henan', 'CN', 'HA', 1),
(2260, 'Yunnan', 'CN', 'YN', 1),
(2261, 'Guizhou', 'CN', 'GZ', 1),
(2262, 'Ningxia Huizu', 'CN', 'NX', 1),
(2263, 'Xinjiang', 'CN', 'XJ', 1),
(2264, 'Xizang', 'CN', 'XZ', 1),
(2265, 'Heilongjiang', 'CN', 'HL', 1),
(2266, 'Macau SAR', 'CN', 'MO', 1),
(2267, 'Hong Kong SAR', 'CN', 'HK', 1),
(2268, 'Liaoning', 'CN', 'LN', 1),
(2269, 'Inner Mongolia', 'CN', 'NM', 1),
(2270, 'Qinghai', 'CN', 'QH', 1),
(2271, 'Chongqing', 'CN', 'CQ', 1),
(2272, 'Shaanxi', 'CN', 'SN', 1),
(2273, 'Hainan', 'CN', 'HI', 1),
(2274, 'Hubei', 'CN', 'HB', 1),
(2275, 'Gansu', 'CN', 'GS', 1),
(2276, 'Tianjin', 'CN', 'TJ', 1),
(2277, 'Sichuan', 'CN', 'SC', 1),
(2278, 'Guangxi Zhuang', 'CN', 'GX', 1),
(2279, 'Guangdong', 'CN', 'GD', 1),
(2280, 'Hebei', 'CN', 'HE', 1),
(2281, 'South', 'LB', 'JA', 1),
(2282, 'Mount Lebanon', 'LB', 'JL', 1),
(2283, 'Baalbek-Hermel', 'LB', 'BH', 1),
(2284, 'North', 'LB', 'AS', 1),
(2285, 'Akkar', 'LB', 'AK', 1),
(2286, 'Beirut', 'LB', 'BA', 1),
(2287, 'Beqaa', 'LB', 'BI', 1),
(2288, 'Nabatieh', 'LB', 'NA', 1),
(2289, 'Isle of Wight', 'GB', 'IOW', 1),
(2290, 'St Helens', 'GB', 'SHN', 1),
(2291, 'London Borough of Brent', 'GB', 'BEN', 1),
(2292, 'Walsall', 'GB', 'WLL', 1),
(2293, 'Trafford', 'GB', 'TRF', 1),
(2294, 'City of Southampton', 'GB', 'STH', 1),
(2295, 'Sheffield', 'GB', 'SHF', 1),
(2296, 'West Sussex', 'GB', 'WSX', 1),
(2297, 'City of Peterborough', 'GB', 'PTE', 1),
(2298, 'Caerphilly County Borough', 'GB', 'CAY', 1),
(2299, 'Vale of Glamorgan', 'GB', 'VGL', 1),
(2300, 'Shetland Islands', 'GB', 'ZET', 1),
(2301, 'Rhondda Cynon Taf', 'GB', 'RCT', 1),
(2302, 'Poole', 'GB', 'POL', 1),
(2303, 'Central Bedfordshire', 'GB', 'CBF', 1),
(2304, 'Down District Council', 'GB', 'DOW', 1),
(2305, 'City of Portsmouth', 'GB', 'POR', 1),
(2306, 'London Borough of Haringey', 'GB', 'HRY', 1),
(2307, 'London Borough of Bexley', 'GB', 'BEX', 1),
(2308, 'Rotherham', 'GB', 'ROT', 1),
(2309, 'Hartlepool', 'GB', 'HPL', 1),
(2310, 'Telford and Wrekin', 'GB', 'TFW', 1),
(2311, 'Belfast district', 'GB', 'BFS', 1),
(2312, 'Cornwall', 'GB', 'CON', 1),
(2313, 'London Borough of Sutton', 'GB', 'STN', 1),
(2314, 'Omagh District Council', 'GB', 'OMH', 1),
(2315, 'Banbridge', 'GB', 'BNB', 1),
(2316, 'Causeway Coast and Glens', 'GB', 'CCG', 1),
(2317, 'Newtownabbey Borough Council', 'GB', 'NTA', 1),
(2318, 'City of Leicester', 'GB', 'LCE', 1),
(2319, 'London Borough of Islington', 'GB', 'ISL', 1),
(2320, 'Metropolitan Borough of Wigan', 'GB', 'WGN', 1),
(2321, 'Oxfordshire', 'GB', 'OXF', 1),
(2322, 'Magherafelt District Council', 'GB', 'MFT', 1),
(2323, 'Southend-on-Sea', 'GB', 'SOS', 1),
(2324, 'Armagh, Banbridge and Craigavon', 'GB', 'ABC', 1),
(2325, 'Perth and Kinross', 'GB', 'PKN', 1),
(2326, 'London Borough of Waltham Forest', 'GB', 'WFT', 1),
(2327, 'Rochdale', 'GB', 'RCH', 1),
(2328, 'Merthyr Tydfil County Borough', 'GB', 'MTY', 1),
(2329, 'Blackburn with Darwen', 'GB', 'BBD', 1),
(2330, 'Knowsley', 'GB', 'KWL', 1),
(2331, 'Armagh City and District Council', 'GB', 'ARM', 1),
(2332, 'Middlesbrough', 'GB', 'MDB', 1),
(2333, 'East Renfrewshire', 'GB', 'ERW', 1),
(2334, 'Cumbria', 'GB', 'CMA', 1),
(2335, 'Scotland', 'GB', 'SCT', 1),
(2336, 'England', 'GB', 'ENG', 1),
(2337, 'Northern Ireland', 'GB', 'NIR', 1),
(2338, 'Wales', 'GB', 'WLS', 1),
(2339, 'Bath and North East Somerset', 'GB', 'BAS', 1),
(2340, 'Liverpool', 'GB', 'LIV', 1),
(2341, 'Sandwell', 'GB', 'SAW', 1),
(2342, 'Bournemouth', 'GB', 'BMH', 1),
(2343, 'Isles of Scilly', 'GB', 'IOS', 1),
(2344, 'Falkirk', 'GB', 'FAL', 1),
(2345, 'Dorset', 'GB', 'DOR', 1),
(2346, 'Scottish Borders', 'GB', 'SCB', 1),
(2347, 'London Borough of Havering', 'GB', 'HAV', 1),
(2348, 'Moyle District Council', 'GB', 'MYL', 1),
(2349, 'London Borough of Camden', 'GB', 'CMD', 1),
(2350, 'Newry and Mourne District Council', 'GB', 'NYM', 1),
(2351, 'Neath Port Talbot County Borough', 'GB', 'NTL', 1),
(2352, 'Conwy County Borough', 'GB', 'CWY', 1),
(2353, 'Outer Hebrides', 'GB', 'ELS', 1),
(2354, 'West Lothian', 'GB', 'WLN', 1),
(2355, 'Lincolnshire', 'GB', 'LIN', 1),
(2356, 'London Borough of Barking and Dagenham', 'GB', 'BDG', 1),
(2357, 'City of Westminster', 'GB', 'WSM', 1),
(2358, 'London Borough of Lewisham', 'GB', 'LEW', 1),
(2359, 'City of Nottingham', 'GB', 'NGM', 1),
(2360, 'Moray', 'GB', 'MRY', 1),
(2361, 'Ballymoney', 'GB', 'BLY', 1),
(2362, 'South Lanarkshire', 'GB', 'SLK', 1),
(2363, 'Ballymena Borough', 'GB', 'BLA', 1),
(2364, 'Doncaster', 'GB', 'DNC', 1),
(2365, 'Northumberland', 'GB', 'NBL', 1),
(2366, 'Fermanagh and Omagh', 'GB', 'FMO', 1),
(2367, 'Tameside', 'GB', 'TAM', 1),
(2368, 'Royal Borough of Kensington and Chelsea', 'GB', 'KEC', 1),
(2369, 'Hertfordshire', 'GB', 'HRT', 1),
(2370, 'East Riding of Yorkshire', 'GB', 'ERY', 1),
(2371, 'Kirklees', 'GB', 'KIR', 1),
(2372, 'City of Sunderland', 'GB', 'SND', 1),
(2373, 'Gloucestershire', 'GB', 'GLS', 1),
(2374, 'East Ayrshire', 'GB', 'EAY', 1),
(2375, 'United Kingdom', 'GB', 'UKM', 1),
(2376, 'London Borough of Hillingdon', 'GB', 'HIL', 1),
(2377, 'South Ayrshire', 'GB', 'SAY', 1),
(2378, 'Ascension Island', 'GB', 'SH-AC', 1),
(2379, 'Gwynedd', 'GB', 'GWN', 1),
(2380, 'London Borough of Hounslow', 'GB', 'HNS', 1),
(2381, 'Medway', 'GB', 'MDW', 1),
(2382, 'Limavady Borough Council', 'GB', 'LMV', 1),
(2383, 'Highland', 'GB', 'HLD', 1),
(2384, 'North East Lincolnshire', 'GB', 'NEL', 1),
(2385, 'London Borough of Harrow', 'GB', 'HRW', 1),
(2386, 'Somerset', 'GB', 'SOM', 1),
(2387, 'Angus', 'GB', 'ANS', 1),
(2388, 'Inverclyde', 'GB', 'IVC', 1),
(2389, 'Darlington', 'GB', 'DAL', 1),
(2390, 'London Borough of Tower Hamlets', 'GB', 'TWH', 1),
(2391, 'Wiltshire', 'GB', 'WIL', 1),
(2392, 'Argyll and Bute', 'GB', 'AGB', 1),
(2393, 'Strabane District Council', 'GB', 'STB', 1),
(2394, 'Stockport', 'GB', 'SKP', 1),
(2395, 'Brighton and Hove', 'GB', 'BNH', 1),
(2396, 'London Borough of Lambeth', 'GB', 'LBH', 1),
(2397, 'London Borough of Redbridge', 'GB', 'RDB', 1),
(2398, 'Manchester', 'GB', 'MAN', 1),
(2399, 'Mid Ulster', 'GB', 'MUL', 1),
(2400, 'South Gloucestershire', 'GB', 'SGC', 1),
(2401, 'Aberdeenshire', 'GB', 'ABD', 1),
(2402, 'Monmouthshire', 'GB', 'MON', 1),
(2403, 'Derbyshire', 'GB', 'DBY', 1),
(2404, 'Glasgow', 'GB', 'GLG', 1),
(2405, 'Buckinghamshire', 'GB', 'BKM', 1),
(2406, 'County Durham', 'GB', 'DUR', 1),
(2407, 'Shropshire', 'GB', 'SHR', 1),
(2408, 'Wirral', 'GB', 'WRL', 1),
(2409, 'South Tyneside', 'GB', 'STY', 1),
(2410, 'Essex', 'GB', 'ESS', 1),
(2411, 'London Borough of Hackney', 'GB', 'HCK', 1),
(2412, 'Antrim and Newtownabbey', 'GB', 'ANN', 1),
(2413, 'City of Bristol', 'GB', 'BST', 1),
(2414, 'East Sussex', 'GB', 'ESX', 1),
(2415, 'Dumfries and Galloway', 'GB', 'DGY', 1),
(2416, 'Milton Keynes', 'GB', 'MIK', 1),
(2417, 'Derry City Council', 'GB', 'DRY', 1),
(2418, 'London Borough of Newham', 'GB', 'NWM', 1),
(2419, 'Wokingham', 'GB', 'WOK', 1),
(2420, 'Warrington', 'GB', 'WRT', 1),
(2421, 'Stockton-on-Tees', 'GB', 'STT', 1),
(2422, 'Swindon', 'GB', 'SWD', 1),
(2423, 'Cambridgeshire', 'GB', 'CAM', 1),
(2424, 'City of London', 'GB', 'LND', 1),
(2425, 'Birmingham', 'GB', 'BIR', 1),
(2426, 'City of York', 'GB', 'YOR', 1),
(2427, 'Slough', 'GB', 'SLG', 1),
(2428, 'Edinburgh', 'GB', 'EDH', 1),
(2429, 'Mid and East Antrim', 'GB', 'MEA', 1),
(2430, 'North Somerset', 'GB', 'NSM', 1),
(2431, 'Gateshead', 'GB', 'GAT', 1),
(2432, 'London Borough of Southwark', 'GB', 'SWK', 1),
(2433, 'City and County of Swansea', 'GB', 'SWA', 1),
(2434, 'London Borough of Wandsworth', 'GB', 'WND', 1),
(2435, 'Hampshire', 'GB', 'HAM', 1),
(2436, 'Wrexham County Borough', 'GB', 'WRX', 1),
(2437, 'Flintshire', 'GB', 'FLN', 1),
(2438, 'Coventry', 'GB', 'COV', 1),
(2439, 'Carrickfergus Borough Council', 'GB', 'CKF', 1),
(2440, 'West Dunbartonshire', 'GB', 'WDU', 1),
(2441, 'Powys', 'GB', 'POW', 1),
(2442, 'Cheshire West and Chester', 'GB', 'CHW', 1),
(2443, 'Renfrewshire', 'GB', 'RFW', 1),
(2444, 'Cheshire East', 'GB', 'CHE', 1),
(2445, 'Cookstown District Council', 'GB', 'CKT', 1),
(2446, 'Derry City and Strabane', 'GB', 'DRS', 1),
(2447, 'Staffordshire', 'GB', 'STS', 1),
(2448, 'London Borough of Hammersmith and Fulham', 'GB', 'HMF', 1),
(2449, 'Craigavon Borough Council', 'GB', 'CGV', 1),
(2450, 'Clackmannanshire', 'GB', 'CLK', 1),
(2451, 'Blackpool', 'GB', 'BPL', 1),
(2452, 'Bridgend County Borough', 'GB', 'BGE', 1),
(2453, 'North Lincolnshire', 'GB', 'NLN', 1),
(2454, 'East Dunbartonshire', 'GB', 'EDU', 1),
(2455, 'Reading', 'GB', 'RDG', 1),
(2456, 'Nottinghamshire', 'GB', 'NTT', 1),
(2457, 'Dudley', 'GB', 'DUD', 1),
(2458, 'Newcastle upon Tyne', 'GB', 'NET', 1),
(2459, 'Bury', 'GB', 'BUR', 1),
(2460, 'Lisburn and Castlereagh', 'GB', 'LBC', 1),
(2461, 'Coleraine Borough Council', 'GB', 'CLR', 1),
(2462, 'East Lothian', 'GB', 'ELN', 1),
(2463, 'Aberdeen', 'GB', 'ABE', 1),
(2464, 'Kent', 'GB', 'KEN', 1),
(2465, 'Wakefield', 'GB', 'WKF', 1),
(2466, 'Halton', 'GB', 'HAL', 1),
(2467, 'Suffolk', 'GB', 'SFK', 1),
(2468, 'Thurrock', 'GB', 'THR', 1),
(2469, 'Solihull', 'GB', 'SOL', 1),
(2470, 'Bracknell Forest', 'GB', 'BRC', 1),
(2471, 'West Berkshire', 'GB', 'WBK', 1),
(2472, 'Rutland', 'GB', 'RUT', 1),
(2473, 'Norfolk', 'GB', 'NFK', 1),
(2474, 'Orkney Islands', 'GB', 'ORK', 1),
(2475, 'City of Kingston upon Hull', 'GB', 'KHL', 1),
(2476, 'London Borough of Enfield', 'GB', 'ENF', 1),
(2477, 'Oldham', 'GB', 'OLD', 1),
(2478, 'Torbay', 'GB', 'TOB', 1),
(2479, 'Fife', 'GB', 'FIF', 1),
(2480, 'Northamptonshire', 'GB', 'NTH', 1),
(2481, 'Royal Borough of Kingston upon Thames', 'GB', 'KTT', 1),
(2482, 'Windsor and Maidenhead', 'GB', 'WNM', 1),
(2483, 'London Borough of Merton', 'GB', 'MRT', 1),
(2484, 'Carmarthenshire', 'GB', 'CMN', 1),
(2485, 'City of Derby', 'GB', 'DER', 1),
(2486, 'Pembrokeshire', 'GB', 'PEM', 1),
(2487, 'North Lanarkshire', 'GB', 'NLK', 1),
(2488, 'Stirling', 'GB', 'STG', 1),
(2489, 'City of Wolverhampton', 'GB', 'WLV', 1),
(2490, 'London Borough of Bromley', 'GB', 'BRY', 1),
(2491, 'Devon', 'GB', 'DEV', 1),
(2492, 'Royal Borough of Greenwich', 'GB', 'GRE', 1),
(2493, 'Salford', 'GB', 'SLF', 1),
(2494, 'Lisburn City Council', 'GB', 'LSB', 1),
(2495, 'Lancashire', 'GB', 'LAN', 1),
(2496, 'Torfaen', 'GB', 'TOF', 1),
(2497, 'Denbighshire', 'GB', 'DEN', 1),
(2498, 'Ards', 'GB', 'ARD', 1),
(2499, 'Barnsley', 'GB', 'BNS', 1),
(2500, 'Herefordshire', 'GB', 'HEF', 1),
(2501, 'London Borough of Richmond upon Thames', 'GB', 'RIC', 1),
(2502, 'Saint Helena', 'GB', 'SH-HL', 1),
(2503, 'Leeds', 'GB', 'LDS', 1),
(2504, 'Bolton', 'GB', 'BOL', 1),
(2505, 'Warwickshire', 'GB', 'WAR', 1),
(2506, 'City of Stoke-on-Trent', 'GB', 'STE', 1),
(2507, 'Bedford', 'GB', 'BDF', 1),
(2508, 'Dungannon and South Tyrone Borough Council', 'GB', 'DGN', 1),
(2509, 'Ceredigion', 'GB', 'CGN', 1),
(2510, 'Worcestershire', 'GB', 'WOR', 1),
(2511, 'Dundee', 'GB', 'DND', 1),
(2512, 'London Borough of Croydon', 'GB', 'CRY', 1),
(2513, 'North Down Borough Council', 'GB', 'NDN', 1),
(2514, 'City of Plymouth', 'GB', 'PLY', 1),
(2515, 'Larne Borough Council', 'GB', 'LRN', 1),
(2516, 'Leicestershire', 'GB', 'LEC', 1),
(2517, 'Calderdale', 'GB', 'CLD', 1),
(2518, 'Sefton', 'GB', 'SFT', 1),
(2519, 'Midlothian', 'GB', 'MLN', 1),
(2520, 'London Borough of Barnet', 'GB', 'BNE', 1),
(2521, 'North Tyneside', 'GB', 'NTY', 1),
(2522, 'North Yorkshire', 'GB', 'NYK', 1),
(2523, 'Ards and North Down', 'GB', 'AND', 1),
(2524, 'Newport', 'GB', 'NWP', 1),
(2525, 'Castlereagh', 'GB', 'CSR', 1),
(2526, 'Surrey', 'GB', 'SRY', 1),
(2527, 'Redcar and Cleveland', 'GB', 'RCC', 1),
(2528, 'City and County of Cardiff', 'GB', 'CRF', 1),
(2529, 'Bradford', 'GB', 'BRD', 1),
(2530, 'Blaenau Gwent County Borough', 'GB', 'BGW', 1),
(2531, 'Fermanagh District Council', 'GB', 'FER', 1),
(2532, 'London Borough of Ealing', 'GB', 'EAL', 1),
(2533, 'Antrim', 'GB', 'ANT', 1),
(2534, 'Newry, Mourne and Down', 'GB', 'NMD', 1),
(2535, 'North Ayrshire', 'GB', 'NAY', 1),
(2536, 'Tashkent', 'UZ', 'TK', 1),
(2537, 'Namangan Region', 'UZ', 'NG', 1),
(2538, 'Fergana Region', 'UZ', 'FA', 1),
(2539, 'Xorazm Region', 'UZ', 'XO', 1),
(2540, 'Andijan Region', 'UZ', 'AN', 1),
(2541, 'Bukhara Region', 'UZ', 'BU', 1),
(2542, 'Navoiy Region', 'UZ', 'NW', 1),
(2543, 'Qashqadaryo Region', 'UZ', 'QA', 1),
(2544, 'Samarqand Region', 'UZ', 'SA', 1),
(2545, 'Jizzakh Region', 'UZ', 'JI', 1),
(2546, 'Surxondaryo Region', 'UZ', 'SU', 1),
(2547, 'Sirdaryo Region', 'UZ', 'SI', 1),
(2548, 'Karakalpakstan', 'UZ', 'QR', 1),
(2549, 'Tashkent Region', 'UZ', 'TO', 1),
(2550, 'Ariana', 'TN', '12', 1),
(2551, 'Bizerte', 'TN', '23', 1),
(2552, 'Jendouba', 'TN', '32', 1),
(2553, 'Monastir', 'TN', '52', 1),
(2554, 'Tunis', 'TN', '11', 1),
(2555, 'Manouba', 'TN', '14', 1),
(2556, 'Gafsa', 'TN', '71', 1),
(2557, 'Sfax', 'TN', '61', 1),
(2558, 'Gabès', 'TN', '81', 1),
(2559, 'Tataouine', 'TN', '83', 1),
(2560, 'Medenine', 'TN', '82', 1),
(2561, 'Kef', 'TN', '33', 1),
(2562, 'Kebili', 'TN', '73', 1),
(2563, 'Siliana', 'TN', '34', 1),
(2564, 'Kairouan', 'TN', '41', 1),
(2565, 'Zaghouan', 'TN', '22', 1),
(2566, 'Ben Arous', 'TN', '13', 1),
(2567, 'Sidi Bouzid', 'TN', '43', 1),
(2568, 'Mahdia', 'TN', '53', 1),
(2569, 'Tozeur', 'TN', '72', 1),
(2570, 'Kasserine', 'TN', '42', 1),
(2571, 'Sousse', 'TN', '51', 1),
(2572, 'Kassrine', 'TN', '31', 1),
(2573, 'Ratak Chain', 'MH', 'T', 1),
(2574, 'Ralik Chain', 'MH', 'L', 1),
(2575, 'Centrale Region', 'TG', 'C', 1),
(2576, 'Maritime', 'TG', 'M', 1),
(2577, 'Plateaux Region', 'TG', 'P', 1),
(2578, 'Savanes Region', 'TG', 'S', 1),
(2579, 'Kara Region', 'TG', 'K', 1),
(2580, 'Chuuk State', 'FM', 'TRK', 1),
(2581, 'Pohnpei State', 'FM', 'PNI', 1),
(2582, 'Yap State', 'FM', 'YAP', 1),
(2583, 'Kosrae State', 'FM', 'KSA', 1),
(2584, 'Vaavu Atoll', 'MV', '04', 1),
(2585, 'Shaviyani Atoll', 'MV', '24', 1),
(2586, 'Haa Alif Atoll', 'MV', '07', 1),
(2587, 'Alif Alif Atoll', 'MV', '02', 1),
(2588, 'North Province', 'MV', 'NO', 1),
(2589, 'North Central Province', 'MV', 'NC', 1),
(2590, 'Dhaalu Atoll', 'MV', '17', 1),
(2591, 'Thaa Atoll', 'MV', '08', 1),
(2592, 'Noonu Atoll', 'MV', '25', 1),
(2593, 'Upper South Province', 'MV', 'US', 1),
(2594, 'Addu Atoll', 'MV', '01', 1),
(2595, 'Gnaviyani Atoll', 'MV', '29', 1),
(2596, 'Kaafu Atoll', 'MV', '26', 1),
(2597, 'Haa Dhaalu Atoll', 'MV', '23', 1),
(2598, 'Gaafu Alif Atoll', 'MV', '27', 1),
(2599, 'Faafu Atoll', 'MV', '14', 1),
(2600, 'Alif Dhaal Atoll', 'MV', '00', 1),
(2601, 'Laamu Atoll', 'MV', '05', 1),
(2602, 'Raa Atoll', 'MV', '13', 1),
(2603, 'Gaafu Dhaalu Atoll', 'MV', '28', 1),
(2604, 'Central Province', 'MV', 'CE', 1),
(2605, 'South Province', 'MV', 'SU', 1),
(2606, 'South Central Province', 'MV', 'SC', 1),
(2607, 'Lhaviyani Atoll', 'MV', '03', 1),
(2608, 'Meemu Atoll', 'MV', '12', 1),
(2609, 'Malé', 'MV', 'MLE', 1),
(2610, 'Utrecht', 'NL', 'UT', 1),
(2611, 'Gelderland', 'NL', 'GE', 1),
(2612, 'North Holland', 'NL', 'NH', 1),
(2613, 'Drenthe', 'NL', 'DR', 1),
(2614, 'South Holland', 'NL', 'ZH', 1),
(2615, 'Limburg', 'NL', 'LI', 1),
(2616, 'Sint Eustatius', 'NL', 'BQ3', 1),
(2617, 'Groningen', 'NL', 'GR', 1),
(2618, 'Overijssel', 'NL', 'OV', 1),
(2619, 'Flevoland', 'NL', 'FL', 1),
(2620, 'Zeeland', 'NL', 'ZE', 1),
(2621, 'Saba', 'NL', 'BQ2', 1),
(2622, 'Friesland', 'NL', 'FR', 1),
(2623, 'North Brabant', 'NL', 'NB', 1),
(2624, 'Bonaire', 'NL', 'BQ1', 1),
(2625, 'Savanes Region', 'CI', '03', 1),
(2626, 'Agnéby', 'CI', '16', 1),
(2627, 'Lagunes District', 'CI', 'LG', 1),
(2628, 'Sud-Bandama', 'CI', '15', 1),
(2629, 'Montagnes District', 'CI', 'MG', 1),
(2630, 'Moyen-Comoé', 'CI', '05', 1),
(2631, 'Marahoué Region', 'CI', '12', 1),
(2632, 'Lacs District', 'CI', 'LC', 1),
(2633, 'Fromager', 'CI', '18', 1),
(2634, 'Abidjan', 'CI', 'AB', 1),
(2635, 'Bas-Sassandra Region', 'CI', '09', 1),
(2636, 'Bafing Region', 'CI', '17', 1),
(2637, 'Vallée du Bandama District', 'CI', 'VB', 1),
(2638, 'Haut-Sassandra', 'CI', '02', 1),
(2639, 'Lagunes region', 'CI', '01', 1),
(2640, 'Lacs Region', 'CI', '07', 1),
(2641, 'Zanzan Region', 'CI', 'ZZ', 1),
(2642, 'Denguélé Region', 'CI', '10', 1),
(2643, 'Bas-Sassandra District', 'CI', 'BS', 1),
(2644, 'Denguélé District', 'CI', 'DN', 1),
(2645, 'Dix-Huit Montagnes', 'CI', '06', 1),
(2646, 'Moyen-Cavally', 'CI', '19', 1),
(2647, 'Vallée du Bandama Region', 'CI', '04', 1),
(2648, 'Sassandra-Marahoué District', 'CI', 'SM', 1),
(2649, 'Worodougou', 'CI', '14', 1),
(2650, 'Woroba District', 'CI', 'WR', 1),
(2651, 'Gôh-Djiboua District', 'CI', 'GD', 1),
(2652, 'Sud-Comoé', 'CI', '13', 1),
(2653, 'Yamoussoukro', 'CI', 'YM', 1),
(2654, 'Comoé District', 'CI', 'CM', 1),
(2655, 'N\'zi-Comoé', 'CI', '11', 1),
(2656, 'Far North', 'CM', 'EN', 1),
(2657, 'Northwest', 'CM', 'NW', 1),
(2658, 'Southwest', 'CM', 'SW', 1),
(2659, 'South', 'CM', 'SU', 1),
(2660, 'Centre', 'CM', 'CE', 1),
(2661, 'East', 'CM', 'ES', 1),
(2662, 'Littoral', 'CM', 'LT', 1),
(2663, 'Adamawa', 'CM', 'AD', 1),
(2664, 'West', 'CM', 'OU', 1),
(2665, 'North', 'CM', 'NO', 1),
(2666, 'Banjul', 'GM', 'B', 1),
(2667, 'West Coast Division', 'GM', 'W', 1),
(2668, 'Upper River Division', 'GM', 'U', 1),
(2669, 'Central River Division', 'GM', 'M', 1),
(2670, 'Lower River Division', 'GM', 'L', 1),
(2671, 'North Bank Division', 'GM', 'N', 1),
(2672, 'Beyla Prefecture', 'GN', 'BE', 1),
(2673, 'Mandiana Prefecture', 'GN', 'MD', 1),
(2674, 'Yomou Prefecture', 'GN', 'YO', 1),
(2675, 'Fria Prefecture', 'GN', 'FR', 1),
(2676, 'Boké Region', 'GN', 'B', 1),
(2677, 'Labé Region', 'GN', 'L', 1),
(2678, 'Nzérékoré Prefecture', 'GN', 'NZ', 1),
(2679, 'Dabola Prefecture', 'GN', 'DB', 1),
(2680, 'Labé Prefecture', 'GN', 'LA', 1),
(2681, 'Dubréka Prefecture', 'GN', 'DU', 1),
(2682, 'Faranah Prefecture', 'GN', 'FA', 1),
(2683, 'Forécariah Prefecture', 'GN', 'FO', 1),
(2684, 'Nzérékoré Region', 'GN', 'N', 1),
(2685, 'Gaoual Prefecture', 'GN', 'GA', 1),
(2686, 'Conakry', 'GN', 'C', 1),
(2687, 'Télimélé Prefecture', 'GN', 'TE', 1),
(2688, 'Dinguiraye Prefecture', 'GN', 'DI', 1),
(2689, 'Mamou Prefecture', 'GN', 'MM', 1);
INSERT INTO `state` (`id`, `name`, `country_code`, `iso2`, `exists`) VALUES
(2690, 'Lélouma Prefecture', 'GN', 'LE', 1),
(2691, 'Kissidougou Prefecture', 'GN', 'KS', 1),
(2692, 'Koubia Prefecture', 'GN', 'KB', 1),
(2693, 'Kindia Prefecture', 'GN', 'KD', 1),
(2694, 'Pita Prefecture', 'GN', 'PI', 1),
(2695, 'Kouroussa Prefecture', 'GN', 'KO', 1),
(2696, 'Tougué Prefecture', 'GN', 'TO', 1),
(2697, 'Kankan Region', 'GN', 'K', 1),
(2698, 'Mamou Region', 'GN', 'M', 1),
(2699, 'Boffa Prefecture', 'GN', 'BF', 1),
(2700, 'Mali Prefecture', 'GN', 'ML', 1),
(2701, 'Kindia Region', 'GN', 'D', 1),
(2702, 'Macenta Prefecture', 'GN', 'MC', 1),
(2703, 'Koundara Prefecture', 'GN', 'KN', 1),
(2704, 'Kankan Prefecture', 'GN', 'KA', 1),
(2705, 'Coyah Prefecture', 'GN', 'CO', 1),
(2706, 'Dalaba Prefecture', 'GN', 'DL', 1),
(2707, 'Siguiri Prefecture', 'GN', 'SI', 1),
(2708, 'Lola Prefecture', 'GN', 'LO', 1),
(2709, 'Boké Prefecture', 'GN', 'BK', 1),
(2710, 'Kérouané Prefecture', 'GN', 'KE', 1),
(2711, 'Guéckédou Prefecture', 'GN', 'GU', 1),
(2712, 'Tombali Region', 'GW', 'TO', 1),
(2713, 'Cacheu Region', 'GW', 'CA', 1),
(2714, 'Biombo Region', 'GW', 'BM', 1),
(2715, 'Quinara Region', 'GW', 'QU', 1),
(2716, 'Sul Province', 'GW', 'S', 1),
(2717, 'Norte Province', 'GW', 'N', 1),
(2718, 'Oio Region', 'GW', 'OI', 1),
(2719, 'Gabú Region', 'GW', 'GA', 1),
(2720, 'Bafatá', 'GW', 'BA', 1),
(2721, 'Leste Province', 'GW', 'L', 1),
(2722, 'Bolama Region', 'GW', 'BL', 1),
(2723, 'Woleu-Ntem Province', 'GA', '9', 1),
(2724, 'Ogooué-Ivindo Province', 'GA', '6', 1),
(2725, 'Nyanga Province', 'GA', '5', 1),
(2726, 'Haut-Ogooué Province', 'GA', '2', 1),
(2727, 'Estuaire Province', 'GA', '1', 1),
(2728, 'Ogooué-Maritime Province', 'GA', '8', 1),
(2729, 'Ogooué-Lolo Province', 'GA', '7', 1),
(2730, 'Moyen-Ogooué Province', 'GA', '3', 1),
(2731, 'Ngounié Province', 'GA', '4', 1),
(2732, 'Tshuapa', 'CD', 'TU', 1),
(2733, 'Tanganyika', 'CD', 'TA', 1),
(2734, 'Haut-Uélé', 'CD', 'HU', 1),
(2735, 'Kasaï Oriental', 'CD', 'KE', 1),
(2738, 'Sud-Kivu', 'CD', 'SK', 1),
(2739, 'Nord-Ubangi', 'CD', 'NU', 1),
(2740, 'Kwango', 'CD', 'KG', 1),
(2741, 'Kinshasa', 'CD', 'KN', 1),
(2742, 'Kasaï Central', 'CD', 'KC', 1),
(2743, 'Sankuru', 'CD', 'SA', 1),
(2744, 'Équateur', 'CD', 'EQ', 1),
(2745, 'Maniema', 'CD', 'MA', 1),
(2746, 'Kongo Central', 'CD', 'BC', 1),
(2747, 'Lomami', 'CD', 'LO', 1),
(2748, 'Sud-Ubangi', 'CD', 'SU', 1),
(2749, 'Nord-Kivu', 'CD', 'NK', 1),
(2750, 'Haut-Katanga', 'CD', 'HK', 1),
(2751, 'Ituri', 'CD', 'IT', 1),
(2752, 'Mongala', 'CD', 'MO', 1),
(2753, 'Bas-Uélé', 'CD', 'BU', 1),
(2755, 'Mai-Ndombe', 'CD', 'MN', 1),
(2756, 'Tshopo', 'CD', 'TO', 1),
(2757, 'Kasaï', 'CD', 'KS', 1),
(2758, 'Haut-Lomami', 'CD', 'HL', 1),
(2759, 'Kwilu', 'CD', 'KL', 1),
(2760, 'Cuyuni-Mazaruni', 'GY', 'CU', 1),
(2761, 'Potaro-Siparuni', 'GY', 'PT', 1),
(2762, 'Mahaica-Berbice', 'GY', 'MA', 1),
(2763, 'Upper Demerara-Berbice', 'GY', 'UD', 1),
(2764, 'Barima-Waini', 'GY', 'BA', 1),
(2765, 'Pomeroon-Supenaam', 'GY', 'PM', 1),
(2766, 'East Berbice-Corentyne', 'GY', 'EB', 1),
(2767, 'Demerara-Mahaica', 'GY', 'DE', 1),
(2768, 'Essequibo Islands-West Demerara', 'GY', 'ES', 1),
(2769, 'Upper Takutu-Upper Essequibo', 'GY', 'UT', 1),
(2770, 'Presidente Hayes Department', 'PY', '15', 1),
(2771, 'Canindeyú', 'PY', '14', 1),
(2772, 'Guairá Department', 'PY', '4', 1),
(2773, 'Caaguazú', 'PY', '5', 1),
(2774, 'Paraguarí Department', 'PY', '9', 1),
(2775, 'Caazapá', 'PY', '6', 1),
(2776, 'San Pedro Department', 'PY', '2', 1),
(2777, 'Central Department', 'PY', '11', 1),
(2778, 'Itapúa', 'PY', '7', 1),
(2779, 'Concepción Department', 'PY', '1', 1),
(2780, 'Boquerón Department', 'PY', '19', 1),
(2781, 'Ñeembucú Department', 'PY', '12', 1),
(2782, 'Amambay Department', 'PY', '13', 1),
(2783, 'Cordillera Department', 'PY', '3', 1),
(2784, 'Alto Paraná Department', 'PY', '10', 1),
(2785, 'Alto Paraguay Department', 'PY', '16', 1),
(2786, 'Misiones Department', 'PY', '8', 1),
(2787, 'Jaffna District', 'LK', '41', 1),
(2788, 'Kandy District', 'LK', '21', 1),
(2789, 'Kalutara District', 'LK', '13', 1),
(2790, 'Badulla District', 'LK', '81', 1),
(2791, 'Hambantota District', 'LK', '33', 1),
(2792, 'Galle District', 'LK', '31', 1),
(2793, 'Kilinochchi District', 'LK', '42', 1),
(2794, 'Nuwara Eliya District', 'LK', '23', 1),
(2795, 'Trincomalee District', 'LK', '53', 1),
(2796, 'Puttalam District', 'LK', '62', 1),
(2797, 'Kegalle District', 'LK', '92', 1),
(2798, 'Central Province', 'LK', '2', 1),
(2799, 'Ampara District', 'LK', '52', 1),
(2800, 'North Central Province', 'LK', '7', 1),
(2801, 'Southern Province', 'LK', '3', 1),
(2802, 'Western Province', 'LK', '1', 1),
(2803, 'Sabaragamuwa Province', 'LK', '9', 1),
(2804, 'Gampaha District', 'LK', '12', 1),
(2805, 'Mannar District', 'LK', '43', 1),
(2806, 'Matara District', 'LK', '32', 1),
(2807, 'Ratnapura district', 'LK', '91', 1),
(2808, 'Eastern Province', 'LK', '5', 1),
(2809, 'Vavuniya District', 'LK', '44', 1),
(2810, 'Matale District', 'LK', '22', 1),
(2811, 'Uva Province', 'LK', '8', 1),
(2812, 'Polonnaruwa District', 'LK', '72', 1),
(2813, 'Northern Province', 'LK', '4', 1),
(2814, 'Mullaitivu District', 'LK', '45', 1),
(2815, 'Colombo District', 'LK', '11', 1),
(2816, 'Anuradhapura District', 'LK', '71', 1),
(2817, 'North Western Province', 'LK', '6', 1),
(2818, 'Batticaloa District', 'LK', '51', 1),
(2819, 'Monaragala District', 'LK', '82', 1),
(2820, 'Mohéli', 'KM', 'M', 1),
(2821, 'Anjouan', 'KM', 'A', 1),
(2822, 'Grande Comore', 'KM', 'G', 1),
(2823, 'Atacama', 'CL', 'AT', 1),
(2824, 'Región Metropolitana de Santiago', 'CL', 'RM', 1),
(2825, 'Coquimbo', 'CL', 'CO', 1),
(2826, 'La Araucanía', 'CL', 'AR', 1),
(2827, 'Biobío', 'CL', 'BI', 1),
(2828, 'Aisén del General Carlos Ibañez del Campo', 'CL', 'AI', 1),
(2829, 'Arica y Parinacota', 'CL', 'AP', 1),
(2830, 'Valparaíso', 'CL', 'VS', 1),
(2831, 'Ñuble', 'CL', 'NB', 1),
(2832, 'Antofagasta', 'CL', 'AN', 1),
(2833, 'Maule', 'CL', 'ML', 1),
(2834, 'Los Ríos', 'CL', 'LR', 1),
(2835, 'Los Lagos', 'CL', 'LL', 1),
(2836, 'Magallanes y de la Antártica Chilena', 'CL', 'MA', 1),
(2837, 'Tarapacá', 'CL', 'TA', 1),
(2838, 'Libertador General Bernardo O\'Higgins', 'CL', 'LI', 1),
(2839, 'Commewijne District', 'SR', 'CM', 1),
(2840, 'Nickerie District', 'SR', 'NI', 1),
(2841, 'Para District', 'SR', 'PR', 1),
(2842, 'Coronie District', 'SR', 'CR', 1),
(2843, 'Paramaribo District', 'SR', 'PM', 1),
(2844, 'Wanica District', 'SR', 'WA', 1),
(2845, 'Marowijne District', 'SR', 'MA', 1),
(2846, 'Brokopondo District', 'SR', 'BR', 1),
(2847, 'Sipaliwini District', 'SR', 'SI', 1),
(2848, 'Saramacca District', 'SR', 'SA', 1),
(2849, 'Riyadh', 'SA', '01', 1),
(2850, 'Makkah', 'SA', '02', 1),
(2851, 'Al Madinah', 'SA', '03', 1),
(2852, 'Tabuk', 'SA', '07', 1),
(2853, '\'Asir', 'SA', '14', 1),
(2854, 'Northern Borders', 'SA', '08', 1),
(2855, 'Ha\'il', 'SA', '06', 1),
(2856, 'Eastern Province', 'SA', '04', 1),
(2857, 'Al Jawf', 'SA', '12', 1),
(2858, 'Jizan', 'SA', '09', 1),
(2859, 'Al Bahah', 'SA', '11', 1),
(2860, 'Najran', 'SA', '10', 1),
(2861, 'Al-Qassim', 'SA', '05', 1),
(2862, 'Plateaux Department', 'CG', '14', 1),
(2863, 'Pointe-Noire', 'CG', '16', 1),
(2864, 'Cuvette Department', 'CG', '8', 1),
(2865, 'Likouala Department', 'CG', '7', 1),
(2866, 'Bouenza Department', 'CG', '11', 1),
(2867, 'Kouilou Department', 'CG', '5', 1),
(2868, 'Lékoumou Department', 'CG', '2', 1),
(2869, 'Cuvette-Ouest Department', 'CG', '15', 1),
(2870, 'Brazzaville', 'CG', 'BZV', 1),
(2871, 'Sangha Department', 'CG', '13', 1),
(2872, 'Niari Department', 'CG', '9', 1),
(2873, 'Pool Department', 'CG', '12', 1),
(2874, 'Quindío', 'CO', 'QUI', 1),
(2875, 'Cundinamarca', 'CO', 'CUN', 1),
(2876, 'Chocó', 'CO', 'CHO', 1),
(2877, 'Norte de Santander', 'CO', 'NSA', 1),
(2878, 'Meta', 'CO', 'MET', 1),
(2879, 'Risaralda', 'CO', 'RIS', 1),
(2880, 'Atlántico', 'CO', 'ATL', 1),
(2881, 'Arauca', 'CO', 'ARA', 1),
(2882, 'Guainía', 'CO', 'GUA', 1),
(2883, 'Tolima', 'CO', 'TOL', 1),
(2884, 'Cauca', 'CO', 'CAU', 1),
(2885, 'Vaupés', 'CO', 'VAU', 1),
(2886, 'Magdalena', 'CO', 'MAG', 1),
(2887, 'Caldas', 'CO', 'CAL', 1),
(2888, 'Guaviare', 'CO', 'GUV', 1),
(2889, 'La Guajira', 'CO', 'LAG', 1),
(2890, 'Antioquia', 'CO', 'ANT', 1),
(2891, 'Caquetá', 'CO', 'CAQ', 1),
(2892, 'Casanare', 'CO', 'CAS', 1),
(2893, 'Bolívar', 'CO', 'BOL', 1),
(2894, 'Vichada', 'CO', 'VID', 1),
(2895, 'Amazonas', 'CO', 'AMA', 1),
(2896, 'Putumayo', 'CO', 'PUT', 1),
(2897, 'Nariño', 'CO', 'NAR', 1),
(2898, 'Córdoba', 'CO', 'COR', 1),
(2899, 'Cesar', 'CO', 'CES', 1),
(2900, 'Archipiélago de San Andrés, Providencia y Santa Catalina', 'CO', 'SAP', 1),
(2901, 'Santander', 'CO', 'SAN', 1),
(2902, 'Sucre', 'CO', 'SUC', 1),
(2903, 'Boyacá', 'CO', 'BOY', 1),
(2904, 'Valle del Cauca', 'CO', 'VAC', 1),
(2905, 'Galápagos', 'EC', 'W', 1),
(2906, 'Sucumbíos', 'EC', 'U', 1),
(2907, 'Pastaza', 'EC', 'Y', 1),
(2908, 'Tungurahua', 'EC', 'T', 1),
(2909, 'Zamora Chinchipe', 'EC', 'Z', 1),
(2910, 'Los Ríos', 'EC', 'R', 1),
(2911, 'Imbabura', 'EC', 'I', 1),
(2912, 'Santa Elena', 'EC', 'SE', 1),
(2913, 'Manabí', 'EC', 'M', 1),
(2914, 'Guayas', 'EC', 'G', 1),
(2915, 'Carchi', 'EC', 'C', 1),
(2916, 'Napo', 'EC', 'N', 1),
(2917, 'Cañar', 'EC', 'F', 1),
(2918, 'Morona-Santiago', 'EC', 'S', 1),
(2919, 'Santo Domingo de los Tsáchilas', 'EC', 'SD', 1),
(2920, 'Bolívar', 'EC', 'B', 1),
(2921, 'Cotopaxi', 'EC', 'X', 1),
(2922, 'Esmeraldas', 'EC', 'E', 1),
(2923, 'Azuay', 'EC', 'A', 1),
(2924, 'El Oro', 'EC', 'O', 1),
(2925, 'Chimborazo', 'EC', 'H', 1),
(2926, 'Orellana', 'EC', 'D', 1),
(2927, 'Pichincha', 'EC', 'P', 1),
(2928, 'Obock Region', 'DJ', 'OB', 1),
(2929, 'Djibouti', 'DJ', 'DJ', 1),
(2930, 'Dikhil Region', 'DJ', 'DI', 1),
(2931, 'Tadjourah Region', 'DJ', 'TA', 1),
(2932, 'Arta Region', 'DJ', 'AR', 1),
(2933, 'Ali Sabieh Region', 'DJ', 'AS', 1),
(2934, 'Hama', 'SY', 'HM', 1),
(2935, 'Rif Dimashq', 'SY', 'RD', 1),
(2936, 'As-Suwayda', 'SY', 'SU', 1),
(2937, 'Deir ez-Zor', 'SY', 'DY', 1),
(2938, 'Latakia', 'SY', 'LA', 1),
(2939, 'Damascus', 'SY', 'DI', 1),
(2940, 'Idlib', 'SY', 'ID', 1),
(2941, 'Al-Hasakah', 'SY', 'HA', 1),
(2942, 'Homs', 'SY', 'HI', 1),
(2943, 'Quneitra', 'SY', 'QU', 1),
(2944, 'Al-Raqqah', 'SY', 'RA', 1),
(2945, 'Daraa', 'SY', 'DR', 1),
(2946, 'Aleppo', 'SY', 'HL', 1),
(2947, 'Tartus', 'SY', 'TA', 1),
(2948, 'Fianarantsoa Province', 'MG', 'F', 1),
(2949, 'Toliara Province', 'MG', 'U', 1),
(2950, 'Antsiranana Province', 'MG', 'D', 1),
(2951, 'Antananarivo Province', 'MG', 'T', 1),
(2952, 'Toamasina Province', 'MG', 'A', 1),
(2953, 'Mahajanga Province', 'MG', 'M', 1),
(2954, 'Mogilev Region', 'BY', 'MA', 1),
(2955, 'Gomel Region', 'BY', 'HO', 1),
(2956, 'Grodno Region', 'BY', 'HR', 1),
(2957, 'Minsk Region', 'BY', 'MI', 1),
(2958, 'Minsk', 'BY', 'HM', 1),
(2959, 'Brest Region', 'BY', 'BR', 1),
(2960, 'Vitebsk Region', 'BY', 'VI', 1),
(2961, 'Murqub', 'LY', 'MB', 1),
(2962, 'Nuqat al Khams', 'LY', 'NQ', 1),
(2963, 'Zawiya District', 'LY', 'ZA', 1),
(2964, 'Al Wahat District', 'LY', 'WA', 1),
(2965, 'Sabha District', 'LY', 'SB', 1),
(2966, 'Derna District', 'LY', 'DR', 1),
(2967, 'Murzuq District', 'LY', 'MQ', 1),
(2968, 'Marj District', 'LY', 'MJ', 1),
(2969, 'Ghat District', 'LY', 'GT', 1),
(2970, 'Jufra', 'LY', 'JU', 1),
(2971, 'Tripoli District', 'LY', 'TB', 1),
(2972, 'Kufra District', 'LY', 'KF', 1),
(2973, 'Wadi al Hayaa District', 'LY', 'WD', 1),
(2974, 'Jabal al Gharbi District', 'LY', 'JG', 1),
(2975, 'Wadi al Shatii District', 'LY', 'WS', 1),
(2976, 'Nalut District', 'LY', 'NL', 1),
(2977, 'Sirte District', 'LY', 'SR', 1),
(2978, 'Misrata District', 'LY', 'MI', 1),
(2979, 'Jafara', 'LY', 'JI', 1),
(2980, 'Jabal al Akhdar', 'LY', 'JA', 1),
(2981, 'Benghazi', 'LY', 'BA', 1),
(2982, 'Ribeira Brava Municipality', 'CV', 'RB', 1),
(2983, 'Tarrafal', 'CV', 'TA', 1),
(2984, 'Ribeira Grande de Santiago', 'CV', 'RS', 1),
(2985, 'Santa Catarina', 'CV', 'CA', 1),
(2986, 'São Domingos', 'CV', 'SD', 1),
(2987, 'Mosteiros', 'CV', 'MO', 1),
(2988, 'Praia', 'CV', 'PR', 1),
(2989, 'Porto Novo', 'CV', 'PN', 1),
(2990, 'São Miguel', 'CV', 'SM', 1),
(2991, 'Maio Municipality', 'CV', 'MA', 1),
(2992, 'Sotavento Islands', 'CV', 'S', 1),
(2993, 'São Lourenço dos Órgãos', 'CV', 'SO', 1),
(2994, 'Barlavento Islands', 'CV', 'B', 1),
(2995, 'Santa Catarina do Fogo', 'CV', 'CF', 1),
(2996, 'Brava', 'CV', 'BR', 1),
(2997, 'Paul', 'CV', 'PA', 1),
(2998, 'Sal', 'CV', 'SL', 1),
(2999, 'Boa Vista', 'CV', 'BV', 1),
(3000, 'São Filipe', 'CV', 'SF', 1),
(3001, 'São Vicente', 'CV', 'SV', 1),
(3002, 'Ribeira Grande', 'CV', 'RG', 1),
(3003, 'Tarrafal de São Nicolau', 'CV', 'TS', 1),
(3004, 'Santa Cruz', 'CV', 'CR', 1),
(3005, 'Schleswig-Holstein', 'DE', 'SH', 1),
(3006, 'Baden-Württemberg', 'DE', 'BW', 1),
(3007, 'Mecklenburg-Vorpommern', 'DE', 'MV', 1),
(3008, 'Lower Saxony', 'DE', 'NI', 1),
(3009, 'Bavaria', 'DE', 'BY', 1),
(3010, 'Berlin', 'DE', 'BE', 1),
(3011, 'Saxony-Anhalt', 'DE', 'ST', 1),
(3013, 'Brandenburg', 'DE', 'BB', 1),
(3014, 'Bremen', 'DE', 'HB', 1),
(3015, 'Thuringia', 'DE', 'TH', 1),
(3016, 'Hamburg', 'DE', 'HH', 1),
(3017, 'North Rhine-Westphalia', 'DE', 'NW', 1),
(3018, 'Hesse', 'DE', 'HE', 1),
(3019, 'Rhineland-Palatinate', 'DE', 'RP', 1),
(3020, 'Saarland', 'DE', 'SL', 1),
(3021, 'Saxony', 'DE', 'SN', 1),
(3022, 'Mafeteng District', 'LS', 'E', 1),
(3023, 'Mohale\'s Hoek District', 'LS', 'F', 1),
(3024, 'Mokhotlong District', 'LS', 'J', 1),
(3025, 'Qacha\'s Nek District', 'LS', 'H', 1),
(3026, 'Leribe District', 'LS', 'C', 1),
(3027, 'Quthing District', 'LS', 'G', 1),
(3028, 'Maseru District', 'LS', 'A', 1),
(3029, 'Butha-Buthe District', 'LS', 'B', 1),
(3030, 'Berea District', 'LS', 'D', 1),
(3031, 'Thaba-Tseka District', 'LS', 'K', 1),
(3032, 'Montserrado County', 'LR', 'MO', 1),
(3033, 'River Cess County', 'LR', 'RI', 1),
(3034, 'Bong County', 'LR', 'BG', 1),
(3035, 'Sinoe County', 'LR', 'SI', 1),
(3036, 'Grand Cape Mount County', 'LR', 'CM', 1),
(3037, 'Lofa County', 'LR', 'LO', 1),
(3038, 'River Gee County', 'LR', 'RG', 1),
(3039, 'Grand Gedeh County', 'LR', 'GG', 1),
(3040, 'Grand Bassa County', 'LR', 'GB', 1),
(3041, 'Bomi County', 'LR', 'BM', 1),
(3042, 'Maryland County', 'LR', 'MY', 1),
(3043, 'Margibi County', 'LR', 'MG', 1),
(3044, 'Gbarpolu County', 'LR', 'GP', 1),
(3045, 'Grand Kru County', 'LR', 'GK', 1),
(3046, 'Nimba', 'LR', 'NI', 1),
(3047, 'Ad Dhahirah', 'OM', 'ZA', 1),
(3048, 'Al Batinah North', 'OM', 'BS', 1),
(3049, 'Al Batinah South', 'OM', 'BJ', 1),
(3050, 'Al Batinah Region', 'OM', 'BA', 1),
(3051, 'Ash Sharqiyah Region', 'OM', 'SH', 1),
(3052, 'Musandam', 'OM', 'MU', 1),
(3053, 'Ash Sharqiyah North', 'OM', 'SS', 1),
(3054, 'Ash Sharqiyah South', 'OM', 'SJ', 1),
(3055, 'Muscat', 'OM', 'MA', 1),
(3056, 'Al Wusta', 'OM', 'WU', 1),
(3057, 'Dhofar', 'OM', 'ZU', 1),
(3058, 'Ad Dakhiliyah', 'OM', 'DA', 1),
(3059, 'Al Buraimi', 'OM', 'BU', 1),
(3060, 'Ngamiland', 'BW', 'NG', 1),
(3061, 'Ghanzi District', 'BW', 'GH', 1),
(3062, 'Kgatleng District', 'BW', 'KL', 1),
(3063, 'Southern District', 'BW', 'SO', 1),
(3064, 'South-East District', 'BW', 'SE', 1),
(3065, 'North-West District', 'BW', 'NW', 1),
(3066, 'Kgalagadi District', 'BW', 'KG', 1),
(3067, 'Central District', 'BW', 'CE', 1),
(3068, 'North-East District', 'BW', 'NE', 1),
(3069, 'Kweneng District', 'BW', 'KW', 1),
(3070, 'Collines Department', 'BJ', 'CO', 1),
(3071, 'Kouffo Department', 'BJ', 'KO', 1),
(3072, 'Donga Department', 'BJ', 'DO', 1),
(3073, 'Zou Department', 'BJ', 'ZO', 1),
(3074, 'Plateau Department', 'BJ', 'PL', 1),
(3075, 'Mono Department', 'BJ', 'MO', 1),
(3076, 'Atakora Department', 'BJ', 'AK', 1),
(3077, 'Alibori Department', 'BJ', 'AL', 1),
(3078, 'Borgou Department', 'BJ', 'BO', 1),
(3079, 'Atlantique Department', 'BJ', 'AQ', 1),
(3080, 'Ouémé Department', 'BJ', 'OU', 1),
(3081, 'Littoral Department', 'BJ', 'LI', 1),
(3082, 'Machinga District', 'MW', 'MH', 1),
(3083, 'Zomba District', 'MW', 'ZO', 1),
(3084, 'Mwanza District', 'MW', 'MW', 1),
(3085, 'Nsanje District', 'MW', 'NS', 1),
(3086, 'Salima District', 'MW', 'SA', 1),
(3087, 'Chitipa district', 'MW', 'CT', 1),
(3088, 'Ntcheu District', 'MW', 'NU', 1),
(3089, 'Rumphi District', 'MW', 'RU', 1),
(3090, 'Dowa District', 'MW', 'DO', 1),
(3091, 'Karonga District', 'MW', 'KR', 1),
(3092, 'Central Region', 'MW', 'C', 1),
(3093, 'Likoma District', 'MW', 'LK', 1),
(3094, 'Kasungu District', 'MW', 'KS', 1),
(3095, 'Nkhata Bay District', 'MW', 'NB', 1),
(3096, 'Balaka District', 'MW', 'BA', 1),
(3097, 'Dedza District', 'MW', 'DE', 1),
(3098, 'Thyolo District', 'MW', 'TH', 1),
(3099, 'Mchinji District', 'MW', 'MC', 1),
(3100, 'Nkhotakota District', 'MW', 'NK', 1),
(3101, 'Lilongwe District', 'MW', 'LI', 1),
(3102, 'Blantyre District', 'MW', 'BL', 1),
(3103, 'Mulanje District', 'MW', 'MU', 1),
(3104, 'Mzimba District', 'MW', 'MZ', 1),
(3105, 'Northern Region', 'MW', 'N', 1),
(3106, 'Southern Region', 'MW', 'S', 1),
(3107, 'Chikwawa District', 'MW', 'CK', 1),
(3108, 'Phalombe District', 'MW', 'PH', 1),
(3109, 'Chiradzulu District', 'MW', 'CR', 1),
(3110, 'Mangochi District', 'MW', 'MG', 1),
(3111, 'Ntchisi District', 'MW', 'NI', 1),
(3112, 'Kénédougou Province', 'BF', 'KEN', 1),
(3113, 'Namentenga Province', 'BF', 'NAM', 1),
(3114, 'Sahel Region', 'BF', '12', 1),
(3115, 'Centre-Ouest Region', 'BF', '06', 1),
(3116, 'Nahouri Province', 'BF', 'NAO', 1),
(3117, 'Passoré Province', 'BF', 'PAS', 1),
(3118, 'Zoundwéogo Province', 'BF', 'ZOU', 1),
(3119, 'Sissili Province', 'BF', 'SIS', 1),
(3120, 'Banwa Province', 'BF', 'BAN', 1),
(3121, 'Bougouriba Province', 'BF', 'BGR', 1),
(3122, 'Gnagna Province', 'BF', 'GNA', 1),
(3123, 'Mouhoun', 'BF', 'MOU', 1),
(3124, 'Yagha Province', 'BF', 'YAG', 1),
(3125, 'Plateau-Central Region', 'BF', '11', 1),
(3126, 'Sanmatenga Province', 'BF', 'SMT', 1),
(3127, 'Centre-Nord Region', 'BF', '05', 1),
(3128, 'Tapoa Province', 'BF', 'TAP', 1),
(3129, 'Houet Province', 'BF', 'HOU', 1),
(3130, 'Zondoma Province', 'BF', 'ZON', 1),
(3131, 'Boulgou', 'BF', 'BLG', 1),
(3132, 'Komondjari Province', 'BF', 'KMD', 1),
(3133, 'Koulpélogo Province', 'BF', 'KOP', 1),
(3134, 'Tuy Province', 'BF', 'TUI', 1),
(3135, 'Ioba Province', 'BF', 'IOB', 1),
(3136, 'Centre', 'BF', '03', 1),
(3137, 'Sourou Province', 'BF', 'SOR', 1),
(3138, 'Boucle du Mouhoun Region', 'BF', '01', 1),
(3139, 'Séno Province', 'BF', 'SEN', 1),
(3140, 'Sud-Ouest Region', 'BF', '13', 1),
(3141, 'Oubritenga Province', 'BF', 'OUB', 1),
(3142, 'Nayala Province', 'BF', 'NAY', 1),
(3143, 'Gourma Province', 'BF', 'GOU', 1),
(3144, 'Oudalan Province', 'BF', 'OUD', 1),
(3145, 'Ziro Province', 'BF', 'ZIR', 1),
(3146, 'Kossi Province', 'BF', 'KOS', 1),
(3147, 'Kourwéogo Province', 'BF', 'KOW', 1),
(3148, 'Ganzourgou Province', 'BF', 'GAN', 1),
(3149, 'Centre-Sud Region', 'BF', '07', 1),
(3150, 'Yatenga Province', 'BF', 'YAT', 1),
(3151, 'Loroum Province', 'BF', 'LOR', 1),
(3152, 'Bazèga Province', 'BF', 'BAZ', 1),
(3153, 'Cascades Region', 'BF', '02', 1),
(3154, 'Sanguié Province', 'BF', 'SNG', 1),
(3155, 'Bam Province', 'BF', 'BAM', 1),
(3156, 'Noumbiel Province', 'BF', 'NOU', 1),
(3157, 'Kompienga Province', 'BF', 'KMP', 1),
(3158, 'Est Region', 'BF', '08', 1),
(3159, 'Léraba Province', 'BF', 'LER', 1),
(3160, 'Balé Province', 'BF', 'BAL', 1),
(3161, 'Kouritenga Province', 'BF', 'KOT', 1),
(3162, 'Centre-Est Region', 'BF', '04', 1),
(3163, 'Poni Province', 'BF', 'PON', 1),
(3164, 'Nord Region, Burkina Faso', 'BF', '10', 1),
(3165, 'Hauts-Bassins Region', 'BF', '09', 1),
(3166, 'Soum Province', 'BF', 'SOM', 1),
(3167, 'Comoé Province', 'BF', 'COM', 1),
(3168, 'Kadiogo Province', 'BF', 'KAD', 1),
(3169, 'Islamabad Capital Territory', 'PK', 'IS', 1),
(3170, 'Gilgit-Baltistan', 'PK', 'GB', 1),
(3171, 'Khyber Pakhtunkhwa', 'PK', 'KP', 1),
(3172, 'Azad Kashmir', 'PK', 'JK', 1),
(3173, 'Federally Administered Tribal Areas', 'PK', 'TA', 1),
(3174, 'Balochistan', 'PK', 'BA', 1),
(3175, 'Sindh', 'PK', 'SD', 1),
(3176, 'Punjab', 'PK', 'PB', 1),
(3177, 'Al Rayyan Municipality', 'QA', 'RA', 1),
(3178, 'Al-Shahaniya', 'QA', 'SH', 1),
(3179, 'Al Wakrah', 'QA', 'WA', 1),
(3180, 'Madinat ash Shamal', 'QA', 'MS', 1),
(3181, 'Doha', 'QA', 'DA', 1),
(3182, 'Al Daayen', 'QA', 'ZA', 1),
(3183, 'Al Khor', 'QA', 'KH', 1),
(3184, 'Umm Salal Municipality', 'QA', 'US', 1),
(3185, 'Rumonge Province', 'BI', 'RM', 1),
(3186, 'Muyinga Province', 'BI', 'MY', 1),
(3187, 'Mwaro Province', 'BI', 'MW', 1),
(3188, 'Makamba Province', 'BI', 'MA', 1),
(3189, 'Rutana Province', 'BI', 'RT', 1),
(3190, 'Cibitoke Province', 'BI', 'CI', 1),
(3191, 'Ruyigi Province', 'BI', 'RY', 1),
(3192, 'Kayanza Province', 'BI', 'KY', 1),
(3193, 'Muramvya Province', 'BI', 'MU', 1),
(3194, 'Karuzi Province', 'BI', 'KR', 1),
(3195, 'Kirundo Province', 'BI', 'KI', 1),
(3196, 'Bubanza Province', 'BI', 'BB', 1),
(3197, 'Gitega Province', 'BI', 'GI', 1),
(3198, 'Bujumbura Mairie Province', 'BI', 'BM', 1),
(3199, 'Ngozi Province', 'BI', 'NG', 1),
(3200, 'Bujumbura Rural Province', 'BI', 'BL', 1),
(3201, 'Cankuzo Province', 'BI', 'CA', 1),
(3202, 'Bururi Province', 'BI', 'BR', 1),
(3203, 'Flores Department', 'UY', 'FS', 1),
(3204, 'San José Department', 'UY', 'SJ', 1),
(3205, 'Artigas Department', 'UY', 'AR', 1),
(3206, 'Maldonado Department', 'UY', 'MA', 1),
(3207, 'Rivera Department', 'UY', 'RV', 1),
(3208, 'Colonia Department', 'UY', 'CO', 1),
(3209, 'Durazno Department', 'UY', 'DU', 1),
(3210, 'Río Negro Department', 'UY', 'RN', 1),
(3211, 'Cerro Largo Department', 'UY', 'CL', 1),
(3212, 'Paysandú Department', 'UY', 'PA', 1),
(3213, 'Canelones Department', 'UY', 'CA', 1),
(3214, 'Treinta y Tres Department', 'UY', 'TT', 1),
(3215, 'Lavalleja Department', 'UY', 'LA', 1),
(3216, 'Rocha Department', 'UY', 'RO', 1),
(3217, 'Florida Department', 'UY', 'FD', 1),
(3218, 'Montevideo Department', 'UY', 'MO', 1),
(3219, 'Soriano Department', 'UY', 'SO', 1),
(3220, 'Salto Department', 'UY', 'SA', 1),
(3221, 'Tacuarembó Department', 'UY', 'TA', 1),
(3222, 'Kafr el-Sheikh', 'EG', 'KFS', 1),
(3223, 'Cairo', 'EG', 'C', 1),
(3224, 'Damietta', 'EG', 'DT', 1),
(3225, 'Aswan', 'EG', 'ASN', 1),
(3226, 'Sohag', 'EG', 'SHG', 1),
(3227, 'North Sinai', 'EG', 'SIN', 1),
(3228, 'Monufia', 'EG', 'MNF', 1),
(3229, 'Port Said', 'EG', 'PTS', 1),
(3230, 'Beni Suef', 'EG', 'BNS', 1),
(3231, 'Matrouh', 'EG', 'MT', 1),
(3232, 'Qalyubia', 'EG', 'KB', 1),
(3233, 'Suez', 'EG', 'SUZ', 1),
(3234, 'Gharbia', 'EG', 'GH', 1),
(3235, 'Alexandria', 'EG', 'ALX', 1),
(3236, 'Asyut', 'EG', 'AST', 1),
(3237, 'South Sinai', 'EG', 'JS', 1),
(3238, 'Faiyum', 'EG', 'FYM', 1),
(3239, 'Giza', 'EG', 'GZ', 1),
(3240, 'Red Sea', 'EG', 'BA', 1),
(3241, 'Beheira', 'EG', 'BH', 1),
(3242, 'Luxor', 'EG', 'LX', 1),
(3243, 'Minya', 'EG', 'MN', 1),
(3244, 'Ismailia', 'EG', 'IS', 1),
(3245, 'Dakahlia', 'EG', 'DK', 1),
(3246, 'New Valley', 'EG', 'WAD', 1),
(3247, 'Qena', 'EG', 'KN', 1),
(3248, 'Agaléga', 'MU', 'AG', 1),
(3249, 'Rodrigues', 'MU', 'RO', 1),
(3250, 'Pamplemousses District', 'MU', 'PA', 1),
(3251, 'Cargados Carajos', 'MU', 'CC', 1),
(3252, 'Vacoas-Phoenix', 'MU', 'VP', 1),
(3253, 'Moka District', 'MU', 'MO', 1),
(3254, 'Flacq District', 'MU', 'FL', 1),
(3255, 'Curepipe', 'MU', 'CU', 1),
(3256, 'Port Louis', 'MU', 'PU', 1),
(3257, 'Savanne District', 'MU', 'SA', 1),
(3258, 'Quatre Bornes', 'MU', 'QB', 1),
(3259, 'Rivière Noire District', 'MU', 'BL', 1),
(3260, 'Port Louis District', 'MU', 'PL', 1),
(3261, 'Rivière du Rempart District', 'MU', 'RR', 1),
(3262, 'Beau Bassin-Rose Hill', 'MU', 'BR', 1),
(3263, 'Plaines Wilhems District', 'MU', 'PW', 1),
(3264, 'Grand Port District', 'MU', 'GP', 1),
(3265, 'Guelmim', 'MA', 'GUE', 1),
(3266, 'Aousserd (EH)', 'MA', 'AOU', 1),
(3267, 'Al Hoceïma', 'MA', 'HOC', 1),
(3268, 'Larache', 'MA', 'LAR', 1),
(3269, 'Ouarzazate', 'MA', 'OUA', 1),
(3270, 'Boulemane', 'MA', 'BOM', 1),
(3271, 'L\'Oriental', 'MA', '02', 1),
(3272, 'Béni Mellal', 'MA', 'BEM', 1),
(3274, 'Chichaoua', 'MA', 'CHI', 1),
(3275, 'Boujdour (EH)', 'MA', 'BOD', 1),
(3276, 'Khémisset', 'MA', 'KHE', 1),
(3277, 'Tiznit', 'MA', 'TIZ', 1),
(3278, 'Béni Mellal-Khénifra', 'MA', '05', 1),
(3279, 'Sidi Kacem', 'MA', 'SIK', 1),
(3280, 'El Jadida', 'MA', 'JDI', 1),
(3281, 'Nador', 'MA', 'NAD', 1),
(3282, 'Settat', 'MA', 'SET', 1),
(3283, 'Zagora', 'MA', 'ZAG', 1),
(3284, 'Médiouna', 'MA', 'MED', 1),
(3285, 'Berkane', 'MA', 'BER', 1),
(3286, 'Tan-Tan (EH-partial)', 'MA', 'TNT', 1),
(3287, 'Nouaceur', 'MA', 'NOU', 1),
(3288, 'Marrakesh-Safi', 'MA', '07', 1),
(3289, 'Sefrou', 'MA', 'SEF', 1),
(3290, 'Drâa-Tafilalet', 'MA', '08', 1),
(3291, 'El Hajeb', 'MA', 'HAJ', 1),
(3292, 'Es-Semara (EH-partial)', 'MA', 'ESM', 1),
(3293, 'Laâyoune (EH)', 'MA', 'LAA', 1),
(3294, 'Inezgane-Ait Melloul', 'MA', 'INE', 1),
(3295, 'Souss-Massa', 'MA', '09', 1),
(3296, 'Taza', 'MA', 'TAZ', 1),
(3297, 'Assa-Zag (EH-partial)', 'MA', 'ASZ', 1),
(3298, 'Laâyoune-Sakia El Hamra (EH-partial)', 'MA', '11', 1),
(3299, 'Errachidia', 'MA', 'ERR', 1),
(3300, 'Fahs-Anjra', 'MA', 'FAH', 1),
(3301, 'Figuig', 'MA', 'FIG', 1),
(3302, 'Chtouka-Ait Baha', 'MA', 'CHT', 1),
(3303, 'Casablanca-Settat', 'MA', '06', 1),
(3304, 'Benslimane', 'MA', 'BES', 1),
(3305, 'Guelmim-Oued Noun (EH-partial)', 'MA', '10', 1),
(3306, 'Dakhla-Oued Ed-Dahab (EH)', 'MA', '12', 1),
(3307, 'Jerada', 'MA', 'JRA', 1),
(3308, 'Kénitra', 'MA', 'KEN', 1),
(3309, 'El Kelâa des Sraghna', 'MA', 'KES', 1),
(3310, 'Chefchaouen', 'MA', 'CHE', 1),
(3311, 'Safi', 'MA', 'SAF', 1),
(3312, 'Tata', 'MA', 'TAT', 1),
(3313, 'Fès-Meknès', 'MA', '03', 1),
(3314, 'Taroudannt', 'MA', 'TAR', 1),
(3315, 'Moulay Yacoub', 'MA', 'MOU', 1),
(3316, 'Essaouira', 'MA', 'ESI', 1),
(3317, 'Khénifra', 'MA', 'KHN', 1),
(3318, 'Tétouan', 'MA', 'TET', 1),
(3319, 'Oued Ed-Dahab (EH)', 'MA', 'OUD', 1),
(3320, 'Al Haouz', 'MA', 'HAO', 1),
(3321, 'Azilal', 'MA', 'AZI', 1),
(3322, 'Taourirt', 'MA', 'TAI', 1),
(3323, 'Taounate', 'MA', 'TAO', 1),
(3324, 'Tanger-Tétouan-Al Hoceïma', 'MA', '01', 1),
(3325, 'Ifrane', 'MA', 'IFR', 1),
(3326, 'Khouribga', 'MA', 'KHO', 1),
(3327, 'Cabo Delgado Province', 'MZ', 'P', 1),
(3328, 'Zambezia Province', 'MZ', 'Q', 1),
(3329, 'Gaza Province', 'MZ', 'G', 1),
(3330, 'Inhambane Province', 'MZ', 'I', 1),
(3331, 'Sofala Province', 'MZ', 'S', 1),
(3332, 'Maputo Province', 'MZ', 'L', 1),
(3333, 'Niassa Province', 'MZ', 'A', 1),
(3334, 'Tete Province', 'MZ', 'T', 1),
(3335, 'Maputo', 'MZ', 'MPM', 1),
(3336, 'Nampula Province', 'MZ', 'N', 1),
(3337, 'Manica Province', 'MZ', 'B', 1),
(3338, 'Hodh Ech Chargui', 'MR', '01', 1),
(3339, 'Brakna', 'MR', '05', 1),
(3340, 'Tiris Zemmour', 'MR', '11', 1),
(3341, 'Gorgol', 'MR', '04', 1),
(3342, 'Inchiri', 'MR', '12', 1),
(3343, 'Nouakchott-Nord', 'MR', '14', 1),
(3344, 'Adrar', 'MR', '07', 1),
(3345, 'Tagant', 'MR', '09', 1),
(3346, 'Dakhlet Nouadhibou', 'MR', '08', 1),
(3347, 'Nouakchott-Sud', 'MR', '15', 1),
(3348, 'Trarza', 'MR', '06', 1),
(3349, 'Assaba', 'MR', '03', 1),
(3350, 'Guidimaka', 'MR', '10', 1),
(3351, 'Hodh El Gharbi', 'MR', '02', 1),
(3352, 'Nouakchott-Ouest', 'MR', '13', 1),
(3353, 'Western Tobago', 'TT', 'WTO', 1),
(3354, 'Couva-Tabaquite-Talparo Regional Corporation', 'TT', 'CTT', 1),
(3355, 'Eastern Tobago', 'TT', 'ETO', 1),
(3356, 'Rio Claro-Mayaro Regional Corporation', 'TT', 'MRC', 1),
(3357, 'San Juan-Laventille Regional Corporation', 'TT', 'SJL', 1),
(3358, 'Tunapuna-Piarco Regional Corporation', 'TT', 'TUP', 1),
(3359, 'San Fernando', 'TT', 'SFO', 1),
(3360, 'Point Fortin', 'TT', 'PTF', 1),
(3361, 'Sangre Grande Regional Corporation', 'TT', 'SGE', 1),
(3362, 'Arima', 'TT', 'ARI', 1),
(3363, 'Port of Spain', 'TT', 'POS', 1),
(3364, 'Siparia Regional Corporation', 'TT', 'SIP', 1),
(3365, 'Penal-Debe Regional Corporation', 'TT', 'PED', 1),
(3366, 'Chaguanas', 'TT', 'CHA', 1),
(3367, 'Diego Martin Regional Corporation', 'TT', 'DMN', 1),
(3368, 'Princes Town Regional Corporation', 'TT', 'PRT', 1),
(3369, 'Mary Region', 'TM', 'M', 1),
(3370, 'Lebap Region', 'TM', 'L', 1),
(3371, 'Ashgabat', 'TM', 'S', 1),
(3372, 'Balkan Region', 'TM', 'B', 1),
(3373, 'Daşoguz Region', 'TM', 'D', 1),
(3374, 'Ahal Region', 'TM', 'A', 1),
(3375, 'Beni Department', 'BO', 'B', 1),
(3376, 'Oruro Department', 'BO', 'O', 1),
(3377, 'Santa Cruz Department', 'BO', 'S', 1),
(3378, 'Tarija Department', 'BO', 'T', 1),
(3379, 'Pando Department', 'BO', 'N', 1),
(3380, 'La Paz Department', 'BO', 'L', 1),
(3381, 'Cochabamba Department', 'BO', 'C', 1),
(3382, 'Chuquisaca Department', 'BO', 'H', 1),
(3383, 'Potosí Department', 'BO', 'P', 1),
(3384, 'Saint George Parish', 'VC', '04', 1),
(3385, 'Saint Patrick Parish', 'VC', '05', 1),
(3386, 'Saint Andrew Parish', 'VC', '02', 1),
(3387, 'Saint David Parish', 'VC', '03', 1),
(3388, 'Grenadines Parish', 'VC', '06', 1),
(3389, 'Charlotte Parish', 'VC', '01', 1),
(3390, 'Sharjah Emirate', 'AE', 'SH', 1),
(3391, 'Dubai', 'AE', 'DU', 1),
(3392, 'Umm al-Quwain', 'AE', 'UQ', 1),
(3393, 'Fujairah', 'AE', 'FU', 1),
(3394, 'Ras al-Khaimah', 'AE', 'RK', 1),
(3395, 'Ajman Emirate', 'AE', 'AJ', 1),
(3396, 'Abu Dhabi Emirate', 'AE', 'AZ', 1),
(3397, 'districts of Republican Subordination', 'TJ', 'RA', 1),
(3398, 'Khatlon Province', 'TJ', 'KT', 1),
(3399, 'Gorno-Badakhshan Autonomous Province', 'TJ', 'GB', 1),
(3400, 'Sughd Province', 'TJ', 'SU', 1),
(3402, 'Yilan', 'TW', 'ILA', 1),
(3403, 'Penghu', 'TW', 'PEN', 1),
(3404, 'Changhua', 'TW', 'CHA', 1),
(3405, 'Pingtung', 'TW', 'PIF', 1),
(3406, 'Taichung', 'TW', 'TXG', 1),
(3407, 'Nantou', 'TW', 'NAN', 1),
(3408, 'Chiayi', 'TW', 'CYI', 1),
(3410, 'Taitung', 'TW', 'TTT', 1),
(3411, 'Hualien', 'TW', 'HUA', 1),
(3412, 'Kaohsiung', 'TW', 'KHH', 1),
(3413, 'Miaoli', 'TW', 'MIA', 1),
(3415, 'Kinmen', 'TW', 'KIN', 1),
(3416, 'Yunlin', 'TW', 'YUN', 1),
(3417, 'Hsinchu', 'TW', 'HSZ', 1),
(3418, 'Chiayi', 'TW', 'CYQ', 1),
(3419, 'Taoyuan', 'TW', 'TAO', 1),
(3420, 'Lienchiang', 'TW', 'LIE', 1),
(3421, 'Tainan', 'TW', 'TNN', 1),
(3422, 'Taipei', 'TW', 'TPE', 1),
(3423, 'Hsinchu', 'TW', 'HSQ', 1),
(3424, 'Northern Red Sea Region', 'ER', 'SK', 1),
(3425, 'Anseba Region', 'ER', 'AN', 1),
(3426, 'Maekel Region', 'ER', 'MA', 1),
(3427, 'Debub Region', 'ER', 'DU', 1),
(3428, 'Gash-Barka Region', 'ER', 'GB', 1),
(3429, 'Southern Red Sea Region', 'ER', 'DK', 1),
(3430, 'Southern Peninsula Region', 'IS', '2', 1),
(3431, 'Capital Region', 'IS', '1', 1),
(3432, 'Westfjords', 'IS', '4', 1),
(3433, 'Eastern Region', 'IS', '7', 1),
(3434, 'Southern Region', 'IS', '8', 1),
(3435, 'Northwestern Region', 'IS', '5', 1),
(3436, 'Western Region', 'IS', '3', 1),
(3437, 'Northeastern Region', 'IS', '6', 1),
(3438, 'Río Muni', 'GQ', 'C', 1),
(3439, 'Kié-Ntem Province', 'GQ', 'KN', 1),
(3440, 'Wele-Nzas Province', 'GQ', 'WN', 1),
(3441, 'Litoral Province', 'GQ', 'LI', 1),
(3442, 'Insular Region', 'GQ', 'I', 1),
(3443, 'Bioko Sur Province', 'GQ', 'BS', 1),
(3444, 'Annobón Province', 'GQ', 'AN', 1),
(3445, 'Centro Sur Province', 'GQ', 'CS', 1),
(3446, 'Bioko Norte Province', 'GQ', 'BN', 1),
(3447, 'Chihuahua', 'MX', 'CHH', 1),
(3448, 'Oaxaca', 'MX', 'OAX', 1),
(3449, 'Sinaloa', 'MX', 'SIN', 1),
(3450, 'Estado de México', 'MX', 'MEX', 1),
(3451, 'Chiapas', 'MX', 'CHP', 1),
(3452, 'Nuevo León', 'MX', 'NLE', 1),
(3453, 'Durango', 'MX', 'DUR', 1),
(3454, 'Tabasco', 'MX', 'TAB', 1),
(3455, 'Querétaro', 'MX', 'QUE', 1),
(3456, 'Aguascalientes', 'MX', 'AGU', 1),
(3457, 'Baja California', 'MX', 'BCN', 1),
(3458, 'Tlaxcala', 'MX', 'TLA', 1),
(3459, 'Guerrero', 'MX', 'GRO', 1),
(3460, 'Baja California Sur', 'MX', 'BCS', 1),
(3461, 'San Luis Potosí', 'MX', 'SLP', 1),
(3462, 'Zacatecas', 'MX', 'ZAC', 1),
(3463, 'Tamaulipas', 'MX', 'TAM', 1),
(3464, 'Veracruz de Ignacio de la Llave', 'MX', 'VER', 1),
(3465, 'Morelos', 'MX', 'MOR', 1),
(3466, 'Yucatán', 'MX', 'YUC', 1),
(3467, 'Quintana Roo', 'MX', 'ROO', 1),
(3468, 'Sonora', 'MX', 'SON', 1),
(3469, 'Guanajuato', 'MX', 'GUA', 1),
(3470, 'Hidalgo', 'MX', 'HID', 1),
(3471, 'Coahuila de Zaragoza', 'MX', 'COA', 1),
(3472, 'Colima', 'MX', 'COL', 1),
(3473, 'Ciudad de México', 'MX', 'CDMX', 1),
(3474, 'Michoacán de Ocampo', 'MX', 'MIC', 1),
(3475, 'Campeche', 'MX', 'CAM', 1),
(3476, 'Puebla', 'MX', 'PUE', 1),
(3477, 'Nayarit', 'MX', 'NAY', 1),
(3478, 'Krabi', 'TH', '81', 1),
(3479, 'Ranong', 'TH', '85', 1),
(3480, 'Nong Bua Lam Phu', 'TH', '39', 1),
(3481, 'Samut Prakan', 'TH', '11', 1),
(3482, 'Surat Thani', 'TH', '84', 1),
(3483, 'Lamphun', 'TH', '51', 1),
(3484, 'Nong Khai', 'TH', '43', 1),
(3485, 'Khon Kaen', 'TH', '40', 1),
(3486, 'Chanthaburi', 'TH', '22', 1),
(3487, 'Saraburi', 'TH', '19', 1),
(3488, 'Phatthalung', 'TH', '93', 1),
(3489, 'Uttaradit', 'TH', '53', 1),
(3490, 'Sing Buri', 'TH', '17', 1),
(3491, 'Chiang Mai', 'TH', '50', 1),
(3492, 'Nakhon Sawan', 'TH', '60', 1),
(3493, 'Yala', 'TH', '95', 1),
(3494, 'Phra Nakhon Si Ayutthaya', 'TH', '14', 1),
(3495, 'Nonthaburi', 'TH', '12', 1),
(3496, 'Trat', 'TH', '23', 1),
(3497, 'Nakhon Ratchasima', 'TH', '30', 1),
(3498, 'Chiang Rai', 'TH', '57', 1),
(3499, 'Ratchaburi', 'TH', '70', 1),
(3500, 'Pathum Thani', 'TH', '13', 1),
(3501, 'Sakon Nakhon', 'TH', '47', 1),
(3502, 'Samut Songkhram', 'TH', '75', 1),
(3503, 'Nakhon Pathom', 'TH', '73', 1),
(3504, 'Samut Sakhon', 'TH', '74', 1),
(3505, 'Mae Hong Son', 'TH', '58', 1),
(3506, 'Phitsanulok', 'TH', '65', 1),
(3507, 'Pattaya', 'TH', 'S', 1),
(3508, 'Prachuap Khiri Khan', 'TH', '77', 1),
(3509, 'Loei', 'TH', '42', 1),
(3510, 'Roi Et', 'TH', '45', 1),
(3511, 'Kanchanaburi', 'TH', '71', 1),
(3512, 'Ubon Ratchathani', 'TH', '34', 1),
(3513, 'Chon Buri', 'TH', '20', 1),
(3514, 'Phichit', 'TH', '66', 1),
(3515, 'Phetchabun', 'TH', '67', 1),
(3516, 'Kamphaeng Phet', 'TH', '62', 1),
(3517, 'Maha Sarakham', 'TH', '44', 1),
(3518, 'Rayong', 'TH', '21', 1),
(3519, 'Ang Thong', 'TH', '15', 1),
(3520, 'Nakhon Si Thammarat', 'TH', '80', 1),
(3521, 'Yasothon', 'TH', '35', 1),
(3522, 'Chai Nat', 'TH', '18', 1),
(3523, 'Amnat Charoen', 'TH', '37', 1),
(3524, 'Suphan Buri', 'TH', '72', 1),
(3525, 'Tak', 'TH', '63', 1),
(3526, 'Chumphon', 'TH', '86', 1),
(3527, 'Udon Thani', 'TH', '41', 1),
(3528, 'Phrae', 'TH', '54', 1),
(3529, 'Sa Kaeo', 'TH', '27', 1),
(3530, 'Nan', 'TH', '55', 1),
(3531, 'Surin', 'TH', '32', 1),
(3532, 'Phetchaburi', 'TH', '76', 1),
(3533, 'Bueng Kan', 'TH', '38', 1),
(3534, 'Buri Ram', 'TH', '31', 1),
(3535, 'Nakhon Nayok', 'TH', '26', 1),
(3536, 'Phuket', 'TH', '83', 1),
(3537, 'Satun', 'TH', '91', 1),
(3538, 'Phayao', 'TH', '56', 1),
(3539, 'Songkhla', 'TH', '90', 1),
(3540, 'Pattani', 'TH', '94', 1),
(3541, 'Trang', 'TH', '92', 1),
(3542, 'Prachin Buri', 'TH', '25', 1),
(3543, 'Lop Buri', 'TH', '16', 1),
(3544, 'Lampang', 'TH', '52', 1),
(3545, 'Sukhothai', 'TH', '64', 1),
(3546, 'Mukdahan', 'TH', '49', 1),
(3547, 'Si Sa Ket', 'TH', '33', 1),
(3548, 'Nakhon Phanom', 'TH', '48', 1),
(3549, 'Phangnga', 'TH', '82', 1),
(3550, 'Kalasin', 'TH', '46', 1),
(3551, 'Uthai Thani', 'TH', '61', 1),
(3552, 'Chachoengsao', 'TH', '24', 1),
(3553, 'Narathiwat', 'TH', '96', 1),
(3554, 'Bangkok', 'TH', '10', 1),
(3555, 'Hiiu County', 'EE', '39', 1),
(3556, 'Viljandi County', 'EE', '84', 1),
(3557, 'Tartu County', 'EE', '78', 1),
(3558, 'Valga County', 'EE', '82', 1),
(3559, 'Rapla County', 'EE', '70', 1),
(3560, 'Võru County', 'EE', '86', 1),
(3561, 'Saare County', 'EE', '74', 1),
(3562, 'Pärnu County', 'EE', '67', 1),
(3563, 'Põlva County', 'EE', '65', 1),
(3564, 'Lääne-Viru County', 'EE', '59', 1),
(3565, 'Jõgeva County', 'EE', '49', 1),
(3566, 'Järva County', 'EE', '51', 1),
(3567, 'Harju County', 'EE', '37', 1),
(3568, 'Lääne County', 'EE', '57', 1),
(3569, 'Ida-Viru County', 'EE', '44', 1),
(3570, 'Moyen-Chari', 'TD', 'MC', 1),
(3571, 'Mayo-Kebbi Ouest', 'TD', 'MO', 1),
(3572, 'Sila', 'TD', 'SI', 1),
(3573, 'Hadjer-Lamis', 'TD', 'HL', 1),
(3574, 'Borkou', 'TD', 'BO', 1),
(3575, 'Ennedi-Est', 'TD', 'EE', 1),
(3576, 'Guéra', 'TD', 'GR', 1),
(3577, 'Lac', 'TD', 'LC', 1),
(3579, 'Tandjilé', 'TD', 'TA', 1),
(3580, 'Mayo-Kebbi Est', 'TD', 'ME', 1),
(3581, 'Wadi Fira', 'TD', 'WF', 1),
(3582, 'Ouaddaï', 'TD', 'OD', 1),
(3583, 'Bahr el Gazel', 'TD', 'BG', 1),
(3584, 'Ennedi-Ouest', 'TD', 'EO', 1),
(3585, 'Logone Occidental', 'TD', 'LO', 1),
(3586, 'N\'Djamena', 'TD', 'ND', 1),
(3587, 'Tibesti', 'TD', 'TI', 1),
(3588, 'Kanem', 'TD', 'KA', 1),
(3589, 'Mandoul', 'TD', 'MA', 1),
(3590, 'Batha', 'TD', 'BA', 1),
(3591, 'Logone Oriental', 'TD', 'LR', 1),
(3592, 'Salamat', 'TD', 'SA', 1),
(3593, 'Berry Islands', 'BS', 'BY', 1),
(3594, 'Nichollstown and Berry Islands', 'BS', 'NB', 1),
(3595, 'Green Turtle Cay', 'BS', 'GT', 1),
(3596, 'Central Eleuthera', 'BS', 'CE', 1),
(3597, 'Governor\'s Harbour', 'BS', 'GH', 1),
(3598, 'High Rock', 'BS', 'HR', 1),
(3599, 'West Grand Bahama', 'BS', 'WG', 1),
(3600, 'Rum Cay District', 'BS', 'RC', 1),
(3601, 'Acklins', 'BS', 'AK', 1),
(3602, 'North Eleuthera', 'BS', 'NE', 1),
(3603, 'Central Abaco', 'BS', 'CO', 1),
(3604, 'Marsh Harbour', 'BS', 'MH', 1),
(3605, 'Black Point', 'BS', 'BP', 1),
(3606, 'Sandy Point', 'BS', 'SP', 1),
(3607, 'South Eleuthera', 'BS', 'SE', 1),
(3608, 'South Abaco', 'BS', 'SO', 1),
(3609, 'Inagua', 'BS', 'IN', 1),
(3610, 'Long Island', 'BS', 'LI', 1),
(3611, 'Cat Island', 'BS', 'CI', 1),
(3612, 'Exuma', 'BS', 'EX', 1),
(3613, 'Harbour Island', 'BS', 'HI', 1),
(3614, 'East Grand Bahama', 'BS', 'EG', 1),
(3615, 'Ragged Island', 'BS', 'RI', 1),
(3616, 'North Abaco', 'BS', 'NO', 1),
(3617, 'North Andros', 'BS', 'NS', 1),
(3618, 'Kemps Bay', 'BS', 'KB', 1),
(3619, 'Fresh Creek', 'BS', 'FC', 1),
(3620, 'San Salvador and Rum Cay', 'BS', 'SR', 1),
(3621, 'Crooked Island', 'BS', 'CK', 1),
(3622, 'South Andros', 'BS', 'SA', 1),
(3623, 'Rock Sound', 'BS', 'RS', 1),
(3624, 'Hope Town', 'BS', 'HT', 1),
(3625, 'Mangrove Cay', 'BS', 'MC', 1),
(3626, 'Freeport', 'BS', 'FP', 1),
(3627, 'San Salvador Island', 'BS', 'SS', 1),
(3628, 'Acklins and Crooked Islands', 'BS', 'AC', 1),
(3629, 'Bimini', 'BS', 'BI', 1),
(3630, 'Spanish Wells', 'BS', 'SW', 1),
(3631, 'Central Andros', 'BS', 'CS', 1),
(3632, 'Grand Cay', 'BS', 'GC', 1),
(3633, 'Mayaguana District', 'BS', 'MG', 1),
(3634, 'San Juan', 'AR', 'J', 1),
(3635, 'Santiago del Estero', 'AR', 'G', 1),
(3636, 'San Luis', 'AR', 'D', 1),
(3637, 'Tucumán', 'AR', 'T', 1),
(3638, 'Corrientes', 'AR', 'W', 1),
(3639, 'Río Negro', 'AR', 'R', 1),
(3640, 'Chaco', 'AR', 'H', 1),
(3641, 'Santa Fe', 'AR', 'S', 1),
(3642, 'Córdoba', 'AR', 'X', 1),
(3643, 'Salta', 'AR', 'A', 1),
(3644, 'Misiones', 'AR', 'N', 1),
(3645, 'Jujuy', 'AR', 'Y', 1),
(3646, 'Mendoza', 'AR', 'M', 1),
(3647, 'Catamarca', 'AR', 'K', 1),
(3648, 'Neuquén', 'AR', 'Q', 1),
(3649, 'Santa Cruz', 'AR', 'Z', 1),
(3650, 'Tierra del Fuego', 'AR', 'V', 1),
(3651, 'Chubut', 'AR', 'U', 1),
(3652, 'Formosa', 'AR', 'P', 1),
(3653, 'La Rioja', 'AR', 'F', 1),
(3654, 'Entre Ríos', 'AR', 'E', 1),
(3655, 'La Pampa', 'AR', 'L', 1),
(3656, 'Buenos Aires', 'AR', 'B', 1),
(3657, 'Quiché Department', 'GT', 'QC', 1),
(3658, 'Jalapa Department', 'GT', 'JA', 1),
(3659, 'Izabal Department', 'GT', 'IZ', 1),
(3660, 'Suchitepéquez Department', 'GT', 'SU', 1),
(3661, 'Sololá Department', 'GT', 'SO', 1),
(3662, 'El Progreso Department', 'GT', 'PR', 1),
(3663, 'Totonicapán Department', 'GT', 'TO', 1),
(3664, 'Retalhuleu Department', 'GT', 'RE', 1),
(3665, 'Santa Rosa Department', 'GT', 'SR', 1),
(3666, 'Chiquimula Department', 'GT', 'CQ', 1),
(3667, 'San Marcos Department', 'GT', 'SM', 1),
(3668, 'Quetzaltenango Department', 'GT', 'QZ', 1),
(3669, 'Petén Department', 'GT', 'PE', 1),
(3670, 'Huehuetenango Department', 'GT', 'HU', 1),
(3671, 'Alta Verapaz Department', 'GT', 'AV', 1),
(3672, 'Guatemala Department', 'GT', 'GU', 1),
(3673, 'Jutiapa Department', 'GT', 'JU', 1),
(3674, 'Baja Verapaz Department', 'GT', 'BV', 1),
(3675, 'Chimaltenango Department', 'GT', 'CM', 1),
(3676, 'Sacatepéquez Department', 'GT', 'SA', 1),
(3677, 'Escuintla Department', 'GT', 'ES', 1),
(3678, 'Madre de Dios', 'PE', 'MDD', 1),
(3679, 'Huancavelica', 'PE', 'HUV', 1),
(3680, 'Áncash', 'PE', 'ANC', 1),
(3681, 'Arequipa', 'PE', 'ARE', 1),
(3682, 'Puno', 'PE', 'PUN', 1),
(3683, 'La Libertad', 'PE', 'LAL', 1),
(3684, 'Ucayali', 'PE', 'UCA', 1),
(3685, 'Amazonas', 'PE', 'AMA', 1),
(3686, 'Pasco', 'PE', 'PAS', 1),
(3687, 'Huanuco', 'PE', 'HUC', 1),
(3688, 'Cajamarca', 'PE', 'CAJ', 1),
(3689, 'Tumbes', 'PE', 'TUM', 1),
(3691, 'Cusco', 'PE', 'CUS', 1),
(3692, 'Ayacucho', 'PE', 'AYA', 1),
(3693, 'Junín', 'PE', 'JUN', 1),
(3694, 'San Martín', 'PE', 'SAM', 1),
(3695, 'Lima', 'PE', 'LIM', 1),
(3696, 'Tacna', 'PE', 'TAC', 1),
(3697, 'Piura', 'PE', 'PIU', 1),
(3698, 'Moquegua', 'PE', 'MOQ', 1),
(3699, 'Apurímac', 'PE', 'APU', 1),
(3700, 'Ica', 'PE', 'ICA', 1),
(3701, 'Callao', 'PE', 'CAL', 1),
(3702, 'Lambayeque', 'PE', 'LAM', 1),
(3703, 'Redonda', 'AG', '11', 1),
(3704, 'Saint Peter Parish', 'AG', '07', 1),
(3705, 'Saint Paul Parish', 'AG', '06', 1),
(3706, 'Saint John Parish', 'AG', '04', 1),
(3707, 'Saint Mary Parish', 'AG', '05', 1),
(3708, 'Barbuda', 'AG', '10', 1),
(3709, 'Saint George Parish', 'AG', '03', 1),
(3710, 'Saint Philip Parish', 'AG', '08', 1),
(3711, 'South Bačka District', 'RS', '06', 1),
(3712, 'Pirot District', 'RS', '22', 1),
(3713, 'South Banat District', 'RS', '04', 1),
(3714, 'North Bačka District', 'RS', '01', 1),
(3715, 'Jablanica District', 'RS', '23', 1),
(3716, 'Central Banat District', 'RS', '02', 1),
(3717, 'Bor District', 'RS', '14', 1),
(3718, 'Toplica District', 'RS', '21', 1),
(3719, 'Mačva District', 'RS', '08', 1),
(3720, 'Rasina District', 'RS', '19', 1),
(3721, 'Pčinja District', 'RS', '24', 1),
(3722, 'Nišava District', 'RS', '20', 1),
(3723, 'Prizren District', 'XK', 'XPR', 1),
(3724, 'Kolubara District', 'RS', '09', 1),
(3725, 'Raška District', 'RS', '18', 1),
(3726, 'West Bačka District', 'RS', '05', 1),
(3727, 'Moravica District', 'RS', '17', 1),
(3728, 'Belgrade', 'RS', '00', 1),
(3729, 'Zlatibor District', 'RS', '16', 1),
(3731, 'Zaječar District', 'RS', '15', 1),
(3732, 'Braničevo District', 'RS', '11', 1),
(3733, 'Vojvodina', 'RS', 'VO', 1),
(3734, 'Šumadija District', 'RS', '12', 1),
(3736, 'North Banat District', 'RS', '03', 1),
(3737, 'Pomoravlje District', 'RS', '13', 1),
(3738, 'Peć District', 'XK', 'XPE', 1),
(3740, 'Srem District', 'RS', '07', 1),
(3741, 'Podunavlje District', 'RS', '10', 1),
(3742, 'Westmoreland Parish', 'JM', '10', 1),
(3743, 'Saint Elizabeth Parish', 'JM', '11', 1),
(3744, 'Saint Ann Parish', 'JM', '06', 1),
(3745, 'Saint James Parish', 'JM', '08', 1),
(3746, 'Saint Catherine Parish', 'JM', '14', 1),
(3747, 'Saint Mary Parish', 'JM', '05', 1),
(3748, 'Kingston Parish', 'JM', '01', 1),
(3749, 'Hanover Parish', 'JM', '09', 1),
(3750, 'Saint Thomas Parish', 'JM', '03', 1),
(3751, 'Saint Andrew', 'JM', '02', 1),
(3752, 'Portland Parish', 'JM', '04', 1),
(3753, 'Clarendon Parish', 'JM', '13', 1),
(3754, 'Manchester Parish', 'JM', '12', 1),
(3755, 'Trelawny Parish', 'JM', '07', 1),
(3756, 'Dennery Quarter', 'LC', '05', 1),
(3757, 'Anse la Raye Quarter', 'LC', '01', 1),
(3758, 'Castries Quarter', 'LC', '02', 1),
(3759, 'Laborie Quarter', 'LC', '07', 1),
(3760, 'Choiseul Quarter', 'LC', '03', 1),
(3761, 'Canaries', 'LC', '12', 1),
(3762, 'Micoud Quarter', 'LC', '08', 1),
(3763, 'Vieux Fort Quarter', 'LC', '11', 1),
(3764, 'Soufrière Quarter', 'LC', '10', 1),
(3765, 'Praslin Quarter', 'LC', '09', 1),
(3766, 'Gros Islet Quarter', 'LC', '06', 1),
(3767, 'Dauphin Quarter', 'LC', '04', 1),
(3768, 'Hưng Yên', 'VN', '66', 1),
(3769, 'Đồng Tháp', 'VN', '45', 1),
(3770, 'Bà Rịa-Vũng Tàu', 'VN', '43', 1),
(3771, 'Thanh Hóa', 'VN', '21', 1),
(3772, 'Kon Tum', 'VN', '28', 1),
(3773, 'Điện Biên', 'VN', '71', 1),
(3774, 'Vĩnh Phúc', 'VN', '70', 1),
(3775, 'Thái Bình', 'VN', '20', 1),
(3776, 'Quảng Nam', 'VN', '27', 1),
(3777, 'Hậu Giang', 'VN', '73', 1),
(3778, 'Cà Mau', 'VN', '59', 1),
(3779, 'Hà Giang', 'VN', '03', 1),
(3780, 'Nghệ An', 'VN', '22', 1),
(3781, 'Tiền Giang', 'VN', '46', 1),
(3782, 'Cao Bằng', 'VN', '04', 1),
(3783, 'Hải Phòng', 'VN', 'HP', 1),
(3784, 'Yên Bái', 'VN', '06', 1),
(3785, 'Bình Dương', 'VN', '57', 1),
(3786, 'Ninh Bình', 'VN', '18', 1),
(3787, 'Bình Thuận', 'VN', '40', 1),
(3788, 'Ninh Thuận', 'VN', '36', 1),
(3789, 'Nam Định', 'VN', '67', 1),
(3790, 'Vĩnh Long', 'VN', '49', 1),
(3791, 'Bắc Ninh', 'VN', '56', 1),
(3792, 'Lạng Sơn', 'VN', '09', 1),
(3793, 'Khánh Hòa', 'VN', '34', 1),
(3794, 'An Giang', 'VN', '44', 1),
(3795, 'Tuyên Quang', 'VN', '07', 1),
(3796, 'Bến Tre', 'VN', '50', 1),
(3797, 'Bình Phước', 'VN', '58', 1),
(3798, 'Thừa Thiên-Huế', 'VN', '26', 1),
(3799, 'Hòa Bình', 'VN', '14', 1),
(3800, 'Kiên Giang', 'VN', '47', 1),
(3801, 'Phú Thọ', 'VN', '68', 1),
(3802, 'Hà Nam', 'VN', '63', 1),
(3803, 'Quảng Trị', 'VN', '25', 1),
(3804, 'Bạc Liêu', 'VN', '55', 1),
(3805, 'Trà Vinh', 'VN', '51', 1),
(3806, 'Đà Nẵng', 'VN', 'DN', 1),
(3807, 'Thái Nguyên', 'VN', '69', 1),
(3808, 'Long An', 'VN', '41', 1),
(3809, 'Quảng Bình', 'VN', '24', 1),
(3810, 'Hà Nội', 'VN', 'HN', 1),
(3811, 'Hồ Chí Minh', 'VN', 'SG', 1),
(3812, 'Sơn La', 'VN', '05', 1),
(3813, 'Gia Lai', 'VN', '30', 1),
(3814, 'Quảng Ninh', 'VN', '13', 1),
(3815, 'Bắc Giang', 'VN', '54', 1),
(3816, 'Hà Tĩnh', 'VN', '23', 1),
(3817, 'Lào Cai', 'VN', '02', 1),
(3818, 'Lâm Đồng', 'VN', '35', 1),
(3819, 'Sóc Trăng', 'VN', '52', 1),
(3821, 'Đồng Nai', 'VN', '39', 1),
(3822, 'Bắc Kạn', 'VN', '53', 1),
(3823, 'Đắk Nông', 'VN', '72', 1),
(3824, 'Phú Yên', 'VN', '32', 1),
(3825, 'Lai Châu', 'VN', '01', 1),
(3826, 'Tây Ninh', 'VN', '37', 1),
(3827, 'Hải Dương', 'VN', '61', 1),
(3828, 'Quảng Ngãi', 'VN', '29', 1),
(3829, 'Đắk Lắk', 'VN', '33', 1),
(3830, 'Bình Định', 'VN', '31', 1),
(3831, 'Saint Peter Basseterre Parish', 'KN', '11', 1),
(3832, 'Nevis', 'KN', 'N', 1),
(3833, 'Christ Church Nichola Town Parish', 'KN', '01', 1),
(3834, 'Saint Paul Capisterre Parish', 'KN', '09', 1),
(3835, 'Saint James Windward Parish', 'KN', '05', 1),
(3836, 'Saint Anne Sandy Point Parish', 'KN', '02', 1),
(3837, 'Saint George Gingerland Parish', 'KN', '04', 1),
(3838, 'Saint Paul Charlestown Parish', 'KN', '10', 1),
(3839, 'Saint Thomas Lowland Parish', 'KN', '12', 1),
(3840, 'Saint John Figtree Parish', 'KN', '07', 1),
(3841, 'Saint Kitts', 'KN', 'K', 1),
(3842, 'Saint Thomas Middle Island Parish', 'KN', '13', 1),
(3843, 'Trinity Palmetto Point Parish', 'KN', '15', 1),
(3844, 'Saint Mary Cayon Parish', 'KN', '08', 1),
(3845, 'Saint John Capisterre Parish', 'KN', '06', 1),
(3846, 'Daegu', 'KR', '27', 1),
(3847, 'Gyeonggi Province', 'KR', '41', 1),
(3848, 'Incheon', 'KR', '28', 1),
(3849, 'Seoul', 'KR', '11', 1),
(3850, 'Daejeon', 'KR', '30', 1),
(3851, 'North Jeolla Province', 'KR', '45', 1),
(3852, 'Ulsan', 'KR', '31', 1),
(3853, 'Jeju', 'KR', '49', 1),
(3854, 'North Chungcheong Province', 'KR', '43', 1),
(3855, 'North Gyeongsang Province', 'KR', '47', 1),
(3856, 'South Jeolla Province', 'KR', '46', 1),
(3857, 'South Gyeongsang Province', 'KR', '48', 1),
(3858, 'Gwangju', 'KR', '29', 1),
(3859, 'South Chungcheong Province', 'KR', '44', 1),
(3860, 'Busan', 'KR', '26', 1),
(3861, 'Sejong City', 'KR', '50', 1),
(3862, 'Gangwon Province', 'KR', '42', 1),
(3863, 'Saint Patrick Parish', 'GD', '06', 1),
(3864, 'Saint George Parish', 'GD', '03', 1),
(3865, 'Saint Andrew Parish', 'GD', '01', 1),
(3866, 'Saint Mark Parish', 'GD', '05', 1),
(3867, 'Carriacou and Petite Martinique', 'GD', '10', 1),
(3868, 'Saint John Parish', 'GD', '04', 1),
(3869, 'Saint David Parish', 'GD', '02', 1),
(3870, 'Ghazni', 'AF', 'GHA', 1),
(3871, 'Badghis', 'AF', 'BDG', 1),
(3872, 'Bamyan', 'AF', 'BAM', 1),
(3873, 'Helmand', 'AF', 'HEL', 1),
(3874, 'Zabul', 'AF', 'ZAB', 1),
(3875, 'Baghlan', 'AF', 'BGL', 1),
(3876, 'Kunar', 'AF', 'KNR', 1),
(3877, 'Paktika', 'AF', 'PKA', 1),
(3878, 'Khost', 'AF', 'KHO', 1),
(3879, 'Kapisa', 'AF', 'KAP', 1),
(3880, 'Nuristan', 'AF', 'NUR', 1),
(3881, 'Panjshir', 'AF', 'PAN', 1),
(3882, 'Nangarhar', 'AF', 'NAN', 1),
(3883, 'Samangan', 'AF', 'SAM', 1),
(3884, 'Balkh', 'AF', 'BAL', 1),
(3885, 'Sar-e Pol', 'AF', 'SAR', 1),
(3886, 'Jowzjan', 'AF', 'JOW', 1),
(3887, 'Herat', 'AF', 'HER', 1),
(3888, 'Ghōr', 'AF', 'GHO', 1),
(3889, 'Faryab', 'AF', 'FYB', 1),
(3890, 'Kandahar', 'AF', 'KAN', 1),
(3891, 'Laghman', 'AF', 'LAG', 1),
(3892, 'Daykundi', 'AF', 'DAY', 1),
(3893, 'Takhar', 'AF', 'TAK', 1),
(3894, 'Paktia', 'AF', 'PIA', 1),
(3895, 'Parwan', 'AF', 'PAR', 1),
(3896, 'Nimruz', 'AF', 'NIM', 1),
(3897, 'Logar', 'AF', 'LOG', 1),
(3898, 'Urozgan', 'AF', 'URU', 1),
(3899, 'Farah', 'AF', 'FRA', 1),
(3900, 'Kunduz Province', 'AF', 'KDZ', 1),
(3901, 'Badakhshan', 'AF', 'BDS', 1),
(3902, 'Kabul', 'AF', 'KAB', 1),
(3903, 'Victoria', 'AU', 'VIC', 1),
(3904, 'South Australia', 'AU', 'SA', 1),
(3905, 'Queensland', 'AU', 'QLD', 1),
(3906, 'Western Australia', 'AU', 'WA', 1),
(3907, 'Australian Capital Territory', 'AU', 'ACT', 1),
(3908, 'Tasmania', 'AU', 'TAS', 1),
(3909, 'New South Wales', 'AU', 'NSW', 1),
(3910, 'Northern Territory', 'AU', 'NT', 1),
(3911, 'Vavaʻu', 'TO', '05', 1),
(3912, 'Tongatapu', 'TO', '04', 1),
(3913, 'Haʻapai', 'TO', '02', 1),
(3914, 'Niuas', 'TO', '03', 1),
(3915, 'ʻEua', 'TO', '01', 1),
(3916, 'Markazi', 'IR', '00', 1),
(3917, 'Khuzestan', 'IR', '06', 1),
(3918, 'Ilam', 'IR', '16', 1),
(3919, 'Kermanshah', 'IR', '05', 1),
(3920, 'Gilan', 'IR', '01', 1),
(3921, 'Chaharmahal and Bakhtiari', 'IR', '14', 1),
(3922, 'Qom', 'IR', '25', 1),
(3923, 'Isfahan', 'IR', '10', 1),
(3924, 'West Azarbaijan', 'IR', '04', 1),
(3925, 'Zanjan', 'IR', '19', 1),
(3926, 'Kohgiluyeh and Boyer-Ahmad', 'IR', '17', 1),
(3927, 'Razavi Khorasan', 'IR', '09', 1),
(3928, 'Lorestan', 'IR', '15', 1),
(3929, 'Alborz', 'IR', '30', 1),
(3930, 'South Khorasan', 'IR', '29', 1),
(3931, 'Sistan and Baluchestan', 'IR', '11', 1),
(3932, 'Bushehr', 'IR', '18', 1),
(3933, 'Golestan', 'IR', '27', 1),
(3934, 'Ardabil', 'IR', '24', 1),
(3935, 'Kurdistan', 'IR', '12', 1),
(3936, 'Yazd', 'IR', '21', 1),
(3937, 'Hormozgan', 'IR', '22', 1),
(3938, 'Mazandaran', 'IR', '02', 1),
(3939, 'Fars', 'IR', '07', 1),
(3940, 'Semnan', 'IR', '20', 1),
(3941, 'Qazvin', 'IR', '26', 1),
(3942, 'North Khorasan', 'IR', '28', 1),
(3943, 'Kerman', 'IR', '08', 1),
(3944, 'East Azerbaijan', 'IR', '03', 1),
(3945, 'Tehran', 'IR', '23', 1),
(3946, 'Niutao Island Council', 'TV', 'NIT', 1),
(3947, 'Nanumanga', 'TV', 'NMG', 1),
(3948, 'Nui', 'TV', 'NUI', 1),
(3949, 'Nanumea', 'TV', 'NMA', 1),
(3950, 'Vaitupu', 'TV', 'VAI', 1),
(3951, 'Funafuti', 'TV', 'FUN', 1),
(3952, 'Nukufetau', 'TV', 'NKF', 1),
(3953, 'Nukulaelae', 'TV', 'NKL', 1),
(3954, 'Dhi Qar', 'IQ', 'DQ', 1),
(3955, 'Babylon', 'IQ', 'BB', 1),
(3956, 'Al-Qādisiyyah', 'IQ', 'QA', 1),
(3957, 'Karbala', 'IQ', 'KA', 1),
(3958, 'Al Muthanna', 'IQ', 'MU', 1),
(3959, 'Baghdad', 'IQ', 'BG', 1),
(3960, 'Basra', 'IQ', 'BA', 1),
(3961, 'Saladin', 'IQ', 'SD', 1),
(3962, 'Najaf', 'IQ', 'NA', 1),
(3963, 'Nineveh', 'IQ', 'NI', 1),
(3964, 'Al Anbar', 'IQ', 'AN', 1),
(3965, 'Diyala', 'IQ', 'DI', 1),
(3966, 'Maysan', 'IQ', 'MA', 1),
(3967, 'Dohuk', 'IQ', 'DA', 1),
(3968, 'Erbil', 'IQ', 'AR', 1),
(3969, 'Sulaymaniyah', 'IQ', 'SU', 1),
(3970, 'Wasit', 'IQ', 'WA', 1),
(3971, 'Kirkuk', 'IQ', 'KI', 1),
(3972, 'Svay Rieng', 'KH', '20', 1),
(3973, 'Preah Vihear', 'KH', '13', 1),
(3974, 'Prey Veng', 'KH', '14', 1),
(3975, 'Takeo', 'KH', '21', 1),
(3976, 'Battambang', 'KH', '2', 1),
(3977, 'Pursat', 'KH', '15', 1),
(3978, 'Kep', 'KH', '23', 1),
(3979, 'Kampong Chhnang', 'KH', '4', 1),
(3980, 'Pailin', 'KH', '24', 1),
(3981, 'Kampot', 'KH', '7', 1),
(3982, 'Koh Kong', 'KH', '9', 1),
(3983, 'Kandal', 'KH', '8', 1),
(3984, 'Banteay Meanchey', 'KH', '1', 1),
(3985, 'Mondulkiri', 'KH', '11', 1),
(3986, 'Kratie', 'KH', '10', 1),
(3987, 'Oddar Meanchey', 'KH', '22', 1),
(3988, 'Kampong Speu', 'KH', '5', 1),
(3989, 'Sihanoukville', 'KH', '18', 1),
(3990, 'Ratanakiri', 'KH', '16', 1),
(3991, 'Kampong Cham', 'KH', '3', 1),
(3992, 'Siem Reap', 'KH', '17', 1),
(3993, 'Stung Treng', 'KH', '19', 1),
(3994, 'Phnom Penh', 'KH', '12', 1),
(3995, 'North Hamgyong Province', 'KP', '09', 1),
(3996, 'Ryanggang Province', 'KP', '10', 1),
(3997, 'South Pyongan Province', 'KP', '02', 1),
(3998, 'Chagang Province', 'KP', '04', 1),
(3999, 'Kangwon Province', 'KP', '07', 1),
(4000, 'South Hamgyong Province', 'KP', '08', 1),
(4001, 'Rason', 'KP', '13', 1),
(4002, 'North Pyongan Province', 'KP', '03', 1),
(4003, 'South Hwanghae Province', 'KP', '05', 1),
(4004, 'North Hwanghae Province', 'KP', '06', 1),
(4005, 'Pyongyang', 'KP', '01', 1),
(4006, 'Meghalaya', 'IN', 'ML', 1),
(4007, 'Haryana', 'IN', 'HR', 1),
(4008, 'Maharashtra', 'IN', 'MH', 1),
(4009, 'Goa', 'IN', 'GA', 1),
(4010, 'Manipur', 'IN', 'MN', 1),
(4011, 'Puducherry', 'IN', 'PY', 1),
(4012, 'Telangana', 'IN', 'TG', 1),
(4013, 'Odisha', 'IN', 'OR', 1),
(4014, 'Rajasthan', 'IN', 'RJ', 1);
INSERT INTO `state` (`id`, `name`, `country_code`, `iso2`, `exists`) VALUES
(4015, 'Punjab', 'IN', 'PB', 1),
(4016, 'Uttarakhand', 'IN', 'UT', 1),
(4017, 'Andhra Pradesh', 'IN', 'AP', 1),
(4018, 'Nagaland', 'IN', 'NL', 1),
(4019, 'Lakshadweep', 'IN', 'LD', 1),
(4020, 'Himachal Pradesh', 'IN', 'HP', 1),
(4021, 'Delhi', 'IN', 'DL', 1),
(4022, 'Uttar Pradesh', 'IN', 'UP', 1),
(4023, 'Andaman and Nicobar Islands', 'IN', 'AN', 1),
(4024, 'Arunachal Pradesh', 'IN', 'AR', 1),
(4025, 'Jharkhand', 'IN', 'JH', 1),
(4026, 'Karnataka', 'IN', 'KA', 1),
(4027, 'Assam', 'IN', 'AS', 1),
(4028, 'Kerala', 'IN', 'KL', 1),
(4029, 'Jammu and Kashmir', 'IN', 'JK', 1),
(4030, 'Gujarat', 'IN', 'GJ', 1),
(4031, 'Chandigarh', 'IN', 'CH', 1),
(4033, 'Dadra and Nagar Haveli and Daman and Diu', 'IN', 'DH', 1),
(4034, 'Sikkim', 'IN', 'SK', 1),
(4035, 'Tamil Nadu', 'IN', 'TN', 1),
(4036, 'Mizoram', 'IN', 'MZ', 1),
(4037, 'Bihar', 'IN', 'BR', 1),
(4038, 'Tripura', 'IN', 'TR', 1),
(4039, 'Madhya Pradesh', 'IN', 'MP', 1),
(4040, 'Chhattisgarh', 'IN', 'CT', 1),
(4041, 'Choluteca Department', 'HN', 'CH', 1),
(4042, 'Comayagua Department', 'HN', 'CM', 1),
(4043, 'El Paraíso Department', 'HN', 'EP', 1),
(4044, 'Intibucá Department', 'HN', 'IN', 1),
(4045, 'Bay Islands Department', 'HN', 'IB', 1),
(4046, 'Cortés Department', 'HN', 'CR', 1),
(4047, 'Atlántida Department', 'HN', 'AT', 1),
(4048, 'Gracias a Dios Department', 'HN', 'GD', 1),
(4049, 'Copán Department', 'HN', 'CP', 1),
(4050, 'Olancho Department', 'HN', 'OL', 1),
(4051, 'Colón Department', 'HN', 'CL', 1),
(4052, 'Francisco Morazán Department', 'HN', 'FM', 1),
(4053, 'Santa Bárbara Department', 'HN', 'SB', 1),
(4054, 'Lempira Department', 'HN', 'LE', 1),
(4055, 'Valle Department', 'HN', 'VA', 1),
(4056, 'Ocotepeque Department', 'HN', 'OC', 1),
(4057, 'Yoro Department', 'HN', 'YO', 1),
(4058, 'La Paz Department', 'HN', 'LP', 1),
(4059, 'Northland Region', 'NZ', 'NTL', 1),
(4060, 'Manawatu-Wanganui Region', 'NZ', 'MWT', 1),
(4061, 'Waikato Region', 'NZ', 'WKO', 1),
(4062, 'Otago Region', 'NZ', 'OTA', 1),
(4063, 'Marlborough Region', 'NZ', 'MBH', 1),
(4064, 'West Coast Region', 'NZ', 'WTC', 1),
(4065, 'Wellington Region', 'NZ', 'WGN', 1),
(4066, 'Canterbury Region', 'NZ', 'CAN', 1),
(4067, 'Chatham Islands', 'NZ', 'CIT', 1),
(4068, 'Gisborne District', 'NZ', 'GIS', 1),
(4069, 'Taranaki Region', 'NZ', 'TKI', 1),
(4070, 'Nelson Region', 'NZ', 'NSN', 1),
(4071, 'Southland Region', 'NZ', 'STL', 1),
(4072, 'Auckland Region', 'NZ', 'AUK', 1),
(4073, 'Tasman District', 'NZ', 'TAS', 1),
(4074, 'Bay of Plenty Region', 'NZ', 'BOP', 1),
(4075, 'Hawke\'s Bay Region', 'NZ', 'HKB', 1),
(4076, 'Saint John Parish', 'DM', '05', 1),
(4077, 'Saint Mark Parish', 'DM', '08', 1),
(4078, 'Saint David Parish', 'DM', '03', 1),
(4079, 'Saint George Parish', 'DM', '04', 1),
(4080, 'Saint Patrick Parish', 'DM', '09', 1),
(4081, 'Saint Peter Parish', 'DM', '11', 1),
(4082, 'Saint Andrew Parish', 'DM', '02', 1),
(4083, 'Saint Luke Parish', 'DM', '07', 1),
(4084, 'Saint Paul Parish', 'DM', '10', 1),
(4085, 'Saint Joseph Parish', 'DM', '06', 1),
(4086, 'El Seibo Province', 'DO', '08', 1),
(4087, 'La Romana Province', 'DO', '12', 1),
(4088, 'Sánchez Ramírez Province', 'DO', '24', 1),
(4089, 'Hermanas Mirabal Province', 'DO', '19', 1),
(4090, 'Barahona Province', 'DO', '04', 1),
(4091, 'San Cristóbal Province', 'DO', '21', 1),
(4092, 'Puerto Plata Province', 'DO', '18', 1),
(4093, 'Santo Domingo Province', 'DO', '32', 1),
(4094, 'María Trinidad Sánchez Province', 'DO', '14', 1),
(4095, 'Distrito Nacional', 'DO', '01', 1),
(4096, 'Peravia Province', 'DO', '17', 1),
(4097, 'Independencia', 'DO', '10', 1),
(4098, 'San Juan Province', 'DO', '22', 1),
(4099, 'Monseñor Nouel Province', 'DO', '28', 1),
(4100, 'Santiago Rodríguez Province', 'DO', '26', 1),
(4101, 'Pedernales Province', 'DO', '16', 1),
(4102, 'Espaillat Province', 'DO', '09', 1),
(4103, 'Samaná Province', 'DO', '20', 1),
(4104, 'Valverde Province', 'DO', '27', 1),
(4105, 'Baoruco Province', 'DO', '03', 1),
(4106, 'Hato Mayor Province', 'DO', '30', 1),
(4107, 'Dajabón Province', 'DO', '05', 1),
(4108, 'Santiago Province', 'DO', '25', 1),
(4109, 'La Altagracia Province', 'DO', '11', 1),
(4110, 'San Pedro de Macorís', 'DO', '23', 1),
(4111, 'Monte Plata Province', 'DO', '29', 1),
(4112, 'San José de Ocoa Province', 'DO', '31', 1),
(4113, 'Duarte Province', 'DO', '06', 1),
(4114, 'Azua Province', 'DO', '02', 1),
(4115, 'Monte Cristi Province', 'DO', '15', 1),
(4116, 'La Vega Province', 'DO', '13', 1),
(4117, 'Nord', 'HT', 'ND', 1),
(4118, 'Nippes', 'HT', 'NI', 1),
(4119, 'Grand\'Anse', 'HT', 'GA', 1),
(4120, 'Ouest', 'HT', 'OU', 1),
(4121, 'Nord-Est', 'HT', 'NE', 1),
(4122, 'Sud', 'HT', 'SD', 1),
(4123, 'Artibonite', 'HT', 'AR', 1),
(4124, 'Sud-Est', 'HT', 'SE', 1),
(4125, 'Centre', 'HT', 'CE', 1),
(4126, 'Nord-Ouest', 'HT', 'NO', 1),
(4127, 'San Vicente Department', 'SV', 'SV', 1),
(4128, 'Santa Ana Department', 'SV', 'SA', 1),
(4129, 'Usulután Department', 'SV', 'US', 1),
(4130, 'Morazán Department', 'SV', 'MO', 1),
(4131, 'Chalatenango Department', 'SV', 'CH', 1),
(4132, 'Cabañas Department', 'SV', 'CA', 1),
(4133, 'San Salvador Department', 'SV', 'SS', 1),
(4134, 'La Libertad Department', 'SV', 'LI', 1),
(4135, 'San Miguel Department', 'SV', 'SM', 1),
(4136, 'La Paz Department', 'SV', 'PA', 1),
(4137, 'Cuscatlán Department', 'SV', 'CU', 1),
(4138, 'La Unión Department', 'SV', 'UN', 1),
(4139, 'Ahuachapán Department', 'SV', 'AH', 1),
(4140, 'Sonsonate Department', 'SV', 'SO', 1),
(4141, 'Braslovče Municipality', 'SI', '151', 1),
(4142, 'Lenart Municipality', 'SI', '058', 1),
(4143, 'Oplotnica', 'SI', '171', 1),
(4144, 'Velike Lašče Municipality', 'SI', '134', 1),
(4145, 'Hajdina Municipality', 'SI', '159', 1),
(4146, 'Podčetrtek Municipality', 'SI', '092', 1),
(4147, 'Cankova Municipality', 'SI', '152', 1),
(4148, 'Vitanje Municipality', 'SI', '137', 1),
(4149, 'Sežana Municipality', 'SI', '111', 1),
(4150, 'Kidričevo Municipality', 'SI', '045', 1),
(4151, 'Črenšovci Municipality', 'SI', '015', 1),
(4152, 'Idrija Municipality', 'SI', '036', 1),
(4153, 'Trnovska Vas Municipality', 'SI', '185', 1),
(4154, 'Vodice Municipality', 'SI', '138', 1),
(4155, 'Ravne na Koroškem Municipality', 'SI', '103', 1),
(4156, 'Lovrenc na Pohorju Municipality', 'SI', '167', 1),
(4157, 'Majšperk Municipality', 'SI', '069', 1),
(4158, 'Loški Potok Municipality', 'SI', '066', 1),
(4159, 'Domžale Municipality', 'SI', '023', 1),
(4160, 'Rečica ob Savinji Municipality', 'SI', '209', 1),
(4161, 'Podlehnik Municipality', 'SI', '172', 1),
(4162, 'Cerknica Municipality', 'SI', '013', 1),
(4163, 'Vransko Municipality', 'SI', '189', 1),
(4164, 'Sveta Ana Municipality', 'SI', '181', 1),
(4165, 'Brezovica Municipality', 'SI', '008', 1),
(4166, 'Benedikt Municipality', 'SI', '148', 1),
(4167, 'Divača Municipality', 'SI', '019', 1),
(4168, 'Moravče Municipality', 'SI', '077', 1),
(4169, 'Slovenj Gradec City Municipality', 'SI', '112', 1),
(4170, 'Škocjan Municipality', 'SI', '121', 1),
(4171, 'Šentjur Municipality', 'SI', '120', 1),
(4172, 'Pesnica Municipality', 'SI', '089', 1),
(4173, 'Dol pri Ljubljani Municipality', 'SI', '022', 1),
(4174, 'Loška Dolina Municipality', 'SI', '065', 1),
(4175, 'Hoče–Slivnica Municipality', 'SI', '160', 1),
(4176, 'Cerkvenjak Municipality', 'SI', '153', 1),
(4177, 'Naklo Municipality', 'SI', '082', 1),
(4178, 'Cerkno Municipality', 'SI', '014', 1),
(4179, 'Bistrica ob Sotli Municipality', 'SI', '149', 1),
(4180, 'Kamnik Municipality', 'SI', '043', 1),
(4181, 'Bovec Municipality', 'SI', '006', 1),
(4182, 'Zavrč Municipality', 'SI', '143', 1),
(4183, 'Ajdovščina Municipality', 'SI', '001', 1),
(4184, 'Pivka Municipality', 'SI', '091', 1),
(4185, 'Štore Municipality', 'SI', '127', 1),
(4186, 'Kozje Municipality', 'SI', '051', 1),
(4187, 'Municipality of Škofljica', 'SI', '123', 1),
(4188, 'Prebold Municipality', 'SI', '174', 1),
(4189, 'Dobrovnik Municipality', 'SI', '156', 1),
(4190, 'Mozirje Municipality', 'SI', '079', 1),
(4191, 'City Municipality of Celje', 'SI', '011', 1),
(4192, 'Žiri Municipality', 'SI', '147', 1),
(4193, 'Horjul Municipality', 'SI', '162', 1),
(4194, 'Tabor Municipality', 'SI', '184', 1),
(4195, 'Radeče Municipality', 'SI', '099', 1),
(4196, 'Vipava Municipality', 'SI', '136', 1),
(4197, 'Kungota', 'SI', '055', 1),
(4198, 'Slovenske Konjice Municipality', 'SI', '114', 1),
(4199, 'Osilnica Municipality', 'SI', '088', 1),
(4200, 'Borovnica Municipality', 'SI', '005', 1),
(4201, 'Piran Municipality', 'SI', '090', 1),
(4202, 'Bled Municipality', 'SI', '003', 1),
(4203, 'Jezersko Municipality', 'SI', '163', 1),
(4204, 'Rače–Fram Municipality', 'SI', '098', 1),
(4205, 'Nova Gorica City Municipality', 'SI', '084', 1),
(4206, 'Razkrižje Municipality', 'SI', '176', 1),
(4207, 'Ribnica na Pohorju Municipality', 'SI', '177', 1),
(4208, 'Muta Municipality', 'SI', '081', 1),
(4209, 'Rogatec Municipality', 'SI', '107', 1),
(4210, 'Gorišnica Municipality', 'SI', '028', 1),
(4211, 'Kuzma Municipality', 'SI', '056', 1),
(4212, 'Mislinja Municipality', 'SI', '076', 1),
(4213, 'Duplek Municipality', 'SI', '026', 1),
(4214, 'Trebnje Municipality', 'SI', '130', 1),
(4215, 'Brežice Municipality', 'SI', '009', 1),
(4216, 'Dobrepolje Municipality', 'SI', '020', 1),
(4217, 'Grad Municipality', 'SI', '158', 1),
(4218, 'Moravske Toplice Municipality', 'SI', '078', 1),
(4219, 'Luče Municipality', 'SI', '067', 1),
(4220, 'Miren–Kostanjevica Municipality', 'SI', '075', 1),
(4221, 'Ormož Municipality', 'SI', '087', 1),
(4222, 'Šalovci Municipality', 'SI', '033', 1),
(4223, 'Miklavž na Dravskem Polju Municipality', 'SI', '169', 1),
(4224, 'Makole Municipality', 'SI', '198', 1),
(4225, 'Lendava Municipality', 'SI', '059', 1),
(4226, 'Vuzenica Municipality', 'SI', '141', 1),
(4227, 'Kanal ob Soči Municipality', 'SI', '044', 1),
(4228, 'Ptuj City Municipality', 'SI', '096', 1),
(4229, 'Sveti Andraž v Slovenskih Goricah Municipality', 'SI', '182', 1),
(4230, 'Selnica ob Dravi Municipality', 'SI', '178', 1),
(4231, 'Radovljica Municipality', 'SI', '102', 1),
(4232, 'Črna na Koroškem Municipality', 'SI', '016', 1),
(4233, 'Rogaška Slatina Municipality', 'SI', '106', 1),
(4234, 'Podvelka Municipality', 'SI', '093', 1),
(4235, 'Ribnica Municipality', 'SI', '104', 1),
(4236, 'City Municipality of Novo Mesto', 'SI', '085', 1),
(4237, 'Mirna Peč Municipality', 'SI', '170', 1),
(4238, 'Križevci Municipality', 'SI', '166', 1),
(4239, 'Poljčane Municipality', 'SI', '200', 1),
(4240, 'Brda Municipality', 'SI', '007', 1),
(4241, 'Šentjernej Municipality', 'SI', '119', 1),
(4242, 'Maribor City Municipality', 'SI', '070', 1),
(4243, 'Kobarid Municipality', 'SI', '046', 1),
(4244, 'Markovci Municipality', 'SI', '168', 1),
(4245, 'Vojnik Municipality', 'SI', '139', 1),
(4246, 'Trbovlje Municipality', 'SI', '129', 1),
(4247, 'Tolmin Municipality', 'SI', '128', 1),
(4248, 'Šoštanj Municipality', 'SI', '126', 1),
(4249, 'Žetale Municipality', 'SI', '191', 1),
(4250, 'Tržič Municipality', 'SI', '131', 1),
(4251, 'Turnišče Municipality', 'SI', '132', 1),
(4252, 'Dobrna Municipality', 'SI', '155', 1),
(4253, 'Renče–Vogrsko Municipality', 'SI', '201', 1),
(4254, 'Kostanjevica na Krki Municipality', 'SI', '197', 1),
(4255, 'Sveti Jurij ob Ščavnici Municipality', 'SI', '116', 1),
(4256, 'Železniki Municipality', 'SI', '146', 1),
(4257, 'Veržej Municipality', 'SI', '188', 1),
(4258, 'Žalec Municipality', 'SI', '190', 1),
(4259, 'Starše Municipality', 'SI', '115', 1),
(4260, 'Sveta Trojica v Slovenskih Goricah Municipality', 'SI', '204', 1),
(4261, 'Solčava Municipality', 'SI', '180', 1),
(4262, 'Vrhnika Municipality', 'SI', '140', 1),
(4263, 'Središče ob Dravi', 'SI', '202', 1),
(4264, 'Rogašovci Municipality', 'SI', '105', 1),
(4265, 'Mežica Municipality', 'SI', '074', 1),
(4266, 'Juršinci Municipality', 'SI', '042', 1),
(4267, 'Velika Polana Municipality', 'SI', '187', 1),
(4268, 'Sevnica Municipality', 'SI', '110', 1),
(4269, 'Zagorje ob Savi Municipality', 'SI', '142', 1),
(4270, 'Ljubljana City Municipality', 'SI', '061', 1),
(4271, 'Gornji Petrovci Municipality', 'SI', '031', 1),
(4272, 'Polzela Municipality', 'SI', '173', 1),
(4273, 'Sveti Tomaž Municipality', 'SI', '205', 1),
(4274, 'Prevalje Municipality', 'SI', '175', 1),
(4275, 'Radlje ob Dravi Municipality', 'SI', '101', 1),
(4276, 'Žirovnica Municipality', 'SI', '192', 1),
(4277, 'Sodražica Municipality', 'SI', '179', 1),
(4278, 'Bloke Municipality', 'SI', '150', 1),
(4279, 'Šmartno pri Litiji Municipality', 'SI', '194', 1),
(4280, 'Ruše Municipality', 'SI', '108', 1),
(4281, 'Dolenjske Toplice Municipality', 'SI', '157', 1),
(4282, 'Bohinj Municipality', 'SI', '004', 1),
(4283, 'Komenda Municipality', 'SI', '164', 1),
(4284, 'Gorje Municipality', 'SI', '207', 1),
(4285, 'Šmarje pri Jelšah Municipality', 'SI', '124', 1),
(4286, 'Ig Municipality', 'SI', '037', 1),
(4287, 'Kranj City Municipality', 'SI', '052', 1),
(4288, 'Puconci Municipality', 'SI', '097', 1),
(4289, 'Šmarješke Toplice Municipality', 'SI', '206', 1),
(4290, 'Dornava Municipality', 'SI', '024', 1),
(4291, 'Črnomelj Municipality', 'SI', '017', 1),
(4292, 'Radenci Municipality', 'SI', '100', 1),
(4293, 'Gorenja Vas–Poljane Municipality', 'SI', '027', 1),
(4294, 'Ljubno Municipality', 'SI', '062', 1),
(4295, 'Dobje Municipality', 'SI', '154', 1),
(4296, 'Šmartno ob Paki Municipality', 'SI', '125', 1),
(4297, 'Mokronog–Trebelno Municipality', 'SI', '199', 1),
(4298, 'Mirna Municipality', 'SI', '212', 1),
(4299, 'Šenčur Municipality', 'SI', '117', 1),
(4300, 'Videm Municipality', 'SI', '135', 1),
(4301, 'Beltinci Municipality', 'SI', '002', 1),
(4302, 'Lukovica Municipality', 'SI', '068', 1),
(4303, 'Preddvor Municipality', 'SI', '095', 1),
(4304, 'Destrnik Municipality', 'SI', '018', 1),
(4305, 'Ivančna Gorica Municipality', 'SI', '039', 1),
(4306, 'Log–Dragomer Municipality', 'SI', '208', 1),
(4307, 'Žužemberk Municipality', 'SI', '193', 1),
(4308, 'Dobrova–Polhov Gradec Municipality', 'SI', '021', 1),
(4309, 'Municipality of Cirkulane', 'SI', '196', 1),
(4310, 'Cerklje na Gorenjskem Municipality', 'SI', '012', 1),
(4311, 'Šentrupert Municipality', 'SI', '211', 1),
(4312, 'Tišina Municipality', 'SI', '010', 1),
(4313, 'Murska Sobota City Municipality', 'SI', '080', 1),
(4314, 'Municipality of Krško', 'SI', '054', 1),
(4315, 'Komen Municipality', 'SI', '049', 1),
(4316, 'Škofja Loka Municipality', 'SI', '122', 1),
(4317, 'Šempeter–Vrtojba Municipality', 'SI', '183', 1),
(4318, 'Municipality of Apače', 'SI', '195', 1),
(4319, 'Koper City Municipality', 'SI', '050', 1),
(4320, 'Odranci Municipality', 'SI', '086', 1),
(4321, 'Hrpelje–Kozina Municipality', 'SI', '035', 1),
(4322, 'Izola Municipality', 'SI', '040', 1),
(4323, 'Metlika Municipality', 'SI', '073', 1),
(4324, 'Šentilj Municipality', 'SI', '118', 1),
(4325, 'Kobilje Municipality', 'SI', '047', 1),
(4326, 'Ankaran Municipality', 'SI', '213', 1),
(4327, 'Hodoš Municipality', 'SI', '161', 1),
(4328, 'Sveti Jurij v Slovenskih Goricah Municipality', 'SI', '210', 1),
(4329, 'Nazarje Municipality', 'SI', '083', 1),
(4330, 'Postojna Municipality', 'SI', '094', 1),
(4331, 'Kostel Municipality', 'SI', '165', 1),
(4332, 'Slovenska Bistrica Municipality', 'SI', '113', 1),
(4333, 'Straža Municipality', 'SI', '203', 1),
(4334, 'Trzin Municipality', 'SI', '186', 1),
(4335, 'Kočevje Municipality', 'SI', '048', 1),
(4336, 'Grosuplje Municipality', 'SI', '032', 1),
(4337, 'Jesenice Municipality', 'SI', '041', 1),
(4338, 'Laško Municipality', 'SI', '057', 1),
(4339, 'Gornji Grad Municipality', 'SI', '030', 1),
(4340, 'Kranjska Gora Municipality', 'SI', '053', 1),
(4341, 'Hrastnik Municipality', 'SI', '034', 1),
(4342, 'Zreče Municipality', 'SI', '144', 1),
(4343, 'Gornja Radgona Municipality', 'SI', '029', 1),
(4344, 'Municipality of Ilirska Bistrica', 'SI', '038', 1),
(4345, 'Dravograd Municipality', 'SI', '025', 1),
(4346, 'Semič Municipality', 'SI', '109', 1),
(4347, 'Litija Municipality', 'SI', '060', 1),
(4348, 'Mengeš Municipality', 'SI', '072', 1),
(4349, 'Medvode Municipality', 'SI', '071', 1),
(4350, 'Logatec Municipality', 'SI', '064', 1),
(4351, 'Ljutomer Municipality', 'SI', '063', 1),
(4352, 'Banská Bystrica Region', 'SK', 'BC', 1),
(4353, 'Košice Region', 'SK', 'KI', 1),
(4354, 'Prešov Region', 'SK', 'PV', 1),
(4355, 'Trnava Region', 'SK', 'TA', 1),
(4356, 'Bratislava Region', 'SK', 'BL', 1),
(4357, 'Nitra Region', 'SK', 'NI', 1),
(4358, 'Trenčín Region', 'SK', 'TC', 1),
(4359, 'Žilina Region', 'SK', 'ZI', 1),
(4360, 'Cimișlia District', 'MD', 'CM', 1),
(4361, 'Orhei District', 'MD', 'OR', 1),
(4362, 'Bender Municipality', 'MD', 'BD', 1),
(4363, 'Nisporeni District', 'MD', 'NI', 1),
(4364, 'Sîngerei District', 'MD', 'SI', 1),
(4365, 'Căușeni District', 'MD', 'CS', 1),
(4366, 'Călărași District', 'MD', 'CL', 1),
(4367, 'Glodeni District', 'MD', 'GL', 1),
(4368, 'Anenii Noi District', 'MD', 'AN', 1),
(4369, 'Ialoveni District', 'MD', 'IA', 1),
(4370, 'Florești District', 'MD', 'FL', 1),
(4371, 'Telenești District', 'MD', 'TE', 1),
(4372, 'Taraclia District', 'MD', 'TA', 1),
(4373, 'Chișinău Municipality', 'MD', 'CU', 1),
(4374, 'Soroca District', 'MD', 'SO', 1),
(4375, 'Briceni District', 'MD', 'BR', 1),
(4376, 'Rîșcani District', 'MD', 'RI', 1),
(4377, 'Strășeni District', 'MD', 'ST', 1),
(4378, 'Ștefan Vodă District', 'MD', 'SV', 1),
(4379, 'Basarabeasca District', 'MD', 'BS', 1),
(4380, 'Cantemir District', 'MD', 'CT', 1),
(4381, 'Fălești District', 'MD', 'FA', 1),
(4382, 'Hîncești District', 'MD', 'HI', 1),
(4383, 'Dubăsari District', 'MD', 'DU', 1),
(4384, 'Dondușeni District', 'MD', 'DO', 1),
(4385, 'Gagauzia', 'MD', 'GA', 1),
(4386, 'Ungheni District', 'MD', 'UN', 1),
(4387, 'Edineț District', 'MD', 'ED', 1),
(4388, 'Șoldănești District', 'MD', 'SD', 1),
(4389, 'Ocnița District', 'MD', 'OC', 1),
(4390, 'Criuleni District', 'MD', 'CR', 1),
(4391, 'Cahul District', 'MD', 'CA', 1),
(4392, 'Drochia District', 'MD', 'DR', 1),
(4393, 'Bălți Municipality', 'MD', 'BA', 1),
(4394, 'Rezina District', 'MD', 'RE', 1),
(4395, 'Transnistria autonomous territorial unit', 'MD', 'SN', 1),
(4396, 'Salacgrīva Municipality', 'LV', '086', 1),
(4397, 'Vecumnieki Municipality', 'LV', '105', 1),
(4398, 'Naukšēni Municipality', 'LV', '064', 1),
(4399, 'Ilūkste Municipality', 'LV', '036', 1),
(4400, 'Gulbene Municipality', 'LV', '033', 1),
(4401, 'Līvāni Municipality', 'LV', '056', 1),
(4402, 'Salaspils Municipality', 'LV', '087', 1),
(4403, 'Ventspils Municipality', 'LV', '106', 1),
(4404, 'Rundāle Municipality', 'LV', '083', 1),
(4405, 'Pļaviņas Municipality', 'LV', '072', 1),
(4406, 'Vārkava Municipality', 'LV', '103', 1),
(4407, 'Jaunpiebalga Municipality', 'LV', '039', 1),
(4408, 'Sēja Municipality', 'LV', '090', 1),
(4409, 'Tukums Municipality', 'LV', '099', 1),
(4410, 'Cibla Municipality', 'LV', '023', 1),
(4411, 'Burtnieki Municipality', 'LV', '019', 1),
(4412, 'Ķegums Municipality', 'LV', '051', 1),
(4413, 'Krustpils Municipality', 'LV', '049', 1),
(4414, 'Cesvaine Municipality', 'LV', '021', 1),
(4415, 'Skrīveri Municipality', 'LV', '092', 1),
(4416, 'Ogre Municipality', 'LV', '067', 1),
(4417, 'Olaine Municipality', 'LV', '068', 1),
(4418, 'Limbaži Municipality', 'LV', '054', 1),
(4419, 'Lubāna Municipality', 'LV', '057', 1),
(4420, 'Kandava Municipality', 'LV', '043', 1),
(4421, 'Ventspils', 'LV', 'VEN', 1),
(4422, 'Krimulda Municipality', 'LV', '048', 1),
(4423, 'Rugāji Municipality', 'LV', '082', 1),
(4424, 'Jelgava Municipality', 'LV', '041', 1),
(4425, 'Valka Municipality', 'LV', '101', 1),
(4426, 'Rūjiena Municipality', 'LV', '084', 1),
(4427, 'Babīte Municipality', 'LV', '012', 1),
(4428, 'Dundaga Municipality', 'LV', '027', 1),
(4429, 'Priekule Municipality', 'LV', '074', 1),
(4430, 'Zilupe Municipality', 'LV', '110', 1),
(4431, 'Varakļāni Municipality', 'LV', '102', 1),
(4432, 'Nereta Municipality', 'LV', '065', 1),
(4433, 'Madona Municipality', 'LV', '059', 1),
(4434, 'Sala Municipality', 'LV', '085', 1),
(4435, 'Ķekava Municipality', 'LV', '052', 1),
(4436, 'Nīca Municipality', 'LV', '066', 1),
(4437, 'Dobele Municipality', 'LV', '026', 1),
(4438, 'Jēkabpils Municipality', 'LV', '042', 1),
(4439, 'Saldus Municipality', 'LV', '088', 1),
(4440, 'Roja Municipality', 'LV', '079', 1),
(4441, 'Iecava Municipality', 'LV', '034', 1),
(4442, 'Ozolnieki Municipality', 'LV', '069', 1),
(4443, 'Saulkrasti Municipality', 'LV', '089', 1),
(4444, 'Ērgļi Municipality', 'LV', '030', 1),
(4445, 'Aglona Municipality', 'LV', '001', 1),
(4446, 'Jūrmala', 'LV', 'JUR', 1),
(4447, 'Skrunda Municipality', 'LV', '093', 1),
(4448, 'Engure Municipality', 'LV', '029', 1),
(4449, 'Inčukalns Municipality', 'LV', '037', 1),
(4450, 'Mārupe Municipality', 'LV', '062', 1),
(4451, 'Mērsrags Municipality', 'LV', '063', 1),
(4452, 'Koknese Municipality', 'LV', '046', 1),
(4453, 'Kārsava Municipality', 'LV', '044', 1),
(4454, 'Carnikava Municipality', 'LV', '020', 1),
(4455, 'Rēzekne Municipality', 'LV', '077', 1),
(4456, 'Viesīte Municipality', 'LV', '107', 1),
(4457, 'Ape Municipality', 'LV', '009', 1),
(4458, 'Durbe Municipality', 'LV', '028', 1),
(4459, 'Talsi Municipality', 'LV', '097', 1),
(4460, 'Liepāja', 'LV', 'LPX', 1),
(4461, 'Mālpils Municipality', 'LV', '061', 1),
(4462, 'Smiltene Municipality', 'LV', '094', 1),
(4463, 'Daugavpils', 'LV', 'DGV', 1),
(4464, 'Jēkabpils', 'LV', 'JKB', 1),
(4465, 'Bauska Municipality', 'LV', '016', 1),
(4466, 'Vecpiebalga Municipality', 'LV', '104', 1),
(4467, 'Pāvilosta Municipality', 'LV', '071', 1),
(4468, 'Brocēni Municipality', 'LV', '018', 1),
(4469, 'Cēsis Municipality', 'LV', '022', 1),
(4470, 'Grobiņa Municipality', 'LV', '032', 1),
(4471, 'Beverīna Municipality', 'LV', '017', 1),
(4472, 'Aizkraukle Municipality', 'LV', '002', 1),
(4473, 'Valmiera', 'LV', 'VMR', 1),
(4474, 'Krāslava Municipality', 'LV', '047', 1),
(4475, 'Jaunjelgava Municipality', 'LV', '038', 1),
(4476, 'Sigulda Municipality', 'LV', '091', 1),
(4477, 'Viļaka Municipality', 'LV', '108', 1),
(4478, 'Stopiņi Municipality', 'LV', '095', 1),
(4479, 'Rauna Municipality', 'LV', '076', 1),
(4480, 'Tērvete Municipality', 'LV', '098', 1),
(4481, 'Auce Municipality', 'LV', '010', 1),
(4482, 'Baldone Municipality', 'LV', '013', 1),
(4483, 'Preiļi Municipality', 'LV', '073', 1),
(4484, 'Aloja Municipality', 'LV', '005', 1),
(4485, 'Alsunga Municipality', 'LV', '006', 1),
(4486, 'Viļāni Municipality', 'LV', '109', 1),
(4487, 'Alūksne Municipality', 'LV', '007', 1),
(4488, 'Līgatne Municipality', 'LV', '055', 1),
(4489, 'Jaunpils Municipality', 'LV', '040', 1),
(4490, 'Kuldīga Municipality', 'LV', '050', 1),
(4491, 'Riga', 'LV', 'RIX', 1),
(4492, 'Daugavpils Municipality', 'LV', '025', 1),
(4493, 'Ropaži Municipality', 'LV', '080', 1),
(4494, 'Strenči Municipality', 'LV', '096', 1),
(4495, 'Kocēni Municipality', 'LV', '045', 1),
(4496, 'Aizpute Municipality', 'LV', '003', 1),
(4497, 'Amata Municipality', 'LV', '008', 1),
(4498, 'Baltinava Municipality', 'LV', '014', 1),
(4499, 'Aknīste Municipality', 'LV', '004', 1),
(4500, 'Jelgava', 'LV', 'JEL', 1),
(4501, 'Ludza Municipality', 'LV', '058', 1),
(4502, 'Riebiņi Municipality', 'LV', '078', 1),
(4503, 'Rucava Municipality', 'LV', '081', 1),
(4504, 'Dagda Municipality', 'LV', '024', 1),
(4505, 'Balvi Municipality', 'LV', '015', 1),
(4506, 'Priekuļi Municipality', 'LV', '075', 1),
(4507, 'Pārgauja Municipality', 'LV', '070', 1),
(4508, 'Vaiņode Municipality', 'LV', '100', 1),
(4509, 'Rēzekne', 'LV', 'REZ', 1),
(4510, 'Garkalne Municipality', 'LV', '031', 1),
(4511, 'Ikšķile Municipality', 'LV', '035', 1),
(4512, 'Lielvārde Municipality', 'LV', '053', 1),
(4513, 'Mazsalaca Municipality', 'LV', '060', 1),
(4514, 'Viqueque Municipality', 'TL', 'VI', 1),
(4515, 'Liquiçá Municipality', 'TL', 'LI', 1),
(4516, 'Ermera District', 'TL', 'ER', 1),
(4517, 'Manatuto District', 'TL', 'MT', 1),
(4518, 'Ainaro Municipality', 'TL', 'AN', 1),
(4519, 'Manufahi Municipality', 'TL', 'MF', 1),
(4520, 'Aileu municipality', 'TL', 'AL', 1),
(4521, 'Baucau Municipality', 'TL', 'BA', 1),
(4522, 'Cova Lima Municipality', 'TL', 'CO', 1),
(4523, 'Lautém Municipality', 'TL', 'LA', 1),
(4524, 'Dili municipality', 'TL', 'DI', 1),
(4525, 'Bobonaro Municipality', 'TL', 'BO', 1),
(4526, 'Peleliu', 'PW', '350', 1),
(4527, 'Ngardmau', 'PW', '222', 1),
(4528, 'Airai', 'PW', '004', 1),
(4529, 'Hatohobei', 'PW', '050', 1),
(4530, 'Melekeok', 'PW', '212', 1),
(4531, 'Ngatpang', 'PW', '224', 1),
(4532, 'Koror', 'PW', '150', 1),
(4533, 'Ngarchelong', 'PW', '218', 1),
(4534, 'Ngiwal', 'PW', '228', 1),
(4535, 'Sonsorol', 'PW', '370', 1),
(4536, 'Ngchesar', 'PW', '226', 1),
(4537, 'Ngaraard', 'PW', '214', 1),
(4538, 'Angaur', 'PW', '010', 1),
(4539, 'Kayangel', 'PW', '100', 1),
(4540, 'Aimeliik', 'PW', '002', 1),
(4541, 'Ngeremlengui', 'PW', '227', 1),
(4542, 'Břeclav', 'CZ', '644', 1),
(4543, 'Český Krumlov', 'CZ', '312', 1),
(4544, 'Plzeň-město', 'CZ', '323', 1),
(4545, 'Brno-venkov', 'CZ', '643', 1),
(4546, 'Příbram', 'CZ', '20B', 1),
(4547, 'Pardubice', 'CZ', '532', 1),
(4548, 'Nový Jičín', 'CZ', '804', 1),
(4550, 'Náchod', 'CZ', '523', 1),
(4551, 'Prostějov', 'CZ', '713', 1),
(4552, 'Zlínský kraj', 'CZ', '72', 1),
(4553, 'Chomutov', 'CZ', '422', 1),
(4554, 'Středočeský kraj', 'CZ', '20', 1),
(4556, 'České Budějovice', 'CZ', '311', 1),
(4558, 'Rakovník', 'CZ', '20C', 1),
(4559, 'Frýdek-Místek', 'CZ', '802', 1),
(4560, 'Písek', 'CZ', '314', 1),
(4561, 'Hodonín', 'CZ', '645', 1),
(4563, 'Zlín', 'CZ', '724', 1),
(4564, 'Plzeň-sever', 'CZ', '325', 1),
(4565, 'Tábor', 'CZ', '317', 1),
(4568, 'Brno-město', 'CZ', '642', 1),
(4571, 'Svitavy', 'CZ', '533', 1),
(4572, 'Vsetín', 'CZ', '723', 1),
(4573, 'Cheb', 'CZ', '411', 1),
(4574, 'Olomouc', 'CZ', '712', 1),
(4575, 'Kraj Vysočina', 'CZ', '63', 1),
(4576, 'Ústecký kraj', 'CZ', '42', 1),
(4578, 'Prachatice', 'CZ', '315', 1),
(4579, 'Trutnov', 'CZ', '525', 1),
(4580, 'Hradec Králové', 'CZ', '521', 1),
(4581, 'Karlovarský kraj', 'CZ', '41', 1),
(4582, 'Nymburk', 'CZ', '208', 1),
(4583, 'Rokycany', 'CZ', '326', 1),
(4584, 'Ostrava-město', 'CZ', '806', 1),
(4586, 'Karviná', 'CZ', '803', 1),
(4588, 'Pardubický kraj', 'CZ', '53', 1),
(4589, 'Olomoucký kraj', 'CZ', '71', 1),
(4590, 'Liberec', 'CZ', '513', 1),
(4591, 'Klatovy', 'CZ', '322', 1),
(4592, 'Uherské Hradiště', 'CZ', '722', 1),
(4593, 'Kroměříž', 'CZ', '721', 1),
(4595, 'Sokolov', 'CZ', '413', 1),
(4596, 'Semily', 'CZ', '514', 1),
(4597, 'Třebíč', 'CZ', '634', 1),
(4598, 'Praha, Hlavní město', 'CZ', '10', 1),
(4599, 'Ústí nad Labem', 'CZ', '427', 1),
(4600, 'Moravskoslezský kraj', 'CZ', '80', 1),
(4601, 'Liberecký kraj', 'CZ', '51', 1),
(4602, 'Jihomoravský kraj', 'CZ', '64', 1),
(4604, 'Karlovy Vary', 'CZ', '412', 1),
(4605, 'Litoměřice', 'CZ', '423', 1),
(4606, 'Praha-východ', 'CZ', '209', 1),
(4607, 'Plzeňský kraj', 'CZ', '32', 1),
(4608, 'Plzeň-jih', 'CZ', '324', 1),
(4609, 'Děčín', 'CZ', '421', 1),
(4611, 'Havlíčkův Brod', 'CZ', '631', 1),
(4612, 'Jablonec nad Nisou', 'CZ', '512', 1),
(4613, 'Jihlava', 'CZ', '632', 1),
(4614, 'Královéhradecký kraj', 'CZ', '52', 1),
(4615, 'Blansko', 'CZ', '641', 1),
(4617, 'Louny', 'CZ', '424', 1),
(4618, 'Kolín', 'CZ', '204', 1),
(4619, 'Praha-západ', 'CZ', '20A', 1),
(4620, 'Beroun', 'CZ', '202', 1),
(4621, 'Teplice', 'CZ', '426', 1),
(4622, 'Vyškov', 'CZ', '646', 1),
(4623, 'Opava', 'CZ', '805', 1),
(4624, 'Jindřichův Hradec', 'CZ', '313', 1),
(4625, 'Jeseník', 'CZ', '711', 1),
(4626, 'Přerov', 'CZ', '714', 1),
(4627, 'Benešov', 'CZ', '201', 1),
(4628, 'Strakonice', 'CZ', '316', 1),
(4629, 'Most', 'CZ', '425', 1),
(4630, 'Znojmo', 'CZ', '647', 1),
(4631, 'Kladno', 'CZ', '203', 1),
(4633, 'Česká Lípa', 'CZ', '511', 1),
(4634, 'Chrudim', 'CZ', '531', 1),
(4636, 'Rychnov nad Kněžnou', 'CZ', '524', 1),
(4638, 'Mělník', 'CZ', '206', 1),
(4639, 'Jihočeský kraj', 'CZ', '31', 1),
(4640, 'Jičín', 'CZ', '522', 1),
(4641, 'Domažlice', 'CZ', '321', 1),
(4642, 'Šumperk', 'CZ', '715', 1),
(4643, 'Mladá Boleslav', 'CZ', '207', 1),
(4644, 'Bruntál', 'CZ', '801', 1),
(4645, 'Pelhřimov', 'CZ', '633', 1),
(4646, 'Tachov', 'CZ', '327', 1),
(4647, 'Ústí nad Orlicí', 'CZ', '534', 1),
(4648, 'Žďár nad Sázavou', 'CZ', '635', 1),
(4649, 'North East Community Development Council', 'SG', '02', 1),
(4650, 'South East Community Development Council', 'SG', '04', 1),
(4651, 'Central Singapore Community Development Council', 'SG', '01', 1),
(4652, 'South West Community Development Council', 'SG', '05', 1),
(4653, 'North West Community Development Council', 'SG', '03', 1),
(4654, 'Ewa District', 'NR', '09', 1),
(4655, 'Uaboe District', 'NR', '13', 1),
(4656, 'Aiwo District', 'NR', '01', 1),
(4657, 'Meneng District', 'NR', '11', 1),
(4658, 'Anabar District', 'NR', '02', 1),
(4659, 'Nibok District', 'NR', '12', 1),
(4660, 'Baiti District', 'NR', '05', 1),
(4661, 'Ijuw District', 'NR', '10', 1),
(4662, 'Buada District', 'NR', '07', 1),
(4663, 'Anibare District', 'NR', '04', 1),
(4664, 'Yaren District', 'NR', '14', 1),
(4665, 'Boe District', 'NR', '06', 1),
(4666, 'Denigomodu District', 'NR', '08', 1),
(4667, 'Anetan District', 'NR', '03', 1),
(4668, 'Zhytomyrska oblast', 'UA', '18', 1),
(4669, 'Vinnytska oblast', 'UA', '05', 1),
(4670, 'Zakarpatska Oblast', 'UA', '21', 1),
(4671, 'Kyivska oblast', 'UA', '32', 1),
(4672, 'Lvivska oblast', 'UA', '46', 1),
(4673, 'Luhanska oblast', 'UA', '09', 1),
(4674, 'Ternopilska oblast', 'UA', '61', 1),
(4675, 'Dnipropetrovska oblast', 'UA', '12', 1),
(4676, 'Kyiv', 'UA', '30', 1),
(4677, 'Kirovohradska oblast', 'UA', '35', 1),
(4678, 'Chernivetska oblast', 'UA', '77', 1),
(4679, 'Mykolaivska oblast', 'UA', '48', 1),
(4680, 'Cherkaska oblast', 'UA', '71', 1),
(4681, 'Khmelnytska oblast', 'UA', '68', 1),
(4682, 'Ivano-Frankivska oblast', 'UA', '26', 1),
(4683, 'Rivnenska oblast', 'UA', '56', 1),
(4684, 'Khersonska oblast', 'UA', '65', 1),
(4685, 'Sumska oblast', 'UA', '59', 1),
(4686, 'Kharkivska oblast', 'UA', '63', 1),
(4687, 'Zaporizka oblast', 'UA', '23', 1),
(4688, 'Odeska oblast', 'UA', '51', 1),
(4689, 'Autonomous Republic of Crimea', 'UA', '43', 1),
(4690, 'Volynska oblast', 'UA', '07', 1),
(4691, 'Donetska oblast', 'UA', '14', 1),
(4692, 'Chernihivska oblast', 'UA', '74', 1),
(4693, 'Gabrovo Province', 'BG', '07', 1),
(4694, 'Smolyan Province', 'BG', '21', 1),
(4695, 'Pernik Province', 'BG', '14', 1),
(4696, 'Montana Province', 'BG', '12', 1),
(4697, 'Vidin Province', 'BG', '05', 1),
(4698, 'Razgrad Province', 'BG', '17', 1),
(4699, 'Blagoevgrad Province', 'BG', '01', 1),
(4700, 'Sliven Province', 'BG', '20', 1),
(4701, 'Plovdiv Province', 'BG', '16', 1),
(4702, 'Kardzhali Province', 'BG', '09', 1),
(4703, 'Kyustendil Province', 'BG', '10', 1),
(4704, 'Haskovo Province', 'BG', '26', 1),
(4705, 'Sofia City Province', 'BG', '22', 1),
(4706, 'Pleven Province', 'BG', '15', 1),
(4707, 'Stara Zagora Province', 'BG', '24', 1),
(4708, 'Silistra Province', 'BG', '19', 1),
(4709, 'Veliko Tarnovo Province', 'BG', '04', 1),
(4710, 'Lovech Province', 'BG', '11', 1),
(4711, 'Vratsa Province', 'BG', '06', 1),
(4712, 'Pazardzhik Province', 'BG', '13', 1),
(4713, 'Ruse Province', 'BG', '18', 1),
(4714, 'Targovishte Province', 'BG', '25', 1),
(4715, 'Burgas Province', 'BG', '02', 1),
(4716, 'Yambol Province', 'BG', '28', 1),
(4717, 'Varna Province', 'BG', '03', 1),
(4718, 'Dobrich Province', 'BG', '08', 1),
(4719, 'Sofia Province', 'BG', '23', 1),
(4720, 'Suceava County', 'RO', 'SV', 1),
(4721, 'Hunedoara County', 'RO', 'HD', 1),
(4722, 'Arges', 'RO', 'AG', 1),
(4723, 'Bihor County', 'RO', 'BH', 1),
(4724, 'Alba', 'RO', 'AB', 1),
(4725, 'Ilfov County', 'RO', 'IF', 1),
(4726, 'Giurgiu County', 'RO', 'GR', 1),
(4727, 'Tulcea County', 'RO', 'TL', 1),
(4728, 'Teleorman County', 'RO', 'TR', 1),
(4729, 'Prahova County', 'RO', 'PH', 1),
(4730, 'Bucharest', 'RO', 'B', 1),
(4731, 'Neamț County', 'RO', 'NT', 1),
(4732, 'Călărași County', 'RO', 'CL', 1),
(4733, 'Bistrița-Năsăud County', 'RO', 'BN', 1),
(4734, 'Cluj County', 'RO', 'CJ', 1),
(4735, 'Iași County', 'RO', 'IS', 1),
(4736, 'Braila', 'RO', 'BR', 1),
(4737, 'Constanța County', 'RO', 'CT', 1),
(4738, 'Olt County', 'RO', 'OT', 1),
(4739, 'Arad County', 'RO', 'AR', 1),
(4740, 'Botoșani County', 'RO', 'BT', 1),
(4741, 'Sălaj County', 'RO', 'SJ', 1),
(4742, 'Dolj County', 'RO', 'DJ', 1),
(4743, 'Ialomița County', 'RO', 'IL', 1),
(4744, 'Bacău County', 'RO', 'BC', 1),
(4745, 'Dâmbovița County', 'RO', 'DB', 1),
(4746, 'Satu Mare County', 'RO', 'SM', 1),
(4747, 'Galați County', 'RO', 'GL', 1),
(4748, 'Timiș County', 'RO', 'TM', 1),
(4749, 'Harghita County', 'RO', 'HR', 1),
(4750, 'Gorj County', 'RO', 'GJ', 1),
(4751, 'Mehedinți County', 'RO', 'MH', 1),
(4752, 'Vaslui County', 'RO', 'VS', 1),
(4753, 'Caraș-Severin County', 'RO', 'CS', 1),
(4754, 'Covasna County', 'RO', 'CV', 1),
(4755, 'Sibiu County', 'RO', 'SB', 1),
(4756, 'Buzău County', 'RO', 'BZ', 1),
(4757, 'Vâlcea County', 'RO', 'VL', 1),
(4758, 'Vrancea County', 'RO', 'VN', 1),
(4759, 'Brașov County', 'RO', 'BV', 1),
(4760, 'Maramureș County', 'RO', 'MM', 1),
(4761, 'Aiga-i-le-Tai', 'WS', 'AL', 1),
(4762, 'Satupa\'itea', 'WS', 'SA', 1),
(4763, 'A\'ana', 'WS', 'AA', 1),
(4764, 'Fa\'asaleleaga', 'WS', 'FA', 1),
(4765, 'Atua', 'WS', 'AT', 1),
(4766, 'Vaisigano', 'WS', 'VS', 1),
(4767, 'Palauli', 'WS', 'PA', 1),
(4768, 'Va\'a-o-Fonoti', 'WS', 'VF', 1),
(4769, 'Gaga\'emauga', 'WS', 'GE', 1),
(4770, 'Tuamasaga', 'WS', 'TU', 1),
(4771, 'Gaga\'ifomauga', 'WS', 'GI', 1),
(4772, 'Torba', 'VU', 'TOB', 1),
(4773, 'Penama', 'VU', 'PAM', 1),
(4774, 'Shefa', 'VU', 'SEE', 1),
(4775, 'Malampa', 'VU', 'MAP', 1),
(4776, 'Sanma', 'VU', 'SAM', 1),
(4777, 'Tafea', 'VU', 'TAE', 1),
(4778, 'Honiara', 'SB', 'CT', 1),
(4779, 'Temotu Province', 'SB', 'TE', 1),
(4780, 'Isabel Province', 'SB', 'IS', 1),
(4781, 'Choiseul Province', 'SB', 'CH', 1),
(4782, 'Makira-Ulawa Province', 'SB', 'MK', 1),
(4783, 'Malaita Province', 'SB', 'ML', 1),
(4784, 'Central Province', 'SB', 'CE', 1),
(4785, 'Guadalcanal Province', 'SB', 'GU', 1),
(4786, 'Western Province', 'SB', 'WE', 1),
(4787, 'Rennell and Bellona Province', 'SB', 'RB', 1),
(4794, 'Saint-Barthélemy', 'FR', 'BL', 1),
(4795, 'Nouvelle-Aquitaine', 'FR', 'NAQ', 1),
(4796, 'Île-de-France', 'FR', 'IDF', 1),
(4797, 'Mayotte', 'FR', '976', 1),
(4798, 'Auvergne-Rhône-Alpes', 'FR', 'ARA', 1),
(4799, 'Occitanie', 'FR', 'OCC', 1),
(4802, 'Pays-de-la-Loire', 'FR', 'PDL', 1),
(4804, 'Normandie', 'FR', 'NOR', 1),
(4806, 'Corse', 'FR', '20R', 1),
(4807, 'Bretagne', 'FR', 'BRE', 1),
(4809, 'Saint-Martin', 'FR', 'MF', 1),
(4810, 'Wallis and Futuna', 'FR', 'WF', 1),
(4811, 'Alsace', 'FR', '6AE', 1),
(4812, 'Provence-Alpes-Côte-d’Azur', 'FR', 'PAC', 1),
(4816, 'Paris', 'FR', '75C', 1),
(4818, 'Centre-Val de Loire', 'FR', 'CVL', 1),
(4820, 'Grand-Est', 'FR', 'GES', 1),
(4821, 'Saint Pierre and Miquelon', 'FR', 'PM', 1),
(4822, 'French Guiana', 'FR', '973', 1),
(4823, 'La Réunion', 'FR', '974', 1),
(4824, 'French Polynesia', 'FR', 'PF', 1),
(4825, 'Bourgogne-Franche-Comté', 'FR', 'BFC', 1),
(4827, 'Martinique', 'FR', '972', 1),
(4828, 'Hauts-de-France', 'FR', 'HDF', 1),
(4829, 'Guadeloupe', 'FR', '971', 1),
(4830, 'West New Britain Province', 'PG', 'WBK', 1),
(4831, 'Bougainville', 'PG', 'NSB', 1),
(4832, 'Jiwaka Province', 'PG', 'JWK', 1),
(4833, 'Hela', 'PG', 'HLA', 1),
(4834, 'East New Britain', 'PG', 'EBR', 1),
(4835, 'Morobe Province', 'PG', 'MPL', 1),
(4836, 'Sandaun Province', 'PG', 'SAN', 1),
(4837, 'Port Moresby', 'PG', 'NCD', 1),
(4838, 'Oro Province', 'PG', 'NPP', 1),
(4839, 'Gulf', 'PG', 'GPK', 1),
(4840, 'Western Highlands Province', 'PG', 'WHM', 1),
(4841, 'New Ireland Province', 'PG', 'NIK', 1),
(4842, 'Manus Province', 'PG', 'MRL', 1),
(4843, 'Madang Province', 'PG', 'MPM', 1),
(4844, 'Southern Highlands Province', 'PG', 'SHM', 1),
(4845, 'Eastern Highlands Province', 'PG', 'EHG', 1),
(4846, 'Chimbu Province', 'PG', 'CPK', 1),
(4847, 'Central Province', 'PG', 'CPM', 1),
(4848, 'Enga Province', 'PG', 'EPW', 1),
(4849, 'Milne Bay Province', 'PG', 'MBA', 1),
(4850, 'Western Province', 'PG', 'WPD', 1),
(4851, 'Ohio', 'US', 'OH', 1),
(4852, 'Ladakh', 'IN', 'LA', 1),
(4853, 'West Bengal', 'IN', 'WB', 1),
(4854, 'Sinop', 'TR', '57', 1),
(4855, 'Distrito Capital', 'VE', 'A', 1),
(4856, 'Apure', 'VE', 'C', 1),
(4857, 'Jalisco', 'MX', 'JAL', 1),
(4858, 'Roraima', 'BR', 'RR', 1),
(4859, 'Guarda', 'PT', '09', 1),
(4860, 'Devonshire Parish', 'BM', 'DEV', 1),
(4861, 'Hamilton Parish', 'BM', 'HA', 1),
(4863, 'Paget Parish', 'BM', 'PAG', 1),
(4864, 'Pembroke Parish', 'BM', 'PEM', 1),
(4866, 'Saint George\'s Parish', 'BM', 'SGE', 1),
(4867, 'Sandys Parish', 'BM', 'SAN', 1),
(4868, 'Smith\'s Parish,', 'BM', 'SMI', 1),
(4869, 'Southampton Parish', 'BM', 'SOU', 1),
(4870, 'Warwick Parish', 'BM', 'WAR', 1),
(4871, 'Huila', 'CO', 'HUI', 1),
(4874, 'Uroševac District (Ferizaj)', 'XK', 'XUF', 1),
(4876, 'Đakovica District (Gjakove)', 'XK', 'XDG', 1),
(4877, 'Gjilan District', 'XK', 'XGJ', 1),
(4878, 'Kosovska Mitrovica District', 'XK', 'XKM', 1),
(4879, 'Pristina (Priştine)', 'XK', 'XPI', 1),
(4880, 'Ciudad Autónoma de Buenos Aires', 'AR', 'C', 1),
(4881, 'New Providence', 'BS', 'NP', 1),
(4882, 'Shumen', 'BG', '27', 1),
(4883, 'Yuen Long District', 'HK', 'NYL', 1),
(4884, 'Tsuen Wan District', 'HK', 'NTW', 1),
(4885, 'Tai Po District', 'KH', 'NTP', 1),
(4887, 'Sai Kung District', 'HK', 'NSK', 1),
(4888, 'Islands District', 'HK', 'NIS', 1),
(4889, 'Central and Western District', 'HK', 'HCW', 1),
(4890, 'Wan Chai', 'HK', 'HWC', 1),
(4891, 'Eastern', 'HK', 'HEA', 1),
(4892, 'Southern', 'HK', 'HSO', 1),
(4893, 'Yau Tsim Mong', 'HK', 'KYT', 1),
(4894, 'Sham Shui Po', 'HK', 'KSS', 1),
(4895, 'Kowloon City', 'HK', 'KKC', 1),
(4896, 'Wong Tai Sin', 'HK', 'KWT', 1),
(4897, 'Kwun Tong', 'HK', 'KKT', 1),
(4898, 'Kwai Tsing', 'HK', 'NKT', 1),
(4899, 'Tuen Mun', 'HK', 'NTM', 1),
(4900, 'North', 'HK', 'NNO', 1),
(4901, 'Sha Tin', 'HK', 'NST', 1),
(4902, 'Sidi Bel Abbès', 'DZ', '22', 1),
(4905, 'El M\'ghair', 'DZ', '49', 1),
(4906, 'El Menia', 'DZ', '50', 1),
(4907, 'Ouled Djellal', 'DZ', '51', 1),
(4908, 'Bordj Baji Mokhtar', 'DZ', '52', 1),
(4909, 'Béni Abbès', 'DZ', '53', 1),
(4910, 'Timimoun', 'DZ', '54', 1),
(4911, 'Touggourt', 'DZ', '55', 1),
(4912, 'Djanet', 'DZ', '56', 1),
(4913, 'In Salah', 'DZ', '57', 1),
(4914, 'In Guezzam', 'DZ', '58', 1),
(4915, 'Mureș County', 'RO', 'MS', 1),
(4916, 'Volgograd Oblast', 'RU', 'VGG', 1),
(4917, 'La Colle', 'MC', 'CL', 1),
(4918, 'La Condamine', 'MC', 'CO', 1),
(4919, 'Moneghetti', 'MC', 'MG', 1),
(4920, 'Hamadan', 'IR', '13', 1),
(4921, 'Bogotá D.C.', 'CO', 'DC', 1),
(4922, 'Loreto', 'PE', 'LOR', 1),
(4923, 'Kutná Hora', 'CZ', '205', 1),
(4924, 'Kōchi Prefecture', 'JP', '39', 1),
(4925, 'Cần Thơ', 'VN', 'CT', 1),
(4926, 'Rivers', 'NG', 'RI', 1),
(4927, 'Rabat-Salé-Kénitra', 'MA', '04', 1),
(4928, 'Agadir-Ida-Ou-Tanane', 'MA', 'AGD', 1),
(4929, 'Berrechid', 'MA', 'BRR', 1),
(4930, 'Casablanca', 'MA', 'CAS', 1),
(4931, 'Driouch', 'MA', 'DRI', 1),
(4932, 'Fès', 'MA', 'FES', 1),
(4933, 'Fquih Ben Salah', 'MA', 'FQH', 1),
(4934, 'Guercif', 'MA', 'GUF', 1),
(4935, 'Marrakech', 'MA', 'MAR', 1),
(4936, 'M’diq-Fnideq', 'MA', 'MDF', 1),
(4937, 'Meknès', 'MA', 'MEK', 1),
(4938, 'Midelt', 'MA', 'MID', 1),
(4939, 'Mohammadia', 'MA', 'MOH', 1),
(4940, 'Oujda-Angad', 'MA', 'OUJ', 1),
(4941, 'Ouezzane', 'MA', 'OUZ', 1),
(4942, 'Rabat', 'MA', 'RAB', 1),
(4943, 'Rehamna', 'MA', 'REH', 1),
(4944, 'Salé', 'MA', 'SAL', 1),
(4945, 'Sidi Bennour', 'MA', 'SIB', 1),
(4946, 'Sidi Ifni', 'MA', 'SIF', 1),
(4947, 'Skhirate-Témara', 'MA', 'SKH', 1),
(4948, 'Tarfaya (EH-partial)', 'MA', 'TAF', 1),
(4949, 'Tinghir', 'MA', 'TIN', 1),
(4950, 'Tanger-Assilah', 'MA', 'TNG', 1),
(4951, 'Youssoufia', 'MA', 'YUS', 1),
(4952, 'Sidi Slimane', 'MA', 'SIL', 1),
(4953, 'Lualaba', 'CD', 'LU', 1),
(4954, 'Chaiyaphum', 'TH', '36', 1),
(4955, 'Mbeya', 'TZ', '14', 1),
(4956, 'Songwe', 'TZ', '31', 1),
(4957, 'Basel-Stadt', 'CH', 'BS', 1),
(4958, 'Bono East', 'GH', 'BE', 1),
(4959, 'Bono', 'GH', 'BO', 1),
(4960, 'North East', 'GH', 'NE', 1),
(4961, 'Oti', 'GH', 'OT', 1),
(4962, 'Savannah', 'GH', 'SV', 1),
(4963, 'Western North', 'GH', 'WN', 1),
(4964, 'Nueva Segovia', 'NI', 'NS', 1),
(4965, 'Keelung', 'TW', 'KEE', 1),
(4966, 'New Taipei', 'TW', 'NWT', 1),
(4967, 'Ain', 'FR', '01', 1),
(4968, 'Aisne', 'FR', '02', 1),
(4969, 'Allier', 'FR', '03', 1),
(4970, 'Alpes-de-Haute-Provence', 'FR', '04', 1),
(4971, 'Hautes-Alpes', 'FR', '05', 1),
(4972, 'Alpes-Maritimes', 'FR', '06', 1),
(4973, 'Ardèche', 'FR', '07', 1),
(4974, 'Ardennes', 'FR', '08', 1),
(4975, 'Ariège', 'FR', '09', 1),
(4976, 'Aube', 'FR', '10', 1),
(4977, 'Aude', 'FR', '11', 1),
(4978, 'Aveyron', 'FR', '12', 1),
(4979, 'Bouches-du-Rhône', 'FR', '13', 1),
(4981, 'Calvados', 'FR', '14', 1),
(4982, 'Cantal', 'FR', '15', 1),
(4983, 'Charente', 'FR', '16', 1),
(4984, 'Charente-Maritime', 'FR', '17', 1),
(4985, 'Cher', 'FR', '18', 1),
(4986, 'Corrèze', 'FR', '19', 1),
(4987, 'Côte-d\'Or', 'FR', '21', 1),
(4988, 'Côtes-d\'Armor', 'FR', '22', 1),
(4989, 'Creuse', 'FR', '23', 1),
(4990, 'Dordogne', 'FR', '24', 1),
(4991, 'Doubs', 'FR', '25', 1),
(4992, 'Drôme', 'FR', '26', 1),
(4993, 'Eure', 'FR', '27', 1),
(4994, 'Eure-et-Loir', 'FR', '28', 1),
(4995, 'Finistère', 'FR', '29', 1),
(4996, 'Corse-du-Sud', 'FR', '2A', 1),
(4997, 'Haute-Corse', 'FR', '2B', 1),
(4998, 'Gard', 'FR', '30', 1),
(4999, 'Haute-Garonne', 'FR', '31', 1),
(5000, 'Gers', 'FR', '32', 1),
(5001, 'Gironde', 'FR', '33', 1),
(5002, 'Hérault', 'FR', '34', 1),
(5003, 'Ille-et-Vilaine', 'FR', '35', 1),
(5004, 'Indre', 'FR', '36', 1),
(5005, 'Indre-et-Loire', 'FR', '37', 1),
(5006, 'Isère', 'FR', '38', 1),
(5007, 'Jura', 'FR', '39', 1),
(5008, 'Landes', 'FR', '40', 1),
(5009, 'Loir-et-Cher', 'FR', '41', 1),
(5010, 'Loire', 'FR', '42', 1),
(5011, 'Haute-Loire', 'FR', '43', 1),
(5012, 'Loire-Atlantique', 'FR', '44', 1),
(5013, 'Loiret', 'FR', '45', 1),
(5014, 'Lot', 'FR', '46', 1),
(5015, 'Lot-et-Garonne', 'FR', '47', 1),
(5016, 'Lozère', 'FR', '48', 1),
(5017, 'Maine-et-Loire', 'FR', '49', 1),
(5018, 'Manche', 'FR', '50', 1),
(5019, 'Marne', 'FR', '51', 1),
(5020, 'Haute-Marne', 'FR', '52', 1),
(5021, 'Mayenne', 'FR', '53', 1),
(5022, 'Meurthe-et-Moselle', 'FR', '54', 1),
(5023, 'Meuse', 'FR', '55', 1),
(5024, 'Morbihan', 'FR', '56', 1),
(5025, 'Moselle', 'FR', '57', 1),
(5026, 'Nièvre', 'FR', '58', 1),
(5027, 'Nord', 'FR', '59', 1),
(5028, 'Oise', 'FR', '60', 1),
(5029, 'Orne', 'FR', '61', 1),
(5030, 'Pas-de-Calais', 'FR', '62', 1),
(5031, 'Puy-de-Dôme', 'FR', '63', 1),
(5032, 'Pyrénées-Atlantiques', 'FR', '64', 1),
(5033, 'Hautes-Pyrénées', 'FR', '65', 1),
(5034, 'Pyrénées-Orientales', 'FR', '66', 1),
(5035, 'Bas-Rhin', 'FR', '67', 1),
(5036, 'Haut-Rhin', 'FR', '68', 1),
(5037, 'Rhône', 'FR', '69', 1),
(5038, 'Métropole de Lyon', 'FR', '69M', 1),
(5039, 'Haute-Saône', 'FR', '70', 1),
(5040, 'Saône-et-Loire', 'FR', '71', 1),
(5041, 'Sarthe', 'FR', '72', 1),
(5042, 'Savoie', 'FR', '73', 1),
(5043, 'Haute-Savoie', 'FR', '74', 1),
(5044, 'Seine-Maritime', 'FR', '76', 1),
(5045, 'Seine-et-Marne', 'FR', '77', 1),
(5046, 'Yvelines', 'FR', '78', 1),
(5047, 'Deux-Sèvres', 'FR', '79', 1),
(5048, 'Somme', 'FR', '80', 1),
(5049, 'Tarn', 'FR', '81', 1),
(5050, 'Tarn-et-Garonne', 'FR', '82', 1),
(5051, 'Var', 'FR', '83', 1),
(5052, 'Vaucluse', 'FR', '84', 1),
(5053, 'Vendée', 'FR', '85', 1),
(5054, 'Vienne', 'FR', '86', 1),
(5055, 'Haute-Vienne', 'FR', '87', 1),
(5056, 'Vosges', 'FR', '88', 1),
(5057, 'Yonne', 'FR', '89', 1),
(5058, 'Territoire de Belfort', 'FR', '90', 1),
(5059, 'Essonne', 'FR', '91', 1),
(5060, 'Hauts-de-Seine', 'FR', '92', 1),
(5061, 'Seine-Saint-Denis', 'FR', '93', 1),
(5062, 'Val-de-Marne', 'FR', '94', 1),
(5063, 'Val-d\'Oise', 'FR', '95', 1),
(5064, 'Clipperton', 'FR', 'CP', 1),
(5065, 'French Southern and Antarctic Lands', 'FR', 'TF', 1),
(5067, 'Sharqia', 'EG', 'SHR', 1),
(5068, 'Loja', 'EC', 'L', 1),
(5069, 'Karlovac', 'HR', '04', 1),
(5070, 'Kampong Thom', 'KH', '6', 1),
(5071, 'Poltavska oblast', 'UA', '53', 1),
(5072, 'Saint Thomas', 'VI', 'ST', 1),
(5073, 'Saint John', 'VI', 'SJ', 1),
(5074, 'Saint Croix', 'VI', 'SC', 1),
(5075, 'San Juan', 'PR', 'SJ', 1),
(5076, 'Bayamon', 'PR', 'BY', 1),
(5077, 'Carolina', 'PR', 'CL', 1),
(5078, 'Ponce', 'PR', 'PO', 1),
(5079, 'Caguas', 'PR', 'CG', 1),
(5080, 'Guaynabo', 'PR', 'GN', 1),
(5081, 'Arecibo', 'PR', 'AR', 1),
(5082, 'Toa Baja', 'PR', 'TB', 1),
(5083, 'Mayagüez', 'PR', 'MG', 1),
(5084, 'Trujillo Alto', 'PR', 'TA', 1),
(5085, 'Komárom-Esztergom', 'HU', 'KE', 1),
(5086, 'Bonaire', 'BQ', 'BQ1', 1),
(5087, 'Saba', 'BQ', 'BQ2', 1),
(5088, 'Sint Eustatius', 'BQ', 'BQ3', 1),
(5089, 'A Coruña', 'ES', 'C', 1),
(5090, 'Lugo', 'ES', 'LU', 1),
(5091, 'Ourense', 'ES', 'OR', 1),
(5092, 'Badajoz', 'ES', 'BA', 1),
(5093, 'Araba', 'ES', 'VI', 1),
(5094, 'Bizkaia', 'ES', 'BI', 1),
(5095, 'Almeria', 'ES', 'AL', 1),
(5096, 'Cádiz', 'ES', 'CA', 1),
(5097, 'Córdoba', 'ES', 'CO', 1),
(5098, 'Granada', 'ES', 'GR', 1),
(5099, 'Huelva', 'ES', 'H', 1),
(5100, 'Jaén', 'ES', 'J', 1),
(5101, 'Málaga', 'ES', 'MA', 1),
(5102, 'Barcelona', 'ES', 'B', 1),
(5103, 'Girona', 'ES', 'GI', 1),
(5104, 'Lleida', 'ES', 'L', 1),
(5105, 'Ciudad Real', 'ES', 'CR', 1),
(5106, 'Cuenca', 'ES', 'CU', 1),
(5107, 'Guadalajara', 'ES', 'GU', 1),
(5108, 'Alicante', 'ES', 'A', 1),
(5109, 'Albacete', 'ES', 'AB', 1),
(5110, 'Castellón', 'ES', 'CS', 1),
(5111, 'Teruel', 'ES', 'TE', 1),
(5112, 'Santa Cruz de Tenerife', 'ES', 'TF', 1),
(5113, 'Zaragoza', 'ES', 'Z', 1),
(5114, 'Chari-Baguirmi', 'TD', 'CB', 1),
(5115, 'Western Samar', 'PH', 'WSA', 1),
(5116, 'Nabeul', 'TN', '21', 1);