<?php
/**
 * DomainMapping
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * DomainMapping Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DomainMapping implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DomainMapping';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'domain_id' => 'string',
        'website_id' => 'string',
        'domain' => 'string',
        'mapping_kind' => '\OpenAPI\Client\Model\DomainMappingKind',
        'document_root' => 'string',
        'cert' => '\OpenAPI\Client\Model\DomainSslCert',
        'cloudflare_status' => '\OpenAPI\Client\Model\CloudFlareStatus',
        'cloudflare_friendly_name' => 'string',
        'cloudflare_token_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'domain_id' => 'uuid',
        'website_id' => 'uuid',
        'domain' => null,
        'mapping_kind' => null,
        'document_root' => null,
        'cert' => null,
        'cloudflare_status' => null,
        'cloudflare_friendly_name' => null,
        'cloudflare_token_id' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'domain_id' => false,
        'website_id' => false,
        'domain' => false,
        'mapping_kind' => false,
        'document_root' => false,
        'cert' => false,
        'cloudflare_status' => false,
        'cloudflare_friendly_name' => false,
        'cloudflare_token_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'domain_id' => 'domainId',
        'website_id' => 'websiteId',
        'domain' => 'domain',
        'mapping_kind' => 'mappingKind',
        'document_root' => 'documentRoot',
        'cert' => 'cert',
        'cloudflare_status' => 'cloudflareStatus',
        'cloudflare_friendly_name' => 'cloudflareFriendlyName',
        'cloudflare_token_id' => 'cloudflareTokenId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'domain_id' => 'setDomainId',
        'website_id' => 'setWebsiteId',
        'domain' => 'setDomain',
        'mapping_kind' => 'setMappingKind',
        'document_root' => 'setDocumentRoot',
        'cert' => 'setCert',
        'cloudflare_status' => 'setCloudflareStatus',
        'cloudflare_friendly_name' => 'setCloudflareFriendlyName',
        'cloudflare_token_id' => 'setCloudflareTokenId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'domain_id' => 'getDomainId',
        'website_id' => 'getWebsiteId',
        'domain' => 'getDomain',
        'mapping_kind' => 'getMappingKind',
        'document_root' => 'getDocumentRoot',
        'cert' => 'getCert',
        'cloudflare_status' => 'getCloudflareStatus',
        'cloudflare_friendly_name' => 'getCloudflareFriendlyName',
        'cloudflare_token_id' => 'getCloudflareTokenId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('domain_id', $data ?? [], null);
        $this->setIfExists('website_id', $data ?? [], null);
        $this->setIfExists('domain', $data ?? [], null);
        $this->setIfExists('mapping_kind', $data ?? [], null);
        $this->setIfExists('document_root', $data ?? [], null);
        $this->setIfExists('cert', $data ?? [], null);
        $this->setIfExists('cloudflare_status', $data ?? [], null);
        $this->setIfExists('cloudflare_friendly_name', $data ?? [], null);
        $this->setIfExists('cloudflare_token_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['domain_id'] === null) {
            $invalidProperties[] = "'domain_id' can't be null";
        }
        if ($this->container['website_id'] === null) {
            $invalidProperties[] = "'website_id' can't be null";
        }
        if ($this->container['domain'] === null) {
            $invalidProperties[] = "'domain' can't be null";
        }
        if ($this->container['mapping_kind'] === null) {
            $invalidProperties[] = "'mapping_kind' can't be null";
        }
        if ($this->container['document_root'] === null) {
            $invalidProperties[] = "'document_root' can't be null";
        }
        if ($this->container['cloudflare_status'] === null) {
            $invalidProperties[] = "'cloudflare_status' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets domain_id
     *
     * @return string
     */
    public function getDomainId()
    {
        return $this->container['domain_id'];
    }

    /**
     * Sets domain_id
     *
     * @param string $domain_id domain_id
     *
     * @return self
     */
    public function setDomainId($domain_id)
    {
        if (is_null($domain_id)) {
            throw new \InvalidArgumentException('non-nullable domain_id cannot be null');
        }
        $this->container['domain_id'] = $domain_id;

        return $this;
    }

    /**
     * Gets website_id
     *
     * @return string
     */
    public function getWebsiteId()
    {
        return $this->container['website_id'];
    }

    /**
     * Sets website_id
     *
     * @param string $website_id website_id
     *
     * @return self
     */
    public function setWebsiteId($website_id)
    {
        if (is_null($website_id)) {
            throw new \InvalidArgumentException('non-nullable website_id cannot be null');
        }
        $this->container['website_id'] = $website_id;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string $domain domain
     *
     * @return self
     */
    public function setDomain($domain)
    {
        if (is_null($domain)) {
            throw new \InvalidArgumentException('non-nullable domain cannot be null');
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets mapping_kind
     *
     * @return \OpenAPI\Client\Model\DomainMappingKind
     */
    public function getMappingKind()
    {
        return $this->container['mapping_kind'];
    }

    /**
     * Sets mapping_kind
     *
     * @param \OpenAPI\Client\Model\DomainMappingKind $mapping_kind mapping_kind
     *
     * @return self
     */
    public function setMappingKind($mapping_kind)
    {
        if (is_null($mapping_kind)) {
            throw new \InvalidArgumentException('non-nullable mapping_kind cannot be null');
        }
        $this->container['mapping_kind'] = $mapping_kind;

        return $this;
    }

    /**
     * Gets document_root
     *
     * @return string
     */
    public function getDocumentRoot()
    {
        return $this->container['document_root'];
    }

    /**
     * Sets document_root
     *
     * @param string $document_root document_root
     *
     * @return self
     */
    public function setDocumentRoot($document_root)
    {
        if (is_null($document_root)) {
            throw new \InvalidArgumentException('non-nullable document_root cannot be null');
        }
        $this->container['document_root'] = $document_root;

        return $this;
    }

    /**
     * Gets cert
     *
     * @return \OpenAPI\Client\Model\DomainSslCert|null
     */
    public function getCert()
    {
        return $this->container['cert'];
    }

    /**
     * Sets cert
     *
     * @param \OpenAPI\Client\Model\DomainSslCert|null $cert cert
     *
     * @return self
     */
    public function setCert($cert)
    {
        if (is_null($cert)) {
            throw new \InvalidArgumentException('non-nullable cert cannot be null');
        }
        $this->container['cert'] = $cert;

        return $this;
    }

    /**
     * Gets cloudflare_status
     *
     * @return \OpenAPI\Client\Model\CloudFlareStatus
     */
    public function getCloudflareStatus()
    {
        return $this->container['cloudflare_status'];
    }

    /**
     * Sets cloudflare_status
     *
     * @param \OpenAPI\Client\Model\CloudFlareStatus $cloudflare_status cloudflare_status
     *
     * @return self
     */
    public function setCloudflareStatus($cloudflare_status)
    {
        if (is_null($cloudflare_status)) {
            throw new \InvalidArgumentException('non-nullable cloudflare_status cannot be null');
        }
        $this->container['cloudflare_status'] = $cloudflare_status;

        return $this;
    }

    /**
     * Gets cloudflare_friendly_name
     *
     * @return string|null
     */
    public function getCloudflareFriendlyName()
    {
        return $this->container['cloudflare_friendly_name'];
    }

    /**
     * Sets cloudflare_friendly_name
     *
     * @param string|null $cloudflare_friendly_name cloudflare_friendly_name
     *
     * @return self
     */
    public function setCloudflareFriendlyName($cloudflare_friendly_name)
    {
        if (is_null($cloudflare_friendly_name)) {
            throw new \InvalidArgumentException('non-nullable cloudflare_friendly_name cannot be null');
        }
        $this->container['cloudflare_friendly_name'] = $cloudflare_friendly_name;

        return $this;
    }

    /**
     * Gets cloudflare_token_id
     *
     * @return string|null
     */
    public function getCloudflareTokenId()
    {
        return $this->container['cloudflare_token_id'];
    }

    /**
     * Sets cloudflare_token_id
     *
     * @param string|null $cloudflare_token_id cloudflare_token_id
     *
     * @return self
     */
    public function setCloudflareTokenId($cloudflare_token_id)
    {
        if (is_null($cloudflare_token_id)) {
            throw new \InvalidArgumentException('non-nullable cloudflare_token_id cannot be null');
        }
        $this->container['cloudflare_token_id'] = $cloudflare_token_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


