/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => {
    // webpackBootstrap
    /******/ "use strict";
    /******/ var __webpack_modules__ = {
        /***/ "./src/skin/scss/system-settings-panel.scss":
            /*!**************************************************!*\
  !*** ./src/skin/scss/system-settings-panel.scss ***!
  \**************************************************/
            /***/ (__unused_webpack_module, __webpack_exports__, __webpack_require__) => {
                eval(
                    "{__webpack_require__.r(__webpack_exports__);\n// extracted by mini-css-extract-plugin\n\n\n//# sourceURL=webpack://churchcrm/./src/skin/scss/system-settings-panel.scss?\n}",
                );

                /***/
            },

        /***/ "./webpack/system-settings-panel.js":
            /*!******************************************!*\
  !*** ./webpack/system-settings-panel.js ***!
  \******************************************/
            /***/ (__unused_webpack_module, __webpack_exports__, __webpack_require__) => {
                eval(
                    "{__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _src_skin_scss_system_settings_panel_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../src/skin/scss/system-settings-panel.scss */ \"./src/skin/scss/system-settings-panel.scss\");\n/**\n * System Settings Panel - Reusable component for displaying/editing SystemConfig settings\n * \n * Usage:\n * 1. Include the CSS: <link rel=\"stylesheet\" href=\"<?= SystemURLs::getRootPath() ?>/skin/v2/system-settings-panel.min.css\">\n * 2. Include the JS: <script src=\"<?= SystemURLs::getRootPath() ?>/skin/v2/system-settings-panel.min.js\"></script>\n * 3. Add container: <div id=\"settingsPanel\"></div>\n * 4. Initialize:\n *    window.CRM.settingsPanel.init({\n *        container: '#settingsPanel',\n *        title: 'Financial Settings',\n *        icon: 'fa-solid fa-sliders',\n *        settings: ['iFYMonth', 'bEnableNonDeductible', 'iChecksPerDepositForm'],\n *        onSave: function() { window.location.reload(); }\n *    });\n */\n\n\n\n(function() {\n    'use strict';\n\n    // Setting type definitions with rendering and value extraction\n    const SettingTypes = {\n        boolean: {\n            render: function(setting, value) {\n                const checked = value === '1' || value === 'true' || value === true;\n                return `\n                    <div class=\"col-md-6 col-lg-4 mb-3\">\n                        <div class=\"custom-control custom-switch mt-2\">\n                            <input type=\"checkbox\" class=\"custom-control-input setting-input\" \n                                   id=\"${setting.name}\" name=\"${setting.name}\"\n                                   data-type=\"boolean\"\n                                   ${checked ? 'checked' : ''}>\n                            <label class=\"custom-control-label\" for=\"${setting.name}\">\n                                ${setting.label}\n                            </label>\n                            ${setting.tooltip ? `<small class=\"form-text text-muted d-block\">${setting.tooltip}</small>` : ''}\n                        </div>\n                    </div>\n                `;\n            },\n            getValue: function(el) {\n                return el.checked ? '1' : '0';\n            }\n        },\n        number: {\n            render: function(setting, value) {\n                return `\n                    <div class=\"col-md-6 col-lg-4 mb-3\">\n                        <label for=\"${setting.name}\" class=\"form-label small font-weight-bold mb-1\">\n                            ${setting.label}\n                            ${setting.helpLink ? `<a href=\"${setting.helpLink}\" target=\"_blank\" class=\"text-info ml-1\"><i class=\"fa-solid fa-circle-question\"></i></a>` : ''}\n                        </label>\n                        <input type=\"number\" class=\"form-control setting-input\" \n                               id=\"${setting.name}\" name=\"${setting.name}\"\n                               data-type=\"number\"\n                               value=\"${value || ''}\" \n                               ${setting.min !== undefined ? `min=\"${setting.min}\"` : ''}\n                               ${setting.max !== undefined ? `max=\"${setting.max}\"` : ''}>\n                        ${setting.tooltip ? `<small class=\"form-text text-muted\">${setting.tooltip}</small>` : ''}\n                    </div>\n                `;\n            },\n            getValue: function(el) {\n                return el.value;\n            }\n        },\n        text: {\n            render: function(setting, value) {\n                return `\n                    <div class=\"col-md-6 col-lg-4 mb-3\">\n                        <label for=\"${setting.name}\" class=\"form-label small font-weight-bold mb-1\">\n                            ${setting.label}\n                            ${setting.helpLink ? `<a href=\"${setting.helpLink}\" target=\"_blank\" class=\"text-info ml-1\"><i class=\"fa-solid fa-circle-question\"></i></a>` : ''}\n                        </label>\n                        <input type=\"text\" class=\"form-control setting-input\" \n                               id=\"${setting.name}\" name=\"${setting.name}\"\n                               data-type=\"text\"\n                               value=\"${escapeHtml(value || '')}\"\n                               ${setting.placeholder ? `placeholder=\"${setting.placeholder}\"` : ''}>\n                        ${setting.tooltip ? `<small class=\"form-text text-muted\">${setting.tooltip}</small>` : ''}\n                    </div>\n                `;\n            },\n            getValue: function(el) {\n                return el.value;\n            }\n        },\n        choice: {\n            render: function(setting, value) {\n                let optionsHtml = '';\n                if (setting.choices) {\n                    setting.choices.forEach(function(choice) {\n                        const optValue = typeof choice === 'object' ? choice.value : choice;\n                        const optLabel = typeof choice === 'object' ? choice.label : choice;\n                        const selected = String(value) === String(optValue) ? 'selected' : '';\n                        optionsHtml += `<option value=\"${escapeHtml(optValue)}\" ${selected}>${escapeHtml(optLabel)}</option>`;\n                    });\n                }\n                return `\n                    <div class=\"col-md-6 col-lg-4 mb-3\">\n                        <label for=\"${setting.name}\" class=\"form-label small font-weight-bold mb-1\">\n                            ${setting.label}\n                            ${setting.helpLink ? `<a href=\"${setting.helpLink}\" target=\"_blank\" class=\"text-info ml-1\"><i class=\"fa-solid fa-circle-question\"></i></a>` : ''}\n                        </label>\n                        <select class=\"form-control setting-input\" \n                                id=\"${setting.name}\" name=\"${setting.name}\"\n                                data-type=\"choice\">\n                            ${optionsHtml}\n                        </select>\n                        ${setting.tooltip ? `<small class=\"form-text text-muted\">${setting.tooltip}</small>` : ''}\n                    </div>\n                `;\n            },\n            getValue: function(el) {\n                return el.value;\n            }\n        },\n        password: {\n            render: function(setting, value) {\n                return `\n                    <div class=\"col-md-6 col-lg-4 mb-3\">\n                        <label for=\"${setting.name}\" class=\"form-label small font-weight-bold mb-1\">\n                            ${setting.label}\n                        </label>\n                        <input type=\"password\" class=\"form-control setting-input\" \n                               id=\"${setting.name}\" name=\"${setting.name}\"\n                               data-type=\"password\"\n                               value=\"${value || ''}\"\n                               autocomplete=\"new-password\">\n                        ${setting.tooltip ? `<small class=\"form-text text-muted\">${setting.tooltip}</small>` : ''}\n                    </div>\n                `;\n            },\n            getValue: function(el) {\n                return el.value;\n            }\n        }\n    };\n\n    // Escape HTML to prevent XSS\n    function escapeHtml(str) {\n        if (!str) return '';\n        const div = document.createElement('div');\n        div.textContent = str;\n        return div.innerHTML;\n    }\n\n    // Month choices helper\n    function getMonthChoices() {\n        return [\n            { value: '1', label: window.i18next ? i18next.t('January') : 'January' },\n            { value: '2', label: window.i18next ? i18next.t('February') : 'February' },\n            { value: '3', label: window.i18next ? i18next.t('March') : 'March' },\n            { value: '4', label: window.i18next ? i18next.t('April') : 'April' },\n            { value: '5', label: window.i18next ? i18next.t('May') : 'May' },\n            { value: '6', label: window.i18next ? i18next.t('June') : 'June' },\n            { value: '7', label: window.i18next ? i18next.t('July') : 'July' },\n            { value: '8', label: window.i18next ? i18next.t('August') : 'August' },\n            { value: '9', label: window.i18next ? i18next.t('September') : 'September' },\n            { value: '10', label: window.i18next ? i18next.t('October') : 'October' },\n            { value: '11', label: window.i18next ? i18next.t('November') : 'November' },\n            { value: '12', label: window.i18next ? i18next.t('December') : 'December' }\n        ];\n    }\n\n    // Pre-defined setting configurations (from SystemConfig)\n    const SettingDefinitions = {\n        // Financial Settings\n        'iFYMonth': {\n            type: 'choice',\n            label: 'First month of the fiscal year',\n            choices: getMonthChoices\n        },\n        'sDepositSlipType': {\n            type: 'choice',\n            label: 'Deposit ticket type',\n            tooltip: 'QBDT - QuickBooks Deposit Ticket',\n            choices: [{ value: 'QBDT', label: 'QBDT (QuickBooks)' }]\n        },\n        'iChecksPerDepositForm': {\n            type: 'number',\n            label: 'Number of checks for Deposit Slip Report',\n            min: 1,\n            max: 100\n        },\n        'bDisplayBillCounts': {\n            type: 'boolean',\n            label: 'Display bill counts on deposit slip'\n        },\n        'bUseScannedChecks': {\n            type: 'boolean',\n            label: 'Enable use of scanned checks'\n        },\n        'bEnableNonDeductible': {\n            type: 'boolean',\n            label: 'Enable non-deductible payments'\n        },\n        'bUseDonationEnvelopes': {\n            type: 'boolean',\n            label: 'Enable use of donation envelopes'\n        },\n        'aFinanceQueries': {\n            type: 'text',\n            label: 'Finance permission query IDs',\n            tooltip: 'Comma-separated query IDs requiring finance permissions',\n            placeholder: '30,31,32'\n        },\n        // Church Information\n        'sChurchName': {\n            type: 'text',\n            label: 'Church Name'\n        },\n        'sChurchAddress': {\n            type: 'text',\n            label: 'Church Address'\n        },\n        'sChurchCity': {\n            type: 'text',\n            label: 'Church City'\n        },\n        'sChurchState': {\n            type: 'text',\n            label: 'Church State'\n        },\n        'sChurchZip': {\n            type: 'text',\n            label: 'Church Zip'\n        },\n        'sChurchPhone': {\n            type: 'text',\n            label: 'Church Phone'\n        },\n        'sChurchEmail': {\n            type: 'text',\n            label: 'Church Email'\n        },\n        // Report Settings\n        'sTaxSigner': {\n            type: 'text',\n            label: 'Tax Report signer'\n        },\n        'sReminderSigner': {\n            type: 'text',\n            label: 'Pledge Reminder Signer'\n        }\n    };\n\n    // Settings Panel Class\n    class SettingsPanel {\n        constructor() {\n            this.options = {};\n            this.settingValues = {};\n            this.initialized = false;\n        }\n\n        /**\n         * Initialize the settings panel\n         * @param {Object} options Configuration options\n         * @param {string} options.container - CSS selector for container element\n         * @param {string} options.toggleButton - CSS selector for toggle button (optional)\n         * @param {string} options.title - Panel title\n         * @param {string} options.icon - Font Awesome icon class\n         * @param {Array} options.settings - Array of setting names or setting config objects\n         * @param {Function} options.onSave - Callback after successful save\n         * @param {boolean} options.showAllSettingsLink - Show link to System Settings page\n         * @param {string} options.headerClass - CSS class for header (default: bg-info)\n         */\n        init(options) {\n            this.options = Object.assign({\n                container: '#settingsPanel',\n                toggleButton: null,\n                title: 'Settings',\n                icon: 'fa-solid fa-cog',\n                settings: [],\n                onSave: null,\n                showAllSettingsLink: true,\n                headerClass: 'bg-info'\n            }, options);\n\n            this.container = document.querySelector(this.options.container);\n            if (!this.container) {\n                console.error('Settings panel container not found:', this.options.container);\n                return;\n            }\n\n            this.loadSettings();\n        }\n\n        // Load current setting values from API\n        loadSettings() {\n            const self = this;\n            const settingNames = this.options.settings.map(s => typeof s === 'string' ? s : s.name);\n            \n            // Fetch all setting values\n            const promises = settingNames.map(name => {\n                return fetch(window.CRM.root + '/api/system/config/' + name)\n                    .then(response => response.json())\n                    .then(data => {\n                        self.settingValues[name] = data.value;\n                    })\n                    .catch(err => {\n                        console.warn('Could not load setting:', name);\n                        self.settingValues[name] = '';\n                    });\n            });\n\n            Promise.all(promises).then(() => {\n                self.render();\n                self.bindEvents();\n                self.initialized = true;\n            });\n        }\n\n        // Render the panel HTML\n        render() {\n            let settingsHtml = '';\n\n            this.options.settings.forEach(setting => {\n                const settingName = typeof setting === 'string' ? setting : setting.name;\n                const settingConfig = this.getSettingConfig(setting);\n                const value = this.settingValues[settingName];\n                \n                const renderer = SettingTypes[settingConfig.type];\n                if (renderer) {\n                    // Handle dynamic choices (functions)\n                    if (typeof settingConfig.choices === 'function') {\n                        settingConfig.choices = settingConfig.choices();\n                    }\n                    settingsHtml += renderer.render(settingConfig, value);\n                }\n            });\n\n            const t = window.i18next ? i18next.t.bind(i18next) : (s => s);\n            \n            const html = `\n                <div class=\"card settings-panel-card border-info\">\n                    <div class=\"card-header ${this.options.headerClass} text-white py-2\">\n                        <h6 class=\"mb-0\">\n                            <i class=\"${this.options.icon}\"></i> ${this.options.title}\n                        </h6>\n                    </div>\n                    <div class=\"card-body\">\n                        <form id=\"settingsPanelForm\">\n                            <div class=\"row\">\n                                ${settingsHtml}\n                            </div>\n                            <hr class=\"my-3\">\n                            <div class=\"d-flex justify-content-between align-items-center\">\n                                ${this.options.showAllSettingsLink ? `\n                                <a href=\"${window.CRM.root}/SystemSettings.php\" class=\"btn btn-outline-secondary btn-sm\">\n                                    <i class=\"fa-solid fa-external-link-alt mr-1\"></i> ${t('All System Settings')}\n                                </a>\n                                ` : '<div></div>'}\n                                <button type=\"button\" id=\"settingsPanelSaveBtn\" class=\"btn btn-primary\">\n                                    <i class=\"fa-solid fa-save mr-1\"></i> ${t('Save Settings')}\n                                </button>\n                            </div>\n                        </form>\n                    </div>\n                </div>\n            `;\n\n            this.container.innerHTML = html;\n        }\n\n        // Get merged setting configuration\n        getSettingConfig(setting) {\n            const name = typeof setting === 'string' ? setting : setting.name;\n            const baseConfig = SettingDefinitions[name] || { type: 'text', label: name };\n            const customConfig = typeof setting === 'object' ? setting : {};\n            \n            return Object.assign({ name: name }, baseConfig, customConfig);\n        }\n\n        // Bind event handlers\n        bindEvents() {\n            const self = this;\n            const saveBtn = this.container.querySelector('#settingsPanelSaveBtn');\n            \n            if (saveBtn) {\n                saveBtn.addEventListener('click', function() {\n                    self.save();\n                });\n            }\n\n            // Toggle button handling\n            if (this.options.toggleButton) {\n                const toggleBtn = document.querySelector(this.options.toggleButton);\n                if (toggleBtn) {\n                    toggleBtn.addEventListener('click', function() {\n                        $(self.container).collapse('toggle');\n                    });\n                }\n            }\n        }\n\n        // Save all settings\n        save() {\n            const self = this;\n            const saveBtn = this.container.querySelector('#settingsPanelSaveBtn');\n            const originalHtml = saveBtn.innerHTML;\n            const t = window.i18next ? i18next.t.bind(i18next) : (s => s);\n            \n            // Disable button and show loading\n            saveBtn.disabled = true;\n            saveBtn.innerHTML = '<i class=\"fa-solid fa-spinner fa-spin mr-1\"></i> ' + t('Saving...');\n\n            // Collect all setting values\n            const settings = {};\n            this.container.querySelectorAll('.setting-input').forEach(function(input) {\n                const type = input.dataset.type;\n                const renderer = SettingTypes[type];\n                if (renderer) {\n                    settings[input.name] = renderer.getValue(input);\n                }\n            });\n\n            // Save each setting\n            const promises = Object.keys(settings).map(function(key) {\n                return fetch(window.CRM.root + '/api/system/config/' + key, {\n                    method: 'POST',\n                    headers: {\n                        'Content-Type': 'application/json'\n                    },\n                    body: JSON.stringify({ value: settings[key] })\n                });\n            });\n\n            Promise.all(promises)\n                .then(function() {\n                    if (window.CRM && window.CRM.notify) {\n                        window.CRM.notify(t('Settings saved successfully'), { type: 'success', delay: 2000 });\n                    }\n                    \n                    if (typeof self.options.onSave === 'function') {\n                        self.options.onSave();\n                    }\n                })\n                .catch(function(error) {\n                    if (window.CRM && window.CRM.notify) {\n                        window.CRM.notify(t('Failed to save settings'), { type: 'error', delay: 5000 });\n                    }\n                    saveBtn.disabled = false;\n                    saveBtn.innerHTML = originalHtml;\n                });\n        }\n\n        // Add a custom setting definition\n        static addSettingDefinition(name, config) {\n            SettingDefinitions[name] = config;\n        }\n\n        // Add a custom setting type renderer\n        static addSettingType(typeName, renderer) {\n            SettingTypes[typeName] = renderer;\n        }\n    }\n\n    // Export to window.CRM namespace\n    window.CRM = window.CRM || {};\n    window.CRM.SettingsPanel = SettingsPanel;\n    window.CRM.settingsPanel = new SettingsPanel();\n\n})();\n\n\n//# sourceURL=webpack://churchcrm/./webpack/system-settings-panel.js?\n}",
                );

                /***/
            },

        /******/
    };
    /************************************************************************/
    /******/ // The module cache
    /******/ var __webpack_module_cache__ = {};
    /******/
    /******/ // The require function
    /******/ function __webpack_require__(moduleId) {
        /******/ // Check if module is in cache
        /******/ var cachedModule = __webpack_module_cache__[moduleId];
        /******/ if (cachedModule !== undefined) {
            /******/ return cachedModule.exports;
            /******/
        }
        /******/ // Create a new module (and put it into the cache)
        /******/ var module = (__webpack_module_cache__[moduleId] = {
            /******/ // no module.id needed
            /******/ // no module.loaded needed
            /******/ exports: {},
            /******/
        });
        /******/
        /******/ // Execute the module function
        /******/ __webpack_modules__[moduleId](module, module.exports, __webpack_require__);
        /******/
        /******/ // Return the exports of the module
        /******/ return module.exports;
        /******/
    }
    /******/
    /************************************************************************/
    /******/ /* webpack/runtime/make namespace object */
    /******/ (() => {
        /******/ // define __esModule on exports
        /******/ __webpack_require__.r = (exports) => {
            /******/ if (typeof Symbol !== "undefined" && Symbol.toStringTag) {
                /******/ Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
                /******/
            }
            /******/ Object.defineProperty(exports, "__esModule", { value: true });
            /******/
        };
        /******/
    })();
    /******/
    /************************************************************************/
    /******/
    /******/ // startup
    /******/ // Load entry module and return exports
    /******/ // This entry module can't be inlined because the eval devtool is used.
    /******/ var __webpack_exports__ = __webpack_require__("./webpack/system-settings-panel.js");
    /******/
    /******/
})();
