<?php

declare (strict_types=1);
/*
 * This file is part of PHP CS Fixer.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *     Dariusz Rumiński <dariusz.ruminski@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */
namespace PhpCsFixer\Console\Report\ListSetsReport;

use PhpCsFixer\RuleSet\RuleSetDescriptionInterface;
/**
 * @author Dariusz Rumiński <dariusz.ruminski@gmail.com>
 *
 * @readonly
 *
 * @internal
 *
 * @no-named-arguments Parameter names are not covered by the backward compatibility promise.
 */
final class JsonReporter implements \PhpCsFixer\Console\Report\ListSetsReport\ReporterInterface
{
    public function getFormat() : string
    {
        return 'json';
    }
    public function generate(\PhpCsFixer\Console\Report\ListSetsReport\ReportSummary $reportSummary) : string
    {
        $sets = $reportSummary->getSets();
        \usort($sets, static function (RuleSetDescriptionInterface $a, RuleSetDescriptionInterface $b) : int {
            return $a->getName() <=> $b->getName();
        });
        $json = ['sets' => []];
        foreach ($sets as $set) {
            $setName = $set->getName();
            $json['sets'][$setName] = ['description' => $set->getDescription(), 'isRisky' => $set->isRisky(), 'name' => $setName];
        }
        return \json_encode($json, \JSON_PRETTY_PRINT);
    }
}
