
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `projectsendr1945`
--

-- --------------------------------------------------------

--
-- Table structure for table `tbl_actions_log`
--

CREATE TABLE `tbl_actions_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` int(2) NOT NULL,
  `owner_id` int(11) NOT NULL,
  `owner_user` text,
  `affected_file` int(11) DEFAULT NULL,
  `affected_account` int(11) DEFAULT NULL,
  `affected_file_name` text,
  `affected_account_name` text,
  `details` text,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tbl_actions_log`
--

-- --------------------------------------------------------

--
-- Table structure for table `tbl_authentication_codes`
--

CREATE TABLE `tbl_authentication_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token` varchar(32) NOT NULL,
  `code` int(6) NOT NULL,
  `used` int(1) NOT NULL DEFAULT '0',
  `used_timestamp` timestamp NULL DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_categories`
--

CREATE TABLE `tbl_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `parent` int(11) DEFAULT NULL,
  `description` text,
  `created_by` varchar(60) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_categories_relations`
--

CREATE TABLE `tbl_categories_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`),
  KEY `cat_id` (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_cron_log`
--

CREATE TABLE `tbl_cron_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sapi` varchar(32) NOT NULL,
  `results` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_custom_assets`
--

CREATE TABLE `tbl_custom_assets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `title` varchar(500) NOT NULL,
  `content` text,
  `language` varchar(32) NOT NULL,
  `location` varchar(500) NOT NULL,
  `position` varchar(500) NOT NULL,
  `enabled` int(1) NOT NULL DEFAULT '0',
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_custom_downloads`
--

CREATE TABLE `tbl_custom_downloads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link` varchar(255) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  `file_id` int(11) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiry_date` timestamp NULL DEFAULT NULL,
  `visit_count` int(16) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link`),
  UNIQUE KEY `id` (`id`),
  KEY `client_id` (`client_id`),
  KEY `file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_custom_fields`
--

CREATE TABLE `tbl_custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(100) NOT NULL,
  `field_label` varchar(255) NOT NULL,
  `field_type` enum('text','textarea','select','checkbox') NOT NULL DEFAULT 'text',
  `field_options` text,
  `default_value` text,
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `is_visible_to_client` tinyint(1) NOT NULL DEFAULT '1',
  `applies_to` enum('user','client','both') NOT NULL DEFAULT 'client',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `field_name` (`field_name`),
  KEY `applies_to` (`applies_to`),
  KEY `active` (`active`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_custom_field_values`
--

CREATE TABLE `tbl_custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `field_value` text,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `field_user` (`field_id`,`user_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_downloads`
--

CREATE TABLE `tbl_downloads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `file_id` int(11) NOT NULL,
  `remote_ip` varchar(100) DEFAULT NULL,
  `remote_host` text,
  `anonymous` tinyint(1) DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_files`
--

CREATE TABLE `tbl_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `url` text NOT NULL,
  `original_url` text NOT NULL,
  `size` bigint(20) unsigned DEFAULT '0',
  `filename` text NOT NULL,
  `description` text,
  `uploader` varchar(60) NOT NULL,
  `expires` int(1) NOT NULL DEFAULT '0',
  `expiry_date` timestamp NOT NULL DEFAULT '2025-12-31 18:30:00',
  `public_allow` int(1) NOT NULL DEFAULT '0',
  `public_token` varchar(32) DEFAULT NULL,
  `download_limit_enabled` tinyint(1) DEFAULT '0',
  `download_limit_type` varchar(20) DEFAULT 'total',
  `download_limit_count` int(11) DEFAULT '0',
  `encrypted` tinyint(1) DEFAULT '0',
  `encryption_key_encrypted` text,
  `encryption_iv` varchar(64) DEFAULT NULL,
  `encryption_algorithm` varchar(20) DEFAULT 'aes-256-gcm',
  `encryption_file_iv` varchar(64) DEFAULT NULL,
  `folder_id` int(11) DEFAULT NULL,
  `disk_folder_year` int(4) DEFAULT NULL,
  `disk_folder_month` int(4) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `storage_type` enum('local','s3','gcs','azure') NOT NULL DEFAULT 'local',
  `external_path` text,
  `bucket_name` varchar(255) DEFAULT NULL,
  `integration_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `folder_id` (`folder_id`),
  KEY `idx_size` (`size`),
  KEY `integration_id` (`integration_id`),
  KEY `idx_encrypted` (`encrypted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_files_relations`
--

CREATE TABLE `tbl_files_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `folder_id` int(11) DEFAULT NULL,
  `hidden` int(1) NOT NULL,
  `download_count` int(16) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`),
  KEY `client_id` (`client_id`),
  KEY `group_id` (`group_id`),
  KEY `folder_id` (`folder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_folders`
--

CREATE TABLE `tbl_folders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(32) NOT NULL,
  `parent` int(11) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `public` tinyint(1) NOT NULL DEFAULT '0',
  `user_id` int(11) DEFAULT NULL,
  `slug` varchar(100) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_groups`
--

CREATE TABLE `tbl_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `description` text,
  `public` tinyint(1) NOT NULL DEFAULT '0',
  `public_token` varchar(32) DEFAULT NULL,
  `created_by` varchar(32) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_integrations`
--

CREATE TABLE `tbl_integrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `credentials_encrypted` text NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `user_id` int(11) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `fk_integrations_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_logins_failed`
--

CREATE TABLE `tbl_logins_failed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(60) NOT NULL,
  `username` varchar(60) NOT NULL,
  `attempted_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_members`
--

CREATE TABLE `tbl_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `added_by` varchar(32) DEFAULT NULL,
  `client_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_members_requests`
--

CREATE TABLE `tbl_members_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_by` varchar(32) DEFAULT NULL,
  `client_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `denied` int(1) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_notifications`
--

CREATE TABLE `tbl_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `upload_type` int(11) NOT NULL,
  `sent_status` int(2) NOT NULL,
  `times_failed` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_options`
--

CREATE TABLE `tbl_options` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=167 ;

--
-- Dumping data for table `tbl_options`
--

INSERT INTO `tbl_options` VALUES
(1, 'base_uri', '[[softurl]]/'),
(2, 'max_thumbnail_width', '100'),
(3, 'max_thumbnail_height', '100'),
(4, 'thumbnails_folder', '../../assets/img/custom/thumbs/'),
(5, 'thumbnail_default_quality', '90'),
(6, 'max_logo_width', '300'),
(7, 'max_logo_height', '300'),
(8, 'this_install_title', '[[site_name]]'),
(9, 'selected_clients_template', 'default'),
(10, 'logo_thumbnails_folder', '/assets/img/custom/thumbs'),
(11, 'timezone', 'America/New_York'),
(12, 'timeformat', 'd/m/Y'),
(13, 'allowed_file_types', '7z,ace,ai,avi,bin,bmp,bz2,cdr,csv,doc,docm,docx,eps,fla,flv,gif,gz,gzip,htm,html,iso,jpeg,jpg,mp3,mp4,mpg,odt,oog,ppt,pptx,pptm,pps,ppsx,pdf,png,psd,rar,rtf,tar,tif,tiff,tgz,txt,wav,xls,xlsm,xlsx,xz,zip'),
(14, 'logo_filename', ''),
(15, 'admin_email_address', '[[admin_email]]'),
(16, 'clients_can_register', '0'),
(17, 'last_update', '1945'),
(18, 'database_version', '2025100501'),
(19, 'mail_system_use', 'mail'),
(20, 'mail_smtp_host', ''),
(21, 'mail_smtp_port', ''),
(22, 'mail_smtp_user', ''),
(23, 'mail_smtp_pass', ''),
(24, 'mail_from_name', '[[site_name]]'),
(25, 'thumbnails_use_absolute', '0'),
(26, 'mail_copy_user_upload', ''),
(27, 'mail_copy_client_upload', ''),
(28, 'mail_copy_main_user', ''),
(29, 'mail_copy_addresses', ''),
(30, 'version_last_check', '[[date]]'),
(31, 'version_new_found', '0'),
(32, 'version_new_number', ''),
(33, 'version_new_url', ''),
(34, 'version_new_chlog', ''),
(35, 'version_new_security', ''),
(36, 'version_new_features', ''),
(37, 'version_new_important', ''),
(38, 'clients_auto_approve', '0'),
(39, 'clients_auto_group', '0'),
(40, 'clients_can_upload', '1'),
(41, 'clients_can_set_expiration_date', '0'),
(42, 'email_new_file_by_user_customize', '0'),
(43, 'email_new_file_by_client_customize', '0'),
(44, 'email_new_client_by_user_customize', '0'),
(45, 'email_new_client_by_self_customize', '0'),
(46, 'email_new_user_customize', '0'),
(47, 'email_new_file_by_user_text', ''),
(48, 'email_new_file_by_client_text', ''),
(49, 'email_new_client_by_user_text', ''),
(50, 'email_new_client_by_self_text', ''),
(51, 'email_new_user_text', ''),
(52, 'email_header_footer_customize', '0'),
(53, 'email_header_text', ''),
(54, 'email_footer_text', ''),
(55, 'email_pass_reset_customize', '0'),
(56, 'email_pass_reset_text', ''),
(57, 'expired_files_hide', '1'),
(58, 'notifications_max_tries', '2'),
(59, 'notifications_max_days', '15'),
(60, 'file_types_limit_to', 'all'),
(61, 'pass_require_upper', '0'),
(62, 'pass_require_lower', '0'),
(63, 'pass_require_number', '0'),
(64, 'pass_require_special', '0'),
(65, 'mail_smtp_auth', 'none'),
(66, 'use_browser_lang', '0'),
(67, 'clients_can_delete_own_files', '0'),
(68, 'google_client_id', ''),
(69, 'google_client_secret', ''),
(70, 'google_signin_enabled', '0'),
(71, 'recaptcha_enabled', '0'),
(72, 'recaptcha_site_key', ''),
(73, 'recaptcha_secret_key', ''),
(74, 'clients_can_select_group', 'none'),
(75, 'files_descriptions_use_ckeditor', '0'),
(76, 'enable_landing_for_all_files', '0'),
(77, 'footer_custom_enable', '0'),
(78, 'footer_custom_content', ''),
(79, 'email_new_file_by_user_subject_customize', '0'),
(80, 'email_new_file_by_client_subject_customize', '0'),
(81, 'email_new_client_by_user_subject_customize', '0'),
(82, 'email_new_client_by_self_subject_customize', '0'),
(83, 'email_new_user_subject_customize', '0'),
(84, 'email_pass_reset_subject_customize', '0'),
(85, 'email_new_file_by_user_subject', ''),
(86, 'email_new_file_by_client_subject', ''),
(87, 'email_new_client_by_user_subject', ''),
(88, 'email_new_client_by_self_subject', ''),
(89, 'email_new_user_subject', ''),
(90, 'email_pass_reset_subject', ''),
(91, 'privacy_noindex_site', '0'),
(92, 'email_account_approve_subject_customize', '0'),
(93, 'email_account_deny_subject_customize', '0'),
(94, 'email_account_approve_customize', '0'),
(95, 'email_account_deny_customize', '0'),
(96, 'email_account_approve_subject', ''),
(97, 'email_account_deny_subject', ''),
(98, 'email_account_approve_text', ''),
(99, 'email_account_deny_text', ''),
(100, 'email_client_edited_subject_customize', '0'),
(101, 'email_client_edited_customize', '0'),
(102, 'email_client_edited_subject', ''),
(103, 'email_client_edited_text', ''),
(104, 'public_listing_page_enable', '0'),
(105, 'public_listing_logged_only', '0'),
(106, 'public_listing_show_all_files', '0'),
(107, 'public_listing_use_download_link', '0'),
(108, 'svg_show_as_thumbnail', '0'),
(109, 'pagination_results_per_page', '10'),
(110, 'login_ip_whitelist', ''),
(111, 'login_ip_blacklist', ''),
(112, 'cron_enable', '0'),
(113, 'cron_key', '[[cron_key]]'),
(114, 'cron_send_emails', '0'),
(115, 'cron_delete_expired_files', '0'),
(116, 'cron_delete_orphan_files', '0'),
(117, 'notifications_max_emails_at_once', '0'),
(118, 'cron_command_line_only', '1'),
(119, 'cron_email_summary_send', '0'),
(120, 'cron_email_summary_address_to', ''),
(121, 'notifications_send_when_saving_files', '1'),
(122, 'cron_save_log_database', '1'),
(123, 'cron_delete_orphan_files_types', 'not_allowed'),
(124, 'files_default_expire', '0'),
(125, 'files_default_expire_days_after', '30'),
(126, 'privacy_record_downloads_ip_address', 'all'),
(127, 'public_listing_enable_preview', '1'),
(128, 'authentication_require_email_code', '0'),
(129, 'email_2fa_code_subject_customize', '0'),
(130, 'email_2fa_code_subject', ''),
(131, 'email_2fa_code_customize', '0'),
(132, 'email_2fa_code_text', ''),
(133, 'public_listing_home_show_link', '0'),
(134, 'clients_files_list_include_public', '0'),
(135, 'clients_can_upload_to_public_folders', '0'),
(136, 'download_logging_ignore_file_author', '0'),
(137, 'uploads_organize_folders_by_date', '0'),
(138, 'files_default_public', '0'),
(139, 'custom_download_uri', ''),
(140, 'upload_chunk_size', '1'),
(141, 'prevent_updates_check', '0'),
(142, 'captcha_method', NULL),
(143, 'cloudflare_turnstile_site_key', NULL),
(144, 'cloudflare_turnstile_secret_key', NULL),
(145, 'mail_smtp_secure', 'none'),
(146, 'recaptcha_v3_site_key', NULL),
(147, 'recaptcha_v3_secret_key', NULL),
(148, 'recaptcha_v3_score_threshold', '0.5'),
(149, 'remember_me_enabled', '1'),
(150, 'remember_me_duration_days', '30'),
(151, 'remember_me_max_tokens_per_user', '5'),
(152, 'enable_custom_roles', '1'),
(153, 'default_new_user_role', '7'),
(154, 'role_system_version', '1'),
(155, 'permission_system_version', '2'),
(156, 'auto_create_missing_permissions', '1'),
(157, 'users_role_migration_completed', '1'),
(158, 'roles_migration_to_id_completed', '1'),
(159, 'legacy_role_levels_removed', '1'),
(160, 'role_level_columns_removed', '1'),
(161, 'default_upload_storage', 'local'),
(162, 'files_encryption_enabled', 'false'),
(163, 'files_encryption_required', 'false'),
(164, 'files_encryption_max_file_size', '0'),
(165, 'clients_default_disk_quota', '0'),
(166, 'show_upgrade_success_message', 'true');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_password_reset`
--

CREATE TABLE `tbl_password_reset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `token` varchar(32) NOT NULL,
  `used` int(1) DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_permissions`
--

CREATE TABLE `tbl_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_key` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text,
  `category` varchar(100) NOT NULL,
  `is_system_permission` tinyint(1) DEFAULT '1',
  `active` tinyint(1) DEFAULT '1',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permission_key` (`permission_key`),
  KEY `idx_permission_key` (`permission_key`),
  KEY `idx_category` (`category`),
  KEY `idx_active` (`active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `tbl_permissions`
--

INSERT INTO `tbl_permissions` VALUES
(1, 'upload', 'Upload files', 'Allow user to upload new files', 'files', 1, 1, '[[regtime]]'),
(2, 'edit_files', 'Edit own files', 'Allow user to edit their own uploaded files (always granted)', 'files', 1, 1, '[[regtime]]'),
(3, 'edit_others_files', 'Edit others files', 'Allow user to edit files uploaded by other users', 'files', 1, 1, '[[regtime]]'),
(4, 'delete_files', 'Delete own files', 'Allow user to delete their own uploaded files', 'files', 1, 1, '[[regtime]]'),
(5, 'delete_others_files', 'Delete others files', 'Allow user to delete files uploaded by other users', 'files', 1, 1, '[[regtime]]'),
(6, 'set_file_expiration_date', 'Set file expiration', 'Allow user to set expiration dates on files', 'files', 1, 1, '[[regtime]]'),
(7, 'set_file_categories', 'Assign categories', 'Allow user to assign categories to files', 'files', 1, 1, '[[regtime]]'),
(8, 'upload_public', 'Upload public files', 'Allow user to mark uploaded files as public', 'files', 1, 1, '[[regtime]]'),
(9, 'upload_to_public_folders', 'Upload to public folders', 'Allow user to upload files to public folders', 'files', 1, 1, '[[regtime]]'),
(10, 'import_orphans', 'Import orphan files', 'Allow user to import orphan files from upload directory', 'files', 1, 1, '[[regtime]]'),
(11, 'upload_storage_select', 'Select upload storage', 'Allow user to select storage destination during file upload', 'files', 1, 1, '[[regtime]]'),
(12, 'limit_downloads', 'Set download limits', 'Allow user to set download limits on files', 'files', 1, 1, '[[regtime]]'),
(13, 'create_categories', 'Create categories', 'Allow user to create new file categories', 'categories', 1, 1, '[[regtime]]'),
(14, 'edit_categories', 'Edit categories', 'Allow user to edit existing categories', 'categories', 1, 1, '[[regtime]]'),
(15, 'delete_categories', 'Delete categories', 'Allow user to delete categories', 'categories', 1, 1, '[[regtime]]'),
(16, 'create_clients', 'Create clients', 'Allow user to create new client accounts', 'users', 1, 1, '[[regtime]]'),
(17, 'edit_clients', 'Edit clients', 'Allow user to edit client accounts', 'users', 1, 1, '[[regtime]]'),
(18, 'delete_clients', 'Delete clients', 'Allow user to delete client accounts', 'users', 1, 1, '[[regtime]]'),
(19, 'create_users', 'Create system users', 'Allow user to create new system user accounts', 'users', 1, 1, '[[regtime]]'),
(20, 'edit_users', 'Edit system users', 'Allow user to edit system user accounts', 'users', 1, 1, '[[regtime]]'),
(21, 'delete_users', 'Delete system users', 'Allow user to delete system user accounts', 'users', 1, 1, '[[regtime]]'),
(22, 'edit_self_account', 'Edit own account', 'Allow user to edit their own account details', 'users', 1, 1, '[[regtime]]'),
(23, 'approve_account_requests', 'Approve accounts', 'Allow user to approve new account registration requests', 'users', 1, 1, '[[regtime]]'),
(24, 'manage_users', 'Manage system users', 'Allow user to manage system user accounts', 'users', 1, 1, '[[regtime]]'),
(25, 'manage_clients', 'Manage clients', 'Allow user to manage client accounts', 'users', 1, 1, '[[regtime]]'),
(26, 'create_groups', 'Create groups', 'Allow user to create new groups', 'groups', 1, 1, '[[regtime]]'),
(27, 'edit_groups', 'Edit groups', 'Allow user to edit existing groups', 'groups', 1, 1, '[[regtime]]'),
(28, 'delete_groups', 'Delete groups', 'Allow user to delete groups', 'groups', 1, 1, '[[regtime]]'),
(29, 'approve_groups_memberships_requests', 'Approve memberships', 'Allow user to approve group membership requests', 'groups', 1, 1, '[[regtime]]'),
(30, 'manage_groups', 'Manage groups', 'Allow user to manage client groups', 'groups', 1, 1, '[[regtime]]'),
(31, 'edit_settings', 'Edit settings', 'Allow user to modify system settings', 'system', 1, 1, '[[regtime]]'),
(32, 'edit_email_templates', 'Edit email templates', 'Allow user to edit email notification templates', 'system', 1, 1, '[[regtime]]'),
(33, 'change_template', 'Change template', 'Allow user to change the client interface template', 'system', 1, 1, '[[regtime]]'),
(34, 'view_actions_log', 'View activity log', 'Allow user to view system activity log', 'system', 1, 1, '[[regtime]]'),
(35, 'view_statistics', 'View statistics', 'Allow user to view system statistics', 'system', 1, 1, '[[regtime]]'),
(36, 'view_news', 'View news', 'Allow user to view system news and updates', 'system', 1, 1, '[[regtime]]'),
(37, 'view_system_info', 'View system info', 'Allow user to view system information', 'system', 1, 1, '[[regtime]]'),
(38, 'view_dashboard_counters', 'View dashboard counters', 'Allow user to view dashboard statistics counters', 'system', 1, 1, '[[regtime]]'),
(39, 'test_email', 'Test email', 'Allow user to send test emails', 'system', 1, 1, '[[regtime]]'),
(40, 'unblock_ip', 'Unblock IP', 'Allow user to unblock IP addresses', 'system', 1, 1, '[[regtime]]'),
(41, 'manage_updates', 'Manage system updates', 'Allow user to download and install system updates', 'system', 1, 1, '[[regtime]]'),
(42, 'create_assets', 'Create assets', 'Allow user to create custom CSS/JS assets', 'assets', 1, 1, '[[regtime]]'),
(43, 'edit_assets', 'Edit assets', 'Allow user to edit custom CSS/JS assets', 'assets', 1, 1, '[[regtime]]'),
(44, 'delete_assets', 'Delete assets', 'Allow user to delete custom CSS/JS assets', 'assets', 1, 1, '[[regtime]]'),
(46, 'view_storage_analytics', 'View storage analytics', 'Allow user to view storage usage and file analytics', 'dashboard', 1, 1, '[[regtime]]'),
(48, 'view_download_analytics', 'View download analytics', 'Allow user to view download statistics and trends', 'dashboard', 1, 1, '[[regtime]]'),
(52, 'manage_custom_fields', 'Manage Custom Fields', 'Create, edit, and delete custom fields for users and clients', 'Custom Fields', 0, 1, '[[regtime]]'),
(53, 'view_downloads_details', 'View Download Details', 'Access detailed download information and statistics', 'files', 0, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_remember_tokens`
--

CREATE TABLE `tbl_remember_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token_hash` varchar(64) NOT NULL,
  `expires_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_used` timestamp NULL DEFAULT NULL,
  `user_agent` text,
  PRIMARY KEY (`id`),
  KEY `idx_token_hash` (`token_hash`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_roles`
--

CREATE TABLE `tbl_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `is_system_role` tinyint(1) DEFAULT '0',
  `permissions_editable` tinyint(1) DEFAULT '1',
  `active` tinyint(1) DEFAULT '1',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_active` (`active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `tbl_roles`
--

INSERT INTO `tbl_roles` VALUES
(1, 'Client', 'Client users who receive files', 1, 0, 1, '[[regtime]]'),
(2, 'Uploader', 'Users who can upload and manage their own files', 1, 1, 1, '[[regtime]]'),
(3, 'Account Manager', 'Users who can manage clients and files', 1, 1, 1, '[[regtime]]'),
(4, 'System Administrator', 'Full system access and management', 1, 0, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_role_permissions`
--

CREATE TABLE `tbl_role_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_level` int(11) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `permission` varchar(255) NOT NULL,
  `granted` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_permission` (`role_level`,`permission`),
  KEY `idx_role_level` (`role_level`),
  KEY `idx_permission` (`permission`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=153 ;

--
-- Dumping data for table `tbl_role_permissions`
--

INSERT INTO `tbl_role_permissions` VALUES
(1, 9, 4, 'upload', 1),
(2, 9, 4, 'edit_files', 1),
(3, 9, 4, 'edit_others_files', 1),
(4, 9, 4, 'delete_files', 1),
(5, 9, 4, 'delete_others_files', 1),
(6, 9, 4, 'set_file_expiration_date', 1),
(7, 9, 4, 'set_file_categories', 1),
(8, 9, 4, 'upload_public', 1),
(9, 9, 4, 'upload_to_public_folders', 1),
(10, 9, 4, 'import_orphans', 1),
(11, 9, 4, 'upload_storage_select', 1),
(12, 9, 4, 'limit_downloads', 1),
(13, 9, 4, 'create_categories', 1),
(14, 9, 4, 'edit_categories', 1),
(15, 9, 4, 'delete_categories', 1),
(16, 9, 4, 'create_clients', 1),
(17, 9, 4, 'edit_clients', 1),
(18, 9, 4, 'delete_clients', 1),
(19, 9, 4, 'create_users', 1),
(20, 9, 4, 'edit_users', 1),
(21, 9, 4, 'delete_users', 1),
(22, 9, 4, 'edit_self_account', 1),
(23, 9, 4, 'approve_account_requests', 1),
(24, 9, 4, 'manage_users', 1),
(25, 9, 4, 'manage_clients', 1),
(26, 9, 4, 'create_groups', 1),
(27, 9, 4, 'edit_groups', 1),
(28, 9, 4, 'delete_groups', 1),
(29, 9, 4, 'approve_groups_memberships_requests', 1),
(30, 9, 4, 'manage_groups', 1),
(31, 9, 4, 'edit_settings', 1),
(32, 9, 4, 'edit_email_templates', 1),
(33, 9, 4, 'change_template', 1),
(34, 9, 4, 'view_actions_log', 1),
(35, 9, 4, 'view_statistics', 1),
(36, 9, 4, 'view_news', 1),
(37, 9, 4, 'view_system_info', 1),
(38, 9, 4, 'view_dashboard_counters', 1),
(39, 9, 4, 'test_email', 1),
(40, 9, 4, 'unblock_ip', 1),
(41, 9, 4, 'manage_updates', 1),
(42, 9, 4, 'create_assets', 1),
(43, 9, 4, 'edit_assets', 1),
(44, 9, 4, 'delete_assets', 1),
(45, 8, 3, 'upload', 1),
(46, 8, 3, 'edit_files', 1),
(47, 8, 3, 'edit_others_files', 1),
(48, 8, 3, 'delete_files', 1),
(49, 8, 3, 'delete_others_files', 1),
(50, 8, 3, 'set_file_expiration_date', 1),
(51, 8, 3, 'upload_public', 1),
(52, 8, 3, 'import_orphans', 1),
(53, 8, 3, 'create_categories', 1),
(54, 8, 3, 'edit_categories', 1),
(55, 8, 3, 'delete_categories', 1),
(56, 8, 3, 'create_clients', 1),
(57, 8, 3, 'edit_clients', 1),
(58, 8, 3, 'delete_clients', 1),
(59, 8, 3, 'edit_self_account', 1),
(60, 8, 3, 'approve_account_requests', 1),
(61, 8, 3, 'create_groups', 1),
(62, 8, 3, 'edit_groups', 1),
(63, 8, 3, 'delete_groups', 1),
(64, 8, 3, 'approve_groups_memberships_requests', 1),
(65, 8, 3, 'view_actions_log', 1),
(66, 8, 3, 'view_statistics', 1),
(67, 8, 3, 'view_news', 1),
(68, 8, 3, 'unblock_ip', 1),
(69, 7, 2, 'upload', 1),
(70, 7, 2, 'edit_files', 1),
(71, 7, 2, 'delete_files', 1),
(72, 7, 2, 'set_file_expiration_date', 1),
(73, 7, 2, 'upload_public', 1),
(74, 7, 2, 'import_orphans', 1),
(75, 7, 2, 'create_categories', 1),
(76, 7, 2, 'edit_categories', 1),
(77, 7, 2, 'delete_categories', 1),
(78, 7, 2, 'edit_self_account', 1),
(79, 7, 2, 'view_actions_log', 1),
(80, 7, 2, 'view_statistics', 1),
(81, 7, 2, 'view_news', 1),
(82, 0, 1, 'edit_self_account', 1),
(83, 0, 1, 'upload', 1),
(84, 0, 1, 'edit_files', 1),
(87, 0, 4, 'edit_others_files', 1),
(88, 0, 4, 'delete_files', 1),
(89, 0, 4, 'delete_others_files', 1),
(90, 0, 4, 'set_file_expiration_date', 1),
(91, 0, 4, 'set_file_categories', 1),
(92, 0, 4, 'upload_public', 1),
(93, 0, 4, 'upload_to_public_folders', 1),
(94, 0, 4, 'import_orphans', 1),
(95, 0, 4, 'upload_storage_select', 1),
(96, 0, 4, 'limit_downloads', 1),
(97, 0, 4, 'create_categories', 1),
(98, 0, 4, 'edit_categories', 1),
(99, 0, 4, 'delete_categories', 1),
(100, 0, 4, 'create_clients', 1),
(101, 0, 4, 'edit_clients', 1),
(102, 0, 4, 'delete_clients', 1),
(103, 0, 4, 'create_users', 1),
(104, 0, 4, 'edit_users', 1),
(105, 0, 4, 'delete_users', 1),
(107, 0, 4, 'approve_account_requests', 1),
(108, 0, 4, 'manage_users', 1),
(109, 0, 4, 'manage_clients', 1),
(110, 0, 4, 'create_groups', 1),
(111, 0, 4, 'edit_groups', 1),
(112, 0, 4, 'delete_groups', 1),
(113, 0, 4, 'approve_groups_memberships_requests', 1),
(114, 0, 4, 'manage_groups', 1),
(115, 0, 4, 'edit_settings', 1),
(116, 0, 4, 'edit_email_templates', 1),
(117, 0, 4, 'change_template', 1),
(118, 0, 4, 'view_actions_log', 1),
(119, 0, 4, 'view_statistics', 1),
(120, 0, 4, 'view_news', 1),
(121, 0, 4, 'view_system_info', 1),
(122, 0, 4, 'view_dashboard_counters', 1),
(123, 0, 4, 'test_email', 1),
(124, 0, 4, 'unblock_ip', 1),
(125, 0, 4, 'manage_updates', 1),
(126, 0, 4, 'create_assets', 1),
(127, 0, 4, 'edit_assets', 1),
(128, 0, 4, 'delete_assets', 1),
(130, 0, 4, 'view_storage_analytics', 1),
(132, 0, 4, 'view_download_analytics', 1),
(142, 7, NULL, 'upload_storage_select', 1),
(143, 8, NULL, 'upload_storage_select', 1),
(144, 0, NULL, 'manage_custom_fields', 1),
(145, 7, NULL, 'manage_custom_fields', 1),
(146, 8, NULL, 'manage_custom_fields', 1),
(147, 9, NULL, 'manage_custom_fields', 1),
(148, 0, NULL, 'view_downloads_details', 0),
(149, 7, NULL, 'view_downloads_details', 1),
(150, 8, NULL, 'view_downloads_details', 1),
(151, 9, NULL, 'view_downloads_details', 1);

-- --------------------------------------------------------

--
-- Table structure for table `tbl_users`
--

CREATE TABLE `tbl_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(60) NOT NULL,
  `password` varchar(60) NOT NULL,
  `name` text NOT NULL,
  `email` varchar(60) NOT NULL,
  `level` tinyint(1) NOT NULL DEFAULT '0',
  `role_id` int(11) DEFAULT NULL,
  `address` text,
  `phone` varchar(32) DEFAULT NULL,
  `notify` tinyint(1) NOT NULL DEFAULT '0',
  `contact` text,
  `created_by` varchar(60) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `account_requested` tinyint(1) NOT NULL DEFAULT '0',
  `account_denied` tinyint(1) NOT NULL DEFAULT '0',
  `max_file_size` int(20) NOT NULL DEFAULT '0',
  `max_disk_quota` bigint(20) unsigned DEFAULT '0',
  `can_upload_public` int(20) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_role_id` (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tbl_users`
--

INSERT INTO `tbl_users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[real_name]]', '[[admin_email]]', 9, 4, NULL, NULL, 0, NULL, NULL, 1, 0, 0, 0, 0, 0, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_limit_upload_to`
--

CREATE TABLE `tbl_user_limit_upload_to` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_meta`
--

CREATE TABLE `tbl_user_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `value` text,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `tbl_authentication_codes`
--
ALTER TABLE `tbl_authentication_codes`
  ADD CONSTRAINT `tbl_authentication_codes_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_categories`
--
ALTER TABLE `tbl_categories`
  ADD CONSTRAINT `tbl_categories_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `tbl_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `tbl_categories_relations`
--
ALTER TABLE `tbl_categories_relations`
  ADD CONSTRAINT `tbl_categories_relations_ibfk_1` FOREIGN KEY (`file_id`) REFERENCES `tbl_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_categories_relations_ibfk_2` FOREIGN KEY (`cat_id`) REFERENCES `tbl_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_custom_downloads`
--
ALTER TABLE `tbl_custom_downloads`
  ADD CONSTRAINT `tbl_custom_downloads_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `tbl_custom_downloads_ibfk_2` FOREIGN KEY (`file_id`) REFERENCES `tbl_files` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `tbl_custom_field_values`
--
ALTER TABLE `tbl_custom_field_values`
  ADD CONSTRAINT `tbl_custom_field_values_ibfk_1` FOREIGN KEY (`field_id`) REFERENCES `tbl_custom_fields` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `tbl_custom_field_values_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tbl_downloads`
--
ALTER TABLE `tbl_downloads`
  ADD CONSTRAINT `tbl_downloads_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_downloads_ibfk_2` FOREIGN KEY (`file_id`) REFERENCES `tbl_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_files`
--
ALTER TABLE `tbl_files`
  ADD CONSTRAINT `tbl_files_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_files_ibfk_2` FOREIGN KEY (`folder_id`) REFERENCES `tbl_folders` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_files_ibfk_3` FOREIGN KEY (`integration_id`) REFERENCES `tbl_integrations` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `tbl_files_relations`
--
ALTER TABLE `tbl_files_relations`
  ADD CONSTRAINT `tbl_files_relations_ibfk_1` FOREIGN KEY (`file_id`) REFERENCES `tbl_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_files_relations_ibfk_2` FOREIGN KEY (`client_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_files_relations_ibfk_3` FOREIGN KEY (`group_id`) REFERENCES `tbl_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_files_relations_ibfk_4` FOREIGN KEY (`folder_id`) REFERENCES `tbl_folders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `tbl_folders`
--
ALTER TABLE `tbl_folders`
  ADD CONSTRAINT `tbl_folders_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `tbl_folders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_folders_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `tbl_integrations`
--
ALTER TABLE `tbl_integrations`
  ADD CONSTRAINT `fk_integrations_user_id` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `tbl_members`
--
ALTER TABLE `tbl_members`
  ADD CONSTRAINT `tbl_members_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_members_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `tbl_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_members_requests`
--
ALTER TABLE `tbl_members_requests`
  ADD CONSTRAINT `tbl_members_requests_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_members_requests_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `tbl_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_notifications`
--
ALTER TABLE `tbl_notifications`
  ADD CONSTRAINT `tbl_notifications_ibfk_1` FOREIGN KEY (`file_id`) REFERENCES `tbl_files` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_notifications_ibfk_2` FOREIGN KEY (`client_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_password_reset`
--
ALTER TABLE `tbl_password_reset`
  ADD CONSTRAINT `tbl_password_reset_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_remember_tokens`
--
ALTER TABLE `tbl_remember_tokens`
  ADD CONSTRAINT `tbl_remember_tokens_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tbl_users`
--
ALTER TABLE `tbl_users`
  ADD CONSTRAINT `fk_users_role` FOREIGN KEY (`role_id`) REFERENCES `tbl_roles` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `tbl_user_limit_upload_to`
--
ALTER TABLE `tbl_user_limit_upload_to`
  ADD CONSTRAINT `tbl_user_limit_upload_to_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_user_limit_upload_to_ibfk_2` FOREIGN KEY (`client_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_user_meta`
--
ALTER TABLE `tbl_user_meta`
  ADD CONSTRAINT `tbl_user_meta_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
