<?php
/**
 * Show the form to edit an existing client.
 */
require_once 'bootstrap.php';
check_access_enhanced(['manage_clients', 'edit_clients', 'create_clients', 'edit_own_client_profile'], 'any');

$active_nav = 'clients';

// Check if the id parameter is on the URI.
if (!isset($_GET['id'])) {
    exit_with_error_code(403);
}

$client_id = (int)$_GET['id'];
if (!client_exists_id($client_id)) {
    exit_with_error_code(403);
}

// Create the object
$edit_client = new \ProjectSend\Classes\Users($client_id);

$client_arguments = $edit_client->getProperties();

// Get groups where this client is member
$get_groups = new \ProjectSend\Classes\GroupsMemberships;
$get_arguments = [
    'client_id' => $client_id,
];
$found_groups = $get_groups->getGroupsByClient($get_arguments);

// Get current membership requests
$get_arguments['denied'] = 0;
$found_requests = $get_groups->getMembershipRequests($get_arguments);

// Form type
if (!current_role_in(['Client'])) {
    $clients_form_type = 'edit_client';
    $ignore_size = false;
} else {
    $clients_form_type = 'edit_client_self';
    define('EDITING_SELF_ACCOUNT', true);
    $ignore_size = true;
}

// Compare the client editing this account to the on the db.
if (current_role_in(['Client'])) {
    if (isset($client_arguments) && CURRENT_USER_USERNAME != $client_arguments['username']) {
        exit_with_error_code(403);
    }
}

if ($_POST) {
    /**
     * If the user is not an admin, check if the id of the client
     * that's being edited is the same as the current logged in one.
     */
    if (current_role_in(['Client', 'Uploader'])) {
        if ($client_id != CURRENT_USER_ID) {
            exit_with_error_code(403);
        }
    }

    /**
     * Clean the posted form values to be used on the user actions,
     * and again on the form if validation failed.
     * Also, overwrites the values gotten from the database so if
     * validation failed, the new unsaved values are shown to avoid
     * having to type them again.
     */
    $client_arguments = array(
        'id' => $client_id,
        'username' => $_POST['username'],
        'role_id' => \ProjectSend\Classes\Roles::getClientRoleId(), // Always set client role for client editing
        'name' => $_POST['name'],
        'email' => $_POST['email'],
        'address' => (isset($_POST["address"])) ? $_POST['address'] : null,
        'phone' => (isset($_POST["phone"])) ? $_POST['phone'] : null,
        'contact' => (isset($_POST["contact"])) ? $_POST['contact'] : null,
        'notify_upload' => (isset($_POST["notify_upload"])) ? 1 : 0,
        'max_file_size' => $client_arguments['max_file_size'],
        'max_disk_quota' => $client_arguments['max_disk_quota'],
        'can_upload_public' => $client_arguments['can_upload_public'],
        'active' => $client_arguments['active'],
        'type' => 'edit_client',
    );

    if ($ignore_size == false) {
        $client_arguments['max_file_size'] = (isset($_POST["max_file_size"])) ? $_POST["max_file_size"] : null;
        $client_arguments['max_disk_quota'] = (isset($_POST["max_disk_quota"])) ? $_POST["max_disk_quota"] : null;
    }

    if (!current_role_in(['Client'])) {
        $client_arguments['can_upload_public'] = (isset($_POST["can_upload_public"])) ? 1 : 0;
        $client_arguments['active'] = (isset($_POST["active"])) ? 1 : 0;
    }

    /**
     * If the password field, or the verification are not completed,
     * send an empty value to prevent notices.
     */
    $client_arguments['password'] = (isset($_POST['password'])) ? $_POST['password'] : null;

    // Process custom fields
    $custom_field_data = [];
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'custom_field_') === 0) {
            $field_id = str_replace('custom_field_', '', $key);
            $custom_field_data[$field_id] = $value;
        }
    }

    /** Validate the information from the posted form. */
    $edit_client->set($client_arguments);
    $edit_client->setType("existing_client");
    $edit_client->custom_field_data = $custom_field_data;
    $edit_response = $edit_client->edit();

    $edit_groups = (!empty($_POST['groups_request'])) ? $_POST['groups_request'] : array();
    $memberships = new \ProjectSend\Classes\GroupsMemberships;
    $arguments = [
        'client_id' => $client_id,
        'group_ids' => $edit_groups,
        'request_by' => CURRENT_USER_USERNAME,
    ];

    if (current_role_in(['Account Manager', 'System Administrator'])) {
        $memberships->clientEditGroups($arguments);
    } else {
        $memberships->updateMembershipRequests($arguments);
    }

    if ($edit_response['status'] === 'success') {
        if ($client_id == CURRENT_USER_ID) {
            $flash->success(__('Profile edited successfully'));
        } else {
            $flash->success($edit_response['message']);
        }
    } else {
        // Store detailed validation errors in session if available
        if (!empty($edit_response['errors'])) {
            $_SESSION['client_edit_errors'] = $edit_response['errors'];
        } else {
            $flash->error($edit_response['message']);
        }
    }

    ps_redirect(BASE_URI . 'clients-edit.php?id=' . $client_id);
}

$page_title = __('Edit client', 'cftp_admin');
if (isset($client_arguments['username']) && CURRENT_USER_USERNAME == $client_arguments['username']) {
    $page_title = __('My account', 'cftp_admin');
}

$page_id = 'client_form';

include_once ADMIN_VIEWS_DIR . DS . 'header.php';
?>
<div class="row">
    <div class="col-12 col-sm-12 col-lg-6">
        <div class="white-box">
            <div class="white-box-interior">
                <?php
                // Display validation errors from session if available (after failed submission)
                if (isset($_SESSION['client_edit_errors'])) {
                    echo $_SESSION['client_edit_errors'];
                    unset($_SESSION['client_edit_errors']);
                } else {
                    // Show any errors from current object (for backward compatibility)
                    echo $edit_client->getValidationErrors();
                }

                include_once FORMS_DIR . DS . 'clients.php';
                ?>
            </div>
        </div>
    </div>
</div>
<?php
include_once ADMIN_VIEWS_DIR . DS . 'footer.php';
