<?php
namespace Opawg\UserAgentsV2Php;

/* Autogenerated.  Do not edit */
 
class UserAgents {
    public static function find($currentUserAgent)
    {
        $playerFound = null;
        $deviceFound = '';

        //Search for device:
        foreach (self::$devices['entries'] as $device) {
            //Does the HTTP_USER_AGENT match this regexp:
            if (preg_match("#{$device['pattern']}#", $currentUserAgent)) {
                $deviceFound = $device['name'];
                //We found it!
                break 1;
            }
        }
        //Search for current HTTP_USER_AGENT:
        foreach (self::$db as $type => $userAgents) {
            foreach ($userAgents['entries'] as $userAgent) {
                //Does the HTTP_USER_AGENT match this regexp:
                if (preg_match("#{$userAgent['pattern']}#", $currentUserAgent)) {
                    $playerFound = [
                        'app' => $userAgent['name'],
                        'device' => $deviceFound,
                        'os' => '',
                        'bot' => ($type=='bots') ? $userAgent['name'] : 0,
                    ];
                    //We found it!
                    break 2;
                }
            }
        }
        return $playerFound;
    }

    static public $devices = array (
  'comments' => 
  array (
    0 => 'If the match entry is not a bot, you can also match the User-Agent header against this file to identity device and category.',
  ),
  '$schema' => 'https://raw.githubusercontent.com/opawg/user-agents-v2/master/schemas/patterns.schema.json',
  'entries' => 
  array (
    0 => 
    array (
      'name' => 'Apple HomePod',
      'pattern' => 'HomePod|^AirPodcasts/\\d',
      'category' => 'smart_speaker',
      'examples' => 
      array (
        0 => 'AirPodcasts/4022.700.8 CFNetwork/1410.0.3 Darwin/22.6.0',
      ),
    ),
    1 => 
    array (
      'name' => 'Apple iPad',
      'pattern' => 'ipad|iPad|IPAD',
      'category' => 'mobile',
    ),
    2 => 
    array (
      'name' => 'Apple TV',
      'pattern' => 'Apple TV|AppleTV|apple;apple_tv',
      'category' => 'smart_tv',
      'examples' => 
      array (
        0 => 'apple;apple_tv;33ddb95064d1479ab37179579af23b77;;tpapi;3.200.405',
        1 => 'AppleCoreMedia/1.0.0.20K71 (Apple TV; U; CPU OS 16_1 like Mac OS X; en_au)',
      ),
    ),
    3 => 
    array (
      'name' => 'Apple iPhone',
      'pattern' => 'iphone|iOS|iPhone|CFNetwork| ios |phone;ios',
      'category' => 'mobile',
      'examples' => 
      array (
        0 => 'Fountain/0.5.3 ios https://www.fountain.fm',
        1 => 'Anytime/1.1 b64 (phone;ios Version 15.6.1 (Build 19G82)) https://github.com/amugofjava/anytime_podcast_player',
      ),
    ),
    4 => 
    array (
      'name' => 'Apple Watch',
      'pattern' => 'watch|Watch OS',
      'category' => 'watch',
    ),
    5 => 
    array (
      'name' => 'Apple iPod',
      'pattern' => 'iPod|IPOD',
      'category' => 'mobile',
    ),
    6 => 
    array (
      'name' => 'Apple Computer',
      'pattern' => 'OS X|OSX|Macintosh|Macbook|macosx|macOS',
      'category' => 'computer',
      'examples' => 
      array (
        0 => 'net/http-easy (macosx; racket[CS] 8.15.0.7; 0.8.2)',
        1 => 'Mimir-macOS/1.8.1',
      ),
    ),
    7 => 
    array (
      'name' => 'Google Home',
      'pattern' => 'GoogleChirp|Google-Speech-Actions|CrKey.*DeviceType/SmartSpeaker',
      'category' => 'smart_speaker',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (X11; Linux aarch64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.225 Safari/537.36 CrKey/1.56.500000 DeviceType/SmartSpeaker',
      ),
    ),
    8 => 
    array (
      'name' => 'Google Chromebook',
      'pattern' => 'Chromebook|CrOS',
      'category' => 'computer',
    ),
    9 => 
    array (
      'name' => 'Android Tablet',
      'pattern' => '[a|A]ndroid.*[t|T]ablet|[t|T]ablet.*[a|A]ndroid|SM-T| GT-|^ZTE;Xview',
      'category' => 'mobile',
      'examples' => 
      array (
        0 => 'ZTE;Xview;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
      ),
    ),
    10 => 
    array (
      'name' => 'Smart Car',
      'pattern' => '^Spotify/.* \\((Rivian|BYD AUTO|Volvo|gminfo\\d+|G6|G9)\\)',
      'category' => 'auto',
      'examples' => 
      array (
        0 => 'Spotify/4.4.1.0 Rivian/30 (Rivian)',
        1 => 'Spotify/4.3.2.0 BYD AUTO/29 (BYD AUTO)',
        2 => 'Spotify/4.4.1.0 Volvo/32 (Volvo)',
        3 => 'Spotify/4.0.8.0 gminfo36/23 (gminfo36)',
        4 => 'Spotify/4.0.8.0 gminfo3/23 (gminfo3)',
        5 => 'Spotify/4.4.0.0 G6/29 (G6)',
        6 => 'Spotify/4.4.0.0 G9/29 (G9)',
      ),
    ),
    11 => 
    array (
      'name' => 'Other Smart TV',
      'pattern' => 'SmartTV|[Rr]oku|CrKey|AFTT Build|AFTM Build|BRAVIA 4K|Opera TV|SmartTv|TSBNetTV|SMART-TV|SMART_TV|TV Safari|WebTV|InettvBrowser|GoogleTV|HbbTV|smart-tv|TVStick|olleh tv|^sony_tv;ps5;|Microsoft Xbox|^microsoft;xbox_|^Google;Chromecast|^TCL;|^Xiaomi;(MIBOX|MiTV-)|^samsung;(un|qn|ue|uj|ua|ls|qe|qa|lh|gq|gu)\\d|^hisense;(c235x|c205x)|^skyworth;(NoblexTV|SWTV)|^Sony;BRAVIA|^tcl;(c1\\d{2}x|7140x)|^onn\\.;8821x|^Funai;PHILIPS4KTV|^Sagemcom;(VSB|DIW)|^TPV;[A-Z0-9]+AndroidTV;|^(CVT_NULL|MediaTek);SMARTTV;|^NVIDIA;SHIELDAndroidTV|UHDAndroidTV;|^westinghouse;7808x;|^ZTE;B820C|Sky, (ES|EM)|^Cinemo/\\d| Cinemo/\\d|^Amazon;(AFTSSS|AFTMM|AFTSS|AFTKA|AFTT|AFTDCT31|AFTKM|AFTKRT|AFTHA004|AFTEAMR311);|^nowtv;|^SEIRobotics;yes|^Changhong;AIPONT|^Arcadyan;Bouygtel|^Amlogic;ONVO|^Philips;TPM|^MediaTek;39LHA120TP',
      'category' => 'smart_tv',
      'comments' => 'Must be before Android Phones',
      'examples' => 
      array (
        0 => 'CVT_NULL;SMARTTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.127.32',
        1 => 'Funai;PHILIPS4KTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        2 => 'Google;ChromecastHD;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        3 => 'hisense;c205x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        4 => 'hisense;c235x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        5 => 'Hisense;HiSmartTVA4;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        6 => 'MediaTek;SMARTTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.127.32',
        7 => 'Microsoft Xbox',
        8 => 'microsoft;xbox_series_x;1fc2d01aa9074dde950e8d3dc0eb1729;;tpapi;3.206.319',
        9 => 'NVIDIA;SHIELDAndroidTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.202.356',
        10 => 'onn.;8821x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        11 => 'roku;3930mx;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        12 => 'Sagemcom;VSB3940_TPL;4501664231eb4355ab482f1ca12dc38a;;tpapi;3.199.315',
        13 => 'samsung;qn55q60rafxza;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        14 => 'samsung;ue50tu7020wxxn;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        15 => 'samsung;uj5500;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.167.55',
        16 => 'samsung;un43mu6100;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        17 => 'samsung;un50ru7100fxzc;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        18 => 'samsung;un50tu7000g;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        19 => 'skyworth;NoblexTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        20 => 'sony_tv;ps5;9b18101888dd42948afd0b8792122bec;;tpapi;3.200.405',
        21 => 'Sony;BRAVIA4KUR3;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        22 => 'Sony;BRAVIA4KVH2;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        23 => 'tcl;7140x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        24 => 'tcl;c102x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        25 => 'tcl;c105x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        26 => 'tcl;c112x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        27 => 'TCL;UnionTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        28 => 'TPV;20202021UHDAndroidTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        29 => 'TPV;202122PhilipsUHDAndroidTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.202.356',
        30 => 'westinghouse;7808x;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.203.233',
        31 => 'Xiaomi;MIBOX4;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        32 => 'Xiaomi;MiTV-AESP0;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        33 => 'Xiaomi;MiTV-MOOQ0;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        34 => 'ZTE;B820C-A15;756a522d9f1648b89e76e80be654456a;;tpapi;3.202.356',
        35 => 'GW-Device/1.0.0 (Sky, ES140, )',
        36 => 'GW-Device/1.0.0 (Sky, ES240, )',
        37 => 'MR-Device/1.0.0 (Sky, EM150, )',
        38 => 'Cinemo/2023.w35.004.p005100.9fbde87f',
        39 => 'Cinemo/2021.w49.039.p001025.bebbed45',
        40 => 'gcc_linux_MIB3Premium_esolutions_CLU35/1.0 Cinemo/2020.27.9.0',
        41 => 'gcc_linux_wayland_aarch64_pcc_mib3_eu/1.0 Cinemo/1.252.7.100516',
        42 => 'Amazon;AFTSSS;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        43 => 'Amazon;AFTMM;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        44 => 'samsung;ua65tu7000uxzn;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        45 => 'samsung;ls32am500nexxy;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        46 => 'nowtv;3801uk;4916bf2fd1c54ff2bace038314d21f39;;tpapi;3.200.454',
        47 => 'samsung;qe49q64ralxxn;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        48 => 'samsung;qa65q75rawxxy;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        49 => 'Amazon;AFTSS;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        50 => 'Amazon;AFTKA;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        51 => 'Amazon;AFTT;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        52 => 'SEIRobotics;yes;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        53 => 'Amazon;AFTDCT31;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        54 => 'Changhong;AIPONT;756a522d9f1648b89e76e80be654456a;;tpapi;3.206.326',
        55 => 'Amazon;AFTKM;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        56 => 'Amazon;AFTKRT;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        57 => 'Arcadyan;Bouygtel4K;756a522d9f1648b89e76e80be654456a;;tpapi;3.202.356',
        58 => 'Arcadyan;BouygtelTV;756a522d9f1648b89e76e80be654456a;;tpapi;3.122.67',
        59 => 'Sagemcom;DIW377_TPL;88b3d7de4766486991f76b231c9fb782;;tpapi;3.200.405',
        60 => 'Amazon;AFTHA004;756a522d9f1648b89e76e80be654456a;;tpapi;3.205.189',
        61 => 'Google;D6TVStick;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.405',
        62 => 'skyworth;SWTV-20AE;756a522d9f1648b89e76e80be654456a;;tpapi;3.199.315',
        63 => 'samsung;lh32betblggxzd;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        64 => 'Amazon;AFTEAMR311;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
        65 => 'Amlogic;ONVO_42OV6000F;756a522d9f1648b89e76e80be654456a;;tpapi;3.127.32',
        66 => 'Philips;TPM191E;756a522d9f1648b89e76e80be654456a;;tpapi;3.122.67',
        67 => 'MediaTek;39LHA120TP;756a522d9f1648b89e76e80be654456a;;tpapi;3.127.32',
        68 => 'samsung;gq55q60tguxzg;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
        69 => 'samsung;gu50tu7079uxzg;568a50c7e7f64fe3b44a3316ef5590fd;;tpapi;3.194.71',
      ),
    ),
    12 => 
    array (
      'name' => 'Android Phone',
      'pattern' => 'ServeStream|Android|android|HTC|ExoPlayer|^AntennaPod/|^GSA/.*\\.arm(64)?$|^sp-agent|^PRDownloader$|^(Turtlecast|TURTLECAST)/|\\((SM-A15|SM-A55|moto g|RMO-NX3)',
      'category' => 'mobile',
      'comments' => 'Must be after CrKey and Android Tablet',
      'examples' => 
      array (
        0 => 'GSA/13.39.12.26.arm64',
        1 => 'GSA/13.39.12.26.arm',
        2 => 'sp-agent',
        3 => 'FileDownloader (Android)',
        4 => 'PRDownloader',
        5 => 'TURTLECAST/0.5.1',
        6 => 'Camino App/5.5.3 (SM-A155M; null; es_US)',
        7 => 'Camino App/5.5.3 (SM-A556E; null; es_US)',
        8 => 'Camino App/5.5.3 (moto g84 5G; null; es_US)',
        9 => 'Camino App/5.5.3 (RMO-NX3; null; es_MX)',
      ),
    ),
    13 => 
    array (
      'name' => 'Windows Computer',
      'pattern' => 'Windows|windows|WMPlayer|Winamp|Win32|Win64|NSPlayer|MediaMonkey|NSPlayer|PC',
      'category' => 'computer',
    ),
    14 => 
    array (
      'name' => 'Amazon Smart Speaker',
      'pattern' => 'Alexa|^Echo/|^Amazon;Echo',
      'category' => 'smart_speaker',
      'examples' => 
      array (
        0 => 'Amazon;Echo_Pop;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
        1 => 'Amazon;Echo_Dot;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
        2 => 'Amazon;Echo_Dot_with_clock;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
        3 => 'Amazon;Echo_Show_5;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
        4 => 'Amazon;Echo;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
      ),
    ),
    15 => 
    array (
      'name' => 'Other Smart Speaker',
      'pattern' => 'sonos|Sonos|^Bose/|^VictorReader|^Bose;Bose_(Home_Speaker|Soundbar|Portable_Home|Smart_Speaker)|^HEOS;DENON|^Denon;DENON-(DWHS|DWMINI)|^Storybutton/|^Bluesound;|^Yamaha;(WX-|YAS_|ATS_|SR-)|^Xiaomi;07G|^(BangAndOlufsen|Bang_And_Olufsen);beo_|^ArgonAudio;SOLO;|^Samsung;HW-(Q9|Q8|Q7|LS60D|S6|S8)|^LenbrookIndustries;NADAmplifier|^Marshall;Uxbridge|^Edifier;MS50A|^Wiim;Pro;|^Naim_Audio;Mu-so|^Audio_Pro;C10MKII|^Devialet;Mania|^Bowers___Wilkins;Zeppelin|^JBL;Charge_5',
      'category' => 'smart_speaker',
      'examples' => 
      array (
        0 => 'Bluesound;N110;3d1292a4f7bc4cbc853faa331d07348a;;tpapi;3.194.61',
        1 => 'Bluesound;N125;3d1292a4f7bc4cbc853faa331d07348a;;tpapi;3.194.61',
        2 => 'Bluesound;N130;3d1292a4f7bc4cbc853faa331d07348a;;tpapi;3.194.61',
        3 => 'Bluesound;N225v2;3d1292a4f7bc4cbc853faa331d07348a;;tpapi;3.194.61',
        4 => 'Bluesound;N330;3d1292a4f7bc4cbc853faa331d07348a;;tpapi;3.194.61',
        5 => 'Bluesound;P125;3d1292a4f7bc4cbc853faa331d07348a;;tpapi;3.194.61',
        6 => 'Bose;Bose_Home_Speaker_500;1d2cf25b1643474983fae381b00cea3c;;tpapi;3.198.103',
        7 => 'Bose;Bose_Home_Speaker_500',
        8 => 'Bose;Bose_Portable_Home_Speaker;1d2cf25b1643474983fae381b00cea3c;;tpapi;3.198.103',
        9 => 'Bose;Bose_Smart_Speaker_500;1d2cf25b1643474983fae381b00cea3c;;tpapi;3.198.103',
        10 => 'Bose;Bose_Soundbar_700;1d2cf25b1643474983fae381b00cea3c;;tpapi;3.198.103',
        11 => 'Denon;DENON-DWHS_60-150;8f2c0cd9c29f44b39c868f9c7055662c;;tpapi;3.202.330',
        12 => 'HEOS;DENON-DWA_40-200;3c043256d0a14590ab901fdc062e55c7;;tpapi;3.202.330',
        13 => 'Storybutton/1.0',
        14 => 'Yamaha;WX-021;59c7bf046992472ab0689f5fc7fa08e2;1810    ;tpapi;3.201.417',
        15 => 'Xiaomi;07G;54374385375a485fbf9f36689bab8e3a;;tpapi;3.199.375',
        16 => 'BangAndOlufsen;beo_ca16;a2a9ac576f954a84a68513f0928306c7;2.6.56516.0xcc9884b;tpapi;3.194.67',
        17 => 'Bang_And_Olufsen;beo_ez3;a2a9ac576f954a84a68513f0928306c7;2.6.56381.0xf6d7b81;tpapi;3.194.67',
        18 => 'ArgonAudio;SOLO;1d6fc5048b7148989f7d11b41bc959de;;tpapi;3.194.71',
        19 => 'Samsung;HW-Q930C_M;f92d2110c0e3483c82534460ac6b08bf;;tpapi;3.200.454',
        20 => 'LenbrookIndustries;NADAmplifierC338;8e2d49fb22084d0d8bf841c58a23948a;;tpapi;3.194.71',
        21 => 'Yamaha;YAS_209;59c7bf046992472ab0689f5fc7fa08e2;;tpapi;3.198.85',
        22 => 'Marshall;Uxbridge;a56a9ca4c3224149844c062bbebf64a4;;tpapi;3.171.19',
        23 => 'Edifier;MS50A;661cc6a65bf64d34848be578c41514ec;;tpapi;3.199.375',
        24 => 'Samsung;HW-Q990C;f92d2110c0e3483c82534460ac6b08bf;;tpapi;3.200.454',
        25 => 'Samsung;HW-LS60D;f92d2110c0e3483c82534460ac6b08bf;7;tpapi;3.202.330',
        26 => 'Wiim;Pro;c6c01f28b0e842a48f4e7d8f17c2bc8b;;tpapi;3.205.187',
        27 => 'Denon;DENON-DWMINI_40-RCDN10;8f2c0cd9c29f44b39c868f9c7055662c;;tpapi;3.205.187',
        28 => 'Yamaha;ATS_2090;59c7bf046992472ab0689f5fc7fa08e2;;tpapi;3.198.85',
        29 => 'Naim_Audio;Mu-so;c1391bf229944da19cfe28f31e1447e3;4003002.6482.1269.0x39709a;tpapi;3.199.315',
        30 => 'Audio_Pro;C10MKII;5a9bb92bc7e640b1a7d4a79bb0726883;;tpapi;3.199.375',
        31 => 'Samsung;HW-Q990D;f92d2110c0e3483c82534460ac6b08bf;7;tpapi;3.202.330',
        32 => 'Samsung;HW-Q700B;f92d2110c0e3483c82534460ac6b08bf;;tpapi;3.194.61',
        33 => 'Samsung;HW-S61B;f92d2110c0e3483c82534460ac6b08bf;;tpapi;3.194.61',
        34 => 'Devialet;Mania;5aa92cc276d144ad97a77938e86c7ef1;0.0.0.0x9947e26;tpapi;3.200.405',
        35 => 'Samsung;HW-Q800B;f92d2110c0e3483c82534460ac6b08bf;;tpapi;3.194.61',
        36 => 'Bowers___Wilkins;Zeppelin;5342ad44959046b9aa19c537108abed9;1.07.9.1;tpapi;3.194.67',
        37 => 'Samsung;HW-S800B;f92d2110c0e3483c82534460ac6b08bf;;tpapi;3.194.61',
        38 => 'Samsung;HW-S60B;f92d2110c0e3483c82534460ac6b08bf;;tpapi;3.194.61',
        39 => 'Yamaha;SR-X50A;59c7bf046992472ab0689f5fc7fa08e2;;tpapi;3.194.71',
        40 => 'JBL;Charge_5_Wi-Fi;ae8cc5068e6443f3b90da43a356e7578;;tpapi;3.194.61',
      ),
    ),
    16 => 
    array (
      'name' => 'Other Computer',
      'pattern' => 'Lavf/|desktop|Linux|linux|VLC|^okhttp/|CastBox/|X11; (OpenBSD|NetBSD)',
      'category' => 'computer',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (X11; OpenBSD i386) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.125 Safari/537.36',
        1 => 'Mozilla/5.0 (X11; NetBSD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.116 Safari/537.36',
      ),
    ),
    17 => 
    array (
      'name' => 'Other Tablet',
      'pattern' => 'tablet|Tablet',
      'category' => 'mobile',
    ),
    18 => 
    array (
      'name' => 'Other Watch',
      'pattern' => 'watch|Watch|^Garmin ',
      'category' => 'watch',
    ),
    19 => 
    array (
      'name' => 'Other Mobile Device',
      'pattern' => 'Player FM$|^Podkicker/|spotify_unknown|^Castro|^Swoot Agent| KAIOS/|^Zune/|^PodcastGuru |^Pocket Casts$|^AmazonMusic$|RTL\\+',
      'category' => 'mobile',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Mobile; Nokia_8110_4G; rv:48.0) Gecko/48.0 Firefox/48.0 KAIOS/2.5.1 PodKast',
        1 => 'Zune/4.8',
        2 => 'PodcastGuru 2.0.2-beta3',
        3 => 'Pocket Casts',
        4 => 'AmazonMusic',
        5 => 'RTL+',
      ),
    ),
  ),
);
    static public $db = array(
    'bots' => 
array (
  'comments' => 
  array (
    0 => 'Look for User-Agent matches in this file order: \'bots\', \'apps\', \'libraries\', \'browsers\', and return the first entry matched, processing each entry in order in which they appear in the file.',
  ),
  '$schema' => 'https://raw.githubusercontent.com/opawg/user-agents-v2/master/schemas/patterns.schema.json',
  'entries' => 
  array (
    0 => 
    array (
      'name' => 'AAABot - unknown bot',
      'pattern' => 'AAABot',
      'examples' => 
      array (
        0 => 'AAABot',
      ),
    ),
    1 => 
    array (
      'name' => 'Adswizz',
      'pattern' => '^AIS VirtualListener',
      'urls' => 
      array (
        0 => 'https://www.adswizz.com/publishers/insertion-suite/',
      ),
      'examples' => 
      array (
        0 => 'AIS VirtualListener',
      ),
    ),
    2 => 
    array (
      'name' => 'ma Podcast (agma) Bot',
      'pattern' => '^agma/',
      'urls' => 
      array (
        0 => 'https://www.agma-mmc.de/media-analyse/ma-podcast',
      ),
      'examples' => 
      array (
        0 => 'agma/1.0',
      ),
    ),
    3 => 
    array (
      'name' => 'AhrefsBot',
      'pattern' => 'AhrefsBot/',
      'urls' => 
      array (
        0 => 'http://ahrefs.com/robot/',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; AhrefsBot/7.0; http://ahrefs.com/robot/)',
        1 => 'Mozilla/5.0 (compatible; AhrefsBot/6.1; +http://ahrefs.com/robot/)',
      ),
    ),
    4 => 
    array (
      'name' => 'AirableBot',
      'pattern' => 'AirableBot-Podcast/',
      'description' => 'An aggregator of internet radio and podcasts, for connected devices.',
      'urls' => 
      array (
        0 => 'https://www.airablenow.com',
      ),
      'examples' => 
      array (
        0 => 'AirableBot-Podcast/1.0 (+https//www.airablenow.com)',
        1 => 'AirableBot-Podcast/1.0 ( https//www.airablenow.com)',
      ),
    ),
    5 => 
    array (
      'name' => 'Alexa Flash Briefing cache',
      'pattern' => '^AmazonNewsContentService',
      'description' => 'A service which downloads, caches and normalises audio for the Flash Briefing service on Alexa-enabled devices',
      'svg' => 'amazon.svg',
      'urls' => 
      array (
        0 => 'https://developer.amazon.com/docs/flashbriefing/flash-briefing-skill-api-feed-reference.html#performance-requirements',
      ),
      'comments' => 'Stats are available within the Alexa skills dashboard.',
    ),
    6 => 
    array (
      'name' => 'AlignaBot',
      'pattern' => '^Alignabot',
      'examples' => 
      array (
        0 => 'Alignabot 1.0 (https://www.alignable.com/)',
      ),
    ),
    7 => 
    array (
      'name' => 'All Ears',
      'pattern' => '^AllEars/',
      'examples' => 
      array (
        0 => 'AllEars/1.0; (+www.allears.ai)',
      ),
      'urls' => 
      array (
        0 => 'https://allears.ai',
      ),
    ),
    8 => 
    array (
      'name' => 'Amazon Music Podcasts Bot',
      'pattern' => '^Amazon Music Podcast',
      'description' => 'A music and podcasts streaming app',
      'svg' => 'amazon.svg',
      'comments' => 'Backend ingestion service',
    ),
    9 => 
    array (
      'name' => 'Anchor Importer',
      'pattern' => 'AnchorImport',
      'description' => 'Anchor\'s tool for importing podcasts',
      'comments' => 'This useragent is used during a user importing a podcast to the Anchor platform',
      'examples' => 
      array (
        0 => 'AnchorImport/1.0',
      ),
    ),
    10 => 
    array (
      'name' => 'Apple Notes share extension',
      'pattern' => '^com.apple.(mobilenotes.SharingExtension|Notes.SharingExtension)/',
      'examples' => 
      array (
        0 => 'com.apple.mobilenotes.SharingExtension/2511 CFNetwork/1494.0.7 Darwin/23.4.0',
        1 => 'com.apple.Notes.SharingExtension/2812 CFNetwork/1494.0.7 Darwin/23.4.0',
      ),
    ),
    11 => 
    array (
      'name' => 'Apple Podcasts (Watch)',
      'pattern' => '^atc/|\\(null\\) watchOS/',
      'comments' => 'Verified (via stamping the audio URL with the RSS useragent) as being sourced from Apple Podcasts; and accordingly this is marked as a bot since these downloads are duplicated with the phone.',
      'examples' => 
      array (
        0 => 'atc/1.0',
        1 => 'atc/1.0 watchOS/6.2 model/Watch3,3 hwp/t8004 build/17T529 (6; dt:155)',
        2 => 'atc/1.0 watchOS/6.2.8 model/Watch2,3 hwp/t8002 build/17U63 (6; dt:133)',
        3 => 'atc/1.0 watchOS/6.2.8 model/Watch3,3 hwp/t8004 build/17U63 (6; dt:155)',
        4 => 'atc/1.0 watchOS/6.2.8 model/Watch4,2 hwp/t8006 build/17U63 (6; dt:191)',
        5 => 'atc/1.0 watchOS/7.0.2 model/Watch5,10 hwp/t8006 build/18R402 (6; dt:233)',
        6 => 'atc/1.0 watchOS/7.0.2 model/Watch5,11 hwp/t8006 build/18R402 (6; dt:234)',
        7 => 'atc/1.0 watchOS/7.1 model/Watch4,2 hwp/t8006 build/18R590 (6; dt:191)',
        8 => 'atc/1.0 watchOS/7.1 model/Watch4,3 hwp/t8006 build/18R590 (6; dt:192)',
        9 => 'atc/1.0 watchOS/7.1 model/Watch4,4 hwp/t8006 build/18R590 (6; dt:193)',
        10 => 'atc/1.0 watchOS/7.1 model/Watch5,1 hwp/t8006 build/18R590 (6; dt:201)',
        11 => 'atc/1.0 watchOS/7.1 model/Watch5,3 hwp/t8006 build/18R590 (6; dt:202)',
        12 => 'atc/1.0 watchOS/7.1 model/Watch5,4 hwp/t8006 build/18R590 (6; dt:202)',
        13 => '(null)/(null) watchOS/5.0.1 model/Watch3,3 hwp/t8004 build/16R381 (6; dt:155)',
      ),
    ),
    12 => 
    array (
      'name' => 'Apple Podcasts automated checks',
      'pattern' => '(iTMS|itunesstored|itms)',
    ),
    13 => 
    array (
      'name' => 'Applebot',
      'pattern' => '^Applebot/',
      'description' => 'Applebot is the web crawler for Apple. Products like Siri and Spotlight Suggestions use Applebot.',
      'urls' => 
      array (
        0 => 'http://www.apple.com/go/applebot',
      ),
    ),
    14 => 
    array (
      'name' => 'Archive.org',
      'pattern' => 'archive\\.org_bot',
      'description' => 'The Internet Archive is a nonprofit digital library that preserves web data and makes it available for research purposes through the Wayback Machine.',
      'urls' => 
      array (
        0 => 'https://archive.org/details/archive.org_bot',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; archive.org_bot http://archive.org/details/archive.org_bot)',
      ),
    ),
    15 => 
    array (
      'name' => 'atheerfm',
      'pattern' => '^atheerfm/',
      'examples' => 
      array (
        0 => 'atheerfm/1 CFNetwork/758.3.15 Darwin/15.3.0',
      ),
    ),
    16 => 
    array (
      'name' => 'Audioboom bot',
      'pattern' => '^audioBoomBot/\\d',
      'examples' => 
      array (
        0 => 'audioBoomBot/1.0; (+http://audioboom.com)',
      ),
    ),
    17 => 
    array (
      'name' => 'AudioFetcher',
      'pattern' => 'AudioFetcher/\\d.*\\+http',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; AudioFetcher/1.0; +https://example.invalid)',
      ),
    ),
    18 => 
    array (
      'name' => 'Audiomack',
      'pattern' => '^Audiomack Podcast Processor/',
      'examples' => 
      array (
        0 => 'Audiomack Podcast Processor/1.0 (https://audiomack.com/)',
      ),
    ),
    19 => 
    array (
      'name' => 'AudioWave feed parser',
      'pattern' => '^AudioWaveBot/1\\.0',
      'urls' => 
      array (
        0 => 'https://audiowave.io',
      ),
      'examples' => 
      array (
        0 => 'AudioWaveBot/1.0',
      ),
    ),
    20 => 
    array (
      'name' => 'AutoHotkey',
      'pattern' => '^AutoHotkey',
      'urls' => 
      array (
        0 => 'https://www.autohotkey.com/',
      ),
      'examples' => 
      array (
        0 => 'AutoHotkey',
      ),
    ),
    21 => 
    array (
      'name' => 'AwarioSmartBot',
      'pattern' => '^AwarioSmartBot/',
      'examples' => 
      array (
        0 => 'AwarioSmartBot/1.0 (+https://awario.com/bots.html; bots@awario.com)',
      ),
    ),
    22 => 
    array (
      'name' => 'Babbar',
      'pattern' => 'Barkrowler/',
      'urls' => 
      array (
        0 => 'https://beta.babbar.tech/crawler',
      ),
    ),
    23 => 
    array (
      'name' => 'Baidu',
      'pattern' => '\\(ce\\.baidu\\.com',
      'examples' => 
      array (
        0 => 'Baidu-YunGuanCe-SLABot(ce.baidu.com)',
      ),
    ),
    24 => 
    array (
      'name' => 'bbot',
      'pattern' => '^bbot/',
      'examples' => 
      array (
        0 => 'bbot/0.1',
      ),
    ),
    25 => 
    array (
      'name' => 'Beacon Podcast Sync',
      'pattern' => '^Beacon/\\d',
      'examples' => 
      array (
        0 => 'Beacon/1.0 Podcast Sync +https://getbeacons.com/',
      ),
      'urls' => 
      array (
        0 => 'https://getbeacons.com/',
      ),
    ),
    26 => 
    array (
      'name' => 'British Library',
      'pattern' => '^bl\\.uk_ldfc_bot',
      'description' => 'British Library\'s legal deposit web crawler',
      'urls' => 
      array (
        0 => 'http://www.bl.uk/aboutus/legaldeposit/websites/websites/faqswebmaster/index.html',
      ),
      'examples' => 
      array (
        0 => 'bl.uk_ldfc_bot/3.4.0-20200518 ( http://www.bl.uk/aboutus/legaldeposit/websites/websites/faqswebmaster/index.html)',
      ),
    ),
    27 => 
    array (
      'name' => 'Blubrry Migration Service',
      'pattern' => '^Blubrry Migration Service',
      'examples' => 
      array (
        0 => 'Blubrry Migration Service',
      ),
    ),
    28 => 
    array (
      'name' => 'Blubrry Crawler',
      'pattern' => '^Blubrry (Podcasting|PowerPress)/\\d',
      'examples' => 
      array (
        0 => 'Blubrry Podcasting/1.0',
        1 => 'Blubrry PowerPress/11.9.19',
      ),
    ),
    29 => 
    array (
      'name' => 'BNE Crawler',
      'pattern' => 'bne\\.es_bot; https://www\\.bne\\.es',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; bne.es_bot; https://www.bne.es/es/colecciones/archivo-web-espanola/aviso-webmasters) Firefox/129.0.1',
      ),
    ),
    30 => 
    array (
      'name' => 'Buck Media Monitoring',
      'pattern' => '^Buck/\\d',
      'examples' => 
      array (
        0 => 'Buck/2.4.2; (+https://app.hypefactors.com/media-monitoring/about.html)',
      ),
      'urls' => 
      array (
        0 => 'https://app.hypefactors.com/media-monitoring/about.html',
      ),
    ),
    31 => 
    array (
      'name' => 'Bullhorn Crawler',
      'pattern' => '^BullhornCrawler/',
      'examples' => 
      array (
        0 => 'BullhornCrawler/unknown-version(+http://bullhorn.fm/)',
      ),
      'urls' => 
      array (
        0 => 'https://bullhorn.fm/',
      ),
    ),
    32 => 
    array (
      'name' => 'Buzzsprout Importer',
      'pattern' => '^Buzzsprout Importer',
      'examples' => 
      array (
        0 => 'Buzzsprout Importer',
      ),
    ),
    33 => 
    array (
      'name' => 'Bytespider.*bytedance',
      'pattern' => 'Bytespider',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Linux; Android 5.0) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; Bytespider; spider-feedback@bytedance.com)',
      ),
    ),
    34 => 
    array (
      'name' => 'Captivate bot',
      'pattern' => '^CaptivateBot/',
      'examples' => 
      array (
        0 => 'CaptivateBot/PodcastImporter 1.0',
      ),
    ),
    35 => 
    array (
      'name' => 'Cartesia.ai bot',
      'pattern' => '^Cartesia\\.ai',
      'examples' => 
      array (
        0 => 'Cartesia.ai',
      ),
      'urls' => 
      array (
        0 => 'https://cartesia.ai/',
      ),
    ),
    36 => 
    array (
      'name' => 'CastFeedValidator',
      'pattern' => '^CastFeedValidator/',
      'examples' => 
      array (
        0 => 'CastFeedValidator/3.0.5 (https://castfeedvalidator.com)',
      ),
    ),
    37 => 
    array (
      'name' => 'Castopod',
      'pattern' => 'Castopod/\\d',
      'examples' => 
      array (
        0 => 'Castopod/1.0',
        1 => 'Castopod/1.1.2',
      ),
    ),
    38 => 
    array (
      'name' => 'Ceramic Terracotta Crawler',
      'pattern' => 'CeramicTerracotta',
      'examples' => 
      array (
        0 => 'TerraCotta https://github.com/CeramicTeam/CeramicTerracotta',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/CeramicTeam/CeramicTerracotta',
      ),
    ),
    39 => 
    array (
      'name' => 'Chartable',
      'pattern' => '^Trackable/',
      'urls' => 
      array (
        0 => 'https://chartable.com/',
      ),
    ),
    40 => 
    array (
      'name' => 'Clark-Crawler, unknown',
      'pattern' => '^clark-crawler2',
    ),
    41 => 
    array (
      'name' => 'Claudebot',
      'pattern' => 'ClaudeBot/',
      'description' => 'Claude is a family of large language models developed by Anthropic and designed to revolutionize the way you interact with AI',
      'urls' => 
      array (
        0 => 'https://docs.anthropic.com/claude/docs/intro-to-claude',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; ClaudeBot/1.0; +claudebot@anthropic.com)',
      ),
    ),
    42 => 
    array (
      'name' => 'Cloudflare SSL detector',
      'pattern' => '^Cloudflare-SSLDetector',
      'examples' => 
      array (
        0 => 'Cloudflare-SSLDetector',
      ),
      'urls' => 
      array (
        0 => 'https://developers.cloudflare.com/ssl/origin-configuration/ssl-tls-recommender/',
      ),
    ),
    43 => 
    array (
      'name' => 'Comscore Crawler',
      'pattern' => 'https://www\\.comscore\\.com',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; proximic;  https://www.comscore.com/Web-Crawler)',
      ),
      'urls' => 
      array (
        0 => 'https://www.comscore.com/Web-Crawler',
      ),
    ),
    44 => 
    array (
      'name' => 'Critical Mention',
      'pattern' => '^Podcast-CriticalMention/',
      'description' => 'Critical Mention is a business intelligence company, monitoring podcasts on the web for their clients',
      'examples' => 
      array (
        0 => 'Podcast-CriticalMention/1.0',
      ),
    ),
    45 => 
    array (
      'name' => 'curl',
      'pattern' => '^curl|^libcurl/|^PycURL/| curl/',
      'examples' => 
      array (
        0 => 'libcurl/7.65.1',
        1 => 'PycURL/7.43.0 libcurl/7.47.0 GnuTLS/3.4.10 zlib/1.2.8 libidn/1.32 librtmp/2.3',
        2 => 'GuzzleHttp/6.1.0 curl/7.50.1 PHP/7.0.13-0ubuntu0.16.10.1',
      ),
    ),
    46 => 
    array (
      'name' => 'DataforSEO',
      'pattern' => 'DataForSeoBot/',
      'description' => 'Working on the biggest available backlink database on the web that every single member of the community, including you, can use and benefit from.',
      'urls' => 
      array (
        0 => 'https://dataforseo.com/dataforseo-bot',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; DataForSeoBot/1.0; +https://dataforseo.com/dataforseo-bot)',
      ),
    ),
    47 => 
    array (
      'name' => 'Datagnion Bot',
      'pattern' => '^datagnionbot',
    ),
    48 => 
    array (
      'name' => 'dataprovider.com',
      'pattern' => 'Dataprovider\\.com',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Dataprovider.com)',
      ),
    ),
    49 => 
    array (
      'name' => 'Daum',
      'pattern' => 'http://cs\\.daum\\.net',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Daum/4.1; +http://cs.daum.net/faq/15/4118.html?faqId=28966)',
      ),
    ),
    50 => 
    array (
      'name' => 'Deepcast Podcast Sync',
      'pattern' => '^DeepCast/\\d.*Sync',
      'examples' => 
      array (
        0 => 'DeepCast/4.3.0 Podcast Sync (+https://deepcast.fm)',
      ),
      'urls' => 
      array (
        0 => 'https://deepcast.fm/',
      ),
    ),
    51 => 
    array (
      'name' => 'Deezer Podcasters',
      'pattern' => '^Deezer Podcasters/1\\.0',
    ),
    52 => 
    array (
      'name' => 'Digg',
      'pattern' => '^Digg ',
      'examples' => 
      array (
        0 => 'Digg Mozilla/5.0 (Digg/1.0; support@digg.com)',
      ),
    ),
    53 => 
    array (
      'name' => 'dorada',
      'pattern' => 'support@dorada\\.co\\.uk',
    ),
    54 => 
    array (
      'name' => 'DotBot',
      'pattern' => 'DotBot',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)',
        1 => 'Mozilla/5.0 (compatible; DotBot/1.2; https://opensiteexplorer.org/dotbot; help@moz.com)',
      ),
    ),
    55 => 
    array (
      'name' => 'Downcast Bot',
      'pattern' => 'downcast feed consumer/',
      'examples' => 
      array (
        0 => 'downcast feed consumer/0.0.175; (mode=dev; id=u2NgjBSPM6; downcast.fm)',
      ),
    ),
    56 => 
    array (
      'name' => 'DuckDuckBot',
      'pattern' => 'DuckDuckBot',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; DuckDuckBot-Https/1.1; https://duckduckgo.com/duckduckbot)',
      ),
    ),
    57 => 
    array (
      'name' => 'F-Secure Riddler',
      'pattern' => '^Riddler ',
      'description' => 'an online research project which investigates algorithms for mapping the topology of the Internet',
      'examples' => 
      array (
        0 => 'Riddler (http://riddler.io/about)',
      ),
    ),
    58 => 
    array (
      'name' => 'Facebook Bot',
      'pattern' => 'FacebookBot|f?acebookexternalhit/?|^podcastbot$|Facebot|facebookexternalua|^facebookplatform/|^"?meta-externalagent/\\d',
      'urls' => 
      array (
        0 => 'https://www.facebook.com/externalhit_uatext.php',
      ),
      'comments' => 'The podcastbot UA appears to be part of Facebook Podcasts onboarding',
      'examples' => 
      array (
        0 => 'facebookexternalhit/1.1 ( http://www.facebook.com/externalhit_uatext.php)',
        1 => 'podcastbot',
        2 => 'facebookexternalhit',
        3 => 'Facebot',
        4 => 'facebookexternalua',
        5 => 'facebookplatform/1.0 (+http://developers.facebook.com)',
        6 => 'acebookexternalhit/1.0 (+http://www.facebook.com/externalhit_uatext.php)',
        7 => 'meta-externalagent/1.1 ( https://developers.facebook.com/docs/sharing/webmasters/crawler)',
        8 => '"meta-externalagent/1.1 ( https://developers.facebook.com/docs/sharing/webmasters/crawler)"',
      ),
    ),
    59 => 
    array (
      'name' => 'Feedly',
      'pattern' => '^Feedly/',
      'examples' => 
      array (
        0 => 'Feedly/1.0 (+http://www.feedly.com/fetcher.html; like FeedFetcher-Google)',
      ),
    ),
    60 => 
    array (
      'name' => 'Feedspot Fetcher',
      'pattern' => 'https://www\\.feedspot\\.com/fs/fetcher',
      'description' => 'Feedspot Fetcher is how Feedspot fetches RSS/Atom feed when users add the feed to their Feedspot account.',
      'urls' => 
      array (
        0 => 'https://www.feedspot.com/fs/fetcher',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Feedspot/1.0 (+https://www.feedspot.com/fs/fetcher; like FeedFetcher-Google)',
      ),
    ),
    61 => 
    array (
      'name' => 'FlexGet',
      'pattern' => '^FlexGet/',
      'examples' => 
      array (
        0 => 'FlexGet/3.3.4 (www.flexget.com)',
      ),
    ),
    62 => 
    array (
      'name' => 'Flipboard Proxy',
      'pattern' => 'FlipboardProxy/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; FlipboardProxy/1.1; +http://flipboard.com/browserproxy)',
      ),
    ),
    63 => 
    array (
      'name' => 'Fyyd',
      'pattern' => '^fyyd-poll',
    ),
    64 => 
    array (
      'name' => 'Go Storage Gateway V1',
      'pattern' => '^storagegw-v1-go$',
      'comments' => 'Found coming from TikTok/ByteDance ASNs, along with Go Http Client.',
      'examples' => 
      array (
        0 => 'storagegw-v1-go',
      ),
    ),
    65 => 
    array (
      'name' => 'Goodpods Bot',
      'pattern' => 'Goodpods/\\d+\\.\\d+',
      'description' => 'The social podcasting app',
      'svg' => 'goodpods.svg',
      'urls' => 
      array (
        0 => 'https://www.goodpods.com/',
      ),
      'comments' => 'RSS scraper / podcast verifier. Contact hello at goodpods dot com.',
      'examples' => 
      array (
        0 => 'Goodpods/2.2',
      ),
    ),
    66 => 
    array (
      'name' => 'Google Adsense Bot',
      'pattern' => 'Mediapartners-Google',
      'examples' => 
      array (
        0 => 'Mediapartners-Google',
      ),
      'urls' => 
      array (
        0 => 'https://developers.google.com/search/docs/crawling-indexing/overview-google-crawlers',
      ),
    ),
    67 => 
    array (
      'name' => 'Google AdsBot',
      'pattern' => 'AdsBot-Google|Google-AdWords-Express',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; Mozilla/5.0, Google-AdWords-Express) Chrome/137.0.7151.119 Safari/537.36',
      ),
      'urls' => 
      array (
        0 => 'http://www.google.com/adsbot.html',
      ),
    ),
    68 => 
    array (
      'name' => 'Google Podcasts Manager',
      'pattern' => 'Google-Podcast',
    ),
    69 => 
    array (
      'name' => 'Googlebot',
      'pattern' => 'Googlebot/|Googlebot-Video/|Googlebot-Image/|^Feed[fF]etcher-Google|google-xrawler|^Googlebot-News|^Google-Safety$',
      'description' => 'Google\'s search bots',
      'urls' => 
      array (
        0 => 'http://www.google.com/bot.html',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.96 Mobile Safari/537.36 (compatible; Googlebot/2.1; http://www.google.com/bot.html)',
        1 => 'Googlebot-Image/1.0',
        2 => 'Feedfetcher-Google; (+http://www.google.com/feedfetcher.html; 1 subscribers; feed-id=4653447469100830145)',
        3 => 'google-xrawler',
        4 => 'Googlebot-News Audio',
        5 => 'Google-Safety',
        6 => 'FeedFetcher-Google; (+http://www.google.com/feedfetcher.html)',
      ),
    ),
    70 => 
    array (
      'name' => 'Gumball',
      'pattern' => '^Gumball',
      'description' => 'An attribution service (known as Gumshoe) from the Gumball network',
      'examples' => 
      array (
        0 => 'Gumball.fm Analytics Prefix Checker',
      ),
    ),
    71 => 
    array (
      'name' => 'Headline Crawler',
      'pattern' => 'https://headline\\.com',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; ev-crawler/1.0;  https://headline.com/legal/crawler)',
      ),
      'urls' => 
      array (
        0 => 'https://headline.com/legal/crawler',
      ),
    ),
    72 => 
    array (
      'name' => 'Headliner',
      'pattern' => '^Headliner/.*[+ ]https://headliner\\.app$',
      'comments' => 'Variety of tools to help promote and drive listens to a podcast.',
      'examples' => 
      array (
        0 => 'Headliner/1.0.0 +https://headliner.app',
        1 => 'Headliner/1.0.0  https://headliner.app',
      ),
    ),
    73 => 
    array (
      'name' => 'HubSpot Crawler',
      'pattern' => 'HubSpot Crawler',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; HubSpot Crawler; +https://www.hubspot.com)',
      ),
    ),
    74 => 
    array (
      'name' => 'Internet Archive',
      'pattern' => 'Archive-It;|web\\.archive\\.org',
      'description' => 'Archive-It is a web archiving service that allows institutions to build and preserve collections of born digital content saving this content for future generations.',
      'urls' => 
      array (
        0 => 'https://archive-it.org/files/site-owners-special.html',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; special_archiver; Archive-It; http://archive-it.org/files/site-owners-special.html)',
        1 => 'ia_archiver-web.archive.org',
      ),
    ),
    75 => 
    array (
      'name' => 'iono.fm feed importer',
      'pattern' => '^iono/feed_importer',
      'examples' => 
      array (
        0 => 'iono/feed_importer',
      ),
      'urls' => 
      array (
        0 => 'https://iono.fm/',
      ),
    ),
    76 => 
    array (
      'name' => 'iOS share menu',
      'pattern' => '^SharingUIService/',
      'examples' => 
      array (
        0 => 'SharingUIService/1 CFNetwork/1467.1 Darwin/23.0.0',
        1 => 'SharingUIService/1 CFNetwork/1490.0.4 Darwin/23.2.0',
      ),
      'comments' => 'Found on iOS 17 e.g. when long-pressing an enclosure link from Safari and choosing Share...',
    ),
    77 => 
    array (
      'name' => 'IPFS Podcasting Node',
      'description' => 'Nodes downloading from the original source (before pinning to IPFS)',
      'pattern' => '^IPFS Podcasting Node/',
      'examples' => 
      array (
        0 => 'IPFS Podcasting Node/0.6n (+https://ipfspodcasting.net)',
        1 => 'IPFS Podcasting Node/0.7p,u,s (+https://ipfspodcasting.net)',
      ),
      'urls' => 
      array (
        0 => 'https://ipfspodcasting.net',
      ),
    ),
    78 => 
    array (
      'name' => 'Jaunt',
      'pattern' => '^Jaunt/',
      'examples' => 
      array (
        0 => 'Jaunt/1.5',
      ),
    ),
    79 => 
    array (
      'name' => 'Jamit bot',
      'pattern' => '^Jamit/1\\.0$',
      'examples' => 
      array (
        0 => 'Jamit/1.0',
      ),
    ),
    80 => 
    array (
      'name' => 'l\'Institut national de l\'audiovisuel',
      'pattern' => 'INA dlweb',
      'urls' => 
      array (
        0 => 'https://institut.ina.fr/collecte-du-depot-legal-web',
      ),
      'comments' => 'Institut National de l\'Audiovisuel is a repository of all French radio and television audiovisual archives.',
    ),
    81 => 
    array (
      'name' => 'Library and Archives Canada',
      'description' => 'The Web and Social Media Preservation Program at Library and Archives Canada (LAC) acquires Canadian web resources for the purposes of digital preservation and makes them available to the public via the Government of Canada Web Archive (GCWA) for future research.',
      'pattern' => 'LAC_IAHarvester/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; LAC_IAHarvester/3.3.0; +https://library-archives.canada.ca/eng/services/government-canada/web-social-media-preservation-program/Pages/web-archive.aspx)',
      ),
      'urls' => 
      array (
        0 => 'https://library-archives.canada.ca/eng/services/government-canada/web-social-media-preservation-program/Pages/web-archive.aspx',
      ),
    ),
    82 => 
    array (
      'name' => 'Libsyn',
      'pattern' => '^Libsyn4',
      'examples' => 
      array (
        0 => 'Libsyn4-Download',
      ),
    ),
    83 => 
    array (
      'name' => 'libwww-perl',
      'pattern' => '^libwww-perl| libwww-perl',
      'examples' => 
      array (
        0 => 'LWP::Simple/6.34 libwww-perl/6.34',
      ),
    ),
    84 => 
    array (
      'name' => 'LinkPreview',
      'pattern' => '^LinkPreview/\\d',
      'examples' => 
      array (
        0 => 'LinkPreview/1.6 (https://www.linkpreview.net)',
      ),
      'urls' => 
      array (
        0 => 'https://www.linkpreview.net/',
      ),
    ),
    85 => 
    array (
      'name' => 'Livelap Crawler',
      'pattern' => 'LivelapBot',
    ),
    86 => 
    array (
      'name' => 'ListenNotes',
      'pattern' => '^ListenNotes/3\\.0 \\(',
      'examples' => 
      array (
        0 => 'ListenNotes/3.0 (id=c1ef144e30174bf6ba1fedf9174ed908; +https://www.listennotes.com/about/)',
      ),
      'urls' => 
      array (
        0 => 'https://www.listennotes.com/about/',
      ),
    ),
    87 => 
    array (
      'name' => 'LTX71',
      'pattern' => '^ltx71 ',
      'description' => 'We continuously scan the internet for security research purposes.',
      'urls' => 
      array (
        0 => 'http://ltx71.com/',
      ),
      'examples' => 
      array (
        0 => 'ltx71 - (http://ltx71.com/)',
      ),
    ),
    88 => 
    array (
      'name' => 'MacOS share menu',
      'pattern' => '^ShareSheetUI/',
      'examples' => 
      array (
        0 => 'ShareSheetUI/1 CFNetwork/1399.4 Darwin/22.1.0',
        1 => 'ShareSheetUI/1 CFNetwork/1474 Darwin/23.0.0',
      ),
      'comments' => 'Found on MacOS 13 (Ventura) and higher e.g. when right-clicking an enclosure link from Safari and choosing Share...',
    ),
    89 => 
    array (
      'name' => 'magic-podcast-downloader',
      'pattern' => '^magic-podcast-downloader/',
      'examples' => 
      array (
        0 => 'magic-podcast-downloader/1.0',
      ),
    ),
    90 => 
    array (
      'name' => 'MauiBot',
      'pattern' => '^MauiBot',
      'examples' => 
      array (
        0 => 'MauiBot (crawler.feedback dc@gmail.com)',
      ),
    ),
    91 => 
    array (
      'name' => 'Mastodon Bot',
      'pattern' => 'rb/.*Mastodon/|Mastodon/.*http\\.rb',
      'examples' => 
      array (
        0 => 'http.rb/5.0.4 (Mastodon/3.5.3; +https://mastodon.xyz/) Bot',
        1 => 'Mastodon/4.3.9 (http.rb/5.2.0; +https://mastodon.shultz.ynh.fr/)',
        2 => 'Mastodon/4.5.0-alpha.1+glitch (http.rb/5.3.1; +https://convo.casa/)',
      ),
    ),
    92 => 
    array (
      'name' => 'Fediverse Bot',
      'pattern' => '^Misskey/|^CherryPick/|^Iceshrimp/|^gotosocial/',
      'examples' => 
      array (
        0 => 'Misskey/2025.4.3 (https://fedi.amethyst.name)',
        1 => 'CherryPick/4.16.0 (https://blewsky.social/)',
        2 => 'Misskey/E9E-3.6.9-Beta1 (https://eter9.com)',
        3 => 'Iceshrimp/2023.12.14-dev-5db0fdc63 (https://misskey.noctella.fun)',
        4 => 'gotosocial/0.19.1+git-6574dc8 (+https://social.maru.my)',
      ),
    ),
    93 => 
    array (
      'name' => 'Metacast Crawler',
      'pattern' => '^Metacast/.* Crawler',
      'examples' => 
      array (
        0 => 'Metacast/1.0 Crawler +https://metacast.app',
      ),
      'urls' => 
      array (
        0 => 'https://metacast.app/',
      ),
    ),
    94 => 
    array (
      'name' => 'Microsoft Bingbot',
      'pattern' => '(BingPreview/|adidxbot/|[bB]ingbot/)',
      'urls' => 
      array (
        0 => 'https://www.bing.com/webmaster/help/which-crawlers-does-bing-use-8c184ec0',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/534 (KHTML, like Gecko) BingPreview/1.0b',
        1 => 'Mozilla/5.0 (compatible; Bingbot/2.0; +http://www.bing.com/bingbot.htm)',
      ),
    ),
    95 => 
    array (
      'name' => 'Microsoft Office',
      'pattern' => 'ms-office; MSOffice',
      'examples' => 
      array (
        0 => 'Mozilla/4.0 (compatible; ms-office; MSOffice 16)',
      ),
    ),
    96 => 
    array (
      'name' => 'Mixcloud Podcast Importer',
      'pattern' => '^MixcloudPodcastImporter/',
      'examples' => 
      array (
        0 => 'MixcloudPodcastImporter/2.0',
      ),
    ),
    97 => 
    array (
      'name' => 'MJ12bot',
      'pattern' => '.*MJ12bot',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; MJ12bot/v1.4.8; http://mj12bot.com/)',
      ),
    ),
    98 => 
    array (
      'name' => 'Mozilla Bot',
      'pattern' => '^\'?Mozilla(/5\\.0(\\.\\.\\.)?)?$|^\\(Mozilla/5\\.0\\)$',
      'examples' => 
      array (
        0 => 'Mozilla/5.0',
        1 => 'Mozilla',
        2 => 'Mozilla/5.0...',
        3 => '\'Mozilla/5.0',
        4 => '(Mozilla/5.0)',
      ),
    ),
    99 => 
    array (
      'name' => 'MSN Bot',
      'pattern' => '^msnbot/',
    ),
    100 => 
    array (
      'name' => 'Neevabot',
      'pattern' => '.*Neevabot',
      'urls' => 
      array (
        0 => 'https://neeva.com/neevabot',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Neevabot/1.0; https://neeva.com/neevabot)',
      ),
    ),
    101 => 
    array (
      'name' => 'Netcraft Survey Agent',
      'pattern' => ' NetcraftSurveyAgent/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; NetcraftSurveyAgent/1.0; +info@netcraft.com)',
      ),
    ),
    102 => 
    array (
      'name' => 'Newspaper',
      'description' => 'News, full-text, and article metadata extraction in Python 3.',
      'pattern' => '^newspaper/\\d',
      'examples' => 
      array (
        0 => 'newspaper/0.3.0',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/codelucas/newspaper',
      ),
    ),
    103 => 
    array (
      'name' => 'NL Israel Internet Archiver',
      'pattern' => 'NL-Israel_IA',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; NL-Israel_IAHarvester2025/3.3.0;  https://www.nli.org.il/he/research-and-teach/internet-archive/law-and-order)',
      ),
      'urls' => 
      array (
        0 => 'https://www.nli.org.il/he/research-and-teach/internet-archive/law-and-order',
      ),
    ),
    104 => 
    array (
      'name' => 'OgScrper',
      'pattern' => 'OgScrper',
      'examples' => 
      array (
        0 => 'OgScrper',
      ),
    ),
    105 => 
    array (
      'name' => 'OkDownload',
      'pattern' => '^OkDownload/',
    ),
    106 => 
    array (
      'name' => 'OmniStudio',
      'pattern' => '^OmnyStudio/\\d',
      'examples' => 
      array (
        0 => 'OmnyStudio/1.0',
      ),
    ),
    107 => 
    array (
      'name' => 'OP3 Fetcher',
      'pattern' => '^op3-fetcher/',
      'examples' => 
      array (
        0 => 'op3-fetcher/1.0 (https://op3.dev)',
      ),
      'urls' => 
      array (
        0 => 'https://op3.dev',
      ),
    ),
    108 => 
    array (
      'name' => 'OpenAI GPTBot',
      'pattern' => 'GPTBot/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; GPTBot/1.2; +https://openai.com/gptbot)',
        1 => 'Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; GPTBot/1.0; +https://openai.com/gptbot)',
      ),
      'urls' => 
      array (
        0 => 'https://openai.com/gptbot',
      ),
    ),
    109 => 
    array (
      'name' => 'Overcast feed parser',
      'pattern' => '^Overcast/1\\.0 Podcast Sync',
      'comments' => 'Marco Arment says: when a new episode is detected, the servers fetch a copy of it to seed these values with an initial set of data to make the privacy screen more accurate.',
      'examples' => 
      array (
        0 => 'Overcast/1.0 Podcast Sync',
        1 => 'Overcast/1.0 Podcast Sync (+http://overcast.fm/)',
        2 => 'Overcast/1.0 Podcast Sync (1 subscribers; feed-id=1234567; +http://overcast.fm/)',
      ),
    ),
    110 => 
    array (
      'name' => 'Overcast Transcriber',
      'pattern' => '^Overcast%20Transcriber/',
      'examples' => 
      array (
        0 => 'Overcast%20Transcriber/1 CFNetwork/3855.100.1 Darwin/25.0.0',
      ),
    ),
    111 => 
    array (
      'name' => 'Owler Open Web Crawler',
      'description' => 'We crawl the Web to create an open web index and to bootstrap a more open internet search ecosystem',
      'pattern' => '^Owler \\(',
      'examples' => 
      array (
        0 => 'Owler (ows.eu/owler)',
      ),
      'urls' => 
      array (
        0 => 'https://ows.eu/owler',
      ),
    ),
    112 => 
    array (
      'name' => 'Pandora RSS crawler',
      'pattern' => '^PandoraRSSCrawler',
    ),
    113 => 
    array (
      'name' => 'PaperLi',
      'pattern' => 'PaperLiBot/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; PaperLiBot/2.1; https://support.paper.li/entries/20023257-what-is-paper-li)',
      ),
    ),
    114 => 
    array (
      'name' => 'PetalBot',
      'pattern' => 'PetalBot',
      'description' => 'PetalBot is an automatic program of the Petal search engine.',
      'urls' => 
      array (
        0 => 'https://aspiegel.com/petalbot',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot; https://aspiegel.com/petalbot)',
      ),
    ),
    115 => 
    array (
      'name' => 'Pinecast Importer',
      'pattern' => '^Pinecast/Importer',
      'examples' => 
      array (
        0 => 'Pinecast/Importer 1.1',
      ),
    ),
    116 => 
    array (
      'name' => 'Pingdom',
      'pattern' => '^Pingdom',
    ),
    117 => 
    array (
      'name' => 'PlayerFM Podcast Sync',
      'pattern' => 'PlayerFM/.* Podcast Sync',
      'examples' => 
      array (
        0 => 'PlayerFM/1.0 Podcast Sync (0 subscribers; url=https://player.fm/series/series-2567872)',
      ),
    ),
    118 => 
    array (
      'name' => 'Podbean Importer',
      'pattern' => '^Podbean Importer',
      'examples' => 
      array (
        0 => 'Podbean Importer',
      ),
    ),
    119 => 
    array (
      'name' => 'Podcastindex.org',
      'pattern' => '^Podcastindex\\.org/|\\(PodcastIndex\\.org\\)',
      'svg' => 'podcast-index.svg',
      'urls' => 
      array (
        0 => 'https://podcastindex.org/',
      ),
      'examples' => 
      array (
        0 => 'Podcastindex.org/v0.3.3 (Aggrivate)',
        1 => 'Aggrivator (PodcastIndex.org)/v0.1.7',
      ),
    ),
    120 => 
    array (
      'name' => 'Podcast de facto Standard',
      'description' => 'Dedicated to providing guidance and information on the conventions and standards used in podcasting',
      'pattern' => '^PodcastStandard/',
      'examples' => 
      array (
        0 => 'PodcastStandard/0.1.0 (+https://podcast-standard.org)',
      ),
      'urls' => 
      array (
        0 => 'https://podcast-standard.org/',
      ),
    ),
    121 => 
    array (
      'name' => 'Podcast Archiver',
      'pattern' => '^Podcast%20Archiver/',
      'urls' => 
      array (
        0 => 'https://www.fredrikblank.com/podcast-archiver/',
      ),
      'examples' => 
      array (
        0 => 'Podcast%20Archiver/3000000003 CFNetwork/1406.0.4 Darwin/22.4.0',
      ),
    ),
    122 => 
    array (
      'name' => 'Podcast Archiver (janw)',
      'pattern' => '^podcast-archiver/v\\d',
      'urls' => 
      array (
        0 => 'https://github.com/janw/podcast-archiver',
      ),
      'examples' => 
      array (
        0 => 'podcast-archiver/v1.7.1 (https://github.com/janw/podcast-archiver)',
      ),
    ),
    123 => 
    array (
      'name' => 'Podcast Go Audio Downloader',
      'pattern' => '^podcast-go-audio-downloader/',
      'examples' => 
      array (
        0 => 'podcast-go-audio-downloader/2.0',
      ),
    ),
    124 => 
    array (
      'name' => 'Podcastics',
      'pattern' => '^Podcastics$',
      'urls' => 
      array (
        0 => 'https://podcastics.com',
      ),
      'examples' => 
      array (
        0 => 'Podcastics',
      ),
    ),
    125 => 
    array (
      'name' => 'Podcatcher Bot',
      'pattern' => '^Podcatcher Bot 1.0',
      'examples' => 
      array (
        0 => 'Podcatcher Bot 1.0',
        1 => 'Podcatcher Bot 1.0 (1 subscribers; +https://podcatcher.net)',
      ),
    ),
    126 => 
    array (
      'name' => 'Podchaser Parser',
      'pattern' => '^PodchaserParser/',
      'examples' => 
      array (
        0 => 'PodchaserParser/2.0 (https://podchaser.com)',
      ),
    ),
    127 => 
    array (
      'name' => 'PodcastBulkDownloader',
      'pattern' => '^PodcastBulkDownloader/',
      'examples' => 
      array (
        0 => 'PodcastBulkDownloader/0.10.1',
      ),
    ),
    128 => 
    array (
      'name' => 'PodcastDownloader',
      'pattern' => ' PodcastDownloader/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; PodcastDownloader/1.0)',
      ),
    ),
    129 => 
    array (
      'name' => 'PodCloud',
      'pattern' => 'podCloud',
      'description' => 'Le podcast, simplement. A French-language web-based podcast player.',
      'urls' => 
      array (
        0 => 'https://podcloud.fr',
      ),
      'comments' => 'This useragent is a bot, doing feed updates and downloading media files. It was observed every six hours. User plays will have a standard browser useragent with a referer of https://podcloud.fr/',
    ),
    130 => 
    array (
      'name' => 'Podcorn',
      'pattern' => 'Podcorn/',
      'description' => 'The leading podcast influencer marketplace. Connecting unique voices to unique brands for native advertising.',
      'urls' => 
      array (
        0 => 'https://podcorn.com/',
      ),
      'examples' => 
      array (
        0 => 'Podcorn/1.0',
      ),
    ),
    131 => 
    array (
      'name' => 'PodderBot',
      'pattern' => 'PodderBot/',
      'description' => 'PodderApp bot',
      'urls' => 
      array (
        0 => 'https://www.podderapp.com/',
      ),
      'comments' => 'PodderApp bot for RSS fetching / verification',
      'examples' => 
      array (
        0 => 'PodderBot/1.0',
      ),
    ),
    132 => 
    array (
      'name' => 'poddl - podcast downloader',
      'description' => 'a cross platform command line podcast downloader for downloading all, individual, or a range of podcast episodes from an RSS feed.',
      'pattern' => 'poddl - (podcast downloader|https://github.com/freshe/poddl)',
      'examples' => 
      array (
        0 => 'poddl - podcast downloader',
        1 => 'poddl - https://github.com/freshe/poddl',
      ),
      'urls' => 
      array (
        0 => 'https://www.fredrikblank.com/poddl/',
        1 => 'https://github.com/freshe/poddl',
      ),
    ),
    133 => 
    array (
      'name' => 'Podfollow',
      'pattern' => 'podfollowbot/',
      'description' => 'Podfollow, a service to help link to your podcast',
      'urls' => 
      array (
        0 => 'https://podfollow.com',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 https://podfollow.com/crawling podfollowbot/1.0',
      ),
    ),
    134 => 
    array (
      'name' => 'Podgrab',
      'pattern' => '^Podgrab$',
      'description' => 'A self-hosted podcast manager to download episodes as soon as they become live',
      'urls' => 
      array (
        0 => 'https://github.com/akhilrex/podgrab',
      ),
      'examples' => 
      array (
        0 => 'Podgrab',
      ),
      'comments' => 'Found used for automated archiving.',
    ),
    135 => 
    array (
      'name' => 'Podhound',
      'pattern' => 'PodhoundBeta',
      'description' => 'AI-powered podcast discovery',
      'urls' => 
      array (
        0 => 'http://podhound.co',
      ),
      'comments' => '\'It grabs it once to get the audio file length.\', says the developer.',
      'examples' => 
      array (
        0 => 'PodhoundBeta',
      ),
    ),
    136 => 
    array (
      'name' => 'Podio Bot',
      'pattern' => '^Podio/',
      'description' => 'Podcasts + Radio = Podio',
      'urls' => 
      array (
        0 => 'https://podio.radio/',
      ),
      'comments' => 'This useragent appears to download and cache audio',
      'examples' => 
      array (
        0 => 'Podio/1.0',
      ),
    ),
    137 => 
    array (
      'name' => 'Podlexicon Downloader',
      'pattern' => '^PodlexiconDownloader',
      'examples' => 
      array (
        0 => 'PodlexiconDownloader/1.0',
      ),
      'urls' => 
      array (
        0 => 'https://podlexicon.com/',
      ),
    ),
    138 => 
    array (
      'name' => 'Podmon Bot',
      'pattern' => '^Podmonbot/',
      'urls' => 
      array (
        0 => 'https://podmon.io/',
      ),
      'examples' => 
      array (
        0 => 'Podmonbot/1.0',
      ),
    ),
    139 => 
    array (
      'name' => 'Podnews',
      'pattern' => 'PodnewsBot',
      'description' => 'Podnews runs a number of bots to read and test RSS and audio files',
      'urls' => 
      array (
        0 => 'http://podnews.net',
      ),
    ),
    140 => 
    array (
      'name' => 'Podnods Bot',
      'pattern' => '(podnods-crawler|podnods)',
      'description' => 'Podnods is a podcast discovery site. This user agent is for crawling podcast data.',
      'urls' => 
      array (
        0 => 'https://podnods.com/about',
      ),
    ),
    141 => 
    array (
      'name' => 'Podplay Podcast Sync',
      'pattern' => '^Podplay-Podcast-Sync/',
      'examples' => 
      array (
        0 => 'Podplay-Podcast-Sync/1.0 (+https://podplay.com/articles/contact)',
      ),
      'urls' => 
      array (
        0 => 'https://podplay.com/articles/contact',
      ),
    ),
    142 => 
    array (
      'name' => 'PodRank Downloader',
      'pattern' => '^pod-rank-downloader/',
      'examples' => 
      array (
        0 => 'pod-rank-downloader/1.0',
      ),
    ),
    143 => 
    array (
      'name' => 'Podroll Analyzer',
      'pattern' => '^pdrl\\.fm ',
      'examples' => 
      array (
        0 => 'pdrl.fm Analyzer / 1.0.0',
      ),
    ),
    144 => 
    array (
      'name' => 'Podscan Bot',
      'pattern' => '^PodscanBot/',
      'examples' => 
      array (
        0 => 'PodscanBot/1.1.0 Ubuntu/22.04 (Linux) +https://podscan.fm',
        1 => 'PodscanBot/1.1.0 Ubuntu/22.04 (Linux) Podscan.fm',
      ),
      'urls' => 
      array (
        0 => 'https://podscan.fm',
      ),
    ),
    145 => 
    array (
      'name' => 'Podscribe',
      'pattern' => '(^Adswizz-podscribe/|^Podscribe/)',
      'examples' => 
      array (
        0 => 'Adswizz-podscribe/1.0',
        1 => 'Podscribe/1.1',
      ),
    ),
    146 => 
    array (
      'name' => 'PodUptime',
      'description' => 'Uptime Monitoring for the Podcast Industry',
      'pattern' => '(PodUptime|PodUptimeBot)/\\d',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; PodUptime/1.0; +https://poduptime.com)',
        1 => 'Mozilla/5.0 (compatible; PodUptimeBot/1.0; +https://poduptime.com; rid:5c02fc9b-2660-4d3e-a352-de1a1aabdc0a)',
      ),
      'urls' => 
      array (
        0 => 'https://poduptime.com/',
      ),
    ),
    147 => 
    array (
      'name' => 'Podtail RSS Crawler',
      'pattern' => '/podtail\\.com',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Podtail/2.0; +https://podtail.com/)',
      ),
    ),
    148 => 
    array (
      'name' => 'Podtrac Feed Scanner',
      'pattern' => '^Podtrac Feed Scanner|^Podtrac Network Client',
      'examples' => 
      array (
        0 => 'Podtrac Feed Scanner',
        1 => 'Podtrac Network Client/1.0 (beta)',
      ),
    ),
    149 => 
    array (
      'name' => 'Podverse Feed Parser',
      'pattern' => '^Podverse/Feed Parser',
      'description' => 'The Podverse feed parser.',
      'urls' => 
      array (
        0 => 'https://podverse.fm',
      ),
      'comments' => 'This service parses publicly-accessible RSS feeds on a timer, then stores parsed data in the Podverse database.',
    ),
    150 => 
    array (
      'name' => 'PodvineBot',
      'pattern' => '^PodvineBot/',
      'examples' => 
      array (
        0 => 'PodvineBot/4.0.1 (www.podvine.com)',
      ),
    ),
    151 => 
    array (
      'name' => 'PostRank Bot',
      'pattern' => '^PostRank/',
      'examples' => 
      array (
        0 => 'PostRank/2.0 (postrank.com; 1 subscribers)',
      ),
      'comments' => 'Acquired by Google, https://en.wikipedia.org/wiki/PostRank',
    ),
    152 => 
    array (
      'name' => 'PodwatchPro',
      'pattern' => 'Podwatch-Pro Crawler',
      'examples' => 
      array (
        0 => 'Podwatch-Pro Crawler',
      ),
      'description' => 'PodwatchPro is a podcast analytics software. This user agent is for crawling podcast data.',
      'urls' => 
      array (
        0 => 'https://www.agma-mmc.de/media-analyse/ma-podcast',
      ),
    ),
    153 => 
    array (
      'name' => 'Puppeteer',
      'pattern' => ' HeadlessChrome/\\d',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) HeadlessChrome/105.0.5173.0 Safari/537.36',
      ),
      'urls' => 
      array (
        0 => 'https://pptr.dev/',
      ),
    ),
    154 => 
    array (
      'name' => 'Pyannote',
      'pattern' => '^pyannoteAI',
      'examples' => 
      array (
        0 => 'pyannoteAI',
        1 => 'pyannoteAI/2025.19.1-021f79d.production',
      ),
      'urls' => 
      array (
        0 => 'https://www.pyannote.ai/',
      ),
    ),
    155 => 
    array (
      'name' => 'python-requests',
      'pattern' => 'python-requests',
    ),
    156 => 
    array (
      'name' => 'Qiniu spider',
      'pattern' => 'qiniu.*spider',
      'examples' => 
      array (
        0 => 'z0-qiniu-imgstg-spider-1.0',
      ),
    ),
    157 => 
    array (
      'name' => 'Radioline Stream Monitoring',
      'pattern' => '^Radioline Stream Monitoring',
      'examples' => 
      array (
        0 => 'Radioline Stream Monitoring (tech@radioline.co)',
      ),
    ),
    158 => 
    array (
      'name' => 'RedCircle',
      'pattern' => 'RedCircle',
      'description' => 'A platform for podcasts and brands to scale their message.',
      'urls' => 
      array (
        0 => 'https://redcircle.com/',
      ),
      'examples' => 
      array (
        0 => 'RedCircle',
      ),
    ),
    159 => 
    array (
      'name' => 'Rephonic',
      'pattern' => '^Rephonic/\\d',
      'urls' => 
      array (
        0 => 'https://rephonic.com/',
      ),
      'examples' => 
      array (
        0 => 'Rephonic/1.0',
      ),
    ),
    160 => 
    array (
      'name' => 'Req',
      'description' => 'Req is a batteries-included HTTP client for Elixir',
      'pattern' => '^req/\\d',
      'urls' => 
      array (
        0 => 'https://github.com/wojtekmach/req',
      ),
      'examples' => 
      array (
        0 => 'req/0.5.10',
      ),
    ),
    161 => 
    array (
      'name' => 'Ridder Bot',
      'pattern' => ' RidderBot/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; RidderBot/1.0; bot@ridder.co)',
      ),
    ),
    162 => 
    array (
      'name' => 'RSS Audio Downloader',
      'pattern' => '^rss-audio-downloader/',
      'examples' => 
      array (
        0 => 'rss-audio-downloader/1.1 (+https://example.invalid)',
      ),
    ),
    163 => 
    array (
      'name' => 'RSS to Telegram',
      'pattern' => '^RSStT',
      'description' => 'an RSS to Telegram bot',
      'urls' => 
      array (
        0 => 'https://apps.apple.com/be/app/audiowave-podcast-player/id1602776751',
      ),
      'examples' => 
      array (
        0 => 'RSStT/2.2.1 RSS Reader',
      ),
    ),
    164 => 
    array (
      'name' => 'rssfeedfetcher',
      'pattern' => '^rssfeedfetcher ',
      'examples' => 
      array (
        0 => 'rssfeedfetcher libfetch/2.0',
      ),
    ),
    165 => 
    array (
      'name' => 'RSSRadio',
      'pattern' => '^RSSRadio \\(',
    ),
    166 => 
    array (
      'name' => 'Ruby Mechanize',
      'pattern' => '^Mechanize|[ -]Mechanize/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Mechanize/2.7.4)',
        1 => 'WWW-Mechanize/1.72',
      ),
    ),
    167 => 
    array (
      'name' => 'RunPod',
      'pattern' => '^runpod-python/',
      'examples' => 
      array (
        0 => 'runpod-python/0.0.0 (https://runpod.io; support@runpod.io)',
      ),
      'urls' => 
      array (
        0 => 'https://www.runpod.io/',
      ),
      'comments' => 'https://github.com/runpod/runpod-python/blob/9c5918e9bc83f82bdfbb9fa94ad049e56c76a398/runpod/serverless/utils/rp_download.py#L23',
    ),
    168 => 
    array (
      'name' => 'SB Intuitions Crawler',
      'pattern' => 'https://sbintuitions\\.co\\.jp',
      'examples' => 
      array (
        0 => 'SB Intuitions Crawler ( https://sbintuitions.co.jp)',
      ),
      'urls' => 
      array (
        0 => 'https://sbintuitions.co.jp',
      ),
    ),
    169 => 
    array (
      'name' => 'Screaming Frog SEO Spider',
      'pattern' => '^Screaming Frog ',
      'examples' => 
      array (
        0 => 'Screaming Frog SEO Spider/5.1',
      ),
    ),
    170 => 
    array (
      'name' => 'SearchAtlas.com SEO Crawler',
      'pattern' => '^SearchAtlas.*Crawler',
      'examples' => 
      array (
        0 => 'SearchAtlas.com SEO Crawler',
      ),
    ),
    171 => 
    array (
      'name' => 'SEMrushBot',
      'pattern' => 'SemrushBot/|^SEMrushBot$',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; SemrushBot/6~bl; http://www.semrush.com/bot.html)',
        1 => 'SEMrushBot',
      ),
    ),
    172 => 
    array (
      'name' => 'Serendeputy',
      'pattern' => 'SerendeputyBot/',
      'urls' => 
      array (
        0 => 'https://serendeputy.com/about/serendeputy-bot',
      ),
      'examples' => 
      array (
        0 => 'SerendeputyBot/0.8.6 (http://serendeputy.com/about/serendeputy-bot)',
      ),
    ),
    173 => 
    array (
      'name' => 'Simplecast',
      'pattern' => '^Simplecast$',
      'examples' => 
      array (
        0 => 'Simplecast',
      ),
    ),
    174 => 
    array (
      'name' => 'SiriusXM Bot',
      'pattern' => '^SiriusXM/(RSS|STT)',
      'examples' => 
      array (
        0 => 'SiriusXM/RSS-Scanner/1.0',
        1 => 'SiriusXM/STT-Processor/1.0',
      ),
    ),
    175 => 
    array (
      'name' => 'Slack Bot',
      'pattern' => '^Slackbot 1\\.0',
      'examples' => 
      array (
        0 => 'Slackbot 1.0 ( https://api.slack.com/robots)',
      ),
    ),
    176 => 
    array (
      'name' => 'Snapchat Bot',
      'pattern' => '://developers\\.snap\\.com/robots',
      'examples' => 
      array (
        0 => 'Snap URL Preview Service; bot; snapchat; https://developers.snap.com/robots',
      ),
    ),
    177 => 
    array (
      'name' => 'SoundMadeSeen',
      'description' => 'SoundMadeSeen is the easy way to turn your podcast, audiobook or talk into sharable video and AI text content in minutes',
      'pattern' => '^SoundMadeSeen/\\d',
      'examples' => 
      array (
        0 => 'SoundMadeSeen/1.0 +https://soundmadeseen.com',
      ),
      'urls' => 
      array (
        0 => 'https://soundmadeseen.com',
      ),
    ),
    178 => 
    array (
      'name' => 'SoundOn Bot',
      'pattern' => '^SoundOn/[\\d.]+\\s+\\(bot',
    ),
    179 => 
    array (
      'name' => 'Speechmatics ASR',
      'pattern' => '^Speechmatics-API/',
      'examples' => 
      array (
        0 => 'Speechmatics-API/2.0',
      ),
      'urls' => 
      array (
        0 => 'https://www.speechmatics.com/',
      ),
    ),
    180 => 
    array (
      'name' => 'Speech is Cheap',
      'pattern' => 'speechischeap\\.com',
      'examples' => 
      array (
        0 => 'To be transcribed with Speech is Cheap (https://speechischeap.com)',
        1 => 'speechischeap.com',
      ),
      'urls' => 
      array (
        0 => 'https://speechischeap.com/',
      ),
    ),
    181 => 
    array (
      'name' => 'Spotify cache service',
      'pattern' => '^Spotify/1\\.0$',
      'comments' => 'This useragent, currently simply Spotify/1.0, is used when retrieving the RSS and audio for Spotify\'s catalogue. It isn\'t used for passthru.',
      'examples' => 
      array (
        0 => 'Spotify/1.0',
      ),
    ),
    182 => 
    array (
      'name' => 'Stitcher Bot',
      'pattern' => '^StitcherBot',
    ),
    183 => 
    array (
      'name' => 'Substack Content Fetcher',
      'pattern' => '^SubstackContentFetch/',
      'examples' => 
      array (
        0 => 'SubstackContentFetch/1.0 (https://substack.com/)',
      ),
    ),
    184 => 
    array (
      'name' => 'SupportingCast',
      'pattern' => '^SupportingCast(/.*)?$',
      'examples' => 
      array (
        0 => 'SupportingCast/1.0',
        1 => 'SupportingCast',
      ),
    ),
    185 => 
    array (
      'name' => 'Taddy Podcast API',
      'pattern' => '^Taddy Podcast API ',
      'urls' => 
      array (
        0 => 'https://taddy.org/developers',
      ),
      'examples' => 
      array (
        0 => 'Taddy Podcast API (https://taddy.org/developers)',
      ),
    ),
    186 => 
    array (
      'name' => 'Timpi search crawler',
      'pattern' => 'Timpibot/',
      'examples' => 
      array (
        0 => 'Timpibot/0.8 ( http://www.timpi.io)',
      ),
    ),
    187 => 
    array (
      'name' => 'Tiny Tiny RSS',
      'pattern' => '^Tiny Tiny RSS/',
      'examples' => 
      array (
        0 => 'Tiny Tiny RSS/22.12-c30b24d09 (Unsupported) (https://tt-rss.org/)',
      ),
      'urls' => 
      array (
        0 => 'https://tt-rss.org/',
      ),
      'comments' => 'Found autodownloading hundreds of episodes from an entire feed in rapid succession',
    ),
    188 => 
    array (
      'name' => 'TranscribeServer',
      'pattern' => '^TranscribeServer/\\d',
      'examples' => 
      array (
        0 => 'TranscribeServer/1.0 (com.xiao.TranscribeServer; build:1; macOS 15.2.0) Alamofire/5.10.2',
      ),
    ),
    189 => 
    array (
      'name' => 'Transistor',
      'pattern' => '^Transistor\\.fm/',
      'examples' => 
      array (
        0 => 'Transistor.fm/1.0',
      ),
      'urls' => 
      array (
        0 => 'https://transistor.fm',
      ),
    ),
    190 => 
    array (
      'name' => 'Trendsmap Resolver',
      'pattern' => 'TrendsmapResolver/',
    ),
    191 => 
    array (
      'name' => 'Triton Digital Podcast Sync',
      'pattern' => '^Triton Digital Podcast Sync$',
      'examples' => 
      array (
        0 => 'Triton Digital Podcast Sync',
      ),
    ),
    192 => 
    array (
      'name' => 'TurnitinBot',
      'pattern' => '^Turnitin \\(',
      'urls' => 
      array (
        0 => 'https://www.turnitin.com/robot/crawlerinfo.html',
      ),
      'examples' => 
      array (
        0 => 'Turnitin (https://bit.ly/2UvnfoQ)',
      ),
    ),
    193 => 
    array (
      'name' => 'Twingly Bot',
      'pattern' => 'Twingly Recon;',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Twingly Recon; twingly.com)',
      ),
    ),
    194 => 
    array (
      'name' => 'Twitterbot',
      'pattern' => '^Twitterbot',
    ),
    195 => 
    array (
      'name' => 'Typhoeus',
      'pattern' => '^Typhoeus',
    ),
    196 => 
    array (
      'name' => 'UCast',
      'pattern' => '^UCast/',
      'examples' => 
      array (
        0 => 'UCast/1.0 Podcast Sync (1 subscribers; feed-id=aHR0cHM6Ly9mZWVkcy5idXp6c3Byb3V0LmNvbS8yMDg0OTQucnNzEAEBAD32-0242-42AC-8583-21E9BAD8C544; +http://www.ucastapp.com/)',
      ),
    ),
    197 => 
    array (
      'name' => 'UptimeRobot',
      'pattern' => 'UptimeRobot/\\d',
      'examples' => 
      array (
        0 => 'Mozilla/5.0+(compatible; UptimeRobot/2.0; http://www.uptimerobot.com/)',
      ),
      'urls' => 
      array (
        0 => 'https://uptimerobot.com/',
      ),
    ),
    198 => 
    array (
      'name' => 'TelegramBot',
      'pattern' => '^TelegramBot ',
      'examples' => 
      array (
        0 => 'TelegramBot (like TwitterBot)',
      ),
    ),
    199 => 
    array (
      'name' => 'Transmission',
      'pattern' => '^Transmission/\\d',
      'examples' => 
      array (
        0 => 'Transmission/2.77',
      ),
      'comments' => 'Seen mass-downloading multiple episodes from multiple shows.  Doubt this is the bitttorrent client, but is bot-like nonetheless',
    ),
    200 => 
    array (
      'name' => 'theTradeDesk Content Web Scraper',
      'pattern' => 'TTD-Content',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; TTD-Content; +https://www.thetradedesk.com/general/ttd-content)',
      ),
      'urls' => 
      array (
        0 => 'https://www.thetradedesk.com/us/ttd-content',
      ),
    ),
    201 => 
    array (
      'name' => 'Veritone Engine Toolkit',
      'pattern' => '^veritone/engine-toolkit',
      'urls' => 
      array (
        0 => 'https://machinebox.io/veritone/engine-toolkit',
      ),
      'examples' => 
      array (
        0 => 'veritone/engine-toolkit-3.0',
      ),
    ),
    202 => 
    array (
      'name' => 'Vurbl',
      'pattern' => 'VurblBot',
      'description' => 'An audio streaming destination',
      'urls' => 
      array (
        0 => 'https://vurbl.com/about-us/',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 https://vurbl.com VurblBot/1.0',
      ),
    ),
    203 => 
    array (
      'name' => 'Wget',
      'pattern' => 'Wget',
    ),
    204 => 
    array (
      'name' => 'weborama',
      'pattern' => '^weborama-fetcher',
      'examples' => 
      array (
        0 => 'weborama-fetcher (+http://www.weborama.com)',
      ),
    ),
    205 => 
    array (
      'name' => 'Windows Crawler',
      'pattern' => '^ZDM/.*Windows',
      'examples' => 
      array (
        0 => 'ZDM/4.0; Windows Mobile 7.0;',
      ),
    ),
    206 => 
    array (
      'name' => 'Windows PowerShell',
      'pattern' => 'WindowsPowerShell/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.2673',
      ),
    ),
    207 => 
    array (
      'name' => 'WordPress',
      'pattern' => '^WordPress',
    ),
    208 => 
    array (
      'name' => 'wsrv.nl',
      'pattern' => 'https?://wsrv.nl/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; ImageFetcher/9.0; +http://wsrv.nl/)',
      ),
    ),
    209 => 
    array (
      'name' => 'YaCy',
      'pattern' => '^yacybot',
      'description' => 'Decentralized Web Search',
      'urls' => 
      array (
        0 => 'http://yacy.net/bot.html',
      ),
      'examples' => 
      array (
        0 => 'yacybot (/global; amd64 Linux 5.9.8-zen1-1-zen; java 1.8.0_265; Europe/de) http://yacy.net/bot.html',
      ),
    ),
    210 => 
    array (
      'name' => 'Yahoo Crawler',
      'pattern' => 'Yahoo! Slurp',
      'examples' => 
      array (
        0 => 'Crawler Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)',
      ),
    ),
    211 => 
    array (
      'name' => 'YandexBot',
      'pattern' => 'YandexBot/',
    ),
    212 => 
    array (
      'name' => 'Zapier',
      'pattern' => '^Zapier$',
      'examples' => 
      array (
        0 => 'Zapier',
      ),
    ),
    213 => 
    array (
      'name' => 'Zencast',
      'pattern' => '^Zencastr/',
      'examples' => 
      array (
        0 => 'Zencastr/2.0',
      ),
    ),
    214 => 
    array (
      'name' => 'podwords',
      'pattern' => '^podwordsbot/',
      'examples' => 
      array (
        0 => 'podwordsbot/0.0.1 podwords',
      ),
      'urls' => 
      array (
        0 => 'https://www.facebook.com/podwords',
      ),
    ),
    215 => 
    array (
      'name' => 'Spider',
      'pattern' => 'Spider/\\d.*spider\\.cloud',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; Spider/2.0; +https://spider.cloud)',
      ),
      'urls' => 
      array (
        0 => 'https://spider.cloud',
      ),
    ),
  ),
)    ,
    'apps' => 
array (
  '$schema' => 'https://raw.githubusercontent.com/opawg/user-agents-v2/master/schemas/patterns.schema.json',
  'comments' => 
  array (
    0 => 'Look for User-Agent matches in this file order: \'bots\', \'apps\', \'libraries\', \'browsers\', and return the first entry matched, processing each entry in order in which they appear in the file.',
    1 => 'If the match entry is from this file (i.e. not a bot), you can also match the User-Agent header against the \'devices\' file to identity device and category.',
  ),
  'entries' => 
  array (
    0 => 
    array (
      'name' => 'Abandon',
      'pattern' => 'Abandon/',
      'examples' => 
      array (
        0 => 'Abandon/1.15.28.58.6 CFNetwork/711.3.18 Darwin/14.0.0',
      ),
    ),
    1 => 
    array (
      'name' => 'Acast',
      'pattern' => '^Acast.+([Aa]ndroid|iOS|Darwin)',
      'examples' => 
      array (
        0 => 'Acast/3989 CFNetwork/758.4.3 Darwin/15.5.0',
      ),
    ),
    2 => 
    array (
      'name' => 'Accompany',
      'pattern' => 'Accompany/',
      'examples' => 
      array (
        0 => 'Accompany/462 CFNetwork/758.5.3 Darwin/15.6.0',
      ),
    ),
    3 => 
    array (
      'name' => 'ActiasLuna',
      'pattern' => 'ActiasLuna/',
      'examples' => 
      array (
        0 => 'ActiasLuna/1.1.3 CFNetwork/672.1.14 Darwin/14.0.0',
      ),
    ),
    4 => 
    array (
      'name' => 'ActionExtension',
      'pattern' => 'ActionExtension/',
      'examples' => 
      array (
        0 => 'ActionExtension/154.2.2 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    5 => 
    array (
      'name' => 'Adori',
      'pattern' => '^Adori(-Dev)?/',
      'examples' => 
      array (
        0 => 'Adori/1 CFNetwork/978.0.7 Darwin/18.7.0',
        1 => 'Adori-Dev/7 CFNetwork/974.2.1 Darwin/18.0.0',
      ),
    ),
    6 => 
    array (
      'name' => 'Adori-Listen',
      'pattern' => '^Adori-Listen/',
      'examples' => 
      array (
        0 => 'Adori-Listen/1 CFNetwork/978.0.7 Darwin/18.6.0',
      ),
    ),
    7 => 
    array (
      'name' => 'AdventureChurch',
      'pattern' => '^AdventureChurch/',
      'examples' => 
      array (
        0 => 'AdventureChurch/18 CFNetwork/889.9 Darwin/17.2.0',
      ),
    ),
    8 => 
    array (
      'name' => 'Aftenposten Android app',
      'pattern' => 'Android AP Hermes/',
      'description' => 'Aftenposten Android app',
      'examples' => 
      array (
        0 => 'Android AP Hermes/1000094692 _app_',
      ),
    ),
    9 => 
    array (
      'name' => 'Aftenposten iOS app',
      'pattern' => 'iOS AP Hermes/',
      'description' => 'Aftenposten iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS AP Hermes/90.0.0 _app_',
      ),
    ),
    10 => 
    array (
      'name' => 'Aftonbladet Android app',
      'pattern' => 'Android Aftonbladet Hermes/',
      'description' => 'Aftonbladet Android app',
      'examples' => 
      array (
        0 => 'Android Aftonbladet Hermes/1000094692 _app_',
      ),
    ),
    11 => 
    array (
      'name' => 'Aftonbladet iOS app',
      'pattern' => 'iOS Aftonbladet Hermes/',
      'description' => 'Aftonbladet iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS Aftonbladet Hermes/90.0.0 _app_',
      ),
    ),
    12 => 
    array (
      'name' => 'Agora',
      'pattern' => '^Agora/',
      'examples' => 
      array (
        0 => 'Agora/37 CFNetwork/974.2.1 Darwin/18.0.0',
      ),
    ),
    13 => 
    array (
      'name' => 'AhaRadio',
      'pattern' => '^AhaRadio2/',
      'examples' => 
      array (
        0 => 'AhaRadio2/8.12.3 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    14 => 
    array (
      'name' => 'Airr',
      'pattern' => '^Airr(%20Beta)?/|^Airr \\(',
      'urls' => 
      array (
        0 => 'https://www.airr.io/',
      ),
      'examples' => 
      array (
        0 => 'Airr/3787 CFNetwork/1128.0.1 Darwin/19.6.0',
        1 => 'Airr/4070 CFNetwork/1206 Darwin/20.1.0',
        2 => 'Airr%20Beta/672 CFNetwork/978.0.7 Darwin/18.5.0',
        3 => 'Airr (airr.io)',
      ),
    ),
    15 => 
    array (
      'name' => 'Airsonic',
      'pattern' => '^Airsonic/',
      'urls' => 
      array (
        0 => 'https://airsonic.github.io/',
      ),
      'examples' => 
      array (
        0 => 'Airsonic/11.0.0-SNAPSHOT.20220625052932',
      ),
    ),
    16 => 
    array (
      'name' => 'Aisten - Podcast Transcription',
      'pattern' => '^Aisten/\\d',
      'examples' => 
      array (
        0 => 'Aisten/19 CFNetwork/3826.400.120 Darwin/24.3.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/aisten-podcast-transcription/id6453694910',
      ),
    ),
    17 => 
    array (
      'name' => 'Alexa-enabled device',
      'pattern' => '^AlexaMediaPlayer/[\\dv]|^Echo/|^AlexaService/|^Alexa Mobile Voice/|^Amazon;Echo',
      'svg' => 'amazon.svg',
      'examples' => 
      array (
        0 => 'Echo/1.0(APNG)',
        1 => 'AlexaMediaPlayer/vizzini.locked.38.0 (Linux;Android 5.1.1) ExoPlayerLib/1.5.9',
        2 => 'AlexaService/2.2.303087.0 (Linux;Android 9) ExoPlayerLib/2.8.4',
        3 => 'Alexa Mobile Voice/2.2.2768.0 (Linux;Android 7.0) ExoPlayerLib/2.2.0',
        4 => 'Echo/1.0(MRM)',
        5 => 'Amazon;Echo_Dot;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
        6 => 'Amazon;Echo_Dot_with_clock;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
        7 => 'Amazon;Echo_Show_5;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
        8 => 'Amazon;Echo;27d4dfe427b34d57995b463e5d63198d;;tpapi;3.199.422',
      ),
    ),
    18 => 
    array (
      'name' => 'AlienBlue',
      'pattern' => '^AlienBlue/',
      'examples' => 
      array (
        0 => 'AlienBlue/2.9.7 CFNetwork/808.2.16 Darwin/16.3.0',
      ),
    ),
    19 => 
    array (
      'name' => 'All Daf',
      'pattern' => '^AllDaf/\\d',
      'examples' => 
      array (
        0 => 'AllDaf/1 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/all-daf/id1480151101',
      ),
    ),
    20 => 
    array (
      'name' => 'All You Can Books',
      'pattern' => 'AllYouCanBooks',
      'examples' => 
      array (
        0 => 'AllYouCanBooks/510 CFNetwork/811.5.4 Darwin/16.7.0',
        1 => 'Mozilla/5.0 (Linux; Android 9; CLT-L29 Build/HUAWEICLT-L29; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/75.0.3770.101 Mobile Safari/537.36 AllYouCanBooksAppAndroid',
      ),
    ),
    21 => 
    array (
      'name' => 'AllHitMusicRadio',
      'pattern' => '^AllHitMusicRadio/',
      'examples' => 
      array (
        0 => 'AllHitMusicRadio/1.0 CFNetwork/978.0.7 Darwin/18.5.0',
      ),
    ),
    22 => 
    array (
      'name' => 'All Mishnah',
      'pattern' => '^AllMishna/\\d',
      'examples' => 
      array (
        0 => 'AllMishna/1 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/all-mishnah/id1598932850',
      ),
    ),
    23 => 
    array (
      'name' => 'Aloha',
      'pattern' => '^Aloha/',
      'examples' => 
      array (
        0 => 'Aloha/2 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    24 => 
    array (
      'name' => 'Amazon Fire',
      'pattern' => '^Amazon;AF',
      'examples' => 
      array (
        0 => 'Amazon;AFTT;756a522d9f1648b89e76e80be654456a;;tpapi',
        1 => 'Amazon;AFTSO001;756a522d9f1648b89e76e80be654456a;;tpapi',
        2 => 'Amazon;AFTEAMR311;756a522d9f1648b89e76e80be654456a;;tpapi',
        3 => 'Amazon;AFTEU014;756a522d9f1648b89e76e80be654456a;;tpapi',
      ),
    ),
    25 => 
    array (
      'name' => 'Amazon Music',
      'pattern' => '^AmazonMusic|^Harley/\\d',
      'description' => 'A music and podcasts streaming app',
      'svg' => 'amazon.svg',
      'examples' => 
      array (
        0 => 'AmazonMusic',
        1 => 'AmazonMusic/9.15.2 iPhone7,2 CFNetwork/978.0.7 Darwin/18.7.0',
        2 => 'AmazonMusic/9.16.1 iPhone9,1 CFNetwork/1128.0.1 Darwin/19.6.0',
        3 => 'AmazonMusic/9.16.0 iPhone12,1 CFNetwork/1128.0.1 Darwin/19.6.0',
        4 => 'AmazonMusic/22.13.3 iPad7,3 CFNetwork/1335.0.3 Darwin/21.6.0',
        5 => 'AmazonMusic/16.17.0 Dalvik/2.1.0 (Linux; U; Android 6.0.1; vivo 1610 Build/MMB29M)',
        6 => 'Harley/3.12.0.78 A1CTGXB4BA274T/9.4.0.2386',
        7 => 'Harley/3.11.0.181 A5FPM1T85BR19/9.2.1.2362a',
      ),
      'comments' => 'Harley found coming from the Amazon Music desktop app.',
    ),
    26 => 
    array (
      'name' => 'Ampache',
      'pattern' => '^Ampache/\\d',
      'description' => 'A web based audio/video streaming application and file manager allowing you to access your music & videos from anywhere, using almost any internet enabled device.',
      'examples' => 
      array (
        0 => 'Ampache/6.3.1',
      ),
      'urls' => 
      array (
        0 => 'https://ampache.org/',
      ),
    ),
    27 => 
    array (
      'name' => 'AMPApp',
      'pattern' => '^AMPApp/',
      'examples' => 
      array (
        0 => 'AMPApp/32.6.1 CFNetwork/978.0.7 Darwin/18.6.0',
      ),
    ),
    28 => 
    array (
      'name' => 'Anchor',
      'pattern' => '^Anchor/',
      'examples' => 
      array (
        0 => 'Anchor/9 CFNetwork/901.1 Darwin/17.5.0',
      ),
    ),
    29 => 
    array (
      'name' => 'AnchorFM',
      'pattern' => '^AnchorFM/',
      'examples' => 
      array (
        0 => 'AnchorFM/3.0 (Linux;Android 6.0) ExoPlayerLib/2.5.4',
      ),
    ),
    30 => 
    array (
      'name' => 'Android Browser',
      'pattern' => '\\(Linux; Android \\d*; MHA-AL00 Build/HUAWEIMHA-AL00\\)',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Linux; Android 9; MHA-AL00 Build/HUAWEIMHA-AL00) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Mobile Safari/537.36',
      ),
    ),
    31 => 
    array (
      'name' => 'Anghami',
      'pattern' => 'Anghami/|^Anghami Android|^%D8%A3%D9%86%D8%BA%D8%A7%D9%85%D9%8A/',
      'examples' => 
      array (
        0 => 'Anghami/502044 CFNetwork/1206 Darwin/20.1.0',
        1 => 'Anghami Android 6.1.157 / V 11 (6011570) Google store',
        2 => '%D8%A3%D9%86%D8%BA%D8%A7%D9%85%D9%8A/601041 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
    ),
    32 => 
    array (
      'name' => 'AntennaPod',
      'pattern' => '(^AntennaPod/|^de\\.danoeh\\.antennapod/|antenna/.*CFNetwork)',
      'urls' => 
      array (
        0 => 'https://github.com/AntennaPod/AntennaPod',
      ),
      'comments' => 'The de.danoeh version was used when streaming only, and will been phased out as of v2',
      'examples' => 
      array (
        0 => 'de.danoeh.antennapod/1.7.3b (Linux;Android 8.0.0) ExoPlayerLib/2.9.3',
        1 => 'antenna/19 CFNetwork/711.1.16 Darwin/14.0.0',
      ),
    ),
    33 => 
    array (
      'name' => 'Anybox',
      'pattern' => '^Anybox/',
      'examples' => 
      array (
        0 => 'Anybox/55 CFNetwork/1399.4 Darwin/22.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://anybox.app/',
      ),
    ),
    34 => 
    array (
      'name' => 'Anytime Podcast Player',
      'pattern' => '^Anytime/.*amugofjava',
      'examples' => 
      array (
        0 => 'Anytime/1.2.1 b74 (phone;android QP1A.190711.020.G965USQU9FVB2) https://github.com/amugofjava/anytime_podcast_player',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/amugofjava/anytime_podcast_player',
      ),
      'description' => 'Simple, easy to use Podcast player app written in Flutter and Dart.',
    ),
    35 => 
    array (
      'name' => 'APK Downloader',
      'pattern' => '^APKXDL',
      'examples' => 
      array (
        0 => 'APKXDL (Linux; U; Android 4.4.4;nb_no; trlte/KTU84P) Downloader',
      ),
    ),
    36 => 
    array (
      'name' => 'Apollo',
      'pattern' => '^Apollo/|Apollo Podcasts \\(android\\)',
      'examples' => 
      array (
        0 => 'Apollo/11.28 CFNetwork/1085.4 Darwin/19.0.0',
        1 => 'Apollo Podcasts (android) https://apollopods.com',
      ),
      'urls' => 
      array (
        0 => 'https://apollopods.com/',
      ),
    ),
    37 => 
    array (
      'name' => 'Apple HomePod',
      'description' => 'Playback initiated directly from the device',
      'pattern' => '^AirPodcasts/\\d',
      'examples' => 
      array (
        0 => 'AirPodcasts/4022.700.8 CFNetwork/1410.0.3 Darwin/22.6.0',
        1 => 'AirPodcasts/4022.700.8 CFNetwork/1410.0.2 Darwin/22.6.0',
      ),
      'comments' => 'Verified on HomePod Gen 1 and HomePod Mini. Spelunked in https://twitter.com/_inside/status/969787463613939712 and https://www.theverge.com/2017/7/31/16067710/apple-leaked-homepod-firmware-os-third-party-apps',
    ),
    38 => 
    array (
      'name' => 'Apple iMessage',
      'pattern' => '^MessagesViewService/|^Messages/|^Messages Share Extension/|^MessagesNotificationExtension/',
      'examples' => 
      array (
        0 => 'MessagesViewService/1.0 CFNetwork/1120 Darwin/19.0.0',
        1 => 'Messages/5500 CFNetwork/1098 Darwin/19.0.0 (x86_64)',
        2 => 'Messages Share Extension/5500 CFNetwork/1098 Darwin/19.0.0 (x86_64)',
        3 => 'MessagesNotificationExtension/1 CFNetwork/1098.7 Darwin/19.0.0',
      ),
    ),
    39 => 
    array (
      'name' => 'Apple Mail',
      'pattern' => '^Mail/',
      'examples' => 
      array (
        0 => 'Mail/1283 CFNetwork/520.5.1 Darwin/11.4.2 (x86_64) (MacBookPro5%2C4)',
      ),
    ),
    40 => 
    array (
      'name' => 'Apple News',
      'pattern' => 'AppleNews/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (iPad; CPU OS 12_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) AppleNews/2166 Version/4.4',
      ),
    ),
    41 => 
    array (
      'name' => 'Apple Podcasts',
      'pattern' => '^Podcasts/.*|^Balados/|^Podcasti/|^Podcastit/|^Podcasturi/|^Podcasty/|^Podcast’ler/|^Podcast%E2%80%99ler/|^Podkaster/|^Podcaster/.*\\(.*\\)|^Podcastok/|^Подкасти/|^Подкасты/|^פודקאסטים/|^البودكاست/|^पॉडकास्ट/|^พ็อดคาสท์/|^播客/|^팟캐스트/|ポッドキャスト/|^%D8%A7%D9%84%D8%A8%D9%88%D8%AF%D9%83%D8%A7%D8%B3%D8%AA/|^%D0%9F%D0%BE%D0%B4%D0%BA%D0%B0%D1%81%D1%82%D1%8B/|^%D0%9F%D0%BE%D0%B4%D0%BA%D0%B0%D1%81%D1%82%D0%B8/|^Podcastok/|^%D7%A4%D7%95%D7%93%D7%A7%D7%90%D7%A1%D7%98%D7%99%D7%9D/|^%ED%8C%9F%EC%BA%90%EC%8A%A4%ED%8A%B8/|^%D8%A7%D9%95%D8%B3%D9%85%D8%B9%D9%84%D9%8A/|^Podcaster/\\d|^%E6%92%AD%E5%AE%A2/|^%E3%83%9D%E3%83%83%E3%83%89%E3%82%AD%E3%83%A3%E3%82%B9%E3%83%88/|^Podcast/|^%E0%B8%9E%E0%B9%87%E0%B8%AD%E0%B8%94%E0%B8%84%E0%B8%B2%E0%B8%AA%E0%B8%97%E0%B9%8C/\\d|%D0%9F%D0%BE%D0%B4%D0%BA%D0%B0%D1%81%D1%82%D1%82%D0%B0%D1%80/\\d|^%E0%A4%AA%E0%A5%89%E0%A4%A1%E0%A4%95%E0%A4%BE%E0%A4%B8%E0%A5%8D%E0%A4%9F/\\d',
      'description' => 'The Apple Podcasts app.',
      'comments' => 'This could be on iOS, iPadOS or macOS. Used when downloading podcasts (not progressive downloads), with support for the following languages: Arabic, Chinese, Finnish, French, English, Hebrew, Hindi, Hungarian, Korean, Polish, Romanian, Russian, Serbian, Slovenian, Swedish, Thai, Turkish.',
      'examples' => 
      array (
        0 => 'Podcasts/1410.53 CFNetwork/1111 Darwin/19.0.0 (x86_64)',
        1 => 'Podcaster/1410.53 CFNetwork/1111 Darwin/19.0.0 (x86_64)',
        2 => 'البودكاست/1530.3 CFNetwork/1209 Darwin/20.2.0',
        3 => 'พ็อดคาสท์/1440.4 CFNetwork/1126 Darwin/19.5.0',
        4 => 'ポッドキャスト/1709.2.2 CFNetwork/1390 Darwin/22.0.0',
        5 => 'פודקאסטים/1420.35 CFNetwork/1120 Darwin/19.0.0',
        6 => 'Подкасти/1520.39 CFNetwork/1206 Darwin/20.1.0',
        7 => '%D8%A7%D9%84%D8%A8%D9%88%D8%AF%D9%83%D8%A7%D8%B3%D8%AA/1410.25.1 CFNetwork/1107.1 Darwin/19.0.0',
        8 => 'Подкасты/1520.39 CFNetwork/1206 Darwin/20.1.0',
        9 => '%D0%9F%D0%BE%D0%B4%D0%BA%D0%B0%D1%81%D1%82%D1%8B/1410.25.1 CFNetwork/1107.1 Darwin/19.0.0',
        10 => '%D0%9F%D0%BE%D0%B4%D0%BA%D0%B0%D1%81%D1%82%D0%B8/1410.25.1 CFNetwork/1107.1 Darwin/19.0.0',
        11 => 'Podcastok/1410.25.1 CFNetwork/1107.1 Darwin/19.0.0',
        12 => '%D7%A4%D7%95%D7%93%D7%A7%D7%90%D7%A1%D7%98%D7%99%D7%9D/1410.25.1 CFNetwork/1107.1 Darwin/19.0.0',
        13 => '%ED%8C%9F%EC%BA%90%EC%8A%A4%ED%8A%B8/1410.25.1 CFNetwork/1107.1 Darwin/19.0.0',
        14 => '%D8%A7%D9%95%D8%B3%D9%85%D8%B9%D9%84%D9%8A/1.0 CFNetwork/609.1.4 Darwin/13.0.0',
        15 => 'पॉडकास्ट/1709.2.2 CFNetwork/1390 Darwin/22.0.0',
        16 => '播客/1709.2.2 CFNetwork/1390 Darwin/22.0.0',
        17 => '팟캐스트/1709.2.2 CFNetwork/1390 Darwin/22.0.0',
        18 => 'Podcasty/1709.2.2 CFNetwork/1390 Darwin/22.0.0',
        19 => 'Podcaster/1660.5 CFNetwork/1335.0.3 Darwin/21.6.0',
        20 => 'Podcaster/1709.2.2 CFNetwork/1390 Darwin/22.0.0',
        21 => '%E6%92%AD%E5%AE%A2/1660.5 CFNetwork/1335.0.3 Darwin/21.6.0',
        22 => '%E3%83%9D%E3%83%83%E3%83%89%E3%82%AD%E3%83%A3%E3%82%B9%E3%83%88/1709.2.2 CFNetwork/1390 Darwin/22.0.0',
        23 => 'Podcastit/1660.5 CFNetwork/1335.0.3 Darwin/21.6.0',
        24 => 'Podkaster/1710.17 CFNetwork/1399 Darwin/22.1.0',
        25 => 'Balados/1660.5 CFNetwork/1335.0.3 Darwin/21.6.0',
        26 => 'Podcast/1660.5 CFNetwork/1335.0.3 Darwin/21.6.0',
        27 => 'Podcast%E2%80%99ler/1710.17 CFNetwork/1399 Darwin/22.1.0',
        28 => '%E0%B8%9E%E0%B9%87%E0%B8%AD%E0%B8%94%E0%B8%84%E0%B8%B2%E0%B8%AA%E0%B8%97%E0%B9%8C/4022.300.6 CFNetwork/1402.0.8 Darwin/22.2.0',
        29 => '%D0%9F%D0%BE%D0%B4%D0%BA%D0%B0%D1%81%D1%82%D1%82%D0%B0%D1%80/4022.510.4 CFNetwork/1406.0.4 Darwin/22.4.0',
        30 => '%E0%A4%AA%E0%A5%89%E0%A4%A1%E0%A4%95%E0%A4%BE%E0%A4%B8%E0%A5%8D%E0%A4%9F/4022.300.6 CFNetwork/1402.0.8 Darwin/22.2.0',
      ),
    ),
    42 => 
    array (
      'name' => 'Apple Reminders',
      'pattern' => '^Recordatorios/',
      'examples' => 
      array (
        0 => 'Recordatorios/2466 CFNetwork/1329 Darwin/21.3.0',
      ),
    ),
    43 => 
    array (
      'name' => 'Arabian Business',
      'pattern' => '^Arabian%20Business/\\d',
      'examples' => 
      array (
        0 => 'Arabian%20Business/21687 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/arabian-business/id1466594419',
      ),
    ),
    44 => 
    array (
      'name' => 'ARD Audiothek',
      'pattern' => '^ARD Audiothek|^ARD%20Audiothek/|^ARD-Audiothek',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=de.ard.audiothek',
        1 => 'https://apps.apple.com/de/app/ard-audiothek/id1224607890',
      ),
      'examples' => 
      array (
        0 => 'ARD Audiothek/2.15.1 (Google Play) Dalvik/2.1.0 (Linux; U; Android 13; FP4 Build/TKQ1.230127.002)/2.15.1 (Linux;Android 13) AndroidXMedia3/1.2.1',
        1 => 'ARD%20Audiothek/93 CFNetwork/1494.0.7 Darwin/23.4.0',
        2 => 'ARD Audiothek iOS Version 2.6.11, Build 90',
        3 => 'ARD-Audiothek/31',
      ),
    ),
    45 => 
    array (
      'name' => 'Arte Radio',
      'pattern' => '^arteradio/',
      'description' => 'Arte Radio is a podcast app',
      'examples' => 
      array (
        0 => 'arteradio/1.1.1 Android/12',
        1 => 'arteradio/1.1.1 iOS/12',
      ),
    ),
    46 => 
    array (
      'name' => 'Arvocast',
      'pattern' => '^Arvocast/',
      'examples' => 
      array (
        0 => 'Arvocast/3752 CFNetwork/1404.0.5 Darwin/22.3.0',
      ),
    ),
    47 => 
    array (
      'name' => 'Askoyvaringen iOS app',
      'pattern' => 'iOS Askoyvaringen Hermes/',
      'description' => 'Askoyvaringen iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS Askoyvaringen Hermes/90.0.0 _app_',
      ),
    ),
    48 => 
    array (
      'name' => 'Audacious',
      'pattern' => '^Audacious',
      'description' => 'Audacious is an open source audio player.',
      'urls' => 
      array (
        0 => 'https://audacious-media-player.org/',
      ),
      'examples' => 
      array (
        0 => 'Audacious/3.10.1 neon/0.30.2',
      ),
    ),
    49 => 
    array (
      'name' => 'Audacy',
      'pattern' => '^Radio\\.com/|^Audacy \\d',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.radiocom&hl=en_US',
      ),
      'examples' => 
      array (
        0 => 'Radio.com/12.2.0 (com.cbsradio.cbsradioplayer; build:1; iOS 14.6.0) Alamofire/4.8.1',
        1 => 'Audacy 16.11.0 / Android',
      ),
    ),
    50 => 
    array (
      'name' => 'Audials',
      'pattern' => '^com\\.audials(\\.paid)?/',
      'examples' => 
      array (
        0 => 'com.audials/9.52.0-0+gb3764950b-1058878988 (Linux;Android 11) AndroidXMedia3/1.1.1',
        1 => 'com.audials.paid/9.54.2-0+gd5b7eebd0-1117772855 (Linux;Android 14) AndroidXMedia3/1.2.0',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.audials',
      ),
    ),
    51 => 
    array (
      'name' => 'Audible',
      'pattern' => '(^com\\.audible\\.playersdk\\.player|^Audible,|^Audible.*Darwin)',
    ),
    52 => 
    array (
      'name' => 'Audio',
      'pattern' => '^Audio/',
      'examples' => 
      array (
        0 => 'Audio/105 CFNetwork/548.1.4 Darwin/11.0.0',
      ),
    ),
    53 => 
    array (
      'name' => 'Audio Now',
      'pattern' => '^Android_AudioNow',
      'urls' => 
      array (
        0 => 'https://audionow.de/',
      ),
      'examples' => 
      array (
        0 => 'Android_AudioNow',
      ),
    ),
    54 => 
    array (
      'name' => 'audiobookshelf',
      'pattern' => '^audiobookshelf',
      'urls' => 
      array (
        0 => 'https://www.audiobookshelf.org/guides/podcasts/',
      ),
      'examples' => 
      array (
        0 => 'audiobookshelf (+https://audiobookshelf.org)',
      ),
    ),
    55 => 
    array (
      'name' => 'AudioWave',
      'pattern' => '(^AudioWave/1|^AudioWave iOS)',
      'urls' => 
      array (
        0 => 'https://apps.apple.com/be/app/audiowave-podcast-player/id1602776751',
      ),
      'examples' => 
      array (
        0 => 'AudioWave/1.5 (+https://audiowave.io/; iPhone 15.4)',
        1 => 'AudioWave iOS',
      ),
    ),
    56 => 
    array (
      'name' => 'Audirvāna Studio',
      'pattern' => 'Audirv%C4%81na%20Studio/\\d',
      'examples' => 
      array (
        0 => 'Audirv%C4%81na%20Studio/20906 CFNetwork/1568.300.101 Darwin/24.2.0',
      ),
      'urls' => 
      array (
        0 => 'https://audirvana.com/audirvana-studio-key-features-overview/',
      ),
    ),
    57 => 
    array (
      'name' => 'Aural',
      'pattern' => '^Aural/',
      'examples' => 
      array (
        0 => 'Aural/1.3 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    58 => 
    array (
      'name' => 'Aurora',
      'pattern' => '^Aurora/',
      'examples' => 
      array (
        0 => 'Aurora/175 CFNetwork/758.4.3 Darwin/15.5.0',
      ),
    ),
    59 => 
    array (
      'name' => 'Autopod',
      'pattern' => '^Autopod/',
      'examples' => 
      array (
        0 => 'Autopod/0 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    60 => 
    array (
      'name' => 'avassetReader',
      'pattern' => '^avassetReader/',
      'examples' => 
      array (
        0 => 'avassetReader/1 CFNetwork/887 Darwin/17.0.0',
      ),
    ),
    61 => 
    array (
      'name' => 'avopodo',
      'pattern' => '^avopodo/',
      'examples' => 
      array (
        0 => 'avopodo/2 CFNetwork/975.0.3 Darwin/18.2.0',
      ),
    ),
    62 => 
    array (
      'name' => 'AVPlay',
      'pattern' => '^AVPlay/',
      'examples' => 
      array (
        0 => 'AVPlay/2 CFNetwork/811.5.4 Darwin/16.7.0',
      ),
    ),
    63 => 
    array (
      'name' => 'Awasu',
      'pattern' => '^Awasu/',
      'examples' => 
      array (
        0 => 'Awasu/3.2PE',
      ),
      'urls' => 
      array (
        0 => 'https://awasu.com/',
      ),
      'comments' => 'Feed reader for Windows',
    ),
    64 => 
    array (
      'name' => 'Azul',
      'pattern' => '^Azul/',
      'examples' => 
      array (
        0 => 'Azul/5.8 CFNetwork/711.1.16 Darwin/14.0.0',
      ),
    ),
    65 => 
    array (
      'name' => 'Babbel',
      'pattern' => '^Babbel/\\d',
      'examples' => 
      array (
        0 => 'Babbel/66695 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/babbel-language-learning/id829587759',
      ),
    ),
    66 => 
    array (
      'name' => 'BaladoQuebec',
      'pattern' => '^BaladoQuebec/',
      'examples' => 
      array (
        0 => 'BaladoQuebec/1 CFNetwork/808.2.16 Darwin/16.3.0',
      ),
    ),
    67 => 
    array (
      'name' => 'Banter',
      'pattern' => '^Banter/|^banter-beta/',
      'examples' => 
      array (
        0 => 'Banter/1.20.7 CFNetwork/897.15 Darwin/17.5.0',
        1 => 'banter-beta/1.14.2 CFNetwork/893.14.2 Darwin/17.3.0',
      ),
    ),
    68 => 
    array (
      'name' => 'Barabbas Road Church',
      'pattern' => '^Barabbas Road Church/',
      'examples' => 
      array (
        0 => 'Barabbas Road Church/4.9.5 CFNetwork/1098.7 Darwin/19.0.0',
      ),
    ),
    69 => 
    array (
      'name' => 'BashPodder',
      'pattern' => '^BashPodder',
      'urls' => 
      array (
        0 => 'http://lincgeek.org/bashpodder/',
      ),
    ),
    70 => 
    array (
      'name' => 'BBC iPlayer',
      'pattern' => '^BBCiPlayer/',
      'examples' => 
      array (
        0 => 'BBCiPlayer/4.75.0.1 (iPad2,5; iPhone OS 9.3.5) BBCSMP/36.2.0 BBCHTTPClient/8.0.2',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=bbc.iplayer.android&hl=en_US',
        1 => 'https://apps.apple.com/gb/app/bbc-iplayer/id416580485',
      ),
    ),
    71 => 
    array (
      'name' => 'BBC iPlayer Radio',
      'pattern' => 'BBCiPlayerRadio/',
      'urls' => 
      array (
        0 => 'https://www.bbc.co.uk/programmes/p00zh17p',
      ),
      'examples' => 
      array (
        0 => 'BBCiPlayerRadio/2.16.0.8764 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    72 => 
    array (
      'name' => 'BBC Sounds',
      'pattern' => 'BBC%20Sounds/',
      'urls' => 
      array (
        0 => 'https://www.bbc.co.uk/sounds/help/questions/getting-started-with-bbc-sounds/sounds-intro',
      ),
      'examples' => 
      array (
        0 => 'BBC%20Sounds/1.13.1.7716 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    73 => 
    array (
      'name' => 'Bear',
      'pattern' => '^Bear/',
      'examples' => 
      array (
        0 => 'Bear/5702 CFNetwork/811.8 Darwin/16.7.0 (x86_64)',
      ),
    ),
    74 => 
    array (
      'name' => 'Behind the Knife',
      'pattern' => '^BehindTheKnife/\\d',
      'examples' => 
      array (
        0 => 'BehindTheKnife/1.0.31+142/Android',
        1 => 'BehindTheKnife/1.0.31+142/iOS',
      ),
      'urls' => 
      array (
        0 => 'https://behindtheknife.org/',
      ),
    ),
    75 => 
    array (
      'name' => 'Bergens Tidende Android app',
      'pattern' => 'Android BT Hermes/',
      'description' => 'Bergens Tidende Android app',
      'examples' => 
      array (
        0 => 'Android BT Hermes/1000094692 _app_',
      ),
    ),
    76 => 
    array (
      'name' => 'Bergens Tidende iOS app',
      'pattern' => 'iOS BT Hermes/',
      'description' => 'Bergens Tidende iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS BT Hermes/90.0.0 _app_',
      ),
    ),
    77 => 
    array (
      'name' => 'BeyondPod',
      'pattern' => '; BeyondPod',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Linux; U; en-us; BeyondPod 4)',
      ),
    ),
    78 => 
    array (
      'name' => 'bgwnr',
      'pattern' => '^bgwnr/',
      'examples' => 
      array (
        0 => 'bgwnr/3300 CFNetwork/975.0.3 Darwin/18.0.0',
      ),
    ),
    79 => 
    array (
      'name' => 'Bible',
      'pattern' => '^Bible/',
      'examples' => 
      array (
        0 => 'Bible/11 CFNetwork/978.0.7 Darwin/18.6.0',
      ),
    ),
    80 => 
    array (
      'name' => 'Bitcast',
      'pattern' => '^Bitcast(\\.fm)?/|^bitcast 4 reel/|^bitcastbitcast/',
      'urls' => 
      array (
        0 => 'https://bitcast.fm/',
      ),
      'examples' => 
      array (
        0 => 'Bitcast/336 CFNetwork/1197 Darwin/20.0.0',
        1 => 'Bitcast.fm/104 CFNetwork/1126 Darwin/19.5.0',
        2 => 'bitcast 4 reel/47 CFNetwork/1121.2.1 Darwin/19.3.0',
        3 => 'bitcastbitcast/45 CFNetwork/1121.2.2 Darwin/19.3.0',
      ),
    ),
    81 => 
    array (
      'name' => 'Bitly',
      'pattern' => '^Bitly/',
      'examples' => 
      array (
        0 => 'Bitly/445 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    82 => 
    array (
      'name' => 'BizCoachPal',
      'pattern' => '^BizCoachPal/',
      'examples' => 
      array (
        0 => 'BizCoachPal/1.5.7.24.4 CFNetwork/711.0.6 Darwin/14.0.0',
      ),
    ),
    83 => 
    array (
      'name' => 'BMR',
      'pattern' => '^BMR/',
      'examples' => 
      array (
        0 => 'BMR/1 CFNetwork/902.2 Darwin/17.7.0',
      ),
    ),
    84 => 
    array (
      'name' => 'Bolt',
      'pattern' => '^Bolt/',
      'examples' => 
      array (
        0 => 'Bolt/10 CFNetwork/1098.7 Darwin/19.0.0',
      ),
    ),
    85 => 
    array (
      'name' => 'Bookmobile',
      'pattern' => '^Bookmobile/',
      'examples' => 
      array (
        0 => 'Bookmobile/1 CFNetwork/894 Darwin/17.4.0',
      ),
    ),
    86 => 
    array (
      'name' => 'Bookself',
      'pattern' => '^Bookself/',
      'examples' => 
      array (
        0 => 'Bookself/1 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    87 => 
    array (
      'name' => 'Boom',
      'pattern' => '^Boom/',
      'examples' => 
      array (
        0 => 'Boom/1.3.110001 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    88 => 
    array (
      'name' => 'Boomplay',
      'pattern' => '^Boomplay( Lite)?/\\d',
      'examples' => 
      array (
        0 => 'Boomplay/5.1.5 (iPhone; iOS 12.4.7; Scale/3.00)',
        1 => 'Boomplay Lite/1.3.0 (iPhone; iOS 12.5.7; Scale/3.00)',
      ),
      'urls' => 
      array (
        0 => 'https://www.boomplay.com/',
      ),
    ),
    89 => 
    array (
      'name' => 'Bose SoundTouch',
      'pattern' => '^Bose/',
    ),
    90 => 
    array (
      'name' => 'bPod',
      'pattern' => '^bPod$',
      'examples' => 
      array (
        0 => 'bPod',
      ),
    ),
    91 => 
    array (
      'name' => 'Breaker',
      'pattern' => '^Breaker/',
    ),
    92 => 
    array (
      'name' => 'Breez',
      'pattern' => '^breez/',
      'examples' => 
      array (
        0 => 'breez/5585.1 CFNetwork/1402 Darwin/22.2.0',
      ),
    ),
    93 => 
    array (
      'name' => 'BrewApp',
      'pattern' => '^BrewApp/',
      'examples' => 
      array (
        0 => 'BrewApp/262 CFNetwork/975.0.3 Darwin/18.2.0',
      ),
    ),
    94 => 
    array (
      'name' => 'Broadcast',
      'pattern' => '^Broadcast/',
      'examples' => 
      array (
        0 => 'Broadcast/1.0 CFNetwork/893.14.2 Darwin/17.3.0',
      ),
    ),
    95 => 
    array (
      'name' => 'Broadway Podcast Network',
      'pattern' => 'BroadwayPodcastNetwork/iOS',
      'description' => 'The Broadway Podcast Network iOS App',
      'examples' => 
      array (
        0 => 'BroadwayPodcastNetwork/iOS',
      ),
    ),
    96 => 
    array (
      'name' => 'Browser',
      'pattern' => '^Browser/',
      'examples' => 
      array (
        0 => 'Browser/21060 CFNetwork/887 Darwin/17.0.0',
      ),
    ),
    97 => 
    array (
      'name' => 'Browser iOS',
      'pattern' => '^browser_ios/',
      'examples' => 
      array (
        0 => 'browser_ios/19100.2.142 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    98 => 
    array (
      'name' => 'BrowserPlus',
      'pattern' => '^BrowserPlus/',
      'examples' => 
      array (
        0 => 'BrowserPlus/21066 CFNetwork/978.0.7 Darwin/18.5.0',
      ),
    ),
    99 => 
    array (
      'name' => 'Bullhorn',
      'pattern' => '^Bullhorn(/.*)?$|^Bullhorn \\(',
      'urls' => 
      array (
        0 => 'http://bullhorn.fm/',
      ),
      'examples' => 
      array (
        0 => 'Bullhorn/1.0 (+http://bullhorn.fm/)',
        1 => 'Bullhorn',
        2 => 'Bullhorn (https://bullhorn.fm)',
        3 => 'Bullhorn/1 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
    ),
    100 => 
    array (
      'name' => 'Bygdanytt iOS app',
      'pattern' => 'iOS Bygdanytt Hermes/',
      'description' => 'Bygdanytt iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS Bygdanytt Hermes/90.0.0 _app_',
      ),
    ),
    101 => 
    array (
      'name' => 'CampfireFM',
      'pattern' => '^Campfire/',
      'description' => 'CampfireFM',
      'examples' => 
      array (
        0 => 'Campfire/2.0.2 (Build 123) Android/15 (SDK 35)',
        1 => 'Campfire/2.0.2 (Build 123) iOS/18.5.0',
      ),
      'urls' => 
      array (
        0 => 'https://joincampfire.fm/',
        1 => 'https://play.google.com/store/apps/details?id=fm.joincampfire.campfire',
        2 => 'https://apps.apple.com/app/id1673471223',
      ),
    ),
    102 => 
    array (
      'name' => 'Canvas',
      'pattern' => '^Canvas/',
      'examples' => 
      array (
        0 => 'Canvas/7369 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    103 => 
    array (
      'name' => 'Capital',
      'pattern' => '^Capital/',
      'examples' => 
      array (
        0 => 'Capital/1528207522 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    104 => 
    array (
      'name' => 'capsule.fm',
      'pattern' => '^capsule\\.fm/|^capsule-android',
      'examples' => 
      array (
        0 => 'capsule.fm/1 CFNetwork/976 Darwin/18.2.0',
        1 => 'capsule-android',
      ),
    ),
    105 => 
    array (
      'name' => 'Cast',
      'pattern' => '^Cast/',
      'examples' => 
      array (
        0 => 'Cast/1031 CFNetwork/711.4.6 Darwin/14.0.0',
      ),
    ),
    106 => 
    array (
      'name' => 'Castamatic',
      'pattern' => '^Castamatic/',
      'description' => 'Your new favorite podcast player for iOS devices',
      'urls' => 
      array (
        0 => 'https://castamatic.com',
      ),
      'examples' => 
      array (
        0 => 'Castamatic/3847 CFNetwork/1240.0.4 Darwin/20.6.0',
        1 => 'Castamatic/5.1.4 (com.gunpmedia.Castamatic; build:3136; iOS 13.1.3) Alamofire/4.9.0',
      ),
    ),
    107 => 
    array (
      'name' => 'Castaway',
      'pattern' => '^Castaway/',
      'examples' => 
      array (
        0 => 'Castaway/8 CFNetwork/1098.7 Darwin/19.0.0',
      ),
    ),
    108 => 
    array (
      'name' => 'CastBox',
      'pattern' => '^Cast[Bb]ox|^fm\\.castbox\\.',
      'examples' => 
      array (
        0 => 'CastBox/8.2.6-191015245 (Linux;Android 10) ExoPlayerLib/2.10.4',
        1 => 'CastBox/8.19.0-200927161 (Linux;Android 10) ExoPlayerLib/2.10.4',
        2 => 'CastBox/8.18.1-200917153 (Linux;Android 8.0.0) ExoPlayerLib/2.10.4',
        3 => 'CastBox/8.5.1 (fm.castbox.audiobook.radio.podcast; build:11; iOS 13.1.2)',
        4 => 'CastBox/5.7.5-190508115.r1a805d3',
        5 => 'CastBox/10.1.0-221129106 (Linux;Android 10) ExoPlayerLib/2.10.4, CastBox/10.1.0-221129106 (Linux;Android 10) ExoPlayerLib/2.10.4, CastBox/10.1.0-221129106 (Linux;Android 10) ExoPlayerLib/2.10.4',
        6 => 'fm.castbox.audiobook.radio.podcast/240611306 (Linux; U; Android 13; en_GB; Lenovo TB125FU; Build/TP1A.220624.014; Cronet/126.0.6423.0)',
      ),
    ),
    109 => 
    array (
      'name' => 'Casterbate',
      'pattern' => '^Casterbate/',
      'examples' => 
      array (
        0 => 'Casterbate/1 CFNetwork/744.5 Darwin/14.4.0',
      ),
    ),
    110 => 
    array (
      'name' => 'castero',
      'pattern' => '^castero \\d',
      'description' => 'castero is a TUI podcast client for the terminal',
      'examples' => 
      array (
        0 => 'castero 0.9.5 <https://github.com/xgi/castero>',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/xgi/castero',
      ),
    ),
    111 => 
    array (
      'name' => 'castget',
      'pattern' => '^castget ',
      'urls' => 
      array (
        0 => 'https://castget.johndal.com/',
      ),
      'examples' => 
      array (
        0 => 'castget 1.2.4 (castget rss enclosure downloader)',
      ),
    ),
    112 => 
    array (
      'name' => 'Castro',
      'pattern' => '^Castro[/ ]',
      'examples' => 
      array (
        0 => 'Castro 2019.13/1167',
        1 => 'Castro 2020.14/1287',
        2 => 'Castro/1024 CFNetwork/955.1.2 Darwin/18.0.0',
      ),
    ),
    113 => 
    array (
      'name' => 'Casts',
      'pattern' => '^Casts/',
      'examples' => 
      array (
        0 => 'Casts/652 CFNetwork/758.2.8 Darwin/15.0.0',
      ),
    ),
    114 => 
    array (
      'name' => 'CCGF',
      'pattern' => '^CCGF/',
      'examples' => 
      array (
        0 => 'CCGF/4.4.1 CFNetwork/758.5.3 Darwin/15.6.0',
      ),
    ),
    115 => 
    array (
      'name' => 'CEBrowser',
      'pattern' => '^CEBrowser/',
      'examples' => 
      array (
        0 => 'CEBrowser/2.5.2.4 CFNetwork/711.1.12 Darwin/14.0.0',
      ),
    ),
    116 => 
    array (
      'name' => 'České Podcasty',
      'pattern' => '^cz\\.ceskeappky\\.podcasty',
      'examples' => 
      array (
        0 => 'cz.ceskeappky.podcasty',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=cz.ceskeappky.podcasty&hl=cs',
      ),
    ),
    117 => 
    array (
      'name' => 'CFC',
      'pattern' => '^CFC/',
      'examples' => 
      array (
        0 => 'CFC/1 CFNetwork/711.3.18 Darwin/14.0.0',
      ),
    ),
    118 => 
    array (
      'name' => 'CHCLeaders',
      'pattern' => '^CHCLeaders/',
      'examples' => 
      array (
        0 => 'CHCLeaders/11 CFNetwork/894 Darwin/17.4.0',
      ),
    ),
    119 => 
    array (
      'name' => 'Childress',
      'pattern' => '^Childress/',
      'examples' => 
      array (
        0 => 'Childress/1 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    120 => 
    array (
      'name' => 'chorus',
      'pattern' => '^chorus/',
      'examples' => 
      array (
        0 => 'chorus/698 CFNetwork/811.5.4 Darwin/16.6.0',
      ),
    ),
    121 => 
    array (
      'name' => 'Christian Life Austin',
      'pattern' => '^Christian Life Austin/',
      'examples' => 
      array (
        0 => 'Christian Life Austin/4.9.4 CFNetwork/893.14.2 Darwin/17.3.0',
      ),
    ),
    122 => 
    array (
      'name' => 'Chromecast device',
      'pattern' => 'CrKey/|\\(CrKey |^Google;Chromecast',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (CrKey armv7l 1.8.17977) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.0 Safari/537.36',
        1 => 'Google;ChromecastHD;756a522d9f1648b89e76e80be654456a;;tpapi;3.200.454',
      ),
    ),
    123 => 
    array (
      'name' => 'ChurchLink',
      'pattern' => '^ChurchLink/',
      'examples' => 
      array (
        0 => 'ChurchLink/110519 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    124 => 
    array (
      'name' => 'Cinemo Infotainment System',
      'pattern' => '^Cinemo/\\d| Cinemo/\\d',
      'examples' => 
      array (
        0 => 'Cinemo/2023.w35.004.p005100.9fbde87f',
        1 => 'Cinemo/2021.w49.039.p001025.bebbed45',
        2 => 'gcc_linux_MIB3Premium_esolutions_CLU35/1.0 Cinemo/2020.27.9.0',
        3 => 'gcc_linux_wayland_aarch64_pcc_mib3_eu/1.0 Cinemo/1.252.7.100516',
      ),
      'urls' => 
      array (
        0 => 'https://www.cinemo.com/products-and-services/cinemo-core/',
      ),
    ),
    125 => 
    array (
      'name' => 'Clammr',
      'pattern' => '^Clammr/',
      'examples' => 
      array (
        0 => 'Clammr/5 CFNetwork/758.3.15 Darwin/15.4.0',
      ),
    ),
    126 => 
    array (
      'name' => 'Claro música radio',
      'pattern' => '^Claro Musica iOS/\\d',
      'examples' => 
      array (
        0 => 'Claro Musica iOS/13.2.18-13.2.18 CFNetwork/1.0 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/claro-m%C3%BAsica-radio/id1437327586',
      ),
    ),
    127 => 
    array (
      'name' => 'Client',
      'pattern' => '^Client/',
      'examples' => 
      array (
        0 => 'Client/16042 CFNetwork/1098.7 Darwin/19.0.0',
      ),
    ),
    128 => 
    array (
      'name' => 'Clementine Music Player',
      'pattern' => '^Clementine ',
      'urls' => 
      array (
        0 => 'https://www.clementine-player.org/',
      ),
    ),
    129 => 
    array (
      'name' => 'Club',
      'pattern' => '^Club/',
      'examples' => 
      array (
        0 => 'Club/126 CFNetwork/672.1.15 Darwin/14.0.0',
      ),
    ),
    130 => 
    array (
      'name' => 'Commotion',
      'pattern' => '^Commotion/',
      'examples' => 
      array (
        0 => 'Commotion/3.0.79 CFNetwork/609 Darwin/13.0.0',
      ),
    ),
    131 => 
    array (
      'name' => 'Cooler',
      'pattern' => '^CoolerFM/',
      'examples' => 
      array (
        0 => 'CoolerFM/1.0 iPhone/15 +https://cooler.fm',
      ),
      'urls' => 
      array (
        0 => 'https://cooler.fm',
      ),
    ),
    132 => 
    array (
      'name' => 'Copied',
      'pattern' => '^Copied/',
      'examples' => 
      array (
        0 => 'Copied/142 CFNetwork/760.2.6 Darwin/15.2.0 (x86_64)',
      ),
    ),
    133 => 
    array (
      'name' => 'CoreDataPlayerSample',
      'pattern' => '^CoreDataPlayerSample/',
      'examples' => 
      array (
        0 => 'CoreDataPlayerSample/1 CFNetwork/975.0.3 Darwin/17.7.0',
      ),
    ),
    134 => 
    array (
      'name' => 'Corriere della Sera',
      'pattern' => '^Corriere della Sera/\\d',
      'examples' => 
      array (
        0 => 'Corriere della Sera/7.49.0 (iPhone14,5; iOS 18.1.1;)',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/corriere-della-sera/id371701657',
      ),
    ),
    135 => 
    array (
      'name' => 'Cosmicast',
      'pattern' => '^Cosmicast/',
      'examples' => 
      array (
        0 => 'Cosmicast/1 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    136 => 
    array (
      'name' => 'CPod',
      'pattern' => 'CPod/',
      'description' => 'A simple, beautiful podcast app, for Windows, MacOS and Linux',
      'urls' => 
      array (
        0 => 'https://github.com/z-------------/CPod',
      ),
      'examples' => 
      array (
        0 => 'CPod/1.27.1 (github.com/z-------------)',
      ),
    ),
    137 => 
    array (
      'name' => 'Crosspoint City Church',
      'pattern' => '^Crosspoint City Church/',
      'examples' => 
      array (
        0 => 'Crosspoint City Church/4.12.5 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    138 => 
    array (
      'name' => 'Crosspointe',
      'pattern' => '^Crosspointe/',
      'examples' => 
      array (
        0 => 'Crosspointe/1 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    139 => 
    array (
      'name' => 'CrossPreach',
      'pattern' => '^CrossPreach/',
      'examples' => 
      array (
        0 => 'CrossPreach/1.3 CFNetwork/711.1.16 Darwin/14.0.0',
      ),
    ),
    140 => 
    array (
      'name' => 'Damus',
      'pattern' => '^damus|%D8%AF%D8%A7%D9%85%D9%8F%D8%B3|%E8%BE%BE%E6%91%A9/',
      'examples' => 
      array (
        0 => 'damus/24 CFNetwork/1406.0.4 Darwin/22.4.0',
        1 => '%D8%AF%D8%A7%D9%85%D9%8F%D8%B3/1 CFNetwork/1498.700.2 Darwin/23.6.0',
        2 => '%E8%BE%BE%E6%91%A9/1 CFNetwork/1474 Darwin/23.0.0',
      ),
    ),
    141 => 
    array (
      'name' => 'DAN Podcast App',
      'pattern' => '^DAN Podcast/\\d',
      'examples' => 
      array (
        0 => 'DAN Podcast/2024.07.09',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/dan-podcast-app/id1562075864',
      ),
    ),
    142 => 
    array (
      'name' => 'DataDogApp',
      'pattern' => '^DataDogApp/',
      'examples' => 
      array (
        0 => 'DataDogApp/0.8.12 CFNetwork/811.5.4 Darwin/16.6.0',
      ),
    ),
    143 => 
    array (
      'name' => 'DaumWebtoon',
      'pattern' => '^DaumWebtoon/',
      'examples' => 
      array (
        0 => 'DaumWebtoon/1 CFNetwork/975.0.3 Darwin/18.2.0',
      ),
    ),
    144 => 
    array (
      'name' => 'De Standaard',
      'pattern' => 'be\\.standaard\\.audio|^DS%20Podcast/',
      'examples' => 
      array (
        0 => 'DS podcast/1.0.5 (be.standaard.audio; build:6; Android 12; Sdk:31; Manufacturer:samsung; Model: SM-A415F) OkHttp/4.9.1',
        1 => 'DS%20Podcast/2 CFNetwork/1410.0.3 Darwin/22.6.0',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=be.standaard.audio',
        1 => 'https://apps.apple.com/us/app/ds-podcast/id1555712044',
      ),
    ),
    145 => 
    array (
      'name' => 'Deezer',
      'pattern' => '(^Deezer/|^DeezerJukebox/|^Deezer.*Electron)',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=deezer.android.app',
        1 => 'https://apps.apple.com/us/app/deezer-music-podcast-player/id292738169',
      ),
      'examples' => 
      array (
        0 => 'Deezer/6.2.2.80 (Android; 9; Mobile; fr) samsung SM-G950F',
        1 => 'Deezer/6.2.3.96 (Android; 10; Mobile; fr) samsung SM-A405FN',
        2 => 'DeezerJukebox/6.2.26.58 (Linux;Android 10) ExoPlayerLib/2.12.1',
        3 => 'Deezer/8.13.0.4 CFNetwork/1125.2 Darwin/19.4.0',
        4 => 'Deezer/4.20.0 (Electron; windows/10.0.18362; Desktop; fr)',
        5 => 'Deezer/4.20.0 (Electron; osx/10.14.6; Desktop; fr)',
      ),
    ),
    146 => 
    array (
      'name' => 'Delve',
      'pattern' => '^Delve/',
      'examples' => 
      array (
        0 => 'Delve/41 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    147 => 
    array (
      'name' => 'DevCasts',
      'pattern' => '^devcasts/.*CFNetwork',
      'description' => 'Our Devcasts app is a new kind of podcast listening app. It is simply the best way for developers to enjoy all of the excellent podcast content created for developers.',
      'urls' => 
      array (
        0 => 'http://devcasts.co/',
      ),
      'examples' => 
      array (
        0 => 'devcasts/1.0.1.00 CFNetwork/1197 Darwin/20.0.0',
      ),
    ),
    148 => 
    array (
      'name' => 'Dlf Audiothek',
      'pattern' => '^DlfAudiothek/|^Dlf Audiothek',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=de.deutschlandfunk.dlfaudiothek',
        1 => 'https://apps.apple.com/de/app/dlf-audiothek/id1255398824',
      ),
      'examples' => 
      array (
        0 => 'Dlf Audiothek; version:2.5.4(2023061301); bundle:de.deutschlandfunk.dlfaudiothek; iOS 17.4.1',
        1 => 'Dlf Audiothek/2.5.6 (Linux; U; Android 13; FP3 Build/6.A.025.0)',
        2 => 'DlfAudiothek/3.0.3 (iPhone; iOS 17.4.1)',
      ),
    ),
    149 => 
    array (
      'name' => 'DManager',
      'pattern' => '^DManager/',
      'examples' => 
      array (
        0 => 'DManager/27 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    150 => 
    array (
      'name' => 'Documents',
      'pattern' => '^Documents/',
      'examples' => 
      array (
        0 => 'Documents/6.9.8.634 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    151 => 
    array (
      'name' => 'DoggCatcher',
      'pattern' => 'DoggCatcher',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Linux; U; Windows NT 6.1; en-us; dream) DoggCatcher',
      ),
    ),
    152 => 
    array (
      'name' => 'DolphiniPad',
      'pattern' => '^Dolphini(Pad|Phone)/',
      'examples' => 
      array (
        0 => 'DolphiniPad/9000144 CFNetwork/758.5.3 Darwin/15.6.0',
        1 => 'DolphiniPhone/9000005 CFNetwork/758.0.2 Darwin/15.0.0',
      ),
    ),
    153 => 
    array (
      'name' => 'Dosis Diaria',
      'pattern' => '^Dosis Diaria/\\d',
      'examples' => 
      array (
        0 => 'Dosis Diaria/1.1.8 (com.elministerioroka.Dosis-Diaria; build:12; iOS 18.1.1) Alamofire/4.8.2',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/dosis-diaria/id6466759396',
      ),
    ),
    154 => 
    array (
      'name' => 'doubleTwist CloudPlayer',
      'pattern' => '^doubleTwist CloudPlayer',
      'urls' => 
      array (
        0 => 'https://www.doubletwist.com/cloudplayer',
      ),
      'examples' => 
      array (
        0 => 'doubleTwist CloudPlayer',
      ),
    ),
    155 => 
    array (
      'name' => 'Doughnut',
      'pattern' => '^Doughnut/',
      'examples' => 
      array (
        0 => 'Doughnut/1666453501 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
      'urls' => 
      array (
        0 => 'https://doughnutapp.com/',
      ),
    ),
    156 => 
    array (
      'name' => 'Downcast',
      'pattern' => 'Downcast/',
      'examples' => 
      array (
        0 => 'Downcast/2.9.42 (iPhone; iOS 12.4.1; Scale/3.00)',
        1 => 'Downcast/2.9.57 (iPad; iOS 14.2; Scale/2.00)',
        2 => 'Downcast/2.9.57 (Mac OS X Version 10.15.7 (Build 19H15))',
      ),
    ),
    157 => 
    array (
      'name' => 'Downie',
      'pattern' => '^Downie/',
      'examples' => 
      array (
        0 => 'Downie/1108 CFNetwork/760.2.6 Darwin/15.2.0 (x86_64)',
      ),
    ),
    158 => 
    array (
      'name' => 'DownloadAll',
      'pattern' => '^DownloadAll/',
      'examples' => 
      array (
        0 => 'DownloadAll/1.0.3 CFNetwork/672.1.13 Darwin/14.0.0',
      ),
    ),
    159 => 
    array (
      'name' => 'Downloader',
      'pattern' => '^Downloader/',
      'examples' => 
      array (
        0 => 'Downloader/1.0.0 CFNetwork/711.3.18 Darwin/14.0.0',
      ),
    ),
    160 => 
    array (
      'name' => 'DownloaderLite',
      'pattern' => '^DownloaderLite/',
      'examples' => 
      array (
        0 => 'DownloaderLite/1.0 CFNetwork/672.1.14 Darwin/14.0.0',
      ),
    ),
    161 => 
    array (
      'name' => 'DownloaderSound',
      'pattern' => '^DownloaderSound/',
      'examples' => 
      array (
        0 => 'DownloaderSound/1.4 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    162 => 
    array (
      'name' => 'Download Shuttle',
      'pattern' => '^Download Shuttle/',
      'examples' => 
      array (
        0 => 'Download Shuttle/24 CFNetwork/1082.2 Darwin/19.0.0 (x86_64)',
      ),
    ),
    163 => 
    array (
      'name' => 'DownloadPro',
      'pattern' => '^DownloadPro/',
      'examples' => 
      array (
        0 => 'DownloadPro/1.0.1 CFNetwork/672.0.8 Darwin/14.0.0',
      ),
    ),
    164 => 
    array (
      'name' => 'Downloads',
      'pattern' => '^Downloads/',
      'examples' => 
      array (
        0 => 'Downloads/20375 CFNetwork/1098.7 Darwin/19.0.0',
      ),
    ),
    165 => 
    array (
      'name' => 'DownMan',
      'pattern' => '^DownMan/',
      'examples' => 
      array (
        0 => 'DownMan/3.0.1 CFNetwork/609 Darwin/13.0.0',
      ),
    ),
    166 => 
    array (
      'name' => 'DowntonAppy',
      'pattern' => '^DowntonAppy/',
      'examples' => 
      array (
        0 => 'DowntonAppy/1382280772 CFNetwork/548.0.4 Darwin/11.0.0',
      ),
    ),
    167 => 
    array (
      'name' => 'DriveCast',
      'pattern' => '^DriveCast/',
      'examples' => 
      array (
        0 => 'DriveCast/2.9 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    168 => 
    array (
      'name' => 'DRN1',
      'pattern' => '^DRN1;',
      'urls' => 
      array (
        0 => 'https://www.drn1.com.au/',
        1 => 'https://www.drn1.com',
      ),
      'examples' => 
      array (
        0 => 'DRN1; iPhone; iOS 17.4.1',
        1 => 'DRN1; Android; Samsung 17.4.1',
        2 => 'DRN1; Website; Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.4.1 Safari/605.1.15',
      ),
    ),
    169 => 
    array (
      'name' => 'DroolRadio',
      'pattern' => '^DroolRadio/',
      'examples' => 
      array (
        0 => 'DroolRadio/38 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    170 => 
    array (
      'name' => 'Dynamo',
      'pattern' => '^Dynamo/',
      'examples' => 
      array (
        0 => 'Dynamo/1.0',
      ),
    ),
    171 => 
    array (
      'name' => 'E24 Android app',
      'pattern' => 'Android E24 Hermes/',
      'description' => 'E24 Android app',
      'examples' => 
      array (
        0 => 'Android E24 Hermes/1000094692 _app_',
      ),
    ),
    172 => 
    array (
      'name' => 'E24 iOS app',
      'pattern' => 'iOS E24 Hermes/',
      'description' => 'E24 iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS E24 Hermes/90.0.0 _app_',
      ),
    ),
    173 => 
    array (
      'name' => 'Earbud',
      'pattern' => '^Earbud/',
      'examples' => 
      array (
        0 => 'Earbud/0 CFNetwork/758.4.3 Darwin/15.5.0',
      ),
    ),
    174 => 
    array (
      'name' => 'Earmark',
      'description' => 'Earmark is a free, audio-based continuing professional education app for accounting and tax professionals.',
      'pattern' => '^Earmark/',
      'examples' => 
      array (
        0 => 'Earmark/1.0 Android',
        1 => 'Earmark/1.0 iOS',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/earmark/id1562599728',
        1 => 'https://play.google.com/store/apps/details?id=com.earmarkcpe.app',
      ),
    ),
    175 => 
    array (
      'name' => 'EasyGet',
      'pattern' => '^EasyGet/',
      'examples' => 
      array (
        0 => 'EasyGet/1.0.70 CFNetwork/672.1.13 Darwin/14.0.0',
      ),
    ),
    176 => 
    array (
      'name' => 'Economist Espresso',
      'pattern' => '^TheEconomist-Darwin-',
      'examples' => 
      array (
        0 => 'TheEconomist-Darwin-android-2.1.1-master-2999-2001024',
        1 => 'TheEconomist-Darwin-ios-2.1.1-master-2999-2001024',
      ),
    ),
    177 => 
    array (
      'name' => 'Elevation Health',
      'pattern' => '^Elevation_Health/',
      'examples' => 
      array (
        0 => 'Elevation_Health/2.9 CFNetwork/672.1.14 Darwin/14.0.0',
      ),
    ),
    178 => 
    array (
      'name' => 'EMAudioPlayer',
      'pattern' => '^EMAudioPlayer ',
      'examples' => 
      array (
        0 => 'EMAudioPlayer 2.9.7 (720) / Android 6.0.1 / MotoG3',
      ),
    ),
    179 => 
    array (
      'name' => 'Emacs',
      'pattern' => '^URL/Emacs ',
      'examples' => 
      array (
        0 => 'URL/Emacs Emacs/28.2 (TTY; x86_64-pc-linux-gnu)',
      ),
    ),
    180 => 
    array (
      'name' => 'Encounter',
      'pattern' => '^Encounter/',
      'examples' => 
      array (
        0 => 'Encounter/1 CFNetwork/711.3.18 Darwin/14.0.0',
      ),
    ),
    181 => 
    array (
      'name' => 'EpisodeFever',
      'pattern' => '^EpisodeFever/',
      'examples' => 
      array (
        0 => 'EpisodeFever/21 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    182 => 
    array (
      'name' => 'EQu',
      'pattern' => '^EQu/',
      'examples' => 
      array (
        0 => 'EQu/14101 CFNetwork/711.1.12 Darwin/14.0.0',
      ),
    ),
    183 => 
    array (
      'name' => 'EvanApp',
      'pattern' => '^EvanApp/',
      'examples' => 
      array (
        0 => 'EvanApp/1 CFNetwork/897.15 Darwin/17.5.0',
      ),
    ),
    184 => 
    array (
      'name' => 'Everand',
      'pattern' => '^Everand/\\d|^everand-android/',
      'examples' => 
      array (
        0 => 'Everand/167 CFNetwork/1568.200.51 Darwin/24.1.0',
        1 => 'everand-android/15.18 (Linux;Android 14) AndroidXMedia3/1.4.1',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/everand-ebooks-and-audiobooks/id542557212',
      ),
    ),
    185 => 
    array (
      'name' => 'Expo',
      'pattern' => '^Expo/',
      'examples' => 
      array (
        0 => 'Expo/2.11.1.106175 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    186 => 
    array (
      'name' => 'ExtDownloader',
      'pattern' => '^ExtDownloader/',
      'examples' => 
      array (
        0 => 'ExtDownloader/5.0.2 CFNetwork/758.2.8 Darwin/15.0.0',
      ),
    ),
    187 => 
    array (
      'name' => 'ExtraCloud',
      'pattern' => '^ExtraCloud/',
      'examples' => 
      array (
        0 => 'ExtraCloud/1.3 CFNetwork/758.2.8 Darwin/15.0.0',
      ),
    ),
    188 => 
    array (
      'name' => 'Facebook',
      'pattern' => '(iPhone|iPad).* \\[FBAN|iOS/Facebook|^FB4A/Facebook|^facebook-mobile/|^Facebook/|^\\[FBAN/|  MetaIAB| IABMV/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_8 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 [FBAN/FBIOS;FBDV/iPhone7,2;FBMD/iPhone;FBSN/iOS;FBSV/12.4.8;FBSS/2;FBID/phone;FBLC/de_DE;FBOP/5]',
        1 => 'iOS/Facebook',
        2 => 'FB4A/Facebook',
        3 => 'Mozilla/5.0 (iPad; CPU OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 [FBAN/FBIOS;FBDV/iPad6,12;FBMD/iPad;FBSN/iOS;FBSV/12.3.1;FBSS/2;FBID/tablet;FBLC/en_GB;FBOP/5;FBCR/EE]',
        4 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 11_0_1 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Mobile/15A402 [FBAN/FBIOS;FBAV/188.0.0.44.85;FBBV/123253203;FBDV/iPhone7,2;FBMD/iPhone;FBSN/iOS;FBSV/11.0.1;FBSS/2;FBCR/3DK;FBID/phone;FBLC/da_DK;FBOP/5;FBRV',
        5 => 'facebook-mobile/1.0',
        6 => 'Facebook/180461199 CFNetwork/1107.1 Darwin/19.0.0',
        7 => '[FBAN/FB4A;FBAV/180.0.0.35.82;FBBV/116984898;FBDM/{density=1.5,width=480,height=854};FBLC/en_US;FBRV/0;FBCR/Verizon Wireless;FBMF/ZTE;FBBD/ZTE;FBPN/com.facebook.katana;FBDV/Z899VL;FBSV/7.1.1;FBOP/19;FBCA/armeabi-v7a:armeabi;]',
        8 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/22F76  MetaIAB',
        9 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Instagram 394.0.0.19.73 (iPhone15,3; iOS 18_6_1; en_US; en; scale=3.00; 1290x2796; IABMV/1; 778482215) Mobile/22G90',
      ),
    ),
    189 => 
    array (
      'name' => 'faidr',
      'pattern' => '^CFR%20Plus/',
      'examples' => 
      array (
        0 => 'CFR%20Plus/9 CFNetwork/1406.0.4 Darwin/22.4.0',
      ),
      'urls' => 
      array (
        0 => 'https://auddia.com/faidr-app/',
      ),
      'comments' => 'Android is streaming only, sends: Dalvik/2.1.0 (Linux; U; Android 11; Pixel 2 Build/RP1A.201005.004.A1)',
    ),
    190 => 
    array (
      'name' => 'FaithPlay',
      'pattern' => '^FaithPlay FaithPlay/',
      'examples' => 
      array (
        0 => 'FaithPlay FaithPlay/1.1.5 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    191 => 
    array (
      'name' => 'Fallound',
      'pattern' => '^Fallound/',
      'examples' => 
      array (
        0 => 'Fallound/16 CFNetwork/975.0.3 Darwin/18.2.0',
      ),
    ),
    192 => 
    array (
      'name' => 'FancyMusic',
      'pattern' => '^FancyMusic/',
      'examples' => 
      array (
        0 => 'FancyMusic/2 CFNetwork/758.1.6 Darwin/15.0.0',
      ),
    ),
    193 => 
    array (
      'name' => 'Fathom',
      'pattern' => '^Fathom/',
      'examples' => 
      array (
        0 => 'Fathom/5 CFNetwork/1406.0.2 Darwin/22.4.0',
      ),
      'urls' => 
      array (
        0 => 'https://fathom.fm',
      ),
    ),
    194 => 
    array (
      'name' => 'Feeder',
      'pattern' => '^Feeder/',
      'examples' => 
      array (
        0 => 'Feeder/2785 CFNetwork/720.5.7 Darwin/14.5.0 (x86_64)',
      ),
    ),
    195 => 
    array (
      'name' => 'Feedly',
      'pattern' => '^feedly/',
      'description' => 'An RSS reader',
      'examples' => 
      array (
        0 => 'feedly/81.0.1 CFNetwork/1206 Darwin/20.1.0',
      ),
    ),
    196 => 
    array (
      'name' => 'FeedStation',
      'pattern' => '^FeedStation/\\d',
      'urls' => 
      array (
        0 => 'https://download.cnet.com/FeedStation/3000-2164_4-10699428.html',
      ),
      'examples' => 
      array (
        0 => 'FeedStation/4.5 (http://www.newsgator.com/; Microsoft Windows)',
      ),
    ),
    197 => 
    array (
      'name' => 'Fellowship Bible Church Topeka',
      'pattern' => '^Fellowship Bible Church Topeka/',
      'examples' => 
      array (
        0 => 'Fellowship Bible Church Topeka/4.9.2 CFNetwork/811.5.4 Darwin/16.7.0',
      ),
    ),
    198 => 
    array (
      'name' => 'Filebox',
      'pattern' => '^Filebox/',
      'examples' => 
      array (
        0 => 'Filebox/2.7.3 CFNetwork/811.4.18 Darwin/16.5.0',
      ),
    ),
    199 => 
    array (
      'name' => 'FileBrowser',
      'pattern' => '^FileBrowser/',
      'examples' => 
      array (
        0 => 'FileBrowser/3 CFNetwork/758.4.3 Darwin/15.5.0',
      ),
    ),
    200 => 
    array (
      'name' => 'Filer',
      'pattern' => '^Filer/',
      'examples' => 
      array (
        0 => 'Filer/351 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    201 => 
    array (
      'name' => 'Files',
      'pattern' => '^Files/',
      'examples' => 
      array (
        0 => 'Files/1.0 CFNetwork/758.3.15 Darwin/15.4.0',
      ),
    ),
    202 => 
    array (
      'name' => 'FilesPro',
      'pattern' => '^FilesPro/',
      'examples' => 
      array (
        0 => 'FilesPro/646 CFNetwork/711.1.16 Darwin/14.0.0',
      ),
    ),
    203 => 
    array (
      'name' => 'Fili',
      'pattern' => '^Fili/',
      'examples' => 
      array (
        0 => 'Fili/3617 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    204 => 
    array (
      'name' => 'Flash',
      'pattern' => '(^MAC |^WIN )',
    ),
    205 => 
    array (
      'name' => 'folkebladet.no',
      'pattern' => '^folkebladet\\.no/',
      'examples' => 
      array (
        0 => 'folkebladet.no/252 CFNetwork/811.5.4 Darwin/16.7.0',
      ),
    ),
    206 => 
    array (
      'name' => 'FocusPodcast',
      'pattern' => '^FocusPodcast_',
      'urls' => 
      array (
        0 => 'https://www.focus.hk.cn/',
        1 => 'https://github.com/allentown521/FocusPodcast',
      ),
      'examples' => 
      array (
        0 => 'FocusPodcast_2.8.1.20240715',
      ),
    ),
    207 => 
    array (
      'name' => 'foobar2000',
      'pattern' => '^foobar2000/',
      'urls' => 
      array (
        0 => 'https://www.foobar2000.org/',
      ),
      'examples' => 
      array (
        0 => 'foobar2000/1.x',
      ),
    ),
    208 => 
    array (
      'name' => 'Fountain',
      'pattern' => '^Fountain|^fountainapp/\\d',
      'urls' => 
      array (
        0 => 'https://www.fountain.fm',
      ),
      'examples' => 
      array (
        0 => 'Fountain/0.2.6 iOS https://www.fountain.fm\'',
        1 => 'Fountain/0.3.8 ios https://www.fountain.fm',
        2 => 'Fountain/0.2.6 Android https://www.fountain.fm\'',
        3 => 'Fountain/0.3.13 android https://www.fountain.fm',
        4 => 'fountainapp/565 CFNetwork/1399 Darwin/22.1.0',
      ),
    ),
    209 => 
    array (
      'name' => 'Free Download Manager',
      'pattern' => '^FDM/|^FDM \\d',
      'examples' => 
      array (
        0 => 'FDM/5.1.38.7312',
        1 => 'FDM 3.x',
      ),
      'urls' => 
      array (
        0 => 'https://www.freedownloadmanager.org/download.htm',
      ),
    ),
    210 => 
    array (
      'name' => 'FreeMP3MusicDownload',
      'pattern' => '^FreeMP3MusicDownload/',
      'examples' => 
      array (
        0 => 'FreeMP3MusicDownload/1.5 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    211 => 
    array (
      'name' => 'freemusic',
      'pattern' => '^freemusic/',
      'examples' => 
      array (
        0 => 'freemusic/2.3 CFNetwork/609 Darwin/13.0.0',
      ),
    ),
    212 => 
    array (
      'name' => 'FreeMusicDownloadPro',
      'pattern' => '^FreeMusicDownloadPro/',
      'examples' => 
      array (
        0 => 'FreeMusicDownloadPro/1.8 CFNetwork/711.1.16 Darwin/14.0.0',
      ),
    ),
    213 => 
    array (
      'name' => 'FreeMusicPlusFree',
      'pattern' => '^FreeMusicPlusFree/',
      'examples' => 
      array (
        0 => 'FreeMusicPlusFree/2.5 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    214 => 
    array (
      'name' => 'Fréquence Plus',
      'pattern' => '^FrequencePlus/',
      'examples' => 
      array (
        0 => 'FrequencePlus/2.1.1 (Linux;Android 12) ExoPlayerLib/2.15.0',
      ),
      'urls' => 
      array (
        0 => 'https://www.frequenceplus.fr',
      ),
    ),
    215 => 
    array (
      'name' => 'Gaana',
      'pattern' => '^GaanaAndroid-|^Gaana-iOS|^Gaana/',
      'examples' => 
      array (
        0 => 'GaanaAndroid-8.13.0/Dalvik/2.1.0 (Linux; U; Android 9; vivo 1906 Build/PKQ1.190616.001)',
        1 => 'GaanaAndroid-8.13.0/Dalvik/2.1.0 (Linux; U; Android 5.1; Micromax P701 Build/LMY47D)',
        2 => 'Gaana-iOS',
        3 => 'Gaana/1768 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    216 => 
    array (
      'name' => 'Garmin fenix',
      'pattern' => '^Garmin fenix ',
      'comments' => 'This uses Spotify to transfer audio to compatible watches',
      'examples' => 
      array (
        0 => 'Garmin fenix 5X Plus/18.0',
        1 => 'Garmin fenix 6 Pro/26.0',
        2 => 'Garmin fenix 6X Sapphire/26.0',
      ),
      'urls' => 
      array (
        0 => 'https://www.garmin.com/en-US/p/865925',
      ),
    ),
    217 => 
    array (
      'name' => 'Garmin Forerunner',
      'pattern' => '^Garmin Forerunner',
      'comments' => 'This uses Spotify to transfer audio to compatible watches',
      'examples' => 
      array (
        0 => 'Garmin Forerunner 245 Music/11.60',
      ),
    ),
    218 => 
    array (
      'name' => 'Garmin tactix',
      'pattern' => '^Garmin tactix',
      'comments' => 'This uses Spotify to transfer audio to compatible watches',
      'examples' => 
      array (
        0 => 'Garmin tactix Delta/26.0',
      ),
    ),
    219 => 
    array (
      'name' => 'Garmin Venu',
      'pattern' => '^Garmin Venu ',
      'comments' => 'This uses Spotify to transfer audio to compatible watches',
      'examples' => 
      array (
        0 => 'Garmin Venu 2S/17.4',
      ),
    ),
    220 => 
    array (
      'name' => 'Garmin Vivoactive',
      'pattern' => '^Garmin v',
      'comments' => 'This uses Spotify to transfer audio to compatible watches',
      'examples' => 
      array (
        0 => 'Garmin vivoactive 3 Music/6.30',
      ),
    ),
    221 => 
    array (
      'name' => 'GBEngine',
      'pattern' => '^GBEngine/',
      'examples' => 
      array (
        0 => 'GBEngine/1.2 CFNetwork/672.1.14 Darwin/14.0.0',
      ),
    ),
    222 => 
    array (
      'name' => 'GMB Show',
      'pattern' => '^GMB Show/',
      'examples' => 
      array (
        0 => 'GMB Show/1.2.0 (iPad; iOS 9.3.2; Scale/2.00)',
      ),
    ),
    223 => 
    array (
      'name' => 'Godcaster',
      'pattern' => '^Godcaster',
      'examples' => 
      array (
        0 => 'Godcaster app 1.0',
        1 => 'GodcasterApp/android/v1.13.0',
        2 => 'GodcasterApp/v1.18.0 (ios)',
        3 => 'GodcasterApp/v1.22 (android)',
      ),
      'urls' => 
      array (
        0 => 'https://godcaster.fm/',
      ),
    ),
    224 => 
    array (
      'name' => 'Godster',
      'pattern' => '^Godster/',
      'examples' => 
      array (
        0 => 'Godster/2.0.6 (Linux;Android 9) ExoPlayerLib/2.8.3',
      ),
    ),
    225 => 
    array (
      'name' => 'GoldenPod',
      'pattern' => '^GoldenPod/',
      'examples' => 
      array (
        0 => 'GoldenPod/0.8.4 (GNU/Linux; podcatcher; Using LWP) libwwwperl',
      ),
    ),
    226 => 
    array (
      'name' => 'GoLoud',
      'pattern' => '^GoLoud/',
      'examples' => 
      array (
        0 => 'GoLoud/1092 CFNetwork/978.0.7 Darwin/18.6.0',
      ),
    ),
    227 => 
    array (
      'name' => 'Goodpods',
      'pattern' => 'Goodpods\\.|^[Gg]oodpods/',
      'description' => 'The social podcasting app',
      'svg' => 'goodpods.svg',
      'urls' => 
      array (
        0 => 'https://www.goodpods.com/',
      ),
      'examples' => 
      array (
        0 => 'Goodpods.Android / 2.2.2',
        1 => 'Goodpods.Android / 3.2.9',
        2 => 'Goodpods.iOS / 2.2.2',
        3 => 'Goodpods/1 CFNetwork/1329 Darwin/21.3.0',
        4 => 'goodpods/1 CFNetwork/1107.1 Darwin/18.7.0',
        5 => 'Goodpods/3 CFNetwork/1128.0.1 Darwin/19.6.0',
      ),
    ),
    228 => 
    array (
      'name' => 'GoodReader',
      'pattern' => '^GoodReader(4|IPad)?/',
      'examples' => 
      array (
        0 => 'GoodReader/3.17.1 CFNetwork/548.1.4 Darwin/11.0.0',
        1 => 'GoodReader4/100 CFNetwork/711.3.18 Darwin/14.0.0',
        2 => 'GoodReaderIPad/3.20.0 CFNetwork/711.3.18 Darwin/14.0.0',
      ),
    ),
    229 => 
    array (
      'name' => 'Google Assistant',
      'pattern' => '^Google-Speech-Actions',
      'urls' => 
      array (
        0 => 'https://cloud.google.com/text-to-speech/docs/ssml',
      ),
      'comments' => 'This is audio downloaded as a result of a Google Assistant voice action. It\'s unlikely to appear in podcast host logs, since voice actions can only use up to 120 seconds of audio.',
    ),
    230 => 
    array (
      'name' => 'Google Nest Hub',
      'pattern' => '(Fuchsia).* CrKey/',
    ),
    231 => 
    array (
      'name' => 'Google Podcasts',
      'pattern' => '(GoogleChirp|^GooglePodcasts/|^Podcasts$|GSA/)',
      'examples' => 
      array (
        0 => 'GooglePodcasts/2.0.2 iPod_touch/13.4.1 hw/iPod9_1',
        1 => 'GooglePodcasts/2.0.10 iPhone/14.6 hw/iPhone12_1',
        2 => 'GooglePodcasts/2.0.10 iPhone/14.6 hw/iPhone13_3',
        3 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) GSA/107.0.310639584 Mobile/15E148 Safari/604.1',
        4 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) GSA/166.0.381336632 Mobile/15E148 Safari/604.1',
        5 => 'Mozilla/5.0 (iPod touch; CPU iPhone OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) GSA/107.0.310639584 Mobile/15E148 Safari/601.1',
        6 => 'GSA/13.38.11.26.arm64',
        7 => 'Mozilla/5.0 (Linux; Android 10; Pixel 3a Build/QQ2A.200305.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.149 Mobile Safari/537.36 GSA/11.2.7.21.arm64',
        8 => 'Mozilla/5.0 (Linux; Android 10; SM-G986U Build/QP1A.190711.020; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/86.0.4240.75 Mobile Safari/537.36 GSA/11.31.12.21.arm64',
      ),
    ),
    232 => 
    array (
      'name' => 'gPodder',
      'pattern' => '^gPodder/|^gpodder\\.net|gpodder',
      'urls' => 
      array (
        0 => 'http://gpodder.org/',
      ),
      'examples' => 
      array (
        0 => 'gPodder/3.10.8 (+http://gpodder.org/) Windows/10',
        1 => 'gPodder/3.10.21 (+http://gpodder.org/) Linux',
        2 => 'gPodder/3.10.15 (+http://gpodder.org/) Linux/5.4.0-74-generic',
        3 => 'gPodder/3.10.15 (+http://gpodder.org/) Linux/5.4.0-90-generic',
        4 => 'gPodder/3.10.17 (+http://gpodder.org/) Linux/5.11.0-49-generic',
        5 => 'mygpo-feedservice +http://feeds.gpodder.net/',
        6 => 'Detlef/1 (https://github.com/gpodder/detlef/',
      ),
    ),
    233 => 
    array (
      'name' => 'Grace Community Church - Texas',
      'pattern' => '^Grace%20Community%20Church%20-%20Texas/',
      'examples' => 
      array (
        0 => 'Grace%20Community%20Church%20-%20Texas/4.4.0 CFNetwork/672.1.15 Darwin/14.0.0',
      ),
    ),
    234 => 
    array (
      'name' => 'Grace Evangelical Covenant Church',
      'pattern' => '^Grace%20Evangelical%20Covenant%20Church/',
      'examples' => 
      array (
        0 => 'Grace%20Evangelical%20Covenant%20Church/4.9.2 CFNetwork/893.14.2 Darwin/17.3.0',
      ),
    ),
    235 => 
    array (
      'name' => 'Gretale',
      'pattern' => '^Gretale/',
      'examples' => 
      array (
        0 => 'Gretale/207 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    236 => 
    array (
      'name' => 'GroupMe',
      'pattern' => '^GroupMe/',
      'examples' => 
      array (
        0 => 'GroupMe/5.33.1.1 CFNetwork/1098.7 Darwin/19.0.0',
      ),
    ),
    237 => 
    array (
      'name' => 'Guardian',
      'pattern' => '^Guardian-iOSLive/|GuardianAndroidApp/|^Guardian Podcast',
      'examples' => 
      array (
        0 => 'Guardian Podcast-2018.10.14',
      ),
    ),
    238 => 
    array (
      'name' => 'Guacamole',
      'pattern' => '^Guacamole/',
      'examples' => 
      array (
        0 => 'Guacamole/1528207522 CFNetwork/811.5.4 Darwin/16.7.0',
      ),
    ),
    239 => 
    array (
      'name' => 'GrabRadioWorld',
      'pattern' => '^GrabRadioWorld/',
      'examples' => 
      array (
        0 => 'GrabRadioWorld/3.9 CFNetwork/758.2.8 Darwin/15.0.0',
      ),
    ),
    240 => 
    array (
      'name' => 'HalfTunes',
      'pattern' => '^HalfTunes/',
      'examples' => 
      array (
        0 => 'HalfTunes/7 CFNetwork/893.14 Darwin/16.7.0',
      ),
    ),
    241 => 
    array (
      'name' => 'Hammel',
      'pattern' => '^Hammel/',
      'examples' => 
      array (
        0 => 'Hammel/1.5 CFNetwork/976 Darwin/18.2.0',
      ),
    ),
    242 => 
    array (
      'name' => 'HardCast',
      'pattern' => '^HardCast/',
      'examples' => 
      array (
        0 => 'HardCast/11 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    243 => 
    array (
      'name' => 'Hark Audio',
      'pattern' => '^Hark/',
      'urls' => 
      array (
        0 => 'https://harkaudio.com/',
      ),
      'examples' => 
      array (
        0 => 'Hark/10678 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
    ),
    244 => 
    array (
      'name' => 'Headliner',
      'pattern' => '^Headliner/.*\\(Headliner-.*\\+https://www\\.headliner\\.app\\)$',
      'description' => 'Variety of tools to help promote and drive listens to a podcast.',
      'urls' => 
      array (
        0 => 'https://play.headliner.app/',
        1 => 'https://www.headliner.app/publisher-widgets/',
      ),
      'examples' => 
      array (
        0 => 'Headliner/1.0.0 (Headliner-Play/1.0.0; +https://www.headliner.app)',
        1 => 'Headliner/1.0.0 (Headliner-Disco/1.0.0; +https://www.headliner.app)',
      ),
    ),
    245 => 
    array (
      'name' => 'Heard.FM',
      'pattern' => '^Heard\\.FM\\s*/',
      'examples' => 
      array (
        0 => 'Heard.FM/1.0 (Linux; U; Android 13.0; Xiaomi 23124RN87I',
        1 => 'Heard.FM  /18.2 CFNetwork/1.0 Darwin/24.2.0',
        2 => 'Heard.FM/1.0 (Linux; U; Android 13.0; samsung SM-A525F',
        3 => 'Heard.FM  /18.1.1 CFNetwork/1.0 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://heard.fm/',
      ),
    ),
    246 => 
    array (
      'name' => 'HermesPod',
      'pattern' => 'hermespod\\.com/',
      'description' => 'HermesPod is the easiest way to subscribe, download and listen to podcasts. It\'s a Windows app.',
      'urls' => 
      array (
        0 => 'http://hermespod.com/',
      ),
      'comments' => 'HermesPod is no longer supported by its author.',
      'examples' => 
      array (
        0 => 'hermespod.com/v1.5.x',
      ),
    ),
    247 => 
    array (
      'name' => 'HiCast',
      'pattern' => '^HiCast/',
      'examples' => 
      array (
        0 => 'HiCast/1 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    248 => 
    array (
      'name' => 'Highly',
      'pattern' => '^Highly/',
      'examples' => 
      array (
        0 => 'Highly/914 CFNetwork/758.5.3 Darwin/15.6.0',
      ),
    ),
    249 => 
    array (
      'name' => 'Himalaya',
      'pattern' => '^Himalaya(_test)?/',
      'description' => 'Himalaya is a podcast app',
      'examples' => 
      array (
        0 => 'Himalaya/2.4.41 (iPhone; iOS 14.0.1; Scale/3.00; CFNetwork; iPhone9,4)',
        1 => 'Himalaya/2.4.42 (iPhone; iOS 14.2; Scale/2.00; CFNetwork; iPhone8,1)',
        2 => 'Himalaya/2.2.7 Android/25 (A577VL)',
        3 => 'Himalaya_test/55 CFNetwork/894 Darwin/17.4.0',
      ),
    ),
    250 => 
    array (
      'name' => 'HopeChurchCleburne',
      'pattern' => '^HopeChurchCleburne/',
      'examples' => 
      array (
        0 => 'HopeChurchCleburne/3 CFNetwork/974.2.1 Darwin/18.0.0',
      ),
    ),
    251 => 
    array (
      'name' => 'Horse Radio Network',
      'pattern' => '^HRN/',
      'examples' => 
      array (
        0 => 'HRN/1900 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    252 => 
    array (
      'name' => 'Hubbard Radio',
      'pattern' => 'HubbardApp/',
      'description' => 'Hubbard Radio Apps',
      'comments' => 'All Hubbard Radio station apps available on iOS and Android. Used when downloading or streaming podcast episodes.',
      'urls' => 
      array (
        0 => 'https://hubbardradio.com',
        1 => 'https://hubbardbroadcasting.com',
        2 => 'https://apps.apple.com/developer/hubbard-radio/id512607571',
        3 => 'https://play.google.com/store/apps/developer?id=Hubbard+Radio',
      ),
      'examples' => 
      array (
        0 => '101 ESPN/iOS 8.1.13 (iPad Air /12.5.7) HubbardApp/120',
        1 => '101.9 THE MIX/iOS 1.6.16 (iPhone XR/16.5.1) HubbardApp/120',
        2 => '92.3 WIL/iOS 4.7.11 (iPhone 12 Pro/16.5.1) HubbardApp/120',
        3 => '97.9 WRMF/iOS 1.2.11 (iPhone 11/16.5.1) HubbardApp/120',
        4 => 'The Point/iOS 5.3.11 (iPhone 12 Pro Max/16.5.1) HubbardApp/120',
        5 => 'TMA STL/iOS 1.0.6 (iPad Mini 5/16.1.1) HubbardApp/120',
        6 => '98 KUPD/Android 2.2.6 (SM-S918U/Android 13 Build TP1A.220624.014) HubbardApp/20',
        7 => 'B-105.1/Android 3.2.5 (GCE x86 phone/Android 9 Build PGR1.190916.001) HubbardApp/20',
        8 => 'KDUS 1060/Android 1.0.3 (Pixel 5/Android 13 Build TQ3A.230705.001) HubbardApp/20',
        9 => 'KS95/Android 2.5.6 (SM-G973F/Android 12 Build SP1A.210812.016) HubbardApp/20',
        10 => 'myTalk 107.1/Android 2.3.6 (cp3705A/Android 9 Build 3705A.210319.0D) HubbardApp/20',
        11 => 'SKOR North/Android 3.2.6 (SM-G973U/Android 12 Build SP1A.210812.016) HubbardApp/20',
        12 => '105.7 The Point/Android 2.2.5 (HD1907/Android 12 Build SKQ1.220303.001) HubbardApp/20',
      ),
    ),
    253 => 
    array (
      'name' => 'Hubhopper',
      'pattern' => '^Hubhopper$',
      'examples' => 
      array (
        0 => 'Hubhopper',
      ),
    ),
    254 => 
    array (
      'name' => 'Hyper',
      'pattern' => '^Hyper/',
      'examples' => 
      array (
        0 => 'Hyper/3 CFNetwork/893.14.2 Darwin/17.3.0',
      ),
    ),
    255 => 
    array (
      'name' => 'HyperCatcher',
      'pattern' => '^HyperCatcher',
      'description' => 'Newsletters and podcasts together!',
      'examples' => 
      array (
        0 => 'HyperCatcher/1',
      ),
    ),
    256 => 
    array (
      'name' => 'iBuilder',
      'pattern' => '^iBuilder/',
      'examples' => 
      array (
        0 => 'iBuilder/1 CFNetwork/548.1.4 Darwin/11.0.0',
      ),
    ),
    257 => 
    array (
      'name' => 'iCatcher',
      'pattern' => '^i[Cc]atcher|\\(iCatcher',
      'examples' => 
      array (
        0 => 'icatcher/4506 CFNetwork/609.1.4 Darwin/13.0.0',
        1 => 'iTunes (iCatcher!/2.6.3)',
      ),
    ),
    258 => 
    array (
      'name' => 'IDEngineering',
      'pattern' => '^com\\.IDEngineering\\.[A-Za-z0-9.]+',
      'examples' => 
      array (
        0 => 'com.IDEngineering.bbc.english.learning',
        1 => 'com.IDEngineering.BBC.minute.learn.english',
        2 => 'com.IDEngineering.bbc.the.english.we.speak',
        3 => 'com.IDEngineering.Learn.English_6_minutes',
        4 => 'com.IDEngineering.bbc.podcast.in.our.time',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/developer?id=IDEngineering&hl=en_US',
      ),
    ),
    259 => 
    array (
      'name' => 'iDL',
      'pattern' => '^iDL/',
      'examples' => 
      array (
        0 => 'iDL/122 CFNetwork/811.5.4 Darwin/16.7.0',
      ),
    ),
    260 => 
    array (
      'name' => 'iDownloader',
      'pattern' => 'IDownloaderApps4StarsFree/|^IDownloaderFree_Apps4Stars/|^iDownloader',
      'examples' => 
      array (
        0 => 'IDownloaderApps4StarsFree" "IDownloaderApps4StarsFree/1.0.107 CFNetwork/672.1.14 Darwin/14.0.0',
        1 => 'IDownloaderFree_Apps4Stars/1.10.108 CFNetwork/672.1.15 Darwin/14.0.0',
        2 => 'iDownloaderLite/1.3 CFNetwork/609.1.4 Darwin/13.0.0',
        3 => 'iDownloaderPro/1.0.1 CFNetwork/672.0.2 Darwin/14.0.0',
      ),
    ),
    261 => 
    array (
      'name' => 'iDownloadsAppPlus',
      'pattern' => '^iDownloadsAppPlus/',
      'examples' => 
      array (
        0 => 'iDownloadsAppPlus/1.6.4 CFNetwork/672.0.8 Darwin/14.0.0',
      ),
    ),
    262 => 
    array (
      'name' => 'iFeedTouch',
      'pattern' => '^iFeedTouch/',
      'examples' => 
      array (
        0 => 'iFeedTouch/1.02 CFNetwork/811.5.4 Darwin/16.7.0',
      ),
    ),
    263 => 
    array (
      'name' => 'Iframely',
      'pattern' => 'Iframely/',
      'urls' => 
      array (
        0 => 'https://iframely.com/docs/about',
      ),
      'examples' => 
      array (
        0 => 'Iframely/1.3.1 (+https://iframely.com/docs/about)',
      ),
    ),
    264 => 
    array (
      'name' => 'IFTTT',
      'pattern' => '^IFTTT/',
      'examples' => 
      array (
        0 => 'IFTTT/550 CFNetwork/758.5.3 Darwin/15.6.0',
      ),
    ),
    265 => 
    array (
      'name' => 'iHeartRadio',
      'pattern' => '^iHeartRadio/|^iHeartPodcasts/|^iHeart/',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.clearchannel.iheartradio.controller',
        1 => 'https://apps.apple.com/us/app/iheart-radio-music-podcasts/id290638154',
      ),
      'examples' => 
      array (
        0 => 'iHeartRadio/9.19.0 (Android 10; SM-G960U Build/QP1A.190711.020)',
        1 => 'iHeartRadio/9.19.0 (Android 9; SM-G950U Build/PPR1.180610.011)',
        2 => 'iHeartRadio/2020052002 CFNetwork/1125.2 Darwin/19.4.0',
        3 => 'iHeartRadio/9.20.0 (iPhone; iOS 13.4.1; iPhone11,8)',
        4 => 'iHeartRadio/9.20.0 (iPad; iOS 13.4.1; iPad6,12)',
        5 => 'iHeartRadio/9.7.0 (iPod touch; iOS 12.4.5; iPod7,1)',
        6 => 'iHeartPodcasts/1.1.0 (Android 10; SM-A505FN Build/QP1A.190711.020)',
        7 => 'iHeart/10.47.0 (iOS/18.1; Phone; en-US; AppStore; Apple/iPhone13,2)',
        8 => 'iHeart/10.47.0 (Linux; U; Android 14; V2130 Build/UP1A.231005.007)',
        9 => 'iHeart/10.47.0 (Windows NT 10.0; Win64; x64; MSAppHost/3.0)',
      ),
    ),
    266 => 
    array (
      'name' => 'iHorror',
      'pattern' => '^iHorror/',
      'examples' => 
      array (
        0 => 'iHorror/1.2.6 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    267 => 
    array (
      'name' => 'InCast',
      'pattern' => '^InCast/',
      'examples' => 
      array (
        0 => 'InCast/3443 CFNetwork/711.0.6 Darwin/14.0.0',
      ),
    ),
    268 => 
    array (
      'name' => 'Insomniac Radio',
      'pattern' => '^Insomniac-Radio/',
      'examples' => 
      array (
        0 => 'Insomniac-Radio/1.0.2 (iOS 16.7.11)',
        1 => 'Insomniac-Radio/1.0.2 (Android 15)',
      ),
    ),
    269 => 
    array (
      'name' => 'Instacast',
      'pattern' => '^Instacast Instacast/|^Instacast/',
      'examples' => 
      array (
        0 => 'Instacast Instacast/4.5.4 CFNetwork/672.1.14 Darwin/14.0.0',
        1 => 'Instacast/2763 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
    ),
    270 => 
    array (
      'name' => 'InstacastPlus',
      'description' => 'InstacastPlus is built on the previously popular podcast app Instacast. Discover podcasts that entertain, inform, and inspire.',
      'pattern' => '^InstacastPlus/\\d',
      'examples' => 
      array (
        0 => 'InstacastPlus/1 CFNetwork/1496.0.7 Darwin/23.5.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/instacastplus/id6472283494',
      ),
    ),
    271 => 
    array (
      'name' => 'Instagram',
      'pattern' => '^Instagram/|Mobile/.* Instagram',
      'examples' => 
      array (
        0 => 'Instagram/252729634 CFNetwork/1126 Darwin/19.5.0',
        1 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 12_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 Instagram 108.0.0.9.119 (iPhone9,3; iOS 12_3_1; en_IN; en-IN; scale=2.00; 750x1334; 168879348)',
      ),
    ),
    272 => 
    array (
      'name' => 'Internazionale',
      'pattern' => '^Internazionale App for (Android|iOS)/',
      'examples' => 
      array (
        0 => 'Internazionale App for Android/null bnull (Phone; android; it_IT)',
        1 => 'Internazionale App for iOS/null bnull (iPhone; ios; it_IT)',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.internazionale.app&hl=en_US',
      ),
    ),
    273 => 
    array (
      'name' => 'iOnGreenville',
      'pattern' => '^iOnGreenville/',
      'examples' => 
      array (
        0 => 'iOnGreenville/1 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    274 => 
    array (
      'name' => 'IOSAudiobooks',
      'pattern' => '^IOSAudiobooks/',
      'examples' => 
      array (
        0 => 'IOSAudiobooks/7.4.1.1 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    275 => 
    array (
      'name' => 'IPF',
      'pattern' => '^IPF/',
      'examples' => 
      array (
        0 => 'IPF/1 CFNetwork/901.1 Darwin/17.6.0',
      ),
    ),
    276 => 
    array (
      'name' => 'iPlay',
      'pattern' => '^iPlay/',
      'examples' => 
      array (
        0 => 'iPlay/1 CFNetwork/889.9 Darwin/17.2.0',
      ),
    ),
    277 => 
    array (
      'name' => 'isitgood',
      'pattern' => '^isitgood/',
      'examples' => 
      array (
        0 => 'isitgood/246 CFNetwork/978.0.7 Darwin/18.6.0',
      ),
    ),
    278 => 
    array (
      'name' => 'iTunes',
      'pattern' => '^iTunesU?[/-]',
      'urls' => 
      array (
        0 => 'https://www.apple.com/itunes/',
      ),
      'examples' => 
      array (
        0 => 'iTunes/10.6.3 (Macintosh; Intel Mac OS X 10.5.8) AppleWebKit/534.50.2',
        1 => 'iTunes/11.4 (Windows; Microsoft Windows 7 x64 Home Premium Edition (Build 7600)) AppleWebKit/7600.1017.0.24',
        2 => 'iTunes/12.10.9 (Windows; Microsoft Windows 10 x64 Home Premium Edition (Build 19041); x64) AppleWebKit/7609.3005.1003.3',
        3 => 'iTunes-iPhone',
        4 => 'iTunesU/3.4 iOS/9.3.2 model/iPod7,1 hwp/t7000 build/13F69 (4; dt:123)',
      ),
    ),
    279 => 
    array (
      'name' => 'ITV News',
      'pattern' => '^com\\.itv\\.itvnewsapp/\\d',
      'examples' => 
      array (
        0 => 'com.itv.itvnewsapp/2.47.0(iPhone12,8; ios 18.1.1; en-GB)',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/gb/app/itv-news-breaking-stories/id907113454',
      ),
    ),
    280 => 
    array (
      'name' => 'iVoox',
      'pattern' => '^[iI][Vv]oox',
      'urls' => 
      array (
        0 => 'https://www.ivoox.com/',
      ),
      'examples' => 
      array (
        0 => 'iVooxApp/3.85 (iPhone; iOS; iOS 15.6.1; d:16910714; 113F)',
        1 => 'ivooxApp/2.281.428_428 (G8341; Android 9; d:420031; E5A4)',
        2 => 'Ivoox 2.3 (iPod touch; iPhone OS 6.1.5; es_MX)',
      ),
    ),
    281 => 
    array (
      'name' => 'iWeb',
      'pattern' => '^iWeb/',
      'examples' => 
      array (
        0 => 'iWeb/1.3.0 CFNetwork/711.1.12 Darwin/14.0.0',
      ),
    ),
    282 => 
    array (
      'name' => 'Jabbercast',
      'pattern' => '^Jabbercast/',
      'examples' => 
      array (
        0 => 'Jabbercast/16 CFNetwork/711.1.16 Darwin/14.0.0',
      ),
    ),
    283 => 
    array (
      'name' => 'Jam',
      'pattern' => '^Jam/\\d.*listentojam',
      'examples' => 
      array (
        0 => 'Jam/1.11.1 iOS/16.2 (www.listentojam.com)',
        1 => 'Jam/1.11.1 Android/12 (www.listentojam.com)',
      ),
      'urls' => 
      array (
        0 => 'https://join.jam.ai/',
      ),
    ),
    284 => 
    array (
      'name' => 'Jamit',
      'pattern' => '^Jamit$',
      'examples' => 
      array (
        0 => 'Jamit',
      ),
      'urls' => 
      array (
        0 => 'https://jamit.app/',
      ),
    ),
    285 => 
    array (
      'name' => 'JamxFeeds',
      'pattern' => '^JamxFeeds/',
      'examples' => 
      array (
        0 => 'JamxFeeds/1.0.3',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=ai.jamx.feeds',
      ),
    ),
    286 => 
    array (
      'name' => 'Jimcast',
      'pattern' => '^Jimcast/',
      'examples' => 
      array (
        0 => 'Jimcast/1.0 CFNetwork/672.1.15 Darwin/14.0.0',
      ),
    ),
    287 => 
    array (
      'name' => 'JioSaavn',
      'pattern' => '(^com\\.jio\\.media\\.jiobeats|^com\\.saavn\\.android|^[sS]aavn)',
      'description' => 'A music streaming and podcast app from India. Earn Your Happy!',
      'urls' => 
      array (
        0 => 'https://www.jiosaavn.com/',
      ),
      'comments' => 'The user-agent will start with one of the above strings followed by the app version and player version.',
      'examples' => 
      array (
        0 => 'com.jio.media.jiobeats/7.3.1 (Linux;Android 8.1.0) ExoPlayerLib/2.11.4',
        1 => 'Saavn Player',
      ),
    ),
    288 => 
    array (
      'name' => 'JRiver Media Center',
      'pattern' => 'J\\. River Internet Reader',
      'urls' => 
      array (
        0 => 'https://www.jriver.com/',
      ),
      'examples' => 
      array (
        0 => 'Microsoft-Windows-XP/2002, UPnP/1.1, J. River Internet Reader/2.0 (compatible; Windows-Media-Player/10)',
      ),
    ),
    289 => 
    array (
      'name' => 'Juice',
      'pattern' => '^Juice/',
      'examples' => 
      array (
        0 => 'Juice/2.2 (Darwin) +http://juicereceiver.sf.net/',
      ),
    ),
    290 => 
    array (
      'name' => 'Kajabi',
      'pattern' => ' Kajabi|KajabiPodcast',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 KajabiMobileApp',
        1 => 'KajabiPodcast',
      ),
    ),
    291 => 
    array (
      'name' => 'KakaoTalk',
      'pattern' => '^KakaoTalk/',
      'examples' => 
      array (
        0 => 'KakaoTalk/2019.10.30.1 CFNetwork/1120 Darwin/19.0.0',
      ),
    ),
    292 => 
    array (
      'name' => 'KaoticRadio.com',
      'pattern' => '^KaoticRadio\\.com/',
      'examples' => 
      array (
        0 => 'KaoticRadio.com/1.56.67.564 CFNetwork/672.1.15 Darwin/14.0.0',
      ),
    ),
    293 => 
    array (
      'name' => 'Kasts',
      'pattern' => '^Kasts/|^kasts ',
      'examples' => 
      array (
        0 => 'Kasts/22.09; Syndication',
        1 => 'kasts LibVLC',
      ),
      'urls' => 
      array (
        0 => 'https://apps.kde.org/kasts/',
      ),
      'description' => 'Kasts is a convergent podcast application that looks good on desktop and mobile.',
    ),
    294 => 
    array (
      'name' => 'KERA Public Media App',
      'pattern' => '^KERAPublicRadioApp/\\d',
      'examples' => 
      array (
        0 => 'KERAPublicRadioApp/6.2.17 (iPhone14,5; iOS 18.1.1)',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/kera-public-media-app/id390567162',
      ),
    ),
    295 => 
    array (
      'name' => 'Kids Listen',
      'pattern' => '^Kids(%20| )Listen/',
      'examples' => 
      array (
        0 => 'Kids%20Listen/55 CFNetwork/1107.1 Darwin/19.0.0',
        1 => 'Kids Listen/55 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    296 => 
    array (
      'name' => 'KidsPod',
      'pattern' => '^KidspodMobileClient/|^KidsPod/',
      'examples' => 
      array (
        0 => 'KidspodMobileClient/111 CFNetwork/1465.2 Darwin/23.0.0',
        1 => 'KidspodMobileClient/111 CFNetwork/1408.0.4 Darwin/22.5.0',
        2 => 'KidsPod/1.0',
      ),
      'urls' => 
      array (
        0 => 'https://kidspod.app/',
      ),
    ),
    297 => 
    array (
      'name' => 'KKBOX',
      'pattern' => '^KKBOX/',
      'examples' => 
      array (
        0 => 'KKBOX/7.10.70/iOS/14.2',
      ),
    ),
    298 => 
    array (
      'name' => 'Kloudie',
      'pattern' => '^Kloudie/',
      'examples' => 
      array (
        0 => 'Kloudie/1.0 CFNetwork/758.1.6 Darwin/15.0.0',
      ),
    ),
    299 => 
    array (
      'name' => 'Knomad',
      'pattern' => '^Knomad/',
      'examples' => 
      array (
        0 => 'Knomad/1.1.9 CFNetwork/711.1.12 Darwin/14.0.0',
      ),
    ),
    300 => 
    array (
      'name' => 'Kodi',
      'pattern' => '^Kodi/',
      'examples' => 
      array (
        0 => 'Kodi/15.2 (Linux; Android 5.1; QM152E Build/LMY47D) Android/5.1.0 Sys_CPU/armv7l App_Bitness/32 Version/15.2-Git:2015-10-27-17fa8da',
      ),
    ),
    301 => 
    array (
      'name' => 'KREAFUNK',
      'pattern' => '^KREAFUNK/',
      'examples' => 
      array (
        0 => 'KREAFUNK/1.7 CFNetwork/711.3.18 Darwin/14.0.0',
      ),
    ),
    302 => 
    array (
      'name' => 'labs',
      'pattern' => '^labs/',
      'examples' => 
      array (
        0 => 'labs/0.1.1.5 CFNetwork/711.2.23 Darwin/14.0.0',
      ),
    ),
    303 => 
    array (
      'name' => 'Laughable',
      'pattern' => '^Laughable.+iOS|^Laughable/',
      'examples' => 
      array (
        0 => 'Laughable/2.1.6.1 CFNetwork/808.1.4 Darwin/16.1.0',
      ),
    ),
    304 => 
    array (
      'name' => 'Le Monde',
      'pattern' => '^AEC/',
      'examples' => 
      array (
        0 => 'AEC/9.16 (free; fr; ABTest 123) iOS/26.0 (phone; iPhone18,1)',
        1 => 'AEC/9.15.2 (free; fr; ABTest 427) Android/14/34 (phone; Pixel 7a)',
      ),
    ),
    305 => 
    array (
      'name' => 'LeParisien',
      'pattern' => '^leparisien/',
      'examples' => 
      array (
        0 => 'leparisien/Android',
        1 => 'leparisien/iOS',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/fr/app/le-parisien-linfo-en-direct/id373948394',
        1 => 'https://play.google.com/store/apps/details?id=com.kreactive.leparisienrssplayer&hl=fr',
      ),
    ),
    306 => 
    array (
      'name' => 'Leaf',
      'pattern' => '^Leaf/',
      'examples' => 
      array (
        0 => 'Leaf/12 CFNetwork/720.0.9 Darwin/14.0.0 (x86_64)',
      ),
    ),
    307 => 
    array (
      'name' => 'Les Indés Radios',
      'pattern' => '(^lesindesradios$|^lesindesradios/)',
      'description' => 'Les Indés Radios is a radio app, available on multiple devices and OSs',
      'urls' => 
      array (
        0 => 'https://www.lesindesradios.fr/',
      ),
      'examples' => 
      array (
        0 => 'lesindesradios',
        1 => 'lesindesradios/9.1.0 (Linux;Android 8.0.0) ExoPlayerLib/2.9.2',
        2 => 'lesindesradios/9.1.0 (Linux;Android 11) ExoPlayerLib/2.9.2',
      ),
    ),
    308 => 
    array (
      'name' => 'LG Player',
      'pattern' => 'LG Player',
    ),
    309 => 
    array (
      'name' => 'LG webOS TV',
      'pattern' => 'Web0S; Linux/SmartTV.*WebAppManager',
      'description' => 'The web engine of the webOS TV platform provides an app programming environment for content providers and aggregators',
      'urls' => 
      array (
        0 => 'https://webostv.developer.lge.com/develop/specifications/web-api-and-web-engine',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.5359.211 Safari/537.36 WebAppManager',
        1 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.128 Safari/537.36 WebAppManager',
        2 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36 WebAppManager',
        3 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36 WebAppManager',
        4 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 WebAppManager',
        5 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.34 Safari/537.36 WebAppManager',
        6 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.36 (KHTML, like Gecko) QtWebEngine/5.2.1 Chrome/38.0.2125.122 Safari/537.36 WebAppManager',
        7 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/538.2 (KHTML, like Gecko) Large Screen WebAppManager Safari/538.2',
        8 => 'Mozilla/5.0 (Web0S; Linux/SmartTV) AppleWebKit/537.41 (KHTML, like Gecko) Large Screen WebAppManager Safari/537.41',
      ),
    ),
    310 => 
    array (
      'name' => 'LifeEssentials',
      'pattern' => '^Life(%20)?Essentials(App)?/',
      'examples' => 
      array (
        0 => 'LifeEssentials/1.0 CFNetwork/758.0.2 Darwin/15.0.0',
        1 => 'LifeEssentialsApp/2.1.0 CFNetwork/758.5.3 Darwin/15.6.0',
        2 => 'Life%20Essentials/1.0 CFNetwork/672.1.15 Darwin/14.0.0',
      ),
    ),
    311 => 
    array (
      'name' => 'lifegateburleson',
      'pattern' => '^lifegateburleson/',
      'examples' => 
      array (
        0 => 'lifegateburleson/10 CFNetwork/672.1.15 Darwin/14.0.0',
      ),
    ),
    312 => 
    array (
      'name' => 'Life Radio',
      'pattern' => '^life-radio-konsole-app-android',
      'examples' => 
      array (
        0 => 'life-radio-konsole-app-android',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.mobileagreements.radio.liferadio',
      ),
    ),
    313 => 
    array (
      'name' => 'LinkedIn',
      'pattern' => 'AppleWebKit.+\\[LinkedInApp\\]|^LinkedIn/',
      'description' => 'The LinkedIn app\'s built-in browser on iPhones.',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 14_4_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 [LinkedInApp]',
        1 => 'LinkedIn/9.14.4868 CFNetwork/1107.1 Darwin/19.0.0',
        2 => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 [LinkedInApp]/9.28.7219',
      ),
    ),
    314 => 
    array (
      'name' => 'Lisny',
      'pattern' => 'Lisny',
      'description' => 'Lisny is a fast, beautiful and fun listening experience.',
      'urls' => 
      array (
        0 => 'https://www.lisny.com',
      ),
      'examples' => 
      array (
        0 => 'Lisny',
      ),
    ),
    315 => 
    array (
      'name' => 'Listen',
      'pattern' => '^Listen(( |%20)App)?/',
      'examples' => 
      array (
        0 => 'Listen/1 CFNetwork/1107.1 Darwin/19.0.0',
        1 => 'Listen App/84 CFNetwork/1240.0.4 Darwin/20.6.0',
        2 => 'Listen%20App/121 CFNetwork/1399 Darwin/22.1.0',
      ),
    ),
    316 => 
    array (
      'name' => 'Liulo',
      'pattern' => '^Liulo/',
      'examples' => 
      array (
        0 => 'Liulo/1.1.6 (vn.bachminh.podcastvn; build:6; iOS 17.0.0) Alamofire/5.6.4',
      ),
      'urls' => 
      array (
        0 => 'https://liulo.fm',
      ),
      'comments' => 'Podcasting platform in Vietnam. Android app sends stagefright for streaming and PRDownloader for downloads, so cannot be identified.',
    ),
    317 => 
    array (
      'name' => 'Listen5',
      'pattern' => 'Listen5',
    ),
    318 => 
    array (
      'name' => 'Livio Radio',
      'pattern' => '^Livio Radio/',
      'examples' => 
      array (
        0 => 'Livio Radio/2.6.2 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    319 => 
    array (
      'name' => 'Luminary',
      'pattern' => '^Luminary(Preprod)?/|^luminary\\.next/',
      'examples' => 
      array (
        0 => 'LuminaryPreprod/27 CFNetwork/976 Darwin/18.2.0',
        1 => 'luminary.next/1.25 (Linux;Android 9) ExoPlayerLib/2.10.5',
      ),
    ),
    320 => 
    array (
      'name' => 'Lysten',
      'pattern' => '^Lysten/\\d',
      'examples' => 
      array (
        0 => 'Lysten/485 CFNetwork/1474 Darwin/23.0.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/lysten-podcast-player/id1579212581',
      ),
    ),
    321 => 
    array (
      'name' => 'MacJournal',
      'pattern' => '^MacJournal/',
      'examples' => 
      array (
        0 => 'MacJournal/6.2.1 CFNetwork/811.5.4 Darwin/16.7.0 (x86_64)',
      ),
    ),
    322 => 
    array (
      'name' => 'Majelan',
      'pattern' => '^MajelanApp',
    ),
    323 => 
    array (
      'name' => 'Mame Cast',
      'pattern' => '^Mame%20Cast/',
      'examples' => 
      array (
        0 => 'Mame%20Cast/36 CFNetwork/1240.0.4 Darwin/20.6.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/mame-cast-a-podcast-player/id1495516059',
      ),
    ),
    324 => 
    array (
      'name' => 'MaxTubePro',
      'pattern' => '^MaxTubePro/',
      'examples' => 
      array (
        0 => 'MaxTubePro/1.5 CFNetwork/711.1.16 Darwin/14.0.0',
      ),
    ),
    325 => 
    array (
      'name' => 'Meadowbrook Church',
      'pattern' => '^Meadowbrook Church/',
      'examples' => 
      array (
        0 => 'Meadowbrook Church/4.10.2 CFNetwork/978.0.7 Darwin/18.6.0',
      ),
    ),
    326 => 
    array (
      'name' => 'MediaMonkey',
      'pattern' => '^MediaMonkey',
    ),
    327 => 
    array (
      'name' => 'Mediatap',
      'pattern' => '^Mediatap/',
      'examples' => 
      array (
        0 => 'Mediatap/342 CFNetwork/672.1.13 Darwin/14.0.0',
      ),
    ),
    328 => 
    array (
      'name' => 'Megaphone',
      'pattern' => '^Megaphone\\.fm',
      'examples' => 
      array (
        0 => 'Megaphone.fm',
      ),
    ),
    329 => 
    array (
      'name' => 'MegaSeg',
      'pattern' => '^MegaSeg/\\d',
      'examples' => 
      array (
        0 => 'MegaSeg/6.3.2b11',
      ),
      'urls' => 
      array (
        0 => 'https://www.megaseg.com/',
      ),
    ),
    330 => 
    array (
      'name' => 'Menucast',
      'pattern' => '^Menucast/',
      'examples' => 
      array (
        0 => 'Menucast/1.4 CFNetwork/720.1.1 Darwin/14.0.0 (x86_64)',
      ),
    ),
    331 => 
    array (
      'name' => 'Message+',
      'pattern' => '^Message\\+/',
      'examples' => 
      array (
        0 => 'Message+/2.4.7 CFNetwork/811.5.4 Darwin/16.7.0 (x86_64)',
      ),
    ),
    332 => 
    array (
      'name' => 'Messenger',
      'pattern' => '^Messenger/',
      'examples' => 
      array (
        0 => 'Messenger/168725151 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    333 => 
    array (
      'name' => 'Metacast',
      'pattern' => '^Metacast/| \\+metacast\\.app',
      'examples' => 
      array (
        0 => 'Metacast/0.73.5 (ios)',
        1 => 'Metacast/1.2.0 (android)',
        2 => 'Mozilla/5.0 (compatible; Metacast/1.0 +metacast.app)',
      ),
      'urls' => 
      array (
        0 => 'https://metacast.app/',
      ),
    ),
    334 => 
    array (
      'name' => 'Microsoft Outlook',
      'pattern' => '^Outlook-Android/|^Microsoft Office/.*?Microsoft Outlook',
      'examples' => 
      array (
        0 => 'Microsoft Office/16.0 (Windows NT 10.0; Microsoft Outlook 16.0.16130; Pro)',
        1 => 'Outlook-Android/2.0',
      ),
    ),
    335 => 
    array (
      'name' => 'Microsoft Xbox',
      'pattern' => '^microsoft;xbox_',
      'examples' => 
      array (
        0 => 'microsoft;xbox_one;1fc2d01aa9074dde950e8d3dc0eb1729;;tpapi;3.167.55',
        1 => 'microsoft;xbox_series_x;1fc2d01aa9074dde950e8d3dc0eb1729;;tpapi;3.167.55 Dynamo/1.0',
      ),
    ),
    336 => 
    array (
      'name' => 'Mimir',
      'pattern' => '^Mimir(-macOS|-iOS)?/',
      'examples' => 
      array (
        0 => 'Mimir/1 CFNetwork/1098 Darwin/19.0.0 (x86_64)',
        1 => 'Mimir-macOS/1.7.2',
        2 => 'Mimir-iOS/1.4.1',
      ),
    ),
    337 => 
    array (
      'name' => 'Miro',
      'pattern' => '^Miro/.+Windows',
      'urls' => 
      array (
        0 => 'http://www.getmiro.com/',
      ),
      'examples' => 
      array (
        0 => 'Miro/6.0 (http://www.getmiro.com/; Windows post2008Server x86)',
      ),
    ),
    338 => 
    array (
      'name' => 'Mixcloud',
      'pattern' => '^Mixcloud/',
      'examples' => 
      array (
        0 => 'Mixcloud/22.2.5 (Linux;Android 6.0.1) ExoPlayerLib/2.10.4',
      ),
    ),
    339 => 
    array (
      'name' => 'MixerBox',
      'pattern' => '^MixerBox((%20| )Pro)?/',
      'urls' => 
      array (
        0 => 'https://www.mixerbox.com/',
      ),
      'examples' => 
      array (
        0 => 'MixerBox/12.33 (Linux;Android 11) ExoPlayerLib/2.11.1',
        1 => 'MixerBox/807.iOS (iPhone; iOS 14.4; en_US)',
        2 => 'MixerBox/869 CFNetwork/1300.1 Darwin/21.0.0',
        3 => 'MixerBox%20Pro/10015 CFNetwork/1406.0.4 Darwin/22.4.0',
        4 => 'MixerBox Pro/10015 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
    ),
    340 => 
    array (
      'name' => 'MobileApp',
      'pattern' => '^MobileApp/',
      'examples' => 
      array (
        0 => 'MobileApp/0 CFNetwork/758.3.15 Darwin/17.4.0',
      ),
    ),
    341 => 
    array (
      'name' => 'MobileSMS',
      'pattern' => '^MobileSMS/',
      'examples' => 
      array (
        0 => 'MobileSMS/1.0 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    342 => 
    array (
      'name' => 'MoonFM',
      'pattern' => '^Moon ?FM/',
      'examples' => 
      array (
        0 => 'MoonFM/128 CFNetwork/978.0.7 Darwin/18.7.0',
        1 => 'Moon FM/4.0.33',
      ),
    ),
    343 => 
    array (
      'name' => 'mowPod',
      'pattern' => '^mowPod/',
      'urls' => 
      array (
        0 => 'https://mowpod.com/',
      ),
      'examples' => 
      array (
        0 => 'mowPod/1.0 Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36',
      ),
    ),
    344 => 
    array (
      'name' => 'MPlayer',
      'description' => 'GPL-licensed cross-platform movie player',
      'pattern' => '^MPlayer \\d',
      'urls' => 
      array (
        0 => 'http://www.mplayerhq.hu/design7/info.html',
      ),
      'examples' => 
      array (
        0 => 'MPlayer 1.3.0 (Debian), built with gcc-6.2.1',
      ),
    ),
    345 => 
    array (
      'name' => 'mpv',
      'pattern' => '^mpv 0\\.|^libmpv$',
      'urls' => 
      array (
        0 => 'https://mpv.io/',
      ),
      'examples' => 
      array (
        0 => 'libmpv',
      ),
    ),
    346 => 
    array (
      'name' => 'MusicBee',
      'pattern' => '^MusicBee',
      'urls' => 
      array (
        0 => 'https://getmusicbee.com/',
      ),
      'examples' => 
      array (
        0 => 'MusicBee',
      ),
    ),
    347 => 
    array (
      'name' => 'Music Download App',
      'pattern' => '^Music%20Download/',
      'examples' => 
      array (
        0 => 'Music%20Download/45 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    348 => 
    array (
      'name' => 'MusiPro',
      'pattern' => '^MusiPro/\\d',
      'examples' => 
      array (
        0 => 'MusiPro/1 CFNetwork/1568.300.101 Darwin/24.2.0',
      ),
      'urls' => 
      array (
        0 => 'https://musipro-music-player-and-strea.appstor.io/',
      ),
    ),
    349 => 
    array (
      'name' => 'MyTuner',
      'pattern' => '^myTuner Radio app/|^myTuner%20Radio%20app/|^mytuner_podcasts_androidplayer/|^MyTuner-|^my[tT]uner$|^myTuneriOS%20Free/|^myTuner( |%20)Podcasts/\\d|^myTuneriOS Free/\\d|^myTuneriOS/\\d',
      'examples' => 
      array (
        0 => 'myTuner Radio app/11 CFNetwork/978.0.7 Darwin/18.7.0',
        1 => 'myTuner%20Radio%20app/11 CFNetwork/978.0.7 Darwin/18.7.0',
        2 => 'mytuner_podcasts_androidplayer/1.0.0 (Linux;Android 6.0) ExoPlayerLib/2.8.4',
        3 => 'MyTuner-ExoPlayerAdapter',
        4 => 'myTuner',
        5 => 'myTuneriOS%20Free/120 CFNetwork/1402.0.8 Darwin/22.2.0',
        6 => 'myTuner Podcasts/30 CFNetwork/1568.200.51 Darwin/24.1.0',
        7 => 'myTuneriOS Free/202 CFNetwork/1568.200.51 Darwin/24.1.0',
        8 => 'mytuner',
        9 => 'myTuner%20Podcasts/30 CFNetwork/1568.200.51 Darwin/24.1.0',
        10 => 'myTuneriOS/55 CFNetwork/1568.300.101 Darwin/24.2.0',
      ),
    ),
    350 => 
    array (
      'name' => 'Nabd Pulse',
      'pattern' => '^(com.waveline.nabd|Nabd)/\\d',
      'examples' => 
      array (
        0 => 'com.waveline.nabd/17.3 (Linux;Android 14) AndroidXMedia3/1.2.1',
        1 => 'Nabd/11.4.0 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.waveline.nabd&hl=en_US',
        1 => 'https://apps.apple.com/us/app/%D9%86%D8%A8%D8%B6-nabd-%D8%A7%D8%AE%D8%A8%D8%A7%D8%B1-%D8%A7%D9%84%D8%B9%D8%A7%D9%84%D9%85-%D8%B9%D8%A7%D8%AC%D9%84/id569532697',
      ),
    ),
    351 => 
    array (
      'name' => 'NetNewsWire',
      'pattern' => '^NetNewsWire',
      'examples' => 
      array (
        0 => 'NetNewsWire (RSS Reader; https://netnewswire.com/)',
      ),
      'urls' => 
      array (
        0 => 'https://netnewswire.com/',
      ),
    ),
    352 => 
    array (
      'name' => 'Neuecast',
      'pattern' => '^Neuecast/',
      'examples' => 
      array (
        0 => 'Neuecast/1.2.1 (iOS; 18.2)',
        1 => 'Neuecast/1.2.2 (iOS; 18.1.1)',
      ),
      'urls' => 
      array (
        0 => 'https://neuecast.app/',
      ),
    ),
    353 => 
    array (
      'name' => 'Newsboat',
      'pattern' => '^Newsboat/',
      'examples' => 
      array (
        0 => 'Newsboat/2.29.0 (Linux x86_64)',
      ),
    ),
    354 => 
    array (
      'name' => 'Newsly',
      'pattern' => '^Newsly',
      'description' => 'Stop Scrolling, Start Listening.',
      'urls' => 
      array (
        0 => 'https://www.newsly.me/',
      ),
      'examples' => 
      array (
        0 => 'Newsly',
      ),
    ),
    355 => 
    array (
      'name' => 'Noice',
      'pattern' => '^Noice/',
      'examples' => 
      array (
        0 => 'Noice/3.38.1 (Apple; iOS 17.4.1) AVQueuePlayer/0',
        1 => 'Noice/3.39 (Apple; iOS 17.4.1) AVQueuePlayer/0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/noice-podcast-radio/id1484372791',
      ),
    ),
    356 => 
    array (
      'name' => 'Nos',
      'pattern' => '^Nos|Nos%20Staging|Nos%20Dev/',
      'examples' => 
      array (
        0 => 'Nos/280 CFNetwork/1498.700.2 Darwin/23.6.0',
        1 => 'Nos%20Staging/482 CFNetwork/1498.700.2 Darwin/23.6.0',
        2 => 'Nos/278 CFNetwork/1498.700.2 Darwin/23.6.0',
        3 => 'Nos%20Dev/6 CFNetwork/1568.100.1 Darwin/24.0.0',
      ),
      'urls' => 
      array (
        0 => 'https://www.nos.social/',
      ),
    ),
    357 => 
    array (
      'name' => 'NPR',
      'pattern' => '^NPR/|^NPR%20One/|^NPROneAndroid|nprone_android/',
      'examples' => 
      array (
        0 => 'NPR%20One/234 CFNetwork/1197 Darwin/20.0.0',
        1 => 'NPROneAndroid',
        2 => 'NPR/618 CFNetwork/1485 Darwin/23.1.0',
        3 => 'Dalvik/2.1.0 (Linux; U; Android 13; SM-G991U Build/TP1A.220624.014) nprone_android/3.7.0/OSv:13',
      ),
      'comments' => 'formerly NPR One: https://www.npr.org/about-npr/1218775096/npr-unifies-mobile-app-experience-for-listeners-sunsets-npr-one-app',
    ),
    358 => 
    array (
      'name' => 'NRC Audio',
      'pattern' => '^NRC( |%20)Audio/',
      'description' => 'NRC Audio',
      'examples' => 
      array (
        0 => 'NRC Audio/2.0.0 (nl.nrc.audio; build:29; Android 12; Sdk:31; Manufacturer:samsung; Model: SM-G975F) OkHttp/4.9.3',
        1 => 'NRC%20Audio/1 CFNetwork/1410.0.3 Darwin/22.6.0',
      ),
    ),
    359 => 
    array (
      'name' => 'NRC',
      'pattern' => 'nl\\.nrc\\.nrcapp|^NRC-Nieuws/|com\\.twipemobile\\.nrc',
      'description' => 'The free NRC app offers you the latest news and the digital version of the paper newspaper.',
      'examples' => 
      array (
        0 => 'NRC-Nieuws/10.3.1 (nl.nrc.nrcapp; build:210; iOS 16.6.0) Alamofire/10.3.1',
        1 => 'iPad (compatible; Tablet2.0) NRC Digitale Editie, nl.nrc.nrcapp 10.0.7 (197) / iPadOS 16.6',
        2 => 'iPhone (compatible; Smartphone2.0) NRC Digitale Editie, nl.nrc.nrcapp 10.0.7 (197) / iOS 16.6',
        3 => 'NRC-Nieuws/5.4.0 (com.twipemobile.nrc; build:540; Android:13; Sdk:33; Manufacturer:samsung; Model: SM-A528B) OkHttp/4.11.0',
        4 => 'SM-T970 (compatible; Tablet2.0) HandelsbladProduction, com.twipemobile.nrc 5.1.4 (511) / Android 33',
      ),
      'urls' => 
      array (
        0 => 'https://www.nrc.nl/app/',
      ),
    ),
    360 => 
    array (
      'name' => 'Outcast',
      'pattern' => '^Outcast[/ ]',
      'examples' => 
      array (
        0 => 'Outcast/1957 CFNetwork/889.7 Darwin/17.2.0',
        1 => 'Outcast 3.1.6',
      ),
    ),
    361 => 
    array (
      'name' => 'Overcast',
      'pattern' => '^Overcast/|^Overcast.*Apple Watch|^Overcast Player ',
      'examples' => 
      array (
        0 => 'Overcast/3.0 (+http://overcast.fm/; iOS podcast app)',
        1 => 'Overcast (+http://overcast.fm/; Apple Watch podcast app)',
        2 => 'Overcast/792 CFNetwork/1098.7 Darwin/19.0.0',
        3 => 'Overcast Player 66271',
      ),
    ),
    362 => 
    array (
      'name' => 'Overhaul',
      'pattern' => '^Podcast Overhaul/|^Overhaul FM/',
      'examples' => 
      array (
        0 => 'Podcast Overhaul/4.1.1 iOS/16.1.1 +https://www.podcastoverhaul.com/',
        1 => 'Overhaul FM/2.0 SM-P615/13 +https://overhaul.fm',
      ),
      'urls' => 
      array (
        0 => 'https://www.overhaul.fm/',
      ),
    ),
    363 => 
    array (
      'name' => 'Palco MP3',
      'pattern' => '^Palco MP3',
      'urls' => 
      array (
        0 => 'https://www.palcomp3.com.br/',
      ),
      'examples' => 
      array (
        0 => 'Palco MP3/3.13.18 (Linux;Android 11) ExoPlayerLib/2.11.0',
      ),
    ),
    364 => 
    array (
      'name' => 'Pandora',
      'pattern' => '(^Pandora/| Pandora/)',
      'examples' => 
      array (
        0 => 'Pandora/2009.2 Android/7.1.1 gteslteatt (ExoPlayerLib1.5.14.1)',
        1 => 'Pandora/2179 CFNetwork/1410.0.3 Darwin/22.6.0',
        2 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 12_4_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 Pandora/2009.2',
        3 => 'Mozilla/5.0 (iPad; CPU OS 12_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 Pandora/1908.1',
      ),
    ),
    365 => 
    array (
      'name' => 'Parler',
      'pattern' => '^Parler( Staging)?/',
      'examples' => 
      array (
        0 => 'Parler Staging/542 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    366 => 
    array (
      'name' => 'PeaCast',
      'pattern' => '^PeaCast/',
      'examples' => 
      array (
        0 => 'PeaCast/0.7',
      ),
    ),
    367 => 
    array (
      'name' => 'phonostar Radio-App',
      'pattern' => '^phonostar-Player/\\d',
      'examples' => 
      array (
        0 => 'phonostar-Player/4.08',
      ),
      'urls' => 
      array (
        0 => 'https://www.phonostar.de/radio/radioaufnehmen/radio-app',
      ),
    ),
    368 => 
    array (
      'name' => 'Playapod',
      'pattern' => '^Playapod',
      'description' => 'Best Cross-Platform Podcast and News App',
      'urls' => 
      array (
        0 => 'https://playapod.com/',
      ),
      'examples' => 
      array (
        0 => 'Playapod/2.4.11',
      ),
    ),
    369 => 
    array (
      'name' => 'PlaydioCast Podcast Radio',
      'pattern' => '^PlaydioCast/',
      'examples' => 
      array (
        0 => 'PlaydioCast/272 CFNetwork/1496.0.7 Darwin/23.5.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/playdiocast-podcast-radio/id858974970',
      ),
    ),
    370 => 
    array (
      'name' => 'Player FM',
      'pattern' => '^Player FM|^Player%20FM|^Alpha%20PlayerFM/',
      'examples' => 
      array (
        0 => 'Player%20FM/588 CFNetwork/1121.2.2 Darwin/19.2.0',
        1 => 'Alpha%20PlayerFM/108 CFNetwork/808.0.2 Darwin/16.0.0',
      ),
    ),
    371 => 
    array (
      'name' => 'Pocket Casts',
      'pattern' => '^Pocket Casts|^Pocket%20Casts|^PocketCasts/|^Shifty Jelly Pocket Casts',
      'description' => 'A podcast app and web player',
      'svg' => 'pocketcasts.svg',
      'urls' => 
      array (
        0 => 'https://www.pocketcasts.com/',
      ),
      'comments' => '\'PocketCasts\' is a feed parser; \'Pocket Casts\' is the app. There is also a web player.',
      'examples' => 
      array (
        0 => 'Pocket Casts',
        1 => 'Shifty Jelly Pocket Casts, iOS v4.2',
        2 => 'Pocket%20Casts/7.96.0.4 CFNetwork/3826.600.41 Darwin/24.6.0',
        3 => 'Pocket%20Casts/7.95.0.4 CFNetwork/3826.600.41 Darwin/24.6.0',
      ),
    ),
    372 => 
    array (
      'name' => 'Podbay',
      'pattern' => '^Podbay/',
      'examples' => 
      array (
        0 => 'Podbay/21 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
    ),
    373 => 
    array (
      'name' => 'Podbean',
      'pattern' => '^Podbean/',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.podbean.app.podcast',
        1 => 'https://apps.apple.com/us/app/podbean-podcast-app-player/id973361050',
      ),
      'examples' => 
      array (
        0 => 'Podbean/Android App 7.6.4 (http://podbean.com),1927526fe23b5acf535b3e91b64cee95',
        1 => 'Podbean/Android App 8.1.5 (http://podbean.com),4f6852f59091d32475ef75a53325a4fe',
        2 => 'Podbean/Android generic 1.1.2 (http://podbean.com),9376c517335ded9a716022cc1f15c884',
        3 => 'Podbean/iOS (http://podbean.com) 5.2.0 - 19c4ff292bd09cd2ccbad22cc6755a45',
      ),
    ),
    374 => 
    array (
      'name' => 'Podcast Guru',
      'pattern' => '^PodcastGuru',
      'description' => 'Podcast Guru is the simple and free podcast player',
      'urls' => 
      array (
        0 => 'https://podcastguru.io/',
      ),
    ),
    375 => 
    array (
      'name' => 'Podcast Addict',
      'pattern' => '^Podcast.*Addict/|^Podcast Addict ',
      'examples' => 
      array (
        0 => 'PodcastAddict/v2 - Dalvik/2.1.0 (Linux; U; Android 9; SM-N950U Build/PPR1.180610.011)',
        1 => 'PodcastAddict/v5 ( https://podcastaddict.com/; Android podcast app)',
        2 => 'Podcast Addict - Dalvik/2.1.0 (Linux; U; Android 9; SM-G960F Build/PPR1.180610.011)',
      ),
    ),
    376 => 
    array (
      'name' => 'Podcast Archiver',
      'description' => 'Archive all episodes from your favorite podcasts.',
      'pattern' => 'janwh/podcast-archiver',
      'examples' => 
      array (
        0 => 'Podcast-Archiver/0.5.1 (https://github.com/janwh/podcast-archiver)',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/janw/podcast-archiver',
      ),
    ),
    377 => 
    array (
      'name' => 'Podcast Player',
      'pattern' => '^Podcast Player/',
      'examples' => 
      array (
        0 => 'Podcast Player/1.0 (phone;android RMX3195_11_A.18)',
      ),
    ),
    378 => 
    array (
      'name' => 'Podcast Republic',
      'pattern' => '^PodcastRepublic/',
      'examples' => 
      array (
        0 => 'PodcastRepublic/18.0 (Linux; U; Android 10;blueline/QP1A.190711.020.C3)',
        1 => 'PodcastRepublic/18.0 (iPhone; CPU iPhone OS 14_7_1 like Mac OS X)',
      ),
    ),
    379 => 
    array (
      'name' => 'Podcastly',
      'pattern' => '^Podcastly/|^Podcastly$',
      'examples' => 
      array (
        0 => 'Podcastly/1.4.1 (samsung; CPU OS android 11; en_us)',
        1 => 'Podcastly',
      ),
    ),
    380 => 
    array (
      'name' => 'Podcast Saver',
      'pattern' => '^Podcast%20Saver/\\d',
      'examples' => 
      array (
        0 => 'Podcast%20Saver/27 CFNetwork/1498.700.2 Darwin/23.6.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/podcast-saver/id1498364459',
      ),
    ),
    381 => 
    array (
      'name' => 'Podcatcher',
      'pattern' => '^Podcatcher \\d',
      'examples' => 
      array (
        0 => 'Podcatcher 1.3',
        1 => 'Podcatcher 1.3 (+https://podcatcher.net)',
      ),
    ),
    382 => 
    array (
      'name' => 'Podchaser',
      'pattern' => '^Podchaser |^Podchaser-Parser',
      'examples' => 
      array (
        0 => 'Podchaser (https://podchaser.com)',
        1 => 'Podchaser-Parser',
      ),
    ),
    383 => 
    array (
      'name' => 'Podcini',
      'description' => 'Open source podcast player for Android in Kotlin with androidx.media3',
      'pattern' => '^Podcini/\\d',
      'examples' => 
      array (
        0 => 'Podcini/4.6.2',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/XilinJia/Podcini',
      ),
    ),
    384 => 
    array (
      'name' => 'Podclipper',
      'pattern' => '^Podclipper/',
      'examples' => 
      array (
        0 => 'Podclipper/4.2 (miguelDSP.Podclipper; build:4; iOS 13.1.3) Alamofire/4.7.3',
      ),
    ),
    385 => 
    array (
      'name' => 'Podcoin',
      'pattern' => '^Podcoin',
    ),
    386 => 
    array (
      'name' => 'PodCruncher',
      'pattern' => '^PodCruncher/.* CFNetwork/',
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/podcruncher-podcast-player/id421894356',
      ),
      'examples' => 
      array (
        0 => 'PodCruncher/3.7.1 CFNetwork/1125.2 Darwin/19.4.0',
        1 => 'PodCruncher/3.7.1 CFNetwork/978.0.7 Darwin/18.7.0',
      ),
    ),
    387 => 
    array (
      'name' => 'Podeo',
      'pattern' => '^Podeo/',
      'examples' => 
      array (
        0 => 'Podeo/4.2.3 (Linux;Android 12) ExoPlayerLib/2.11.7',
      ),
    ),
    388 => 
    array (
      'name' => 'Podfriend',
      'pattern' => '^Podfriend',
      'description' => 'Podfriend Electron app',
      'urls' => 
      array (
        0 => 'https://podfriend.com',
      ),
      'examples' => 
      array (
        0 => 'Podfriend/1.0 Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) PodFriend/0.7.11 Chrome/83.0.4103.122 Electron/9.2.0 Safari/537.36',
      ),
    ),
    389 => 
    array (
      'name' => 'Podgrab',
      'pattern' => '^Podgrab ',
      'description' => 'A self-hosted podcast manager/downloader/archiver tool to download podcast episodes as soon as they become live with an integrated player.',
      'urls' => 
      array (
        0 => 'https://github.com/akhilrex/podgrab',
      ),
      'examples' => 
      array (
        0 => 'Podgrab - docker',
      ),
    ),
    390 => 
    array (
      'name' => 'Podhero',
      'pattern' => '^Podhero|^Swoot[/ ]',
      'description' => 'Podhero app on iOS and Android.',
      'urls' => 
      array (
        0 => 'https://podhero.com',
      ),
      'examples' => 
      array (
        0 => 'Podhero%20Alpha/4373 CFNetwork/1197 Darwin/20.0.0',
        1 => 'Swoot Agent 1.0',
      ),
    ),
    391 => 
    array (
      'name' => 'Podhome',
      'pattern' => '^Podhome App',
      'description' => 'Podhome app on iOS, Android and Web.',
      'urls' => 
      array (
        0 => 'https://www.podhome.fm/',
      ),
      'examples' => 
      array (
        0 => 'Podhome App/1.0 CFNetwork/1121.2.2 Darwin/19.2.0',
        1 => 'Podhome App/1.0 (Linux; Android 10; SM-G960F Build/QP1A.190711.020) ExoPlayerLib/2.10.4',
      ),
    ),
    392 => 
    array (
      'name' => 'Podimo',
      'pattern' => '^Podimo/',
      'urls' => 
      array (
        0 => 'https://apps.apple.com/dk/app/podimo-a-world-of-podcasts/id1476538730',
        1 => 'https://play.google.com/store/apps/details?id=com.podimo&hl=en_US',
      ),
      'examples' => 
      array (
        0 => 'Podimo/1.11.3 build 121/iOS 13.3',
        1 => 'Podimo/1.11.3 build 91/Android 28',
      ),
    ),
    393 => 
    array (
      'name' => 'Podium Podcast',
      'pattern' => '^Podium/\\d',
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/podium-podcast/id1151134762',
      ),
      'examples' => 
      array (
        0 => 'Podium/2.5.4 iOS_iPhone 15.0 Build 11',
      ),
    ),
    394 => 
    array (
      'name' => 'PodKast app',
      'pattern' => '.*PodKast$',
      'description' => 'PodKast is a podcast app available for KaiOS smartphones',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Mobile; M571M3; rv:48.0) Gecko/48.0 Firefox/48.0 KAIOS/2.5.1.2 PodKast',
        1 => 'KaiOS Downloader PodKast',
      ),
    ),
    395 => 
    array (
      'name' => 'Podkicker Pro',
      'pattern' => '^Podkicker',
    ),
    396 => 
    array (
      'name' => 'PodLink',
      'pattern' => 'PodLink',
      'svg' => 'podlink.svg',
      'urls' => 
      array (
        0 => 'https://pod.link/faq/crawler',
      ),
    ),
    397 => 
    array (
      'name' => 'PodLP podcast app for KaiOS',
      'pattern' => '.*PodLP/',
      'description' => 'PodLP is the first podcast app available for KaiOS smart feature phones on the KaiStore.',
      'urls' => 
      array (
        0 => 'https://podlp.com',
      ),
      'comments' => 'Introduced in version v1.2.0.0 for limited content (downloads); available for all content after v1.3.0.0',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Mobile; LYF/F271i/LYF_F271i-000-01-20-101019; Android; rv:48.0) Gecko/48.0 Firefox/48.0 KAIOS/2.5 PodLP/1.3.2.0',
      ),
    ),
    398 => 
    array (
      'name' => 'PodMe',
      'pattern' => '^Podme android app/|^PodMe/',
      'examples' => 
      array (
        0 => 'Podme android app/5.1 (Linux;Android 9) ExoPlayerLib/2.11.5',
        1 => 'PodMe/10289 CFNetwork/1240.0.4 Darwin/20.6.0',
      ),
    ),
    399 => 
    array (
      'name' => 'PodMN',
      'pattern' => '^PodMN/',
      'description' => 'Minnesota Podcasts Live Here',
      'svg' => 'podmn.svg',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.podmn.app',
        1 => 'https://apps.apple.com/us/app/podmn/id1464935818',
      ),
      'examples' => 
      array (
        0 => 'PodMN/Android 1.2.6 (Android 7.1.1; SM-J510FN Build/NMF26X)',
        1 => 'PodMN/iOS 1.2.6 (iPhone XR/13.6.1)',
      ),
    ),
    400 => 
    array (
      'name' => 'PodNL',
      'pattern' => '^PodNL/',
      'examples' => 
      array (
        0 => 'PodNL/47 CFNetwork/1107.1 Darwin/19.0.0',
      ),
    ),
    401 => 
    array (
      'name' => 'Podnods',
      'pattern' => 'podnods-player',
      'description' => 'Podnods is a podcast discovery site. This user agent is for users to sample and play podcasts.',
      'urls' => 
      array (
        0 => 'https://podnods.com/about',
      ),
    ),
    402 => 
    array (
      'name' => 'Podopolo',
      'pattern' => '^Podopolo|^podopolo/',
      'description' => 'Listen with passion - connect with purpose',
      'urls' => 
      array (
        0 => 'https://podopolo.com/',
      ),
      'examples' => 
      array (
        0 => 'podopolo/36 CFNetwork/1312 Darwin/20.4.0',
      ),
    ),
    403 => 
    array (
      'name' => 'Podplay',
      'pattern' => '^Podplay/',
      'examples' => 
      array (
        0 => 'Podplay/21.06.23 (Linux;Android 11) ExoPlayerLib/2.13.3',
      ),
    ),
    404 => 
    array (
      'name' => 'PodPuppy',
      'pattern' => 'felixwatts/PodPuppy',
      'examples' => 
      array (
        0 => 'PodPuppy 1.0.0.0 github.com/felixwatts/PodPuppy',
      ),
    ),
    405 => 
    array (
      'name' => 'PodQast',
      'pattern' => '^PodQast/',
      'examples' => 
      array (
        0 => 'PodQast/2.23 +https://gitlab.com/cy8aer/podqast',
      ),
    ),
    406 => 
    array (
      'name' => 'Pods',
      'pattern' => '^Pods/',
      'examples' => 
      array (
        0 => 'Pods/1 CFNetwork/1312 Darwin/21.0.0',
      ),
    ),
    407 => 
    array (
      'name' => 'Podurama',
      'pattern' => '^Podurama',
      'description' => 'Best free cross-platform podcast app',
      'urls' => 
      array (
        0 => 'https://podurama.com',
      ),
      'examples' => 
      array (
        0 => 'Podurama/4.0.8.1 CFNetwork/1390 Darwin/22.0.0',
      ),
    ),
    408 => 
    array (
      'name' => 'PodTrapper',
      'pattern' => '^PodTrapper',
      'examples' => 
      array (
        0 => 'PodTrapper',
      ),
    ),
    409 => 
    array (
      'name' => 'Podvine',
      'pattern' => '^Podvine/\\d',
      'examples' => 
      array (
        0 => 'Podvine/3.3.1 (www.podvine.com)',
      ),
      'urls' => 
      array (
        0 => 'https://podvine.com/',
      ),
    ),
    410 => 
    array (
      'name' => 'Podverse',
      'pattern' => '^[Pp]odverse/',
      'description' => 'Open source podcast catcher for Android, with clip-sharing, playlists, device syncing and more.',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.podverse&hl=en_US',
        1 => 'https://apps.apple.com/us/app/podverse/id1390888454',
      ),
      'comments' => 'The standard device user agent was formerly concatenated to the end of the Podverse/Android Mobile App/ user agent.',
      'examples' => 
      array (
        0 => 'Podverse/Android Mobile App',
        1 => 'Podverse/F-Droid Android Mobile App/',
        2 => 'Podverse/Android Mobile App/Mozilla/5.0 (Linux; Android 12; SM-S134DL Build/SP1A.210812.016; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/105.0.5195.136 Mobile Safari/537.36',
        3 => 'Podverse/iOS Mobile App',
        4 => 'Podverse/iOS Mobile App/Mozilla/5.0 (iPhone; CPU iPhone OS 13_6_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/1234',
        5 => 'podverse/393 CFNetwork/1128.0.1 Darwin/19.6.0',
      ),
    ),
    411 => 
    array (
      'name' => 'Podyssey',
      'pattern' => 'Podyssey App|com\\.toysinboxes\\.Echo|fm\\.podyssey\\.podcasts|^Podyssey',
      'description' => 'Podyssey is a community for people that love podcasts. It\'s like Goodreads, but for podcasts.',
      'urls' => 
      array (
        0 => 'https://podyssey.fm',
      ),
      'examples' => 
      array (
        0 => 'Podyssey',
      ),
    ),
    412 => 
    array (
      'name' => 'Pratilipi FM',
      'pattern' => '^Pratilipi FM/\\d',
      'examples' => 
      array (
        0 => 'Pratilipi FM/6.3.2 (Linux;Android 14) AndroidXMedia3/1.2.1',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.pratilipi.android.pratilipifm&hl=en_US',
      ),
    ),
    413 => 
    array (
      'name' => 'ProCast',
      'pattern' => '^Pro[Cc]ast/\\d|^com\\.podflitzer\\.android/\\d|^Procast \\(',
      'description' => 'The new generation of Podcast player.',
      'urls' => 
      array (
        0 => 'https://podcast-app.de/',
      ),
      'examples' => 
      array (
        0 => 'ProCast/1 CFNetwork/1240.0.4 Darwin/20.6.0',
        1 => 'com.podflitzer.android/1.8.1 (Linux;Android 10) AndroidXMedia3/1.4.1',
        2 => 'Procast (iOS)',
      ),
    ),
    414 => 
    array (
      'name' => 'PugPig Bolt',
      'pattern' => '^PugpigBolt ',
      'examples' => 
      array (
        0 => 'PugpigBolt 2.29.3 (iPhone, iOS 16.1.1) on phone (model iPhone12,1)',
        1 => 'PugpigBolt 2.14.7 (samsung, Android 12) on phone (model SM-F721U1)',
      ),
      'urls' => 
      array (
        0 => 'https://www.pugpig.com/products-and-services',
      ),
    ),
    415 => 
    array (
      'name' => 'Pypodder',
      'description' => 'A scriptable podcatcher written in python 3',
      'pattern' => '^pypodder$',
      'examples' => 
      array (
        0 => 'pypodder',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/Northcode/pypodder',
      ),
    ),
    416 => 
    array (
      'name' => 'Queue',
      'pattern' => '^Queue/\\d',
      'examples' => 
      array (
        0 => 'Queue/1.9.1 (1) (iOS)',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/queue-simple-podcasts/id6639586996',
      ),
    ),
    417 => 
    array (
      'name' => 'Radio Downloader',
      'pattern' => '^Podcast Provider.*?Radio Downloader',
      'description' => 'An easy to use application for managing podcast subscriptions and downloads.',
      'examples' => 
      array (
        0 => 'Podcast Provider 0.34-9e9009e7 for Radio Downloader 0.34-9e9009e7',
      ),
      'urls' => 
      array (
        0 => 'https://nerdoftheherd.com/tools/radiodld/',
      ),
    ),
    418 => 
    array (
      'name' => 'Radio France',
      'pattern' => '^AppRF/\\d|^com\\.radiofrance\\.radio\\.radiofrance\\.android/|^RadioFrance/\\d|^Radio France/\\d',
      'examples' => 
      array (
        0 => 'AppRF/9.9.1_250221.1453 iPhone13,2 iOS/18.3.1 CFNetwork/9.9.1 Darwin/24.3.0',
        1 => 'com.radiofrance.radio.radiofrance.android/9.10.0-android(83646)/Android 14/mobile/SM-A156B',
        2 => 'Radio France/9.10.0 TransistorKit/5.0.1 iOS/18.3.1 iPhone13,1',
        3 => 'RadioFrance/9.10.0 RFPlayer/1.63.0 AndroidXMedia3/1.5.1 Dalvik/2.1.0 (Linux; U; Android 14; sdk_gphone64_arm64 Build/UE1A.230829.036.A4)',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/fr/app/radio-france-podcast-direct/id310211433',
        1 => 'https://play.google.com/store/apps/details?id=com.radiofrance.radio.radiofrance.android&hl=fr',
      ),
    ),
    419 => 
    array (
      'name' => 'Radio thmanyah',
      'pattern' => '^Radio thmanyah ',
      'examples' => 
      array (
        0 => 'Radio thmanyah (iOS 17.2.1)',
        1 => 'Radio thmanyah (Android 12;Pixel 6a)',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.thmanyah.podcast&hl=en_US&gl=US',
        1 => 'https://apps.apple.com/tr/app/radio-thmanyah-%D8%B1%D8%A7%D8%AF%D9%8A%D9%88-%D8%AB%D9%85%D8%A7%D9%86%D9%8A%D8%A9/id1641282078',
      ),
    ),
    420 => 
    array (
      'name' => 'radio.de',
      'pattern' => '^(radio\\.[a-z]{2,3}|GetPodcast)[ /]\\d',
      'description' => 'Radio.de is a radio and podcast app in Germany',
      'urls' => 
      array (
        0 => 'https://www.radio.de/',
        1 => 'https://www.radio.net/',
      ),
      'examples' => 
      array (
        0 => 'radio.fr 5.6.22 (iPhone; iPhone OS 16.4; fr_FR)',
        1 => 'radio.de 5.6.22 (iPad; iPhone OS 16.4; de_DE)',
        2 => 'radio.de 5.6.22 (iPhone; iPhone OS 16.4; de_DE)',
        3 => 'radio.net 5.7.3 (iPhone; iPhone OS 17.0.1; fr_FR)',
        4 => 'GetPodcast 5.6.22 (iPhone; iPhone OS 16.4; de_DE)',
        5 => 'GetPodcast 5.6.22 (iPhone; 16.4; de_DE)',
        6 => 'radio.de/4671 CFNetwork/1121.2.2 Darwin/19.2.0',
        7 => 'radio.de/5.10.5.3 (Linux; 13) ExoPlayerLib/2.18.2',
        8 => 'radio.de/5.10.3.0 (Linux;Android 13) ExoPlayerLib/2.18.2',
        9 => 'radio.de/5.10.5.3 (Linux; Android 13) ExoPlayerLib/2.18.2',
        10 => 'radio.de/5.10.5.3 (Linux; Android 13; de_DE) ExoPlayerLib/2.18.2',
        11 => 'radio.de/5.10.5.3 (Linux; Android 13; zn-Hans) ExoPlayerLib/2.18.2',
        12 => 'GetPodcast/5.10.5.3 (Linux; Android 13; de_DE) ExoPlayerLib/2.18.2',
      ),
      'comments' => 'radio.de GmbH is the operator of the international service radio.net as well as the regional platforms radio.de, radio.at, radio.fr, radio.se, radio.dk, radio.pt, radio.es, radio.it, radio.pl and GetPodcast',
    ),
    421 => 
    array (
      'name' => 'Radioline',
      'pattern' => '^Radioline%202/|^Radioline$',
      'examples' => 
      array (
        0 => 'Radioline%202/5.8.4 CFNetwork/1107.1 Darwin/19.0.0',
        1 => 'Radioline',
      ),
    ),
    422 => 
    array (
      'name' => 'RadioPlayer',
      'pattern' => '(^Radioplayer Android app|^Radioplayer iOS app)|^Radioplayer(%20UK)?/',
      'description' => 'Radioplayer is a radio and podcast app, with country-specific versions available in selected countries.',
      'urls' => 
      array (
        0 => 'http://radioplayer.org',
      ),
      'examples' => 
      array (
        0 => 'Radioplayer/7.7.4.100 ios/17.2.1 AVPlayer/5.0.0 (Swift) Radioplayer Worldwide Ltd',
        1 => 'Radioplayer/7.7.4.100 android/13 ExoPlayer/2.18.1 Radioplayer Worldwide Ltd',
        2 => 'Radioplayer/100 CFNetwork/1490.0.4 Darwin/23.2.0',
        3 => 'Radioplayer%20UK/815 CFNetwork/1490.0.4 Darwin/23.2.0',
      ),
    ),
    423 => 
    array (
      'name' => 'RadioPublic',
      'pattern' => '^RadioPublic/android-|^RadioPublic Android|RadioPublic iOS|RadioPublic.+CFNetwork|^RadioPublic/iOS|^RadioPublicDraper/',
      'description' => 'RadioPublic’s free, easy to use podcast player makes listening to podcasts simple, enjoyable, and fun.',
      'svg' => 'radiopublic.svg',
      'urls' => 
      array (
        0 => 'https://radiopublic.com/',
      ),
      'examples' => 
      array (
        0 => 'RadioPublic/android-2.2',
        1 => 'RadioPublic/iOS-2.0',
        2 => 'RadioPublicDraper/81b12be Faraday/0.15.2 ruby/2.3.8',
      ),
    ),
    424 => 
    array (
      'name' => 'Radios México',
      'pattern' => '^Radios%20M%C3%A9xico/\\d',
      'examples' => 
      array (
        0 => 'Radios%20M%C3%A9xico/14 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/radios-m%C3%A9xico/id1042399696',
      ),
    ),
    425 => 
    array (
      'name' => 'Reeder',
      'pattern' => '^Reeder/',
      'examples' => 
      array (
        0 => 'Reeder/5040002 CFNetwork/1404.0.5 Darwin/22.3.0',
      ),
    ),
    426 => 
    array (
      'name' => 'Relevant Radio',
      'pattern' => '^Relevant Radio/',
      'examples' => 
      array (
        0 => 'Relevant Radio/Android 4.0.11 (moto g stylus (2022)/Android 12 Build S3RDES32.123-37-5-22)',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.jacobsmedia.relevantradio&hl=en_US',
      ),
    ),
    427 => 
    array (
      'name' => 'Repod',
      'pattern' => '(^Repod/.+iOS|^Repod/.+Android)',
      'description' => 'Repod is a social podcast app that helps creators engage, montetization, and grow their community.',
      'svg' => 'repod.svg',
      'urls' => 
      array (
        0 => 'https://repod.io/',
      ),
      'examples' => 
      array (
        0 => 'Repod/2.9.0.363 CFNetwork/1240.0.4 Darwin/20.6.0 (iPhone/X iOS/14.7.1)',
        1 => 'Repod/2.9.0.221 Mozilla/5.0 (Linux; Android 11; Pixel 3 Build/RQ3A.210905.001; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/94.0.4606.85 Mobile Safari/537.36',
      ),
    ),
    428 => 
    array (
      'name' => 'Roka Stereo',
      'pattern' => '^Roka Stereo/',
      'examples' => 
      array (
        0 => 'Roka Stereo/2.0.0 (com.goodbarber.rokastereo; build:110; iOS 13.7.0) Alamofire/4.8.2',
      ),
    ),
    429 => 
    array (
      'name' => 'Roku',
      'pattern' => '^Roku/',
      'examples' => 
      array (
        0 => 'Roku/DVP-9.10 (499.10E04121A)',
      ),
    ),
    430 => 
    array (
      'name' => 'Rhythmbox',
      'pattern' => '(^gvfs/|^rhythmbox/)',
      'description' => 'Rhythmbox is your one-stop multimedia application, supporting a music library, multiple playlists, internet radio, and more.',
      'urls' => 
      array (
        0 => 'https://gitlab.gnome.org/GNOME/rhythmbox',
      ),
      'comments' => 'The new UA is Rhythmbox: https://gitlab.gnome.org/GNOME/rhythmbox/-/issues/1855',
      'examples' => 
      array (
        0 => 'gvfs/1.46.1',
      ),
    ),
    431 => 
    array (
      'name' => 'RSS Radio',
      'pattern' => '^RSSRadio|^RSS Radio -',
      'urls' => 
      array (
        0 => 'http://rssrad.io',
      ),
      'examples' => 
      array (
        0 => 'RSSRadio7/9252 CFNetwork/1107.1 Darwin/19.0.0',
        1 => 'RSSRadio/9710',
        2 => 'RSS Radio - Player FM',
      ),
    ),
    432 => 
    array (
      'name' => 'RSSDemon',
      'description' => 'RssDemon is a powerful, clean and easy to use Rss Feed and podcast reader.',
      'pattern' => 'com\\.meecel\\.feedreader\\.RssDemonAd',
      'examples' => 
      array (
        0 => 'com.meecel.feedreader.RssDemonAd',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.meecel.feedreader.RssDemonAd',
      ),
    ),
    433 => 
    array (
      'name' => 'RSSOwl',
      'pattern' => '^RSSOwl.*Windows',
      'description' => 'A Mac and Windows app, to help organize, search, and read feeds',
      'urls' => 
      array (
        0 => 'http://www.rssowl.org/',
      ),
      'examples' => 
      array (
        0 => 'RSSOwl/2.2.1.201312301314 (Windows; U; en)',
      ),
    ),
    434 => 
    array (
      'name' => 'RTL+',
      'pattern' => 'RTL\\+',
      'examples' => 
      array (
        0 => 'RTL+',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/de/app/rtl/id1057991212',
        1 => 'https://play.google.com/store/apps/details?id=de.rtli.tvnow&hl=en_US&gl=US',
      ),
    ),
    435 => 
    array (
      'name' => 'SachNoi',
      'pattern' => '^SachNoi\\.app/|^SachNoiApp/',
      'examples' => 
      array (
        0 => 'SachNoi.app/1 CFNetwork/1197 Darwin/20.0.0',
        1 => 'SachNoiApp/2 CFNetwork/1128.0.1 Darwin/19.6.0',
      ),
    ),
    436 => 
    array (
      'name' => 'Samsung Podcasts',
      'pattern' => '^sp-agent',
      'urls' => 
      array (
        0 => 'https://developer.samsung.com/podcasts',
      ),
      'examples' => 
      array (
        0 => 'sp-agent',
      ),
      'comments' => 'aka Samsung Free',
    ),
    437 => 
    array (
      'name' => 'Seekr',
      'pattern' => '^Seekr/\\d',
      'urls' => 
      array (
        0 => 'https://www.seekyoursounds.com',
      ),
      'examples' => 
      array (
        0 => 'Seekr/1.6.0.748-debug Dalvik/2.1.0 (Linux; U; Android 14; SM-S928W Build/UP1A.231005.007)',
        1 => 'Seekr/1077 CFNetwork/3826.400.120 Darwin/24.3.0',
      ),
    ),
    438 => 
    array (
      'name' => 'ServeStream',
      'pattern' => '^ServeStream Dynamo/|^ServeStream$',
      'examples' => 
      array (
        0 => 'ServeStream Dynamo/1.0',
        1 => 'ServeStream',
      ),
    ),
    439 => 
    array (
      'name' => 'Shadow',
      'pattern' => '^Shadow',
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/shadow/id940127690',
      ),
    ),
    440 => 
    array (
      'name' => 'SiriusXM',
      'pattern' => '^SiriusXM/\\d|SXMApp|sxm-android|sxm-apple/',
      'examples' => 
      array (
        0 => 'SiriusXM/1608138304 CFNetwork/1206 Darwin/20.1.0',
        1 => 'SXMApp/36270 CFNetwork/1496.0.7 Darwin/23.5.0',
        2 => 'sxm-android/7.5.2 samsung/SM-S918U Android/14',
        3 => 'sxm-android/7.5.0 motorola/motorola-edge-plus-5G-UW-(2022) Android/13',
        4 => 'sxm-apple/7.8.1 iPhone14,5 iOS17.6.1',
      ),
    ),
    441 => 
    array (
      'name' => 'Slack',
      'pattern' => '^Slack/',
    ),
    442 => 
    array (
      'name' => 'Snipd',
      'pattern' => '^Snipd/',
      'urls' => 
      array (
        0 => 'https://www.snipd.com/',
      ),
      'examples' => 
      array (
        0 => 'Snipd/90 CFNetwork/1329 Darwin/21.3.0',
      ),
    ),
    443 => 
    array (
      'name' => 'Snapchat',
      'pattern' => 's~snapchat-proxy',
      'examples' => 
      array (
        0 => 'AppEngine-Google; (+http://code.google.com/appengine; appid: s~snapchat-proxy)',
      ),
    ),
    444 => 
    array (
      'name' => 'Sodes',
      'pattern' => '^Sodes/',
      'examples' => 
      array (
        0 => 'Sodes/1657 CFNetwork/1098.6 Darwin/19.0.0',
      ),
    ),
    445 => 
    array (
      'name' => 'Sonnet',
      'pattern' => '(Sonnet|^Simple Podcast Player)',
      'description' => 'Sonnet is a simple, easy to use podcast app aimed at new listeners',
      'svg' => 'sonnet.svg',
      'urls' => 
      array (
        0 => 'https://sonnet.fm',
      ),
      'examples' => 
      array (
        0 => 'Simple Podcast Player/1.8 (Linux;Android 12) ExoPlayerLib/2.10.1',
      ),
    ),
    446 => 
    array (
      'name' => 'Sony PlayStation 5',
      'pattern' => '^sony_tv;ps5;',
      'examples' => 
      array (
        0 => 'sony_tv;ps5;9b18101888dd42948afd0b8792122bec;;tpapi;3.200.405',
      ),
      'comments' => 'Possibly altered by Checkpoint Threat Prevention API',
    ),
    447 => 
    array (
      'name' => 'Sonos',
      'pattern' => 'Sonos',
    ),
    448 => 
    array (
      'name' => 'SoundOn',
      'pattern' => '^SoundOn/',
      'examples' => 
      array (
        0 => 'SoundOn/1.9.17 (Linux;Android 10) ExoPlayerLib/2.9.4',
        1 => 'SoundOn/1.10.1',
        2 => 'SoundOn/2.2.0',
        3 => 'SoundOn/2.2.2 (iOS)',
      ),
    ),
    449 => 
    array (
      'name' => 'SoundWaves',
      'pattern' => '^SoundWaves-\\d',
      'examples' => 
      array (
        0 => 'SoundWaves-0.160.2',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.dne.wavesapp&hl=en_US&gl=US',
      ),
    ),
    450 => 
    array (
      'name' => 'Sportbladet Android app',
      'pattern' => 'Android Sportbladet Hermes/',
      'description' => 'Sportbladet Android app',
      'examples' => 
      array (
        0 => 'Android Sportbladet Hermes/1000094692 _app_',
      ),
    ),
    451 => 
    array (
      'name' => 'Sportbladet iOS app',
      'pattern' => 'iOS Sportbladet Hermes/',
      'description' => 'Sportbladet iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS Sportbladet Hermes/90.0.0 _app_',
      ),
    ),
    452 => 
    array (
      'name' => 'Spotify',
      'pattern' => '^Spotify/.+Linux|Macintosh.+Spotify/|^Spotify/.+OSX|Windows.+Spotify/|^Spotify/.+Win32|^Spotify/.+Android|^Spotify/.+iOS|^Spotify/.+Polestar|^Spotify/.+Volvo|^spotify_|^Spotify-Lite|^Spotify/\\d',
      'examples' => 
      array (
        0 => 'Spotify/8.7.10 iOS/15.3.1 (iPhone13,2)',
        1 => 'spotify_other-mobile',
        2 => 'spotify_android-tablet',
        3 => 'Spotify-Lite: Spotify-Lite/0.13.48.96 Android/22 (SM-G531H)',
        4 => 'Spotify/4.3.2.0 Polestar/30 (Polestar)',
        5 => 'Spotify/4.3.2.0 Volvo/30 (Volvo)',
        6 => 'Spotify/8.7.76.359 SM-R870/30 (SM-R870)',
      ),
    ),
    453 => 
    array (
      'name' => 'Spreaker',
      'pattern' => '^Spreaker for Android|^Spreaker Custom App for (Android|iOS)|Spreaker/|^Spreaker \\d',
      'examples' => 
      array (
        0 => 'Spreaker Custom App for Android 5.5.3 release:2021-04-08 device:phone (samsung SM-N986B; Android 12; it_IT)',
        1 => 'Spreaker Custom App for iOS 2.2.2 rv:6302 (iPhone15,3; iOS 18.1.1; en_US) SPKAudioPlayer',
        2 => 'Spreaker 7.17.0 rv:1300 (iPhone8,4; iOS 15.8.3; en_CA)',
      ),
    ),
    454 => 
    array (
      'name' => 'Sprewell',
      'pattern' => '^Sprewell/',
      'description' => 'A \'world podcast player\' for iOS and Android',
      'examples' => 
      array (
        0 => 'Sprewell/101 CFNetwork/1494.0.7 Darwin/23.4.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/sprewell-podcast/id1497544057',
        1 => 'https://play.google.com/store/apps/details?id=com.sprewellpodcast.app&hl=en&gl=US',
      ),
    ),
    455 => 
    array (
      'name' => 'Stavanger Aftenblad Android app',
      'pattern' => 'Android SA Hermes/',
      'description' => 'Stavanger Aftenblad Android app',
      'examples' => 
      array (
        0 => 'Android SA Hermes/1000094692 _app_',
      ),
    ),
    456 => 
    array (
      'name' => 'Stavanger Aftenblad iOS app',
      'pattern' => 'iOS SA Hermes/',
      'description' => 'Stavanger Aftenblad iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS SA Hermes/90.0.0 _app_',
      ),
    ),
    457 => 
    array (
      'name' => 'Stitcher',
      'pattern' => '^Stitcher/|^Stitcher Demo/|^AlexaMediaPlayer/Stitcher',
      'examples' => 
      array (
        0 => 'Stitcher Demo/4.8.0 (Linux;Android 11) ExoPlayerLib/2.10.7',
        1 => 'Stitcher/Android',
        2 => 'Stitcher/28420 CFNetwork/609.1.4 Darwin/13.0.0',
      ),
    ),
    458 => 
    array (
      'name' => 'Stoler Report',
      'pattern' => '^Stoler(%20| )Report/',
      'examples' => 
      array (
        0 => 'Stoler%20Report/1.4 CFNetwork/672.1.14 Darwin/14.0.0',
        1 => 'Stoler Report/1.4 CFNetwork/672.1.14 Darwin/14.0.0',
      ),
    ),
    459 => 
    array (
      'name' => 'Storiyoh',
      'pattern' => '^Storiyoh/',
    ),
    460 => 
    array (
      'name' => 'Storybutton',
      'description' => 'An audio player device for kids',
      'pattern' => '^Storybutton/',
      'examples' => 
      array (
        0 => 'Storybutton/1.0',
      ),
      'urls' => 
      array (
        0 => 'https://storybutton.com/',
      ),
    ),
    461 => 
    array (
      'name' => 'StoryShots',
      'pattern' => '^StoryShots/',
      'examples' => 
      array (
        0 => 'StoryShots/1.9.72 (Linux;Android 9) ExoPlayerLib/2.11.4',
      ),
    ),
    462 => 
    array (
      'name' => 'Storytel',
      'pattern' => '^Storytel(Downloader)?/\\d',
      'examples' => 
      array (
        0 => 'Storytel/24.50.0 (iPadOS 18.1; iPad13,18) Release/449.1',
        1 => 'Storytel/25.2 (Android 8.0.0; HUAWEI AGSL09) Release/2288820',
        2 => 'Storytel/24.52 (Android 14; samsung SMG991U1) Release/2288809',
        3 => 'StorytelDownloader/1.0',
      ),
      'urls' => 
      array (
        0 => 'https://www.storytel.com/tv/podcasts',
      ),
    ),
    463 => 
    array (
      'name' => 'Strilen iOS app',
      'pattern' => 'iOS Strilen Hermes/',
      'description' => 'Strilen iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS Strilen Hermes/90.0.0 _app_',
      ),
    ),
    464 => 
    array (
      'name' => 'Subcast',
      'pattern' => '^Subcast',
    ),
    465 => 
    array (
      'name' => 'Substack',
      'pattern' => '^Substack/',
      'description' => 'Substack iOS app',
      'examples' => 
      array (
        0 => 'Substack/1457 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
      'urls' => 
      array (
        0 => 'https://substack.com/',
      ),
      'comments' => 'App doesn\'t download yet, and plays/streams with AppleCoreMedia ua, but other API calls use this ua',
    ),
    466 => 
    array (
      'name' => 'Supla',
      'pattern' => '^Supla/\\d',
      'examples' => 
      array (
        0 => 'Supla/157 iPhone16,1 iOS/18.2.1 CFNetwork/1.0 Darwin/24.2.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/supla/id1048533570',
      ),
    ),
    467 => 
    array (
      'name' => 'Svenska Dagbladet iOS app',
      'pattern' => 'iOS SvD Hermes/',
      'description' => 'Svenska Dagbladet iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS SvD Hermes/90.0.0 _app_',
      ),
      'comments' => 'Must match above android app',
    ),
    468 => 
    array (
      'name' => 'Svenska Dagbladet Android app',
      'pattern' => 'SvD Hermes/',
      'description' => 'Svenska Dagbladet Android app',
      'examples' => 
      array (
        0 => 'SvD Hermes/999999999 _app_',
      ),
      'comments' => 'Must match after ios app',
    ),
    469 => 
    array (
      'name' => 'SWAPA',
      'pattern' => '^SWAPA/\\d',
      'examples' => 
      array (
        0 => 'SWAPA/171 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/swapa/id766906650',
      ),
    ),
    470 => 
    array (
      'name' => 'Swinsian',
      'pattern' => '^Swinsian/',
      'urls' => 
      array (
        0 => 'https://swinsian.com/',
      ),
      'examples' => 
      array (
        0 => 'Swinsian/472 CFNetwork/978.0.7 Darwin/18.7.0 (x86_64)',
      ),
    ),
    471 => 
    array (
      'name' => 'Sybel',
      'pattern' => '^Sybel$',
      'examples' => 
      array (
        0 => 'Sybel',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/sybel-audio-series-podcasts/id1396497254',
      ),
    ),
    472 => 
    array (
      'name' => 'SYOK',
      'pattern' => '^SYOK|^my\\.com\\.astro\\.player',
      'examples' => 
      array (
        0 => 'SYOK/965 CFNetwork/1406.0.4 Darwin/22.4.0',
        1 => 'my.com.astro.player',
      ),
      'urls' => 
      array (
        0 => 'https://syok.my/',
      ),
    ),
    473 => 
    array (
      'name' => 'Tatori',
      'pattern' => '^Tatori/\\d',
      'examples' => 
      array (
        0 => 'Tatori/96 CFNetwork/3826.400.120 Darwin/24.3.0',
      ),
      'urls' => 
      array (
        0 => 'https://tatori.justinandrews.net/',
        1 => 'https://apps.apple.com/us/app/tatori-podcasts-audiobooks/id1398063696',
      ),
    ),
    474 => 
    array (
      'name' => 'TED',
      'pattern' => '^TED |^TED/',
      'examples' => 
      array (
        0 => 'TED POD-2.0.2',
        1 => 'TED/2941 CFNetwork/976 Darwin/18.2.0',
        2 => 'TED Android; Version 3.3.3; OPPO R15 9',
      ),
    ),
    475 => 
    array (
      'name' => 'Telmate',
      'pattern' => '^telmate-audio-player',
      'examples' => 
      array (
        0 => 'telmate-audio-player',
      ),
      'urls' => 
      array (
        0 => 'https://www.telmate.com/wp-content/uploads/2017/05/TEL-DS-TelmateDevices-8.5x11-SMALL-r8.pdf',
      ),
    ),
    476 => 
    array (
      'name' => 'The Athletic',
      'pattern' => '(^theathletic-| theathletic-)',
      'examples' => 
      array (
        0 => 'theathletic-ios/13.88.0,(10983.250528d) iPhone17,5 iOS/18.5 CFNetwork/1.0 Darwin/24.5.0',
        1 => 'Mozilla/5.0 (Linux; Android 15; Pixel 8a Build/BP1A.250505.005.B1; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/138.0.7204.67 Mobile Safari/537.36 theathletic-android',
        2 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) theathletic-ios/13.92.0 (11205.250625d)',
      ),
      'urls' => 
      array (
        0 => 'https://www.theathletic.com/',
        1 => 'https://apps.apple.com/us/app/the-athletic-sports-news/id1135216317',
        2 => 'https://play.google.com/store/apps/details?id=com.theathletic',
      ),
    ),
    477 => 
    array (
      'name' => 'The God Minute',
      'pattern' => '^The God Minute/',
      'examples' => 
      array (
        0 => 'The God Minute/8 CFNetwork/1125.2 Darwin/19.4.0',
      ),
    ),
    478 => 
    array (
      'name' => 'The Economist',
      'pattern' => '(^lamarr-iOS|^TheEconomist-Lamarr-ios|^TheEconomist-Lamarr-iOS|^lamarr-android|^TheEconomist-Lamarr-android)',
      'examples' => 
      array (
        0 => 'lamarr-iOS-2.20.3-116',
        1 => 'TheEconomist-Lamarr-ios-2.22.2-12002',
        2 => 'TheEconomist-Lamarr-iOS-3.44.1-2',
        3 => 'lamarr-android-2.18.1-21810',
        4 => 'TheEconomist-Lamarr-android-2.22.2-12002',
      ),
    ),
    479 => 
    array (
      'name' => 'The Podcast App',
      'pattern' => '^ThePodcastApp|iOS.*The Podcast App/|com\\.evolve\\.podcast/|^podcast/\\d* |^PodcastApp/\\d',
      'examples' => 
      array (
        0 => 'ThePodcastApp/6.23.0 (iPhone; iOS 15.6.1; ) player (build 6272; +https://podcast.app/)',
        1 => 'ThePodcastApp/6.28.1 (iPhone; iOS 16.0.2; ) player (build 6391; +https://podcast.app/)',
        2 => 'podcast/2358 iOS/Version 13.5.1 (Build 017F80) The Podcast App/3.22.1',
        3 => 'com.evolve.podcast/3.22.1 (iPhone; ) (build 2358, iOS 13.5.1)',
        4 => 'podcast/ CFNetwork/1107 Darwin/19.0.0',
        5 => 'podcast/878 CFNetwork/1335.0.3 Darwin/21.6.0',
        6 => 'PodcastApp/22.10.30 CFNetwork/1333.0.4 Darwin/21.5.0',
      ),
    ),
    480 => 
    array (
      'name' => 'Twipe Mobile App',
      'pattern' => '^TwipeMobileApp',
      'examples' => 
      array (
        0 => 'TwipeMobileApp PLATFORM=iOS VERSION=5.4.7.0 ENV=PROD isPhone',
        1 => 'TwipeMobileApp PLATFORM=Android VERSION=5.4.7.0 ENV=PROD isTablet',
      ),
      'urls' => 
      array (
        0 => 'https://www.twipemobile.com/',
      ),
    ),
    481 => 
    array (
      'name' => 'miaocast',
      'pattern' => '^miaocast ',
      'examples' => 
      array (
        0 => 'miaocast 2025.1.0 Android 15 vivo I2407i iQOO/I2407i/I2407:15/AP3A.240905.015.A2_V000L1/compiler250513211815:user/release-keys',
      ),
      'urls' => 
      array (
        0 => 'https://www.miaocast.com/',
      ),
    ),
    482 => 
    array (
      'name' => 'Mozilla Thunderbird',
      'pattern' => ' Thunderbird/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:102.0) Gecko/20100101 Thunderbird/102.4.1',
      ),
    ),
    483 => 
    array (
      'name' => 'TikTok',
      'pattern' => 'musical_ly',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 musical_ly_17.5.0 JsSdk/2.0 NetType/WIFI Channel/App Store ByteLocale/nl Region/NL ByteFullLocale/nl-NL WKWebView/1',
      ),
    ),
    484 => 
    array (
      'name' => 'Treble',
      'pattern' => '^TREBLE/',
      'examples' => 
      array (
        0 => 'TREBLE/1.0',
      ),
    ),
    485 => 
    array (
      'name' => 'Tubidy Fm Offline Music Player',
      'pattern' => '^Tubidy( |%20)FM/\\d',
      'examples' => 
      array (
        0 => 'Tubidy FM/1 CFNetwork/1335.0.3.4 Darwin/21.6.0',
        1 => 'Tubidy%20FM/1 CFNetwork/1568.300.101 Darwin/24.2.0',
      ),
      'urls' => 
      array (
        0 => 'https://apps.apple.com/us/app/tubidy-fm-offline-music-player/id1355464544',
      ),
    ),
    486 => 
    array (
      'name' => 'Tumult',
      'pattern' => '^Tumult',
      'description' => 'Et le podcast devient social',
      'urls' => 
      array (
        0 => 'https://tumult-podcast.com/',
      ),
      'examples' => 
      array (
        0 => 'Tumult',
      ),
    ),
    487 => 
    array (
      'name' => 'TuneIn',
      'pattern' => '^TuneIn| TuneIn/',
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=tunein.player',
        1 => 'https://play.google.com/store/apps/details?id=radiotime.player',
        2 => 'https://apps.apple.com/us/app/tunein-radio-live-news-music/id418987775',
        3 => 'https://apps.apple.com/us/app/tunein-pro-radio-sports/id319295332',
        4 => 'https://tunein.com/',
      ),
      'examples' => 
      array (
        0 => 'TuneIn Radio/24.2 (Linux;Android 10) ExoPlayerLib/2.11.4',
        1 => 'TuneIn Radio Pro/23.3.2 (Linux;Android 5.1.1) ExoPlayerLib/2.10.7',
        2 => 'TuneIn Radio/1366 CFNetwork/1121.2.2 Darwin/19.3.0',
        3 => 'TuneIn Radio/18.1; iPhone12,8; iOS/13.4.1',
        4 => 'TuneIn%20Radio/1383 CFNetwork/1125.2 Darwin/19.4.0',
        5 => 'TuneIn Radio Pro/24.2.1; iPhone13,4; iOS/16.1',
        6 => 'TuneIn Radio',
        7 => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) TuneIn/1.25.0 Chrome/69.0.3497.128 Electron/4.2.8 Safari/537.36',
      ),
    ),
    488 => 
    array (
      'name' => 'Turtlecast',
      'pattern' => '^(Turtlecast|TURTLECAST)/',
      'urls' => 
      array (
        0 => 'https://www.turtlecast.app/',
      ),
      'examples' => 
      array (
        0 => 'TURTLECAST/0.5.1',
        1 => 'Turtlecast/0.7.7; (Android 13); +https://www.turtlecast.app',
      ),
      'comments' => 'Android only',
    ),
    489 => 
    array (
      'name' => 'Twitter',
      'pattern' => '^Twitter(Android)?/| Twitter for i',
      'examples' => 
      array (
        0 => 'TwitterAndroid/8.8.0-release.82 (18080082-r-82) SM-T837V/9 (samsung;SM-T837V;Verizon;gts4lltevzw;0;;0;2015)',
        1 => 'Twitter/7.51.5 CFNetwork/978.0.7 Darwin/18.6.0',
        2 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 12_1_4 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/16D57 Twitter for iPhone/7.50',
      ),
    ),
    490 => 
    array (
      'name' => 'Tweetbot',
      'pattern' => '^Tweetbot/',
      'examples' => 
      array (
        0 => 'Tweetbot/53300 CFNetwork/1335.0.3 Darwin/21.6.0',
      ),
      'urls' => 
      array (
        0 => 'https://tapbots.com/tweetbot/',
      ),
    ),
    491 => 
    array (
      'name' => 'Ubook Player',
      'pattern' => '^Ubook Player',
      'examples' => 
      array (
        0 => 'Ubook Player',
      ),
    ),
    492 => 
    array (
      'name' => 'Upcast',
      'pattern' => '^Upcast/\\d',
      'examples' => 
      array (
        0 => 'Upcast/1.0 (+https://getupcast.app/; iOS podcast app)',
      ),
      'urls' => 
      array (
        0 => 'https://getupcast.app/',
      ),
    ),
    493 => 
    array (
      'name' => 'Updates',
      'pattern' => '^Updates/',
      'examples' => 
      array (
        0 => 'Updates/1.10 (+https://getupdates.app/; iOS podcast app)',
      ),
    ),
    494 => 
    array (
      'name' => 'uTorrent',
      'pattern' => '^uTorrent|BTWebClient',
      'examples' => 
      array (
        0 => 'BTWebClient/1870(43938)',
      ),
    ),
    495 => 
    array (
      'name' => 'Vestnytt iOS app',
      'pattern' => 'iOS Vestnytt Hermes/',
      'description' => 'Vestnytt iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS Vestnytt Hermes/90.0.0 _app_',
      ),
    ),
    496 => 
    array (
      'name' => 'VG Android app',
      'pattern' => 'Android VG Hermes/',
      'description' => 'VG Android app',
      'examples' => 
      array (
        0 => 'Android VG Hermes/1000094692 app vg_app_ VG/Snarvei/1000094692 VG-App',
      ),
    ),
    497 => 
    array (
      'name' => 'VG iOS app',
      'pattern' => 'iOS VG Hermes/',
      'description' => 'VG iOS app',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.19E239 (iPhone; U; CPU OS 15_4 like Mac OS X; sv_se) iOS VG Hermes/90.0.0 _app_',
      ),
    ),
    498 => 
    array (
      'name' => 'VictorReader',
      'pattern' => '^VictorReader Stream|^VictorReader_',
      'examples' => 
      array (
        0 => 'VictorReader_4-4-2',
      ),
    ),
    499 => 
    array (
      'name' => 'VLC media player',
      'pattern' => '^VLC/\\d',
      'urls' => 
      array (
        0 => 'https://www.videolan.org/vlc/',
      ),
      'examples' => 
      array (
        0 => 'VLC/3.0.8 LibVLC/3.0.8',
      ),
    ),
    500 => 
    array (
      'name' => 'Vodacast',
      'pattern' => '^Vodacast',
      'description' => 'Podcasts with deeper digital stories',
      'urls' => 
      array (
        0 => 'https://auddiainc.com/vodacast-app/',
      ),
    ),
    501 => 
    array (
      'name' => 'Voiz FM',
      'pattern' => '^Voiz FM/',
      'examples' => 
      array (
        0 => 'Voiz FM/10.1.0 (Linux;Android 8.1.0) ExoPlayerLib/2.9.3',
      ),
    ),
    502 => 
    array (
      'name' => 'Wavlake',
      'pattern' => '^Wavlake/',
      'urls' => 
      array (
        0 => 'https://wavlake.com',
      ),
      'examples' => 
      array (
        0 => 'Wavlake/0.0.2 iPhone 11/35 https://wavlake.com',
        1 => 'Wavlake/0.0.1 Android 18/34 https://wavlake.com',
      ),
    ),
    503 => 
    array (
      'name' => 'Winamp',
      'pattern' => '^Winamp',
      'examples' => 
      array (
        0 => 'WinampMPEG/2.7',
      ),
    ),
    504 => 
    array (
      'name' => 'WeCast',
      'pattern' => '^WeCast/',
      'examples' => 
      array (
        0 => 'WeCast/3.050 CFNetwork/672.1.14 Darwin/14.0.0',
      ),
    ),
    505 => 
    array (
      'name' => 'WhatsApp',
      'pattern' => '^WhatsApp/',
      'examples' => 
      array (
        0 => 'WhatsApp/0.3.5374 N',
      ),
    ),
    506 => 
    array (
      'name' => 'Windows Media Player',
      'pattern' => '^NSPlayer|WMPlayer/|^Windows-Media-Player/',
      'examples' => 
      array (
        0 => 'NSPlayer/12.00.18362.0418 WMFSDK/12.00.18362.0418',
        1 => 'Windows-Media-Player/12.0.15063.1805',
        2 => 'Lavf52.104.0 WMPlayer/10.0.0.364 guid/3300AD50-2C39-46C0-AE0A-AC7B8159E203',
      ),
    ),
    507 => 
    array (
      'name' => 'Wink 106',
      'pattern' => '^Wink106/\\d',
      'examples' => 
      array (
        0 => 'Wink106/9 CFNetwork/1568.200.51 Darwin/24.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.wink106.player&hl=en_US',
      ),
    ),
    508 => 
    array (
      'name' => 'WNYC',
      'pattern' => '^WNYC(-|%20| )App/',
      'examples' => 
      array (
        0 => 'WNYC-App/iOS 4.4.3; iPhone; iOS 18.5',
        1 => 'WNYC App/3.0.32-11141 iOS/12.5.7 device/iPad4%2C4',
      ),
    ),
    509 => 
    array (
      'name' => 'WOWY Radio',
      'pattern' => '^Wowy Radio/\\d',
      'examples' => 
      array (
        0 => 'Wowy Radio/12.0.6 (Pixel 7 Pro; Android 14)',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.wowy.player&hl=en_US',
      ),
    ),
    510 => 
    array (
      'name' => 'WynkMusic',
      'pattern' => '^WynkMusic/',
      'urls' => 
      array (
        0 => 'https://wynk.in/podcasts',
      ),
      'examples' => 
      array (
        0 => 'WynkMusic/3.42.0.21 (Linux;Android 13) ExoPlayerLib/2.11.7',
      ),
    ),
    511 => 
    array (
      'name' => 'Xiao Yu Zhou',
      'pattern' => '^Xiaoyuzhou/',
      'description' => 'Xiao Yu Zhou, a podcast app',
      'urls' => 
      array (
        0 => 'https://apps.apple.com/cn/app/%E5%B0%8F%E5%AE%87%E5%AE%99-%E4%B8%80%E8%B5%B7%E5%90%AC%E6%92%AD%E5%AE%A2/id1488894313',
      ),
      'examples' => 
      array (
        0 => 'Xiaoyuzhou/1.9.6 Android/10',
        1 => 'Xiaoyuzhou/1.9.0',
        2 => 'Xiaoyuzhou/1.5.1',
      ),
    ),
    512 => 
    array (
      'name' => 'XING',
      'pattern' => 'iPhone.*XING',
      'description' => 'German version of LinkedIn',
      'urls' => 
      array (
        0 => 'https://www.xing.com/',
      ),
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) ; iPhone/13.6 XING/8.15.2 ttt_webview_iosm',
      ),
    ),
    513 => 
    array (
      'name' => 'Yandex Music',
      'pattern' => '^Ya(ndex)?\\.Music/',
      'examples' => 
      array (
        0 => 'Yandex.Music/2019-11-01.trunk.5885661',
        1 => 'Ya.Music/2022-10-06.trunk.10125214',
      ),
    ),
    514 => 
    array (
      'name' => 'Yapa',
      'pattern' => '^yapa/',
    ),
    515 => 
    array (
      'name' => 'Yoto',
      'pattern' => '^Yoto/|^Yoto v2 FW;',
      'examples' => 
      array (
        0 => 'Yoto/14665 CFNetwork/1.0 Darwin/18.5.0',
        1 => 'Yoto/15035 CFNetwork/1335.0.3.4 Darwin/15.8.4',
        2 => 'Yoto v2 FW; version v2.23.2',
      ),
      'urls' => 
      array (
        0 => 'https://us.yotoplay.com/',
      ),
    ),
    516 => 
    array (
      'name' => 'YouTube Music',
      'pattern' => '^com\\.google\\.android\\.apps\\.youtube\\.music/|^YouTubeMusic/\\d|^com\\.google\\.ios\\.youtubemusic/',
      'examples' => 
      array (
        0 => 'com.google.android.apps.youtube.music/62354340 (Linux; U; Android 14; en_US; Pixel 7 Pro; Build/UP1A.231105.002; Cronet/114.0.5735.84)',
        1 => 'com.google.android.apps.youtube.music/62251340 (Linux; U; Android 14; en_US; Pixel 7 Pro; Build/UP1A.231005.007; Cronet/114.0.5735.84)',
        2 => 'com.google.android.apps.youtube.music/62354340 (Linux; U; Android 14; en_US; Pixel 7 Pro; Build/UP1A.231005.007; Cronet/114.0.5735.84)',
        3 => 'com.google.android.apps.youtube.music/62852240 (Linux; U; Android 11; pt_PT; SM-A705FN; Build/RP1A.200720.012; Cronet/120.0.6057.2)',
        4 => 'YouTubeMusic/20231020.1.1 CFNetwork/1474 Darwin/23.0.0',
        5 => 'YouTubeMusic/20230915.1.1 CFNetwork/1410.0.3 Darwin/22.6.0',
        6 => 'YouTubeMusic/6.29.2 CFNetwork/1485 Darwin/23.1.0',
        7 => 'com.google.ios.youtubemusic/6.21 (iPhone14,3; U; CPU iOS 15_7_1 like Mac OS X; en_US)',
      ),
      'urls' => 
      array (
        0 => 'https://music.youtube.com/',
      ),
    ),
    517 => 
    array (
      'name' => 'YouTube Music (ReVanced)',
      'pattern' => '^app\\.revanced\\.android\\.apps\\.youtube\\.music/',
      'examples' => 
      array (
        0 => 'app.revanced.android.apps.youtube.music/62852240 (Linux; U; Android 11; pt_BR; Redmi Note 8 Pro; Build/RP1A.200720.011; Cronet/120.0.6057.2)',
      ),
      'urls' => 
      array (
        0 => 'https://revanced.app/patches?pkg=com.google.android.apps.youtube.music',
        1 => 'https://github.com/ReVanced/revanced-patches',
      ),
      'comments' => 'Unofficial 3p-patched version of public apk to block ads, enable premium features',
    ),
    518 => 
    array (
      'name' => 'Zeno',
      'pattern' => '^Zeno$',
      'urls' => 
      array (
        0 => 'https://zeno.fm/',
      ),
      'examples' => 
      array (
        0 => 'Zeno',
      ),
    ),
    519 => 
    array (
      'name' => 'Zune',
      'pattern' => 'Zune/',
      'examples' => 
      array (
        0 => 'Zune/4.8',
      ),
    ),
    520 => 
    array (
      'name' => '小宇宙',
      'pattern' => '^Podcast/1\\.',
      'description' => 'Cosmos, a chinese podcast app',
      'urls' => 
      array (
        0 => 'https://www.coolapk.com/apk/app.podcast.cosmos',
      ),
    ),
    521 => 
    array (
      'name' => 'KAIOS podcast app',
      'pattern' => '.*KAIOS/',
      'urls' => 
      array (
        0 => 'https://kaiostech.com',
      ),
      'comments' => 'This is a standard useragent for KaiOS, the cut-down operating system for mobile phones in developing countries. Watch out - it may also contain Android.',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Mobile; LYF/F271i/LYF_F271i-000-01-20-101019; Android; rv:48.0) Gecko/48.0 Firefox/48.0 KAIOS/2.5',
      ),
    ),
    522 => 
    array (
      'name' => 'talkSPORT app',
      'pattern' => '^talkS(PORT|port)/',
      'examples' => 
      array (
        0 => 'talkSPORT/x.x.x.xxx.xxx (Linux; Android x) ExoPlayerLib/x.xx.x',
        1 => 'talkSPORT/xxxxxxxxxxx CFNetwork/1126 Darwin/19.5.0',
        2 => 'talkSport/45.2.1./iOS 17.2.1/iPhone iPhone',
      ),
    ),
    523 => 
    array (
      'name' => 'Times Radio app',
      'pattern' => '^Times(%20|\\s)Radio',
      'examples' => 
      array (
        0 => 'Times%20Radio/x.x.x.xxx.xxx (Linux; Android x) ExoPlayerLib/x.xx.x',
        1 => 'Times%20Radio/xxxxxxxxxxx CFNetwork/1126 Darwin/19.5.0',
        2 => 'Times%20Radio/45.2.0.22025 / (Linux; Android 13) ExoPlayerLib/2.17.1 / samsung (SM-A145R)',
      ),
    ),
    524 => 
    array (
      'name' => 'Virgin Radio app',
      'pattern' => '^Virgin(%20|\\s)Radio',
      'examples' => 
      array (
        0 => 'Virgin%20Radio/x.x.x.xxx.xxx (Linux; Android x) ExoPlayerLib/x.xx.x',
        1 => 'Virgin%20Radio/xxxxxxxxxxx CFNetwork/1126 Darwin/19.5.0',
        2 => 'Virgin%20Radio/45.2.0.22026 / (Linux; Android 14) ExoPlayerLib/2.17.1 / samsung (SM-G996B)',
      ),
    ),
    525 => 
    array (
      'name' => 'Global Player',
      'description' => 'Global Player also powers many station-branded apps such as LBC, Heart, and Classic FM',
      'pattern' => '^Global Player/|^Radio X/|^Capital (XTRA|FM)/|^Smooth/|^LBC/|^Heart/|^Classic FM/|^Gold/',
      'urls' => 
      array (
        0 => 'https://www.globalplayer.com/',
      ),
      'examples' => 
      array (
        0 => 'Global Player/119.0 (iPhone; CPU iPhone OS 17_2_1 like Mac OS X)',
        1 => 'Global Player/119.0 (iPad; CPU iPad OS 17_2 like Mac OS X)',
        2 => 'Global Player/78.0.0 Android 14/samsung SM-S911B',
        3 => 'Radio X/120.1 (iPhone; CPU iPhone OS 16_1 like Mac OS X)',
        4 => 'Capital XTRA/119.0 (iPhone; CPU iPhone OS 16_6_1 like Mac OS X)',
        5 => 'Capital FM/78.1.0 Android 14/samsung SM-S901B',
        6 => 'Smooth/121.0 (iPhone; CPU iPhone OS 17_3 like Mac OS X)',
        7 => 'LBC/91 (iPhone; CPU iPhone OS 17_2_1 like Mac OS X)',
        8 => 'LBC/120.1 (iPhone; CPU iPhone OS 17_2_1 like Mac OS X)',
        9 => 'LBC/67.0.0 Android 13/samsung SM-A135F',
        10 => 'Heart/120.1 (iPhone; CPU iPhone OS 17_2_1 like Mac OS X)',
        11 => 'Heart/69.0.0 Android 11/samsung SM-A405FN',
        12 => 'Classic FM/120.1 (iPhone; CPU iPhone OS 17_2_1 like Mac OS X)',
        13 => 'Classic FM/78.0.0 Android 11/samsung SM-A202F',
        14 => 'Gold/120.1 (iPhone; CPU iPhone OS 17_2_1 like Mac OS X)',
        15 => 'Gold/78.1.0 Android 14/samsung SM-S911B',
      ),
    ),
    526 => 
    array (
      'name' => 'TalkRadio',
      'pattern' => '^Talk%20Radio/',
      'urls' => 
      array (
        0 => 'https://talk.tv/how-to-listen/261/talkradio-app',
      ),
      'examples' => 
      array (
        0 => 'Talk%20Radio/45.2.1./iOS 17.2.1/iPhone iPhone',
        1 => 'Talk%20Radio/45.2.1./iPadOS 15.8/iPad 3)',
      ),
    ),
  ),
)    ,
    'libraries' => 
array (
  'comments' => 
  array (
    0 => 'Look for User-Agent matches in this file order: \'bots\', \'apps\', \'libraries\', \'browsers\', and return the first entry matched, processing each entry in order in which they appear in the file.',
    1 => 'If the match entry is from this file (i.e. not a bot), you can also match the User-Agent header against the \'devices\' file to identity device and category.',
  ),
  '$schema' => 'https://raw.githubusercontent.com/opawg/user-agents-v2/master/schemas/patterns.schema.json',
  'entries' => 
  array (
    0 => 
    array (
      'name' => 'AIOHTTP',
      'description' => 'Asynchronous HTTP Client/Server for asyncio and Python',
      'pattern' => '^Python/\\d.*aiohttp/\\d',
      'examples' => 
      array (
        0 => 'Python/3.10 aiohttp/3.9.3',
      ),
      'urls' => 
      array (
        0 => 'https://docs.aiohttp.org/en/stable/',
      ),
      'category' => 'bot',
    ),
    1 => 
    array (
      'name' => 'AndroidDownloadManager',
      'pattern' => '^AndroidDownloadManager',
    ),
    2 => 
    array (
      'name' => 'Apache HttpClient',
      'pattern' => 'Apache-HttpClient',
      'examples' => 
      array (
        0 => 'Apache-HttpClient/4.5.3-SNAPSHOT (Java/1.8.0_73)',
      ),
      'comments' => 'While the Apache HttpClient can also be used in an Android podcast player app, it\'s mostly seen today on the server-side (bots).  Most Android apps use other HTTP libraries these days.',
      'category' => 'bot',
    ),
    3 => 
    array (
      'name' => 'AppleCoreMedia',
      'pattern' => '^AppleCoreMedia/1',
      'description' => 'AppleCoreMedia library',
      'urls' => 
      array (
        0 => 'https://podnews.net/article/applecoremedia-user-agent',
      ),
      'comments' => 'This is a library used by a number of apps when progressively downloading podcasts. It is not (just) Apple Podcasts, and should not be treated as an Apple Podcasts useragent',
      'examples' => 
      array (
        0 => 'AppleCoreMedia/1.0.0.16G114 (iPod touch; U; CPU OS 12_4_2 like Mac OS X; en_us)',
        1 => 'AppleCoreMedia/1.0.0.19A583 (Macintosh; U; Intel Mac OS X 10_15; en_us)',
        2 => 'AppleCoreMedia/1.0.0.15G77 (iPhone; U; CPU OS 11_4_1 like Mac OS X; en_us)',
        3 => 'AppleCoreMedia/1.0.0.17A860 (iPad; U; CPU OS 13_1_2 like Mac OS X; en_us)',
        4 => 'AppleCoreMedia/1.0.0.16G78 (HomePod; U; CPU OS 12_4 like Mac OS X; en_us)',
        5 => 'AppleCoreMedia/1.0.0.17J586 (Apple TV; U; CPU OS 13_0 like Mac OS X; en_us)',
      ),
    ),
    4 => 
    array (
      'name' => 'aria2',
      'description' => 'aria2 is a lightweight multi-protocol & multi-source command-line download utility',
      'pattern' => '^aria2/',
      'examples' => 
      array (
        0 => 'aria2/1.36.0',
      ),
      'urls' => 
      array (
        0 => 'https://aria2.github.io/',
      ),
      'category' => 'bot',
    ),
    5 => 
    array (
      'name' => 'Armadillo',
      'pattern' => '^Armadillo/1',
      'urls' => 
      array (
        0 => 'https://tech.scribd.com/blog/2021/android-audio-player-tutorial-with-armadillo.html',
      ),
      'comments' => 'This is a library, and not an app',
      'examples' => 
      array (
        0 => 'Armadillo/12.19 (Linux;Android 11) ExoPlayerLib/2.17.1',
      ),
    ),
    6 => 
    array (
      'name' => 'assets_audio_player (flutter)',
      'pattern' => '^assets_audio_player',
      'examples' => 
      array (
        0 => 'assets_audio_player',
      ),
      'urls' => 
      array (
        0 => 'https://pub.dev/packages/assets_audio_player',
      ),
    ),
    7 => 
    array (
      'name' => 'Async Http Client (java)',
      'description' => 'The AsyncHttpClient (AHC) library allows Java applications to easily execute HTTP requests and asynchronously process HTTP responses.',
      'pattern' => '^AHC/\\d+\\.\\d+',
      'examples' => 
      array (
        0 => 'AHC/2.1',
        1 => 'AHC/2.0',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/AsyncHttpClient/async-http-client',
        1 => 'https://twitter.com/AsyncHttpClient',
      ),
      'comments' => 'Android compat is not supported (https://github.com/AsyncHttpClient/async-http-client/issues?q=is%3Aissue+android), UAs found in https://github.com/AsyncHttpClient/async-http-client/blame/25e12bfd03f6375a91ca264a32588fbba7ab900c/client/src/main/resources/org/asynchttpclient/config/ahc-default.properties#L15',
      'category' => 'bot',
    ),
    8 => 
    array (
      'name' => 'Axios (Node)',
      'pattern' => '^axios/',
      'examples' => 
      array (
        0 => 'axios/0.26.1',
      ),
      'category' => 'bot',
    ),
    9 => 
    array (
      'name' => 'Bubble (no-code)',
      'description' => 'The full-stack, no-code app builder for everyone',
      'pattern' => '^Bubble$',
      'examples' => 
      array (
        0 => 'Bubble',
      ),
      'urls' => 
      array (
        0 => 'https://bubble.io/',
      ),
      'comments' => 'https://forum.bubble.io/t/upgrade-to-bubble-version-25-giving-all-external-api-calls-a-default-user-agent-if-they-dont-already-have-one-set/271309',
    ),
    10 => 
    array (
      'name' => 'Bun',
      'description' => 'A fast all-in-one JavaScript runtime and toolkit',
      'pattern' => '^Bun/\\d',
      'examples' => 
      array (
        0 => 'Bun/1.0.7',
      ),
      'urls' => 
      array (
        0 => 'https://bun.sh/',
      ),
      'category' => 'bot',
    ),
    11 => 
    array (
      'name' => 'CarrierWave (ruby)',
      'description' => 'Classier solution for file uploads for Rails, Sinatra and other Ruby web frameworks',
      'pattern' => '^CarrierWave/',
      'examples' => 
      array (
        0 => 'CarrierWave/2.2.4',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/carrierwaveuploader/carrierwave/',
      ),
      'category' => 'bot',
    ),
    12 => 
    array (
      'name' => 'Colly',
      'description' => 'Lightning Fast and Elegant Scraping Framework for Go',
      'pattern' => 'github\\.com/gocolly',
      'examples' => 
      array (
        0 => 'colly - https://github.com/gocolly/colly',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/gocolly/colly',
      ),
      'category' => 'bot',
    ),
    13 => 
    array (
      'name' => 'Dalvik',
      'pattern' => '^Dalvik[/ ]',
      'examples' => 
      array (
        0 => 'Dalvik/2.1.0 (Linux; U; Android 9; SM-N950U Build/PPR1.180610.011)',
        1 => 'Dalvik (Linux; U; Android 4.1.1;aries/JRO03L)',
      ),
    ),
    14 => 
    array (
      'name' => 'Dart',
      'pattern' => '^Dart/',
      'examples' => 
      array (
        0 => 'Dart/2.18 (dart:io)',
      ),
      'comments' => 'Default for the Dart programming language (Flutter uses Dart)',
      'category' => 'bot',
    ),
    15 => 
    array (
      'name' => 'Deno',
      'pattern' => '^Deno/',
      'examples' => 
      array (
        0 => 'Deno/1.26.1',
      ),
      'comments' => 'Default for the Deno JavaScript/TypeScript runtime',
      'category' => 'bot',
    ),
    16 => 
    array (
      'name' => 'Down (ruby)',
      'description' => 'Streaming downloads using net/http, http.rb, HTTPX or wget',
      'pattern' => '^Down/\\d',
      'examples' => 
      array (
        0 => 'Down/5.3.1',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/janko/down',
      ),
      'category' => 'bot',
    ),
    17 => 
    array (
      'name' => 'ffmpeg',
      'pattern' => '^Lavf/',
      'comments' => 'ffmpeg is a library used within TuneIn, VLC, ffmpeg and other programs. This is the default useragent for the ffmpeg library.',
      'category' => 'bot',
    ),
    18 => 
    array (
      'name' => 'FileDownloader (Android)',
      'pattern' => '^FileDownloader/',
      'examples' => 
      array (
        0 => 'FileDownloader/1.7.7',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/lingochamp/FileDownloader',
      ),
    ),
    19 => 
    array (
      'name' => 'git-annex',
      'description' => 'Allows managing large files with git, without storing the file contents in git',
      'pattern' => '^git-annex',
      'examples' => 
      array (
        0 => 'git-annex/10.20230407',
      ),
      'urls' => 
      array (
        0 => 'https://git-annex.branchable.com/',
      ),
      'category' => 'bot',
    ),
    20 => 
    array (
      'name' => 'Go Http Client',
      'pattern' => '^Go-http-client',
      'comments' => 'Default user-agent for Go programs',
      'examples' => 
      array (
        0 => 'Go-http-client/2.0',
      ),
      'urls' => 
      array (
        0 => 'https://pkg.go.dev/net/http',
      ),
      'category' => 'bot',
    ),
    21 => 
    array (
      'name' => 'Got (node)',
      'pattern' => '^got(/| \\()',
      'examples' => 
      array (
        0 => 'got (https://github.com/sindresorhus/got)',
      ),
      'urls' => 
      array (
        0 => 'https://play.google.com/store/apps/details?id=com.podimo&hl=en_US',
      ),
      'comments' => 'Got is a HTTP library for NodeJs',
      'category' => 'bot',
    ),
    22 => 
    array (
      'name' => 'GStreamer',
      'pattern' => '^GStreamer|GStreamer/',
      'examples' => 
      array (
        0 => 'amarok/2.8.0 (Phonon/4.7.80; Phonon-GStreamer/4.7.80)',
      ),
      'comments' => 'User-facing Linux media playback apps like Amarok',
    ),
    23 => 
    array (
      'name' => 'Guzzle',
      'pattern' => '^GuzzleHttp',
      'description' => 'Guzzle is a PHP HTTP client that makes it easy to send HTTP requests and trivial to integrate with web services.',
      'urls' => 
      array (
        0 => 'https://docs.guzzlephp.org/',
      ),
      'examples' => 
      array (
        0 => 'GuzzleHttp/7',
      ),
      'category' => 'bot',
    ),
    24 => 
    array (
      'name' => 'gvfs',
      'pattern' => '^gvfs',
    ),
    25 => 
    array (
      'name' => 'hackney (elixir)',
      'pattern' => '^hackney/\\d',
      'examples' => 
      array (
        0 => 'hackney/1.18.1',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/benoitc/hackney',
      ),
      'category' => 'bot',
    ),
    26 => 
    array (
      'name' => 'HTTP:Tiny',
      'description' => 'A small, simple, correct HTTP/1.1 client (Perl)',
      'pattern' => '^HTTP-Tiny/',
      'examples' => 
      array (
        0 => 'HTTP-Tiny/0.076',
      ),
      'category' => 'bot',
    ),
    27 => 
    array (
      'name' => 'http.rb',
      'description' => 'HTTP (The Gem! a.k.a. http.rb) - a fast Ruby HTTP client with a chainable API, streaming support, and timeouts',
      'pattern' => '^http\\.rb/[\\d.]+',
      'examples' => 
      array (
        0 => 'http.rb/5.1.0',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/httprb/http/',
      ),
      'category' => 'bot',
    ),
    28 => 
    array (
      'name' => 'net/http-easy (racket)',
      'pattern' => '^net/http-easy.*racket',
      'examples' => 
      array (
        0 => 'net/http-easy (macosx; racket[CS] 8.15.0.7; 0.8.2)',
      ),
      'urls' => 
      array (
        0 => 'https://docs.racket-lang.org/http-easy/index.html',
      ),
      'category' => 'bot',
    ),
    29 => 
    array (
      'name' => 'Java Platform Default',
      'description' => 'Java platform-provided client default used in the desktop/server runtime',
      'pattern' => '^Java/\\d',
      'examples' => 
      array (
        0 => 'Java/17',
        1 => 'Java/21.0.5',
        2 => 'Java/11.0.13',
        3 => 'Java/17.0.1',
      ),
      'category' => 'bot',
    ),
    30 => 
    array (
      'name' => 'Just Audio',
      'description' => 'just_audio is a feature-rich audio player for Android, iOS, macOS, web, Linux and Windows (Flutter/Dart)',
      'pattern' => '^just_audio/',
      'examples' => 
      array (
        0 => 'just_audio/3.6.2 (Linux;Android 9) ExoPlayerLib/2.13.1',
        1 => 'just_audio/1.0.68 (Linux;Android 12) ExoPlayerLib/2.18.7',
      ),
      'urls' => 
      array (
        0 => 'https://pub.dev/packages/just_audio',
      ),
    ),
    31 => 
    array (
      'name' => 'KaiOS Downloader',
      'pattern' => 'KaiOS Downloader',
      'comments' => 'This is the KaiOS Downloader library, and this could refer to any app on this platform',
      'examples' => 
      array (
        0 => 'KaiOS Downloader',
      ),
    ),
    32 => 
    array (
      'name' => 'libsoup',
      'pattern' => '^libsoup/',
      'examples' => 
      array (
        0 => 'libsoup/2.68.2',
      ),
      'urls' => 
      array (
        0 => 'https://libsoup.org/',
      ),
      'description' => 'HTTP client/server library for GNOME',
    ),
    33 => 
    array (
      'name' => 'lua-resty-http',
      'description' => 'Lua HTTP client cosocket driver for OpenResty / ngx_lua.',
      'pattern' => '^lua-resty-http/\\d',
      'examples' => 
      array (
        0 => 'lua-resty-http/0.07 (Lua) ngx_lua/10025',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/ledgetech/lua-resty-http',
      ),
      'category' => 'bot',
    ),
    34 => 
    array (
      'name' => 'Android License Verification Library',
      'pattern' => '^Android\\.LVLDM$',
      'examples' => 
      array (
        0 => 'Android.LVLDM',
      ),
    ),
    35 => 
    array (
      'name' => 'node-fetch',
      'pattern' => '^node-fetch(/.*)?$',
      'examples' => 
      array (
        0 => 'node-fetch/1.0 (+https://github.com/bitinn/node-fetch)',
        1 => 'node-fetch',
      ),
      'category' => 'bot',
    ),
    36 => 
    array (
      'name' => 'okhttp',
      'pattern' => 'okhttp',
      'examples' => 
      array (
        0 => 'okhttp/3.11.0',
      ),
      'category' => 'bot',
    ),
    37 => 
    array (
      'name' => 'PRDownloader',
      'description' => 'A file downloader library for Android with pause and resume support',
      'pattern' => '^PRDownloader$',
      'examples' => 
      array (
        0 => 'PRDownloader',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/amitshekhariitbhu/PRDownloader',
      ),
    ),
    38 => 
    array (
      'name' => 'python-httpx',
      'pattern' => '^python-httpx/',
      'examples' => 
      array (
        0 => 'python-httpx/0.18.2',
      ),
      'urls' => 
      array (
        0 => 'https://www.python-httpx.org/',
      ),
      'category' => 'bot',
    ),
    39 => 
    array (
      'name' => 'react-native-track-player',
      'pattern' => '^react-native-track-player/',
      'examples' => 
      array (
        0 => 'react-native-track-player/0.5.1 (Linux;Android 12) ExoPlayerLib/2.18.1',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/doublesymmetry/react-native-track-player',
      ),
      'description' => 'A fully fledged audio module created for music apps. Provides audio playback, external media controls, chromecast support, background mode and more!',
      'comments' => 'Must match before exoplayer',
    ),
    40 => 
    array (
      'name' => 'Request (node)',
      'pattern' => 'request\\.js',
      'category' => 'bot',
    ),
    41 => 
    array (
      'name' => 'reqwest (rust)',
      'pattern' => '^reqwest/\\d',
      'urls' => 
      array (
        0 => 'https://docs.rs/reqwest/latest/reqwest/',
      ),
      'examples' => 
      array (
        0 => 'reqwest/0.9.19',
      ),
    ),
    42 => 
    array (
      'name' => 'resty (go)',
      'description' => 'Simple HTTP and REST client library for Go',
      'pattern' => '^go-resty/\\d',
      'examples' => 
      array (
        0 => 'go-resty/2.10.0 (https://github.com/go-resty/resty)',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/go-resty/resty',
      ),
      'category' => 'bot',
    ),
    43 => 
    array (
      'name' => 'resty-requests (lua)',
      'pattern' => '^resty-requests',
      'urls' => 
      array (
        0 => 'https://github.com/tokers/lua-resty-requests',
      ),
      'examples' => 
      array (
        0 => 'resty-requests',
      ),
      'category' => 'bot',
    ),
    44 => 
    array (
      'name' => 'ruby',
      'pattern' => '^Ruby',
      'comments' => 'The generic Ruby user-agent.',
    ),
    45 => 
    array (
      'name' => 'rest-client (ruby)',
      'pattern' => '^rest-client/.*ruby/',
      'description' => 'A simple HTTP and REST client for Ruby, inspired by Sinatra',
      'comments' => 'Found mostly coming from Amazon IPs',
      'examples' => 
      array (
        0 => 'rest-client/2.0.2 (linux-gnu x86_64) ruby/2.6.8p205',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/rest-client/rest-client',
      ),
      'category' => 'bot',
    ),
    46 => 
    array (
      'name' => 'Safari View Service (SFSafariViewController)',
      'pattern' => '^SafariViewService/',
      'examples' => 
      array (
        0 => 'SafariViewService/8614.1.25.0.31 CFNetwork/1390 Darwin/22.0.0',
      ),
    ),
    47 => 
    array (
      'name' => 'Scrapy (python)',
      'pattern' => '^Scrapy/',
      'examples' => 
      array (
        0 => 'Scrapy/2.9.0 (+https://scrapy.org)',
      ),
      'urls' => 
      array (
        0 => 'https://scrapy.org',
      ),
      'category' => 'bot',
    ),
    48 => 
    array (
      'name' => 'stagefright',
      'pattern' => 'stagefright/',
      'comments' => '(android)',
    ),
    49 => 
    array (
      'name' => 'Symfony (php)',
      'pattern' => '^Symfony HttpClient[/ ]',
      'examples' => 
      array (
        0 => 'Symfony HttpClient/Curl',
        1 => 'Symfony HttpClient (Curl)',
      ),
      'category' => 'bot',
    ),
    50 => 
    array (
      'name' => 'undici (node)',
      'pattern' => '^undici$',
      'examples' => 
      array (
        0 => 'undici',
      ),
      'category' => 'bot',
      'urls' => 
      array (
        0 => 'https://github.com/nodejs/undici',
      ),
    ),
    51 => 
    array (
      'name' => 'urllib (python)',
      'pattern' => '^(Python-urllib|python-urllib3)/',
      'examples' => 
      array (
        0 => 'Python-urllib/3.9',
        1 => 'python-urllib3/1.26.7',
      ),
      'category' => 'bot',
    ),
    52 => 
    array (
      'name' => 'ExoPlayer (Android)',
      'pattern' => ' ExoPlayerLib/',
      'examples' => 
      array (
        0 => 'yourApplicationName/2.21.9 (Linux;Android 11) ExoPlayerLib/2.14.0',
        1 => 'ExoPlayerLib/2.14.0 (Linux; Android 12) ExoPlayerLib/2.14.0',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/google/ExoPlayer',
      ),
      'comments' => 'Must match after react-native-track-player. Unable to track down where everyone is copying yourApplicationName from, there are several small exoplayer examples with similar code.',
    ),
    53 => 
    array (
      'name' => 'Jetpack Media3 (Android)',
      'pattern' => '^ExoPlayer(Demo|Plugin)?/[\\d\\.]+ \\(Linux;Android [\\d.]+\\) AndroidXMedia3/\\d+\\.\\d+\\.\\d+$',
      'examples' => 
      array (
        0 => 'ExoPlayerDemo/2.5.5 (Linux;Android 14) AndroidXMedia3/1.1.1',
        1 => 'ExoPlayerDemo/2.3 (Linux;Android 14) AndroidXMedia3/1.1.1',
        2 => 'ExoPlayer/11.2 (Linux;Android 13) AndroidXMedia3/1.4.1',
        3 => 'ExoPlayer/11.2 (Linux;Android 8.1.0) AndroidXMedia3/1.4.1',
        4 => 'ExoPlayerPlugin/1.0.30 (Linux;Android 14) AndroidXMedia3/1.1.1',
      ),
      'urls' => 
      array (
        0 => 'https://developer.android.com/jetpack/androidx/releases/media3',
      ),
      'comments' => 'Copied code without changing demo user agent',
    ),
    54 => 
    array (
      'name' => 'ExoMedia',
      'description' => 'ExoMedia is an audio/video playback library for Android built on top of the ExoPlayer with straightforward APIs and integrations',
      'pattern' => '^ExoMedia \\d.*Android',
      'examples' => 
      array (
        0 => 'ExoMedia 5.0.0 / Android 14 / SM-S711U',
        1 => 'ExoMedia 5.0.0 / Android 15 / Pixel 8a',
        2 => 'ExoMedia 5.0.0 / Android 8.0.0 / SM-G930F',
        3 => 'ExoMedia 5.0.0 / Android 15 / Pixel 8 Pro',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/brianwernick/ExoMedia',
      ),
    ),
    55 => 
    array (
      'name' => 'ESP32 HTTP Client',
      'pattern' => '^ESP32 HTTP Client/',
      'examples' => 
      array (
        0 => 'ESP32 HTTP Client/1.0',
      ),
      'urls' => 
      array (
        0 => 'https://github.com/espressif/arduino-esp32',
      ),
    ),
  ),
)    ,
    'browsers' => 
array (
  'comments' => 
  array (
    0 => 'Look for User-Agent matches in this file order: \'bots\', \'apps\', \'libraries\', \'browsers\', and return the first entry matched, processing each entry in order in which they appear in the file.',
    1 => 'If the match entry is from this file (i.e. not a bot), you can also match the User-Agent header against the \'devices\' file to identity device and category.',
    2 => 'If the match entry is a Browser (i.e. in this file), you can also match the Referer header against the \'referers\' file to identify web-based apps and other known web entities.',
  ),
  '$schema' => 'https://raw.githubusercontent.com/opawg/user-agents-v2/master/schemas/patterns.schema.json',
  'entries' => 
  array (
    0 => 
    array (
      'name' => 'Brave',
      'pattern' => '.+[Bb]rave',
    ),
    1 => 
    array (
      'name' => 'Opera',
      'pattern' => 'Opera/|Macintosh.*OPR/|Windows.*OPR/|Mobile/.* OPT/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36 OPR/72.0.3815.186',
        1 => 'Mozilla/5.0 (iPad; CPU OS 15_6_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 OPT/3.2.13',
      ),
      'comments' => 'Must match above Chrome',
    ),
    2 => 
    array (
      'name' => 'Edge',
      'pattern' => '(Xbox.+Edg?/|Android.+EdgA/|iPhone.+EdgiOS/|Macintosh.+MacEdgeClient/|Windows Phone.+Edge?/|Windows.+Edge?/|X11.+Edge?/)',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; WebView/3.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299',
        1 => 'Mozilla/5.0 (X11) AppleWebKit/62.41 (KHTML, like Gecko) Edge/17.10859 Safari/452.6',
      ),
      'comments' => 'Must match above Chrome',
    ),
    3 => 
    array (
      'name' => 'Chrome',
      'pattern' => '^.*Android.*Chrome/|CrOS.*Chrome/|Linux.*Chrome/|Mac OS X.*Chrome/|Windows.*Chrome/|iPad.*CriOS/|iPhone.*CriOS/|^Chrome/\\d.*CFNetwork|X11.*Chrome/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.71 Safari/537.36',
        1 => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36',
        2 => 'Chrome/103.0.5060.63 CFNetwork/1390 Darwin/22.0.0',
        3 => 'Mozilla/5.0 (X11; OpenBSD i386) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.125 Safari/537.36',
        4 => 'Mozilla/5.0 (X11; NetBSD) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.116 Safari/537.36',
      ),
      'comments' => 'Must match below Edge',
    ),
    4 => 
    array (
      'name' => 'Firefox',
      'pattern' => 'Firefox/|(Android|iPhone|iPad).*Focus/| FxiOS/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0',
        1 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) FxiOS/100 Mobile/15E148 Version/15.0',
      ),
    ),
    5 => 
    array (
      'name' => 'Internet Explorer',
      'pattern' => 'MSIE | Trident/',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/6.0)',
        1 => 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko',
      ),
    ),
    6 => 
    array (
      'name' => 'NCSA Mosaic',
      'pattern' => '^NCSA Mosaic/',
      'examples' => 
      array (
        0 => 'NCSA Mosaic/1.0 (X11;SunOS 4.1.4 sun4m)',
      ),
    ),
    7 => 
    array (
      'name' => 'DuckDuckGo',
      'pattern' => '^DuckDuckGo',
      'examples' => 
      array (
        0 => 'DuckDuckGo/3 CFNetwork/1494.0.7 Darwin/23.4.0',
      ),
      'comments' => 'Not a bot; but a downloadable browser on iOS',
    ),
    8 => 
    array (
      'name' => 'Safari',
      'pattern' => '(Macintosh|Windows|iPhone|iPad|X11|BB10|SMART-TV|Linux).*AppleWebKit.*Safari/|^MobileSafari/|^Safari/',
      'comments' => 'Must match below Chrome',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0 Safari/605.1.15',
        1 => 'MobileSafari/604.1 CFNetwork/1107.1 Darwin/19.0.0',
        2 => 'Safari/18614.4.6.1.6 CFNetwork/1404.0.5 Darwin/22.3.0',
        3 => 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.0 Safari/605.1.15',
        4 => 'Mozilla/5.0 (BB10; Touch) AppleWebKit/537.35+ (KHTML, like Gecko) Version/10.3.3.3216 Mobile Safari/537.35+',
        5 => 'Mozilla/5.0 (SMART-TV; LINUX; Tizen 4.0) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 TV Safari/537.36',
        6 => 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
      ),
    ),
    9 => 
    array (
      'name' => 'iOS WebView',
      'pattern' => 'Mozilla/5\\.0 \\([A-Za-z ]+; CPU( iPhone)? OS [\\d_]+ like Mac OS X\\) AppleWebKit/[\\d.]+ \\(KHTML, like Gecko\\) Mobile/[0-9A-Z]{6,}',
      'description' => 'Default for UIWebView and WKWebView if apps do not customize',
      'comments' => 'Be extremely specific to avoid false positives. Versions frozen (like Safari) to avoid fingerprinting: https://twitter.com/rmondello/status/943545865204989953?s=20',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 16_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148',
        1 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 16_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148',
        2 => 'Mozilla/5.0 (iPad; CPU OS 16_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E1480',
        3 => 'Mozilla/5.0 (iPod touch; CPU iPhone OS 14_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148',
      ),
    ),
    10 => 
    array (
      'name' => 'Generic WebKit',
      'pattern' => '^Mozilla/5.0 \\((Macintosh|iPhone|iPad|Windows|iPod).*\\) AppleWebKit/[\\d+\\.]+ \\(KHTML, like Gecko\\)$',
      'description' => 'WebKit-based browsers that do not further identify themselves',
      'examples' => 
      array (
        0 => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko)',
        1 => 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_1_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)',
        2 => 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko)',
        3 => 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko)',
        4 => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko)',
        5 => 'Mozilla/5.0 (iPad; CPU OS 12_5_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)',
        6 => 'Mozilla/5.0 (iPod touch; CPU iPhone OS 12_5_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko)',
      ),
    ),
  ),
)
    );
}
