<?php
/**
 *
 * @category        modules
 * @package         jsadmin
 * @author          WebsiteBaker Project
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http:/websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.3
 * @requirements    PHP 5.3.6 and higher
 * @version         $Id: upgrade.php 4 2025-08-08 07:53:04Z Uwe $
 * @filesource      $HeadURL: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/modules/jsadmin/upgrade.php $
 * @lastmodified    $Date: 2025-08-08 09:53:04 +0200 (Fr, 08 Aug 2025) $
 *
 */
use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck,msgQueue};
use src\Security\{CsfrTokens,Randomizer};
use src\Interfaces\Requester;
use bin\Requester\HttpRequester;

/* -------------------------------------------------------- */
// Must include code to stop this file being accessed directly
if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; flush(); exit; }
/* -------------------------------------------------------- */

    $msg = '';
    $msg = [];
    $sErrorMsg = null;
    $sAddonPath = \str_replace('\\', '/', __DIR__);
    $sAddonName = basename($sAddonPath);
    $globalStarted = preg_match('/upgrade\-script\.php$/', $_SERVER["SCRIPT_NAME"]);
    $sWbVersion = ($globalStarted && defined('VERSION') ? VERSION : WB_VERSION);
    $sModulePlatform = PreCheck::getAddonVariable($sAddonName,'platform');
    if (version_compare($sWbVersion, $sModulePlatform, '<')){
        $msg[] = $sErrorMsg = sprintf('It is not possible to install/upgrade from WebsiteBaker Versions before %s',$sModulePlatform);
        if ($globalStarted){
            echo $sErrorMsg;
        }else{
            throw new \Exception ($sErrorMsg);
        }
    } else {
/*
        $sTable = TABLE_PREFIX.'mod_jsadmin';
        if(($sOldType = $database->getTableEngine($sTable))) {
            if(('myisam' != strtolower($sOldType))) {
                if(!$database->query('ALTER TABLE `'.$sTable.'` Engine = \'MyISAM\' ')) {
                    $msg[] = $database->get_error();
                }
            }
        } else {
            $msg[] = $database->get_error();
        }
*/
// ------------------------------------
        $sInstallStruct = $sAddonPath.'/install-struct.sql.php';
        if (!is_readable($sInstallStruct)) {
            $msg[] = '<strong>\'missing or not readable file [install-struct.sql]\'</strong> '.$FAIL.'<br />';
            $iErr = true;
        } else {
            $database->SqlImport($sInstallStruct, TABLE_PREFIX, true );
        }

//  remove obselete files and folder
            $aRemoveList = [
                '/index.php',
                '/install-data.sql',
                '/install-struct.sql',
                '/sql/',
            ];
            PreCheck::deleteFiles($sAddonPath,$aRemoveList);

    }