<?php
/**
 *
 * @category        module
 * @package         Form
 * @author          WebsiteBaker Project
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.8.3
 * @requirements    PHP 5.3.6 and higher
 * @version         $Id: delete_submission.php 4 2025-08-08 07:53:04Z Uwe $
 * @filesource      $HeadURL: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/modules/form/delete_submission.php $
 * @lastmodified    $Date: 2025-08-08 09:53:04 +0200 (Fr, 08 Aug 2025) $
 * @description
 */



declare(strict_types=1);

use bin\{WbAdaptor,SecureTokens,Sanitize,Requester};
use bin\helpers\{PreCheck,msgQueue};

//    echo "<pre>";
//    print_r($_POST);
//    echo "</pre>";

//if ( !defined( 'SYSTEM_RUN' ) ){ require( dirname(__DIR__,2).'/config.php' ); }
    $sAddonFile   = \str_replace('\\','/',__FILE__);
    $sFolder      = \basename(\dirname($sAddonFile));
    switch ($sFolder):
        case 'cmd':
          $sAddonPath   = \dirname($sAddonFile,2).'/';
          break;
        default :
          $sAddonPath   = (\dirname($sAddonFile)).'/';
    endswitch;

    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = \basename($sModulesPath);
    $sAddonName   = \basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = \preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    if (! \defined('SYSTEM_RUN') && \is_readable($sAppPath.'config.php')) {
        require($sAppPath.'config.php');
    }
    $bLocalDebug  = (\is_readable($sAddonPath.'.setDebug'));
    $bSecureToken = (!\is_readable($sAddonPath.'.setToken'));
    $bFrontendCss = (!\is_readable($sAddonPath.'.setFrontend.inc'));
    $sPHP_EOL     = ($bLocalDebug ? "\n" : '');
    $sqlEOL       = ($bLocalDebug ? "\n" : "");
/* ------------------------------------------------------------------ */
// print with or without header
//    $admin_header = false;
// settings needs a admin object
    $print_info_banner = true;
// Include WB admin wrapper script
    require($sModulesPath.'admin.php');
/* -------------------------------------------------------- */
try {
    $oReg     = WbAdaptor::getInstance();
    $oDb      = $oReg->getDatabase();
    $oTrans   = $oReg->getTranslate();
    $oRequest = $oReg->getRequester();
    $oApp     = $oReg->getApplication();
/* -------------------------------------------------------- */
    $sCallingScript = $oRequest->getServerVar('SCRIPT_NAME');
    $ModuleUrl      = $oReg->AppUrl.$ModuleRel;
    $sAddonUrl      = $oReg->AppUrl.$sAddonRel;
    $sDomain        = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);

    $sDomain  = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);
    $sBacklinkRel = $oReg->AcpDir.'pages/modify.php?page_id='.$page_id;
    $sBacklinkUrl = $oReg->AcpUrl.'pages/modify.php?page_id='.$page_id;
//    $SectionIdPrefix = '#'.(defined('SEC_ANCHOR') && !empty(SEC_ANCHOR) ? SEC_ANCHOR : 'Sec' ).$section['section_id'];
    $sBackModuleUrl = $oReg->AcpUrl.'pages/sections.php?page_id='.$page_id;
    $sErrMsg = $oTrans->TEXT_DELETING_FAILED;

//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $aRequestVars ); print '</pre>'; \flush (); //  sleep(10); die();

    $bGetOldSecureToken = (SecureTokens::checkFTAN());
    // to put in form input hidden fields, dont forgget the php echo tag round the variables
    $aFtan = \bin\SecureTokens::getFTAN();
    // <input type="hidden" name="$aFtan['name']" value="$aFtan['value']">
    $sFtan['name']  = $aFtan['name'];
    $sFtan['value'] = $aFtan['value'];
    // for $_GET Querystring
    $sFtanQuery = $sFtan['name'].'='.$sFtan['value'];

// check FTAN
    if ($bSecureToken && !$bGetOldSecureToken){
        $aMessage = \sprintf($oTrans->MESSAGE_GENERIC_SECURITY_ACCESS);
        throw new \Exception ($aMessage);
    }
    $sAction = ($oRequest->getParam('action',FILTER_SANITIZE_SPECIAL_CHARS) ?? 'show');
    $options=['options'=>['default'=>1, 'min_range'=>0, 'max_range'=>1]];
    $iActive = (int)($oRequest->getParam('sub_delete',FILTER_VALIDATE_INT,$options));

        if (!($submission_id = SecureTokens::checkIDKEY($aRequestVars['submission_id']))){ //$oRequest->file
            throw new \Exception ($oTrans->MESSAGE_GENERIC_SECURITY_ACCESS);
        } else {
            $sSubmissions = 'IN ('.$submission_id.')';
        }
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sAction));
    $aDebugArray = [
        'submission_id'=>$submission_id,
        'action'=>$sAction,
        'sub_delete'=>$iActive,
        'page_id'=>$page_id,
        'gettype' =>gettype($iActive),
        'sFtanQuery'=>$sFtanQuery,
        'submission_id' => $submission_id,
        '$sBacklinkUrl' => $sBacklinkUrl,
    ];

//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $aDebugArray ); print '</pre>'; \flush (); //  sleep(10); die();

    if ($sAction === 'modal_sub') {
?>
  <form action="<?= $sAddonUrl;?>delete_submission.php#" method="post">
    <input id="p<?php echo $section_id; ?>" type="hidden" name="section_id" value="<?php echo $section_id; ?>">
    <input id="p<?php echo $page_id; ?>" type="hidden" name="page_id" value="<?php echo $page_id; ?>">
    <input type="hidden" name="<?php echo $aFtan['name'];?>" value="<?php echo $aFtan['value']; ?>">
    <input type="hidden" name="action" value="save_sub" >
    <input type="hidden" name="sub_delete" value="<?php echo $iActive;?>" >
    <input type="hidden" name="submission_id" value=<?php echo $admin->getIDKEY($submission_id);?>>
    <div id="id01" class="w3-modal-box">
      <div class="w3-modal-content">
          <header class="w3-container w3-header-blue-wb">
            <h3><?php echo $oTrans->TEXT_ENTRY_DELETED; ?></h3>
          </header>
          <div class="w3-container  w3-padding-large">
          <div class="w3-container">
<?php
    $aDebugArray = [
        'submission_id'=>$submission_id,
        'submission_idKey'=>$admin->getIDKEY($submission_id),
        'action'=>$sAction,
        'sub_delete'=>$iActive,
        'page_id'=>$page_id,
        'gettype' =>gettype($iActive),
        'sFtanQuery'=>$sFtanQuery,
        'submission_id' => $submission_id,
        '$sBacklinkUrl' => $sBacklinkUrl,
    ];

//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $aDebugArray ); print '</pre>'; \flush (); //  sleep(10); die();
?>
            <h4 style="text-align: center;margin-top: 10px;"><?php echo $oTrans->FORM_MESSAGE_CONFIRM_SUB_DELETING;?> </h4>
            <p style="text-align: center;margin-top: 10px;"><?php echo $oTrans->TEXT_NO_REVERT;?></p>
            </div>
          </div>
        <footer class="w3-container w3-header-blue-wb w3-padding-4">
            <div class="w3-col l6 w3-left-align w3-padding-large">
                <button class="w3-btn w3-blue-wb w3-hover-green w3-medium w3-padding-4" type="submit" ><?php echo $oTrans->TEXT_DELETE; ?></button>
            </div>
            <div class="w3-col l6 w3-right-align w3-padding-large">
                <button name="page_id" value="<?php echo $page_id;?>" class="url-close w3-btn w3-blue-wb w3-hover-red w3-medium w3-padding-4" type="button" data-overview="<?php echo ADMIN_DIRECTORY; ?>/pages/modify.php?page_id=<?= $page_id; ?>" >
                    <i class="fa fa-times w3-left-align">&nbsp;</i>
                    <span class="w3-padding--0"><?php echo $TEXT['CLOSE']; ?></span>
                </button>
            </div>
        </footer>
      </div>
    </div>
  </form>
<?php
    } elseif ($sAction === 'save_sub') {
    $aDebugArray = [
        'submission_id'=>$submission_id,
        'action'=>$sAction,
        'sub_delete'=>$iActive,
        'page_id'=>$page_id,
        'gettype' =>gettype($iActive),
        'sFtanQuery'=>$sFtanQuery,
        'submission_id' => $submission_id,
        '$sBacklinkUrl' => $sBacklinkUrl,
    ];

//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $aDebugArray ); print '</pre>'; \flush (); //  sleep(10); die();
//echo "iActive: ".$iActive;
// Delete rows when sub_delete is inactive (0)
        if ($iActive === 0 ){
            $sql  = '
            DELETE FROM `'.TABLE_PREFIX.'mod_form_submissions`
            WHERE `submission_id` = '.(int)$submission_id.'
              AND `sub_delete` = 0
            ';    
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sql));
        $sErrMsg = $oTrans->TEXT_ENTRY_SUCCESSFULLY_DELETED;
        $database->query($sql);
        } //end $iActive

    // Delete rows when sub_delete is active (1)
        if ($iActive === 1 ){
            $sql  = '
            DELETE FROM `'.TABLE_PREFIX.'mod_form_submissions`
            WHERE `submission_id` = '.(int)$submission_id.'
              AND `sub_delete` = 1
            ';    
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sql));
        $sErrMsg = $oTrans->TEXT_ENTRY_SUCCESSFULLY_DELETED;
        $database->query($sql);
        } //end $iActive
    } // save_sub
//    $admin->clearIDKEY();
    }catch (\Exception $ex) {
        $sErrMsg = PreCheck::xnl2br(sprintf('[%d] %s', $ex->getLine(), $ex->getMessage()));
        $admin->print_error ($sErrMsg, $sBacklinkUrl);
        exit;
    }
    if ($sAction === 'save_sub') {
    $admin->print_success($sErrMsg, $sBacklinkUrl);
    }
//    Print admin footer
    $admin->print_footer();
?>
<script>
// Get the modal
var modal = document.getElementById('id01');

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
</script>