<?php
/**
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Description of Translate
 *
 * @category     Addon
 * @package      Addon package
 * @subpackage   Name of subpackage if needed
 * @copyright    Dietmar Wöllbrink <dietmar.woellbrink@websitebaker@org>
 * @author       Manuela v.d.Decken <manuela@isteam.de>
 * @author       Dietmar Wöllbrink <dietmar.woellbrink@websitebaker@org>
 * @license      GNU General Public License 3.0
 * @version      1.0.0-dev.1
 * @revision     $Revision: 4 $
 * @lastmodified $Date: 2025-08-08 09:53:04 +0200 (Fr, 08 Aug 2025) $
 * @since        File available since 02.12.2017
 * @deprecated   no
 * @description  xxx
 */

use bin\{WbAdaptor,SecureTokens,Sanitize};
use addon\WBLingual\Lingual;


if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}

if (!\function_exists('LangPageId')){
    function LangPageId($sLang){
        $sLang = \strtoupper($sLang);
        $oReg = WbAdaptor::getInstance();
// have to be enabled
        if ($oReg->PageLanguages) {
            $oReg->PageLanguages = \filter_var($oReg->PageLanguages, \FILTER_VALIDATE_BOOLEAN);
            $oLingual = new Lingual($oReg);
            $aLink = $oLingual->getPageLangDetails();
// return page_id given by $sLang || valide page_id
            $iRetval = (isset($aLink[$sLang]['page_id']) ? $aLink[$sLang]['page_id'] : $oReg->App->page_id );
        }
        return ($iRetval ?? false);
    }
}

if (!\function_exists('getLangChildPageId')){
    /**
     * getLangChildPageId()
     *
     * @param string $sLang
     * @param string $sMenuTitle
     * @return page_id
     */
    function getLangChildPageId($sLang='en',$sMenuTitle=''){
        $iRetval = 0;
        $sLang = \strtoupper($sLang);
        $oReg = WbAdaptor::getInstance();
        $sSqlWhere = '
        WHERE
        '.(!empty($sMenuTitle) ? '`menu_title` = \''.($sMenuTitle).'\'' : '`level` = 0
          AND `parent`= 0
          AND `root_parent` = 0 ');
        $sSqlId = '
        SELECT
        `page_id` FROM `'.$oReg->Db->TablePrefix.'pages` '
         . $sSqlWhere.'
          AND `language` = \''.$sLang.'\'
          AND `visibility` NOT IN (\'hidden\',\'deleted\',\'none\')
        ';

        if (!($iRetval = $oReg->Db->get_one($sSqlId))){
          $sErrorMsg = sprintf('[%d] DB Error %s given menu_title \"%s\" ',__LINE__, $oReg->Db->get_error(),$sMenuTitle);
//          \trigger_error($sErrorMsg, E_USER_NOTICE);
        }
        return (int)$iRetval;
    }
}

if (!\function_exists('getLangStartPageIds')){
    function getLangStartPageIds($sLang='')
    {
        $sLang =(!empty($sLang) ? \strtoupper($sLang) : '');
        $aRetval = (!empty($sLang) ? [] : null);
        $oReg = WbAdaptor::getInstance();
// have to be enabled
        if ($oReg->PageLanguages) {
//            $oReg->PageLanguages = \filter_var($oReg->PageLanguages, \FILTER_VALIDATE_BOOLEAN);
            $oLingual = new Lingual($oReg);
            $aLinks = $oLingual->getPagesDetail();
            foreach ($aLinks as $aLang){
// return page_id given by $aLang || valide page_id
                if ((!empty($sLang) && ($aLang['language']==$sLang)) && ($aLang['parent']==$aLang['root_parent']))
                {
                    $aRetval = ($aLang['page_id'] ?? null );
                    break;
                } else {
                    $aRetval[] = ($aLang['page_id'] ?? [] );
                }
            }
        }
        return ($aRetval ?? []);
    }
}


if (!\function_exists('language_menu')){
    function language_menu($sExtension = "auto", $bOutput=true)
    {
        $oReg = WbAdaptor::getInstance();
        $sRetVal = '';
        $oReg->PageLanguages = \filter_var($oReg->PageLanguages, \FILTER_VALIDATE_BOOLEAN);
        if ($oReg->PageLanguages) {
        $sExtension = \strtolower($sExtension);
        switch($sExtension)
        {
            case 'gif':
            case 'png':
            case 'svg':
                break;
            default:
                $sExtension = 'auto';
        }
        $oLingual = new Lingual($oReg);
        $oLingual->setExtension($sExtension);
        $sRetVal = \trim($oLingual->getLangMenu());
        if ($bOutput){echo $sRetVal;}
        }
        return $sRetVal ?? false;
    }
}
