<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of \languages\PT
 * @package          CoreTranslation
 * @copyright        Manuela v.d.Decken <manuela@isteam.de>
 * @author          $Author: Uwe $
 * @license         GNU General Public License 2.0
 * @version         4.0.3
 * @revision        $Revision: 63 $
 * @since           $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @lastmodified    $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @deprecated      no
 * @description     CoreTranslation
 * @svn-id          $Header: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/languages/PT.php 63 2025-09-01 10:08:14Z Uwe $
 */

//declare(strict_types = 1);

//declare(encoding = 'UTF-8');

if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
// Define that this file is loaded
if (!defined('LANGUAGE_LOADED')) { define('LANGUAGE_LOADED', true); }

// Set the language information
$language_code = 'PT';
$language_name = 'Português';
$language_version = '4.0.3';
$language_platform = '2.11.0';
$language_author = 'Jacobi22';// All translations by Google AI
$language_license = 'GNU General Public License 2.0';

$HEADING['ADDON_PRECHECK_FAILED']            = 'Requisitos do Add-On não cumpridos';
$HEADING['ADD_CHILD_PAGE']                   = 'Adicionar subpágina';
$HEADING['ADD_GROUP']                        = 'Adicionar Grupo';
$HEADING['ADD_GROUPS']                       = 'Adicionar Grupos';
$HEADING['ADD_HEADING']                      = 'Adicionar Título';
$HEADING['ADD_PAGE']                         = 'Adicionar Página';
$HEADING['ADD_USER']                         = 'Adicionar Usuário';
$HEADING['ADMINISTRATION_TOOLS']             = 'Ferramentas de Administração';
$HEADING['BROWSE_MEDIA']                     = 'Navegar Mídia';
$HEADING['CREATE_FOLDER']                    = 'Criar Pasta';
$HEADING['DEFAULT_SETTINGS']                 = 'Configurações Padrão';
$HEADING['DELETED_PAGES']                    = 'Páginas Excluídas';
$HEADING['FILESYSTEM_SETTINGS']              = 'Configurações do Sistema de Arquivos';
$HEADING['GENERAL_SETTINGS']                 = 'Configurações Gerais';
$HEADING['INSTALL_LANGUAGE']                 = 'Instalar Idioma';
$HEADING['INSTALL_MODULE']                   = 'Instalar Módulo';
$HEADING['INSTALL_TEMPLATE']                 = 'Instalar Modelo';
$HEADING['INVOKE_LANGUAGE_FILES']            = 'Executar arquivos de idioma manualmente';
$HEADING['INVOKE_MODULE_FILES']              = 'Executar arquivos de módulo manualmente';
$HEADING['INVOKE_TEMPLATE_FILES']            = 'Executar arquivos de modelo manualmente';
$HEADING['LANGUAGE_DETAILS']                 = 'Detalhes do Idioma';
$HEADING['MANAGE_SECTIONS']                  = 'Gerenciar Seções';
$HEADING['MODIFY_ADVANCED_PAGE_SETTINGS']    = 'Modificar Configurações Avançadas da Página';
$HEADING['MODIFY_DELETE_GROUP']              = 'Modificar/Excluir Grupo';
$HEADING['MODIFY_DELETE_PAGE']               = 'Modificar/Excluir Página';
$HEADING['MODIFY_DELETE_USER']               = 'Modificar/Excluir Usuário';
$HEADING['MODIFY_GROUP']                     = 'Modificar Grupo';
$HEADING['MODIFY_GROUPS']                    = 'Modificar Grupos';
$HEADING['MODIFY_INTRO_PAGE']                = 'Modificar Página de Introdução';
$HEADING['MODIFY_PAGE']                      = 'Modificar Página';
$HEADING['MODIFY_PAGE_SETTINGS']             = 'Modificar Configurações da Página';
$HEADING['MODIFY_USER']                      = 'Modificar Usuário';
$HEADING['MODULE_DETAILS']                   = 'Detalhes do Módulo';
$HEADING['MY_EMAIL']                         = 'Meu E-mail';
$HEADING['MY_PASSWORD']                      = 'Minha Senha';
$HEADING['MY_SETTINGS']                      = 'Minhas Configurações';
$HEADING['SEARCH_SETTINGS']                  = 'Configurações de Pesquisa';
$HEADING['SERVER_SETTINGS']                  = 'Configurações do Servidor';
$HEADING['TEMPLATE_DETAILS']                 = 'Detalhes do Modelo';
$HEADING['UNINSTALL_LANGUAGE']               = 'Desinstalar Idioma';
$HEADING['UNINSTALL_MODULE']                 = 'Desinstalar Módulo';
$HEADING['UNINSTALL_TEMPLATE']               = 'Desinstalar Modelo';
$HEADING['UPGRADE_LANGUAGE']                 = 'Registro/Atualização de Idioma';
$HEADING['UPLOAD_FILES']                     = 'Carregar Arquivo(s)';
$HEADING['WBMAILER_SETTINGS']                = 'Configurações do Mailer';
$MENU['ACCESS']                             = 'Gerenciamento de Usuários';
$MENU['ADDON']                              = 'Add-on';
$MENU['ADDONS']                             = 'Add-ons';
$MENU['ADMINTOOLS']                         = 'Ferramentas Admin';
$MENU['BREADCRUMB']                         = 'Você está aqui: ';
$MENU['FORGOT']                             = 'Recuperar Detalhes de Login';
$MENU['GROUP']                              = 'Grupo';
$MENU['GROUPS']                             = 'Grupos';
$MENU['HELP']                               = 'Ajuda';
$MENU['LANGUAGES']                          = 'Idiomas';
$MENU['LOGIN']                              = 'Login';
$MENU['LOGOUT']                             = 'Sair';
$MENU['MEDIA']                              = 'Mídia';
$MENU['MODULES']                            = 'Módulos';
$MENU['MY_PROFILE']                         = 'Meu Perfil';
$MENU['PAGES']                              = 'Páginas';
$MENU['PREFERENCES']                        = 'Preferências';
$MENU['REORG_TABLE']                        = 'Reorganizar tabelas';
$MENU['SETTINGS']                           = 'Configurações';
$MENU['START']                              = 'Início';
$MENU['TEMPLATES']                          = 'Modelos';
$MENU['USERS']                              = 'Usuários';
$MENU['VIEW']                               = 'Ver';
$MESSAGE['ADDON_ERROR_RELOAD']               = 'Erro ao atualizar as informações do Add-On.';
$MESSAGE['ADDON_LANGUAGES_RELOADED']         = 'Idiomas recarregados com sucesso';
$MESSAGE['ADDON_MANUAL_FTP_LANGUAGE']        = '<strong>ATENÇÃO!</strong> Por razões de segurança, transfira arquivos de idioma apenas via FTP para a pasta /languages/ e use a função de Atualização para registrar ou atualizar.';
$MESSAGE['ADDON_MANUAL_FTP_WARNING']         = 'Aviso: As entradas existentes no banco de dados do módulo serão perdidas. ';
$MESSAGE['ADDON_MANUAL_INSTALLATION']        = 'Quando os módulos são carregados via FTP (não recomendado), as funções de instalação do módulo <code>install</code>, <code>upgrade</code> ou <code>uninstall</code> não serão executadas automaticamente. Esses módulos podem não funcionar corretamente ou desinstalar-se apropriadamente.<br /><br />Você pode executar as funções do módulo manualmente para módulos carregados via FTP abaixo.';
$MESSAGE['ADDON_MANUAL_INSTALLATION_WARNING']= 'Aviso: As entradas existentes no banco de dados do módulo serão perdidas. Use esta opção apenas se você tiver problemas com módulos carregados via FTP.';
$MESSAGE['ADDON_MANUAL_RELOAD_WARNING']      = 'Aviso: As entradas existentes no banco de dados do módulo serão perdidas. ';
$MESSAGE['ADDON_MODULES_RELOADED']           = 'Módulos recarregados com sucesso';
$MESSAGE['ADDON_OVERWRITE_NEWER_FILES']      = 'Sobrescrever Arquivos Mais Recentes';
$MESSAGE['ADDON_PRECHECK_FAILED']            = 'A instalação do add-on falhou. Seu sistema não atende aos requisitos deste add-on. Para que este add-on funcione em seu sistema, por favor, corrija os problemas resumidos abaixo.';
$MESSAGE['ADDON_RELOAD']                     = 'Atualizar banco de dados com informações dos arquivos do Add-on (ex: após upload via FTP).';
$MESSAGE['ADDON_TEMPLATES_RELOADED']         = 'Modelos recarregados com sucesso';
$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES']   = 'Privilégios de acesso insuficientes';
$MESSAGE['FORGOT_PASS_ALREADY_RESET']        = 'A Senha só pode ser redefinida uma vez por hora';
$MESSAGE['FORGOT_PASS_CANNOT_EMAIL']         = 'Não é possível enviar a senha por e-mail, entre em contato com o administrador do sistema';
$MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND']      = 'O e-mail que você inseriu não pode ser encontrado no banco de dados';
$MESSAGE['FORGOT_PASS_NO_DATA']              = 'Por favor, insira seu endereço de e-mail abaixo';
$MESSAGE['FORGOT_PASS_PASSWORD_RESET']       = 'Sua senha foi enviada para o seu endereço de e-mail';
$MESSAGE['FRONTEND_SORRY_NO_ACTIVE_SECTIONS']= 'Desculpe, nenhum conteúdo ativo para exibir';
$MESSAGE['FRONTEND_SORRY_NO_VIEWING_PERMISSIONS'] = 'Desculpe, você não tem permissão para visualizar esta página';
$MESSAGE['GENERIC_ALREADY_INSTALLED']        = 'Já instalado';
$MESSAGE['GENERIC_BAD_PERMISSIONS']          = 'Não é possível gravar no diretório de destino';
$MESSAGE['GENERIC_BE_PATIENT']               = 'Por favor, seja paciente.';
$MESSAGE['GENERIC_CANNOT_UNINSTALL']         = 'Não é possível desinstalar';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE']  = 'Não é possível desinstalar: o arquivo selecionado está em uso';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL'] = '<br /><br />{{type}} <b>{{type_name}}</b> não pôde ser desinstalado, porque ainda está em uso em {{pages}}.<br /><br />';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL_PAGES'] = 'esta página;estas páginas';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_TEMPLATE'] = 'Não é possível desinstalar o modelo <b>{{name}}</b>, pois é o modelo padrão!';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_THEME'] = 'Não é possível desinstalar o modelo <b>{{name}}</b>, pois é o tema de back-end padrão!';
$MESSAGE['GENERIC_CANNOT_UNZIP']             = 'Não é possível descompactar arquivo';
$MESSAGE['GENERIC_CANNOT_UPLOAD']            = 'Não é possível carregar arquivo';
$MESSAGE['GENERIC_COMPARE']                  = ' bem-sucedido';
$MESSAGE['GENERIC_ERROR_OPENING_FILE']       = 'Erro ao abrir arquivo.';
$MESSAGE['GENERIC_FAILED_COMPARE']           = ' falhou';
$MESSAGE['GENERIC_FILE_TYPE']                = 'Por favor, note que o arquivo que você carrega deve estar no seguinte formato:';
$MESSAGE['GENERIC_FILE_TYPES']               = 'Por favor, note que o arquivo que você carrega deve estar em um dos seguintes formatos:';
$MESSAGE['GENERIC_FILL_IN_ALL']              = 'Por favor, volte e preencha todos os campos';
$MESSAGE['GENERIC_FORGOT_OPTIONS']           = 'Você não fez uma seleção!';
$MESSAGE['GENERIC_INSTALLED']                = 'Instalado com sucesso';
$MESSAGE['GENERIC_INVALID']                  = 'O arquivo carregado é inválido';
$MESSAGE['GENERIC_INVALID_ADDON_FILE']       = 'Arquivo de instalação WebsiteBaker inválido. Por favor, verifique o formato *.zip.';
$MESSAGE['GENERIC_INVALID_LANGUAGE_FILE']    = 'Arquivo de idioma WebsiteBaker inválido. Por favor, verifique o arquivo de texto.';
$MESSAGE['GENERIC_INVALID_MODULE_FILE']      = 'Arquivo de módulo WebsiteBaker inválido. Por favor, verifique o arquivo de texto.';
$MESSAGE['GENERIC_INVALID_TEMPLATE_FILE']    = 'Arquivo de modelo WebsiteBaker inválido. Por favor, verifique o arquivo de texto.';
$MESSAGE['GENERIC_IN_USE']                   = ' mas usado em ';
$MESSAGE['GENERIC_MISSING_ARCHIVE_FILE']     = 'Arquivo de arquivo ausente!';
$MESSAGE['GENERIC_MODULE_VERSION_ERROR']     = 'O módulo %s não está instalado corretamente!';
$MESSAGE['GENERIC_NOT_COMPARE']              = ' não é possível';
$MESSAGE['GENERIC_NOT_INSTALLED']            = 'Não instalado';
$MESSAGE['GENERIC_NOT_UPGRADED']             = 'Atualização não é possível';
$MESSAGE['GENERIC_PLEASE_BE_PATIENT']        = 'Por favor, seja paciente, isso pode demorar um pouco.';
$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON']   = 'Por favor, volte em breve...';
$MESSAGE['GENERIC_SECURITY_ACCESS']          = 'Violação de segurança!! Acesso negado!';
$MESSAGE['GENERIC_SECURITY_OFFENSE']         = 'Violação de segurança!! O armazenamento de dados foi recusado!';
$MESSAGE['GENERIC_UNINSTALLED']              = 'Desinstalado com sucesso';
$MESSAGE['GENERIC_UPGRADED']                 = 'Atualizado com sucesso';
$MESSAGE['GENERIC_VERSION_COMPARE']          = 'Comparação de versão';
$MESSAGE['GENERIC_VERSION_GT']               = 'Atualização necessária!';
$MESSAGE['GENERIC_VERSION_LT']               = 'Downgrade';
$MESSAGE['GENERIC_WEBSITE_LOCKED']           = 'este site está temporariamente fora do ar para manutenção';
$MESSAGE['GENERIC_WEBSITE_UNDER_CONSTRUCTION'] = 'Site em Construção';
$MESSAGE['GENERIC_WEBSITE_NO_PAGES']         = 'Este site para este idioma (%s) ainda está em construção';
$MESSAGE['GROUPS_ADDED']                     = 'Grupo adicionado com sucesso';
$MESSAGE['GROUPS_CONFIRM_DELETE']            = 'Tem certeza de que deseja excluir o grupo selecionado (e todos os usuários que pertencem a ele)?';
$MESSAGE['GROUPS_DELETED']                   = 'Grupo excluído com sucesso';
$MESSAGE['GROUPS_GROUP_NAME_BLANK']          = 'O nome do grupo está em branco';
$MESSAGE['GROUPS_GROUP_NAME_EXISTS']         = 'O nome do grupo já existe';
$MESSAGE['GROUPS_NO_GROUPS_FOUND']           = 'Nenhum grupo encontrado';
$MESSAGE['GROUPS_SAVED']                     = 'Grupo salvo com sucesso';
$MESSAGE['LOGIN_AUTHENTICATION_FAILED']      = 'Nome de usuário ou senha incorretos';
$MESSAGE['LOGIN_BOTH_BLANK']                 = 'Por favor, insira seu nome de usuário e senha';
$MESSAGE['LOGIN_PASSWORD_BLANK']             = 'Por favor, insira uma senha';
$MESSAGE['LOGIN_PASSWORD_TOO_LONG']          = 'Senha fornecida muito longa';
$MESSAGE['LOGIN_PASSWORD_TOO_SHORT']         = 'Senha fornecida muito curta';
$MESSAGE['LOGIN_USERNAME_BLANK']             = 'Por favor, insira um nome de usuário';
$MESSAGE['LOGIN_USERNAME_TOO_LONG']          = 'Nome de usuário fornecido muito longo';
$MESSAGE['LOGIN_USERNAME_TOO_SHORT']         = 'Nome de usuário fornecido muito curto';
$MESSAGE['MEDIA_BLANK_EXTENSION']            = 'Você não inseriu uma extensão de arquivo';
$MESSAGE['MEDIA_BLANK_NAME']                 = 'Você não inseriu um novo nome';
$MESSAGE['MEDIA_CANNOT_DELETE_DIR']          = 'Não é possível excluir a pasta selecionada';
$MESSAGE['MEDIA_CANNOT_DELETE_FILE']         = 'Não é possível excluir o arquivo selecionado';
$MESSAGE['MEDIA_CANNOT_RENAME']              = 'Renomeação sem sucesso';
$MESSAGE['MEDIA_CONFIRM_DELETE']             = 'Tem certeza de que deseja excluir o seguinte arquivo ou pasta?';
$MESSAGE['MEDIA_DELETED_DIR']                = 'Pasta excluída com sucesso';
$MESSAGE['MEDIA_DELETED_FILE']               = 'Arquivo excluído com sucesso';
$MESSAGE['MEDIA_DIR_ACCESS_DENIED']          = 'O diretório especificado não existe ou não é permitido.';
$MESSAGE['MEDIA_DIR_DOES_NOT_EXIST']         = 'O diretório não existe';
$MESSAGE['MEDIA_DIR_DOT_DOT_SLASH']          = 'Não pode incluir ../ no nome da pasta';
$MESSAGE['MEDIA_DIR_EXISTS']                 = 'Uma pasta com o nome que você inseriu já existe';
$MESSAGE['MEDIA_DIR_MADE']                   = 'Pasta criada com sucesso';
$MESSAGE['MEDIA_DIR_NOT_MADE']               = 'Não foi possível criar a pasta';
$MESSAGE['MEDIA_FILE_EXISTS']                = 'Um arquivo com o nome que você inseriu já existe';
$MESSAGE['MEDIA_FILE_NOT_FOUND']             = 'Arquivo não encontrado';
$MESSAGE['MEDIA_NAME_DOT_DOT_SLASH']         = 'Não pode incluir ../ no nome';
$MESSAGE['MEDIA_NAME_INDEX_PHP']             = 'Não é possível usar index.php como nome';
$MESSAGE['MEDIA_NONE_FOUND']                 = 'Nenhum item de mídia encontrado na pasta atual';
$MESSAGE['MEDIA_NO_FILE_UPLOADED']           = 'Nenhum arquivo foi recebido';
$MESSAGE['MEDIA_RENAMED']                    = 'Renomeação bem-sucedida';
$MESSAGE['MEDIA_SINGLE_UPLOADED']            = ' arquivo foi carregado com sucesso';
$MESSAGE['MEDIA_TARGET_DOT_DOT_SLASH']       = 'Não pode ter ../ na pasta de destino';
$MESSAGE['MEDIA_UPLOADED']                   = ' arquivos foram carregados com sucesso';
$MESSAGE['MOD_FORM_EXCESS_SUBMISSIONS']      = 'Desculpe, este formulário foi enviado muitas vezes nesta hora. Por favor, tente novamente na próxima hora.';
$MESSAGE['MOD_FORM_INCORRECT_CAPTCHA']       = 'O número de verificação (também conhecido como Captcha) que você inseriu está incorreto. Se você está tendo problemas para ler o Captcha, por favor, envie um e-mail para: <a href="mailto:{{SERVER_EMAIL}}">{{SERVER_EMAIL}}</a>';
$MESSAGE['MOD_FORM_REQUIRED_FIELDS']         = 'Você deve inserir detalhes para os seguintes campos';
$MESSAGE['PAGES_ADDED']                      = 'Página adicionada com sucesso';
$MESSAGE['PAGES_ADDED_HEADING']              = 'Título da página adicionado com sucesso';
$MESSAGE['PAGES_BLANK_MENU_TITLE']           = 'Por favor, insira um título de menu';
$MESSAGE['PAGES_BLANK_PAGE_TITLE']           = 'Por favor, insira um título de página';
$MESSAGE['PAGES_CANNOT_CREATE_ACCESS_FILE']  = 'Erro ao criar arquivo de acesso no diretório /pages (privilégios insuficientes)';
$MESSAGE['PAGES_CANNOT_DELETE_ACCESS_FILE']  = 'Erro ao excluir arquivo de acesso no diretório /pages (privilégios insuficientes)';
$MESSAGE['PAGES_CANNOT_REORDER']             = 'Erro ao reordenar página';
$MESSAGE['PAGES_DELETED']                    = 'Página excluída com sucesso';
$MESSAGE['PAGES_DELETE_CONFIRM']             = 'Tem certeza de que deseja excluir a página selecionada (e todas as suas subpáginas)?';
$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']   = 'Você não tem permissão para modificar esta página';
$MESSAGE['PAGES_INTRO_LINK']                 = 'Clique AQUI para modificar a página de introdução';
$MESSAGE['PAGES_INTRO_NOT_WRITABLE']         = 'Não é possível gravar no arquivo /pages/intro.php (privilégios insuficientes)';
$MESSAGE['PAGES_INTRO_SAVED']                = 'Página de introdução salva com sucesso';
$MESSAGE['PAGES_LAST_MODIFIED']              = 'Última modificação por';
$MESSAGE['PAGES_NOT_FOUND']                  = 'Página não encontrada';
$MESSAGE['PAGES_NOT_SAVED']                  = 'Erro ao salvar página';
$MESSAGE['PAGES_PAGE_EXISTS']                = 'Uma página com o mesmo título ou similar já existe';
$MESSAGE['PAGES_REORDERED']                  = 'Página reordenada com sucesso';
$MESSAGE['PAGES_RESTORED']                   = 'Página restaurada com sucesso';
$MESSAGE['PAGES_RETURN_TO_PAGES']            = 'Voltar para as páginas';
$MESSAGE['PAGES_SAVED']                      = 'Página salva com sucesso';
$MESSAGE['PAGES_SAVED_SETTINGS']             = 'Configurações da página salvas com sucesso';
$MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED']  = 'Propriedades da seção salvas com sucesso';
$MESSAGE['PAGE_MODIFIED']                    = 'A página foi modificada em %s por %s';
$MESSAGE['PREFERENCES_CURRENT_PASSWORD_INCORRECT'] = 'A senha (atual) que você inseriu está incorreta';
$MESSAGE['PREFERENCES_DETAILS_SAVED']        = 'Detalhes salvos com sucesso';
$MESSAGE['PREFERENCES_EMAIL_UPDATED']        = 'E-mail atualizado com sucesso';
$MESSAGE['PREFERENCES_INVALID_CHARS']        = 'Caracteres de senha inválidos usados';
$MESSAGE['PREFERENCES_PASSWORD_CHANGED']     = 'Senha alterada com sucesso';
$MESSAGE['RECORD_MODIFIED_FAILED']           = 'Falha na alteração do registro.';
$MESSAGE['RECORD_MODIFIED_SAVED']            = 'O registro alterado foi atualizado com sucesso.';
$MESSAGE['RECORD_NEW_FAILED']                = 'Falha ao adicionar um novo registro.';
$MESSAGE['RECORD_NEW_SAVED']                 = 'Novo registro adicionado com sucesso.';
$MESSAGE['REORG_SUCCESS']                    = 'A reorganização foi realizada com sucesso';
$MESSAGE['SETTINGS_MODE_SWITCH_WARNING']     = 'Por favor, note: Pressionar este botão redefine todas as alterações não salvas';
$MESSAGE['SETTINGS_SAVED']                   = 'Opções salvas com sucesso!';
$MESSAGE['SETTINGS_UNABLE_OPEN_CONFIG']      = 'Não é possível abrir o arquivo de configuração';
$MESSAGE['SETTINGS_UNABLE_WRITE_CONFIG']     = 'Não é possível gravar no arquivo de configuração';
$MESSAGE['SETTINGS_WORLD_WRITEABLE_WARNING'] = 'Por favor, note: isso é recomendado apenas para ambientes de teste';
$MESSAGE['SIGNUP2_ADMIN_INFO']               = "\r\nUm novo usuário foi registrado.\r\n\r\nNome de Login: {LOGIN_NAME}\r\n{DISPLAY_NAME}: {LOGIN_ID}\r\nE-Mail: {LOGIN_EMAIL}\r\nData de registro: {SIGNUP_DATE}\r\n----------------------------------------\r\nEsta mensagem foi gerada automaticamente!\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_FORGOT']       = "\r\nOlá {LOGIN_DISPLAY_NAME},\r\n\r\nEste e-mail foi enviado porque a função 'esqueci a senha' foi aplicada à sua conta.\r\n\r\nSeus novos detalhes de login de '{LOGIN_WEBSITE_TITLE}' são:\r\n\r\nNome de login: xxxxx\r\nSenha: {LOGIN_PASSWORD}\r\n\r\nSua senha foi redefinida para a acima.\r\nIsso significa que sua senha antiga não funcionará mais!\r\nSe você tiver alguma dúvida ou problema em relação aos seus novos dados de login\r\nvocê deve entrar em contato com a equipe do site ou com o administrador de '{LOGIN_WEBSITE_TITLE}'.\r\nLembre-se de limpar o cache do seu navegador antes de usar o novo para evitar falhas inesperadas.\r\n\r\nAtenciosamente\r\n------------------------------------\r\nEsta mensagem foi gerada automaticamente\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_INFO']          = "\r\nOlá {LOGIN_DISPLAY_NAME},\r\n\r\nBem-vindo ao '{LOGIN_WEBSITE_TITLE}'.\r\n\r\nSeus detalhes de login de '{LOGIN_WEBSITE_TITLE}' são:\r\nNome de login: xxxxx\r\nSenha: {LOGIN_PASSWORD}\r\n\r\nAtenciosamente\r\n\r\nPor favor:\r\nse você recebeu esta mensagem por engano, exclua-a imediatamente!\r\n-------------------------------------\r\nEsta mensagem foi gerada automaticamente!\r\n";
$MESSAGE['SIGNUP2_NEW_USER']                 = 'Um novo usuário foi registrado';
$MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO']       = 'Seus detalhes de login...';
$MESSAGE['SIGNUP2_SUBJECT_NEW_USER']         = 'Obrigado por se registrar';
$MESSAGE['SIGNUP_NO_EMAIL']                  = 'Você deve inserir um endereço de e-mail';
$MESSAGE['START_CURRENT_USER']               = 'Você está atualmente logado como:';
$MESSAGE['START_INSTALL_DIR_EXISTS']         = 'Aviso, o Diretório de Instalação ainda Existe!';
$MESSAGE['START_UPGRADE_SCRIPT_EXISTS']      = 'Por favor, exclua o arquivo {{file}} do seu espaço na web.';
$MESSAGE['START_WELCOME_MESSAGE']            = 'Bem-vindo à Administração do WebsiteBaker';
$MESSAGE['TEMPLATES_CHANGE_TEMPLATE_NOTICE'] = 'Por favor, note: para alterar o modelo, você deve ir para a seção Configurações';
$MESSAGE['THEME_ALREADY_EXISTS']             = 'Este novo descritor de tema já existe.';
$MESSAGE['THEME_COPY_CURRENT']               = 'Copie o tema ativo atual e salve-o com um novo nome.';
$MESSAGE['THEME_DESTINATION_READONLY']       = 'Sem direitos para criar novo diretório de tema!';
$MESSAGE['THEME_IMPORT_HTT']                 = 'Importar modelos adicionais para o tema ativo atual.<br />Use esses modelos para sobrescrever o modelo padrão correspondente.';
$MESSAGE['THEME_INVALID_SOURCE_DESTINATION'] = 'Descritor inválido para o novo tema fornecido!';
$MESSAGE['UNKNOW_UPLOAD_ERROR']              = 'Erro de upload desconhecido';
$MESSAGE['UPLOAD_ERR_CANT_WRITE']            = 'Falha ao gravar arquivo no disco';
$MESSAGE['UPLOAD_ERR_EXTENSION']             = 'Upload de arquivo interrompido pela extensão';
$MESSAGE['UPLOAD_ERR_FORM_SIZE']             = 'O arquivo carregado excede a diretiva MAX_FILE_SIZE que foi especificada no formulário HTML';
$MESSAGE['UPLOAD_ERR_INI_SIZE']              = 'O arquivo carregado excede a diretiva upload_max_filesize em php.ini';
$MESSAGE['UPLOAD_ERR_NO_FILE']               = 'Nenhum arquivo foi carregado';
$MESSAGE['UPLOAD_ERR_NO_TMP_DIR']            = 'Falta uma pasta temporária';
$MESSAGE['UPLOAD_ERR_OK']                    = 'O(s) arquivo(s) foi(foram) carregado(s) com sucesso';
$MESSAGE['UPLOAD_ERR_PARTIAL']               = 'O arquivo carregado foi apenas parcialmente carregado';
$MESSAGE['USERS_ADDED']                      = 'Usuário adicionado com sucesso';
$MESSAGE['USERS_CANT_SELFDELETE']            = 'Função rejeitada, você não pode se excluir!';
$MESSAGE['USERS_CHANGING_PASSWORD']          = 'Por favor, note: Você só deve inserir valores nos campos acima se desejar alterar a senha para este usuário';
$MESSAGE['USERS_CONFIRM_DELETE']             = 'Tem certeza de que deseja excluir o usuário selecionado?';
$MESSAGE['USERS_DELETED']                    = 'Usuário excluído com sucesso';
$MESSAGE['USERS_DISPLAYNAME_TAKEN']          = 'O nome de exibição especificado já está em uso.';
$MESSAGE['USERS_EMAIL_TAKEN']                = 'O e-mail que você inseriu já está em uso';
$MESSAGE['USERS_INVALID_EMAIL']              = 'O endereço de e-mail que você inseriu é inválido';
$MESSAGE['USERS_NAME_INVALID_CHARS']         = 'Caracteres inválidos para o nome de login encontrados';
$MESSAGE['USERS_NO_GROUP']                   = 'Nenhum grupo foi selecionado';
$MESSAGE['USERS_PASSWORD_MISMATCH']          = 'As senhas que você inseriu não correspondem';
$MESSAGE['USERS_PASSWORD_TOO_SHORT']         = 'A senha que você inseriu era muito curta';
$MESSAGE['USERS_SAVED']                      = 'Usuário salvo com sucesso';
$MESSAGE['USERS_USERNAME_TAKEN']             = 'O nome de login que você inseriu já está em uso';
$MESSAGE['USERS_USERNAME_TOO_SHORT']         = 'O nome de login que você inseriu era muito curto';
$OVERVIEW['ADMINTOOLS']                     = 'Acessar as ferramentas de administração do WebsiteBaker...';
$OVERVIEW['GROUPS']                         = 'Gerenciar grupos de usuários e suas permissões de sistema...';
$OVERVIEW['HELP']                           = 'Tem dúvidas? Encontre sua resposta...';
$OVERVIEW['LANGUAGES']                      = 'Gerenciar idiomas do WebsiteBaker...';
$OVERVIEW['MEDIA']                          = 'Gerenciar arquivos armazenados na pasta de mídia...';
$OVERVIEW['MODULES']                        = 'Gerenciar módulos do WebsiteBaker...';
$OVERVIEW['PAGES']                          = 'Gerenciar as páginas do seu site...';
$OVERVIEW['PREFERENCES']                    = 'Alterar preferências como endereço de e-mail, senha, etc... ';
$OVERVIEW['SETTINGS']                       = 'Altera as configurações do WebsiteBaker...';
$OVERVIEW['START']                          = 'Visão geral da administração';
$OVERVIEW['TEMPLATES']                      = 'Mude a aparência do seu site com modelos...';
$OVERVIEW['USERS']                          = 'Gerenciar usuários que podem fazer login no WebsiteBaker...';
$OVERVIEW['VIEW']                           = 'Visualize e navegue rapidamente pelo seu site em uma nova janela...';
$TEXT['ACCOUNT_SIGNUP']                     = 'Cadastro de Conta';
$TEXT['ACTIONS']                            = 'Ações';
$TEXT['ACTIVE']                             = 'Ativo';
$TEXT['ADD']                                = 'Adicionar';
$TEXT['ADDON']                              = 'Add-on';
$TEXT['ADD_SECTION']                        = 'Adicionar Seção';
$TEXT['ADMIN']                              = 'Admin';
$TEXT['ADMINISTRATION']                     = 'Administração';
$TEXT['ADMINISTRATION_TOOL']                = 'Ferramenta de administração';
$TEXT['ADMINISTRATOR']                      = 'Administrador';
$TEXT['ADMINISTRATORS']                     = 'Administradores';
$TEXT['ADVANCED']                           = 'Avançado';
$TEXT['ALLOWED_FILETYPES_ON_UPLOAD']        = 'Tipos de arquivo permitidos no upload';
$TEXT['ALLOWED_VIEWERS']                    = 'Visualizadores Permitidos';
$TEXT['ALLOW_MULTIPLE_SELECTIONS']          = 'Permitir Múltiplas Seleções';
$TEXT['ALL_WORDS']                          = 'Todas as Palavras';
$TEXT['ANCHOR']                             = 'Âncora';
$TEXT['ANONYMOUS']                          = 'Anônimo';
$TEXT['ANY_WORDS']                          = 'Quaisquer Palavras';
$TEXT['APP_NAME']                           = 'Nome do Aplicativo';
$TEXT['ARE_YOU_SURE']                       = 'Você tem certeza?';
$TEXT['AUTHOR']                             = 'Autor';
$TEXT['BACK']                               = 'Voltar';
$TEXT['BACKUP']                             = 'Backup';
$TEXT['BACKUP_ALL_TABLES']                  = 'Backup de todas as tabelas no banco de dados';
$TEXT['BACKUP_DATABASE']                    = 'Backup do Banco de Dados';
$TEXT['BACKUP_MEDIA']                       = 'Backup de Mídia';
$TEXT['BACKUP_WB_SPECIFIC']                 = 'Backup apenas das tabelas específicas do WB';
$TEXT['BASIC']                              = 'Básico';
$TEXT['BLOCK']                              = 'Bloco';
$TEXT['BROWSE_UPLOAD_FILE']                 = 'Selecionar um arquivo!';
$TEXT['CALENDAR']                           = 'Calendário';
$TEXT['CANCEL']                             = 'Cancelar';
$TEXT['CAN_DELETE_HIMSELF']                 = 'Pode se excluir';
$TEXT['CAPTCHA_VERIFICATION']               = 'Verificação de Captcha';
$TEXT['CAP_EDIT_CSS']                       = 'Editar CSS';
$TEXT['CHANGE']                             = 'Alterar';
$TEXT['CHANGES']                            = 'Mudanças';
$TEXT['CHANGE_SETTINGS']                    = 'Alterar Configurações';
$TEXT['CHARSET']                            = 'Charset';
$TEXT['CHECKBOX_GROUP']                     = 'Grupo de Caixa de Seleção';
$TEXT['CLOSE']                              = 'Fechar';
$TEXT['CODE']                               = 'Código';
$TEXT['CODE_SNIPPET']                       = 'Snippet de código';
$TEXT['COLLAPSE']                           = 'Recolher';
$TEXT['COMMENT']                            = 'Comentário';
$TEXT['COMMENTING']                         = 'Comentando';
$TEXT['COMMENTS']                           = 'Comentários';
$TEXT['CONFIRM']                            = 'Confirmar';
$TEXT['CREATE_FOLDER']                      = 'Criar Pasta';
$TEXT['CURRENT']                            = 'Atual';
$TEXT['CURRENT_FOLDER']                     = 'Pasta Atual';
$TEXT['CURRENT_PAGE']                       = 'Página Atual';
$TEXT['CURRENT_PASSWORD']                   = 'Senha Atual';
$TEXT['CUSTOM']                             = 'Personalizado';
$TEXT['DATABASE']                           = 'Banco de Dados';
$TEXT['DATE']                               = 'Data';
$TEXT['DATE_FORMAT']                        = 'Formato da Data';
$TEXT['DEFAULT']                            = 'Padrão';
$TEXT['DEFAULT_CHARSET']                    = 'Charset Padrão';
$TEXT['DEFAULT_TEXT']                       = 'Texto Padrão';
$TEXT['DELETE']                             = 'Excluir';
$TEXT['DELETED']                            = 'Excluído';
$TEXT['DELETE_DATE']                        = 'Data de Exclusão';
$TEXT['DELETE_ZIP']                         = 'Excluir arquivo zip após descompactar';
$TEXT['DESCRIPTION']                        = 'Descrição';
$TEXT['DESIGNED_FOR']                       = 'Projetado Para';
$TEXT['DEV_INFOS']                          = 'Informações do Desenvolvedor';
$TEXT['DIRECTORIES']                        = 'Diretórios';
$TEXT['DIRECTORY_MODE']                     = 'Modo de Diretório';
$TEXT['DISABLED']                           = 'Desabilitado';
$TEXT['DISPLAY_NAME']                       = 'Nome de Exibição';
$TEXT['EMAIL']                              = 'E-mail';
$TEXT['EMAIL_ADDRESS']                      = 'Endereço de E-mail';
$TEXT['EMPTY_TRASH']                        = 'Esvaziar Lixeira';
$TEXT['ENABLED']                            = 'Habilitado';
$TEXT['END']                                = 'Fim';
$TEXT['ERROR']                              = 'Erro';
$TEXT['EXACT_MATCH']                        = 'Correspondência Exata';
$TEXT['EXECUTE']                            = 'Executar';
$TEXT['EXPAND']                             = 'Expandir';
$TEXT['EXTENSION']                          = 'Extensão';
$TEXT['FIELD']                              = 'Campo';
$TEXT['FILE']                               = 'Arquivo';
$TEXT['FILES']                              = 'Arquivos';
$TEXT['FILESYSTEM_PERMISSIONS']             = 'Permissões do Sistema de Arquivos';
$TEXT['FILE_MODE']                          = 'Modo de Arquivo';
$TEXT['FINISH_PUBLISHING']                  = 'Concluir Publicação';
$TEXT['FOLDER']                             = 'Pasta';
$TEXT['FOLDERS']                            = 'Pastas';
$TEXT['FOOTER']                             = 'Rodapé';
$TEXT['FORGOTTEN_DETAILS']                  = 'Esqueceu seus detalhes?';
$TEXT['FORGOT_DETAILS']                     = 'Esqueceu os detalhes?';
$TEXT['FROM']                               = 'De';
$TEXT['FRONTEND']                           = 'Frontend';
$TEXT['FULL_NAME']                          = 'Nome Completo';
$TEXT['FUNCTION']                           = 'Função';
$TEXT['GROUP']                              = 'Grupo';
$TEXT['GUEST']                              = 'Convidado';
$TEXT['HEADER']                             = 'Cabeçalho';
$TEXT['HEADING']                            = 'Título';
$TEXT['HEADING_CSS_FILE']                   = 'Arquivo de módulo atual: ';
$TEXT['HEIGHT']                             = 'Altura';
$TEXT['HIDDEN']                             = 'Oculto';
$TEXT['HIDE']                               = 'Ocultar';
$TEXT['HIDE_ADVANCED']                      = 'Ocultar Opções Avançadas';
$TEXT['HOME']                               = 'Início';
$TEXT['HOMEPAGE_REDIRECTION']               = 'Redirecionamento da Página Inicial';
$TEXT['HOME_FOLDER']                        = 'Pasta Pessoal';
$TEXT['HOME_FOLDERS']                       = 'Pastas Pessoais';
$TEXT['HOST']                               = 'Host';
$TEXT['ICON']                               = 'Ícone';
$TEXT['IMAGE']                              = 'Imagem';
$TEXT['INLINE']                             = 'Em linha';
$TEXT['INSTALL']                            = 'Instalar';
$TEXT['INSTALLATION']                       = 'Instalação';
$TEXT['INSTALLATION_PATH']                  = 'Caminho de Instalação';
$TEXT['INSTALLATION_URL']                   = 'URL de Instalação';
$TEXT['INSTALLED']                          = 'instalado';
$TEXT['INTRO']                              = 'Introdução';
$TEXT['INTRO_PAGE']                         = 'Página de Introdução';
$TEXT['INVALID_SIGNS']                      = 'deve começar com uma letra ou contém caracteres inválidos';
$TEXT['KEYWORDS']                           = 'Palavras-chave';
$TEXT['LANGUAGE']                           = 'Idioma';
$TEXT['LAST_UPDATED_BY']                    = 'Última Atualização Por';
$TEXT['LENGTH']                             = 'Comprimento';
$TEXT['LEVEL']                              = 'Nível';
$TEXT['LICENSE']                            = 'Licença';
$TEXT['LINK']                               = 'Link';
$TEXT['LINUX_UNIX_BASED']                   = 'Baseado em Linux/Unix';
$TEXT['LIST_OPTIONS']                       = 'Opções de Lista';
$TEXT['LOGGED_IN']                          = 'Logado';
$TEXT['LOGIN']                              = 'Login';
$TEXT['LONG']                               = 'Longo';
$TEXT['LONG_TEXT']                          = 'Texto Longo';
$TEXT['LOOP']                               = 'Loop';
$TEXT['MAIN']                               = 'Principal';
$TEXT['USER_LOGIN_ON']                      = 'Permitir login de usuário';
$TEXT['USER_LOGIN_OFF']                     = 'Prevenir login de usuário';
$TEXT['MAINTENANCE_OFF']                    = 'Manutenção desativada';
$TEXT['MAINTENANCE_ON']                     = 'Manutenção ativada';
$TEXT['MANAGE']                             = 'Gerenciar';
$TEXT['MANAGE_GROUPS']                      = 'Gerenciar Grupos';
$TEXT['MANAGE_USERS']                       = 'Gerenciar Usuários';
$TEXT['MATCH']                              = 'Corresponder';
$TEXT['MATCHING']                           = 'Correspondência';
$TEXT['MAX_EXCERPT']                        = 'Máx. linhas de excerto';
$TEXT['MAX_SUBMISSIONS_PER_HOUR']           = 'Máx. Envios Por Hora';
$TEXT['MEDIA_DIRECTORY']                    = 'Diretório de Mídia';
$TEXT['MENU']                               = 'Menu';
$TEXT['MENU_ICON_0']                        = 'Ícone do Menu normal';
$TEXT['MENU_ICON_1']                        = 'Ícone do Menu ao passar o mouse';
$TEXT['MENU_TITLE']                         = 'Título do Menu';
$TEXT['MESSAGE']                            = 'Mensagem';
$TEXT['MODIFY']                             = 'Modificar';
$TEXT['MODIFY_CONTENT']                     = 'Modificar Conteúdo';
$TEXT['MODIFY_SETTINGS']                    = 'Modificar Configurações';
$TEXT['MODULE_ORDER']                       = 'Ordem do módulo para pesquisa';
$TEXT['MODULE_PERMISSIONS']                 = 'Permissões do Módulo';
$TEXT['MORE']                               = 'Mais';
$TEXT['MOVE_DOWN']                          = 'Mover Para Baixo';
$TEXT['MOVE_UP']                            = 'Mover Para Cima';
$TEXT['MULTILINGUAL']                       = 'MULTILÍNGUE';
$TEXT['MULTIPLE_MENUS']                     = 'Múltiplos Menus';
$TEXT['MULTISELECT']                        = 'Múltipla Seleção';
$TEXT['NAME']                               = 'Nome';
$TEXT['NEED_CURRENT_PASSWORD']              = 'confirmar com a senha atual';
$TEXT['NEED_TO_LOGIN']                      = 'Precisa fazer login?';
$TEXT['NEW_PASSWORD']                       = 'Nova Senha';
$TEXT['NEW_WINDOW']                         = 'Nova Janela';
$TEXT['NEXT']                               = 'Próximo';
$TEXT['NEXT_PAGE']                          = 'Próxima Página';
$TEXT['NO']                                 = 'Não';
$TEXT['NONE']                               = 'Nenhum';
$TEXT['NONE_FOUND']                         = 'Nenhum Encontrado';
$TEXT['NOT_FOUND']                          = 'Não Encontrado';
$TEXT['NOT_INSTALLED']                      = 'não instalado';
$TEXT['NO_IMAGE_SELECTED']                  = 'nenhuma imagem selecionada';
$TEXT['NO_RESULTS']                         = 'Sem Resultados';
$TEXT['NO_SELECTION']                       = 'nenhuma seleção';
$TEXT['OF']                                 = 'de';
$TEXT['ON']                                 = 'ligado';
$TEXT['OPEN']                               = 'Abrir';
$TEXT['OPTION']                             = 'Opção';
$TEXT['OTHERS']                             = 'Outros';
$TEXT['OUT_OF']                             = 'Fora de';
$TEXT['OVERWRITE_EXISTING']                 = 'Sobrescrever existente';
$TEXT['PAGE']                               = 'Página';
$TEXT['PAGES_DIRECTORY']                    = 'Diretório de Páginas';
$TEXT['PAGES_PERMISSION']                   = 'Permissão de Páginas';
$TEXT['PAGES_PERMISSIONS']                  = 'Permissões de Páginas';
$TEXT['PAGE_EXTENSION']                     = 'Extensão de Página';
$TEXT['PAGE_ICON']                          = 'Ícone da Página';
$TEXT['PAGE_ICON_DIR']                      = 'Caminho imagens de páginas/menu';
$TEXT['PAGE_LANGUAGES']                     = 'Idiomas da Página';
$TEXT['PAGE_LEVEL_LIMIT']                   = 'Limite de Nível de Página';
$TEXT['PAGE_SPACER']                        = 'Espaçador de Página';
$TEXT['PAGE_TITLE']                         = 'Título da Página';
$TEXT['PAGE_TRASH']                         = 'Lixeira de Páginas';
$TEXT['PARENT']                             = 'Pai';
$TEXT['PASSWORD']                           = 'Senha';
$TEXT['PATH']                               = 'Caminho';
$TEXT['PHP_ERROR_LEVEL']                    = 'Nível de Relato de Erros PHP';
$TEXT['PLEASE_LOGIN']                       = 'Por favor, faça login';
$TEXT['PLEASE_SELECT']                      = 'Por favor, selecione';
$TEXT['POST']                               = 'Publicar';
$TEXT['POSTS_PER_PAGE']                     = 'Publicações por Página';
$TEXT['POST_FOOTER']                        = 'Rodapé da Publicação';
$TEXT['POST_HEADER']                        = 'Cabeçalho da Publicação';
$TEXT['PREVIOUS']                           = 'Anterior';
$TEXT['PREVIOUS_PAGE']                      = 'Página Anterior';
$TEXT['PRIVATE']                            = 'Privado';
$TEXT['PRIVATE_VIEWERS']                    = 'Visualizadores Privados';
$TEXT['PROFILES_EDIT']                      = 'Alterar o perfil';
$TEXT['PUBLIC']                             = 'Público';
$TEXT['PUBL_END_DATE']                      = 'Data Final';
$TEXT['PUBL_START_DATE']                    = 'Data de Início';
$TEXT['RADIO_BUTTON_GROUP']                 = 'Grupo de Botões de Rádio';
$TEXT['READ']                               = 'Ler';
$TEXT['READ_MORE']                          = 'Ler Mais';
$TEXT['REDIRECT_AFTER']                     = 'Redirecionar após';
$TEXT['REGISTERED']                         = 'Registrado';
$TEXT['REGISTERED_VIEWERS']                 = 'Visualizadores Registrados';
$TEXT['RELOAD']                             = 'Recarregar';
$TEXT['REMEMBER_ME']                        = 'Lembrar-me';
$TEXT['RENAME']                             = 'Renomear';
$TEXT['RENAME_FILES_ON_UPLOAD']             = 'Não enviar para estes tipos de arquivo';
$TEXT['REQUIRED']                           = 'Obrigatório';
$TEXT['REQUIREMENT']                        = 'Requisito';
$TEXT['RESET']                              = 'Redefinir';
$TEXT['RESIZE']                             = 'Redimensionar';
$TEXT['RESIZE_IMAGE_TO']                    = 'Redimensionar Imagem Para';
$TEXT['REFILL']                             = 'Redefinir entradas';
$TEXT['RESTORE']                            = 'Redefinir entradas';
$TEXT['RESTORE_DATABASE']                   = 'Restaurar Banco de Dados';
$TEXT['RESTORE_MEDIA']                      = 'Restaurar Mídia';
$TEXT['RESULTS']                            = 'Resultados';
$TEXT['RESULTS_FOOTER']                     = 'Rodapé dos Resultados';
$TEXT['RESULTS_FOR']                        = 'Resultados Para';
$TEXT['RESULTS_HEADER']                     = 'Cabeçalho dos Resultados';
$TEXT['RESULTS_LOOP']                       = 'Loop de Resultados';
$TEXT['RETYPE_NEW_PASSWORD']                = 'Redigite a Nova Senha';
$TEXT['RETYPE_PASSWORD']                    = 'Redigite a Senha';
$TEXT['SAME_WINDOW']                        = 'Mesma Janela';
$TEXT['SAVE']                               = 'Salvar';
$TEXT['SEARCH']                             = 'Pesquisar';
$TEXT['SEARCHING']                          = 'Pesquisando';
$TEXT['SECTION']                            = 'Seção';
$TEXT['SECTION_BLOCKS']                     = 'Blocos de Seção';
$TEXT['SEC_ANCHOR']                         = 'Texto de Âncora da Seção';
$TEXT['SELECT_BOX']                         = 'Caixa de Seleção';
$TEXT['SEND_DETAILS']                       = 'Enviar Detalhes';
$TEXT['SEPARATE']                           = 'Separado';
$TEXT['SEPERATOR']                          = 'Separador';
$TEXT['SERVER_EMAIL']                       = 'E-mail do Servidor';
$TEXT['SERVER_OPERATING_SYSTEM']            = 'Sistema Operacional do Servidor';
$TEXT['SESSION_IDENTIFIER']                 = 'Identificador de Sessão';
$TEXT['SETTINGS']                           = 'Configurações';
$TEXT['SHORT']                              = 'Curto';
$TEXT['SHORT_TEXT']                         = 'Texto Curto';
$TEXT['SHOW']                               = 'Mostrar';
$TEXT['SHOW_ADVANCED']                      = 'Mostrar Opções Avançadas';
$TEXT['SIGNUP']                             = 'Cadastrar-se';
$TEXT['SIZE']                               = 'Tamanho';
$TEXT['SMART_LOGIN']                        = 'Login Inteligente';
$TEXT['START']                              = 'Início';
$TEXT['START_PUBLISHING']                   = 'Começar a Publicar';
$TEXT['SUBJECT']                            = 'Assunto';
$TEXT['SUBMISSIONS']                        = 'Envios';
$TEXT['SUBMISSIONS_STORED_IN_DATABASE']     = 'Envios Armazenados no Banco de Dados';
$TEXT['SUBMISSION_ID']                      = 'ID de Envio';
$TEXT['SUBMITTED']                          = 'Enviado';
$TEXT['SUCCESS']                            = 'Sucesso';
$TEXT['SYSTEM_DEFAULT']                     = 'Padrão do Sistema';
$TEXT['SYSTEM_PERMISSIONS']                 = 'Permissões do Sistema';
$TEXT['TABLE_PREFIX']                       = 'Prefixo da Tabela';
$TEXT['TARGET']                             = 'Alvo';
$TEXT['TARGET_FOLDER']                      = 'Pasta de destino';
$TEXT['TEMPLATE']                           = 'Modelo';
$TEXT['TEMPLATE_PERMISSIONS']               = 'Permissões do Modelo';
$TEXT['TEXT']                               = 'Texto';
$TEXT['TEXTAREA']                           = 'Área de Texto';
$TEXT['TEXTFIELD']                          = 'Campo de Texto';
$TEXT['THEME']                              = 'Tema do Backend';
$TEXT['THEME_COPY_CURRENT']                 = 'Copiar tema do backend.';
$TEXT['THEME_CURRENT']                      = 'tema ativo atual';
$TEXT['THEME_IMPORT_HTT']                   = 'Importar modelos adicionais';
$TEXT['THEME_NEW_NAME']                     = 'Nome do novo Tema';
$TEXT['THEME_NOMORE_HTT']                   = 'não mais disponível';
$TEXT['THEME_SELECT_HTT']                   = 'selecionar modelos';
$TEXT['THEME_START_COPY']                   = 'copiar';
$TEXT['THEME_START_IMPORT']                 = 'importar';
$TEXT['TIME']                               = 'Hora';
$TEXT['TIMEZONE']                           = 'Fuso Horário';
$TEXT['TIME_FORMAT']                        = 'Formato da Hora';
$TEXT['TIME_LIMIT']                         = 'Tempo máximo para coletar excertos por módulo';
$TEXT['TITLE']                              = 'Título';
$TEXT['TO']                                 = 'Para';
$TEXT['TOP_FRAME']                          = 'Moldura Superior';
$TEXT['TRASH_EMPTIED']                      = 'Lixeira Esvaziada';
$TEXT['TXT_EDIT_CSS_FILE']                  = 'Edite as definições CSS na área de texto abaixo.';
$TEXT['TYPE']                               = 'Tipo';
$TEXT['UNDER_CONSTRUCTION']                 = 'Em Construção';
$TEXT['UNINSTALL']                          = 'Desinstalar';
$TEXT['UNKNOWN']                            = 'Desconhecido';
$TEXT['UNLIMITED']                          = 'Ilimitado';
$TEXT['UNZIP_FILE']                         = 'Carregar e descompactar um arquivo zip';
$TEXT['UP']                                 = 'Cima';
$TEXT['UPGRADE']                            = 'Atualizar';
$TEXT['UPLOAD_FILES']                       = 'Carregar Arquivo(s)';
$TEXT['URL']                                = 'URL';
$TEXT['USER']                               = 'Usuário';
$TEXT['USERNAME']                           = 'Nome de Usuário';
$TEXT['USERS_ACTIVE']                       = 'Usuário ativo';
$TEXT['USERS_CAN_SELFDELETE']               = 'Usuário pode se autoexcluir';
$TEXT['USERS_CHANGE_SETTINGS']              = 'Usuário pode alterar suas próprias configurações';
$TEXT['USERS_DELETED']                      = 'Usuário marcado como excluído';
$TEXT['USERS_FLAGS']                        = 'Sinalizadores de Usuário';
$TEXT['USERS_PROFILE_ALLOWED']              = 'Usuário pode criar perfil estendido';
$TEXT['VERIFICATION']                       = 'Verificação';
$TEXT['VERSION']                            = 'Versão';
$TEXT['VIEW']                               = 'Ver';
$TEXT['VIEW_DELETED_PAGES']                 = 'Ver Páginas Excluídas';
$TEXT['VIEW_DETAILS']                       = 'Ver Detalhes';
$TEXT['VISIBILITY']                         = 'Visibilidade';
$TEXT['WBMAILER_DEFAULT_SENDER_MAIL']       = 'Endereço "De" padrão';
$TEXT['WBMAILER_DEFAULT_SENDER_NAME']       = 'Nome do Remetente Padrão';
$TEXT['WBMAILER_DEFAULT_SETTINGS_NOTICE']   = 'Por favor, especifique um endereço "DE" e um nome de "REMETENTE" padrão abaixo. Recomenda-se usar um endereço DE: como: <strong>admin@seusite.com</strong>. Alguns provedores de e-mail (por exemplo, <em>mail.com</em>) podem recusar e-mails com um endereço DE: como <em>nome@mail.com</em> enviados por meio de um retransmissor estrangeiro para evitar spam.<br /><br />Os valores padrão são usados apenas se nenhum outro valor for especificado pelo WebsiteBaker. Se o seu servidor suportar <abbr title="Simple mail transfer protocol">SMTP</abbr>, você pode querer usar esta opção para e-mails de saída.';
$TEXT['WBMAILER_FUNCTION']                  = 'Rotina de E-mail';
$TEXT['WBMAILER_NOTICE']                    = '<strong>Configurações do Mailer SMTP:</strong><br />As configurações abaixo são necessárias apenas se você deseja enviar e-mails via <abbr title="Simple mail transfer protocol">SMTP</abbr>. Se você não conhece seu host SMTP ou não tem certeza sobre as configurações necessárias, simplesmente mantenha a rotina de e-mail padrão: PHP MAIL.';
$TEXT['WBMAILER_PHP']                       = 'PHP MAIL';
$TEXT['WBMAILER_SMTP']                      = 'SMTP';
$TEXT['WBMAILER_SMTP_AUTH']                 = 'Autenticação SMTP';
$TEXT['WBMAILER_SMTP_AUTH_NOTICE']          = 'ativar apenas se o seu host SMTP exigir autenticação';
$TEXT['WBMAILER_SMTP_HOST']                 = 'Host SMTP';
$TEXT['WBMAILER_SMTP_PASSWORD']             = 'Senha SMTP';
$TEXT['WBMAILER_SMTP_USERNAME']             = 'Nome de Usuário SMTP';
$TEXT['WEBSITE']                            = 'Website';
$TEXT['WEBSITE_DESCRIPTION']                = 'Descrição de Metadados';
$TEXT['WEBSITE_FOOTER']                     = 'Rodapé do Site';
$TEXT['WEBSITE_HEADER']                     = 'Cabeçalho do Site';
$TEXT['WEBSITE_KEYWORDS']                   = 'Palavras-chave de Metadados';
$TEXT['WEBSITE_TITLE']                      = 'Título de Metadados';
$TEXT['WELCOME_BACK']                       = 'Bem-vindo de volta';
$TEXT['WIDTH']                              = 'Largura';
$TEXT['WINDOW']                             = 'Janela';
$TEXT['WINDOWS']                            = 'Windows';
$TEXT['WORLD_WRITEABLE_FILE_PERMISSIONS']   = 'Permissões de arquivo graváveis por todos';
$TEXT['WRITE']                              = 'Escrever';
$TEXT['WYSIWYG_EDITOR']                     = 'Editor WYSIWYG';
$TEXT['WYSIWYG_STYLE']                      = 'Estilo WYSIWYG';
$TEXT['YES']                                = 'Sim';

$TEXT['NO_REVERT'] = 'Você não pode desfazer isso!';
$TEXT['NO_DELETED'] = 'A exclusão não foi executada!';
$TEXT['PAGE_CODE'] = 'Código da Página';
