<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of \languages\NO
 * @package          CoreTranslation
 * @copyright        Manuela v.d.Decken <manuela@isteam.de>
 * @author          $Author: Uwe $
 * @license         GNU General Public License 2.0
 * @version         4.0.3
 * @revision        $Revision: 63 $
 * @since           $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @lastmodified    $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @deprecated      no
 * @description     CoreTranslation
 * @svn-id          $Header: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/languages/NO.php 63 2025-09-01 10:08:14Z Uwe $
 */

//declare(strict_types = 1);

//declare(encoding = 'UTF-8');

if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
// Define that this file is loaded
if (!defined('LANGUAGE_LOADED')) { define('LANGUAGE_LOADED', true); }

// Set the language information
$language_code = 'NO';
$language_name = 'Norsk';
$language_version = '4.0.3';
$language_platform = '2.11.0';
$language_author = 'Jacobi22';// All translations by Google AI
$language_license = 'GNU General Public License 2.0';

$HEADING['ADDON_PRECHECK_FAILED']            = 'Add-On-krav er ikke oppfylt';
$HEADING['ADD_CHILD_PAGE']                   = 'Legg til underside';
$HEADING['ADD_GROUP']                        = 'Legg til gruppe';
$HEADING['ADD_GROUPS']                       = 'Legg til grupper';
$HEADING['ADD_HEADING']                      = 'Legg til overskrift';
$HEADING['ADD_PAGE']                         = 'Legg til side';
$HEADING['ADD_USER']                         = 'Legg til bruker';
$HEADING['ADMINISTRATION_TOOLS']             = 'Administrasjonsverktøy';
$HEADING['BROWSE_MEDIA']                     = 'Bla gjennom medier';
$HEADING['CREATE_FOLDER']                    = 'Opprett mappe';
$HEADING['DEFAULT_SETTINGS']                 = 'Standardinnstillinger';
$HEADING['DELETED_PAGES']                    = 'Slettede sider';
$HEADING['FILESYSTEM_SETTINGS']              = 'Filysysteminnstillinger';
$HEADING['GENERAL_SETTINGS']                 = 'Generelle innstillinger';
$HEADING['INSTALL_LANGUAGE']                 = 'Installer språk';
$HEADING['INSTALL_MODULE']                   = 'Installer modul';
$HEADING['INSTALL_TEMPLATE']                 = 'Installer mal';
$HEADING['INVOKE_LANGUAGE_FILES']            = 'Utfør språkfiler manuelt';
$HEADING['INVOKE_MODULE_FILES']              = 'Utfør modulfiler manuelt';
$HEADING['INVOKE_TEMPLATE_FILES']            = 'Utfør malfiler manuelt';
$HEADING['LANGUAGE_DETAILS']                 = 'Språkdetaljer';
$HEADING['MANAGE_SECTIONS']                  = 'Administrer seksjoner';
$HEADING['MODIFY_ADVANCED_PAGE_SETTINGS']    = 'Endre avanserte sideinnstillinger';
$HEADING['MODIFY_DELETE_GROUP']              = 'Endre/slett gruppe';
$HEADING['MODIFY_DELETE_PAGE']               = 'Endre/slett side';
$HEADING['MODIFY_DELETE_USER']               = 'Endre/slett bruker';
$HEADING['MODIFY_GROUP']                     = 'Endre gruppe';
$HEADING['MODIFY_GROUPS']                    = 'Endre grupper';
$HEADING['MODIFY_INTRO_PAGE']                = 'Endre introtekst';
$HEADING['MODIFY_PAGE']                      = 'Endre side';
$HEADING['MODIFY_PAGE_SETTINGS']             = 'Endre sideinnstillinger';
$HEADING['MODIFY_USER']                      = 'Endre bruker';
$HEADING['MODULE_DETAILS']                   = 'Moduldetaljer';
$HEADING['MY_EMAIL']                         = 'Min e-post';
$HEADING['MY_PASSWORD']                      = 'Mitt passord';
$HEADING['MY_SETTINGS']                      = 'Mine innstillinger';
$HEADING['SEARCH_SETTINGS']                  = 'Søkeinnstillinger';
$HEADING['SERVER_SETTINGS']                  = 'Serverinnstillinger';
$HEADING['TEMPLATE_DETAILS']                 = 'Maldetaljer';
$HEADING['UNINSTALL_LANGUAGE']               = 'Avinstaller språk';
$HEADING['UNINSTALL_MODULE']                 = 'Avinstaller modul';
$HEADING['UNINSTALL_TEMPLATE']               = 'Avinstaller mal';
$HEADING['UPGRADE_LANGUAGE']                 = 'Språkregistrering/oppgradering';
$HEADING['UPLOAD_FILES']                     = 'Last opp fil(er)';
$HEADING['WBMAILER_SETTINGS']                = 'E-postinnstillinger';
$MENU['ACCESS']                             = 'Brukeradministrasjon';
$MENU['ADDON']                              = 'Add-on';
$MENU['ADDONS']                             = 'Add-ons';
$MENU['ADMINTOOLS']                         = 'Admin-verktøy';
$MENU['BREADCRUMB']                         = 'Du er her: ';
$MENU['FORGOT']                             = 'Hent innloggingsdetaljer';
$MENU['GROUP']                              = 'Gruppe';
$MENU['GROUPS']                             = 'Grupper';
$MENU['HELP']                               = 'Hjelp';
$MENU['LANGUAGES']                          = 'Språk';
$MENU['LOGIN']                              = 'Logg inn';
$MENU['LOGOUT']                             = 'Logg ut';
$MENU['MEDIA']                              = 'Medier';
$MENU['MODULES']                            = 'Moduler';
$MENU['MY_PROFILE']                         = 'Min profil';
$MENU['PAGES']                              = 'Sider';
$MENU['PREFERENCES']                        = 'Innstillinger';
$MENU['REORG_TABLE']                        = 'Reorganiser tabeller';
$MENU['SETTINGS']                           = 'Innstillinger';
$MENU['START']                              = 'Start';
$MENU['TEMPLATES']                          = 'Maler';
$MENU['USERS']                              = 'Brukere';
$MENU['VIEW']                               = 'Vis';
$MESSAGE['ADDON_ERROR_RELOAD']               = 'Feil under oppdatering av Add-On-informasjonen.';
$MESSAGE['ADDON_LANGUAGES_RELOADED']         = 'Språk lastet inn på nytt';
$MESSAGE['ADDON_MANUAL_FTP_LANGUAGE']        = '<strong>OBS!</strong> Av sikkerhetsgrunner, overfør kun språkfiler via FTP til /languages/-mappen og bruk oppgraderingsfunksjonen for å registrere eller oppdatere.';
$MESSAGE['ADDON_MANUAL_FTP_WARNING']         = 'Advarsel: Eksisterende moduldatabaseoppføringer vil gå tapt. ';
$MESSAGE['ADDON_MANUAL_INSTALLATION']        = 'Når moduler lastes opp via FTP (ikke anbefalt), vil modulinstallasjonsfunksjonene <code>install</code>, <code>upgrade</code> eller <code>uninstall</code> ikke bli utført automatisk. Disse modulene fungerer kanskje ikke riktig eller avinstalleres ikke ordentlig.<br /><br />Du kan utføre modulfunksjonene manuelt for moduler lastet opp via FTP nedenfor.';
$MESSAGE['ADDON_MANUAL_INSTALLATION_WARNING']= 'Advarsel: Eksisterende moduldatabaseoppføringer vil gå tapt. Bruk kun dette alternativet hvis du opplever problemer med moduler lastet opp via FTP.';
$MESSAGE['ADDON_MANUAL_RELOAD_WARNING']      = 'Advarsel: Eksisterende moduldatabaseoppføringer vil gå tapt. ';
$MESSAGE['ADDON_MODULES_RELOADED']           = 'Moduler lastet inn på nytt';
$MESSAGE['ADDON_OVERWRITE_NEWER_FILES']      = 'Overskriv nyere filer';
$MESSAGE['ADDON_PRECHECK_FAILED']            = 'Installering av tillegg mislyktes. Systemet ditt oppfyller ikke kravene til dette tillegget. For at dette tillegget skal fungere på systemet ditt, vennligst fiks problemene oppsummert nedenfor.';
$MESSAGE['ADDON_RELOAD']                     = 'Oppdater database med informasjon fra Add-on-filer (f.eks. etter FTP-opplasting).';
$MESSAGE['ADDON_TEMPLATES_RELOADED']         = 'Maler lastet inn på nytt';
$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES']   = 'Utilstrekkelige tilgangsrettigheter';
$MESSAGE['FORGOT_PASS_ALREADY_RESET']        = 'Passordet kan bare tilbakestilles én gang i timen';
$MESSAGE['FORGOT_PASS_CANNOT_EMAIL']         = 'Kan ikke sende passord via e-post, vennligst kontakt systemadministratoren';
$MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND']      = 'E-posten du skrev inn kan ikke finnes i databasen';
$MESSAGE['FORGOT_PASS_NO_DATA']              = 'Vennligst skriv inn din e-postadresse nedenfor';
$MESSAGE['FORGOT_PASS_PASSWORD_RESET']       = 'Passordet ditt er sendt til din e-postadresse';
$MESSAGE['FRONTEND_SORRY_NO_ACTIVE_SECTIONS']= 'Beklager, ingen aktivt innhold å vise';
$MESSAGE['FRONTEND_SORRY_NO_VIEWING_PERMISSIONS'] = 'Beklager, du har ikke tillatelse til å se denne siden';
$MESSAGE['GENERIC_ALREADY_INSTALLED']        = 'Allerede installert';
$MESSAGE['GENERIC_BAD_PERMISSIONS']          = 'Kan ikke skrive til målmappen';
$MESSAGE['GENERIC_BE_PATIENT']               = 'Vennligst vær tålmodig.';
$MESSAGE['GENERIC_CANNOT_UNINSTALL']         = 'Kan ikke avinstallere';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE']  = 'Kan ikke avinstallere: den valgte filen er i bruk';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL'] = '<br /><br />{{type}} <b>{{type_name}}</b> kunne ikke avinstalleres, fordi den fortsatt er i bruk på {{pages}}.<br /><br />';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL_PAGES'] = 'denne siden;disse sidene';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_TEMPLATE'] = 'Kan ikke avinstallere malen <b>{{name}}</b>, fordi den er standardmalen!';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_THEME'] = 'Kan ikke avinstallere malen <b>{{name}}</b>, fordi den er standard backend-temaet!';
$MESSAGE['GENERIC_CANNOT_UNZIP']             = 'Kan ikke pakke ut filen';
$MESSAGE['GENERIC_CANNOT_UPLOAD']            = 'Kan ikke laste opp fil';
$MESSAGE['GENERIC_COMPARE']                  = ' vellykket';
$MESSAGE['GENERIC_ERROR_OPENING_FILE']       = 'Feil ved åpning av fil.';
$MESSAGE['GENERIC_FAILED_COMPARE']           = ' mislyktes';
$MESSAGE['GENERIC_FILE_TYPE']                = 'Vennligst merk at filen du laster opp må være i følgende format:';
$MESSAGE['GENERIC_FILE_TYPES']               = 'Vennligst merk at filen du laster opp må være i ett av følgende formater:';
$MESSAGE['GENERIC_FILL_IN_ALL']              = 'Gå tilbake og fyll ut alle feltene';
$MESSAGE['GENERIC_FORGOT_OPTIONS']           = 'Du har ikke gjort et valg!';
$MESSAGE['GENERIC_INSTALLED']                = 'Installert vellykket';
$MESSAGE['GENERIC_INVALID']                  = 'Filen du lastet opp er ugyldig';
$MESSAGE['GENERIC_INVALID_ADDON_FILE']       = 'Ugyldig WebsiteBaker installasjonsfil. Vennligst sjekk *.zip-formatet.';
$MESSAGE['GENERIC_INVALID_LANGUAGE_FILE']    = 'Ugyldig WebsiteBaker språkfil. Vennligst sjekk tekstfilen.';
$MESSAGE['GENERIC_INVALID_MODULE_FILE']      = 'Ugyldig WebsiteBaker modulfild. Vennligst sjekk tekstfilen.';
$MESSAGE['GENERIC_INVALID_TEMPLATE_FILE']    = 'Ugyldig WebsiteBaker malfil. Vennligst sjekk tekstfilen.';
$MESSAGE['GENERIC_IN_USE']                   = ' men brukt i ';
$MESSAGE['GENERIC_MISSING_ARCHIVE_FILE']     = 'Mangler arkivfil!';
$MESSAGE['GENERIC_MODULE_VERSION_ERROR']     = 'Modulen %s er ikke riktig installert!';
$MESSAGE['GENERIC_NOT_COMPARE']              = ' ikke mulig';
$MESSAGE['GENERIC_NOT_INSTALLED']            = 'Ikke installert';
$MESSAGE['GENERIC_NOT_UPGRADED']             = 'Oppdatering ikke mulig';
$MESSAGE['GENERIC_PLEASE_BE_PATIENT']        = 'Vennligst vær tålmodig, dette kan ta litt tid.';
$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON']   = 'Vennligst sjekk tilbake snart...';
$MESSAGE['GENERIC_SECURITY_ACCESS']          = 'Sikkerhetsbrudd!! Tilgang nektet!';
$MESSAGE['GENERIC_SECURITY_OFFENSE']         = 'Sikkerhetsbrudd!! Datalagring ble nektet!';
$MESSAGE['GENERIC_UNINSTALLED']              = 'Avinstallert vellykket';
$MESSAGE['GENERIC_UPGRADED']                 = 'Oppgradert vellykket';
$MESSAGE['GENERIC_VERSION_COMPARE']          = 'Versjonssammenligning';
$MESSAGE['GENERIC_VERSION_GT']               = 'Oppgradering nødvendig!';
$MESSAGE['GENERIC_VERSION_LT']               = 'Nedgradering';
$MESSAGE['GENERIC_WEBSITE_LOCKED']           = 'dette nettstedet er midlertidig nede for vedlikehold';
$MESSAGE['GENERIC_WEBSITE_UNDER_CONSTRUCTION'] = 'Nettsted under konstruksjon';
$MESSAGE['GENERIC_WEBSITE_NO_PAGES']         = 'Dette nettstedet for dette språket (%s) er fortsatt under konstruksjon';
$MESSAGE['GROUPS_ADDED']                     = 'Gruppe lagt til vellykket';
$MESSAGE['GROUPS_CONFIRM_DELETE']            = 'Er du sikker på at du vil slette den valgte gruppen (og eventuelle brukere som tilhører den)?';
$MESSAGE['GROUPS_DELETED']                   = 'Gruppe slettet vellykket';
$MESSAGE['GROUPS_GROUP_NAME_BLANK']          = 'Gruppenavn er tomt';
$MESSAGE['GROUPS_GROUP_NAME_EXISTS']         = 'Gruppenavn finnes allerede';
$MESSAGE['GROUPS_NO_GROUPS_FOUND']           = 'Ingen grupper funnet';
$MESSAGE['GROUPS_SAVED']                     = 'Gruppe lagret vellykket';
$MESSAGE['LOGIN_AUTHENTICATION_FAILED']      = 'Feil brukernavn eller passord';
$MESSAGE['LOGIN_BOTH_BLANK']                 = 'Vennligst skriv inn ditt brukernavn og passord';
$MESSAGE['LOGIN_PASSWORD_BLANK']             = 'Vennligst skriv inn et passord';
$MESSAGE['LOGIN_PASSWORD_TOO_LONG']          = 'Oppgitt passord er for langt';
$MESSAGE['LOGIN_PASSWORD_TOO_SHORT']         = 'Oppgitt passord er for kort';
$MESSAGE['LOGIN_USERNAME_BLANK']             = 'Vennligst skriv inn et brukernavn';
$MESSAGE['LOGIN_USERNAME_TOO_LONG']          = 'Oppgitt brukernavn er for langt';
$MESSAGE['LOGIN_USERNAME_TOO_SHORT']         = 'Oppgitt brukernavn er for kort';
$MESSAGE['MEDIA_BLANK_EXTENSION']            = 'Du har ikke angitt en filtype';
$MESSAGE['MEDIA_BLANK_NAME']                 = 'Du har ikke angitt et nytt navn';
$MESSAGE['MEDIA_CANNOT_DELETE_DIR']          = 'Kan ikke slette den valgte mappen';
$MESSAGE['MEDIA_CANNOT_DELETE_FILE']         = 'Kan ikke slette den valgte filen';
$MESSAGE['MEDIA_CANNOT_RENAME']              = 'Navneendring mislyktes';
$MESSAGE['MEDIA_CONFIRM_DELETE']             = 'Er du sikker på at du vil slette følgende fil eller mappe?';
$MESSAGE['MEDIA_DELETED_DIR']                = 'Mappe slettet vellykket';
$MESSAGE['MEDIA_DELETED_FILE']               = 'Fil slettet vellykket';
$MESSAGE['MEDIA_DIR_ACCESS_DENIED']          = 'Den angitte katalogen eksisterer ikke eller er ikke tillatt.';
$MESSAGE['MEDIA_DIR_DOES_NOT_EXIST']         = 'Katalogen eksisterer ikke';
$MESSAGE['MEDIA_DIR_DOT_DOT_SLASH']          = 'Kan ikke inkludere ../ i mappenavnet';
$MESSAGE['MEDIA_DIR_EXISTS']                 = 'En mappe med navnet du skrev inn finnes allerede';
$MESSAGE['MEDIA_DIR_MADE']                   = 'Mappe opprettet vellykket';
$MESSAGE['MEDIA_DIR_NOT_MADE']               = 'Kan ikke opprette mappe';
$MESSAGE['MEDIA_FILE_EXISTS']                = 'En fil med navnet du skrev inn finnes allerede';
$MESSAGE['MEDIA_FILE_NOT_FOUND']             = 'Fil ikke funnet';
$MESSAGE['MEDIA_NAME_DOT_DOT_SLASH']         = 'Kan ikke inkludere ../ i navnet';
$MESSAGE['MEDIA_NAME_INDEX_PHP']             = 'Kan ikke bruke index.php som navn';
$MESSAGE['MEDIA_NONE_FOUND']                 = 'Ingen medier funnet i den nåværende mappen';
$MESSAGE['MEDIA_NO_FILE_UPLOADED']           = 'Ingen fil ble lastet opp';
$MESSAGE['MEDIA_RENAMED']                    = 'Navneendring vellykket';
$MESSAGE['MEDIA_SINGLE_UPLOADED']            = ' fil ble lastet opp vellykket';
$MESSAGE['MEDIA_TARGET_DOT_DOT_SLASH']       = 'Kan ikke ha ../ i målmappen';
$MESSAGE['MEDIA_UPLOADED']                   = ' filer ble lastet opp vellykket';
$MESSAGE['MOD_FORM_EXCESS_SUBMISSIONS']      = 'Beklager, dette skjemaet har blitt sendt inn for mange ganger denne timen. Vennligst prøv igjen i neste time.';
$MESSAGE['MOD_FORM_INCORRECT_CAPTCHA']       = 'Verifikasjonsnummeret (også kjent som Captcha) du skrev inn er feil. Hvis du har problemer med å lese Captcha, vennligst send en e-post til: <a href="mailto:{{SERVER_EMAIL}}">{{SERVER_EMAIL}}</a>';
$MESSAGE['MOD_FORM_REQUIRED_FIELDS']         = 'Du må fylle ut detaljer for følgende felt';
$MESSAGE['PAGES_ADDED']                      = 'Side lagt til vellykket';
$MESSAGE['PAGES_ADDED_HEADING']              = 'Sideoverskrift lagt til vellykket';
$MESSAGE['PAGES_BLANK_MENU_TITLE']           = 'Vennligst skriv inn en menytittel';
$MESSAGE['PAGES_BLANK_PAGE_TITLE']           = 'Vennligst skriv inn en sidetittel';
$MESSAGE['PAGES_CANNOT_CREATE_ACCESS_FILE']  = 'Feil ved oppretting av tilgangsfil i /pages-katalogen (utilstrekkelige rettigheter)';
$MESSAGE['PAGES_CANNOT_DELETE_ACCESS_FILE']  = 'Feil ved sletting av tilgangsfil i /pages-katalogen (utilstrekkelige rettigheter)';
$MESSAGE['PAGES_CANNOT_REORDER']             = 'Feil ved omorganisering av side';
$MESSAGE['PAGES_DELETED']                    = 'Side slettet vellykket';
$MESSAGE['PAGES_DELETE_CONFIRM']             = 'Er du sikker på at du vil slette den valgte siden (og alle dens undersider)?';
$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']   = 'Du har ikke tillatelse til å endre denne siden';
$MESSAGE['PAGES_INTRO_LINK']                 = 'Klikk HER for å endre introtekst';
$MESSAGE['PAGES_INTRO_NOT_WRITABLE']         = 'Kan ikke skrive til fil /pages/intro.php (utilstrekkelige rettigheter)';
$MESSAGE['PAGES_INTRO_SAVED']                = 'Introtekst lagret vellykket';
$MESSAGE['PAGES_LAST_MODIFIED']              = 'Sist endret av';
$MESSAGE['PAGES_NOT_FOUND']                  = 'Side ikke funnet';
$MESSAGE['PAGES_NOT_SAVED']                  = 'Feil ved lagring av side';
$MESSAGE['PAGES_PAGE_EXISTS']                = 'En side med samme eller lignende tittel finnes';
$MESSAGE['PAGES_REORDERED']                  = 'Side omorganisert vellykket';
$MESSAGE['PAGES_RESTORED']                   = 'Side gjenopprettet vellykket';
$MESSAGE['PAGES_RETURN_TO_PAGES']            = 'Tilbake til sider';
$MESSAGE['PAGES_SAVED']                      = 'Side lagret vellykket';
$MESSAGE['PAGES_SAVED_SETTINGS']             = 'Sideinnstillinger lagret vellykket';
$MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED']  = 'Seksjonsegenskaper lagret vellykket';
$MESSAGE['PAGE_MODIFIED']                    = 'Siden ble endret %s av %s';
$MESSAGE['PREFERENCES_CURRENT_PASSWORD_INCORRECT'] = 'Det (nåværende) passordet du skrev inn er feil';
$MESSAGE['PREFERENCES_DETAILS_SAVED']        = 'Detaljer lagret vellykket';
$MESSAGE['PREFERENCES_EMAIL_UPDATED']        = 'E-post oppdatert vellykket';
$MESSAGE['PREFERENCES_INVALID_CHARS']        = 'Ugyldige passordkarakterer brukt';
$MESSAGE['PREFERENCES_PASSWORD_CHANGED']     = 'Passord endret vellykket';
$MESSAGE['RECORD_MODIFIED_FAILED']           = 'Postendring mislyktes.';
$MESSAGE['RECORD_MODIFIED_SAVED']            = 'Den endrede posten ble oppdatert vellykket.';
$MESSAGE['RECORD_NEW_FAILED']                = 'Legge til en ny post mislyktes.';
$MESSAGE['RECORD_NEW_SAVED']                 = 'Ny post ble lagt til vellykket.';
$MESSAGE['REORG_SUCCESS']                    = 'Reorganisering ble utført vellykket';
$MESSAGE['SETTINGS_MODE_SWITCH_WARNING']     = 'Vennligst merk: Ved å trykke på denne knappen nullstilles alle ulagrede endringer';
$MESSAGE['SETTINGS_SAVED']                   = 'Innstillinger ble lagret vellykket!';
$MESSAGE['SETTINGS_UNABLE_OPEN_CONFIG']      = 'Kan ikke åpne konfigurasjonsfilen';
$MESSAGE['SETTINGS_UNABLE_WRITE_CONFIG']     = 'Kan ikke skrive til konfigurasjonsfilen';
$MESSAGE['SETTINGS_WORLD_WRITEABLE_WARNING'] = 'Vennligst merk: dette anbefales kun for testmiljøer';
$MESSAGE['SIGNUP2_ADMIN_INFO']               = "\r\nEn ny bruker ble registrert.\r\n\r\nBrukernavn: {LOGIN_NAME}\r\n{DISPLAY_NAME}: {LOGIN_ID}\r\nE-post: {LOGIN_EMAIL}\r\nRegistreringsdato: {SIGNUP_DATE}\r\n----------------------------------------\r\nDenne meldingen ble automatisk generert!\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_FORGOT']       = "\r\nHei {LOGIN_DISPLAY_NAME},\r\n\r\nDenne e-posten ble sendt fordi funksjonen 'glemt passord' er blitt brukt på kontoen din.\r\n\r\nDine nye '{LOGIN_WEBSITE_TITLE}' innloggingsdetaljer er:\r\n\r\nBrukernavn: xxxxx\r\nPassord: {LOGIN_PASSWORD}\r\n\r\nPassordet ditt er blitt tilbakestilt til det ovenfor.\r\nDette betyr at ditt gamle passord ikke lenger vil fungere!\r\nHvis du har spørsmål eller problemer angående dine nye innloggingsdata\r\nbør du kontakte nettstedsteamet eller administratoren av '{LOGIN_WEBSITE_TITLE}'.\r\nHusk å tømme nettleserens cache før du bruker den nye for å unngå uventede feil.\r\n\r\nMed vennlig hilsen\r\n------------------------------------\r\nDenne meldingen ble automatisk generert\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_INFO']          = "\r\nHei {LOGIN_DISPLAY_NAME},\r\n\r\nVelkommen til '{LOGIN_WEBSITE_TITLE}'.\r\n\r\nDine '{LOGIN_WEBSITE_TITLE}' innloggingsdetaljer er:\r\nBrukernavn: xxxxx\r\nPassord: {LOGIN_PASSWORD}\r\n\r\nMed vennlig hilsen\r\n\r\nVennligst:\r\nhvis du har mottatt denne meldingen ved en feil, vennligst slett den umiddelbart!\r\n-------------------------------------\r\nDenne meldingen ble automatisk generert!\r\n";
$MESSAGE['SIGNUP2_NEW_USER']                 = 'En ny bruker er blitt registrert';
$MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO']       = 'Dine innloggingsdetaljer...';
$MESSAGE['SIGNUP2_SUBJECT_NEW_USER']         = 'Takk for din registrering';
$MESSAGE['SIGNUP_NO_EMAIL']                  = 'Du må oppgi en e-postadresse';
$MESSAGE['START_CURRENT_USER']               = 'Du er for øyeblikket logget inn som:';
$MESSAGE['START_INSTALL_DIR_EXISTS']         = 'Advarsel, installasjonskatalog eksisterer fortsatt!';
$MESSAGE['START_UPGRADE_SCRIPT_EXISTS']      = 'Vennligst slett filen {{file}} fra din webplass.';
$MESSAGE['START_WELCOME_MESSAGE']            = 'Velkommen til WebsiteBaker Administrasjon';
$MESSAGE['TEMPLATES_CHANGE_TEMPLATE_NOTICE'] = 'Vennligst merk: for å endre malen må du gå til Innstillinger-seksjonen';
$MESSAGE['THEME_ALREADY_EXISTS']             = 'Denne nye temabeskrivelsen finnes allerede.';
$MESSAGE['THEME_COPY_CURRENT']               = 'Kopier det nåværende aktive temaet og lagre det med et nytt navn.';
$MESSAGE['THEME_DESTINATION_READONLY']       = 'Ingen rettigheter til å opprette ny temamappe!';
$MESSAGE['THEME_IMPORT_HTT']                 = 'Importer tilleggsmaler til det nåværende aktive temaet.<br />Bruk disse malene til å overskrive den tilsvarende standardmalen.';
$MESSAGE['THEME_INVALID_SOURCE_DESTINATION'] = 'Ugyldig deskriptor for det nye temaet gitt!';
$MESSAGE['UNKNOW_UPLOAD_ERROR']              = 'Ukjent opplastingsfeil';
$MESSAGE['UPLOAD_ERR_CANT_WRITE']            = 'Kunne ikke skrive fil til disk';
$MESSAGE['UPLOAD_ERR_EXTENSION']             = 'Filopplasting stoppet av utvidelse';
$MESSAGE['UPLOAD_ERR_FORM_SIZE']             = 'Den opplastede filen overskrider MAX_FILE_SIZE-direktivet som ble spesifisert i HTML-skjemaet';
$MESSAGE['UPLOAD_ERR_INI_SIZE']              = 'Den opplastede filen overskrider upload_max_filesize-direktivet i php.ini';
$MESSAGE['UPLOAD_ERR_NO_FILE']               = 'Ingen fil ble lastet opp';
$MESSAGE['UPLOAD_ERR_NO_TMP_DIR']            = 'Mangler en midlertidig mappe';
$MESSAGE['UPLOAD_ERR_OK']                    = 'Filer ble lastet opp vellykket';
$MESSAGE['UPLOAD_ERR_PARTIAL']               = 'Den opplastede filen ble bare delvis lastet opp';
$MESSAGE['USERS_ADDED']                      = 'Bruker lagt til vellykket';
$MESSAGE['USERS_CANT_SELFDELETE']            = 'Funksjon avvist, du kan ikke slette deg selv!';
$MESSAGE['USERS_CHANGING_PASSWORD']          = 'Vennligst merk: Du skal bare oppgi verdier i feltene ovenfor hvis du ønsker å endre passordet for denne brukeren';
$MESSAGE['USERS_CONFIRM_DELETE']             = 'Er du sikker på at du vil slette den valgte brukeren?';
$MESSAGE['USERS_DELETED']                    = 'Bruker slettet vellykket';
$MESSAGE['USERS_DISPLAYNAME_TAKEN']          = 'Det angitte visningsnavnet er allerede i bruk.';
$MESSAGE['USERS_EMAIL_TAKEN']                = 'E-posten du skrev inn er allerede i bruk';
$MESSAGE['USERS_INVALID_EMAIL']              = 'E-postadressen du skrev inn er ugyldig';
$MESSAGE['USERS_NAME_INVALID_CHARS']         = 'Ugyldige tegn for brukernavn funnet';
$MESSAGE['USERS_NO_GROUP']                   = 'Ingen gruppe ble valgt';
$MESSAGE['USERS_PASSWORD_MISMATCH']          = 'Passordene du skrev inn stemmer ikke overens';
$MESSAGE['USERS_PASSWORD_TOO_SHORT']         = 'Passordet du skrev inn var for kort';
$MESSAGE['USERS_SAVED']                      = 'Bruker lagret vellykket';
$MESSAGE['USERS_USERNAME_TAKEN']             = 'Brukernavnet du skrev inn er allerede tatt';
$MESSAGE['USERS_USERNAME_TOO_SHORT']         = 'Brukernavnet du skrev inn var for kort';
$OVERVIEW['ADMINTOOLS']                     = 'Få tilgang til WebsiteBaker sine administrasjonsverktøy...';
$OVERVIEW['GROUPS']                         = 'Administrer brukergrupper og deres systemtillatelser...';
$OVERVIEW['HELP']                           = 'Har du spørsmål? Finn svaret ditt...';
$OVERVIEW['LANGUAGES']                      = 'Administrer WebsiteBaker sine språk...';
$OVERVIEW['MEDIA']                          = 'Administrer filer lagret i mediemappen...';
$OVERVIEW['MODULES']                        = 'Administrer WebsiteBaker sine moduler...';
$OVERVIEW['PAGES']                          = 'Administrer dine nettsteders sider...';
$OVERVIEW['PREFERENCES']                    = 'Endre preferanser som e-postadresse, passord, etc... ';
$OVERVIEW['SETTINGS']                       = 'Endrer innstillinger for WebsiteBaker...';
$OVERVIEW['START']                          = 'Administrasjonsoversikt';
$OVERVIEW['TEMPLATES']                      = 'Endre utseendet på nettstedet ditt med maler...';
$OVERVIEW['USERS']                          = 'Administrer brukere som kan logge inn på WebsiteBaker...';
$OVERVIEW['VIEW']                           = 'Vis og bla raskt gjennom nettstedet ditt i et nytt vindu...';
$TEXT['ACCOUNT_SIGNUP']                     = 'Kontoregistrering';
$TEXT['ACTIONS']                            = 'Handlinger';
$TEXT['ACTIVE']                             = 'Aktiv';
$TEXT['ADD']                                = 'Legg til';
$TEXT['ADDON']                              = 'Tillegg';
$TEXT['ADD_SECTION']                        = 'Legg til seksjon';
$TEXT['ADMIN']                              = 'Admin';
$TEXT['ADMINISTRATION']                     = 'Administrasjon';
$TEXT['ADMINISTRATION_TOOL']                = 'Administrasjonsverktøy';
$TEXT['ADMINISTRATOR']                      = 'Administrator';
$TEXT['ADMINISTRATORS']                     = 'Administratorer';
$TEXT['ADVANCED']                           = 'Avansert';
$TEXT['ALLOWED_FILETYPES_ON_UPLOAD']        = 'Tillatte filtyper ved opplasting';
$TEXT['ALLOWED_VIEWERS']                    = 'Tillatte seere';
$TEXT['ALLOW_MULTIPLE_SELECTIONS']          = 'Tillat flere valg';
$TEXT['ALL_WORDS']                          = 'Alle ord';
$TEXT['ANCHOR']                             = 'Anker';
$TEXT['ANONYMOUS']                          = 'Anonym';
$TEXT['ANY_WORDS']                          = 'Alle ord';
$TEXT['APP_NAME']                           = 'Applikasjonsnavn';
$TEXT['ARE_YOU_SURE']                       = 'Er du sikker?';
$TEXT['AUTHOR']                             = 'Forfatter';
$TEXT['BACK']                               = 'Tilbake';
$TEXT['BACKUP']                             = 'Sikkerhetskopi';
$TEXT['BACKUP_ALL_TABLES']                  = 'Sikkerhetskopier alle tabeller i databasen';
$TEXT['BACKUP_DATABASE']                    = 'Sikkerhetskopier database';
$TEXT['BACKUP_MEDIA']                       = 'Sikkerhetskopier medier';
$TEXT['BACKUP_WB_SPECIFIC']                 = 'Sikkerhetskopier kun WB-spesifikke tabeller';
$TEXT['BASIC']                              = 'Grunnleggende';
$TEXT['BLOCK']                              = 'Blokk';
$TEXT['BROWSE_UPLOAD_FILE']                 = 'Velg en fil!';
$TEXT['CALENDAR']                           = 'Kalender';
$TEXT['CANCEL']                             = 'Avbryt';
$TEXT['CAN_DELETE_HIMSELF']                 = 'Kan slette seg selv';
$TEXT['CAPTCHA_VERIFICATION']               = 'Captcha-verifisering';
$TEXT['CAP_EDIT_CSS']                       = 'Rediger CSS';
$TEXT['CHANGE']                             = 'Endre';
$TEXT['CHANGES']                            = 'Endringer';
$TEXT['CHANGE_SETTINGS']                    = 'Endre innstillinger';
$TEXT['CHARSET']                            = 'Tegnssett';
$TEXT['CHECKBOX_GROUP']                     = 'Avkrysningsboks-gruppe';
$TEXT['CLOSE']                              = 'Lukk';
$TEXT['CODE']                               = 'Kode';
$TEXT['CODE_SNIPPET']                       = 'Kode-snippet';
$TEXT['COLLAPSE']                           = 'Skjul';
$TEXT['COMMENT']                            = 'Kommentar';
$TEXT['COMMENTING']                         = 'Kommentering';
$TEXT['COMMENTS']                           = 'Kommentarer';
$TEXT['CONFIRM']                            = 'Bekreft';
$TEXT['CREATE_FOLDER']                      = 'Opprett mappe';
$TEXT['CURRENT']                            = 'Nåværende';
$TEXT['CURRENT_FOLDER']                     = 'Nåværende mappe';
$TEXT['CURRENT_PAGE']                       = 'Nåværende side';
$TEXT['CURRENT_PASSWORD']                   = 'Nåværende passord';
$TEXT['CUSTOM']                             = 'Tilpasset';
$TEXT['DATABASE']                           = 'Database';
$TEXT['DATE']                               = 'Dato';
$TEXT['DATE_FORMAT']                        = 'Datoformat';
$TEXT['DEFAULT']                            = 'Standard';
$TEXT['DEFAULT_CHARSET']                    = 'Standard tegnssett';
$TEXT['DEFAULT_TEXT']                       = 'Standard tekst';
$TEXT['DELETE']                             = 'Slett';
$TEXT['DELETED']                            = 'Slettet';
$TEXT['DELETE_DATE']                        = 'Slett dato';
$TEXT['DELETE_ZIP']                         = 'Slett zip-arkiv etter utpakking';
$TEXT['DESCRIPTION']                        = 'Beskrivelse';
$TEXT['DESIGNED_FOR']                       = 'Designet for';
$TEXT['DEV_INFOS']                          = 'Utviklerinformasjon';
$TEXT['DIRECTORIES']                        = 'Kataloger';
$TEXT['DIRECTORY_MODE']                     = 'Katalogmodus';
$TEXT['DISABLED']                           = 'Deaktivert';
$TEXT['DISPLAY_NAME']                       = 'Visningsnavn';
$TEXT['EMAIL']                              = 'E-post';
$TEXT['EMAIL_ADDRESS']                      = 'E-postadresse';
$TEXT['EMPTY_TRASH']                        = 'Tøm søppelbøtte';
$TEXT['ENABLED']                            = 'Aktivert';
$TEXT['END']                                = 'Slutt';
$TEXT['ERROR']                              = 'Feil';
$TEXT['EXACT_MATCH']                        = 'Nøyaktig match';
$TEXT['EXECUTE']                            = 'Utfør';
$TEXT['EXPAND']                             = 'Utvid';
$TEXT['EXTENSION']                          = 'Utvidelse';
$TEXT['FIELD']                              = 'Felt';
$TEXT['FILE']                               = 'Fil';
$TEXT['FILES']                              = 'Filer';
$TEXT['FILESYSTEM_PERMISSIONS']             = 'Filysystemtillatelser';
$TEXT['FILE_MODE']                          = 'Filmodus';
$TEXT['FINISH_PUBLISHING']                  = 'Fullfør publisering';
$TEXT['FOLDER']                             = 'Mappe';
$TEXT['FOLDERS']                            = 'Mapper';
$TEXT['FOOTER']                             = 'Sidefot';
$TEXT['FORGOTTEN_DETAILS']                  = 'Glemt detaljer?';
$TEXT['FORGOT_DETAILS']                     = 'Glemt detaljer?';
$TEXT['FROM']                               = 'Fra';
$TEXT['FRONTEND']                           = 'Frontend';
$TEXT['FULL_NAME']                          = 'Fullt navn';
$TEXT['FUNCTION']                           = 'Funksjon';
$TEXT['GROUP']                              = 'Gruppe';
$TEXT['GUEST']                              = 'Gjest';
$TEXT['HEADER']                             = 'Sidehode';
$TEXT['HEADING']                            = 'Overskrift';
$TEXT['HEADING_CSS_FILE']                   = 'Faktisk modulfild: ';
$TEXT['HEIGHT']                             = 'Høyde';
$TEXT['HIDDEN']                             = 'Skjult';
$TEXT['HIDE']                               = 'Skjul';
$TEXT['HIDE_ADVANCED']                      = 'Skjul avanserte alternativer';
$TEXT['HOME']                               = 'Hjem';
$TEXT['HOMEPAGE_REDIRECTION']               = 'Hjemmesideomdirigering';
$TEXT['HOME_FOLDER']                        = 'Personlig mappe';
$TEXT['HOME_FOLDERS']                       = 'Personlige mapper';
$TEXT['HOST']                               = 'Vert';
$TEXT['ICON']                               = 'Ikon';
$TEXT['IMAGE']                              = 'Bilde';
$TEXT['INLINE']                             = 'Inline';
$TEXT['INSTALL']                            = 'Installer';
$TEXT['INSTALLATION']                       = 'Installasjon';
$TEXT['INSTALLATION_PATH']                  = 'Installasjonssti';
$TEXT['INSTALLATION_URL']                   = 'Installasjons-URL';
$TEXT['INSTALLED']                          = 'installert';
$TEXT['INTRO']                              = 'Intro';
$TEXT['INTRO_PAGE']                         = 'Introtekst';
$TEXT['INVALID_SIGNS']                      = 'må starte med en bokstav eller har ugyldige tegn';
$TEXT['KEYWORDS']                           = 'Nøkkelord';
$TEXT['LANGUAGE']                           = 'Språk';
$TEXT['LAST_UPDATED_BY']                    = 'Sist oppdatert av';
$TEXT['LENGTH']                             = 'Lengde';
$TEXT['LEVEL']                              = 'Nivå';
$TEXT['LICENSE']                            = 'Lisens';
$TEXT['LINK']                               = 'Lenke';
$TEXT['LINUX_UNIX_BASED']                   = 'Linux/Unix-basert';
$TEXT['LIST_OPTIONS']                       = 'Listealternativer';
$TEXT['LOGGED_IN']                          = 'Logget inn';
$TEXT['LOGIN']                              = 'Logg inn';
$TEXT['LONG']                               = 'Lang';
$TEXT['LONG_TEXT']                          = 'Lang tekst';
$TEXT['LOOP']                               = 'Løkke';
$TEXT['MAIN']                               = 'Hoved';
$TEXT['USER_LOGIN_ON']                      = 'Tillat brukerpålogging';
$TEXT['USER_LOGIN_OFF']                     = 'Forhindre brukerpålogging';
$TEXT['MAINTENANCE_OFF']                    = 'Vedlikehold av';
$TEXT['MAINTENANCE_ON']                     = 'Vedlikehold på';
$TEXT['MANAGE']                             = 'Administrer';
$TEXT['MANAGE_GROUPS']                      = 'Administrer grupper';
$TEXT['MANAGE_USERS']                       = 'Administrer brukere';
$TEXT['MATCH']                              = 'Match';
$TEXT['MATCHING']                           = 'Matchende';
$TEXT['MAX_EXCERPT']                        = 'Maks. linjer i utdrag';
$TEXT['MAX_SUBMISSIONS_PER_HOUR']           = 'Maks. innleveringer per time';
$TEXT['MEDIA_DIRECTORY']                    = 'Mediekatalog';
$TEXT['MENU']                               = 'Meny';
$TEXT['MENU_ICON_0']                        = 'Meny-ikon normal';
$TEXT['MENU_ICON_1']                        = 'Meny-ikon ved hover';
$TEXT['MENU_TITLE']                         = 'Menytittel';
$TEXT['MESSAGE']                            = 'Melding';
$TEXT['MODIFY']                             = 'Endre';
$TEXT['MODIFY_CONTENT']                     = 'Endre innhold';
$TEXT['MODIFY_SETTINGS']                    = 'Endre innstillinger';
$TEXT['MODULE_ORDER']                       = 'Modul-rekkefølge for søk';
$TEXT['MODULE_PERMISSIONS']                 = 'Modultillatelser';
$TEXT['MORE']                               = 'Mer';
$TEXT['MOVE_DOWN']                          = 'Flytt ned';
$TEXT['MOVE_UP']                            = 'Flytt opp';
$TEXT['MULTILINGUAL']                       = 'FLERSPRAKLIG';
$TEXT['MULTIPLE_MENUS']                     = 'Flere menyer';
$TEXT['MULTISELECT']                        = 'Flervalg';
$TEXT['NAME']                               = 'Navn';
$TEXT['NEED_CURRENT_PASSWORD']              = 'bekreft med nåværende passord';
$TEXT['NEED_TO_LOGIN']                      = 'Må logge inn?';
$TEXT['NEW_PASSWORD']                       = 'Nytt passord';
$TEXT['NEW_WINDOW']                         = 'Nytt vindu';
$TEXT['NEXT']                               = 'Neste';
$TEXT['NEXT_PAGE']                          = 'Neste side';
$TEXT['NO']                                 = 'Nei';
$TEXT['NONE']                               = 'Ingen';
$TEXT['NONE_FOUND']                         = 'Ingen funnet';
$TEXT['NOT_FOUND']                          = 'Ikke funnet';
$TEXT['NOT_INSTALLED']                      = 'ikke installert';
$TEXT['NO_IMAGE_SELECTED']                  = 'intet bilde valgt';
$TEXT['NO_RESULTS']                         = 'Ingen resultater';
$TEXT['NO_SELECTION']                       = 'intet valg';
$TEXT['OF']                                 = 'av';
$TEXT['ON']                                 = 'på';
$TEXT['OPEN']                               = 'Åpne';
$TEXT['OPTION']                             = 'Alternativ';
$TEXT['OTHERS']                             = 'Andre';
$TEXT['OUT_OF']                             = 'Ut av';
$TEXT['OVERWRITE_EXISTING']                 = 'Overskriv eksisterende';
$TEXT['PAGE']                               = 'Side';
$TEXT['PAGES_DIRECTORY']                    = 'Sider Katalog';
$TEXT['PAGES_PERMISSION']                   = 'Sider Tillatelse';
$TEXT['PAGES_PERMISSIONS']                  = 'Sider Tillatelser';
$TEXT['PAGE_EXTENSION']                     = 'Sideutvidelse';
$TEXT['PAGE_ICON']                          = 'Sideikon';
$TEXT['PAGE_ICON_DIR']                      = 'Sti sider/menybilder';
$TEXT['PAGE_LANGUAGES']                     = 'Sidespråk';
$TEXT['PAGE_LEVEL_LIMIT']                   = 'Sidenivågrense';
$TEXT['PAGE_SPACER']                        = 'Sidemellomrom';
$TEXT['PAGE_TITLE']                         = 'Sidetittel';
$TEXT['PAGE_TRASH']                         = 'Side søppelbøtte';
$TEXT['PARENT']                             = 'Forelder';
$TEXT['PASSWORD']                           = 'Passord';
$TEXT['PATH']                               = 'Sti';
$TEXT['PHP_ERROR_LEVEL']                    = 'PHP feilrapporteringsnivå';
$TEXT['PLEASE_LOGIN']                       = 'Vennligst logg inn';
$TEXT['PLEASE_SELECT']                      = 'Vennligst velg';
$TEXT['POST']                               = 'Innlegg';
$TEXT['POSTS_PER_PAGE']                     = 'Innlegg per side';
$TEXT['POST_FOOTER']                        = 'Innleggsfot';
$TEXT['POST_HEADER']                        = 'Innleggshode';
$TEXT['PREVIOUS']                           = 'Forrige';
$TEXT['PREVIOUS_PAGE']                      = 'Forrige side';
$TEXT['PRIVATE']                            = 'Privat';
$TEXT['PRIVATE_VIEWERS']                    = 'Private seere';
$TEXT['PROFILES_EDIT']                      = 'Endre profilen';
$TEXT['PUBLIC']                             = 'Offentlig';
$TEXT['PUBL_END_DATE']                      = 'Sluttdato';
$TEXT['PUBL_START_DATE']                    = 'Startdato';
$TEXT['RADIO_BUTTON_GROUP']                 = 'Radioknappgruppe';
$TEXT['READ']                               = 'Les';
$TEXT['READ_MORE']                          = 'Les mer';
$TEXT['REDIRECT_AFTER']                     = 'Omdiriger etter';
$TEXT['REGISTERED']                         = 'Registrert';
$TEXT['REGISTERED_VIEWERS']                 = 'Registrerte seere';
$TEXT['RELOAD']                             = 'Last inn på nytt';
$TEXT['REMEMBER_ME']                        = 'Husk meg';
$TEXT['RENAME']                             = 'Endre navn';
$TEXT['RENAME_FILES_ON_UPLOAD']             = 'Ingen opplasting for disse filtypene';
$TEXT['REQUIRED']                           = 'Påkrevd';
$TEXT['REQUIREMENT']                        = 'Krav';
$TEXT['RESET']                              = 'Tilbakestill';
$TEXT['RESIZE']                             = 'Endre størrelse';
$TEXT['RESIZE_IMAGE_TO']                    = 'Endre bildestørrelse til';
$TEXT['REFILL']                             = 'Tilbakestill inndata';
$TEXT['RESTORE']                            = 'Tilbakestill inndata';
$TEXT['RESTORE_DATABASE']                   = 'Gjenopprett database';
$TEXT['RESTORE_MEDIA']                      = 'Gjenopprett medier';
$TEXT['RESULTS']                            = 'Resultater';
$TEXT['RESULTS_FOOTER']                     = 'Resultatfot';
$TEXT['RESULTS_FOR']                        = 'Resultater for';
$TEXT['RESULTS_HEADER']                     = 'Resultathode';
$TEXT['RESULTS_LOOP']                       = 'Resultatløkke';
$TEXT['RETYPE_NEW_PASSWORD']                = 'Gjenta nytt passord';
$TEXT['RETYPE_PASSWORD']                    = 'Gjenta passord';
$TEXT['SAME_WINDOW']                        = 'Samme vindu';
$TEXT['SAVE']                               = 'Lagre';
$TEXT['SEARCH']                             = 'Søk';
$TEXT['SEARCHING']                          = 'Søker';
$TEXT['SECTION']                            = 'Seksjon';
$TEXT['SECTION_BLOCKS']                     = 'Seksjonsblokker';
$TEXT['SEC_ANCHOR']                         = 'Seksjons-ankertekst';
$TEXT['SELECT_BOX']                         = 'Velg boks';
$TEXT['SEND_DETAILS']                       = 'Send detaljer';
$TEXT['SEPARATE']                           = 'Separer';
$TEXT['SEPERATOR']                          = 'Separator';
$TEXT['SERVER_EMAIL']                       = 'Server-e-post';
$TEXT['SERVER_OPERATING_SYSTEM']            = 'Serveroperativsystem';
$TEXT['SESSION_IDENTIFIER']                 = 'Sesjonsidentifikator';
$TEXT['SETTINGS']                           = 'Innstillinger';
$TEXT['SHORT']                              = 'Kort';
$TEXT['SHORT_TEXT']                         = 'Kort tekst';
$TEXT['SHOW']                               = 'Vis';
$TEXT['SHOW_ADVANCED']                      = 'Vis avanserte alternativer';
$TEXT['SIGNUP']                             = 'Registrer deg';
$TEXT['SIZE']                               = 'Størrelse';
$TEXT['SMART_LOGIN']                        = 'Smart pålogging';
$TEXT['START']                              = 'Start';
$TEXT['START_PUBLISHING']                   = 'Start publisering';
$TEXT['SUBJECT']                            = 'Emne';
$TEXT['SUBMISSIONS']                        = 'Innleveringer';
$TEXT['SUBMISSIONS_STORED_IN_DATABASE']     = 'Innleveringer lagret i database';
$TEXT['SUBMISSION_ID']                      = 'Innleverings-ID';
$TEXT['SUBMITTED']                          = 'Sendt inn';
$TEXT['SUCCESS']                            = 'Vellykket';
$TEXT['SYSTEM_DEFAULT']                     = 'Systemstandard';
$TEXT['SYSTEM_PERMISSIONS']                 = 'Systemtillatelser';
$TEXT['TABLE_PREFIX']                       = 'Tabelprefikset';
$TEXT['TARGET']                             = 'Mål';
$TEXT['TARGET_FOLDER']                      = 'Målmappe';
$TEXT['TEMPLATE']                           = 'Mal';
$TEXT['TEMPLATE_PERMISSIONS']               = 'Maltillatelser';
$TEXT['TEXT']                               = 'Tekst';
$TEXT['TEXTAREA']                           = 'Tekstområde';
$TEXT['TEXTFIELD']                          = 'Tekstfelt';
$TEXT['THEME']                              = 'Backend-tema';
$TEXT['THEME_COPY_CURRENT']                 = 'Kopier backend-tema.';
$TEXT['THEME_CURRENT']                      = 'nåværende aktivt tema';
$TEXT['THEME_IMPORT_HTT']                   = 'Importer tilleggsmaler';
$TEXT['THEME_NEW_NAME']                     = 'Navn på det nye temaet';
$TEXT['THEME_NOMORE_HTT']                   = 'ikke mer tilgjengelig';
$TEXT['THEME_SELECT_HTT']                   = 'velg maler';
$TEXT['THEME_START_COPY']                   = 'kopier';
$TEXT['THEME_START_IMPORT']                 = 'importer';
$TEXT['TIME']                               = 'Tid';
$TEXT['TIMEZONE']                           = 'Tidssone';
$TEXT['TIME_FORMAT']                        = 'Tidsformat';
$TEXT['TIME_LIMIT']                         = 'Maks. tid til å samle utdrag per modul';
$TEXT['TITLE']                              = 'Tittel';
$TEXT['TO']                                 = 'Til';
$TEXT['TOP_FRAME']                          = 'Toppramme';
$TEXT['TRASH_EMPTIED']                      = 'Søppelbøtte tømt';
$TEXT['TXT_EDIT_CSS_FILE']                  = 'Rediger CSS-definisjonene i tekstområdet nedenfor.';
$TEXT['TYPE']                               = 'Type';
$TEXT['UNDER_CONSTRUCTION']                 = 'Under konstruksjon';
$TEXT['UNINSTALL']                          = 'Avinstaller';
$TEXT['UNKNOWN']                            = 'Ukjent';
$TEXT['UNLIMITED']                          = 'Ubegrenset';
$TEXT['UNZIP_FILE']                         = 'Last opp og pakk ut et zip-arkiv';
$TEXT['UP']                                 = 'Opp';
$TEXT['UPGRADE']                            = 'Oppgrader';
$TEXT['UPLOAD_FILES']                       = 'Last opp fil(er)';
$TEXT['URL']                                = 'URL';
$TEXT['USER']                               = 'Bruker';
$TEXT['USERNAME']                           = 'Brukernavn';
$TEXT['USERS_ACTIVE']                       = 'Bruker er aktiv';
$TEXT['USERS_CAN_SELFDELETE']               = 'Bruker kan slette seg selv';
$TEXT['USERS_CHANGE_SETTINGS']              = 'Bruker kan endre egne innstillinger';
$TEXT['USERS_DELETED']                      = 'Bruker er merket som slettet';
$TEXT['USERS_FLAGS']                        = 'Bruker-flagg';
$TEXT['USERS_PROFILE_ALLOWED']              = 'Bruker kan opprette utvidet profil';
$TEXT['VERIFICATION']                       = 'Verifikasjon';
$TEXT['VERSION']                            = 'Versjon';
$TEXT['VIEW']                               = 'Vis';
$TEXT['VIEW_DELETED_PAGES']                 = 'Vis slettede sider';
$TEXT['VIEW_DETAILS']                       = 'Vis detaljer';
$TEXT['VISIBILITY']                         = 'Synlighet';
$TEXT['WBMAILER_DEFAULT_SENDER_MAIL']       = 'Standard "Fra" adresse';
$TEXT['WBMAILER_DEFAULT_SENDER_NAME']       = 'Standard avsender navn';
$TEXT['WBMAILER_DEFAULT_SETTINGS_NOTICE']   = 'Vennligst spesifiser en standard "FRA" adresse og "AVSENDER" navn nedenfor. Det anbefales å bruke en FRA-adresse som: <strong>admin@dittdomene.com</strong>. Noen e-postleverandører (f.eks. <em>mail.com</em>) kan avvise e-post med en FRA:-adresse som <em>navn@mail.com</em> sendt via et fremmed relé for å unngå spam.<br /><br />Standardverdiene brukes kun hvis ingen andre verdier er spesifisert av WebsiteBaker. Hvis serveren din støtter <abbr title="Simple mail transfer protocol">SMTP</abbr>, ønsker du kanskje å bruke dette alternativet for utgående e-post.';
$TEXT['WBMAILER_FUNCTION']                  = 'E-postrutine';
$TEXT['WBMAILER_NOTICE']                    = '<strong>SMTP Mailer-innstillinger:</strong><br />Innstillingene nedenfor er kun påkrevd hvis du vil sende e-post via <abbr title="Simple mail transfer protocol">SMTP</abbr>. Hvis du ikke kjenner din SMTP-vert eller er usikker på de påkrevde innstillingene, kan du bare holde deg til standard e-postrutinen: PHP MAIL.';
$TEXT['WBMAILER_PHP']                       = 'PHP MAIL';
$TEXT['WBMAILER_SMTP']                      = 'SMTP';
$TEXT['WBMAILER_SMTP_AUTH']                 = 'SMTP-autentisering';
$TEXT['WBMAILER_SMTP_AUTH_NOTICE']          = 'aktiver bare hvis SMTP-verten din krever autentisering';
$TEXT['WBMAILER_SMTP_HOST']                 = 'SMTP Vert';
$TEXT['WBMAILER_SMTP_PASSWORD']             = 'SMTP Passord';
$TEXT['WBMAILER_SMTP_USERNAME']             = 'SMTP Brukernavn';
$TEXT['WEBSITE']                            = 'Nettsted';
$TEXT['WEBSITE_DESCRIPTION']                = 'Metadata Beskrivelse';
$TEXT['WEBSITE_FOOTER']                     = 'Nettstedets bunntekst';
$TEXT['WEBSITE_HEADER']                     = 'Nettstedets topptekst';
$TEXT['WEBSITE_KEYWORDS']                   = 'Metadata nøkkelord';
$TEXT['WEBSITE_TITLE']                      = 'Metadata tittel';
$TEXT['WELCOME_BACK']                       = 'Velkommen tilbake';
$TEXT['WIDTH']                              = 'Bredde';
$TEXT['WINDOW']                             = 'Vindu';
$TEXT['WINDOWS']                            = 'Windows';
$TEXT['WORLD_WRITEABLE_FILE_PERMISSIONS']   = 'Verdensskrivbare filtillatelser';
$TEXT['WRITE']                              = 'Skriv';
$TEXT['WYSIWYG_EDITOR']                     = 'WYSIWYG-editor';
$TEXT['WYSIWYG_STYLE']                      = 'WYSIWYG-stil';
$TEXT['YES']                                = 'Ja';

$TEXT['NO_REVERT'] = 'Dette kan du ikke angre!';
$TEXT['NO_DELETED'] = 'Sletting ble ikke utført!';
$TEXT['PAGE_CODE'] = 'Sidekode';