<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of \languages\HU
 * @package          CoreTranslation
 * @copyright        Manuela v.d.Decken <manuela@isteam.de>
 * @author          $Author: Uwe $
 * @license         GNU General Public License 2.0
 * @version         4.0.3
 * @revision        $Revision: 63 $
 * @since           $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @lastmodified    $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @deprecated      no
 * @description     CoreTranslation
 * @svn-id          $Header: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/languages/HU.php 63 2025-09-01 10:08:14Z Uwe $
 */

//declare(strict_types = 1);

//declare(encoding = 'UTF-8');

if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
// Define that this file is loaded
if (!defined('LANGUAGE_LOADED')) { define('LANGUAGE_LOADED', true); }

// Set the language information
$language_code = 'HU';
$language_name = 'Magyar';
$language_version = '4.0.3';
$language_platform = '2.11.0';
$language_author = 'Jacobi22';// All translations by Google AI
$language_license = 'GNU General Public License 2.0';

$HEADING['ADDON_PRECHECK_FAILED']            = 'A kiegészítőre vonatkozó követelmények nem teljesültek';
$HEADING['ADD_CHILD_PAGE']                   = 'Aloldal hozzáadása';
$HEADING['ADD_GROUP']                        = 'Csoport hozzáadása';
$HEADING['ADD_GROUPS']                       = 'Csoportok hozzáadása';
$HEADING['ADD_HEADING']                      = 'Címsor hozzáadása';
$HEADING['ADD_PAGE']                         = 'Oldal hozzáadása';
$HEADING['ADD_USER']                         = 'Felhasználó hozzáadása';
$HEADING['ADMINISTRATION_TOOLS']             = 'Adminisztrációs eszközök';
$HEADING['BROWSE_MEDIA']                     = 'Média böngészése';
$HEADING['CREATE_FOLDER']                    = 'Mappa létrehozása';
$HEADING['DEFAULT_SETTINGS']                 = 'Alapértelmezett beállítások';
$HEADING['DELETED_PAGES']                    = 'Törölt oldalak';
$HEADING['FILESYSTEM_SETTINGS']              = 'Fájlrendszer beállításai';
$HEADING['GENERAL_SETTINGS']                 = 'Általános beállítások';
$HEADING['INSTALL_LANGUAGE']                 = 'Nyelv telepítése';
$HEADING['INSTALL_MODULE']                   = 'Modul telepítése';
$HEADING['INSTALL_TEMPLATE']                 = 'Sablon telepítése';
$HEADING['INVOKE_LANGUAGE_FILES']            = 'Nyelvi fájlok kézi végrehajtása';
$HEADING['INVOKE_MODULE_FILES']              = 'Modul fájlok kézi végrehajtása';
$HEADING['INVOKE_TEMPLATE_FILES']            = 'Sablon fájlok kézi végrehajtása';
$HEADING['LANGUAGE_DETAILS']                 = 'Nyelvi részletek';
$HEADING['MANAGE_SECTIONS']                  = 'Szekciók kezelése';
$HEADING['MODIFY_ADVANCED_PAGE_SETTINGS']    = 'Haladó oldalbeállítások módosítása';
$HEADING['MODIFY_DELETE_GROUP']              = 'Csoport módosítása/törlése';
$HEADING['MODIFY_DELETE_PAGE']               = 'Oldal módosítása/törlése';
$HEADING['MODIFY_DELETE_USER']               = 'Felhasználó módosítása/törlése';
$HEADING['MODIFY_GROUP']                     = 'Csoport módosítása';
$HEADING['MODIFY_GROUPS']                    = 'Csoportok módosítása';
$HEADING['MODIFY_INTRO_PAGE']                = 'Intro oldal módosítása';
$HEADING['MODIFY_PAGE']                      = 'Oldal módosítása';
$HEADING['MODIFY_PAGE_SETTINGS']             = 'Oldalbeállítások módosítása';
$HEADING['MODIFY_USER']                      = 'Felhasználó módosítása';
$HEADING['MODULE_DETAILS']                   = 'Modul részletek';
$HEADING['MY_EMAIL']                         = 'Saját e-mail címem';
$HEADING['MY_PASSWORD']                      = 'Saját jelszavam';
$HEADING['MY_SETTINGS']                      = 'Saját beállításaim';
$HEADING['SEARCH_SETTINGS']                  = 'Keresési beállítások';
$HEADING['SERVER_SETTINGS']                  = 'Szerver beállítások';
$HEADING['TEMPLATE_DETAILS']                 = 'Sablon részletek';
$HEADING['UNINSTALL_LANGUAGE']               = 'Nyelv eltávolítása';
$HEADING['UNINSTALL_MODULE']                 = 'Modul eltávolítása';
$HEADING['UNINSTALL_TEMPLATE']               = 'Sablon eltávolítása';
$HEADING['UPGRADE_LANGUAGE']                 = 'Nyelv regisztrálása/frissítése';
$HEADING['UPLOAD_FILES']                     = 'Fájl(ok) feltöltése';
$HEADING['WBMAILER_SETTINGS']                = 'E-mail küldő beállítások';
$MENU['ACCESS']                             = 'Felhasználókezelés';
$MENU['ADDON']                              = 'Kiegészítő';
$MENU['ADDONS']                             = 'Kiegészítők';
$MENU['ADMINTOOLS']                         = 'Admin eszközök';
$MENU['BREADCRUMB']                         = 'Ön itt van: ';
$MENU['FORGOT']                             = 'Bejelentkezési adatok lekérése';
$MENU['GROUP']                              = 'Csoport';
$MENU['GROUPS']                             = 'Csoportok';
$MENU['HELP']                               = 'Segítség';
$MENU['LANGUAGES']                          = 'Nyelvek';
$MENU['LOGIN']                              = 'Bejelentkezés';
$MENU['LOGOUT']                             = 'Kijelentkezés';
$MENU['MEDIA']                              = 'Média';
$MENU['MODULES']                            = 'Modulok';
$MENU['MY_PROFILE']                         = 'Saját profilom';
$MENU['PAGES']                              = 'Oldalak';
$MENU['PREFERENCES']                        = 'Beállítások';
$MENU['REORG_TABLE']                        = 'Táblák újrarendezése';
$MENU['SETTINGS']                           = 'Beállítások';
$MENU['START']                              = 'Start';
$MENU['TEMPLATES']                          = 'Sablonok';
$MENU['USERS']                              = 'Felhasználók';
$MENU['VIEW']                               = 'Nézet';
$MESSAGE['ADDON_ERROR_RELOAD']               = 'Hiba a kiegészítő információinak frissítésekor.';
$MESSAGE['ADDON_LANGUAGES_RELOADED']         = 'Nyelvek sikeresen újratöltve';
$MESSAGE['ADDON_MANUAL_FTP_LANGUAGE']        = '<strong>FIGYELEM!</strong> Biztonsági okokból a nyelvi fájlokat csak FTP-n keresztül töltsd fel a /languages/ mappába, és a frissítési funkciót használd a regisztrációhoz vagy frissítéshez.';
$MESSAGE['ADDON_MANUAL_FTP_WARNING']         = 'Figyelem: A meglévő moduladatbázis-bejegyzések elvesznek. ';
$MESSAGE['ADDON_MANUAL_INSTALLATION']        = 'Amikor a modulok FTP-n keresztül kerülnek feltöltésre (nem ajánlott), a modul telepítési funkciói (<code>install</code>, <code>upgrade</code> vagy <code>uninstall</code>) nem kerülnek automatikusan végrehajtásra. Ezek a modulok nem működhetnek megfelelően, vagy nem távolíthatók el megfelelően.<br /><br />Az FTP-n keresztül feltöltött modulok funkcióit manuálisan is végrehajthatja alább.';
$MESSAGE['ADDON_MANUAL_INSTALLATION_WARNING']= 'Figyelem: A meglévő moduladatbázis-bejegyzések elvesznek. Csak akkor használja ezt az opciót, ha problémákat tapasztal az FTP-n keresztül feltöltött modulokkal.';
$MESSAGE['ADDON_MANUAL_RELOAD_WARNING']      = 'Figyelem: A meglévő moduladatbázis-bejegyzések elvesznek. ';
$MESSAGE['ADDON_MODULES_RELOADED']           = 'Modulok sikeresen újratöltve';
$MESSAGE['ADDON_OVERWRITE_NEWER_FILES']      = 'Újabb fájlok felülírása';
$MESSAGE['ADDON_PRECHECK_FAILED']            = 'A kiegészítő telepítése sikertelen. Rendszere nem felel meg a kiegészítő követelményeinek. Ahhoz, hogy ez a kiegészítő működjön a rendszerén, kérjük, javítsa az alább összefoglalt problémákat.';
$MESSAGE['ADDON_RELOAD']                     = 'Adatbázis frissítése a kiegészítő fájlokból származó információkkal (pl. FTP feltöltés után).';
$MESSAGE['ADDON_TEMPLATES_RELOADED']         = 'Sablonok sikeresen újratöltve';
$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES']   = 'Elégtelen hozzáférési jogosultságok';
$MESSAGE['FORGOT_PASS_ALREADY_RESET']        = 'A jelszó csak óránként egyszer állítható vissza';
$MESSAGE['FORGOT_PASS_CANNOT_EMAIL']         = 'Nem lehet e-mailben elküldeni a jelszót, kérjük, vegye fel a kapcsolatot a rendszergazdával';
$MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND']      = 'Az Ön által megadott e-mail cím nem található az adatbázisban';
$MESSAGE['FORGOT_PASS_NO_DATA']              = 'Kérjük, adja meg e-mail címét alább';
$MESSAGE['FORGOT_PASS_PASSWORD_RESET']       = 'Jelszavát elküldtük e-mail címére';
$MESSAGE['FRONTEND_SORRY_NO_ACTIVE_SECTIONS']= 'Sajnáljuk, nincs aktív tartalom a megjelenítéshez';
$MESSAGE['FRONTEND_SORRY_NO_VIEWING_PERMISSIONS'] = 'Sajnáljuk, nincs jogosultsága megtekinteni ezt az oldalt';
$MESSAGE['GENERIC_ALREADY_INSTALLED']        = 'Már telepítve';
$MESSAGE['GENERIC_BAD_PERMISSIONS']          = 'Nem lehet írni a célkönyvtárba';
$MESSAGE['GENERIC_BE_PATIENT']               = 'Kérjük, legyen türelemmel.';
$MESSAGE['GENERIC_CANNOT_UNINSTALL']         = 'Nem távolítható el';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE']  = 'Nem távolítható el: a kiválasztott fájl használatban van';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL'] = '<br /><br />{{type}} <b>{{type_name}}</b> nem távolítható el, mert még használatban van a következőn: {{pages}}.<br /><br />';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL_PAGES'] = 'ezen az oldalon;ezeken az oldalakon';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_TEMPLATE'] = 'Nem távolítható el a <b>{{name}}</b> sablon, mert ez az alapértelmezett sablon!';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_THEME'] = 'Nem távolítható el a <b>{{name}}</b> sablon, mert ez az alapértelmezett backend téma!';
$MESSAGE['GENERIC_CANNOT_UNZIP']             = 'Nem lehet kicsomagolni a fájlt';
$MESSAGE['GENERIC_CANNOT_UPLOAD']            = 'Nem lehet feltölteni a fájlt';
$MESSAGE['GENERIC_COMPARE']                  = ' sikeres';
$MESSAGE['GENERIC_ERROR_OPENING_FILE']       = 'Hiba a fájl megnyitásakor.';
$MESSAGE['GENERIC_FAILED_COMPARE']           = ' sikertelen';
$MESSAGE['GENERIC_FILE_TYPE']                = 'Kérjük, vegye figyelembe, hogy a feltöltött fájl formátuma a következő kell, hogy legyen:';
$MESSAGE['GENERIC_FILE_TYPES']               = 'Kérjük, vegye figyelembe, hogy a feltöltött fájl formátuma az alábbiak közül az egyik kell, hogy legyen:';
$MESSAGE['GENERIC_FILL_IN_ALL']              = 'Kérjük, menjen vissza és töltse ki az összes mezőt';
$MESSAGE['GENERIC_FORGOT_OPTIONS']           = 'Nem választott!';
$MESSAGE['GENERIC_INSTALLED']                = 'Sikeresen telepítve';
$MESSAGE['GENERIC_INVALID']                  = 'A feltöltött fájl érvénytelen';
$MESSAGE['GENERIC_INVALID_ADDON_FILE']       = 'Érvénytelen WebsiteBaker telepítési fájl. Kérjük, ellenőrizze a *.zip formátumot.';
$MESSAGE['GENERIC_INVALID_LANGUAGE_FILE']    = 'Érvénytelen WebsiteBaker nyelvi fájl. Kérjük, ellenőrizze a szöveges fájlt.';
$MESSAGE['GENERIC_INVALID_MODULE_FILE']      = 'Érvénytelen WebsiteBaker modul fájl. Kérjük, ellenőrizze a szöveges fájlt.';
$MESSAGE['GENERIC_INVALID_TEMPLATE_FILE']    = 'Érvénytelen WebsiteBaker sablon fájl. Kérjük, ellenőrizze a szöveges fájlt.';
$MESSAGE['GENERIC_IN_USE']                   = ' de használatban van: ';
$MESSAGE['GENERIC_MISSING_ARCHIVE_FILE']     = 'Hiányzó archív fájl!';
$MESSAGE['GENERIC_MODULE_VERSION_ERROR']     = 'A %s modul nincs megfelelően telepítve!';
$MESSAGE['GENERIC_NOT_COMPARE']              = ' nem lehetséges';
$MESSAGE['GENERIC_NOT_INSTALLED']            = 'Nincs telepítve';
$MESSAGE['GENERIC_NOT_UPGRADED']             = 'Frissítés nem lehetséges';
$MESSAGE['GENERIC_PLEASE_BE_PATIENT']        = 'Kérjük, legyen türelemmel, ez eltarthat egy ideig.';
$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON']   = 'Kérjük, nézzen vissza hamarosan...';
$MESSAGE['GENERIC_SECURITY_ACCESS']          = 'Biztonsági szabálysértés!! Hozzáférés megtagadva!';
$MESSAGE['GENERIC_SECURITY_OFFENSE']         = 'Biztonsági szabálysértés!! Adattárolás megtagadva!';
$MESSAGE['GENERIC_UNINSTALLED']              = 'Sikeresen eltávolítva';
$MESSAGE['GENERIC_UPGRADED']                 = 'Sikeresen frissítve';
$MESSAGE['GENERIC_VERSION_COMPARE']          = 'Verzió összehasonlítás';
$MESSAGE['GENERIC_VERSION_GT']               = 'Frissítés szükséges!';
$MESSAGE['GENERIC_VERSION_LT']               = 'Visszaállítás';
$MESSAGE['GENERIC_WEBSITE_LOCKED']           = 'ez az oldal ideiglenesen karbantartás miatt nem elérhető';
$MESSAGE['GENERIC_WEBSITE_UNDER_CONSTRUCTION'] = 'Webhely karbantartás alatt';
$MESSAGE['GENERIC_WEBSITE_NO_PAGES']         = 'Ez a webhely ehhez a nyelvhez (%s) még fejlesztés alatt áll';
$MESSAGE['GROUPS_ADDED']                     = 'Csoport sikeresen hozzáadva';
$MESSAGE['GROUPS_CONFIRM_DELETE']            = 'Biztosan törölni szeretné a kiválasztott csoportot (és a hozzá tartozó felhasználókat)?';
$MESSAGE['GROUPS_DELETED']                   = 'Csoport sikeresen törölve';
$MESSAGE['GROUPS_GROUP_NAME_BLANK']          = 'A csoport neve üres';
$MESSAGE['GROUPS_GROUP_NAME_EXISTS']         = 'A csoport neve már létezik';
$MESSAGE['GROUPS_NO_GROUPS_FOUND']           = 'Nem található csoport';
$MESSAGE['GROUPS_SAVED']                     = 'Csoport sikeresen elmentve';
$MESSAGE['LOGIN_AUTHENTICATION_FAILED']      = 'Hibás felhasználónév vagy jelszó';
$MESSAGE['LOGIN_BOTH_BLANK']                 = 'Kérjük, adja meg felhasználónevét és jelszavát';
$MESSAGE['LOGIN_PASSWORD_BLANK']             = 'Kérjük, adjon meg egy jelszót';
$MESSAGE['LOGIN_PASSWORD_TOO_LONG']          = 'A megadott jelszó túl hosszú';
$MESSAGE['LOGIN_PASSWORD_TOO_SHORT']         = 'A megadott jelszó túl rövid';
$MESSAGE['LOGIN_USERNAME_BLANK']             = 'Kérjük, adjon meg egy felhasználónevet';
$MESSAGE['LOGIN_USERNAME_TOO_LONG']          = 'A megadott felhasználónév túl hosszú';
$MESSAGE['LOGIN_USERNAME_TOO_SHORT']         = 'A megadott felhasználónév túl rövid';
$MESSAGE['MEDIA_BLANK_EXTENSION']            = 'Nem adtál meg fájlkiterjesztést';
$MESSAGE['MEDIA_BLANK_NAME']                 = 'Nem adtál meg új nevet';
$MESSAGE['MEDIA_CANNOT_DELETE_DIR']          = 'Nem lehet törölni a kiválasztott mappát';
$MESSAGE['MEDIA_CANNOT_DELETE_FILE']         = 'Nem lehet törölni a kiválasztott fájlt';
$MESSAGE['MEDIA_CANNOT_RENAME']              = 'Átnevezés sikertelen';
$MESSAGE['MEDIA_CONFIRM_DELETE']             = 'Biztosan törölni szeretné a következő fájlt vagy mappát?';
$MESSAGE['MEDIA_DELETED_DIR']                = 'Mappa sikeresen törölve';
$MESSAGE['MEDIA_DELETED_FILE']               = 'Fájl sikeresen törölve';
$MESSAGE['MEDIA_DIR_ACCESS_DENIED']          = 'A megadott könyvtár nem létezik vagy nem engedélyezett.';
$MESSAGE['MEDIA_DIR_DOES_NOT_EXIST']         = 'A könyvtár nem létezik';
$MESSAGE['MEDIA_DIR_DOT_DOT_SLASH']          = 'Nem tartalmazhatja a ../ karaktert a mappa nevében';
$MESSAGE['MEDIA_DIR_EXISTS']                 = 'Már létezik egy mappa a megadott névvel';
$MESSAGE['MEDIA_DIR_MADE']                   = 'Mappa sikeresen létrehozva';
$MESSAGE['MEDIA_DIR_NOT_MADE']               = 'Nem sikerült létrehozni a mappát';
$MESSAGE['MEDIA_FILE_EXISTS']                = 'Már létezik egy fájl a megadott névvel';
$MESSAGE['MEDIA_FILE_NOT_FOUND']             = 'Fájl nem található';
$MESSAGE['MEDIA_NAME_DOT_DOT_SLASH']         = 'Nem tartalmazhatja a ../ karaktert a névben';
$MESSAGE['MEDIA_NAME_INDEX_PHP']             = 'Nem használható az index.php névként';
$MESSAGE['MEDIA_NONE_FOUND']                 = 'Nem található média az aktuális mappában';
$MESSAGE['MEDIA_NO_FILE_UPLOADED']           = 'Nem lett feltöltve fájl';
$MESSAGE['MEDIA_RENAMED']                    = 'Átnevezés sikeres';
$MESSAGE['MEDIA_SINGLE_UPLOADED']            = ' fájl sikeresen feltöltve';
$MESSAGE['MEDIA_TARGET_DOT_DOT_SLASH']       = 'Nem tartalmazhatja a ../ karaktert a célmappában';
$MESSAGE['MEDIA_UPLOADED']                   = ' fájl sikeresen feltöltve';
$MESSAGE['MOD_FORM_EXCESS_SUBMISSIONS']      = 'Sajnáljuk, ezt az űrlapot túl sokszor küldték be ebben az órában. Kérjük, próbálja meg újra a következő órában.';
$MESSAGE['MOD_FORM_INCORRECT_CAPTCHA']       = 'Az Ön által megadott ellenőrző szám (más néven Captcha) helytelen. Ha problémája van a Captcha elolvasásával, kérjük, küldjön e-mailt a következő címre: <a href="mailto:{{SERVER_EMAIL}}">{{SERVER_EMAIL}}</a>';
$MESSAGE['MOD_FORM_REQUIRED_FIELDS']         = 'Meg kell adni a következő mezők adatait';
$MESSAGE['PAGES_ADDED']                      = 'Oldal sikeresen hozzáadva';
$MESSAGE['PAGES_ADDED_HEADING']              = 'Oldal fejléc sikeresen hozzáadva';
$MESSAGE['PAGES_BLANK_MENU_TITLE']           = 'Kérjük, adjon meg egy menü címet';
$MESSAGE['PAGES_BLANK_PAGE_TITLE']           = 'Kérjük, adja meg az oldal címét';
$MESSAGE['PAGES_CANNOT_CREATE_ACCESS_FILE']  = 'Hiba a hozzáférési fájl létrehozásakor a /pages könyvtárban (elégtelen jogosultságok)';
$MESSAGE['PAGES_CANNOT_DELETE_ACCESS_FILE']  = 'Hiba a hozzáférési fájl törlésekor a /pages könyvtárban (elégtelen jogosultságok)';
$MESSAGE['PAGES_CANNOT_REORDER']             = 'Hiba az oldal átrendezésénél';
$MESSAGE['PAGES_DELETED']                    = 'Oldal sikeresen törölve';
$MESSAGE['PAGES_DELETE_CONFIRM']             = 'Biztosan törölni szeretné a kiválasztott oldalt (és az összes aloldalát)?';
$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']   = 'Nincs jogosultsága az oldal módosításához';
$MESSAGE['PAGES_INTRO_LINK']                 = 'Kattintson IDE az intro oldal módosításához';
$MESSAGE['PAGES_INTRO_NOT_WRITABLE']         = 'Nem lehet írni a /pages/intro.php fájlba (elégtelen jogosultságok)';
$MESSAGE['PAGES_INTRO_SAVED']                = 'Intro oldal sikeresen elmentve';
$MESSAGE['PAGES_LAST_MODIFIED']              = 'Utolsó módosítás:';
$MESSAGE['PAGES_NOT_FOUND']                  = 'Oldal nem található';
$MESSAGE['PAGES_NOT_SAVED']                  = 'Hiba az oldal mentésekor';
$MESSAGE['PAGES_PAGE_EXISTS']                = 'Már létezik egy oldal azonos vagy hasonló címmel';
$MESSAGE['PAGES_REORDERED']                  = 'Oldal sikeresen átrendezve';
$MESSAGE['PAGES_RESTORED']                   = 'Oldal sikeresen visszaállítva';
$MESSAGE['PAGES_RETURN_TO_PAGES']            = 'Vissza az oldalakhoz';
$MESSAGE['PAGES_SAVED']                      = 'Oldal sikeresen elmentve';
$MESSAGE['PAGES_SAVED_SETTINGS']             = 'Oldalbeállítások sikeresen elmentve';
$MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED']  = 'Szekció tulajdonságok sikeresen elmentve';
$MESSAGE['PAGE_MODIFIED']                    = 'Az oldal módosítva %s %s által';
$MESSAGE['PREFERENCES_CURRENT_PASSWORD_INCORRECT'] = 'A megadott (jelenlegi) jelszó helytelen';
$MESSAGE['PREFERENCES_DETAILS_SAVED']        = 'Adatok sikeresen elmentve';
$MESSAGE['PREFERENCES_EMAIL_UPDATED']        = 'E-mail sikeresen frissítve';
$MESSAGE['PREFERENCES_INVALID_CHARS']        = 'Érvénytelen jelszókarakterek használva';
$MESSAGE['PREFERENCES_PASSWORD_CHANGED']     = 'Jelszó sikeresen megváltoztatva';
$MESSAGE['RECORD_MODIFIED_FAILED']           = 'A rekord módosítása sikertelen.';
$MESSAGE['RECORD_MODIFIED_SAVED']            = 'A módosított rekord sikeresen frissült.';
$MESSAGE['RECORD_NEW_FAILED']                = 'Új rekord hozzáadása sikertelen.';
$MESSAGE['RECORD_NEW_SAVED']                 = 'Új rekord sikeresen hozzáadva.';
$MESSAGE['REORG_SUCCESS']                    = 'Az újrarendezés sikeresen megtörtént';
$MESSAGE['SETTINGS_MODE_SWITCH_WARNING']     = 'Kérjük, vegye figyelembe: Ez a gomb visszaállítja az összes nem mentett változást';
$MESSAGE['SETTINGS_SAVED']                   = 'Beállítások sikeresen elmentve!';
$MESSAGE['SETTINGS_UNABLE_OPEN_CONFIG']      = 'Nem lehet megnyitni a konfigurációs fájlt';
$MESSAGE['SETTINGS_UNABLE_WRITE_CONFIG']     = 'Nem lehet írni a konfigurációs fájlba';
$MESSAGE['SETTINGS_WORLD_WRITEABLE_WARNING'] = 'Kérjük, vegye figyelembe: ez csak tesztkörnyezetekhez ajánlott';
$MESSAGE['SIGNUP2_ADMIN_INFO']               = "\r\nÚj felhasználó regisztrálva.\r\n\r\nFelhasználónév: {LOGIN_NAME}\r\n{DISPLAY_NAME}: {LOGIN_ID}\r\nE-mail: {LOGIN_EMAIL}\r\nRegisztráció dátuma: {SIGNUP_DATE}\r\n----------------------------------------\r\nEz az üzenet automatikusan generálódott!\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_FORGOT']       = "\r\nÜdvözlöm, {LOGIN_DISPLAY_NAME},\r\n\r\nEzt az e-mailt azért küldtük, mert fiókjához a 'jelszó elfelejtve' funkciót használták.\r\n\r\nAz Ön új '{LOGIN_WEBSITE_TITLE}' bejelentkezési adatai:\r\n\r\nFelhasználónév: xxxxx\r\nJelszó: {LOGIN_PASSWORD}\r\n\r\nJelszavát a fentire állítottuk vissza.\r\nEz azt jelenti, hogy régi jelszava többé nem fog működni!\r\nHa bármilyen kérdése vagy problémája van az új bejelentkezési adatokkal kapcsolatban,\r\nforduljon a webhely csapatához vagy a(z) '{LOGIN_WEBSITE_TITLE}' adminisztrátorához.\r\nKérjük, ne feledje törölni a böngésző gyorsítótárát, mielőtt az újat használná, hogy elkerülje a váratlan hibákat.\r\n\r\nÜdvözlettel\r\n------------------------------------\r\nEz az üzenet automatikusan generálódott\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_INFO']          = "\r\nÜdvözlöm, {LOGIN_DISPLAY_NAME},\r\n\r\nÜdvözöljük a(z) '{LOGIN_WEBSITE_TITLE}' oldalon.\r\n\r\nAz Ön '{LOGIN_WEBSITE_TITLE}' bejelentkezési adatai:\r\nFelhasználónév: xxxxx\r\nJelszó: {LOGIN_PASSWORD}\r\n\r\nÜdvözlettel\r\n\r\nKérjük:\r\nha tévedésből kapta ezt az üzenetet, azonnal törölje!\r\n-------------------------------------\r\nEz az üzenet automatikusan generálódott!\r\n";
$MESSAGE['SIGNUP2_NEW_USER']                 = 'Új felhasználó regisztrálva';
$MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO']       = 'Az Ön bejelentkezési adatai...';
$MESSAGE['SIGNUP2_SUBJECT_NEW_USER']         = 'Köszönjük a regisztrációt';
$MESSAGE['SIGNUP_NO_EMAIL']                  = 'Meg kell adnia egy e-mail címet';
$MESSAGE['START_CURRENT_USER']               = 'Jelenleg bejelentkezve mint:';
$MESSAGE['START_INSTALL_DIR_EXISTS']         = 'Figyelem, az telepítési könyvtár még létezik!';
$MESSAGE['START_UPGRADE_SCRIPT_EXISTS']      = 'Kérjük, törölje a {{file}} fájlt a webtárhelyéről.';
$MESSAGE['START_WELCOME_MESSAGE']            = 'Üdvözöljük a WebsiteBaker adminisztrációjában';
$MESSAGE['TEMPLATES_CHANGE_TEMPLATE_NOTICE'] = 'Kérjük, vegye figyelembe: a sablon megváltoztatásához a Beállítások szekcióba kell lépnie';
$MESSAGE['THEME_ALREADY_EXISTS']             = 'Ez az új téma leíró már létezik.';
$MESSAGE['THEME_COPY_CURRENT']               = 'Másolja a jelenlegi aktív témát, és mentse új néven.';
$MESSAGE['THEME_DESTINATION_READONLY']       = 'Nincs jogosultság új téma könyvtár létrehozására!';
$MESSAGE['THEME_IMPORT_HTT']                 = 'További sablonok importálása az aktuális aktív témába.<br />Ezeket a sablonokat használja a megfelelő alapértelmezett sablon felülírásához.';
$MESSAGE['THEME_INVALID_SOURCE_DESTINATION'] = 'Érvénytelen leírót adott meg az új témához!';
$MESSAGE['UNKNOW_UPLOAD_ERROR']              = 'Ismeretlen feltöltési hiba';
$MESSAGE['UPLOAD_ERR_CANT_WRITE']            = 'Nem sikerült a fájlt a lemezre írni';
$MESSAGE['UPLOAD_ERR_EXTENSION']             = 'Fájlfeltöltést leállította a kiterjesztés';
$MESSAGE['UPLOAD_ERR_FORM_SIZE']             = 'A feltöltött fájl mérete meghaladja a HTML űrlapon megadott MAX_FILE_SIZE direktívát';
$MESSAGE['UPLOAD_ERR_INI_SIZE']              = 'A feltöltött fájl mérete meghaladja az upload_max_filesize direktívát a php.ini fájlban';
$MESSAGE['UPLOAD_ERR_NO_FILE']               = 'Nem lett feltöltve fájl';
$MESSAGE['UPLOAD_ERR_NO_TMP_DIR']            = 'Hiányzik az ideiglenes mappa';
$MESSAGE['UPLOAD_ERR_OK']                    = 'A fájl sikeresen feltöltve';
$MESSAGE['UPLOAD_ERR_PARTIAL']               = 'A feltöltött fájl csak részlegesen került feltöltésre';
$MESSAGE['USERS_ADDED']                      = 'Felhasználó sikeresen hozzáadva';
$MESSAGE['USERS_CANT_SELFDELETE']            = 'Funkció elutasítva, nem törölheti saját magát!';
$MESSAGE['USERS_CHANGING_PASSWORD']          = 'Kérjük, vegye figyelembe: Csak akkor adhat meg értékeket a fenti mezőkbe, ha módosítani szeretné ennek a felhasználónak a jelszavát';
$MESSAGE['USERS_CONFIRM_DELETE']             = 'Biztosan törölni szeretné a kiválasztott felhasználót?';
$MESSAGE['USERS_DELETED']                    = 'Felhasználó sikeresen törölve';
$MESSAGE['USERS_DISPLAYNAME_TAKEN']          = 'A megadott megjelenítési név már használatban van.';
$MESSAGE['USERS_EMAIL_TAKEN']                = 'A megadott e-mail cím már használatban van';
$MESSAGE['USERS_INVALID_EMAIL']              = 'A megadott e-mail cím érvénytelen';
$MESSAGE['USERS_NAME_INVALID_CHARS']         = 'Érvénytelen karakterek a felhasználónévben';
$MESSAGE['USERS_NO_GROUP']                   = 'Nincs csoport kiválasztva';
$MESSAGE['USERS_PASSWORD_MISMATCH']          = 'A megadott jelszavak nem egyeznek';
$MESSAGE['USERS_PASSWORD_TOO_SHORT']         = 'A megadott jelszó túl rövid volt';
$MESSAGE['USERS_SAVED']                      = 'Felhasználó sikeresen elmentve';
$MESSAGE['USERS_USERNAME_TAKEN']             = 'A megadott felhasználónév már foglalt';
$MESSAGE['USERS_USERNAME_TOO_SHORT']         = 'A megadott felhasználónév túl rövid volt';
$OVERVIEW['ADMINTOOLS']                     = 'Hozzáférés a WebsiteBaker adminisztrációs eszközeihez...';
$OVERVIEW['GROUPS']                         = 'Felhasználói csoportok és rendszerjogosultságaik kezelése...';
$OVERVIEW['HELP']                           = 'Kérdése van? Keresse meg a választ...';
$OVERVIEW['LANGUAGES']                      = 'WebsiteBaker nyelvek kezelése...';
$OVERVIEW['MEDIA']                          = 'Média mappában tárolt fájlok kezelése...';
$OVERVIEW['MODULES']                        = 'WebsiteBaker modulok kezelése...';
$OVERVIEW['PAGES']                          = 'Webhelyének oldalai kezelése...';
$OVERVIEW['PREFERENCES']                    = 'Beállítások módosítása, mint e-mail cím, jelszó stb... ';
$OVERVIEW['SETTINGS']                       = 'Módosítja a WebsiteBaker beállításait...';
$OVERVIEW['START']                          = 'Adminisztrációs áttekintés';
$OVERVIEW['TEMPLATES']                      = 'Változtassa meg webhelyének kinézetét sablonokkal...';
$OVERVIEW['USERS']                          = 'WebsiteBakerbe bejelentkezni képes felhasználók kezelése...';
$OVERVIEW['VIEW']                           = 'Gyorsan megtekintheti és böngészheti webhelyét új ablakban...';
$TEXT['ACCOUNT_SIGNUP']                     = 'Fiók regisztrációja';
$TEXT['ACTIONS']                            = 'Műveletek';
$TEXT['ACTIVE']                             = 'Aktív';
$TEXT['ADD']                                = 'Hozzáadás';
$TEXT['ADDON']                              = 'Kiegészítő';
$TEXT['ADD_SECTION']                        = 'Szekció hozzáadása';
$TEXT['ADMIN']                              = 'Admin';
$TEXT['ADMINISTRATION']                     = 'Adminisztráció';
$TEXT['ADMINISTRATION_TOOL']                = 'Adminisztrációs eszköz';
$TEXT['ADMINISTRATOR']                      = 'Adminisztrátor';
$TEXT['ADMINISTRATORS']                     = 'Adminisztrátorok';
$TEXT['ADVANCED']                           = 'Haladó';
$TEXT['ALLOWED_FILETYPES_ON_UPLOAD']        = 'Engedélyezett fájltípusok feltöltéskor';
$TEXT['ALLOWED_VIEWERS']                    = 'Engedélyezett nézők';
$TEXT['ALLOW_MULTIPLE_SELECTIONS']          = 'Többszörös kijelölés engedélyezése';
$TEXT['ALL_WORDS']                          = 'Összes szó';
$TEXT['ANCHOR']                             = 'Horgony';
$TEXT['ANONYMOUS']                          = 'Névtelen';
$TEXT['ANY_WORDS']                          = 'Bármely szó';
$TEXT['APP_NAME']                           = 'Alkalmazás neve';
$TEXT['ARE_YOU_SURE']                       = 'Biztos benne?';
$TEXT['AUTHOR']                             = 'Szerző';
$TEXT['BACK']                               = 'Vissza';
$TEXT['BACKUP']                             = 'Biztonsági mentés';
$TEXT['BACKUP_ALL_TABLES']                  = 'Az adatbázis összes táblájának biztonsági mentése';
$TEXT['BACKUP_DATABASE']                    = 'Adatbázis biztonsági mentése';
$TEXT['BACKUP_MEDIA']                       = 'Média biztonsági mentése';
$TEXT['BACKUP_WB_SPECIFIC']                 = 'Csak WB-specifikus táblák biztonsági mentése';
$TEXT['BASIC']                              = 'Alap';
$TEXT['BLOCK']                              = 'Blokk';
$TEXT['BROWSE_UPLOAD_FILE']                 = 'Fájl kiválasztása!';
$TEXT['CALENDAR']                           = 'Naptár';
$TEXT['CANCEL']                             = 'Mégse';
$TEXT['CAN_DELETE_HIMSELF']                 = 'Törölheti saját magát';
$TEXT['CAPTCHA_VERIFICATION']               = 'Captcha ellenőrzés';
$TEXT['CAP_EDIT_CSS']                       = 'CSS szerkesztése';
$TEXT['CHANGE']                             = 'Módosítás';
$TEXT['CHANGES']                            = 'Változások';
$TEXT['CHANGE_SETTINGS']                    = 'Beállítások módosítása';
$TEXT['CHARSET']                            = 'Karakterkészlet';
$TEXT['CHECKBOX_GROUP']                     = 'Jelölőnégyzet csoport';
$TEXT['CLOSE']                              = 'Bezárás';
$TEXT['CODE']                               = 'Kód';
$TEXT['CODE_SNIPPET']                       = 'Kódrészlet';
$TEXT['COLLAPSE']                           = 'Összecsukás';
$TEXT['COMMENT']                            = 'Megjegyzés';
$TEXT['COMMENTING']                         = 'Hozzászólás';
$TEXT['COMMENTS']                           = 'Hozzászólások';
$TEXT['CONFIRM']                            = 'Megerősítés';
$TEXT['CREATE_FOLDER']                      = 'Mappa létrehozása';
$TEXT['CURRENT']                            = 'Jelenlegi';
$TEXT['CURRENT_FOLDER']                     = 'Jelenlegi mappa';
$TEXT['CURRENT_PAGE']                       = 'Jelenlegi oldal';
$TEXT['CURRENT_PASSWORD']                   = 'Jelenlegi jelszó';
$TEXT['CUSTOM']                             = 'Egyedi';
$TEXT['DATABASE']                           = 'Adatbázis';
$TEXT['DATE']                               = 'Dátum';
$TEXT['DATE_FORMAT']                        = 'Dátum formátum';
$TEXT['DEFAULT']                            = 'Alapértelmezett';
$TEXT['DEFAULT_CHARSET']                    = 'Alapértelmezett karakterkészlet';
$TEXT['DEFAULT_TEXT']                       = 'Alapértelmezett szöveg';
$TEXT['DELETE']                             = 'Törlés';
$TEXT['DELETED']                            = 'Törölve';
$TEXT['DELETE_DATE']                        = 'Törlés dátuma';
$TEXT['DELETE_ZIP']                         = 'Zip archívum törlése kicsomagolás után';
$TEXT['DESCRIPTION']                        = 'Leírás';
$TEXT['DESIGNED_FOR']                       = 'Célközönség';
$TEXT['DEV_INFOS']                          = 'Fejlesztői információk';
$TEXT['DIRECTORIES']                        = 'Könyvtárak';
$TEXT['DIRECTORY_MODE']                     = 'Könyvtár mód';
$TEXT['DISABLED']                           = 'Kikapcsolva';
$TEXT['DISPLAY_NAME']                       = 'Megjelenített név';
$TEXT['EMAIL']                              = 'E-mail';
$TEXT['EMAIL_ADDRESS']                      = 'E-mail cím';
$TEXT['EMPTY_TRASH']                        = 'Kuka ürítése';
$TEXT['ENABLED']                            = 'Engedélyezve';
$TEXT['END']                                = 'Vége';
$TEXT['ERROR']                              = 'Hiba';
$TEXT['EXACT_MATCH']                        = 'Pontos egyezés';
$TEXT['EXECUTE']                            = 'Végrehajtás';
$TEXT['EXPAND']                             = 'Kibontás';
$TEXT['EXTENSION']                          = 'Kiterjesztés';
$TEXT['FIELD']                              = 'Mező';
$TEXT['FILE']                               = 'Fájl';
$TEXT['FILES']                              = 'Fájlok';
$TEXT['FILESYSTEM_PERMISSIONS']             = 'Fájlrendszer jogosultságok';
$TEXT['FILE_MODE']                          = 'Fájl mód';
$TEXT['FINISH_PUBLISHING']                  = 'Közzététel befejezése';
$TEXT['FOLDER']                             = 'Mappa';
$TEXT['FOLDERS']                            = 'Mappák';
$TEXT['FOOTER']                             = 'Lábléc';
$TEXT['FORGOTTEN_DETAILS']                  = 'Elfelejtette adatait?';
$TEXT['FORGOT_DETAILS']                     = 'Elfelejtett adatok?';
$TEXT['FROM']                               = 'Feladó';
$TEXT['FRONTEND']                           = 'Frontend';
$TEXT['FULL_NAME']                          = 'Teljes név';
$TEXT['FUNCTION']                           = 'Funkció';
$TEXT['GROUP']                              = 'Csoport';
$TEXT['GUEST']                              = 'Vendég';
$TEXT['HEADER']                             = 'Fejléc';
$TEXT['HEADING']                            = 'Címsor';
$TEXT['HEADING_CSS_FILE']                   = 'Aktuális modul fájl: ';
$TEXT['HEIGHT']                             = 'Magasság';
$TEXT['HIDDEN']                             = 'Rejtett';
$TEXT['HIDE']                               = 'Elrejtés';
$TEXT['HIDE_ADVANCED']                      = 'Haladó beállítások elrejtése';
$TEXT['HOME']                               = 'Főoldal';
$TEXT['HOMEPAGE_REDIRECTION']               = 'Kezdőlap átirányítás';
$TEXT['HOME_FOLDER']                        = 'Személyes mappa';
$TEXT['HOME_FOLDERS']                       = 'Személyes mappák';
$TEXT['HOST']                               = 'Host';
$TEXT['ICON']                               = 'Ikon';
$TEXT['IMAGE']                              = 'Kép';
$TEXT['INLINE']                             = 'Inline';
$TEXT['INSTALL']                            = 'Telepítés';
$TEXT['INSTALLATION']                       = 'Telepítés';
$TEXT['INSTALLATION_PATH']                  = 'Telepítési útvonal';
$TEXT['INSTALLATION_URL']                   = 'Telepítési URL';
$TEXT['INSTALLED']                          = 'telepítve';
$TEXT['INTRO']                              = 'Intro';
$TEXT['INTRO_PAGE']                         = 'Intro oldal';
$TEXT['INVALID_SIGNS']                      = 'betűvel kell kezdődnie vagy érvénytelen karaktereket tartalmaz';
$TEXT['KEYWORDS']                           = 'Kulcsszavak';
$TEXT['LANGUAGE']                           = 'Nyelv';
$TEXT['LAST_UPDATED_BY']                    = 'Utolsó frissítés dátuma:';
$TEXT['LENGTH']                             = 'Hossz';
$TEXT['LEVEL']                              = 'Szint';
$TEXT['LICENSE']                            = 'Licenc';
$TEXT['LINK']                               = 'Link';
$TEXT['LINUX_UNIX_BASED']                   = 'Linux/Unix alapú';
$TEXT['LIST_OPTIONS']                       = 'Lista opciók';
$TEXT['LOGGED_IN']                          = 'Bejelentkezett';
$TEXT['LOGIN']                              = 'Bejelentkezés';
$TEXT['LONG']                               = 'Hosszú';
$TEXT['LONG_TEXT']                          = 'Hosszú szöveg';
$TEXT['LOOP']                               = 'Ciklus';
$TEXT['MAIN']                               = 'Fő';
$TEXT['USER_LOGIN_ON']                      = 'Felhasználói bejelentkezés engedélyezése';
$TEXT['USER_LOGIN_OFF']                     = 'Felhasználói bejelentkezés megakadályozása';
$TEXT['MAINTENANCE_OFF']                    = 'Karbantartás kikapcsolva';
$TEXT['MAINTENANCE_ON']                     = 'Karbantartás bekapcsolva';
$TEXT['MANAGE']                             = 'Kezelés';
$TEXT['MANAGE_GROUPS']                      = 'Csoportok kezelése';
$TEXT['MANAGE_USERS']                       = 'Felhasználók kezelése';
$TEXT['MATCH']                              = 'Egyezés';
$TEXT['MATCHING']                           = 'Egyező';
$TEXT['MAX_EXCERPT']                        = 'Kivonat max. sora';
$TEXT['MAX_SUBMISSIONS_PER_HOUR']           = 'Max. beküldés óránként';
$TEXT['MEDIA_DIRECTORY']                    = 'Média könyvtár';
$TEXT['MENU']                               = 'Menü';
$TEXT['MENU_ICON_0']                        = 'Menü ikon normál';
$TEXT['MENU_ICON_1']                        = 'Menü ikon lebegéskor';
$TEXT['MENU_TITLE']                         = 'Menü címe';
$TEXT['MESSAGE']                            = 'Üzenet';
$TEXT['MODIFY']                             = 'Módosítás';
$TEXT['MODIFY_CONTENT']                     = 'Tartalom módosítása';
$TEXT['MODIFY_SETTINGS']                    = 'Beállítások módosítása';
$TEXT['MODULE_ORDER']                       = 'Modulok sorrendje kereséshez';
$TEXT['MODULE_PERMISSIONS']                 = 'Modul jogosultságok';
$TEXT['MORE']                               = 'Több';
$TEXT['MOVE_DOWN']                          = 'Mozgatás le';
$TEXT['MOVE_UP']                            = 'Mozgatás fel';
$TEXT['MULTILINGUAL']                       = 'TÖBBNYELVŰ';
$TEXT['MULTIPLE_MENUS']                     = 'Több menü';
$TEXT['MULTISELECT']                        = 'Többszörös kijelölés';
$TEXT['NAME']                               = 'Név';
$TEXT['NEED_CURRENT_PASSWORD']              = 'megerősítés a jelenlegi jelszóval';
$TEXT['NEED_TO_LOGIN']                      = 'Be kell jelentkezni?';
$TEXT['NEW_PASSWORD']                       = 'Új jelszó';
$TEXT['NEW_WINDOW']                         = 'Új ablak';
$TEXT['NEXT']                               = 'Következő';
$TEXT['NEXT_PAGE']                          = 'Következő oldal';
$TEXT['NO']                                 = 'Nem';
$TEXT['NONE']                               = 'Nincs';
$TEXT['NONE_FOUND']                         = 'Nincs találat';
$TEXT['NOT_FOUND']                          = 'Nem található';
$TEXT['NOT_INSTALLED']                      = 'nincs telepítve';
$TEXT['NO_IMAGE_SELECTED']                  = 'nincs kép kiválasztva';
$TEXT['NO_RESULTS']                         = 'Nincs találat';
$TEXT['NO_SELECTION']                       = 'nincs kijelölés';
$TEXT['OF']                                 = '-ból/-ből';
$TEXT['ON']                                 = 'bekapcsolva';
$TEXT['OPEN']                               = 'Megnyitás';
$TEXT['OPTION']                             = 'Opció';
$TEXT['OTHERS']                             = 'Egyéb';
$TEXT['OUT_OF']                             = 'Ki a(z)';
$TEXT['OVERWRITE_EXISTING']                 = 'Meglévők felülírása';
$TEXT['PAGE']                               = 'Oldal';
$TEXT['PAGES_DIRECTORY']                    = 'Oldalak könyvtára';
$TEXT['PAGES_PERMISSION']                   = 'Oldalak engedélye';
$TEXT['PAGES_PERMISSIONS']                  = 'Oldalak engedélyei';
$TEXT['PAGE_EXTENSION']                     = 'Oldal kiterjesztés';
$TEXT['PAGE_ICON']                          = 'Oldal ikon';
$TEXT['PAGE_ICON_DIR']                      = 'Oldalak/menü képek útvonala';
$TEXT['PAGE_LANGUAGES']                     = 'Oldal nyelvek';
$TEXT['PAGE_LEVEL_LIMIT']                   = 'Oldalszint korlát';
$TEXT['PAGE_SPACER']                        = 'Oldal elválasztó';
$TEXT['PAGE_TITLE']                         = 'Oldal címe';
$TEXT['PAGE_TRASH']                         = 'Oldal kuka';
$TEXT['PARENT']                             = 'Szülő';
$TEXT['PASSWORD']                           = 'Jelszó';
$TEXT['PATH']                               = 'Útvonal';
$TEXT['PHP_ERROR_LEVEL']                    = 'PHP hiba jelentési szint';
$TEXT['PLEASE_LOGIN']                       = 'Kérjük, jelentkezzen be';
$TEXT['PLEASE_SELECT']                      = 'Kérjük, válasszon';
$TEXT['POST']                               = 'Bejegyzés';
$TEXT['POSTS_PER_PAGE']                     = 'Bejegyzés oldalanként';
$TEXT['POST_FOOTER']                        = 'Bejegyzés lábléce';
$TEXT['POST_HEADER']                        = 'Bejegyzés fejléce';
$TEXT['PREVIOUS']                           = 'Előző';
$TEXT['PREVIOUS_PAGE']                      = 'Előző oldal';
$TEXT['PRIVATE']                            = 'Privát';
$TEXT['PRIVATE_VIEWERS']                    = 'Privát nézők';
$TEXT['PROFILES_EDIT']                      = 'Profil módosítása';
$TEXT['PUBLIC']                             = 'Nyilvános';
$TEXT['PUBL_END_DATE']                      = 'Befejezés dátuma';
$TEXT['PUBL_START_DATE']                    = 'Kezdés dátuma';
$TEXT['RADIO_BUTTON_GROUP']                 = 'Rádió gomb csoport';
$TEXT['READ']                               = 'Olvasás';
$TEXT['READ_MORE']                          = 'Tovább';
$TEXT['REDIRECT_AFTER']                     = 'Átirányítás ennyi idő után';
$TEXT['REGISTERED']                         = 'Regisztrált';
$TEXT['REGISTERED_VIEWERS']                 = 'Regisztrált nézők';
$TEXT['RELOAD']                             = 'Újratöltés';
$TEXT['REMEMBER_ME']                        = 'Emlékezz rám';
$TEXT['RENAME']                             = 'Átnevezés';
$TEXT['RENAME_FILES_ON_UPLOAD']             = 'Nincs feltöltés ezekre a fájltípusokra';
$TEXT['REQUIRED']                           = 'Kötelező';
$TEXT['REQUIREMENT']                        = 'Követelmény';
$TEXT['RESET']                              = 'Visszaállítás';
$TEXT['RESIZE']                             = 'Átméretezés';
$TEXT['RESIZE_IMAGE_TO']                    = 'Kép átméretezése ide';
$TEXT['REFILL']                             = 'Bevitel visszaállítása';
$TEXT['RESTORE']                            = 'Bevitel visszaállítása';
$TEXT['RESTORE_DATABASE']                   = 'Adatbázis visszaállítása';
$TEXT['RESTORE_MEDIA']                      = 'Média visszaállítása';
$TEXT['RESULTS']                            = 'Eredmények';
$TEXT['RESULTS_FOOTER']                     = 'Eredmények lábléce';
$TEXT['RESULTS_FOR']                        = 'Eredmények a(z)';
$TEXT['RESULTS_HEADER']                     = 'Eredmények fejléce';
$TEXT['RESULTS_LOOP']                       = 'Eredmények ciklus';
$TEXT['RETYPE_NEW_PASSWORD']                = 'Új jelszó ismétlése';
$TEXT['RETYPE_PASSWORD']                    = 'Jelszó ismétlése';
$TEXT['SAME_WINDOW']                        = 'Azonos ablak';
$TEXT['SAVE']                               = 'Mentés';
$TEXT['SEARCH']                             = 'Keresés';
$TEXT['SEARCHING']                          = 'Keresés...';
$TEXT['SECTION']                            = 'Szekció';
$TEXT['SECTION_BLOCKS']                     = 'Szekció blokkok';
$TEXT['SEC_ANCHOR']                         = 'Szekció horgony szöveg';
$TEXT['SELECT_BOX']                         = 'Választó doboz';
$TEXT['SEND_DETAILS']                       = 'Adatok küldése';
$TEXT['SEPARATE']                           = 'Külön';
$TEXT['SEPERATOR']                          = 'Elválasztó';
$TEXT['SERVER_EMAIL']                       = 'Szerver e-mail címe';
$TEXT['SERVER_OPERATING_SYSTEM']            = 'Szerver operációs rendszer';
$TEXT['SESSION_IDENTIFIER']                 = 'Munkamenet azonosító';
$TEXT['SETTINGS']                           = 'Beállítások';
$TEXT['SHORT']                              = 'Rövid';
$TEXT['SHORT_TEXT']                         = 'Rövid szöveg';
$TEXT['SHOW']                               = 'Megjelenítés';
$TEXT['SHOW_ADVANCED']                      = 'Haladó beállítások megjelenítése';
$TEXT['SIGNUP']                             = 'Regisztráció';
$TEXT['SIZE']                               = 'Méret';
$TEXT['SMART_LOGIN']                        = 'Intelligens bejelentkezés';
$TEXT['START']                              = 'Start';
$TEXT['START_PUBLISHING']                   = 'Közzététel megkezdése';
$TEXT['SUBJECT']                            = 'Tárgy';
$TEXT['SUBMISSIONS']                        = 'Beküldések';
$TEXT['SUBMISSIONS_STORED_IN_DATABASE']     = 'Beküldések adatbázisban tárolva';
$TEXT['SUBMISSION_ID']                      = 'Beküldés azonosítója';
$TEXT['SUBMITTED']                          = 'Beküldve';
$TEXT['SUCCESS']                            = 'Siker';
$TEXT['SYSTEM_DEFAULT']                     = 'Rendszer alapértelmezett';
$TEXT['SYSTEM_PERMISSIONS']                 = 'Rendszerjogosultságok';
$TEXT['TABLE_PREFIX']                       = 'Táblaelőtag';
$TEXT['TARGET']                             = 'Cél';
$TEXT['TARGET_FOLDER']                      = 'Célmappa';
$TEXT['TEMPLATE']                           = 'Sablon';
$TEXT['TEMPLATE_PERMISSIONS']               = 'Sablon jogosultságok';
$TEXT['TEXT']                               = 'Szöveg';
$TEXT['TEXTAREA']                           = 'Szövegmező';
$TEXT['TEXTFIELD']                          = 'Szövegmező';
$TEXT['THEME']                              = 'Backend téma';
$TEXT['THEME_COPY_CURRENT']                 = 'Backend téma másolása.';
$TEXT['THEME_CURRENT']                      = 'jelenlegi aktív téma';
$TEXT['THEME_IMPORT_HTT']                   = 'További sablonok importálása';
$TEXT['THEME_NEW_NAME']                     = 'Az új téma neve';
$TEXT['THEME_NOMORE_HTT']                   = 'nincs több elérhető';
$TEXT['THEME_SELECT_HTT']                   = 'sablonok kiválasztása';
$TEXT['THEME_START_COPY']                   = 'másolás';
$TEXT['THEME_START_IMPORT']                 = 'importálás';
$TEXT['TIME']                               = 'Idő';
$TEXT['TIMEZONE']                           = 'Időzóna';
$TEXT['TIME_FORMAT']                        = 'Időformátum';
$TEXT['TIME_LIMIT']                         = 'Max. idő a kivonatok gyűjtésére modulonként';
$TEXT['TITLE']                              = 'Cím';
$TEXT['TO']                                 = 'Címzett';
$TEXT['TOP_FRAME']                          = 'Felső keret';
$TEXT['TRASH_EMPTIED']                      = 'Kuka kiürítve';
$TEXT['TXT_EDIT_CSS_FILE']                  = 'Szerkessze a CSS definíciókat az alábbi szövegmezőben.';
$TEXT['TYPE']                               = 'Típus';
$TEXT['UNDER_CONSTRUCTION']                 = 'Karbantartás alatt';
$TEXT['UNINSTALL']                          = 'Eltávolítás';
$TEXT['UNKNOWN']                            = 'Ismeretlen';
$TEXT['UNLIMITED']                          = 'Korlátlan';
$TEXT['UNZIP_FILE']                         = 'Zip archívum feltöltése és kicsomagolása';
$TEXT['UP']                                 = 'Fel';
$TEXT['UPGRADE']                            = 'Frissítés';
$TEXT['UPLOAD_FILES']                       = 'Fájl(ok) feltöltése';
$TEXT['URL']                                = 'URL';
$TEXT['USER']                               = 'Felhasználó';
$TEXT['USERNAME']                           = 'Felhasználónév';
$TEXT['USERS_ACTIVE']                       = 'Felhasználó aktív';
$TEXT['USERS_CAN_SELFDELETE']               = 'Felhasználó törölheti saját magát';
$TEXT['USERS_CHANGE_SETTINGS']              = 'Felhasználó módosíthatja saját beállításait';
$TEXT['USERS_DELETED']                      = 'Felhasználó töröltként megjelölve';
$TEXT['USERS_FLAGS']                        = 'Felhasználói jelölők';
$TEXT['USERS_PROFILE_ALLOWED']              = 'Felhasználó létrehozhat kiterjesztett profilt';
$TEXT['VERIFICATION']                       = 'Ellenőrzés';
$TEXT['VERSION']                            = 'Verzió';
$TEXT['VIEW']                               = 'Nézet';
$TEXT['VIEW_DELETED_PAGES']                 = 'Törölt oldalak megtekintése';
$TEXT['VIEW_DETAILS']                       = 'Részletek megtekintése';
$TEXT['VISIBILITY']                         = 'Láthatóság';
$TEXT['WBMAILER_DEFAULT_SENDER_MAIL']       = 'Alapértelmezett "Feladó" cím';
$TEXT['WBMAILER_DEFAULT_SENDER_NAME']       = 'Alapértelmezett feladó neve';
$TEXT['WBMAILER_DEFAULT_SETTINGS_NOTICE']   = 'Kérjük, adja meg az alapértelmezett "FROM" címet és "SENDER" nevet alább. Javasolt a FROM cím használata, mint pl.: <strong>admin@azöndoménje.com</strong>. Néhány levelező szolgáltató (pl. <em>mail.com</em>) elutasíthatja az olyan FROM: címmel rendelkező leveleket, mint <em>név@mail.com</em>, amelyeket külföldi relé keresztül küldtek, a spam elkerülése érdekében.<br /><br />Az alapértelmezett értékek csak akkor használatosak, ha a WebsiteBaker nem ad meg más értékeket. Ha szervere támogatja az <abbr title="Simple mail transfer protocol">SMTP</abbr>-t, akkor érdemes ezt az opciót használni a kimenő levelezéshez.';
$TEXT['WBMAILER_FUNCTION']                  = 'E-mail küldő rutin';
$TEXT['WBMAILER_NOTICE']                    = '<strong>SMTP levelező beállítások:</strong><br />Az alábbi beállítások csak akkor szükségesek, ha <abbr title="Simple mail transfer protocol">SMTP</abbr> protokollon keresztül szeretne levelet küldeni. Ha nem ismeri az SMTP hostját, vagy bizonytalan a szükséges beállításokban, egyszerűen maradjon az alapértelmezett levelező rutinnál: PHP MAIL.';
$TEXT['WBMAILER_PHP']                       = 'PHP MAIL';
$TEXT['WBMAILER_SMTP']                      = 'SMTP';
$TEXT['WBMAILER_SMTP_AUTH']                 = 'SMTP hitelesítés';
$TEXT['WBMAILER_SMTP_AUTH_NOTICE']          = 'csak akkor aktiválja, ha az SMTP host hitelesítést igényel';
$TEXT['WBMAILER_SMTP_HOST']                 = 'SMTP Host';
$TEXT['WBMAILER_SMTP_PASSWORD']             = 'SMTP jelszó';
$TEXT['WBMAILER_SMTP_USERNAME']             = 'SMTP felhasználónév';
$TEXT['WEBSITE']                            = 'Webhely';
$TEXT['WEBSITE_DESCRIPTION']                = 'Metaadat leírás';
$TEXT['WEBSITE_FOOTER']                     = 'Webhely lábléc';
$TEXT['WEBSITE_HEADER']                     = 'Webhely fejléc';
$TEXT['WEBSITE_KEYWORDS']                   = 'Metaadat kulcsszavak';
$TEXT['WEBSITE_TITLE']                      = 'Metaadat cím';
$TEXT['WELCOME_BACK']                       = 'Üdvözöljük újra';
$TEXT['WIDTH']                              = 'Szélesség';
$TEXT['WINDOW']                             = 'Ablak';
$TEXT['WINDOWS']                            = 'Windows';
$TEXT['WORLD_WRITEABLE_FILE_PERMISSIONS']   = 'Világ számára írható fájl jogosultságok';
$TEXT['WRITE']                              = 'Írás';
$TEXT['WYSIWYG_EDITOR']                     = 'WYSIWYG szerkesztő';
$TEXT['WYSIWYG_STYLE']                      = 'WYSIWYG stílus';
$TEXT['YES']                                = 'Igen';

$TEXT['NO_REVERT'] = 'Ezt nem vonhatja vissza!';
$TEXT['NO_DELETED'] = 'A törlés nem történt meg!';
$TEXT['PAGE_CODE'] = 'Oldalkód';

