<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of \languages\ES
 * @package          CoreTranslation
 * @copyright        Manuela v.d.Decken <manuela@isteam.de>
 * @author          $Author: Uwe $
 * @license         GNU General Public License 2.0
 * @version         4.0.3
 * @revision        $Revision: 63 $
 * @since           $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @lastmodified    $Date: 2025-09-01 12:08:14 +0200 (Mo, 01 Sep 2025) $
 * @deprecated      no
 * @description     CoreTranslation
 * @svn-id          $Header: file:///G:/SVN_Projekte/WB_Entwicklung/branches/patch-2.13.9-hotfix/languages/ES.php 63 2025-09-01 10:08:14Z Uwe $
 */

//declare(strict_types = 1);

//declare(encoding = 'UTF-8');

if (!\defined('SYSTEM_RUN')) {\header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found'); echo '404 Not Found'; \flush(); exit;}
// Define that this file is loaded
if (!defined('LANGUAGE_LOADED')) { define('LANGUAGE_LOADED', true); }

// Set the language information
$language_code = 'ES';
$language_name = 'Español';
$language_version = '4.0.3';
$language_platform = '2.11.0';
$language_author = 'Jacobi22';// All translations by Google AI
$language_license = 'GNU General Public License 2.0';

$HEADING['ADDON_PRECHECK_FAILED']            = 'Requisitos del Add-On no cumplidos';
$HEADING['ADD_CHILD_PAGE']                   = 'Añadir subpágina';
$HEADING['ADD_GROUP']                        = 'Añadir Grupo';
$HEADING['ADD_GROUPS']                       = 'Añadir Grupos';
$HEADING['ADD_HEADING']                      = 'Añadir Encabezado';
$HEADING['ADD_PAGE']                         = 'Añadir Página';
$HEADING['ADD_USER']                         = 'Añadir Usuario';
$HEADING['ADMINISTRATION_TOOLS']             = 'Herramientas de Administración';
$HEADING['BROWSE_MEDIA']                     = 'Explorar Medios';
$HEADING['CREATE_FOLDER']                    = 'Crear Carpeta';
$HEADING['DEFAULT_SETTINGS']                 = 'Configuración Predeterminada';
$HEADING['DELETED_PAGES']                    = 'Páginas Eliminadas';
$HEADING['FILESYSTEM_SETTINGS']              = 'Configuración del Sistema de Archivos';
$HEADING['GENERAL_SETTINGS']                 = 'Configuración General';
$HEADING['INSTALL_LANGUAGE']                 = 'Instalar Idioma';
$HEADING['INSTALL_MODULE']                   = 'Instalar Módulo';
$HEADING['INSTALL_TEMPLATE']                 = 'Instalar Plantilla';
$HEADING['INVOKE_LANGUAGE_FILES']            = 'Ejecutar archivos de idioma manualmente';
$HEADING['INVOKE_MODULE_FILES']              = 'Ejecutar archivos de módulo manualmente';
$HEADING['INVOKE_TEMPLATE_FILES']            = 'Ejecutar archivos de plantilla manualmente';
$HEADING['LANGUAGE_DETAILS']                 = 'Detalles del Idioma';
$HEADING['MANAGE_SECTIONS']                  = 'Gestionar Secciones';
$HEADING['MODIFY_ADVANCED_PAGE_SETTINGS']    = 'Modificar Configuración Avanzada de la Página';
$HEADING['MODIFY_DELETE_GROUP']              = 'Modificar/Eliminar Grupo';
$HEADING['MODIFY_DELETE_PAGE']               = 'Modificar/Eliminar Página';
$HEADING['MODIFY_DELETE_USER']               = 'Modificar/Eliminar Usuario';
$HEADING['MODIFY_GROUP']                     = 'Modificar Grupo';
$HEADING['MODIFY_GROUPS']                    = 'Modificar Grupos';
$HEADING['MODIFY_INTRO_PAGE']                = 'Modificar Página de Introducción';
$HEADING['MODIFY_PAGE']                      = 'Modificar Página';
$HEADING['MODIFY_PAGE_SETTINGS']             = 'Modificar Configuración de Página';
$HEADING['MODIFY_USER']                      = 'Modificar Usuario';
$HEADING['MODULE_DETAILS']                   = 'Detalles del Módulo';
$HEADING['MY_EMAIL']                         = 'Mi Correo Electrónico';
$HEADING['MY_PASSWORD']                      = 'Mi Contraseña';
$HEADING['MY_SETTINGS']                      = 'Mi Configuración';
$HEADING['SEARCH_SETTINGS']                  = 'Configuración de Búsqueda';
$HEADING['SERVER_SETTINGS']                  = 'Configuración del Servidor';
$HEADING['TEMPLATE_DETAILS']                 = 'Detalles de la Plantilla';
$HEADING['UNINSTALL_LANGUAGE']               = 'Desinstalar Idioma';
$HEADING['UNINSTALL_MODULE']                 = 'Desinstalar Módulo';
$HEADING['UNINSTALL_TEMPLATE']               = 'Desinstalar Plantilla';
$HEADING['UPGRADE_LANGUAGE']                 = 'Registro/Actualización de Idioma';
$HEADING['UPLOAD_FILES']                     = 'Subir Archivo(s)';
$HEADING['WBMAILER_SETTINGS']                = 'Configuración de Correo';
$MENU['ACCESS']                             = 'Gestión de usuarios';
$MENU['ADDON']                              = 'Add-on';
$MENU['ADDONS']                             = 'Add-ons';
$MENU['ADMINTOOLS']                         = 'Herramientas de Administración';
$MENU['BREADCRUMB']                         = 'Usted está aquí: ';
$MENU['FORGOT']                             = 'Recuperar Detalles de Inicio de Sesión';
$MENU['GROUP']                              = 'Grupo';
$MENU['GROUPS']                             = 'Grupos';
$MENU['HELP']                               = 'Ayuda';
$MENU['LANGUAGES']                          = 'Idiomas';
$MENU['LOGIN']                              = 'Iniciar Sesión';
$MENU['LOGOUT']                             = 'Cerrar Sesión';
$MENU['MEDIA']                              = 'Medios';
$MENU['MODULES']                            = 'Módulos';
$MENU['MY_PROFILE']                         = 'Mi Perfil';
$MENU['PAGES']                              = 'Páginas';
$MENU['PREFERENCES']                        = 'Preferencias';
$MENU['REORG_TABLE']                        = 'Reorganizar tablas';
$MENU['SETTINGS']                           = 'Configuración';
$MENU['START']                              = 'Inicio';
$MENU['TEMPLATES']                          = 'Plantillas';
$MENU['USERS']                              = 'Usuarios';
$MENU['VIEW']                               = 'Ver';
$MESSAGE['ADDON_ERROR_RELOAD']               = 'Error al actualizar la información del Add-On.';
$MESSAGE['ADDON_LANGUAGES_RELOADED']         = 'Idiomas recargados correctamente';
$MESSAGE['ADDON_MANUAL_FTP_LANGUAGE']        = '<strong>¡ATENCIÓN!</strong> Por razones de seguridad, solo transfiera archivos de idioma vía FTP a la carpeta /languages/ y use la función de Actualizar para registrar o actualizar.';
$MESSAGE['ADDON_MANUAL_FTP_WARNING']         = 'Advertencia: Las entradas existentes en la base de datos del módulo se perderán. ';
$MESSAGE['ADDON_MANUAL_INSTALLATION']        = 'Cuando los módulos se suben vía FTP (no recomendado), las funciones de instalación del módulo <code>install</code>, <code>upgrade</code> o <code>uninstall</code> no se ejecutarán automáticamente. Estos módulos podrían no funcionar correctamente o desinstalarse apropiadamente.<br /><br />Puede ejecutar las funciones del módulo manualmente para los módulos subidos vía FTP a continuación.';
$MESSAGE['ADDON_MANUAL_INSTALLATION_WARNING']= 'Advertencia: Las entradas existentes en la base de datos del módulo se perderán. Use esta opción solo si experimenta problemas con módulos subidos vía FTP.';
$MESSAGE['ADDON_MANUAL_RELOAD_WARNING']      = 'Advertencia: Las entradas existentes en la base de datos del módulo se perderán. ';
$MESSAGE['ADDON_MODULES_RELOADED']           = 'Módulos recargados correctamente';
$MESSAGE['ADDON_OVERWRITE_NEWER_FILES']      = 'Sobreescribir Archivos Más Recientes';
$MESSAGE['ADDON_PRECHECK_FAILED']            = 'La instalación del add-on falló. Su sistema no cumple los requisitos de este add-on. Para que este add-on funcione en su sistema, por favor, corrija los problemas resumidos a continuación.';
$MESSAGE['ADDON_RELOAD']                     = 'Actualizar la base de datos con información de los archivos del Add-on (por ejemplo, después de la subida por FTP).';
$MESSAGE['ADDON_TEMPLATES_RELOADED']         = 'Plantillas recargadas correctamente';
$MESSAGE['ADMIN_INSUFFICIENT_PRIVELLIGES']   = 'Privilegios de acceso insuficientes';
$MESSAGE['FORGOT_PASS_ALREADY_RESET']        = 'La Contraseña solo se puede restablecer una vez por hora';
$MESSAGE['FORGOT_PASS_CANNOT_EMAIL']         = 'No se puede enviar la contraseña por correo electrónico, póngase en contacto con el administrador del sistema';
$MESSAGE['FORGOT_PASS_EMAIL_NOT_FOUND']      = 'El correo electrónico que ha introducido no se encuentra en la base de datos';
$MESSAGE['FORGOT_PASS_NO_DATA']              = 'Por favor, introduzca su dirección de correo electrónico a continuación';
$MESSAGE['FORGOT_PASS_PASSWORD_RESET']       = 'Su contraseña ha sido enviada a su dirección de correo electrónico';
$MESSAGE['FRONTEND_SORRY_NO_ACTIVE_SECTIONS']= 'Lo sentimos, no hay contenido activo para mostrar';
$MESSAGE['FRONTEND_SORRY_NO_VIEWING_PERMISSIONS'] = 'Lo sentimos, no tiene permiso para ver esta página';
$MESSAGE['GENERIC_ALREADY_INSTALLED']        = 'Ya instalado';
$MESSAGE['GENERIC_BAD_PERMISSIONS']          = 'No se puede escribir en el directorio de destino';
$MESSAGE['GENERIC_BE_PATIENT']               = 'Por favor, tenga paciencia.';
$MESSAGE['GENERIC_CANNOT_UNINSTALL']         = 'No se puede desinstalar';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE']  = 'No se puede desinstalar: el archivo seleccionado está en uso';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL'] = '<br /><br />{{type}} <b>{{type_name}}</b> no pudo ser desinstalado, porque todavía está en uso en {{pages}}.<br /><br />';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IN_USE_TMPL_PAGES'] = 'esta página;estas páginas';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_TEMPLATE'] = 'No se puede desinstalar la plantilla <b>{{name}}</b>, ¡porque es la plantilla predeterminada!';
$MESSAGE['GENERIC_CANNOT_UNINSTALL_IS_DEFAULT_THEME'] = 'No se puede desinstalar la plantilla <b>{{name}}</b>, ¡porque es el tema de backend predeterminado!';
$MESSAGE['GENERIC_CANNOT_UNZIP']             = 'No se puede descomprimir el archivo';
$MESSAGE['GENERIC_CANNOT_UPLOAD']            = 'No se puede subir el archivo';
$MESSAGE['GENERIC_COMPARE']                  = ' correcto';
$MESSAGE['GENERIC_ERROR_OPENING_FILE']       = 'Error al abrir el archivo.';
$MESSAGE['GENERIC_FAILED_COMPARE']           = ' falló';
$MESSAGE['GENERIC_FILE_TYPE']                = 'Tenga en cuenta que el archivo que suba debe tener el siguiente formato:';
$MESSAGE['GENERIC_FILE_TYPES']               = 'Tenga en cuenta que el archivo que suba debe tener uno de los siguientes formatos:';
$MESSAGE['GENERIC_FILL_IN_ALL']              = 'Por favor, vuelva atrás y rellene todos los campos';
$MESSAGE['GENERIC_FORGOT_OPTIONS']           = 'No ha realizado una selección!';
$MESSAGE['GENERIC_INSTALLED']                = 'Instalado correctamente';
$MESSAGE['GENERIC_INVALID']                  = 'El archivo que ha subido no es válido';
$MESSAGE['GENERIC_INVALID_ADDON_FILE']       = 'Archivo de instalación de WebsiteBaker no válido. Por favor, verifique el formato *.zip.';
$MESSAGE['GENERIC_INVALID_LANGUAGE_FILE']    = 'Archivo de idioma de WebsiteBaker no válido. Por favor, verifique el archivo de texto.';
$MESSAGE['GENERIC_INVALID_MODULE_FILE']      = 'Archivo de módulo de WebsiteBaker no válido. Por favor, verifique el archivo de texto.';
$MESSAGE['GENERIC_INVALID_TEMPLATE_FILE']    = 'Archivo de plantilla de WebsiteBaker no válido. Por favor, verifique el archivo de texto.';
$MESSAGE['GENERIC_IN_USE']                   = ' pero usado en ';
$MESSAGE['GENERIC_MISSING_ARCHIVE_FILE']     = '¡Falta el archivo de archivo!';
$MESSAGE['GENERIC_MODULE_VERSION_ERROR']     = '¡El módulo %s no está instalado correctamente!';
$MESSAGE['GENERIC_NOT_COMPARE']              = ' no es posible';
$MESSAGE['GENERIC_NOT_INSTALLED']            = 'No instalado';
$MESSAGE['GENERIC_NOT_UPGRADED']             = 'Actualización no posible';
$MESSAGE['GENERIC_PLEASE_BE_PATIENT']        = 'Por favor, tenga paciencia, esto podría llevar un tiempo.';
$MESSAGE['GENERIC_PLEASE_CHECK_BACK_SOON']   = 'Por favor, vuelva pronto...';
$MESSAGE['GENERIC_SECURITY_ACCESS']          = '¡¡Infracción de seguridad!! ¡Acceso denegado!';
$MESSAGE['GENERIC_SECURITY_OFFENSE']         = '¡¡Infracción de seguridad!! ¡El almacenamiento de datos fue rechazado!';
$MESSAGE['GENERIC_UNINSTALLED']              = 'Desinstalado correctamente';
$MESSAGE['GENERIC_UPGRADED']                 = 'Actualizado correctamente';
$MESSAGE['GENERIC_VERSION_COMPARE']          = 'Comparación de versiones';
$MESSAGE['GENERIC_VERSION_GT']               = '¡Actualización necesaria!';
$MESSAGE['GENERIC_VERSION_LT']               = 'Downgrade';
$MESSAGE['GENERIC_WEBSITE_LOCKED']           = 'este sitio está temporalmente fuera de servicio por mantenimiento';
$MESSAGE['GENERIC_WEBSITE_UNDER_CONSTRUCTION'] = 'Sitio Web en Construcción';
$MESSAGE['GENERIC_WEBSITE_NO_PAGES']         = 'Este sitio web para este idioma (%s) todavía está en construcción';
$MESSAGE['GROUPS_ADDED']                     = 'Grupo añadido correctamente';
$MESSAGE['GROUPS_CONFIRM_DELETE']            = '¿Está seguro de que desea eliminar el grupo seleccionado (y los usuarios que pertenecen a él)?';
$MESSAGE['GROUPS_DELETED']                   = 'Grupo eliminado correctamente';
$MESSAGE['GROUPS_GROUP_NAME_BLANK']          = 'El nombre del grupo está en blanco';
$MESSAGE['GROUPS_GROUP_NAME_EXISTS']         = 'El nombre del grupo ya existe';
$MESSAGE['GROUPS_NO_GROUPS_FOUND']           = 'No se encontraron grupos';
$MESSAGE['GROUPS_SAVED']                     = 'Grupo guardado correctamente';
$MESSAGE['LOGIN_AUTHENTICATION_FAILED']      = 'Nombre de usuario o contraseña incorrectos';
$MESSAGE['LOGIN_BOTH_BLANK']                 = 'Por favor, introduzca su nombre de usuario y contraseña';
$MESSAGE['LOGIN_PASSWORD_BLANK']             = 'Por favor, introduzca una contraseña';
$MESSAGE['LOGIN_PASSWORD_TOO_LONG']          = 'Contraseña proporcionada demasiado larga';
$MESSAGE['LOGIN_PASSWORD_TOO_SHORT']         = 'Contraseña proporcionada demasiado corta';
$MESSAGE['LOGIN_USERNAME_BLANK']             = 'Por favor, introduzca un nombre de usuario';
$MESSAGE['LOGIN_USERNAME_TOO_LONG']          = 'Nombre de usuario proporcionado demasiado largo';
$MESSAGE['LOGIN_USERNAME_TOO_SHORT']         = 'Nombre de usuario proporcionado demasiado corto';
$MESSAGE['MEDIA_BLANK_EXTENSION']            = 'No ha introducido una extensión de archivo';
$MESSAGE['MEDIA_BLANK_NAME']                 = 'No ha introducido un nuevo nombre';
$MESSAGE['MEDIA_CANNOT_DELETE_DIR']          = 'No se puede eliminar la carpeta seleccionada';
$MESSAGE['MEDIA_CANNOT_DELETE_FILE']         = 'No se puede eliminar el archivo seleccionado';
$MESSAGE['MEDIA_CANNOT_RENAME']              = 'Renombrado sin éxito';
$MESSAGE['MEDIA_CONFIRM_DELETE']             = '¿Está seguro de que desea eliminar el siguiente archivo o carpeta?';
$MESSAGE['MEDIA_DELETED_DIR']                = 'Carpeta eliminada correctamente';
$MESSAGE['MEDIA_DELETED_FILE']               = 'Archivo eliminado correctamente';
$MESSAGE['MEDIA_DIR_ACCESS_DENIED']          = 'El directorio especificado no existe o no está permitido.';
$MESSAGE['MEDIA_DIR_DOES_NOT_EXIST']         = 'El directorio no existe';
$MESSAGE['MEDIA_DIR_DOT_DOT_SLASH']          = 'No se puede incluir ../ en el nombre de la carpeta';
$MESSAGE['MEDIA_DIR_EXISTS']                 = 'Ya existe una carpeta con el nombre que ha introducido';
$MESSAGE['MEDIA_DIR_MADE']                   = 'Carpeta creada correctamente';
$MESSAGE['MEDIA_DIR_NOT_MADE']               = 'No se puede crear la carpeta';
$MESSAGE['MEDIA_FILE_EXISTS']                = 'Ya existe un archivo con el nombre que ha introducido';
$MESSAGE['MEDIA_FILE_NOT_FOUND']             = 'Archivo no encontrado';
$MESSAGE['MEDIA_NAME_DOT_DOT_SLASH']         = 'No se puede incluir ../ en el nombre';
$MESSAGE['MEDIA_NAME_INDEX_PHP']             = 'No se puede usar index.php como nombre';
$MESSAGE['MEDIA_NONE_FOUND']                 = 'No se encontraron medios en la carpeta actual';
$MESSAGE['MEDIA_NO_FILE_UPLOADED']           = 'No se recibió ningún archivo';
$MESSAGE['MEDIA_RENAMED']                    = 'Renombrado correctamente';
$MESSAGE['MEDIA_SINGLE_UPLOADED']            = ' archivo se cargó correctamente';
$MESSAGE['MEDIA_TARGET_DOT_DOT_SLASH']       = 'No se puede tener ../ en la carpeta de destino';
$MESSAGE['MEDIA_UPLOADED']                   = ' archivos se cargaron correctamente';
$MESSAGE['MOD_FORM_EXCESS_SUBMISSIONS']      = 'Lo sentimos, este formulario se ha enviado demasiadas veces esta hora. Por favor, inténtelo de nuevo en la próxima hora.';
$MESSAGE['MOD_FORM_INCORRECT_CAPTCHA']       = 'El número de verificación (también conocido como Captcha) que ha introducido es incorrecto. Si tiene problemas para leer el Captcha, envíe un correo electrónico a: <a href="mailto:{{SERVER_EMAIL}}">{{SERVER_EMAIL}}</a>';
$MESSAGE['MOD_FORM_REQUIRED_FIELDS']         = 'Debe introducir detalles para los siguientes campos';
$MESSAGE['PAGES_ADDED']                      = 'Página añadida correctamente';
$MESSAGE['PAGES_ADDED_HEADING']              = 'Título de página añadido correctamente';
$MESSAGE['PAGES_BLANK_MENU_TITLE']           = 'Por favor, introduzca un título de menú';
$MESSAGE['PAGES_BLANK_PAGE_TITLE']           = 'Por favor, introduzca un título de página';
$MESSAGE['PAGES_CANNOT_CREATE_ACCESS_FILE']  = 'Error al crear el archivo de acceso en el directorio /pages (privilegios insuficientes)';
$MESSAGE['PAGES_CANNOT_DELETE_ACCESS_FILE']  = 'Error al eliminar el archivo de acceso en el directorio /pages (privilegios insuficientes)';
$MESSAGE['PAGES_CANNOT_REORDER']             = 'Error al reordenar la página';
$MESSAGE['PAGES_DELETED']                    = 'Página eliminada correctamente';
$MESSAGE['PAGES_DELETE_CONFIRM']             = '¿Está seguro de que desea eliminar la página seleccionada (y todas sus subpáginas)?';
$MESSAGE['PAGES_INSUFFICIENT_PERMISSIONS']   = 'No tiene permiso para modificar esta página';
$MESSAGE['PAGES_INTRO_LINK']                 = 'Haga clic AQUÍ para modificar la página de introducción';
$MESSAGE['PAGES_INTRO_NOT_WRITABLE']         = 'No se puede escribir en el archivo /pages/intro.php (privilegios insuficientes)';
$MESSAGE['PAGES_INTRO_SAVED']                = 'Página de introducción guardada correctamente';
$MESSAGE['PAGES_LAST_MODIFIED']              = 'Última modificación por';
$MESSAGE['PAGES_NOT_FOUND']                  = 'Página no encontrada';
$MESSAGE['PAGES_NOT_SAVED']                  = 'Error al guardar la página';
$MESSAGE['PAGES_PAGE_EXISTS']                = 'Ya existe una página con el mismo o similar título';
$MESSAGE['PAGES_REORDERED']                  = 'Página reordenada correctamente';
$MESSAGE['PAGES_RESTORED']                   = 'Página restaurada correctamente';
$MESSAGE['PAGES_RETURN_TO_PAGES']            = 'Volver a las páginas';
$MESSAGE['PAGES_SAVED']                      = 'Página guardada correctamente';
$MESSAGE['PAGES_SAVED_SETTINGS']             = 'Configuración de página guardada correctamente';
$MESSAGE['PAGES_SECTIONS_PROPERTIES_SAVED']  = 'Propiedades de la sección guardadas correctamente';
$MESSAGE['PAGE_MODIFIED']                    = 'La página fue modificada el %s por %s';
$MESSAGE['PREFERENCES_CURRENT_PASSWORD_INCORRECT'] = 'La contraseña (actual) que ha introducido es incorrecta';
$MESSAGE['PREFERENCES_DETAILS_SAVED']        = 'Detalles guardados correctamente';
$MESSAGE['PREFERENCES_EMAIL_UPDATED']        = 'Correo electrónico actualizado correctamente';
$MESSAGE['PREFERENCES_INVALID_CHARS']        = 'Se usaron caracteres de contraseña no válidos';
$MESSAGE['PREFERENCES_PASSWORD_CHANGED']     = 'Contraseña cambiada correctamente';
$MESSAGE['RECORD_MODIFIED_FAILED']           = 'Error al cambiar el registro.';
$MESSAGE['RECORD_MODIFIED_SAVED']            = 'El registro modificado se ha actualizado correctamente.';
$MESSAGE['RECORD_NEW_FAILED']                = 'Error al añadir un nuevo registro.';
$MESSAGE['RECORD_NEW_SAVED']                 = 'Nuevo registro añadido correctamente.';
$MESSAGE['REORG_SUCCESS']                    = 'La reorganización se realizó correctamente';
$MESSAGE['SETTINGS_MODE_SWITCH_WARNING']     = 'Tenga en cuenta: Al presionar este botón se restablecen todos los cambios no guardados';
$MESSAGE['SETTINGS_SAVED']                   = '¡Opciones guardadas correctamente!';
$MESSAGE['SETTINGS_UNABLE_OPEN_CONFIG']      = 'No se puede abrir el archivo de configuración';
$MESSAGE['SETTINGS_UNABLE_WRITE_CONFIG']     = 'No se puede escribir en el archivo de configuración';
$MESSAGE['SETTINGS_WORLD_WRITEABLE_WARNING'] = 'Tenga en cuenta: esto solo se recomienda para entornos de prueba';
$MESSAGE['SIGNUP2_ADMIN_INFO']               = "\r\nSe ha registrado un nuevo usuario.\r\n\r\nNombre de usuario: {LOGIN_NAME}\r\n{DISPLAY_NAME}: {LOGIN_ID}\r\nCorreo electrónico: {LOGIN_EMAIL}\r\nFecha de registro: {SIGNUP_DATE}\r\n----------------------------------------\r\n¡Este mensaje se ha generado automáticamente!\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_FORGOT']       = "\r\nHola {LOGIN_DISPLAY_NAME},\r\n\r\nEste correo se ha enviado porque la función 'recuperar contraseña' se ha aplicado a su cuenta.\r\n\r\nSus nuevos datos de inicio de sesión de '{LOGIN_WEBSITE_TITLE}' son:\r\n\r\nNombre de usuario: xxxxx\r\nContraseña: {LOGIN_PASSWORD}\r\n\r\nSu contraseña ha sido restablecida a la indicada anteriormente.\r\n¡Esto significa que su antigua contraseña ya no funcionará!\r\nSi tiene alguna pregunta o problema relacionado con sus nuevos datos de inicio de sesión\r\ndebe ponerse en contacto con el equipo del sitio web o con el administrador de '{LOGIN_WEBSITE_TITLE}'.\r\nRecuerde limpiar la caché de su navegador antes de usar la nueva para evitar fallos inesperados.\r\n\r\nSaludos\r\n------------------------------------\r\n¡Este mensaje se ha generado automáticamente!\r\n\r\n";
$MESSAGE['SIGNUP2_BODY_LOGIN_INFO']          = "\r\nHola {LOGIN_DISPLAY_NAME},\r\n\r\nBienvenido a '{LOGIN_WEBSITE_TITLE}'.\r\n\r\nSus datos de inicio de sesión de '{LOGIN_WEBSITE_TITLE}' son:\r\nNombre de usuario: xxxxx\r\nContraseña: {LOGIN_PASSWORD}\r\n\r\nSaludos\r\n\r\nPor favor:\r\nsi ha recibido este mensaje por error, ¡elimínelo inmediatamente!\r\n-------------------------------------\r\n¡Este mensaje se ha generado automáticamente!\r\n";
$MESSAGE['SIGNUP2_NEW_USER']                 = 'Se ha registrado un nuevo usuario';
$MESSAGE['SIGNUP2_SUBJECT_LOGIN_INFO']       = 'Sus datos de inicio de sesión...';
$MESSAGE['SIGNUP2_SUBJECT_NEW_USER']         = 'Gracias por registrarse';
$MESSAGE['SIGNUP_NO_EMAIL']                  = 'Debe introducir una dirección de correo electrónico';
$MESSAGE['START_CURRENT_USER']               = 'Actualmente ha iniciado sesión como:';
$MESSAGE['START_INSTALL_DIR_EXISTS']         = '¡Advertencia, el directorio de instalación aún existe!';
$MESSAGE['START_UPGRADE_SCRIPT_EXISTS']      = 'Por favor, elimine el archivo {{file}} de su espacio web.';
$MESSAGE['START_WELCOME_MESSAGE']            = 'Bienvenido a la Administración de WebsiteBaker';
$MESSAGE['TEMPLATES_CHANGE_TEMPLATE_NOTICE'] = 'Tenga en cuenta: para cambiar la plantilla debe ir a la sección Configuración';
$MESSAGE['THEME_ALREADY_EXISTS']             = 'Este nuevo descriptor de tema ya existe.';
$MESSAGE['THEME_COPY_CURRENT']               = 'Copiar el tema activo actual y guardarlo con un nuevo nombre.';
$MESSAGE['THEME_DESTINATION_READONLY']       = '¡No hay derechos para crear un nuevo directorio de tema!';
$MESSAGE['THEME_IMPORT_HTT']                 = 'Importar plantillas adicionales al tema activo actual.<br />Utilice estas plantillas para sobrescribir la plantilla predeterminada correspondiente.';
$MESSAGE['THEME_INVALID_SOURCE_DESTINATION'] = '¡Se proporcionó un descriptor no válido para el nuevo tema!';
$MESSAGE['UNKNOW_UPLOAD_ERROR']              = 'Error de carga desconocido';
$MESSAGE['UPLOAD_ERR_CANT_WRITE']            = 'Error al escribir el archivo en el disco';
$MESSAGE['UPLOAD_ERR_EXTENSION']             = 'La carga del archivo fue detenida por la extensión';
$MESSAGE['UPLOAD_ERR_FORM_SIZE']             = 'El archivo cargado excede la directiva MAX_FILE_SIZE que se especificó en el formulario HTML';
$MESSAGE['UPLOAD_ERR_INI_SIZE']              = 'El archivo cargado excede la directiva upload_max_filesize en php.ini';
$MESSAGE['UPLOAD_ERR_NO_FILE']               = 'No se cargó ningún archivo';
$MESSAGE['UPLOAD_ERR_NO_TMP_DIR']            = 'Falta una carpeta temporal';
$MESSAGE['UPLOAD_ERR_OK']                    = 'Los archivos se cargaron correctamente';
$MESSAGE['UPLOAD_ERR_PARTIAL']               = 'El archivo cargado fue subido solo parcialmente';
$MESSAGE['USERS_ADDED']                      = 'Usuario añadido correctamente';
$MESSAGE['USERS_CANT_SELFDELETE']            = 'Función rechazada, ¡no se puede eliminar a sí mismo!';
$MESSAGE['USERS_CHANGING_PASSWORD']          = 'Tenga en cuenta: Solo debe introducir valores en los campos anteriores si desea cambiar la contraseña de este usuario';
$MESSAGE['USERS_CONFIRM_DELETE']             = '¿Está seguro de que desea eliminar el usuario seleccionado?';
$MESSAGE['USERS_DELETED']                    = 'Usuario eliminado correctamente';
$MESSAGE['USERS_DISPLAYNAME_TAKEN']          = 'El nombre de visualización especificado ya está en uso.';
$MESSAGE['USERS_EMAIL_TAKEN']                = 'El correo electrónico que ha introducido ya está en uso';
$MESSAGE['USERS_INVALID_EMAIL']              = 'La dirección de correo electrónico que ha introducido no es válida';
$MESSAGE['USERS_NAME_INVALID_CHARS']         = 'Caracteres no válidos para el nombre de usuario encontrados';
$MESSAGE['USERS_NO_GROUP']                   = 'No se seleccionó ningún grupo';
$MESSAGE['USERS_PASSWORD_MISMATCH']          = 'Las contraseñas que ha introducido no coinciden';
$MESSAGE['USERS_PASSWORD_TOO_SHORT']         = 'La contraseña que ha introducido era demasiado corta';
$MESSAGE['USERS_SAVED']                      = 'Usuario guardado correctamente';
$MESSAGE['USERS_USERNAME_TAKEN']             = 'El nombre de usuario que ha introducido ya está en uso';
$MESSAGE['USERS_USERNAME_TOO_SHORT']         = 'El nombre de usuario que ha introducido era demasiado corto';
$OVERVIEW['ADMINTOOLS']                     = 'Acceder a las herramientas de administración de WebsiteBaker...';
$OVERVIEW['GROUPS']                         = 'Gestionar grupos de usuarios y sus permisos del sistema...';
$OVERVIEW['HELP']                           = '¿Tiene preguntas? Encuentre su respuesta...';
$OVERVIEW['LANGUAGES']                      = 'Gestionar los idiomas de WebsiteBaker...';
$OVERVIEW['MEDIA']                          = 'Gestionar los archivos almacenados en la carpeta de medios...';
$OVERVIEW['MODULES']                        = 'Gestionar los módulos de WebsiteBaker...';
$OVERVIEW['PAGES']                          = 'Gestionar las páginas de su sitio web...';
$OVERVIEW['PREFERENCES']                    = 'Cambiar preferencias como dirección de correo electrónico, contraseña, etc... ';
$OVERVIEW['SETTINGS']                       = 'Cambia la configuración de WebsiteBaker...';
$OVERVIEW['START']                          = 'Resumen de la administración';
$OVERVIEW['TEMPLATES']                      = 'Cambiar la apariencia de su sitio web con plantillas...';
$OVERVIEW['USERS']                          = 'Gestionar los usuarios que pueden iniciar sesión en WebsiteBaker...';
$OVERVIEW['VIEW']                           = 'Ver y navegar rápidamente por su sitio web en una ventana nueva...';
$TEXT['ACCOUNT_SIGNUP']                     = 'Registro de Cuenta';
$TEXT['ACTIONS']                            = 'Acciones';
$TEXT['ACTIVE']                             = 'Activo';
$TEXT['ADD']                                = 'Añadir';
$TEXT['ADDON']                              = 'Add-on';
$TEXT['ADD_SECTION']                        = 'Añadir Sección';
$TEXT['ADMIN']                              = 'Admin';
$TEXT['ADMINISTRATION']                     = 'Administración';
$TEXT['ADMINISTRATION_TOOL']                = 'Herramienta de administración';
$TEXT['ADMINISTRATOR']                      = 'Administrador';
$TEXT['ADMINISTRATORS']                     = 'Administradores';
$TEXT['ADVANCED']                           = 'Avanzado';
$TEXT['ALLOWED_FILETYPES_ON_UPLOAD']        = 'Tipos de archivo permitidos en la carga';
$TEXT['ALLOWED_VIEWERS']                    = 'Visores permitidos';
$TEXT['ALLOW_MULTIPLE_SELECTIONS']          = 'Permitir selecciones múltiples';
$TEXT['ALL_WORDS']                          = 'Todas las palabras';
$TEXT['ANCHOR']                             = 'Ancla';
$TEXT['ANONYMOUS']                          = 'Anónimo';
$TEXT['ANY_WORDS']                          = 'Cualquier palabra';
$TEXT['APP_NAME']                           = 'Nombre de la aplicación';
$TEXT['ARE_YOU_SURE']                       = '¿Está seguro?';
$TEXT['AUTHOR']                             = 'Autor';
$TEXT['BACK']                               = 'Atrás';
$TEXT['BACKUP']                             = 'Copia de seguridad';
$TEXT['BACKUP_ALL_TABLES']                  = 'Copia de seguridad de todas las tablas en la base de datos';
$TEXT['BACKUP_DATABASE']                    = 'Copia de seguridad de la Base de Datos';
$TEXT['BACKUP_MEDIA']                       = 'Copia de seguridad de Medios';
$TEXT['BACKUP_WB_SPECIFIC']                 = 'Copia de seguridad solo de las tablas específicas de WB';
$TEXT['BASIC']                              = 'Básico';
$TEXT['BLOCK']                              = 'Bloque';
$TEXT['BROWSE_UPLOAD_FILE']                 = '¡Seleccionar un archivo!';
$TEXT['CALENDAR']                           = 'Calendario';
$TEXT['CANCEL']                             = 'Cancelar';
$TEXT['CAN_DELETE_HIMSELF']                 = 'Puede eliminarse a sí mismo';
$TEXT['CAPTCHA_VERIFICATION']               = 'Verificación CAPTCHA';
$TEXT['CAP_EDIT_CSS']                       = 'Editar CSS';
$TEXT['CHANGE']                             = 'Cambiar';
$TEXT['CHANGES']                            = 'Cambios';
$TEXT['CHANGE_SETTINGS']                    = 'Cambiar configuración';
$TEXT['CHARSET']                            = 'Juego de caracteres';
$TEXT['CHECKBOX_GROUP']                     = 'Grupo de casillas de verificación';
$TEXT['CLOSE']                              = 'Cerrar';
$TEXT['CODE']                               = 'Código';
$TEXT['CODE_SNIPPET']                       = 'Fragmento de código';
$TEXT['COLLAPSE']                           = 'Contraer';
$TEXT['COMMENT']                            = 'Comentario';
$TEXT['COMMENTING']                         = 'Comentando';
$TEXT['COMMENTS']                           = 'Comentarios';
$TEXT['CONFIRM']                            = 'Confirmar';
$TEXT['CREATE_FOLDER']                      = 'Crear Carpeta';
$TEXT['CURRENT']                            = 'Actual';
$TEXT['CURRENT_FOLDER']                     = 'Carpeta Actual';
$TEXT['CURRENT_PAGE']                       = 'Página Actual';
$TEXT['CURRENT_PASSWORD']                   = 'Contraseña actual';
$TEXT['CUSTOM']                             = 'Personalizado';
$TEXT['DATABASE']                           = 'Base de datos';
$TEXT['DATE']                               = 'Fecha';
$TEXT['DATE_FORMAT']                        = 'Formato de fecha';
$TEXT['DEFAULT']                            = 'Predeterminado';
$TEXT['DEFAULT_CHARSET']                    = 'Juego de caracteres predeterminado';
$TEXT['DEFAULT_TEXT']                       = 'Texto predeterminado';
$TEXT['DELETE']                             = 'Eliminar';
$TEXT['DELETED']                            = 'Eliminado';
$TEXT['DELETE_DATE']                        = 'Fecha de eliminación';
$TEXT['DELETE_ZIP']                         = 'Eliminar archivo zip después de descomprimir';
$TEXT['DESCRIPTION']                        = 'Descripción';
$TEXT['DESIGNED_FOR']                       = 'Diseñado para';
$TEXT['DEV_INFOS']                          = 'Información para desarrolladores';
$TEXT['DIRECTORIES']                        = 'Directorios';
$TEXT['DIRECTORY_MODE']                     = 'Modo de directorio';
$TEXT['DISABLED']                           = 'Deshabilitado';
$TEXT['DISPLAY_NAME']                       = 'Nombre de visualización';
$TEXT['EMAIL']                              = 'Correo electrónico';
$TEXT['EMAIL_ADDRESS']                      = 'Dirección de correo electrónico';
$TEXT['EMPTY_TRASH']                        = 'Vaciar papelera';
$TEXT['ENABLED']                            = 'Habilitado';
$TEXT['END']                                = 'Fin';
$TEXT['ERROR']                              = 'Error';
$TEXT['EXACT_MATCH']                        = 'Coincidencia exacta';
$TEXT['EXECUTE']                            = 'Ejecutar';
$TEXT['EXPAND']                             = 'Expandir';
$TEXT['EXTENSION']                          = 'Extensión';
$TEXT['FIELD']                              = 'Campo';
$TEXT['FILE']                               = 'Archivo';
$TEXT['FILES']                              = 'Archivos';
$TEXT['FILESYSTEM_PERMISSIONS']             = 'Permisos del sistema de archivos';
$TEXT['FILE_MODE']                          = 'Modo de archivo';
$TEXT['FINISH_PUBLISHING']                  = 'Terminar de publicar';
$TEXT['FOLDER']                             = 'Carpeta';
$TEXT['FOLDERS']                            = 'Carpetas';
$TEXT['FOOTER']                             = 'Pie de página';
$TEXT['FORGOTTEN_DETAILS']                  = '¿Ha olvidado sus datos?';
$TEXT['FORGOT_DETAILS']                     = '¿Ha olvidado los detalles?';
$TEXT['FROM']                               = 'De';
$TEXT['FRONTEND']                           = 'Front-end';
$TEXT['FULL_NAME']                          = 'Nombre Completo';
$TEXT['FUNCTION']                           = 'Función';
$TEXT['GROUP']                              = 'Grupo';
$TEXT['GUEST']                              = 'Invitado';
$TEXT['HEADER']                             = 'Cabecera';
$TEXT['HEADING']                            = 'Encabezado';
$TEXT['HEADING_CSS_FILE']                   = 'Archivo de módulo actual: ';
$TEXT['HEIGHT']                             = 'Altura';
$TEXT['HIDDEN']                             = 'Oculto';
$TEXT['HIDE']                               = 'Ocultar';
$TEXT['HIDE_ADVANCED']                      = 'Ocultar Opciones Avanzadas';
$TEXT['HOME']                               = 'Inicio';
$TEXT['HOMEPAGE_REDIRECTION']               = 'Redirección de la Página de Inicio';
$TEXT['HOME_FOLDER']                        = 'Carpeta Personal';
$TEXT['HOME_FOLDERS']                       = 'Carpetas Personales';
$TEXT['HOST']                               = 'Host';
$TEXT['ICON']                               = 'Icono';
$TEXT['IMAGE']                              = 'Imagen';
$TEXT['INLINE']                             = 'En línea';
$TEXT['INSTALL']                            = 'Instalar';
$TEXT['INSTALLATION']                       = 'Instalación';
$TEXT['INSTALLATION_PATH']                  = 'Ruta de Instalación';
$TEXT['INSTALLATION_URL']                   = 'URL de Instalación';
$TEXT['INSTALLED']                          = 'instalado';
$TEXT['INTRO']                              = 'Introducción';
$TEXT['INTRO_PAGE']                         = 'Página de Introducción';
$TEXT['INVALID_SIGNS']                      = 'debe comenzar con una letra o contiene caracteres no válidos';
$TEXT['KEYWORDS']                           = 'Palabras clave';
$TEXT['LANGUAGE']                           = 'Idioma';
$TEXT['LAST_UPDATED_BY']                    = 'Última Actualización por';
$TEXT['LENGTH']                             = 'Longitud';
$TEXT['LEVEL']                              = 'Nivel';
$TEXT['LICENSE']                            = 'Licencia';
$TEXT['LINK']                               = 'Enlace';
$TEXT['LINUX_UNIX_BASED']                   = 'Basado en Linux/Unix';
$TEXT['LIST_OPTIONS']                       = 'Opciones de Lista';
$TEXT['LOGGED_IN']                          = 'Conectado';
$TEXT['LOGIN']                              = 'Iniciar Sesión';
$TEXT['LONG']                               = 'Largo';
$TEXT['LONG_TEXT']                          = 'Texto Largo';
$TEXT['LOOP']                               = 'Bucle';
$TEXT['MAIN']                               = 'Principal';
$TEXT['USER_LOGIN_ON']                      = 'Permitir inicio de sesión de usuario';
$TEXT['USER_LOGIN_OFF']                     = 'Prevenir inicio de sesión de usuario';
$TEXT['MAINTENANCE_OFF']                    = 'Mantenimiento desactivado';
$TEXT['MAINTENANCE_ON']                     = 'Mantenimiento activado';
$TEXT['MANAGE']                             = 'Gestionar';
$TEXT['MANAGE_GROUPS']                      = 'Gestionar Grupos';
$TEXT['MANAGE_USERS']                       = 'Gestionar Usuarios';
$TEXT['MATCH']                              = 'Coincidir';
$TEXT['MATCHING']                           = 'Coincidencia';
$TEXT['MAX_EXCERPT']                        = 'Máximo de líneas de extracto';
$TEXT['MAX_SUBMISSIONS_PER_HOUR']           = 'Máx. Envíos por Hora';
$TEXT['MEDIA_DIRECTORY']                    = 'Directorio de Medios';
$TEXT['MENU']                               = 'Menú';
$TEXT['MENU_ICON_0']                        = 'Icono de menú normal';
$TEXT['MENU_ICON_1']                        = 'Icono de menú al pasar el ratón';
$TEXT['MENU_TITLE']                         = 'Título del Menú';
$TEXT['MESSAGE']                            = 'Mensaje';
$TEXT['MODIFY']                             = 'Modificar';
$TEXT['MODIFY_CONTENT']                     = 'Modificar Contenido';
$TEXT['MODIFY_SETTINGS']                    = 'Modificar Configuración';
$TEXT['MODULE_ORDER']                       = 'Orden de módulos para la búsqueda';
$TEXT['MODULE_PERMISSIONS']                 = 'Permisos de Módulo';
$TEXT['MORE']                               = 'Más';
$TEXT['MOVE_DOWN']                          = 'Mover Abajo';
$TEXT['MOVE_UP']                            = 'Mover Arriba';
$TEXT['MULTILINGUAL']                       = 'MULTILINGÜE';
$TEXT['MULTIPLE_MENUS']                     = 'Múltiples Menús';
$TEXT['MULTISELECT']                        = 'Selección Múltiple';
$TEXT['NAME']                               = 'Nombre';
$TEXT['NEED_CURRENT_PASSWORD']              = 'confirmar con la contraseña actual';
$TEXT['NEED_TO_LOGIN']                      = '¿Necesita iniciar sesión?';
$TEXT['NEW_PASSWORD']                       = 'Nueva Contraseña';
$TEXT['NEW_WINDOW']                         = 'Nueva Ventana';
$TEXT['NEXT']                               = 'Siguiente';
$TEXT['NEXT_PAGE']                          = 'Siguiente Página';
$TEXT['NO']                                 = 'No';
$TEXT['NONE']                               = 'Ninguno';
$TEXT['NONE_FOUND']                         = 'Ninguno Encontrado';
$TEXT['NOT_FOUND']                          = 'No Encontrado';
$TEXT['NOT_INSTALLED']                      = 'no instalado';
$TEXT['NO_IMAGE_SELECTED']                  = 'ninguna imagen seleccionada';
$TEXT['NO_RESULTS']                         = 'Sin Resultados';
$TEXT['NO_SELECTION']                       = 'sin selección';
$TEXT['OF']                                 = 'de';
$TEXT['ON']                                 = 'activado';
$TEXT['OPEN']                               = 'Abrir';
$TEXT['OPTION']                             = 'Opción';
$TEXT['OTHERS']                             = 'Otros';
$TEXT['OUT_OF']                             = 'Fuera de';
$TEXT['OVERWRITE_EXISTING']                 = 'Sobreescribir existentes';
$TEXT['PAGE']                               = 'Página';
$TEXT['PAGES_DIRECTORY']                    = 'Directorio de Páginas';
$TEXT['PAGES_PERMISSION']                   = 'Permiso de Páginas';
$TEXT['PAGES_PERMISSIONS']                  = 'Permisos de Páginas';
$TEXT['PAGE_EXTENSION']                     = 'Extensión de Página';
$TEXT['PAGE_ICON']                          = 'Imagen de Página';
$TEXT['PAGE_ICON_DIR']                      = 'Ruta imágenes de páginas/menú';
$TEXT['PAGE_LANGUAGES']                     = 'Idiomas de la Página';
$TEXT['PAGE_LEVEL_LIMIT']                   = 'Límite de Nivel de Página';
$TEXT['PAGE_SPACER']                        = 'Espaciador de Página';
$TEXT['PAGE_TITLE']                         = 'Título de la Página';
$TEXT['PAGE_TRASH']                         = 'Papelera de Páginas';
$TEXT['PARENT']                             = 'Padre';
$TEXT['PASSWORD']                           = 'Contraseña';
$TEXT['PATH']                               = 'Ruta';
$TEXT['PHP_ERROR_LEVEL']                    = 'Nivel de Informe de Errores PHP';
$TEXT['PLEASE_LOGIN']                       = 'Por favor, inicie sesión';
$TEXT['PLEASE_SELECT']                      = 'Por favor, seleccione';
$TEXT['POST']                               = 'Publicación';
$TEXT['POSTS_PER_PAGE']                     = 'Publicaciones por Página';
$TEXT['POST_FOOTER']                        = 'Pie de Publicación';
$TEXT['POST_HEADER']                        = 'Encabezado de Publicación';
$TEXT['PREVIOUS']                           = 'Anterior';
$TEXT['PREVIOUS_PAGE']                      = 'Página Anterior';
$TEXT['PRIVATE']                            = 'Privado';
$TEXT['PRIVATE_VIEWERS']                    = 'Visores Privados';
$TEXT['PROFILES_EDIT']                      = 'Cambiar el perfil';
$TEXT['PUBLIC']                             = 'Público';
$TEXT['PUBL_END_DATE']                      = 'Fecha de Fin';
$TEXT['PUBL_START_DATE']                    = 'Fecha de Inicio';
$TEXT['RADIO_BUTTON_GROUP']                 = 'Grupo de Botones de Opción';
$TEXT['READ']                               = 'Leer';
$TEXT['READ_MORE']                          = 'Leer Más';
$TEXT['REDIRECT_AFTER']                     = 'Redireccionar después de';
$TEXT['REGISTERED']                         = 'Registrado';
$TEXT['REGISTERED_VIEWERS']                 = 'Visores Registrados';
$TEXT['RELOAD']                             = 'Recargar';
$TEXT['REMEMBER_ME']                        = 'Recordarme';
$TEXT['RENAME']                             = 'Renombrar';
$TEXT['RENAME_FILES_ON_UPLOAD']             = 'No subir para estos tipos de archivo';
$TEXT['REQUIRED']                           = 'Requerido';
$TEXT['REQUIREMENT']                        = 'Requisito';
$TEXT['RESET']                              = 'Restablecer';
$TEXT['RESIZE']                             = 'Redimensionar';
$TEXT['RESIZE_IMAGE_TO']                    = 'Redimensionar Imagen A';
$TEXT['REFILL']                             = 'Restablecer entradas';
$TEXT['RESTORE']                            = 'Restablecer entradas';
$TEXT['RESTORE_DATABASE']                   = 'Restaurar Base de Datos';
$TEXT['RESTORE_MEDIA']                      = 'Restaurar Medios';
$TEXT['RESULTS']                            = 'Resultados';
$TEXT['RESULTS_FOOTER']                     = 'Pie de Resultados';
$TEXT['RESULTS_FOR']                        = 'Resultados Para';
$TEXT['RESULTS_HEADER']                     = 'Encabezado de Resultados';
$TEXT['RESULTS_LOOP']                       = 'Bucle de Resultados';
$TEXT['RETYPE_NEW_PASSWORD']                = 'Vuelva a escribir la Nueva Contraseña';
$TEXT['RETYPE_PASSWORD']                    = 'Vuelva a escribir la Contraseña';
$TEXT['SAME_WINDOW']                        = 'Misma Ventana';
$TEXT['SAVE']                               = 'Guardar';
$TEXT['SEARCH']                             = 'Buscar';
$TEXT['SEARCHING']                          = 'Buscando';
$TEXT['SECTION']                            = 'Sección';
$TEXT['SECTION_BLOCKS']                     = 'Bloques de Sección';
$TEXT['SEC_ANCHOR']                         = 'Texto de Anclaje de Sección';
$TEXT['SELECT_BOX']                         = 'Cuadro de Selección';
$TEXT['SEND_DETAILS']                       = 'Enviar Detalles';
$TEXT['SEPARATE']                           = 'Separar';
$TEXT['SEPERATOR']                          = 'Separador';
$TEXT['SERVER_EMAIL']                       = 'Correo Electrónico del Servidor';
$TEXT['SERVER_OPERATING_SYSTEM']            = 'Sistema Operativo del Servidor';
$TEXT['SESSION_IDENTIFIER']                 = 'Identificador de Sesión';
$TEXT['SETTINGS']                           = 'Configuración';
$TEXT['SHORT']                              = 'Corto';
$TEXT['SHORT_TEXT']                         = 'Texto Corto';
$TEXT['SHOW']                               = 'Mostrar';
$TEXT['SHOW_ADVANCED']                      = 'Mostrar Opciones Avanzadas';
$TEXT['SIGNUP']                             = 'Registrarse';
$TEXT['SIZE']                               = 'Tamaño';
$TEXT['SMART_LOGIN']                        = 'Inicio de Sesión Inteligente';
$TEXT['START']                              = 'Inicio';
$TEXT['START_PUBLISHING']                   = 'Comenzar a Publicar';
$TEXT['SUBJECT']                            = 'Asunto';
$TEXT['SUBMISSIONS']                        = 'Envíos';
$TEXT['SUBMISSIONS_STORED_IN_DATABASE']     = 'Envíos Almacenados en la Base de Datos';
$TEXT['SUBMISSION_ID']                      = 'ID de Envío';
$TEXT['SUBMITTED']                          = 'Enviado';
$TEXT['SUCCESS']                            = 'Éxito';
$TEXT['SYSTEM_DEFAULT']                     = 'Predeterminado del Sistema';
$TEXT['SYSTEM_PERMISSIONS']                 = 'Permisos del Sistema';
$TEXT['TABLE_PREFIX']                       = 'Prefijo de Tabla';
$TEXT['TARGET']                             = 'Destino';
$TEXT['TARGET_FOLDER']                      = 'Carpeta de destino';
$TEXT['TEMPLATE']                           = 'Plantilla';
$TEXT['TEMPLATE_PERMISSIONS']               = 'Permisos de Plantilla';
$TEXT['TEXT']                               = 'Texto';
$TEXT['TEXTAREA']                           = 'Área de Texto';
$TEXT['TEXTFIELD']                          = 'Campo de Texto';
$TEXT['THEME']                              = 'Tema del Backend';
$TEXT['THEME_COPY_CURRENT']                 = 'Copiar tema del backend.';
$TEXT['THEME_CURRENT']                      = 'tema activo actual';
$TEXT['THEME_IMPORT_HTT']                   = 'Importar plantillas adicionales';
$TEXT['THEME_NEW_NAME']                     = 'Nombre del nuevo Tema';
$TEXT['THEME_NOMORE_HTT']                   = 'no más disponibles';
$TEXT['THEME_SELECT_HTT']                   = 'seleccionar plantillas';
$TEXT['THEME_START_COPY']                   = 'copiar';
$TEXT['THEME_START_IMPORT']                 = 'importar';
$TEXT['TIME']                               = 'Hora';
$TEXT['TIMEZONE']                           = 'Zona Horaria';
$TEXT['TIME_FORMAT']                        = 'Formato de Hora';
$TEXT['TIME_LIMIT']                         = 'Tiempo máximo para recopilar extractos por módulo';
$TEXT['TITLE']                              = 'Título';
$TEXT['TO']                                 = 'A';
$TEXT['TOP_FRAME']                          = 'Marco Superior';
$TEXT['TRASH_EMPTIED']                      = 'Papelera Vaciada';
$TEXT['TXT_EDIT_CSS_FILE']                  = 'Edite las definiciones CSS en el área de texto a continuación.';
$TEXT['TYPE']                               = 'Tipo';
$TEXT['UNDER_CONSTRUCTION']                 = 'En Construcción';
$TEXT['UNINSTALL']                          = 'Desinstalar';
$TEXT['UNKNOWN']                            = 'Desconocido';
$TEXT['UNLIMITED']                          = 'Ilimitado';
$TEXT['UNZIP_FILE']                         = 'Subir y descomprimir un archivo zip';
$TEXT['UP']                                 = 'Arriba';
$TEXT['UPGRADE']                            = 'Actualizar';
$TEXT['UPLOAD_FILES']                       = 'Subir Archivo(s)';
$TEXT['URL']                                = 'URL';
$TEXT['USER']                               = 'Usuario';
$TEXT['USERNAME']                           = 'Nombre de Usuario';
$TEXT['USERS_ACTIVE']                       = 'Usuario activo';
$TEXT['USERS_CAN_SELFDELETE']               = 'El usuario puede eliminarse a sí mismo';
$TEXT['USERS_CHANGE_SETTINGS']              = 'El usuario puede cambiar su propia configuración';
$TEXT['USERS_DELETED']                      = 'El usuario está marcado como eliminado';
$TEXT['USERS_FLAGS']                        = 'Banderas de Usuario';
$TEXT['USERS_PROFILE_ALLOWED']              = 'El usuario puede crear un perfil extendido';
$TEXT['VERIFICATION']                       = 'Verificación';
$TEXT['VERSION']                            = 'Versión';
$TEXT['VIEW']                               = 'Ver';
$TEXT['VIEW_DELETED_PAGES']                 = 'Ver Páginas Eliminadas';
$TEXT['VIEW_DETAILS']                       = 'Ver Detalles';
$TEXT['VISIBILITY']                         = 'Visibilidad';
$TEXT['WBMAILER_DEFAULT_SENDER_MAIL']       = 'Dirección "De" predeterminada';
$TEXT['WBMAILER_DEFAULT_SENDER_NAME']       = 'Nombre del Remitente predeterminado';
$TEXT['WBMAILER_DEFAULT_SETTINGS_NOTICE']   = 'Por favor, especifique una dirección "DE" y un nombre de "REMITENTE" predeterminados a continuación. Se recomienda usar una dirección DE: como: <strong>admin@sudominio.com</strong>. Algunos proveedores de correo (por ejemplo, <em>mail.com</em>) pueden rechazar el correo con una dirección DE: como <em>nombre@mail.com</em> enviado a través de un retransmisor externo para evitar el spam.<br /><br />Los valores predeterminados solo se utilizan si WebsiteBaker no especifica otros valores. Si su servidor admite <abbr title="Protocolo simple de transferencia de correo">SMTP</abbr>, es posible que desee usar esta opción para el correo saliente.';
$TEXT['WBMAILER_FUNCTION']                  = 'Rutina de Correo';
$TEXT['WBMAILER_NOTICE']                    = '<strong>Configuración del Mailer SMTP:</strong><br />La configuración a continuación solo es necesaria si desea enviar correo a través de <abbr title="Protocolo simple de transferencia de correo">SMTP</abbr>. Si no conoce su host SMTP o no está seguro de la configuración requerida, simplemente quédese con la rutina de correo predeterminada: PHP MAIL.';
$TEXT['WBMAILER_PHP']                       = 'CORREO PHP';
$TEXT['WBMAILER_SMTP']                      = 'SMTP';
$TEXT['WBMAILER_SMTP_AUTH']                 = 'Autenticación SMTP';
$TEXT['WBMAILER_SMTP_AUTH_NOTICE']          = 'activar solo si su host SMTP requiere autenticación';
$TEXT['WBMAILER_SMTP_HOST']                 = 'Host SMTP';
$TEXT['WBMAILER_SMTP_PASSWORD']             = 'Contraseña SMTP';
$TEXT['WBMAILER_SMTP_USERNAME']             = 'Nombre de Usuario SMTP';
$TEXT['WEBSITE']                            = 'Sitio Web';
$TEXT['WEBSITE_DESCRIPTION']                = 'Descripción de Metadatos';
$TEXT['WEBSITE_FOOTER']                     = 'Pie de Página del Sitio Web';
$TEXT['WEBSITE_HEADER']                     = 'Encabezado del Sitio Web';
$TEXT['WEBSITE_KEYWORDS']                   = 'Palabras Clave de Metadatos';
$TEXT['WEBSITE_TITLE']                      = 'Título de Metadatos';
$TEXT['WELCOME_BACK']                       = 'Bienvenido de nuevo';
$TEXT['WIDTH']                              = 'Ancho';
$TEXT['WINDOW']                             = 'Ventana';
$TEXT['WINDOWS']                            = 'Windows';
$TEXT['WORLD_WRITEABLE_FILE_PERMISSIONS']   = 'Permisos de archivo de escritura global';
$TEXT['WRITE']                              = 'Escribir';
$TEXT['WYSIWYG_EDITOR']                     = 'Editor WYSIWYG';
$TEXT['WYSIWYG_STYLE']                      = 'Estilo WYSIWYG';
$TEXT['YES']                                = 'Sí';

$TEXT['NO_REVERT'] = '¡No puedes deshacer esto!';
$TEXT['NO_DELETED'] = '¡La eliminación no se ejecutó!';
$TEXT['PAGE_CODE'] = 'Código de Página';