<?php

declare(strict_types=1);

use bin\{WbAdaptor,SecureTokens,Sanitize,Requester};
use bin\helpers\{PreCheck,msgQueue};
use Intervention\Image\ImageManagerStatic as Image;

    $sAddonFile   = \str_replace('\\','/',__FILE__);
    $sFolder      = \basename(\dirname($sAddonFile));
    switch ($sFolder):
        case 'filerobot':
          $sAddonPath   = \dirname($sAddonFile,2).'/';
          break;
        default :
          $sAddonPath   = (\dirname($sAddonFile)).'/';
    endswitch;

    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = \basename($sModulesPath);
    $sAddonName   = \basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = \preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    if (! \defined('SYSTEM_RUN') && \is_readable($sAppPath.'config.php')) {
        require($sAppPath.'config.php');
    }
/* ------------------------------------------------------------------ */
    $section_name = 'Media';
    $section_permission = 'media_view';
// print with or without header
    $admin_header = false;
    $admin_auth   = ($admin_auth ?? true);
// Include WB admin wrapper script
    $admin = new \admin($section_name, $section_permission,(bool)$admin_header);

/* -------------------------------------------------------- */

// settings needs a admin object
    $oReg       = WbAdaptor::getInstance();
    $oDb        = $oReg->getDatabase();
    $oTrans     = $oReg->getTranslate();
    $oRequest   = $oReg->getRequester();
    $oApp       = $oReg->getApplication();
    $sDir       = $oRequest->getParam('dir');
    $sImageFile = $oRequest->getParam('image');
    $sBacklink  = $oReg->AcpUrl.'media/browse.php?dir='.$sDir;
    $sAcpPath   = $oReg->AcpPath;
    $sDomain    = $oApp->getDirNamespace($sAcpPath.'media');
    $oTrans->enableAddon($sDomain);

/* -------------------------------------------------------- */
    $sImageDir  = ltrim($sDir,'/').'/';
    $sImageFolderUrl = $oReg->AppUrl.$oReg->MediaDir.($sImageDir).$sImageFile;
    $sImageFolderDir = $oReg->AppPath.$oReg->MediaDir.($sImageDir).$sImageFile;
    $sImageFolderRel = $oReg->MediaDir.($sImageDir).$sImageFile;

    if (!empty($sImageFile)){
        $degrees   = (float)$fDegrees;

// create an image manager instance with favored driver
        Image::configure(['driver' => 'gd']);
        $img = Image::make($sImageFolderDir)->rotate($degrees);
        $img->save(); //$sImageFolderDir
        $img->destroy();

/*
        $sEditlink  = $oReg->AppUrl.'framework/media/filerobot/edit.php?dir='.$sDir.'&amp;image='.$sImageFile;
        header("location: ".$sEditlink);
        exit();
*/
    }